/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;

public abstract class TypedCmdLineTool<T, P>
extends CmdLineTool {
    protected final Class<T> type;

    protected TypedCmdLineTool(Class<T> sampleType) {
        this.type = sampleType;
    }

    protected ObjectStreamFactory<T, P> getStreamFactory(String format) {
        ObjectStreamFactory factory = StreamFactoryRegistry.getFactory(this.type, format);
        if (null != factory) {
            return factory;
        }
        throw new TerminateToolException(1, "Format " + format + " is not found.\n" + this.getHelp());
    }

    protected <A> void validateAllArgs(String[] args, Class<A> argProxyInterface, String format) {
        ObjectStreamFactory<T, P> factory = this.getStreamFactory(format);
        String errMessage = ArgumentParser.validateArgumentsLoudly(args, argProxyInterface, factory.getParameters());
        if (null != errMessage) {
            throw new TerminateToolException(1, errMessage + "\n" + this.getHelp(format));
        }
    }

    protected void validateFactoryArgs(ObjectStreamFactory<T, P> factory, String[] args) {
        String errMessage = ArgumentParser.validateArgumentsLoudly(args, factory.getParameters());
        if (null != errMessage) {
            throw new TerminateToolException(1, "Format parameters are invalid: " + errMessage + "\nUsage: " + ArgumentParser.createUsage(factory.getParameters()));
        }
    }

    @Override
    protected String getBasicHelp(Class<?> ... argProxyInterfaces) {
        Map factories = StreamFactoryRegistry.getFactories(this.type);
        Object formatsHelp = " ";
        if (1 < factories.size()) {
            StringBuilder formats = new StringBuilder();
            for (String format : factories.keySet()) {
                if ("opennlp".equals(format)) continue;
                formats.append(".").append(format).append("|");
            }
            formatsHelp = "[" + formats.substring(0, formats.length() - 1) + "] ";
        }
        return "Usage: opennlp " + this.getName() + (String)formatsHelp + ArgumentParser.createUsage(argProxyInterfaces);
    }

    @Override
    public String getHelp() {
        return this.getHelp("");
    }

    public abstract void run(String var1, String[] var2);

    public abstract String getHelp(String var1);
}

