/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;

class DocumentSplitterStream
extends FilterObjectStream<String, String> {
    private static final String DOC_START_ELEMENT = "<DOC>";
    private static final String DOC_END_ELEMENT = "</DOC>";
    private final List<String> docs = new ArrayList<String>();

    DocumentSplitterStream(ObjectStream<String> samples) {
        super(samples);
    }

    @Override
    public String read() throws IOException {
        String newDocs;
        if (this.docs.isEmpty() && (newDocs = (String)this.samples.read()) != null) {
            int endDocElement;
            int startDocElement;
            block4: {
                int docStartOffset = 0;
                while (true) {
                    startDocElement = newDocs.indexOf(DOC_START_ELEMENT, docStartOffset);
                    endDocElement = newDocs.indexOf(DOC_END_ELEMENT, docStartOffset);
                    if (startDocElement == -1 || endDocElement == -1) break block4;
                    if (startDocElement >= endDocElement) break;
                    this.docs.add(newDocs.substring(startDocElement, endDocElement + DOC_END_ELEMENT.length()));
                    docStartOffset = endDocElement + DOC_END_ELEMENT.length();
                }
                throw new InvalidFormatException("<DOC> element is not closed!");
            }
            if (startDocElement != endDocElement) {
                throw new InvalidFormatException("Missing <DOC> or </DOC> element!");
            }
        }
        if (!this.docs.isEmpty()) {
            return this.docs.remove(0);
        }
        return null;
    }
}

