/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.FormatUtil;
import opennlp.tools.formats.conllu.ConlluSentenceSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class ConlluSentenceSampleStreamFactory
extends AbstractSampleStreamFactory<SentenceSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "conllu", new ConlluSentenceSampleStreamFactory(Parameters.class));
    }

    protected ConlluSentenceSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        try {
            return new ConlluSentenceSampleStream(new ConlluStream(FormatUtil.createInputStreamFactory(params.getData())), Integer.parseInt(params.getSentencesPerSample()));
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO Error while creating an Input Stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="sentencesPerSample", description="number of sentences per sample")
        public String getSentencesPerSample();
    }
}

