/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.dictionary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.dictionary.DictionaryBuilderParams;
import opennlp.tools.dictionary.Dictionary;

public class DictionaryBuilderTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "Builds a new dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp((Class<?>)Params.class);
    }

    @Override
    public void run(String[] args) {
        Params params = this.validateAndParseParams(args, Params.class);
        File dictInFile = params.getInputFile();
        File dictOutFile = params.getOutputFile();
        Charset encoding = params.getEncoding();
        CmdLineUtil.checkInputFile("dictionary input file", dictInFile);
        CmdLineUtil.checkOutputFile("dictionary output file", dictOutFile);
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dictInFile), encoding));
             FileOutputStream out = new FileOutputStream(dictOutFile);){
            Dictionary dict = Dictionary.parseOneEntryPerLine((Reader)in);
            dict.serialize((OutputStream)out);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
        }
    }

    static interface Params
    extends DictionaryBuilderParams {
    }
}

