/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public final class ExponentialBackoffRetry
implements RetryPolicy {
    private final TimeDuration baseSleepTime;
    private final TimeDuration maxSleepTime;
    private final int maxAttempts;

    private ExponentialBackoffRetry(TimeDuration baseSleepTime, TimeDuration maxSleepTime, int maxAttempts) {
        this.baseSleepTime = baseSleepTime;
        this.maxSleepTime = maxSleepTime;
        this.maxAttempts = maxAttempts;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private TimeDuration getSleepTime(int attemptCount) {
        TimeDuration sleepTime = this.baseSleepTime.multiply(Math.pow(2.0, attemptCount));
        sleepTime = this.maxSleepTime != null && sleepTime.compareTo(this.maxSleepTime) > 0 ? this.maxSleepTime : sleepTime;
        return sleepTime.multiply(ThreadLocalRandom.current().nextDouble() + 0.5);
    }

    @Override
    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        TimeDuration sleepTime = this.getSleepTime(event.getAttemptCount());
        return event.getAttemptCount() < this.maxAttempts ? () -> sleepTime : NO_RETRY_ACTION;
    }

    public static final class Builder {
        private TimeDuration baseSleepTime;
        private TimeDuration maxSleepTime = null;
        private int maxAttempts = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder setBaseSleepTime(TimeDuration baseSleepTime) {
            this.baseSleepTime = baseSleepTime;
            return this;
        }

        public Builder setMaxSleepTime(TimeDuration maxSleepTime) {
            this.maxSleepTime = maxSleepTime;
            return this;
        }

        public ExponentialBackoffRetry build() {
            Objects.requireNonNull(this.baseSleepTime, "baseSleepTime == null");
            return new ExponentialBackoffRetry(this.baseSleepTime, this.maxSleepTime, this.maxAttempts);
        }
    }
}

