/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.NetworkClient;

final class InFlightRequests {
    private final int maxInFlightRequestsPerConnection;
    private final Map<String, Deque<NetworkClient.InFlightRequest>> requests = new HashMap<String, Deque<NetworkClient.InFlightRequest>>();
    private final AtomicInteger inFlightRequestCount = new AtomicInteger(0);

    public InFlightRequests(int maxInFlightRequestsPerConnection) {
        this.maxInFlightRequestsPerConnection = maxInFlightRequestsPerConnection;
    }

    public void add(NetworkClient.InFlightRequest request) {
        String destination = request.destination;
        Deque reqs = this.requests.computeIfAbsent(destination, k -> new ArrayDeque());
        reqs.addFirst(request);
        this.inFlightRequestCount.incrementAndGet();
    }

    private Deque<NetworkClient.InFlightRequest> requestQueue(String node) {
        Deque<NetworkClient.InFlightRequest> reqs = this.requests.get(node);
        if (reqs == null || reqs.isEmpty()) {
            throw new IllegalStateException("There are no in-flight requests for node " + node);
        }
        return reqs;
    }

    public NetworkClient.InFlightRequest completeNext(String node) {
        NetworkClient.InFlightRequest inFlightRequest = this.requestQueue(node).pollLast();
        this.inFlightRequestCount.decrementAndGet();
        return inFlightRequest;
    }

    public NetworkClient.InFlightRequest lastSent(String node) {
        return this.requestQueue(node).peekFirst();
    }

    public NetworkClient.InFlightRequest completeLastSent(String node) {
        NetworkClient.InFlightRequest inFlightRequest = this.requestQueue(node).pollFirst();
        this.inFlightRequestCount.decrementAndGet();
        return inFlightRequest;
    }

    public boolean canSendMore(String node) {
        Deque<NetworkClient.InFlightRequest> queue = this.requests.get(node);
        return queue == null || queue.isEmpty() || queue.peekFirst().send.completed() && queue.size() < this.maxInFlightRequestsPerConnection;
    }

    public int count(String node) {
        Deque<NetworkClient.InFlightRequest> queue = this.requests.get(node);
        return queue == null ? 0 : queue.size();
    }

    public boolean isEmpty(String node) {
        Deque<NetworkClient.InFlightRequest> queue = this.requests.get(node);
        return queue == null || queue.isEmpty();
    }

    public int count() {
        return this.inFlightRequestCount.get();
    }

    public boolean isEmpty() {
        for (Deque<NetworkClient.InFlightRequest> deque : this.requests.values()) {
            if (deque.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterable<NetworkClient.InFlightRequest> clearAll(String node) {
        Deque<NetworkClient.InFlightRequest> reqs = this.requests.get(node);
        if (reqs == null) {
            return Collections.emptyList();
        }
        Deque<NetworkClient.InFlightRequest> clearedRequests = this.requests.remove(node);
        this.inFlightRequestCount.getAndAdd(-clearedRequests.size());
        return clearedRequests::descendingIterator;
    }

    private Boolean hasExpiredRequest(long now, Deque<NetworkClient.InFlightRequest> deque) {
        for (NetworkClient.InFlightRequest request : deque) {
            if (request.timeElapsedSinceSendMs(now) - request.throttleTimeMs() <= request.requestTimeoutMs) continue;
            return true;
        }
        return false;
    }

    public List<String> nodesWithTimedOutRequests(long now) {
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (Map.Entry<String, Deque<NetworkClient.InFlightRequest>> requestEntry : this.requests.entrySet()) {
            String nodeId = requestEntry.getKey();
            Deque<NetworkClient.InFlightRequest> deque = requestEntry.getValue();
            if (!this.hasExpiredRequest(now, deque).booleanValue()) continue;
            nodeIds.add(nodeId);
        }
        return nodeIds;
    }

    void incrementThrottleTime(String nodeId, long throttleTimeMs) {
        ((Deque)this.requests.getOrDefault(nodeId, new ArrayDeque())).forEach(request -> request.incrementThrottleTime(throttleTimeMs));
    }
}

