/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ReadShareGroupStateSummaryResponse;

public class ReadShareGroupStateSummaryRequest
extends AbstractRequest {
    private final ReadShareGroupStateSummaryRequestData data;

    public ReadShareGroupStateSummaryRequest(ReadShareGroupStateSummaryRequestData data, short version) {
        super(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, version);
        this.data = data;
    }

    @Override
    public ReadShareGroupStateSummaryResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult> results = new ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult>();
        this.data.topics().forEach(topicResult -> results.add(new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new ReadShareGroupStateSummaryResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code()).setErrorMessage(Errors.forException(e).message())).collect(Collectors.toList()))));
        return new ReadShareGroupStateSummaryResponse(new ReadShareGroupStateSummaryResponseData().setResults(results));
    }

    @Override
    public ReadShareGroupStateSummaryRequestData data() {
        return this.data;
    }

    public static ReadShareGroupStateSummaryRequest parse(ByteBuffer buffer, short version) {
        return new ReadShareGroupStateSummaryRequest(new ReadShareGroupStateSummaryRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReadShareGroupStateSummaryRequest> {
        private final ReadShareGroupStateSummaryRequestData data;

        public Builder(ReadShareGroupStateSummaryRequestData data) {
            this(data, false);
        }

        public Builder(ReadShareGroupStateSummaryRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public ReadShareGroupStateSummaryRequest build(short version) {
            return new ReadShareGroupStateSummaryRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

