/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Configurable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.MetricsContext;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.ClientTelemetryUtils;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.shaded.io.opentelemetry.proto.common.v1.AnyValue;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.shaded.io.opentelemetry.proto.common.v1.KeyValue;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.shaded.io.opentelemetry.proto.resource.v1.Resource;

public class ClientTelemetryProvider
implements Configurable {
    public static final String DOMAIN = "org.apache.skywalking.apm.dependencies.org.apache.kafka";
    public static final String CLIENT_RACK = "client_rack";
    public static final String GROUP_ID = "group_id";
    public static final String GROUP_INSTANCE_ID = "group_instance_id";
    public static final String GROUP_MEMBER_ID = "group_member_id";
    public static final String TRANSACTIONAL_ID = "transactional_id";
    private static final String PRODUCER_NAMESPACE = "org.apache.skywalking.apm.dependencies.kafka.producer";
    private static final String CONSUMER_NAMESPACE = "org.apache.skywalking.apm.dependencies.kafka.consumer";
    private static final Map<String, String> PRODUCER_CONFIG_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> CONSUMER_CONFIG_MAPPING = new HashMap<String, String>();
    private volatile Resource resource = null;
    private Map<String, ?> config = null;

    @Override
    public synchronized void configure(Map<String, ?> configs) {
        this.config = configs;
    }

    boolean validate(MetricsContext metricsContext) {
        return ClientTelemetryUtils.validateRequiredResourceLabels(metricsContext.contextLabels());
    }

    synchronized void contextChange(MetricsContext metricsContext) {
        Resource.Builder resourceBuilder = Resource.newBuilder();
        String namespace = metricsContext.contextLabels().get("_namespace");
        if (PRODUCER_NAMESPACE.equals(namespace)) {
            PRODUCER_CONFIG_MAPPING.forEach((configKey, telemetryKey) -> {
                if (this.config.containsKey(configKey)) {
                    this.addAttribute(resourceBuilder, (String)telemetryKey, String.valueOf(this.config.get(configKey)));
                }
            });
        } else if (CONSUMER_NAMESPACE.equals(namespace)) {
            CONSUMER_CONFIG_MAPPING.forEach((configKey, telemetryKey) -> {
                if (this.config.containsKey(configKey)) {
                    this.addAttribute(resourceBuilder, (String)telemetryKey, String.valueOf(this.config.get(configKey)));
                }
            });
        }
        if (this.config.containsKey("client.rack")) {
            this.addAttribute(resourceBuilder, CLIENT_RACK, String.valueOf(this.config.get("client.rack")));
        }
        this.resource = resourceBuilder.build();
    }

    synchronized void updateLabels(Map<String, String> labels) {
        Resource.Builder resourceBuilder = this.resource.toBuilder();
        Map<String, String> finalLabels = this.resource.getAttributesList().stream().collect(Collectors.toMap(KeyValue::getKey, kv -> kv.getValue().getStringValue()));
        finalLabels.putAll(labels);
        resourceBuilder.clearAttributes();
        finalLabels.forEach((key, value) -> this.addAttribute(resourceBuilder, (String)key, (String)value));
        this.resource = resourceBuilder.build();
    }

    Resource resource() {
        return this.resource;
    }

    String domain() {
        return DOMAIN;
    }

    private void addAttribute(Resource.Builder resourceBuilder, String key, String value) {
        KeyValue.Builder kv = KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value));
        resourceBuilder.addAttributes(kv);
    }

    static {
        PRODUCER_CONFIG_MAPPING.put("transactional.id", TRANSACTIONAL_ID);
        CONSUMER_CONFIG_MAPPING.put("group.id", GROUP_ID);
        CONSUMER_CONFIG_MAPPING.put("group.instance.id", GROUP_INSTANCE_ID);
    }
}

