/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class AddEdgeStartStep
extends AbstractStep<Edge, Edge>
implements AddEdgeStepContract<Edge> {
    private static final String FROM = Graph.Hidden.hide("from");
    private static final String TO = Graph.Hidden.hide("to");
    private boolean first = true;
    private Parameters internalParameters = new Parameters();
    private Parameters withConfiguration = new Parameters();
    private CallbackRegistry<Event.EdgeAddedEvent> callbackRegistry;

    public AddEdgeStartStep(Traversal.Admin traversal, String edgeLabel) {
        super(traversal);
        this.internalParameters.set(this, T.label, edgeLabel);
    }

    public AddEdgeStartStep(Traversal.Admin traversal, Traversal<?, String> edgeLabelTraversal) {
        super(traversal);
        this.internalParameters.set(this, T.label, edgeLabelTraversal);
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.internalParameters.getTraversals();
    }

    @Override
    public Parameters getParameters() {
        return this.withConfiguration;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.internalParameters.getReferencedLabels();
    }

    @Override
    public void configure(Object ... keyValues) {
        this.withConfiguration.set(this, keyValues);
    }

    private void configureInternalParams(Object ... keyValues) {
        this.internalParameters.set(this, keyValues);
    }

    @Override
    public void addTo(Traversal.Admin<?, ?> toObject) {
        this.internalParameters.set(this, TO, toObject);
    }

    @Override
    public void addFrom(Traversal.Admin<?, ?> fromObject) {
        this.internalParameters.set(this, FROM, fromObject);
    }

    @Override
    public Object getElementId() {
        List ids = this.internalParameters.get(T.id, null);
        return ids.isEmpty() ? null : ids.get(0);
    }

    @Override
    public void setElementId(Object elementId) {
        this.configureInternalParams(T.id, elementId);
    }

    @Override
    protected Traverser.Admin<Edge> processNextStart() {
        if (this.first) {
            this.first = false;
            TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
            Traverser.Admin<Edge> traverser = generator.generate(1, this, 1L);
            String edgeLabel = this.internalParameters.get(traverser, T.label, () -> "edge").get(0);
            Object theTo = this.internalParameters.get(traverser, TO, () -> null).get(0);
            if (theTo != null && !(theTo instanceof Vertex)) {
                theTo = new ReferenceVertex(theTo);
            }
            if (theTo == null) {
                throw new IllegalStateException(String.format("The value given to addE(%s).to() must resolve to a Vertex or the ID of a Vertex present in the graph, but null was specified instead", edgeLabel));
            }
            Object theFrom = this.internalParameters.get(traverser, FROM, () -> null).get(0);
            if (theFrom != null && !(theFrom instanceof Vertex)) {
                theFrom = new ReferenceVertex(theFrom);
            }
            if (theFrom == null) {
                throw new IllegalStateException(String.format("The value given to addE(%s).from() must resolve to a Vertex or the ID of a Vertex present in the graph, but null was specified instead", edgeLabel));
            }
            Vertex toVertex = (Vertex)theTo;
            Vertex fromVertex = (Vertex)theFrom;
            try {
                if (toVertex instanceof Attachable) {
                    toVertex = (Vertex)((Attachable)((Object)toVertex)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.format("The value given to addE(%s).to() must resolve to a Vertex or the ID of a Vertex present in the graph. The provided value does not match any vertices in the graph", edgeLabel));
            }
            try {
                if (fromVertex instanceof Attachable) {
                    fromVertex = (Vertex)((Attachable)((Object)fromVertex)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.format("The value given to addE(%s).from() must resolve to a Vertex or the ID of a Vertex present in the graph. The provided value does not match any vertices in the graph", edgeLabel));
            }
            Edge edge = fromVertex.addEdge(edgeLabel, toVertex, this.internalParameters.getKeyValues(traverser, TO, FROM, T.label));
            EventUtil.registerEdgeCreation(this.callbackRegistry, this.getTraversal(), edge);
            return generator.generate(edge, this, 1L);
        }
        throw FastNoSuchElementException.instance();
    }

    @Override
    public CallbackRegistry<Event.EdgeAddedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.EdgeAddedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.internalParameters.hashCode() ^ this.withConfiguration.hashCode();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.internalParameters.toString());
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.internalParameters.getTraversals().forEach(this::integrateChild);
        this.withConfiguration.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public AddEdgeStartStep clone() {
        AddEdgeStartStep clone = (AddEdgeStartStep)super.clone();
        clone.internalParameters = this.internalParameters.clone();
        clone.withConfiguration = this.withConfiguration.clone();
        return clone;
    }

    @Override
    public Object getLabel() {
        String label = this.internalParameters.get(T.label, () -> "edge").get(0);
        if (label instanceof ConstantTraversal) {
            return ((ConstantTraversal)((Object)label)).next();
        }
        return label;
    }

    @Override
    public void setLabel(Object label) {
        this.configure(T.label, label);
    }

    @Override
    public Object getFrom() {
        return this.getAdjacentVertex(this.internalParameters, FROM);
    }

    @Override
    public Object getTo() {
        return this.getAdjacentVertex(this.internalParameters, TO);
    }

    @Override
    public Map<Object, List<Object>> getProperties() {
        return Collections.unmodifiableMap(this.internalParameters.getRaw(T.id, T.label, TO, FROM));
    }

    @Override
    public boolean removeProperty(Object k) {
        if (this.internalParameters.contains(k)) {
            this.internalParameters.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeElementId() {
        if (this.internalParameters.contains(T.id)) {
            this.internalParameters.remove(T.id);
            return true;
        }
        return false;
    }

    @Override
    public void addProperty(Object key, Object value) {
        this.configureInternalParams(key, value);
    }
}

