/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.translator.GroovyTranslator;

public class AnonymizingTypeTranslator
extends GroovyTranslator.DefaultTypeTranslator {
    private final Anonymizer anonymizer;

    public AnonymizingTypeTranslator() {
        this(new DefaultAnonymizer(), false);
    }

    public AnonymizingTypeTranslator(boolean withParameters) {
        this(new DefaultAnonymizer(), withParameters);
    }

    public AnonymizingTypeTranslator(Anonymizer anonymizer, boolean withParameters) {
        super(withParameters);
        this.anonymizer = anonymizer;
    }

    @Override
    protected String getSyntax(String o) {
        return this.anonymizer.anonymize(o).toString();
    }

    @Override
    protected String getSyntax(Date o) {
        return this.anonymizer.anonymize(o).toString();
    }

    @Override
    protected String getSyntax(OffsetDateTime o) {
        return this.anonymizer.anonymize(o).toString();
    }

    @Override
    protected String getSyntax(Timestamp o) {
        return this.anonymizer.anonymize(o).toString();
    }

    @Override
    protected String getSyntax(UUID o) {
        return this.anonymizer.anonymize(o).toString();
    }

    @Override
    protected String getSyntax(Number o) {
        return this.anonymizer.anonymize(o).toString();
    }

    @Override
    protected Script produceScript(Class<?> o) {
        return this.script.append(this.anonymizer.anonymize(o).toString());
    }

    public static class DefaultAnonymizer
    implements Anonymizer {
        private final Map<String, Map<Object, String>> simpleNameToObjectCache = new HashMap<String, Map<Object, String>>();

        @Override
        public Object anonymize(Object obj) {
            String type = obj.getClass().getSimpleName();
            Map<Object, String> objectToAnonymizedString = this.simpleNameToObjectCache.get(type);
            if (objectToAnonymizedString != null) {
                String innerValue = objectToAnonymizedString.get(obj);
                if (innerValue != null) {
                    return innerValue;
                }
                String anonymizedValue = type.toLowerCase() + objectToAnonymizedString.size();
                objectToAnonymizedString.put(obj, anonymizedValue);
                return anonymizedValue;
            }
            objectToAnonymizedString = new HashMap<Object, String>();
            this.simpleNameToObjectCache.put(type, objectToAnonymizedString);
            String anonymizedValue = type.toLowerCase() + objectToAnonymizedString.size();
            objectToAnonymizedString.put(obj, anonymizedValue);
            return anonymizedValue;
        }
    }

    public static interface Anonymizer {
        public Object anonymize(Object var1);
    }
}

