/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import java.lang.reflect.Method;
import java.util.Objects;

public class InterceptionPoint {
    private final String name;
    private final Class<?> beanClass;
    private final Method method;

    public InterceptionPoint(Class<?> beanClass, Method method) {
        this.name = beanClass.getName() + "#" + method.getName();
        this.beanClass = beanClass;
        this.method = method;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public Method method() {
        return this.method;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptionPoint that = (InterceptionPoint)o;
        return this.beanClass.equals(that.beanClass) && this.method.equals(that.method);
    }

    public int hashCode() {
        return Objects.hash(this.beanClass, this.method);
    }
}

