/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import org.apache.openejb.bval.ValidatorUtil;

public class LazyValidator
implements InvocationHandler,
Serializable {
    private transient ValidatorFactory factory;
    private volatile transient Validator validator;

    public LazyValidator(ValidatorFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.ensureDelegate();
        try {
            return method.invoke((Object)this.validator, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDelegate() {
        if (this.validator == null) {
            LazyValidator lazyValidator = this;
            synchronized (lazyValidator) {
                if (this.validator == null && this.validator == null) {
                    this.validator = (this.factory == null ? this.findFactory() : this.factory).usingContext().getValidator();
                }
            }
        }
    }

    private ValidatorFactory findFactory() {
        try {
            return ValidatorUtil.lookupFactory();
        }
        catch (NamingException ne) {
            return Validation.buildDefaultValidatorFactory();
        }
    }

    public Validator getValidator() {
        this.ensureDelegate();
        return this.validator;
    }
}

