/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import java.io.ByteArrayOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TransactionRolledbackException
extends jakarta.transaction.TransactionRolledbackException {
    private Throwable cause = this;

    public TransactionRolledbackException() {
        this.fillInStackTrace();
    }

    public TransactionRolledbackException(String detailMessage) {
        super(detailMessage);
    }

    public TransactionRolledbackException(String detailMessage, Throwable throwable) {
        super(detailMessage);
        this.cause = throwable;
    }

    public TransactionRolledbackException(Throwable throwable) {
        super(throwable == null ? null : throwable.toString());
        this.cause = throwable;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        StackTraceElement parentFrame;
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0 && (parentFrame = parentStack[parentIndex]).equals(currentStack[i])) {
            ++duplicates;
        }
        return duplicates;
    }

    public void printStackTrace(PrintStream err) {
        StackTraceElement[] stack;
        err.println(this.toString());
        for (StackTraceElement stackTraceElement : stack = this.getStackTrace()) {
            err.println("\tat " + String.valueOf(stackTraceElement));
        }
        StackTraceElement[] parentStack = stack;
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            err.print("Caused by: ");
            err.println(throwable);
            StackTraceElement[] currentStack = throwable.getStackTrace();
            int duplicates = TransactionRolledbackException.countDuplicates(currentStack, parentStack);
            for (int i = 0; i < currentStack.length - duplicates; ++i) {
                err.println("\tat " + String.valueOf(currentStack[i]));
            }
            if (duplicates > 0) {
                err.println("\t... " + duplicates + " more");
            }
            parentStack = currentStack;
        }
    }

    public void printStackTrace(PrintWriter err) {
        StackTraceElement[] stack;
        err.println(this.toString());
        for (StackTraceElement stackTraceElement : stack = this.getStackTrace()) {
            err.println("\tat " + String.valueOf(stackTraceElement));
        }
        StackTraceElement[] parentStack = stack;
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            err.print("Caused by: ");
            err.println(throwable);
            StackTraceElement[] currentStack = throwable.getStackTrace();
            int duplicates = TransactionRolledbackException.countDuplicates(currentStack, parentStack);
            for (int i = 0; i < currentStack.length - duplicates; ++i) {
                err.println("\tat " + String.valueOf(currentStack[i]));
            }
            if (duplicates > 0) {
                err.println("\t... " + duplicates + " more");
            }
            parentStack = currentStack;
        }
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        String name = ((Object)((Object)this)).getClass().getName();
        if (msg == null) {
            return name;
        }
        return name + ": " + msg;
    }

    public synchronized TransactionRolledbackException initCause(Throwable throwable) {
        this.cause = throwable;
        return this;
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    protected Object writeReplace() throws ObjectStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(baos));
        return new jakarta.transaction.TransactionRolledbackException(this.getMessage() + "\n\t" + new String(baos.toByteArray()));
    }
}

