/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1999
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *       Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: rnd-pool.h,v 1.1 1999/10/18 22:24:33 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __RND_POOL_H__
#define __RND_POOL_H__

#define RND_POOL_SIZE  (5*1024)

extern unsigned random_pool_density_percentage (void) ;

extern unsigned put_random_pool_data (const char *buf, unsigned len);
extern void     point_of_random_time (const char *buf, unsigned len);
extern unsigned get_random_pool_data       (char *buf, unsigned len);


#define POINT_OF_RANDOM( buf, len) \
		{ point_of_random_time (buf,len); }

#define POINT_OF_RANDOM_VAR( var) \
		{ POINT_OF_RANDOM ((char*)&(var), sizeof (var)); }

#define POINT_OF_RANDOM_COND( cond, buf, len) \
		{ if (cond) POINT_OF_RANDOM (buf,len); }

#define POINT_OF_RANDOM_VAR_COND( cond, var) \
		{ if (cond) POINT_OF_RANDOM_VAR (var); }

#define POINT_OF_RANDOM_STACK(size) \
		{ char __ ## size [size]; POINT_OF_RANDOM (__ ## size, size); }

#define POINT_OF_RANDOM_STACK_COND(size) \
		{ if (cond) POINT_OF_RANDOM_STACK (size); }


#ifdef USE_PTHREADS
/* support for posix threads */
extern void rnd_pool_sema_create (void *attr);
extern void rnd_pool_sema_destroy (void);
#endif

#endif /* __RND_POOL_H__ */


