/*
 * Default accounts check
 * $Id: accounts.c,v 1.6 1999/11/07 21:04:17 renaud Exp $
 *
 * By Renaud Deraison <deraison@cvs.nessus.org>
 *
 * TODO :
 *	- other protocols (POP3, ...)
 *
 */


#include <includes.h>
#include "structs.h"
#include "read_accounts.h"
#include "accounts.h"
#include "network.h"


#define EN_NAME "Default accounts"
#define FR_NAME "Comptes par dfaut"


#define EN_DESC "\
This plugin checks several the login/password\n\
combinations, and reports whether the attempts\n\
were successful or not"

#define FR_DESC "\
Ce plugin test diffrentes combinaisons de nom\n\
d'utilsateur/mot de passe et indique si les essais\n\
on fonctionns ou pas"


#define COPY "This plugin was written by Renaud Deraison"

#define EN_SUMM "Telnet to the remote host and try login/passwords"
#define FR_SUMM "Fait un telnet sur l'hote distant et essaye des login/passwd"

#define FR_FAMILY "Divers"
#define EN_FAMILY "Misc."


#define FILE_LOCATION "Accounts location : "
#define FILE_DFL_LOC DIR_PREFIX"/share/nessus/accounts.txt"

#define NUM_CONNECTIONS "Simultaneous connections : "
#define DFL_CONNECTIONS "10"


/*
 * Plugin initialization function
 */
int plugin_init(desc)
 struct arglist * desc;
{
 plug_set_name(desc, FR_NAME, "francais");
 plug_set_name(desc, EN_NAME, NULL);
 
 
 plug_set_description(desc, FR_DESC, "francais");
 plug_set_description(desc, EN_DESC, NULL);
 
 plug_set_summary(desc, FR_SUMM, "francais");
 plug_set_summary(desc, EN_SUMM, NULL);
 
 plug_set_copyright(desc, COPY, NULL);
 
 plug_set_family(desc, FR_FAMILY, "francais");
 plug_set_family(desc, EN_FAMILY, NULL);
 
 
 plug_set_category(desc, ACT_GATHER_INFO);
 
 /*
  * Preferences
  */
  add_plugin_preference(desc, FILE_LOCATION, PREF_ENTRY, FILE_DFL_LOC);
  add_plugin_preference(desc, NUM_CONNECTIONS, PREF_ENTRY, DFL_CONNECTIONS);

  plug_require_port(desc, "Services/telnet");
  plug_require_port(desc, "23");
}


int
plugin_run(data)
 struct arglist * data;
{
 int port = (int)plug_get_key(data, "Services/telnet");
 int s;
 
 if(port)port = atoi((char*)port);
 else port = 23;
 if(!host_get_port_state(data, port))return(0);
 s = open_sock_tcp(data, port);
 if(s<0)return(0);
 else 
 {
 char * filename = get_plugin_preference(data, FILE_LOCATION);
 char * asc_num  = get_plugin_preference(data, NUM_CONNECTIONS);
 int num = atoi(asc_num);
 int * sockets;
 int num_accs;
 struct accounts ** accounts = read_accounts(filename, &num_accs);
 char ** ret;
 int i;
 
 
 shutdown(s, 2);
 close(s);
 qsort(accounts, num_accs, sizeof(struct accounts*),accs_compar);
 while(1)
 {
  int limit;
  
  for(limit=0;!(accounts[limit]->tested) && (limit < num);limit++);
  if(!limit)break;
  
  
 sockets = init_telnet_connections(data, port, limit, 1);
 ret = read_all(sockets);
 for(i=0;i<limit;i++){
 	if(!strstr(ret[i], "ogin:"))
	{
	 shutdown(sockets[i], 2);
	 close(sockets[i]);
	 sockets[i]=-1;
	}
	free(ret[i]);
     }
 free(ret);
 
 for(i=0;i<limit;i++)
 {
  int flag = 0;
  if(sockets[i]!=-1)
  {
   char * data = emalloc(strlen(accounts[i]->login+3));
   flag++;
   sprintf(data, "%s\r\n", accounts[i]->login);
   send(sockets[i], data, strlen(data), 0);
   free(data);
  }
  /* no socket open. Is that a _real_ telnet ? */
  if(!flag)return;
 }
 

 
 ret = read_all(sockets);
 
 
 for(i=0;i<limit;i++)
 {
  if(!(ret[i] && strstr(ret[i], "word:")))
  {
   if(ret[i])
    if(((!strstr(ret[i], "denied"))&&
      (!strstr(ret[i], "incorrect"))&&
      (!strstr(ret[i], "ogin:")))||strstr(ret[i], "last login"))
      {
       accounts[i]->working = 1;
      }
   shutdown(sockets[i], 2);
   close(sockets[i]);
   sockets[i]=-1;
  }
  free(ret[i]);
 }
 free(ret);
 
 for(i=0;i<limit;i++)
 {
  if(sockets[i]!=-1)
  {
   char * data = emalloc(strlen(accounts[i]->pass+3));
   sprintf(data, "%s\r\n", accounts[i]->pass);
   accounts[i]->tested = 1;
   send(sockets[i], data, strlen(data), 0);
   free(data);
  }
 }
 
 ret = read_all(sockets);
 for(i=0;i<limit;i++)
 {
  if(ret[i])
  {
   int j,k = strlen(ret[i]);
   for(j=0;j<k;j++)ret[i][j]=tolower(ret[i][j]);
   if((strlen(ret[i])>5)&&((!strstr(ret[i], "denied"))&&
      (!strstr(ret[i], "incorrect"))&&
      (!strstr(ret[i], "bad "))&&
      (!strstr(ret[i], "ogin:")))||strstr(ret[i], "last login"))
      {
       accounts[i]->working = 1;
      }
  free(ret[i]);
  }
 }
 free(ret);
 
 for(i=0;i<limit;i++)
 {
  shutdown(sockets[i], 2);
  close(sockets[i]);
 }
 free(sockets);


 qsort(accounts, num_accs, sizeof(struct accounts*),accs_compar);
 if(accounts[0]->tested)break;
 }

for(i=0;i<num_accs;i++)
{
 if(accounts[i]->working)
 {
  char * report;
  report = emalloc(1024);
  sprintf(report, "The account %s/%s seems to be valid. Change or disable it\n",
  			accounts[i]->login, accounts[i]->pass);
  post_hole(data, port, report);
  free(report);
 }
}
}
}
 

 
 
 
