/* we need some of the portability definitions... for strchr */
#include "httpd.h"

/* A bunch of functions in util.c scan strings looking for certain characters.
 * To make that more efficient we encode a lookup table.
 */
#define T_ESCAPE_SHELL_CMD	(0x01)
#define T_ESCAPE_PATH_SEGMENT	(0x02)
#define T_OS_ESCAPE_PATH	(0x04)
#define T_HTTP_TOKEN_STOP	(0x08)

int main(int argc, char *argv[])
{
    unsigned c;
    unsigned char flags;

    printf(
"/* this file is automatically generated by gen_test_char, do not edit */\n"
"#define T_ESCAPE_SHELL_CMD	(%u)\n"
"#define T_ESCAPE_PATH_SEGMENT	(%u)\n"
"#define T_OS_ESCAPE_PATH	(%u)\n"
"#define T_HTTP_TOKEN_STOP	(%u)\n"
"\n"
"static const unsigned char test_char_table[256] = {\n"
"    0,",
	T_ESCAPE_SHELL_CMD,
	T_ESCAPE_PATH_SEGMENT,
	T_OS_ESCAPE_PATH,
	T_HTTP_TOKEN_STOP);

    /* we explicitly dealt with NUL above
     * in case some strchr() do bogosity with it */

    for (c = 1; c < 256; ++c) {
	flags = 0;
	if (c % 20 == 0)
	    printf("\n    ");

	/* escape_shell_cmd */
	if (strchr("&;`'\"|*?~<>^()[]{}$\\\n", c)) {
	    flags |= T_ESCAPE_SHELL_CMD;
	}

	if (!ap_isalnum(c) && !strchr("$-_.+!*'(),:@&=~", c)) {
	    flags |= T_ESCAPE_PATH_SEGMENT;
	}

	if (!ap_isalnum(c) && !strchr("$-_.+!*'(),:@&=/~", c)) {
	    flags |= T_OS_ESCAPE_PATH;
	}

	/* these are the "tspecials" from RFC2068 */
	if (ap_iscntrl(c) || strchr(" \t()<>@,;:\\/[]?={}", c)) {
	    flags |= T_HTTP_TOKEN_STOP;
	}
	printf("%u%c", flags, (c < 255) ? ',' : ' ');

    }
    printf("\n};\n");

    return 0;
}
