#include <string>
#include <iostream>
#include <vector>
#include <unistd.h>
#include "ace/Synch.h"

class DBHostConfig;
class DBBalancerConfig;
class DBPooledConnection;

class DBPool {

public:

  // R-O
  DBPool(DBBalancerConfig* config, DBHostConfig *host, string id);
  // R-W
  DBPool(DBBalancerConfig* config, vector<DBHostConfig *> hosts, string id);
  ~DBPool();
  DBPooledConnection *getPooledConnection(int strategy);
  DBPooledConnection *getConnectionForTest();
  int shrink(int shrinkConns);
  int grow(int growConns);

private:

  unsigned int _npool;
  ACE_Thread_Mutex _used_conn_mutex;
  ACE_Thread_Mutex _tested_conn_mutex;
  unsigned int _used_conn_index;
  unsigned int _tested_conn_index;

  string _id;

  DBBalancerConfig * _config;
  DBHostConfig * _host;
  unsigned int _nConns;
  vector<DBPooledConnection *> _connections;
  
};

