/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * CgiForm.h
 *   Class for outputting appropriate forms.
 *
 * $Id: CgiForm.h,v 1.7 2000/12/29 05:35:05 rex Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *                and Benoit Joly <benoit@dhis.net>
 *
 * Licensed under the GPLv2
 */

#ifndef CGIFORM_H
#define CGIFORM_H

extern "C" {
#include <cgi.h>
}

#include <openssl/md5.h>
#include <arpa/inet.h> // for string to ip conversion

#include <macrosystem.hh>
using namespace macrosystem;

#include "Exception.h"
#include "Logger.h"
#include "DdtManager.h"
#include "Options.h"


class CgiForm
{
  public:

    // default constructor
    CgiForm (char *templatePath, char *foot);

    // destructor
    ~CgiForm ();

    // print file to stdout ... for header and footer
    void display (char *file);
    void display (char *file, MacroSystem &macro);

    void quit (int status = 0, char *msg = "");
        
    // print registration form
    void printRegForm (char *domain);
    void printRegisteredInfoPage (int accountId, char *uPassword, char *aPassword);

    // print authentication form
    void printAuthForm ();

    // print the userAccounts info update form
    void printAcctForm (char *md5hash, userAccount *acct);

    // print the form to add/remove dns records
    void printDnsForm (char *md5hash, int hostId);
    
    void printDeleteForm (char *md5hash, int hostId);

  private:
    string genDropDown(char *inputName, char *values[], char *selectedValue);

  public:
    s_cgi *cgi;
    static char *arch[];
    static char *OS[];

  private:
    Logger *log;
    DdtManager *ddtdb;

    char *foot;
    char *templatePath;
};

#endif // CGIFORM_H
