/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * ddtcd.h
 *   header file for client daemon.
 *
 * $Id: ddtcd.h,v 1.29 2001/11/24 21:11:50 benoit Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "global.h"

#define PID_FILE  PID_DIR  "/ddt/ddtcd.pid"
#define LOG_FILE  LOG_DIR  "/ddtcd.log"
#define CONF_FILE CONF_DIR "/ddtcd.conf"
#define INFIFO    VAR_DIR  "/ddt-client/fifo.in"
#define OUTFIFO   VAR_DIR  "/ddt-client/fifo.out"

#define TIMEOUT (5*60)
#define MAX_RETRIES 10
#define MAX_PATH 256

#include <iostream>
#include <fstream>

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <net/if.h>

#include <pwd.h> // for dropping priviledges
#include <grp.h> //    idem 
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h> // for NetBSD
#include <time.h>
#include <opt.h> // opt parser lib

#include "Exception.h"
#include "Logger.h"
#include "Options.h"
#include "UDP.h"
#include "Packet.h"

#ifndef DDTCD_H
#define DDTCD_H

class Client
{
  public:
    Client();
    ~Client();

    int alreadyRunning();
    int parseArgs(int *argc, char ***argv);
    int becomeDaemon();
    int receiver();

    int readSocket();
    int readFifo();

  private:
    void processUserRequest();
    int processReceivedPacket(DdtpPacket *pkt);

    static void atexit_handler();
    static void signal_handler(int signum);

    unsigned long getIfaceAddr(char *iface);

    static Options *opts;
    static Logger *log;
    static UDP *udp;
    static DdtpPacket *pkt;

    char msgbuf[256];
    int infifofd;
    int outfifofd;

    // IP address that matched interface last time we checked
    unsigned long lastIP;
    unsigned long forceIP;
    
    time_t serverStamp;  // last time we heard from server
    int retryCount;      // how many times did we try without reply ?
    time_t retryStamp; 
    int retryIn;         // in how long do we reconsider our status ? 
    int currentStatus;   // our status
    int changeStatus;    // what we want
    char *md5_password;  // our md5 hashed password
};

#endif // DDTCD_H
