C
C THIS ROUTINE RETRIEVES A PARTIAL LIST FROM DISK. THIS
C ROUTINE READS ONLY A TRUNCATED DISTRIBUTION.
C 
C  INPUT:
C         ISTART - FIRST DISTRIBUTION TO READ
C         IEND   - LAST DISTRIBUTION TO READ
C         NUMDIS - IEND+1-ISTART
C         ICACHE - I/O CACHE TO BE USED.
C         ISPIN - SPIN OR IRREP SPECIFIER FOR LIST.
C         ITYPE - LIST NUMBER.
C
C  SCRATCH:
C            BUF - INTERMEDIATE ARRAY HOLDING DISTRIBUTIONS (SIZE: NDSSIZ)
C
C  OUTPUT:
C              Z - THE TRANSPOSED LIST, TREATED AS A MATRIX WITH
C                   DIMENSIONS (NUMDIS,NDSSIZ).
C     
      SUBROUTINE GETLST3(Z,BUF,ISTART,IEND,
     &                   NDSSIZ,IFIRST,NUMDIS,
     &                   ICACHE,ISPIN,ITYPE)
      IMPLICIT INTEGER (A-Z)
      DOUBLE PRECISION Z(NDSSIZ,NDSSIZ),BUF(1)
      CALL ZERO(Z,NUMDIS*NDSSIZ)
      DO 10 I=1,NUMDIS
       CALL GETLST(BUF,I,1,ICACHE,ISPIN,ITYPE)
       CALL SCOPY(NDSSIZ,BUF(ISTART),1,Z(1,I),1)
10    CONTINUE
      RETURN
      END
