/*
 * Copyright 2018 ConsenSys AG.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package net.consensys.cava.rlpx.wire;

import static org.junit.jupiter.api.Assertions.assertEquals;

import net.consensys.cava.bytes.Bytes;

import java.util.Collections;

import org.junit.jupiter.api.Test;

class HelloMessageTest {

  @Test
  void p2pVersion() {
    HelloMessage msg = HelloMessage.create(Bytes.fromHexString("deadbeef"), 10000, 3, "blah", Collections.emptyList());
    HelloMessage msgRead = HelloMessage.read(msg.toBytes());
    assertEquals(3, msgRead.p2pVersion());
  }

  @Test
  void nodeId() {
    HelloMessage msg = HelloMessage.create(Bytes.fromHexString("deadbeef"), 10000, 3, "blah", Collections.emptyList());
    HelloMessage msgRead = HelloMessage.read(msg.toBytes());
    assertEquals(Bytes.fromHexString("deadbeef"), msgRead.nodeId());
  }

  @Test
  void clientId() {
    HelloMessage msg =
        HelloMessage.create(Bytes.fromHexString("deadbeef"), 10000, 3, "foofoo", Collections.emptyList());
    HelloMessage msgRead = HelloMessage.read(msg.toBytes());
    assertEquals("foofoo", msgRead.clientId());
  }
}
