// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Created by postproc-cld2 4.0 on 2013-05-27 15:44:09
// From command line:
//  --cld2 --cc --just_read_raw --distinct_octa --standard --minchars=2
//  --mincount=1 --max_items_per_langscript=2000 --flatmap --rr_alloc
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=240
//  --v25 --kentries=16 --tablename=DistinctOcta0527 --suppress=bs-Latn
//  bs-Cyrl sr-ME-Latn    az-Arab az-Cyrl kk-Latn ku-Latn my-Latn ru-Latn
//  tg-Arab tk-Arab ug-Latn za-Hani zzb-Latn zze-Latn zzh-Latn
//  --remap=xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl
//  sr-ME-Cyrl=>sr-Cyrl  --ko_english --force_to_lang_soft --nosoft_cram2
//  --nomsidlevel --shapeflatprob --langpriorpercent=10 --skipnuc
//  --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15
//  --nodoubleclose --langcounts --writebin --list_items=120
//  /tmp/xocta_octa2.utf8
//
// CLD2_pslangs
//
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDistinctOcta0527BuildDate = 20130527;    // yyyymmdd


// Of 19859 offered items into 16384 table entries:
// 14354 filled (72%), 39 merged (0%), 5466 dropped (27%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 22 languages in range DANISH..RUNDI:
//     DANISH NORWEGIAN PORTUGUESE SPANISH CZECH CROATIAN SERBIAN
//     GALICIAN HINDI INDONESIAN MALAY NEPALI BIHARI MARATHI SLOVAK
//     NORWEGIAN_N XHOSA ZULU TIBETAN DZONGKHA KINYARWANDA RUNDI

//  DANISH 475
//  NORWEGIAN 661
//  PORTUGUESE 981
//  SPANISH 1076
//  CZECH 792
//  CROATIAN 348
//  SERBIAN 1642
//  GALICIAN 732
//  HINDI 1088
//  INDONESIAN 349
//  MALAY 545
//  NEPALI 38
//  BIHARI 499
//  MARATHI 23
//  SLOVAK 803
//  NORWEGIAN_N 255
//  XHOSA 699
//  ZULU 923
//  TIBETAN 806
//  DZONGKHA 910
//  KINYARWANDA 627
//  RUNDI 121



// Recognized language-script combinations [23]:
static const char* const kDistinctOcta0527RecognizedLangScripts =
  "bh-Deva bo-Tibt cs-Latn da-Latn dz-Tibt es-Latn gl-Latn hi-Deva "
  "hr-Latn id-Latn mr-Deva ms-Latn ne-Deva nn-Latn no-Latn pt-Latn "
  "rn-Latn rw-Latn sk-Latn sr-Cyrl sr-Latn xh-Latn zu-Latn ";

static const uint32 kDistinctOcta0527Size = 4096;    // Bucket count
static const uint32 kDistinctOcta0527KeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kDistinctOcta0527[kDistinctOcta0527Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x4b8dd002,0xe2ddc003,0x0305d004,0xebb62005}},	// [000] _जय_, _kuthetha__ukuba_, _na__verdade_, _имао_,
   {{0xd47c1006,0x34427007,0x04432008,0x826d9009}},	//   _saat__itu_, _jen_, _ivy_, _terbuat__dari_,
   {{0x4722700a,0x7658c00b,0x9e1ac006,0xcab0000c}},	//   _बाड़े_, _དོ__ཡོདཔ_, _kecelaka, _लिए__कोई_,
   {{0x5442700d,0x62a6e00b,0x32e71005,0x0c0ac00c}},	//   _len_, _གས__དགོ_, _odeljenj, _किसी__को_,
   {{0x7be1a00e,0x3275a005,0x6494a00f,0xc311a00f}},	//   _འདི__ནི_, _имало__становни, _ku__isi_, _buri__wese_,
   {{0x18468005,0x3354d010,0xebc9300c,0xaa7c2007}},	//   _dodatim__stepenom_, _quienes_, _बॉलीवुड_, _jihočesk,
   {{0x82122011,0x1a46b011,0x13954012,0x7b499005}},	//   _lokhu_, _leli__phephand, _pjesma_, _је__село_,
   {{0x8e5d600b,0x6b39f010,0x00000000,0x00000000}},	//   _གནས__བསྐྱོད_, _de__tratamie, --, --,
   {{0x7296f013,0xc4972014,0x23874010,0xf4426010}},	//   _je__prema_, _ou__non_, _cierto_, _veo_,
   {{0x03061015,0xc4427016,0x626de007,0xb9e45017}},	//   _terletak__dalam_, _cen_, _tyto_, _facultad,
   {{0x73eb900d,0x7beb7018,0x79f4e014,0x2be6300c}},	//   _mesta_, _གང__ཡང_, _senón_, _और__जब_,
   {{0x28ac3019,0xef03a00d,0x7272800d,0x00000000}},	//   _as__empresas_, _voľný_, _povedať_, --,
   {{0x326f9005,0xac605005,0x8a3c901a,0xd2b72005}},	//   _је__становни, _avgusta_, _लॉग_, _другим_,
   {{0x0290701b,0xebe1c00c,0x5470e007,0x8c0db00c}},	//   _funa_, _आप__इस_, _kdy__se_, _बनाने__का_,
   {{0x6e05901c,0xb29f701d,0x82d45004,0xf1c92005}},	//   _kendaraa, _posjeta_, _áudio_, _доста_,
   {{0xd24df00e,0xfa3e700a,0x0242100c,0x0c537014}},	//   _ཤིག_, _बनल_, _मामले_, _xustiza_,
   {{0x8291e016,0x7657c00b,0xebdf300b,0x7be1c00c}},	// [010] _dotaz_, _ཏེ__ཡོདཔ_, _གསུངས__ཡི_, _आप__उन_,
   {{0x64906014,0xe2bf100b,0x6219e007,0x2c290004}},	//   _ao__de_, _དབང__མངའ_, _podnikán, _das__pessoas_,
   {{0x1e73c01e,0x0f17200e,0x00000000,0x00000000}},	//   _सिर्फ_, _མདོར__བསྡུས_, --, --,
   {{0xab62901f,0x6c6c6004,0xfbd33018,0x00000000}},	//   _igitsina_, _alguém_, _ལེགས__པར_, --,
   {{0x12248007,0x62c7000f,0x00000000,0x00000000}},	//   _velké_, _niba__ushaka_, --, --,
   {{0x6df76020,0x12fee015,0xa7125004,0xb3e57007}},	//   _མི__རིགས_, _tanah__melayu_, _construç, _dětí_,
   {{0x2e44201d,0x43412011,0xb2495011,0xba96400c}},	//   _katapult_, _emoses__mabhida_, _iqembu_, _से__बना_,
   {{0xc4906021,0xa9f56022,0xcdd8300b,0x5c09c023}},	//   _av__dem_, _según_, _གིས__གཞིས_, _sempena_,
   {{0x84712021,0xe46e7021,0xe808c003,0x39e46019}},	//   _mye__mer_, _seg__til_, _isicwang, _faculdad,
   {{0x13eaf004,0xe4a20007,0x74191010,0x00000000}},	//   _muitos_, _aniž__by_, _los__puntos_, --,
   {{0x1b8c8018,0x36f9400c,0xc4b6c005,0x5bf8100d}},	//   _ནས_, _सकता_, _lansiran_je_, _bydlisko_,
   {{0xe4209005,0x95212003,0xa2590024,0x4200c005}},	//   _metara__površina_, _kunye__nonyango_, _གཞུང__འདི_, _vidim_,
   {{0xaf1b3005,0x52f37017,0x54713010,0x2ec5c005}},	//   _види__још_, _decidiu_, _una__vez_, _главни_,
   {{0xc527e025,0x83ea0004,0xc4c63021,0x4f77a023}},	//   _इंटरनेट__विपणन_, _muito_, _tusenvis__av_, _mencadan,
   {{0x0f17a026,0xac0c200c,0x018c4010,0x00000000}},	//   _kornjača_, _पहले__की_, _de__impuesto, --,
   {{0x32929005,0x4983a009,0x00000000,0x00000000}},	//   _број__становни, _olahraga_, --, --,
   {{0xb3f85010,0x5bd00004,0xe4a5c00d,0x0be3400b}},	// [020] _salud_, _opinião_, _nástroj__na_, _ིམས__ཅན_,
   {{0x6c49c01e,0x83f8d006,0x647c5010,0x12d65004}},	//   _डाउनलोड_, _kudus_, _mano__de_, _eles__são_,
   {{0x6c90500c,0x3c960014,0x10e4100d,0xc54c100d}},	//   _लोगों_, _segundo__padrón_, _užívatel, _užívateľ_,
   {{0x0ed88027,0xeaf85028,0xb469f00d,0xe7ad100e}},	//   _menyumba, _naturale, _aby__sme_, _མུ__མཐུད_,
   {{0x969f8003,0x28982010,0x00000000,0x00000000}},	//   _yokusety, _las__personas_, --, --,
   {{0x18ac801d,0x52d0c005,0x9ec1f029,0xf297000b}},	//   _preskoči_, _svetskog__rata_, _gjenstan, _ཨིང__ལིཤ_,
   {{0x542e2011,0x72ef4026,0x07369011,0x7f08d005}},	//   _enkantol_enkulu_, _na__svijetu_, _abezimo__eziphuth, _чланова__по_,
   {{0xadcb8007,0x1419a004,0x00000000,0x00000000}},	//   _zakázáno_, _que__muitos_, --, --,
   {{0xdc10e00b,0x025be00b,0x1bca800c,0x00000000}},	//   _ཕྱག__ཞུ_, _དོན__ཨིན_, _में__कितना_, --,
   {{0xc490702a,0xded7200f,0xba3d500a,0x8b8c902b}},	//   _en__del_, _bijyanye_, _रहत_, _དབ_,
   {{0x92240005,0xaa6b200c,0x5a55b00c,0x3bdbe00c}},	//   _slika_, _अपने__लिए_, _उस__समय_, _ने__यह_,
   {{0x2de1802b,0x6a6cc00f,0x725a9023,0xf24e700b}},	//   _བའི__རྗེས_, _abaminis, _itali_, _ལིཤ_,
   {{0x12b2e00a,0x00000000,0x00000000,0x00000000}},	//   _भावुक_, --, --, --,
   {{0xa2918010,0x49f7a02c,0xe248f011,0x00000000}},	//   _otra_, _densidad, _ehhovisi_, --,
   {{0xd2c84014,0x7df1c02b,0x4618600c,0x00000000}},	//   _nas__súas_, _འཛོམས__ཚོགས_, _रिकॉर्ड_, --,
   {{0xb45f1007,0x7d86c005,0xaf02c005,0x00000000}},	//   _není__to_, _награда_, _школи_, --,
   {{0x22a69007,0x8c86200c,0x4ba9b02b,0x7cec2011}},	// [030] _životní_, _के__माध्यम_, _ཁག__ཆེ_, _izithomb_patrick_,
   {{0xf293600e,0xf4426008,0xe4af602a,0xadb8f005}},	//   _ཞིག__རེད_, _mwo_, _men__du_, _они__су_,
   {{0xb9e7901d,0x427f7010,0x1a3e700c,0xa32c8009}},	//   _balonima_, _cuando_, _मैं_, _menjabat__sebagai_,
   {{0x2cd23011,0xc1682006,0x8224d007,0x15d5900f}},	//   _emuva__kokuthi_, _pengadil, _funkce_, _batangiy,
   {{0xcb8fa02b,0xfaf46005,0x02e3600d,0x8bfac00c}},	//   _འད_, _активнос, _konsolid_dlhov_, _देने__का_,
   {{0x1bce800e,0x4b95400e,0x7698c00b,0x4a8f100c}},	//   _ཁོངས__སུ_, _འཇུག__ལོ_, _ཚུ__ཡོདཔ_, _बन__गया_,
   {{0xd0438023,0xb3eb9013,0x6476b004,0x541b1004}},	//   _kemudian, _mestu_, _maneiras__de_, _se__houver_,
   {{0x54713010,0x1400c005,0xebfe300c,0x00000000}},	//   _que__sea_, _једно_, _व्यक्तिय_के_, --,
   {{0x8a33e02d,0xdf8ab02b,0x3a1f500e,0xd48e7010}},	//   _जाई_, _མཇུག__བསྡུ_, _རེད__དེའི_, _al__que_,
   {{0xe46ad021,0xb471a011,0x4f24c007,0x92de000a}},	//   _trenger__du_, _futhi__uma_, _naší_, _कहनी_,
   {{0xc471e021,0x1dbbb011,0x46fea00c,0x146d1010}},	//   _mye__av_, _emhlaben_jikelele_, _जैसा_, _hacer__con_,
   {{0x6a3d500c,0x126dd02e,0x85d5900f,0xb212b02f}},	//   _रहा_, _ukwo_, _yatangiy, _nech_,
   {{0x1b19f010,0x6ee2e005,0xe2a5400d,0x0f24600d}},	//   _responde, _он_, _svojich_, _prácu_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf2e78011,0x649c2004,0x7499b010,0x00000000}},	//   _ngabe__ufuna_, _relatóri_de_, _dólares__al_, --,
   {{0xc386000f,0x6bef200c,0x9d8af00e,0x00000000}},	//   _tpir_, _अभी__भी_, _ལྟོས_, --,
   {{0x42903008,0x7a3d500a,0x527f7007,0x00000000}},	// [040] _bija_, _रहि_, _vodní_, --,
   {{0x29ed500c,0xb943f00d,0xa2902023,0x72b4600d}},	//   _का__प्रयोग_, _počasie_, _askar_, _dvoch_,
   {{0x42d19021,0xf490902a,0xf4952010,0xdb8fb00b}},	//   _på__grunn_, _at__jeg_, _se__han_, _ཡད_,
   {{0x8ae1f030,0x64b16010,0x5ecdb00d,0xd2b0100e}},	//   _kostnade, _web__de_, _spôsob_, _རྩ__བའི_,
   {{0xd693b005,0xe9864003,0xc9d07005,0x3490a007}},	//   _као__кориштен_, _yekharit, _речи_, _je__jen_,
   {{0x76824002,0x97f13005,0xbb8d400e,0x029e500b}},	//   _अरमान_, _скоро_, _བྷ_, _གིས__འོག_,
   {{0x7baf000e,0x5a3d500a,0xa1782003,0x5490a00d}},	//   _ཕྱོགས__དྲ_, _रहऽ_, _yecandel, _je__len_,
   {{0x22d9800d,0xc2903008,0x7be3100e,0xa248001d}},	//   _hore_, _zija_, _བཙོན__ཁང_, _čim_,
   {{0xc3954003,0xdca23011,0x4f240007,0xe4463007}},	//   _ixesha_, _ngo__ephreli_, _našem_, _musí__být_,
   {{0xc2d9600f,0xe29b702b,0x13e36026,0x5e048011}},	//   _kugeza_, _མེད__རྡོ_, _je__pjesma_, _uma__kuqhatha,
   {{0xb3f98012,0x72785011,0x00000000,0x00000000}},	//   _moru_, _omunye_, --, --,
   {{0x94909021,0x80fc900a,0xa28d700d,0x6441f005}},	//   _gi__deg_, _बतावल_, _vo__svojej_, _детаљниј,
   {{0xfa32a002,0xf442c00d,0x5612c012,0x6893b007}},	//   _गजल_, _ked_, _licencom_, _provozov,
   {{0xd490a021,0x0a4c9031,0x56019005,0x19711016}},	//   _av__den_, _iindlela_, _iznosi__geometri, _stažení_,
   {{0x45cc7005,0x7290b01d,0x52ed4030,0x725b0010}},	//   _на__надморск, _suca_, _kopiere_, _cuales_,
   {{0xab4ba02b,0x99c0900d,0xb26ce013,0x02d8c014}},	//   _དབང__ཕྱུག_, _priemyse, _odnosi_, _cadea_,
   {{0x82d5700f,0xd232a005,0x13f81014,0x2cb9400c}},	// [050] _seromba_, _tri__popisa_, _por__outra_, _पसंद__करते_,
   {{0x4d9ad00b,0xc2bbf007,0x03340004,0xdd5a0005}},	//   _ཉམས__བཅོས_, _zadejte_, _de__câncer_, _дође_,
   {{0xe2d9800f,0x7544a01d,0x4c4f200c,0x64779004}},	//   _dore_, _srušite_, _उसने_, _março__de_,
   {{0x62904032,0x2335700f,0x00000000,0x00000000}},	//   _cima_, _ahariho__hose_, --, --,
   {{0xe4b0e033,0xebe4000e,0xba15500f,0xe6a22005}},	//   _stand__til_, _ལོའི__ཟླ_, _njyanama_, _институц,
   {{0x4b88202d,0xd9f4300d,0x33474023,0xedcf1005}},	//   _नु_, _majú_, _kerajaan__negeri_, _након__што_,
   {{0x72d8a026,0xfafb5007,0x93f99012,0x02901015}},	//   _dijeli_, _žádné_, _kosu_, _faham_,
   {{0x26fed00a,0x81156013,0x9290c028,0xd4757011}},	//   _चोखा_, _prijatel, _duda_, _happy__gal_,
   {{0xaee97019,0x6277200b,0x0bec0024,0xca3e7002}},	//   _de__saúde_, _བསྐྱོད__བསམ_, _སྡེ__ནང_, _बनि_,
   {{0x64b9b014,0xd4b1a02a,0x52921009,0xfc3ce003}},	//   _millóns__de_, _til__den_, _bupati_, _amanqaku_,
   {{0xa2904015,0xb17de011,0xf1c91005,0xc2b5000b}},	//   _ramai_, _enkantol, _пошто_, _ེར__གྱི_,
   {{0xe2fd6030,0xcc77d00c,0x127e2010,0x00000000}},	//   _logger_, _एलर्जी_, _la__llamada_, --,
   {{0x6b56100e,0x821cf011,0x4e08600e,0x2aef100d}},	//   _དུང__གཟིགས_, _ekhala__ngokuthi_, _པར__བརྟེན_, _zabudnut,
   {{0x2c0d5003,0x89ed7023,0x5a33601a,0x6b7fc005}},	//   _satshop_, _sainsnya_, _किस_, _posledic,
   {{0xd2fd5029,0x5a7ea00f,0xd4aaf010,0x00000000}},	//   _kopiert_, _ukwakira_, _hasta__que_, --,
   {{0x2442d01b,0xd2d99008,0x7bbb900c,0xad06f00e}},	//   _nee_, _cose_, _हैं__तो_, _རྒྱུའི_,
   {{0x52d88013,0xba5d9007,0x36fe0011,0x64bc5004}},	// [060] _raketa_, _jiného_, _uma__usebenzi, _jogo__de_,
   {{0x12ffe02a,0x229af011,0x64038011,0x64acd010}},	//   _år__siden_, _kuleli__cala_, _sikhathi__sonyaka_, _ayuda__de_,
   {{0x02d98034,0x1224e011,0x393f900c,0x00000000}},	//   _vore_, _isicoco__seligi_, _का__सर्वोत्त, --,
   {{0x34d5202d,0xed036023,0xa3039004,0x42922010}},	//   _रुपिया_, _matlamat_, _para__venda_, _nueva__york_,
   {{0x4317f028,0x6df7d00e,0x634e7004,0x7bec500b}},	//   _cruz_, _མི__རྣམས_, _função_, _འཕྲུལ__ཁང_,
   {{0x62d8a026,0x52431011,0xbbddc00b,0xf5a5e00d}},	//   _cijeli_, _umhlaba__wonke_, _གནོད__ོན_, _niektorý,
   {{0xd7be9024,0xb24f8010,0x4cca0007,0xf37cf011}},	//   _རྟགས__བཀོད_, _el__sitio_, _ve__formátu_, _into__yamehlo_,
   {{0x835bf035,0x00000000,0x00000000,0x00000000}},	//   _kungaba_, --, --, --,
   {{0xfad19024,0x84b1e003,0x547ab019,0x00000000}},	//   _བཙུགས_, _ukuba__ube_, _problema_no_, --,
   {{0x6a3e100a,0x926c2023,0x5bb9d005,0xe36bd010}},	//   _मनई_, _rekod_, _недеља_, _de__precios_,
   {{0xc86f1008,0xeaad6021,0x6c4ed01e,0x128dc00e}},	//   _abanyabu, _konverte, _जैसे_, _བསམ__བློ_,
   {{0xebc5900b,0x00000000,0x00000000,0x00000000}},	//   _བཀག__ོམ_, --, --, --,
   {{0x7200e010,0x02a6b003,0xb26d0019,0x6af1f005}},	//   _sonido_, _kule__meko_, _embora_, _непријат,
   {{0xc24e5024,0x89cff00d,0xc48f5007,0x00000000}},	//   _ཡིག_, _stretnut, _který__je_, --,
   {{0xc2584014,0xc40d8014,0x8bfc600d,0x39f47007}},	//   _de__máis_, _dous__anos_, _priateľo, _jiný_,
   {{0x1c56200a,0x7fa25021,0x26ce3036,0xf272800b}},	//   _काहें_, _nedenfor_, _detaljni, _ཡི__ཟེར_,
   {{0xa510c005,0x00000000,0x00000000,0x00000000}},	// [070] _веома_, --, --, --,
   {{0x2f247007,0x42d88023,0x947c900f,0xb9f8400c}},	//   _část_, _cakera_, _kaminuza__ya_, _आपकी__सहायता_,
   {{0x62927012,0x34bba015,0xc4966021,0xe46a5011}},	//   _igrati_, _sama__ada_, _ta__en_, _kusolaka_ukuthi_,
   {{0x89787007,0x33eaf004,0x1e5d8014,0x507d8014}},	//   _velikost, _muitas_, _traballa, _traballo,
   {{0xf2e72005,0x33c2e006,0x64682021,0xf30e702a}},	//   _spoljašn_veze_, _hindia__belanda_, _deg__for_, _helt__sikkert_,
   {{0xdcac3006,0x971b000c,0xc9c8c00e,0xb46ab004}},	//   _yogyakar, _कि__क्या_, _གོའི_, _com__uma_,
   {{0x92905019,0x4f5cd023,0xe2a7600b,0x7bc7a00b}},	//   _vila_, _inggeris_, _ཤོས__ཅིག_, _བཏང__ནི_,
   {{0x427eb00d,0x92b77014,0xa3ea0004,0x52396005}},	//   _jednej_, _de__polo_, _muita_, _коју_,
   {{0x53218037,0x127df00b,0xb4686004,0x00000000}},	//   _hirya_, _ལུ__སྦེ_, _dia__do_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc490e02a,0x7bf2600e,0x4bf8700a,0xfbc1900c}},	//   _få__en_, _མན__ངག_, _शलजम_, _साइट__से_,
   {{0xf2e1a01d,0xffdad023,0x23250022,0x82b73014}},	//   _kolovoz_, _pada__disember_, _de__este_, _era__unha_,
   {{0xcc618034,0x64ba5019,0x524d800e,0x1a97c00c}},	//   _sverige_, _taxas__de_, _སྒམ_, _जब__मैं_,
   {{0x7be7a00b,0x4e724011,0xfcc06004,0x00000000}},	//   _བཟོ__ནི_, _de__villiers_, _de__algumas_, --,
   {{0x0bf6100b,0x00000000,0x00000000,0x00000000}},	//   _གི__ིས_, --, --, --,
   {{0x50808005,0x670b2011,0x54863010,0x00000000}},	//   _централн_године_, _ne__equatori, _alguna__vez_, --,
   {{0x62267038,0x52c24003,0x5d54200b,0xef57600c}},	// [080] _verkar_, _ngelixa_, _ཆོས__རྒྱུགས_, _जाएगी_,
   {{0xc248901d,0x2e9a5005,0xf229c007,0x5200f00f}},	//   _znam_, _што__је_, _díky_, _mugi_,
   {{0x12907035,0x32378038,0xb451a011,0xf2ca701c}},	//   _mina_, _byrja_, _ukuthi__uma_, _sunda_,
   {{0x238a1007,0x5290b004,0xb2613004,0xac82b032}},	//   _fóru_, _dicas_, _mão_, _seu__sistema_,
   {{0xff185005,0x80bc6003,0x83ea7014,0x8c76402c}},	//   _да__би_, _kunye__nokugcin, _xunta_, _actuais_,
   {{0x533b5009,0xb2240029,0x43290021,0x4ec74005}},	//   _pergurua_tinggi_, _klikk_, _du__leter_, _разлику__од_,
   {{0xc2613004,0xe5a3e039,0x22dcc006,0xc478b022}},	//   _não_, _कर्मचारी_, _di__bidang_, _particip_en_,
   {{0x99aa2005,0x446a2003,0xa3e6700d,0x00000000}},	//   _нато__ознака_, _kwezi__ntsuku_, _sa__dnes_, --,
   {{0x72977005,0xd2ced011,0x3c8e500a,0x0420800f}},	//   _ma__prema_, _akwazulu__natal_, _कउनो_, _hari__bintu_,
   {{0x8300e01c,0x1b18b003,0xbba3100f,0x92919005}},	//   _sepak__bola_, _inxaxheb, _imihango_, _pisac_,
   {{0x3b1f3006,0xf3043011,0x71862005,0xd007b004}},	//   _komandan_, _bese__kuba_, _економск, _no__início_,
   {{0x51039015,0x64acd011,0x00000000,0x00000000}},	//   _mahkamah_, _stadium__pm_, --, --,
   {{0x6290b019,0xb170a00d,0xdc0ad015,0x3462200d}},	//   _ficar_, _vytlačiť_, _tumpuan_, _stredisk,
   {{0x45373003,0x54625004,0xe45a7011,0xc4736010}},	//   _zemibuth, _não__se_, _iqiniso__ukuthi_, _venta__en_,
   {{0x426e7005,0x9234500f,0x846d9014,0xb9aac005}},	//   _nosač__nato_, _igamije_, _ocasións_, _попис_,
   {{0x2495600f,0x8217500b,0x92988010,0x00000000}},	//   _ni__ba_, _ནི__ཨིནམ_, _últimos__años_, --,
   {{0x944a5009,0xf2007011,0x647ad014,0xe2575013}},	// [090] _karena__ia_, _yini_, _illa__de_, _su__jedino_,
   {{0xc2d8a012,0xe19b200d,0x4a4c100c,0x13f4c016}},	//   _rijeci_, _zvieratá_, _हो__गया_, _ústí_,
   {{0x252f501f,0xc49ed005,0xb472300d,0xf9f66004}},	//   _umuyoboz, _takođe__je_, _skúsenos, _força_,
   {{0xe321e00f,0x8537800c,0x446f700d,0x7523d005}},	//   _bityo_, _और__अन्य_, _tak__nie_, _поздрав_,
   {{0x1ca7800c,0x047a1010,0xf337800c,0x00000000}},	//   _और__उसके_, _desarrol_por_, _और__उसकी_, --,
   {{0x83eaf01c,0xa37d400d,0xe3f9c01d,0xa2d9c005}},	//   _kantor_, _zdravie_, _novu_, _nove_,
   {{0x325a6014,0x00000000,0x00000000,0x00000000}},	//   _xullo_, --, --, --,
   {{0x6f47b036,0x6290e005,0xd4a03010,0x46fca00c}},	//   _državu_, _finala_, _alguien__que_, _हैं__इसलिए_,
   {{0x12613004,0xb442f038,0x92f15038,0x34711021}},	//   _são_, _veg_, _låg_, _klikk__her_,
   {{0xb2911031,0x024e5020,0xbf47200e,0x1c57900a}},	//   _kuza_, _ཡིས_, _མིང__འབྱུང_, _एहमें_,
   {{0x22360012,0x9a3e701a,0x902de005,0x00000000}},	//   _dvije_, _मैच_, _упркос_, --,
   {{0x1f49d005,0x42613004,0x00000000,0x00000000}},	//   _производ, _vão_, --, --,
   {{0x832b2010,0x62de9010,0x00000000,0x00000000}},	//   _que__tenga_, _hacer__clic_, --, --,
   {{0xaa4ca00c,0x22613004,0x02cb7007,0x00000000}},	//   _के__लिए_, _tão_, _hradec_, --,
   {{0x5b88700a,0x1a691010,0x34956011,0xb478d004}},	//   _बड_, _clic__aquí_, _of__sa_, _apresent_uma_,
   {{0x2291b00f,0x22010023,0xc8297021,0x5c114014}},	//   _imvaho_, _dibina_, _også__tilgjeng, _posíbel_,
   {{0x92ec100f,0x824d900e,0x00000000,0x00000000}},	// [0a0] _ubwo__rero_, _སྡང_, --, --,
   {{0x7442002e,0x2443100d,0xcf302005,0xe31c9003}},	//   _iti_, _cez_, _врста__има_, _uyazi__ukuba_,
   {{0x0474d00f,0x34431004,0x9be24024,0x6db8500e}},	//   _nyuma__yo_, _dez_, _འདི__མི_, _དེ__རྣམས_,
   {{0xf442d037,0xccf1800f,0x7bfc702b,0xbde2a004}},	//   _bwe_, _ibiteker, _མི__ཡང_, _se__preocupa,
   {{0xd2793005,0x54431004,0xaf355005,0xd2fc5021}},	//   _ракета__носач_, _fez_, _за__то_, _velge_,
   {{0xc291e01c,0xa4432010,0x0237b011,0x863f2023}},	//   _antar_, _ley_, _ngemuva_, _berhampi,
   {{0x0b8f800c,0x52e1a011,0x72da6014,0xd2df7003}},	//   _था_, _yize__kunjalo_, _igrexa_, _kwi__yeedola_,
   {{0xa4390005,0x0e39b005,0x8f0ef005,0x128fe004}},	//   _staništa__vrste_, _постер__за_, _примећен_, _que__são_,
   {{0x6bde8005,0x6407901c,0x5290a015,0x0bdef02b}},	//   _opština__istočnoj_, _dukungan_, _sabah_, _ཁྱིམ__ནང_,
   {{0xb4b29023,0x3387a00d,0xcb5ea00a,0x8fbd5010}},	//   _iaitu__dan_, _napr_, _जईसन_, _dólares__estadoun,
   {{0xc3cf702f,0x63ea7014,0xd200a00f,0xc9da501a}},	//   _hlavne_, _xunto_, _mibi_, _पासवर्ड_,
   {{0x4c4e000a,0x7c133011,0x32de000a,0xdc27900f}},	//   _कहले_, _amanye__amalungu_, _कहली_, _imyanzur,
   {{0x02f15038,0x634ef02a,0x81e1801a,0x3bd9e00c}},	//   _såg_, _ikke__alle_, _उपकरण_, _जो__यह_,
   {{0xc290a037,0x42cb5010,0xf2123003,0x02e38019}},	//   _niba_, _puedes_, _komhla_, _seu__produto_,
   {{0xa24da024,0xf4273021,0x13027015,0x3200b00f}},	//   _འདི_, _nettsted_ditt_, _ini__boleh_, _padiri_,
   {{0x58c6e021,0x00000000,0x00000000,0x00000000}},	//   _innehold, --, --, --,
   {{0x2200a037,0xb386d038,0x7b9c3003,0x2bbcf00e}},	// [0b0] _bibi_, _gjera_, _njengoko_, _ཡི__གེ_,
   {{0x546dd014,0xa2fc5021,0xf473f014,0xf442d00f}},	//   _cando__se_, _selge_, _mesmo__ano_, _rwe_,
   {{0x22c5a030,0xc2a9a007,0xa387900d,0xb2e8c003}},	//   _daglige_, _článků_, _tasr_, _kwindlu_,
   {{0x9be18024,0xf3f12004,0x00000000,0x00000000}},	//   _བཏོན__ཏེ_, _do__corpo_, --, --,
   {{0x830b401d,0x9290301c,0x24b2f003,0xe0206017}},	//   _svibanj_, _pajak_, _kunye__nee_, _numeroso,
   {{0x03aac01d,0x00000000,0x00000000,0x00000000}},	//   _animalia__insecta_, --, --, --,
   {{0xfac37011,0x62a6c005,0xec09000c,0x00000000}},	//   _absa__premiers, _мјесто_, _सुरक्षा__के_, --,
   {{0x4291901d,0xfca79004,0x00000000,0x00000000}},	//   _rezač_, _estão__algumas_, --, --,
   {{0xca33600c,0xf5a70005,0x0a54500c,0xc1a6600c}},	//   _किए_, _aerodrom_, _ही__में_, _का__प्रदर्शन_,
   {{0x32d9d00f,0xa290b026,0xb4722011,0x92ffe010}},	//   _wowe_, _lica_, _kuthe__uma_, _sin__duda_,
   {{0x0f097023,0x42f2500c,0x5c62500c,0x1383e00f}},	//   _amerika__syarikat_, _हो__सकती_, _हो__सकते_, _muburyo__bwiza_,
   {{0x03468011,0x413b1005,0x00000000,0x00000000}},	//   _soccer__league_, _опет_, --, --,
   {{0x62fc7010,0x02d8e010,0x64bcb004,0x3f3b7011}},	//   _tengo_, _manera_, _quantida_de_, _esigaben,
   {{0xc360800f,0x9b19e005,0x00000000,0x00000000}},	//   _ni__ukubera_, _библиоте, --, --,
   {{0xd47fa014,0xe47c7005,0x0bd3102d,0x4320700f}},	//   _unha__das_, _vikipedi_na_, _तबियत_, _yanyu_,
   {{0x72b33023,0xabbd7006,0x63eb000d,0xeb8d300b}},	//   _pilihan__raya_, _soekarno_, _piatok_, _ཞབ_,
   {{0x02409003,0xcc25e00c,0x32e43011,0x00000000}},	// [0c0] _ezimbini_, _तो__कृपया_, _ku__absa_, --,
   {{0x557d6004,0x29a70011,0xad89c00b,0x62126007}},	//   _populaçã, _kwe__inthanet, _ཡིག__སྒྲོམ_, _mnoha_,
   {{0x327f7004,0x7b8d300e,0x4290b004,0xe2829011}},	//   _quando_, _ཟས_, _fica_, _kwendoda_yakhe_,
   {{0x5290b03a,0x02905015,0x7c6bf00a,0x61e7b007}},	//   _gica_, _ialah_, _कुल्हि_, _nachází_,
   {{0x33099003,0x2d42700c,0x94bba011,0x74b45010}},	//   _iimali__mboleko_, _किस__प्रकार_, _enkulu__yasethek, _saber__si_,
   {{0x3b2a600c,0x00000000,0x00000000,0x00000000}},	//   _सबसे__अच्छे_, --, --, --,
   {{0x029dd013,0xcbed100c,0x00000000,0x00000000}},	//   _hiljada_, _पर__ही_, --, --,
   {{0x825e701c,0x00000000,0x00000000,0x00000000}},	//   _sebagai__bagian_, --, --, --,
   {{0x5224000f,0xb4bf502a,0x5aa07023,0xdf919017}},	//   _aliko_, _husk__at_, _penyelia_, _primeiro,
   {{0x6b62100a,0xc4b2e021,0x00000000,0x00000000}},	//   _केतना_, _glipp__av_, --, --,
   {{0x32489008,0x93f98027,0xe45b7007,0x3497e010}},	//   _akama_, _turut_, _mohou__být_, _si__lo_,
   {{0x3c59f01c,0x02a01018,0x94911021,0xe48b1007}},	//   _listrik_, _བཞིན__ཡོད_, _av__deg_, _požadavk_na_,
   {{0xf980500f,0x0290b010,0x8752700c,0x8395402f}},	//   _gashyant, _rica_, _आप__अपना_, _presne_,
   {{0x2309c004,0x12ec7034,0xf1778005,0x7241800a}},	//   _também_, _geografi_, _астероид_износи_, _दिहले_,
   {{0xc25b8027,0x12f37014,0x9999900d,0x2f772005}},	//   _perlu_, _recibiu_, _ísť_, _децембра_,
   {{0xd200c007,0x92fd4013,0x00296005,0x00000000}},	//   _lidi_, _njegov_, _најпозна, --,
   {{0x027f003b,0x269ca00e,0x52bf6004,0xb2c25007}},	// [0d0] _etanol_, _སླེབས_, _sua__vida_, _mnohem__více_,
   {{0x845de007,0x00000000,0x00000000,0x00000000}},	//   _několik__let_, --, --, --,
   {{0xcc7de020,0xbc59f01c,0x02c4b014,0x3a96500c}},	//   _འདིའི_, _distrik_, _ademais_, _और__साथ_,
   {{0x16d1300a,0xcb00a017,0xb2d9f013,0x82a8b010}},	//   _खातिर_, _división_, _putem_, _no__sólo_,
   {{0xbf02f02b,0xdd82f00e,0xe1662004,0xf2019023}},	//   _འབྲུག_, _འབྲོག_, _veículos_, _jisim_,
   {{0xf2f45038,0xcc219011,0x4bc98024,0xf497e004}},	//   _plantar_, _ngemuva__kwalokho_, _གནམ__ལོ_, _um__bom_,
   {{0x325a1007,0xa3fa700f,0x94780011,0xc458e021}},	//   _mohl_, _gusura_, _umengame_we_, _forårsak_av_,
   {{0x8b0b1030,0xe2d88010,0x94b21021,0x5c4c5003}},	//   _rapporte, _mejores_, _til__deg_, _iilwimi_,
   {{0xd418b021,0x0cffe02a,0x00000000,0x00000000}},	//   _via__post_, _en__løsning_, --, --,
   {{0xbeb31010,0x003fb003,0x0a73600c,0x00000000}},	//   _aquellos_, _ukutshin, _दिनों__में_, --,
   {{0xd4ba7021,0xcba12011,0x14f8e004,0x00000000}},	//   _delprosj, _ngosuku__lokuqala_, _de__serviços_, --,
   {{0xada17005,0x9477500f,0xa48eb010,0x00000000}},	//   _јер__су_, _hafi__ya_, _de__mis_, --,
   {{0x8378e009,0xff67f005,0xb8688003,0x1468a004}},	//   _balapan_, _других_, _kwiintsu, _ele__foi_,
   {{0x32f91026,0x6c4e000c,0x7bbc100c,0xd66d300b}},	//   _ni__klub_, _कहते_, _हों__तो_, _བཞག__དགོཔ_,
   {{0xf46b5021,0x62ee5011,0xc29dd020,0x33265010}},	//   _kroppen__din_, _amalungu__omndeni_, _ཤེས__པའི_, _el__modelo_,
   {{0x28464004,0x1bd2700a,0x32d89012,0xcb9d901c}},	//   _qualidad, _बांये_, _tijela_, _soeharto_,
   {{0x1ba5203c,0x5fc78013,0xe2efe007,0xc88c4004}},	// [0e0] _ही__एक_, _evropsko, _jak__vytvořit_, _são__fornecid,
   {{0x7dbc902b,0xb22c100f,0xfe871028,0xa2ffa011}},	//   _ལས__ཚོགས_, _kandi__muri_, _de__baño_, _udj__tira_,
   {{0xc7564024,0x4edc5005,0x02024003,0x8828a011}},	//   _དཔེ__མཛོད_, _више__од_, _yowiso_, _lo__mqhudelw,
   {{0x2290c038,0x13157015,0xc27ed034,0x64736021}},	//   _sida_, _yang__boleh_, _byen_, _designet__for_,
   {{0x62907015,0xd982f00f,0x4495c010,0x40bd2005}},	//   _kanak_, _ubuhamya_, _no__hay_, _прву_,
   {{0x09cf300b,0x72cad010,0x83f8f011,0x13e8a00f}},	//   _ནིའི_, _pueda_, _angu_, _ibintu__byawe_,
   {{0x6ee8b00c,0x9248f007,0xfc60b010,0xe6c2000d}},	//   _सूचक_, _kromě_, _este__artículo_, _na__chudnuti,
   {{0x0bb4800c,0xb24ca00b,0xe4a2f007,0x3c5d900c}},	//   _नहीं__है_, _ིམས_, _klepnutí_na_, _शामिल__करें_,
   {{0x3290c038,0x0984e003,0xa4914010,0x00000000}},	//   _tida_, _igqitshe, _la__ley_, --,
   {{0xa378e023,0xf023f00d,0x0bb3800c,0xae6b2019}},	//   _pelakon_, _predajco, _आती__है_, _de__chamadas_,
   {{0x6c7f700c,0x2a55700c,0x93461010,0x00000000}},	//   _उपयोग__करने_, _कर__लें_, _puede__tener_, --,
   {{0x29984007,0xc2988018,0xf2e62011,0xc4b5e028}},	//   _domů_, _རྒྱུ__མཚན_, _lesi__sicoco_, _pensando__en_,
   {{0x026c800f,0x5d1b6036,0x725b6036,0x3c72400c}},	//   _bakoze_, _porodice_, _porodici_, _डाउनलोड__करें_,
   {{0x8be6b00c,0xc2950020,0x397e2005,0x43836010}},	//   _हो__रही_, _བཞིན__པའི_, _групе_, _la__compañía_,
   {{0x62dff003,0x7f86e01e,0x6d61b010,0x00000000}},	//   _kukho__into_, _कार्रवाई_, _anuncios__clasific, --,
   {{0x343d802a,0x82aa0024,0xc2caf027,0x6201a01c}},	//   _på__dette_, _གི__ཐོག_, _bandar_, _sipil_,
   {{0xf9c4900a,0x00000000,0x00000000,0x00000000}},	// [0f0] _अंजोरिया_, --, --, --,
   {{0xc200d014,0x1a708004,0xc2ffe00c,0xc364c004}},	//   _froito_, _bem__sucedida_, _यह__किसी_, _página__inicial_,
   {{0xc496e02a,0x79a37004,0x0f38b020,0x3225403d}},	//   _se__en_, _ministér, _དུ__འགྱུར_, _akekho_,
   {{0x1326e014,0x3347a02a,0x2ba6300c,0x72f97010}},	//   _en__onde_, _de__mange_, _है__जब_, _que__pueda_,
   {{0x726c800f,0xd3874022,0xd27a600b,0x9310200f}},	//   _yakoze_, _muerte_, _ལས__འགོ_, _buri__gihe_,
   {{0xd33d0009,0x9201901c,0x33ead004,0x24286011}},	//   _bahwa__mereka_, _fisik_, _frete_, _most__gifted_,
   {{0x84a95014,0x699b2014,0xdc763005,0x00000000}},	//   _durante__os_, _maioría_, _децембар_, --,
   {{0x8d0f0012,0x3868600d,0x4c7c4010,0x2fedd015}},	//   _uklonite_, _vzdeláva, _muestra_, _menyokon,
   {{0xfe8f1005,0xeedd1005,0x5d84b01d,0xcc4f600c}},	//   _или_, _prirodno__stanište_, _odredite_, _लिए__कृपया_,
   {{0x54523033,0x56755014,0x1bee100b,0xca3d0004}},	//   _den__mest_, _unha__diminuci, _གྲོགས__རམ_, _seu__computad,
   {{0x02910015,0xfecbd01d,0x5c7c4010,0x986c4010}},	//   _beliau__juga_, _najigran, _nuestra_, _nuestras_,
   {{0x82d8f03e,0x28b8a010,0x00000000,0x00000000}},	//   _unge_, _de__personas_, --, --,
   {{0xbca2a00c,0x5429e023,0x9332a00c,0x2e880032}},	//   _आप__अपने_, _merupaka_portal_, _आप__अपनी_, _os__programa,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xab8fd009,0xb4c05021,0x63874028,0x92489004}},	//   _हा_, _slik__at_, _fuerte_, _eram_,
   {{0xa2489034,0xe4af702a,0x0b5f000a,0xa268802b}},	//   _fram_, _tid__til_, _अईसन_, _རྫོང__འདི_,
   {{0x7290f027,0xb297400e,0xae572005,0x00000000}},	// [100] _bagai_, _གཙོ__བོར_, _иза_, --,
   {{0xedb7c00b,0xfad5800e,0x7e0d7005,0x00000000}},	//   _ལས__རྟགས_, _ཉེན__རྟོག_, _ову_, --,
   {{0x446a6014,0xf347900d,0x1c7dc00e,0xa4bfe010}},	//   _través__da_, _týždeň_, _སྐུའི_, _por__sí_,
   {{0x52c11010,0x00000000,0x00000000,0x00000000}},	//   _del__siglo_, --, --, --,
   {{0x627ff007,0x0a6e900c,0x9e61f009,0x224bb004}},	//   _seznam_, _करते__हुए_, _pembagia, _de__email_,
   {{0x125a9015,0x79d8802a,0x67db8011,0x7d67e005}},	//   _kuala_, _eksemple, _olive__conventi, _требало_,
   {{0x3c4f000c,0x00000000,0x00000000,0x00000000}},	//   _इससे_, --, --, --,
   {{0xc3ea6007,0xc2d7503b,0xa2125004,0x8d287022}},	//   _proto_, _atmosfær, _filho_, _efectos__secundar,
   {{0x7bd2a00b,0xc4916007,0xfbe6b00c,0x82d6f00d}},	//   _འབད__ནི_, _co__je_, _हो__रहे_, _ktorá__bola_,
   {{0xe085c00c,0x5290f038,0x76fed01e,0xac55100c}},	//   _सम्बंधित_, _eiga_, _कहना_, _ऐसा__नहीं_,
   {{0x84438021,0x3712a00c,0xf016a007,0xfbd1900e}},	//   _mer_, _हो__सकता_, _příslušn, _ཞིག__དང_,
   {{0xa470c023,0x71772005,0x74438019,0xc26c5016}},	//   _menyumba_semua_, _место_, _ler_, _celou_,
   {{0xe495e00d,0xee3f5005,0xacb3200c,0x00000000}},	//   _sa__na_, _значи__да_, _क्यों__नहीं_, --,
   {{0xe2b5d007,0xb2127004,0x1357e003,0x398b4007}},	//   _najdete_, _tinha_, _iimfuno_, _vidět_,
   {{0x6278a00b,0xe25b1010,0xa2afb00b,0x1702f00c}},	//   _བརྒྱའི__དྲན_, _hablar_, _འཛོམས__འདི_, _ऐसा__लगता_,
   {{0xc442600d,0x5683b00a,0x91df200a,0xdffb7004}},	//   _kto_, _तोहार_, _अनार_, _questões_,
   {{0xd443803b,0x755b9011,0xe3f41004,0x00000000}},	// [110] _ber_, _enkundle_yezokuxh, _maneira__mais_, --,
   {{0x02018037,0x825ad003,0x9be1302b,0x32ed8011}},	//   _buri_, _ngeli_, _བརྟེན__ཏེ_, _ukuba__khona_,
   {{0xc8fc8007,0xf291801d,0x6477502a,0xc26c4026}},	//   _odpovědě, _cura_, _alle__de_, _nemoj_,
   {{0xff3ca006,0x52cad010,0x29353011,0xd2d8b00d}},	//   _perusaha, _puedo_, _esithang_sabezind, _chcel_,
   {{0xe292001c,0x8d73e028,0x9bc8402b,0xa4b6700d}},	//   _jepang_, _de__asistenc, _བཏང__མི_, _ako__vytvoriť_,
   {{0xe2d8b01d,0x48700004,0x5fedd015,0xd9f42007}},	//   _vodeno_, _pernambu, _penyokon, _jaký_,
   {{0x2c8e803c,0x12d8e01a,0x67e0d018,0x00000000}},	//   _कार्य__करते_, _सूची_, _རིག__འཛིན_, --,
   {{0x009a4007,0x3e0d1005,0x5e9d1005,0x00000000}},	//   _přání_, _сви_, _ски_, --,
   {{0x84439028,0xd70d4004,0x143ab00d,0x6be5d010}},	//   _mes_, _experiên, _na__ceste_, _la__creación_,
   {{0x74439022,0xb201902e,0x53f8f004,0x8b76c00c}},	//   _les_, _musi_, _água_, _का__पालन_,
   {{0xd5036004,0x00000000,0x00000000,0x00000000}},	//   _um__serviço_, --, --, --,
   {{0xb77b9005,0xd2771011,0xc2cad038,0xba09a00d}},	//   _opština__severnoj_, _zweli__mkhize_, _budde_, _zodpoved,
   {{0x4e72e005,0x7bad100e,0x43ea003b,0xe2d8b02f}},	//   _не_, _ནང__དུ_, _fritt_, _chcem_,
   {{0x78aeb01d,0x22e6d00a,0xc472600d,0x00000000}},	//   _počnete_, _चाहीं_, _kto__je_, --,
   {{0xebe2b00b,0x8e9bd01d,0xf2d2300e,0x54916007}},	//   _འདི__གི_, _pokupite_, _གཅིག__རེད_, _co__se_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8d96a034,0xfea9d026,0xabffc024,0xf27fa003}},	// [120] _milliona, _postavke_, _སོ__ནམ_, _ngeli__xesha_,
   {{0x95c33005,0x65840005,0xbfb43005,0xc2a3300e}},	//   _је__једино_, _на__овом_, _су__имали_, _སྤྱོད__པའི_,
   {{0x22c7e011,0xc983a01f,0x23479031,0x4c4f200c}},	//   _leli__cala_, _amahanga_, _iphepha_, _उससे_,
   {{0x5236600d,0x7aabd032,0x426c500d,0xfe9e5014}},	//   _svoje_, _oliveira_, _celom_, _saúdo_,
   {{0xf4438004,0xd2786004,0x941a3005,0xfa3c400a}},	//   _ter_, _jornal_, _је__једна_, _आगा_,
   {{0x2201801f,0x52912003,0xe399b007,0x0e4ca01c}},	//   _turi_, _liya_, _místo_, _pelayana,
   {{0x4e7a6005,0x3ae5400f,0x4798c00e,0xd3e8d005}},	//   _је__од_, _itsembab, _གཤེན_, _успео_,
   {{0xab594006,0xef804005,0x4291101b,0x67f15024}},	//   _सचिन_, _је__имало_, _ziza_, _འགོ__འཛིན_,
   {{0x02a76007,0x00000000,0x00000000,0x00000000}},	//   _se__měli_, --, --, --,
   {{0x5e86801d,0x9200200f,0xbde6c00d,0x52dee010}},	//   _mjehurić, _komite_, _nájdete_, _la__vida_,
   {{0x84426034,0x748b0011,0x5c76c00f,0x00000000}},	//   _wto_, _esikhumu_sezindiz, _aderesi_, --,
   {{0xe24e400e,0x1e429005,0x6a56b00c,0x63a28021}},	//   _རྒན_, _је__као_, _हो__रहा_, _dokpro_,
   {{0x8b8d900b,0x0dd92027,0x69c10003,0x3bb9700e}},	//   _གས_, _perkataa, _capegate, _ཡས__མས_,
   {{0x6816d02b,0xd443a004,0x040a2011,0x00000000}},	//   _དབང__འཛིན_, _cep_, _freedom__party_, --,
   {{0x62d8b01d,0x8ec4300f,0xbeb1300d,0x0df8f005}},	//   _srce_, _kinyarwa, _porovnan, _vazduhop,
   {{0x725a9014,0x7de3902b,0x00000000,0x00000000}},	//   _tralo_, _རྒྱས__ཚོགས_, --, --,
   {{0x6290501c,0x02667027,0xaba6200c,0x42905015}},	// [130] _salat_, _dan__beliau_, _प्रकार__की_, _balas_,
   {{0x9a1b4023,0xb2cad010,0x32912003,0xb4667014}},	//   _terdiri__daripada_, _puede_, _ziya_, _decembro_,
   {{0x2a3e0002,0x22912003,0x32d9f014,0x54b99011}},	//   _बाप_, _yiya_, _estea_, _esiphezu_se_,
   {{0xa298002b,0x13b0e004,0xd200b038,0x894f2029}},	//   _འཇིགས__མེད_, _clique_, _fleire_, _samlinge,
   {{0xe2d87005,0xf2da501f,0xf4906021,0xc2011013}},	//   _prema__procjeni_, _guteza_, _ha__et_, _naziv_,
   {{0xe2ace005,0xe931200d,0xd27c1011,0x6be4100c}},	//   _procjeni_, _vložiť_, _ukuthi__uthole_, _तक__आप_,
   {{0x7a3d9002,0xce25f023,0x126c800d,0x83081003}},	//   _दाल_, _baru__mendafta, _rokoch_, _ixabiso_,
   {{0x3d4c8005,0x78ada022,0xd3d56028,0x0f02c005}},	//   _potrebe__ilustrac, _de__vehículo, _la__muerte_, _школу_,
   {{0x9b8da024,0xf14dc005,0xeb98100c,0x64726010}},	//   _ངས_, _износи_, _समय__के_, _una__de_,
   {{0xc291201b,0x0491802a,0xd1614005,0x22ce8011}},	//   _siya_, _at__det_, _је__написао_, _kahle__ngoba_,
   {{0x74292023,0xde40100f,0xd2c07004,0xc255b00b}},	//   _tempatan_, _ibyabaye_, _médio_, _རྒྱལ__བཞི_,
   {{0xd443a010,0x33f40007,0xd3a2301c,0xa9f6602c}},	//   _sep_, _jestli_, _dampak_, _verán_,
   {{0x54b26014,0x0c773003,0x1292701c,0xcf7ee022}},	//   _non__se_, _kwisebe_, _wisata_, _de__presenta,
   {{0xd2429024,0x5e731005,0x4e737005,0xeb136010}},	//   _བཅའ_, _тек_, _јер_, _los__siguient,
   {{0x64692021,0xd311b02a,0x56e8e005,0x8f735011}},	//   _bra__for_, _skal__ikke_, _манастир, _centre__ethekwin,
   {{0xc26c7007,0xb2f97010,0x00000000,0x00000000}},	//   _jenom_, _que__puede_, --, --,
   {{0x6394f004,0xd931200d,0x14700004,0x6c0a800c}},	// [140] _coisas_, _uložiť_, _sem__fio_, _छात्र__ऋण_,
   {{0x52d4900f,0x63469021,0x747ad007,0x748dd00d}},	//   _ubundi__kandi_, _eller__annen_, _nebo__si_, _ktorí__si_,
   {{0xd24e500e,0xe5922011,0xebd2e00b,0xbf6cc00b}},	//   _ཡིན_, _kulesi__sifundaz, _སོང__ཡི_, _མས__འབྲུག_,
   {{0x6bdd100c,0xe345800d,0xd477b005,0x024d000b}},	//   _यदि__आप_, _predmet_, _naseljen_ma_, _ོམས_,
   {{0x7f57500a,0xc3940004,0xe4293023,0x1461e021}},	//   _जिनगी_, _coisa_, _sempadan_, _begynne__med_,
   {{0x0e426005,0x038dc00f,0x49463030,0x196e4014}},	//   _је__за_, _ugomba__kumenya_, _målrette, _dirixent,
   {{0x0201801d,0x12927005,0x62005010,0x925a9005}},	//   _igri_, _strani_, _salir_, _kralj_,
   {{0xc7b33005,0x29d8700b,0x782a8010,0x00000000}},	//   _populaci, _ཡོད__མིའི_, _le__proporci, --,
   {{0xa387f01f,0xc368d027,0x9a3ca00a,0x927b7004}},	//   _ukuri_, _ringkas_, _लगल_, _calendár,
   {{0x40b0f005,0x4291e026,0x3f24000d,0xdc093014}},	//   _метра__површина_, _pitam_, _našej_, _tempada_,
   {{0x3a3c900a,0x99f08005,0x966f5010,0x00000000}},	//   _लेल_, _тај__начин_, _el__principi, --,
   {{0xab62900a,0xe4367011,0xb46b6004,0x23d66010}},	//   _जेतना_, _kucace__ukuthi_, _era__um_, _es__cierto_,
   {{0x62e21011,0xc20e2005,0xe4ae6021,0x77d8c013}},	//   _one__touch_, _када_, _merke__til_, _današnje_,
   {{0xd491a02a,0x13959038,0x8491a021,0x29e23005}},	//   _er__den_, _desse_, _en__mer_, _istorija_,
   {{0x40b80005,0xbb520027,0xa1e2100a,0x8bcca01e}},	//   _метара__површина_, _oleh__kerajaan_, _केकरा_, _लगी_,
   {{0x52f50014,0xb480a011,0x329da00b,0xc2de5019}},	//   _político__galego_, _uthe__uma_, _གིས__སླབ_, _as__taxas_,
   {{0x12deb00a,0xd472a033,0xb3959004,0x6346000a}},	// [150] _अउरी_, _som__den_, _nesse_, _कबहूँ_,
   {{0xeae53010,0xc27b000b,0x5a74b010,0x00000000}},	//   _siguient, _ཏོ__འབད_, _la__descarga_, --,
   {{0x8c6ac00c,0x22724024,0x025a1011,0x08d1a002}},	//   _चिट्ठा_, _ལག__ལེན_, _kahle_, _टमाटर_,
   {{0x64a82014,0x2f82e00a,0x6758400c,0xe495e010}},	//   _listaxe__de_, _उनुकर_, _और__उनका_, _lo__es_,
   {{0x3aa6700c,0xf2d8c026,0xb293100f,0xd7d9300a}},	//   _में__मदद_, _maleni_, _kanda__hano_, _रविकिशन_,
   {{0xe2e26011,0x7abbd00c,0x29a80011,0x64c5e02a}},	//   _lo__mdlali_, _चाहते__हैं_, _kwi__inthanet, _ikke__så_,
   {{0xfbf8200c,0x3317102c,0x00000000,0x00000000}},	//   _में__से_, _procede_, --, --,
   {{0x6480502a,0xa13f3033,0x89ed6038,0x553ce015}},	//   _over__de_, _anmeldel, _hovudsid, _sekirany,
   {{0xedbba005,0x43491021,0x00000000,0x00000000}},	//   _је__постао_, _ser__etter_, --, --,
   {{0x5bc3b00a,0x925a6003,0xe3329014,0x74bcd007}},	//   _आजु_, _ngolu_, _viaxe_, _jsem__si_,
   {{0x128e0011,0x7689800b,0xb877d01b,0x00000000}},	//   _ukuthi__izinto_, _སྟེ__ཡོདཔ_, _ukuhlawu, --,
   {{0x78c4e027,0x947ec021,0xfb37200b,0x72670005}},	//   _dikehend, _registre_deg_, _ཞི__གཡོག_, _децу_,
   {{0x7ed4e005,0xbefb201d,0x82131007,0x9491a019}},	//   _по_, _natjecan, _rychle_, _eu__sei_,
   {{0xd467e014,0x7a3dc00a,0xf2aa600b,0x733b900a}},	//   _aínda__que_, _हमर_, _གི__ཚོང_, _नाशपाती_,
   {{0xc236c012,0x83eae034,0xfc48e00a,0xe316701c}},	//   _ovdje_, _lufta_, _संगे_, _pribadi_,
   {{0x9bcc700b,0xd036c03f,0x83b2f021,0xcd83800d}},	//   _ཐོག__ལས_, _ubytovan, _seg__over_, _voči_,
   {{0x94975011,0x64bd5014,0x03b8500f,0xb9e2800c}},	// [160] _we__anc_, _logo__de_, _yabwiye_, _की__सहायता_,
   {{0xb6ae3005,0x94d6f01e,0xb3dfb004,0x00000000}},	//   _iznosila__stanovni, _मीडिया_, _de__duas_, --,
   {{0x4ab7f00c,0x00000000,0x00000000,0x00000000}},	//   _दिया__गया_, --, --, --,
   {{0x381fd024,0xac61b01d,0x344fd005,0xa4aa7021}},	//   _བརྩི_, _udarite_, _oznaka__sa_, _han__ble_,
   {{0x648fa014,0xca3c900a,0x030d102c,0x527ee007}},	//   _ao__sur_, _लेब_, _rematar_, _ve__věku_,
   {{0x82ffe009,0x4401c013,0xa472f011,0x24769005}},	//   _sebagian__besar_, _otkriven_, _kuzwelon_umnuz_, _процес_,
   {{0x4ccf9007,0x6e2ee005,0xfe46e00b,0x2ef38005}},	//   _opět_, _за__више_, _དང__འཁྐྲིལ_, _домаћинс_је_,
   {{0x434fc012,0xe46b2003,0xc3469021,0x00000000}},	//   _riječi_, _nantoni__na_, _eller__annet_, --,
   {{0x62d85004,0x027a300e,0xa26ce013,0xf3984011}},	//   _fale_, _དུ__ཡོད_, _aviona_, _ngenyang_ezayo_,
   {{0xe47f9021,0xef00f010,0x00000000,0x00000000}},	//   _nettsted_er_, _las__agencias_, --, --,
   {{0x5640100f,0xee644005,0x127ff026,0xb292700f}},	//   _abanyarw, _тако__да_, _neznam_, _burayi_,
   {{0xa2d8501b,0xb3cf5010,0x733a5004,0xf47e1005}},	//   _zale_, _llevar_, _não__precisa_, _широм_,
   {{0x22b9c023,0x0bc3800c,0x52c67011,0xc2bb000b}},	//   _dibahagi_kepada_, _रही__है_, _helen__zille_, _ོད__འབད_,
   {{0x7b8e4002,0x1c013007,0x4bcec01a,0x55e44005}},	//   _आब_, _prostor_, _नही_, _из__књиге_,
   {{0x0086c007,0xb38b6029,0xc2d46004,0xa3120007}},	//   _nábytek_, _vært_, _jardim_, _přístroj,
   {{0xc4926021,0x27a6c00e,0x0c4f000c,0x1bfd600c}},	//   _en__av_, _འཇིག__རྟེན_, _इसके_, _प्राप्त__कर_,
   {{0xdf051021,0x0abab00c,0x00000000,0x00000000}},	// [170] _de__gjør_, _ध्यान__में_, --, --,
   {{0x4bf54024,0x0f691015,0x526d702b,0x9c3b8005}},	//   _མི__ལོ_, _sepatutn, _དང__འཆར_, _студије_,
   {{0x2bd8002b,0x2386d00d,0x1b62100c,0xf05f5004}},	//   _མཐུན__ལམ_, _dvere_, _मिलने_, _seu__navegado,
   {{0xf2ca702e,0x73ead00d,0x42127004,0x62924015}},	//   _kundi_, _preto_, _minha_, _petang_,
   {{0xc2252023,0xd442c040,0x32127004,0x9e2dc005}},	//   _tinggal__hari_, _atd_, _linha_, _крају_,
   {{0x83760011,0x7de0c026,0x69a0c026,0x1d7b3003}},	//   _isithomb_nqobile_, _zvijezde_, _zvijezda_, _kwiminya,
   {{0xc24d800e,0x7238c007,0xf04f7010,0x00000000}},	//   _བསྟན__པའི_, _něj_, _una__interfaz_, --,
   {{0xc477d012,0x03954033,0xeedd1004,0xe461f011}},	//   _gdje__je_, _nyeste_, _referênc, _thola__ukuthi_,
   {{0x2443e003,0x7213f023,0x5378600f,0x92da6004}},	//   _fet_, _perkhidm, _muganga_, _igreja_,
   {{0xd2ad9011,0xb43ab005,0x6450d010,0x00000000}},	//   _lo__mculi_, _na__mestu_, _nombre__de_, --,
   {{0x9c4f101e,0x72df101a,0x00000000,0x00000000}},	//   _उनके_, _उनकी_, --, --,
   {{0xbb5ed00a,0x16fed00a,0x7eeed00a,0x09a41005}},	//   _कहलन_, _कहला_, _कहलक_, _април_,
   {{0x9443f004,0xf32b4022,0x9ca5100f,0x59dcd005}},	//   _meu_, _se__deben_, _muri__gahunda_, _последиц,
   {{0x02e7c011,0x9fb66007,0xd2d0f026,0xc268500e}},	//   _ukuthi__kube_, _právě_, _prvi__puta_, _ནམ__མཁའ_,
   {{0xd62f200b,0xe46c3011,0xd3f63011,0x135f7026}},	//   _དགོཔ_, _kungenze_ukuthi_, _state__stars_, _filmske__uloge_,
   {{0xe2cc4011,0x8e979005,0x42cad00d,0xd3ea9013}},	//   _lolu__daba_, _године__број_, _vtedy_, _vrata_,
   {{0x03e6801a,0xc46d2010,0x00000000,0x00000000}},	// [180] _उत्तराखं, _hacer__una_, --, --,
   {{0xfccf9007,0x925a9014,0x5b98f00c,0xb499e005}},	//   _zpět_, _trala_, _एक__या_, _породице_,
   {{0x64c10014,0x0ba2000e,0xc4805010,0x00000000}},	//   _parroqui_de_, _བྱུང__བར_, _basada__en_, --,
   {{0x02f8e015,0x7290a01c,0x0c0ee00b,0xca9ed031}},	//   _bebas__dalam_, _kabar_, _སྐབས__ལུ_, _isixhosa_,
   {{0x738fb014,0x0443f004,0x00000000,0x00000000}},	//   _resumo__licenza_, _deu_, --, --,
   {{0x6e426005,0xd291e013,0x72df9010,0x03a74010}},	//   _је__са_, _puta_, _el__agua_, _no__podemos_,
   {{0xc249801d,0xdd2ff016,0xa491c004,0x2c6be00c}},	//   _farma_, _uživatel_, _na__web_, _प्रयास__करते_,
   {{0x39aa7005,0x222a7005,0x3d5a7005,0x8200c010}},	//   _који_, _која_, _које_, _salida_,
   {{0xf32a1023,0x82fdf00f,0x0bcae00c,0x23268010}},	//   _berkahwi_dengan_, _umugi_, _कहना__है_, _el__dinero_,
   {{0x42d87008,0x148f6010,0xdeb1c005,0x62f41005}},	//   _cane_, _de__mi_, _preduzeć, _непосред,
   {{0xa3411021,0x00000000,0x00000000,0x00000000}},	//   _det__ingen_, --, --, --,
   {{0x1c4f200c,0xe28da003,0x7badb024,0xf2df200c}},	//   _उसके_, _isikolo_, _དང__ཁང_, _उसकी_,
   {{0x32d84007,0xa2cf3005,0x3be9f00c,0x00000000}},	//   _jsme_, _osnovne_, _करें__यह_, --,
   {{0x226c3010,0x5477d012,0xf98a4007,0x3a8c6003}},	//   _mejor_, _gdje__se_, _země_, _kwinkqub,
   {{0x4f72b014,0x0302b014,0x2c7f700c,0x00000000}},	//   _árbores_, _árbore_, _उपयोग__करते_, --,
   {{0x726c201c,0xb7ad5014,0xe2eba030,0x29d73003}},	//   _rekor_, _obxectiv, _ovenfor_, _ngeendle,
   {{0xd2cd0026,0x237cb014,0x02a3f00b,0x00000000}},	// [190] _poznate__osobe_, _da__imaxe_, _རྒེད__འོག_, --,
   {{0xf443f004,0x6491e041,0xfbe5c00d,0x1491e02a}},	//   _seu_, _at__de_, _priestor, _er__med_,
   {{0xf442d00d,0x32b60005,0xd296e010,0xebe0d004}},	//   _ste_, _месног__становни, _el__tiempo_, _ganhar__dinheiro_,
   {{0x7466d004,0x9bbfa00b,0xa3eab003,0x52889010}},	//   _dezembro_, _བརྒྱུད__མི_, _uoct_, _un__ejemplo_,
   {{0x62d89026,0x4247500d,0xeb336010,0x00000000}},	//   _lijepo_, _nahlásiť_, _la__siguient, --,
   {{0x8335102a,0x163f000d,0xf26c4028,0x00000000}},	//   _hver__gang_, _komentár_, _hemos_, --,
   {{0xfbc3500a,0x847c3002,0x93f8c011,0x00000000}},	//   _कबो_, _देवनागरी_, _edlule_, --,
   {{0xe237002e,0xe2e21003,0xf29db00e,0x22b4d003}},	//   _amajwi_, _uqinisek_ukuba_, _བྱེད__མཁན_, _udec_,
   {{0xd349f00f,0x7bfd700b,0xafe6f00d,0xbb2e5010}},	//   _gisenyi_, _ཚུ__ཡང_, _svoje__vlastné_, _las__herramie,
   {{0xd2ca5038,0x33874010,0x926d8014,0xcde4d00e}},	//   _halde_, _suerte_, _deron_, _བྱེད__སྐབས_,
   {{0xf752d005,0xef1bf004,0x6de63021,0x9a59700c}},	//   _референц, _olá_, _et__nettsted_, _कि__लोग_,
   {{0x3cb81007,0x0b97a00d,0x54a76010,0x00000000}},	//   _odpovědi_, _zdieľať_, _el__objetivo_, --,
   {{0xb29e300e,0x434d3021,0x9fd68005,0x00000000}},	//   _བྱེད__ཀྱི_, _forskjel_typer_, _квалифик, --,
   {{0x161dc003,0x24bbe021,0xe30ba023,0xc46be011}},	//   _izalathi, _ditt__og_, _membiak_, _eneminya_engu_,
   {{0xbf5e9014,0x9285100f,0xd2f9f004,0x32919004}},	//   _campiona, _inshuro_, _nenhuma_, _essas_,
   {{0x1eb14010,0x14138023,0x5eff4019,0x8dfd6004}},	//   _importan, _kristian_, _os__clientes_, _ser__encontra,
   {{0x5cdae00d,0x2eacf005,0x24afe021,0x00000000}},	// [1a0] _katalóg_, _тога__је_, _mat__og_, --,
   {{0x52fa8011,0x80eeb024,0x034c9011,0x00000000}},	//   _eastern__cape_, _བཟོ__གྲྭ_, _kufanele__kube_, --,
   {{0x2ef4d005,0x73ea1006,0xd985600d,0x00000000}},	//   _које__је_, _tahta_, _môžete__použiť_, --,
   {{0x04202006,0x824d8009,0x0279f005,0xa9f66004}},	//   _pada__saat_, _di__bagian_, _orbite__iznosi_, _serão_,
   {{0xb6984005,0x145c5007,0x00000000,0x00000000}},	//   _gustina__stanovni, _mohou__mít_, --, --,
   {{0x4478b019,0xaa40100c,0x1c11500c,0x00000000}},	//   _particip_da_, _की__कुछ_, _वाली__एक_, --,
   {{0x9bd3400b,0xe2ca9005,0xf48fe028,0x4243000a}},	//   _འབད__མི_, _gradu_, _ee__uu_, _अगिला_,
   {{0xd32d402a,0x63f89023,0x6c770005,0x00000000}},	//   _vi__ikke_, _hujung_, _оних_, --,
   {{0x32ade00b,0xe473d011,0x1bf3400b,0x00000000}},	//   _ོང__ཁའི_, _ngayo__le_, _ངས__ཇི_, --,
   {{0x444fe005,0xc4bf9021,0xd3791023,0xd0b4400a}},	//   _je__otkriven_, _versjone_av_, _bapanya_, _अंगुरी_,
   {{0x34548033,0x64b4d019,0xeb37a00e,0xf2d9a013}},	//   _med__dette_, _plano__de_, _མི__འདུག_, _uspeo_,
   {{0x027f703b,0x29dbd005,0x76be500d,0xa1dfc00a}},	//   _spania_, _су__дати_, _súťaž_, _इनार_,
   {{0xc42f0005,0x92cbf01c,0x335c300a,0xaebb2013}},	//   _grad__okrugu_, _studi_, _रहेला_, _energije_,
   {{0x5eced005,0x82856011,0x3c72d00e,0x00000000}},	//   _преко_, _esikhund_sakhe_, _བཅུའི_, --,
   {{0x43c05016,0x57a7b00e,0x67d0c005,0x0291500b}},	//   _प्रस्तुत_, _པར__བྱེད_, _много_, _འབདཝ__ཨིན_,
   {{0x8201a01d,0x02fd4002,0x8e9fb014,0xa32cb011}},	//   _ispis_, _ससुरा_, _tódolos_, _fanelesi_bengu_,
   {{0x83f86007,0x3a3ec00a,0x3aea101d,0x0f005010}},	// [1b0] _jsou_, _नहि_, _vjerojat, _análisis_,
   {{0x0439302a,0x3c80c00c,0x00000000,0x00000000}},	//   _en__gratis_, _कैसे__करें_, --, --,
   {{0x82242038,0x6c89500e,0xc3da802a,0xade1000e}},	//   _fekk_, _རྒྱ__མཚོའི_, _du__være_, _པའི__ལྕགས_,
   {{0x82b8b014,0xb3d1e02a,0x4149900d,0x4fd21005}},	//   _foi__unha_, _de__andre_, _ľahko__použiteľ, _војска_,
   {{0xf3137009,0x8e6ec023,0xf3d48032,0xd24e600e}},	//   _berbeda__dengan_, _peluru__berpandu_, _as__regras_, _ལྡེ_,
   {{0x32d8b010,0x1417b00f,0x00000000,0x00000000}},	//   _hace_, _ibicuruz_byawe_, --, --,
   {{0x3da90009,0x97319026,0xd3206010,0x73a41013}},	//   _fasilita, _vjerujem_, _apoyo_, _finansij,
   {{0x4200c01d,0x0c84d00c,0x42d4600f,0x0bb5b00c}},	//   _palica_, _किए__जाने_, _bigomba_, _सामग्री__को_,
   {{0x22d91003,0xd48ff014,0xb181b007,0x4b0a4005}},	//   _uncedo_, _as__que_, _nákupní_, _насељено,
   {{0x04920021,0xa260600e,0x1dcde00e,0xd3805005}},	//   _av__det_, _སྲོང__བཙན_, _གདན__དྲངས_, _ostrvo_,
   {{0x63a2d023,0x6cdfd00e,0x55f52004,0xc42b200d}},	//   _eropah_, _བལྟས_, _diferenç, _to__urobiť_,
   {{0xa2da600f,0x44bbd005,0x830f7023,0xd2af1018}},	//   _kureba_, _uspeo__da_, _berbeza_, _བྱ__བའི_,
   {{0x024ed00b,0x1316000f,0x4b882024,0x6b280021}},	//   _ཨིན_, _bwiza_, _ཨམ_, _webadres,
   {{0x0bb28003,0x646e000b,0x00000000,0x00000000}},	//   _kunye__nokwenza_, _ནུག__རྒྱལ_, --, --,
   {{0xc3fb802a,0xa26c100d,0x00000000,0x00000000}},	//   _vil__være_, _dlho_, --, --,
   {{0xa3eb9005,0xc4622027,0xed199030,0x86ec000c}},	//   _vrste_, _dibenark, _tjeneste_, _में__सुधार_,
   {{0x2e6ac005,0x8224203b,0x726c5019,0xa27a8024}},	// [1c0] _промене__броја_, _vekk_, _pelos_, _ལས__འདི_,
   {{0x7291f028,0x6288900b,0xa1eb300d,0x32d8a030}},	//   _agua_, _འབད__དགོ_, _obchodné_, _visning_,
   {{0xad28c038,0xa2c04003,0xb4adf021,0xf492102a}},	//   _liknande_, _oku__kuya_, _for__mye_, _er__jeg_,
   {{0x54ba1014,0xfa45f00f,0x33075010,0x2bc7200c}},	//   _tamén__se_, _gukemura_, _que__hace_, _संभव__हो_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x04b3002a,0x5dc8e00f,0xb2640010,0xf473102a}},	//   _til__det_, _inshinga, _empleo_, _som__jeg_,
   {{0x4adcb014,0xb32f8004,0xb6d32005,0x00000000}},	//   _descoñec, _um__site_, _послова_, --,
   {{0xf3a42026,0xda142022,0x0ba0900c,0x12aae017}},	//   _financij, _financie, _आवश्यक__है_, _oficialm,
   {{0x43db7023,0x3263d024,0xb3bfa019,0x83eb9014}},	//   _komuniti_, _ཁབ__གཞན_, _para__usar_, _xusto_,
   {{0x3a3df01e,0xc3216028,0xe2cfc007,0x77960013}},	//   _साथ_, _gracias_, _kancelář, _predstav,
   {{0x19f57004,0xb2de200d,0xfbfcd00b,0xe4b7000d}},	//   _praça_, _okrem__toho_, _ིས__དང_, _určené__na_,
   {{0xa4420029,0xe4048027,0x0dddf003,0xd452a021}},	//   _cgi_, _tinggi__untuk_, _iinkcuka, _har__blitt_,
   {{0x5b60701b,0x546ce00f,0x27374005,0x45a90007}},	//   _septemba_, _hamwe__no_, _heroji__jugoslav, _formulář_,
   {{0x54444026,0x5307f015,0x5eb68016,0xd2f2501b}},	//   _ce_, _pulau__pinang_, _zobrazit_, _iingxaki_,
   {{0xb3f9e01b,0x1e19d005,0x0a3a5007,0x329c000e}},	//   _mntu_, _београд_, _které__mají_, _མདོ__ཁམས_,
   {{0xd2494010,0x2e7ad005,0x0357a003,0x0bbbf00c}},	//   _tiempo_, _граду__је_, _intaneth_kunye_, _हुई__है_,
   {{0xc2ab3023,0xe1e2900a,0xe4424019,0xe467e02a}},	// [1d0] _belajar__jika_, _जेकरा_, _num_, _dag__er_,
   {{0x84083011,0x5be1600d,0xc7eb9023,0x338f200d}},	//   _kusho__unksz_, _navigáci, _walaubag, _ľudí__ktorí_,
   {{0xa2aa102b,0xf3292026,0x6bd2f00e,0xb9f58004}},	//   _གི__དོན_, _živjeti_, _ཐོག__ཏུ_, _pará_,
   {{0xb2d9e028,0x625a4038,0x54049003,0xd4b15004}},	//   _ante_, _samla_, _ngenxa__yokuba_, _inscriçõ,
   {{0x0298b00b,0x926e7005,0x00000000,0x00000000}},	//   _འདི__གིས_, _evropi_, --, --,
   {{0xee42a005,0xe1eb3007,0x0bad400b,0xd409500f}},	//   _је__пад_, _obchodní_, _ཁབ__ནང_, _amagambo_,
   {{0xba3e201a,0xbf24000d,0x33511014,0x500d2005}},	//   _मां_, _vašej_, _fosfato_, _природно_,
   {{0xb4307023,0x93423014,0xe4553004,0x00000000}},	//   _mana__satu_, _goberno_, _disponív_na_, --,
   {{0xc202600f,0x4e1e1005,0x00000000,0x00000000}},	//   _kiriya_, _приликом_, --, --,
   {{0x115fa003,0x2b66a01b,0x01bea01a,0x13920011}},	//   _ezigcwal, _ngethuba_, _घायल_, _noma__ngubani_,
   {{0xf27ed02f,0xc5cb4004,0xba1e1005,0xbdce1005}},	//   _zmena_, _de__informaç, _чини_, _чине_,
   {{0x2290f038,0xbbad700b,0x00000000,0x00000000}},	//   _dagar_, _ཅན__ཚུ_, --, --,
   {{0xbaf7801d,0x1b2f9018,0x4eb8e005,0x5290f019}},	//   _rebubble, _ཕྲེང_, _ли_, _vagas_,
   {{0x63b61011,0xaca37011,0x7be2600b,0xdf82c005}},	//   _music__awards_, _isinqumo__sokuthi_, _དྲུང__ངག_, _сваки_,
   {{0x7200901d,0xbc682010,0xf2d87012,0x12df400a}},	//   _jajima_, _febrero_, _usne_, _आउरी_,
   {{0x2200b007,0x1a5db02a,0xe5d9500f,0xeba0a00c}},	//   _chci_, _det__også_, _ikintu__icyaricy, _ऋण__के_,
   {{0x4272900d,0xc380601d,0x96183005,0x00000000}},	// [1e0] _jún_, _blurst_, _је__учествов, --,
   {{0x1a52000f,0xc862c003,0xbb93d00c,0xcdb5800b}},	//   _birebana_, _ezintand, _समय__पर_, _དེ__གཞིས_,
   {{0xab9ab018,0x2bbb100c,0x1eff6010,0x00000000}},	//   _ཟིན__ཐོ_, _अपने__घर_, _la__importan, --,
   {{0xe291901c,0x23f98005,0x5647700b,0xccb96004}},	//   _pasal_, _okrug_, _ཟེར__བཤདཔ_, _um__pequeno_,
   {{0x0e0f0028,0x00000000,0x00000000,0x00000000}},	//   _disfruta, --, --, --,
   {{0xee426005,0x94a0702a,0x04a52021,0xdb0d0014}},	//   _је__да_, _og__få_, _akkurat__som_, _edicións_,
   {{0x1d8fd00e,0xb2729010,0x76c90007,0x00000000}},	//   _དྲངས_, _aún_, _součástí_, --,
   {{0xebc0a00c,0x7a4c000c,0xb994c00d,0x2ebb4005}},	//   _करने__के_, _के__रूप_, _môže_, _иако__је_,
   {{0x15ad3003,0x9213f023,0x0a71100c,0x92f39005}},	//   _qhagamsh, _berkhidm, _वर्ष__में_, _годину_,
   {{0x3fb45005,0xb2783007,0x57093005,0x30893005}},	//   _друге__стране_, _stejně__jako_, _велики_, _велика_,
   {{0xae1ff032,0xfb8b000c,0x00000000,0x00000000}},	//   _após_, _बहुत__आसान_, --, --,
   {{0xf3519015,0x928d6006,0x0bdd800b,0x02254003}},	//   _anda__hanya_, _ibukota_, _འདི__ལུ_, _ifeksi_,
   {{0x4201e02e,0x34669021,0x9dd8100b,0x00000000}},	//   _kiti_, _bedre__enn_, _གཉེན__སྦྱོར_, --,
   {{0x3226701c,0x00000000,0x00000000,0x00000000}},	//   _berkas_, --, --, --,
   {{0x7291600f,0xc2915011,0x197e2005,0x932d200d}},	//   _magana_, _bafana_, _група_, _odoslať_,
   {{0x1cc5d023,0x1e9c0010,0x00000000,0x00000000}},	//   _koleksi__rujukan_, _intelige_emociona, --, --,
   {{0xe2e9c014,0xe3bb2011,0xe27a702b,0xd520200c}},	// [1f0] _as__dúas_, _kulo__mkhakha_, _ལས__སྡེ_, _की__घोषणा_,
   {{0x0f237021,0x34a0702a,0x7201e005,0x852df01b}},	//   _kan__gjøre_, _og__på_, _niti_, _amanyath,
   {{0x8ef28010,0x0292c00d,0x79c17004,0x00000000}},	//   _los__niños_, _ako__rokov_, _de__atendime, --,
   {{0x32771011,0x1be7200c,0xb9f4e004,0x7dde6005}},	//   _iningizi_afrika_, _और__एक_, _união_, _да__му_,
   {{0x34425004,0x44a01015,0x9291e00f,0xc338a040}},	//   _sul_, _rencana__ini_, _bita_, _zdraví_,
   {{0xa31e9015,0xa291e028,0x58f70021,0xe382e014}},	//   _biasa__yang_, _cita_, _som__innehold, _quizais_,
   {{0x4291100f,0xe7b8900f,0x3994d00d,0x54c13011}},	//   _gacaca_, _repubuli, _môžu_, _africa__cup_,
   {{0xea3e702d,0xaf4f900f,0x641b500b,0xe25c700b}},	//   _भाव_, _ubushaka, _ལུ__རྒྱལ_, _གྲོས__གནང_,
   {{0xab9b400e,0x2fad2011,0x00000000,0x00000000}},	//   _ཡིན__དེ_, _lo__mhlangan, --, --,
   {{0xc2918023,0x675d100c,0x00000000,0x00000000}},	//   _barah_, _पर__आपका_, --, --,
   {{0x14945005,0xf81c8005,0x02e8e003,0x3b46502b}},	//   _visini__od_, _слика__слика_, _kwaye__uthenge_, _ཁྲིམས__སྲུང_,
   {{0xc3007038,0x2eed4005,0x5e990005,0x6df9500e}},	//   _samband_, _насељено_је_, _килограм_космос_, _པོ__རྣམས_,
   {{0x3e72e005,0x03071011,0xf3147004,0x00000000}},	//   _ме_, _kuleli__zinga_, _de__suporte_, --,
   {{0xb4b65021,0xa09d800e,0x1f072004,0x5c19401d}},	//   _etter__at_, _སྨྲ_, _disponív, _mozgalic,
   {{0x63fa1003,0xcb8e702b,0xaa6d0004,0x6095500c}},	//   _kuquka_, _ཉས_, _aqui__está_, _अपने__लक्ष्य_,
   {{0xf3658003,0x22c3f005,0xbf4ea00b,0x0bfbf00c}},	//   _imigaqo_, _користи_, _ཡོདཔ__འབྲུག_, _ठीक__है_,
   {{0x5bc3501e,0x42918023,0x304fd007,0x4ec73005}},	// [200] _कभी_, _zarah_, _šíření_, _земљи_,
   {{0xc4427030,0xec4e000a,0x7bd3a00b,0x140e900f}},	//   _kun_, _काहे_, _འཐབ__ནི_, _ubugingo_,
   {{0x3337902a,0x6c3b700d,0x6f73200d,0xbbad700b}},	//   _hvor__mange_, _súhlasu_, _na__vašom_, _ཁབ__ཚུ_,
   {{0x2bccc00a,0xa291e02f,0x227b402b,0x1deb5004}},	//   _एगो_, _sita_, _ལས__རིམ_, _municípi,
   {{0xb4b15004,0xd415102a,0x00000000,0x00000000}},	//   _descriçã, _du__virkelig_, --, --,
   {{0xd2e9c014,0xf741000c,0x6cbd8010,0x00000000}},	//   _as__súas_, _प्रतीत__होता_, _la__entrada_, --,
   {{0xb2733005,0x8ec46022,0x32019023,0xee378005}},	//   _centraln_godine_, _niños_, _tasik_, _успео__да_,
   {{0x2c902011,0xe39ab007,0xd26c5010,0xd279600b}},	//   _ngemuva__kokuthi_, _města_, _ello_, _ནི__འགོ_,
   {{0x230c4037,0x24427010,0x5fc4000d,0x850d000d}},	//   _impamvu_, _aun_, _šírenie_, _prístroj,
   {{0x93ea7028,0xf3eae004,0x00000000,0x00000000}},	//   _santa_, _edital_, --, --,
   {{0x24a8100f,0x88ce4005,0x00000000,0x00000000}},	//   _ukubera__iki_, _источној_, --, --,
   {{0x56186026,0xc4ab2021,0xc6d0001b,0xd5085003}},	//   _naslovni, _kan__bli_, _ephakami, _iintloko_,
   {{0xe496e007,0xc37e2014,0xd3874007,0x3959e00c}},	//   _se__na_, _de__imaxes_, _kterou_, _सांकेतिक_,
   {{0xc340602e,0x7b2dd021,0xe3961007,0xf5119014}},	//   _yigenga_, _de__viktigst, _napsat_, _estreado_,
   {{0x93eb9022,0x7eec500d,0x7c109005,0x00000000}},	//   _gusta_, _iných_, _не__само_, --,
   {{0x12cd0003,0x72d8200f,0x527e9003,0xc256b00b}},	//   _intloko_, _yemeje_, _ujan_, _བཟུམ__གྱི_,
   {{0xa3406008,0x2cbe6003,0xef9a6010,0x00000000}},	// [210] _wigenga_, _ulwazi__malunga_, _las__palabras_, --,
   {{0x64926042,0x7355d029,0x2e9ca005,0x22b9d023}},	//   _en__de_, _nyheter_, _астероид_је_, _rujukan__bahasa_,
   {{0x825b7006,0x34bf702a,0xf31aa021,0x3342f007}},	//   _italia_, _svare__på_, _er__verdt_, _vnitřní_,
   {{0x5236600d,0x93f2f021,0xb46f8003,0xdc4e700c}},	//   _svoju_, _deg__selv_, _kwaye__oko_, _कमरे_,
   {{0xf2c14003,0x0291a027,0x28d6d022,0x42b07010}},	//   _uya__kuba_, _tapak_, _estrateg, _muy__bien_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6a3c901a,0xc6df300a,0xa3165007,0x6bfbc00c}},	//   _लेख_, _हल्द्वान, _nelze_, _अपने__सभी_,
   {{0xe279a00b,0xcbc2e00c,0x00000000,0x00000000}},	//   _དེ__ཅིག_, _उतना__ही_, --, --,
   {{0x5053c005,0x02899020,0x4163c005,0xcf732007}},	//   _године_, _རིག__གནས_, _година_, _na__vašem_,
   {{0xe9a5f00d,0xfde5f00d,0xd24a200b,0xc32aa02a}},	//   _diskusia_, _diskusie_, _འགྲུལ__བསྐྱོདཔ_, _og__deres_,
   {{0xb045800d,0x7331e00d,0x426e9011,0x559c7004}},	//   _vyhraden, _medzinár, _kube__manje_, _uma__questão_,
   {{0x5340602e,0x925a5028,0x1c26e007,0x3e86c005}},	//   _rigenga_, _calle_, _prostě_, _график_,
   {{0x1248d007,0x5d4fb007,0x5eeda005,0x105b3003}},	//   _jsem_, _včetně_, _орбиту__око_, _ungayiqo,
   {{0x64b3602a,0x54b7402a,0x6f207006,0x00000000}},	//   _til__de_, _artikler__om_, _mendukun, --,
   {{0x04b45003,0xf4429019,0xfbcaf005,0x798e2005}},	//   _kunye__ne_, _eua_, _округу_, _бави_,
   {{0x62af300a,0xe42cb011,0xebb9600c,0x7cb97004}},	//   _अहाँ_, _qiniseka__ukuthi_, _क्षेत्र__के_, _de__energia_,
   {{0x025aa023,0x68b74005,0xe24ba014,0xd4472003}},	// [220] _majlis_, _са__додатим_, _da__serie_, _eyona__ndawo_,
   {{0x047bd021,0x5df5300d,0xebf7602c,0x84926007}},	//   _noen__som_, _pridajte_, _desemboc, _je__ve_,
   {{0x29e7000c,0xe47f6033,0x2eab7005,0x00000000}},	//   _घण्टे_, _hvor__du_, _тада__је_, --,
   {{0xa3158011,0xc48df02a,0x62da5004,0x44993004}},	//   _ku__million_, _de__nye_, _úteis_, _um__dos_,
   {{0xee1b4003,0xbd8fe00e,0x00000000,0x00000000}},	//   _iphetsha, _བྲོས_, --, --,
   {{0xf2da6010,0x568a300f,0x7a8f900e,0x54599004}},	//   _prueba_, _amajyepf, _ཀྲུང__དབྱང_, _está__se_,
   {{0xb6a2d003,0x54302011,0xb27e602b,0x00000000}},	//   _abantu__basetyhi, _inkantol_enkulu_, _རྒྱུགས__ཀྱི_, --,
   {{0x7bee100e,0x7d32500e,0x9862500f,0xd0fc700a}},	//   _མང__དུ_, _འཕེལ__རྒྱས_, _bisobanu, _बसावन_,
   {{0xc134f00e,0xddfc201d,0xd4bf9014,0x7161d006}},	//   _བར__འཁྱམས_, _sastavu__općine_, _parroqui_que_, _pengelol,
   {{0x82d9a021,0xc4429004,0x1a5eb02a,0x32ca7014}},	//   _adwords_, _rua_, _kan__også_, _cando_,
   {{0xd4429004,0x5cf1600f,0xd4b0b010,0x00000000}},	//   _sua_, _imiterer, _herramie_que_, --,
   {{0x54a0b00d,0x00000000,0x00000000,0x00000000}},	//   _sa__dá_, --, --, --,
   {{0x63ca0023,0x0f79b00e,0xee888005,0xb29cf00e}},	//   _pada__ogos_, _མི__འགྱུར_, _мислим__да_, _རྒྱུད__ཀྱི_,
   {{0x8290e00f,0x1a5e302a,0xd1f0b00b,0xd2b59013}},	//   _kanama_, _har__også_, _བསྐྱོདཔ_, _srednje_,
   {{0x0fa3c028,0xadb4f005,0x2a890023,0x62d0900b}},	//   _superior_, _али__су_, _pusingan_, _དྲག__ཤོས_,
   {{0x73869034,0x5231702c,0x428c9005,0xec58e00c}},	//   _kvart_, _formada_, _од__тога_, _के__पहले_,
   {{0x42317015,0x7319000d,0x00000000,0x00000000}},	// [230] _bermula_, _osobných__údajov_, --, --,
   {{0x429c7005,0xa3696004,0x7cd14003,0x3c64a007}},	//   _drugo__kolo_, _viagens_, _ngokungq, _situace_,
   {{0xf2d92003,0x5474d004,0xb2baf00b,0x00000000}},	//   _yaye_, _torna__se_, _ཁྐྲིམས__ཀྱི_, --,
   {{0x22c7b00c,0x00000000,0x00000000,0x00000000}},	//   _है__जहाँ_, --, --, --,
   {{0x6a3c501c,0xf303000f,0x1b9e900c,0x74ba500d}},	//   _आता_, _birashob_kuba_, _पास__एक_, _kúpte__si_,
   {{0x0b20b004,0x92b7c011,0xea475005,0xac30c005}},	//   _campanha_, _uvela__shembe_, _ситуациј, _испред_,
   {{0xc20ce023,0x73409021,0x773de007,0xe4645011}},	//   _tujuan__kami_, _enheten_, _se__speciali, _kungakha_ukuthi_,
   {{0xe2de300a,0x826c9035,0x23227004,0x00000000}},	//   _चाही_, _inkosi_, _da__pele_, --,
   {{0x63214005,0x137a6023,0xd4907043,0x6b9c200c}},	//   _насељено__мјесто_, _rawatan_, _el__que_, _अब__भी_,
   {{0xf442603a,0xa2e20010,0x0f3f801d,0xddae3023}},	//   _ego_, _calidad_, _ulogiran, _mengikut_,
   {{0xfa4f500c,0x326cd01b,0xe38c3005,0x74573007}},	//   _का__चयन_, _kaloku_, _буде_, _představ_si_,
   {{0x92925038,0x24aee021,0x00000000,0x00000000}},	//   _snakkar_, _laste__ned_, --, --,
   {{0x1f131005,0xbca3200c,0x8429a011,0x332c7010}},	//   _opština__južnoj_, _तो__अपने_, _ungizwe__mchunu_, _los__equipos_,
   {{0xd2da7014,0x2ed14005,0x00000000,0x00000000}},	//   _da__illa_, _авион__је_, --, --,
   {{0x84278007,0x233a7007,0xec04100c,0x00000000}},	//   _zde__jsou_, _xml__nahoře_, _जानने__के_, --,
   {{0x6378100f,0xd6ffd00c,0xa25a7014,0x00000000}},	//   _rubanda_, _इसका_, _canle_, --,
   {{0x327e0017,0xb184e011,0xb712a014,0xa258800b}},	// [240] _reino_, _umnyango__wezempil, _dispoñib, _དམིགས__དོན_,
   {{0xbb300003,0x49f4e004,0xb401b010,0xebaca00c}},	//   _uqhagams, _dança_, _con__más_, _यात्रा__के_,
   {{0xb201800f,0x14bd0014,0x83417011,0xcbf7d02b}},	//   _ibyiza_, _proxecto_, _ngoba__vele_, _ངོ__ཚབ_,
   {{0xb381503d,0xac50900c,0x7419f010,0xfba0a00c}},	//   _kwazulu_, _बात__नहीं_, _de__nuevo_, _एक__से_,
   {{0x494b6034,0xc3959004,0xcbd69003,0xef3b0005}},	//   _minorite, _nossa_, _ngexabis, _није__био_,
   {{0x3afdf030,0xf22a2005,0x39fb8011,0x9fe5d004}},	//   _prosjekt, _кога_, _isithomb_sithunye, _de__dívidas_,
   {{0x5215a007,0xeaff2003,0xa49ed004,0x00000000}},	//   _oddělení_, _ezisetye, _você__vai_, --,
   {{0xb297f003,0x6e95b005,0x05000005,0x34465011}},	//   _ingqalel, _ознака__са_, _није__било_, _khona__kodwa_,
   {{0xa3e2a003,0x5ddbc00d,0x52cb0014,0xc4192004}},	//   _ka__agasti_, _základe_, _acadar_, _uma__parte_,
   {{0x5242902b,0x4d8a300e,0x54698007,0x12ec0005}},	//   _དཔར_, _སྤངས_, _může__se_, _углавном_,
   {{0x21dfe00a,0x3492a02a,0x5429c027,0xe44cd007}},	//   _उनकर_, _er__her_, _simpanan_, _ohledu__na_,
   {{0xf87cc005,0x00000000,0x00000000,0x00000000}},	//   _поставље, --, --, --,
   {{0x0b8eb00b,0x34523021,0x74424004,0xfbdff00d}},	//   _ིས_, _den__siste_, _mim_, _aplikáci,
   {{0x72cb8034,0x8492a021,0x3c80400c,0x00000000}},	//   _nord_, _er__mer_, _उपयोग__करें_, --,
   {{0xe25a5038,0x64714019,0x00000000,0x00000000}},	//   _kalla_, _ferramen_de_, --, --,
   {{0xc468e021,0x3df2a00d,0x73338014,0x00000000}},	//   _deg__en_, _aj__keď_, _virxe_, --,
   {{0xb278e00f,0x5a51a011,0xc2a7a00e,0x394df00c}},	// [250] _miliyoni_, _mayelana_, _རྫོགས__པའི_, _हमारी__साइट_,
   {{0xe46cb021,0x0d73d005,0xe499a00d,0x00000000}},	//   _gjøre__er_, _територи, _dôležité__aby_, --,
   {{0xab88500e,0xd200c023,0x00000000,0x00000000}},	//   _རྨ_, _talian_, --, --,
   {{0xe496e010,0x23478004,0xc4736007,0x00000000}},	//   _no__es_, _começa_, _zde__je_, --,
   {{0xd442c038,0xa444f003,0x12921013,0xdbf5900e}},	//   _aud_, _yiyo__loo_, _nosač_, _ཆུ__བོ_,
   {{0x2c67c003,0x5332900f,0xd75f800b,0x3d838005}},	//   _malunga_, _cyane__kandi_, _ནང__བཀོད_, _tiče_,
   {{0x04424004,0xe0bbd007,0x8ec46014,0xa706e00c}},	//   _fim_, _hvězdičk, _liñas_, _बना__दिया_,
   {{0x6bab800c,0xe3eb701d,0xc26db013,0xbc4db00a}},	//   _कि__वह_, _svatko_, _govori_, _खइले_,
   {{0x13dfd02a,0x924d800e,0xf2d91005,0xe2a8b00b}},	//   _de__fleste_, _སྨད_, _tabeli_, _ངས__ཞིབ_,
   {{0x82711006,0xbb61700d,0x1ce47011,0x00000000}},	//   _mulai__dari_, _bystrica_, _izinsolo__zokuthi_, --,
   {{0xcc4e8044,0x3442c045,0xd9fc2003,0x6a4ad004}},	//   _जाते_, _gud_, _umgangat, _do__pagament,
   {{0x5291e015,0xe6fff01a,0xcc84d00c,0xa44a6004}},	//   _watak_, _उसका_, _किए__जाते_, _artigo__how_,
   {{0x6442d010,0xf23ca011,0x00000000,0x00000000}},	//   _jue_, _kulo__muzi_, --, --,
   {{0xa290f023,0x9a475004,0xabd70004,0x298e1005}},	//   _sahaja_, _se__você_, _se__transfor, _затим_,
   {{0xa2b9202d,0x1498000d,0x92d89026,0x7273100d}},	//   _मीनू_, _to__čo_, _cijelo_, _ján_,
   {{0xf3ce0013,0xa24e500e,0xab58b00e,0x84903004}},	//   _živi_, _རྨང_, _ནས__བྱུང_, _do__dia_,
   {{0x94985011,0xb291b00d,0x2a1e7005,0xa7d5c00e}},	// [260] _ye__anc_, _tovaru_, _бити_, _བཀག__བཙོན_,
   {{0xd4424019,0x8354100d,0xa2c1c014,0xf0319007}},	//   _sim_, _všetky_, _coa__súa_, _předchoz,
   {{0xf7e7a00a,0xe492a02a,0x82bbb018,0xf2a4e00f}},	//   _पुखराज_, _du__ser_, _མེ__ཏོག_, _amabanki_,
   {{0x7b88200c,0x4f9b7005,0xcec0a003,0x00000000}},	//   _ने_, _су__насељено_, _isayinwe_, --,
   {{0x8f1be005,0xec4e800a,0x932b7010,0x00000000}},	//   _од__њих_, _जादे_, _los__juegos_, --,
   {{0x10eec02d,0xd2905007,0xf2005007,0x33205007}},	//   _गाँव_, _byla_, _byli_, _byly_,
   {{0x5285800d,0xfeaa800f,0x42bb700d,0x9e438004}},	//   _na__svoje_, _baturage_, _na__celom_, _atualiza,
   {{0x2442d010,0x2ebbc005,0x7a89900c,0x6469d022}},	//   _fue_, _како__је_, _विशेष__रूप_, _causa__de_,
   {{0x04425038,0x2ec86005,0x1c69c00d,0xc4770021}},	//   _fil_, _то__је_, _ktorým_, _innehold_en_,
   {{0x32b68011,0xdc08300f,0xb3dc601b,0x1767300c}},	//   _kube__khona_, _ikiganir, _ngowe_, _में__किया_,
   {{0xb24d800e,0x91b14005,0xd37fc017,0xf9f80014}},	//   _སྨན_, _је__такође_, _comarca_, _adestrad,
   {{0xaf1bf007,0x72890009,0x2c73700c,0x68d3800d}},	//   _stát_, _departem, _नहीं__करते_, _prispiev,
   {{0xbb5ed02d,0x7438a014,0x3318a014,0x0493e021}},	//   _कारन_, _en__canto_, _en__cando_, _på__som_,
   {{0x0242b024,0xd15fb023,0x32ea3005,0x00000000}},	//   _བཤལ_, _mengekal, _употреба_, --,
   {{0x1f945007,0xe3187003,0x1201b00d,0xbded201d}},	//   _jméno_, _zonxulum, _neviem_, _je__općina_,
   {{0xbd885007,0xb8aa8010,0xbb4ed010,0x00000000}},	//   _celém__světě_, _de__carreras_, _de__herramie, --,
   {{0x54874007,0x6be6900c,0xc299000e,0x6f49300d}},	// [270] _नेपाली_, _और__आप_, _འདོད__པའི_, _pre__vaše_,
   {{0x2dacd015,0x32d91019,0x9b3bb00e,0x12e37003}},	//   _perniaga, _recebe_, _གཡུང__དྲུང_, _welizwe_,
   {{0xb2c73038,0x8f4f301b,0xbc46b010,0xd0091004}},	//   _jødar_, _kwisikha, _de__septiemb, _de__três_,
   {{0x5d726005,0xfa920003,0x00000000,0x00000000}},	//   _да__их_, _kunyanze, --, --,
   {{0x4a3dc02d,0x935ca00c,0x2c09e02c,0xbccca00c}},	//   _सेर_, _लिए__अपनी_, _permitiu_, _लिए__अपने_,
   {{0xe2ca7038,0xd3556011,0xb480602a,0x5ccbe003}},	//   _landa_, _umnuz__james_, _over__at_, _kunye__nokunye_,
   {{0x6386d030,0xab9a8024,0xd4426013,0x2e2a1005}},	//   _hvert_, _དོན__ཚན_, _bio_, _национал,
   {{0xd4b67010,0xd47c1010,0x00000000,0x00000000}},	//   _cree__que_, _personas__que_, --, --,
   {{0x92fd5010,0xc259400e,0x86f1f004,0xa35e1036}},	//   _juegos_, _འཁྱམས__ཟིན_, _portuguê, _beograd_,
   {{0xadcb8003,0x52f66010,0x00000000,0x00000000}},	//   _kwakunye_, _buena__idea_, --, --,
   {{0x52497008,0x32ca7017,0xd3404005,0x7681a00b}},	//   _shamba_, _banda_, _nedelja_, _བྱིན__ཡོདཔ_,
   {{0x45479005,0x2e72e005,0x12de400a,0x8dafb003}},	//   _poznato__prirodno_, _је_, _गइनी_, _iintsuku_,
   {{0x2e56e005,0x3dbda004,0x1d09500e,0x741da004}},	//   _из_, _cadastre_, _ཞི__རྒོལ_, _cadastro_,
   {{0xc47df021,0x72bac007,0x3f0c900e,0xedd86005}},	//   _hundrevi_av_, _věci_, _འགྲུས_, _владавин,
   {{0xb27e6005,0xd305e011,0xf27a800d,0x647cd004}},	//   _severnoj__godine_, _lesi__sikhulu_, _sa__týka_, _loja__de_,
   {{0xe27d9011,0x2ed90014,0x52cc9004,0x00000000}},	//   _kodwa__futhi_, _nacións_, _os__alunos_, --,
   {{0x3a3df02d,0x4f750004,0x9422800f,0xf2ab8014}},	// [280] _देस_, _nascimen, _buri__kintu_, _táboa_,
   {{0x1abe800f,0x29cfe00e,0x42d9800d,0xffa54023}},	//   _amajyamb, _བྱའི_, _okrem_, _disember_,
   {{0xe5b3f007,0xd3074011,0xe200800f,0x4443a03d}},	//   _nejlepší_, _ku__sabc_, _rukiko_, _ifp_,
   {{0x1241d00c,0xd4717014,0x63eb9005,0x5be3701c}},	//   _हवाले_, _que__que_, _vrsta_, _memengar,
   {{0xd4426019,0xd466d005,0x4394e011,0xc30ca01c}},	//   _rio_, _naselje__ma_, _elisha_, _derajat_,
   {{0x12cb2023,0x72b0e011,0x626c601b,0xedf4102b}},	//   _sila__lihat_, _kuleli__qembu_, _kuloo_, _ཚོང__འབྲེལ_,
   {{0xcb8e6046,0x52590018,0xe4180011,0x759f500a}},	//   _आव_, _རྒྱ__མཚོ_, _ngiyazi__ukuthi_, _जानत_,
   {{0x759e8002,0x5290d015,0xde737005,0x846fc007}},	//   _चाहत_, _pinang_, _већ_, _tomto__webu_,
   {{0x059c6023,0x8443c02f,0xc75d200c,0x00000000}},	//   _tujuan__mewujudk, _stv_, _चिट्ठों_, --,
   {{0x32ca9016,0x7404e021,0x34b3b021,0x1f1bf014}},	//   _snad_, _vi__håper_, _vet__hva_, _agás_,
   {{0x0c754028,0x0341d02c,0xec07100c,0x00000000}},	//   _algunas_, _nomeado_, _बदलने__के_, --,
   {{0x04427034,0xe4d6f002,0x8439a02a,0x04426021}},	//   _ein_, _मुखिया_, _en__kort_, _uio_,
   {{0x64b85032,0xf2d83003,0xdc585014,0x63954013}},	//   _mecanism_de_, _iimeko_, _na__tempada_, _umesto_,
   {{0x71f1a005,0x21882005,0x8387f00f,0x9419f010}},	//   _насељено__место_, _три__пописа_, _umuziki_, _de__nueva_,
   {{0x52bac007,0x1b2f8014,0xa2e8b023,0xd30c9023}},	//   _něco_, _considér, _rejimen_, _setakat_,
   {{0x83959004,0x02de600a,0x085ff023,0x2b977013}},	//   _fosse_, _कइनी_, _dihantar_, _trenutno_,
   {{0xc48d3005,0x24b1602a,0x9be18024,0xbbbc600c}},	// [290] _primećen__je_, _tid__og_, _གཏོགས__མི_, _करने__पर_,
   {{0xf4884005,0x53dc400f,0xd468f004,0x00000000}},	//   _је__према_, _bumwe_, _coisa__que_, --,
   {{0xf279600e,0x9f263003,0x6bb6e00b,0x00000000}},	//   _དེ__ཉིད_, _ngeenjon, _ལམ__ཁར_, --,
   {{0xd268d023,0x15851007,0x7c574013,0x32c38031}},	//   _dalam__talian_, _nemůžete_, _postaje_, _mboleko_,
   {{0x5443e038,0xbdd9f00e,0xec9a8005,0x4cfdc005}},	//   _att_, _ཞེས__བརྗོད_, _трекбеко, _приче_,
   {{0x9b4b000b,0xaab0a00c,0x4bb8c024,0x00000000}},	//   _པོ__འཇིགས_, _मेरे__लिए_, _ལུ__ལོ_, --,
   {{0x1849d011,0xcc0e900c,0x00000000,0x00000000}},	//   _kusho__amaphoyi, _पहले__ही_, --, --,
   {{0xe4427029,0x69fd3019,0xdf240005,0x3724400c}},	//   _sin_, _pagament, _pošto_, _नहीं__करना_,
   {{0x9443e021,0xf4988014,0x33403010,0x00000000}},	//   _ett_, _un__ano_, _los__nombres_, --,
   {{0x9c5df005,0xa4aaf021,0x00000000,0x00000000}},	//   _prosječn_gustina_, _det__ble_, --, --,
   {{0xec4db00a,0xd3403010,0x00000000,0x00000000}},	//   _खेते_, _los__hombres_, --, --,
   {{0x53022003,0x82e3100d,0xf269a005,0x00000000}},	//   _nangona__kunjalo_, _cenník_, _седиште_, --,
   {{0x85085005,0x00000000,0x00000000,0x00000000}},	//   _другачиј, --, --, --,
   {{0xdc66501d,0x129b600e,0xa281b010,0x00000000}},	//   _lopticu_, _ཕྲེང__བཅུ_, _de__viaje_, --,
   {{0x59792007,0x9301200f,0x66b9500c,0x3bb3e00c}},	//   _století_, _imibare_, _के__बहुत_, _हैं__यह_,
   {{0xf35a8006,0xfb8d1018,0xf2d57011,0x9bd4400b}},	//   _dikenal__dengan_, _ཚོ_, _kuleli__bandla_, _འཐབ__མི_,
   {{0xd2bc9023,0x32fcd00f,0xa41dd00d,0x00000000}},	// [2a0] _ini__kerana_, _ntego_, _na__začiatku_, --,
   {{0x86128007,0xc9139015,0xf4eac00c,0xcd4eb011}},	//   _příspěvk, _merangku, _आपके__द्वारा_, _upitso__mosimane_,
   {{0xc4a88007,0x00000000,0x00000000,0x00000000}},	//   _když__je_, --, --, --,
   {{0x4499b014,0xdb8f100b,0x929f9003,0xfc0be010}},	//   _un__dos_, _ོབ_, _kuko__konke_, _tampoco_,
   {{0x94673027,0x3a3dc00a,0x0fa29023,0xc4ae2036}},	//   _apa__apa_, _सेठ_, _tahun__selepasn, _korišten__je_,
   {{0x34432010,0xbb88701e,0x1476e02a,0x3adc700d}},	//   _muy_, _ये_, _gang__med_, _vrátane_,
   {{0xcbd6f018,0xf2d9a00d,0xf251c00e,0xebda400e}},	//   _ཆེན__པོ_, _mape_, _ཡིན__ཟེར_, _བོད__ཟླ_,
   {{0xa43b0005,0xe4b6e00f,0x0d28700c,0x00000000}},	//   _stanište__vrste_, _ibikores_bya_, _की__गुणवत्ता_, --,
   {{0x67cc602a,0x4b0c6038,0xc2d99006,0x5b8f102b}},	//   _personli, _personle, _akses_, _ོས_,
   {{0x821d7009,0xd2eb303f,0x1e93a005,0x4c72800e}},	//   _menjadi__bagian_, _samozrej, _године__као_, _བློའི_,
   {{0xe2fca01c,0x6471e014,0xa290e00d,0xe6ea300e}},	//   _serikat_, _decembro__de_, _priamo_, _སྤྱན_,
   {{0xd3ce1032,0xe4b5c021,0x13214010,0xfbbfd010}},	//   _no__entanto_, _artikkel_er_, _del__cliente_, _forma__gratuita_,
   {{0xfba5b00e,0x8343b011,0x59bf5007,0x2fe4701b}},	//   _འབོར__པར_, _gugu__mqadi_, _naleznet, _kwizifun,
   {{0x1be6a00c,0xb6503010,0xe29c9014,0xe740100c}},	//   _से__एक_, _ubicació, _dúas_, _किया__जाना_,
   {{0x06405021,0xd3121028,0x0a9af003,0x72e59011}},	//   _optimali, _hombres_, _utshints, _lesi__sikole_,
   {{0xefd71007,0xc2340011,0x1e6c2005,0xd99ff021}},	//   _protože_, _ukuthi__ayikho_, _општини_, _kl__innlegge,
   {{0xdda47016,0x00000000,0x00000000,0x00000000}},	// [2b0] _reagovat_, --, --, --,
   {{0xeaa86038,0xd439b021,0x00000000,0x00000000}},	//   _innhalds, _en__post_, --, --,
   {{0xca3df01a,0x344bd005,0x126df00b,0x63291010}},	//   _दें_, _износила_, _ནང__སྦེ_, _es__usted_,
   {{0x0a63e00c,0x73aab008,0xada66005,0xe2d8c034}},	//   _वास्तव__में_, _norvege_, _што__су_, _tyder_,
   {{0x3bdb600c,0x00000000,0x00000000,0x00000000}},	//   _आप__यह_, --, --, --,
   {{0x52cac008,0x3493b021,0xd25ad005,0xc487b01e}},	//   _cndd_, _og__hva_, _čelu_, _डिजाइन_,
   {{0xfcd4b00c,0xa26b900e,0xc379a00f,0xcd7f0005}},	//   _पर__निर्भर_, _ནས__བོད_, _muhango_, _пут_,
   {{0xd3f8301b,0xb242d00c,0x73fa601d,0xb8c22005}},	//   _amaziko_, _पिछले_, _udruge_, _се__сматра_,
   {{0x54a88007,0xd490f010,0xc3967014,0x1deb000d}},	//   _když__se_, _la__que_, _cousas_, _obľúbený,
   {{0x0493002a,0x5a3e200a,0xcf1b800b,0xa2cad040}},	//   _er__det_, _नेह_, _བརྡ__འཕྲུལ_, _hned_,
   {{0xe25eb00b,0xba33100a,0x6289900b,0x5ee36016}},	//   _ལེན__འཐབ_, _चलल_, _འཐབ__དགོ_, _spokojen,
   {{0x3442b040,0x72afd00a,0x1fd37014,0x1f286004}},	//   _nic_, _इहाँ_, _relación, _mais__importan,
   {{0x0c58800c,0x0474002a,0x6a3df02d,0xca2ad00f}},	//   _के__बारे_, _som__det_, _देब_, _ya__enterine,
   {{0x685bb005,0xe41f0011,0x3b5e100a,0x584bb005}},	//   _се__налази_, _nje__ukuthi_, _गइलन_, _се__налазе_,
   {{0xe464e021,0x9bede009,0x904d0005,0x6cde7018}},	//   _tillegg__til_, _diperkir, _фотограф, _དཀྱིལ__འཁོར_,
   {{0x8ef2a005,0xf823e00e,0xf34a7010,0x00000000}},	//   _за__потребе_, _སྤྲིན_, _el__juego_, --,
   {{0xe8336005,0xa71d900c,0x22776011,0x00000000}},	// [2c0] _opština__zapadnoj_, _यहां__क्लिक_, _eqenjini_, --,
   {{0xa735d00c,0x72021013,0xc25e800b,0x00000000}},	//   _पर__क्लिक_, _popisu_, _འཇོག__འབད_, --,
   {{0xdb8c9025,0xd29c9014,0x0411e00f,0x34cd7021}},	//   _ऑफ_, _súas_, _kurubuga__rwawe_, _sett__på_,
   {{0x2497a02a,0x9f207006,0x9f1fe00f,0x8423d00f}},	//   _vi__kan_, _pendukun, _abatanga, _mugihe__kimwe_,
   {{0x6aeed010,0x02f1f00f,0x94840010,0x928ae010}},	//   _tratamie, _umuntu__umwe_, _en__efectivo_, _dos__años_,
   {{0x24770011,0x04b4002a,0x7eb1701b,0x00000000}},	//   _republic__of_, _vil__det_, _bafumane_, --,
   {{0x63dca037,0x5c49200a,0xe6022007,0xaff4a00c}},	//   _nubwo_, _धरीं_, _je__nejlepší_, _अच्छा__तरीका_,
   {{0x734ae019,0x64aed004,0x00000000,0x00000000}},	//   _que__precisa_, _dados__de_, --, --,
   {{0xf27a9011,0xc419a010,0x0bc7300c,0x00000000}},	//   _noma__yini_, _una__parte_, _संभव__है_, --,
   {{0x24930021,0x91be301e,0xc328a011,0x150d9004}},	//   _du__vet_, _केवल_, _futhi__kukhona_, _uma__seleção_,
   {{0xbb9b400c,0xa2449011,0x0c69d003,0x8b21e011}},	//   _की__जा_, _ngesikha_kusha_, _nawuphi_, _imiphume,
   {{0x0316b011,0x53fa1014,0xe4a3f021,0x92003022}},	//   _kuze__kube_, _un__grupo_, _tilgang__til_, _camino_,
   {{0x9ba8c00b,0xe44f1019,0x4268e00b,0x7795d005}},	//   _ནང__ལས_, _poderá__ser_, _ཁག__འགན_, _дужина_,
   {{0xf490a021,0x1bdef00e,0x3410d023,0xb999900d}},	//   _av__din_, _བརྟེན__ནས_, _tentera__laut_, _dosť_,
   {{0x0f01b020,0xf4e97021,0x027ba00b,0x668ac00c}},	//   _བསྡུས_, _bærbare__datamask, _ལས__ཨིན_, _को__पसंद_,
   {{0x62b8900a,0x62a8900a,0x8c88900a,0xe5de8007}},	//   _दुनू_, _दुनु_, _दुनो_, _pojišťov,
   {{0x8205a009,0x4c6bf02d,0xa499e007,0xa3eb401d}},	// [2d0] _memiliki_, _जिम्मे_, _to__co_, _sretna_,
   {{0x1b8c902d,0x705e300a,0x86fe300a,0x00000000}},	//   _गो_, _कइलस_, _कइला_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x15772003,0xa2798024,0x6496a00d,0xfbf4f00b}},	//   _osetyenz, _ནི__འདི_, _prípade__že_, _གི__གླ_,
   {{0xea3df047,0xf356a023,0x5504900f,0x22fb0031}},	//   _देत_, _telah__dicipta_, _umutungo_, _ntshona_,
   {{0xb24e5005,0xb3434006,0xc3940038,0xd2d34023}},	//   _do__godine_, _dikenal_, _riise_, _dikenali_,
   {{0xf491f00d,0x3d8fb00e,0x22341011,0x00000000}},	//   _by__ste_, _མདངས_, _walolu__phiko_, --,
   {{0x82aff048,0xf8a75019,0x00000000,0x00000000}},	//   _उहाँ_, _os__arquivos_, --, --,
   {{0xa4741003,0x438f6010,0xe2aae00b,0x00000000}},	//   _ukuya__kwi_, _el__momento_, _གི__གནང_, --,
   {{0xf4b1a049,0xb9ab101d,0xaeda6017,0x328e7011}},	//   _til__din_, _nedjelja_, _mediados_, _kodwa__ngeke_,
   {{0x22759011,0x13e41011,0x45cdd00c,0x75772003}},	//   _usho__kanje_, _imali__engango_, _हैं__परंतु_, _esetyenz,
   {{0x04b3802a,0x0786804a,0xe4671004,0x00000000}},	//   _var__det_, _ansvarli, _precisa__ser_, --,
   {{0xec899005,0x2959a014,0x00000000,0x00000000}},	//   _на__пример_, _quilómet, --, --,
   {{0xa8a65032,0xa2a0500d,0x3acfe022,0x6da8f023}},	//   _os__recursos_, _futbal_, _todavía_, _berikuta,
   {{0xda3e300a,0x4c54301b,0xd4a8100d,0x3467500d}},	//   _फेर_, _eliqinis, _predtým__ako_, _kým__sa_,
   {{0x4442d00d,0x3d97d00b,0x00000000,0x00000000}},	//   _nie_, _དངུལ__རྩིས_, --, --,
   {{0x2a12802a,0x731e1037,0x027bb024,0x4c07d00b}},	// [2e0] _på__internet, _agaciro_, _དེ__ཡོད_, _རྟགས__ལོ_,
   {{0xa2d89012,0x94708011,0xf202600f,0xf2365013}},	//   _tijelo_, _ngenyang_edlule_, _bariya_, _bolje_,
   {{0x12d99004,0x03ffa003,0x9474d00f,0xfc4db00a}},	//   _esse_, _kwiziko_, _nyuma__ya_, _ओतने_,
   {{0x92f5b011,0x246a002c,0x747c9004,0x20920004}},	//   _le__ndaba_, _falecido_, _para__ler_, _os__anúncios_,
   {{0xc0536004,0x0499e021,0xcc27d011,0xcc6a4007}},	//   _mensagen, _ut__som_, _ngaphand_kwalokho_, _kterým_,
   {{0x0b8cb01a,0xa280b00f,0x72de9011,0x8adca00e}},	//   _को_, _ubukene_, _izingane__zabo_, _འདོགས_,
   {{0x326c201f,0x029a800b,0x22d8f015,0xb63b3016}},	//   _koko_, _ཡོདཔ__ཨིན_, _hehehe_, _vyšší_,
   {{0x3dce7005,0x2269700e,0x00000000,0x00000000}},	//   _није_, _ཕྱི__རོལ_, --, --,
   {{0x92d9d008,0x52d9c034,0x5274e003,0x72cdb00e}},	//   _dawe_, _pave_, _ukususel, _ཐུགས__རྗེ_,
   {{0x97f00014,0x0d1b001d,0x64a92014,0x7a5c0035}},	//   _da__parroqui, _obiteljs_kućansta, _despois__de_, _ngomgqib,
   {{0x32798005,0x19e6e021,0xf236c009,0xebcf9005}},	//   _густина__становни, _korrektu, _produksi_, _је__имао_,
   {{0x92787007,0x626c2038,0x64bb5019,0x25c5a003}},	//   _první_, _noko_, _mais__de_, _iziphumo_,
   {{0xda33100a,0x7b9e300e,0xf2fe602f,0x0be1f00b}},	//   _चलत_, _ཡིན__ཡང_, _obchode_, _འཛིན__ིས_,
   {{0x4baa4003,0x22be600a,0x5d492005,0x22ae600a}},	//   _iinkonzo_, _केहू_, _при_, _केहु_,
   {{0x2ec77005,0x59c61021,0xa85ef019,0x24be3021}},	//   _такође__је_, _av__menneske, _forneced, _funksjon_og_,
   {{0xaacf9024,0xc493e021,0x14739021,0x6ba5a007}},	//   _ཕྱུག_, _et__av_, _begynner__med_, _přístup_,
   {{0xf444404b,0x22cb7038,0xe2eac014,0xbbde200b}},	// [2f0] _et_, _staden_, _en__dúas_, _རིམ__ཚུ_,
   {{0x5cee3005,0x00000000,0x00000000,0x00000000}},	//   _пред_, --, --, --,
   {{0xc498e014,0x555d801b,0xf26d6026,0xf5cd300f}},	//   _ou__en_, _uvavanyo_, _pogodi_, _gufatany,
   {{0xfa3e500a,0xe291000f,0x00000000,0x00000000}},	//   _भइल_, _kubaho_, --, --,
   {{0xc442d02f,0x53454013,0x77a54036,0x7e71900a}},	//   _vie_, _naselje_, _naseljav, _काल्ह_,
   {{0xc4b1301d,0xc2129040,0x15924003,0x00000000}},	//   _također__je_, _prahy_, _zoqeqesh, --,
   {{0xa442d02f,0xa2bc4005,0x4248f035,0x00000000}},	//   _tie_, _planete__zemlje_, _mcimbi_, --,
   {{0x424e5018,0xbbda900b,0x4baa401b,0xdd91000b}},	//   _ལྟར_, _གསལ__ོན_, _yinkonzo_, _ཚུགསཔ_,
   {{0x86ff500a,0xb46ae00d,0xe292402b,0xdb9a800e}},	//   _जाला_, _ako__to_, _བཀོད__གནང_, _པར__གསུངས_,
   {{0xa4651023,0x524df018,0x13299011,0x2eecd005}},	//   _daripada__semua_, _སྟག_, _engu__ubudala_, _ово__је_,
   {{0xa3959004,0xa0189007,0x83eae00f,0xabdc400e}},	//   _nosso_, _přísluše, _cyitwa_, _རེད__དེ_,
   {{0x17a09007,0x735aa003,0xc3b7a005,0xfc491005}},	//   _podmínky_, _kunye__nezinto_, _градић_, _месног_,
   {{0xf2fcd010,0xf47c9032,0x434fa021,0x0abfc00c}},	//   _juego_, _para__ter_, _så__lenge_, _बाज़ार__में_,
   {{0xb9ffc014,0xd315a01d,0xe394b02a,0x08a18007}},	//   _véxase__tamén_, _hrvatsko_dijelu_, _et__produkt_, _různých_,
   {{0x12fcd010,0x32a6401c,0xdda9f023,0x20ea500d}},	//   _luego_, _lomba_, _setiausa, _oprávnen,
   {{0x33436004,0x8bcc400a,0x629fc011,0xcbdd9018}},	//   _governo_, _आके_, _ukuthi__laba_, _མགོན__པོ_,
   {{0xfab82005,0x93f96017,0x00000000,0x00000000}},	// [300] _privreda_, _seguiu_, --, --,
   {{0xbc4e600a,0x00000000,0x00000000,0x00000000}},	//   _कइले_, --, --, --,
   {{0x1471a022,0x748f5007,0x1243f011,0x00000000}},	//   _contacto__con_, _který__si_, _nethimba__lakhe_, --,
   {{0x8a33100a,0x8c380011,0x83066011,0x52a2a02b}},	//   _चलि_, _kwezinye__izindawo_, _ukuze__akwazi_, _འདི__འཛམ_,
   {{0x540d301c,0x0a3e502d,0x5c90400c,0x00000000}},	//   _menyatak_bahwa_, _भेल_, _वेदों_, --,
   {{0x0ccf9020,0x1d8f900e,0xee08c005,0x00000000}},	//   _ཕྱིར_, _ཕྱིས_, _фебруар_, --,
   {{0x2edf4005,0x674ed005,0x7aa0500c,0x38eb300c}},	//   _је__главни_, _цркве_, _देखते__हैं_, _यह__साइट_,
   {{0x23ea1014,0x8bfe101b,0x00000000,0x00000000}},	//   _os__dous_, _kwindawo_, --, --,
   {{0x4277300e,0x442d8015,0xa386501f,0xf93f501a}},	//   _ཇི__ལྟར_, _merupaka_tahun_, _fdlr_, _जांच_,
   {{0x7ab81007,0x6a33100a,0xc2de7010,0xefe10005}},	//   _odpověď_, _चलऽ_, _ha__estado_, _свој_,
   {{0xb4b12011,0xebd4200b,0x27ec0024,0xd6d7d005}},	//   _njalo__uma_, _བོང__ཀུ_, _གཞི__རྟེན_, _орбите_,
   {{0xa307e040,0xf471b019,0x326fa011,0x72c9300b}},	//   _vedení_, _nos__eua_, _abaningi_, _མཚམས__བྲག_,
   {{0xda3e600a,0x4ba4500e,0x0ea18035,0x5a5e1014}},	//   _बेर_, _རྒྱ__ཆེ_, _emhlaben, _posúen_,
   {{0xc3959004,0xebb0a00c,0x3496200d,0x221d2005}},	//   _posso_, _लोगों__के_, _keď__sa_, _датум_,
   {{0xd34c8009,0x430d2015,0x0beec02b,0x825d700e}},	//   _yang__berbeda_, _pelajar_, _ཚང__ནང_, _རྫོང__ཐོག_,
   {{0x9bdbe00b,0x531ae00f,0xe279800e,0x00000000}},	//   _བཀོད__མི_, _bimwe__mubintu_, _ནི__འདས_, --,
   {{0xabfbe00b,0x00000000,0x00000000,0x00000000}},	// [310] _མི__ོད_, --, --, --,
   {{0x6493604c,0x54438034,0x33c8a02a,0xc3066011}},	//   _na__de_, _bur_, _alle__disse_, _ukuze__ukwazi_,
   {{0xc308b011,0x1acfc02b,0x22b2200e,0x9b9b700b}},	//   _ukuthi__kukhona_, _བདོག_, _པོ__ཞེས_, _དགོད__བྲ_,
   {{0xcb7d3007,0x3bf5b00b,0x73948030,0x00000000}},	//   _finanční_, _སྤ__རོ_, _boksen_, --,
   {{0x6474602a,0xb2769005,0x92e3100d,0x00000000}},	//   _som__de_, _septembr_godine_, _denník_, --,
   {{0x437cf010,0xfc64a00f,0xe495b00d,0x00000000}},	//   _uruguay_, _werurwe_, _si__ich_, --,
   {{0xb443903e,0xb498700d,0x3ed4a011,0x4738300c}},	//   _hus_, _to__pre_, _mamelodi__sundowns_, _अनुमति__देता_,
   {{0xc1ed6002,0xbcb4300c,0x7af6f003,0xd3c67011}},	//   _बनारस_, _आपको__अपने_, _ukhusele, _iminyaka__eyishumi_,
   {{0xc401f02a,0xe738100e,0x00000000,0x00000000}},	//   _ikke__være_, _གཉིད_, --, --,
   {{0x659f500a,0xf33df007,0x8ef11005,0x00000000}},	//   _जाइत_, _údajů_, _смо_, --,
   {{0x726cc003,0x22c5e023,0xcc7e6010,0x2300c023}},	//   _koloni_, _ayat__anda_, _nuestro_, _terbahag_kepada_,
   {{0xa365800f,0x54791014,0xe0d1c003,0x9fd7800d}},	//   _tangazo_, _localiza__no_, _intlawul, _pretože_,
   {{0x127b7007,0xe4627021,0x82a71005,0x341a3010}},	//   _komentář, _tilbake__til_, _народа_, _que__éste_,
   {{0x3292601c,0x64b4602a,0x2fe8f01a,0x00000000}},	//   _sarana_, _vil__de_, _धड़ाधड़_, --,
   {{0xcf0d5020,0x5493604d,0x3497e00d,0xb991600d}},	//   _རྒྱུས_, _du__se_, _si__sa_, _riešenie_,
   {{0x2ed59016,0x1ba4300e,0x32903007,0x0c11f00c}},	//   _než_, _དུས__སུ_, _který__vám_, _जगह__है_,
   {{0x82dc4006,0x532a1011,0x2c33e011,0xc3862038}},	// [320] _di__dekat_, _isithomb_sandile_, _ngo__ebusuku_, _nokre_,
   {{0x8bcc600a,0x3f47800c,0xac617010,0xebba500c}},	//   _आवे_, _और__अधिक_, _alguien_, _हैं__वे_,
   {{0x54431004,0x198b400d,0xecaba010,0x6486d010}},	//   _diz_, _prečo_, _una__persona_, _imagen__de_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb26c500d,0xfceed005,0x00000000,0x00000000}},	//   _bolo_, _граду_, --, --,
   {{0x54509007,0xac9fe00e,0x6040b00c,0x00000000}},	//   _týkající__se_, _བྱོལ_, _फ़िल्म_, --,
   {{0x8248701c,0x2f1b900d,0xf79fb00e,0xe320b010}},	//   _negara__bagian_, _vaša_, _མདུན_, _precios_,
   {{0xbcc87007,0xf2d1c011,0xcc5a701b,0x00000000}},	//   _světa_, _abanye__abadlali_, _yintoni_, --,
   {{0x37eb5018,0x6bae700c,0x00000000,0x00000000}},	//   _གསལ__བཞིན_, _जिन्हें__आप_, --, --,
   {{0x9c67800f,0x3875300b,0x6b58800b,0x00000000}},	//   _gahunda_, _གསོལ__བརྩི_, _ལུ__གཞུང_, --,
   {{0x6be6100c,0xe73fc00e,0x64bc0019,0x671c100c}},	//   _से__आप_, _བདུད_, _arquivos__de_, _कि__आपका_,
   {{0x4444404e,0x573fe00e,0x54a1b007,0x0c48e002}},	//   _af_, _བྱེད_, _se__dá_, _सुने_,
   {{0x647b5005,0x234f6011,0xaa17300f,0xfa846007}},	//   _procjeni__iz_, _of__nations_, _gutahuka_, _větší_,
   {{0x04b25011,0xbba0800b,0x522a7005,0x6d5a7005}},	//   _ikickoff__com_, _འཁོར__ཚུ_, _поља_, _поље_,
   {{0x64439010,0x72d9e007,0xd386900d,0x5f25b004}},	//   _sus_, _jste_, _ktorá_, _selecion,
   {{0xb47df021,0x8b5e300a,0x101fa004,0x5453b02a}},	//   _hvor__mye_, _कइसन_, _endereço_, _det__mest_,
   {{0x22b7f01c,0xd49b5005,0x556ed004,0x41127011}},	// [330] _sebesar__jiwa_, _спољашње_, _questão_, _yenkulul,
   {{0x227c5005,0x03207003,0xbe19f009,0x3b68a00c}},	//   _iznosi__samom_, _omnye_, _menemuka, _के__समान_,
   {{0x74431007,0x4a3c602d,0xc6fe000a,0x29e0500c}},	//   _viz_, _आवत_, _ओतना_, _के__प्रयोग_,
   {{0xc26c5028,0x74439010,0x87aa6014,0x0b9db00c}},	//   _solo_, _tus_, _un__político_, _को__और_,
   {{0xf4926021,0xf304000f,0x00000000,0x00000000}},	//   _av__et_, _harashob_kuba_, --, --,
   {{0x02a3800e,0x82591011,0x00000000,0x00000000}},	//   _བཙོན__འོག_, _ukuthi__uzuma_, --, --,
   {{0x5ea6a021,0x3dfa800b,0xf2ca3004,0x0bbb300c}},	//   _fortsatt_, _འགོ__འདྲེན_, _execução_, _उपकरण__है_,
   {{0x2c43e011,0x22d92038,0x8419d00d,0x886f5019}},	//   _ngolwesi_ebusuku_, _seinare_, _nachádza, _dificuld,
   {{0x22d9e00d,0x04aa602a,0x6da15018,0x098ec013}},	//   _este_, _det__som_, _མཁྱེན_, _радио_,
   {{0x4857801c,0xc23bc014,0xfc754004,0xe407c023}},	//   _fakultas_, _que__máis_, _algumas_, _keluasan_,
   {{0xb6336005,0xc2a66032,0x33160032,0x39945007}},	//   _stanovni, _globo_, _de__vendas_, _chtěl_,
   {{0xb4b3604f,0x475d6023,0xd283d031,0x8d05b005}},	//   _til__at_, _sebilang, _okokuba_, _šaljete_,
   {{0xfb22a00b,0x2395f014,0xff64700d,0x00000000}},	//   _གཞི__བཙུགས_, _cousa_, _vo__vnútri_, --,
   {{0xc559601d,0xc4b65021,0x445ee014,0xb46d3011}},	//   _lješnjak, _grunn__av_, _maioría__dos_, _nje__uma_,
   {{0x5b884020,0xd7af800b,0x0babb00c,0x00000000}},	//   _རྟ_, _ིས__བཀོད_, _देखें__और_, --,
   {{0x93104023,0xf4b3602a,0x7b9e700e,0x5396501b}},	//   _dengan__sedaya_, _til__et_, _ལྷན__ཁང_, _omtsha_,
   {{0xd2ae5023,0x92561005,0x09dd2003,0x02de6010}},	// [340] _maklumat__lanjut_, _је__присутна_, _bemihla__ngemihla_, _el__enlace_,
   {{0x4eb58005,0xe5b1900d,0x473de004,0xe3aa2004}},	//   _једна__од_, _technoló, _agência_, _informaç_mais_,
   {{0x5a29d011,0x42f84007,0xfbda200c,0x00000000}},	//   _uma__kwenzeka_, _mimo__podnik_, _हाथ__से_, --,
   {{0xe451d036,0xc44ba010,0x00000000,0x00000000}},	//   _nalazi__na_, _tienen__una_, --, --,
   {{0xc3411023,0xbe737005,0x00000000,0x00000000}},	//   _semua__rencana_, _реч_, --, --,
   {{0x03eb9012,0xd33fc02a,0xabf51007,0x7349e015}},	//   _zasto_, _han__ikke_, _produktů_, _bererti_,
   {{0x72ddd011,0x6bd4900c,0x3ab6e00c,0x00000000}},	//   _leli__qembu_, _फिर__भी_, _सकता__हूँ_, --,
   {{0x0c0c600c,0x0272600e,0x43172011,0x9293c00b}},	//   _जाता__है_, _ཟླ__ཚེས_, _uthe__yize_, _རིམ__དུས_,
   {{0x6291c029,0x71fe2005,0x01013005,0x7a72400c}},	//   _klikker_, _кроз_, _свети_, _जाती__हैं_,
   {{0xebc1000c,0x6b5ba010,0x9efe2004,0x2732500c}},	//   _बच्चों__के_, _la__función_, _de__direitos_, _करना__होगा_,
   {{0xc2e68014,0xa2f7e00c,0xcc67e00c,0x22fc4014}},	//   _coñecida__como_, _हो__जाती_, _हो__जाते_, _dirixiu_,
   {{0x26359004,0xa46c8011,0x00000000,0x00000000}},	//   _econômic, _kusho__umnuz_, --, --,
   {{0x9bdea00b,0x00000000,0x00000000,0x00000000}},	//   _འགྱོ__མི_, --, --, --,
   {{0xf2fc7038,0xd493a02a,0x99d5d01a,0xf25ad00d}},	//   _gong_, _og__den_, _उत्पाद_, _diely_,
   {{0x8bc8d022,0x53542014,0x4d359014,0xabbc600b}},	//   _de__atención_, _comezos_, _topónimo_, _དེ__ོད_,
   {{0x929df024,0xda3c600a,0xb16fb005,0x65e2601a}},	//   _སྟོན__དུས_, _आवऽ_, _подручју_, _मानचित्र_,
   {{0x727a9011,0xa2116003,0x713ec011,0x03ac602c}},	// [350] _kulesi__sikole_, _ngakumbi_, _thuli__madonsel, _ocupou_,
   {{0xa740100c,0xc46a6021,0xc24e8010,0xb4b22004}},	//   _किया__जाता_, _bli__en_, _el__único_, _fazer__uma_,
   {{0x22da500f,0xc912f040,0x00000000,0x00000000}},	//   _intego_, _českých_, --, --,
   {{0x1291e027,0x42cad00d,0xb236601d,0x13f2601f}},	//   _bahasa__melayu_, _pred_, _ovoj_, _amashuri_,
   {{0x6b885018,0xa293f032,0x6a95c00c,0x427ed003}},	//   _ལྟ_, _de__filmes_, _अच्छी__तरह_, _njongo_,
   {{0x1243100e,0x53966011,0x8290f011,0x00000000}},	//   _ཚོས_, _omusha_, _iqhaza_, --,
   {{0x927e0038,0xcc77400f,0xc2ba6014,0xd26de004}},	//   _seint_, _cyumweru_, _en__como_, _setor_,
   {{0x424e5024,0x2fcde00d,0x52d55005,0xebf5300e}},	//   _ལྟག_, _článok_, _oktobra_, _མི__ཡི_,
   {{0xe243900e,0xc9e16011,0x00000000,0x00000000}},	//   _ཁུལ_, _endaweni__yesithat, --, --,
   {{0x3ba5800c,0xf333a014,0x2ebeb005,0x03948003}},	//   _है__जो_, _da__rexión_, _којих__је_, _yakho__kunye_,
   {{0x5a3cc002,0x8c6c400c,0x9cac400c,0x0bb5800e}},	//   _एकर_, _कि__आपके_, _कि__आपको_, _ནས__བར_,
   {{0x1dbe4005,0x0bb9800c,0x4ff6900d,0x00000000}},	//   _popisa__primećen_, _आवश्यकता__है_, _sa__používaj, --,
   {{0x6fe79007,0x3b824015,0xe28cf00e,0x4b8fc024}},	//   _svůj_, _dianggar, _ཆེན__པོས_, _ེས_,
   {{0x8f07e01c,0x4cfdd005,0x33bca00f,0xfa8a9005}},	//   _berbasis_, _последњи, _kugirang_ukore_, _августа_,
   {{0x12d4100d,0x00000000,0x00000000,0x00000000}},	//   _ľudí_, --, --, --,
   {{0x9200301d,0x1c4e600a,0xc47ed014,0xe30f6023}},	//   _uzmite_, _कइसे_, _hoxe__en_, _empayar_,
   {{0x8201601c,0xffd94004,0x5b59900a,0x225b8005}},	// [360] _bagian_, _opção_, _नीमन_, _не__могу_,
   {{0x32a3b003,0xd471f014,0x54b6e011,0xf3027011}},	//   _emva__koko_, _nos__que_, _lokhu__nje_, _leli__bandla_,
   {{0xc2d9101b,0x52e83010,0x00000000,0x00000000}},	//   _zicelo_, _su__casa_, --, --,
   {{0x910d1003,0x06d83011,0xaf8b200d,0x00000000}},	//   _kwimeko__yesiqhel, _iminyaka__emithath, _malo__byť_, --,
   {{0x0bffc00c,0xf26d0012,0x00000000,0x00000000}},	//   _होती__है_, _subota_, --, --,
   {{0x430ab011,0xf4a3700d,0x00000000,0x00000000}},	//   _emperors__palace_, _čo__ste_, --, --,
   {{0xf236600d,0x59eb500f,0xb4b8a004,0x6293f00b}},	//   _svoj_, _nyarwand, _como__uma_, _འགྱོ__དགོ_,
   {{0x6b8e401a,0x42926030,0xe261b011,0x4059800a}},	//   _आप_, _totalt_, _james__nxumalo_, _बरिस_,
   {{0xd34b5015,0xb3bb5009,0x12bbf01d,0x4498e01d}},	//   _juga__dikenali_, _juga__dikenal_, _studeni_, _pr__kr_,
   {{0x998ab00d,0x6bd3f00e,0x1479b021,0x00000000}},	//   _podľa_, _ཞིག__ཏུ_, _andre__verdensk, --,
   {{0x52d91031,0x32d8303d,0xbe0f0009,0x421c700f}},	//   _sicelo_, _kumele_, _keberada, _mushya_,
   {{0x82d06014,0xe2871011,0x92ba6004,0x00000000}},	//   _supón__unha_, _empilwen_yakhe_, _em__todo_, --,
   {{0x829e200b,0x7bb1b020,0xa3069011,0xf294700b}},	//   _རྗེ__དབང_, _ལག__ཁང_, _welamont_golden_, _འབད__རུང_,
   {{0xe22c600d,0xb97e2005,0xfd5a7005,0xd2c09010}},	//   _výmena_, _групу_, _боље_, _no__estoy_,
   {{0x6442001b,0xc4a8d021,0xa3e1b019,0xd491b004}},	//   _ezi_, _samling__av_, _as__suas_, _na__sua_,
   {{0x3a3c400a,0x1be9100e,0xc0368010,0x726cb020}},	//   _आपन_, _སྒོ__ནས_, _correo__electrón, _ནང__ཆོས_,
   {{0xa3b75023,0x7258900e,0xc2573020,0x4bfe500b}},	// [370] _menambah__koleksi_, _རྒྱ__དམར_, _དུས__དེབ_, _ོབ__ོང_,
   {{0x34a1f02a,0x83041014,0x00000000,0x00000000}},	//   _se__på_, _encóntra, --, --,
   {{0x027b300b,0x6491b010,0xda93f00c,0x00000000}},	//   _ཏེ__ཡོད_, _en__sus_, _से__ऊपर_, --,
   {{0x23869038,0xf27ec005,0x17303014,0x00000000}},	//   _kvar_, _jednu_, _iugoslav, --,
   {{0xf4ea6011,0xee405005,0x244be021,0x00000000}},	//   _okhulume_umnyango_, _почео__да_, _lastet__ned_, --,
   {{0x1ed64010,0x86b5300f,0x05729013,0x7339b032}},	//   _mientras_, _inguzany, _britansk, _ser__usado_,
   {{0x4ab2a00c,0x43cff011,0xb4c06007,0x00000000}},	//   _की__आवश्यकता_, _emuva_, _jsou__to_, --,
   {{0xc0cc9018,0x5395400d,0x6c05900c,0xf27ff003}},	//   _འཁྱམས_, _miesta_, _लिए__भी_, _ujun_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6296c00e,0x92a08011,0x8a75c004,0xf7f55024}},	//   _གཟིགས__ཕྱི_, _umengame_jacob_, _ações_, _ཀྱི__མཐུན_,
   {{0x06f9d00a,0x647d3014,0x3394b012,0xb4b3d021}},	//   _बीरा_, _externas__de_, _pjesme_, _betyr__at_,
   {{0x56998015,0x4210d026,0x4293300b,0x23280028}},	//   _yang__berkuali, _sljedeći_, _ལུགས__ཨེན_, _en__este_,
   {{0xa3317023,0x6395f004,0xe27f7040,0x53eb8005}},	//   _kelayaka_yang_, _meus_, _jedná_, _marta_,
   {{0xe2b4a00f,0xfed51005,0xd200b005,0x9b08900d}},	//   _kugirang_ubone_, _док_, _vidite_, _mobilný__telefón_,
   {{0xc2b4d00d,0x2c62b04a,0x27303005,0x7bcaa00b}},	//   _nieco_, _forrige_, _jugoslav, _བཞག__ནི_,
   {{0x331fe01d,0xc35ff013,0xdbb5900b,0x00000000}},	//   _nogometn_klub_, _njegove_, _དེ__འི_, --,
   {{0x0be4b00e,0x7b8cf00e,0x64b47004,0xb4a10007}},	// [380] _རིས__བར_, _ནན_, _categori_de_, _klepnutí_sem_,
   {{0xe3954028,0x0c51f032,0xc32fe00c,0xb2728005}},	//   _fiesta_, _santana_, _जो__किसी_, _београдс,
   {{0xdbf71018,0x64b7202a,0x39bec010,0x7bb59024}},	//   _ངོ__བོ_, _sørge__for_, _videojue, _དེ__ལག_,
   {{0xe2d0202a,0xad83a02b,0x3afa2026,0xbe7d500c}},	//   _på__denne_, _སྒྲོམ_, _razumije, _फैक्स_,
   {{0x03860038,0xd395f004,0xd2ffc02a,0xf201400f}},	//   _meir_, _deus_, _jeg__ikke_, _gifite_,
   {{0x72b1e011,0x6e89900a,0x0c0fe00c,0x8bca500c}},	//   _waleli__qembu_, _संघतिया_, _रहता__है_, _कार्ड__का_,
   {{0xc3d1200d,0x73940010,0xa454b010,0x3272b00d}},	//   _história_, _luis_, _sitios__web_, _sme__vám_,
   {{0x03eb9010,0x9e5b3009,0xe6856014,0x1028b01e}},	//   _hasta_, _perbedaa, _na__galipedi, _सुबह_,
   {{0x42240003,0x4b76000d,0x90172005,0x00000000}},	//   _iziko_, _európske, _народни_, --,
   {{0xaf1b900d,0xcbf1e007,0x0258c00b,0x1f25301b}},	//   _naša_, _spotřebi, _དབྱིན__ཚེས_, _basemzan,
   {{0xb2009005,0x6467d032,0x8a59900c,0x00000000}},	//   _knjige_, _precisa__de_, _का__लाभ_, --,
   {{0x42d9a030,0xf26cd007,0x5e2ae00d,0x34b24010}},	//   _typer_, _budou_, _na__základe_, _ser__muy_,
   {{0xa3ea7021,0xc2e7f011,0x6f253003,0xd7521007}},	//   _fant_, _ibafana__bafana_, _wasemzan, _připrave,
   {{0xb4b53011,0x6290c011,0x00000000,0x00000000}},	//   _isikhath_uma_, _nalabo_, --, --,
   {{0x7a3ce01e,0x426cb010,0xd477d012,0x9c530005}},	//   _एवं_, _poco_, _gdje__su_, _gustina_,
   {{0xf2fea00f,0x675e200f,0x0ec41014,0xac00200c}},	//   _uruhare_, _ubwiyung, _mañá_, _रखने__की_,
   {{0x3370f027,0xc4b99014,0xaf87500d,0x94aef003}},	// [390] _lapangan__terbang_, _distribu_en_, _košice_, _njl__njl_,
   {{0xc395f004,0x8d83800d,0x4ae6b01c,0x922b4007}},	//   _seus_, _nič_, _parlemen_, _někdy_,
   {{0x32b5b005,0x9b71f00f,0x5d3d2005,0x26185005}},	//   _износи__становни, _gikongor, _саставу__града_, _nasledni,
   {{0xe491e02a,0x8f300005,0x29b34011,0x1257b011}},	//   _at__du_, _пописа__примећен_, _amalungu__omphakat, _iqembu__lakhe_,
   {{0xa242b018,0x50911005,0x0bcb400b,0x00000000}},	//   _བོད_, _opština__centraln, _གནད__ཅན_, --,
   {{0x44438030,0x9f356038,0xebb5b018,0x1cfdc005}},	//   _gir_, _tilsvara, _དེ__ཡི_, _прича_,
   {{0xd38ea007,0x234ba00d,0x00000000,0x00000000}},	//   _ubytován, _xml__hore_, --, --,
   {{0x14adc004,0xd3f96010,0x13dfd02a,0x242a200f}},	//   _serviços_, _miguel_, _de__eneste_, _kugiti__cyawe_,
   {{0xa4439028,0xc4a4e00d,0xb046c013,0x5bfd700b}},	//   _mis_, _čo__je_, _savremen, _ཚུ__ཧེ_,
   {{0xe24e5024,0x9cc4200c,0x6b205003,0x8c84200c}},	//   _ལྟོ_, _क्या__आपको_, _ingakumb, _क्या__आपके_,
   {{0xc5764004,0xc4687010,0x98796005,0x00000000}},	//   _realizaç, _través__del_, _грађевин, --,
   {{0xa53e5006,0x5debd00c,0x9014d00d,0xac77900c}},	//   _karierny, _टिप्पणिय, _skutočno, _कुछ__नहीं_,
   {{0xa2344003,0x5b3b201c,0xa201f023,0xe30ed011}},	//   _ngamnye_, _berbatas, _muzium_, _umnuz__edward_,
   {{0x5c57501d,0x626c4010,0xf3e46026,0xe4791004}},	//   _loptice_, _humor_, _na__mjestu_, _deve__ser_,
   {{0x6dc6200d,0x00000000,0x00000000,0x00000000}},	//   _ružomber, --, --, --,
   {{0xe386a02f,0x43dd901f,0xb3871007,0x3d2de036}},	//   _dobre_, _ruswa_, _vybrat_, _korišten_,
   {{0x12a6d00d,0xbaf7f003,0x12c69023,0xe2b4f010}},	// [3a0] _alebo_, _urhulume, _ensiklop_bebas_, _chicas_,
   {{0xe243500e,0x7f243005,0xc439a010,0x19fa600d}},	//   _པོས_, _судећи__по_, _la__parte_, _dôvod__prečo_,
   {{0xf208000d,0xd08b2007,0x9c602028,0x55aec03f}},	//   _informác, _domácí_, _escuela_, _výsledko,
   {{0xc443d008,0x9290b038,0xd470e011,0xf2a3e011}},	//   _ngw_, _vidare_, _kanti__ke_, _leli__culo_,
   {{0xdd9e1024,0xc458d011,0x52b40010,0x30491005}},	//   _རྒྱལ__ཡོངས_, _ukhozi__fm_, _chica_, _периоду_,
   {{0xec527008,0xd6121027,0xc256500b,0x1be4700e}},	//   _amatora_, _untuk__memudahk, _དགོ__པའི_, _པའི__ཆུ_,
   {{0xe27f700f,0x11ba700a,0x93b11014,0xdfa11014}},	//   _mwanya_, _परमल_, _servizo_, _servizos_,
   {{0x0a32801a,0xc4426003,0x0bcd000c,0x86a26003}},	//   _खोज_, _qho_, _कठिन__है_, _nootitsh,
   {{0xc26c2035,0x325d9014,0x00000000,0x00000000}},	//   _eskom_, _así__mesmo_, --, --,
   {{0xebb0c01b,0x5bb3e00c,0x546ef003,0x00000000}},	//   _iinkqubo_, _हैं__या_, _mva__nje_, --,
   {{0x83870007,0x3231a011,0x56a26003,0x00000000}},	//   _která_, _basening_afrika_, _kootitsh, --,
   {{0xb6580005,0x12439020,0x00000000,0x00000000}},	//   _živelo__stanovni, _ཁོག_, --, --,
   {{0xeb9bb003,0x54465010,0xe1dfc01e,0x00000000}},	//   _zezikolo_, _cuando__se_, _आमिर_, --,
   {{0x541f0005,0xb302a00f,0xb0183005,0xeac08007}},	//   _naseljen_mesto_, _umubare_, _je__registro, _patří_,
   {{0xd2b7d00b,0x00000000,0x00000000,0x00000000}},	//   _མས__སྟེ_, --, --, --,
   {{0x2c4cb007,0xd5ce1003,0x00000000,0x00000000}},	//   _partneři_, _kuvavany, --, --,
   {{0x025ae02a,0x4fe11005,0x9c0cc00c,0x0fb0700c}},	// [3b0] _hvilke_, _овај_, _पहले__कि_, _में__लगभग_,
   {{0x28e96008,0x6be7900c,0xdbb47017,0x62dab005}},	//   _abashing, _जब__आप_, _reacción_, _oktobar_,
   {{0x525bf019,0x8352800c,0x3f47b007,0x630e0023}},	//   _paulo_, _के__संबंध_, _výrobce_, _telah__berjaya_,
   {{0x547d5032,0x7cebb029,0x530ba00c,0xe469600d}},	//   _para__se_, _norvegic, _होने__वाली_, _iba__na_,
   {{0xb3b9e02a,0x0bc5800c,0x00000000,0x00000000}},	//   _alle__andre_, _सही__है_, --, --,
   {{0xeb8c900c,0xabdcc00b,0xd046900a,0x73f42007}},	//   _गई_, _ཨིན__དེ_, _दिहलसि_, _jistě_,
   {{0x11b9d00a,0x645fe010,0x00000000,0x00000000}},	//   _बीतल_, _gestión__de_, --, --,
   {{0x89c38030,0x057a602a,0x00000000,0x00000000}},	//   _imidlert, _hjemmeba_virksomh, --, --,
   {{0xd491f050,0x286d7028,0x23947034,0x02025014}},	//   _na__que_, _personas_, _finst_, _estivo_,
   {{0x0491702a,0xcb5eb00a,0x92588005,0x8256d00b}},	//   _du__vil_, _जइसन_, _su__dati_, _སེངྒེ__དབང_,
   {{0x19f65014,0xaec7c00d,0x00000000,0x00000000}},	//   _entón_, _vzdialen, --, --,
   {{0x1db8000e,0xe491702a,0x0f5c0034,0xc4735014}},	//   _ནས__བཏུས_, _er__til_, _omfattan, _cada__un_,
   {{0x04727021,0xca0f8007,0x02921014,0x00000000}},	//   _som__vil_, _následuj, _espazo_, --,
   {{0x6b3e200e,0x8dfbd010,0x00000000,0x00000000}},	//   _རྒྱ__གཞུང_, _puede__encontra, --, --,
   {{0xc9b14007,0x7be9100b,0xc1f76005,0xbe71400d}},	//   _ostatní_, _སྟོན__ཁང_, _spoljašn, _ostatné_,
   {{0x026cf004,0xfb9a200c,0x6bf5600b,0x00000000}},	//   _jogo_, _नाम__से_, _གླ__ཁར_, --,
   {{0xabc0200c,0x1b4c3026,0xfe97200a,0x32e73011}},	// [3c0] _होने__की_, _djevojka_, _लस्टमानं, _ye__absa_,
   {{0x0236b008,0xa33a1005,0xe758e00c,0x7298b004}},	//   _ujejwe_, _провинци, _सदस्यों_, _mas__isso_,
   {{0xf494102a,0x2b6c0011,0x64822021,0xf2c1b00f}},	//   _og__jeg_, _kusho__okhulume, _tips__for_, _irashobo_kuba_,
   {{0xe896f005,0x43241003,0x2dd94003,0x8ba6c00c}},	//   _детаљниј_подаци_, _kunye__nendawo_, _beskibaa, _प्रकार__का_,
   {{0x4ed25005,0x2252500e,0x00000000,0x00000000}},	//   _да__ће_, _ཡིན__ཞེས_, --, --,
   {{0x44b36014,0x63ed102a,0x00000000,0x00000000}},	//   _concello__da_, _den__store_, --, --,
   {{0xc2d38006,0x027eb00b,0x00000000,0x00000000}},	//   _dari__berbagai_, _ལུ__ཡོད_, --, --,
   {{0x6c62300f,0x1dafb005,0x5315e004,0xe3e8a019}},	//   _kibungo_, _primećen_, _antônio_, _ou__mais_,
   {{0xeb1b0015,0x894bb023,0x553f002c,0xb2752021}},	//   _batalion_, _berundur_, _tampouco_, _og__klikk_,
   {{0x94444004,0x2594700f,0xc4707010,0x424b8010}},	//   _ou_, _ushobora__gukoresh, _parte__del_, _de__julio_,
   {{0x1498a02a,0x23fa6013,0xd6e3700c,0x00000000}},	//   _vi__har_, _okruga_, _को__शामिल_, --,
   {{0x19f65004,0x7ae58021,0x3df5102b,0x1bdff00e}},	//   _então_, _bekrefte, _མི__ཚུགས_, _བསྟེན__ནས_,
   {{0x1bb9e00e,0x4fa27023,0x84986014,0x926c2013}},	//   _དེ__ནས_, _boleh__memulaka, _os__os_, _zakon_,
   {{0x33959030,0xb2778011,0xd4ab1015,0xbb89d010}},	//   _disse_, _south__africa_, _selepas__itu_, _noviembr,
   {{0xd4444026,0xd3eba011,0xad7a6003,0x00000000}},	//   _cu_, _kuleya__ndawo_, _ejoliswe_, --,
   {{0xe3f0b02e,0xf442f038,0xc2331017,0x030e000f}},	//   _abarundi_, _òg_, _formado_, _ndabona_,
   {{0xf4444032,0xb4ace028,0xbab46007,0x0470802a}},	// [3d0] _eu_, _con__el_, _vlastní_, _fordi__det_,
   {{0x73ae900d,0x0bf5a00c,0xa2c5d010,0x00000000}},	//   _kúpa_, _में__और_, _cualquie_otra_, --,
   {{0x8b61b02a,0x6ab18003,0xe4ab202a,0x031b800f}},	//   _tidliger, _amaxesha_, _flere__år_, _igishush_mbonera_,
   {{0x22da7003,0x5328a02a,0xb2671005,0x6950f03d}},	//   _yesebe_, _er__bare_, _чему_, _abalande,
   {{0xbf8bf00d,0xb46be007,0x047f4028,0x0295800b}},	//   _iné_, _jak__to_, _proporci_por_, _བཀལ__ལྷག_,
   {{0xae00e005,0xac09a00f,0x2a22400d,0xfeb7100f}},	//   _које__су_, _ikoranab, _poradňa_, _imirenge_,
   {{0x99990007,0xb3b5e036,0x5309a021,0xaa180005}},	//   _dobře_, _čoveka_, _som__bare_, _исто_,
   {{0x0e553051,0x5862a00c,0x00000000,0x00000000}},	//   _महत्वपूर, _अधिक__जानकारी_, --, --,
   {{0x8308d011,0xf2d8d02d,0x6c800022,0x53e5a011}},	//   _iningi__labantu_, _हँसी_, _libertad_, _lo__mlisa_,
   {{0x8284a011,0x649fa011,0x275d000c,0xc38d5004}},	//   _lokho__kusho_, _asikho__isidingo_, _कुत्तों_, _de__sucesso_,
   {{0x9442601b,0x850f1010,0x235ed005,0x9aeea00e}},	//   _ezo_, _aprovech, _akademij, _ཡང__འཇུག_,
   {{0xf7040015,0x3f47000c,0x73ebe038,0xd37bc028}},	//   _yang__dipanggi, _से__अधिक_, _natta_, _espacio_,
   {{0x83e5000f,0xb9954007,0xa7a53005,0x0abe100c}},	//   _gicurasi_, _výše_, _пре__свега_, _मामले__में_,
   {{0xf1648005,0x49877007,0x524b9010,0x6c36300c}},	//   _орбите__износи_, _připojen, _de__junio_, _में__सभी_,
   {{0x12cb800f,0x54896011,0x0bd5000b,0xcf167011}},	//   _gukorwa_, _inqobo__nje_, _ཐབས__ལུ_, _thumela__isixhuma,
   {{0xf472e032,0x14dff004,0x9bb60018,0x6cb4800c}},	//   _que__eu_, _seleção_, _ནས__མི_, _अन्य__लोगों_,
   {{0x052b6004,0x93874021,0xabbbe00b,0x63da9005}},	// [3e0] _conselho_, _endres_, _ཏེ__ོད_, _утицај_,
   {{0x126d8010,0xc5d2f014,0x027aa00b,0xf3cd0007}},	//   _otros_, _da__poboació, _ནི__ཨིན_, _osobní_,
   {{0x4def300d,0xf4b9d021,0x00000000,0x00000000}},	//   _zaujímav, _nettlese_din_, --, --,
   {{0xd25ad034,0xbbf1800d,0xf2ab000b,0x3789d005}},	//   _gjeld_, _je__určený_, _སྔོ__ཤིང_, _његовом_,
   {{0x52a9f024,0x19f4e016,0xe271a00f,0x427ef014}},	//   _གི__བདག_, _deník_, _birasa__naho_, _asinou_,
   {{0x5e143005,0x9cae4010,0x00000000,0x00000000}},	//   _власти_, _la__escuela_, --, --,
   {{0x82cf3011,0x02b9f011,0xbb194023,0x32679005}},	//   _isithomb_gallo_, _akekho__umuntu_, _cawangan_, _старост__становни,
   {{0x232a5011,0x9d15d005,0xd232b005,0x7bf17003}},	//   _lo__mndeni_, _меморија__рачунара_, _годину__дана_, _kuqwalas,
   {{0xf4b36021,0xc4548021,0x0c6f0003,0x82c9800f}},	//   _ser__ut_, _har__sett_, _kunye__neendawo_, _gukora__ibintu_,
   {{0x4c4ee00a,0xaa42100c,0x34924010,0x8eba0005}},	//   _जइसे_, _के__कुछ_, _es__muy_, _дошло_,
   {{0xd6f98002,0xb269e02b,0x7079d028,0xf26cd014}},	//   _बरखा_, _དར__དཀར_, _de__ordenado, _creou_,
   {{0x0b8d5020,0x630ed010,0xe4b1f021,0x09f4e007}},	//   _ཕལ_, _tambien_, _opp__til_, _ceník_,
   {{0xc2431024,0x58961004,0xe20e2005,0x00000000}},	//   _ཚོད_, _os__sintomas_, _пада_, --,
   {{0x52a07007,0xf3168011,0x6142d005,0x00000000}},	//   _soubor_, _ababili_, _ствар_, --,
   {{0xa3475011,0x2c61602c,0xa3e23004,0x00000000}},	//   _ujulius__malema_, _situada_, _em__suas_, --,
   {{0xf9c4900a,0xc2d8b011,0x36f00003,0xb23d4010}},	//   _अँजोरिया_, _eqhuba__uthe_, _ziyacelw, _hay__muchos_,
   {{0x6494700d,0xbc4f500c,0x3af72005,0x93ee8010}},	// [3f0] _sa__že_, _अगले_, _сателит_, _hasta__ahora_,
   {{0x0c05000c,0xcc59500d,0x9451d011,0x31e9500c}},	//   _स्वयं__को_, _záujem_, _ukuthi__anc_, _के__बाहर_,
   {{0x0f8d1004,0x04632004,0x00000000,0x00000000}},	//   _diário_, _contato__com_, --, --,
   {{0xe499602a,0xead9500e,0x6712500c,0x334aa021}},	//   _vi__er_, _ཡིན__འདུག_, _में__बहुत_, _av__mange_,
   {{0x3bdbe00c,0x62e32004,0x00000000,0x00000000}},	//   _तो__यह_, _no__final_, --, --,
   {{0xc4071004,0x5ae84007,0x3f5c000d,0x94578011}},	//   _comissão_, _založen_, _vzťah_, _amagama__abo_,
   {{0xc69b900c,0x2bba100e,0xbf369007,0x00000000}},	//   _का__आनंद_, _དེ__བས_, _se__svým_, --,
   {{0x3443e038,0xc4429031,0x00000000,0x00000000}},	//   _eit_, _oza_, --, --,
   {{0xb2caf038,0x047ee02a,0xe3207023,0x5e20500d}},	//   _bygda_, _ting__som_, _amnya_, _občiansk,
   {{0xcf33c010,0x4f29e011,0x0f0e9023,0x43b9a040}},	//   _presenta, _kubika__iphephan, _perlu__menyumba, _serveru_,
   {{0x5a15200f,0x00000000,0x00000000,0x00000000}},	//   _gitarama_, --, --, --,
   {{0xeccba010,0xaa7ab00c,0x00000000,0x00000000}},	//   _la__persona_, _जिसके__लिए_, --, --,
   {{0x19f66004,0x80857011,0x00000000,0x00000000}},	//   _porém_, _le__ndatshan, --, --,
   {{0xe27f7037,0x2442d004,0xe9091005,0x6b9db010}},	//   _rwanda_, _lhe_, _метара_, _más__informac,
   {{0x24429031,0xe266f003,0xd6fed00a,0xc28eb024}},	//   _eza_, _lwabiwo__mali_, _कतना_, _གསར__གྱི_,
   {{0xd7377007,0x5b9ee005,0x327df00b,0x474ed005}},	//   _dalších_, _четврто__коло_, _ལུ__སླབ_, _црква_,

   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [400] --, --, --, --,
   {{0xda3c6002,0xc2a55011,0x7baff02b,0xcbb0e011}},	//   _उपर_, _bes__thende_, _ནང__ཡང_, _ngesikha_kuqubuka_,
   {{0xd47ba004,0x9abae00c,0x00000000,0x00000000}},	//   _para__sua_, _लिए__ठीक_, --, --,
   {{0x0395000d,0xb65bb003,0xc47e4010,0xf27f0011}},	//   _časti_, _kwiindaw, _proporci_una_, _abangu_,
   {{0x7359c006,0xfe660014,0x0450e00f,0xf71ec00c}},	//   _sebagai__berikut_, _incluínd, _hejuru__yo_, _निर्भर__करता_,
   {{0xf4b8d021,0x525bf003,0xf1320021,0x55fbf017}},	//   _lage__et_, _nzulu_, _er__sannsynl, _dimensió,
   {{0x12e86023,0x7eced005,0x427e601b,0x00000000}},	//   _baginda_, _му__се_, _ntoni_, --,
   {{0xf2d8200f,0x3e765005,0xd4d96005,0x32a1202b}},	//   _kamere_, _су__на_, _просјечн, _དྲུང__ཆེན_,
   {{0x572c700a,0x03ce900d,0xdc49200c,0xc3e4302a}},	//   _बाड़न_, _stave_, _बड़े_, _også__være_,
   {{0xb3954026,0x8386a005,0x64dff004,0x6b066014}},	//   _pjesmu_, _dobro_, _coleção_, _chegaron_,
   {{0x5236d023,0xb2c8b00f,0x53168003,0x1c05b00c}},	//   _projek_, _zasomwe_, _amabini_, _बंद__कर_,
   {{0x046be021,0x52a7f013,0x22b1f023,0xc2e9c00d}},	//   _hva__som_, _kluba_, _saidina_, _zoznamu_,
   {{0xe46ce00f,0x97f2600d,0xf71e000c,0x82670005}},	//   _hamwe__na_, _veľkosť_, _नहीं__होता_, _селу_,
   {{0x6444400f,0xca32b01e,0xda602014,0x14376011}},	//   _cg_, _कोई_, _comúns_, _uthe__bafuna_,
   {{0x53dc101c,0x11037003,0xe61e7003,0x33cf5010}},	//   _bahwa_, _ofikelel, _ye__intaneth, _jueves_,
   {{0x84444038,0x0b5f100a,0x1891e008,0x2e9c8005}},	//   _eg_, _अइसन_, _abakengu, _астероид__је_,
   {{0x8b206020,0xb243300e,0xa2d47014,0x64b65010}},	// [410] _བཅུ__དྲུག_, _མོད_, _axudar_, _julio__de_,
   {{0x55536011,0x33e3b021,0x02bbb00b,0xe27d3011}},	//   _isikhath, _av__disse_, _ོད__ཡོད_, _khona__lapho_,
   {{0x422bb03a,0x026ce005,0x92a6400f,0x726e203f}},	//   _ntambwe_, _iznosi_, _zombi_, _aspoň_,
   {{0x62fdf013,0x00000000,0x00000000,0x00000000}},	//   _druge_, --, --, --,
   {{0xaf51100c,0x3a74e00c,0x32016021,0xd2f5b010}},	//   _होंगे_, _करता__हूँ_, _angitt_, _más__famosos_,
   {{0x2c966035,0x54a82014,0xee07400e,0x00000000}},	//   _ngaphand_kokuthi_, _súa__vez_, _བྱེད__འབྲེལ_, --,
   {{0x96dcb00a,0xf2db8026,0x2201400f,0x9c50b01e}},	//   _फिलिम_, _prije__nego_, _zifite_, _ट्रेन_,
   {{0xeda8a005,0x00000000,0x00000000,0x00000000}},	//   _оно__што_, --, --, --,
   {{0x3eef3052,0x1394601b,0xbebf5007,0x9782000e}},	//   _अधिक_, _xhosa_, _červenec_, _འཐབ__རྩོད_,
   {{0x6352e014,0x4471a015,0xd793e00e,0x34afa00d}},	//   _outros__artigos_, _memasuki__tahun_, _ཞེས__འབོད_, _uistite__sa_,
   {{0xa718b00c,0xadb94011,0xd95f5007,0x00000000}},	//   _हो__जाता_, _umntwana__umelizwe_, _července_, --,
   {{0x3c7fc029,0x9b66d003,0x92abe010,0x0a94200c}},	//   _følgende_, _izithuba_, _de__años_, _दुनिया__में_,
   {{0x3404b02a,0x9b9d600e,0xc2bbb00b,0xf22b400d}},	//   _til__disse_, _ཡིན__ཏེ_, _ཐོ__ཡིག_, _upraviť_,
   {{0xb3949004,0xbcaba01c,0xd2aa300e,0xeba2900c}},	//   _duas_, _menyadar, _གང__ཡིན_, _इंटरनेट__के_,
   {{0x54946007,0xb3677005,0x32ebb023,0xc7bea00d}},	//   _li__se_, _toku__poslednj, _fizikal_, _na__zvýšenie_,
   {{0x4478101c,0x04ba802a,0xfd32900f,0xb2249007}},	//   _film__ini_, _ikke__det_, _amahirwe_, _velký_,
   {{0xa3090022,0xd4926010,0xda80d007,0x4a45d00d}},	// [420] _que__ofrece_, _en__su_, _konečně_, _sa__dajú_,
   {{0xa491e02a,0xab751005,0x6f57c010,0x92cf6004}},	//   _at__vi_, _квалитет, _del__marketin, _os__comentár,
   {{0xa2ba800b,0xb10a800e,0xa575b004,0x9bdb402b}},	//   _མི__འདི_, _མི__འདྲ_, _utilizaç, _ཐོབ__མི_,
   {{0xcea1f012,0xe4b11010,0x7672000b,0x747b5004}},	//   _posljedn, _puede__ser_, _བཀལ__ཡོདཔ_, _para__mim_,
   {{0x025ae00e,0x12bba010,0x00000000,0x00000000}},	//   _ཡིན__ཅིང_, _en__otros_, --, --,
   {{0x324c0020,0xc2d43004,0x6244e02f,0x40578013}},	//   _ཉུང_, _escolha_, _kým_, _inostran,
   {{0xc48ce021,0xb9f4a007,0x225fa011,0xc2d8c03d}},	//   _fleste__av_, _najít_, _lolu__phiko_, _uhlelo_,
   {{0x54b7000d,0xfcfe7005,0xe9ec6004,0x6bae500e}},	//   _môžete_, _eliptičn, _empreend, _དང__ཉེ_,
   {{0x6470d02a,0x5c0ce005,0x772d500c,0xe31d4003}},	//   _fordi__de_, _прво__коло_, _ताज़ा_, _fumanisa__ukuba_,
   {{0x3e8fa005,0x3233f011,0x93949004,0x00000000}},	//   _простире__на_, _ukuthi__ngeke_, _ruas_, --,
   {{0xb2b25009,0xa3949004,0xcb60401d,0x82af700b}},	//   _diakses__pada_, _suas_, _siječanj_, _མི__དབང_,
   {{0xe4715003,0x3c05600c,0x3b61600a,0x77532031}},	//   _naphi__na_, _लिए__यह_, _देखनी_, _ngenjong,
   {{0x12b0600d,0xf9f67004,0x59f39010,0x00000000}},	//   _vidieť_, _visão_, _una__excelent, --,
   {{0xfc0ba00c,0xdeb9f021,0x23cc000d,0xd5ee1010}},	//   _रूप__से_, _gjør_, _ste__získali_, _producto__servicio_,
   {{0x32d9d011,0x05807023,0x00000000,0x00000000}},	//   _ujacob__zuma_, _televisy, --, --,
   {{0x5a32900a,0xfa89b03b,0xc498d021,0x646da010}},	//   _गईल_, _europeis, _tilbyr__en_, _cantidad__de_,
   {{0xb4936033,0x1afc4007,0x08912028,0xe2d32010}},	// [430] _er__at_, _zajímavé_, _para__alcanzar_, _ningún__otro_,
   {{0x640b5024,0x03107014,0x4cec1005,0x00000000}},	//   _ནང__རྒྱལ_, _forzas_, _компаниј, --,
   {{0x32916009,0x2753f036,0xfaa7101a,0x1c67c011}},	//   _diakses_, _tehnolog, _अच्छी_, _namuhla_,
   {{0x8d3c3007,0x6ca7300c,0xd1deb00a,0x3bba702b}},	//   _velikost_, _प्रदान__करने_, _जेकर_, _ལས__ཁོ_,
   {{0xf493602a,0x82a62003,0x624a600f,0xa7e4f004}},	//   _er__et_, _iincwadi_, _byumba_, _companhi,
   {{0x01d69007,0xa27d000b,0x00000000,0x00000000}},	//   _jednání_, _ཡི__འདི_, --, --,
   {{0xf474602a,0x23ce9034,0x227f700f,0xae1ce004}},	//   _som__et_, _olav_, _ibanze_, _pergunta,
   {{0xef03e005,0xf9f43007,0x92b59010,0x6b1b701c}},	//   _se__prostire_, _její_, _disco_, _batalyon_,
   {{0xc4439004,0x0f4fa023,0xd2a3d00e,0x035e9007}},	//   _às_, _untuk__menyumba, _རྒྱུ__ཡིན_, _zahradní_,
   {{0x02bcb00e,0xa3c33004,0x00000000,0x00000000}},	//   _པོ__ཡོད_, _que__suas_, --, --,
   {{0x3224900f,0x04079023,0xa243800e,0xa255c003}},	//   _shaka_, _halaman__iaitu_, _གནའ_, _utitshal,
   {{0x8584500d,0x8302400f,0xa200d00f,0x9766700c}},	//   _fotogalé, _byabaye_, _abahinzi_, _में__क्या_,
   {{0xe470b02a,0xfeff3005,0x425a1021,0xa329a007}},	//   _knyttet__til_, _година__код_, _blir__brukt_, _ve__všech_,
   {{0x5319a011,0x576cb00e,0xd3cf0013,0x63261010}},	//   _noma__kunjalo_, _ལས__བྱེད_, _glavni_, _haga__clic_,
   {{0x9c8e100a,0x3c6a8046,0xb442d007,0xe2e7202a}},	//   _कवनो_, _चिन्ता_, _lze_, _med__denne_,
   {{0x53c28010,0xd517100f,0xee844007,0x5bea0003}},	//   _móvil_, _imirongo_, _nejvíce_, _iimvelis,
   {{0x5232e015,0x0c49200c,0x64aec010,0x00000000}},	// [440] _ahli__ahli_, _मुझे_, _alrededo_de_, --,
   {{0x623e403e,0xc2a78012,0x14779005,0xf244e03f}},	//   _danmark_, _borba_, _poslednj_tri_, _tým_,
   {{0x34cef021,0xb365901b,0x00000000,0x00000000}},	//   _titt__på_, _nangoko_, --, --,
   {{0xd243a00b,0x2dc6b011,0x4a74e007,0x22a0f011}},	//   _གླར_, _ngesonto__eledlule_, _zprávy_, _okubalwa__kubo_,
   {{0xf6314021,0x3497e021,0xb4b24007,0x349bf007}},	//   _topograf, _basert__på_, _průvodce_, _než__jen_,
   {{0xe4444016,0x699d101b,0x63178014,0xb6ff400a}},	//   _ji_, _kwakhona_, _forza_, _जगहा_,
   {{0x7eee6005,0x0322000d,0x00000000,0x00000000}},	//   _је__по_, _rýchlo_, --, --,
   {{0xe46a3011,0x1bd8f00e,0x69d07005,0x00000000}},	//   _kubalule_ukuthi_, _ཕེབས__ནས_, _рећи_, --,
   {{0x83062014,0x52f5d014,0x9bbf800e,0x43cc800f}},	//   _como__unha_, _súa__vida_, _ལོ__ཙཱ_, _buri__munsi_,
   {{0x32f30006,0xf1e1900a,0x2a749003,0x0abe500c}},	//   _kalimat_, _मतारी_, _isigxina_, _बनाने__में_,
   {{0x13b68013,0x58a24021,0x00000000,0x00000000}},	//   _razvoja_, _søkeorde, --, --,
   {{0xda74e02f,0xced6700d,0xf2ad9011,0x9a5b5007}},	//   _správy_, _veľmi_, _uma__ufuna_, _jiných_,
   {{0x3f1a600c,0x8f1d3005,0x1238703d,0x00000000}},	//   _बहुत__अधिक_, _бивши_, _izimali_, --,
   {{0x8494a021,0x00000000,0x00000000,0x00000000}},	//   _og__mer_, --, --, --,
   {{0x39a3b01d,0xb4906004,0x0bcf800b,0x00000000}},	//   _posjetit, _redação_, _རིང__ལུ_, --,
   {{0x94444034,0xab5cb018,0x32d47004,0xebe3100e}},	//   _ei_, _ལས__བྱུང_, _ajudar_, _པའི__ཚེ_,
   {{0xe9806003,0x9f238014,0x30d0e011,0x775a902b}},	// [450] _esikolwe, _semellan, _ekuphele_kwesizin, _ནང__སྡོད_,
   {{0x6ed90014,0x03161010,0x00000000,0x00000000}},	//   _accións_, _las__plantas_, --, --,
   {{0xf4808014,0x0b58a00e,0xfb9b200c,0xbbe9400c}},	//   _polo__seu_, _ནས__བཟུང_, _तरह__से_, _जब__तक_,
   {{0x0290201c,0x4a32b00a,0x7279b02b,0x5c3c8007}},	//   _rekan_, _कईल_, _དེ__ཉམས_, _jak__získat_,
   {{0x226d8010,0x0f9a0004,0xc3aa0004,0x7bd5a00b}},	//   _foro_, _dúvidas_, _dúvida_, _འོང__ནི_,
   {{0xc2ff2011,0xd467f010,0x00000000,0x00000000}},	//   _kubafana__bafana_, _desea__que_, --, --,
   {{0x0bd9d00c,0xd48f202a,0xf4b3e02a,0xc2bb6028}},	//   _गया__था_, _få__den_, _var__et_, _es__como_,
   {{0x6c723038,0x0bd7300b,0x6c12b020,0xbcb8d004}},	//   _rørsla_, _བཀོད__ལུ_, _གཅིག__ཏུ_, _um__arquivo_,
   {{0x12a7f032,0x73543014,0x0ba5800c,0xaf02900e}},	//   _clube_, _galegas_, _ही__है_, _རྒྱུག_,
   {{0xd2786007,0x22b5c02b,0xd3fdc004,0x42ce2011}},	//   _levné_, _གི__ལོར_, _mais__sobre_, _yonke__imali_,
   {{0x946e8014,0xe251100e,0x00000000,0x00000000}},	//   _versións_, _ཡིན__ནའང_, --, --,
   {{0x34536011,0xeb421040,0xdb4f9005,0x72902015}},	//   _ukuthi__lo_, _doporuču, _podaci__računaru_, _kekal_,
   {{0xf3ead026,0x43b6e004,0xa3eb9007,0x1c00600c}},	//   _ljeto_, _orçament, _byste_, _प्रारंभ__कर_,
   {{0x537f8009,0xd386d010,0xd2e1301c,0x12d7e005}},	//   _jakarta_, _leer_, _spanyol_, _се__користе_,
   {{0x56ff300a,0x2463e02a,0xb478a004,0x9f2b0010}},	//   _अतना_, _hvordan__kan_, _encontra_em_, _pueden__utilizar_,
   {{0x4303e010,0x00000000,0x00000000,0x00000000}},	//   _del__día_, --, --, --,
   {{0xb0cb0018,0x1426d00f,0x00000000,0x00000000}},	// [460] _དེ__འདྲ_, _gukora__hamwe_, --, --,
   {{0x375a902b,0x24aa2021,0x00000000,0x00000000}},	//   _ནང__འཁོད_, _din__kan_, --, --,
   {{0x614b3005,0x2fff8038,0xcc0da00e,0x12431024}},	//   _на__површини_, _brukarko, _ཅུང__ཟད_, _མནོ_,
   {{0xe5731026,0xf293400b,0x7c60b014,0xe9c3a014}},	//   _amatersk, _ཨིན__ཟེར_, _alguén_, _prodúces,
   {{0x4b1b9014,0xf386c038,0x6a33500a,0x6ad2400c}},	//   _pode__referirs, _endre_, _छोट_, _बच्चे_,
   {{0x44425007,0xd3ed3011,0x41ff700b,0x00000000}},	//   _byl_, _all__stars_, _སྒྲིང__ཁྱིམ_, --,
   {{0x8c7c5012,0xabf2100c,0x9343c005,0x00000000}},	//   _mjeseca_, _कंपनी__की_, _положај_, --,
   {{0x6442400d,0x81f2b00c,0xb2bb700d,0x7dc0100b}},	//   _tym_, _एक__दूसरे_, _by__bolo_, _ལུ__ཚོགས_,
   {{0xd73b600c,0x14aa202a,0x53cc2011,0xd30d0011}},	//   _में__शामिल_, _den__har_, _leli__khasi_, _ngalolu__hlobo_,
   {{0xb853500b,0x00000000,0x00000000,0x00000000}},	//   _ལོ__དབྱིན_, --, --, --,
   {{0xfd4c9005,0xe979a007,0xad73a005,0x00000000}},	//   _je__eliptičn, _bydlení_, _познато_, --,
   {{0x2386a026,0xf26c7038,0x9de0d00b,0x64aba02a}},	//   _dobri_, _enno_, _ཚེས__གྲངས_, _det__for_,
   {{0xfb1c2010,0x44bee013,0xe3fe8013,0x02670005}},	//   _respuest, _mogu__da_, _ekonomsk, _делу_,
   {{0x225a401d,0xac5da00c,0xc9b7302c,0x00000000}},	//   _probuši_, _भी__नहीं_, _dinastía_, --,
   {{0xebd5b024,0x659b2023,0xf2eab022,0xee88f005}},	//   _འོག__གི_, _menubuhk, _fuentes_, _могао__да_,
   {{0xb9f89038,0x4f8bf004,0xd21c6023,0xc342a032}},	//   _samstund, _pré_, _terhad_, _mais__tarde_,
   {{0x626c8037,0xa451e034,0xc4ab3010,0xb478a004}},	// [470] _bakora_, _jordbruk, _con__una_, _encontra_um_,
   {{0x0b95800b,0xfbc3300c,0xede6c00e,0x84e92005}},	//   _དོན__ལུ_, _करने__से_, _རང__སྐྱོང_, _максимал,
   {{0x4ec8f00d,0x39c3401d,0x8616c007,0xed732013}},	//   _zariaden, _skačuće_, _zpracová, _posmatra,
   {{0x9394d010,0x26f9c002,0xb2bab00b,0xdbe3400e}},	//   _pues_, _भुला_, _སར__རྣམ_, _པའི__མེ_,
   {{0x06f8300c,0x5a9bb004,0x0ab3800c,0x64add010}},	//   _लिया_, _jornalis, _वर्तमान__में_, _nombres__de_,
   {{0x847a8013,0xe9c2f005,0x728b7014,0x00000000}},	//   _nastavlj, _vrednost, _españois_, --,
   {{0x23015027,0xf3d5f02a,0x92d9f005,0x00000000}},	//   _bergantu_kepada_, _er__flere_, _верзија_, --,
   {{0x5442600f,0x74756011,0xebe2600c,0x00000000}},	//   _byo_, _ukuthi__basebenz, _तो__वे_, --,
   {{0x64426037,0x94498021,0x6ab3e038,0x60361037}},	//   _cyo_, _hjelpe__deg_, _marknads, _guverino,
   {{0xa402000d,0x2baca00c,0x25d9800d,0x9e693023}},	//   _dovolenk, _कि__हम_, _napíšte_, _percubaa,
   {{0xca3dd02d,0x625c202b,0x4d62b010,0x9baac00e}},	//   _सकल_, _རྗེས__དྲན_, _se__encuentr, _དམག__དཔུང_,
   {{0xb27e0038,0xd340402a,0x348c2005,0x0f307023}},	//   _kring_, _det__ikke_, _eliptičn_sa_, _selepasn,
   {{0x13cf5010,0x5a32900c,0x7bae4003,0x724ee02a}},	//   _nuevos_, _ऐसा_, _yephondo_, _en__online_,
   {{0xd442200d,0x1c884026,0x02fdf005,0x3bee1005}},	//   _skk_, _naselje__sastavu_, _drugo_, _мало_,
   {{0x1b8d400a,0x7be6200b,0x00000000,0x00000000}},	//   _छै_, _སོར__ནི_, --, --,
   {{0x327f5028,0x7c35d005,0x00000000,0x00000000}},	//   _buenos_, _чланова_, --, --,
   {{0xf26da004,0xa2d7201b,0x5bd54005,0xe260600e}},	// [480] _topo_, _sesotho_, _друго__коло_, _དགེ__རྒན_,
   {{0x6ef1200a,0xd1e1200a,0xe26c202b,0xe41cf011}},	//   _तोहके_, _तोहरे_, _དང__ཅིག_, _funda__ukuthi_,
   {{0x6b227003,0xb27fc021,0xcc50b00c,0xa2e0b00a}},	//   _ngamanye__amaxesha_, _nevnt_, _देखें_, _देखीं_,
   {{0x59f47007,0x92d53004,0xb2f22007,0x4c48c00c}},	//   _není_, _mãe_, _přitom_, _रखें_,
   {{0x934e0004,0x823ab003,0x16c73021,0xa2ab200e}},	//   _edição_, _kule__veki_, _og__markedsf, _པར__བྱས_,
   {{0x02eaf011,0x3d59b004,0xf48e201a,0x00000000}},	//   _wonke__umuntu_, _exercíci, _खत्म_, --,
   {{0x3e3ce005,0xb24b100e,0x6d2ee00f,0x52a91014}},	//   _се__на_, _ཉིད__ཀྱི_, _icyizere_, _polo__menos_,
   {{0x5bae4003,0x7afd900d,0x8641001f,0x373f7003}},	//   _wephondo_, _prípade_, _umunyarw, _ukuba__usebenzi,
   {{0x427e6038,0x7aae800c,0x3457002a,0xd2d2d011}},	//   _trond_, _रखते__हैं_, _for__dette_, _ikwazulu__natal_,
   {{0xa35e3009,0x94426008,0x946b8023,0xa291200f}},	//   _dikenal__sebagai_, _vyo_, _memulaka_sebuah_, _ajya_,
   {{0x04926007,0xe4687011,0x2249f01b,0x00000000}},	//   _je__li_, _kusho__ukuthi_, _mvume_, --,
   {{0xe4497011,0xc26f802b,0x83dd0015,0x1f861032}},	//   _siyazi__ukuthi_, _ལས__ཐོབ_, _piawai_, _artes__marciais_,
   {{0x8442603a,0x24926012,0x6f3b2023,0x8c3a000d}},	//   _uyo_, _je__ni_, _penubuha, _prehľad_,
   {{0xa378600f,0xe9b5d00c,0xb435a003,0x2baab00c}},	//   _ingamba_, _अपनी__वेबसाइट_, _kumaziko_, _कि__जब_,
   {{0x2a33a00a,0x92131021,0x1e001006,0xe344a016}},	//   _अछि_, _urchin_, _kecepata, _baterie_,
   {{0x5317f007,0x730c2017,0xcbcc200c,0x2aa6300d}},	//   _pouze_, _romanos_, _अवश्य__ही_, _ako__môžem_,
   {{0x6225e01d,0x86e62010,0x00000000,0x00000000}},	// [490] _nitko_, _suscribi, --, --,
   {{0xe4aae02a,0x6494e014,0x1494e021,0xa38f8011}},	//   _den__er_, _km__de_, _ta__med_, _lesi__senzo_,
   {{0xe2855003,0x548d5021,0xd257100e,0xb574f021}},	//   _umxholo_, _snakke__om_, _དུས__བཀག_, _nettverk,
   {{0x46a5400f,0x2b80a02b,0x00000000,0x00000000}},	//   _kurushah, _དངོས__མཐོང_, --, --,
   {{0x7c755010,0xdba3600f,0x72903015,0x33372010}},	//   _algunos_, _imikorer, _semasa_, _la__acción_,
   {{0xc26dc004,0xe49f602a,0xd27f5011,0x24dc200c}},	//   _novo_, _får__du_, _ehamba__phambili_, _उत्पादों_,
   {{0xd47c8015,0xede62005,0x92ca6016,0x647e1005}},	//   _oleh__itu_, _као__што_, _apod_, _нико_,
   {{0xc5802004,0x1d31700b,0x5f315005,0x6a615014}},	//   _informaç, _གི__སྐོར_, _од__преко_, _algúns_,
   {{0xa442903a,0x64427034,0x64b1902a,0xebcbb02b}},	//   _nya_, _syn_, _eller__for_, _བཞག__གི_,
   {{0x1d8f300e,0xebe6c00c,0xe68f300b,0x0041a00c}},	//   _བཏུས_, _और__इस_, _བཏུབ_, _से__प्राप्त_,
   {{0xd4429031,0x6b6bb01c,0xd7082004,0x64b6d010}},	//   _aya_, _kedokter, _impressã, _junio__de_,
   {{0xe442900f,0x4b935010,0xadd47005,0x91f52005}},	//   _bya_, _haciendo_, _то__су_, _смрти_,
   {{0xf442900f,0x8e74900b,0xf4bd102a,0x4bdd800e}},	//   _cya_, _རྒྱང__བསྒྲགས_, _hvis__jeg_, _ཚུལ__ལོ_,
   {{0xfd82c00e,0x10119004,0x00000000,0x00000000}},	//   _སྒྲོག_, _do__país_, --, --,
   {{0x738b203b,0xfdc5900e,0x9747a005,0x646dd004}},	//   _førte_, _ལོར__སྐྱེས_, _ограниче, _linha__de_,
   {{0xb8c50004,0x2b1a7010,0x00000000,0x00000000}},	//   _governad, _propuest, --, --,
   {{0x6c06600c,0x246a202a,0xf269600f,0x00000000}},	// [4a0] _किसी__भी_, _jeg__kan_, _cyane__mugihe_, --,
   {{0xfb8da02b,0x2394f013,0x32d8b003,0x2eecf005}},	//   _གླ_, _spisak_, _iwced_, _чега__је_,
   {{0xc3eb8038,0x8eac6005,0xd4aae004,0x00000000}},	//   _vart_, _већи__број_, _você__só_, --,
   {{0x8473b003,0x7ca3f010,0x00000000,0x00000000}},	//   _umzekelo_, _que__algunos_, --, --,
   {{0x1029f002,0x2c48600c,0x7662000b,0x00000000}},	//   _मुँह_, _लिये_, _གནང__ཡོདཔ_, --,
   {{0x7b3f0005,0x73401014,0xa5a68007,0xfbe6d00c}},	//   _domaćins_prosečan_, _licenza_, _připomín, _और__उस_,
   {{0x8231a003,0x6475e010,0xf5bd8004,0x9f543014}},	//   _kwimeko_, _uno__de_, _encaminh, _nalgúns_,
   {{0x49786010,0xd346302a,0xe2905023,0x92490014}},	//   _administ, _eller__ikke_, _kelab_, _alemá_,
   {{0xe26dc004,0xb47f1004,0x00000000,0x00000000}},	//   _povo_, _interess_em_, --, --,
   {{0x4b908007,0xdc1c302f,0x0b629005,0x2c992005}},	//   _prostřed, _nitrians, _пре__него_, _краљевск,
   {{0xe3f82007,0x42d8b030,0x53e34019,0x726d8013}},	//   _pokud_, _ordene_, _de__nós_, _narod_,
   {{0x396d6014,0xfe70401e,0x348f500d,0x00000000}},	//   _habitant, _कोर्ट_, _týkajúce__sa_, --,
   {{0x32b4900d,0xa26e502e,0xda3dd00a,0xe74ed005}},	//   _viac_, _gutora_, _सकत_, _прави_,
   {{0x24429008,0x51b8300a,0xf243a020,0x22fce023}},	//   _vya_, _लागल_, _གླང_, _mangsa_,
   {{0x3297c005,0x79765004,0xad7ef005,0x6b000014}},	//   _износила__становни, _atendime, _су_, _se__converte,
   {{0x7e45c00f,0x249a400f,0x3482f02a,0xfd808003}},	//   _bigaraga, _ubushinj, _eksempel__på_, _ithunyel_ngurober,
   {{0x32480011,0x1442901b,0x127e9013,0x809f000b}},	// [4b0] _ulimi_, _uya_, _hrane_, _གཞུང__གྲྭ_,
   {{0xd242b00b,0x2b2ab00e,0x229d1010,0xe43e1005}},	//   _བླམ_, _སྐུ__གཤེགས_, _más__grande_, _тачно_,
   {{0xb2f2d023,0xb4426003,0xe8507014,0xfafa5023}},	//   _bermula__pada_, _oko_, _algunhas_, _pengerus,
   {{0xe2a16011,0xfe61c004,0x424c700e,0xb3d4e021}},	//   _okubalwa__kuzo_, _trabalha, _ཇུས_, _av__andre_,
   {{0x7b8cb00e,0x1d0f701d,0x93fcf010,0x00000000}},	//   _དྲ_, _pomozite_, _una__nueva_, --,
   {{0xd442600d,0xe4b3602a,0xe25a400b,0xe376c005}},	//   _ako_, _ser__du_, _ཟེར__བཤད_, _српског_,
   {{0xf2cde013,0xb47d9035,0xf8f69005,0xb2b8a011}},	//   _na__jednu_, _ngonyaka__ka_, _је__поставил, _njengoba__iqembu_,
   {{0x42848011,0xdf26b01d,0xc26a8020,0xf6ffa00a}},	//   _kulo__mcimbi_, _gađajte_, _ཙམ__གྱི_, _एइजा_,
   {{0x228f8007,0x647ff004,0xc089d005,0x00000000}},	//   _takové_, _profissi_de_, _режирао_, --,
   {{0x0495002a,0x7a6e800c,0xe394703b,0xed019023}},	//   _og__det_, _होते__हैं_, _fanst_, _maklumat_,
   {{0x601b9014,0x8bc2f00a,0xa46c8011,0x17d5c011}},	//   _nas__elección, _ओने_, _kusho__abezimo_, _amaphoyi,
   {{0xa3eaf038,0x111b800c,0x98b30027,0xc9f67021}},	//   _heiter_, _इसके__अलावा_, _bertukar_, _besøk_,
   {{0x5374e011,0x4bd8000e,0x8821d020,0x02ace02b}},	//   _orlando__pirates_, _རེད__ལོ_, _དཀྱིལ_, _སྟེ__ཡོད_,
   {{0xa3ce4037,0x8339e014,0x646ed004,0x00000000}},	//   _kumva_, _da__familia_, _dicas__de_, --,
   {{0x0b9e300c,0xf30dc027,0x1730400c,0xabdd9024}},	//   _एक__और_, _membina_, _उपयोग__किया_, _དངོས__དེ_,
   {{0x9212b007,0x0340b021,0xb3f5e02a,0xd2bb300e}},	//   _bych_, _det__enkelt_, _til__andre_, _བུ__ཡིན_,
   {{0xf29ea005,0xea298003,0x298e7005,0x00000000}},	// [4c0] _zemlje__masa_, _iipesent_ezingama_, _дати_, --,
   {{0xd3dc900f,0xc23bf013,0xa316d00d,0x65ee1014}},	//   _ikawa_, _godine__broj_, _naozaj_, _produció,
   {{0x136af021,0xf2502005,0x1c802005,0x415be005}},	//   _tjene__penger_, _жена_, _жене_, _сматрају_,
   {{0xecdd100e,0x54685011,0x7be4600b,0x741c7010}},	//   _གྲོང__ཁྱེར_, _isicoco__se_, _བཙུགས__ནི_, _el__nuevo_,
   {{0x6be36022,0x47b3e00f,0xab22d021,0xe35f6004}},	//   _comentar, _ararangi, _kampanje, _de__domínio_,
   {{0xc3f1a02e,0xd341402a,0xa2003009,0xb31b9003}},	//   _uburundi_, _kan__ikke_, _komisi_, _ethengis_izindlu_,
   {{0xbb9e500c,0x33cf5010,0x6bd5700e,0xc2937007}},	//   _इंटरनेट__पर_, _nuevas_, _ཀུན__ཏུ_, _konsolid_dluhů_,
   {{0x23bad00f,0xa574202f,0xdb8d300e,0x66350021}},	//   _muri__rusange_, _liptovsk, _ཟི_, _besøkend,
   {{0x88700032,0x00000000,0x00000000,0x00000000}},	//   _músicas_, --, --, --,
   {{0x83b3d01d,0xd340c02a,0x24258011,0x5eb3c01c}},	//   _travanj_, _har__ikke_, _lezi__zinto_, _filsafat_,
   {{0x0442601d,0xda5ea005,0xd2d60003,0x52da600f}},	//   _tko_, _imala__kapacite, _olu__hlobo_, _turere_,
   {{0x6a56500c,0x438ca004,0x77f00010,0x64b5b010}},	//   _है__तथा_, _de__janeiro_, _la__industri, _director__de_,
   {{0x5375e036,0xe316600f,0x52b3802c,0x92026005}},	//   _ovo__naselje_, _kuri__wewe_, _condado_, _aprila_,
   {{0xd495202a,0x70b2300d,0x9c6f102c,0xc94f1014}},	//   _om__den_, _reštaurá, _emprega_, _empregar_,
   {{0x3473f021,0xb450e021,0x1280a021,0x00000000}},	//   _deg__på_, _viktig__at_, _brukere_, --,
   {{0x6400e00b,0xc25ec00b,0xea90e00b,0x3becf00c}},	//   _འབྲུག__རྒྱལ_, _ལེན__འབད_, _འབྲུག__རྒྱང_, _आपको__यह_,
   {{0x547f2014,0x12e6400c,0x5791f019,0xd4a1902a}},	// [4d0] _unha__vez_, _की__सूची_, _institui, _når__den_,
   {{0x427f5010,0x1ee2e010,0x13083004,0x00000000}},	//   _buenas_, _muy__importan, _sobre__esse_, --,
   {{0xc320a007,0x53661007,0xe29a600b,0xd4be6004}},	//   _nebyl_, _je__pouze_, _གསུངས__གནང_, _isso__que_,
   {{0x2b8a2005,0xaddc0004,0x00000000,0x00000000}},	//   _којој_, _de__telefone_, --, --,
   {{0x339c3009,0xebb61014,0xa998d00d,0x54835021}},	//   _pada__tanggal_, _da__historia_, _tiež_, _vite__om_,
   {{0x8290c038,0x42370010,0x3200c023,0x930e4014}},	//   _medan_, _viajes_, _sedia_, _engadir_,
   {{0xcb18201c,0x62005027,0x00000000,0x00000000}},	//   _sebagian_, _belia_, --, --,
   {{0x0337300c,0xdbb8100e,0x00000000,0x00000000}},	//   _प्रदान__करती_, _ཇོ__བོ_, --, --,
   {{0x6242800b,0xb1e4f011,0x22025014,0x7101c005}},	//   _དགོ_, _avele__enkantol, _obtivo_, _свету_,
   {{0x526ca013,0x643b000b,0x32a66004,0x00000000}},	//   _izbor_, _ཨིན__རྒྱལ_, _você__mesmo_, --,
   {{0x6386c03b,0x1c4d8014,0x7439a021,0x8af39014}},	//   _gjorde_, _de__persoas_, _er__sant_, _estranxe,
   {{0x33ebe038,0x8243900a,0x4473a021,0x238ca014}},	//   _nytta_, _दिहलन_, _som__gir_, _de__xaneiro_,
   {{0x8442d00f,0x143c1011,0x522a1005,0x00000000}},	//   _jye_, _lo__muntu_, _пола_, --,
   {{0x92b86053,0xa442903a,0x82d86054,0xac486002}},	//   _लागू_, _eka_, _लागी_, _लागे_,
   {{0xf2eed030,0x12484038,0xa664b00d,0x2478d021}},	//   _treff_, _somme_, _služieb_, _dine__og_,
   {{0x67c7a02b,0x224d0005,0x66bad00c,0x00000000}},	//   _ལས__འཛིན_, _се__могу_, _एक__बहुत_, --,
   {{0x4470f01c,0x6d23f00d,0x2fc3f014,0x00000000}},	// [4e0] _kecamata_ini_, _ponúkame_, _saír_, --,
   {{0xc5d3f014,0xc2c5f023,0xb3007023,0x525be005}},	//   _de__poboació, _pada__julai_, _senarai_, _međuviki_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0442d037,0x67f5c00b,0x00000000,0x00000000}},	//   _bye_, _འགོ__དཔོན_, --, --,
   {{0x32fdd003,0x1442d00f,0xa386d010,0x32d8c017}},	//   _emzantsi_, _cye_, _enero_, _aldea_,
   {{0x72d83026,0xc9d9200e,0x546bc007,0x3f2fb010}},	//   _gdje_, _ཀྲུང__གོའི_, _protože__se_, _con__nosotros_,
   {{0x82429024,0x64b4c010,0x00000000,0x00000000}},	//   _བགོ_, _estudian_de_, --, --,
   {{0x0f411023,0xb2fc0037,0x2a330002,0x131d800f}},	//   _boleh__menyumba, _ikigo_, _चना_, _ibiciro_,
   {{0xbe0b100b,0x04885007,0x184cc00b,0x834c2007}},	//   _བརྒྱའི_, _chcete__li_, _དང__འཁྲིལ_, _cestovní_,
   {{0xe26c7016,0x92ecb01c,0xfb23501c,0x7301c00d}},	//   _brno_, _periode_, _dibangun_, _údajov_,
   {{0xd5fdd011,0x2394d00f,0x2eba4005,0x2eae4005}},	//   _enkantol_yemantsh, _mbese_, _имао__је_, _тако__је_,
   {{0x62752011,0x2f53d005,0x00000000,0x00000000}},	//   _zonke__lezi_, _коначно_, --, --,
   {{0x526e6034,0x3757200c,0x09434005,0xa784900c}},	//   _europa_, _जा__सकता_, _међунаро, _दिया__जाता_,
   {{0xbd23e00f,0x652c1028,0x377fd00b,0xfbd6600b}},	//   _umusarur, _términos_, _གཤམ__འཁོད_, _ཤོག__པར_,
   {{0xc291c012,0x92ba501c,0xe1ee700c,0x4af7800e}},	//   _vrijeme_, _pendiri_, _के__अंदर_, _ལྷོ__ཕྱོགས_,
   {{0xa991f003,0x2ccc800c,0x00000000,0x00000000}},	//   _isihlome, _पेशकश__करते_, --, --,
   {{0xe2428020,0x64957007,0xfa25400a,0x00000000}},	// [4f0] _དགུ_, _se__že_, _रामबदन_, --,
   {{0x0442d00f,0x91848005,0x07b99005,0x8243400e}},	//   _rye_, _природно__станиште_, _од__метра_, _བྲལ_,
   {{0x2dd8a00e,0x925ad014,0x0a7c800c,0x0dfc0018}},	//   _བཅུ__གཉིས_, _mellor_, _वर्षों__में_, _མི__དགོས_,
   {{0x12cbf010,0x334ba02a,0xa2868003,0xaba5800b}},	//   _ayuda_, _er__mange_, _yonke__imihla_, _སྒྲོམ__ཨང_,
   {{0xd27bb00e,0x6750800e,0x6cb2500c,0x00000000}},	//   _དེ__ཡིན_, _སྒེར__གཅོད_, _सुनिश्चि_करने_, --,
   {{0xf52e600f,0x3262f011,0xe46e1011,0xc44d5010}},	//   _abayoboz, _uthe__ngeke_, _okusolak_ukuthi_, _tienen__un_,
   {{0x4d32e005,0x0bc1400c,0xd4662004,0x7eaef005}},	//   _току__последњи, _सकती__है_, _maioria__das_, _спомениц,
   {{0x1a5c6027,0xab98e02b,0x4370d004,0x00000000}},	//   _di__malaysia_, _གི__དགོངས_, _do__século_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc2da7003,0xc3aaa030,0x32b16021,0x1b88d00a}},	//   _siseko_, _servere_, _bare__noen_, _नऽ_,
   {{0x22e38005,0x5b31202a,0xabdaa004,0xd4e8f00c}},	//   _knjige__narodni_, _er__interess, _decisão_, _के__मध्य_,
   {{0x069c2005,0x0adc2005,0x2f1c2005,0xb5ac8003}},	//   _opština_, _opštine_, _opštini_, _zengqesh,
   {{0xb6cc8008,0x84271014,0xa46f3023,0x9ba6c00e}},	//   _imigambw, _polo__tanto_, _laman__web_, _ལའི__བླ_,
   {{0xd2c20014,0x00000000,0x00000000,0x00000000}},	//   _os__datos_, --, --, --,
   {{0x9a092031,0xe7d0c027,0x93404019,0x32fdd003}},	//   _yabasebe, _tanggung, _poderia_, _umzantsi_,
   {{0x6a6e100c,0x163f300d,0x0ac3d00c,0x2b421040}},	//   _पूरी__तरह_, _kalendár_, _व्यवसाय__में_, _doporuči,
   {{0x73ced010,0x1201b03a,0x1ca19004,0x41f1b00b}},	// [500] _nuevo_, _amwita_, _em__contato_, _རྒྱལཔོ_,
   {{0x2eeae005,0xe394d004,0x6492d010,0xcda8800b}},	//   _док__је_, _grosso_, _tiempo__de_, _ནང__གཞིས_,
   {{0x506d3005,0x50b63005,0xf524d00a,0xe44ad003}},	//   _је__године_, _од__године_, _छोड़ीं_, _namphi__na_,
   {{0xb699f013,0xa3ebe021,0x927ed028,0x3a33d02d}},	//   _broja__stanovni, _satt_, _bueno_, _जनम_,
   {{0xd26c0004,0x646d8021,0x82ec6007,0x3a9bb014}},	//   _maio_, _verktøy__for_, _kterých_, _xornalis,
   {{0x2c0b800d,0xc48cd026,0x4ed26005,0x2364800d}},	//   _približn, _pjesma__je_, _да__не_, _rozšíren,
   {{0x39f52004,0x647ca010,0x9c6bf00c,0x00000000}},	//   _vocês_, _para__sus_, _कि__उनके_, --,
   {{0x63910005,0x00000000,0x00000000,0x00000000}},	//   _свих_, --, --, --,
   {{0xc6fe700a,0x24723007,0xe3415030,0x7b97f00e}},	//   _ओकरा_, _libereck, _videoen_, _རྣམས__ནི_,
   {{0x0394e037,0x7ed2e005,0xb926400d,0x25506007}},	//   _kristo_, _би__се_, _odpoveď_, _měsíců_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x52493007,0xb3cae003,0x43563003,0x22bfb00e}},	//   _přihláše, _eli__phepha_, _kuwo__onke_, _ཨུ__ཡོན_,
   {{0x021ea01d,0x3da7800d,0x27ed300f,0x33cef013}},	//   _ostali__projekti_, _keď_, _mafarang, _živeo_,
   {{0xc2904026,0x9a5cb027,0xd479b023,0x6a9b300c}},	//   _nemam_, _lebih__daripada_, _merupaka_ke_, _जा__रहा_,
   {{0xc251d018,0xf38a1015,0x56fee00a,0xe4b08003}},	//   _ཡིན__པའི_, _merupaka_sejenis_, _कवना_, _konke__oku_,
   {{0x758a000d,0xda01b00f,0x84946021,0x07a2b010}},	//   _registrá, _imbaraga_, _må__ha_, _la__tecnolog,
   {{0xb3af7034,0x00000000,0x00000000,0x00000000}},	// [510] _solveig_, --, --, --,
   {{0x6495602a,0xf46f600f,0x64565022,0x94bd2011}},	//   _og__de_, _ibyemezo_, _sitios__de_, _usihlalo__we_,
   {{0x6b8d8024,0xa248d021,0xfc9e8003,0x89e1700d}},	//   _ཁར_, _filmer_, _ngenisa__amanqaku_, _sa__rozhodne,
   {{0xe493602a,0x9be3e00e,0x7b210005,0x8efdf00d}},	//   _er__du_, _བྱས__ཏེ_, _prosečan_, _mobilnýc_telefóno,
   {{0x22c49023,0xeb36e010,0x00000000,0x00000000}},	//   _sehingga__anda_, _lo__siguient, --, --,
   {{0x9bcff02b,0xc407e005,0x00000000,0x00000000}},	//   _ཚོང__ལས_, _градова_, --, --,
   {{0xe474602a,0x530ea003,0x2274b00e,0xcde00018}},	//   _som__du_, _ukuba__kunjalo_, _ཕལ__ཆེར_, _རྣལ__འབྱོར_,
   {{0xa9e6f00d,0x00000000,0x00000000,0x00000000}},	//   _je__tiež_, --, --, --,
   {{0x3c9ac02b,0x1d8fc00e,0xbc06000c,0x8fde3007}},	//   _འཚོལ_, _བཟོས_, _आधार__पर_, _vytiskno,
   {{0xc46be02a,0x9bfe200b,0x00000000,0x00000000}},	//   _fra__en_, _ིལ__ཏེ_, --, --,
   {{0x23fa1003,0xd4ba5005,0x2358700d,0x729e1005}},	//   _nkqubo_, _satelita__pri_, _potrebné_, _сина_,
   {{0x9f861023,0x51d8d00a,0x62d87007,0x6245b004}},	//   _anda__mempunya, _राउर_, _konec_, _têm_,
   {{0xd6dcf00a,0xabba5024,0x8bba8010,0xc438c010}},	//   _बाकिर_, _ལས__ཚན_, _el__aeropuer, _el__sector_,
   {{0x3037d003,0x63027014,0x1fc3f010,0xbc66a00c}},	//   _lentshon, _dos__cales_, _ahí_, _वे__अपने_,
   {{0x3499e00d,0x5495602a,0xc24d4011,0x32021030}},	//   _to__sa_, _og__se_, _nonkosik_wakhe_, _kopier_,
   {{0xe4b4602a,0xd27ee003,0x32903009,0xc70ba00b}},	//   _vil__du_, _printa_, _romawi_, _ཁང__བརྙན_,
   {{0x6bd0700e,0x7243300b,0x52a4000e,0xc243800b}},	// [520] _རྟག__ཏུ_, _ཟླཝ_, _འདུ__ཤེས_, _ཀྲར_,
   {{0x0b499044,0x7245c016,0xe46ae00d,0x18605036}},	//   _राष्ट्री, _tím_, _ako__na_, _manastir_,
   {{0xf35bf028,0x845fc011,0xf4710005,0x0c12700c}},	//   _ninguna_, _amathuba__okuthi_, _prosečna_, _व्यवसाय__को_,
   {{0xa33d9023,0xb2957003,0x5450b007,0xcbdf100c}},	//   _haiwan__yang_, _ukuba__akukho_, _týkající_se_, _आज__ही_,
   {{0xa26c201d,0x44a7d013,0xd11c700d,0x00000000}},	//   _iako_, _trebalo__da_, _dôležité_, --,
   {{0x43083010,0x9242a024,0x7f783010,0x1ac4700d}},	//   _trabajo_, _ཐིམ_, _trabajos_, _zapamäta,
   {{0x375e5024,0x64516004,0x2f21f00e,0xc2786011}},	//   _ཨོ__རྒྱན_, _roupas__de_, _ནོར__འཁྲུལ_, _ilunga_,
   {{0xb26c2007,0x34825011,0x7f1ff00d,0xb3dde00f}},	//   _jako_, _uthe__lo_, _oblečeni, _natwe_,
   {{0x92cb5026,0xcda78007,0xb386c038,0x00000000}},	//   _negdje_, _teď_, _endra_, --,
   {{0x34d5601a,0x9c4d0014,0x0b9da00c,0x3fae800d}},	//   _वीडियो_, _pouco__despois_, _को__कम_, _obyvateľ,
   {{0xf5a0300f,0x8a87a011,0x00000000,0x00000000}},	//   _igisubiz, _amazinga_, --, --,
   {{0xf26c2031,0x63ce9013,0x4314e004,0xced2f011}},	//   _nako_, _pravo_, _negócios_, _zemfundo__ephakeme_,
   {{0xbb03b010,0x2bfc601d,0x7c6f6028,0x22cf1004}},	//   _herramie, _zvjezdic, _carrera_, _site__para_,
   {{0xee125033,0xcad52005,0xc9d4d00d,0x00000000}},	//   _på__markedet_, _на__почетку_, _umiestne, --,
   {{0x0fbad007,0x62e3a011,0x1c51e02c,0x00000000}},	//   _zařízení_, _thulani__zwane_, _contaba_, --,
   {{0xcfbdf004,0x5200701c,0xa3209003,0xabc2800a}},	//   _três_, _menit_, _umay_, _ओही_,
   {{0x0b2fc020,0x61efc00b,0x3c2e5010,0x00000000}},	// [530] _བཟུང_, _བཟུམ_, _más__rápido_, --,
   {{0xfc49200a,0x8201c00f,0x52fd8028,0xa2005026}},	//   _बाटे_, _ubuhinzi_, _cargo_, _zelim_,
   {{0x8d0fa01d,0xb2489009,0xf3c3b004,0x4357d011}},	//   _pogodite_, _alami_, _nível_, _kanye__nezinye_,
   {{0x346ae00d,0x94314023,0xe4678011,0x6c58700c}},	//   _ako__sa_, _mewujudk_sebuah_, _uveze__ukuthi_, _भुगतान__करने_,
   {{0xfd136010,0x9290b023,0x43232017,0x8f13202c}},	//   _consider, _sedaya_, _século_, _séculos_,
   {{0xd47f6014,0x324c600e,0xed00e012,0x84912004}},	//   _polo__que_, _ཆུབ_, _promjene_, _coração_,
   {{0x84b6f023,0x71b8300a,0x432c9021,0x131a1010}},	//   _berkuali_di_, _लिहल_, _se__etter_, _la__ayuda_,
   {{0x2dc3a006,0x42e3200d,0x03026003,0xd4afa00f}},	//   _disingka, _peniaze_, _elisekwe__ekhaya_, _urubuga__rwa_,
   {{0xfa0fe01c,0xd2b18003,0xd250c005,0x00000000}},	//   _manajeme, _cofa__icon_, _један_, --,
   {{0x5350102a,0xe2dd5003,0xc29b802b,0xcbc2800a}},	//   _ikke__bare_, _kufuneka__ukuba_, _དཔྱད__ཡིག_, _ओहू_,
   {{0x6b8ea00b,0xfbf0d00b,0x64779022,0x00000000}},	//   _ིན_, _གས__དང_, _informac_de_, --,
   {{0xe358101c,0x56331028,0x0bd0800b,0x00000000}},	//   _amerika__serikat_, _bienveni, _འོག__ལུ_, --,
   {{0x4408c007,0x31b8d00a,0x9b9d8018,0x00000000}},	//   _na__serveru_, _राखल_, _ཡོད__ཚད_, --,
   {{0x1c53f004,0xc3145014,0xaa9b100c,0xf3916010}},	//   _contato_, _un__cordial_, _में__कुछ_, _de__windows_,
   {{0x06ea4005,0x7ea3f017,0xc2926013,0x548cd007}},	//   _je__opština_, _soldados_, _upravo_, _abyste__se_,
   {{0xc452800f,0xd7cb7018,0x00000000,0x00000000}},	//   _yo__murugo_, _དུ__ཕྱིན_, --, --,
   {{0x326c3010,0x6df15010,0x00000000,0x00000000}},	// [540] _bajo_, _préstamo__hipoteca, --, --,
   {{0x56152007,0x13ead003,0xca33a00a,0xeb10000d}},	//   _příspěve, _abet_, _आईल_, _prostrie,
   {{0xc9f8f01d,0x526c2005,0x7a572007,0x4317f004}},	//   _milijuna_, _tako_, _peníze_, _souza_,
   {{0x8ed52005,0x4d5a2005,0xb802200b,0x00000000}},	//   _том_, _коме_, _ཀུ__འཐོན_, --,
   {{0xa26cd010,0x7491d00d,0x00000000,0x00000000}},	//   _creo_, _ktorý__si_, --, --,
   {{0x5d65f005,0x1beca00c,0xa28c600e,0x5b57c00b}},	//   _stanovni_prosječn, _पर__एक_, _འགའ__ཞིག_, _ལས__རྫོང_,
   {{0xa293e027,0x42010013,0x26658007,0xebf6800b}},	//   _kadang__kala_, _srbije_, _děkujeme_, _ཆུ__གི_,
   {{0xe2925013,0xf0373005,0x52721007,0xa1acc007}},	//   _ostalo_, _partizan, _přehráva, _pondělí_,
   {{0x426df010,0x5f9dd010,0x39ef2005,0x93ce0004}},	//   _autos_, _jóvenes_, _фирме__који_, _em__outros_,
   {{0xc272a024,0xeb8eb00b,0xe640e003,0x7711b00c}},	//   _ཟླ__པའི_, _ིལ_, _ekwi__intaneth, _होना__चाहिए_,
   {{0x93ced028,0x74012004,0xc2b3e004,0x00000000}},	//   _nueva_, _posição_, _se__não_, --,
   {{0xc3275011,0x00000000,0x00000000,0x00000000}},	//   _lo__mthombo_, --, --, --,
   {{0xa6f9100c,0x2493602a,0x71ba600a,0x5d61900a}},	//   _दिया_, _er__og_, _पड़ल_, _बताईं_,
   {{0x23329014,0xb8ae3005,0x00000000,0x00000000}},	//   _imaxe_, _сматра_, --, --,
   {{0x0c01600c,0xc2d84004,0x7f388003,0xec82e00c}},	//   _देता__है_, _homem_, _impumala, _की__समस्या_,
   {{0xc2d9002e,0x4bde0018,0xf54aa01b,0x00000000}},	//   _imbeba_, _ཀྱི__ལོ_, _kukhutsh, --,
   {{0x2415a003,0x0f25d030,0x7483e00f,0x22bdd010}},	// [550] _ezi__zinto_, _beklager_, _umurongo__wa_, _lo__mejor_,
   {{0xca33a002,0x23dc900f,0x44968007,0xc0cea00b}},	//   _आईं_, _cyawe_, _ti__kdo_, _ལུ__རྒྱ_,
   {{0x92430020,0xa8ddc005,0x72640016,0x26823022}},	//   _མགོ_, _iznosi__asteroid, _poslat_, _accesori,
   {{0x6847c005,0x5be6700e,0x5837c005,0x7a9c800c}},	//   _налази_, _གསུངས__སོ_, _налазе_, _चुके__हैं_,
   {{0x82db3014,0xa092b00e,0x1c538014,0x4843802c}},	//   _de__unha_, _པདྨ_, _contido_, _contidos_,
   {{0xb27ed010,0x2277d013,0xc2011036,0xa315e004}},	//   _buena_, _maksimal, _srbiju_, _horário_,
   {{0x4b88200a,0xe2fb2003,0x00000000,0x00000000}},	//   _नू_, _liphela_, --, --,
   {{0xab029034,0xe3f4b007,0x9cc3900b,0xbef2c005}},	//   _samfunns, _jen__pár_, _ཕྱིའི__དངུལ_, _хвала_,
   {{0xf37d2014,0xc2c93023,0x4497a004,0x12a7f014}},	//   _de__orixe_, _saje__jika_, _criação_, _houbo_,
   {{0x67aeb00b,0xd963e01d,0xc3eb2010,0x33f86007}},	//   _དུས__སྟོན_, _prosinac_, _sector_, _dvou_,
   {{0xd343403b,0xfc52f030,0x7352300b,0x00000000}},	//   _likevel_, _kontoen_, _ལོ__བསྟར_, --,
   {{0xd2906015,0x02257038,0xe3083010,0x0f733010}},	//   _beliau__telah_, _snakka_, _que__desee_, _las__páginas_,
   {{0x4e28e005,0x4c48f00a,0x2273c00b,0xd942f00d}},	//   _па_, _हमके_, _ཕབ__ལེན_, _vyhlásen,
   {{0xe483b005,0xc2c53024,0x23a6900d,0x62922003}},	//   _prostire__na_, _ཚུགས__པའི_, _je__potrebné_, _inqaku_,
   {{0xf26c500d,0x1387b004,0x75c54015,0xc03f6010}},	//   _malo_, _livros_, _memboleh, _los__producto,
   {{0x9037302f,0x424da00e,0xa2fdf013,0x77cbb00e}},	//   _cestovan, _ཧོར_, _drugi_, _དུ__བྱོན_,
   {{0xb2909018,0x8102801d,0x00000000,0x00000000}},	// [560] _བོད__ཀྱི_, _lančana_, --, --,
   {{0x44302004,0x94612027,0x4473d005,0xf2d85007}},	//   _processo_, _ialah__sebuah_, _mogao__da_, _kolem_,
   {{0x3335e055,0x97ce0014,0x4ea36028,0x82913014}},	//   _विधानसभा_, _lugares__parroqui, _mañana_, _sexan_,
   {{0x6a247021,0xf303e010,0xe4a67033,0xb4ae2023}},	//   _på__nettsted, _regístra, _forhold__til_, _jawatank,
   {{0xa314702a,0xb4b2502a,0x3bcfe004,0x42d83014}},	//   _over__hele_, _eller__to_, _seminári, _comeza_,
   {{0x9bfa400b,0x00000000,0x00000000,0x00000000}},	//   _ོར__ལས_, --, --, --,
   {{0x23f86007,0x2e706005,0x2ec65005,0xf05f1007}},	//   _svou_, _је__из_, _ју__је_, _co__potřebuj,
   {{0x4aed800e,0x12120005,0x026d4007,0xd16aa00d}},	//   _ཕྱི__ཕྱོགས_, _njih_, _jehož_, _je__dôležité_,
   {{0xf2c69014,0x1ae69014,0xf3b68004,0x00000000}},	//   _inclúe_, _inclúen_, _as__imagens_, --,
   {{0x7473e00d,0xe46a3011,0x35eec014,0x02d56003}},	//   _ste__si_, _okulinde_ukuthi_, _tradució, _oktobha_,
   {{0x03d4902a,0x6df22024,0x67ec800e,0x54647011}},	//   _en__stor_, _གི__འཐུས_, _བཞིན__འཛིན_, _kuphela__nje_,
   {{0x123be007,0xfa890023,0xcb8dd024,0x08e22005}},	//   _můj_, _perisian_, _ཝི_, _поруке_,
   {{0x93f62014,0x37652005,0x9b8d6020,0x9a595004}},	//   _tamén__outros_, _је__астероид, _ཕྲ_, _agora__você_,
   {{0x92a0700b,0xbf33400b,0xc263202b,0xfbde0018}},	//   _གཙོའི__བཙག_, _ལུ__འབྲུག_, _དང__པའི_, _མངོན__པར_,
   {{0xccee3005,0xc2d85023,0x3adba013,0xa26c300e}},	//   _град_, _kolej_, _zvanično_, _ཅི__ཞིག_,
   {{0x16f96056,0x1add4018,0xa3f87011,0xbb51d010}},	//   _साझा_, _རྟོགས_, _umnuz_, _la__herramie,
   {{0xdf091021,0x7e5d6006,0xc252600e,0x6722c017}},	// [570] _du__gjør_, _tercatat_, _དགོན__གྱི_, _aparició,
   {{0x5c494016,0xd21d701c,0x8ea67005,0xde8ce005}},	//   _दिने_, _maskapai_, _просечан__број_, _је__већ_,
   {{0xc0114028,0xeadad00e,0x8a32800a,0xe493000d}},	//   _producto, _ཡོད__འདུག_, _ओहि_, _použiť__na_,
   {{0x32a79005,0x02ca301d,0xc44cc007,0xdeea1021}},	//   _броја__становни, _internac_linkovi_, _mě_, _som__gjør_,
   {{0x906bf005,0x8b0bc00d,0xca6c900c,0x00000000}},	//   _на__википеди, _spojenýc_štátov_, _इससे__कोई_, --,
   {{0x72eaa021,0xc46ab021,0x14152007,0x12318005}},	//   _for__barn_, _gjøre__dem_, _tomu__abyste_, _септембр,
   {{0xd44cc007,0x00000000,0x00000000,0x00000000}},	//   _ně_, --, --, --,
   {{0x6b8e501e,0xee3d8007,0x0ab1500c,0xab5bb00e}},	//   _इन_, _přejít_, _जीवन__में_, _དུ__བྱུང_,
   {{0x4f4e0005,0xd2de0028,0xd4b07010,0xa2a9f00b}},	//   _насељено_, _por__alto_, _puede__que_, _གི__བཟའ_,
   {{0xfe731005,0xc2a22011,0xfa33000c,0x00000000}},	//   _део_, _okubalwa__kuwo_, _टैग_, --,
   {{0xc495e02a,0xd3e9b019,0xd2ad8011,0x00000000}},	//   _på__en_, _artigos__sobre_, _esihamba__phambili_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x62d82021,0xa61e4010,0x24b3e021,0xebb5200c}},	//   _boken_, _reconoci, _opp__og_, _आयु__के_,
   {{0xee325005,0x37f64003,0x7eb8b005,0xa1e6000c}},	//   _може__да_, _kunye__nokwenzi, _сматра__се_, _गैलरी_,
   {{0xb263500e,0xb22a2005,0x64b99010,0x00000000}},	//   _ལྗོངས__ཀྱི_, _доба_, _seguimie_de_, --,
   {{0x50c01005,0x2e8e9005,0x1bd0900e,0x42e62011}},	//   _источној__године_, _скениран_из_, _ཐོག__ནས_, _lo__msakazi_,
   {{0xe26c702e,0x6ddc900b,0xb25e4010,0x00000000}},	// [580] _kano_, _སོན__རིགས_, _de__muchos_, --,
   {{0xa2480038,0x82494011,0x00000000,0x00000000}},	//   _heim_, _isigwebo__sakhe_, --, --,
   {{0x22cd5023,0xd20e2005,0xe98e2005,0x00000000}},	//   _sini__anda_, _дана_, _дани_, --,
   {{0xd2fc7038,0xf4ab202a,0xfc036009,0xc2c34004}},	//   _lang_, _han__var_, _lampung_, _um__tipo_,
   {{0x0bff400c,0x9387e007,0x04007027,0x73160004}},	//   _करती__है_, _petr_, _kegunaan_, _juiz_,
   {{0xd379900d,0x25c2d005,0x5a549004,0x00000000}},	//   _pridať_, _књига_, _de__propried, --,
   {{0x62c66023,0x93160004,0xb26cb003,0x7db9b02f}},	//   _lain__sila_, _luiz_, _iqabane__lakho_, _trenčian,
   {{0x7ec05005,0x1467a00d,0x5585b011,0x018c0011}},	//   _су__се_, _niečo__čo_, _esitatim_esikhish, _ngolwesi_olwedlul,
   {{0x4b2a1018,0x027f4010,0x1f1f3009,0xbca7a00c}},	//   _སྙིང_, _cuenta_, _komunita, _और__अपने_,
   {{0xa437b014,0xc331600c,0x9bd9b00c,0xe21cb011}},	//   _ao__leste_, _आप__किसी_, _कहा__कि_, _impilo__yakhe_,
   {{0x91ee4004,0xb877002b,0xe243800e,0xcab6e00c}},	//   _promoção_, _པའི__དབྱིན_, _ཀྲང_, _उपयोगकर्,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x50bdf005,0x12d85023,0x5f243005,0x9093f00e}},	//   _североис_године_, _boleh_, _septemba, _ཀརྨ_,
   {{0x8a867005,0x344cc007,0x941cf010,0xe991f00c}},	//   _istorijs, _tě_, _la__nueva_, _क्षेत्रो,
   {{0x9c63002c,0x7295a00b,0x00000000,0x00000000}},	//   _situado_, _གནས__འཆང_, --, --,
   {{0x23ead00d,0x02a29003,0x00000000,0x00000000}},	//   _svete_, _kunye__neemeko_, --, --,
   {{0xeb8e600c,0xf4d04005,0x689d3007,0xec036027}},	// [590] _इस_, _ма__према_, _soutěže_, _kampung_,
   {{0xe4abe02a,0x642f4005,0x842d7011,0xec03700c}},	//   _han__er_, _слатково_подручја_, _royal__zulu_, _अवधि__के_,
   {{0xb9507005,0x59c3f01d,0x654a100d,0x00000000}},	//   _дани__сећања_, _novčiće_, _webových__stránkac, --,
   {{0x94438045,0x04be002a,0x2ab1500d,0x7b8e601a}},	//   _dyr_, _hvis__det_, _telefóny_, _उन_,
   {{0x5e1b3010,0x70f88011,0xed271005,0x00000000}},	//   _animales_, _umkhandl, _сасвим_, --,
   {{0xb4bad049,0x33755011,0x62903010,0x021da02f}},	//   _ikke__at_, _we__ancyl_, _dejar_, _prešovsk,
   {{0xbb8f000b,0x93ac7014,0xd243900e,0xca4b600c}},	//   _ོན_, _entre__outros_, _ཁྲག_, _की__बात_,
   {{0x24aaa02a,0xc37cb00f,0x9c187014,0xfbb3300c}},	//   _det__kan_, _yasabye_, _despois_, _लोगों__से_,
   {{0x96ff600a,0x4c50402d,0x4981e029,0xe26ca00b}},	//   _जवना_, _कैसेट_, _deaktive, _ཅན__ཅིག_,
   {{0x32d80038,0x53954010,0x00000000,0x00000000}},	//   _seie_, _puesto_, --, --,
   {{0xf3958015,0xaa7db00d,0xabbe200c,0x0c00000c}},	//   _parsi_, _pričom_, _उपयोग__की_, _जीवन__को_,
   {{0x0ed59007,0x2f2b2007,0x93361021,0xf2687011}},	//   _již_, _více__než_, _noen__ting_, _utshele__leli_,
   {{0x34654005,0xfb8e700c,0x1724400c,0x25502005}},	//   _је__износила_, _उस_, _नहीं__किया_, _неколико_,
   {{0x9399e019,0xd22a1005,0x00000000,0x00000000}},	//   _até__agora_, _носач_, --, --,
   {{0x97325013,0x32f9e004,0x00000000,0x00000000}},	//   _jugoslov, _também__pode_, --, --,
   {{0x327ed021,0x04ba5021,0x84b6f00c,0x1f1c3028}},	//   _noen_, _hvem__som_, _शर्तें_, _de__anuncios_,
   {{0x6f081003,0xb4b46021,0x43205021,0x1c34600f}},	// [5a0] _kwi__inshuren, _vil__gi_, _være__veldig_, _asobanur,
   {{0x4a414005,0x8e6e6005,0x7474600d,0x8bfa700b}},	//   _једну__државу_, _мањи__број_, _som__si_, _ེད__གས_,
   {{0xe4a9b023,0x6c394028,0xfafa5015,0x22de5010}},	//   _kedua__dua_, _descripc, _pengurus, _la__semana_,
   {{0xaf53900d,0xdae4201f,0x025c600e,0xbc94d004}},	//   _byť_, _ingengab, _ཡོད__ཅིང_, _você__precisar,
   {{0xa4746033,0x33f02005,0x6cc8100c,0x30b74007}},	//   _som__vi_, _januar__mart_, _स्थापित__करने_, _rozměry_,
   {{0x3b8f100b,0xd2919027,0x4ef18028,0x00000000}},	//   _ོལ_, _kesan_, _la__mañana_, --,
   {{0xc2480010,0x3da21021,0xa28d600e,0x2270b004}},	//   _anime_, _egenskap, _ཆེན__ཞིག_, _por__email_,
   {{0x146b202a,0x41b8300a,0xf758000c,0x9b2d201c}},	//   _jeg__har_, _लिखल_, _प्रदान__करता_, _jembatan_,
   {{0x423f3003,0xebf7300b,0x549d1028,0x00000000}},	//   _kwaye__kukho_, _ཞུ__ཡི_, _aquí__se_, --,
   {{0xa25ad03b,0x0bc7100c,0x00000000,0x00000000}},	//   _hjelp_, _करना__और_, --, --,
   {{0xa42b601c,0x32cb4007,0x647dd02a,0x74b46021}},	//   _berperan_, _hledej_, _mens__de_, _vil__si_,
   {{0x1dbc000e,0xb7be2007,0x00000000,0x00000000}},	//   _ལས__བཏུས_, _ke__zvýšení_, --, --,
   {{0x8abbe017,0x00000000,0x00000000,0x00000000}},	//   _exército_, --, --, --,
   {{0x04b3d00f,0xc31c400f,0x04ad600d,0x74b19007}},	//   _nziza__yo_, _rimwe__narimwe_, _že__som_, _kteří__si_,
   {{0x04444040,0x0202600f,0xeb09402c,0x2169402c}},	//   _cz_, _harimo_, _composte, _composto,
   {{0x2291801c,0xd4b6e005,0x3277a010,0xe947c005}},	//   _peran_, _mesto__ma_, _una__forma_, _финале_,
   {{0x03959038,0xab8e202b,0x00000000,0x00000000}},	// [5b0] _viss_, _ཊར_, --, --,
   {{0x026ca008,0xb224901d,0x6addd004,0xe32a700f}},	//   _cabo_, _opaki_, _trânsito_, _pc__yawe_,
   {{0xc236f026,0xe45cf011,0x6471e014,0xc2259007}},	//   _svijet_, _kakhulu__ukuthi_, _febreiro__de_, _tisk_,
   {{0xc278b005,0x8c71400c,0x1be08018,0x62757011}},	//   _године__када_, _यह__आपके_, _དངོས__སུ_, _abalande_bakhe_,
   {{0x82c6c023,0xa290501c,0x42a01011,0x93ea000f}},	//   _menanyak_saya_, _gelar_, _kodwa__manje_, _kwita_,
   {{0x5291a006,0x0a15e02a,0x0290c023,0xc4800022}},	//   _depan_, _forbinde, _kedah_, _proporci_un_,
   {{0x72b5d003,0xf243a00e,0x3510a004,0x66d1d00e}},	//   _pgwc_, _གྲང_, _de__trabalho_, _མཁས__གྲུབ_,
   {{0xa202600f,0x0f279011,0x00000000,0x00000000}},	//   _barimo_, _phesheya__kwezilwa, --, --,
   {{0x4edc6028,0x1d20c00f,0xe2706024,0x49cb700b}},	//   _sociales_, _amashyir, _ལས__གནང_, _ཨེསི_,
   {{0x72905034,0x64ad202a,0xa26e900e,0x0493702a}},	//   _delar_, _her__for_, _ནི__བོད_, _og__vil_,
   {{0x72918004,0x3457e021,0xd31ac00d,0x5a28e011}},	//   _geral_, _penger__på_, _rôzne_, _wophiko__lwentsha_,
   {{0xb26cb008,0xe493702a,0xfda3a011,0x738fd010}},	//   _naco_, _og__til_, _ngemuva__kweminya, _el__cabello_,
   {{0xa0921019,0x1bcdd00c,0x00000000,0x00000000}},	//   _de__ferramen, _कार्य__कर_, --, --,
   {{0x22919009,0x87bfd004,0x459fd004,0x2f20f004}},	//   _pesan_, _próprio_, _própria_, _desempen,
   {{0x2cd67011,0xf25a0038,0x1f02d020,0xd5a7701a}},	//   _ngaphamb_kokuthi_, _heile_, _འཁྲུག_, _चाहते_,
   {{0x82787005,0xa9c2c00d,0x00000000,0x00000000}},	//   _светског__рата_, _pre__váš_, --, --,
   {{0x1aabe007,0xfee32005,0x42905004,0xe7c1a00f}},	// [5c0] _základní_, _она_, _pelas_, _mahugurw,
   {{0x83ee2021,0x94425003,0xa27ef003,0x00000000}},	//   _det__blir_, _njl_, _uninzi_, --,
   {{0xd2d85038,0xc477b005,0x52d82038,0x0490802a}},	//   _elles_, _naseljen_je_, _teke_, _få__det_,
   {{0x7eb8f005,0x6af8c005,0x00000000,0x00000000}},	//   _када__се_, _konstant, --, --,
   {{0x4f185005,0xee27a00b,0xd4b4f010,0x52d46010}},	//   _да__ли_, _ཁྐྲིམས_, _xml__que_, _han__sido_,
   {{0x6ba8c02b,0x026f7015,0x6386c030,0xbf37c009}},	//   _རྫོང__ཁག_, _digunaka_bagi_, _bidra_, _pemukima,
   {{0xe2318010,0x1290c015,0xd2322017,0x2e218028}},	//   _primero_, _kedai_, _chamado_, _primeros_,
   {{0x130f901f,0xfbdc200c,0x00000000,0x00000000}},	//   _ikibazo_, _फिर__से_, --, --,
   {{0x52c32003,0x177c200c,0x26f20014,0x0bf5a00c}},	//   _cofa__apha_, _माता__पिता_, _testemuñ, _में__कम_,
   {{0xe2093011,0x828a8011,0x2cbe7005,0x298e7005}},	//   _gospel__music_, _isidumbu__sakhe_, _мање_, _мањи_,
   {{0xab8f300b,0xb295302b,0xdde3d00e,0x00000000}},	//   _ེན_, _འཁོད__ཀྱི_, _ཞེས__སོགས_, --,
   {{0x93f9000f,0xd14de003,0x6bef400c,0x02cd6010}},	//   _imbuto_, _kunye__neendlel, _हम__सभी_, _en__cuenta_,
   {{0xbf85d021,0xd472e010,0x00000000,0x00000000}},	//   _du__kjøper_, _sobre__su_, --, --,
   {{0x226a4005,0xb4962004,0x00000000,0x00000000}},	//   _firme__koji_, _possui__uma_, --, --,
   {{0x3c1b1012,0xf30db003,0xc2ac000e,0xbd7ef005}},	//   _vatrogas, _kuya__kuba_, _བར__གྱི_, _ту_,
   {{0xe98d9003,0xee8ef005,0xe2a4600e,0x00000000}},	//   _iithenda_, _режирао__га_, _པའི__ཡུལ_, --,
   {{0xc272e003,0xe46be02a,0x0b830020,0xd224d03b}},	// [5d0] _abantu__abaninzi_, _jeg__er_, _འཛིན__བཟུང_, _folket_,
   {{0x9bed7004,0x3d985027,0xac10e00e,0xedd9300b}},	//   _fevereir, _berlaina, _དྲག__ཆས_, _གཞི__ཁེབས_,
   {{0xc3c4f014,0xa2cbf004,0x12d84019,0x1402400f}},	//   _de__españa_, _ajuda_, _gomes_, _yawe__wenyine_,
   {{0x32cb401d,0xc4ba2010,0x00000000,0x00000000}},	//   _tjedna_, _solicita_un_, --, --,
   {{0x0bef300c,0x23790013,0x00000000,0x00000000}},	//   _करें__और_, _stranka_, --, --,
   {{0xafb9600d,0x203d500a,0x00000000,0x00000000}},	//   _môže__byť_, _देंहि_, --, --,
   {{0x744ac00d,0x00000000,0x00000000,0x00000000}},	//   _prečítaj_si_, --, --, --,
   {{0x3c7c7013,0x5467e011,0x134b8029,0x22a6d003}},	//   _časova_, _ama__cd_, _nederst_, _ufeb_,
   {{0x8b8e400e,0xad0d4017,0xaf42200d,0x7243900e}},	//   _ཆར_, _territor, _opäť_, _ཁྲོ_,
   {{0xdbfc100e,0xb46ee010,0xf2ba9010,0x00000000}},	//   _རི__བོ_, _sea__el_, _el__pago_, --,
   {{0x03c43014,0xd235800d,0x0291c014,0x0a5cd00c}},	//   _foi__elixido_, _hľadať_, _levan_, _भर__में_,
   {{0x64a45019,0x52a1c014,0xf3625011,0xeb88400e}},	//   _maneira__de_, _pódese_, _isibalo__sabantu_, _འུ_,
   {{0x74963010,0x4477c005,0x00000000,0x00000000}},	//   _se__les_, _савеза_, --, --,
   {{0xf1c75005,0xe2d9d02d,0x748bb007,0x6343800d}},	//   _становни_износи_, _माटी_, _největší_, _členom_,
   {{0x327df011,0x00000000,0x00000000,0x00000000}},	//   _umnuz__julius_, --, --, --,
   {{0xe2d9102f,0x02d70004,0x53160031,0xebb7800b}},	//   _jozef_, _inglês_, _eziza_, _ཁོ__གི_,
   {{0x2fa30010,0x3256900d,0x8b24400e,0x8f79e00d}},	// [5e0] _director_, _júl_, _ཡོངས__རྫོགས_, _veľká_,
   {{0xf2b5b011,0x97807005,0x00000000,0x00000000}},	//   _ukuthi__ngabe_, _je__jugoslov, --, --,
   {{0x02a3600e,0xe4a3702a,0xc49c0010,0x00000000}},	//   _བྱས__ཡོད_, _direkte__til_, _artículo_en_, --,
   {{0xc46ce014,0x1280b007,0x00000000,0x00000000}},	//   _foi__un_, _diskuze_, --, --,
   {{0xab8e500e,0x9d91b00f,0xc2dea011,0x646c1004}},	//   _ཉག_, _ikibuga__cyindege_, _echaza__uthe_, _emprésti_de_,
   {{0xc3d12005,0xae9bf040,0x4bde8018,0x8774c00c}},	//   _је__градић_, _nastavit_, _གྱི__ལོ_, _यह__सुनिश्चि,
   {{0xe1dbd023,0x46247007,0xedb9600b,0x7b67400c}},	//   _pengarah_, _bohužel_, _དངུལ__འབྲེལ_, _कितने_,
   {{0xd44a1009,0x180a202d,0x947b100f,0x347ad00d}},	//   _karena__itu_, _बुढ़िया_, _imikorer_ya_, _ktorých__sa_,
   {{0xc42fc011,0x4c807005,0x00000000,0x00000000}},	//   _iminyaka__engu_, _неће_, --, --,
   {{0x7ba8100c,0x02d8c004,0xe44a7011,0x133dd00f}},	//   _है__तो_, _podem_, _ukwazi__ukuthi_, _birashob_gukorwa_,
   {{0x13d1400d,0x9c8e9014,0x5d6d9005,0x43f8f004}},	//   _partneri_, _anos__despois_, _сателита__при_, _algum_,
   {{0xa243d00e,0x6b974014,0x64be502a,0x681d902a}},	//   _ཞིག_, _bibliogr_ligazóns_, _hvis__de_, _og__personli,
   {{0x64805014,0xd291401d,0x03f46023,0xe9f5e00d}},	//   _unha__de_, _zadanu_, _pautan_, _detí_,
   {{0x0a7ad00c,0xd4f4b004,0x232ca028,0xd2c8f011}},	//   _तुलना__में_, _acompanh, _se__espera_, _nekwazul_natal_,
   {{0xfbba200b,0x32edf021,0x00000000,0x00000000}},	//   _ལས__པར_, _til__noen_, --, --,
   {{0x0243a024,0xca32b00a,0x146b4021,0xf6919013}},	//   _གིས_, _खाय_, _gjøre__med_, _generaci,
   {{0xe4429008,0x2f6fc004,0xe37fc004,0xbbc5300c}},	// [5f0] _ija_, _palavras_, _palavra_, _स्थान__पर_,
   {{0xa2bd0011,0xf46f600f,0x9c230007,0x00000000}},	//   _le__moto_, _icyemezo_, _poprvé_, --,
   {{0x7009800c,0x7beb400b,0x00000000,0x00000000}},	//   _के__मुकाबले_, _སྤེལ__ཁང_, --, --,
   {{0x52d85003,0xd52f501f,0x74bca011,0xc2dfa00f}},	//   _sele_, _ubuyoboz, _noma__cha_, _abantu__bose_,
   {{0x525ad021,0xc291d01c,0xd73a5005,0x3475702a}},	//   _vanlig_, _hewan_, _од__орбите_, _dem__på_,
   {{0x22ba6023,0x2d91e010,0xf2d52007,0x64e40040}},	//   _golongan__alam_, _cantidad_, _všem_, _klávesov,
   {{0xcb6bb023,0x00000000,0x00000000,0x00000000}},	//   _di__bahagian_, --, --, --,
   {{0xf33af014,0x1bab200c,0x73eae022,0xf2006021}},	//   _de__galicia_, _का__एक_, _ventas_, _mulig_,
   {{0x84783009,0xc224c00d,0x43f5800f,0x00000000}},	//   _ditemuka_di_, _celkom_, _abarwayi_, --,
   {{0xeeb5c040,0xc9f4e010,0x0bd7e003,0x8be3500e}},	//   _prezenta, _tenía_, _ilimpopo_, _པའི__བྱ_,
   {{0xc7c00010,0x00000000,0x00000000,0x00000000}},	//   _se__convirti, --, --, --,
   {{0x42671005,0x00000000,0x00000000,0x00000000}},	//   _реду_, --, --, --,
   {{0x14bc5012,0x7a90400f,0xe495e02a,0x0bba300b}},	//   _razdoblj_od_, _indirimb, _på__er_, _ལས__ཕར_,
   {{0x8324f009,0xf2011013,0x1bee1005,0x00000000}},	//   _dibagi__menjadi_, _jezik_, _јако_, --,
   {{0xf291400f,0xe28f9021,0xbd8c7013,0x7c13200e}},	//   _madamu_, _kan__brukes_, _lično_, _རིགས__རང_,
   {{0xe95dd029,0xa57d6004,0xddce900f,0x843c2010}},	//   _tjeneste, _reputaçã, _kuri__terefone_, _lo__tanto_,
   {{0xd387c004,0x4174400d,0x824d700b,0x027ba00b}},	// [600] _livre_, _galéria_, _ོངམ_, _ཏེ__ཨིན_,
   {{0xa243400e,0x1dace038,0xfbacb02b,0x57f6000c}},	//   _བྱས_, _visninga, _ཚོགས__གླིང_, _की__जानकारी_,
   {{0x633ed014,0xf41e1014,0x71b9f00a,0xb2dcb003}},	//   _ás__veces_, _licenza__resumo_, _बाजल_, _kunye__nabo_,
   {{0xe278001c,0x37f1f007,0x3f972011,0xa310600d}},	//   _bisnis_, _rozšířen, _wale__nhlangan, _verzia_,
   {{0xc298500e,0xb4b56021,0xe469300d,0x00000000}},	//   _བྱས__པའི_, _vet__at_, _aby__ich_, --,
   {{0x0b88700b,0xca33600a,0x03ce9013,0x748c0007}},	//   _ལུ_, _कहल_, _pravi_, _stáhněte__si_,
   {{0x93866010,0x53430004,0x9eb30004,0x12c7e023}},	//   _ahora_, _direito_, _direitos_, _lanjutan__lihat_,
   {{0x148f6014,0x92905010,0xea6b8005,0xee1b8005}},	//   _de__km_, _ella_, _су__били_, _су__биле_,
   {{0x40f2500a,0x0b62500c,0x20ca5005,0x00000000}},	//   _बनावे_, _बनाने_, _запослен, --,
   {{0x320e9011,0x54a3f00f,0xab5b300e,0x64b78010}},	//   _ngenxa__yesimo_, _ibintu__bitanduk, _ཏུ__བྱུང_, _ventajas__de_,
   {{0x224c5018,0x53164003,0x00000000,0x00000000}},	//   _ཆེར_, _zombini_, --, --,
   {{0x1479902a,0xd2d9b004,0xd394f023,0x00000000}},	//   _probleme_med_, _jovens_, _rahsia_, --,
   {{0xd6934017,0x41ed4007,0x43168011,0x8486c00c}},	//   _expedici, _formulář, _amabili_, _पुराने_,
   {{0xfb3d2003,0x346b600d,0xf12d2005,0xce173005}},	//   _ngexabis_eliphant, _aby__sa_, _марта_, _значи_,
   {{0x2224c007,0x11b9100a,0xd49bd003,0x5d7f2005}},	//   _celkem_, _दिहल_, _echaphaz, _јул_,
   {{0xc2e51011,0x00000000,0x00000000,0x00000000}},	//   _kukhona__abantu_, --, --, --,
   {{0xcbb7d005,0x00000000,0x00000000,0x00000000}},	// [610] _разлику_, --, --, --,
   {{0x148d202c,0x44523005,0x021c8005,0x00000000}},	//   _de__foi_, _može__da_, _објављен, --,
   {{0x04708023,0x6bc7100c,0x89e27007,0x3bd6e00c}},	//   _bagi__kegunaan_, _अगर__आप_, _se__rozhodne, _यदि__यह_,
   {{0xabd4c02b,0x4200b028,0xee68d004,0x00000000}},	//   _གནས__དེ_, _decir_, _de__gerencia, --,
   {{0x3ce9d00b,0xe2d8c023,0xa2ebe00c,0x426db00f}},	//   _ཞིབ__འཚོལ_, _moden_, _की__जाती_, _segiteri_,
   {{0xe5af7040,0xaa3c700a,0x00000000,0x00000000}},	//   _obchodní, _उठल_, --, --,
   {{0x52fe601c,0x8d95200f,0xa2cae02c,0x434fa004}},	//   _dirilis_, _igituntu_, _fundou_, _todos__esses_,
   {{0x0ea63005,0x65221005,0x43440004,0x4e637004}},	//   _површина__општине_, _свим_, _nos__negócios_, _de__tróia_,
   {{0xd4772010,0x00000000,0x00000000,0x00000000}},	//   _cualquie_que_, --, --, --,
   {{0x71cda007,0xfa4da007,0x446da007,0x3abcb003}},	//   _všechny_, _všechna_, _všechno_, _kunye__nendlela_,
   {{0x7e4b0035,0x7e38a010,0xc2d8c029,0x0293600e}},	//   _kufanele_, _entonces_, _koden_, _ཆགས__ཡོད_,
   {{0xc2cae03b,0xf16c5003,0x00000000,0x00000000}},	//   _landet_, _intsholo, --, --,
   {{0x73ceb023,0x7ea8e005,0xc326702a,0xa3c6a021}},	//   _dalam__tinggal_, _али__се_, _en__eller_, _nettsted_vårt_,
   {{0xd23b5005,0xc41d9011,0x00000000,0x00000000}},	//   _još__uvek_, _laba__bantu_, --, --,
   {{0x224e600e,0x62af502b,0x7f0ba009,0xa207300d}},	//   _རོལ_, _མང__ཤོས_, _bervaria, _rôznych_,
   {{0x13506023,0xd112f003,0x12833011,0x00000000}},	//   _juga__boleh_, _iyakuvul, _eqenjini__lakhe_, --,
   {{0x927f402e,0x225bd005,0xb491f021,0xeda90005}},	// [620] _agenga_, _su__etnički_, _er__mye_, _definisa,
   {{0xfc48800a,0x46e9300c,0x8243400e,0x22542004}},	//   _सबले_, _है__इसलिए_, _བྲན_, _seu__link_,
   {{0x22b27035,0x4c77e00f,0xe3eba005,0xc4ace028}},	//   _cape__town_, _uburezi_, _да__буде_, _con__un_,
   {{0x8b8fe01e,0x7bee2005,0xf011f007,0x472b700c}},	//   _दो_, _само_, _potřebuj, _करने__वाला_,
   {{0x526d2010,0x92d6f021,0x6f446005,0xb48f6004}},	//   _mayo_, _som__tilbyr_, _са__ом_, _de__um_,
   {{0x344d8007,0xc4b35013,0xf3696004,0x3e9f6005}},	//   _kč_, _gradu__je_, _imagens_, _има__на_,
   {{0x535ca00a,0xe478502a,0xb4ba5028,0xd52d5010}},	//   _सकेला_, _gang__du_, _como__el_, _una__solución_,
   {{0x224e7020,0xc32d2023,0xd387101c,0x146a1014}},	//   _ལོར_, _sedaya__upaya_, _pabrik_, _conta__con_,
   {{0x626e503a,0x61f9f003,0xf73ae00e,0x8b073014}},	//   _matora_, _karhulum, _རྙེད_, _relixión_,
   {{0x835ac036,0xe470d02a,0x69173005,0x00000000}},	//   _gradić_, _fordi__du_, _далеко_, --,
   {{0xa0914005,0xaa33900a,0xe5c5600f,0xeb8e900b}},	//   _надморск_висини_, _अउर_, _imibereh, _ིག_,
   {{0xee70a005,0x6c2bb007,0x26fe600c,0x00000000}},	//   _треба__да_, _místě_, _हैं__लेकिन_, --,
   {{0x80533007,0x1bab300c,0x00000000,0x00000000}},	//   _sportovn, _प्रयास__कर_, --, --,
   {{0xe3e6e007,0x64736010,0x28bc7005,0x3b9e600c}},	//   _být_, _venta__de_, _покушава, _ही__यह_,
   {{0xcc72f00d,0x5f78500f,0x145ef007,0x74a4e00d}},	//   _hlavná_, _abacaman, _příspěve_od_, _čo__si_,
   {{0x046de021,0xa3874022,0x46d0d00c,0x2ed13005}},	//   _noe__som_, _tierra_, _इसलिए_, _добио__је_,
   {{0x19bf3029,0xd6f9f00a,0xb495602a,0x13e8d005}},	// [630] _meldinge, _बिया_, _og__at_, _успех_,
   {{0x226d200f,0xe4280011,0xdc1d0030,0x7d8b4014}},	//   _zayo_, _kudingek_ukuthi_, _stoppet_, _utilízas,
   {{0x12d8a010,0xa2d87010,0x12d8c014,0xb4ab2011}},	//   _debe_, _poner_, _poden_, _kakhulu__uma_,
   {{0xe46be036,0xd249800c,0x00000000,0x00000000}},	//   _ima__na_, _में__हमारे_, --, --,
   {{0x32b91023,0x424c7020,0xf495602a,0x94525011}},	//   _rencana__adalah_, _ཉེར_, _og__et_, _umholi__we_,
   {{0x32cad003,0xcc9af00e,0x12b5700f,0xe25ce00e}},	//   _wced_, _རྩོལ_, _mugihe__gito_, _ལྷན__ཅིག_,
   {{0xc4ace02a,0x237b8011,0x7c4e200c,0x6a6fa00c}},	//   _med__en_, _ukuthi__kungani_, _घंटे_, _अलग__अलग_,
   {{0x03207003,0xea33600a,0xf30e801b,0x6486b032}},	//   _kunye_, _कहत_, _elizweni_, _produtos__de_,
   {{0xccc98003,0xd4947010,0x9db2c003,0x2de00010}},	//   _ukuba__yintoni_, _lo__que_, _inqununu_, _la__cantidad_,
   {{0x0496802a,0xc3f04009,0xc4779014,0x646bf022}},	//   _om__det_, _prasasti_, _converte_en_, _aplicaci_de_,
   {{0xc4765021,0x546fe004,0x0b97a00c,0x72c34010}},	//   _brukt__av_, _mais__comuns_, _नाम__और_, _un__mayor_,
   {{0x3291001d,0x02ba1011,0xb2d8b01d,0x92e55011}},	//   _spojite_, _kubika__ikickoff_, _nece_, _lesi__simo_,
   {{0x926c101b,0x04a3002a,0xc2e70021,0x7a33100a}},	//   _apho_, _når__det_, _det__finnes_, _चान_,
   {{0xfc19b031,0xf27e000f,0x7ee3f00d,0x0b98200c}},	//   _inkqubo_, _nyine_, _aký_, _समय__और_,
   {{0xe443f003,0x2253600f,0x0fc06010,0xf6c9601a}},	//   _oku_, _bayobozi_, _de__interés_, _तिथि_,
   {{0x9a314023,0x02d8a01b,0x7aa5700c,0x2758800c}},	//   _satu__daripada_, _sebe_, _में__हैं_, _में__प्रवेश_,
   {{0x13076014,0xaa33a00a,0xeb8eb00b,0x00000000}},	// [640] _que__poden_, _आउर_, _ིར_, --,
   {{0x3e543005,0x3753c030,0x7344b00f,0xab98000c}},	//   _налази__на_, _kronolog, _mirenge_, _तरह__की_,
   {{0xbca7200c,0x9337200c,0x00000000,0x00000000}},	//   _से__अपने_, _से__अपनी_, --, --,
   {{0x4b2c3006,0xe1b9a00a,0xe3ead00d,0xb599a00a}},	//   _di__kabupate, _मिलल_, _sveta_, _मिलत_,
   {{0x12d8a01d,0xf26de00e,0x9450e00f,0x9babc00c}},	//   _tebe_, _སྐྱེས__ཤིང_, _hejuru__ya_, _देखें__कि_,
   {{0x826ff018,0xdbe3a00e,0x3be2500b,0xeb56b004}},	//   _ལས__ཚིག_, _སྐྱེ__བོ_, _འཛིན__ོལ_, _telefone_celulare,
   {{0x735fb01f,0x129df005,0xc4ac602a,0x227c7005}},	//   _abagore_, _za__vreme_, _det__en_, _игра_,
   {{0xe442d038,0xddbd501d,0xe242802b,0x9683e00c}},	//   _gje_, _ispalite_, _བཀལ_, _दौरान_,
   {{0x79e0c027,0x00000000,0x00000000,0x00000000}},	//   _penghant, --, --, --,
   {{0x8a33601a,0x7f79f016,0x426e700f,0x2a38e005}},	//   _कहा_, _možná_, _gusoma_, _ће__бити_,
   {{0xb4537005,0xe3bc2004,0x00000000,0x00000000}},	//   _orbitu__oko_, _com__mais_, --, --,
   {{0x7ab0000c,0x8243600e,0x120e2005,0xe45d0011}},	//   _सकते__हैं_, _ཕྲན_, _тада_, _uyabona__ukuthi_,
   {{0xd444403a,0xc2ac0011,0x32fd9029,0xb4210021}},	//   _ay_, _lo__mholi_, _rediger_, _hele__tatt_,
   {{0x4c72a010,0x35997011,0x74659007,0xd2bcb00e}},	//   _viernes_, _ungqongq_wezokuth, _přečtěte__si_, _པོ__ཡིན_,
   {{0xf444400f,0x8498b02e,0x9a33600a,0x82918014}},	//   _cy_, _ihagarik, _कहि_, _xeral_,
   {{0x0bdbf00c,0x00000000,0x00000000,0x00000000}},	//   _उपलब्ध__है_, --, --, --,
   {{0xa6ffb00a,0xa6c9500f,0x6146d01a,0x1e806004}},	// [650] _एकरा_, _amashany, _जाएंगे_, _inteligê_emociona,
   {{0xcdff5038,0x64b1e022,0xea0f2003,0x00000000}},	//   _hendinga, _actualiz_de_, _owephond, --,
   {{0xfa3c900a,0x2f20400b,0x4f20e023,0xb4736007}},	//   _लीं_, _འཁོར__འགྲུལ_, _perubata, _pokud__to_,
   {{0x7c7ba00c,0x530ba00c,0x8bc0c00c,0x29d0c005}},	//   _करने__वाले_, _करने__वाली_, _होने__का_, _неким_,
   {{0x13cd2005,0x72a1300d,0xd0738016,0xf4969019}},	//   _postavil_satelit_, _pravidlá_, _moravsko, _se__seu_,
   {{0xc3012011,0x92902023,0xebfc900e,0x430e3011}},	//   _webafana__bafana_, _sukan_, _རི__མོ_, _nekaizer__chiefs_,
   {{0x74adc011,0xd2cbf005,0x00000000,0x00000000}},	//   _hip__hop_, _ljudi_, --, --,
   {{0x96174006,0x3cb3200c,0xdb89a00c,0xba8b300c}},	//   _partikel_, _सुनिश्चि_करें_, _का__सामना_, _से__काम_,
   {{0xc493d005,0xa4229011,0x00000000,0x00000000}},	//   _kosmos__je_, _yetheku__umnuz_, --, --,
   {{0xc237100f,0x2b8fc00b,0x6270f00d,0xa4689003}},	//   _hano__hari_, _ེལ_, _napríkla, _kunye__nokuba_,
   {{0x44a81015,0xb28c1024,0xc2a1f011,0x44131005}},	//   _sebelum__ini_, _འབབ__ཀྱི_, _umnuz__bheki_, _почела_,
   {{0x5436b02a,0x6499c02a,0xdb959018,0x3d73a005}},	//   _de__mest_, _nødvendi_for_, _ལྷག__ཙམ_, _позната_,
   {{0xe2a7800b,0xe263702b,0x0ab8500c,0x4b577010}},	//   _འདྲེན__འཐབ_, _ཅན__མའི_, _खेल__में_, _en__ocasione,
   {{0x24493003,0xdb82b024,0xd2ce1007,0x00000000}},	//   _le__nkqubo_, _གིས__གསུངས_, _je__nutno_, --,
   {{0x054d702a,0x8290301d,0x6c5d5004,0xa2ad100b}},	//   _virksomh, _rujan_, _cartão_, _འབྲེལ__འདི_,
   {{0x24444008,0x36c9f00a,0x42002027,0x54538007}},	//   _vy_, _बाकि_, _mukim_, _proč__se_,
   {{0xabc0200c,0x0be2000b,0x2d0b3017,0x48cca014}},	// [660] _करने__की_, _འདི__ནང_, _ferrocar, _enfermid,
   {{0xf24a0005,0xd2ab500d,0xdad8a00c,0xd69c800b}},	//   _kosmos_, _výber_, _के__अंतर्गत_, _ོད__དགོཔ_,
   {{0x0b8f201e,0x8476d014,0x02d8c004,0xe3543014}},	//   _है_, _cara__ao_, _rede_, _galegos_,
   {{0x2eeec005,0xc3198010,0x00000000,0x00000000}},	//   _село__је_, _los__grandes_, --, --,
   {{0x2ed25005,0x56978034,0x048d6030,0xf2d98038}},	//   _да__је_, _liberali, _de__som_, _noreg_,
   {{0xe475d005,0x92d06038,0xdf3a2004,0x00000000}},	//   _stanovni_toku_, _korleis_, _as__melhores_, --,
   {{0x02d8c030,0xf39b9014,0x64ad5028,0x2f8b9014}},	//   _koder_, _sinxelo_, _entorno__de_, _sinxelos_,
   {{0xc3960036,0x02571007,0xc225f00f,0xb3eef011}},	//   _srpska_, _dál_, _isuku_, _ngculazi_,
   {{0xd224e030,0x54706021,0xbd739005,0x00000000}},	//   _klikke_, _seg__om_, _познат_, --,
   {{0xfbe7e018,0x346be00d,0x238e2010,0x43f90035}},	//   _ཤེས__པར_, _kde__sa_, _de__acuerdo_, _umbuso_,
   {{0x246c2021,0xb2acb010,0x74998007,0x89a9d010}},	//   _hva__kan_, _una__gran_, _prohlédn_si_, _de__cualquie,
   {{0x2b88d00e,0x1eb16014,0xfd45e017,0x03ce6003}},	//   _ཨུ_, _externas_, _competic, _unov_,
   {{0x83a8e036,0xa30f600f,0x92e5200f,0xb3fed011}},	//   _je__gradić_, _ukuboza_, _muriki__gihe_, _wezempil_kwazulu_,
   {{0xab8f4051,0x5b6f5013,0x00000000,0x00000000}},	//   _रन_, _žitelja_, --, --,
   {{0x14676021,0xb26e3020,0xabaf600b,0x02822011}},	//   _deg__med_, _དང__རྣམ_, _ནང__ོད_, _kahle__kahle_,
   {{0x9290b036,0x62d8c017,0x2fd3502c,0x00000000}},	//   _podaci_, _podes_, _abandono, --,
   {{0x7c51c007,0x9c65f029,0xba5e1023,0x76506011}},	// [670] _kultura_, _slettet_, _pengetua_, _umuhsin__ertugral_,
   {{0xd25b6028,0x1cd0b011,0x4dd0e00b,0x149a7011}},	//   _reglas_, _kakhulu__wukuthi_, _ལུ__བརྟེན_, _icala__lombango_,
   {{0x7387c004,0x422fa011,0x9438a010,0x00000000}},	//   _livro_, _uma__kuziwa_, _la__mente_, --,
   {{0xc4b2502a,0x4b5a400a,0xa3d56028,0x3f4d000c}},	//   _eller__en_, _निमन_, _la__tierra_, _पर__अधिक_,
   {{0x237d4037,0xa386d004,0x7bdf400b,0x3bde200b}},	//   _rusange_, _quer_, _བཏོན__ནི_, _ཚབས__ོལ_,
   {{0xeac0300f,0xb470b004,0xd20ec005,0x00000000}},	//   _kwikinis, _tem__uma_, _такав_, --,
   {{0xf3d0d005,0x2243800b,0x32e11003,0x1baba00c}},	//   _nadmorsk, _ཀྲམ_, _yenye__yezona_, _कि__एक_,
   {{0xf3a2c006,0xaf10200c,0x2725600f,0x4ac04014}},	//   _kompas_, _है__जिसके_, _kuri__mudasobw, _trátase_,
   {{0xb2ea0038,0x332b5010,0x00000000,0x00000000}},	//   _skriven_, _se__hace_, --, --,
   {{0x6326402a,0xe275700b,0x91d1e005,0xb240f010}},	//   _en__enkel_, _ལན__འཐབ_, _основан_, _otro__sitio_,
   {{0x9278a00b,0xbbefb016,0x54ac3010,0x9f7a5004}},	//   _བརྒྱའི__དུས_, _pardubic, _con__las_, _ou__qualquer_,
   {{0xaf5a3004,0x646ff003,0xd473000d,0x8a4c900c}},	//   _pesquisa, _ngu__jml_, _tom__ako_, _के__लाभ_,
   {{0xac9a200e,0x827e7038,0xd628c00b,0xb2911014}},	//   _སྐུལ_, _danna_, _གསརཔ_, _pezas_,
   {{0xaaa1a023,0x426c9013,0x00000000,0x00000000}},	//   _semua__pengguna_, _škola_, --, --,
   {{0x2eea6005,0xe433f011,0x1bfc200c,0x90e90003}},	//   _био__је_, _yini__ukuthi_, _इसे__एक_, _yesiqhel,
   {{0xbc4f501e,0x5c5b8003,0xe410f011,0x1bfc600e}},	//   _अपने_, _ngenisa__ikhonkco_, _kanjani__ukuthi_, _ཚོ__ནས_,
   {{0x2af2a026,0x02a3e00e,0x7ef93005,0xbba6b010}},	// [680] _izgradit, _ཀྱི__ཡོད_, _детаљни_, _tráfico__dirigido_,
   {{0xb26de015,0x86fa600a,0x85ccb023,0x92414035}},	//   _orang__asli_, _पाछा_, _selaluny, _ngodisem,
   {{0x4200d038,0x528f1021,0xa610300d,0x4b9bd00e}},	//   _blei_, _kan__bruke_, _hľadám_, _འཁོར__ལོ_,
   {{0x027ff032,0xebe5a00c,0xa278d010,0x00000000}},	//   _bruno_, _और__के_, _del__coche_, --,
   {{0xa2bd0023,0x7283f00f,0xe9d7804a,0xf2918027}},	//   _bukan__sahaja_, _inshuti_, _anbefale, _perak_,
   {{0xa3439011,0xfaffe004,0x923e100f,0x727f0011}},	//   _ucaptain__thulani_, _imóveis_, _kuva__kuri_, _phansi_,
   {{0x2cace00c,0x42006028,0x6a55500c,0x85523005}},	//   _का__उपयोग_, _julio_, _इस__तरह_, _уопште_,
   {{0x1c3f5011,0xb23e100f,0x1b0f5003,0x03489004}},	//   _ngaphans, _kuva__muri_, _ngaphant, _de__viagem_,
   {{0x624c400e,0xd3445007,0x5200300f,0x3297a010}},	//   _ཅེས_, _recenze_, _komini_, _la__forma_,
   {{0x82127004,0x0bcfe00c,0x92b12011,0x2ed79005}},	//   _senha_, _किया__है_, _kuthunye_ngujml_, _учествов_је_,
   {{0x3f013005,0xd48d600d,0xe496e010,0x823bb003}},	//   _је__југослов, _spôsob__ako_, _se__le_, _iqumrhu_,
   {{0x6444402f,0xf486600c,0xd243800e,0x74301031}},	//   _ak_, _द्वारा_, _ཀྱང_, _emva__kokuba_,
   {{0x03909003,0x6be0a00c,0x32439024,0x8c1af007}},	//   _kunye__kunye_, _और__भी_, _ཁྲམ_, _webovou__stránku_,
   {{0xa492602a,0xdd9a2020,0xe2434020,0xe4b7f021}},	//   _en__ny_, _སྐྱེ_, _བྱེ_, _legg__til_,
   {{0x92127004,0x82125004,0xe293902b,0x02fa103d}},	//   _tenha_, _velho_, _གིས__གནང_, _kuchaza_,
   {{0xc2adb00b,0xe24e700e,0xe4690011,0xebf8000c}},	//   _གན__ཡིག_, _ལུག_, _uyazi__ukuthi_, _जानकारी__के_,
   {{0xc4ad602a,0x00000000,0x00000000,0x00000000}},	// [690] _kan__en_, --, --, --,
   {{0x6496e057,0x82dfa014,0x1bc3500c,0x63108040}},	//   _om__de_, _en__xeral_, _केवल__एक_, _zkratky_,
   {{0xcbf8b00a,0x00000000,0x00000000,0x00000000}},	//   _हजाम_, --, --, --,
   {{0x62b68003,0xafc6a005,0x12825004,0x9489e005}},	//   _apha__ngasentl, _на__енглеско, _também__são_, _проглаше,
   {{0xc4ace02a,0x64a3502a,0x7a4e800c,0xc260100b}},	//   _har__en_, _når__de_, _गए__हैं_, _བཅོས__འབད_,
   {{0x52a91003,0x92ba501c,0x1b9bd00e,0x4451f011}},	//   _ngokuthe__ngqo_, _kondisi_, _ཡིན__པས_, _ukuthi__abe_,
   {{0xc3423004,0x230b200d,0xb30e4023,0xa2908023}},	//   _sucesso_, _mesiacov_, _peratus_, _rekaan_,
   {{0x2e827005,0x6c782003,0x00000000,0x00000000}},	//   _пошто__је_, _kunye__nokuhamb, --, --,
   {{0x33069014,0x02a3e007,0x5140e00b,0x52605010}},	//   _unha__banda_, _by__měly_, _འབད__འབདཝ_, _el__hecho_,
   {{0x426d602b,0x23457010,0x00000000,0x00000000}},	//   _དང__འགན_, _ganar__dinero_, --, --,
   {{0xaeac402e,0x52007010,0x63f95010,0x148da014}},	//   _aturutse_, _junio_, _alguna_, _de__son_,
   {{0x8444402f,0xe40c3007,0xabd13007,0xe45a300d}},	//   _sk_, _může__být_, _mezináro, _nájdete__na_,
   {{0x633ef009,0x3e52d023,0xf3e8500f,0x831f3007}},	//   _yang__berarti_, _adalah__berkenaa, _ibintu__bimwe_, _které__chcete_,
   {{0xc470e011,0xd2fce03b,0x5721f00a,0x025a1007}},	//   _oneminya_engu_, _lenger_, _मूड़ी_, _tohle_,
   {{0x12fe6027,0x14aba02a,0x69c5f014,0x74946007}},	//   _orang__melayu_, _det__har_, _en__entidade, _li__si_,
   {{0x6291500f,0x57acb00e,0x8aa0e013,0xebc0500c}},	//   _kagame_, _མི__བྱེད_, _policijs, _वर्ष__के_,
   {{0x525ad030,0xe4077011,0xe477f007,0xcbecc00c}},	// [6a0] _tallet_, _waveza__ukuthi_, _speciali_na_, _आनंद__ले_,
   {{0x8496e007,0xa1fbc02e,0x7e9a5005,0x6e43400f}},	//   _se__ve_, _nshingam, _што__се_, _ambasade_,
   {{0x4292101d,0x00000000,0x00000000,0x00000000}},	//   _lipanj_, --, --, --,
   {{0xa3203037,0x6496e010,0x3bfa702b,0x9481b00f}},	//   _kujya_, _no__te_, _མི__གོ_, _software__ya_,
   {{0xc6fa6002,0xc7c72004,0x1b9c201a,0x32d11005}},	//   _पिया_, _mensagem_, _की__एक_, _око__становни,
   {{0x6d83d020,0x89db6017,0x0bdbb00b,0xc4b6a010}},	//   _སྐྱོན_, _francesa_, _འཛིན__ལུ_, _encuentr_en_,
   {{0x139cb013,0x97a5e014,0x63fa6005,0xdd289005}},	//   _objašnje, _parroqui, _titulu_, _варијант,
   {{0xe243d024,0xb2907006,0x03011030,0xa2d4f010}},	//   _ཞིབ_, _sunan_, _tilbake_, _un__buen_,
   {{0x8236d01c,0x42925013,0xd3ba0028,0x63f9100f}},	//   _merupaka_bagian_, _metara_, _informac_sobre_, _yezu_,
   {{0x427bb00e,0x22020009,0x92da5007,0xc2257011}},	//   _དེ__ལྟར_, _posisi_, _letech_, _ngakho_,
   {{0x327fa01d,0x2c7c8009,0xcba0100c,0x00000000}},	//   _lupni_, _kristen_, _एक__ही_, --,
   {{0xabab5003,0x6fc79011,0xd2d81021,0x55020011}},	//   _kwaye__kufuneka_, _ngokuham_kwesikha, _enhet_, _imali__engaphez,
   {{0x6b82e00e,0x3b8f100b,0x92ac1011,0x00000000}},	//   _སྲིད__གཞུང_, _ོར_, _kanti__abanye_, --,
   {{0x54b06021,0x124e600e,0xf3f9b00f,0x649f5010}},	//   _mer__om_, _རུས_, _umwuka_, _cuidado__de_,
   {{0x526d9010,0x1bbee00e,0x22925023,0xb23b0010}},	//   _paso_, _ལོ__ནས_, _ketara_, _este__sitio_,
   {{0xe3f46011,0x026c4003,0x7d21600f,0x00000000}},	//   _ukuthi_, _ezininzi_, _bakomeje_, --,
   {{0xb495e021,0x921fd007,0x1303200c,0xfba4300c}},	// [6b0] _sa__at_, _téměř_, _आवश्यकता__होती_, _दृष्टि__से_,
   {{0x9452a021,0x2edc6005,0xe9288005,0xa4655007}},	//   _det__viktig_, _јој__је_, _центар_, _vše__co_,
   {{0x6307b021,0x42902027,0x8745f014,0x00000000}},	//   _som__hjelper_, _cukai_, _campesiñ, --,
   {{0x42caf02a,0x65765004,0x3029f00a,0xf5c5c003}},	//   _kunder_, _publicaç, _बिआह_, _amaphulo_,
   {{0xa37ca017,0x1a104027,0x4ecb1023,0x657eb00d}},	//   _durante_, _malaysia_, _mesyuara, _na__stránkac,
   {{0xaaa1a00c,0xbba0500c,0x73ea002c,0xb402a010}},	//   _आपके__लिए_, _इस__पर_, _moita_, _forma__más_,
   {{0xc33bd011,0xd25bf013,0x63ea0014,0x07e4a00c}},	//   _ngaleyo__ndlela_, _razlog_, _loita_, _ख़बरें_,
   {{0xed21600f,0x0cfcf00e,0x6f77a011,0x646f5010}},	//   _yakomeje_, _དེ__ཕྱིར_, _ngemuva__kwesikha, _línea__de_,
   {{0x22920027,0x529e500e,0xbaeb4021,0x51e1600c}},	//   _kepada_, _མངོན__སུམ_, _for__informas, _दूसरी_,
   {{0x429a9011,0xf4aba02a,0x526df00d,0xe469a003}},	//   _lo__mcimbi_, _det__var_, _predchád, _nakuphi__na_,
   {{0xcf17800b,0x00000000,0x00000000,0x00000000}},	//   _དཔར__འཕྲུལ_, --, --, --,
   {{0x224e7020,0xd4aba021,0xa0571005,0xc843a00c}},	//   _ལུས_, _det__tar_, _висини_, _पर__आधारित_,
   {{0x92a62010,0x72127004,0xc75bc00d,0x1a3cf01a}},	//   _nombre_, _tenho_, _spojenýc_štátoch_, _वीं_,
   {{0x646a1021,0x62ca9013,0x00000000,0x00000000}},	//   _trenger__for_, _vlada_, --, --,
   {{0x32a62028,0x7e51500f,0x2c99e030,0x83243022}},	//   _hombre_, _abacitse_, _naturlig_, _de__cabeza_,
   {{0x1eccc014,0x4bfa902b,0x5db5701b,0xe32a500d}},	//   _ligazóns__externas_, _མི__ངོ_, _ilandela, _sa__budete_,
   {{0xc259400b,0xb0885005,0x3282800b,0x00000000}},	// [6c0] _འབྲུག__པའི_, _елиптичн, _ཁོངས__གོང_, --,
   {{0xeaf06017,0x12677005,0x00000000,0x00000000}},	//   _comunist, _међу_, --, --,
   {{0x53ea7003,0xea89300d,0xdd8fc00e,0x98851021}},	//   _umntu_, _inzeráto, _དྭགས_, _fagkonsu,
   {{0x96ffb002,0x34a7002a,0xb3fa7023,0x92926023}},	//   _एकटा_, _størrels_på_, _kerusi_, _berasa_,
   {{0x928ee010,0x00000000,0x00000000,0x00000000}},	//   _los__años_, --, --, --,
   {{0x1437a014,0xd343402a,0xe25d7018,0x6c93e00c}},	//   _ao__norte_, _men__ikke_, _ཡུན__རིང_, _काम__करने_,
   {{0x129e7005,0xdbaac00e,0xc4b8a010,0x82dbe004}},	//   _to__vreme_, _ཏྲེ__བོ_, _como__una_, _nossas__vidas_,
   {{0xe4ac602a,0xd33d001d,0xbad16007,0x00000000}},	//   _det__er_, _nevjeroj, _své__vlastní_, --,
   {{0xb9f4000c,0x22d8c021,0xa4b83010,0x15a5b02c}},	//   _का__प्रयास_, _kodet_, _sitio__web_, _variació,
   {{0x3e5b6005,0x8e295003,0x00000000,0x00000000}},	//   _објашњењ_на_, _imiganga, --, --,
   {{0xe433f011,0x00000000,0x00000000,0x00000000}},	//   _wazi__ukuthi_, --, --, --,
   {{0xb270e014,0xc47cf007,0x5323d010,0xc293500b}},	//   _por__medio_, _pro__mě_, _de__hacer_, _ཨིན__པའི_,
   {{0x12c02005,0x446e3010,0x00000000,0x00000000}},	//   _онда_, _las__dos_, --, --,
   {{0x4e7df005,0xd2feb021,0xe47a702a,0xf2dd8010}},	//   _висини__од_, _trenger__ikke_, _evne__til_, _de__verano_,
   {{0x1be1900e,0x23fa0003,0x32d9c004,0x64b5a010}},	//   _བྱས__ནས_, _impuma_, _jovem_, _director_de_,
   {{0x8f1fb010,0xcdbbb010,0x22c3e011,0xb4ab5010}},	//   _particip, _búsqueda_, _ngoba__phela_, _desde__el_,
   {{0xe44d5003,0x00000000,0x00000000,0x00000000}},	// [6d0] _nanini__na_, --, --, --,
   {{0x2ab1d003,0xc4b9a010,0xf251f005,0xeec1c005}},	//   _ngexesha_, _todos__los_, _странице_, _стоји_,
   {{0x2439f00d,0x1260a00b,0xa46c6004,0x03098004}},	//   _na__svete_, _བཟུམ__སྦེ_, _com__as_, _um__produto_,
   {{0xe54b5014,0x5320000f,0x6cbdb00c,0x00000000}},	//   _parroqui_concello_, _iriya_, _कुछ__लोगों_, --,
   {{0x43ca0023,0x5df5e007,0x06833002,0x1a7b0003}},	//   _merupaka_biasa_, _představ, _संतान_, _kunye__namandla_,
   {{0x726d9004,0x5212b010,0xdffc2007,0xcb2ac00b}},	//   _isso_, _hecho_, _tento__článek_, _འཐིང_,
   {{0x73f98016,0x8a4ce00c,0x7b96d00b,0x00000000}},	//   _korun_, _कई__बार_, _བརྐྱབ__ནི_, --,
   {{0x547cd014,0x75234006,0x42d9c02f,0x5292900e}},	//   _onde__se_, _pernikah, _novej_, _བཙན__སྒམ_,
   {{0x9260c028,0xe4a9a003,0x4494a021,0x00000000}},	//   _años_, _naluphi__na_, _og__gir_, --,
   {{0x8287a011,0xd2fce015,0xd2dd0004,0x00000000}},	//   _lokhu__kusho_, _tengku_, _de__natal_, --,
   {{0xa387e02f,0x92267036,0x00000000,0x00000000}},	//   _nitra_, _uprkos_, --, --,
   {{0x9b278011,0x3366a01c,0x5ec2000d,0xa9f44014}},	//   _johannes, _tanggal_, _podnikan, _irmá_,
   {{0x163f3007,0x8c1c4011,0x00000000,0x00000000}},	//   _komentář_, _lesi__sikhungo_, --, --,
   {{0x5317101d,0x9e51f027,0xfbac200b,0xa44dd004}},	//   _pizzu_, _kelayaka, _ལག__ལན_, _quando__as_,
   {{0xd2d45028,0xd7d0c005,0x00000000,0x00000000}},	//   _ciudad_, _снаге_, --, --,
   {{0x62436020,0x23e9c00d,0xbca8c00c,0x00000000}},	//   _ཕྱི_, _veľkej__británii_, _जब__आपने_, --,
   {{0xf34c601d,0x948cd011,0x3200701c,0x72e95028}},	// [6e0] _tijekom_, _be__anc_, _etnis_, _región_,
   {{0x55c3f011,0x24aca033,0x32ad7011,0x3709c005}},	//   _sonke__isikhath, _man__kan_, _lapho__khona_, _великим_,
   {{0x32cdf021,0x2ecdd005,0xdfd94004,0x0a9e200c}},	//   _er__noen_, _их__је_, _seção_, _बाज़ार__में_,
   {{0x2edd6005,0xf34b8021,0x6c2b0010,0x729c3004}},	//   _године__је_, _dette__betyr_, _de__enfermer, _que__isso_,
   {{0xb2fd4014,0xabff800e,0x00000000,0x00000000}},	//   _chegan_, _སོ__དེ_, --, --,
   {{0x8386d021,0xa2eff00f,0x4eb4b005,0x2f4bd023}},	//   _eier_, _ngufu_, _који__ће_, _pengasas_,
   {{0x0bb9200c,0x42bff00d,0x1e00f01c,0x1f8da011}},	//   _हैं__और_, _po__celom_, _kesehata, _uthe__ngesikha,
   {{0xe96b8005,0xe4b56021,0x7ba9100c,0xb3b06011}},	//   _од__метара_, _vet__du_, _हो__तो_, _albhamu__entsha_,
   {{0xc2906023,0xcda0f023,0x2c4f8004,0x64b4a010}},	//   _julai_, _kejohana, _as__pessoas_, _variedad__de_,
   {{0x42578008,0x19f8c01d,0x5236d00d,0x00000000}},	//   _tél_, _odlična_, _svojom_, --,
   {{0x9c75b058,0x5c51f00f,0xcc45e01c,0x1320000f}},	//   _निर्णय_, _igituba_, _kompetis, _uriya_,
   {{0x7394b00d,0x99fe4004,0xa294c00b,0x00000000}},	//   _mieste_, _quando__você_, _བཀྲིན__དགའ_, --,
   {{0x5a191020,0x1bace00e,0x0bc0b00c,0xc3b09003}},	//   _ཆེན__པོའི_, _ནང__ནས_, _करने__और_, _mgaqo_,
   {{0xd480e004,0x00000000,0x00000000,0x00000000}},	//   _tudo__que_, --, --, --,
   {{0x99a5f014,0x326de019,0x644f6028,0x0bf9000b}},	//   _por__primeira_, _mato_, _gastos__de_, _ིན__ཅན_,
   {{0xd243900e,0x13a69014,0x9342b014,0x4f969014}},	//   _གཡོ_, _páxina_, _obxecto_, _páxinas_,
   {{0x79929003,0x6767800c,0x00000000,0x00000000}},	// [6f0] _sephepha_, _में__आपका_, --, --,
   {{0xa1920026,0xbf22c02b,0x12a1a00b,0xd772c005}},	//   _stoljeća_, _དང__འབྲུག_, _ཤོམ__སྦེ_, _овога_,
   {{0xb4903004,0x8151c005,0x00000000,0x00000000}},	//   _em__uma_, _облика_, --, --,
   {{0x6bab100c,0x334da02a,0x32352007,0x246cb005}},	//   _कि__आप_, _og__mange_, _olomouc_, _најчешће_,
   {{0xe2d87021,0x99f65007,0x03669003,0x67a2600d}},	//   _innen_, _zatím_, _ixesha__kunye_, _spotrebi,
   {{0x0fd1c015,0xc26e501c,0x02cde00b,0x1f208013}},	//   _walau__bagaiman, _metode_, _ཅིག__ཨིན_, _specifič,
   {{0x82d85021,0xa3201007,0x9316d02f,0xba0cb005}},	//   _filen_, _výběr_, _tiez_, _на__попис_,
   {{0xa22f3005,0x805d900d,0x9bb90018,0x0368d014}},	//   _grafik__promene_, _nachádza_, _དུ__མི_, _linguas_,
   {{0x0290301d,0xc26de004,0xc29cb02b,0x3ec46014}},	//   _koja_, _fato_, _སེར__གྱི_, _poñer_,
   {{0xe2d94010,0xd26de00f,0xa2ca9013,0x4e98500b}},	//   _videos_, _gato_, _vlade_, _ཕུག__བརྒྱུད_,
   {{0x2290300d,0x4340e01c,0x82776010,0x00000000}},	//   _moja_, _telepon_, _descubra__cómo_, --,
   {{0xb220c01c,0x12903004,0x3290e00d,0x026de005}},	//   _catatan__kaki_, _loja_, _trnava_, _zato_,
   {{0xb4d6d00a,0x7290200d,0x1b37d00e,0xebd3100c}},	//   _जिनिगी_, _roka_, _ཤེས__རྟོགས_, _काम__के_,
   {{0xeb8fd002,0x73684027,0x131ea023,0x62d87021}},	//   _सन_, _seperti__berikut_, _menyumba_sambil_, _annen_,
   {{0x927e9010,0xf2ca7017,0xab689004,0x00000000}},	//   _eran_, _conde_, _da__pesquisa_, --,
   {{0x02a2d00b,0xb45f2011,0xe183d005,0xd54d5010}},	//   _ཕྱུག__སྐུ_, _kanjani__uma_, _рачунару_, _la__solución_,
   {{0x32c2b02a,0x3a14402c,0x4c7d2007,0xc35b600c}},	// [700] _det__skal_, _bombarde, _operační__systém_, _लिए__किसी_,
   {{0xbc743028,0x62c22023,0x386e603d,0x884dc010}},	//   _saludos_, _menyatak_bahawa_, _wesifund, _de__automóvi,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5342a023,0x8b994024,0xe9f6e005,0x2a67a007}},	//   _jeneral_, _ཉམས__ཆག_, _је__поједина, _zprávu_,
   {{0x4459000f,0x5a60b004,0x04783004,0x00000000}},	//   _uburyo__bwo_, _preços_, _preocupa_com_, --,
   {{0x04426005,0x226f202b,0x02b77010,0x6449d010}},	//   _smo_, _སློབ__རིམ_, _de__ellos_, _tienda__de_,
   {{0x6922600a,0x1317f01c,0x3b8f702b,0x94c1c007}},	//   _ओहिजा_, _terbagi_, _ོག_, _tomu__tak_,
   {{0x9f28601d,0x13e7c007,0xeb9fc004,0x52c86005}},	//   _također_, _mít_, _dinheiro_, _takođe_,
   {{0xa26de007,0xc4976005,0x12438024,0x3314f011}},	//   _tato_, _on__je_, _གདམ_, _ulieuten_colonel_,
   {{0x32cad007,0xa2677018,0xfd18400d,0x7a15701b}},	//   _prodej_, _ཕན__ཚུན_, _odpovede_, _oluphezu,
   {{0x12904034,0xdb8d7020,0x440c7007,0xc44fe021}},	//   _koma_, _ཙམ_, _aktuální_, _resten__av_,
   {{0xaa62200c,0x22535024,0x177c300c,0x00000000}},	//   _उनके__लिए_, _ཡོད__པའམ_, _लिए__किया_, --,
   {{0x35be2005,0x00000000,0x00000000,0x00000000}},	//   _други_, --, --, --,
   {{0x62bd0003,0xe175d004,0x34a0100d,0xf86e603d}},	//   _na__into_, _matéria_, _snažte__sa_, _sesifund,
   {{0x01772005,0xc3107003,0x4494e007,0xc4b65010}},	//   _места_, _sombefu_, _se__jim_, _basa__en_,
   {{0x42904011,0xd25f700b,0x92bcb00a,0x6257c007}},	//   _noma_, _ཁང__གླར_, _पारुल_, _díl_,
   {{0x5a4d300c,0xc4ade021,0xf9e79013,0xc49f1004}},	// [710] _के__समय_, _enn__en_, _uslovima_, _você__tem_,
   {{0x7be1900e,0x00000000,0x00000000,0x00000000}},	//   _དྲུང__དུ_, --, --, --,
   {{0xa0fa0003,0x1bb2c00c,0xf3259023,0x04a5a003}},	//   _umphandl, _नहीं__कर_, _berbandi_dengan_, _malunga__ne_,
   {{0xed6d3005,0xe495602a,0x3342a014,0x0cc9b011}},	//   _што_, _og__du_, _xeneral_, _imibiko__yokuthi_,
   {{0x6a0ef02a,0x00000000,0x00000000,0x00000000}},	//   _behandle, --, --, --,
   {{0xd27ed008,0x22bee023,0x938f1007,0x9ae4300e}},	//   _nyene_, _upaya__anda_, _cestován, _རྗེས__འཇུག_,
   {{0xf2e98014,0x2ed98014,0x6738c00e,0x7798c00e}},	//   _rexión_, _rexións_, _གསོད_, _གསོན_,
   {{0x046c6021,0xd3101003,0xd0a92023,0x669c4038}},	//   _gjøre__det_, _ixesha__elide_, _dan__kemudian, _tilfeldi,
   {{0xec36a00d,0x5a0ce011,0x1a3df00a,0xc2d8c011}},	//   _kategóri, _uphiko__lwentsha_, _सरप_, _kulesi_,
   {{0x72bad01d,0xcfc4201e,0x00000000,0x00000000}},	//   _uredski_, _ब्रिटेन_, --, --,
   {{0xf863e010,0x12507007,0x22e7a021,0xb4b35004}},	//   _artículo, _délka_, _kan__finne_, _antes__do_,
   {{0xe2905010,0x3295500d,0x00000000,0x00000000}},	//   _hola_, _hľadanie_, --, --,
   {{0x3e28e005,0xe2e9a02a,0xb451500d,0xfe5b3005}},	//   _на_, _for__denne_, _pokiaľ__to_, _странке_,
   {{0x23807032,0xf5a0d04a,0xaf025021,0x9bc8c00b}},	//   _carros_, _størrels, _en__oversikt_, _འཆང__མི_,
   {{0x72d99011,0x5c0b001d,0x147d1032,0x643e8018}},	//   _bese_, _obiteljs, _pode__ver_, _ཆོས__རྒྱལ_,
   {{0xb79ac02b,0x42d9c028,0x13dc0003,0xc4787010}},	//   _འཐོན_, _joven_, _uviwo_, _converti_en_,
   {{0x64907021,0xe4cea014,0x6347b00c,0x252ea014}},	// [720] _av__jml_, _concello_, _में__आपकी_, _consello_,
   {{0x9290400f,0x3a61b005,0x24b1a003,0x2eec7005}},	//   _soma_, _međunaro_saradnja_, _ukuba__uza_, _становни_је_,
   {{0xb2d98038,0x73f8e00d,0xdeed0004,0xe484602a}},	//   _vere_, _ponuka_, _melhores_, _tror__du_,
   {{0xfa33e002,0xb269c026,0xc2d87021,0x7369b00d}},	//   _जाय_, _dvije__godine_, _annet_, _likvidác,
   {{0x8290500d,0xa200500d,0xadd9900d,0xb48e4010}},	//   _bola_, _boli_, _deň_, _de__hoy_,
   {{0x825af007,0x92de0021,0x9b4b0005,0x00000000}},	//   _mailem_, _målene__dine_, _računara_, --,
   {{0x23f99037,0x824fc011,0x452da005,0xb3e05007}},	//   _yesu_, _ngolwesi_kusho_, _са__својим_, _dítě_,
   {{0x2224f013,0x0ba3f00f,0x00000000,0x00000000}},	//   _slikar_, _amakoper, --, --,
   {{0x247e701d,0xc4ace010,0x00000000,0x00000000}},	//   _svjetsko_, _con__la_, --, --,
   {{0xd4637004,0x00000000,0x00000000,0x00000000}},	//   _algumas__das_, --, --, --,
   {{0x22d58014,0x4278e00b,0xfc4c1007,0x7bd7c00e}},	//   _máis__grande_, _ཡར__སེང_, _střední_, _གསར__དུ_,
   {{0x826de004,0xd16af003,0x7a4e000c,0x9c0dc00c}},	//   _isto_, _kwisihlo, _एक__हैं_, _जिसे__कि_,
   {{0x6bae900c,0xd3ca1011,0x7d0b401a,0x00000000}},	//   _कोई__भी_, _ne__orlando_, _प्रबंधन_, --,
   {{0xa97f001b,0x4320300f,0x7a4be00c,0xa5a99005}},	//   _ushicile, _mujyi_, _शामिल__हैं_, _организа,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb4429004,0xc2cb401d,0x00000000,0x00000000}},	//   _uma_, _tjedan_, --, --,
   {{0xda07500f,0x6810e00e,0xf2b37013,0x8f02c005}},	// [730] _malariya_, _བརྒྱབ_, _studija_, _школе_,
   {{0xd159d010,0x531ee010,0x00000000,0x00000000}},	//   _los__servicio, _cómo__puedo_, --, --,
   {{0x6cabe00f,0xcc57300c,0xf3243004,0x23507011}},	//   _muri__amerika_, _इसमें_, _de__fazer_, _ngasikha_sinye_,
   {{0x6bc2f00c,0xf20f7011,0xfbfe200c,0x6f8bf007}},	//   _क्या__आप_, _ukuthi__leli_, _ढंग__से_, _svém_,
   {{0x4212b028,0xa23ea023,0xadf6f005,0xb2c8f005}},	//   _fecha_, _hasil__usaha_, _док__су_, _на__челу_,
   {{0x633c7010,0x00000000,0x00000000,0x00000000}},	//   _es__posible_, --, --, --,
   {{0xcb99000c,0xf318f023,0x8f36b005,0x7ba4900e}},	//   _साथ__ही_, _berbeza__dengan_, _је__бивши_, _སྟེང__དུ_,
   {{0xc446d014,0xa47c3005,0xa3696004,0xe27f9005}},	//   _finado__en_, _износила__килограм, _alagoas_, _jasno_,
   {{0x426de010,0x64686004,0x00000000,0x00000000}},	//   _esto_, _dia__de_, --, --,
   {{0x0ba9f00b,0x00000000,0x00000000,0x00000000}},	//   _ཨེསི__སི_, --, --, --,
   {{0xc2d6f007,0xc2c7200e,0xf24f8021,0x934fd011}},	//   _před_, _གཅིག__པའི_, _er__mulig_, _lika__under_,
   {{0xa242f020,0x33ced038,0x9bedf036,0xbba0d00c}},	//   _ཐམས_, _krev_, _ograniče, _उस__पर_,
   {{0xf490e02a,0x00000000,0x00000000,0x00000000}},	//   _få__et_, --, --, --,
   {{0x02ca9010,0x143d8021,0xf2308021,0xb4713004}},	//   _edad_, _på__nytt_, _som__mulig_, _que__uma_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4a32a00a,0xb25c9018,0x4c3c2013,0x348ad00d}},	//   _गइल_, _ལུས__ཀྱི_, _trenutku_, _ktorá__sa_,
   {{0xcf33301b,0x3be0600c,0x4eb98005,0x400c6036}},	// [740] _ukufuman, _और__यह_, _једно__од_, _privredn,
   {{0x6326a021,0x8bf8e02b,0x92925013,0xf0f0900a}},	//   _en__annen_, _གེ__སར_, _ostale_, _लगावे_,
   {{0x6c4e100c,0xd256102b,0x0e395015,0x12fce021}},	//   _करने_, _འཁོར__བའི_, _kemahira, _penger_,
   {{0x12add013,0xe48f702a,0xa3e05007,0xb2ccb010}},	//   _je__postavil, _gå__til_, _sítě_, _la__gran_,
   {{0xc3e93004,0x53cc000f,0x74b16007,0xc24e600b}},	//   _resoluçã, _no__gutanga_, _byste__si_, _རུད_,
   {{0xd12bb010,0xb3eb902f,0x122d7007,0xc90a5028}},	//   _servicio, _meste_, _témata_, _trabajad,
   {{0x6be0200c,0xa3eb9017,0x026c0010,0x12d8b010}},	//   _से__भी_, _leste_, _ocio_, _dicen_,
   {{0x447a1009,0xe4ace02a,0xa9f5800d,0x1fe13005}},	//   _saat__ini_, _alt__er_, _bazár_, _своју_,
   {{0xe2af0003,0x8bad700b,0xb36cb059,0x00000000}},	//   _ucinga__ukuba_, _དང__གས_, _do__mercado_, --,
   {{0xfbc9200c,0x53f95004,0xbb88400e,0x3400d005}},	//   _आसानी__से_, _alguma_, _རྫ_, _једну_,
   {{0x146f6005,0xc3c4f033,0xc2b5e004,0x00000000}},	//   _površini__od_, _skal__være_, _ou__não_, --,
   {{0x53169005,0x9f76901d,0xba3f5014,0x62ca0014}},	//   _je__takođe_, _je__također_, _de__tamén_, _poida_,
   {{0xe2486003,0xfb929024,0xb320100f,0xcc79f005}},	//   _ifom_, _ཡིག__དང_, _nshya_, _prosečna__starost_,
   {{0xd2903003,0x0afa7026,0x5e015009,0xb47bd02a}},	//   _fumana_, _ustuplje, _pemekara, _viser__at_,
   {{0x6329f02a,0x508ca00d,0x5feff014,0xf8179010}},	//   _på__alle_, _nábytok_, _elección, _de__microsof,
   {{0xc2918007,0x027e4038,0xe47ab00d,0xf2c81005}},	//   _stran_, _namn_, _kliknite__na_, _код__жена_,
   {{0x5a32a02d,0x0251f00b,0x59b56005,0x12907009}},	// [750] _गेल_, _གཞིས__གནས_, _додатим__степеном_, _lunak_,
   {{0x027e900f,0x047e8021,0x62b39003,0xb2a5902b}},	//   _cyane_, _programv_som_, _candelo_, _འཛོམས__ཀྱི_,
   {{0x038a0014,0x3beec005,0x64b90019,0x3b69f014}},	//   _parroqui_lugares_, _након_, _equipame_de_, _ligazón_,
   {{0xc293b018,0x1496a021,0x00000000,0x00000000}},	//   _དགོས__པའི_, _så__har_, --, --,
   {{0x823d9009,0x52dc0014,0xbcbc6003,0xd7fb4023}},	//   _bagian__dari_, _de__finado_, _kunye__nolwazi_, _terbahag,
   {{0x024d900e,0x35dae00b,0x0571602c,0x4354e00c}},	//   _འཚལ_, _རྐྱབ_, _mosteiro_, _ढेर__सारी_,
   {{0xa291e015,0x63f9b00f,0x8bd2300b,0xd289700b}},	//   _setar_, _imvugo_, _མིང__གས_, _ཡོངས__དཔེ_,
   {{0xc200702e,0xf2da101b,0xc3435003,0xe3eaf014}},	//   _soni_, _sepedi_, _eyona__ndlela_, _moitos_,
   {{0x963c5006,0x9255c02d,0x22bd400b,0x6984a00d}},	//   _mengirim_, _समुंदर_, _ོབ__རིམ_, _použitie_,
   {{0x7a6e800c,0x64910004,0x00000000,0x00000000}},	//   _करते__हैं_, _citação_, --, --,
   {{0xb2d9c004,0xcb8f300a,0xd262602b,0xbbeb400c}},	//   _deve_, _हँ_, _དང__བཅའ_, _तब__तक_,
   {{0x226c1004,0x53ea0014,0x92da0036,0x3c06f004}},	//   _acho_, _moito_, _meseci_, _fóruns_,
   {{0x32d42005,0x721cc007,0x39351005,0x00000000}},	//   _пунолетн_становни, _na__všechny_, _зграда_, --,
   {{0x0b034005,0x6b7d7011,0x00000000,0x00000000}},	//   _površina__opštine_, _lo__mkhankas, --, --,
   {{0xebb9800b,0xec09200c,0xca1b2016,0xd3435014}},	//   _ནི__གི_, _रहने__के_, _rozlišen, _deseño_,
   {{0xc2ae2015,0x14b23021,0x84953004,0xc45f5010}},	//   _kegunaan__lain_, _akkurat__nå_, _no__dia_, _año__en_,
   {{0x38101020,0xb28cf03f,0xcb1ae00d,0xb7f7f005}},	// [760] _བརྒྱད_, _archív_, _činnosť_, _највећи_,
   {{0xa25ac007,0xf2906006,0x30a2400f,0x0a3fe00c}},	//   _podle_, _mulai_, _yo__kwerekan, _की__खोज_,
   {{0x462ad00f,0xc2bdc00b,0xd48fb023,0x52773010}},	//   _umwihari, _ོམ__རིག_, _mengelak, _hoy__mismo_,
   {{0x43eae004,0x32d67011,0xe28ff00b,0xa0749004}},	//   _pontos_, _kuleli__dolobha_, _ལྷགཔ__ཅིག_, _uma__ferramen,
   {{0x43866030,0x2e8dd005,0xb29f9011,0x00000000}},	//   _spore_, _космос__је_, _ukuthi__yena_, --,
   {{0x89cfb00e,0x020f101d,0x14bd1028,0x00000000}},	//   _ཚོའི_, _ostali__nazivi_, _acabar__con_, --,
   {{0x53981004,0x926d1012,0x3439802a,0xd3ea0030}},	//   _nós_, _subotu_, _at__dette_, _blitt_,
   {{0xc366a010,0xebce100e,0xe30d4004,0x00000000}},	//   _escribió_, _གཞན__དག_, _para__ajudá_, --,
   {{0x0c51b00c,0xdb8d400a,0xb3087004,0xac9da00c}},	//   _पढ़ें_, _कइ_, _que__deve_, _आप__नहीं_,
   {{0x7ae8602f,0x73a2c027,0x9e09a006,0xc8faa02a}},	//   _založený_, _lumpur_, _kepemimp, _er__nødvendi,
   {{0x2e966005,0x327f4013,0x00000000,0x00000000}},	//   _он__је_, _imenom_, --, --,
   {{0xfab4b003,0x527e6003,0x62de6004,0x00000000}},	//   _inyanga__nenyanga_, _eyona_, _em__toda_, --,
   {{0xb2d9c004,0xf4222010,0x00000000,0x00000000}},	//   _teve_, _los__costes_, --, --,
   {{0x2f53f038,0x7bca501d,0xfba9702b,0x1c682011}},	//   _sjå_, _animalia__chordata_, _ཁང__གླ_, _wukuthi_,
   {{0xc321f037,0x028d6027,0x02d9d00f,0xdccf8007}},	//   _utuye_, _perkara_, _yewe_, _mně_,
   {{0xb315e004,0xeb99e00c,0x53874010,0xebe6a00c}},	//   _usuário_, _की__गई_, _fueron_, _घर__के_,
   {{0x92027003,0xc4ae5021,0x1468e021,0xdf0b1021}},	// [770] _yesiza_, _delen__av_, _bli__med_, _og__gjør_,
   {{0xb442d00d,0x5a33e00a,0xe48fc007,0x71fdc007}},	//   _sme_, _जाव_, _klepněte__na_, _pro__všechny_,
   {{0x5bdff010,0xe4430011,0x00000000,0x00000000}},	//   _ingenier, _ke__ukuthi_, --, --,
   {{0x047d602a,0x3228800f,0x38031010,0x00000000}},	//   _hvor__som_, _ibintu__bishya_, _de__ejercici, --,
   {{0x6a329002,0x025f602b,0x00000000,0x00000000}},	//   _खेत_, _ལེན__ཡོད_, --, --,
   {{0x9bbe500b,0x22391005,0xb200b00d,0x140d1007}},	//   _བརྒྱའི__ལས_, _могу_, _hoci_, _může__mít_,
   {{0x9355d021,0x9c625013,0x00000000,0x00000000}},	//   _enheter_, _odbrane_, --, --,
   {{0x2291800d,0x12ca7028,0xb7c41019,0x3a0f3003}},	//   _teraz_, _donde_, _brasilei, _kwisithu,
   {{0xc496300d,0xb457d004,0x00000000,0x00000000}},	//   _keď__je_, _está__uma_, --, --,
   {{0xe2d9d008,0xd548400f,0x6a861027,0x73981004}},	//   _wewe_, _nyakubah, _nyanyian_, _pós_,
   {{0xd2af8011,0xc2908021,0x8242800e,0x9f3dc005}},	//   _ezihamba__phambili_, _inn__lenken_, _དམན_, _треће_,
   {{0xe291c038,0xf349f01c,0x134fa02a,0x64a33004}},	//   _elva_, _lisensi_, _så__langt_, _através__de_,
   {{0x93806006,0xc3de4004,0xe83a300b,0x33374004}},	//   _aturan_, _avaliaçã, _སྒྲིང__སྒྲིང_, _você__deseja_,
   {{0x7c724005,0x3e296005,0xde9e5014,0x00000000}},	//   _број__чланова_, _ваш_, _miúdo_, --,
   {{0x9c3c1013,0xd2926023,0x92a3900e,0x9f5b0028}},	//   _je__ograniče, _kerana_, _པའི__སྒོ_, _para__utilizar_,
   {{0x14db7003,0xf33ce021,0x52f8a010,0xb497d004}},	//   _oku__kubandak, _og__kvinner_, _desde__casa_, _possui__um_,
   {{0x226d200f,0x1a086030,0x4b2db005,0x99f4d00d}},	// [780] _ibyo_, _humanist, _густина__насељено, _budú_,
   {{0xb9ebe040,0xd3f13003,0xe9f66014,0x43d4e010}},	//   _माओवादी_, _lobunini_, _tería_, _el__cuerpo_,
   {{0xa3cf8007,0x00000000,0x00000000,0x00000000}},	//   _barva_, --, --, --,
   {{0x1f5e9028,0x22d91007,0x0bd1e01e,0x00000000}},	//   _vacacion, _docela_, _करियर_, --,
   {{0x5c6f6017,0xafbe9007,0x00000000,0x00000000}},	//   _derrota_, _sdílet_, --, --,
   {{0xedd10024,0x54a9d021,0x00000000,0x00000000}},	//   _མཚན__རྟགས_, _snakker__om_, --, --,
   {{0xd471b023,0x8447c007,0x43c6b00d,0x4327c00d}},	//   _lesen__hak_, _na__webu_, _pre__vás_, _na__webe_,
   {{0x62e6702a,0x64a8d014,0x9af07014,0x00000000}},	//   _din__egen_, _goberno__de_, _atópanse_, --,
   {{0x43418004,0xc497e007,0x9359e011,0x0bf85002}},	//   _janeiro_, _si__je_, _ngonyaka__ozayo_, _एलबम_,
   {{0x5835c00b,0x0a46000c,0x3e08100c,0x00000000}},	//   _ཁྲིམས__སྤྱི_, _तलाश__में_, _सद्ग्रन्, --,
   {{0xae62e013,0x6041700c,0x62ade00b,0x31d9a01a}},	//   _staništa_, _से__प्रारंभ_, _ིན__དགོ_, _नज़र_,
   {{0xf30d2004,0x6b750017,0x033b6010,0x00000000}},	//   _deverá_, _conserva_, _los__lugares_, --,
   {{0x927e7038,0x8d09e00a,0x227bc011,0x1be2500e}},	//   _fann_, _बबुआ_, _kodwa__lokho_, _བྱས__པས_,
   {{0x69cfe00e,0xeae1d012,0x1acb402a,0x34c2600d}},	//   _བོའི_, _dopušten, _den__største_, _roku__sa_,
   {{0x83ef6027,0x725a0029,0xee62e005,0x734f600d}},	//   _dalam__daerah_, _feil_, _stanište_, _pozemok_,
   {{0x42d8f038,0x23ee901c,0xc3ea100d,0x225af00d}},	//   _eigen_, _di__eropa_, _tohto_, _mailom_,
   {{0x11d0e040,0xad90e004,0x32d48034,0x827e901c}},	// [790] _telefony_, _telefone_, _unionen_, _ajang_,
   {{0xd2902015,0x241d0011,0x3f885010,0x00000000}},	//   _sukar_, _noma__iyiphi_, _las__relacion, --,
   {{0xd2dc6027,0xf2d89026,0x12dea010,0x00000000}},	//   _di__nama_, _lijepa_, _la__zona_, --,
   {{0x1e079011,0x64967010,0x91a19005,0xc4a02010}},	//   _unobhala__jikelele_, _préstamo_de_, _одговара, _póngase__en_,
   {{0xccaec005,0x348ea014,0x1468e02a,0x8203100b}},	//   _спољашње__везе_, _de__cor_, _dem__med_, _ཟེར__ཨིནམ_,
   {{0xb34f1011,0x00000000,0x00000000,0x00000000}},	//   _ngaso__linye_, --, --, --,
   {{0xf36f2006,0xa00d5007,0xc06d0013,0xe2e35011}},	//   _tingkat_, _proveden, _režirao_, _umuntu__oyedwa_,
   {{0x13fa5010,0xd2e8a01c,0x1c025014,0x14509010}},	//   _actual_, _pikiran_, _persoas_, _ocurre__con_,
   {{0xbdc4a003,0xb4694005,0x23418014,0xa25ad011}},	//   _ootitsha, _stanovni_mestu_, _xaneiro_, _hlelo_,
   {{0x53874010,0xba160023,0x32b8e00e,0xca4f800c}},	//   _puerto_, _dijangka_, _མི__ཉུང_, _कि__कोई_,
   {{0xe46de021,0xfbfa700e,0xaf8f9010,0xac6da00c}},	//   _hva__er_, _མྱ__ངན_, _puede__realizar_, _वह__नहीं_,
   {{0x4d5ac005,0xc34ba011,0x762a900b,0x00000000}},	//   _човек_, _izolo__uthe_, _ལྷགཔ_, --,
   {{0x93ea0038,0xc48eb010,0x04ad500f,0x026ee00e}},	//   _veit_, _de__los_, _mbere__yo_, _ཏུ__གནས_,
   {{0x72d85023,0x4424100f,0xb3f85023,0xc588d014}},	//   _filem_, _arakomez, _filum_, _poboació,
   {{0x32cad021,0x5497e028,0x7bd3400e,0xb47ad003}},	//   _bilder_, _si__se_, _སྐད__དུ_, _icon__ye_,
   {{0xcef38005,0x7da04024,0x030d402c,0xc25aa028}},	//   _broj__država_, _ལྷན__ཚོགས_, _lugares_, _doble_,
   {{0x6236601d,0xc4505010,0x00000000,0x00000000}},	// [7a0] _spoji_, _piense__en_, --, --,
   {{0x9488e021,0x9b2f300e,0xa495602a,0xf2139003}},	//   _noen__få_, _དཔུང_, _og__vi_, _xesha_,
   {{0x36837028,0x9badb00c,0x00000000,0x00000000}},	//   _producci, _था__कि_, --, --,
   {{0x33ebe030,0x0294900b,0x72c23011,0xa2ca5014}},	//   _dette_, _གཞི__གནས_, _into__ecokeme_, _rolda_,
   {{0x93278011,0x84ad6021,0x6629602c,0x13eae017}},	//   _ngo__okthoba_, _kan__ha_, _soviétic, _pintor_,
   {{0x2c026004,0xe495e00d,0xbbced00c,0x00000000}},	//   _pessoas_, _sa__tu_, _काम__पर_, --,
   {{0x56fe000a,0x9bd30030,0x00000000,0x00000000}},	//   _खीरा_, _oppdater, --, --,
   {{0xd323402a,0x8479c011,0xe44ce007,0xbf23400b}},	//   _de__ikke_, _kusukela__ngo_, _se__kterými_, _ནང__འབྲུག_,
   {{0x4b913003,0xc3eae003,0x72831011,0x8298800e}},	//   _icandelo_, _umntla_, _minyaka__yonke_, _སྐུལ__ཚིག_,
   {{0x92cbd004,0x83f4f02a,0xc25e600b,0xc4775021}},	//   _educação_, _liste__over_, _ཡོད__ཡིག_, _enda__en_,
   {{0x4c88e040,0x7d2e4021,0x9a3de02d,0xcc006004}},	//   _त्यो_, _registre_, _दीं_, _férias_,
   {{0x6444400d,0xe47de02a,0x7a33e00a,0xf985d01a}},	//   _aj_, _mens__du_, _जाइ_, _जिसमें_,
   {{0x7df1100e,0xce49f023,0xf393900d,0x3490800d}},	//   _མང__ཚོགས_, _antaraba, _je__súčasťou_, _týkajúci_sa_,
   {{0xf4420003,0xdcf18021,0x81937003,0x00000000}},	//   _eli_, _fakturer, _shicilel, --,
   {{0xa3f87016,0xa2a6d03a,0x3436b021,0xfe27300e}},	//   _minut_, _mbeba_, _de__siste_, _བཅོས__བསྒྱུར_,
   {{0xf2c11011,0x63805005,0x32d8c011,0x00000000}},	//   _ku__arrows_, _ostrva_, _kulezi_, --,
   {{0xb496e033,0xdc394010,0xc2be0004,0x6bb7d00c}},	// [7b0] _om__at_, _suscripc, _você__não_, _क्योंकि__वह_,
   {{0xf35c8023,0x00000000,0x00000000,0x00000000}},	//   _boleh__didapati_, --, --, --,
   {{0xda375018,0xf4058007,0x6d80c00e,0x32ff6004}},	//   _པོ__ཆེའི_, _sdružení_, _བགྲོད_, _ele__pode_,
   {{0xb3d7e02a,0x4225903b,0xcb1f9023,0x0e6c2005}},	//   _og__andre_, _tysk_, _bahagian_, _општине_,
   {{0xf27c3004,0xf496e033,0x2bd7000a,0xc2b2000b}},	//   _necessár, _om__et_, _कहियो_, _གས__འབད_,
   {{0x7e1b7009,0x84431003,0xfafd9030,0x38d9f005}},	//   _ditemuka, _umz_, _autentis, _занимљив,
   {{0x42b54010,0x935b8003,0xc458300d,0x42dc7011}},	//   _precio_, _isigama_, _aký__je_, _le__albhamu_,
   {{0xd30f701c,0x82b0900b,0x1fb0c00d,0x0e0d1005}},	//   _berbeda_, _མི__ངོམ_, _čítaj_, _ови_,
   {{0x33e5201c,0x8d8c001d,0xbaec4021,0x0b93002b}},	//   _pranala__luar_, _jučer_, _mer__informas, _ཡིག__ནང_,
   {{0xf41ff005,0x0abe600c,0x4bcdf00a,0xe37b0004}},	//   _na__nadmorsk, _बारे__में_, _तरे_, _espaço_,
   {{0x74444004,0x524da00b,0x22dfa00d,0x00000000}},	//   _rj_, _ཧེང_, _je__teraz_, --,
   {{0x649c3014,0x2c1bc01c,0x1c1d100f,0xd296c02b}},	//   _xuño__de_, _kekaisar, _yatangar, _བགོ__བཤའ_,
   {{0x4bccd00b,0xa0941019,0x743ef00d,0x00000000}},	//   _ལུགས__ལོ_, _as__ferramen, _všetky__tieto_, --,
   {{0x04523021,0xf3f8201d,0x451ff003,0x748cd007}},	//   _den__beste_, _ruku_, _wedoloph, _abyste__si_,
   {{0x6320703d,0x43874010,0xa479602a,0xc478a022}},	//   _kanye_, _cuerpo_, _lang__tid_, _encontra_en_,
   {{0x326f4003,0xbf11800b,0x7c07900c,0x00000000}},	//   _ngapha__koko_, _བསྐྱོདཔ__འབྲུག_, _जाए__तो_, --,
   {{0x7e9e2005,0x3b4b9037,0x64924028,0x00000000}},	// [7c0] _налази__се_, _ubutumwa_, _electrón_de_, --,
   {{0x44ad6021,0x23b3b012,0x0b43b012,0x96d15010}},	//   _kan__ta_, _čovjek_, _čovjeka_, _es__necesari,
   {{0xf1be4005,0x2439f005,0xf48ca02a,0x5a6b200c}},	//   _општине__износи_, _na__svetu_, _da__han_, _कुछ__समय_,
   {{0x7ef4d005,0xeb0c9036,0xebe6e00c,0x770f601e}},	//   _које__се_, _prisutna_, _और__वे_, _जल्द_,
   {{0x33109003,0x98626007,0x34982007,0x00000000}},	//   _yemali__mboleko_, _zapomenu, _to__jen_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xebb9e00e,0x7da17013,0x722a7005,0x8b892010}},	//   _དེ__དག_, _takmičar, _мора_, _de__energía_,
   {{0x3a4d500c,0xf2cd4023,0x7e871014,0xa2900019}},	//   _के__साथ_, _mempunya_lima_, _de__tiña_, _criar_,
   {{0xb4b5501f,0xa3f8a009,0x62b65010,0xbbe2700b}},	//   _inyandik, _gedung_, _un__año_, _ཕྲུག__ཚུ_,
   {{0x44abd00d,0x73957011,0x00000000,0x00000000}},	//   _stránke_, _abasha_, --, --,
   {{0x7bb61018,0xbc01600c,0xc2ba7011,0x6df5d004}},	//   _ལམ__དུ_, _जाने__पर_, _umndeni_, _os__principa,
   {{0x7acac020,0xc2cb1012,0x00000000,0x00000000}},	//   _འཇིག_, _mozda_, --, --,
   {{0xf3f8b006,0x73578005,0xac0bf00c,0x00000000}},	//   _diduga_, _по__попису_, _सेवा__की_, --,
   {{0xc3fa7005,0x6be1a00c,0x32b81004,0x0c65f00c}},	//   _okrugu_, _जब__भी_, _de__jogos_, _कि__मुझे_,
   {{0xebb9500c,0x2d253005,0x549fe004,0x00000000}},	//   _शरीर__के_, _оца_, _você__fez_, --,
   {{0x02ff2023,0xe2e22011,0x32821028,0xfbd2c00e}},	//   _tidak__faham_, _lo__mbhalo_, _esta__forma_, _བརྒྱ__དང_,
   {{0x0e292003,0x9c88900a,0xa20d200d,0xb395f021}},	// [7d0] _nomganga, _दूनो_, _pracovné_, _livene__våre_,
   {{0x7bb9e00e,0x6e9b8005,0x023f6011,0x00000000}},	//   _དེ__ནི_, _преузето__са_, _kuze__kufike_, --,
   {{0xd3ead00d,0x499c2026,0xd3f8f022,0x83946010}},	//   _svet_, _srušili_, _sigue_, _ojos_,
   {{0xe2902023,0xd3a53005,0x00000000,0x00000000}},	//   _rakan_, _vizantij, --, --,
   {{0x2440b02e,0x92904023,0xe20d2007,0x16e20005}},	//   _abakurik, _laman_, _pracovní_, _резултат,
   {{0xd2d8303a,0x4c7d201c,0x5b1fc023,0xc2a3f00e}},	//   _tuje_, _stasiun_, _kelantan_, _ཀྱི__རིག_,
   {{0xfa3ca00a,0xd280b00e,0x7442900d,0xc2ac800b}},	//   _लखन_, _ལོ__ཡིན_, _ťa_, _རམ__གྱི_,
   {{0x847ed006,0x42c1800d,0x1476f02a,0x9291f004}},	//   _kota__di_, _žilina_, _sammenli_med_, _atual_,
   {{0x9bd58024,0xe430b011,0x940f8022,0xb4ac6010}},	//   _གནས__ཚད_, _ngokusob_ukuthi_, _de__canadá_, _hasta__el_,
   {{0x03890003,0x8a5b400c,0xebe98018,0x9bc2f02b}},	//   _bakho__kunye_, _का__पता_, _ངག__གི_, _བདག__ལས_,
   {{0x2b884020,0xb24ee00e,0x2876801f,0xcb9b200e}},	//   _ཡེ_, _རྣམས__ཀྱི_, _abanyamu, _ཡིན__ནོ_,
   {{0x11938003,0xad8d9007,0x02bf3018,0x1412e004}},	//   _inkcazel, _jihomora, _སུ__ཡོད_, _existem__muitos_,
   {{0xd2ff8011,0x9e8fb005,0x8301f023,0x00000000}},	//   _kwazulu__natal_, _на__крају_, _seramai_, --,
   {{0x52d85031,0x2e728005,0xf30da005,0xa2918026}},	//   _kule_, _попису__из_, _dati__tabeli_, _kurac_,
   {{0xa677900e,0x33f9000f,0x00000000,0x00000000}},	//   _འམ__དཔྱད_, _nibura_, --, --,
   {{0x8483d023,0xd2b1e01c,0x73406023,0x7b94400e}},	//   _stub__di_, _bandara_, _dalam__filem_, _ཉིད__དུ_,
   {{0x73c6b010,0x00000000,0x00000000,0x00000000}},	// [7e0] _el__tamaño_, --, --, --,
   {{0xd2918010,0xf2ea5004,0xc2caf00d,0x6f8be007}},	//   _otras_, _região_, _pridaj_, _části_,
   {{0x44765014,0x73309010,0xb4c4c011,0x00000000}},	//   _lugar__da_, _del__mundo_, _kuthunye_ngu_, --,
   {{0x3a33400a,0xd2cb900d,0x8deb1004,0x089ad004}},	//   _कइल_, _dokonca_, _você__encontra, _uma__variedad,
   {{0xea4d600c,0xea32b02d,0xc28a300b,0x64962014}},	//   _के__बाद_, _खतम_, _བཙག__འཐུ_, _no__sur_,
   {{0xbb93200b,0xca009006,0x72692007,0x500ac007}},	//   _ཡིག__ཚུ_, _tepatnya_, _vybavení_, _několika_,
   {{0x2c4e101e,0x343a0021,0x02de100c,0x64595010}},	//   _करते_, _av__dette_, _करती_, _calidad__de_,
   {{0x8254500b,0xa0464007,0xb2fde029,0x35178011}},	//   _རྒྱན__དབང_, _zeměděls, _arkiver_, _ngesonto_,
   {{0x93e5100d,0x2eec9005,0x41e3c00a,0xa3a41013}},	//   _podmienk, _лансирањ_је_, _उनकरा_, _dinastij,
   {{0xa3eb8038,0x99f42007,0x7cddf011,0x00000000}},	//   _flytta_, _jaké_, _van__heerden_, --,
   {{0x62429024,0xec05d038,0x4394e01c,0x49e17013}},	//   _བཟོ_, _viktigas, _konser_, _takmičen,
   {{0xee8b500c,0x00000000,0x00000000,0x00000000}},	//   _इस__पृष्ठ_, --, --, --,
   {{0xe4be602a,0x1b8fc002,0xc290301b,0x4ada800b}},	//   _hvis__du_, _तँ_, _iimali_, _ལུང__ཕྱོགས_,
   {{0xd25b7005,0xb277f005,0x42e3b003,0x83fde00f}},	//   _promene__broja_, _zapadnoj__godine_, _okanye__inkonzo_, _kwizera_,
   {{0xb3334023,0xb2c4301c,0xa54c9022,0x00000000}},	//   _penyelia__senarai_, _televisi_, _pequeño_, --,
   {{0x81ec900a,0xd78a400b,0xa2011023,0x62103011}},	//   _तोहरा_, _བསམ__བཀོད_, _muzik_, _ukuthi__lezi_,
   {{0x632c4007,0xc3a23023,0x46d1300a,0x2cfe300f}},	// [7f0] _těchto_, _kempen_, _किसिम_, _kwitabir,
   {{0x5a58a00f,0x03250004,0xb2680010,0x0c09200c}},	//   _ijambo__ryibanga_, _de__iates_, _del__sitio_, _अधिक__है_,
   {{0xa408d003,0x72de9021,0xb4913011,0xd3af900f}},	//   _isigqibo_, _mange__forskjel, _ke__uma_, _muyindi__nzira_,
   {{0x1e80300d,0x52973010,0xc46e6010,0x00000000}},	//   _hľadáte_, _el__mismo_, _hay__un_, --,
   {{0x646fa021,0x5edba00c,0xbf3a2004,0xe7bf200b}},	//   _seg__for_, _में__समर्थ_, _as__mulheres_, _ཟད__གྲོན_,
   {{0x0c27101d,0x59f36028,0xdb0a6030,0x4b2a900e}},	//   _vanjske__poveznic, _constitu, _tilpasse, _ལྷུང_,
   {{0x29cd8011,0xd2e11011,0x8bde500e,0x0351b00f}},	//   _ku__inthanet, _ukuze__uthole_, _གཞོན__ནུ_, _mumwanya__umwe_,
   {{0xdc684009,0xbe8f1005,0xb3ea7019,0x0d86402c}},	//   _dimulai_, _али_, _ponto_, _interese_,
   {{0x02904038,0x92d82038,0x92009004,0x69f4b00d}},	//   _saman_, _riket_, _quais_, _hodín_,
   {{0x3f2e2028,0xc04dc01d,0x54985010,0x627e3003}},	//   _editoria, _izvornik_, _cómo__se_, _kumntu_,
   {{0x9bdf300c,0x35932003,0x2be2c00b,0x3bdfe00c}},	//   _जो__कि_, _zaseburh, _པའི__བས_, _से__यह_,
   {{0x2587d023,0x2ef15005,0x6e957026,0xe9f5c02f}},	//   _portal__masyarak, _град__је_, _slijedeć, _prvé_,
   {{0x39f42016,0xd33ac021,0x1cb3d026,0x4eb8e005}},	//   _také_, _du__trenger_, _mjesto__sastavu_, _ми_,
   {{0xc252b00e,0x0b60b005,0x00000000,0x00000000}},	//   _ཁུལ__གྱི_, _админист, --, --,
   {{0xc49a502a,0xfc76f00a,0x2bade00c,0xab699004}},	//   _være__en_, _फिल्मन_, _समाप्त__हो_, _de__pesquisa_,
   {{0xb224d003,0xb3ff4011,0xd2b4100b,0xf23e7011}},	//   _imeko_, _wezemfun_kwazulu_, _ེལ__བའི_, _uthe__leli_,

   {{0xa2aee02a,0x53098010,0xb964a040,0xb48ce028}},	// [800] _den__samme_, _añadir_, _použití_, _contra__el_,
   {{0xe2781007,0x52d8c011,0x00000000,0x00000000}},	//   _letní_, _kuleli_, --, --,
   {{0xaaf04024,0x647ac010,0x64a65010,0x00000000}},	//   _སློབ__ཕྲུག_, _desarrol_de_, _trabajo__de_, --,
   {{0x029d800b,0x3c94900c,0x223c6011,0x00000000}},	//   _དགོཔ__ཨིན_, _सबमिट__करें_, _kwenzeka__lesi_, --,
   {{0x43797016,0x4a4e300c,0x232d2010,0x1f7f8010}},	//   _poradna_, _के__नाम_, _un__entorno_, _la__comunica,
   {{0xf438a014,0x62d9e004,0x0264500e,0xf296800d}},	//   _en__conta_, _ontem_, _སློབ__གསོ_, _sa__tým_,
   {{0xeb5ab013,0x04bc3021,0x998e500d,0x7bb3300b}},	//   _je__prisutna_, _funksjon_som_, _postupuj_podľa_, _ཉལ__ཁང_,
   {{0x0200c028,0x348be021,0x74652014,0x7407500f}},	//   _nadie_, _vare__på_, _diferenz, _mugihe__gikwiye_,
   {{0x83291011,0xa3bbb01f,0x59da8026,0x06794010}},	//   _gallo__images_, _indwara_, _spremlje, _miércole,
   {{0x44388021,0x34b1e003,0xa9c54007,0x1495e00d}},	//   _en__flott_, _ukuba__uye_, _pro__váš_, _sa__mi_,
   {{0x686da013,0x827bc011,0x1b6ab00b,0xafd5a00e}},	//   _proizvod, _kodwa__lokhu_, _ཉོགས__འཛིང_, _བྱེད__རྒྱུ_,
   {{0x227f4010,0x6290f023,0x744c8010,0x0e292005}},	//   _tienen_, _bahawa_, _gestión_, _рад_,
   {{0x229f9005,0x7f33200f,0x00000000,0x00000000}},	//   _pad__broju_, _ubufatan, --, --,
   {{0xe4c2700f,0xb1772005,0x29fcd003,0xe68a7005}},	//   _yoherejw_na_, _месту_, _ngorhulu, _организо,
   {{0x8bc85003,0x22001004,0x00000000,0x00000000}},	//   _apha__ngezants, _bahia_, --, --,
   {{0x93eb8038,0xc3df2004,0x00000000,0x00000000}},	//   _vorte_, _de__dois_, --, --,
   {{0xe24ed013,0x747b902a,0xdc186010,0x9bcec024}},	// [810] _je__jedino_, _hver__dag_, _despues_, _གཞན__མི_,
   {{0x06cf400c,0x9332f014,0x00000000,0x00000000}},	//   _का__उत्तर_, _orixes_, --, --,
   {{0xc4426003,0x36fee01a,0xb228b03b,0x386d9010}},	//   _olo_, _करना_, _søk_, _consejos_,
   {{0xb4677023,0x6d7f3005,0x00000000,0x00000000}},	//   _sub__filum_, _јун_, --, --,
   {{0x1b9d5018,0xc4ae6021,0xebe9800e,0xf44f8010}},	//   _ཡོད__པས_, _gir__en_, _གང__གི_, _un__seguro_,
   {{0xe4ade02a,0xbda4901d,0xf3320014,0x625ac00d}},	//   _her__er_, _godine__općina_, _orixe_, _podla_,
   {{0x4a3e700a,0xf48d8010,0x1213a011,0x00000000}},	//   _भरल_, _de__oro_, _kepha_, --,
   {{0xfdf5801d,0x77939017,0x0aa3500c,0x00000000}},	//   _sjednite_, _guitarri, _की__उम्मीद_, --,
   {{0x3b6c6013,0xbbe2500c,0x42dea010,0x00000000}},	//   _februara_, _घर__पर_, _el__lugar_, --,
   {{0x2442601b,0x82e91014,0xf1e5f011,0xe594f011}},	//   _elo_, _camiño_, _utshele__inkantol, _unkulunk,
   {{0xabc7400b,0x00000000,0x00000000,0x00000000}},	//   _བདག__དེ_, --, --, --,
   {{0x7293300e,0x00000000,0x00000000,0x00000000}},	//   _རེད__གསལ_, --, --, --,
   {{0xf3755023,0xa290303a,0x2eb1e005,0x3d838005}},	//   _menyumba_dengan_, _yamara_, _врста__је_, _reči_,
   {{0xda226003,0xd2248007,0x1295600e,0xc2afe011}},	//   _kwicande, _velká_, _དབུས__གཙང_, _wukuthi__abantu_,
   {{0xc004c015,0x8dc0700b,0x83256022,0x22b4f013}},	//   _elektrik_, _བརྒྱའི__རིངས_, _de__motores_, _uticaj_,
   {{0x82beb014,0x2eb98005,0x844c8014,0xd32eb010}},	//   _que__unha_, _била__је_, _xestión_, _el__anuncio_,
   {{0x6491700f,0xe2c57010,0x85b0b00f,0xb493f021}},	// [820] _na__jml_, _además_, _abasirik, _og__mye_,
   {{0xd26a3005,0x92d58004,0x1452802a,0x32250015}},	//   _је__један_, _conosco_, _den__rette_, _adakah_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc290d010,0xed8e400b,0xb3e6b010,0x00000000}},	//   _dudas_, _གཞུང__སྐྱོང_, _el__más_, --,
   {{0x549c7005,0x0395c00d,0x73c3600f,0x0c14600c}},	//   _opština__se_, _časť_, _kuri__imeri_, _दिया__है_,
   {{0x04426038,0x00000000,0x00000000,0x00000000}},	//   _slo_, --, --, --,
   {{0xccf5c00c,0x1be2a00e,0xb296b00d,0x00000000}},	//   _इलाकाई_, _དྲུག__ཅུ_, _sa__nám_, --,
   {{0x6ccfe00c,0xb4726004,0x430df004,0x00000000}},	//   _मदद__करने_, _tem__um_, _qualquer__lugar_, --,
   {{0x54339003,0x4f220032,0xc27a502b,0x86711011}},	//   _into__yokuba_, _seus__produtos_, _གནང__པའི_, _njalo__ngolwesi,
   {{0x329df01d,0xa357c003,0x3ba0600c,0xdbb1002c}},	//   _srijeda_, _intaneth_kwaye_, _है__यह_, _proteína_,
   {{0x3bdd300b,0x43439003,0x7462a011,0xf7f92005}},	//   _ཨིན__མས_, _kwaye__wenze_, _emuva__kokuba_, _серије_,
   {{0x0bb4500b,0x125b9005,0x22d10011,0xe2c84007}},	//   _ནི__ལུ_, _posle_, _nje__ngoba_, _vytvořit_,
   {{0x0b74300e,0x3b840005,0xc2a66035,0x00000000}},	//   _མཛད__དགུང_, _генераци, _uqobo_, --,
   {{0x9acac018,0x00000000,0x00000000,0x00000000}},	//   _འཇུག_, --, --, --,
   {{0x82bfc015,0x79f5f00d,0x885d6004,0x00000000}},	//   _sebahagi_besar_, _autá_, _brinqued, --,
   {{0x52499028,0x02731023,0x14b02014,0xc283300e}},	//   _mismo_, _tahun__bagi_, _non__foi_, _མཁན__གྱི_,
   {{0x09f43007,0xb2ce9011,0x2be3400b,0x00000000}},	// [830] _mají_, _uthe__yena_, _བའི__བས_, --,
   {{0x6eca3011,0xd291101c,0x9bfa0024,0x00000000}},	//   _imininin, _dibagi_, _མི__མི_, --,
   {{0x7320301f,0x92d9b014,0x4ea35030,0xa22ff00d}},	//   _bajya_, _niveis_, _opprette_, _ste__boli_,
   {{0xe46f5006,0xf27c0005,0xb6ffc00a,0x33210007}},	//   _jawa__timur_, _kilogram_kosmos_, _अलगा_, _nebylo_,
   {{0xe88fc005,0x9f83c00a,0x00000000,0x00000000}},	//   _детаљни__подаци_, _उनुका_, --, --,
   {{0xc4604005,0xb475d011,0x3412e004,0x00000000}},	//   _učestvov_je_, _ikakhulu_uma_, _existem__muitas_, --,
   {{0x54429038,0x42d8901d,0xebd4e00c,0x00000000}},	//   _ola_, _cijena_, _कनाडा__के_, --,
   {{0x3b88100c,0x1808c003,0xf490f00d,0x00000000}},	//   _यह_, _izicwang, _miesto__kde_, --,
   {{0xd4931005,0x99f5b007,0x563f800f,0x00000000}},	//   _računaru__su_, _navíc_, _ikinyarw, --,
   {{0xa2cb400d,0x61867005,0x5b8ca00e,0xc25af005}},	//   _predaj_, _su__slatkovo, _པཎ_, _mogli_,
   {{0xa2e6c014,0x74627021,0x73eb9016,0xada9e004}},	//   _da__súa_, _ditt__eget_, _odst_, _eleitora,
   {{0xb44ff021,0xe3543023,0xcb0e7003,0x3296b00d}},	//   _har__fått_, _selepas_, _intshona_, _sa__vám_,
   {{0xd200801b,0x00000000,0x00000000,0x00000000}},	//   _uthixo_, --, --, --,
   {{0x68aa3005,0xb4429004,0xb2132010,0x12d83005}},	//   _од__налази_, _ela_, _muchos_, _nije_,
   {{0xd293600e,0x025f0024,0x034cc011,0x12df5004}},	//   _ཞིག__ཡིན_, _ཁག__གིས_, _ukuze__kube_, _na__loja_,
   {{0x4b612010,0x5d874036,0x0fafe007,0xe2d22007}},	//   _también_, _međunaro, _spíše_, _se__jedná_,
   {{0x42d5400f,0x2bf8100c,0x52bca010,0x00000000}},	// [840] _mbere__yuko_, _में__हम_, _usted__mismo_, --,
   {{0xc212902e,0xff34d00f,0x5a096004,0x00000000}},	//   _ngaha_, _uburinga, _propried, --,
   {{0x526df00b,0x52cb8038,0x24a30028,0x53071036}},	//   _ཇོ__བདག_, _jorda_, _proyecto_, _narodnog_,
   {{0x8ca1400c,0x9ce1400c,0xcf0a700c,0xbc335019}},	//   _जो__आपके_, _जो__आपको_, _की__पेशकश_, _benefíci,
   {{0xbf18e00b,0xf4bc8021,0xc2b1800b,0x9bbc802b}},	//   _འབྲུག__འབྲུག_, _bortsett__fra_, _རང__འབད_, _ཡི__མི_,
   {{0x64b36014,0xac52401d,0x85386005,0x31ed100d}},	//   _concello__de_, _žetona_, _метара__максимал, _formulár,
   {{0x6a7eb00d,0x76d7d005,0x00000000,0x00000000}},	//   _vášho_, _армије_, --, --,
   {{0x42122031,0xc294e00b,0x027f001b,0xd4778022}},	//   _kukho_, _བཅའ__ཡིག_, _ebanzi_, _necesari_que_,
   {{0x22024003,0xbd8fd02b,0xab9e300e,0x1eff3010}},	//   _ulwimi_, _བཤུས_, _པོ__བྱུང_, _los__anuncios_,
   {{0xfc5bd003,0x5dbed010,0x8cc8d005,0x00000000}},	//   _kakuhle_, _pelicula, _новембар_, --,
   {{0xf3ba801c,0x12d87016,0xc4c2b021,0x348f6010}},	//   _jenis__lisensi_, _ihned_, _produsen_av_, _de__lo_,
   {{0xba1e2005,0xcbfb300b,0xb241c010,0x00000000}},	//   _види_, _ོན__པོ_, _que__muchos_, --,
   {{0xfed52005,0x0323b011,0x1342c005,0x3319f007}},	//   _код_, _umnuz__thabo_, _pobedio_, _na__prodej_,
   {{0xd320a00f,0xad00e029,0x82499005,0xd0f7f00c}},	//   _nabyo_, _returner, _pismo_, _की__समीक्षा_,
   {{0x0cdd002a,0x848f6014,0x4923a00a,0x113f5010}},	//   _den__første_, _de__ao_, _एहिजा_, _venezuel,
   {{0x62d83008,0xfba3900e,0xbf53000b,0x49c7c005}},	//   _sije_, _ཡུལ__དང_, _ཨིན__འབྲུག_, _напада_,
   {{0xb2234012,0x34aea021,0x17fb201d,0x8291600f}},	// [850] _naselje__godine_, _mer__enn_, _meebling, _bigari_,
   {{0xba33b00a,0x7d8c000d,0x1b2dc023,0x184d0005}},	//   _आइल_, _počas_, _timbalan_, _neposred,
   {{0x1bdd500b,0xb46de003,0xa290f014,0xf0491005}},	//   _ཨིན__པས_, _nge__ka_, _augas_, _период_,
   {{0xfbbaf00b,0x00000000,0x00000000,0x00000000}},	//   _དེ__གླ_, --, --, --,
   {{0xf2918004,0x00000000,0x00000000,0x00000000}},	//   _fora_, --, --, --,
   {{0x44192023,0x4290f017,0x99f96037,0xc3f8c040}},	//   _mengikut__tempat_, _lugar_, _gushyira_, _budu_,
   {{0xd2c71015,0xc3954004,0x93020014,0xb47b3004}},	//   _mana__mana_, _acesso_, _rematou_, _controle__do_,
   {{0x0471a004,0x00000000,0x00000000,0x00000000}},	//   _dinheiro__com_, --, --, --,
   {{0xcd07a005,0x7201b019,0x00000000,0x00000000}},	//   _је__град_, _devido_, --, --,
   {{0x7b62a02d,0xb2d6f007,0xf338a014,0x5b7c2004}},	//   _जमाना_, _přes_, _na__rexión_, _reconhec,
   {{0xca00f009,0x0c09e023,0x22773016,0x325cc004}},	//   _surabaya_, _tropika_, _oblíbené_, _da__manhã_,
   {{0xa35dc011,0x9201901d,0x2290f010,0x12927013}},	//   _eqenjini__lesizwe_, _nosi_, _jugar_, _pesama_,
   {{0x1ed11028,0xd2e11022,0xb63e8012,0x35f3a004}},	//   _anuncios_, _anuncio_, _sastav__stanovni, _orientaç,
   {{0xb26c8007,0xd2d9e04b,0x5c620006,0xebbe9018}},	//   _nahoru_, _enten_, _jurusan_, _ལྷ__མོ_,
   {{0x53250032,0x934c8021,0x13574014,0x00000000}},	//   _de__obter_, _du__legger_, _arredor_, --,
   {{0xb3991010,0xc2919010,0x7ddde01c,0xa437c005}},	//   _más_, _cosa_, _menjabat_, _sovjetsk,
   {{0x226d200f,0x0ba2700c,0xb326d00c,0x953b3023}},	// [860] _icyo_, _रहा__है_, _लिए__यहाँ_, _sepanyol_,
   {{0x01a2a007,0xb26e600e,0xcc66c029,0x02eef003}},	//   _hledání_, _ནི__དཀར_, _knyttet_, _ekufuphi_,
   {{0x4f678005,0x42026004,0x9bbd1003,0x00000000}},	//   _је__насељено_, _equipe_, _izakhono_, --,
   {{0xb290c015,0xb48f605a,0x634bf021,0x89f66004}},	//   _badan_, _de__to_, _du__velger_, _terça_,
   {{0x45ba600c,0x00000000,0x00000000,0x00000000}},	//   _है__परंतु_, --, --, --,
   {{0x637c6019,0xd4083004,0x5aa6200c,0x00000000}},	//   _seus__artigos_, _vez__disso_, _में__समय_, --,
   {{0x338eb023,0x427f4040,0x6ec16031,0x00000000}},	//   _pautan__luar_, _jednou_, _komntwan, --,
   {{0x73950019,0xb269900f,0x00000000,0x00000000}},	//   _brasil_, _cyane__muri_, --, --,
   {{0xc2853011,0x3c0cb00b,0x0bae900b,0x00000000}},	//   _nomndeni__wakhe_, _ཅིག__གོ_, _དང__ིས_, --,
   {{0x92d9e038,0xb909000f,0x7711b00c,0x7b328024}},	//   _anten_, _urubyiru, _करना__चाहिए_, _ངོ__གཅིག_,
   {{0xb51e300c,0x92a6703d,0x643e1005,0xe4b1d011}},	//   _के__कारण_, _kanjani_, _јасно_, _lakho__le_,
   {{0x999ae014,0xc2cd700d,0x00000000,0x00000000}},	//   _súa__primeira_, _pre__mňa_, --, --,
   {{0xd2d85031,0xfdacc005,0xebfae00c,0x00000000}},	//   _yile_, _позоришт, _स्वास्थ्_के_, --,
   {{0x82efd036,0x7a67800d,0x2210b011,0x52fd102c}},	//   _miliona_, _štátu_, _ukuthi__lesi_, _ácidos_,
   {{0x730b3005,0xbe88102d,0x8376c005,0x2213e03d}},	//   _према__попису_, _कलकत्ता_, _простор_, _bethi_,
   {{0x72ea8010,0xbeda8010,0x00000000,0x00000000}},	//   _de__tarjeta_, _de__tarjetas_, --, --,
   {{0x03207015,0x02bfb00b,0x00000000,0x00000000}},	// [870] _ianya_, _ེལ__ཡོད_, --, --,
   {{0x34a6f021,0x8d604005,0x20891005,0x00000000}},	//   _ut__på_, _је__завршио_, _речима_, --,
   {{0xf2ef0003,0xc48e6014,0x99be1006,0x024e500e}},	//   _ukuba__ufuna_, _da__en_, _penderit, _རེག_,
   {{0x1443e02a,0x34c58004,0xf2fce006,0x44692005}},	//   _amt_, _trabalho_, _sangat_, _počeo__da_,
   {{0x9248d004,0x8bbda00b,0x64c24010,0x7b07d005}},	//   _quem_, _ལུ__ཕན_, _producto_de_, _патријар,
   {{0x6201901c,0xc344c016,0x539b000f,0x4f89c007}},	//   _musik_, _inzerce_, _abantu__benshi_, _svátek_,
   {{0x7c17d011,0x2301f023,0x6263d031,0x5fb4f028}},	//   _kulezi__zinsuku_, _masyarak_anda_, _sokubhal, _de__comandos_,
   {{0x04868002,0xe3b6000f,0x46916014,0xc4b7b010}},	//   _बिहारी_, _akavuga_, _enxeñeir, _marketin_en_,
   {{0x0272f015,0x2ac14040,0xd494000d,0x2e12100f}},	//   _tahun__beliau_, _lepší_, _sa__ako_, _rusesaba,
   {{0x6bdfc014,0x7443e010,0xf6d8b006,0x4b19601c}},	//   _tamén__ligazóns_, _gmt_, _mahasisw, _keuangan_,
   {{0x92242021,0x258ec01b,0xa291a010,0xa4be502a}},	//   _rekke_, _isatifik, _ropa_, _hvis__vi_,
   {{0xc4aa6021,0xe347c038,0x1e28e005,0x12dd0022}},	//   _del__av_, _handlar_, _ја_, _de__esta_,
   {{0xc841502b,0xf212702c,0x00000000,0x00000000}},	//   _ལོ__བརྒྱ_, _cunha_, --, --,
   {{0x0495e02f,0x2eea6005,0x52f33007,0x86529003}},	//   _potrebuj, _ако__је_, _přidej_, _nophuhli,
   {{0x937c2003,0xe2b3100f,0xf479700d,0xe346500c}},	//   _ngaba__uyazi_, _uwo__mwanya_, _keby__ste_, _में__काफी_,
   {{0xe45e8011,0xe45e9010,0x4ff0a010,0x00000000}},	//   _ukubona__ukuthi_, _también__es_, _el__interior_, --,
   {{0x57b5f030,0x00000000,0x00000000,0x00000000}},	// [880] _arkeolog, --, --, --,
   {{0x7a3d300c,0xc9f3402f,0x9ef9f02f,0x50b5b005}},	//   _हुआ_, _prostred, _košický_, _на__године_,
   {{0xa442d021,0x4c802005,0x39d02005,0x00000000}},	//   _ble_, _мене_, _мени_, --,
   {{0xa24d600a,0xa2b0100b,0x98c35005,0x425ad014}},	//   _निकलल_, _ོད__དོན_, _делу__централн, _fillos_,
   {{0xaf669030,0xc442d007,0x647fc021,0xa98b8035}},	//   _kampanje_, _dle_, _programv_for_, _emakhaya_,
   {{0x920ee007,0xd442d004,0x2ee86005,0xc548601d}},	//   _při_, _ele_, _где__је_, _uništite_,
   {{0x42126004,0xfedb6005,0x428c0005,0x3bb5d00d}},	//   _julho_, _не__би_, _након__тога_, _štúdium_,
   {{0x8606b04a,0x7ebbc005,0xb21c600d,0x92b0200e}},	//   _sammenli, _како__се_, _druhej_, _བླ__བྲང_,
   {{0x0bb6900c,0x00000000,0x00000000,0x00000000}},	//   _समस्या__है_, --, --, --,
   {{0x12a4100e,0x82d87022,0x9bf2200e,0x72499028}},	//   _ཚེས__ཉིན_, _cine_, _གལ__ཏེ_, _misma_,
   {{0xcc4ee00a,0x7ba3c00e,0xf2f6a00f,0x12dfa010}},	//   _करीं_, _ཡུལ__དུ_, _afite__imyaka_, _la__hora_,
   {{0x44717014,0x42fb0008,0xaa3e7002,0x4a3dc01e}},	//   _que__lle_, _gushika_, _मीट_, _तुम_,
   {{0x0ec9500c,0x00000000,0x00000000,0x00000000}},	//   _से__कार्य_, --, --, --,
   {{0x5201b01c,0xd2fcc030,0x87cb6014,0x84215004}},	//   _divisi_, _valgte_, _castelán_, _você__ficará_,
   {{0x81ed400a,0x1274e00e,0x4303d023,0xc98e2011}},	//   _दोसरा_, _ལོ__བཅུ_, _sejagat_, _indebe__yomhlaba_,
   {{0x2a878034,0xc273000b,0x00000000,0x00000000}},	//   _ortodoks, _ཕབ__འབད_, --, --,
   {{0xd298202b,0x36529003,0xdef7c004,0x64b14010}},	// [890] _ཀྱི__བཅའ_, _yophuhli, _de__controle_, _conscien_de_,
   {{0xb3f71003,0x6b69f014,0xe23d9011,0x3265200b}},	//   _oluthe__kratya_, _ligazóns_, _indodaka_yakhe_, _ཟེར__སླབ_,
   {{0x7dc2b009,0x12dfa014,0xd4bc000d,0xc77d400b}},	//   _kebijaka, _na__zona_, _viac__ako_, _གཏན__མཛོད_,
   {{0x9300f01c,0x7291c038,0x2281e005,0x9a3d300c}},	//   _lihat__pula_, _lova_, _metara__maksimal, _हुई_,
   {{0xe3eba026,0x8c6f9037,0xeb8f000b,0x3a16c005}},	//   _lopte_, _imirimo_, _ོམ_, _saradnja_,
   {{0xe4a3602a,0x9291c004,0x6727500c,0xc287e004}},	//   _når__du_, _nova_, _लिए__बहुत_, _ele__não_,
   {{0x0a3d300c,0xadde7005,0x258d800f,0xb48df00d}},	//   _हुए_, _да__су_, _bashobor_gukoresh, _aj__pre_,
   {{0xd2132010,0xfebce013,0x02fa1003,0xa628800b}},	//   _muchas_, _verovatn, _machiza_, _ཆོགཔ_,
   {{0xf48e8014,0xe466f021,0x52b16002,0xb2f37027}},	//   _ao__ano_, _deg__til_, _कुकुर_, _peminat_,
   {{0x42ca5029,0x0cca9009,0xf278501d,0x00000000}},	//   _kilde_, _untuk__pertama_, _vrtnja_, --,
   {{0x52127004,0xf48df02a,0x337b9007,0x80a01004}},	//   _junho_, _de__tre_, _skladem_, _eleições_,
   {{0xb3869038,0x351cb01f,0xe46f4011,0x00000000}},	//   _byar_, _bakoresh, _ukuthola__ukuthi_, --,
   {{0x7e72e005,0x2a3ef00a,0x646f3004,0x00000000}},	//   _се_, _परल_, _cadeiras__de_, --,
   {{0xda3e200a,0xc40c0007,0x64adf00d,0xbc55c005}},	//   _नीक_, _aktuálně_, _či__už_, _чланка_,
   {{0x27ba403a,0x02a4801d,0x62d3700e,0x3e756005}},	//   _gukuriki, _crte__iznosi_, _དགའ__ལྡན_, _википеди_на_,
   {{0xd36a7009,0xd3ebe021,0xa1f7900d,0xe45e5011}},	//   _bahasa__inggris_, _motta_, _najlepši, _akungaba_ukuthi_,
   {{0x3275b011,0x668e8011,0xe2e92014,0x14b3100d}},	// [8a0] _abantu__abaningi_, _jazz__festival_, _mariña_, _akými__sú_,
   {{0xb2261005,0xd3c1c00d,0x27d08004,0x00000000}},	//   _avgusta__godine_, _osobné_, _não__consegui, --,
   {{0x32620024,0xacc5f00e,0x00000000,0x00000000}},	//   _འབྱོར__གོང_, _ནི__སྐུལ_, --, --,
   {{0x898a900d,0x5eb68005,0x22502005,0x43702011}},	//   _tlač_, _је__око_, _нема_, _amadoda__amabili_,
   {{0xaac7f007,0x6465d014,0xbb672005,0xb491e004}},	//   _kteří_, _banda__de_, _насеље_, _em__um_,
   {{0x3c4ee00c,0x3b76e009,0xebcf7004,0x00000000}},	//   _करें_, _istrinya_, _seu__dinheiro_, --,
   {{0xc3f9101d,0xc2c32015,0xd2e37011,0x4298000d}},	//   _guzu_, _hanya__perlu_, _le__ntokazi_, _vďaka_,
   {{0xc47a5014,0x5200b010,0x2b90a017,0x00000000}},	//   _nado__en_, _hacia_, _invasión_, --,
   {{0x525b101c,0xac1fc00c,0x23f83023,0xedd94005}},	//   _publik_, _आप__इसे_, _tajuk_, _funkcije_,
   {{0xb4ba9009,0xc3274011,0xd4392021,0x52efc006}},	//   _yaitu__dan_, _uma__kukhona_, _er__blitt_, _aslinya_,
   {{0xc200c00f,0x875cf00c,0xf822700d,0x62cf800d}},	//   _indi_, _पर__अपना_, _prehráva, _obdobie_,
   {{0x9236f026,0xf2d75007,0x946f5011,0x2c58300c}},	//   _uvijek_, _třeba_, _lwe__anc_, _महसूस__करते_,
   {{0x5f18a004,0xbefd3005,0x00000000,0x00000000}},	//   _de__multimíd, _јавља_, --, --,
   {{0xd552f005,0xdf2d6019,0x1c160020,0xebfa800b}},	//   _становни_просјечн, _através_, _སྐབས__སུ_, _མི__གི_,
   {{0x02fcf021,0xd27ef038,0x9a272023,0xa65e402b}},	//   _legge_, _meiner_, _sumbanga_daripada_, _ཞིབ__དཔྱད_,
   {{0x93090004,0xccc9c005,0x00000000,0x00000000}},	//   _mais__alta_, _многим_, --, --,
   {{0xb497e021,0xd6dee00c,0xb2dfc010,0x00000000}},	// [8b0] _si__at_, _की__कोशिश_, _la__copa_, --,
   {{0xbeed0004,0xd4590004,0x00000000,0x00000000}},	//   _mulheres_, _informaç_que_, --, --,
   {{0x4a4bb037,0xfc6d1004,0xa4e43005,0xd2301011}},	//   _perezida_, _relatóri, _регистро_житеља_, _ucingo__lwakhe_,
   {{0x9889d00d,0x6d1f9017,0x00000000,0x00000000}},	//   _darčeky_, _síntese_, --, --,
   {{0xf2efd02c,0x2321e016,0xb491f00d,0x9f1c700c}},	//   _galicia_, _boty_, _by__sme_, _अपना__लिंक_,
   {{0x7b99c00e,0x7671000b,0xce821004,0x47606004}},	//   _དོན__དུ_, _འབད__ཡོདཔ_, _imóvel_, _de__seguranç,
   {{0xa328102a,0x14b7d014,0xcad2700e,0x82ed400d}},	//   _er__ingen_, _tamén__foi_, _ཕྱུགས_, _mesiace_,
   {{0xd47ea014,0xf3f7b011,0xa25fb00e,0xfbd9900e}},	//   _senón__que_, _enorth__west_, _ཁང__ཞིག_, _མེད__དང_,
   {{0xd496f014,0x14b0a014,0x7bd9c00e,0xe2583011}},	//   _xa__que_, _non__son_, _བོད__དུ_, _ingane__yakhe_,
   {{0x23280021,0xeb8e801e,0xb2d8b01d,0xfd88a00b}},	//   _en__liten_, _वे_, _lice_, _ཉོགས_,
   {{0x1bdf800f,0xa3564010,0x0ec4400f,0x82518003}},	//   _ruhenger, _hoteles_, _munyarwa, _kwaye__ngoku_,
   {{0x78d0100c,0xebbf600b,0x623f2011,0x00000000}},	//   _बच्चों_, _གནང__ཡི_, _uthe__lezi_, --,
   {{0xdc282022,0xa480500a,0x00000000,0x00000000}},	//   _sociedad_, _बुझाइल_, --, --,
   {{0x92724021,0x833de010,0x00000000,0x00000000}},	//   _en__rekke_, _la__familia_, --, --,
   {{0x12d8b02e,0xd29a900e,0x34943021,0xd7a46005}},	//   _bice_, _བོད__སྐད_, _på__hva_, _независн,
   {{0x6eee4004,0xa586101c,0x5467b011,0xdcf47007}},	//   _milhões_, _diproduk, _big__nuz_, _úřad_,
   {{0x92d8300f,0xcb03d005,0xb4698004,0xcf248010}},	// [8c0] _kamena_, _можете_, _prefeito_, _de__californ,
   {{0x83bc2006,0xb293300b,0x1bb1f00e,0x247f9021}},	//   _terdiri__atas_, _བཅའ__ིམས_, _ཕྱོགས__སུ_, _nettsted_og_,
   {{0x8d2d7021,0xb496e011,0x030f7021,0xc29b800e}},	//   _jumpstar, _ngalesi__sigameko_, _kan__tilby_, _གྲོལ__ཐོབ_,
   {{0x248da02a,0x19f43014,0x00000000,0x00000000}},	//   _de__kan_, _irmán_, --, --,
   {{0x929b400d,0x071e1011,0x6bbae00b,0x8be3902b}},	//   _izbový_, _yeminyak_emithath, _དེ__ཁར_, _པའི__ཁས_,
   {{0x7c619003,0x34b7702a,0xdc72e020,0x02926023}},	//   _hierdie_, _det__på_, _བཞིའི_, _purata_,
   {{0x3bb7a00f,0xa29fb020,0xa3065010,0x0a45500c}},	//   _urukundo_, _གང__ཞིག_, _los__colores_, _रात__में_,
   {{0xf201b003,0x511ab026,0x54575007,0x868a800b}},	//   _baviwa_, _zauvijek_, _nachází__se_, _རྦོབ_,
   {{0xb145600d,0xc9b02011,0xa72e700c,0xd5bb1010}},	//   _špeciali, _yendebe__yomhlaba_, _इसका__अर्थ_, _de__servicio_,
   {{0x2eb3f005,0xa2d98016,0xb3a2d02c,0xce0be005}},	//   _која__је_, _firem_, _tropas_, _ослобође,
   {{0x7c16200e,0xf373c00d,0x02ca2007,0x43ea200d}},	//   _སྐབས__རང_, _žiadne_, _nikdo_, _nikto_,
   {{0x83b06003,0xadef600f,0x5b5b400b,0x1ee32005}},	//   _rhoqo_, _igihe__kirekire_, _ལུ__རྫོང_, _оне_,
   {{0xfc922005,0x648dd010,0x00000000,0x00000000}},	//   _овде_, _sillas__de_, --, --,
   {{0xff27101d,0xb253b036,0x22d8b016,0xdf706003}},	//   _isprinta, _iz__knjige_, _sice_, _ukuqwala,
   {{0x14420004,0xd386e004,0x2e2dc005,0x00000000}},	//   _foi_, _bairro_, _броја_, --,
   {{0xb4444004,0x1bb0a00c,0x12e31007,0xd25ee018}},	//   _em_, _यह__एक_, _policie_, _ཁོར__ཡུག_,
   {{0x52d9e03b,0x4db09005,0x88199014,0x829d500e}},	// [8d0] _ofte_, _око__планете_, _en__castelán_, _སྲིད__དབང_,
   {{0x92364005,0x2212b010,0xe4695003,0x96ea1003}},	//   _poslednj_godina_, _mucho_, _kutheni__le_, _amaqumrh,
   {{0x763b300f,0xc3c7f014,0x00000000,0x00000000}},	//   _mpuzamah, _en__españa_, --, --,
   {{0xc469e005,0x0f097021,0xc947f005,0x5cafb010}},	//   _gde__je_, _du__gjøre_, _средњој_, _de__octubre_,
   {{0x23495011,0xebba1010,0xa2c16011,0x00000000}},	//   _ngendlel_efanele_, _la__historia_, _ngalolu__hlelo_, --,
   {{0x82c6b029,0xd2c90023,0xf4bad021,0x4310b011}},	//   _kategori_, _wikipedi_telah_, _finn__ut_, _kukaizer__chiefs_,
   {{0xbd76a007,0xd3948005,0x479ba010,0x00000000}},	//   _umění_, _teksta_, _las__compañía, --,
   {{0xc478a010,0x00000000,0x00000000,0x00000000}},	//   _encontra_la_, --, --, --,
   {{0x13eb9010,0xe489d021,0x13170015,0x64bab022}},	//   _costa_, _finner__du_, _ijazah_, _experien_de_,
   {{0x8b6b5029,0x9347a033,0xff6ca004,0x3feb900f}},	//   _annonser, _til__dine_, _detalhes_, _zinyuran,
   {{0x6420e00b,0x9bef400c,0xa2d83028,0x7290e00f}},	//   _བརྒྱའི__རྒྱལ_, _करें__कि_, _colores_, _runaka_,
   {{0xbf7ad020,0x64b0a02a,0x6468a028,0xf46ec007}},	//   _འབྲུ_, _tid__for_, _paquete__de_, _tak__jak_,
   {{0xb290f034,0x7475d003,0x544f5007,0x96e1d00c}},	//   _inga_, _kuthi__ga_, _ať_, _पर__ध्यान_,
   {{0x44b08007,0xe2fba005,0x977b700c,0x00000000}},	//   _můžete_, _samom__gradu_, _लिए__क्या_, --,
   {{0x534ad012,0xe2c78004,0x12d91003,0xe5f3b011}},	//   _godine__naselje_, _rádio_, _kubemi_, _bakulesi__sifundaz,
   {{0xd467f014,0xce39101c,0x9f5db015,0x0f2a7021}},	//   _coa__que_, _kapasita, _pelancon, _vil__gjøre_,
   {{0x23eba026,0x942fc011,0x12fc6036,0x7cae9010}},	// [8e0] _lopti_, _ngesizin_edlule_, _uloge_, _la__segunda_,
   {{0xb4444004,0x2a27d005,0x1c241013,0xe2d8b014}},	//   _um_, _може__бити_, _manastir, _naceu_,
   {{0xff8bf004,0xc386d010,0x12bfb00f,0x621d200b}},	//   _além_, _ayer_, _no__kubona_, _དེ__བཟུམ_,
   {{0x34b85011,0x0577700d,0x36f8a01a,0xd78ac00b}},	//   _kusho__lo_, _autobazá, _होना_, _གསལ__བཀོད_,
   {{0xf994001d,0x64b9c021,0xabe5d00c,0x00000000}},	//   _uopće_, _tilgjeng_for_, _प्रदान__की_, --,
   {{0x5200f021,0xebe0d015,0x00000000,0x00000000}},	//   _angi_, _ketenter, --, --,
   {{0x343b002a,0xb2580028,0x6bab7007,0x44247011}},	//   _er__dette_, _un__sitio_, _další__informac, _lombango__wobuholi_,
   {{0xde5d700d,0xc3282021,0x1135d007,0x4bca000b}},	//   _nehnuteľ, _et__annet_, _zájezdy_, _བདག__ོང_,
   {{0x1b9e200c,0xb2127014,0x5200c005,0xe2d8c014}},	//   _के__एक_, _nunha_, _koliko_, _galega_,
   {{0x5469e005,0xe3357004,0x00000000,0x00000000}},	//   _gde__se_, _você__sabe_, --, --,
   {{0xb4422003,0xfa4e400c,0xb290701d,0x5e952036}},	//   _ook_, _के__पास_, _crna_, _formiran,
   {{0xe27e7011,0xebbb000b,0x898d4005,0x2f2ad005}},	//   _indodana__yakhe_, _དེ__གི_, _популарн, _ваздухоп,
   {{0xf4938003,0x2212f004,0xe822000e,0xb3430004}},	//   _yeyona__nto_, _ganhar_, _མཁྲིས_, _deste__site_,
   {{0xb2e85005,0x83d12021,0x00000000,0x00000000}},	//   _poslednj, _de__blir_, --, --,
   {{0x9f8bf007,0x2c75b007,0xa303b007,0x55ca5011}},	//   _své_, _hlavní_, _opravdu_, _ngesinye__isikhath,
   {{0x93019031,0x6bf7300e,0x2ec44005,0xdd6d0005}},	//   _ndebele_, _རབ__ཏུ_, _којој__је_, _стр_,
   {{0x824cf011,0xe3be2019,0x1ace400d,0x6451d010}},	// [8f0] _kwenzeka__lokhu_, _dos__mais_, _vo__výške_, _muchos__de_,
   {{0x639ba003,0xc4aa000d,0x4cde300d,0xfbbd202b}},	//   _inkxaso_, _prísluše, _kúpiť_, _ལི__པར_,
   {{0x37ab4005,0x5bacd005,0xa25b7015,0x7bd9c00e}},	//   _износи__астероид, _registro_žitelja_, _amalan_, _མེད__དུ_,
   {{0xeef0c008,0x8bc0c00c,0x3325c011,0x8b9cf00d}},	//   _amakomin, _करने__का_, _nje__kuphela_, _jedného_,
   {{0xa291000f,0x12d91004,0xd46a202a,0x8248d00d}},	//   _kubaka_, _dizer_, _fra__den_, _viem_,
   {{0x02127014,0x13f82009,0x13271011,0x52647013}},	//   _dunha_, _uskup_, _ukuthi__ngubani_, _mislim_,
   {{0x82ff3014,0x9e61f00d,0xd595c007,0x048ff010}},	//   _ser__unha_, _osôb_, _vzhledem_, _el__sol_,
   {{0xf33df014,0x7f9a2011,0x00000000,0x00000000}},	//   _en__galicia_, _icala__lokubula, --, --,
   {{0xf3e7800d,0xe0596014,0x5a6b8011,0xda6c8005}},	//   _dátum_, _colaboro, _njengoba__kwenzeka_, _хоризонт,
   {{0xc4b22021,0x02976005,0xd2b2e00b,0x26fee00b}},	//   _vil__bli_, _источном__делу_, _ིས__བཅའ_, _ཡུན__བརྟན_,
   {{0x34966021,0x045eb011,0x6e86d004,0x54605010}},	//   _brukes__på_, _ngalolu__suku_, _não__funciona, _sólo__se_,
   {{0x0201a010,0x7bf5100e,0x0f754028,0x0bc5e00c}},	//   _mexico_, _བར__དུ_, _interés_, _व्यक्ति__को_,
   {{0xf9f47007,0xf85d9011,0x00000000,0x00000000}},	//   _nyní_, _nkulunku, --, --,
   {{0xc26c403f,0xebfae00b,0x98f42005,0x64b55010}},	//   _pomoc_, _ོད__གན_, _академиј, _mejor__de_,
   {{0xe461f015,0xa2a63026,0x527f4028,0x12a7800d}},	//   _ialah__untuk_, _vidjeti_, _fuente_, _farby_,
   {{0xd2e6101c,0x1407a026,0x6eb0e00d,0xe2fbe00d}},	//   _pranala_, _na__sjeveru_, _pre__spoločno, _vo__svojich_,
   {{0xec0d900c,0x00000000,0x00000000,0x00000000}},	// [900] _बनाने__के_, --, --, --,
   {{0x34321011,0xc2ef6002,0x0399b004,0x19f66014}},	//   _ngonyaka__odlule_, _जरुर_, _mês_, _porén_,
   {{0x43075005,0x64af8014,0x8292701c,0x43eb9004}},	//   _oko__planete_, _entidade_de_, _desain_, _gosto_,
   {{0x94b8702a,0xc4add021,0x6ecac00d,0x00000000}},	//   _kan__få_, _mange__av_, _webnovin, --,
   {{0x32860003,0xebe7e00c,0xb48c3004,0x00000000}},	//   _ukuza__kuthi_, _जब__वे_, _além__do_, --,
   {{0x7bd5400e,0x03566023,0x72a76011,0x54a11004}},	//   _ཆེད__དུ_, _gabenor_, _baleli__qembu_, _você__se_,
   {{0xc27fe038,0x127f4010,0xedfc402b,0x9df02024}},	//   _vatn_, _siendo_, _མཐུན__འབྲེལ_, _གི__གྲངས_,
   {{0xcbad3018,0xb25a5014,0x225a1031,0xa38c2005}},	//   _དང__པོ_, _fillo_, _mihla_, _руке_,
   {{0xfba8200c,0x7b18b00e,0x2a249010,0xd8d8100c}},	//   _कम__से_, _བཅུ__གཅིག_, _que__esté_, _को__समाप्त_,
   {{0x1496e007,0x02878011,0x62d8f038,0xfbc8200c}},	//   _se__mi_, _ukuthi__umuntu_, _eige_, _में__आसान_,
   {{0x84424030,0x5cc2f016,0xd2e05003,0x6c97600c}},	//   _kom_, _český_, _ekuhlalw_kuyo_, _प्रयोग__करने_,
   {{0x1a44b02a,0xc243f00b,0x5c67900f,0xc1e56015}},	//   _er__også_, _གཏང_, _inkunga_, _anugerah_,
   {{0x52f6900f,0xdb92d00d,0x44fb000d,0x00000000}},	//   _ariko__kandi_, _podnájom_, _na__stránke_, --,
   {{0xe4a7d003,0xe46a7021,0x471c7005,0x7c079005}},	//   _naliphi__na_, _legge__til_, _srednjoj_, _је__само_,
   {{0x122b8010,0x727ff01c,0xec6d8016,0x9cb0c00c}},	//   _siempre_, _ujung_, _zahrada_, _हम__आपको_,
   {{0xe45b8011,0x00000000,0x00000000,0x00000000}},	//   _akazi__ukuthi_, --, --, --,
   {{0x962f7005,0xc4afe021,0x9ff6c00c,0x2df7600e}},	// [910] _demograf, _inn__en_, _की__संभावना_, _མོ__གཉིས_,
   {{0x14902014,0x92a74022,0xe468f021,0x82413011}},	//   _en__foi_, _pueblo_, _grunnen__til_, _futhi__lokhu_,
   {{0xf4424004,0xc273a023,0x9ba0400b,0x00000000}},	//   _bom_, _peribadi_, _དགོ__མི_, --,
   {{0x6c48d00c,0x82de602d,0x9c07900c,0x6292f003}},	//   _होने_, _कुली_, _जैसा__कि_, _kwelinye__icala_,
   {{0xc4af602a,0x7be4b024,0xb83f6010,0x0442301d}},	//   _for__en_, _འདི__ཡང_, _después_, _toj_,
   {{0xed8fb018,0x229e4026,0xe394d01b,0xd29ac007}},	//   _མཛེས_, _vidjela_, _kwesi_, _děkuji_,
   {{0x34424003,0xf413e003,0xcc612015,0x7640400b}},	//   _fom_, _oyintlok, _taburan_, _བྱུང__ཡོདཔ_,
   {{0x8300a009,0x1a65b02a,0x1dba6005,0x00000000}},	//   _tidak__bisa_, _vil__også_, _почетком_, --,
   {{0x504a8005,0xca9ce00f,0x1201c019,0xb4599004}},	//   _познато__природно_, _ishyamba_, _ouvir_, _está__em_,
   {{0xeeb91005,0x2e97f005,0x7e76f007,0x8da7402c}},	//   _био_, _којима__је_, _klikněte_, _salienta,
   {{0x6d50702d,0x821cb007,0x0859e023,0x0a45500c}},	//   _मुंगेर_, _během_, _selangor_, _बाद__में_,
   {{0xc405300e,0x72d91031,0x01e8900c,0x00000000}},	//   _སྡུག__བསྔལ_, _lize_, _के__भीतर_, --,
   {{0x1bd97056,0x82700003,0xc329702a,0x451e8013}},	//   _आपूर्ति_, _ga__ngoku_, _og__eller_, _prirodno_,
   {{0x02763011,0xc4bdf00c,0x00000000,0x00000000}},	//   _chofoza__lapha_, _नोएडा_, --, --,
   {{0x03019015,0xd439702a,0x2c0dd00b,0xd2af6010}},	//   _lihat__juga_, _er__helt_, _ཕོག__ལམ_, _del__tiempo_,
   {{0x62b9c007,0x32ca9015,0xf2cbf011,0xc47a7010}},	//   _víc_, _tiada_, _baleli__bandla_, _convirti_en_,
   {{0xc0f46005,0x437ae010,0xb444d004,0x024d100b}},	// [920] _године__режирао_, _este__momento_, _apenas__um_, _ོའི_,
   {{0x89992007,0x930d102a,0xbbe11005,0xe48db028}},	//   _když_, _dine__egne_, _ово__насеље_, _de__esa_,
   {{0xb2916037,0xe3eb8038,0x228d9003,0xba0e0004}},	//   _kigali_, _vert_, _izikolo_, _paraíba_,
   {{0xa2d85038,0xb290c036,0xa4a3502a,0x44369010}},	//   _valet_, _nalazi_, _når__vi_, _de__cuatro_,
   {{0xf442500d,0xe4892013,0xb2019004,0xabd2c00b}},	//   _bol_, _ograniče_na_, _assim_, _འབད__དེ_,
   {{0x82d85038,0x0ccad020,0xd73ad00e,0xf7bc1013}},	//   _talet_, _འབོར_, _འབོད_, _kragujev,
   {{0xf443e038,0x23430010,0x64ac9003,0xb297b007}},	//   _åt_, _acuerdo_, _zombini__ezi_, _se__nám_,
   {{0x895eb010,0x228af009,0xebfaa00c,0xb4c27011}},	//   _cualquie, _praktik_, _देने__के_, _african__national_,
   {{0x7b95700b,0x64abd004,0x00000000,0x00000000}},	//   _ཅིན__ཁང_, _soluções__de_, --, --,
   {{0xc478d014,0x9b19d018,0xac1b9015,0x6d145024}},	//   _nada__en_, _ཞིབ__འཇུག_, _dilancar, _མཐའ__འཁོར_,
   {{0xba3c400c,0x7bfae00e,0x6201c013,0xf1632005}},	//   _आया_, _པོ__ནི_, _prvih_, _буду_,
   {{0x3212b010,0xeda81005,0x0e292005,0x00000000}},	//   _mucha_, _зато__што_, _сад_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa24a6017,0x67aed024,0x04619028,0x95a2e00c}},	//   _forman_, _དབུ__འཛིན_, _gracias__por_, _चाहता_,
   {{0xd2d8f021,0xb291a023,0xc34b2011,0x634a0014}},	//   _laget_, _lapan_, _zwane__uthe_, _comezou_,
   {{0xe291f038,0x14aa6021,0xde370014,0xcaa6500c}},	//   _artar_, _din__med_, _nalgunha, _में__बात_,
   {{0x3b88000a,0x12dca005,0x32ad5011,0x4a3d400c}},	// [930] _बा_, _raketa__nosač_, _dlamini__zuma_, _रखा_,
   {{0xa442601b,0x2290c034,0x62d85014,0xb50c7014}},	//   _loo_, _orda_, _cales_, _febreiro_,
   {{0xa52bb00f,0xc4550010,0x131a9036,0xe17a9013}},	//   _munyakaz, _producto_, _društvo_, _društva_,
   {{0x53320003,0x00000000,0x00000000,0x00000000}},	//   _isixa_, --, --, --,
   {{0xce66c014,0x5ba0700c,0x6d8fc00e,0xa34f100f}},	//   _habitant_mulleres_, _है__या_, _ཉིད__ཀྱིས_, _nibindi__byinshi_,
   {{0xf24e500e,0x9468a023,0x72712011,0x12709005}},	//   _རེད_, _bagi__tujuan_, _ngalesi__sikhathi_, _од__тада_,
   {{0xd2b5f037,0x8be6500e,0x82bdd011,0x4ef8e005}},	//   _umuco_, _ཞེས__བྱ_, _isithomb_mthobisi_, _министар,
   {{0x4a3ed02d,0x926c2036,0x7b6c7004,0xcc11f00e}},	//   _नरक_, _tokom_, _imprensa_, _ཕུང__པོ_,
   {{0x92903008,0x8a9c6007,0x2ee9d005,0xd4977010}},	//   _kaja_, _způsobem_, _funkcion, _ya__que_,
   {{0x24425004,0x223fa011,0x0a6fc00c,0x00000000}},	//   _uol_, _uthe__lesi_, _साइट__में_, --,
   {{0xa2754005,0xa2e7c014,0x32fc7003,0x64b6700d}},	//   _tabeli__ispod_, _de__súa_, _jonga_, _preto__že_,
   {{0x23f9a01d,0x348cd00d,0x32480004,0xcc02900c}},	//   _rupu_, _ktoré__sa_, _acima_, _जैसे__ही_,
   {{0x2d20900d,0xa48fd00d,0x00000000,0x00000000}},	//   _vyhľadáv, _vytvoriť_, --, --,
   {{0x1290203b,0x9c9ad020,0x87fa9024,0x73b41004}},	//   _saka_, _འབུལ_, _སྲིད__བློན_, _não__possui_,
   {{0x1df0202b,0x9b717003,0xf2e72011,0xe273e00b}},	//   _གི__གྲོས_, _kufumana_, _ngobunin_babo_, _ལུ__གནང_,
   {{0x13274021,0xac590007,0x231a7011,0xfa429007}},	//   _du__liker_, _hlavně_, _lokhu__ngoba_, _je__nyní_,
   {{0x02903008,0xe21df003,0xea28b011,0x646b5010}},	// [940] _baja_, _kubomi__bethu_, _uthe__njengoba_, _precios__de_,
   {{0xeda8d01c,0x125b000d,0x12903010,0xebd6900c}},	//   _aktivita, _ďalej_, _caja_, _प्रयोग__के_,
   {{0x83202016,0x9d0b2036,0xe9aef02a,0x0295700e}},	//   _taky_, _patrijar, _og__tjeneste, _མངའ__རིས_,
   {{0x64c1f01d,0xed738005,0x442c8005,0x7eb92005}},	//   _stanovni_te_, _је__почео_, _је__почела_, _тим_,
   {{0x02fd7004,0x64400024,0x00000000,0x00000000}},	//   _viagem_, _འདི__རྒྱལ_, --, --,
   {{0xc2f38003,0xc4b75010,0x74da3005,0x00000000}},	//   _yakho__okanye_, _clic__en_, _својом_, --,
   {{0x44984011,0xcbd2700e,0x09f4e010,0x6717f005}},	//   _we__ifp_, _བཙན__པོ_, _quién_, _факултет,
   {{0x7daa2009,0x22d80004,0x00000000,0x00000000}},	//   _pariwisa, _grátis__para_, --, --,
   {{0xe464602a,0x130fe01b,0x9c537023,0x03467007}},	//   _før__du_, _nombolo_, _sastera_, _liberec_,
   {{0x14427010,0x64b53004,0x39a0800c,0x645d2005}},	//   _con_, _milhares__de_, _लिए__सर्वोत्त, _учествуј,
   {{0xab7e301b,0x22e7a005,0xe4acd00d,0x5b28900e}},	//   _kufuneka_, _jedino__poznato_, _alebo__na_, _ྋགོང_,
   {{0x4c1d201f,0x83401003,0x22489011,0x00000000}},	//   _intambar, _kucelwa_, _isixhuma_sakho_, --,
   {{0x23a2601c,0xca12c00f,0x52d86011,0x0250300b}},	//   _eropa_, _kuri__enterine, _unkk__zille_, _བལྟ__བཤལ_,
   {{0xbf240026,0x7a56c01d,0x00000000,0x00000000}},	//   _loših_, _small__napomena_, --, --,
   {{0x3dae8013,0x337b4027,0xb2a0e00d,0x00000000}},	//   _enciklop, _dikawal_, _namiesto__toho_, --,
   {{0x72d98021,0x00000000,0x00000000,0x00000000}},	//   _agre_, --, --, --,
   {{0x52327010,0x72f0501b,0x00000000,0x00000000}},	// [950] _ejemplo_, _naliphi_, --, --,
   {{0x82750024,0x947d9011,0x529c802b,0x00000000}},	//   _ལོ__ཐོག_, _ngonyaka__we_, _གིས__ཉེན_, --,
   {{0xc49db005,0xc560a005,0x59cba003,0xfc07f004}},	//   _opštini__je_, _živjelo_, _emalunga_, _vários_,
   {{0xc4712014,0xaa641014,0x00000000,0x00000000}},	//   _que__non_, _non__está_, --, --,
   {{0x12cc5011,0xadf89005,0xa3ceb005,0xf300b019}},	//   _kulo__mdlalo_, _становни_су_, _prevod_, _de__busca_,
   {{0x224e6024,0x9bbd800b,0x16bd900d,0x7f1bf014}},	//   _ལེན_, _ལུ__མི_, _prístup_, _xoán_,
   {{0xd494202a,0xd2360026,0x64c63028,0x64723010}},	//   _på__den_, _smije_, _usuarios__de_, _derechos__de_,
   {{0x62b4c003,0xd4adc004,0xcf53400c,0x3451500d}},	//   _emdc_, _serviço_, _जाएगा_, _pokiaľ__sa_,
   {{0x03fbe02a,0xf21f9004,0xa98ec005,0x503c600c}},	//   _den__nyeste_, _soluções_, _назив_, _दोपहर_,
   {{0x92e9501c,0x7e658014,0x77c8c00d,0x527f4029}},	//   _artinya_, _cando__tiña_, _poisteni, _ordnet_,
   {{0x94429004,0x82214011,0x62011036,0xa2004011}},	//   _boa_, _ukuthi__lokhu_, _srbiji_, _yami_,
   {{0x9200500f,0x393b4034,0x00000000,0x00000000}},	//   _hali_, _framtida_, --, --,
   {{0x8a3e7002,0x34acd00d,0xc9091005,0x00000000}},	//   _बडा_, _alebo__sa_, _песама_, --,
   {{0x0c742011,0x727ee038,0xc29fd00d,0xdba8800e}},	//   _ngenxa__yokuthi_, _hennar_, _mňa_, _ཁྲིམས__ཐག_,
   {{0xc290500d,0x72f39005,0x8225f011,0xf2aa400e}},	//   _mala_, _попису_, _ukhale__ngokuthi_, _གང__རུང_,
   {{0xd4687014,0x940f8011,0x00000000,0x00000000}},	//   _ata__que_, _igama__elithi_, --, --,
   {{0x22d8e010,0x5ecf1017,0xb47c5007,0x00000000}},	// [960] _quiero_, _destruíd, _bylo__to_, --,
   {{0x3935f00c,0x0c0a000b,0x00000000,0x00000000}},	//   _अपनी__साइट_, _ཁོང__ལུ_, --, --,
   {{0x72926008,0x6a3e700a,0x3c5bc00f,0x00000000}},	//   _buraya_, _बड़_, _bakunze_, --,
   {{0xb301f023,0x02b0800b,0x00000000,0x00000000}},	//   _ditubuhk_pada_, _མི__གིས_, --, --,
   {{0x2ed55005,0x04906021,0x34b9500d,0x47d23010}},	//   _па__је_, _en__som_, _potom__sa_, _de__préstamo,
   {{0x329fd00d,0x82004011,0x19b3a026,0x6f0b100c}},	//   _dňa_, _wami_, _spomenic_znamenit, _है__जिसका_,
   {{0xfef48014,0x39c44014,0x02029013,0xb2588010}},	//   _un__saúdo_, _atópase_, _pozorišt, _su__sitio_,
   {{0x673bc00c,0xfdce7005,0x00000000,0x00000000}},	//   _में__स्थित_, _биће_, --, --,
   {{0xc4b3d011,0x52905004,0xc4885007,0xe46ee010}},	//   _wokhozi__fm_, _fala_, _která__je_, _eso__es_,
   {{0xc0beb005,0x18c7200f,0x3d081004,0x9d91502b}},	//   _живи__пунолетн, _umuturag, _distânci, _ཉིན__གྲངས_,
   {{0x54c15011,0x93bea011,0x89acd010,0xcb5f800c}},	//   _kuya__ku_, _ithe__star_, _en__cualquie, _ईरान_,
   {{0x42e2f013,0x75c63014,0xd292800e,0xd200c023}},	//   _od__metara_, _de__santiago_, _མིང__སྟེ_, _bilion_,
   {{0xd442900f,0x00000000,0x00000000,0x00000000}},	//   _voa_, --, --, --,
   {{0xd2cc7011,0x7290000b,0xc2da5027,0xd4a6e013}},	//   _wakwazul_natal_, _ཐིམ__ཕུག_, _isteri_, _fudbalsk,
   {{0x5adca020,0x827ed031,0x252d0017,0x92eec011}},	//   _འཛུགས_, _nkonzo_, _composto_, _njengoba__abanye_,
   {{0x64206011,0x8ac8200e,0x897f6011,0x0bab800c}},	//   _kwesimo__sezulu_, _ཀློག_, _umphakat, _का__है_,
   {{0x04b16021,0xa6f8b01a,0x00000000,0x00000000}},	// [970] _til__som_, _सोया_, --, --,
   {{0x73ebe034,0xdc498002,0xd2a60003,0x7a62800c}},	//   _nett_, _पढ़े_, _imiba_, _नहीं__हैं_,
   {{0xc48f602c,0xb650500d,0x95e0d00d,0x2ec27005}},	//   _de__en_, _ďakujeme_, _literatú, _данас__је_,
   {{0x02d99029,0xf4c2a021,0x826c1004,0xabf8b00e}},	//   _vises_, _virksomh_din_, _olhos_, _ཤུ__རྩ_,
   {{0x2d7c9005,0x6388f011,0x8bdeb00b,0x1587f005}},	//   _не__може_, _irvin__khoza_, _རིམ__གས_, _насељу_,
   {{0x7321c008,0xf068f007,0x84193004,0x00000000}},	//   _navyo_, _ve__skutečno, _uma__lista_, --,
   {{0xebddc00c,0x00000000,0x00000000,0x00000000}},	//   _बनाया_, --, --, --,
   {{0xf27e3038,0x4264000d,0xacb5200c,0x2c9fe00c}},	//   _namnet_, _úplne_, _कभी__नहीं_, _के__उपयोग_,
   {{0x5442b040,0x62ca7032,0xb249a005,0x8dbcf00b}},	//   _moc_, _ainda_, _južnoj__godine_, _བརྒྱུད__རིངས_,
   {{0x37cd100e,0xabd26014,0x9ff32005,0xd39cd004}},	//   _དེ__བཞིན_, _súa__carreira_, _демограф, _informaç_sobre_,
   {{0x526c1009,0xd2caf023,0x0bf5500b,0x8261c003}},	//   _pohon_, _oleh__kerana_, _མི__ལུ_, _kwaye__ufumane_,
   {{0x4c77601c,0x00e1300a,0x7b0b004b,0xa2d8c011}},	//   _populer_, _पंडीजी_, _eksperte, _malema_,
   {{0x3ea5f012,0x2e7cd005,0xd798200e,0xa31a700d}},	//   _djelovan, _рођен__је_, _གནོན_, _na__predaj_,
   {{0x42129007,0xc72d301d,0x0c06e00d,0xd6ac800f}},	//   _praha_, _lopticom_, _potreby_, _bangambi,
   {{0xe27c8011,0xc4ba5028,0x2ea36005,0x54885007}},	//   _kakhulu__futhi_, _como__la_, _насељено__ма_, _která__se_,
   {{0x22b4901f,0xb442a004,0x5a6f300c,0x726f1011}},	//   _iwacu_, _sob_, _करते__समय_, _eziningi_,
   {{0xce14a00d,0xdba32024,0x1eefa007,0xace4f00e}},	// [980] _zamestna, _དགོངས__ཞུ_, _základní, _བཙན__བྱོལ_,
   {{0xc260d003,0x90dd601b,0x928e1011,0x00be7005}},	//   _isetyhul, _ebonelel, _kodwa__konke_, _личности_,
   {{0xf2d99030,0x3d08a00b,0xb3ebe038,0x4a06c030}},	//   _viser_, _ཚུ__འཚོལ_, _rett_, _kataloge,
   {{0xc3ebe03b,0x2ee3e005,0x7ab3d00c,0x59f4b007}},	//   _sett_, _општини__је_, _जानते__हैं_, _akcí_,
   {{0xc48f6022,0x9b58000a,0xf26c0004,0xe3eba012}},	//   _de__un_, _लोगन_, _meio_, _loptu_,
   {{0x2eb4b005,0x1478c00d,0x9ce8c00e,0x3d5a2005}},	//   _који__је_, _nie__sú_, _སློབ__གཉེར_, _рођен_,
   {{0xf14a8005,0x5291800d,0x00000000,0x00000000}},	//   _је__откривен_, _úrad_, --, --,
   {{0xd454501d,0x8b8d600a,0x73b61013,0x0b28200e}},	//   _iznosi__st_, _कऽ_, _pravila_, _ཀླུང_,
   {{0x52d8b010,0x727fa011,0x61beb00a,0xe2e9e004}},	//   _hacer_, _izinto__eziningi_, _जुडल_, _caminho_,
   {{0x8d93600e,0x52bf3004,0x00000000,0x00000000}},	//   _ཉོན__མོངས_, _uma__casa_, --, --,
   {{0xf2926028,0x9bf3200b,0xbfa7100d,0x00000000}},	//   _verano_, _གས__ཏེ_, _bolo__možné_, --,
   {{0x7b4e602f,0xe3488026,0x3c627031,0xfcc5b010}},	//   _slovakia_, _leteći_, _emfundo_, _su__empresa_,
   {{0x4442c01d,0xe48e6014,0x2107a003,0x1490a014}},	//   _kod_, _da__na_, _ngokumal, _en__con_,
   {{0x5c64e00c,0x32d8b014,0xeb20d00c,0x00000000}},	//   _का__सबसे_, _facer_, _लिए__अच्छा_, --,
   {{0xfa468013,0x6c8ec00c,0x2163c005,0xa350d004}},	//   _novembra_, _है__परन्तु_, _пописа_, _os__efeitos_,
   {{0x07c66051,0xc490d022,0x7297b011,0x00000000}},	//   _प्रभावित_, _éxito__en_, _izimoto__zabo_, --,
   {{0x02d9e00c,0x12ae600a,0xb2ce1011,0x2c49e00c}},	// [990] _पूरी_, _कुछु_, _le__nkinga_, _पूरे_,
   {{0x62a0601f,0x448e6014,0xf29a9005,0xe4b7b004}},	//   _ahubwo_, _da__da_, _pre__nego_, _marketin_na_,
   {{0xf3c65005,0x7a32f00a,0xe386d00d,0xec0b200c}},	//   _samom__mjestu_, _ओकर_, _ktorom_, _लाने__के_,
   {{0xf2e67037,0x93fa7021,0x4294e011,0xf79ee005}},	//   _cyangwa_, _seg__selv_, _thabo__mbeki_, _треба_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x73ead00d,0x1bd68018,0xc5aed026,0xd2845011}},	//   _tieto_, _ཡོངས__སུ_, _je__živjelo_, _ohamba__phambili_,
   {{0x4b88702d,0xb2641005,0x62979010,0x53075010}},	//   _भा_, _istočnoj__godine_, _hacer__algo_, _que__hacer_,
   {{0xd468f014,0xeeb0b013,0x437f800f,0xdf39e023}},	//   _hai__que_, _države_, _muhanda_, _dimulaka,
   {{0xf2851011,0xbed5800d,0x2b1fc015,0x91c3303f}},	//   _abantu__abangu_, _veľa_, _kelajuan_, _autorské_,
   {{0x026c100d,0x698c200f,0x00000000,0x00000000}},	//   _neho_, _imihanda_, --, --,
   {{0x4291e034,0x8200701d,0x5851000c,0x00000000}},	//   _satan_, _vani_, _में__जानकारी_, --,
   {{0x927f7003,0xd379e004,0x6b61d00c,0x9241d00a}},	//   _nganye_, _tamanho_, _देखने_, _देखले_,
   {{0x6442d008,0x2eb36005,0xfbdae00e,0xaaea4026}},	//   _moe_, _врсте__је_, _རྣམ__པར_, _izbrisat,
   {{0xc46ae00d,0x3369d005,0x00000000,0x00000000}},	//   _ako__je_, _подацима_, --, --,
   {{0x5499e007,0xf443f003,0x02765023,0x1b9f201a}},	//   _to__se_, _olu_, _pengguna__bagi_, _को__एक_,
   {{0x7442d029,0xa2a8000e,0x7290e036,0x0af61003}},	//   _noe_, _ཚད__མེད_, _oznaka_, _ezizodwa_,
   {{0x9bfa800b,0x0a33700a,0x28bfe010,0xeefd2004}},	// [9a0] _ོད__མི_, _कवन_, _enfermed, _primeiro_socorros_,
   {{0x0271000b,0xe2a3200e,0xb2450003,0x6c774036}},	//   _དེ__གིས_, _བློ__བཟང_, _ikhonkco__lakho_, _srpskog_,
   {{0xebfb800b,0xd87f2028,0x1fcf000d,0xbf2fc015}},	//   _ཚུ__གི_, _buscador_, _obrázok_, _kewujuda,
   {{0x62d9d008,0xd26e1004,0xe2dac003,0xb3e83010}},	//   _ngwe_, _depois_, _khumbula__ukuba_, _es__más_,
   {{0x147d9014,0xc623f010,0x9bab900e,0x287b2005}},	//   _xunto__con_, _conocimi, _འབྱོར__མི_, _страна_,
   {{0x323a600d,0xb3e2500f,0x32c14011,0x02d2a00b}},	//   _môj_, _abantu__bamwe_, _ezingaph_kuka_, _གཅིག__ཨིན_,
   {{0x02499023,0x02020005,0x4862500f,0xa44e4004}},	//   _rasmi_, _visini_, _gusobanu, _graduaçã,
   {{0xd355d004,0x91f53005,0xa1e2600c,0xef1b7005}},	//   _confira_, _имате_, _फरवरी_, _историча,
   {{0x7200a011,0xf8673010,0xbc773010,0xc27ee021}},	//   _kabi_, _mensajes_, _mensaje_, _hennes_,
   {{0xbfe10005,0x52e76010,0x173b900c,0xebf4b00c}},	//   _овој_, _su__vida_, _तैयार__किया_, _मार्केटि_के_,
   {{0xb0a1d005,0x43320017,0xb9ea600d,0x647cd010}},	//   _је__елиптичн, _baixo_, _to__môže_, _plan__de_,
   {{0x62b40010,0x82162004,0xe2a6d01d,0x126c2005}},	//   _clic_, _conhecim, _osobno_, _neko_,
   {{0x225ad01d,0xd3cc9011,0xf2b0600d,0x6ffe7005}},	//   _stolni_, _ku__orlando_, _vedieť_, _trekbeko,
   {{0x0239a005,0x3c73c018,0x12d4500d,0x94b6500f}},	//   _nadmorsk_visini_, _གཞིའི_, _ľudia_, _munsi__ya_,
   {{0x0e73f051,0xc3ead00d,0x2ebb1005,0x72925004}},	//   _बुद्ध_, _siete_, _било__је_, _estava_,
   {{0x326c1015,0x64ab5028,0x1332f00d,0x00000000}},	//   _johor_, _copia__de_, _získať_, --,
   {{0xb475003b,0x63960004,0xe31f8010,0xfc3da00c}},	// [9b0] _kulturen_, _nossas_, _de__verdad_, _खोज__रहे_,
   {{0x3a26301c,0x02dd302a,0xdd87a016,0x0c523014}},	//   _mencakup_, _ganske__enkelt_, _objednat_, _mantén_,
   {{0xcf3fb020,0xaf49f002,0xd249b003,0x12753011}},	//   _ལོ__རྒྱུས_, _मूंग_, _kuba__nakho_, _icala__lakhe_,
   {{0x5863c005,0x365ec005,0x00000000,0x00000000}},	//   _долази_, _филма_, --, --,
   {{0x4cd7b011,0x5c9ae011,0x28ebe014,0x525af022}},	//   _inazaret_baptist_, _mayelana__nokuthi_, _coñecido_, _siglo_,
   {{0xe2c1d015,0xfcd6900f,0x29d5a02c,0x64b1a02a}},	//   _anda__tidak_, _ubukungu_, _cantidad, _kun__for_,
   {{0xe315e004,0xec13100c,0xa2670018,0xb22e000f}},	//   _usuários_, _व्यवसाय__के_, _ཡང__མེད_, _umwanya__munini_,
   {{0x12d8d03c,0x82139011,0x42d9801c,0x7c45700f}},	//   _होती_, _kusho_, _maret_, _guswera_,
   {{0x4225701d,0x4bec4020,0xbd5a0007,0xa348c028}},	//   _opakog_, _རང__ལོ_, _světě_, _de__divisas_,
   {{0x4e94a005,0x0497702a,0xce6ac005,0x00000000}},	//   _удаљенос_од_, _vi__vil_, _можда_, --,
   {{0x8293e00b,0xabb2600b,0x00000000,0x00000000}},	//   _ལེགས__ཤོམ_, _ཁར__ོད_, --, --,
   {{0x92926008,0x424ec02b,0x62afe00b,0x840b900f}},	//   _kuraba_, _ཨེན_, _ོད__དགོ_, _icyaricy_cyose_,
   {{0xfeb8e005,0x12132017,0x68b56019,0x72c0f004}},	//   _ви_, _machos_, _ser__realizad, _que__estava_,
   {{0xb6698013,0xc46ed021,0x9c7d900e,0x82011019}},	//   _živjelo__stanovni, _bruke__en_, _རྗེའི_, _recife_,
   {{0xc290a008,0x64b61003,0xe468702a,0x7babe00e}},	//   _raba_, _zonke__ezi_, _dem__til_, _དག__ནི_,
   {{0x040e900d,0xe2d9200a,0x81dfc02d,0xea140036}},	//   _svoj__život_, _मछरी_, _अरहर_, _podacima_,
   {{0xfaf2200d,0x0edbe004,0xd3c7200d,0x84197004}},	// [9c0] _prihláse, _conteúdo_, _hospodár, _sua__dieta_,
   {{0x2ead7005,0x1290d015,0xf201c004,0x0a8b700c}},	//   _коју__је_, _melayu_, _havia_, _विश्व__में_,
   {{0x026c5010,0x43f9e009,0x9b91f00b,0x726c3010}},	//   _ellos_, _fitur_, _ཞིནམ__ལས_, _dejo_,
   {{0x1290b03a,0xe4a5202a,0x00000000,0x00000000}},	//   _gaca_, _faktisk__er_, --, --,
   {{0xd2efd003,0x8f0ce00e,0xa1632005,0x00000000}},	//   _kunikwa_, _སྦྲུལ_, _којима_, --,
   {{0xb6437005,0xf300d013,0xca1e2005,0x2ac8d007}},	//   _iznosi__stanovni, _ostalih_, _живи_, _na__paměti_,
   {{0x425a5005,0xc442f005,0x9340800a,0x92b0800a}},	//   _iznosila__kilogram, _bog_, _हमहूँ_, _हमहुँ_,
   {{0xe2087012,0xf291f022,0x6257f00b,0x00000000}},	//   _očito_, _estan_, _ཀྲོང__གསར_, --,
   {{0xd4ade035,0x2200800f,0xa472f021,0x497a300d}},	//   _kodwa__ke_, _inkiko_, _som__ble_, _ďalší_,
   {{0xe2911034,0x505d4005,0x00000000,0x00000000}},	//   _debatt_, _западној__године_, --, --,
   {{0x148ea02a,0x00000000,0x00000000,0x00000000}},	//   _de__har_, --, --, --,
   {{0xd0f6900e,0xa1fc100c,0x00000000,0x00000000}},	//   _སེར__སྐྱ_, _का__अवसर_, --, --,
   {{0x6290c005,0xdc287014,0x72011011,0x00000000}},	//   _kada_, _no__primeiro_, _kabili_, --,
   {{0x649da033,0x1383300f,0xef4e2005,0xbe2dc005}},	//   _sørg__for_, _wenyine_, _политичк, _броју_,
   {{0x23f9e01c,0x3e43d005,0x1201f01f,0x326c7009}},	//   _situs_, _односу__на_, _buzima_, _konon_,
   {{0x3201900f,0xf1770005,0xd48ef004,0x2472600c}},	//   _ebyiri_, _шест_, _pessoa__que_, _जानकारी__प्रदान_,
   {{0x83f9c00f,0x43c93007,0xab706028,0x360ac00e}},	// [9d0] _kivu_, _pro__vás_, _recordar, _འཕྲད_,
   {{0x42f1c02d,0x9a6ac004,0x5aaeb00c,0x00000000}},	//   _सबेरे_, _como__você_, _लंबे__समय_, --,
   {{0x0b41f013,0xd3876014,0x5c25c014,0x00000000}},	//   _porodičn, _logrou_, _pasaxeir, --,
   {{0x5c70600a,0x425ad00d,0x00000000,0x00000000}},	//   _लिट्टी_, _biela_, --, --,
   {{0x54599003,0x02829011,0x9c56800a,0x94949021}},	//   _ukuba__umntu_, _kule__ndima_, _जइहें_, _på__deg_,
   {{0xc9715007,0x7dafa00e,0xe275f00b,0x3fdc4005}},	//   _řešení_, _ཙམ__གྱིས_, _ཧེ__མའི_, _појављуј,
   {{0x4a4e801d,0xf487f003,0xb53cb005,0x749a4013}},	//   _vrsta__porodica_, _akukho__nto_, _на__копну_, _režirao__ga_,
   {{0x1497300d,0xf598b00a,0xf89e5019,0x5458c007}},	//   _ktoré__sú_, _सोचत_, _de__arquivos_, _ujistěte__se_,
   {{0x29afd011,0x1432400d,0xa7232005,0x00000000}},	//   _ngamalun_omphakat, _ak__máte_, _потпуно_, --,
   {{0x3cc4100c,0x926c401c,0xe767a00c,0x00000000}},	//   _क्लिक__करें_, _nomor_, _में__जाना_, --,
   {{0x425b2007,0x02d9201c,0x7b9af02b,0x225e500b}},	//   _styl_, _obyek_, _དོན__ཁང_, _རྫོང__གཞི_,
   {{0x32d8f021,0x45e7d00b,0x00000000,0x00000000}},	//   _dager_, _དངུལ__རྒྱབ_, --, --,
   {{0x0490e02a,0x548eb010,0xb868f004,0x94ad500f}},	//   _en__god_, _de__las_, _assinatu, _mbere__ya_,
   {{0x6cf2f00f,0x12486003,0x33d16014,0xed59f00a}},	//   _ubutaber, _ubomi_, _da__guerra_, _बढ़ई_,
   {{0xf3435010,0x6be6200c,0x3b26400d,0x36a80011}},	//   _diseño_, _पर__भी_, _pripomie, _abantu__abathath,
   {{0x22fc7037,0x8a4ee00c,0x3305301c,0x83ab7021}},	//   _kongo_, _एक__बार_, _beragam_, _deg__over_,
   {{0xc394001b,0xb25a0010,0x6475d004,0x39dc100c}},	// [9e0] _ofisi_, _chile_, _jogos__de_, _में__परिवर्ति,
   {{0xb4432010,0xb47ad007,0x8249f011,0x00000000}},	//   _hoy_, _byla__to_, _uzuma_, --,
   {{0xf200c01d,0xf2d7b023,0xd290c012,0x226cb01c}},	//   _radi_, _dipanggi_stub_, _rada_, _cocok_,
   {{0xaac70007,0xf20f9011,0x73791004,0xab8cb00c}},	//   _zboží_, _ukuthi__yini_, _você__precisa_, _कं_,
   {{0xda3d900a,0x626c5004,0xac74900c,0xc4c23021}},	//   _दाई_, _belo_, _आवश्यकता__नहीं_, _utviklin_av_,
   {{0xebdb000e,0x456a8005,0x897f6011,0x72986007}},	//   _ཐོབ__ཐང_, _надморск, _emphakat, _se__tím_,
   {{0xb91e100d,0xd0d07003,0xc3416014,0x00000000}},	//   _trenčín_, _kuhlawul, _dereita_, --,
   {{0x34af600d,0x44bd2023,0x121a3011,0x546de010}},	//   _že__sa_, _kumpulan__ini_, _ekhaya__lakhe_, _gente__no_,
   {{0x1d1a500d,0xe394901c,0x5320c007,0x824df00e}},	//   _ďalšie_, _sukses_, _tady_, _སྙམ_,
   {{0x9297a02e,0x82c92014,0xa36c700f,0x1fc39011}},	//   _umukuru_, _para__unha_, _imigani_, _lokhu__ngesikha,
   {{0xabd5c014,0xd3049023,0x4802a004,0x550aa00d}},	//   _tamén__bibliogr, _atau__mana_, _automóve, _si__môžete_,
   {{0xeaf2200d,0x64a95019,0x00000000,0x00000000}},	//   _prihlást, _feira__de_, --, --,
   {{0x2309d023,0x247a1021,0xaa4bb00c,0x5dc79011}},	//   _sama__anda_, _informas_og_, _की__बचत_, _ukuthi__kwenzeka,
   {{0x9bb9300c,0x76f9302d,0x6e787007,0x5201f003}},	//   _हैं__कि_, _भोला_, _pojištěn, _yeziko_,
   {{0x332d9003,0xc598a00a,0x52d91004,0x541f2007}},	//   _imali__mboleko_, _होइत_, _lazer_, _na__začátku_,
   {{0xb4444010,0x5997705b,0xf2d91004,0xd09d8020}},	//   _el_, _प्रशिक्ष, _fazer_, _སྐྱ_,
   {{0x91e1401a,0x63a2d014,0x00000000,0x00000000}},	// [9f0] _हमारी_, _atopan_, --, --,
   {{0x9ba1500b,0x6e83400d,0x79e0e010,0x71d9600a}},	//   _སྐོར__ལས_, _spoločno, _distingu, _दोसर_,
   {{0xf326d027,0x63f9b01d,0x00000000,0x00000000}},	//   _berkenaa_dengan_, _izvuci_, --, --,
   {{0xe48f602a,0x726c501d,0x926c1007,0x0453b021}},	//   _de__er_, _selo_, _mohou_, _det__beste_,
   {{0x426c5019,0x329c1005,0x69e11004,0xa4910003}},	//   _pelo_, _броју__становни, _comércio_, _ke__loo_,
   {{0x8419b010,0x8de1900b,0x00000000,0x00000000}},	//   _una__lista_, _བརྩོན__ཤུགས_, --, --,
   {{0x83003014,0xfba3600f,0x82fc5021,0x2e9c8005}},	//   _por__unha_, _abikorer, _velg_, _авиона__је_,
   {{0xf2bb400e,0x7be16003,0xe3ff8011,0xfd660010}},	//   _མི__རུང_, _neemfuno_, _ebuzwa__ukuthi_, _se__consider,
   {{0x1b88d002,0x513f701d,0x826c500d,0x2e7d5005}},	//   _ना_, _ponedjel, _telo_, _коме__је_,
   {{0x12531011,0xf3b4f01c,0x64432010,0x725ff02b}},	//   _ngaso__sonke_, _bagian__selatan_, _soy_, _རྩ__ཁྲིམས_,
   {{0xe23d9014,0x9f559014,0xea295010,0x00000000}},	//   _unha__serie_, _despraza, _de__contenid, --,
   {{0xc29e000e,0xad8af00e,0x634c700d,0xea090030}},	//   _བྱེད__པའི_, _ལྕགས_, _povedal_, _forbedre,
   {{0xda3e101a,0x39f3400d,0xfeb7d004,0x94432010}},	//   _यदि_, _spoločen, _possível_, _voy_,
   {{0xb472e028,0x74209011,0x4290f010,0x94531011}},	//   _que__el_, _ngemuva__kokuba_, _haga_, _kakhulu__kanti_,
   {{0xc28f1011,0x70378005,0xc2393005,0x64b45010}},	//   _unkosika_wakhe_, _učesnik_, _попут_, _hojas__de_,
   {{0xc2983011,0xc26c5014,0xfbabc00e,0x527f7013}},	//   _kusho__unkk_, _polos_, _རྒྱུས__པར_, _stanje_,
   {{0xd5344008,0xc313f015,0xfbe0f00f,0xb4705028}},	// [a00] _itungany, _rencana_, _kurenger, _entre__el_,
   {{0x8290f038,0xc26d2008,0x3a3e201e,0x5249000f}},	//   _laga_, _ivyo_, _मदद_, _nkambi_,
   {{0x226c700d,0x39d76038,0x82441022,0x73a3a030}},	//   _meno_, _eigentle, _cómo_, _suppe_,
   {{0xb29c600e,0x8be0f00c,0x00000000,0x00000000}},	//   _གཞིའི__དཀར_, _प्रश्नों__का_, --, --,
   {{0xe3fa7023,0xf9fa0014,0x00000000,0x00000000}},	//   _rasuah_, _xogadore, --, --,
   {{0xa3961007,0xb7764007,0x73959004,0x00000000}},	//   _napsal_, _zkušenos, _nessa_, --,
   {{0x3e426005,0x563fa005,0x3ad61012,0x9bfc7018}},	//   _је__на_, _je__geometri, _pretplat, _མི__སྣ_,
   {{0x4f5de023,0xce834007,0x23e11014,0x7c48e002}},	//   _bahasa__inggeris_, _společno, _de__dous_, _सोचे_,
   {{0x9200301c,0xb9f43014,0x3a4ed00c,0x00000000}},	//   _pemilu_, _tamén_, _एक__साथ_, --,
   {{0xc24da00b,0x4378a023,0x52bfb010,0xb48dc007}},	//   _འཐུ_, _rakaman_, _una__casa_, _klepněte__sem_,
   {{0xc439b02a,0x9bb2c00c,0x0ec73005,0x00000000}},	//   _en__liste_, _नहीं__कि_, _земља_, --,
   {{0x92a71021,0xe43ef011,0xe738c00e,0x02b72005}},	//   _jobber_, _bayazi__ukuthi_, _གློད_, _другом_,
   {{0xe2f11003,0x7ebc6007,0x00000000,0x00000000}},	//   _naziphi_, _přeskoči, --, --,
   {{0xabe1002b,0x7496200d,0x79765011,0x00000000}},	//   _གཏོགས__དེ_, _keď__si_, _umengame, --,
   {{0x73c32027,0x5474602a,0xe2aa8018,0xcbfb400c}},	//   _adalah__seperti_, _som__om_, _པར__བཤད_, _उतनी__ही_,
   {{0xfb1bf023,0x00000000,0x00000000,0x00000000}},	//   _rencana__lanjutan_, --, --, --,
   {{0x180f2011,0x74c1300d,0x00000000,0x00000000}},	// [a10] _okhulume_amaphoyi, _prezrite__si_, --, --,
   {{0x4225e01d,0xd4ab202a,0x9b0e701b,0x7b28c00e}},	//   _netko_, _med__den_, _setswana_, _གླེང_,
   {{0x1721802d,0xb54ec01b,0xd3959004,0x99f34007}},	//   _बाड़ी_, _izixhobo_, _dessa_, _společen,
   {{0x0bd9700c,0x4283f00f,0xfa85700c,0xc2df2011}},	//   _गया__है_, _mashuri_, _हमारे__पास_, _mdunge__uthe_,
   {{0xd30c601d,0x3af2200d,0x43185021,0x12be900d}},	//   _naciljaj, _prihlási, _en__veldig_, _zatiaľ_,
   {{0x4266f00b,0x0bdaf00b,0x00000000,0x00000000}},	//   _ཞལ__འཛོམས_, _ཚོད__ནང_, --, --,
   {{0xba22d014,0x42ac6005,0x3237e01b,0x1dbe7005}},	//   _que__tamén_, _prvo__kolo_, _ngomhla_, _републик_српске_,
   {{0xc472d021,0xee51c015,0x00000000,0x00000000}},	//   _skrevet__av_, _kemasuka, --, --,
   {{0x3201101f,0x2290f019,0xf4900004,0xd2965011}},	//   _kazi_, _vaga_, _do__ano_, _wezokubu_ngokubam,
   {{0x6b8fe00c,0x1bd1300e,0x998e1005,0x8bb0c00c}},	//   _थे_, _ཐོག__མར_, _начин_, _लोगों__का_,
   {{0x026c200d,0x756fd02a,0x4776200c,0x8cc02011}},	//   _rokov_, _for__eksempel_, _का__निर्माण_, _ukuze__bakwazi_,
   {{0x5b9e403a,0xe256300b,0x02a0600b,0xb25a6011}},	//   _abahagar, _བཟུམ__མའི_, _སླབ__ཨིན_, _thola_,
   {{0x825a9010,0x0b9c800c,0x9226800c,0x0c01500c}},	//   _cual_, _की__है_, _में__केवल_, _चीज़ों__को_,
   {{0x53eab037,0xf3028009,0x6273a010,0xe23a7007}},	//   _ndetse_, _sampai__dengan_, _línea_, _vyzkouše,
   {{0x26f8a00c,0x34394011,0xe2f12003,0xb3a3f005}},	//   _होगा_, _ngesonto__elizayo_, _nayiphi_, _grupe_,
   {{0x521d8011,0x229fe004,0x5e8fe004,0xbe82e00d}},	//   _uqhube__wathi_, _projeto_, _projetos_, _bývanie_,
   {{0xa273a014,0x4bc3800c,0x5c6c300c,0x00000000}},	// [a20] _aínda_, _का__भुगतान_, _खरीद__सकते_, --,
   {{0xd2912010,0x14b47022,0x725a4021,0xbc6c400c}},	//   _haya_, _relacion_con_, _sgml_, _कि__आपने_,
   {{0x3a33f00a,0x326c402f,0xf81ae007,0xf327a010}},	//   _जवन_, _domov_, _společno_microsof, _no__importa_,
   {{0x7378e023,0xc4c13028,0x66c9a00c,0x00000000}},	//   _dalaman_, _utilizar__en_, _की__शक्ति_, --,
   {{0x739ba003,0xf42bb004,0x00000000,0x00000000}},	//   _isixeko_, _estão__alguns_, --, --,
   {{0x896d4011,0x8b8c900e,0x062a5023,0xc16c1007}},	//   _nesikhat, _ནུ_, _saintifi, _je__důležité_,
   {{0x5b8d002d,0xb2e2a023,0x2617c00c,0x8e6eb00d}},	//   _छल_, _seramai__orang_, _है__क्योंकि_, _určite_,
   {{0x1ebdc007,0x2972a01d,0xaafca007,0xc4ab5010}},	//   _hodnocen, _ispitajt, _vysočina_, _desde__la_,
   {{0x1aaa7005,0xd44ae010,0x00000000,0x00000000}},	//   _председн, _cuenta__que_, --, --,
   {{0x2468e021,0xd2dfc011,0xf3445014,0x0266900e}},	//   _deg__og_, _kwa__sabc_, _facerse_, _ལོར__སྐུ_,
   {{0x7291201b,0x42d9b036,0xcfab1014,0x7aa7d00c}},	//   _baya_, _planete_, _raíña_, _सोचते__हैं_,
   {{0x09f5900f,0xb26ca00d,0xc2a6c023,0xc7293005}},	//   _kaminuza_, _lebo_, _nombor_, _добро_,
   {{0x93f9e007,0x7380d009,0xc47dd021,0x32a5b02a}},	//   _datum_, _luas__wilayah_, _noen__av_, _de__skal_,
   {{0xd26ca007,0x0249f003,0x8291d023,0x7b975007}},	//   _nebo_, _ubume_, _ehwal_, _mobilníc_telefonů_,
   {{0x03ea0023,0xa2a24014,0x0bc3e00c,0xec00900c}},	//   _iaitu_, _que__aínda_, _क्या__है_, _जीवन__के_,
   {{0xc75de00f,0x435cd003,0xb2fde011,0xe47ad007}},	//   _bizimung, _kunye__nezinye_, _laba__badlali_, _nebo__na_,
   {{0x72da501c,0x37b7f010,0x646a600d,0x43ec7011}},	// [a30] _materi_, _ejercici, _tým__že_, _ekutheni_,
   {{0x46ba302e,0x3386d00d,0xcf163011,0x9fdb1007}},	//   _yubahiri, _ktorej_, _uma__kukhulun, _na__své_,
   {{0xb4926010,0xee4ed007,0x535e8013,0x898aa007}},	//   _en__el_, _bydliště_, _pregled_, _sobě_,
   {{0x62d8000a,0x6379a006,0x74bd1021,0x25ff600c}},	//   _रहनी_, _layanan_, _send__inn_, _क्योंकि_,
   {{0xc2c6b026,0xbb55b005,0xe200c007,0x82bfc004}},	//   _mislite_, _opština__severois, _velice_, _no__ícone_,
   {{0x52fd7010,0x3db24017,0xc4c13028,0x00000000}},	//   _imagen_, _apareceu_, _utilizar__un_, --,
   {{0xa2b06033,0xf3069011,0x486f400d,0x00000000}},	//   _det__samme_, _uma__ubheka_, _sprievod, --,
   {{0x6ac77007,0xfbbb000c,0xcf139021,0x64a5d004}},	//   _další_, _बहुत__से_, _de__høyeste_, _cavalos__de_,
   {{0xf394e023,0x00000000,0x00000000,0x00000000}},	//   _episod_, --, --, --,
   {{0x06bec005,0x3291301b,0x22cdf021,0x6863d005}},	//   _naselje__opština_, _naxa_, _er__kjent_, _додатим_,
   {{0x64425021,0x5c55e00c,0x7d27a00c,0x00000000}},	//   _inl_, _की__सबसे_, _का__प्रबंधन_, --,
   {{0x227ff00d,0x7bac6018,0x1458200d,0x00000000}},	//   _zoznam_, _དང__ནི_, _príspevo_od_, --,
   {{0x52901031,0x26c2c03a,0x64ada019,0x754db005}},	//   _apha_, _amaradiy, _simples__de_, _посматра,
   {{0x1bf7100c,0xec620017,0x83949004,0xd293000e}},	//   _में__एक_, _segundo_, _elas_, _ཞིག__སྟེ_,
   {{0xce383027,0x2474802a,0x3495b021,0xd787c00b}},	//   _pengajia, _bygninge_og_, _så__hva_, _ཆེད__བཀོད_,
   {{0x024ba055,0x6cd36005,0xbec4400f,0xfa94f00c}},	//   _श्रेणी_, _просјечн_густина_, _banyarwa, _कश्मीर_,
   {{0x03ea001c,0xc43d8004,0x11240005,0x00000000}},	// [a40] _yaitu_, _se__sentir_, _јединств, --,
   {{0x2ebf6005,0x6457d036,0x8324300d,0xe3b7c003}},	//   _мјесту__је_, _popisu__iz_, _ak__chcete_, _iimviwo_,
   {{0x63210017,0xbf68400b,0x00000000,0x00000000}},	//   _década_, _ཨང__འབྲུག_, --, --,
   {{0x8e1c900f,0xc29c500e,0x3c97600c,0x9d5a2005}},	//   _interaha, _ཞེས__པའི_, _प्रयोग__करके_, _томе_,
   {{0x524cf011,0xe4bbe021,0x00000000,0x00000000}},	//   _emhlaben_wonke_, _ditt__er_, --, --,
   {{0xf469f00d,0xb2e2500c,0xf6295005,0x4ed52005}},	//   _aby__ste_, _तकनीक_, _су__етнички_, _тог_,
   {{0xb316900f,0x62abe003,0xe5bfe011,0x4c4e000c}},	//   _amazu_, _kwaye__ujonge_, _kulesiya__sifundaz, _किये_,
   {{0x4e27e00b,0xa386d038,0xc4b1d010,0xcf6ca00c}},	//   _རྒྱལ__བརྒྱུད_, _gjer_, _tiene__la_, _हो__जाएगा_,
   {{0xb4438038,0x225be003,0x6431000b,0x00000000}},	//   _kor_, _entla_, _འབད__རྒྱལ_, --,
   {{0x7b8cb018,0x5263300e,0xc23e3011,0x00000000}},	//   _དུ_, _གྲོང__རྡལ_, _umama__wakhe_, --,
   {{0xab88200c,0x8274b006,0xc2ed8014,0x3b6ee005}},	//   _नए_, _tidak__memiliki_, _coñecido__como_, _поставил_сателит_,
   {{0x32fba023,0x22a93003,0x23ce900d,0x6c0c900b}},	//   _sebelum__memasuki_, _le__mihla_, _slová_, _ཅིག__ཁར_,
   {{0xa27e900f,0x3c48d00a,0x430c901d,0x48b4d032}},	//   _bwana_, _होके_, _pomicanj, _ser__utilizad,
   {{0x6dc33008,0x647cf014,0x33aa1021,0x629d8021}},	//   _ishiraha, _provinci_de_, _få__tilgang_, _dette__programm,
   {{0x1378101d,0x42d8d00c,0xbd6bb014,0x00000000}},	//   _zabavna_, _होगी_, _soamente_, --,
   {{0x34b6b005,0x0200d015,0x9bdff00b,0x00000000}},	//   _pojedina_sa_, _beliau_, _ཤུལ__ལས_, --,
   {{0x476ba005,0x7205b037,0x91bed00a,0x3525200c}},	// [a50] _na__srednjoj_, _politiki_, _चुकल_, _जोड़ें_,
   {{0x4c48d00a,0x32d8d00a,0x5c88d00a,0x6c81200c}},	//   _होखे_, _होखी_, _होखो_, _शुरू__करने_,
   {{0x73f9e015,0x4984801b,0xd9f6600d,0x00000000}},	//   _datuk_, _ngokwase, _korún_, --,
   {{0xc4b89021,0xb337c005,0x3293600b,0xe44f1010}},	//   _ikke__bli_, _никола_, _འཐབ__ཆོག_, _suelen__ser_,
   {{0x52df0014,0x0465402a,0xca8b3007,0x62b9300f}},	//   _en__finado_, _hvordan__det_, _sociální_, _kumenya__neza_,
   {{0xf4426004,0xb21c3005,0xb3bfb010,0x9c00c00c}},	//   _ano_, _učesnik__godine_, _obtener__más_, _जैसे__कि_,
   {{0x8d8f8020,0x0685a005,0x8f67e017,0x3a054036}},	//   _ཕེབས_, _na__vikipedi, _estadoun, _uopšte_,
   {{0x9bb8900e,0xba39300a,0x00000000,0x00000000}},	//   _ལྟ__བུ_, _भोजप_, --, --,
   {{0x02b1800b,0x73954004,0x94bda011,0x00000000}},	//   _ཚུ__གིས_, _acesse_, _lwentsha__lwe_, --,
   {{0xc4439010,0xe4a8f02a,0xfb7a2014,0x02339011}},	//   _los_, _den__til_, _presenza_, _ukuthi__bonke_,
   {{0x32b49008,0xf47ef003,0x38a8400b,0x126cd01b}},	//   _ataco_, _ekufunek, _དགའ__སྐྱིད_, _amaninzi_,
   {{0x2b9ba024,0xc6dd100c,0x9267c010,0x00000000}},	//   _འཁོར__ལམ_, _की__अवधि_, _del__éxito_, --,
   {{0x67ef502b,0x00000000,0x00000000,0x00000000}},	//   _གཙོ__འཛིན_, --, --, --,
   {{0x14439004,0x0e36c00d,0x2326e007,0x54bca010}},	//   _aos_, _spracova, _soubory_, _la__versión_,
   {{0x13c4702a,0x64611007,0xc0446010,0x0ab1600c}},	//   _som__helst_, _říká__že_, _sus__producto, _रखने__में_,
   {{0x923b100d,0x2a0a7032,0x6b865013,0x84983004}},	//   _máj_, _catarina_, _istočnoj_, _um__dia_,
   {{0x046b802a,0x62c1c010,0xd695a005,0xca64c00c}},	// [a60] _fra__det_, _en__línea_, _младост_, _उपयोग__किए_,
   {{0x626d000f,0x1a23d014,0xa43ab021,0x6a07000f}},	//   _imboro_, _seu__irmán_, _er__best_, _ambasade,
   {{0x53f9901c,0xc4b02014,0x9430b00d,0x52df3004}},	//   _kasus_, _non__hai_, _poľnohos, _em__casa_,
   {{0x6a064007,0xc4716021,0x4b7cd014,0x00000000}},	//   _služeb_, _nok__en_, _recoñece, --,
   {{0x630b8011,0xf2b83014,0x82d5a003,0x92bf700a}},	//   _semi__final_, _da__época_, _iphondo_, _आड़ू_,
   {{0x10b1c005,0x14aae02a,0xd719e03f,0x995f2017}},	//   _станиште__врсте_, _det__med_, _komuniká, _francese,
   {{0x9b95702b,0xb6f8000a,0x44984011,0x00000000}},	//   _དོན__ལས_, _लईका_, _we__hip_, --,
   {{0xe299100b,0xa2606003,0x92ea6017,0xc4723010}},	//   _པའི__མངའ_, _kwilizwe__lonke_, _fusión_, _que__los_,
   {{0x23056010,0x00000000,0x00000000,0x00000000}},	//   _disponib_para_, --, --, --,
   {{0x13ee5005,0xa22e2005,0x246dd011,0x94039004}},	//   _sa__objašnje, _је__регистро, _isithomb_gugu_, _aplicaçã,
   {{0x33eb903b,0x424e6020,0x7b349028,0xc46fb010}},	//   _siste_, _ལའི_, _se__utilizan_, _entre__los_,
   {{0x34427038,0x34426028,0xe3960036,0x04505021}},	//   _enn_, _uno_, _srpske_, _virker__som_,
   {{0xe22ff00d,0xbe3de00d,0xc3faa005,0x1ba2200c}},	//   _ste__mali_, _tu__nájdete_, _истражив, _भी__एक_,
   {{0xe5f5f01b,0x0bc6e00c,0xb8c6102a,0xebdba02c}},	//   _kwi__intaneth, _होता__है_, _leverand, _formando_,
   {{0x6d8f8005,0x26e5d00c,0x00000000,0x00000000}},	//   _април__јун_, _गोपनीयता__नीति_, --, --,
   {{0x0bf6500b,0xd4ab202a,0xc48a5021,0x4f1b9013}},	//   _ཚུ__ལུ_, _har__den_, _bruken__av_, _piše_,
   {{0x12b6b036,0x8b282024,0x6bb8b004,0x00000000}},	// [a70] _studije_, _ཀྲོང_, _não__signific, --,
   {{0xb242b00e,0xe494f02a,0xd0b28024,0xea9d1013}},	//   _བོར_, _føre__til_, _དང__བརྡ_, _medicins,
   {{0xc4906021,0xeba2f00b,0xec0cb02b,0xd1ccf010}},	//   _ha__en_, _དབྱིན__ཟླ_, _ཅིག__གི_, _el__desarrol,
   {{0xe24da02b,0xac50602a,0xb4c44005,0xe22fe004}},	//   _འཐབ_, _du__ønsker_, _то__време_, _uma__ótima_,
   {{0x1a3e200a,0x44429031,0x8258b00e,0x798bf005}},	//   _माई_, _mna_, _འདྲ__མིན_, _страну_,
   {{0x416af007,0xb8eaf007,0x71b5b00d,0x00000000}},	//   _nabídka_, _nabídky_, _najčítan, --,
   {{0x442ca009,0x8e4d2011,0x9b865013,0xe6533005}},	//   _nomor__tahun_, _amaphoyi_esifunda, _istočnom_, _међусобн,
   {{0xde4f6003,0x41b9c00a,0x00000000,0x00000000}},	//   _kagawula, _बोलल_, --, --,
   {{0x84b85003,0x534b9010,0x1447f010,0x00000000}},	//   _yakho__xa_, _la__imagen_, _el__futuro_, --,
   {{0xc46be007,0x13eed007,0x00000000,0x00000000}},	//   _jak__je_, _budete__mít_, --, --,
   {{0xe2cca021,0x6293b011,0x1492f00d,0x424d800e}},	//   _av__denne_, _kuqhubek_icala_, _zatiaľ__čo_, _སྐམ_,
   {{0xd442000d,0xe213f03d,0x12910037,0x400e2004}},	//   _pri_, _futhi_, _bibazo_, _eletrôni,
   {{0x8d1e200f,0x624e600e,0xc2a7a00b,0xbbce900c}},	//   _jenoside_, _ལའང_, _གས__པའི_, _यहां__पर_,
   {{0x02c54005,0x43a2000f,0x2f3dd005,0x34a5702a}},	//   _opštine__iznosi_, _ikipe_, _све__до_, _være__på_,
   {{0x540ab009,0xd738300e,0x83860038,0xc2b5000b}},	//   _mengatak_bahwa_, _ཁྲོད_, _deira_, _ཞབ__འབད_,
   {{0x1442000d,0x93e2f021,0xb450e007,0x00000000}},	//   _tri_, _en__ganske_, _vypadá__to_, --,
   {{0xa3860019,0x72dd9021,0x00000000,0x00000000}},	// [a80] _feira_, _har__forskjel, --, --,
   {{0xb2fcf038,0x626c9013,0x0b99f00c,0x00000000}},	//   _legg_, _škole_, _ऐसा__है_, --,
   {{0x84ba5015,0x59e1902a,0x9bfc0024,0x00000000}},	//   _kami__di_, _mange__menneske, _ཞུ__མི_, --,
   {{0xf26cf01d,0xc7a27023,0x7e3bf014,0xbbe6200b}},	//   _nego_, _pentadbi, _tiña_, _སེར__ཚུ_,
   {{0x0cde802a,0xa248f027,0x3309b00f,0x5050a010}},	//   _det__første_, _rahman_, _kwisi__yose_, _sus__objetivo,
   {{0xa660400e,0xa394d004,0x22654024,0x0fd2900d}},	//   _གཞི__དཔྱད_, _eles_, _གྲོས__ཆོད_, _vzťahy_,
   {{0xe2eda033,0xc3f3802a,0xb46ed005,0xaa65a00c}},	//   _til__denne_, _det__være_, _време_, _इसके__लिए_,
   {{0x8014d013,0x82d90013,0x2dac6014,0x0bbca00c}},	//   _učestvov, _pobede_, _linguaxe_, _तरीका__है_,
   {{0x62ca7029,0x0b28200e,0x3e2aa007,0xe26c9013}},	//   _bind_, _ཀྲུང_, _akční_, _školu_,
   {{0x93eb9038,0x5386900f,0x5b2f302b,0x2322100f}},	//   _mista_, _imari_, _བཙོང_, _ibintu__byiza_,
   {{0xc48f6028,0x326cf004,0x6e264023,0xfbae600c}},	//   _de__la_, _jogos_, _penyelia__terdapat_, _के__विरुद्ध_,
   {{0xd2ca7009,0x73960004,0x00000000,0x00000000}},	//   _candi_, _possui_, --, --,
   {{0xe48f605c,0xabdb602b,0x26cf200a,0x79f84014}},	//   _de__na_, _བཀོད__དེ_, _आँखि_, _asasinad,
   {{0xdf1b9026,0x8fd8c007,0xadc3b00f,0x846ce00f}},	//   _miša_, _návštěvn, _gisirika, _hamwe__nu_,
   {{0xd212e004,0x00000000,0x00000000,0x00000000}},	//   _nenhum_, --, --, --,
   {{0x546be007,0x4fe79005,0x94ab9021,0x00000000}},	//   _jak__se_, _још__увек_, _med__deg_, --,
   {{0x63b0d010,0xc255f00a,0x6ba4a00c,0x00000000}},	// [a90] _aunque_, _होखेला_, _का__भी_, --,
   {{0x72018008,0x7e6a9014,0xe4b0e02a,0x635d5004}},	//   _cari_, _que__tiña_, _hun__er_, _um__período_,
   {{0xc225901c,0x64c2d028,0xe427f011,0x3be5e00c}},	//   _meski_, _ciudad__de_, _kabi__ukuthi_, _पर__यह_,
   {{0xd48a5011,0xe443c05d,0xa3c37019,0xbc020010}},	//   _ngakho__ke_, _lov_, _que__eles_, _realidad_,
   {{0x12f62007,0xbf47500b,0x00000000,0x00000000}},	//   _úplně_, _ལུགས__འབྲུག_, --, --,
   {{0x0443c010,0xdc754002,0xefe6c005,0x3a47c00c}},	//   _nov_, _तृप्ति_, _против_, _साथ__साथ_,
   {{0x7c68100f,0xa3c0f014,0xf4ab102a,0xe9a4c010}},	//   _amaraso_, _entre__eles_, _det__jeg_, _mayoría_,
   {{0x1419100f,0x00000000,0x00000000,0x00000000}},	//   _kumurong_hamwe_, --, --, --,
   {{0x04b9e014,0x7487b00c,0x00000000,0x00000000}},	//   _dirixido__por_, _सेवाएं_, --, --,
   {{0x63dcf03a,0xfb9be00e,0x82904011,0xbf7aa00d}},	//   _ingwe_, _ཡིན__པར_, _le__nkampani_, _vo__vašej_,
   {{0xdba7a00b,0x126cf014,0xe063c005,0x00000000}},	//   _སྲུང__ཞུ_, _xogos_, _поново_, --,
   {{0x1442600d,0xf2afe00e,0x5eac2030,0xb162f02c}},	//   _čo_, _རང__ཉིད_, _eksterne_, _traslado,
   {{0x57fdb00d,0xc491b010,0x0ba2e00c,0x0a17d005}},	//   _spôsobom_, _en__los_, _ग्राहकों__को_, _јединица_,
   {{0x998aa007,0x9a3e002d,0xca17e014,0xc4713010}},	//   _době_, _मटर_, _podería_, _que__una_,
   {{0x62019008,0xaa3d400c,0x6f8bf004,0x348f600d}},	//   _basi_, _लिए_, _até_, _ak__sa_,
   {{0x72019010,0xe2a63017,0x83c41004,0x00000000}},	//   _casi_, _álbum_, _uma__pessoa_, --,
   {{0x00ebf004,0xbbde400b,0x00000000,0x00000000}},	// [aa0] _lançamen, _སླབ__དོ_, --, --,
   {{0x279f3020,0xe24f705e,0x1eb92005,0x447b9014}},	//   _བཙུན_, _le__mali_, _низ_, _historia__da_,
   {{0x226c0026,0x4498700d,0xd457500d,0x0bdfa00c}},	//   _htio_, _to__nie_, _skôr__ako_, _विकल्प__है_,
   {{0x470ec007,0x00000000,0x00000000,0x00000000}},	//   _člověk_, --, --, --,
   {{0x929e3009,0x94579023,0x1b99000e,0x6784600c}},	//   _sumber__daya_, _rencana__baru_, _གཉིས__སུ_, _के__अनुसार_,
   {{0x73ead030,0x62907038,0x1c48000a,0x02d8000a}},	//   _eget_, _opna_, _रहले_, _रहली_,
   {{0xb289f014,0xfbe43004,0x246b8021,0xd4735011}},	//   _seu__fillo_, _engenhar, _jeg__vet_, _lapho__ke_,
   {{0xbb8d100b,0x72caf005,0xe3eae029,0xc9c72013}},	//   _ཚུ_, _nato__oznaka_, _hentet_, _zahvalju,
   {{0x02d89030,0xccf2e01d,0x0ec45014,0x8d30a00e}},	//   _enkelt_, _popis__pjesama_, _teñen_, _པར__གྱུར_,
   {{0x3a9f4013,0x32503005,0x00000000,0x00000000}},	//   _aktivnos, _рекао_, --, --,
   {{0xe47dd049,0x834a8003,0xd26cc00d,0x031a8011}},	//   _skal__du_, _apha__ukuze_, _bodov_, _mthobisi__mbanjwa_,
   {{0xf9f6703b,0xa6f8200a,0x47ee5023,0x4830500c}},	//   _språk_, _रउवा_, _berasing, _से__अधिकांश_,
   {{0xace8c023,0x6465a02a,0x92f33005,0x00000000}},	//   _kumpulan__pemuzik_, _hvordan__de_, _албум_, --,
   {{0xe26b800e,0xe471f007,0xbdc7d005,0x00000000}},	//   _ནས__བཤད_, _pokud__jde_, _превод_, --,
   {{0x22919010,0xfc08300c,0x34908010,0x00000000}},	//   _pasa_, _हममें__से_, _en__uno_, --,
   {{0xd17f5028,0x6242900b,0xa1ef200c,0x3495e021}},	//   _desarrol, _ནུག_, _के__आधार_, _holder__på_,
   {{0xc4b76013,0x2998f005,0x00000000,0x00000000}},	// [ab0] _vrsta__je_, _унутар_, --, --,
   {{0x1c7f2004,0x7248d00f,0xc89c6035,0x8a60c00c}},	//   _passado_, _byombi_, _ukukhulu, _यह__पता_,
   {{0x83683030,0x5b662036,0x543b0021,0x646e1010}},	//   _googles_, _upotreba_, _er__lett_, _asegúres_de_,
   {{0x7231b009,0xb4a90006,0xe47ca02a,0xebdb800b}},	//   _rumah__sakit_, _nasional_, _velkomme_til_, _བུམ__ཐང_,
   {{0xe22c3011,0x5b8d200e,0x39c57014,0x00000000}},	//   _albhamu__yakhe_, _ཞང_, _nacement, --,
   {{0x3908b01e,0xb3417005,0xa31d000f,0x3cb8c00c}},	//   _वेब__साइट_, _porekla_, _ibisoban_byinshi_, _का__मूल्यांक,
   {{0x0ef2f014,0x09f5b007,0x84715003,0x5041a00d}},	//   _que__teñen_, _nevím_, _kwaye__xa_, _združeni,
   {{0x92723011,0xadf47005,0x8b7cd014,0x00000000}},	//   _iningi__labo_, _где__су_, _recoñeci, --,
   {{0xd498f014,0x1e47e007,0x646be02a,0x79a3000d}},	//   _un__que_, _zpravoda, _fra__de_, _obľúbené_,
   {{0x87c3e030,0x83f8c023,0x1041a036,0x47721005}},	//   _programv, _laluan_, _udruženj, _овог_,
   {{0x56f8200a,0x6bf6900c,0x04b82021,0xcb93b014}},	//   _रउरा_, _में__आप_, _selskape_som_, _dirixido_,
   {{0xa9827007,0xab1e7004,0x50c86005,0x0d25a00e}},	//   _možnost_, _pesquisa_, _исте__године_, _པའི__ཕྱིར_,
   {{0x22fc7008,0xa28e400e,0x6200c013,0xdb216004}},	//   _hinge_, _བུད__མེད_, _velike_, _de__crianças_,
   {{0xfbfca00e,0x6293a00b,0x00000000,0x00000000}},	//   _ཚེ__པར_, _གཞི__བཟོ_, --, --,
   {{0x8324c00f,0x62f4501c,0x0bc4400c,0x00000000}},	//   _habyarim, _standar_, _जाती__है_, --,
   {{0x22ba7024,0x5dc7a00f,0x2d327007,0x6c79000c}},	//   _མི__སེར_, _abazungu_, _pronájem_, _चिट्ठाजग,
   {{0xae47e00d,0x03960004,0x64997007,0x3c209010}},	// [ac0] _spravoda, _passou_, _ať__už_, _el__verdader,
   {{0x738b6030,0xc4715021,0x2f58f014,0x1473100f}},	//   _vær_, _ingen__av_, _xeralmen, _imbaraga__zo_,
   {{0x0495802a,0xfc56700c,0x23944010,0x00000000}},	//   _på__det_, _खबरें_, _lo__general_, --,
   {{0x97e20014,0x781ee005,0x42926023,0x224c0004}},	//   _unha__parroqui, _slatkovo_područja_, _diraja_, _para__ganhar_,
   {{0xd442d007,0xa224d007,0xbc90601a,0x60892005}},	//   _dne_, _řekl_, _वालों_, _већина_,
   {{0xf2a1100e,0x263fe007,0x4da9d00d,0x6a3ec007}},	//   _འདི__ཉིད_, _kalendář_, _pridané_, _emoční__intelige,
   {{0x8f697005,0x4ba3800e,0xb4b46004,0x92547024}},	//   _самом__мјесту_, _ཕྱི__ལོ_, _por__um_, _མིའི__མིང_,
   {{0x6242a00e,0x52e7600a,0x39e55017,0x3ed57005}},	//   _ཐུང_, _अइलीं_, _partícul, _мој_,
   {{0x32b4d011,0xcbeeb00e,0x44aa9023,0x02922023}},	//   _jacob__zuma_, _མང__པོ_, _sebab__ini_, _secara__rasmi_,
   {{0xd2d89026,0x23094023,0xed9c000d,0x946ba007}},	//   _dijete_, _anda__saje_, _odpoveda, _většinou_,
   {{0xc27fc014,0x80630005,0xa3681005,0x00000000}},	//   _moito__máis_, _je__učestvov, _убрзо_, --,
   {{0xaf38d026,0xebbf900e,0x8eb7e007,0x4f7f300a}},	//   _gađanje_, _ལོ__ཟླ_, _zajímavo, _अदरख_,
   {{0xc3940004,0x3eff800c,0x00000000,0x00000000}},	//   _dois_, _को__अधिक_, --, --,
   {{0x133cc005,0x00000000,0x00000000,0x00000000}},	//   _близу_, --, --, --,
   {{0xd236d013,0x545f3007,0x8439b010,0xdcbe7005}},	//   _svojih_, _zdá__se_, _la__lista_, _даје_,
   {{0x9b8d4020,0x6bcd0014,0x4e632013,0xf4a39007}},	//   _བུ_, _artigos__ligazóns_, _je__pojedina, _způsoby__jak_,
   {{0xc3f4802a,0xa915f00d,0xb472d004,0x00000000}},	// [ad0] _kan__være_, _webovej__stránky_, _sobre__um_, --,
   {{0x4443f004,0x61c17023,0x2dc77010,0x93091010}},	//   _sou_, _sesebuah_, _gran__cantidad_, _debe__tener_,
   {{0xc3566009,0x73a3f005,0x02fe6013,0xc490b010}},	//   _sebesar_, _grupa_, _drugim_, _en__una_,
   {{0x2224601b,0x53b67003,0xf4426028,0x5242b00e}},	//   _ngoko_, _abaviwa_, _oro_, _དུག_,
   {{0x7443f004,0x9202701c,0xb4b36010,0xd499a00d}},	//   _vou_, _fisika_, _ser__el_, _spôsobov__ako_,
   {{0x7242b018,0x2d0f000c,0x4312b011,0x3224d011}},	//   _དུང_, _इस__प्रकार_, _wekaizer__chiefs_, _ngeke_,
   {{0xf335900f,0xf3414021,0xbc502010,0x6482c004}},	//   _na__cyangwa_, _verdier_, _en__realidad_, _início__de_,
   {{0xf46c1004,0x22d8001e,0x0cc8d00c,0x00000000}},	//   _com__seu_, _रहती_, _दिए__जाने_, --,
   {{0x220cb009,0xf37f8005,0xebad0020,0x587b500d}},	//   _kurang__lebih_, _jugoslav_mladost_, _དག__གི_, _týmto__spôsobom_,
   {{0x82f99007,0xe9f2e010,0x246ed00f,0x32ded01e}},	//   _přidat_, _la__mayoría_, _kandi__ko_, _घाटी_,
   {{0xfc27a010,0x83940004,0xc29c600b,0x9fc3f017}},	//   _artículo_, _pois_, _བཀོད__འབད_, _cría_,
   {{0xa2429020,0x44b5701c,0x64b7e014,0x5f3f5010}},	//   _ནུས_, _keluraha_ini_, _preto__de_, _de__archivos_,
   {{0x7f1fc005,0x6299700b,0xabadd00e,0x00000000}},	//   _podeljen, _གསུངས__ནུག_, _ནང__ཚན_, --,
   {{0x64b4d005,0x52b7e004,0x32b1f01a,0x1498300d}},	//   _sećanja_, _de__dados_, _जयपुर_, _ktorí__sú_,
   {{0xf291d00f,0xf4ad0003,0x4295800f,0xe2546024}},	//   _kawa_, _eyona__nto_, _ababyeyi_, _འཇོག__གནང_,
   {{0x4bde800b,0xc2d93010,0x22921004,0x53e8b004}},	//   _འཐུ__ལོ_, _conocer_, _apenas__para_, _os__dias_,
   {{0xf4ac102a,0x5236d00f,0xc2a8200a,0xb2945011}},	// [ae0] _kan__jeg_, _wanjye_, _रउआँ_, _udalai__lama_,
   {{0x3a33b02d,0x620ed00f,0xb32d8021,0x3fa02005}},	//   _अपन_, _ibihumbi_, _som__ligger_, _decembar_,
   {{0x02919004,0x026d8014,0x7491f021,0xd3949004}},	//   _essa_, _foron_, _er__noe_, _quase_,
   {{0x63ce5014,0xadce2005,0x00000000,0x00000000}},	//   _volve_, _чиме_, --, --,
   {{0x0bdf5029,0x59c14005,0xf4ab902a,0x9b3df014}},	//   _kalender, _је__живело_, _har__jeg_, _enerxía_,
   {{0x2f21b005,0x9dd1d018,0xa319f021,0xe48f6004}},	//   _godine__opštini_, _ཤོག__གྲངས_, _et__bilde_, _de__us_,
   {{0x7348a026,0x0266600b,0x2d84f01d,0x72027015}},	//   _nebeski_, _ཟེར__ཨིན_, _dovedite_, _tarikh_,
   {{0x04426007,0x42fc6013,0x4590f003,0xb2c1f00d}},	//   _pro_, _mnogo_, _weseketh, _to__bolo_,
   {{0x162fa021,0x6343702a,0xd446d003,0x91787005}},	//   _etnograf, _for__alle_, _yiyo__ke_, _има__станиште_,
   {{0xe4495003,0xb2891003,0x3290700e,0x0e3bf014}},	//   _nabani__na_, _ishishin_lakho_, _བྱང__ཆུབ_, _miña_,
   {{0x9b58b02b,0xfe3bf014,0x6e2f6024,0x7c71200c}},	//   _དབང__འཇིགས_, _liña_, _དཔར__བསྐྲུན_, _आने__वाले_,
   {{0xd469e005,0x15910003,0x8be1300b,0x6463a004}},	//   _gde__su_, _sepemeth, _ཆོས__གས_, _certeza__de_,
   {{0x0201e03a,0x2ed52005,0x43ef002a,0xe4786021}},	//   _kati_, _под_, _har__gjort_, _blir__du_,
   {{0x022f7027,0xc243300e,0xdbeea00f,0xd2cdf011}},	//   _itu__beliau_, _མོར_, _yo__guhindur, _zakwazul_natal_,
   {{0xe2f73011,0x23ced010,0x00000000,0x00000000}},	//   _ngalolu__daba_, _lleva_, --, --,
   {{0xdc4e802d,0xc49be021,0xfa53f00d,0x00000000}},	//   _जाके_, _ut__av_, _ponúka_, --,
   {{0x9cd0b005,0xe4b72021,0x029c2014,0xfbefc00c}},	// [af0] _stanovni_gustina_, _mulighet_til_, _que__foron_, _तरीके__से_,
   {{0x6394f01c,0xdd699004,0x13cfe023,0x02b9a00f}},	//   _kaisar_, _acessóri, _termasuk, _neza__cyane_,
   {{0x52d8c014,0x125ad010,0xd243300e,0x00000000}},	//   _galego_, _piel_, _མོལ_, --,
   {{0xf2bb1007,0x2d6e1005,0x6813c003,0x8b8d600e}},	//   _galerie_, _се__може_, _abaqeshw, _པུ_,
   {{0x15b0101d,0x22367005,0x326cf014,0x04a2e00d}},	//   _granatom_, _menja_, _xogou_, _čo__som_,
   {{0x132b6014,0x427fb030,0x132b4022,0x7dcc6005}},	//   _se__poden_, _navnet_, _se__debe_, _су__му_,
   {{0x4a3d9056,0xa2b2300e,0x32b6a030,0x13b90011}},	//   _दिए_, _པོ__ཞིག_, _vurdere_, _lokhu__kuvezwe_,
   {{0xc02e2022,0x0db77037,0x327ef011,0x00000000}},	//   _condicio, _umunyama, _ezingu_, --,
   {{0x9291e02e,0xfb97e00e,0x15bc7011,0xc0bb2011}},	//   _fata_, _རྣམས__དང_, _ezindawe_zasemakh, _izimpahl,
   {{0xc201e008,0xcc184005,0xd2e20011,0x223bb029}},	//   _gati_, _за__разлику_, _lolu__hlobo_, _kobling_,
   {{0x93ea7035,0x02b2000b,0x7a7e100d,0x00000000}},	//   _kanti_, _པོ__གིས_, _cieľom_, --,
   {{0xadc01005,0x7b91000b,0x0ed8100c,0x529ba010}},	//   _која__су_, _པས__གདོང_, _सबसे__महत्वपूर, _los__foros_,
   {{0x2ed4e005,0xbda92007,0xe4032003,0xe46be010}},	//   _до_, _na__světě_, _neenkonz, _ésta__es_,
   {{0x12d8b007,0x5c006007,0x4f506007,0x3bd2f028}},	//   _akce_, _měsíc_, _měsíce_, _verdader,
   {{0xc2da601c,0x294e101d,0x03273021,0x55785007}},	//   _karena_, _prolazit, _av__robert_, _poslední,
   {{0xc34d4011,0xe2a8101a,0xe2b8101a,0x8997c010}},	//   _iminyaka__emibili_, _वहाँ_, _वहां_, _para__cualquie,
   {{0xcef12005,0x2eca5005,0x2d60200a,0x646c5004}},	// [b00] _има_, _постао__је_, _राजैं_, _excesso__de_,
   {{0x32f22014,0xe2e96002,0xbcbb202b,0x3446900d}},	//   _ano__cando_, _ससुर_, _ནང__འཛུལ_, _naučte__sa_,
   {{0x2201401f,0xa3ced007,0xfe90e00e,0xc2a8200b}},	//   _dufite_, _sleva_, _དབང__བསྒྱུར_, _ངས__པའི_,
   {{0x8201e012,0x6291e012,0x64662014,0x3f12000c}},	//   _sati_, _sata_, _padrón__de_, _या__अधिक_,
   {{0x3ec71010,0xd2e7c011,0x0af67011,0x95ce1003}},	//   _nosotros_, _ukuthi__babe_, _lo__mncintis, _zovavany,
   {{0x12925011,0x33949027,0x086e1010,0x00000000}},	//   _natali_, _kuasa_, _trabajar_, --,
   {{0x4c81200d,0x00000000,0x00000000,0x00000000}},	//   _operačný__systém_, --, --, --,
   {{0xb2c0b006,0x1c96700c,0xe4b5500f,0x78b2a007}},	//   _didirika_pada_, _क्यों_, _byoherej_na_, _nejnověj,
   {{0xc49b600d,0xb63ef005,0x62913038,0xcc04900c}},	//   _tu__je_, _mesnog__stanovni, _lenkjer_, _भले__ही_,
   {{0x1758d002,0xa26de03f,0x8292500f,0x8fcf100d}},	//   _संग्राम_, _potom_, _satani_, _stránok_,
   {{0x84c3e00f,0x0a5d400c,0x22e82011,0xbbff800c}},	//   _ubucuruz, _क्षेत्रो_में_, _elias__pelembe_, _स्तर__पर_,
   {{0x84444004,0x94429004,0xc2de000c,0x246ce00f}},	//   _ao_, _pra_, _किसी_, _hamwe__ni_,
   {{0x74432007,0xd2692011,0x2c335007,0x52b09004}},	//   _dny_, _ngoba__ethi_, _se__používá_, _algumas__dicas_,
   {{0xe5187013,0x6c0ea00c,0x8263200e,0x54051011}},	//   _potrebno_, _जिसे__आप_, _དང__བྲལ_, _indawo__yokuba_,
   {{0xe259900b,0xadc65005,0xf4488021,0x92dab011}},	//   _ཁྲི__མངའ_, _били__су_, _lenken__din_, _vusi__dube_,
   {{0x526d8028,0xc470a014,0xfec34014,0x7c911003}},	//   _foros_, _que__hai_, _ano__seguinte_, _igauteng_,
   {{0x96f98002,0x6dd7900e,0x9bd5b00b,0xf31b9007}},	// [b10] _मनवा_, _བོད__རིགས_, _གནས__ངས_, _název_,
   {{0x530a6011,0x848e0011,0xd2b1f020,0x00000000}},	//   _lesi__sigaba_, _kusuka__ngo_, _པོ__ཁྲི_, --,
   {{0x8386c04a,0x0bbb500c,0xc29ed004,0x00000000}},	//   _bedre_, _हुआ__था_, _site__não_, --,
   {{0x1444400d,0xe2a0d00b,0x00000000,0x00000000}},	//   _zo_, _འཛིན__འཐབ_, --, --,
   {{0x43195021,0x246c102a,0xaa66200c,0xa2010005}},	//   _er__veldig_, _dette__kan_, _उसके__लिए_, _orbite_,
   {{0x0316d031,0xe3806008,0xa2435020,0xa212900f}},	//   _kwezi_, _umurwi_, _པོར_, _cyaha_,
   {{0x16fed00c,0xd4425010,0x034a8011,0x42e8b032}},	//   _किया_, _él_, _iphephan_ithe_, _enviada_,
   {{0x5472e022,0x55fec005,0x12edf003,0xd2b77007}},	//   _que__no_, _korišćen, _ukuba__izinto_, _aby__byla_,
   {{0x8d826005,0x8b8d800e,0x52b4f00f,0xabbfd00c}},	//   _последња__три_, _ངང_, _kugirang_umenye_, _वर्ष__की_,
   {{0x74bff00d,0x326d903d,0x00000000,0x00000000}},	//   _predstav_si_, _leso_, --, --,
   {{0x6495e02a,0x44420004,0xcc61400f,0x237a6023}},	//   _på__de_, _pai_, _butumwa_, _kawalan_,
   {{0xe4536011,0x303c5005,0x00000000,0x00000000}},	//   _ukuthi__le_, _западној_, --, --,
   {{0xa4420004,0xc2feb030,0xf4a11011,0x2ad58003}},	//   _vai_, _aktiver_, _natal__ucaptain_, _komtshat,
   {{0x943c9023,0x02647010,0xcb25000b,0x9da4000f}},	//   _pandai__baru_, _carlos_, _ཕྱུག__མཆོག_, _ishorama,
   {{0x13eb9034,0xb2baa014,0x00000000,0x00000000}},	//   _aust_, _unha__gran_, --, --,
   {{0x9e61f00d,0x5c9c500c,0xaba5200e,0x1308c004}},	//   _skôr_, _दे__सकते_, _འགྱུར__དེ_, _do__cliente_,
   {{0x726d8010,0x145b6014,0x83415007,0x230f0011}},	// [b20] _pero_, _contaba__con_, _stejně_, _kakhulu__ngoba_,
   {{0x8d5e800a,0x00000000,0x00000000,0x00000000}},	//   _चिरई_, --, --, --,
   {{0xe2eb4029,0x7eeae005,0xf2ae000a,0xc796600f}},	//   _avsnitt_, _док__се_, _किछु_, _gukoresh_kugirang,
   {{0x95f73005,0xe8b4d013,0x22011005,0x327bb007}},	//   _су__једино_, _učestvuj, _orbitu_, _se__týká_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x526e100d,0xa98b400d,0xb3a26003,0x103c700a}},	//   _šport_, _niečo_, _ikopi_, _बड़हन_,
   {{0x1386800d,0xb27ee021,0x1c802005,0x1380100d}},	//   _ktoré_, _finner_, _себе_, _patrí_,
   {{0xf4422007,0xac4e800c,0x3f058005,0x6f199010}},	//   _jak_, _जिले_, _pravosla, _lo__suficien,
   {{0x02c2b02b,0x9ba21003,0x328c700f,0xd44be010}},	//   _ཅིག__གིས_, _uya__kufumana_, _cyakora_, _tienen__que_,
   {{0x7b9bc00e,0x4316b014,0x00000000,0x00000000}},	//   _ཁུལ__དུ_, _débese_, --, --,
   {{0xc3189023,0x0c07e00c,0x04908007,0x4a3bc010}},	//   _sebuah__rencana_, _लगता__है_, _je__pro_, _la__actualid,
   {{0x8fe9900d,0x0bb4e00c,0x00000000,0x00000000}},	//   _webových__stránok_, _नहीं__था_, --, --,
   {{0x729f6010,0xbe8f6010,0x544dd004,0x00000000}},	//   _tarjeta_, _tarjetas_, _quando__se_, --,
   {{0x72a6e00f,0xa2711011,0x00000000,0x00000000}},	//   _usibye_, _ezweni__lonke_, --, --,
   {{0xd2c34014,0xde6c2005,0x8e372005,0x66eac014}},	//   _das__súas_, _општина_, _маса__сателита_, _gravació,
   {{0x83869003,0x0a73500c,0x697f4003,0x63b89005}},	//   _umar_, _उद्योग__में_, _kufikele, _подручја_,
   {{0x1fee0004,0xe3cef01d,0x0c450028,0x0e95b019}},	// [b30] _amazonas_, _živci_, _desconec, _destaque_,
   {{0xac71b029,0xa442c03b,0x03759011,0x748da013}},	//   _startet_, _ord_, _youth__league_, _situacij,
   {{0xe4427021,0x0041c00a,0x81be300a,0xb4936010}},	//   _én_, _पहिलका_, _कटहल_, _es__el_,
   {{0x925dc005,0xc2824005,0x9c48900a,0x5a4c8003}},	//   _beograd__godina_, _prosečan__broj_, _तहरे_, _kunye__nokulawu,
   {{0xb2a46007,0x11c5a014,0x930b9004,0x00000000}},	//   _původní_, _cromosom, _um__pouco_, --,
   {{0x5326e014,0x4a02701d,0xaed56005,0x52a29010}},	//   _en__galego_, _nježno_, _још_, _por__ejemplo_,
   {{0xe4aba02a,0x230e1015,0x0242f00b,0x9450c00f}},	//   _det__ser_, _apabila_, _ཐངས_, _yo__hejuru_,
   {{0xc9c64004,0x6ce2c00b,0xf36cf00f,0x00000000}},	//   _apresent, _སྣུམ__འཁོར_, _akagari_, --,
   {{0x09f61014,0x6453600d,0x00000000,0x00000000}},	//   _supón_, _hovorí__že_, --, --,
   {{0xf378c03b,0xfbd8300b,0xc291900f,0x00000000}},	//   _romanen_, _ཡོདཔ__དང_, _icyayi_, --,
   {{0x5dc14030,0x1499c00d,0x22e3200d,0x5a1e6011}},	//   _beskytte_, _ak__sú_, _sa__teraz_, _bophiko__lwentsha_,
   {{0xfb92e00d,0x48538030,0x2bec2005,0x6316d003}},	//   _prenájom_, _omfatter_, _на__којој_, _kwezo_,
   {{0xe288900b,0xc3940014,0xe4962007,0x00000000}},	//   _མཛད__གནང_, _faise_, _odpovědi__na_, --,
   {{0x3442302f,0x4a57b004,0x83417023,0x69b72023}},	//   _naj_, _conheça_, _kesemua_, _terdapat,
   {{0x54422007,0x7399e003,0x00000000,0x00000000}},	//   _pak_, _umnxeba_, --, --,
   {{0xa442d029,0x4c01b01c,0x29d6e022,0xab80400e}},	//   _ore_, _agustus_, _generale, _དགོས__བྱུང_,
   {{0xcc802005,0xc4b65021,0xb314d03b,0x9f945007}},	// [b40] _везе_, _etter__en_, _arabisk_, _svého_,
   {{0xd30d4023,0x9a1cf003,0x7408c00f,0x00000000}},	//   _pesakit_, _ukuphucu, _ibikores_byose_, --,
   {{0xf490202a,0x9442301d,0x52f46006,0xc236d00f}},	//   _at__han_, _daj_, _dikirim_, _nanjye_,
   {{0xb3fa601d,0x9a46700d,0xb45b700d,0xc2bb8010}},	//   _kirurg_, _sa__budú_, _sú__pre_, _el__motor_,
   {{0x74420007,0x9a8e800c,0x447a700f,0x337f2010}},	//   _jsi_, _में__उपलब्ध_, _ubushobo_bwo_, _las__mujeres_,
   {{0x7272a011,0x6301e01c,0x75ce6015,0xb243200e}},	//   _ngaleso__sikhathi_, _berarti_, _umpamany, _ཙུང_,
   {{0x0a24b014,0xeea74005,0xcd8b7014,0x2ed57005}},	//   _que__supón_, _musliman, _maiorita, _јој_,
   {{0xe213a011,0xc3d9d02a,0xdc6fe00f,0xb201e011}},	//   _lapho_, _du__bør_, _itorero_, _andile__jali_,
   {{0x9298b00b,0x04156011,0xd5bd9010,0x5ed94010}},	//   _པའི__ཐོན_, _kuleliya__lizwe_, _el__servicio_, _los__clientes_,
   {{0xf2e7000a,0xe3290021,0xc1013005,0x00000000}},	//   _अबहीं_, _du__vite_, _света_, --,
   {{0x7387c004,0xa298c00e,0x54916004,0xfe27100b}},	//   _ceará_, _པའི__བོད_, _maranhão_, _འཁྐྲིལ_,
   {{0xf496102a,0x1243900e,0xada40005,0xeed59007}},	//   _så__jeg_, _ཁོར_, _којима__су_, _muže_,
   {{0x54926014,0xdeaca004,0xdb926007,0x1c1d100d}},	//   _en__no_, _controle_, _srovnání_, _štandard,
   {{0xe98a6007,0x0236d00f,0xa459e003,0x72aba004}},	//   _proč_, _banjye_, _malunga__nokuba_, _tudo__isso_,
   {{0x843e8007,0xe44eb00d,0x00000000,0x00000000}},	//   _které__jsou_, _dispozíc_na_, --, --,
   {{0x6d10700b,0x246a602a,0x67565030,0x23d93003}},	//   _བརྒྱ__འཁོར_, _dem__og_, _gjennomg, _ye__imeyile_,
   {{0x32878011,0xa9d4a004,0x9c6a0003,0x6e46c00b}},	// [b50] _bese__kuthi_, _telefone, _loluntu_, _དང__འཁྲིལཝ_,
   {{0xb4926005,0xe4733003,0x84044021,0x9bbf802b}},	//   _je__do_, _kunye__neenkonz, _oversikt__over_, _ལོ__མི_,
   {{0x8442401b,0xa2267038,0xa2e9a02d,0x72d8a01d}},	//   _bam_, _brukar_, _मसूर_, _uvjeti_,
   {{0xb442d00d,0xf51bd027,0xb4aa000d,0x629a600b}},	//   _pre_, _mengawal_, _môže__to_, _བཙུགས__ནུག_,
   {{0xd4695003,0xc3f93004,0x00000000,0x00000000}},	//   _ngokuba__yi_, _piauí_, --, --,
   {{0x89b1b004,0x7b6a701c,0xf46d5021,0x7236d00f}},	//   _atividad, _britania_, _finne__ut_, _yanjye_,
   {{0x831a702a,0x1e888005,0x52cb8019,0xd3bfb022}},	//   _et__sted_, _младост__београд_, _maioria_, _este__libro_,
   {{0xf442d030,0x12e2603d,0x8a93a01a,0x04a9f021}},	//   _tre_, _lo__mdlalo_, _फटाफट_, _din__vil_,
   {{0xbdb40015,0x42813003,0x4397e022,0x0dad0004}},	//   _sebuah__ensiklop, _ukuba__kukho_, _un__momento_, _quantida,
   {{0x82246031,0xdff5a02a,0xc345100d,0xd659f014}},	//   _ngoku_, _betydnin, _všetci_, _orixinal_,
   {{0xf4424031,0xf3a3f005,0x63949004,0xdb41d005}},	//   _yam_, _grupi_, _boas_, _istoriča,
   {{0xdc50f011,0xf27a300e,0xb24da00e,0xf2a92010}},	//   _zanele__magwaza_, _ནི__རེད_, _འབའ_, _tiempo__real_,
   {{0x5ade1023,0x00000000,0x00000000,0x00000000}},	//   _satu__penyelia_, --, --, --,
   {{0x4e9bd01d,0x8287a024,0x42cb4007,0xa22b2005}},	//   _sakupite_, _མིང__ཚིག_, _hledat_, _promene_,
   {{0x23ef401d,0x1c5f401d,0x54b45003,0x36e15005}},	//   _obitelji_, _obitelj_, _kunye__no_, _под__називом_,
   {{0x5311c010,0xceb36007,0x1be0a00c,0x00000000}},	//   _para__hacer_, _pro__společno, _जो__एक_, --,
   {{0xf03de004,0x9c09802b,0xc42a901b,0xca9b000c}},	// [b60] _anúncio_, _དབང__ཚད_, _lolawulo_, _में__कोई_,
   {{0x50c1e005,0xb6dc6005,0xc471e010,0x2b00c010}},	//   _северној__године_, _коришћењ, _hoy__en_, _más__populare,
   {{0x82c03014,0xe469f02a,0xa2fa100f,0xe42a9003}},	//   _no__caso_, _fra__til_, _ibintu__byinshi_, _nolawulo_,
   {{0x37074004,0x75758036,0x6bf3800c,0x00000000}},	//   _instalaç, _četvrto_, _आपको__वह_, --,
   {{0xc4b6e021,0xc48a5007,0xfad69005,0x00000000}},	//   _løpet__av_, _které__je_, _јануара_, --,
   {{0xd4424031,0x6b8f400a,0x6c6a0003,0xd24da00e}},	//   _wam_, _लऽ_, _yoluntu_, _འབར_,
   {{0x46322040,0x9c79b005,0x00000000,0x00000000}},	//   _सम्बन्धि, _bio__gustina_, --, --,
   {{0x701b905f,0x5598000a,0x55f3000d,0x43400014}},	//   _प्रत्येक_, _लउकत_, _vám__pomôže_, _cuberta_,
   {{0xc25a9011,0xcc5d6004,0x72fe7003,0x00000000}},	//   _obala_, _gestão_, _yesazisi_, --,
   {{0x5386900f,0x2bb9a00c,0x00000000,0x00000000}},	//   _twari_, _हैं__जब_, --, --,
   {{0xb2fce038,0xae612005,0x4320e01c,0xf394f010}},	//   _gongen_, _где_, _sinyal_, _crisis_,
   {{0x3f57800c,0x8f706004,0xa41d2011,0xc2a8a00b}},	//   _में__अधिक_, _peças_, _anc__umnuz_, _ཚན__པའི_,
   {{0x6ad28020,0x7c6a0003,0xe9f67014,0x00000000}},	//   _གཟིགས_, _zoluntu_, _posúe_, --,
   {{0x419e3005,0x235f2011,0x6ba20007,0xa06b5005}},	//   _последњи_година_, _south__african_, _případě_, _је__освојио_,
   {{0xdc49e03c,0x3341d011,0x6bcf1005,0x2382c00c}},	//   _पैसे_, _kodwa__kumele_, _код__мушкарац, _लाइफस्टा,
   {{0x55ccd011,0x426de02f,0x72ed8010,0x00000000}},	//   _kwesinye__isikhath, _leto_, _la__tarjeta_, --,
   {{0x646ce014,0xd2020015,0x50845005,0x0abea003}},	// [b70] _foi__de_, _masihi_, _септембр_године_, _kukho__iindlela_,
   {{0x94352014,0x5750f00e,0x26dcc010,0xd46ab004}},	//   _de__feito_, _ལེན__བྱེད_, _de__benefici, _com__sua_,
   {{0x47154004,0x8d262013,0x86616007,0xa2a88011}},	//   _seguranç, _napomene_, _zaměstná, _kule__moto_,
   {{0x54426004,0x5224d005,0x9b086027,0x06b51004}},	//   _nao_, _preko_, _terpaksa_, _assistên,
   {{0xc4b1b010,0x9a39900c,0x00000000,0x00000000}},	//   _ser__una_, _भी__उपलब्ध_, --, --,
   {{0x02eaa005,0x9b58d00a,0xf6f8d00a,0xabd2800c}},	//   _stanovni_iznosi_, _रहलन_, _रहला_, _काम__की_,
   {{0xb4352014,0xa2ea5011,0xe2e1a003,0x447e7004}},	//   _de__xeito_, _julius__malema_, _qiniseki_ukuba_, _atenção_,
   {{0xf2d43011,0x00000000,0x00000000,0x00000000}},	//   _uma__ngabe_, --, --, --,
   {{0xe7ee3030,0x0c66e00c,0x00000000,0x00000000}},	//   _betaling, _है__जिसे_, --, --,
   {{0x7e8a9016,0x8a3ee01e,0xe4b7002a,0x6d726007}},	//   _प्रतिशत_, _फिर_, _menneske_er_, _náměstí_,
   {{0x7b282024,0x931b900d,0x773de004,0x548a5007}},	//   _གདོང_, _názov_, _ciência_, _které__se_,
   {{0xec48d002,0xb2735005,0x6ce3100e,0xdcc96005}},	//   _रहीं_, _mesto__godine_, _སྟོང__འཁོར_, _краљевин,
   {{0xbe3d700b,0x9bdcc00e,0xe40f000d,0x929d400e}},	//   _ལོ__བརྒྱའི_, _རེད__མི_, _na__serveri_, _བྱེད__ཐབས_,
   {{0x04ac8033,0xb9c08003,0x0bb4600c,0x00000000}},	//   _med__det_, _oko__kuthetha_, _अर्थ__है_, --,
   {{0xc3ff8017,0x19cd2004,0x8cee0005,0x00000000}},	//   _lanzado_, _homenage, _хрватске_, --,
   {{0x1a43701d,0xc6c5f023,0xd798300e,0x24c3102a}},	//   _veljača_, _sebahagi, _ཁྱོན_, _produkte_og_,
   {{0xe291200f,0xeae0200e,0x42d2f004,0x88137004}},	// [b80] _ibya_, _བྱུང__འདུག_, _os__itens_, _si__próprio_,
   {{0x8242a00e,0x9655401d,0x73807017,0xcc536021}},	//   _ཐུབ_, _namjesti, _terras_, _et__selskap_,
   {{0xd73f302b,0x02c29004,0x00000000,0x00000000}},	//   _བཀོད_, _um__jogo_, --, --,
   {{0x2e6de01e,0xa252700b,0x3f8ca011,0x00000000}},	//   _अधिकारिय, _གླིང__བཟའ_, _bale__nhlangan, --,
   {{0x3e937005,0x5b66d01b,0xc293a00b,0x64b8f007}},	//   _године__на_, _isithuba_, _གཞི__བཞག_, _proto__že_,
   {{0xa4426019,0xd56ff010,0x726cf016,0xb738300e}},	//   _sao_, _servicio_, _tohoto_, _ཁྱེད_,
   {{0xc4b6f014,0x33430014,0x65aa0004,0x7eb30014}},	//   _diminuci_en_, _dereito_, _promoçõe, _dereitos_,
   {{0x3499e02a,0x84137004,0x00000000,0x00000000}},	//   _sikker__på_, _qualquer__pessoa_, --, --,
   {{0x5d1e200f,0x9eda101d,0x83f91017,0xd317f011}},	//   _genocide_, _pasijans_, _escudo_, _umuzi_,
   {{0xc476d02a,0xdf10c005,0x30266007,0x72a64011}},	//   _bare__en_, _predsedn, _plzeňský_, _qembu_,
   {{0xa293000b,0xfffa200c,0x827bb011,0xd4713004}},	//   _ནིའི__དོན_, _को__प्राप्त_, _ukuthi__inkosi_, _uma__das_,
   {{0xc2d8c03b,0x9ce3400c,0x42725005,0x9b401005}},	//   _bilete_, _तो__आपको_, _због__тога_, _енглески_,
   {{0x02a9600b,0x00000000,0x00000000,0x00000000}},	//   _བཟོ__ཡོད_, --, --, --,
   {{0xbb809005,0x12f1202d,0xc394903f,0x9243700e}},	//   _је__насеље_, _जरुरत_, _čase_, _ཕུང_,
   {{0xdf3bd01c,0xc2fe601c,0x7be7300e,0x02630018}},	//   _kebutuha, _merilis_, _སླར__ཡང_, _དག__གིས_,
   {{0x34baf021,0x54900010,0x0bf9d00b,0x80b1b005}},	//   _inn__på_, _el__uso_, _རེ__ལུ_, _станишта_,
   {{0x7f8bf010,0x5c649010,0xd5373003,0xfbe2600e}},	// [b90] _qué_, _octubre_, _nemiqath, _བྱས__པར_,
   {{0x628d900f,0x23f8c022,0x94916011,0x6de7e00e}},	//   _imikino_, _saludo_, _umculi__we_, _ཀུན__མཁྱེན_,
   {{0x545d0003,0xce00c005,0x00000000,0x00000000}},	//   _wonke__umntu_, _први__пут_, --, --,
   {{0x54439004,0x336cb015,0xd571d01c,0x74b2900f}},	//   _uns_, _kapal__terbang_, _jenderal_, _miryango_,
   {{0xa9f54004,0x644f102a,0xa3892003,0xa219f005}},	//   _preço_, _stedet__for_, _kakhulu__kwaye_, _већину_,
   {{0x6b4c0007,0xc297a00e,0x44512007,0x9bd6700b}},	//   _vytvořen, _དྲུག__པའི_, _případně_, _ཚོད__ལས_,
   {{0xb490f00d,0x22730003,0x02b44007,0x0469f02a}},	//   _je__pre_, _ke__ngoko_, _vůbec_, _jeg__vil_,
   {{0x2dd0c027,0x6492a02a,0x164e6021,0x0b28300e}},	//   _di__internet_, _er__for_, _er__vanligvi, _ཁྱུང_,
   {{0x91e8a00b,0x8444500f,0xc2ba200b,0xcb279010}},	//   _ཉིནམ_, _igihe__kimwe_, _བསྒྲགས__འབད_, _de__imágenes_,
   {{0x22cb4010,0x4bef402b,0x0213a011,0x0cd72011}},	//   _pueden_, _ཀི__ལོ_, _lapha_, _ngendlel_yokuthi_,
   {{0x5242a00e,0x03088011,0x49110007,0x8ccf300e}},	//   _ཐུན_, _laba__basolwa_, _odpovída, _བཀུར_,
   {{0xc47e1014,0xe4946030,0x2eb07005,0xe290f015}},	//   _pero__non_, _må__du_, _месту__је_, _pahang_,
   {{0xcf1b901d,0x6c8e500a,0xc6be500d,0x668c300a}},	//   _miš_, _कौनो_, _súťaže_, _पुरान_,
   {{0x3dea700b,0x40c15034,0x73566023,0xa266900b}},	//   _སྟོན__དམངས_, _verktøy_, _sebenar_, _ལག__དོན_,
   {{0x8efff005,0x0201400f,0xf46f1021,0xe6de7011}},	//   _maksimal_minimaln, _rufite_, _legen__din_, _uma__kuwukuth,
   {{0x3585a023,0x189d3007,0x0bb46016,0x5c14e007}},	//   _bandaray, _soutěž_, _velkoobc, _získat_,
   {{0x0f240007,0xa934400d,0xf34c7014,0x00000000}},	// [ba0] _ovšem_, _najskôr_, _xuvenil_, --,
   {{0x3b285020,0xb3098004,0xf4e59004,0x00000000}},	//   _མྱོང_, _seu__site_, _em__relação_, --,
   {{0xc3870007,0xa2932024,0x0c12e00c,0x00000000}},	//   _které_, _དགོས__དོན_, _विचार__है_, --,
   {{0x6bd6f00e,0xa150f00c,0x649b5010,0x00000000}},	//   _འོག__ཏུ_, _नस्लों_, _además__de_, --,
   {{0xc282100b,0x82027031,0xf2d41003,0xcc970010}},	//   _བསྐྱོད__འབད_, _sisifo_, _xa__ufuna_, _el__título_,
   {{0x8c75c027,0xd46dd011,0x0eb62005,0x00000000}},	//   _menukar_, _hhayi__ke_, _систем_, --,
   {{0x12c5a01d,0xf2bf500a,0x4e74e005,0xd288c00b}},	//   _kuglice_, _जाईं_, _се__од_, _འབད__བའི_,
   {{0xd327402a,0x63c2f011,0xa4ce4011,0x83966014}},	//   _er__ikke_, _lesi__siteshi_, _iphephan_isowetan_, _persoa_,
   {{0x72dbe019,0x00000000,0x00000000,0x00000000}},	//   _de__rodas_, --, --, --,
   {{0x3442901f,0x6702500c,0xf414400d,0x3e5d4010}},	//   _saa_, _और__बहुत_, _pre__túto_, _la__necesida,
   {{0x64ad5014,0x99f3a015,0xc252600e,0xac5d9007}},	//   _xaneiro__de_, _daripada_, _ཡིན__ཞིང_, _alespoň_,
   {{0x69fc7021,0x1999a007,0x8f371005,0x1e3d1005}},	//   _dette__nettsted, _např_, _на__том_, _се__као_,
   {{0xd7c09005,0x926c201f,0x03f22005,0x2bcde00a}},	//   _се__простире_, _nuko_, _je__galaksij, _तबे_,
   {{0x12912023,0x00000000,0x00000000,0x00000000}},	//   _cecair_, --, --, --,
   {{0x74425021,0x6a4b500c,0xcd88200e,0x5578500d}},	//   _xsl_, _की__तरह_, _གདམས_, _posledný,
   {{0x3b409038,0xf53a3014,0xa9f51004,0xebad000e}},	//   _påverka_, _foi__estreado_, _bebês_, _ཏང__གི_,
   {{0xc487702d,0x51a2e004,0x00000000,0x00000000}},	// [bb0] _मिलावट_, _sua__família_, --, --,
   {{0x04b5402a,0xf32c3010,0x64786019,0x00000000}},	//   _fungerer__som_, _un__negocio_, _perto__de_, --,
   {{0x43298021,0x529f7011,0x5243600e,0x00000000}},	//   _et__lite_, _kulesi__sigaba_, _ཚངས_, --,
   {{0xd348402a,0x38e0b00c,0x00000000,0x00000000}},	//   _vil__ikke_, _इस__साइट_, --, --,
   {{0x52d8b00f,0x12e03003,0x6bcff00b,0x00000000}},	//   _indege_, _endaweni__yoko_, _ཆོག__ཇོ_, --,
   {{0x83967004,0x3256500c,0x9243000e,0xf730100c}},	//   _pessoa_, _करेंगे_, _མཛའ_, _प्रदर्शि_करता_,
   {{0x73eb8009,0x26eae00c,0x944ee007,0x1b98900c}},	//   _kartu_, _है__लेकिन_, _souvisej, _साथ__एक_,
   {{0xadc0c005,0x1b993028,0xe49aa003,0xa2489005}},	//   _који__су_, _gobierno_, _kunye__nolawulo_, _imamo_,
   {{0x63368021,0x2cf03005,0xd98bc007,0xe28db003}},	//   _noen__ganger_, _је__српски_, _nově_, _zerhafu_,
   {{0x3cc8500e,0xede6c005,0x6ee31005,0xd28db003}},	//   _མྱུར_, _становни_што_, _оно_, _yerhafu_,
   {{0x54426010,0x5478d036,0x128ef007,0x0b95700c}},	//   _eso_, _grad__se_, _které__jsem_, _बात__है_,
   {{0x0290c03b,0x92a48024,0xd46af004,0x7bdcd00e}},	//   _irland_, _བློ__གཏད_, _com__que_, _བོད__རང_,
   {{0xaed4e005,0xa2e1d00a,0x7f6b3023,0x2163c005}},	//   _то_, _बानीं_, _berbilan, _добила_,
   {{0x0b8f900a,0x00000000,0x00000000,0x00000000}},	//   _दऽ_, --, --, --,
   {{0xa37ab003,0x9dace00e,0x32dfc011,0x00000000}},	//   _unyango_, _སྤྲེལ_, _esikhath_esiningi_, --,
   {{0xd2b59010,0xa3a23004,0x1d015011,0x7275300e}},	//   _busco_, _secretár, _iminyaka__emihlanu_, _ནས__ཆོས_,
   {{0xc29c900e,0x1370a028,0x76175005,0x728db003}},	// [bc0] _སྔོན__ཞིང_, _que__ofrecen_, _železnič, _serhafu_,
   {{0x34438040,0xebf0900c,0x8a0a000d,0xcc51f005}},	//   _čr_, _देखने__के_, _štatisti, _zahteva_,
   {{0xeb8e300e,0x9d0cb00c,0xb277d016,0xc03b8010}},	//   _ཏང_, _लिए__आपको_, _oznámení_, _libros__electrón,
   {{0x3ba4e00c,0xf243a020,0xa63b4007,0x078ad00c}},	//   _कि__यह_, _གུང_, _státní_, _हैं__जिन्हें_,
   {{0xb28db003,0xf4da2005,0x00000000,0x00000000}},	//   _werhafu_, _војни_, --, --,
   {{0xd24da02b,0x0e3ce005,0x79aa2005,0x1a163011}},	//   _འབག_, _се__за_, _којих_, _naleli__phephand,
   {{0x22d8900a,0x51744004,0xb47d5028,0x533d7011}},	//   _तानी_, _família_, _para__el_, _kuze__kuphele_,
   {{0xcfb51004,0x7a281023,0x648c4022,0xe867d005}},	//   _início_, _menunggu__sehingga_, _guía__de_, _држава_,
   {{0x9316c00d,0x7dc59023,0x1be8400e,0x346d000d}},	//   _medzi_, _diiktira, _བྱོན__ནས_, _prečo__sa_,
   {{0xf62c1004,0xd347c02a,0xd319e011,0x63b4e004}},	//   _condiçõe, _var__ikke_, _amalungu__ebandla_, _algumas__coisas_,
   {{0x84097011,0x04bc9021,0xe41c7011,0xcadde00e}},	//   _lo__mqeqeshi_, _personer__som_, _kahle__ukuthi_, _དཀོན__མཆོག_,
   {{0xd3949038,0xade2400e,0x00000000,0x00000000}},	//   _trass_, _མདོ__སྔགས_, --, --,
   {{0x762af00b,0xaa28c022,0x82902023,0x26422004}},	//   _ཡོདཔ_, _cancione, _dekad_, _imobiliá,
   {{0x94349021,0xa879c004,0xebc0000b,0xf0bfb007}},	//   _veldig__viktig_, _campinas_, _ལོ__གི_, _dnešní_,
   {{0xf367c01c,0x6a29802d,0xadbf8005,0xf3878038}},	//   _berbatas_dengan_, _मनोज_, _врсте__су_, _berre_,
   {{0xd127f005,0x00000000,0x00000000,0x00000000}},	//   _сарадња_, --, --, --,
   {{0xbfec4003,0x53178007,0x3db25004,0x42d91014}},	// [bd0] _emayilan, _verze_, _escreveu_, _facelo_,
   {{0xa7781005,0x42c2d010,0xbcacf004,0x3c8bc00c}},	//   _univerzi, _un__poco_, _uma__versão_, _तुलना__करें_,
   {{0x6f1b900d,0x22a94011,0x2bdaa00b,0x727ed00d}},	//   _vašu_, _thokozan_ndlovu_, _མེད__གེ_, _zmeny_,
   {{0xb3f40021,0x0b8e400e,0x8692800c,0x00000000}},	//   _har__vært_, _ངུ_, _के__स्थान_, --,
   {{0x52b4600d,0x8262c011,0xb4b46028,0x0ee3f00d}},	//   _troch_, _ukusho__lokhu_, _por__el_, _iný_,
   {{0x32c0f005,0xf4942033,0x9b97400f,0x64ace02a}},	//   _живело__становни, _på__din_, _komisiyo_, _med__de_,
   {{0x4a50801d,0x7c68900d,0xf80cc005,0x42e77031}},	//   _vrste__porodica_, _zabudli_, _слика_, _nkundla_,
   {{0x84ea7060,0x04ad002a,0x4249600d,0x44b15004}},	//   _तथा__अन्य_, _kan__det_, _najmä_, _inscriçã,
   {{0x76fa500a,0xf4810003,0xac08a00c,0x00000000}},	//   _पनवा_, _yile__nto_, _रहने__की_, --,
   {{0xa2b2000b,0x00000000,0x00000000,0x00000000}},	//   _གས__འདི_, --, --, --,
   {{0x04509014,0xf46be02a,0xd498902a,0x5256900d}},	//   _súa__morte_, _fra__et_, _være__den_, _júla_,
   {{0x04ac802a,0x33ff5011,0x0be7d00b,0x00000000}},	//   _har__det_, _kunjalo__kodwa_, _ཐང__ལུ_, --,
   {{0x6be0100c,0xdb994007,0x4afb200d,0x00000000}},	//   _जो__आप_, _požadavk, _zverejne, --,
   {{0x93fde036,0xfba1e00e,0x33fa501c,0x8254c007}},	//   _godine__selu_, _གྲོང__ཚོ_, _satuan_, _měla_,
   {{0xe4429010,0xf497f004,0x8795601a,0xb472d010}},	//   _esa_, _relação_, _गोपनीयता_, _sobre__el_,
   {{0x124d900b,0x8474a023,0x91020005,0x00000000}},	//   _སྦེ_, _saya__atau_, _станиште_, --,
   {{0x9491d011,0x43eb7028,0xeb16d02b,0x00000000}},	// [be0] _le__anc_, _cuatro_, _མིན__འདུག_, --,
   {{0x92e1902d,0x1b8e5020,0xe2759021,0x0272a00b}},	//   _नाहीं_, _ཅུ_, _du__bruker_, _དཔ__ཨིན_,
   {{0xff79f012,0xcf21c014,0x92c1c014,0x38631005}},	//   _možeš_, _mellorar_, _mellora_, _пошаљи_,
   {{0xe5214014,0x00000000,0x00000000,0x00000000}},	//   _no__concello_, --, --, --,
   {{0x422a2007,0xe2569021,0x4c91100c,0x02f9e004}},	//   _přihlási, _som__bruker_, _याद__रखें_, _também__podem_,
   {{0x02ba7027,0x63da702a,0x7a16301d,0x64ac602a}},	//   _ini__ialah_, _du__får_, _rotacija_, _det__de_,
   {{0xb2e16005,0x7c48400c,0x73da702a,0x02b3000b}},	//   _od__nalazi_, _वाले_, _du__går_, _མོ__གིས_,
   {{0x7202701f,0xe4825011,0x19805003,0xc2e81011}},	//   _tariki_, _uthe__le_, _ezikolwe, _kushone__abantu_,
   {{0x7a3cb01e,0x63bb7021,0x12c65010,0xc28bc00b}},	//   _रूप_, _som__får_, _incluye_, _བཞག__འབད_,
   {{0x3c8ad00d,0x625ac03b,0x73bb7021,0x12f3b036}},	//   _príspevk, _mellom_, _som__går_, _periodu_,
   {{0x5c51d01c,0x00000000,0x00000000,0x00000000}},	//   _tentara_, --, --, --,
   {{0x0327b021,0x9da79023,0x3c7c4005,0x00000000}},	//   _er__enkelt_, _kerosaka, _потенциј, --,
   {{0xb3048011,0x9bcaf00b,0xda3c200c,0x00000000}},	//   _kusho__yena_, _འབདཝ__ལས_, _एंड_, --,
   {{0x7c8ad00d,0x5c0e901d,0x7aadc00c,0x7d7ef005}},	//   _príspevo, _skupite_, _होती__हैं_, _ћу_,
   {{0xa38a8004,0x8442a011,0x8a22e010,0x00000000}},	//   _fórum_, _nsb_, _los__demás_, --,
   {{0xdddf2023,0xe230600f,0x4e8b7005,0x1a92400c}},	//   _perlu__menunggu_, _umujyi_, _на__тај_, _तो__मैं_,
   {{0xa3481026,0x23eb7004,0x528a1010,0x00000000}},	// [bf0] _vijesti_, _quatro_, _más__menos_, --,
   {{0x23955004,0x8272b010,0x00000000,0x00000000}},	//   _apesar_, _sobre__cómo_, --, --,
   {{0xab8cb01a,0xc491e02a,0x2db8500e,0x9756800c}},	//   _की_, _at__en_, _དེ__རྗེས_, _और__क्या_,
   {{0xdc912004,0x147ec005,0xfbe3300b,0x529b3010}},	//   _começou_, _живот_, _ཀྱི__གླ_, _lo__mismo_,
   {{0xaa5a9014,0xeca1600c,0x0273901d,0x1ebae036}},	//   _mulleres__distribu, _से__पहले_, _na__otoku_, _južnoj_,
   {{0xec5a201d,0x6283f003,0x82486007,0x92a5900e}},	//   _ožujak_, _ngasentl, _veřejnos, _མདོ__སྨད_,
   {{0x827e9030,0x54408023,0xc2896006,0x725b7023}},	//   _blant_, _di__portal_, _ditandai_, _jualan_,
   {{0x03ebe038,0x86ff501e,0xc4b82010,0x00000000}},	//   _eitt_, _जिला_, _disponib_en_, --,
   {{0x2862d003,0x6461d010,0x7681c00b,0x00000000}},	//   _kwinkund, _más__de_, _གསུངས__ཡོདཔ_, --,
   {{0x9b9d402b,0xee9d1005,0xd266d010,0x00000000}},	//   _ཡོད__མི_, _ако_, _más__tiempo_, --,
   {{0xc6fe900a,0xfe053011,0xce55e023,0xd097e005}},	//   _टटका_, _lo__wesifaza, _perbanda, _времена_,
   {{0xf2908003,0xebfda00c,0x221d1005,0xb77cd00c}},	//   _irhafu_, _लेने__के_, _раду_, _सबसे__बड़ा_,
   {{0x6d56c003,0x7309802a,0x00000000,0x00000000}},	//   _uninzi__lwabantu_, _hele__verden_, --, --,
   {{0x44684003,0xfb8a700e,0x9ab1500d,0x50e8300c}},	//   _iindleko_, _བོད__ལྗོངས_, _telefón_, _लाइव_,
   {{0x0328300f,0xe4496021,0xb270a007,0x00000000}},	//   _na__robert_, _lenker__til_, _kromě__toho_, --,
   {{0xab8fd00a,0x6e62b005,0x7c096005,0x00000000}},	//   _हऽ_, _заједно__са_, _подручје_, --,

   {{0x5227c014,0x2a44f004,0x00000000,0x00000000}},	// [c00] _cómpre_, _de__ação_, --, --,
   {{0xf442f034,0x539ab007,0x644b5014,0x85fb8005}},	//   _lag_, _město_, _álbum__de_, _концентр,
   {{0x227e7034,0x026c3028,0x89f4c010,0x3bbcc00c}},	//   _menn_, _hijos_, _demás_, _क्या__यह_,
   {{0xeed28005,0xe3ebe034,0xa443a003,0x76f9600a}},	//   _је__био_, _sitt_, _irp_, _तहरा_,
   {{0xdb58a014,0xfaeb9023,0x2eaae005,0x527d8011}},	//   _de__cancións_, _sokongan_, _она__је_, _kodwa__wathi_,
   {{0xa2cb4014,0x6979d01d,0xda0aa015,0x6e3ce005}},	//   _que__súa_, _povijest, _manakala_, _се__са_,
   {{0xd2b79005,0x12926034,0xb3954038,0x04979005}},	//   _је__била_, _oftast_, _pressa_, _је__било_,
   {{0xc493d005,0x5546900d,0xd258000e,0x2f9f800f}},	//   _mjestu__je_, _zobraziť_, _བྱུང__བའི_, _ikarita__yinguzan,
   {{0xd9f4e00d,0x9292c00e,0xa204000d,0xe956a00c}},	//   _minút_, _རེད__མིང_, _požiadav, _की__वेबसाइट_,
   {{0x92a64011,0xf26c7008,0xc2cad01b,0x281eb00c}},	//   _kumbe_, _buno_, _nceda_, _और__उन्हें_,
   {{0x1b8fe00a,0x9317000d,0xbbbd1011,0x00000000}},	//   _सभ_, _žiadny_, _amakhono_, --,
   {{0x64677014,0x4234b003,0x63f97010,0x00000000}},	//   _produció_de_, _afumane_, _su__propia_, --,
   {{0xe4e2800c,0x96aed00e,0x00000000,0x00000000}},	//   _की__सुविधा_, _སྙིང__སྟོབས_, --, --,
   {{0x0042c011,0xe4b04023,0x55b3e007,0x02c2d004}},	//   _of__technolo, _filum__sub_, _některýc, _rondônia_,
   {{0x60458007,0x2c421011,0xcf2c100d,0x00000000}},	//   _vyhrazen, _ngomsomb_ebusuku_, _to__veľmi_, --,
   {{0xbbb8400c,0xa245900d,0x779fb00e,0x1bd3300c}},	//   _वेबसाइट__पर_, _tému_, _མཐོན_, _काम__कर_,
   {{0x82561010,0x03f4001d,0xe459300d,0x00000000}},	// [c10] _sólo_, _sustav_, _mať__na_, --,
   {{0x256d9005,0x547e5010,0x00000000,0x00000000}},	//   _напомене_, _esto__no_, --, --,
   {{0x8e3e0005,0x64655010,0x00000000,0x00000000}},	//   _корисник, _miembro__de_, --, --,
   {{0xf2e81023,0x82b67028,0x39b96005,0x00000000}},	//   _dicipta_, _trucos_, _материја, --,
   {{0xf2bb4003,0xc4702021,0x23364011,0x12a64005}},	//   _iya__kuba_, _versjon__av_, _meshack__radebe_, _резултат_,
   {{0xf243d00e,0x9dbd200f,0x4798c00e,0x065d200f}},	//   _ཞུས_, _gushyira, _གཡོན_, _gushyirw,
   {{0x8c134018,0x52484003,0xf290f00f,0xbe03f00d}},	//   _དཀར__ཆག_, _kwindawo__yethu_, _yahawe_, _keďže_,
   {{0x1ba9000e,0xc4ba1014,0x0294600b,0x23ab2011}},	//   _རྗེས__སུ_, _tamén__en_, _འབད__ཡོད_, _kube__yimanje_,
   {{0xfb9d600e,0xcbe5300b,0x4a5aa00c,0x00000000}},	//   _ཡོད__པར_, _ིམས__འད_, _कि__तुम_, --,
   {{0x8234b003,0x0f1b700d,0xa3fab004,0x00000000}},	//   _ufumane_, _odporúča, _às__suas_, --,
   {{0x667a600c,0x02520024,0xb27e7030,0x0cba6011}},	//   _पसंद_, _མཆོག__གིས_, _venn_, _ku__twitter_,
   {{0x03621010,0x00000000,0x00000000,0x00000000}},	//   _la__oficina_, --, --, --,
   {{0xa394d03b,0x6243400e,0x93178007,0xe3140003}},	//   _gresk_, _བུད_, _verzi_, _njani__ukuba_,
   {{0x22a66011,0x4443e016,0xfbc0500b,0x00000000}},	//   _ngoba_, _čt_, _ལུ__ཤི_, --,
   {{0x2622803f,0xf3dd9009,0x72d8802d,0x3267e00b}},	//   _organizá, _siswa_, _हाली_, _ཁྲིམས__ཆེན_,
   {{0x92be8011,0x948a500f,0x4fe00007,0x9b0c5004}},	//   _nelson__mandela_, _hagati__ya_, _kvůli_, _crescime,
   {{0x53524011,0x6e0cb007,0x82366013,0xb2e53010}},	// [c20] _ewestern__cape_, _vlastně_, _stoji_, _también__puede_,
   {{0x44432010,0xfb8ff00a,0xc4891005,0x5225f021}},	//   _hay_, _तऽ_, _računara__je_, _bruke_,
   {{0xc27f7003,0x1e0d2005,0x92fbf021,0x00000000}},	//   _okanye_, _све_, _vi__tilbyr_, --,
   {{0x52d8f00a,0xf2cfd007,0x627ed013,0xbc5ad013}},	//   _हमनी_, _dokonce_, _poena_, _svetski_,
   {{0x2444401d,0x6cbe100c,0x34431004,0x12c6b038}},	//   _kn_, _प्राप्त__करने_, _faz_, _fødd_,
   {{0x8cc8c018,0xc27ee021,0x150a6005,0x00000000}},	//   _གྱུར_, _finnes_, _привредн, --,
   {{0xde843009,0x0442d010,0x7237e028,0x9c51d023}},	//   _di__kecamata, _ese_, _primera_, _tentera_,
   {{0x2490e005,0xb023900d,0xe4427007,0xb3fca004}},	//   _je__pad_, _pondelok_, _měl__být_, _como__usar_,
   {{0x9202600f,0x54a3e023,0xe135f007,0xfbf6d00b}},	//   _mirimo_, _bersetuj, _poptávka_, _ོང__དང_,
   {{0x43dca02e,0x0de9e00e,0x127e9010,0x00000000}},	//   _kubw_, _བྱེད__དགོས_, _sean_, --,
   {{0xffe82040,0x4a3cc014,0x62d89026,0x7bc2a00b}},	//   _स्थानीय_, _na__actualid, _cijene_, _གཏང__ནི_,
   {{0x45c8d005,0xb4bb5004,0x6bcf500c,0x00000000}},	//   _средњој__надморск, _mais__do_, _जहाँ__आप_, --,
   {{0x31fda007,0x036a7014,0x33eb401d,0x71719011}},	//   _vyhledáv, _foi__nomeado_, _sretan_, _lesi__sikhundl,
   {{0xe26d8010,0x2988c029,0x32a71007,0xbab19005}},	//   _otro_, _bankkont, _stavební_, _области_,
   {{0xf443100d,0x82a8c003,0xb473e00d,0x34c3500d}},	//   _raz_, _ukuze__ufumane_, _ste__to_, _jedná__sa_,
   {{0x64ad602a,0x9c49c00a,0xd4b3a014,0x473bf00e}},	//   _kan__de_, _नईखे_, _por__mor_, _ཐུབ__བསྟན_,
   {{0xe2e04003,0x6bcde00a,0x4cc80007,0xc47ca010}},	// [c30] _qiniseka__ukuba_, _तबो_, _změny_, _para__los_,
   {{0xec49900c,0xc2e6e012,0x6e45d01f,0xd2d9901a}},	//   _पहले_, _za__vrijeme_, _kugaraga, _पहली_,
   {{0x3291d005,0x6f24500d,0x0d2d9007,0xb2647011}},	//   _живјело__становни, _práca_, _napište_, _uthe__akukho_,
   {{0x926ce003,0x746ae00d,0x12d8c01d,0xd465f022}},	//   _iifom_, _ako__si_, _ajde_, _posible__que_,
   {{0xfbb8500b,0xd5815004,0x4278c00e,0x7dd6a00b}},	//   _ནི__དང_, _associaç, _ཏཱ__ལའི_, _ཡོངས__ཚོགས_,
   {{0xf26c2003,0xebd2b00e,0xd1e1001e,0x64502021}},	//   _ziko_, _ཞིག__གི_, _जागरण_, _viktig__for_,
   {{0xa0fc800a,0x92da4003,0x1bdcf018,0x00000000}},	//   _बनावल_, _okweli_, _བཅོ__ལྔ_, --,
   {{0xa3694027,0xd26c3010,0x79ca800e,0xcf31d005}},	//   _daripada__yang_, _hijo_, _རིའི_, _хероји__југослав,
   {{0xc2bc0061,0xb495e033,0xd33c5023,0xd654d005}},	//   _फागुन_, _på__at_, _lebih__dikenali_, _су__слатково,
   {{0xd2360026,0xc4bc5021,0x932ac006,0x00000000}},	//   _prije_, _bruk__av_, _provinsi_, --,
   {{0xd248d038,0x94444019,0xaad64004,0xc4b43010}},	//   _kjem_, _rn_, _criança_, _son__los_,
   {{0xe499f021,0xa273a02f,0xb2801011,0xf2d3800f}},	//   _ut__til_, _zakázané_, _kube__nzima_, _ariko__ntabwo_,
   {{0x6faf101c,0xf495e02a,0x54ad602a,0xfd09902d}},	//   _desa__keluraha, _på__et_, _kan__se_, _महुआ_,
   {{0x0af1f021,0x1179200d,0x6bee1005,0x1c83800c}},	//   _webserve, _španiels, _тако_, _की__बिक्री_,
   {{0xb491b021,0x437ad021,0x9942f00d,0xc4b3b010}},	//   _er__bra_, _av__høy_, _nahlásen, _por__los_,
   {{0xa2247008,0x5f248028,0xc1898015,0x00000000}},	//   _canke_, _de__noticias_, _membekal, --,
   {{0x1291d03a,0x645c5014,0xcb8cb00e,0x37189017}},	// [c40] _mbwa_, _ademais__de_, _བེ_, _arqueoló,
   {{0xb2a6901b,0x14b31036,0xc472d021,0x9c79e013}},	//   _ngaba_, _kapacite_od_, _laget__av_, _srpskom_,
   {{0x926c3010,0xd3ead00d,0x0497002a,0xff91300c}},	//   _dijo_, _azet_, _så__det_, _के__तरीके_,
   {{0xe464d005,0x24f5300f,0x8b42f00d,0x3200c014}},	//   _objašnje_na_, _itumanah, _topoľčan, _femias_,
   {{0xe46de02a,0xe3fa7011,0x2e927005,0x33869013}},	//   _dette__er_, _abantu__ukuthi_, _клуб__из_, _stari_,
   {{0x9693400c,0xb47fd028,0x32c0c011,0xb4a8a00d}},	//   _के__दौरान_, _pero__el_, _angaphez_kuka_, _softvér__pre_,
   {{0xebab600c,0xb03a300e,0xebae700b,0x5a4a2007}},	//   _कि__वे_, _འགྲམ_, _དང__ིག_, _to__není_,
   {{0x0bb1000c,0xb3f0602a,0x4e20a014,0xec142004}},	//   _यह__है_, _mange__andre_, _alemáns_, _uma__tendênci,
   {{0xb371b032,0x74b96021,0xd2c9800f,0xf6cd1004}},	//   _no__mercado_, _ikke__noe_, _gukora__ikintu_, _cidadani,
   {{0x63580011,0x0bb1400c,0x00000000,0x00000000}},	//   _kulesi__siteshi_, _हम__सब_, --, --,
   {{0xe4297011,0xe25b7005,0x34936010,0x3a3dd01a}},	//   _bazi__ukuthi_, _stalno_, _es__lo_, _सड़क_,
   {{0xf43a0021,0xa443d00f,0xf3f51014,0xb46aa011}},	//   _en__titt_, _frw_, _se__atopa_, _kahle__uma_,
   {{0x54936014,0xd2d83007,0xce292005,0x00000000}},	//   _na__no_, _nejen_, _кад_, --,
   {{0xc3736031,0xb9f6502c,0x52c43011,0x64912004}},	//   _kumazwe_, _latín_, _undunank_wakwazul, _do__mar_,
   {{0x347b7021,0x22e14021,0x6243700e,0xe6f8100c}},	//   _seg__på_, _et__utvalg_, _ཕུད_, _लेना_,
   {{0xac91600c,0xbbfbf00c,0x6bd5b007,0x00000000}},	//   _दिनों_, _आमतौर__पर_, _více__informac, --,
   {{0xc2a16011,0x00000000,0x00000000,0x00000000}},	// [c50] _ukuthi__ukwazi_, --, --, --,
   {{0xb3ed6021,0x21d9600a,0x532c9005,0x00000000}},	//   _den__andre_, _तहार_, _просечна_, --,
   {{0xa4622023,0xa28bf003,0x2dece011,0x7d7a1003}},	//   _lima__ayat_, _ebizwa__ngokuba_, _iphephan_isolezwe_, _kwilizwe_,
   {{0x846e400f,0x89722013,0xcf3b9003,0x0ba8500b}},	//   _ibidukik, _arhitekt, _emfutsha, _ནག__ལུ_,
   {{0x9d84c011,0xb97ad00d,0x73120014,0x29de1014}},	//   _amaphoyi_akwazulu_, _ďalších_, _dúbida_, _protexid,
   {{0xc3946004,0xa2d88002,0xa35c9015,0xcd8a800e}},	//   _anos_, _हाथी_, _perkara__yang_, _རླབས_,
   {{0x62d9202d,0x08e01021,0x42bde007,0x0f3b9003}},	//   _बानी_, _innskriv, _prodám_, _imfutsha,
   {{0xe2cf8005,0x3f00000c,0x6cc6400c,0x00000000}},	//   _narodni__heroji_, _एक__अधिक_, _पूरा__करने_, --,
   {{0x72d5602c,0x14a08005,0xc2c37004,0x00000000}},	//   _vitoria_, _по__домаћинс, _um__novo_, --,
   {{0x48d06062,0xe2409011,0x725a0038,0x2b9a200c}},	//   _पश्चिम_, _kanti__futhi_, _skil_, _बार__जब_,
   {{0xe31c2011,0x93076023,0x6c73c00c,0x6481d004}},	//   _sandile__makhoba_, _jenayah_, _बहुत__सारे_, _site__de_,
   {{0x0c52100f,0xb65e1005,0x829e1005,0xc4c2d010}},	//   _amateka_, _писмо_, _писао_, _debido__la_,
   {{0xc26c2024,0x13f9600f,0x02d1800b,0x6485d011}},	//   _ལྔ__པའི_, _ingufu_, _བཤདཔ__ཨིན_, _zonke__izinhlak,
   {{0xdd47b016,0xf8f4900d,0x00000000,0x00000000}},	//   _dispozic, _všetkých_, --, --,
   {{0x0719d005,0x863b4007,0x91fe200d,0xebb9f00c}},	//   _stanovni_opština_, _právní_, _diskusné_, _परिवार__के_,
   {{0xe4198023,0xc2d8a026,0xb245500d,0x00000000}},	//   _dicipta__untuk_, _cijelu_, _týmto_, --,
   {{0xcdc7300d,0xac6f700f,0x7387e036,0xf291200f}},	// [c60] _kliknite_, _afurika_, _metra_, _icya_,
   {{0x5c5e201d,0xb1e1a00d,0xa2d8c021,0x1473000d}},	//   _te__obiteljs, _niektoré_, _filene_, _tom__čo_,
   {{0xb2b92002,0xc108500d,0x6228c01d,0x00000000}},	//   _बाबू_, _užívateľ, _vještine_, --,
   {{0x9f53f038,0x6d22500b,0xced59007,0xed717026}},	//   _frå_, _སྐུ__འཁོར_, _což_, _promatra,
   {{0x8242a00e,0x645a6014,0x0493602a,0xc46be00d}},	//   _དེར_, _poboació_de_, _og__som_, _každý__kto_,
   {{0xee3ce005,0x0254c007,0x230f702c,0x00000000}},	//   _се__да_, _měli_, _órbita_, --,
   {{0x4d8c901c,0x6a41f021,0x343e8033,0xc2b04011}},	//   _mayorita, _til__nettsted, _om__dette_, _amalunge_abantu_,
   {{0xbc48900a,0xc3f4701c,0x346bf021,0x241f6003}},	//   _साथे_, _sastra_, _uansett__hva_, _sesikhok,
   {{0xab56d023,0x42b1e017,0x8c01700d,0x5f6d900d}},	//   _sentiasa_, _fundada_, _webovú__stránku_, _sa__zdá_,
   {{0xb3a34003,0xc26cc004,0x3b53d015,0xb2ce0021}},	//   _phepha_, _tudo_, _dalam__golongan_, _du__finner_,
   {{0x4e559038,0x16d5e015,0xf2ac000b,0x6477b004}},	//   _osmanske_, _berbandi, _པས__ཟེར_, _milhões__de_,
   {{0x03946010,0x64926005,0xb2b9800c,0x0328302a}},	//   _unos_, _je__on_, _यहां_, _et__enkelt_,
   {{0x93f9000f,0xf26b802b,0x515c2005,0x00000000}},	//   _kibuye_, _ཅི__ཟེར_, _лука_, --,
   {{0x6b8ee018,0x93e4c007,0x94ad1021,0x133df015}},	//   _ཏུ_, _děti_, _gir__deg_, _dan__boleh_,
   {{0x8e0f100b,0x2cca2020,0xf3463003,0xe4b8500f}},	//   _རིངས__ལུགས_, _སྒོར_, _olu__lwazi_, _ibikorwa__bya_,
   {{0xb2abe021,0xe4421005,0xc22a4008,0x94752011}},	//   _budding_, _metra__površina_, _abajenam, _jikelele__we_,
   {{0xb224900d,0x22c42007,0xc4b33010,0x00000000}},	// [c70] _inak_, _úrokové__sazby_, _son__una_, --,
   {{0x0ba5b00c,0x1bc7900e,0x8a75000c,0x546da004}},	//   _है__और_, _བཏང__ནས_, _रहे__हों_, _pessoas__se_,
   {{0xc4926063,0x0bec2014,0xc9cc2014,0x4d8f603d}},	//   _en__en_, _vermello_, _vermella_, _umhlanga,
   {{0x6301801d,0xb618c005,0x00000000,0x00000000}},	//   _trebate_, _заједнич, --, --,
   {{0x12d9600a,0x23f9001b,0xb277900d,0xbe2ec022}},	//   _भउजी_, _sibuze_, _účtovníc, _que__necesita,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7b77300b,0xa2d1a00d,0x89e1a00d,0xc877d007}},	//   _ཞིབ__གདོང_, _človek_, _človeka_, _říká_,
   {{0x7443f038,0xdfc70007,0x8ccf8007,0xb9483017}},	//   _tru_, _článek_, _dvě_, _escritor_,
   {{0x431bc03a,0x43dde00f,0xe7db3036,0xd498000d}},	//   _kwiyamam, _witwa_, _zapadnoj_, _to__ako_,
   {{0xc2925021,0x63063021,0xec10700c,0x6befa011}},	//   _antall_, _bla__gjennom_, _विकास__के_, _lezi__zinhlelo_,
   {{0xd0a6200a,0x23ced007,0xd189c003,0x10f98003}},	//   _रामभरोसा_, _slevy_, _kwibakal, _wokhusel,
   {{0xa394004e,0xc28e2011,0x4395801c,0x6429c015}},	//   _pris_, _ukuthi__abantu_, _kursi_, _kumpulan_,
   {{0x3ef0e005,0x9ab17003,0xe4725004,0x00000000}},	//   _им_, _kwixesha_, _sucesso__na_, --,
   {{0xe7e79055,0xa9c0f007,0xb201202c,0x6dce6005}},	//   _संपर्क_, _zejména_, _ácido_, _више_,
   {{0x0b8d501a,0xc4b3602a,0xa202501d,0x5c57e00c}},	//   _और_, _til__en_, _vrtite_, _के__सबसे_,
   {{0xf26c700f,0x54a4502a,0x30f98003,0x527a8011}},	//   _hino_, _handler__om_, _yokhusel, _uphinde__wathi_,
   {{0xc26d5035,0x00000000,0x00000000,0x00000000}},	// [c80] _ingoma_, --, --, --,
   {{0x7bbab02b,0x54b1f003,0x3d292036,0x0a48d00c}},	//   _ལས__ཁང_, _yamva__nje_, _ilustrac, _समय__में_,
   {{0x20e74010,0x248f5021,0xd469800d,0xcc4b300c}},	//   _proyecto, _mellom__og_, _rovnako__ako_, _लिए__सही_,
   {{0x1a5ca005,0x2ebcb036,0xd4aa200f,0x0276000b}},	//   _galerija_, _prvobitn, _ububiko__bwa_, _ལོ__གིས_,
   {{0x7ed25005,0xc4926022,0xf4eeb005,0xc288b011}},	//   _да__се_, _en__un_, _stanovni_prosečna_, _umuzi__wakhe_,
   {{0x7e8d6005,0xcee7901b,0x2241900a,0xf495e00d}},	//   _ће__се_, _ngokuban, _पहुँचल_, _sa__im_,
   {{0xdb8d502d,0x6c73500e,0xa48cc004,0xbbdb400c}},	//   _छी_, _མཚོའི_, _da__web_, _कंप्यूटर__पर_,
   {{0xff01c005,0x64806014,0x82d9200f,0xc3946031}},	//   _како__би_, _conxunto__de_, _njye_, _khosi_,
   {{0xc24da00b,0x92132016,0xe41e6011,0x6d93900e}},	//   _འབད_, _archiv_, _ngicaban_ukuthi_, _རྣམས__ཀྱིས_,
   {{0xf495c00c,0xf41aa00d,0xfbe3b00b,0x073c7005}},	//   _के__द्वारा_, _napriek__tomu_, _གྱི__གླ_, _комуника,
   {{0x64438010,0x0dbc501d,0x6bcde00c,0xae0d2005}},	//   _mar_, _izbacite_, _सभी_, _две_,
   {{0xfc48f00a,0x0c88f00a,0xd2d8f00a,0x42e06007}},	//   _हमरे_, _हमरो_, _हमरी_, _jednoho_,
   {{0x1b8d601e,0x00000000,0x00000000,0x00000000}},	//   _कर_, --, --, --,
   {{0xf2a69011,0x04aa702a,0x4b083036,0xe2b7f00b}},	//   _ngabe_, _det__vil_, _geografs, _ོང__འཐབ_,
   {{0x3fcd9005,0x23c5e004,0x6471d014,0x72c43023}},	//   _од__стране_, _paraná_, _fillo__de_, _menerusi_,
   {{0x93949010,0xe4aa702a,0xfc51e004,0x64761004}},	//   _unas_, _det__til_, _leitura_, _garantia__de_,
   {{0xa3209003,0xeaca3020,0x522b100f,0x64967022}},	// [c90] _kwaye_, _འགོག_, _ikomeye_, _compañía_de_,
   {{0xf4ab2033,0x8dbb600e,0x82379011,0x0296800a}},	//   _med__din_, _དུ__ཕེབས_, _kunazo__zonke_, _निहोरा_,
   {{0xa2a3300b,0x2a736014,0x3324900f,0x1475a007}},	//   _ིམས__འདི_, _ningunha_, _ikintu__cyiza_, _informac_tom_,
   {{0xdb692030,0x7ab3800c,0xa461303b,0xb6f9f00a}},	//   _profilen_, _जाते__हैं_, _arbeidsk, _बहरा_,
   {{0x827d202b,0x6c69e01c,0x00000000,0x00000000}},	//   _བདག__དབང_, _korupsi_, --, --,
   {{0x427ef038,0x9258900b,0x83566011,0xabcbc020}},	//   _segn_, _འབྲུག__ཐིམ_, _unkk__helen_, _བཅད__དེ_,
   {{0xe295f015,0xa4916011,0x03565014,0x00000000}},	//   _terkini_, _co__za_, _igrexas_, --,
   {{0xa26c7010,0x00000000,0x00000000,0x00000000}},	//   _sino_, --, --, --,
   {{0x30550036,0x6315000f,0xd200f00f,0x1225b007}},	//   _sopstven, _kuri__none_, _ishize_, _mobilní__telefony_,
   {{0x54439010,0x8f2f1021,0x6aef1021,0xee6a0005}},	//   _las_, _annonser_, _annonsen_, _могу__да_,
   {{0x0d37b00e,0x527ef030,0x825d0011,0xf491f02a}},	//   _མི__འབོར_, _tegn_, _nsuku__zonke_, _er__tre_,
   {{0x74439004,0x64ba3005,0xf3e6900d,0xa25ad007}},	//   _nas_, _skeniran_iz_, _túto_, _zcela_,
   {{0xc280601d,0xb4746005,0x9f53900d,0xfeb8e005}},	//   _kockice_, _sve__do_, _mať_, _би_,
   {{0x62572007,0x1ec6c005,0x00000000,0x00000000}},	//   _dále_, _садржај_, --, --,
   {{0xea995026,0xe41ff011,0x99fe5004,0xca588019}},	//   _južnoafr, _uvumile__ukuthi_, _curitiba_, _de__computad,
   {{0x203de004,0x9e6b0013,0x00000000,0x00000000}},	//   _anúncios_, _rečima_, --, --,
   {{0xd4439004,0xdbfbd02e,0x2a33600a,0x9be1a00e}},	// [ca0] _das_, _shingiro_, _करब_, _འབྲས__བུ_,
   {{0xb7a2a00e,0x92968011,0x3491700d,0xace4c00b}},	//   _པར__འདོད_, _kukho__konke_, _by__mal_, _བཀྲམ__སྤེལ_,
   {{0xa3609006,0xd29de012,0xb25c3003,0x0f5f2023}},	//   _lainnya__yang_, _svijeta_, _ityala__lakho_, _keupayaa,
   {{0x8d8a800b,0xd490b03b,0x4354d010,0x9bf9f011}},	//   _རིངས_, _området_, _tenemos_, _isithomb,
   {{0x1277002b,0xc46a3004,0xfbd9a00c,0x00000000}},	//   _ཁེ__འབབ_, _das__às_, _की__आयु_, --,
   {{0xdbcde00a,0xb992e01b,0x7d57801e,0x0c71800c}},	//   _सभे_, _kuthetha_, _महंगाई_, _इसके__बारे_,
   {{0x6b413016,0xe2d1802b,0x99462005,0x6bdd700c}},	//   _pravidla_, _ཚོགས__སྡེ_, _састав_, _यदि__वह_,
   {{0xf3f96019,0x226c4013,0x54723010,0x00000000}},	//   _alguns_, _samom_, _que__las_, --,
   {{0x2be6000e,0x00000000,0x00000000,0x00000000}},	//   _སྨོན__ལམ_, --, --, --,
   {{0xeba3a00b,0x3fc0b007,0x5439e021,0xe9214007}},	//   _འབྲུག__གི_, _stránek_, _er__alltid_, _aktivní_,
   {{0xdbfc6021,0x227a3027,0x4ed82007,0xacb70007}},	//   _konfigur, _adalah__lebih_, _budějovi, _května_,
   {{0x2b0cf01d,0x31595007,0x7b495021,0xa306a010}},	//   _proslije, _doplňky_, _den__viktigst, _del__árbol_,
   {{0x10477064,0x00000000,0x00000000,0x00000000}},	//   _विकल्प_, --, --, --,
   {{0xb4444032,0xe465a02a,0xa2ce4011,0x6479e004}},	//   _br_, _hvordan__du_, _nqobile__mbonambi_, _ponto__de_,
   {{0x23eae006,0x2d08b02c,0x4bf0c00e,0x00000000}},	//   _banten_, _noroeste_, _བར__ལོ_, --,
   {{0x5b8c802d,0x54bdd011,0xdb009003,0x9200f00f}},	//   _ओह_, _kuka__no_, _ukusetye, _ushize_,
   {{0xc4b96005,0xb49be021,0xacca200c,0x96ba800c}},	// [cb0] _vrste__je_, _ut__at_, _आसान__नहीं_, _विषय__वस्तु_,
   {{0xc2e76012,0x2fab501c,0x42369016,0x00000000}},	//   _to__vrijeme_, _gubernur_, _kraje_, --,
   {{0x92cde014,0x1ec95005,0x8bc0e00e,0xfd392007}},	//   _unha__nova_, _ilustrac_stranice_, _ལྷ__སར_, _pro__začátečn,
   {{0x5439c014,0x1a19c014,0x00000000,0x00000000}},	//   _traballo_, _traballa_, --, --,
   {{0xc9858025,0x629bf003,0xc353300a,0x6322600d}},	//   _टाइम्स_, _amanqaku__akho_, _आवेला_, _týchto_,
   {{0x5c2f900f,0xca59000d,0xd9cc501d,0x33dc300d}},	//   _cyangugu_, _inzercia_, _smjestit, _tí__ktorí_,
   {{0xe9de3010,0x01745004,0xb67fd00a,0x79807007}},	//   _contenid, _polícia_, _इयाद_, _péče_,
   {{0xeba6a00c,0x1057801c,0x1296c00b,0xf20ec005}},	//   _प्रकार__के_, _tiongkok_, _འོང__འབབ_, _данас_,
   {{0x83954023,0x646de021,0x00000000,0x00000000}},	//   _stesen_, _hva__de_, --, --,
   {{0x227e7029,0xc4ad6033,0x2dfa300b,0xc28f500e}},	//   _finne_, _for__dem_, _འགྱོ_, _ཐུབ__པའི_,
   {{0x32925037,0x54806011,0xd6c41005,0xea10c00d}},	//   _butare_, _muva__nje_, _југослав_младост_, _redakcia_,
   {{0x2280c00e,0xfebac005,0xd48df00d,0x5a43700c}},	//   _ལོ__ལོར_, _могли_, _ak__ide_, _एक__ऐसा_,
   {{0xc444403f,0x3bef100c,0x93cf7013,0x9229a00f}},	//   _sr_, _करें__जो_, _glavna_, _amaranga__mutima_,
   {{0xc47d0005,0xde27e007,0x2ecba003,0x2be1300c}},	//   _stepenom__je_, _nápověda_, _ubungqin, _पी__एस_,
   {{0xe3706006,0x32e75011,0xe202601f,0x9b58200a}},	//   _relatif_, _ukuthi__kumele_, _birimo_, _लगलन_,
   {{0x0c08e00c,0x3245b007,0xede5200f,0x3a46c007}},	//   _सकता__है_, _tímto_, _nkuko__bisanzwe_, _se__také_,
   {{0x73e5d014,0xb243000e,0x22187011,0xd2ce8011}},	// [cc0] _de__véxase_, _མཚར_, _abanye__bethi_, _inkosi__yamaqadi_,
   {{0xc4a9702a,0x6d61002a,0x9bbf400c,0x00000000}},	//   _den__nye_, _og__struktur, _जानें__कि_, --,
   {{0x9301c005,0x52f91005,0x00000000,0x00000000}},	//   _detaljni__podaci_, _потребно_, --, --,
   {{0x2491a02a,0x8a5d6007,0xc47ed007,0x00000000}},	//   _du__kan_, _zpráva_, _tady__je_, --,
   {{0xe4896021,0x52bb6019,0xbbf6c00c,0x6b91a011}},	//   _brukes__til_, _comente_, _अभी__तक_, _isinqumo_,
   {{0x4355a005,0x32a6d014,0x00000000,0x00000000}},	//   _sa__dodatim_, _probas_, --, --,
   {{0x1f4f8011,0x4396601c,0x8bf5200e,0x64168013}},	//   _ngesikha, _persen_, _པར__བྱ_, _površini_,
   {{0x1d96200b,0xafb13005,0x17f49005,0x00000000}},	//   _གསུང__གྲོས_, _veroispo, _гласање_, --,
   {{0xfbdab020,0x6be3902b,0xa2b3000b,0x0348b011}},	//   _ཐམས__ཅད_, _པའི__ཁར_, _ཚན__འདི_, _colonel__vincent_,
   {{0xd3169007,0x1f9ac010,0x00000000,0x00000000}},	//   _praze_, _los__detalles_, --, --,
   {{0xa2b46011,0x3f5b7013,0xced3e007,0x545e9010}},	//   _itumelen_khune_, _komandan, _od__společno, _también__se_,
   {{0x1c62501d,0x9b9be00e,0xf1f25004,0xf25ad01b}},	//   _šarene_, _དོན__ཏེ_, _planejam, _iqela_,
   {{0x2a33001a,0x95d42009,0x6797000e,0x3a61300c}},	//   _टीम_, _membutuh, _ཐག__གཅོད_, _आपकी__मदद_,
   {{0xb2be200c,0xbbb8f00b,0xe759d01a,0xb468a004}},	//   _क्रं_, _ནི__ཚུ_, _फिल्मों_, _comprar__um_,
   {{0xe2d2901b,0x7106a011,0x7ea09011,0x42a7200e}},	//   _nje__ukuba_, _kulesi__sikhundl, _kuma__olympics_, _སྲིད__ཇུས_,
   {{0x9fb9600d,0x72e90011,0x64b6d010,0x534d3005}},	//   _môže__mať_, _imali__eningi_, _idea__de_, _преузето_,
   {{0x4f6dd005,0xf46b8026,0x817a7005,0x16ce8004}},	// [cd0] _са__објашњењ, _kao__dio_, _се__састоји_, _aniversá,
   {{0x7ab7000c,0x00000000,0x00000000,0x00000000}},	//   _रहते__हैं_, --, --, --,
   {{0xf33b300a,0xc473e021,0xf2be500d,0x41b9a00a}},	//   _भोजपुरी_, _avhengig__av_, _predám_, _मानल_,
   {{0x645b103d,0xa474e007,0x42eb6010,0x00000000}},	//   _isidingo_, _tom__co_, _el__día_, --,
   {{0xe616e003,0x7ab1d003,0x5c56c00c,0x00000000}},	//   _ezikwi__intaneth, _kwexesha_, _बना__सकते_, --,
   {{0xd2d95008,0xee8f6012,0x1225f038,0x980cc005}},	//   _ingene_, _promijen, _bruka_, _слику_,
   {{0x7bc33047,0x6446d014,0xac48901e,0x729dc015}},	//   _घरी_, _finado__de_, _देने_, _pelbagai_,
   {{0x19fe3003,0x8a32902d,0xdc48400a,0x6464a010}},	//   _kunye__nomhlaba_, _गुन_, _लेवे_, _algunas__de_,
   {{0x0ba8d00b,0x94aaa023,0xc2c3f014,0xf48a200f}},	//   _ནང__ལུ_, _faham__apa_, _un__novo_, _mugihe__cya_,
   {{0x92da6040,0xe280b007,0x3341f00f,0xd292a024}},	//   _hotelu_, _diskuse_, _iyariyo__yose_, _གིས__དཔེ_,
   {{0xd4bc4014,0x52bb6004,0xd200f00f,0xabdfe024}},	//   _non__só_, _somente_, _yahise_, _འཛིན__དེ_,
   {{0xc6f9400a,0x14439034,0x0bfcf00e,0x7ddc0024}},	//   _हमरा_, _oss_, _ཐོ__འམ_, _འཛིན__གྱིས_,
   {{0xa3eae006,0xa27f4023,0x5491b010,0x56394014}},	//   _mantan_, _agensi_, _en__las_, _diminuci,
   {{0x448e6014,0x9438a021,0xb66f5005,0x6e26a00e}},	//   _dentro__da_, _en__viktig_, _punoletn_stanovni, _དབྱིབས_,
   {{0xe4168005,0x1748200c,0xfbddb00e,0xdc17100c}},	//   _površina_, _प्रयोग__किया_, _དགོས__པར_, _आप__अभी_,
   {{0x9a21e023,0x44bd5014,0x934aa02a,0x9228100f}},	//   _sebahagi_daripada_, _logo__da_, _en__ting_, _kanda__kuri_,
   {{0xa0b1c005,0xf4ae102a,0x9492d011,0x749c2005}},	// [ce0] _график__промене_, _men__jeg_, _ne__anc_, _члан_,
   {{0x1be1600e,0x64a95059,0xd07c700c,0x00000000}},	//   _དྲུང__ནས_, _ajuda__de_, _लिए__अनेक_, --,
   {{0xc31b8003,0x84278007,0x345b9004,0x52bef010}},	//   _kwaye__ucofe_, _pokud__jsou_, _fazê__lo_, _una__idea_,
   {{0x693ec02a,0xe2569021,0xebf6b00c,0xd789c02b}},	//   _fremtide, _som__brukes_, _में__इस_, _འཆར__བཀོད_,
   {{0xe240100a,0xc3ce5032,0xd2d9400a,0x13784011}},	//   _भोजपुरिय, _silva_, _दाली_, _amaphoyi_aphenya_,
   {{0xb398a00a,0xc3d62007,0x00000000,0x00000000}},	//   _हs_, _na__které_, --, --,
   {{0xf6f9102d,0xcc04d012,0x4b59f00a,0x93170014}},	//   _दाता_, _mjeseci_, _बहिन_, _grazas_,
   {{0xbc7f5004,0xb480d010,0x00000000,0x00000000}},	//   _versão_, _todo__el_, --, --,
   {{0x96fe200c,0x247a7006,0xf29f7023,0xfe46a014}},	//   _क्या_, _mengajuk, _kerjaya_, _escribiu_,
   {{0x3a3d300c,0x73249014,0x626c800f,0x82992020}},	//   _हूँ_, _da__igrexa_, _buhoro_, _པའི__ཚིག_,
   {{0x6588e004,0x2ed4e005,0x02931021,0xf308700f}},	//   _obrigató, _им__је_, _ved__bruk_, _ushobora__kuba_,
   {{0xe4ab5003,0x1c49200a,0xe3e4902a,0x0288b00e}},	//   _naziphi__na_, _बाडे_, _en__person_, _ཞིག__གིས_,
   {{0x0ab9d00c,0x97f2700d,0x34b46010,0x4eb16011}},	//   _रूप__में_, _možnosť_, _por__lo_, _maqondan,
   {{0x83d52021,0x94ad9021,0x9a068014,0xf472c007}},	//   _du__blir_, _lar__deg_, _localiza_, _tom__jak_,
   {{0xe3877038,0x5ac7e01d,0x51cfb023,0x66c9500a}},	//   _starta_, _čelični_, _semenyih_, _हालि_,
   {{0xd4ada02a,0x924d6026,0xec77b01d,0x4c049036}},	//   _for__den_, _još__uvijek_, _spasite_, _srpskih_,
   {{0x6d8af00e,0xa442900d,0x32485040,0xc242a020}},	// [cf0] _རྣམས_, _iba_, _velmi_, _དེས_,
   {{0x42c1502a,0x349b7021,0xc29c600e,0x5bdfb029}},	//   _en__måned_, _ha__på_, _སྔོན__གྱི_, _indekser,
   {{0x22eef003,0x8212d004,0x83eab034,0x5312f019}},	//   _phantsi_, _melhor_, _goethe_, _para__obter_,
   {{0x5415b01c,0x62fc0023,0x14b30005,0x7a65000c}},	//   _menunjuk_bahwa_, _anda__pandai_, _има__домаћинс, _आते__हैं_,
   {{0xe4429031,0xb4ace04f,0x82cea009,0xe46b5003}},	//   _mba_, _med__at_, _yang__bisa_, _nayiphi__na_,
   {{0x5c0b600f,0xfc605014,0xf4195004,0x00000000}},	//   _umupira_, _doutras_, _um__nível_, --,
   {{0xe443e007,0x4a3d300c,0x4abca005,0x00000000}},	//   _dat_, _हूं_, _министар_, --,
   {{0xd23ff00f,0xc4736007,0x7bc3a00b,0xc382c010}},	//   _muri__firime_, _pokud__je_, _གནང__ནི_, _los__modelos_,
   {{0xf4ace02a,0xb4696023,0x83052006,0x8a4a500c}},	//   _med__et_, _alam__filum_, _mataram_, _बार__बार_,
   {{0x148b502a,0xa4671011,0xc2be202c,0x6296a010}},	//   _sammen__med_, _natal__umnuz_, _cordial_, _el__primer_,
   {{0x554e803f,0xc312f009,0x22d9200a,0x65c82021}},	//   _slovensk, _oleh__karena_, _बाती_, _webområd,
   {{0x1de9500e,0x6c11500b,0x529b800e,0x00000000}},	//   _བློ__གྲོས_, _གཅིག__ཁར_, _རྣམ__ཤེས_, --,
   {{0x845f1003,0x9f8cd004,0x5c801005,0xe41cf011}},	//   _lixesha__lokuba_, _está__procuran, _десет_, _wathola__ukuthi_,
   {{0x22fce028,0x326e3018,0x42501005,0x5c801005}},	//   _origen_, _དང__ཡུམ_, _река_, _реке_,
   {{0x348b6021,0xe2763011,0x23120010,0x00000000}},	//   _tenk__på_, _intombi__yakhe_, _superior__para_, --,
   {{0xf4a3200f,0x17a8d005,0x54603010,0x8fa66010}},	//   _ikibazo__cya_, _особа_, _qué__no_, _la__propieda,
   {{0x27c6500c,0xc8cdc004,0xb394c02a,0x9719300a}},	// [d00] _उन्हें_, _prefeitu, _hilsen_, _ठाढ़_,
   {{0x32beb00d,0xc3f4701c,0xd2fcf038,0x8e35b00b}},	//   _všetko_, _partai_, _ligg_, _ནང__བསྐྱོད_,
   {{0xd2cf900d,0x8c7f6004,0xb45c9010,0x649d6004}},	//   _kancelár, _sessão_, _será__el_, _definiçã_de_,
   {{0xc9696061,0x3200a007,0x30596002,0x12b5700f}},	//   _साँझ_, _jejich_, _साँस_, _ntacyo_,
   {{0xbb2ac00e,0x64bad036,0xb4ac602a,0x7c89200a}},	//   _སྲོང_, _popis__iz_, _det__at_, _बादो_,
   {{0xc7d0a030,0xc4b8d010,0x00000000,0x00000000}},	//   _tilgjeng, _tener__en_, --, --,
   {{0x526cf00f,0xc3ab800d,0x9b20000e,0x4c49400c}},	//   _bigo_, _najviac_, _བཙོན__འཇུག_, _हमें_,
   {{0xa2caf034,0x626ce031,0xb4afd011,0x23e41014}},	//   _bygd_, _sifo_, _lesi__sigameko_, _en__dous_,
   {{0x4b8f700b,0xf4ac602a,0x2f8d3016,0xd99c7010}},	//   _ོང_, _det__et_, _vašeho_, _los__visitant,
   {{0xe2fce034,0xdea73003,0xca6f3004,0x00000000}},	//   _krigen_, _nxuluman, _um__problema_, --,
   {{0xd4590014,0x2278e021,0x4c48400a,0x0bbe200c}},	//   _poboació_que_, _som__kommer_, _लेबे_, _प्रक्रिय_को_,
   {{0xbbd1a005,0x198e2005,0x020e2005,0xd46c3004}},	//   _године__насеље_, _ради_, _рада_, _pessoas__que_,
   {{0x6bc36002,0xc275c014,0xdc17b004,0x1807b019}},	//   _करी_, _con__máis_, _tópico_, _tópicos_,
   {{0x54736007,0xe26d8004,0x72a8700b,0x30679005}},	//   _pokud__se_, _ouro_, _ངས__གསལ_, _развој_,
   {{0x2e92d005,0x63e15011,0x944ad023,0x946d2004}},	//   _процјени__из_, _isithomb_bongani_, _kerana__ia_, _não__há_,
   {{0x6201400f,0x429dc010,0xa3949010,0x43eb7026}},	//   _bafite_, _día_, _tras_, _slatke_,
   {{0xc6a95016,0x34357021,0xaf7ab007,0x64ac3010}},	// [d10] _समेत_, _en__måte_, _upozorně, _con__sus_,
   {{0x499bd04a,0x6490d010,0x8be2b00b,0x00000000}},	//   _velkomme, _juegos__de_, _འདི__གས_, --,
   {{0x834c8023,0xa2e90003,0xe3c2a019,0x7e99202b}},	//   _yang__berbeza_, _imali__eninzi_, _que__mais_, _ཤུགས__བསྐྱེད_,
   {{0xb4bd8003,0x0186d00c,0xc3222017,0x9f0a4014}},	//   _ithunyel_ngu_, _की__तलाश_, _núcleo_, _saúdos_,
   {{0xd4b87014,0x2ea24005,0x52787005,0x00000000}},	//   _xeito__que_, _умро__је_, _turnir_, --,
   {{0x02bad011,0xd1c12005,0x00000000,0x00000000}},	//   _la__madoda_, _prikaži_, --, --,
   {{0xa269e011,0xfa181011,0x7ba8900e,0x84bd2014}},	//   _kulolu__hlelo_, _uma__kungukut, _ཁང__དུ_, _conxunto_,
   {{0x526d1010,0x8e2d1005,0xd7fcc005,0xc4b8d010}},	//   _hizo_, _број_, _улогу_, _tener__un_,
   {{0x7d54f005,0xe2d91003,0x85109003,0xca8fc003}},	//   _према__процјени_, _yenza__ukuba_, _umtshato_, _lemicimb,
   {{0x07205026,0x33e7302a,0x5a2d2011,0x4e510027}},	//   _osjećaj_, _på__disse_, _ngesikha_kwenzeka_, _sembahya,
   {{0xc25a1003,0x72b46007,0xeb94100c,0x0442e004}},	//   _umhla_, _líbí_, _दिन__के_, _acordo__com_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x9bdec00b,0xe420100f,0x7b301005,0x52501005}},	//   _སླབ__མི_, _niba__ufite_, _село_, _села_,
   {{0x72c9b011,0xc46e6007,0x00000000,0x00000000}},	//   _kulo__msakazo_, _kdo__je_, --, --,
   {{0x6f85e005,0x42d9f002,0x1491b021,0x304a100f}},	//   _gustina__naseljen, _नानी_, _av__oss_, _kwerekan,
   {{0x0436b021,0x527f5010,0x4bb1400e,0x33b3e005}},	//   _de__beste_, _tienes_, _ནས__ལོ_, _једноста,
   {{0xb2295005,0x24c5701b,0x3d23c005,0x82a3e007}},	// [d20] _dve__godine_, _imibutho_, _evropske_, _by__měla_,
   {{0x426d2008,0x04af5011,0x23e7200d,0x4b59601e}},	//   _hiyo_, _kanye__ne_, _táto_, _साइन_,
   {{0x32562005,0x0279e003,0xdb964018,0xcc48401a}},	//   _становни, _kwisikol, _དཔའ__བོ_, _लेते_,
   {{0xa2fc504a,0x4c49900a,0xf212e004,0x74c89010}},	//   _valgt_, _पावे_, _senhor_, _atención__al_,
   {{0x9bd4100b,0x985d9017,0x52d8300f,0xfbde600e}},	//   _ཡོདཔ__ལས_, _teorías_, _yemeza_, _རིམ__པར_,
   {{0x7be8900e,0x51c10004,0x0328a010,0x00000000}},	//   _གང__དུ_, _de__notícias_, _cámara__digital_, --,
   {{0x64755004,0x6b99100c,0x00000000,0x00000000}},	//   _série__de_, _समय__आप_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf2843005,0x364a6005,0x61332007,0xd26cc013}},	//   _do__kraja_, _при__лансирањ, _kvalitní_, _radom_,
   {{0x61d9400a,0x683d0007,0x52c4a00f,0xfb303005}},	//   _हमार_, _osobních_, _yo__gukora_, _делом_,
   {{0x3b8ff00a,0x64b05021,0xf386d014,0xd293a00b}},	//   _दू_, _blant__de_, _quere_, _རིག__འགོ_,
   {{0x77917005,0x1452500f,0x22d95011,0x00000000}},	//   _на__удаљенос, _ibikorwa__byawe_, _angeke_, --,
   {{0xe41e1011,0xc2a5800b,0x00000000,0x00000000}},	//   _conventi_centre_, _བཙུགས__འབད_, --, --,
   {{0x9d86c005,0x00000000,0x00000000,0x00000000}},	//   _награде_, --, --, --,
   {{0xba6c0007,0xe42bf011,0x00000000,0x00000000}},	//   _přímo_, _inkantol_ukuthi_, --, --,
   {{0x1b8fa018,0x0a71600c,0xc4b9e005,0x06ddc01e}},	//   _སུ_, _करने__में_, _mestu__je_, _पुलिस_,
   {{0xfc31400d,0x29761005,0x00000000,0x00000000}},	// [d30] _detské_, _књижевни, --, --,
   {{0xf292600d,0xa71c200c,0x00000000,0x00000000}},	//   _strane_, _का__अर्थ_, --, --,
   {{0xc24a7017,0x679ac00e,0xe22ac005,0x69c37011}},	//   _formar_, _སྲིན_, _јован_, _ngempela_,
   {{0x4e778005,0xbc5fa00c,0xd3cb9028,0x32967007}},	//   _један__од_, _को__अपने_, _de__correo_, _je__velmi_,
   {{0x73946037,0xac24c00c,0x2889b010,0x431f9010}},	//   _byose_, _और__इसे_, _las__empresas_, _de__deudas_,
   {{0x49f65004,0x7504b029,0x34bc7033,0xe4abe021}},	//   _estão_, _eksempel_, _tid__på_, _der__du_,
   {{0xc2eb9009,0x6248f013,0xa2fdd023,0x72fcb032}},	//   _di__berbagai_, _primer_, _orang__ramai_, _alegre_,
   {{0xe2ebc00f,0xd288f00b,0x00000000,0x00000000}},	//   _orinfor_, _བདག__རིན_, --, --,
   {{0xaa336047,0xa385a005,0x52fd7004,0x226e5013}},	//   _करत_, _mladost__beograd_, _imagem_, _gotovo_,
   {{0xa6a1f023,0x834d7021,0xc400c005,0x64a65010}},	//   _pertubuh, _og__velg_, _једне_, _fecha__de_,
   {{0xa2ebc014,0xc62be02e,0x3864a018,0x4fcc5004}},	//   _na__súa_, _abanyagi, _བཅོ__བརྒྱད_, _apontado,
   {{0x0f74b00e,0xd3a8d006,0x1378e023,0x6c68d004}},	//   _པར__འགྱུར_, _semarang_, _gelaran_, _faça__download_,
   {{0xf67f6009,0x17c9a014,0x6cc6c005,0xb73af00b}},	//   _peneliti, _da__provinci, _umetničk, _རྒེད_,
   {{0x66feb01d,0x38dc3005,0xe9d0c005,0x644fe004}},	//   _izbrišit, _људи_, _језик_, _níveis__de_,
   {{0x7fc3f010,0x12490037,0x34c59021,0x5354901c}},	//   _así_, _mpamvu_, _tilgjeng_på_, _majelis_,
   {{0x9701100c,0x9fe13005,0x647df010,0x0a91500c}},	//   _लिए__तैयार_, _своје_, _producci_de_, _आप__में_,
   {{0x44957014,0x9b80d005,0x8775d005,0x72927005}},	// [d40] _se__lle_, _memorija__računara_, _имала__капаците, _stranu_,
   {{0xc3c38014,0x868c400a,0x00000000,0x00000000}},	//   _nos__anos_, _तइयार_, --, --,
   {{0xf24d8024,0x82468003,0x62f2000d,0xc2b6800b}},	//   _ཤུལ_, _kwindawo__yakho_, _nasleduj, _རམ__འབད_,
   {{0x43ff202a,0x7424f010,0x0a2a400b,0xe3f47011}},	//   _men__hvis_, _un__nuevo_, _བཟོ__ནིའི_, _babone__ukuthi_,
   {{0xd32f2021,0xb65fc013,0x34146021,0x6b9e700b}},	//   _er__grunnen_, _svešteni, _gjøre__dette_, _ལྷན__ཁག_,
   {{0x740b5027,0x02f7601c,0xa264300e,0x0bb9c00c}},	//   _kuala__lumpur_, _menikah_, _ཁབ__ཞིག_, _देती__है_,
   {{0xd96bb007,0xd394d010,0x84830003,0x326c7010}},	//   _uživatel, _eres_, _ukusukel_ngo_, _manos_,
   {{0x7378600f,0x5ab4d004,0x73a85010,0x00000000}},	//   _rugamba_, _os__preços_, _del__cabello_, --,
   {{0x4c48900a,0x2f45d026,0x11efd004,0xc2bd1011}},	//   _देले_, _najljepš, _formação_, _uthe__abantu_,
   {{0xc2d7303a,0x154d800d,0xd2366013,0x9aff0003}},	//   _impongo_, _prevádzk, _broja_, _kunye__nezixhob,
   {{0xc2cae028,0x822fe00c,0x3a0e2005,0x00000000}},	//   _unidad_, _से__लेकर_, _врло_, --,
   {{0x5038e005,0x0f31800d,0x03758004,0xd294200b}},	//   _centraln, _priemern, _uma__maneira_, _འགྱོ__བའི_,
   {{0x29fe6032,0xa7bc504b,0x7247d00b,0x00000000}},	//   _economia_, _forretni, _བཙོན__ཁྲིམས_, --,
   {{0x8b4b901b,0xc4895013,0x59ef600e,0xa2d8700d}},	//   _ekuthiwa_, _aviona__je_, _དང__པོའི_, _menej_,
   {{0x22ab101c,0x5e62d022,0x53959004,0x1adb902b}},	//   _bandung_, _descarga, _passo_, _གསོག__འཇོག_,
   {{0x5a33600a,0x82a88019,0x00000000,0x00000000}},	//   _करि_, _de__investim, --, --,
   {{0xa27e9038,0x44b0d013,0x7ae96003,0xcb88500e}},	// [d50] _utan_, _treba__da_, _emva__kwexesha_, _རྭ_,
   {{0xbbff600b,0x8c7af036,0xffa1800d,0x8472e010}},	//   _ིས__ོན_, _srpskoj_, _priestor_, _que__ha_,
   {{0xe442100d,0x3bad400c,0x0bc0100c,0x00000000}},	//   _ich_, _अर्थ__यह_, _करने__को_, --,
   {{0xc46e600d,0x9be3300c,0xc28e9021,0xe42dd011}},	//   _nie__je_, _तक__कि_, _det__virker_, _isolezwe__ukuthi_,
   {{0xe8c6300f,0x2495e02a,0x7ad60004,0x00000000}},	//   _abaturag, _på__og_, _mudanças_, --,
   {{0x8444401b,0x3a33600a,0xc472e010,0x34882021}},	//   _xa_, _करऽ_, _que__la_, _oppmerks_på_,
   {{0x7395401d,0xf4ace02a,0xaf3ff004,0xf2ad000b}},	//   _mjesec_, _har__et_, _joão_, _མས__ཟེར_,
   {{0x36a0000f,0x00000000,0x00000000,0x00000000}},	//   _yisumbuy, --, --, --,
   {{0x8b8fc00e,0xc348e00f,0x4471500a,0x64ac5010}},	//   _ཤང_, _ingenzi_, _सकेनी_, _fuera__de_,
   {{0x9a134023,0xcbb4700d,0x0386d010,0x180aa011}},	//   _berasal__daripada_, _reagovať_, _fuera_, _johannes_amaphoyi,
   {{0x52430020,0xb3ae602a,0x5425d003,0x72b6d011}},	//   _མཚོ_, _fra__andre_, _kwaye__kulula_, _womlalis_phansi_,
   {{0x12d1d010,0x00000000,0x00000000,0x00000000}},	//   _el__archivo_, --, --, --,
   {{0xbf68400b,0xf6dc702d,0xb4a95010,0x7e5e7004}},	//   _ཆས__འབྲུག_, _बिपिन_, _durante__el_, _efeitos__colatera,
   {{0x6eba1005,0xbb8a1005,0x413c702f,0x22053005}},	//   _после_, _потом_, _predpokl, _etnički_,
   {{0x739b8011,0xc378e01c,0x72c01021,0x8a95d00c}},	//   _abantu__abasha_, _delapan_, _de__forskjel, _से__दूर_,
   {{0xaf7af018,0xe91af00e,0xf2805021,0x00000000}},	//   _རྒྱུ_, _རྒྱག_, _faksimil, --,
   {{0xc382d027,0xcf71600d,0x02b5b00e,0x0ba8d00b}},	// [d60] _hari__sebelum_, _veľké_, _གི__ཡོད_, _ཁབ__ལུ_,
   {{0x424d8010,0x5128300b,0x5bf6f00b,0x729b4010}},	//   _de__sitios_, _དེ__འབདཝ_, _གི__ཧེ_, _una__mayor_,
   {{0xec48900a,0xa293602a,0x50d7f00d,0x2272f010}},	//   _देबे_, _de__samme_, _dodávate, _dónde_,
   {{0x82ddb009,0xf2b39011,0xfd41b005,0x8472e014}},	//   _di__desa_, _golden__arrows_, _самом__граду_, _que__xa_,
   {{0xc297c00b,0xcac03005,0x00000000,0x00000000}},	//   _སེང__འབད_, _обично_, --, --,
   {{0x334c1004,0x24ae1021,0xdf412004,0x00000000}},	//   _futebol_, _for__meg_, _os__melhores_, --,
   {{0x0452e021,0x5201800f,0xafa9300d,0x0f3f0007}},	//   _gjør__det_, _zayire_, _to__byť_, _se__svými_,
   {{0x1be2200c,0x82ef0005,0xebfe000b,0xec782014}},	//   _आप__एक_, _grafik_, _སི__གི_, _persoal_,
   {{0x4c68401c,0x94912011,0x0a6a200c,0x1212d007}},	//   _memulai_, _le__mpi_, _क्षेत्र__में_, _mnohem_,
   {{0x6b28100e,0x0f75300e,0xb738100e,0x00000000}},	//   _གཏོང_, _བར__འགྱུར_, _གཏོད_, --,
   {{0x447c9006,0x02ab800f,0xa253a005,0xfb98a00c}},	//   _kota__ini_, _iyi__ngingo_, _професор_, _कारणों__से_,
   {{0xc4b9d007,0xfb4cf01f,0x9c6d8011,0x00000000}},	//   _jako__je_, _kurwanya_, _izolo__isithomb, --,
   {{0x52d80038,0x89f1301b,0x00000000,0x00000000}},	//   _seier_, _khangela_, --, --,
   {{0x94ae1021,0x7446002a,0xc2957019,0x00000000}},	//   _for__deg_, _på__nettet_, _ano__novo_, --,
   {{0x02c94004,0x4e394004,0x43401011,0xa5ee2017}},	//   _esporte_, _esportes_, _ikaizer__chiefs_, _condició,
   {{0x0bb7c028,0xd2c8301e,0x00000000,0x00000000}},	//   _de__pantalla_, _अक्टूबर_, --, --,
   {{0x64b0902a,0x138ff01b,0x93bef004,0x06565011}},	// [d70] _behov__for_, _kunyaka_, _móveis_, _ancyl__osamisiw,
   {{0xc395400d,0x1c0f300c,0xa3bcb004,0x00000000}},	//   _miesto_, _मदद__कर_, _com__suas_, --,
   {{0xc4936065,0xf243200e,0x6146204a,0x029a902b}},	//   _er__en_, _མེས_, _underhol, _མའི__གནས_,
   {{0x7254c007,0xd9c32038,0xf4608021,0x5c9f500c}},	//   _měl_, _stadfest, _livet__ditt_, _ले__सकते_,
   {{0xb225400d,0xd442601b,0xe9f4f004,0xe2b50003}},	//   _niekto_, _nqo_, _goiás_, _eyenza__ukuba_,
   {{0xc474602a,0xec783004,0xb2551011,0x62c72007}},	//   _som__en_, _pessoal_, _ku__africa_, _rádi_,
   {{0x7a75000c,0xa6f8100a,0x4b58100a,0x2482d02a}},	//   _रहे__हैं_, _लइका_, _लइकन_, _tips__og_,
   {{0x8e32701c,0xaf982005,0x0bfbc00b,0x00000000}},	//   _kualitas_, _међутим_, _འི__ནང_, --,
   {{0xd44e1004,0xc2e71035,0x228b200d,0x3f10f021}},	//   _só_, _bonke__abantu_, _poslať_, _denne__funksjon,
   {{0xdad64004,0xc26d9022,0xb9f4e00d,0x62972010}},	//   _crianças_, _pisos_, _oznám_, _en__primer_,
   {{0xd9b1502a,0xea3cf02d,0x0011503f,0xa6f8400a}},	//   _produkte, _वोह_, _produkto, _एतना_,
   {{0x91456010,0xb5144023,0x8a3dc00a,0xe463b011}},	//   _especial, _boleh__menanyak, _तूँ_, _kuyacaca__ukuthi_,
   {{0xda336002,0x0b301005,0xd2501005,0xa65e1005}},	//   _चीज_, _дело_, _дела_, _филм_,
   {{0x9ae4b013,0x2ecfd005,0x63350022,0x93169014}},	//   _rezultat, _рачунара__је_, _de__dominio_, _praza_,
   {{0x6b8cf020,0x2b8f8020,0x81ea3020,0xe29ab00b}},	//   _ནད_, _སྔ_, _སྡོམ_, _ཤུལ__མའི_,
   {{0x1399400a,0xa0c5c011,0xe2005007,0x7a6f400c}},	//   _तs_, _konke__okuseman, _kolik_, _सकती__हैं_,
   {{0x6443200f,0x029d002b,0xdbddd00a,0xbba0500b}},	// [d80] _iby_, _བཀོད__ཡོད_, _बतिया_, _དཔོན__ཚུ_,
   {{0x9d4e9007,0xef239005,0x8dcc5031,0xc41f1010}},	//   _předmět_, _године__био_, _ngekhomp, _mayor__parte_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfbf95024,0x700ed00d,0x82e8d011,0xc2bb4010}},	//   _མི__དང_, _vytvoren, _kodwa__ngenxa_, _el__tipo_,
   {{0x14444010,0x2ee95005,0xc4936010,0x5f225010}},	//   _hs_, _кад__је_, _es__un_, _los__archivos_,
   {{0xa32f3023,0x22366036,0xc29cc00b,0xc4b95010}},	//   _dikenali__sebagai_, _broju_, _ཞིབ__འབད_, _poner__en_,
   {{0x426e9023,0x32e97023,0xd255802f,0x42670005}},	//   _yang__bermula_, _sesiapa_, _problémo, _неку_,
   {{0x81d8101a,0x3cbee00c,0xd47cc014,0x560fd00e}},	//   _लेकर_, _प्राप्त__करें_, _que__só_, _བསྡད_,
   {{0x310ff021,0x6820500b,0xf4af0004,0x17f7d005}},	//   _denne__artikkel, _བརྙན__སྟོན_, _envie__seu_, _припада_,
   {{0x84444019,0x92d56014,0x426de016,0x00000000}},	//   _os_, _con__todo_, _tuto_, --,
   {{0xc4926010,0xb3ea901c,0x2d5a2005,0x33164011}},	//   _en__la_, _dokter_, _може_, _uthe__kumele_,
   {{0xcbddd00c,0x12a60032,0x4e5b3023,0x4e7cf005}},	//   _बताया_, _saiba_, _perbezaa, _састоји__од_,
   {{0xc6f81061,0xecdc5024,0xe4926014,0x8af52007}},	//   _लेखा_, _གོང__འཕེལ_, _en__na_, _napříkla,
   {{0x0bc6e00c,0x9242b00e,0x24377021,0xa5f39005}},	//   _करता__है_, _བེད_, _det__krever_, _болести_,
   {{0x636b7021,0x4cafa014,0x34aa000d,0x00000000}},	//   _til__salgs_, _coñecida, _môže__sa_, --,
   {{0x928f1037,0xab8f9024,0x0b43100f,0x1fc32011}},	//   _urukiko_, _སྤ_, _amacakub, _izolo__ngesikha,
   {{0x9ba09024,0x8bd1f004,0xd3955011,0xab96300b}},	// [d90] _འཐུས__མི_, _reunião_, _ezinkund_zokuxhum, _ཁྲམ__ཐོ_,
   {{0x63e79007,0xf9aa1023,0xb27fa013,0x45329005}},	//   _této_, _mendakwa_, _kopnu_, _североис,
   {{0x94b28014,0xd2dbf003,0xe290c011,0x00000000}},	//   _por__iso_, _nge__yeedola_, _mdlali_, --,
   {{0x263f5029,0xb3f95011,0x0a9d600c,0x328bb02b}},	//   _digitali, _abantu__bakuleli_, _मात्रा__में_, _གནས__གོང_,
   {{0xc4b3e02a,0x10452022,0xa2365005,0x9be7900b}},	//   _var__en_, _estudian, _dalje_, _འཁྲིལ__ཏེ_,
   {{0xb6a07012,0x9bc4400b,0xe303c004,0xfa3c3007}},	//   _imalo__stanovni, _གནང__མི_, _indústri, _září_,
   {{0x52ac0003,0x52a35014,0x64855004,0x00000000}},	//   _yeyiphi__eyona_, _procedem, _apesar__de_, --,
   {{0x1ebd1036,0x2dd2c010,0xb83e1005,0x00000000}},	//   _dužina_, _en__internet_, _битка_, --,
   {{0x12843010,0x5ef43010,0x09cfb010,0x72d57023}},	//   _archivo_, _archivos_, _novedade, _peronda_,
   {{0x83a92023,0xd46d1021,0x1bb2200c,0x43c48005}},	//   _sebarang_, _bruke__den_, _वह__एक_, _вероиспо,
   {{0x99f4b004,0x526cc019,0xc2d9000a,0xccc2e011}},	//   _você_, _dados_, _बेसी_, _ku__website_,
   {{0xe4b39004,0xc27a800b,0x6476d004,0x327a0011}},	//   _podem__ser_, _ལས__འབད_, _junho__de_, _lase__afrika_,
   {{0x42cad029,0x4f1fb00d,0x7bce400e,0x344e8007}},	//   _bildet_, _sú__dispozíc, _གཞན__དུ_, _ze__dvou_,
   {{0x94444028,0x535bf003,0xb57ed028,0x323b8007}},	//   _ps_, _nangona_, _població, _zájem_,
   {{0x34926036,0xee6e300b,0x4c61a013,0xe472e010}},	//   _je__sa_, _བཅའ__ཁྐྲིམས_, _nagrade_, _que__es_,
   {{0xdb4a300b,0x54b28028,0xe263d031,0x22a51004}},	//   _ཟེར__གསུངས_, _por__eso_, _sokuhlal, _pronto__para_,
   {{0xf2d99023,0x82499036,0xd2132004,0x45032007}},	// [da0] _lesen_, _pesma_, _fechar_, _se__můžete_,
   {{0xd27ed010,0x42369013,0xabfa200c,0x02a3e00b}},	//   _viene_, _kraju_, _देने__की_, _འདི__ཨིན_,
   {{0xfe14d020,0xf7d80013,0x02d8f01e,0xef2b7004}},	//   _བསྒྱུར_, _događaji_, _तेरी_, _mais__recentes_,
   {{0xb27ed010,0x2d8f3020,0x70525013,0x00000000}},	//   _tiene_, _དབུས_, _pokrajin, --,
   {{0x642e6015,0xa35a9015,0x9202600d,0xcba4301b}},	//   _sebuah__kumpulan_, _rencana__yang_, _firiem_, _yesicelo_,
   {{0x0b302005,0xadd60005,0x92a66013,0x62d95004}},	//   _него_, _рачунару__су_, _osoba_, _defesa_,
   {{0x7ee1e005,0xc3ac6007,0xb2d8400a,0x16b5d00f}},	//   _општина__се_, _koupit_, _लइकी_, _byerekey,
   {{0xd329402a,0x72f5f005,0xb3f4601b,0x49d05007}},	//   _og__ikke_, _veroispo_mesnog_, _ukutya_, _vzdělává,
   {{0x4be2b00b,0x9a235004,0x1c681011,0x0f776010}},	//   _འཛིན__ོང_, _que__você_, _zokuthi_, _los__propieta,
   {{0x9242900b,0xb141702d,0xb444e011,0x9cde300c}},	//   _བཙག_, _बाबूजी_, _kulesi__sigameko_, _यदि__आपको_,
   {{0xbd80c00e,0x2afd700e,0xd22db011,0x782ed005}},	//   _དཔྱོད_, _དུ__བཞུགས_, _uma__ethi_, _првих_,
   {{0xe290201d,0x745ed013,0xd2640005,0xd98ca00f}},	//   _neka_, _sudeći__po_, _naslov_, _mushinga_,
   {{0x14426008,0xb3402005,0xccc7d006,0x7bce400e}},	//   _ico_, _licenca_, _perilaku_, _གོང__དུ_,
   {{0xee351010,0xe493200f,0xf4567007,0x00000000}},	//   _millones_, _ko__ari_, _způsobem__jak_, --,
   {{0xb2fcd02e,0x629c500b,0x0c6a700d,0xaa8a900c}},	//   _mbega_, _སྐྱིད__དཔལ_, _hlavné_, _से__कुछ_,
   {{0xe462e00d,0x00000000,0x00000000,0x00000000}},	//   _kliknutí_na_, --, --, --,
   {{0x42367011,0x0cc1802a,0x1a60001b,0xac681011}},	// [db0] _manje_, _de__første_, _ngamaxes, _sokuthi_,
   {{0x3462c005,0x324d900e,0xf27f6007,0x98e2c005}},	//   _на__једну_, _སོག_, _hodně_, _могуће_,
   {{0xb2ca6024,0x72bae007,0xb2ad7010,0xbd8fa00e}},	//   _དབང__རྣམ_, _příliš_, _que__tiene_, _མཆིས_,
   {{0x43a41003,0x0d8cd020,0xe82cd00e,0x8bf2f00b}},	//   _ingxelo_, _སྒྲོལ_, _སྒྲིལ_, _ཆས__གས_,
   {{0x03f9a023,0x7a7f300e,0x381f300e,0x9b8d200e}},	//   _jepun_, _དབྱང_, _དབྱི_, _ཙཱ_,
   {{0x7443800f,0x0bf7700c,0x3003000d,0x00000000}},	//   _fpr_, _में__है_, _tento__článok_, --,
   {{0x65055004,0x42903004,0xf2de000d,0x3231d00c}},	//   _enquanto_, _lojas_, _pomocou_, _से__बाहर_,
   {{0xdc48400a,0x3ee31005,0x9ba9000f,0x3365202a}},	//   _लेके_, _они_, _amahugur, _med__mange_,
   {{0x3e45d00f,0xc9f7801c,0x48e8d00f,0xf236d00d}},	//   _bagaraga, _tionghoa_, _imishing, _svojho_,
   {{0x72a69006,0x1999400d,0xd3320032,0x82d85029}},	//   _prabu_, _dieťa_, _deixe_, _deler_,
   {{0x644ce014,0xd344b00f,0x23946010,0x6949702a}},	//   _páxina__de_, _murenge_, _esos_, _mest__populære_,
   {{0x037d601d,0x52367008,0xd1584005,0x69f66004}},	//   _vozače_, _nanje_, _међунаро_сарадња_, _março_,
   {{0x527f5020,0xd299a00b,0x0c6a1005,0xb3d8602a}},	//   _ཡེ__ཤེས_, _པའི__ཁྲི_, _представ, _på__andre_,
   {{0x02905014,0x4d9fa007,0xa8dfa007,0xeb0fe010}},	//   _illas_, _nějaké_, _nějaký_, _las__siguient,
   {{0x32e1c011,0x72df502d,0xd4ace010,0x04a3f007}},	//   _isikhath_esiningi_, _अबकी_, _con__su_, _nástroj__pro_,
   {{0x15395004,0xf25e7024,0xeacbc007,0x16e8b005}},	//   _estadual_, _ཡོད__རུང_, _základě_, _карактер,
   {{0xae45d00f,0xce3b2005,0x32cfe00b,0x00000000}},	// [dc0] _yagaraga, _оба_, _ཁོང__རའི_, --,
   {{0xc294e024,0xd2b4901f,0xadb9b011,0x031d7023}},	//   _སྐད__ཡིག_, _cyacu_, _abantu__besifaza, _percuma_,
   {{0xb38f900f,0x42903010,0xc2905028,0x2c321011}},	//   _ishyaka_, _deja_, _ellas_, _ngo__ekuseni_,
   {{0xfb28202b,0xdaab3007,0xb9c20003,0x52000003}},	//   _འགོ__བཙུགས_, _množství_, _oku__kuthetha_, _kwii_,
   {{0x50864005,0x2cc0102a,0x00000000,0x00000000}},	//   _pri__lansiran, _og__hvordan_, --, --,
   {{0xa290b01c,0xe973a01c,0xd26d902c,0x1633c007}},	//   _terkait_, _arsitekt, _casou_, _vzdáleno,
   {{0x9b79f00c,0xc394a007,0x6325f02a,0x132ba004}},	//   _की__तुलना_, _nejsou_, _at__alle_, _on__line_,
   {{0xc2f3c029,0x3364a021,0x687e100d,0xd253900e}},	//   _arkivet_, _det__mange_, _prehliad, _ཡོད__ཀྱང_,
   {{0x73264011,0x72cf3023,0x6f397015,0x09c6b004}},	//   _kubukeka__sengathi_, _bandar__raya_, _terutama, _paulista_,
   {{0x92a6d02f,0xf443a03b,0x34640023,0xe2f3c027}},	//   _treba_, _opp_, _reka__bentuk_, _falsafah_,
   {{0x1492a02a,0xbc37b016,0x72dc2014,0x26c9f00a}},	//   _du__har_, _české_, _de__auga_, _बाति_,
   {{0x4c916006,0xd294a00e,0xd333000d,0x00000000}},	//   _didukung_, _འགྲོ__བའི_, _na__ktorých_, --,
   {{0x7a33e006,0x84926014,0x6387401c,0x12ffd021}},	//   _जरा_, _en__os_, _energi_, _denne__siden_,
   {{0x7eeaf005,0x3d7f901d,0xe2fe6013,0xa46c3007}},	//   _živi__punoletn, _na__ljestvic, _drugih_, _předpokl,
   {{0x52d9201a,0x6c49200c,0xa2d5b014,0xebe5400e}},	//   _मेरी_, _मेरे_, _para__súa_, _ཚེས__ཟླ_,
   {{0x3bb9000c,0x32903004,0x0288e009,0xc599401a}},	//   _हैं__जो_, _seja_, _melayani_, _सेहत_,
   {{0xa442903a,0x382ae00b,0x6b8da002,0xd3877004}},	// [dd0] _ica_, _དྲན__བརྩི_, _आउ_, _quarta_,
   {{0xb494e005,0x5473a021,0x474be030,0xf46bc011}},	//   _od__do_, _som__lar_, _planlegg, _esikhund_sokuba_,
   {{0x62903004,0x1c074021,0x59e6a005,0xbcb7a00c}},	//   _veja_, _destinas, _iznosila_, _में__अपने_,
   {{0x2b88400e,0xc4714021,0x94b45019,0xc7c1f00b}},	//   _འོ_, _anmeldel_av_, _produto__ou_, _ཁྲིདཔ_,
   {{0xb820f024,0x4ccac00e,0x33fe302a,0x5d8ac00e}},	//   _དབྱིན_, _འདིར_, _med__disse_, _འདིས_,
   {{0x127b400d,0x6da08020,0x72cf700f,0xfa418004}},	//   _komentár, _བསྟེན_, _muri__reta_, _de__força_,
   {{0x7287001d,0x02926026,0x04a86004,0x8e923005}},	//   _blokove_, _toranj_, _postado__por_, _потребе_,
   {{0x04af002a,0xa251a005,0x6b8c900c,0xa0631005}},	//   _men__det_, _od__orbite_, _अपने__जीवन_, _готово_,
   {{0x624c200e,0xdf20d00f,0x542ab003,0x05a9c005}},	//   _ཁམས__དཔལ_, _umutanga, _kuxhomek, _великог_,
   {{0x24429008,0x32a58014,0xd2004040,0x1331b005}},	//   _aca_, _de__xullo_, _zemi_, _diskusij,
   {{0x03223011,0x047d9021,0x4712400c,0x1f99300c}},	//   _kumele__kube_, _nettsted_som_, _कर__देता_, _अपने__पसंदीदा_,
   {{0x033ca011,0x00000000,0x00000000,0x00000000}},	//   _isikhath_eside_, --, --, --,
   {{0x8b8cb002,0xa461d011,0x32d83038,0x024c900a}},	//   _खा_, _kubika__isowetan_, _olje_, _दिहलस_,
   {{0x84b3d015,0x9439a021,0xd79fb00d,0x33d56028}},	//   _didapati__di_, _er__viktig_, _podujati, _la__guerra_,
   {{0x927b4004,0xd46de014,0x0c9a800e,0xb3949010}},	//   _comentár, _dicir__que_, _རྡུལ_, _esas_,
   {{0xd2caf00d,0x99aa7005,0xbee32005,0x2713e00c}},	//   _pridal_, _носи_, _зна_, _को__प्रदर्शि,
   {{0x0290c005,0x9c67e013,0x8759d005,0x00000000}},	// [de0] _dodaj_, _januara_, _капаците, --,
   {{0x92e9d011,0xaf9f6021,0x001ba00c,0x00000000}},	//   _umnuz__jacob_, _kan__gjøres_, _कैसे__प्राप्त_, --,
   {{0xaf25d014,0x52b3100f,0x00000000,0x00000000}},	//   _enfronta, _ugomba__gukora_, --, --,
   {{0xde381009,0xfebbd01d,0x5ce84013,0x00000000}},	//   _kecamata, _nogometn, _prosječn, --,
   {{0x1eb0900f,0x0344a038,0x09f73034,0xd4d7800a}},	//   _umurenge_, _attende_, _samanset, _लड़िकन_,
   {{0x4e9bf005,0x2eced005,0x2eee6005,0x1c00300f}},	//   _површини__од_, _му__је_, _је__до_, _uhagarar,
   {{0x2f376005,0x52905019,0x5202700d,0x00000000}},	//   _од__до_, _dela_, _mesiac_, --,
   {{0xe4ac602a,0x92d87010,0x9ba4c00b,0xd492a021}},	//   _det__du_, _tener_, _ཟེར__མི_, _du__tar_,
   {{0xb26dc01d,0x03658011,0x435ed010,0x00000000}},	//   _pivo_, _le__ngozi_, _su__trabajo_, --,
   {{0x9aaee02a,0x4225f005,0x95dfd00e,0x314e5007}},	//   _forvente, _nauka_, _བསླབ_, _dlouhodo,
   {{0xd2da7003,0x94a6e009,0x126dc028,0xd473a021}},	//   _adresi_, _bahwa__ia_, _vivo_, _som__tar_,
   {{0xa45d3005,0x8036800a,0xa253b02b,0x0329b021}},	//   _istočnom__delu_, _घुरहु_, _ཡིག__འདི_, _og__enkelt_,
   {{0x6802002b,0xc2499036,0x3b35502b,0x7956f00d}},	//   _པར__སྟོན_, _pesme_, _ཉེན__སྲུང_, _najlacne,
   {{0xf2219011,0x1f09600e,0x3c891005,0x84726011}},	//   _kufaka__phakathi_, _ཟིང__འཁྲུག_, _различит, _phakathi__kwe_,
   {{0x5b8e600e,0x1f33e00f,0x42e89004,0x52b4d00b}},	//   _ཇེ_, _akarenga, _cozinha_, _གི__ོགས_,
   {{0xe29db00b,0x0bf9c00b,0x20946007,0x84aea021}},	//   _འཚོལ__ཞིབ_, _མི__ནང_, _nabízí_, _for__mer_,
   {{0x8641e023,0xebbf000c,0x9abfb014,0x680e100b}},	// [df0] _perkahwi, _साइट__के_, _convérte, _ོབ__དཔོན_,
   {{0x92b4d012,0x4d493005,0xe43c8007,0x9bc3100b}},	//   _djece_, _пре_, _to__být_, _བཀག__དམ_,
   {{0x822fc009,0xd2927004,0x5b7e8024,0xf6f9401e}},	//   _ini__memiliki_, _gerais_, _ཆོས__རྫོང_, _तेरा_,
   {{0xe493602a,0x61b9600a,0xe2ef9011,0x6dcc5010}},	//   _du__er_, _देहल_, _othisha_, _las__principa,
   {{0x12905004,0x83a2d014,0x00000000,0x00000000}},	//   _pela_, _atopar_, --, --,
   {{0xbf58400b,0x00000000,0x00000000,0x00000000}},	//   _ཕྱུག__འབྲུག_, --, --, --,
   {{0x144e900d,0x68dcd00f,0xb4715004,0x6c5e700c}},	//   _sú_, _urufungu, _criar__um_, _को__करने_,
   {{0xbc73c024,0x3d570005,0x6d20200f,0x7bab900c}},	//   _གཙོའི_, _kao__korišten_, _ishinzwe_, _लोगों__ने_,
   {{0x78e9f029,0xe2d9f023,0x94950021,0x8601c030}},	//   _leksikog, _negeri__pulau_, _føle__deg_, _midlerti,
   {{0xa2d58007,0xa3ea000f,0x748a5007,0x4ff6a011}},	//   _všech_, _imiti_, _které__si_, _umthetho,
   {{0x7b50a003,0x16f9c02d,0x13eb402f,0x60e94005}},	//   _ingcacis, _भइया_, _vsetko_, _површини_,
   {{0x244e9010,0xadd85005,0x8f06b00d,0x6394a011}},	//   _tú_, _једино__познато_, _súvisiac, _toll__plaza_,
   {{0x726df028,0xa2bd4011,0x1386c028,0xb2ad600e}},	//   _estos_, _ngo__kuya_, _madre_, _ངོ__མཚར_,
   {{0x53f83015,0x0465d02a,0xf29e700b,0x94a1200f}},	//   _semula_, _hvilken__som_, _ཨིན__རུང_, _gahunda__ya_,
   {{0x9be90051,0x00000000,0x00000000,0x00000000}},	//   _अमेरिकी_, --, --, --,
   {{0xb2005023,0x92905014,0x6297e003,0x3480d010}},	//   _polis_, _polas_, _wagqibel, _todo__lo_,
   {{0x95fc9062,0xe8442005,0x126cb00b,0x03160011}},	// [e00] _प्रथम_, _ипак_, _ནང__ཆེད_, _usizo_,
   {{0x9b23800e,0x00000000,0x00000000,0x00000000}},	//   _སྔོན__འཇུག_, --, --, --,
   {{0x2259d00b,0x00000000,0x00000000,0x00000000}},	//   _གདོང__ཤོག_, --, --, --,
   {{0xf44eb038,0xce0ed015,0xd9f47003,0xbc0ea00b}},	//   _bø_, _terengga, _ebhaliwe, _ཁོང__ཚུ_,
   {{0x32460003,0x00000000,0x00000000,0x00000000}},	//   _ukuya__kuthi_, --, --, --,
   {{0xf313e01c,0x1f5dd005,0x62c8200f,0xebe0400c}},	//   _mencoba_, _се__производ, _reba__neza_, _जो__इस_,
   {{0x2243c00e,0x74104014,0x50b54005,0x329bc00d}},	//   _ཞེས_, _notas__véxase_, _до__године_, _niekedy_,
   {{0x53e2d011,0xde50600d,0xb200f00d,0x0202602c}},	//   _baptist__church_, _financie_, _meniny_, _deriva_,
   {{0xc4952014,0xb59bd009,0xef938017,0xb2b3802c}},	//   _se__non_, _dibutuhk, _fundador_, _fundado_,
   {{0xaa3d2066,0x6465a013,0x72007008,0xd9ce5003}},	//   _होत_, _na__površini_, _ceni_, _iintlawu,
   {{0x4291a005,0x9320d01c,0x7d7ef005,0xf73fa00e}},	//   _treće__kolo_, _proyek_, _му_, _མཆེད_,
   {{0xcc51e01d,0x2229a005,0xeef12005,0xf46cb019}},	//   _erotska_, _satelit__orbitu_, _име_, _dos__eua_,
   {{0x29456010,0x1bcc400c,0x3316600f,0xdfdcb019}},	//   _alquiler_, _आने_, _kuri__wowe_, _de__primeiro,
   {{0x327e703b,0xbd67d021,0xca32000a,0x530d300c}},	//   _funn_, _høy__kvalitet_, _मनोजे_, _पर__जाएँ_,
   {{0x2d20200f,0x7aad400c,0x5c68103d,0x54615021}},	//   _ushinzwe_, _करती__हैं_, _nokuthi_, _ikke__alltid_,
   {{0x530bb011,0x54b83010,0xb45ed010,0x00000000}},	//   _ajax__cape_, _continua_se_, _cambiar__el_, --,
   {{0x3bcc600c,0x657ec017,0xd7a7900e,0x00000000}},	// [e10] _इसी_, _coalició, _རི__ཁྲོད_, --,
   {{0x648e6014,0x62d9700a,0x7c49700a,0x9349b003}},	//   _da__de_, _भइली_, _भइले_, _umqeshi_,
   {{0xeeba6038,0x23992012,0x8db44003,0xcb3aa021}},	//   _sjølv_, _na__temelju_, _ubuncina, _du__bestemme,
   {{0xf40c500d,0xd4805011,0x0435a003,0x9bf2c00b}},	//   _aktuálne_, _ngokuthi__yi_, _zamaziko_, _ོང__ལས_,
   {{0x027e9010,0xc4b46014,0x9c88901a,0xdbc3902d}},	//   _juan_, _por__en_, _देखो_, _ुरी_,
   {{0x224df024,0x5a34d005,0xc38b1023,0x3365202a}},	//   _ཤོག_, _je__iznosila_, _untuk__rencana_, _har__mange_,
   {{0x5b64a030,0xc452a005,0x73f9a00f,0xbc6ba02c}},	//   _adressen_, _opština__okrugu_, _bavuze_, _estudou_,
   {{0x52907037,0x4e908013,0x00000000,0x00000000}},	//   _sena_, _električ, --, --,
   {{0xe24e5020,0xde85a005,0xc2684004,0x26f9600a}},	//   _ཡུལ_, _је__општина_, _produção_, _देला_,
   {{0x3205a007,0xd37fc013,0xf2b4800d,0x1b9b000e}},	//   _všichni_, _članka_, _sekcie_, _རྣམས__སུ_,
   {{0x7c62a00f,0x14952028,0xebcd900c,0x26bfc010}},	//   _uturere_, _no__son_, _त्वचा__के_, _los__benefici,
   {{0x7ef15005,0xe4b41014,0x7a06700d,0x5b8f1005}},	//   _град__се_, _poden__ser_, _stiahnut, _треће__коло_,
   {{0xbbf9f00b,0x721f2011,0xbaee802a,0x646b5022}},	//   _མི__ཚུ_, _kulesi__sikhathi_, _rettighe, _sesión__de_,
   {{0x99e0300f,0x00000000,0x00000000,0x00000000}},	//   _ushinjwa_, --, --, --,
   {{0xe3f9a01f,0xe3874028,0xaeeee005,0xe24a2011}},	//   _yavuze_, _padres_, _је__још_, _inkontil_yakhe_,
   {{0x89e86007,0xaa5df00c,0x50c93005,0xf4adf00d}},	//   _samozřej, _बहुत__कुछ_, _две__године_, _že__ste_,
   {{0x99fdc015,0x24ac602a,0x7dde700b,0xa3083010}},	// [e20] _selain__daripada_, _det__og_, _བཀོད__ཚོགས_, _que__desea_,
   {{0xa200c016,0xe2d51003,0xf26e1017,0xa3874028}},	//   _hodin_, _kwaye__ukuba_, _época_, _fuerza_,
   {{0xdf3f8016,0x4497a01d,0x5057a013,0xd24e000e}},	//   _विभिन्न_, _lansiraj, _lansiran, _གཏོང__བའི_,
   {{0xea533011,0x7757300c,0xd45a7010,0x00000000}},	//   _kakhulu__njengoba_, _जाना__चाहिए_, _aquéllos__que_, --,
   {{0xb3ead019,0x2827200c,0x00000000,0x00000000}},	//   _voltar_, _इस__आलेख_, --, --,
   {{0xd3070011,0x449f5011,0xd3738013,0x1ba5200e}},	//   _kule__midlalo_, _abaholi__be_, _podatke_, _རྟོག__པས_,
   {{0x02cf800d,0x2249901c,0x62cfc007,0x64a0c00d}},	//   _podobne_, _resmi_, _později_, _keď__už_,
   {{0xe0fc9014,0xd46cf010,0x00000000,0x00000000}},	//   _galego__traxecto, _hay__que_, --, --,
   {{0xd320a00d,0xc2a07011,0xc4b4d021,0xea2e900b}},	//   _keby_, _ukuthi__ingane_, _siden__av_, _རང__སོའི_,
   {{0xf2a7700f,0x24b9102a,0x0eae1023,0x3c6bb011}},	//   _ntabwo_, _ikke__kan_, _syarikat_, _ithuba__lokuthi_,
   {{0x12b4f011,0x62025012,0x0348f003,0x323c2011}},	//   _kahle__kakhulu_, _kutije_, _ukuya__kwezi_, _wasening_afrika_,
   {{0x72d80010,0xabcc600c,0x64abd014,0x2175e004}},	//   _quien_, _इसे_, _rexión__de_, _notícia_,
   {{0xb3805006,0xd3105015,0x32a9b033,0x64e7e005}},	//   _yang__dikenal_, _yang__dikenali_, _du__skal_, _dani__sećanja_,
   {{0x0bba400b,0xc200a026,0x427f6004,0x8c05c00c}},	//   _དེ__ནང_, _nebi_, _motivo__pelo_, _जाने__का_,
   {{0x625a2012,0x0c4e802d,0x26919010,0x73574028}},	//   _rekla_, _चलीं_, _benefici, _agregar_,
   {{0xacde7011,0x64af602a,0x9b8d300e,0x1386f030}},	//   _isiqinis_sokuthi_, _men__de_, _མྱ_, _lagre_,
   {{0x327e2006,0x03ed300d,0x55d1100d,0x8cf1a007}},	// [e30] _yakni_, _kozmetik, _nemôžete_, _přehled_,
   {{0xe4ad602a,0xf35ef015,0x7b61800a,0x882a900b}},	//   _kan__du_, _bermula__dengan_, _दहिने_, _མེད__སེངྒེ_,
   {{0x3ac60011,0x334c501d,0x626c700d,0x67baa02b}},	//   _kubika__inewswat, _raketom_, _áno_, _དང__འཇོན_,
   {{0xe2dfb002,0xb3ea0014,0x6bb5900c,0x00000000}},	//   _लौकी_, _xeito_, _कुछ__भी_, --,
   {{0xbf7f000b,0x130e4004,0x00000000,0x00000000}},	//   _དབང__འབྲུག_, _jogador_, --, --,
   {{0xe4ace02a,0x6627600f,0x4967600f,0x13fb502a}},	//   _har__du_, _minisiti, _minisite, _den__eneste_,
   {{0x52757013,0xbfac7011,0xe3b49004,0x00000000}},	//   _od__preko_, _ungqongq_wezemfun, _são__mais_, --,
   {{0xbbcc700c,0x1ad2102d,0x6b98a00c,0xbf4bd00f}},	//   _उसे_, _खर्चा_, _को__भी_, _ubushake_,
   {{0xe2770027,0x0be5200c,0x95a9c005,0x8e297005}},	//   _untuk__menambah_, _से__कम_, _једино_, _рат_,
   {{0xe2a6402e,0xc0c7a024,0x22bbc00b,0xb2304010}},	//   _namba_, _ལམ__རྒྱ_, _ོད__ལེན_, _nuestro__sitio_,
   {{0xfb8da020,0x20d98007,0xc6083014,0x7c574014}},	//   _ཅད_, _středoče, _xeografí, _listaxe_,
   {{0x3f419005,0xaeea4002,0xee4d4029,0xe477c005}},	//   _планете__земље_, _नाहक_, _forbedre_, _ракета_,
   {{0x4e60e005,0x4342a004,0x7b955024,0x8a87400c}},	//   _од_, _fazendo_, _དོན__ལག_, _ने__कहा_,
   {{0xa253900e,0x2f8bf00d,0x5cc76010,0xef66c005}},	//   _བཟུང__བྱས_, _aké_, _de__nuestra_, _имало_,
   {{0xf2e58003,0x72da7003,0x83fc700f,0x3855f00b}},	//   _ngaba__ufuna_, _lisebe_, _igihe__cyose_, _བརྒྱུད__འཕྲིན_,
   {{0x1200b008,0xf290a00d,0x347ce021,0x1200a005}},	//   _ceci_, _seba_, _klikk__på_, _sebi_,
   {{0xd294100e,0x3f5b8011,0x42e6800d,0x774a900c}},	// [e40] _འོན__ཀྱང_, _nhlangan, _pre__tých_, _होनी__चाहिए_,
   {{0xd045203a,0x29a48011,0x7bbc702b,0x33029021}},	//   _gutungan, _nge__inthanet, _ལས__ཡང_, _disse__dager_,
   {{0x030c5015,0x1e292005,0xe4475021,0x9356e011}},	//   _tergolon_dalam_, _као_, _ganger__er_, _unkk__zanele_,
   {{0x8b8d4020,0xd7ac9005,0x7bee2005,0x43930004}},	//   _བྱ_, _простире_, _тамо_, _seus__negócios_,
   {{0xf30e4014,0x740d0007,0x3491d00d,0x9bfa100e}},	//   _xogador_, _francouz, _ktorý__sa_, _མི__བུ_,
   {{0xb2794005,0x10364009,0x32c2c011,0x7af7500d}},	//   _под__именом_, _perekono, _engaphez_kuka_, _verejnos,
   {{0x0abc2005,0x22a17024,0x63267021,0x00000000}},	//   _masa__satelita_, _ངོས__ལེན_, _av__alle_, --,
   {{0x647a5014,0x78fdf00c,0xa94a3005,0xf2bea004}},	//   _nado__de_, _अपने__बच्चों_, _светог_, _no__meio_,
   {{0x6aef302e,0xc81fc021,0xd3b0c003,0x72a9d02b}},	//   _kumenyes, _er__tilgjeng, _kunye__nexesha_, _རྗེ__རྗེ_,
   {{0xabf6e00b,0xe457f011,0x424c000e,0xfbf2a00b}},	//   _གླ__ོད_, _kubikwa__ukuthi_, _ཉིས_, _ཨང__པར_,
   {{0x830f1036,0x8394d013,0x00000000,0x00000000}},	//   _izabran_, _šest_, --, --,
   {{0xced6003f,0xb296800b,0xe2bb200f,0x8bce900b}},	//   _možno_, _ངེས__གཏན_, _bwo__kubaho_, _ཆོག__ཐམ_,
   {{0x0200b012,0xe320c00d,0x9a99e00d,0xe33c9004}},	//   _reci_, _kedy_, _náhradné_, _no__caminho_,
   {{0x621c601b,0xd48ea021,0x58f5804a,0xd2d99013}},	//   _uluhlu_, _ha__den_, _løsninge, _deset_,
   {{0x0bfa600c,0x00000000,0x00000000,0x00000000}},	//   _देखा__है_, --, --, --,
   {{0xfefc7014,0xe40e0011,0x851e3003,0x00000000}},	//   _cordial__saúdo_, _kwacaca__ukuthi_, _imfuneko_, --,
   {{0xcf572013,0x62b3f011,0x4200b00d,0xc2e92011}},	// [e50] _vidi__još_, _ayikho__into_, _veci_, _ndlovu__uthe_,
   {{0x437a603f,0xab99600b,0x92dcc011,0xe3268021}},	//   _zadarmo_, _དྲན__ཆས_, _kamengam_jacob_, _få__vite_,
   {{0x6347702a,0xa28df003,0x6657400d,0xd2de9010}},	//   _til__alle_, _ibizwa__ngokuba_, _súčasnos, _el__hogar_,
   {{0x82936024,0x529b700f,0x2ac71040,0x83fc9021}},	//   _དགོས__མཁོ_, _abicanyi_, _menší_, _ikke__blir_,
   {{0x1bd6b00c,0x8b9f9024,0x45c6900d,0x00000000}},	//   _प्रयोग__कर_, _ཡོད__སར_, _je__ťažké_, --,
   {{0x2290b018,0xcadc7010,0xe3a59004,0x0a61600c}},	//   _དཔྱད__གཞི_, _imágenes_, _quanto__mais_, _लोगों__में_,
   {{0xe2362038,0xdd018007,0x32f6d004,0x2bee1005}},	//   _mykje_, _vyhledat_, _não__pode_, _лако_,
   {{0x22a6d003,0x9e8ee023,0x0da01009,0xe473e00d}},	//   _isebe_, _mempunya_kelayaka, _diantara, _ste__na_,
   {{0x1da8900f,0x227eb011,0x62b1e00b,0x00000000}},	//   _itangaza, _konke__lokho_, _ིར__བཏང_, --,
   {{0x2eadb005,0x7c1c6003,0x42772011,0x00000000}},	//   _степеном__је_, _iimpawu_, _kanjani__imali_, --,
   {{0xbbba700b,0x224ff011,0x234eb004,0x5b301005}},	//   _དེ__ཚུ_, _le__filimu_, _duas__vezes_, _ћемо_,
   {{0x3d061010,0x04af002a,0x06a6e01a,0x22dea010}},	//   _reproduc, _for__det_, _गिरफ्तार_, _la__pena_,
   {{0x0e28e005,0x944f1004,0xa26d9014,0x54441004}},	//   _за_, _há_, _pasou_, _de__água_,
   {{0x4496e014,0x3248900d,0xb479700d,0x00000000}},	//   _algúns__dos_, _takmer_, _keby__sme_, --,
   {{0xb44f1004,0xaf0c900e,0xfed56003,0x00000000}},	//   _já_, _རྒྱུར_, _nayiphin, --,
   {{0xe76b900e,0x224e402b,0x7bbc9024,0x6b62500c}},	//   _དྲ__མཐུད_, _འོང_, _ལས__རང_, _मैंने_,
   {{0xd44f1004,0x6443200f,0xbf24500d,0xa641e023}},	// [e60] _lá_, _icy_, _práve_, _berkahwi,
   {{0xd46cf014,0x46f9c00a,0x2587e032,0x04102011}},	//   _dos__que_, _भइला_, _os__músculos_, _boa__morte_,
   {{0xdb8d3067,0xe4b02021,0x9342c014,0x52fe6011}},	//   _टा_, _behandli_mot_, _facendo_, _bheki__cele_,
   {{0xa27ed010,0x7d73a005,0x64783010,0x00000000}},	//   _buen_, _познати_, _reseñas__de_, --,
   {{0x73f4001c,0xa3d56010,0x00000000,0x00000000}},	//   _justru_, _la__fuerza_, --, --,
   {{0xe24c402b,0x026c5007,0x023e100f,0x52d98004}},	//   _ཅིག_, _bylo_, _kuri__buri_, _serem_,
   {{0x3290c00d,0x46614007,0x829bb010,0x00000000}},	//   _veda_, _zaměstna, _los__pasos_, --,
   {{0x024c4018,0x544f1004,0x54af6007,0xba3dc02d}},	//   _ཅིང_, _dá_, _že__se_, _तोर_,
   {{0x1290c02f,0x7320c007,0x8312a009,0x4ae1f014}},	//   _teda_, _tedy_, _terbuat_, _referirs,
   {{0x44a92014,0x3473e00d,0xf9a3700d,0x287ad004}},	//   _despois__da_, _ste__sa_, _kuchyňa_, _alta__qualidad,
   {{0x81eb700b,0x24a71014,0x5445a010,0x00000000}},	//   _ཨིནམ_, _súa__nai_, _cuando__las_, --,
   {{0x5d33b034,0x8296e00f,0xddb2c003,0x2aaf5003}},	//   _menneske_, _umubyeyi_, _kwinqana, _nxaxheba_,
   {{0x9ca6c00c,0x00000000,0x00000000,0x00000000}},	//   _वे__आपको_, --, --, --,
   {{0x324e500e,0x827e5011,0xb79a200e,0x9458b011}},	//   _ཡོང_, _patrick__mtolo_, _སྨོན_, _natal__udkt_,
   {{0xda99400c,0xd48cb004,0xeda22005,0x82a7800b}},	//   _की__अनुमति_, _da__sua_, _постао_, _ངས__ཐོག_,
   {{0x03961036,0x4cd3a005,0x00000000,0x00000000}},	//   _srpski_, _помоћу_, --, --,
   {{0xcf905004,0x9486a00a,0x9741e005,0x00000000}},	// [e70] _grátis_, _महतारी_, _основне_, --,
   {{0x649a5014,0x6417d024,0xc29dc02b,0x1721800d}},	//   _máis__de_, _ལས__རྒྱལ_, _གིས__འབད_, _niekoľko_,
   {{0x2ef76005,0x59681010,0x11869003,0xa229c004}},	//   _примећен__је_, _reciente, _likarhul, _com__êxito_,
   {{0x9b553026,0x449a1015,0x925ac02b,0x00000000}},	//   _kormilar, _berasask, _ཟེར__མིང_, --,
   {{0x83ea300d,0xb4b19014,0x74b81021,0xe2e30005}},	//   _tejto_, _de__decembro_, _legg__inn_, _pominje_,
   {{0x144f1016,0xb1d91005,0xfc474007,0x1386c014}},	//   _pá_, _на__месту_, _různé_, _cadro_,
   {{0x22d91004,0x28d54009,0x12d91004,0x00000000}},	//   _vezes_, _pegunung, _receba_, --,
   {{0xb3ef602a,0x3e2cc005,0xb949e004,0xc283c010}},	//   _med__andre_, _влада_, _suas__necessid, _le__permite_,
   {{0x0bb0100c,0xfbfa500b,0x83f98023,0x004d900d}},	//   _लोगों__को_, _ཚུ__དང_, _teruk_, _prípadne_,
   {{0x544f100d,0x3cc0f00e,0xe3f4101d,0x62982005}},	//   _tá_, _དཔྱད__གཞིའི_, _loptom_, _na__primer_,
   {{0x54b43010,0x00000000,0x00000000,0x00000000}},	//   _son__las_, --, --, --,
   {{0x727f801d,0x62bf9023,0x324e600e,0xabe1a00b}},	//   _mirna_, _mengatak_bahawa_, _རོང_, _གཟུགས__ཕབ_,
   {{0xc3a23023,0xdc53f014,0xaaf7f011,0x00000000}},	//   _tempoh_, _mantivo_, _zonke__izinhlob, --,
   {{0xb9f5e007,0xfdd0500e,0x64bff010,0x00000000}},	//   _poté_, _བེད__སྤྱོད_, _industri_de_, --,
   {{0xb48db014,0x34730017,0xf1869003,0x49dfa003}},	//   _de__ata_, _destacan_, _zikarhul, _uxanduva_,
   {{0xb44f2008,0x3520e00f,0x326cd010,0x0b81501b}},	//   _yâ_, _inkotany, _conoce_, _lezolimo_,
   {{0xd352402a,0xfb9c9018,0x3e26100e,0x1301d00d}},	// [e80] _hvis__ikke_, _གསུམ__དང_, _དུ__འགྲོ_, _väčšina__ľudí_,
   {{0x6212d004,0xb27f4010,0x215c7007,0x0257c007}},	//   _mulher_, _tienda_, _speciáln, _díly_,
   {{0x82e5f009,0x03ac601c,0x36f9d00a,0x6bccc00a}},	//   _lainnya_, _maupun_, _बेरा_, _एने_,
   {{0xfcf1800f,0x824df00b,0x8baf1005,0xb44ec00d}},	//   _igiteker, _ཤོམ_, _адреса_, _vo__veku_,
   {{0x177c201d,0x64959011,0xf3030023,0x00215014}},	//   _sudjelov, _ku__log_, _melawat_, _comezaro,
   {{0xea3d202d,0xc2e6003a,0x4a4db00c,0x3316000f}},	//   _होई_, _amanama_, _के__बीच_, _cyiza_,
   {{0x17f4c00e,0x4e86e005,0x84936021,0x0b18301b}},	//   _མཚོ__སྔོན_, _се__не_, _du__ha_, _yengenis,
   {{0x2d808011,0xa387f009,0xe31fc004,0xb3eee021}},	//   _kubika__isolezwe_, _putri_, _situação_, _det__andre_,
   {{0x400ac007,0x1a18301c,0x92ddb02d,0x81eb6011}},	//   _několik_, _memprodu, _गोभी_, _lokhu__kulandel,
   {{0xc2918004,0x72d70010,0x6378a01c,0xbf672011}},	//   _foram_, _antonio_, _rekaman_, _umnyango__wezemfun,
   {{0x8248000f,0x5d12f005,0x02685004,0xc4936010}},	//   _arimo_, _их_, _fundação_, _es__la_,
   {{0x5313e023,0x624c000b,0xd37bc010,0x00000000}},	//   _mencuba_, _ཉིམ_, _desea__obtener_, --,
   {{0xa2ca701b,0x52cc7006,0xd27e7038,0xe3ea7028}},	//   _venda_, _rata__rata_, _finn_, _venta_,
   {{0x83361021,0x5c2e300c,0xb2ca700f,0x126b200b}},	//   _noen__gang_, _कभी__कभी_, _wenda_, _སྦོམ__སྦེ_,
   {{0x925a502c,0xcf242007,0x00000000,0x00000000}},	//   _vello_, _je__možno_, --, --,
   {{0xa30d1015,0xd290f010,0x586f502b,0x00000000}},	//   _melayu__yang_, _hogar_, _འདི__སྤྱི_, --,
   {{0x82d9c004,0x00000000,0x00000000,0x00000000}},	// [e90] _devem_, --, --, --,
   {{0x8258800b,0x2ba3300c,0x00000000,0x00000000}},	//   _བཤུས__དབང_, _यू__एस_, --, --,
   {{0x8cd8201b,0x84b46021,0x63ea000f,0xf26ea005}},	//   _ubukhulu_, _vil__ha_, _mfite_, _илустрац_странице_,
   {{0x627ee038,0x544f5010,0x00000000,0x00000000}},	//   _meinte_, _aunque__no_, --, --,
   {{0xb4a69064,0x1a08601d,0x463f6011,0x56281011}},	//   _स्वास्थ्, _uništi_, _esiteshi_samaphoy, _eningizi,
   {{0x02c5e015,0x925ad014,0xf2842005,0x00000000}},	//   _pada__dalam_, _follas_, _вероватн, --,
   {{0x1242b003,0x990c9007,0x43452023,0x764c900d}},	//   _ubomi__bakho_, _úvodní_, _khidmat_, _úvodná_,
   {{0x39b96014,0xfa05600d,0x2dd3c004,0x2ea31005}},	//   _tiña__habitant, _lepšie_, _na__internet_, _касније__је_,
   {{0x506e0005,0xc4ae2021,0x7ed6700d,0xc4605004}},	//   _delu__centraln, _prosent__av_, _koľko_, _não__tem_,
   {{0x3404d011,0xf290f004,0xe47e5010,0x00000000}},	//   _kahle__kodwa_, _jogar_, _esto__es_, --,
   {{0x72011007,0xbbbac00c,0x7aa8800c,0x23ad3003}},	//   _mezi_, _साइट__पर_, _देते__हैं_, _nge__imeyile_,
   {{0x6201103d,0xe4976033,0x179a200e,0xfbd1b00e}},	//   _lezi_, _så__du_, _སྨིན_, _ལུགས__པར_,
   {{0x8eb8e005,0x6e28e005,0xe242800e,0x8aa3200d}},	//   _си_, _са_, _ནའང_, _inštitúc,
   {{0xa9964007,0x22b56023,0xe224e021,0x9f38d023}},	//   _může_, _apa__anda_, _lenker_, _semulaja,
   {{0x23ea000f,0x3493600d,0x46f9f01a,0x8ecee013}},	//   _ifite_, _by__sa_, _मेरा_, _minimaln,
   {{0x744f5038,0x93958003,0x9348d006,0xf292101d}},	//   _då_, _sars_, _setelah_, _srpanj_,
   {{0xf47a6021,0xe3ff7011,0x839b4014,0x45042007}},	// [ea0] _lagt__ut_, _kuvela__ukuthi_, _réxime_, _si__můžete_,
   {{0x32362038,0xf1b9d00a,0x26c9d00a,0x0ba0000c}},	//   _ikkje_, _बइठल_, _बइठि_, _एक__है_,
   {{0x0bcee01a,0xe5c03022,0xa93cf005,0x00000000}},	//   _पढे_, _de__contacto_, _популаци, --,
   {{0xd3959038,0x44936021,0x247f500f,0x22b4e010}},	//   _gass_, _du__ta_, _neza__ko_, _diseñado__para_,
   {{0x0b9de00c,0xc9c44005,0x62c6d021,0x62012031}},	//   _शामिल__है_, _је__добио_, _amerikan_dollar_, _meyi_,
   {{0x7ee86005,0x1346200d,0x00000000,0x00000000}},	//   _где__се_, _mnoho__ľudí_, --, --,
   {{0x53d6102a,0xaeee6005,0xc3efd00e,0xe480d02a}},	//   _et__stort_, _је__то_, _བསྔལ_, _ting__du_,
   {{0xa3ea0037,0xf26dc010,0x42011003,0x193b9014}},	//   _afite_, _favor_, _zezi_, _asemblea_,
   {{0xddb5f00f,0x855d400c,0x647da021,0xaca0b043}},	//   _ikinyama, _किसी__अन्य_, _tross__for_, _el__sistema_,
   {{0x2e956005,0x92003023,0x2b6bf004,0x72d7e023}},	//   _јер__је_, _enjin_, _gostaria_, _nuklear_,
   {{0xd26df010,0x174ed005,0x345de011,0x00000000}},	//   _estoy_, _право_, _wonyaka__odlule_, --,
   {{0x42fce030,0x02f1002a,0x736ee007,0x12dee00d}},	//   _gangen_, _xml__ikonet_, _je__tedy_, _je__teda_,
   {{0x547a1021,0x6315b023,0x57b65023,0xc47ad007}},	//   _informas_om_, _sambil__belajar_, _seseteng, _nebo__je_,
   {{0x02e6a00f,0x00000000,0x00000000,0x00000000}},	//   _cyane__cyane_, --, --, --,
   {{0xd2020005,0xc279800b,0x22b09004,0x00000000}},	//   _popisa_, _ནི__འབད_, _caminho__para_, --,
   {{0x2181400a,0x7a0c9005,0x42b4e024,0xf243c00e}},	//   _रहुवे_, _од__којих_, _གི__འགན_, _ཞེན_,
   {{0x7ceaa011,0x62882018,0x4497f003,0x00000000}},	// [eb0] _isithomb_patrick_, _འཇམ__དཔལ_, _ye__xml_, --,
   {{0x84444010,0x03eaf014,0xe4ade021,0xe9ba5003}},	//   _gb_, _moitas_, _enn__du_, _umqeshwa_,
   {{0x914b3010,0x03e43036,0xb4ad6021,0x03925004}},	//   _correspo, _je__srpski_, _kan__gi_, _do__adsense_,
   {{0x64af602a,0x00000000,0x00000000,0x00000000}},	//   _for__de_, --, --, --,
   {{0x448ca023,0x6f210005,0x0c7d800f,0x0bc0700c}},	//   _portal__ini_, _naseljen, _imisoro_, _बच्चों__को_,
   {{0xe3ea000f,0xd6fed02d,0x52b4d012,0xea113013}},	//   _ufite_, _चंदा_, _djeca_, _objavlje,
   {{0xd3edb016,0x72a3f007,0x22b95004,0x00000000}},	//   _kosmetik, _by__měl_, _emprésti_para_, --,
   {{0x22d51007,0x2c1c2017,0x92beb007,0x00000000}},	//   _vše_, _realizou_, _se__mohou_, --,
   {{0xd48cf014,0x08dac037,0x9a73700f,0x0b9cc02b}},	//   _da__que_, _imiryang, _kwigisha_, _གླིང__ནང_,
   {{0x9463700c,0x029ee011,0x5ba43003,0x78df600c}},	//   _कंपनियों_, _ama__athikili_, _sisikolo_, _के__बच्चों_,
   {{0xe46de021,0x113c100d,0x00000000,0x00000000}},	//   _hva__du_, _posledné_, --, --,
   {{0x44444040,0x92509005,0x7b9cc00e,0x56a17031}},	//   _sb_, _slika__slika_, _གསུམ__དུ_, _izithuth,
   {{0xd46bb014,0x2b8c901a,0x2e39e004,0xa2f30003}},	//   _mentres__que_, _गए_, _cadastra, _ukuba__kutheni_,
   {{0x3314a014,0xb3f46021,0x29f9d004,0x2bc2e00c}},	//   _da__banda_, _setter_, _ação_, _किए__गए_,
   {{0xe25a0038,0x513c1007,0x1b883024,0xc40a5023}},	//   _heilt_, _poslední_, _ཨན_, _dalam__tempoh_,
   {{0xaacb7038,0xa4ad602a,0xd3cf3021,0xe7c08014}},	//   _sommaren_, _kan__vi_, _noen__tips_, _prestixi,
   {{0xf49a602a,0x34a5b00f,0x64b98010,0xd15e2005}},	// [ec0] _være__et_, _kurangiz, _disponer__de_, _породичн,
   {{0x8200c005,0xdb0d7014,0x22a6d040,0xc44c5028}},	//   _veliki_, _cancións_, _aneb_, _pensar__en_,
   {{0xdf21001b,0x547ad007,0x9a4df00c,0x00000000}},	//   _kusetyen, _nebo__se_, _को__ठीक_, --,
   {{0xa4ace02a,0x2493a02a,0xd3a2e014,0xf47fb007}},	//   _har__vi_, _og__kan_, _exipto_, _toho__jak_,
   {{0x9301f005,0xee885005,0xcd3ea007,0xe8a44005}},	//   _detaljni_podaci_, _да__га_, _navigace_, _број__држава_,
   {{0xf320a011,0x3b7c800b,0x64be2028,0x97b5e00c}},	//   _noma__ngabe_, _བརྩི__སྲུང_, _reproduc_de_, _पर__विश्वास_,
   {{0xd3ea703b,0xb32c8004,0xfecba00c,0x00000000}},	//   _bente_, _no__site_, _से__युक्त_, --,
   {{0xd4b96013,0x43ea7014,0x082ce00e,0x0a16400b}},	//   _vrste__su_, _xente_, _འཁྱིལ_, _འཐབ__ནིའི_,
   {{0xa8cda005,0xbbcc000a,0xf2bdf007,0x127e3003}},	//   _asteroid, _ईहे_, _rozdíl_, _yomntu_,
   {{0x2bde900c,0x00000000,0x00000000,0x00000000}},	//   _यदि__हम_, --, --, --,
   {{0xb293000d,0xcbc7f020,0x4b9b000b,0x00000000}},	//   _storočia_, _བདག__པོ_, _ཉམས__ོང_, --,
   {{0x6b8ea01a,0xd474a022,0x4058e007,0x00000000}},	//   _वह_, _sabía__que_, _je__několik_, --,
   {{0x2f0ce00e,0x182ce00b,0xc473a021,0xb290102c}},	//   _འཁྲུལ_, _འཁྲིལ_, _slutten__av_, _unhas_,
   {{0x9ed5900f,0xe25b600b,0x00000000,0x00000000}},	//   _ubwishin, _དེམ__ཅིག_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xbfb61007,0x749a400f,0xe438a010,0x00000000}},	//   _ještě_, _umushinj, _la__venta_, --,
   {{0x2c8d902a,0x22c90010,0xd294e00e,0x00000000}},	// [ed0] _lær__hvordan_, _de__teléfono_, _ཤིག__ཡིན_, --,
   {{0xf2f76040,0xb495e00d,0x3320b011,0x5e923005}},	//   _जरुरी_, _sa__do_, _ancyl_, _постала_,
   {{0xcadbc00a,0xc2c4e011,0x03018004,0x00000000}},	//   _मेहरारू_, _magwaza__msibi_, _do__produto_, --,
   {{0xa3fba007,0x0494300d,0x31283005,0x00000000}},	//   _měli__byste_, _keď__som_, _планинск, --,
   {{0xb3853010,0x00000000,0x00000000,0x00000000}},	//   _del__mercado_, --, --, --,
   {{0xb2b9c007,0xb2cec036,0x6bf0900c,0x9fab3007}},	//   _více_, _na__kopnu_, _में__भी_, _nemovito,
   {{0x229af00b,0x1c6e0010,0xf48df00d,0x74b1f004}},	//   _ཐོན__རིམ_, _podría_, _ak__ste_, _de__dezembro_,
   {{0xc2366026,0xb2ede005,0x827eb011,0x8ca7c00c}},	//   _broj_, _godine__poslednj, _konke__lokhu_, _और__आपके_,
   {{0xc4bad02a,0x33548010,0x124df00e,0x12aac00d}},	//   _ikke__en_, _mujeres_, _ཤོད_, _vôbec_,
   {{0x129e7014,0xa2bfd014,0x7a89f00c,0x00000000}},	//   _un__filme_, _que__sexa_, _उपलब्ध__हैं_, --,
   {{0x1813e011,0x135bd01f,0x54bcd007,0xd7c93005}},	//   _uthe__amaphoyi, _kongera_, _jsem__se_, _партизан,
   {{0x6a3d200a,0x23dce023,0xee94d005,0x69dd0007}},	//   _हईं_, _haiwan_, _требало__да_, _stáhnout_,
   {{0xc29b600e,0xb71e000a,0xf24d900e,0x8e56e005}},	//   _བོད__ཡིག_, _गोड़_, _སྣེ_, _уз_,
   {{0xc20d9006,0xf2916003,0x3b36500b,0x00000000}},	//   _sehari__hari_, _umgaqo_, _ཉམས__སྲུང_, --,
   {{0xa3e7200d,0x19beb00f,0x14779021,0xc9f82011}},	//   _ešte_, _abadepit, _gang__har_, _endebeni__yomhlaba_,
   {{0x1c0c100c,0x88129011,0x7bcf9024,0x21d9601a}},	//   _लिए__एक_, _kulo__mqhudelw, _གཞན__གང_, _देकर_,
   {{0xf24c0018,0xd1e1300c,0x1b8cb00a,0xe04d6007}},	// [ee0] _ཉིད_, _हमारे_, _कए_, _prohlíže,
   {{0xcfa32015,0x92b4d012,0xc59ef00a,0x52918005}},	//   _boleh__digunaka, _djecu_, _चढ़त_, _morao_,
   {{0x427ed010,0x72a02012,0x6a98a021,0xd2918014}},	//   _bien_, _svijetu_, _transaks, _foran_,
   {{0x0c140029,0x527ed00d,0xb495e00d,0xac12e00b}},	//   _gruppen_, _cien_, _sa__to_, _ཏོག__ཏོ_,
   {{0x844f8022,0x66c96068,0x72ba1011,0x0bfac00b}},	//   _sé_, _देखि_, _equatori_guinea_, _ཚུ__ནང_,
   {{0x6ca4c005,0xe485b00d,0x64865004,0x28d59005}},	//   _густина_, _ohľadu__na_, _fáceis__de_, _уговор_,
   {{0x53f8201b,0x9989c00d,0x2da8f023,0x0ba2d010}},	//   _koku_, _záhrada_, _kesihata, _el__formular,
   {{0x30940007,0x99aeb007,0x3a50800c,0x00000000}},	//   _nabízíme_, _současné__době_, _रहा__हूँ_, --,
   {{0x862ac03b,0x5468e021,0x738fd01c,0xc4a95011}},	//   _navigeri, _deg__om_, _senyawa_, _bokhozi__fm_,
   {{0x944f8007,0xe471c011,0x7eb3f005,0xd5e1300c}},	//   _té_, _ukuqinis_ukuthi_, _која__се_, _करना__चाहते_,
   {{0xd972c010,0x32d07021,0x34a8a014,0x00000000}},	//   _opinione, _på__noen_, _rexional_, --,
   {{0x83f8201b,0x4d8c7013,0x3b98600c,0x9a064004}},	//   _noku_, _način_, _को__यह_, _quanto__você_,
   {{0x7a3d200c,0x7f807027,0xee292005,0x82bbd011}},	//   _हैं_, _yang__tergolon, _пад_, _ngeke__akwazi_,
   {{0x38593032,0xabd0e010,0x64bcb028,0x00000000}},	//   _empregos_, _compañer, _propieta_de_, --,
   {{0xf44b0005,0x2a35b00b,0x00000000,0x00000000}},	//   _srednjoj__nadmorsk, _ོད__མིའི_, --, --,
   {{0xabfb4003,0x1c631004,0x58531004,0x6c605014}},	//   _kuya__kufuneka_, _assunto_, _assuntos_, _doutros_,
   {{0x64706014,0xfdd0d00b,0xb4726004,0xe5cf0005}},	// [ef0] _rei__de_, _བཟའ__སྤྱོད_, _parte__do_, _општинск,
   {{0x03ea7034,0xc290e017,0x75f8601e,0x8cf4200e}},	//   _henta_, _finais_, _रिपोर्ट_, _ཏུ__གྱུར_,
   {{0xc29f7009,0x0b57f00d,0x53f9901c,0xe3f51011}},	//   _berbagai_, _kultúra_, _yesus_, _kuleli__sonto_,
   {{0x2de0000e,0xd9f5a011,0x524cd00e,0x00000000}},	//   _བྱས__རྗེས_, _endaweni__yesigame, _ཏིང_, --,
   {{0xd2907038,0xcbcc300a,0x965e1005,0xbca1200c}},	//   _innan_, _ऊहे_, _фирме_, _जो__अपने_,
   {{0xe2c25017,0x82af800e,0x00000000,0x00000000}},	//   _inglesa_, _མི__ཐུབ_, --, --,
   {{0x1b9b700b,0xd316000f,0x1778d00c,0x9bf7400b}},	//   _རྒྱལ__ལྔ_, _myiza_, _पोस्ट__किया_, _འི__ལས_,
   {{0x3b8ed00a,0xe2d83004,0xc4aaf02a,0x95feb005}},	//   _एह_, _hoje_, _det__nye_, _учествов,
   {{0x7554502a,0x53f83005,0xab93b018,0xb4835021}},	//   _et__eksempel_, _koju_, _རང__བྱུང_, _vite__at_,
   {{0x6a338011,0x7ae5e00d,0x00000000,0x00000000}},	//   _le__ngqungqu, _je__nevyhnut, --, --,
   {{0x94b02014,0x00000000,0x00000000,0x00000000}},	//   _non__sei_, --, --, --,
   {{0xe2d59003,0x0379a003,0x6707d00c,0x00000000}},	//   _ukwenza__ukuba_, _uphando_, _पर__बहुत_, --,
   {{0x5ed96022,0x2316000f,0xebd7900e,0xe394d011}},	//   _noticias_, _byiza_, _མཐུད__ཡི_, _ujesu_,
   {{0x52907038,0x7c747038,0x49e3c036,0x3201c013}},	//   _annan_, _særleg_, _datoteka_, _novih_,
   {{0x1307d023,0xc68d000a,0x00000000,0x00000000}},	//   _sarawak_, _बियाह_, --, --,
   {{0xb86ca00b,0xfe6ca004,0xdc523014,0x92fc4010}},	//   _ཡོདཔ__དབྱིན_, _opiniões_, _contén_, _un__nombre_,
   {{0x9405c005,0x0427a009,0x548f500d,0x0bff800c}},	// [f00] _je__živelo_, _yang__saat_, _diskov__cd_, _खुद__को_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x50753005,0xfaa3500c,0xb28cb00c,0x4a33d00a}},	//   _из__године_, _आपके__पास_, _उन्होंने_, _जखन_,
   {{0xdcadd00f,0x2a74a005,0x1248d005,0x00000000}},	//   _imiyobor, _табели__испод_, _vreme_, --,
   {{0x5a32b002,0x56916003,0xfbeaf00b,0xd2dd0010}},	//   _खाई_, _elithaty, _འཕྲུལ__དང_, _de__citas_,
   {{0x04781021,0x2404902a,0x72ad6011,0x72dd1010}},	//   _informas_som_, _støtter_, _naleli__qembu_, _de__agua_,
   {{0x13096023,0x144fc007,0x3438a010,0x7242b00e}},	//   _anda__boleh_, _jí_, _la__gente_, _བའོ_,
   {{0x444fc010,0xd3c75007,0x32fb8013,0x3d368011}},	//   _mí_, _hospodář, _njihovo_, _izingane_,
   {{0xc9f4c007,0xc48f600d,0xdfaba01c,0x4f39e023}},	//   _lidé_, _ak__je_, _direktur_, _memulaka,
   {{0xa44fb004,0x624e500e,0x22d3f019,0x00000000}},	//   _dê_, _རྣལ_, _produtos__para_, --,
   {{0x544fc007,0x22d84038,0x96458031,0x2d48f005}},	//   _ní_, _kome_, _ukuhlazi, _др_,
   {{0xa91bc005,0x828b200b,0x00000000,0x00000000}},	//   _je__asteroid, _གནས__ཚིག_, --, --,
   {{0x2442603a,0x844fc004,0x900a0005,0x00000000}},	//   _ido_, _aí_, _википеди, --,
   {{0x9236900d,0x647ed021,0x43ed6010,0x00000000}},	//   _vraj_, _nettsted_for_, _del__cuerpo_, --,
   {{0x44426007,0xef01f024,0xd369501c,0x8bd4b00b}},	//   _kdo_, _བསྡུར_, _inggris_, _འཐབ__གས_,
   {{0x52d84004,0x82cd9009,0x62e3e036,0x7ec44005}},	//   _nome_, _bagian__barat_, _iz__kada_, _којој__се_,
   {{0x148b3013,0xbc071029,0x00000000,0x00000000}},	// [f10] _izgradnj, _ønsket_, --, --,
   {{0x6cc1100c,0x829f000b,0xbbc4300c,0x00000000}},	//   _प्रारंभ__करने_, _སྒྲོན__དབང_, _किए__जा_, --,
   {{0x2b8fd00c,0x348c702a,0x748f6028,0xe4253011}},	//   _थी_, _svar__på_, _de__ee_, _phephand_ukuthi_,
   {{0xf4787003,0xf3f9200d,0x0bbd400b,0xe343c017}},	//   _lemfundo_, _albumy_, _ལུ__ནང_, _imperio_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd25ad003,0xaebdb00d,0x8a640023,0xec00a00c}},	//   _kweli_, _hodnoten, _nama__sainsnya_, _रखने__के_,
   {{0x7bdfb02b,0x00000000,0x00000000,0x00000000}},	//   _གིས__ཡང_, --, --, --,
   {{0xd498e014,0xc2374014,0x64962021,0xa2bdc00d}},	//   _máis__que_, _dos__máis_, _se__for_, _pokiaľ_,
   {{0x9296c011,0xe2ca5038,0x4c76b027,0xc4465010}},	//   _odlala__indawo_, _heldt_, _ditukar_, _cuando__la_,
   {{0x92f5901c,0xe2125019,0x43860004,0xd21db014}},	//   _program__studi_, _folha_, _sair_, _orixinal,
   {{0x44469011,0x00000000,0x00000000,0x00000000}},	//   _bongani__mbatha_, --, --, --,
   {{0x7399a007,0x938d6014,0x3291301d,0xd2faf021}},	//   _místa_, _de__goberno_, _vanjske_, _som__holder_,
   {{0x63f85003,0xa44fc010,0x2444f023,0xdb6c2036}},	//   _kolu_, _sí_, _ialah__haiwan_, _spomenic,
   {{0x7e7c5005,0x29fb400e,0x9bda300b,0x94c3200f}},	//   _може__се_, _ལྟ__བུའི_, _ཐོན__ངས_, _sisitemu__ya_,
   {{0xca33b002,0x7ae8503b,0xc47f9021,0x2349b00f}},	//   _आँख_, _jacobsen_, _resultat_av_, _abafite_,
   {{0x72dfc011,0x1c66c014,0x5e5b7013,0x3291c013}},	//   _lo__msakazo_, _mentres_, _najbolje_, _jovan_,
   {{0xe9eaa011,0x4b8f900e,0x00000000,0x00000000}},	// [f20] _njengoba_, _སེ_, --, --,
   {{0x7f803005,0xbcb34010,0x22bd9010,0x7bbb300b}},	//   _је__имала_, _de__febrero_, _ideas__para_, _དེ__ཁང_,
   {{0xa2918038,0xbbcc600a,0xd2f5e023,0xc24cd00e}},	//   _vera_, _इहे_, _senarai__nama_, _ཏྲེ_,
   {{0x73d88013,0x12010036,0x92590010,0x00000000}},	//   _od__metra_, _dobija_, _su__equipo_, --,
   {{0x6be2100c,0x528b6007,0x7abde00c,0x52d8300f}},	//   _तो__आप_, _pomocí_, _निश्चित__रूप_, _remezo_,
   {{0xc329f02a,0xa1c3c007,0x63e8d005,0x00000000}},	//   _på__eller_, _evropské_, _услед_, --,
   {{0xfb191023,0xc2bf6010,0xbbc6900c,0x00000000}},	//   _empangan_, _no__todos_, _कौन__सी_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfd8c7036,0x03084004,0x00000000,0x00000000}},	//   _tačno_, _proteção_, --, --,
   {{0xc310f01d,0x748fa021,0x00000000,0x00000000}},	//   _zeebovu_, _gå__inn_, --, --,
   {{0xf2919028,0xe0f9f014,0x82a3c003,0xfa45f011}},	//   _cosas_, _traxecto, _ukuba__ufumane_, _bese__uchofoza_,
   {{0x22326010,0xf3291023,0x6e226010,0xa3735003}},	//   _miembro_, _berhampi_dengan_, _miembros_, _kunye__nabantu_,
   {{0xfa330064,0x427ec009,0xc4b46010,0x9e373031}},	//   _चयन_, _halnya_, _por__la_, _langapha,
   {{0x8201a008,0x1c73e00e,0x1b47900c,0xf2670005}},	//   _cepi_, _ཀྲུའུ_, _लिक्खाड़_, _веку_,
   {{0x5b8fa024,0x041d4023,0x34a4e00d,0x04109011}},	//   _ཧེ_, _rujukan__pautan_, _čo__sa_, _anc__youth_,
   {{0xf31cf009,0xe29fb011,0xf4722021,0x4bd0e014}},	//   _menikah__dengan_, _kulolu__daba_, _datamask_din_, _compoñen,
   {{0x14ba102a,0x5b8ea00b,0x8686e00a,0xeba3800c}},	// [f30] _ikke__har_, _ིད_, _कहवाँ_, _ग्राहकों__के_,
   {{0x83878032,0x3386900d,0x3386d00f,0x9fe01007}},	//   _carro_, _ktorí_, _nzeri_, _ve__své_,
   {{0x02b6400e,0xc3171027,0x43a3300d,0x4a1d800b}},	//   _པར__རིས_, _di__bandar_, _televízi, _ཨེན__ཨེསི_,
   {{0xb4ac2011,0x5288a00b,0x82b63014,0xbee3f007}},	//   _kodwa__uma_, _འབད__དཔར_, _hai__unha_, _svým_,
   {{0x32fbc005,0x6033d005,0x00000000,0x00000000}},	//   _авиона_, _довољно_, --, --,
   {{0xd44a300d,0x00000000,0x00000000,0x00000000}},	//   _lepšie__ako_, --, --, --,
   {{0x1bee1005,0xc472d010,0xe46e9011,0x0692b00c}},	//   _како_, _sobre__la_, _kuliqini_ukuthi_, _के__आसपास_,
   {{0x0a7e000f,0xbbcea00c,0x527ef00e,0x9bd1100c}},	//   _byandits, _किया__जा_, _ལྷ__སའི_, _चाहिए__कि_,
   {{0xa2d7b014,0xb386900d,0x03c39005,0xe28dc00e}},	//   _pola__súa_, _ktorý_, _на__основу_, _ཐུན__མོང_,
   {{0x7e97f005,0x37d0300f,0x282f800e,0x194ff029}},	//   _којима__се_, _byagarag, _པུའུ_, _koblinge,
   {{0x9ad29010,0x33f8f00d,0x62a6900f,0x3066d00a}},	//   _contrase, _ponuky_, _byabo_, _कहलसी_,
   {{0xc9a9e005,0x3292600e,0x72a6900f,0x247be021}},	//   _на__средњој_, _ཞིང__ཆེན_, _cyabo_, _last__ned_,
   {{0xc5663005,0x796e5004,0x7d9b100b,0x00000000}},	//   _godine__živjelo_, _assinant, _གཞུང__ཚོགས_, --,
   {{0x03eb3032,0x96fa400a,0xc46ad010,0x00000000}},	//   _sexta_, _पइसा_, _obtener__la_, --,
   {{0xe27e602e,0x124d9020,0xcbcc700a,0x76d7f00c}},	//   _ibona_, _འགའ_, _उहे_, _चाहिए_,
   {{0x8c49d00a,0xa35bb013,0x33f40017,0x5d3d3007}},	//   _नइखे_, _njegova_, _restos_, _aplikace_,
   {{0x72fcd01d,0x746b4021,0xbc099011,0x00000000}},	// [f40] _bloger_, _gjøre__noe_, _phansi__ngonyawo_, --,
   {{0xc4429040,0xe36fb003,0x6a69c00c,0x1da4600f}},	//   _zda_, _kuyo__nayiphi_, _हैं__तथा_, _nshingwa,
   {{0x42d9e021,0xf9f47007,0xf4b3f003,0xb486d005}},	//   _leter_, _jiné_, _zematrik, _имена_,
   {{0x6b88100c,0x00000000,0x00000000,0x00000000}},	//   _नई_, --, --, --,
   {{0x1257e00e,0x2cc19033,0x00000000,0x00000000}},	//   _བྱུང__བཅུ_, _om__hvordan_, --, --,
   {{0x76e0f00c,0x64a20010,0x422a2005,0x22fe700c}},	//   _पर__विचार_, _después__de_, _тога_, _की__जरूरत_,
   {{0xebc0a00c,0x2ddeb00c,0x00000000,0x00000000}},	//   _होने__के_, _के__जरिए_, --, --,
   {{0x643b0024,0xfec8c028,0x62a3200b,0x7390c010}},	//   _གིས__རྒྱལ_, _movimien, _སྦེ__བཟོ_, _el__derecho_,
   {{0x2292201c,0x9982e030,0xcc0d9029,0x8c07f004}},	//   _secara__resmi_, _beskrive, _instruks, _várias_,
   {{0x6308702a,0x04a35007,0xc02d6005,0x00000000}},	//   _som__alle_, _stránce_, _совјетск, --,
   {{0x827ed01b,0x127f5004,0x15a70007,0x966d5010}},	//   _tsonga_, _não__são_, _vám__pomůže_, _al__principi,
   {{0xc2763006,0x527eb00d,0x2cf1500c,0xb3f40004}},	//   _laki__laki_, _umenie_, _लिए__आवश्यक_, _testes_,
   {{0x7ce90026,0x1320a00f,0x6c799005,0x00000000}},	//   _plastičn, _nibyo_, _његову_, --,
   {{0xd6076005,0x00000000,0x00000000,0x00000000}},	//   _слатково, --, --, --,
   {{0x14545012,0x214ef01b,0x02c1e007,0x4d35a005}},	//   _iznosi__km_, _ukufikel, _byste__měli_, _планете_,
   {{0x62da600f,0xfb9d7029,0x12f69014,0xe20ec005}},	//   _gereza_, _angående_, _súa__obra_, _напад_,
   {{0x6e81c023,0x6a33300a,0xf4548021,0xdb0f5004}},	// [f50] _memudahk_sumbanga, _घाघ_, _har__hatt_, _para__crianças_,
   {{0xd37fd01d,0x7354d010,0x52b8400d,0x29a50011}},	//   _povezani__članci_, _quieres_, _budete__musieť_, _eku__inthanet,
   {{0xb315a003,0xe4b6a02a,0x00000000,0x00000000}},	//   _ukuba__ngaba_, _hvert__år_, --, --,
   {{0xe4213011,0xd290b03d,0x6be8b00c,0xcbf4600c}},	//   _ucabanga__ukuthi_, _indaba_, _कहीं__भी_, _जल्दी__ही_,
   {{0x7bbb702b,0x1246b007,0x00000000,0x00000000}},	//   _ནི__ཡང_, _nahlásit_, --, --,
   {{0x12fd201c,0xbbe2900b,0x00000000,0x00000000}},	//   _militer_, _ཆོས__ོན_, --, --,
   {{0x4bffe00c,0x00000000,0x00000000,0x00000000}},	//   _से__संबंधित_, --, --, --,
   {{0xe38a1014,0xf5809007,0x64bad004,0xae488005}},	//   _fóra_, _použít_, _setor__de_, _значај_,
   {{0xe2de201c,0xfa63d00c,0x77f7f005,0x00000000}},	//   _di__jepang_, _उनके__पास_, _највећа_, --,
   {{0xe4bad02a,0x7b29d004,0x129ef00d,0x62e4a011}},	//   _ikke__er_, _justiça_, _vo__filme_, _nabanye__abaholi_,
   {{0x5c61d00c,0x42f1d00c,0xdba9200f,0xae059023}},	//   _कर__सकते_, _कर__सकती_, _ubukerar, _kenderaa,
   {{0xd5546003,0xa24ed00b,0x00000000,0x00000000}},	//   _ngokutsh, _ཨོམ_, --, --,
   {{0x4b46800f,0x6c0b900c,0x3c0a800c,0x00000000}},	//   _ibi__birashob, _लिए__आप_, _लिए__जो_, --,
   {{0x4442b008,0x8543e01c,0x9bc9f00b,0x00000000}},	//   _adc_, _berhasil_, _གོང__ལས_, --,
   {{0x6f3b0009,0xa3966026,0x828fa02b,0xd9ec5022}},	//   _keluraha, _spusti_, _མེད__དབང_, _colombia_,
   {{0x0c00000b,0xc84c6007,0xec00a00c,0x00000000}},	//   _སི__སི_, _způsob_, _बचने__के_, --,
   {{0xe4696011,0x624c3003,0x52978011,0x94955011}},	// [f60] _kulindel_ukuthi_, _eli__nqaku_, _le__ngoma_, _ku__anc_,
   {{0x3e9d9014,0x42e43010,0x00000000,0x00000000}},	//   _tódalas_, _se__basa_, --, --,
   {{0x5a3ca00a,0x7bc2b00c,0xe243400e,0x00000000}},	//   _रउआ_, _गयी_, _པའང_, --,
   {{0x34d6e002,0xe524c014,0xcba65003,0x9bca700b}},	//   _बढ़िया_, _un__concello_, _kwiimeko_, _ཐུག__ལས_,
   {{0x4e952005,0xc2df8011,0xd9f7a00f,0xb3866005}},	//   _капаците_од_, _leli__thuba_, _bibiliya_, _skoro_,
   {{0xa2967011,0xc257900e,0xc5327005,0x00000000}},	//   _lolu__hlelo_, _གསེར__གྱི_, _септемба, --,
   {{0x93e90014,0xdebf1011,0xe24d900e,0xdc3c4011}},	//   _con__outros_, _mahlangu__nkabinde_, _སླད_, _izinsuku_,
   {{0x324d900b,0x6de7e005,0x0bf2000b,0x00000000}},	//   _སླབ_, _је__више_, _གས__ཅན_, --,
   {{0x6201c019,0x4b8ed00e,0xdb8bb00e,0x9be7e00e}},	//   _envie_, _ཏཱ_, _ཞེས__གསུངས_, _བྱེད__མི_,
   {{0x679a2024,0x673a2018,0x22d7e005,0x2e654005}},	//   _སྟོན_, _སྟོད_, _се__користи_, _просечна__старост_,
   {{0x84b4e014,0x12eee038,0x70855010,0x00000000}},	//   _son__os_, _kaffi_, _su__ordenado, --,
   {{0xfe871014,0x82fd5010,0xc38c2005,0x44adf00d}},	//   _de__xuño_, _llegar_, _путем_, _že__nie_,
   {{0xf46f8003,0x3315a014,0x42011010,0x94661021}},	//   _loo__nto_, _de__cando_, _cocina_, _hjelper__deg_,
   {{0xa4b4e014,0x637f9009,0xd248d01f,0x9201100f}},	//   _son__as_, _rahasia_, _ugomba_, _mubiri_,
   {{0x1230700f,0x9bf5402b,0x99db300f,0x74d92004}},	//   _nyamara_, _མི__ལས_, _ibyereke, _direção_,
   {{0xfb2a2020,0xb4cf4005,0xf4ada033,0x02d8d004}},	//   _སྟེང_, _за__време_, _for__din_, _ordem_,
   {{0x0290c019,0x530d0028,0x2683900a,0xd2a9e02b}},	// [f70] _ltda_, _locales_, _बुझात_, _གི__བཅའ_,
   {{0x644ad004,0xdff03014,0x227b200b,0x00000000}},	//   _depois__de_, _reacción, _ལས__འོང_, --,
   {{0xc495602a,0x34429029,0x7bbb9018,0x23eae027}},	//   _og__en_, _hva_, _ནི__རང_, _rantau_,
   {{0x64429038,0x9245e007,0xeeb13005,0xc2e81011}},	//   _kva_, _dům_, _prostire_, _ngoba__abantu_,
   {{0xd2d8901d,0x02fce023,0x1d2c3005,0xd4b06010}},	//   _htjela_, _pingat_, _sedište_, _tiene__que_,
   {{0x612fd005,0xcd493005,0xb4be3010,0x6a51500c}},	//   _slatkovo, _грб_, _consulte__el_, _भी__तरह_,
   {{0xb201e00d,0x1291c00d,0x028bf011,0x5175d004}},	//   _deti_, _tovar_, _omunye__umuntu_, _vitória_,
   {{0x9ba5b00c,0x8bccd00a,0x49f6400d,0xa2efa004}},	//   _है__कि_, _एही_, _štýl_, _bem__vindo_,
   {{0xd442d02f,0xa442c008,0x9f8b1023,0x04993010}},	//   _ide_, _fdd_, _perlu__mempunya, _personaj,
   {{0x0290c038,0x23086011,0xe45df011,0x498c900f}},	//   _sidan_, _united__nations_, _khona__ukuthi_, _ubuhanga_,
   {{0xcbddd02d,0x23660011,0xd3738007,0xda965021}},	//   _बढिया_, _le__nsizwa_, _redakce_, _eiendoms,
   {{0x0b99f00c,0xe442d007,0x34b45005,0xe4420011}},	//   _की__ओर_, _jde_, _galaksij_sa_, _okusho__ukuthi_,
   {{0xab8a502b,0x22e9c005,0x31d9c005,0x5789c005}},	//   _རྐྱེན__བྱུང_, _његова_, _његове_, _његово_,
   {{0x6200c012,0xebc2b00c,0x739ab014,0x73f40017}},	//   _vidio_, _गये_, _véxase_, _destas_,
   {{0xbcada024,0x0bd2d01d,0x32018038,0x1c597027}},	//   _དམངས__གཙོའི_, _spajalic, _dorit_, _peluang_,
   {{0x434c0021,0x92fcc010,0x9a64d004,0x00000000}},	//   _leter__etter_, _su__nombre_, _por__você_, --,
   {{0x5b170023,0x9197c005,0x7e4a2011,0x04570007}},	// [f80] _nama__penyelia_, _такође_, _ama__olympics_, _vhodný__pro_,
   {{0xe4420029,0x6650500d,0x54469007,0x1bda500e}},	//   _hei_, _ďakujem_, _naučte__se_, _མེད__པས_,
   {{0x7291e02e,0x8213900d,0xcb3a0024,0x8a57000d}},	//   _reta_, _najnovši, _ཆེ__མཆོག_, _domáce_,
   {{0xb6a47036,0x3faaa011,0xd3113014,0x3483e021}},	//   _broju__stanovni, _le__nhlangan, _polas__súas_, _dine__på_,
   {{0x62603010,0xbeb32010,0x73432028,0x9fe79007}},	//   _año_, _derechos_, _derecho_, _dnů_,
   {{0xfa3d5061,0x844d1014,0x9bcde00a,0x9e11f005}},	//   _रहन_, _relación__ao_, _तनी_, _омогућав,
   {{0x82d83010,0x3dd93023,0x92a7800d,0xa097d005}},	//   _mujer_, _berkenaa, _farba_, _промене_,
   {{0xb4505005,0x52484011,0xfbe8000e,0xf3574004}},	//   _dolazi__do_, _esihloko__sithi_, _བྱེད__པར_, _diretor_,
   {{0x87dd800b,0x22122011,0x05c07004,0xc4010004}},	//   _སེངྒེ_, _lokho_, _maravilh, _envie__seus_,
   {{0x726cf003,0xe442d007,0x3bf0600c,0x8c56200a}},	//   _inhoud_, _zde_, _में__यह_, _कहलें_,
   {{0xe4429013,0x00000000,0x00000000,0x00000000}},	//   _sva_, --, --, --,
   {{0x6320901c,0xb25a901c,0x0433c011,0xc6915004}},	//   _biaya_, _nuklir_, _lolu__suku_, _prática_,
   {{0xa4420038,0x42d8b007,0x846e8003,0x82a6900f}},	//   _dei_, _roce_, _ngo__ngo_, _byaba_,
   {{0x549ae014,0x0bc8e00c,0x92d9700d,0x8be6300c}},	//   _só__se_, _करना__है_, _videá_, _कर__रही_,
   {{0x0a09e00d,0xcc462003,0xddbd0027,0x72aaf024}},	//   _prešov_, _ulawulo_, _berhijra, _གི__གསལ_,
   {{0xbf9dd010,0xc4b4c021,0x708a8005,0x22f06011}},	//   _móviles_, _avhenger__av_, _својих_, _yeningi_,
   {{0x6f774005,0x00000000,0x00000000,0x00000000}},	// [f90] _jednu__državu_, --, --, --,
   {{0x55f0e033,0xaa3cf01e,0xb2a6e02b,0x9ce7400c}},	//   _hjemmesi, _शहर_, _གལ__གནད_, _से__आपको_,
   {{0xe4273011,0xb498e004,0x127af00b,0x00000000}},	//   _khumbula__ukuthi_, _ou__em_, _དེ__སྦེ_, --,
   {{0x238a100d,0x0c1d000d,0x00000000,0x00000000}},	//   _fóre_, _napísal_, --, --,
   {{0xc2cb8038,0x4386900f,0xc7b55023,0xc25b202b}},	//   _verda_, _byari_, _kepelbag, _བསྡུར__གྱི_,
   {{0x29cfe00e,0x9387e014,0x6cbab007,0xc34f300f}},	//   _བུའི_, _catro_, _udělat_, _umuganga__wawe_,
   {{0x62caf006,0x92009013,0xd4b37004,0x00000000}},	//   _mundur_, _knjiga_, _dizer__que_, --,
   {{0xc48fe021,0xa4393010,0xe23c0011,0x54553004}},	//   _gi__dem_, _el__resto_, _kahle__futhi_, _disponív_no_,
   {{0x7e54d003,0x93ff2023,0xc4025003,0xd914d003}},	//   _ukubanga, _talian__tujuan_, _lonke__ixesha_, _ukubangu,
   {{0xb747000d,0x33954014,0x7c62200c,0xb469b004}},	//   _správcov, _sueste_, _कर__सकें_, _era__uma_,
   {{0x6243400e,0xe4007011,0x6321a02f,0xad22700f}},	//   _པའོ_, _kuvele__ukuthi_, _dopyt_, _kwishyur,
   {{0x09caf00e,0xf2e7902c,0x1bc0700c,0x00000000}},	//   _ལྟའི_, _reinado_, _शुरू__कर_, --,
   {{0x14444010,0xab8f000b,0x24aee011,0x12414023}},	//   _pc_, _ོད_, _cup__of_, _mendafta_oleh_,
   {{0x3a318002,0x5386900f,0xda14300d,0x00000000}},	//   _इज्जत_, _cyari_, _rekonštr, --,
   {{0x74444004,0xc8f88005,0x8f3af027,0x66ff300c}},	//   _vc_, _литерату, _kemudaha, _आपका_,
   {{0x1c73f010,0x00000000,0x00000000,0x00000000}},	//   _es__difícil_, --, --, --,
   {{0xb26de01d,0x4a32b00c,0x6f03a00d,0x224a7011}},	// [fa0] _što_, _गया_, _veľký_, _isikwele_sakho_,
   {{0xf4a35007,0x9071c005,0x00000000,0x00000000}},	//   _počasí_, _књиге__народни_, --, --,
   {{0x6cc2f00f,0x3342c010,0xc2bf300e,0xe863d005}},	//   _ya__amerika_, _hacerlo_, _གྲགས__པའི_, _подаци_,
   {{0x52d8d03f,0x2eb8f005,0x90867003,0xe4b85011}},	//   _budem_, _када__је_, _iinqunun, _kusho__le_,
   {{0x32d8c004,0xcf41c005,0x5a55300c,0x0363a007}},	//   _pode_, _насељу__има_, _इस__समय_, _národní_,
   {{0x7eb4b005,0x00000000,0x00000000,0x00000000}},	//   _који__се_, --, --, --,
   {{0x22f6b006,0xd3f8c012,0xfbcc600a,0x52e4500f}},	//   _bahan__bakar_, _vodu_, _इहो_, _ushobora__gukora_,
   {{0xb9f5c00d,0x34b39011,0xcb1fb00b,0xec05d00c}},	//   _novú_, _njengoba__lo_, _ཞབས__མཆོག_, _आकार__के_,
   {{0xfbe6300c,0xb495f021,0xf46ed005,0x94b87021}},	//   _कर__रहे_, _så__mye_, _према_, _forsikre__deg_,
   {{0xacdfd00b,0x06fef02d,0x64b35010,0x5c350014}},	//   _མངའ__གསོལ_, _टोला_, _largo__de_, _descuber,
   {{0x3249f008,0xb23e8005,0x3712200c,0xb687600a}},	//   _iguma_, _severois_godine_, _कर__सकता_, _जहवाँ_,
   {{0x3e9da005,0xc2a3600b,0x63e3f005,0x00000000}},	//   _ограниче_на_, _འདོན__འབད_, _пројекат_, --,
   {{0x67d55024,0x2de28011,0x2ba5f00c,0x528d700d}},	//   _བདག__འཛིན_, _utshele__isolezwe_, _हो__गए_, _vo__svojom_,
   {{0x2387f01c,0x83e96004,0xd3c44010,0x00000000}},	//   _istri_, _exposiçã, _puede__obtener_, --,
   {{0x92902038,0x72007023,0xebd69018,0x124da00e}},	//   _auka_, _minit_, _མཐའ__དག_, _སྲང_,
   {{0xabf9802b,0x1c90b00c,0x842da011,0x37d0c005}},	//   _མི__དེ_, _दोनों_, _senzo__mchunu_, _многи_,
   {{0x53eb900d,0x49cef04a,0x3e0ef034,0x6212b028}},	// [fb0] _mesto_, _forfatte, _forfatta, _noche_,
   {{0x0ad07029,0x00000000,0x00000000,0x00000000}},	//   _kontinue, --, --, --,
   {{0xb59c3004,0x3e591015,0xb497e010,0xfc9cb004}},	//   _legislaç, _perbinca, _si__el_, _uma__empresa_,
   {{0xfedc6010,0x82a66007,0xfc26900f,0xbbfb700b}},	//   _opciones_, _osob_, _gukangur, _པོ__ཚུ_,
   {{0x63871007,0x42b4001f,0x0c0c000b,0x00000000}},	//   _který_, _kwica_, _ཅིག__ནང_, --,
   {{0x02786011,0x143b8021,0xaa499010,0x97840014}},	//   _umuntu_, _et__nytt_, _si__está_, _xeográfi,
   {{0x4d101010,0x32e6f021,0x9c71500f,0x88044007}},	//   _encuentr, _det__noen_, _abarimu_, _určitě_,
   {{0x9f25b004,0x7200f021,0x29596005,0x00000000}},	//   _qualquer_, _angir_, _најзнача, --,
   {{0x5eec6007,0xa2d87010,0x00000000,0x00000000}},	//   _svých_, _lunes_, --, --,
   {{0x32903008,0x1442303f,0x048d702a,0xdea40007}},	//   _kuja_, _jej_, _de__vil_, _řízení_,
   {{0x27bda021,0x6a3cd00a,0xfdb96010,0xd2c5a024}},	//   _ytterlig, _एहि_, _dominica, _ཕྱག__དཔེ_,
   {{0x22fd5023,0x63eb9026,0x23fd3021,0x23f96014}},	//   _usaha__sama_, _nesto_, _helt__klart_, _seguen_,
   {{0x6e28e005,0x524d700b,0x8eb8e005,0x49676003}},	//   _та_, _ོགས_, _ти_, _kwiintet,
   {{0x5442302f,0xb4471003,0xafb2e00d,0xf49eb00d}},	//   _nej_, _iinjongo_, _musí__byť_, _je__skutočne_,
   {{0xab98300e,0x933fb021,0x1fd55007,0x64802010}},	//   _རབ__བྱུང_, _det__gjelder_, _předevší, _multitud__de_,
   {{0x12fe100c,0x063c3013,0xbc70a00c,0xf326d004}},	//   _की__ज़रूरत_, _njegovim_, _हम__अपने_, _do__boxe_,
   {{0x53f8f01d,0x9b8f300b,0xebb06018,0xce0d2005}},	// [fc0] _mogu_, _ེད_, _ཡང__དག_, _ова_,
   {{0xb46fe023,0xf0581007,0x782d000b,0xe2f5d011}},	//   _pemuzik__dan_, _které__potřebuj, _འཁྐྲི_, _ublack__coffee_,
   {{0xb4422038,0x94432007,0xf37a000f,0x527f7028}},	//   _tek_, _kdy_, _magambo_, _cuanto_,
   {{0xa4420031,0x4c61b01f,0xcb98f00e,0x13417007}},	//   _kwi_, _akarere_, _དམར__པོ_, _bez__ohledu_,
   {{0x4bddd00b,0x09f4c007,0x94810010,0x00000000}},	//   _གསོལ__ལོ_, _lidí_, _de__efectivo_, --,
   {{0x76514005,0x1442d00d,0x6d3d901d,0x0e4ce009}},	//   _године__живјело_, _dve_, _povijest_, _dikarena,
   {{0x13965003,0x64c66004,0x00000000,0x00000000}},	//   _matshi_, _criação__de_, --, --,
   {{0x4a73700c,0x22005023,0x89d7f00a,0x322a7005}},	//   _किया__गया_, _bilik_, _बरियार_, _моја_,
   {{0x23947004,0x5386201d,0x01fbe02b,0x00000000}},	//   _série_, _šmrka_, _རྒྱལ__གསུམ_, --,
   {{0xc49d102a,0x74b59005,0x5987800d,0xc2ca9007}},	//   _også__en_, _је__члан_, _páči_, _řada_,
   {{0x5c48f00c,0x1494a02a,0x42d8f00c,0x8c339011}},	//   _सकते_, _og__har_, _सकती_, _nakwezin_izindawo_,
   {{0x4c38500d,0x6a56300c,0xc44eb00d,0x4ab2b00c}},	//   _banská_, _कर__रहा_, _dispozíc_je_, _डोमेन__नाम_,
   {{0x8f5c7011,0x946d1021,0x00000000,0x00000000}},	//   _isithomb_thokozan, _holde__deg_, --, --,
   {{0xdb88402b,0xd490202a,0x62f0f02a,0x67ed400d}},	//   _འི_, _at__den_, _andre__steder_, _futbalov,
   {{0x8c4f600c,0x9c8f600c,0x62df600c,0xa5a6800c}},	//   _आपके_, _आपको_, _आपकी_, _चाहती_,
   {{0x64424004,0x00000000,0x00000000,0x00000000}},	//   _nem_, --, --, --,
   {{0x43eb8038,0xdb61f009,0x72904004,0x8be7d00e}},	// [fd0] _verte_, _sinetron_, _numa_, _ཤེས__བྱ_,
   {{0xb496e007,0x078d700c,0xc3567004,0x1451a010}},	//   _se__do_, _प्रविष्ट, _receber_, _del__norte_,
   {{0xb4af6049,0xa4424004,0x327f7004,0x52484038}},	//   _for__at_, _bem_, _quanto_, _ramma_,
   {{0x52da7005,0xdc896007,0x6473d010,0x00000000}},	//   _meseca_, _ve__městě_, _juego__de_, --,
   {{0xc4424030,0xb442300d,0xdee5c005,0xa2ca7030}},	//   _dem_, _tej_, _становни_општина_, _sendt_,
   {{0xa2ee0037,0x739ae014,0x00000000,0x00000000}},	//   _byinshi_, _fíxose_, --, --,
   {{0xf4af602a,0xcf24c007,0x238a9005,0x39e72005}},	//   _for__et_, _vaší_, _француск, _заједно_,
   {{0xc6b2600a,0xa254b007,0x8243e00e,0xe44c9010}},	//   _बहुते_, _dělat_, _གཉན_, _pueden__ser_,
   {{0x7c9be011,0x0277e00b,0x0250c005,0x00000000}},	//   _laba__bafundi_, _ཉོ__ཉོཝ_, _седам_, --,
   {{0x5f5eb00e,0xa3f88003,0x760d6014,0x00000000}},	//   _འཛུགས__སྐྲུན_, _kukuba_, _biolóxic, --,
   {{0x424bb02d,0x4049b00f,0x6a485019,0x00000000}},	//   _श्वेता_, _ibireban, _de__pagament, --,
   {{0x049e7029,0x1cd4e011,0x4e72e005,0xc0c7200e}},	//   _du__må_, _izindaba__zokuthi_, _ће_, _ནས__རྒྱ_,
   {{0x03eb9021,0xfe40a00e,0x575fe00c,0x00000000}},	//   _beste_, _དུ__བསྒྱུར_, _विस्फोट_, --,
   {{0x4290501b,0xa3c12011,0xca487007,0x732b8011}},	//   _kula_, _ngo__agasti_, _po__celém_, _kube__sengathi_,
   {{0x52902026,0x23cc5011,0x149e7021,0xda12f011}},	//   _nemate_, _lo__mnyango_, _er__nå_, _lowo__owayengu,
   {{0x8200500f,0x1b32100e,0x7b4b900e,0x22d86005}},	//   _muli_, _མཚུངས_, _རིགས__གཅིག_, _usled_,
   {{0x3c4e501a,0x325e600b,0x52905019,0x0e88b00c}},	// [fe0] _कैसे_, _རྫོང__ཁའི_, _lula_, _भारतदीप_,
   {{0xb4424007,0xd46e7014,0xc30c2011,0x9aeb7007}},	//   _sem_, _nas__que_, _uzuma__uthe_, _zvířata_,
   {{0x5175e004,0x647a5005,0x12786031,0x2bb4800c}},	//   _notícias_, _film__iz_, _mfundo_, _नहीं__हो_,
   {{0xb496e007,0x0a3e400a,0xac13e00b,0x00000000}},	//   _se__to_, _भईल_, _ཏོང__ཏོ_, --,
   {{0x92907007,0xe4424004,0x9a47300e,0x00000000}},	//   _jinak_, _vem_, _འཇམ__དབྱངས_, --,
   {{0x949e702a,0x4bd88024,0x2e86e005,0x82cfb00d}},	//   _du__få_, _གིས__ལོ_, _те__је_, _svoj__odkaz_,
   {{0xc4424004,0x99207007,0xa240a00a,0x8de0700d}},	//   _tem_, _mobilní_, _लिखले_, _mobilné_,
   {{0x273d700f,0xe47fd010,0x00000000,0x00000000}},	//   _ya__mudasobw, _pero__es_, --, --,
   {{0x0bb1800b,0x69aa7005,0x00000000,0x00000000}},	//   _ཡང__ཅན_, _ноћи_, --, --,
   {{0xee15400e,0xfdca201d,0x1248003d,0x00000000}},	//   _དཀར__མཛེས_, _naselje__općini_, _isimo_, --,
   {{0xf494c007,0xf312a004,0x637c9011,0x00000000}},	//   _se__jak_, _pode__fazer_, _ubobby__motaung_, --,
   {{0x876d6010,0xbf3b9009,0xe48a5007,0xf3e19011}},	//   _converti, _kerusaka, _které__by_, _best__gospel_,
   {{0xe48b602a,0xb289d011,0x388b600b,0xebf2900c}},	//   _kommer__til_, _ibhizini_lakho_, _པར__འཕྲིན_, _कंपनी__के_,
   {{0xae7d5014,0x80771004,0x32b74011,0x530e0021}},	//   _de__millóns_, _parceiro, _abangaph_kuka_, _blir__ofte_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x99d22003,0xd9ffa007,0x335d3010,0x00000000}},	//   _ifreyist, _hudební_, _de__nombres_, --,
   {{0x649e702a,0xe2e7c014,0xbbbc600c,0x00000000}},	// [ff0] _er__så_, _de__dúas_, _होने__पर_, --,
   {{0xff29802f,0x349e702a,0x3c261014,0xdfdef011}},	//   _bratisla, _er__på_, _molécula_, _umvikeli__womphaka,
   {{0xa340702a,0x97f18021,0x6b7c000b,0x00000000}},	//   _det__hele_, _emosjone_intellig, _རྒྱས__གཞུང_, --,
   {{0x32751011,0xe495602a,0x02eed00f,0x07125017}},	//   _eningizi_afrika_, _og__er_, _akenshi_, _construí,
   {{0xc3219014,0x2f77f004,0x4194b005,0xe2b78003}},	//   _máis__tarde_, _faça_, _београд__година_, _kwenza__ukuba_,
   {{0x6bc3e004,0xd240a02d,0x1dcf3003,0x2f971011}},	//   _opções_, _लिहले_, _kwilizwe__jikelele_, _kulo__mhlangan,
   {{0xe442505d,0xaa58a004,0xbc456009,0x2be8200c}},	//   _vel_, _pergunta_, _perwira_, _और__हम_,
   {{0x9a3d500a,0xa3332027,0x13e95010,0xadcee00f}},	//   _रहल_, _dilantik__sebagai_, _sin__embargo_, _mugihe__kirekire_,
   {{0xd4426013,0x14895006,0x6bda200c,0x6a401011}},	//   _deo_, _mengungk, _जो__भी_, _lo__wesilisa_,
   {{0x138ab038,0x123c1011,0xebe19018,0xb200e00f}},	//   _føra_, _kule__sizini_, _འདི__དག_, _munini_,
   {{0xf4b5a005,0x8248b024,0xf2f0b038,0xbfb49011}},	//   _vrsta__ima_, _ཡིག__ཐོག_, _høg_, _boxing__promotio,
   {{0xe2fe0003,0x00000000,0x00000000,0x00000000}},	//   _ukwazi__ukuba_, --, --, --,
   {{0x2ea8e005,0xf386d034,0xc584c00c,0x00000000}},	//   _али__је_, _gjere_, _प्रोटीन_, --,
   {{0xe2915031,0x2a5f8005,0x1201f013,0x824de011}},	//   _ingaba_, _могу__бити_, _vozila_, _ngomsomb_kusho_,
   {{0x026e100f,0x124da02b,0xc460d010,0x00000000}},	//   _raporo_, _སྲུ_, _basados__en_, --,
   {{0xabdda00b,0x9cdca018,0x00000000,0x00000000}},	//   _གླར__ོད_, _རྡོ__རྗེའི_, --, --,

  };
  // table_hash = 40ea-ebc2, unused_entries = 2030 (12.39%)

static const uint32 kDistinctOcta0527SizeOne = 105;    // Bucket count one-lang
static const uint32 kDistinctOcta0527Ind[105] = {
  // [0000]
  0x00000000, 0x00000000, 0x00001301, 0x00003406,   // -- --  et.un.un_200 xh.un.un_400
  0x00000a06, 0x00001706, 0x00001c01, 0x00000d06,   // pt.un.un_400 sr.un.un_400  id.un.un_200 cs.un.un_400
  0x00005906, 0x00001c03, 0x00001306, 0x00003906,   // rn.un.un_400 id.un.un_300  et.un.un_400 br.un.un_400
  0x00000906, 0x00002d06, 0x00002a06, 0x00005506,   // pl.un.un_400 sk.un.un_400  mt.un.un_400 rw.un.un_400
  // [0010]
  0x00000b06, 0x00003506, 0x00001601, 0x00001703,   // es.un.un_400 zu.un.un_400  hr.un.un_200 sr.un.un_300
  0x00001906, 0x00001e03, 0x00000d03, 0x00001901,   // gl.un.un_400 ms.un.un_300  cs.un.un_300 gl.un.un_200
  0x00002a03, 0x00000a03, 0x00000903, 0x00003403,   // mt.un.un_300 pt.un.un_300  pl.un.un_300 xh.un.un_300
  0x00001c06, 0x00001606, 0x00000901, 0x00005501,   // id.un.un_400 hr.un.un_400  pl.un.un_200 rw.un.un_200
  // [0020]
  0x00002a01, 0x00000806, 0x00000b01, 0x00001e06,   // mt.un.un_200 no.un.un_400  es.un.un_200 ms.un.un_400
  0x00003901, 0x09001c09, 0x00001603, 0x00001e01,   // br.un.un_200 id.pl.un_440  hr.un.un_300 ms.un.un_200
  0x00000b03, 0x00000803, 0x08000209, 0x00003903,   // es.un.un_300 no.un.un_300  da.no.un_440 br.un.un_300
  0x00001903, 0x00001303, 0x00005901, 0x00002d03,   // gl.un.un_300 et.un.un_300  rn.un.un_200 sk.un.un_300
  // [0030]
  0x00000801, 0x00003401, 0x00000a01, 0x08000208,   // no.un.un_200 xh.un.un_200  pt.un.un_200 da.no.un_430
  0x00003303, 0x00003501, 0x00001701, 0x00005503,   // nn.un.un_300 zu.un.un_200  sr.un.un_200 rw.un.un_300
  0x00003306, 0x091c0da4, 0x00005903, 0x00003301,   // nn.un.un_400 cs.id.pl_433  rn.un.un_300 nn.un.un_200
  0x09001c08, 0x00003503, 0x33000204, 0x00002d01,   // id.pl.un_430 zu.un.un_300  da.nn.un_320 sk.un.un_200
  // [0040]
  0x00000d01, 0x0a080209, 0x0b081955, 0x0a000b09,   // cs.un.un_200 da.no.pt_444  gl.no.es_442 es.pt.un_440
  0x09001c05, 0x33000205, 0x13000d02, 0x13001c08,   // id.pl.un_330 da.nn.un_330  cs.et.un_220 id.et.un_430
  0x13000d09, 0x08000207, 0x08000205, 0x08000202,   // cs.et.un_440 da.no.un_420  da.no.un_330 da.no.un_220
  0x0b021955, 0x0d080209, 0x00000201, 0x00000206,   // gl.da.es_442 da.no.cs_444  da.un.un_200 da.un.un_400
  // [0050]
  0x0b001909, 0x09000d02, 0x09001c04, 0x091c0da0,   // gl.es.un_440 cs.pl.un_220  id.pl.un_320 cs.id.pl_322
  0x13000d08, 0x09001c02, 0x09000d09, 0x0a080208,   // cs.et.un_430 id.pl.un_220  cs.pl.un_440 da.no.pt_443
  0x091c0d07, 0x0b000a09, 0x2d080209, 0x1c000d04,   // cs.id.pl_432 pt.es.un_440  da.no.sk_444 cs.id.un_320
  0x2d001909, 0x33000202, 0x2d003509, 0x090d1ca4,   // gl.sk.un_440 da.nn.un_220  zu.sk.un_440 id.cs.pl_433
  // [0060] --- double_langprob_start=0069 ---
  0x09000d08, 0x13000d05, 0x1c000d02, 0x08001909,   // cs.pl.un_430 cs.et.un_330  cs.id.un_220 gl.no.un_440
  0x09000d04, 0x0b080208, 0x13001c07, 0x13001c05,   // cs.pl.un_320 da.no.es_443  id.et.un_420 id.et.un_330
  0x13000d04,                                       // cs.et.un_320
  };

//  COMPILE_ASSERT(105 < (1 << 12), k_indirectbits_too_small);

extern const CLD2TableSummary kDistinctOcta_obj = {
  kDistinctOcta0527,
  kDistinctOcta0527Ind,
  kDistinctOcta0527SizeOne,
  kDistinctOcta0527Size,
  kDistinctOcta0527KeyMask,
  kDistinctOcta0527BuildDate,
  kDistinctOcta0527RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
