/* foundry-input-choice.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include "foundry-input.h"
#include "foundry-types.h"
#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_INPUT_CHOICE (foundry_input_choice_get_type())

FOUNDRY_AVAILABLE_IN_ALL
G_DECLARE_FINAL_TYPE (FoundryInputChoice, foundry_input_choice, FOUNDRY, INPUT_CHOICE, FoundryInput)

FOUNDRY_AVAILABLE_IN_ALL
FoundryInput *foundry_input_choice_new          (const char         *title,
                                                 const char         *subtitle,
                                                 GObject            *item);
FOUNDRY_AVAILABLE_IN_ALL
GObject      *foundry_input_choice_dup_item     (FoundryInputChoice *self);
FOUNDRY_AVAILABLE_IN_ALL
gboolean      foundry_input_choice_get_selected (FoundryInputChoice *self);
FOUNDRY_AVAILABLE_IN_ALL
void          foundry_input_choice_set_selected (FoundryInputChoice *self,
                                                 gboolean            selected);

G_END_DECLS
