/*
  Copyright (c) 2007-2013 Stefan Kurtz <kurtz@zbh.uni-hamburg.de>
  Copyright (c) 2007-2013 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

#ifndef ESA_MAXPAIRS_H
#define ESA_MAXPAIRS_H

#include "core/error_api.h"
#include "core/encseq.h"
#include "core/logger_api.h"
#include "esa-seqread.h"
#include "bare-encseq.h"
#include "sfx-sain.h"

typedef struct
{
  bool hasencseq;
  union
  {
    const GtEncseq *encseq;
    const GtBareEncseq *bare_encseq;
  } seqptr;
} GtGenericEncseq;

typedef int (*GtProcessmaxpairs)(void *,
                                 const GtGenericEncseq *,
                                 GtUword,
                                 GtUword,
                                 GtUword,
                                 GtError *);

int gt_enumeratemaxpairs(Sequentialsuffixarrayreader *ssar,
                         unsigned int searchlength,
                         GtProcessmaxpairs processmaxpairs,
                         void *processmaxpairsinfo,
                         GtError *err);

int gt_enumeratemaxpairs_sain(GtSainSufLcpIterator *suflcpiterator,
                              unsigned int searchlength,
                              GtProcessmaxpairs processmaxpairs,
                              void *processmaxpairsinfo,
                              GtError *err);

int gt_callenummaxpairs(const char *indexname,
                        unsigned int userdefinedleastlength,
                        GtUword maxfreq,
                        bool scanfile,
                        GtProcessmaxpairs processmaxpairs,
                        void *processmaxpairsinfo,
                        GtLogger *logger,
                        GtError *err);

#endif
