// Released under the terms of LGPL 2.1, Please see COPYING.LIB

#import "GSXCMakefileGenerator.h"
#import "PBXNativeTarget.h"
#import "XCConfigurationList.h"
#import "PBXBuildFile.h"
#import "PBXFileReference.h"

#import "NSArray+Additions.h"

@implementation GSXCMakefileGenerator

- (NSString *) projectTypeForString: (NSString *)type
{
  if ([type isEqualToString: @"APPLICATION"])
    {
      return @"APP";
    }
  return type;
}

- (id) objectForString: (NSString *)o
{
  return o != nil ? o : @"";
}

- (BOOL) generate
{
  BOOL result = YES;
  GSXCBuildContext *context = [GSXCBuildContext sharedBuildContext];
  NSString *name = [_target name];
  NSString *appName = [name stringByDeletingPathExtension];
  NSString *makefileName = @"GNUmakefile";
  NSString *makefileString = @"";
  NSString *headerFilesString = [[context objectForKey: @"HEADERS"] arrayToList];
  NSString *objCFilesString = [[context objectForKey: @"OBJC_FILES"] arrayToList];
  NSString *cFilesString = [[context objectForKey: @"C_FILES"] arrayToList];
  NSString *cppFilesString = [[context objectForKey: @"CPP_FILES"] arrayToList];
  NSString *objCPPFilesString = [[context objectForKey: @"OBJCPP_FILES"] arrayToList];  
  NSString *resourceFilesString = [[context objectForKey: @"RESOURCES"] arrayToList];
  NSString *additionalIncludes = [[context objectForKey: @"ADDITIONAL_INCLUDE_DIRS"] arrayToIncludeList];
  NSString *additionalOCflags = [[context objectForKey: @"ADDITIONAL_OBJC_LIBS"] arrayToLinkList];
  NSString *projectType = [context objectForKey: @"PROJECT_TYPE"];

  // Construct the makefile out of the data we have thusfar collected.
  xcputs("\t* Generating GNUmakefile");

  // Sometimes the build will generate all of the target makefiles in one place, depending on the version of
  // Xcode the project was created with.
  if([[NSFileManager defaultManager] fileExistsAtPath: @"GNUmakefile"])
    {
      // if it collides with the existing name, add the target name...
      makefileName = [makefileName stringByAppendingString: [NSString stringWithFormat: @"_%@", appName]];
    }

  makefileString = [makefileString stringByAppendingString: @"#\n"];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"# GNUmakefile for target %@\n", name]];
  makefileString = [makefileString stringByAppendingString: @"# begin - generated by buildtool, please don't modify\n"];
  makefileString = [makefileString stringByAppendingString: @"#\n\n"];
  makefileString = [makefileString stringByAppendingString: @"include $(GNUSTEP_MAKEFILES)/common.make\n\n"];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_NAME = %@\n\n", [self projectTypeForString: [projectType uppercaseString]], appName]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_OBJC_FILES = %@\n\n", appName, [self objectForString: objCFilesString]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_C_FILES = %@\n\n", appName, [self objectForString: cFilesString]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_CPP_FILES = %@\n\n", appName, [self objectForString: cppFilesString]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_OBJCPP_FILES = %@\n\n", appName, [self objectForString: objCPPFilesString]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_HEADER_FILES = %@\n\n", appName, [self objectForString: headerFilesString]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"%@_RESOURCE_FILES = %@\n\n", appName, [self objectForString: resourceFilesString]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"ADDITIONAL_INCLUDE_DIRS += %@\n\n", [self objectForString: additionalIncludes]]];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"ADDITIONAL_OBJC_LIBS += %@\n\n", [self objectForString: additionalOCflags]]];
  
  makefileString = [makefileString stringByAppendingString: @"-include GNUmakefile.preamble\n"];
  makefileString = [makefileString stringByAppendingString: @"include $(GNUSTEP_MAKEFILES)/common.make\n"];
  makefileString = [makefileString stringByAppendingString:
                                [NSString stringWithFormat: @"include $(GNUSTEP_MAKEFILES)/%@.make\n", projectType]];
  makefileString = [makefileString stringByAppendingString: @"-include GNUmakefile.postamble\n\n"];
  makefileString = [makefileString stringByAppendingString: @"#\n"];
  makefileString = [makefileString stringByAppendingString: @"# end - generated makefile\n"];
  makefileString = [makefileString stringByAppendingString: @"#\n"];

  NSDebugLog(@"makefile = %@", makefileString);
  [makefileString writeToFile: makefileName atomically: YES];
  xcputs([[NSString stringWithFormat: @"=== Completed generation of %@ for target %@", makefileName, name] cString]);

  return result;
}

@end
