(****************************************************************************)
(*                           the diy toolsuite                              *)
(*                                                                          *)
(* Jade Alglave, University College London, UK.                             *)
(* Luc Maranget, INRIA Paris-Rocquencourt, France.                          *)
(*                                                                          *)
(* Copyright 2020-present Institut National de Recherche en Informatique et *)
(* en Automatique and the authors. All rights reserved.                     *)
(*                                                                          *)
(* This software is governed by the CeCILL-B license under French law and   *)
(* abiding by the rules of distribution of free software. You can use,      *)
(* modify and/ or redistribute the software under the terms of the CeCILL-B *)
(* license as circulated by CEA, CNRS and INRIA at the following URL        *)
(* "http://www.cecill.info". We also give a copy in LICENSE.txt.            *)
(****************************************************************************)

(** Global locations for litmus *)

type t = Addr of string | Pte of string | Phy of string

val pp_old : t -> string
val pp : t -> string
val compare : t -> t -> int
val as_addr : t -> string (* assert false if not an addr *)
val tr_symbol : Constant.symbol -> t

module Set : MySet.S with type elt = t
module Map : MyMap.S with type key = t

type displayed = string ConstrGen.rloc

val dump_displayed : displayed -> string

module DisplayedSet : MySet.S with type elt = displayed
