// SPDX-License-Identifier: GPL-2.0-or-later
#ifndef __UI_WIDGET_ICONRENDERER_H__
#define __UI_WIDGET_ICONRENDERER_H__
/*
 * Authors:
 *   Theodore Janeczko
 *
 * Copyright (C) Theodore Janeczko 2012 <flutterguy317@gmail.com>
 *               Martin Owens 2018 <doctormo@gmail.com>
 *
 * Released under GNU GPL v2+, read the file 'COPYING' for more information.
 */

#include <gtkmm/cellrendererpixbuf.h>
#include <gtkmm/widget.h>
#include <glibmm/property.h>

namespace Inkscape {
namespace UI {
namespace Widget {

class IconRenderer : public Gtk::CellRendererPixbuf {
public:
    IconRenderer();
    ~IconRenderer() override = default;;

    Glib::PropertyProxy<int> property_icon() { return _property_icon.get_proxy(); }
    Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf_on();
    Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf_off();

    void add_icon(Glib::ustring name);

    typedef sigc::signal<void, Glib::ustring> type_signal_activated;
    type_signal_activated signal_activated();
protected:
    type_signal_activated m_signal_activated;

    void render_vfunc( const Cairo::RefPtr<Cairo::Context>& cr,
                               Gtk::Widget& widget,
                               const Gdk::Rectangle& background_area,
                               const Gdk::Rectangle& cell_area,
                               Gtk::CellRendererState flags ) override;

    void get_preferred_width_vfunc(Gtk::Widget& widget,
                                           int& min_w,
                                           int& nat_w) const override;
    
    void get_preferred_height_vfunc(Gtk::Widget& widget,
                                            int& min_h,
                                            int& nat_h) const override;

    bool activate_vfunc(GdkEvent *event,
                                Gtk::Widget &widget,
                                const Glib::ustring &path,
                                const Gdk::Rectangle &background_area,
                                const Gdk::Rectangle &cell_area,
                                Gtk::CellRendererState flags) override;

private:
    
    Glib::Property<int> _property_icon;
    std::vector<Glib::RefPtr<Gdk::Pixbuf>> _icons;
    void set_pixbuf();
};



} // namespace Widget
} // namespace UI
} // namespace Inkscape


#endif /* __UI_WIDGET_ICONRENDERER_H__ */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:fileencoding=utf-8:textwidth=99 :
