/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef _XE_LRC_LAYOUT_H_
#define _XE_LRC_LAYOUT_H_

#define CTX_CONTEXT_CONTROL		(0x02 + 1)
#define CTX_RING_HEAD			(0x04 + 1)
#define CTX_RING_TAIL			(0x06 + 1)
#define CTX_RING_START			(0x08 + 1)
#define CTX_RING_CTL			(0x0a + 1)
#define CTX_BB_PER_CTX_PTR		(0x12 + 1)
#define CTX_CS_INDIRECT_CTX		(0x14 + 1)
#define CTX_CS_INDIRECT_CTX_OFFSET	(0x16 + 1)
#define CTX_TIMESTAMP			(0x22 + 1)
#define CTX_TIMESTAMP_UDW		(0x24 + 1)
#define CTX_INDIRECT_RING_STATE		(0x26 + 1)
#define CTX_ACC_CTR_THOLD		(0x2a + 1)
#define CTX_ASID			(0x2e + 1)
#define CTX_PDP0_UDW			(0x30 + 1)
#define CTX_PDP0_LDW			(0x32 + 1)

#define CTX_LRM_INT_MASK_ENABLE		0x50
#define CTX_INT_MASK_ENABLE_REG		(CTX_LRM_INT_MASK_ENABLE + 1)
#define CTX_INT_MASK_ENABLE_PTR		(CTX_LRM_INT_MASK_ENABLE + 2)
#define CTX_LRI_INT_REPORT_PTR		0x55
#define CTX_INT_STATUS_REPORT_REG	(CTX_LRI_INT_REPORT_PTR + 1)
#define CTX_INT_STATUS_REPORT_PTR	(CTX_LRI_INT_REPORT_PTR + 2)
#define CTX_INT_SRC_REPORT_REG		(CTX_LRI_INT_REPORT_PTR + 3)
#define CTX_INT_SRC_REPORT_PTR		(CTX_LRI_INT_REPORT_PTR + 4)

#define CTX_CS_INT_VEC_REG		0x5a
#define CTX_CS_INT_VEC_DATA		(CTX_CS_INT_VEC_REG + 1)

#define INDIRECT_CTX_RING_HEAD		(0x02 + 1)
#define INDIRECT_CTX_RING_TAIL		(0x04 + 1)
#define INDIRECT_CTX_RING_START		(0x06 + 1)
#define INDIRECT_CTX_RING_START_UDW	(0x08 + 1)
#define INDIRECT_CTX_RING_CTL		(0x0a + 1)

#endif
