# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry.v2025_04_01 import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementWebhooksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_list(self, resource_group):
        response = self.client.webhooks.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_get(self, resource_group):
        response = self.client.webhooks.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_begin_create(self, resource_group):
        response = self.client.webhooks.begin_create(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            webhook_create_parameters={
                "location": "str",
                "actions": ["str"],
                "customHeaders": {"str": "str"},
                "scope": "str",
                "serviceUri": "str",
                "status": "str",
                "tags": {"str": "str"},
            },
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_begin_delete(self, resource_group):
        response = self.client.webhooks.begin_delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_begin_update(self, resource_group):
        response = self.client.webhooks.begin_update(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            webhook_update_parameters={
                "actions": ["str"],
                "customHeaders": {"str": "str"},
                "scope": "str",
                "serviceUri": "str",
                "status": "str",
                "tags": {"str": "str"},
            },
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_ping(self, resource_group):
        response = self.client.webhooks.ping(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_list_events(self, resource_group):
        response = self.client.webhooks.list_events(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            api_version="2025-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_webhooks_get_callback_config(self, resource_group):
        response = self.client.webhooks.get_callback_config(
            resource_group_name=resource_group.name,
            registry_name="str",
            webhook_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...
