% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso-year-week-day-widen}
\alias{iso-year-week-day-widen}
\alias{calendar_widen.clock_iso_year_week_day}
\title{Widen: iso-year-week-day}
\usage{
\method{calendar_widen}{clock_iso_year_week_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_iso_year_week_day]}

A iso-year-week-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"week"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} widened to the supplied \code{precision}.
}
\description{
This is a iso-year-week-day method for the \code{\link[=calendar_widen]{calendar_widen()}} generic. It
widens a iso-year-week-day vector to the specified \code{precision}.
}
\examples{
# Week precision
x <- iso_year_week_day(2019, 1)
x

# Widen to day precision
# In the ISO calendar, the first day of the week is a Monday
calendar_widen(x, "day")

# Or second precision
sec <- calendar_widen(x, "second")
sec
}
