use axum::{
    extract::State,
    response::Json,
};
use serde_json::json;
use std::sync::Arc;

use crate::state::AppState;

/// Handler for the IndieAuth metadata endpoint
/// Returns server configuration as JSON per IndieAuth spec
pub async fn metadata_handler(State(state): State<Arc<AppState>>) -> Json<serde_json::Value> {
    let metadata = json!({
        "issuer": state.issuer.as_str(),
        "authorization_endpoint": state.issuer.join("auth").unwrap().as_str(),
        "token_endpoint": state.issuer.join("token").unwrap().as_str(),
        "userinfo_endpoint": state.issuer.join("userinfo").unwrap().as_str(),
        "code_challenge_methods_supported": ["S256"],
        "scopes_supported": ["profile", "email"],
        "response_types_supported": ["code"],
        "grant_types_supported": ["authorization_code"],
        "service_documentation": "https://indieauth.spec.indieweb.org/",
    });
    
    Json(metadata)
}