use url::Url;

use crate::standards::websub::{Result, WebSubError};

#[tracing::instrument(skip(client))]
pub async fn discover_hubs(
    client: &impl crate::http::Client,
    topic: &Url,
) -> Result<Vec<Url>> {
    let rels = crate::algorithms::link_rel::for_url(client, topic, &["hub"], "GET")
        .await
        .map_err(|err| WebSubError::Http(err.to_string()))?;

    Ok(rels.get("hub").cloned().unwrap_or_default())
}

#[tracing::instrument(skip(client))]
pub async fn discover_self(
    client: &impl crate::http::Client,
    topic: &Url,
) -> Result<Vec<Url>> {
    let rels = crate::algorithms::link_rel::for_url(client, topic, &["self"], "GET")
        .await
        .map_err(|err| WebSubError::Http(err.to_string()))?;

    Ok(rels.get("self").cloned().unwrap_or_default())
}
