#![doc = " fiat-crypto output postprocessed by fiat-constify: https://github.com/rustcrypto/utils"]
#![doc = " Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384 32 '2^384 - 2^128 - 2^96 + 2^32 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp"]
#![doc = " curve description: p384"]
#![doc = " machine_wordsize = 32 (from \"32\")"]
#![doc = " requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp"]
#![doc = " m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from \"2^384 - 2^128 - 2^96 + 2^32 - 1\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in"]
#![doc = "                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    dead_code,
    rustdoc::bare_urls,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p384_u1 = u8;
pub type fiat_p384_i1 = i8;
pub type fiat_p384_u2 = u8;
pub type fiat_p384_i2 = i8;
pub type fiat_p384_montgomery_domain_field_element = [u32; 12];
pub type fiat_p384_non_montgomery_domain_field_element = [u32; 12];
#[doc = " The function fiat_p384_addcarryx_u32 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^32"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_addcarryx_u32(
    arg1: fiat_p384_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p384_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p384_u1 = 0;
    let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: fiat_p384_u1 = ((x1 >> 32) as fiat_p384_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_subborrowx_u32 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^32"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_subborrowx_u32(
    arg1: fiat_p384_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p384_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p384_u1 = 0;
    let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
    let x2: fiat_p384_i1 = ((x1 >> 32) as fiat_p384_i1);
    let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
    out1 = x3;
    out2 = (((0x0 as fiat_p384_i2) - (x2 as fiat_p384_i2)) as fiat_p384_u1);
    (out1, out2)
}
#[doc = " The function fiat_p384_mulx_u32 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^32"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_mulx_u32(arg1: u32, arg2: u32) -> (u32, u32) {
    let mut out1: u32 = 0;
    let mut out2: u32 = 0;
    let x1: u64 = ((arg1 as u64) * (arg2 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: u32 = ((x1 >> 32) as u32);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_cmovznz_u32 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_cmovznz_u32(arg1: fiat_p384_u1, arg2: u32, arg3: u32) -> u32 {
    let mut out1: u32 = 0;
    let x1: fiat_p384_u1 = (!(!arg1));
    let x2: u32 = ((((((0x0 as fiat_p384_i2) - (x1 as fiat_p384_i2)) as fiat_p384_i1) as i64)
        & (0xffffffff as i64)) as u32);
    let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p384_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_mul(
    arg1: &fiat_p384_montgomery_domain_field_element,
    arg2: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let (x13, x14) = fiat_p384_mulx_u32(x12, (arg2[11]));
    let (x15, x16) = fiat_p384_mulx_u32(x12, (arg2[10]));
    let (x17, x18) = fiat_p384_mulx_u32(x12, (arg2[9]));
    let (x19, x20) = fiat_p384_mulx_u32(x12, (arg2[8]));
    let (x21, x22) = fiat_p384_mulx_u32(x12, (arg2[7]));
    let (x23, x24) = fiat_p384_mulx_u32(x12, (arg2[6]));
    let (x25, x26) = fiat_p384_mulx_u32(x12, (arg2[5]));
    let (x27, x28) = fiat_p384_mulx_u32(x12, (arg2[4]));
    let (x29, x30) = fiat_p384_mulx_u32(x12, (arg2[3]));
    let (x31, x32) = fiat_p384_mulx_u32(x12, (arg2[2]));
    let (x33, x34) = fiat_p384_mulx_u32(x12, (arg2[1]));
    let (x35, x36) = fiat_p384_mulx_u32(x12, (arg2[0]));
    let (x37, x38) = fiat_p384_addcarryx_u32(0x0, x36, x33);
    let (x39, x40) = fiat_p384_addcarryx_u32(x38, x34, x31);
    let (x41, x42) = fiat_p384_addcarryx_u32(x40, x32, x29);
    let (x43, x44) = fiat_p384_addcarryx_u32(x42, x30, x27);
    let (x45, x46) = fiat_p384_addcarryx_u32(x44, x28, x25);
    let (x47, x48) = fiat_p384_addcarryx_u32(x46, x26, x23);
    let (x49, x50) = fiat_p384_addcarryx_u32(x48, x24, x21);
    let (x51, x52) = fiat_p384_addcarryx_u32(x50, x22, x19);
    let (x53, x54) = fiat_p384_addcarryx_u32(x52, x20, x17);
    let (x55, x56) = fiat_p384_addcarryx_u32(x54, x18, x15);
    let (x57, x58) = fiat_p384_addcarryx_u32(x56, x16, x13);
    let x59: u32 = ((x58 as u32) + x14);
    let (x60, x61) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x62, x63) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x64, x65) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x66, x67) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x68, x69) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x70, x71) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x72, x73) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x74, x75) = fiat_p384_mulx_u32(x35, 0xfffffffe);
    let (x76, x77) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x78, x79) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x80, x81) = fiat_p384_addcarryx_u32(0x0, x77, x74);
    let (x82, x83) = fiat_p384_addcarryx_u32(x81, x75, x72);
    let (x84, x85) = fiat_p384_addcarryx_u32(x83, x73, x70);
    let (x86, x87) = fiat_p384_addcarryx_u32(x85, x71, x68);
    let (x88, x89) = fiat_p384_addcarryx_u32(x87, x69, x66);
    let (x90, x91) = fiat_p384_addcarryx_u32(x89, x67, x64);
    let (x92, x93) = fiat_p384_addcarryx_u32(x91, x65, x62);
    let (x94, x95) = fiat_p384_addcarryx_u32(x93, x63, x60);
    let x96: u32 = ((x95 as u32) + x61);
    let (x97, x98) = fiat_p384_addcarryx_u32(0x0, x35, x78);
    let (x99, x100) = fiat_p384_addcarryx_u32(x98, x37, x79);
    let (x101, x102) = fiat_p384_addcarryx_u32(x100, x39, (0x0 as u32));
    let (x103, x104) = fiat_p384_addcarryx_u32(x102, x41, x76);
    let (x105, x106) = fiat_p384_addcarryx_u32(x104, x43, x80);
    let (x107, x108) = fiat_p384_addcarryx_u32(x106, x45, x82);
    let (x109, x110) = fiat_p384_addcarryx_u32(x108, x47, x84);
    let (x111, x112) = fiat_p384_addcarryx_u32(x110, x49, x86);
    let (x113, x114) = fiat_p384_addcarryx_u32(x112, x51, x88);
    let (x115, x116) = fiat_p384_addcarryx_u32(x114, x53, x90);
    let (x117, x118) = fiat_p384_addcarryx_u32(x116, x55, x92);
    let (x119, x120) = fiat_p384_addcarryx_u32(x118, x57, x94);
    let (x121, x122) = fiat_p384_addcarryx_u32(x120, x59, x96);
    let (x123, x124) = fiat_p384_mulx_u32(x1, (arg2[11]));
    let (x125, x126) = fiat_p384_mulx_u32(x1, (arg2[10]));
    let (x127, x128) = fiat_p384_mulx_u32(x1, (arg2[9]));
    let (x129, x130) = fiat_p384_mulx_u32(x1, (arg2[8]));
    let (x131, x132) = fiat_p384_mulx_u32(x1, (arg2[7]));
    let (x133, x134) = fiat_p384_mulx_u32(x1, (arg2[6]));
    let (x135, x136) = fiat_p384_mulx_u32(x1, (arg2[5]));
    let (x137, x138) = fiat_p384_mulx_u32(x1, (arg2[4]));
    let (x139, x140) = fiat_p384_mulx_u32(x1, (arg2[3]));
    let (x141, x142) = fiat_p384_mulx_u32(x1, (arg2[2]));
    let (x143, x144) = fiat_p384_mulx_u32(x1, (arg2[1]));
    let (x145, x146) = fiat_p384_mulx_u32(x1, (arg2[0]));
    let (x147, x148) = fiat_p384_addcarryx_u32(0x0, x146, x143);
    let (x149, x150) = fiat_p384_addcarryx_u32(x148, x144, x141);
    let (x151, x152) = fiat_p384_addcarryx_u32(x150, x142, x139);
    let (x153, x154) = fiat_p384_addcarryx_u32(x152, x140, x137);
    let (x155, x156) = fiat_p384_addcarryx_u32(x154, x138, x135);
    let (x157, x158) = fiat_p384_addcarryx_u32(x156, x136, x133);
    let (x159, x160) = fiat_p384_addcarryx_u32(x158, x134, x131);
    let (x161, x162) = fiat_p384_addcarryx_u32(x160, x132, x129);
    let (x163, x164) = fiat_p384_addcarryx_u32(x162, x130, x127);
    let (x165, x166) = fiat_p384_addcarryx_u32(x164, x128, x125);
    let (x167, x168) = fiat_p384_addcarryx_u32(x166, x126, x123);
    let x169: u32 = ((x168 as u32) + x124);
    let (x170, x171) = fiat_p384_addcarryx_u32(0x0, x99, x145);
    let (x172, x173) = fiat_p384_addcarryx_u32(x171, x101, x147);
    let (x174, x175) = fiat_p384_addcarryx_u32(x173, x103, x149);
    let (x176, x177) = fiat_p384_addcarryx_u32(x175, x105, x151);
    let (x178, x179) = fiat_p384_addcarryx_u32(x177, x107, x153);
    let (x180, x181) = fiat_p384_addcarryx_u32(x179, x109, x155);
    let (x182, x183) = fiat_p384_addcarryx_u32(x181, x111, x157);
    let (x184, x185) = fiat_p384_addcarryx_u32(x183, x113, x159);
    let (x186, x187) = fiat_p384_addcarryx_u32(x185, x115, x161);
    let (x188, x189) = fiat_p384_addcarryx_u32(x187, x117, x163);
    let (x190, x191) = fiat_p384_addcarryx_u32(x189, x119, x165);
    let (x192, x193) = fiat_p384_addcarryx_u32(x191, x121, x167);
    let (x194, x195) = fiat_p384_addcarryx_u32(x193, (x122 as u32), x169);
    let (x196, x197) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x198, x199) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x200, x201) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x202, x203) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x204, x205) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x206, x207) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x208, x209) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x210, x211) = fiat_p384_mulx_u32(x170, 0xfffffffe);
    let (x212, x213) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x214, x215) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x216, x217) = fiat_p384_addcarryx_u32(0x0, x213, x210);
    let (x218, x219) = fiat_p384_addcarryx_u32(x217, x211, x208);
    let (x220, x221) = fiat_p384_addcarryx_u32(x219, x209, x206);
    let (x222, x223) = fiat_p384_addcarryx_u32(x221, x207, x204);
    let (x224, x225) = fiat_p384_addcarryx_u32(x223, x205, x202);
    let (x226, x227) = fiat_p384_addcarryx_u32(x225, x203, x200);
    let (x228, x229) = fiat_p384_addcarryx_u32(x227, x201, x198);
    let (x230, x231) = fiat_p384_addcarryx_u32(x229, x199, x196);
    let x232: u32 = ((x231 as u32) + x197);
    let (x233, x234) = fiat_p384_addcarryx_u32(0x0, x170, x214);
    let (x235, x236) = fiat_p384_addcarryx_u32(x234, x172, x215);
    let (x237, x238) = fiat_p384_addcarryx_u32(x236, x174, (0x0 as u32));
    let (x239, x240) = fiat_p384_addcarryx_u32(x238, x176, x212);
    let (x241, x242) = fiat_p384_addcarryx_u32(x240, x178, x216);
    let (x243, x244) = fiat_p384_addcarryx_u32(x242, x180, x218);
    let (x245, x246) = fiat_p384_addcarryx_u32(x244, x182, x220);
    let (x247, x248) = fiat_p384_addcarryx_u32(x246, x184, x222);
    let (x249, x250) = fiat_p384_addcarryx_u32(x248, x186, x224);
    let (x251, x252) = fiat_p384_addcarryx_u32(x250, x188, x226);
    let (x253, x254) = fiat_p384_addcarryx_u32(x252, x190, x228);
    let (x255, x256) = fiat_p384_addcarryx_u32(x254, x192, x230);
    let (x257, x258) = fiat_p384_addcarryx_u32(x256, x194, x232);
    let x259: u32 = ((x258 as u32) + (x195 as u32));
    let (x260, x261) = fiat_p384_mulx_u32(x2, (arg2[11]));
    let (x262, x263) = fiat_p384_mulx_u32(x2, (arg2[10]));
    let (x264, x265) = fiat_p384_mulx_u32(x2, (arg2[9]));
    let (x266, x267) = fiat_p384_mulx_u32(x2, (arg2[8]));
    let (x268, x269) = fiat_p384_mulx_u32(x2, (arg2[7]));
    let (x270, x271) = fiat_p384_mulx_u32(x2, (arg2[6]));
    let (x272, x273) = fiat_p384_mulx_u32(x2, (arg2[5]));
    let (x274, x275) = fiat_p384_mulx_u32(x2, (arg2[4]));
    let (x276, x277) = fiat_p384_mulx_u32(x2, (arg2[3]));
    let (x278, x279) = fiat_p384_mulx_u32(x2, (arg2[2]));
    let (x280, x281) = fiat_p384_mulx_u32(x2, (arg2[1]));
    let (x282, x283) = fiat_p384_mulx_u32(x2, (arg2[0]));
    let (x284, x285) = fiat_p384_addcarryx_u32(0x0, x283, x280);
    let (x286, x287) = fiat_p384_addcarryx_u32(x285, x281, x278);
    let (x288, x289) = fiat_p384_addcarryx_u32(x287, x279, x276);
    let (x290, x291) = fiat_p384_addcarryx_u32(x289, x277, x274);
    let (x292, x293) = fiat_p384_addcarryx_u32(x291, x275, x272);
    let (x294, x295) = fiat_p384_addcarryx_u32(x293, x273, x270);
    let (x296, x297) = fiat_p384_addcarryx_u32(x295, x271, x268);
    let (x298, x299) = fiat_p384_addcarryx_u32(x297, x269, x266);
    let (x300, x301) = fiat_p384_addcarryx_u32(x299, x267, x264);
    let (x302, x303) = fiat_p384_addcarryx_u32(x301, x265, x262);
    let (x304, x305) = fiat_p384_addcarryx_u32(x303, x263, x260);
    let x306: u32 = ((x305 as u32) + x261);
    let (x307, x308) = fiat_p384_addcarryx_u32(0x0, x235, x282);
    let (x309, x310) = fiat_p384_addcarryx_u32(x308, x237, x284);
    let (x311, x312) = fiat_p384_addcarryx_u32(x310, x239, x286);
    let (x313, x314) = fiat_p384_addcarryx_u32(x312, x241, x288);
    let (x315, x316) = fiat_p384_addcarryx_u32(x314, x243, x290);
    let (x317, x318) = fiat_p384_addcarryx_u32(x316, x245, x292);
    let (x319, x320) = fiat_p384_addcarryx_u32(x318, x247, x294);
    let (x321, x322) = fiat_p384_addcarryx_u32(x320, x249, x296);
    let (x323, x324) = fiat_p384_addcarryx_u32(x322, x251, x298);
    let (x325, x326) = fiat_p384_addcarryx_u32(x324, x253, x300);
    let (x327, x328) = fiat_p384_addcarryx_u32(x326, x255, x302);
    let (x329, x330) = fiat_p384_addcarryx_u32(x328, x257, x304);
    let (x331, x332) = fiat_p384_addcarryx_u32(x330, x259, x306);
    let (x333, x334) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x335, x336) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x337, x338) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x339, x340) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x341, x342) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x343, x344) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x345, x346) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x347, x348) = fiat_p384_mulx_u32(x307, 0xfffffffe);
    let (x349, x350) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x351, x352) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x353, x354) = fiat_p384_addcarryx_u32(0x0, x350, x347);
    let (x355, x356) = fiat_p384_addcarryx_u32(x354, x348, x345);
    let (x357, x358) = fiat_p384_addcarryx_u32(x356, x346, x343);
    let (x359, x360) = fiat_p384_addcarryx_u32(x358, x344, x341);
    let (x361, x362) = fiat_p384_addcarryx_u32(x360, x342, x339);
    let (x363, x364) = fiat_p384_addcarryx_u32(x362, x340, x337);
    let (x365, x366) = fiat_p384_addcarryx_u32(x364, x338, x335);
    let (x367, x368) = fiat_p384_addcarryx_u32(x366, x336, x333);
    let x369: u32 = ((x368 as u32) + x334);
    let (x370, x371) = fiat_p384_addcarryx_u32(0x0, x307, x351);
    let (x372, x373) = fiat_p384_addcarryx_u32(x371, x309, x352);
    let (x374, x375) = fiat_p384_addcarryx_u32(x373, x311, (0x0 as u32));
    let (x376, x377) = fiat_p384_addcarryx_u32(x375, x313, x349);
    let (x378, x379) = fiat_p384_addcarryx_u32(x377, x315, x353);
    let (x380, x381) = fiat_p384_addcarryx_u32(x379, x317, x355);
    let (x382, x383) = fiat_p384_addcarryx_u32(x381, x319, x357);
    let (x384, x385) = fiat_p384_addcarryx_u32(x383, x321, x359);
    let (x386, x387) = fiat_p384_addcarryx_u32(x385, x323, x361);
    let (x388, x389) = fiat_p384_addcarryx_u32(x387, x325, x363);
    let (x390, x391) = fiat_p384_addcarryx_u32(x389, x327, x365);
    let (x392, x393) = fiat_p384_addcarryx_u32(x391, x329, x367);
    let (x394, x395) = fiat_p384_addcarryx_u32(x393, x331, x369);
    let x396: u32 = ((x395 as u32) + (x332 as u32));
    let (x397, x398) = fiat_p384_mulx_u32(x3, (arg2[11]));
    let (x399, x400) = fiat_p384_mulx_u32(x3, (arg2[10]));
    let (x401, x402) = fiat_p384_mulx_u32(x3, (arg2[9]));
    let (x403, x404) = fiat_p384_mulx_u32(x3, (arg2[8]));
    let (x405, x406) = fiat_p384_mulx_u32(x3, (arg2[7]));
    let (x407, x408) = fiat_p384_mulx_u32(x3, (arg2[6]));
    let (x409, x410) = fiat_p384_mulx_u32(x3, (arg2[5]));
    let (x411, x412) = fiat_p384_mulx_u32(x3, (arg2[4]));
    let (x413, x414) = fiat_p384_mulx_u32(x3, (arg2[3]));
    let (x415, x416) = fiat_p384_mulx_u32(x3, (arg2[2]));
    let (x417, x418) = fiat_p384_mulx_u32(x3, (arg2[1]));
    let (x419, x420) = fiat_p384_mulx_u32(x3, (arg2[0]));
    let (x421, x422) = fiat_p384_addcarryx_u32(0x0, x420, x417);
    let (x423, x424) = fiat_p384_addcarryx_u32(x422, x418, x415);
    let (x425, x426) = fiat_p384_addcarryx_u32(x424, x416, x413);
    let (x427, x428) = fiat_p384_addcarryx_u32(x426, x414, x411);
    let (x429, x430) = fiat_p384_addcarryx_u32(x428, x412, x409);
    let (x431, x432) = fiat_p384_addcarryx_u32(x430, x410, x407);
    let (x433, x434) = fiat_p384_addcarryx_u32(x432, x408, x405);
    let (x435, x436) = fiat_p384_addcarryx_u32(x434, x406, x403);
    let (x437, x438) = fiat_p384_addcarryx_u32(x436, x404, x401);
    let (x439, x440) = fiat_p384_addcarryx_u32(x438, x402, x399);
    let (x441, x442) = fiat_p384_addcarryx_u32(x440, x400, x397);
    let x443: u32 = ((x442 as u32) + x398);
    let (x444, x445) = fiat_p384_addcarryx_u32(0x0, x372, x419);
    let (x446, x447) = fiat_p384_addcarryx_u32(x445, x374, x421);
    let (x448, x449) = fiat_p384_addcarryx_u32(x447, x376, x423);
    let (x450, x451) = fiat_p384_addcarryx_u32(x449, x378, x425);
    let (x452, x453) = fiat_p384_addcarryx_u32(x451, x380, x427);
    let (x454, x455) = fiat_p384_addcarryx_u32(x453, x382, x429);
    let (x456, x457) = fiat_p384_addcarryx_u32(x455, x384, x431);
    let (x458, x459) = fiat_p384_addcarryx_u32(x457, x386, x433);
    let (x460, x461) = fiat_p384_addcarryx_u32(x459, x388, x435);
    let (x462, x463) = fiat_p384_addcarryx_u32(x461, x390, x437);
    let (x464, x465) = fiat_p384_addcarryx_u32(x463, x392, x439);
    let (x466, x467) = fiat_p384_addcarryx_u32(x465, x394, x441);
    let (x468, x469) = fiat_p384_addcarryx_u32(x467, x396, x443);
    let (x470, x471) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x472, x473) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x474, x475) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x476, x477) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x478, x479) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x480, x481) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x482, x483) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x484, x485) = fiat_p384_mulx_u32(x444, 0xfffffffe);
    let (x486, x487) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x488, x489) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x490, x491) = fiat_p384_addcarryx_u32(0x0, x487, x484);
    let (x492, x493) = fiat_p384_addcarryx_u32(x491, x485, x482);
    let (x494, x495) = fiat_p384_addcarryx_u32(x493, x483, x480);
    let (x496, x497) = fiat_p384_addcarryx_u32(x495, x481, x478);
    let (x498, x499) = fiat_p384_addcarryx_u32(x497, x479, x476);
    let (x500, x501) = fiat_p384_addcarryx_u32(x499, x477, x474);
    let (x502, x503) = fiat_p384_addcarryx_u32(x501, x475, x472);
    let (x504, x505) = fiat_p384_addcarryx_u32(x503, x473, x470);
    let x506: u32 = ((x505 as u32) + x471);
    let (x507, x508) = fiat_p384_addcarryx_u32(0x0, x444, x488);
    let (x509, x510) = fiat_p384_addcarryx_u32(x508, x446, x489);
    let (x511, x512) = fiat_p384_addcarryx_u32(x510, x448, (0x0 as u32));
    let (x513, x514) = fiat_p384_addcarryx_u32(x512, x450, x486);
    let (x515, x516) = fiat_p384_addcarryx_u32(x514, x452, x490);
    let (x517, x518) = fiat_p384_addcarryx_u32(x516, x454, x492);
    let (x519, x520) = fiat_p384_addcarryx_u32(x518, x456, x494);
    let (x521, x522) = fiat_p384_addcarryx_u32(x520, x458, x496);
    let (x523, x524) = fiat_p384_addcarryx_u32(x522, x460, x498);
    let (x525, x526) = fiat_p384_addcarryx_u32(x524, x462, x500);
    let (x527, x528) = fiat_p384_addcarryx_u32(x526, x464, x502);
    let (x529, x530) = fiat_p384_addcarryx_u32(x528, x466, x504);
    let (x531, x532) = fiat_p384_addcarryx_u32(x530, x468, x506);
    let x533: u32 = ((x532 as u32) + (x469 as u32));
    let (x534, x535) = fiat_p384_mulx_u32(x4, (arg2[11]));
    let (x536, x537) = fiat_p384_mulx_u32(x4, (arg2[10]));
    let (x538, x539) = fiat_p384_mulx_u32(x4, (arg2[9]));
    let (x540, x541) = fiat_p384_mulx_u32(x4, (arg2[8]));
    let (x542, x543) = fiat_p384_mulx_u32(x4, (arg2[7]));
    let (x544, x545) = fiat_p384_mulx_u32(x4, (arg2[6]));
    let (x546, x547) = fiat_p384_mulx_u32(x4, (arg2[5]));
    let (x548, x549) = fiat_p384_mulx_u32(x4, (arg2[4]));
    let (x550, x551) = fiat_p384_mulx_u32(x4, (arg2[3]));
    let (x552, x553) = fiat_p384_mulx_u32(x4, (arg2[2]));
    let (x554, x555) = fiat_p384_mulx_u32(x4, (arg2[1]));
    let (x556, x557) = fiat_p384_mulx_u32(x4, (arg2[0]));
    let (x558, x559) = fiat_p384_addcarryx_u32(0x0, x557, x554);
    let (x560, x561) = fiat_p384_addcarryx_u32(x559, x555, x552);
    let (x562, x563) = fiat_p384_addcarryx_u32(x561, x553, x550);
    let (x564, x565) = fiat_p384_addcarryx_u32(x563, x551, x548);
    let (x566, x567) = fiat_p384_addcarryx_u32(x565, x549, x546);
    let (x568, x569) = fiat_p384_addcarryx_u32(x567, x547, x544);
    let (x570, x571) = fiat_p384_addcarryx_u32(x569, x545, x542);
    let (x572, x573) = fiat_p384_addcarryx_u32(x571, x543, x540);
    let (x574, x575) = fiat_p384_addcarryx_u32(x573, x541, x538);
    let (x576, x577) = fiat_p384_addcarryx_u32(x575, x539, x536);
    let (x578, x579) = fiat_p384_addcarryx_u32(x577, x537, x534);
    let x580: u32 = ((x579 as u32) + x535);
    let (x581, x582) = fiat_p384_addcarryx_u32(0x0, x509, x556);
    let (x583, x584) = fiat_p384_addcarryx_u32(x582, x511, x558);
    let (x585, x586) = fiat_p384_addcarryx_u32(x584, x513, x560);
    let (x587, x588) = fiat_p384_addcarryx_u32(x586, x515, x562);
    let (x589, x590) = fiat_p384_addcarryx_u32(x588, x517, x564);
    let (x591, x592) = fiat_p384_addcarryx_u32(x590, x519, x566);
    let (x593, x594) = fiat_p384_addcarryx_u32(x592, x521, x568);
    let (x595, x596) = fiat_p384_addcarryx_u32(x594, x523, x570);
    let (x597, x598) = fiat_p384_addcarryx_u32(x596, x525, x572);
    let (x599, x600) = fiat_p384_addcarryx_u32(x598, x527, x574);
    let (x601, x602) = fiat_p384_addcarryx_u32(x600, x529, x576);
    let (x603, x604) = fiat_p384_addcarryx_u32(x602, x531, x578);
    let (x605, x606) = fiat_p384_addcarryx_u32(x604, x533, x580);
    let (x607, x608) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x609, x610) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x611, x612) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x613, x614) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x615, x616) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x617, x618) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x619, x620) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x621, x622) = fiat_p384_mulx_u32(x581, 0xfffffffe);
    let (x623, x624) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x625, x626) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x627, x628) = fiat_p384_addcarryx_u32(0x0, x624, x621);
    let (x629, x630) = fiat_p384_addcarryx_u32(x628, x622, x619);
    let (x631, x632) = fiat_p384_addcarryx_u32(x630, x620, x617);
    let (x633, x634) = fiat_p384_addcarryx_u32(x632, x618, x615);
    let (x635, x636) = fiat_p384_addcarryx_u32(x634, x616, x613);
    let (x637, x638) = fiat_p384_addcarryx_u32(x636, x614, x611);
    let (x639, x640) = fiat_p384_addcarryx_u32(x638, x612, x609);
    let (x641, x642) = fiat_p384_addcarryx_u32(x640, x610, x607);
    let x643: u32 = ((x642 as u32) + x608);
    let (x644, x645) = fiat_p384_addcarryx_u32(0x0, x581, x625);
    let (x646, x647) = fiat_p384_addcarryx_u32(x645, x583, x626);
    let (x648, x649) = fiat_p384_addcarryx_u32(x647, x585, (0x0 as u32));
    let (x650, x651) = fiat_p384_addcarryx_u32(x649, x587, x623);
    let (x652, x653) = fiat_p384_addcarryx_u32(x651, x589, x627);
    let (x654, x655) = fiat_p384_addcarryx_u32(x653, x591, x629);
    let (x656, x657) = fiat_p384_addcarryx_u32(x655, x593, x631);
    let (x658, x659) = fiat_p384_addcarryx_u32(x657, x595, x633);
    let (x660, x661) = fiat_p384_addcarryx_u32(x659, x597, x635);
    let (x662, x663) = fiat_p384_addcarryx_u32(x661, x599, x637);
    let (x664, x665) = fiat_p384_addcarryx_u32(x663, x601, x639);
    let (x666, x667) = fiat_p384_addcarryx_u32(x665, x603, x641);
    let (x668, x669) = fiat_p384_addcarryx_u32(x667, x605, x643);
    let x670: u32 = ((x669 as u32) + (x606 as u32));
    let (x671, x672) = fiat_p384_mulx_u32(x5, (arg2[11]));
    let (x673, x674) = fiat_p384_mulx_u32(x5, (arg2[10]));
    let (x675, x676) = fiat_p384_mulx_u32(x5, (arg2[9]));
    let (x677, x678) = fiat_p384_mulx_u32(x5, (arg2[8]));
    let (x679, x680) = fiat_p384_mulx_u32(x5, (arg2[7]));
    let (x681, x682) = fiat_p384_mulx_u32(x5, (arg2[6]));
    let (x683, x684) = fiat_p384_mulx_u32(x5, (arg2[5]));
    let (x685, x686) = fiat_p384_mulx_u32(x5, (arg2[4]));
    let (x687, x688) = fiat_p384_mulx_u32(x5, (arg2[3]));
    let (x689, x690) = fiat_p384_mulx_u32(x5, (arg2[2]));
    let (x691, x692) = fiat_p384_mulx_u32(x5, (arg2[1]));
    let (x693, x694) = fiat_p384_mulx_u32(x5, (arg2[0]));
    let (x695, x696) = fiat_p384_addcarryx_u32(0x0, x694, x691);
    let (x697, x698) = fiat_p384_addcarryx_u32(x696, x692, x689);
    let (x699, x700) = fiat_p384_addcarryx_u32(x698, x690, x687);
    let (x701, x702) = fiat_p384_addcarryx_u32(x700, x688, x685);
    let (x703, x704) = fiat_p384_addcarryx_u32(x702, x686, x683);
    let (x705, x706) = fiat_p384_addcarryx_u32(x704, x684, x681);
    let (x707, x708) = fiat_p384_addcarryx_u32(x706, x682, x679);
    let (x709, x710) = fiat_p384_addcarryx_u32(x708, x680, x677);
    let (x711, x712) = fiat_p384_addcarryx_u32(x710, x678, x675);
    let (x713, x714) = fiat_p384_addcarryx_u32(x712, x676, x673);
    let (x715, x716) = fiat_p384_addcarryx_u32(x714, x674, x671);
    let x717: u32 = ((x716 as u32) + x672);
    let (x718, x719) = fiat_p384_addcarryx_u32(0x0, x646, x693);
    let (x720, x721) = fiat_p384_addcarryx_u32(x719, x648, x695);
    let (x722, x723) = fiat_p384_addcarryx_u32(x721, x650, x697);
    let (x724, x725) = fiat_p384_addcarryx_u32(x723, x652, x699);
    let (x726, x727) = fiat_p384_addcarryx_u32(x725, x654, x701);
    let (x728, x729) = fiat_p384_addcarryx_u32(x727, x656, x703);
    let (x730, x731) = fiat_p384_addcarryx_u32(x729, x658, x705);
    let (x732, x733) = fiat_p384_addcarryx_u32(x731, x660, x707);
    let (x734, x735) = fiat_p384_addcarryx_u32(x733, x662, x709);
    let (x736, x737) = fiat_p384_addcarryx_u32(x735, x664, x711);
    let (x738, x739) = fiat_p384_addcarryx_u32(x737, x666, x713);
    let (x740, x741) = fiat_p384_addcarryx_u32(x739, x668, x715);
    let (x742, x743) = fiat_p384_addcarryx_u32(x741, x670, x717);
    let (x744, x745) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x746, x747) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x748, x749) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x750, x751) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x752, x753) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x754, x755) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x756, x757) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x758, x759) = fiat_p384_mulx_u32(x718, 0xfffffffe);
    let (x760, x761) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x762, x763) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x764, x765) = fiat_p384_addcarryx_u32(0x0, x761, x758);
    let (x766, x767) = fiat_p384_addcarryx_u32(x765, x759, x756);
    let (x768, x769) = fiat_p384_addcarryx_u32(x767, x757, x754);
    let (x770, x771) = fiat_p384_addcarryx_u32(x769, x755, x752);
    let (x772, x773) = fiat_p384_addcarryx_u32(x771, x753, x750);
    let (x774, x775) = fiat_p384_addcarryx_u32(x773, x751, x748);
    let (x776, x777) = fiat_p384_addcarryx_u32(x775, x749, x746);
    let (x778, x779) = fiat_p384_addcarryx_u32(x777, x747, x744);
    let x780: u32 = ((x779 as u32) + x745);
    let (x781, x782) = fiat_p384_addcarryx_u32(0x0, x718, x762);
    let (x783, x784) = fiat_p384_addcarryx_u32(x782, x720, x763);
    let (x785, x786) = fiat_p384_addcarryx_u32(x784, x722, (0x0 as u32));
    let (x787, x788) = fiat_p384_addcarryx_u32(x786, x724, x760);
    let (x789, x790) = fiat_p384_addcarryx_u32(x788, x726, x764);
    let (x791, x792) = fiat_p384_addcarryx_u32(x790, x728, x766);
    let (x793, x794) = fiat_p384_addcarryx_u32(x792, x730, x768);
    let (x795, x796) = fiat_p384_addcarryx_u32(x794, x732, x770);
    let (x797, x798) = fiat_p384_addcarryx_u32(x796, x734, x772);
    let (x799, x800) = fiat_p384_addcarryx_u32(x798, x736, x774);
    let (x801, x802) = fiat_p384_addcarryx_u32(x800, x738, x776);
    let (x803, x804) = fiat_p384_addcarryx_u32(x802, x740, x778);
    let (x805, x806) = fiat_p384_addcarryx_u32(x804, x742, x780);
    let x807: u32 = ((x806 as u32) + (x743 as u32));
    let (x808, x809) = fiat_p384_mulx_u32(x6, (arg2[11]));
    let (x810, x811) = fiat_p384_mulx_u32(x6, (arg2[10]));
    let (x812, x813) = fiat_p384_mulx_u32(x6, (arg2[9]));
    let (x814, x815) = fiat_p384_mulx_u32(x6, (arg2[8]));
    let (x816, x817) = fiat_p384_mulx_u32(x6, (arg2[7]));
    let (x818, x819) = fiat_p384_mulx_u32(x6, (arg2[6]));
    let (x820, x821) = fiat_p384_mulx_u32(x6, (arg2[5]));
    let (x822, x823) = fiat_p384_mulx_u32(x6, (arg2[4]));
    let (x824, x825) = fiat_p384_mulx_u32(x6, (arg2[3]));
    let (x826, x827) = fiat_p384_mulx_u32(x6, (arg2[2]));
    let (x828, x829) = fiat_p384_mulx_u32(x6, (arg2[1]));
    let (x830, x831) = fiat_p384_mulx_u32(x6, (arg2[0]));
    let (x832, x833) = fiat_p384_addcarryx_u32(0x0, x831, x828);
    let (x834, x835) = fiat_p384_addcarryx_u32(x833, x829, x826);
    let (x836, x837) = fiat_p384_addcarryx_u32(x835, x827, x824);
    let (x838, x839) = fiat_p384_addcarryx_u32(x837, x825, x822);
    let (x840, x841) = fiat_p384_addcarryx_u32(x839, x823, x820);
    let (x842, x843) = fiat_p384_addcarryx_u32(x841, x821, x818);
    let (x844, x845) = fiat_p384_addcarryx_u32(x843, x819, x816);
    let (x846, x847) = fiat_p384_addcarryx_u32(x845, x817, x814);
    let (x848, x849) = fiat_p384_addcarryx_u32(x847, x815, x812);
    let (x850, x851) = fiat_p384_addcarryx_u32(x849, x813, x810);
    let (x852, x853) = fiat_p384_addcarryx_u32(x851, x811, x808);
    let x854: u32 = ((x853 as u32) + x809);
    let (x855, x856) = fiat_p384_addcarryx_u32(0x0, x783, x830);
    let (x857, x858) = fiat_p384_addcarryx_u32(x856, x785, x832);
    let (x859, x860) = fiat_p384_addcarryx_u32(x858, x787, x834);
    let (x861, x862) = fiat_p384_addcarryx_u32(x860, x789, x836);
    let (x863, x864) = fiat_p384_addcarryx_u32(x862, x791, x838);
    let (x865, x866) = fiat_p384_addcarryx_u32(x864, x793, x840);
    let (x867, x868) = fiat_p384_addcarryx_u32(x866, x795, x842);
    let (x869, x870) = fiat_p384_addcarryx_u32(x868, x797, x844);
    let (x871, x872) = fiat_p384_addcarryx_u32(x870, x799, x846);
    let (x873, x874) = fiat_p384_addcarryx_u32(x872, x801, x848);
    let (x875, x876) = fiat_p384_addcarryx_u32(x874, x803, x850);
    let (x877, x878) = fiat_p384_addcarryx_u32(x876, x805, x852);
    let (x879, x880) = fiat_p384_addcarryx_u32(x878, x807, x854);
    let (x881, x882) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x883, x884) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x885, x886) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x887, x888) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x889, x890) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x891, x892) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x893, x894) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x895, x896) = fiat_p384_mulx_u32(x855, 0xfffffffe);
    let (x897, x898) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x899, x900) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x901, x902) = fiat_p384_addcarryx_u32(0x0, x898, x895);
    let (x903, x904) = fiat_p384_addcarryx_u32(x902, x896, x893);
    let (x905, x906) = fiat_p384_addcarryx_u32(x904, x894, x891);
    let (x907, x908) = fiat_p384_addcarryx_u32(x906, x892, x889);
    let (x909, x910) = fiat_p384_addcarryx_u32(x908, x890, x887);
    let (x911, x912) = fiat_p384_addcarryx_u32(x910, x888, x885);
    let (x913, x914) = fiat_p384_addcarryx_u32(x912, x886, x883);
    let (x915, x916) = fiat_p384_addcarryx_u32(x914, x884, x881);
    let x917: u32 = ((x916 as u32) + x882);
    let (x918, x919) = fiat_p384_addcarryx_u32(0x0, x855, x899);
    let (x920, x921) = fiat_p384_addcarryx_u32(x919, x857, x900);
    let (x922, x923) = fiat_p384_addcarryx_u32(x921, x859, (0x0 as u32));
    let (x924, x925) = fiat_p384_addcarryx_u32(x923, x861, x897);
    let (x926, x927) = fiat_p384_addcarryx_u32(x925, x863, x901);
    let (x928, x929) = fiat_p384_addcarryx_u32(x927, x865, x903);
    let (x930, x931) = fiat_p384_addcarryx_u32(x929, x867, x905);
    let (x932, x933) = fiat_p384_addcarryx_u32(x931, x869, x907);
    let (x934, x935) = fiat_p384_addcarryx_u32(x933, x871, x909);
    let (x936, x937) = fiat_p384_addcarryx_u32(x935, x873, x911);
    let (x938, x939) = fiat_p384_addcarryx_u32(x937, x875, x913);
    let (x940, x941) = fiat_p384_addcarryx_u32(x939, x877, x915);
    let (x942, x943) = fiat_p384_addcarryx_u32(x941, x879, x917);
    let x944: u32 = ((x943 as u32) + (x880 as u32));
    let (x945, x946) = fiat_p384_mulx_u32(x7, (arg2[11]));
    let (x947, x948) = fiat_p384_mulx_u32(x7, (arg2[10]));
    let (x949, x950) = fiat_p384_mulx_u32(x7, (arg2[9]));
    let (x951, x952) = fiat_p384_mulx_u32(x7, (arg2[8]));
    let (x953, x954) = fiat_p384_mulx_u32(x7, (arg2[7]));
    let (x955, x956) = fiat_p384_mulx_u32(x7, (arg2[6]));
    let (x957, x958) = fiat_p384_mulx_u32(x7, (arg2[5]));
    let (x959, x960) = fiat_p384_mulx_u32(x7, (arg2[4]));
    let (x961, x962) = fiat_p384_mulx_u32(x7, (arg2[3]));
    let (x963, x964) = fiat_p384_mulx_u32(x7, (arg2[2]));
    let (x965, x966) = fiat_p384_mulx_u32(x7, (arg2[1]));
    let (x967, x968) = fiat_p384_mulx_u32(x7, (arg2[0]));
    let (x969, x970) = fiat_p384_addcarryx_u32(0x0, x968, x965);
    let (x971, x972) = fiat_p384_addcarryx_u32(x970, x966, x963);
    let (x973, x974) = fiat_p384_addcarryx_u32(x972, x964, x961);
    let (x975, x976) = fiat_p384_addcarryx_u32(x974, x962, x959);
    let (x977, x978) = fiat_p384_addcarryx_u32(x976, x960, x957);
    let (x979, x980) = fiat_p384_addcarryx_u32(x978, x958, x955);
    let (x981, x982) = fiat_p384_addcarryx_u32(x980, x956, x953);
    let (x983, x984) = fiat_p384_addcarryx_u32(x982, x954, x951);
    let (x985, x986) = fiat_p384_addcarryx_u32(x984, x952, x949);
    let (x987, x988) = fiat_p384_addcarryx_u32(x986, x950, x947);
    let (x989, x990) = fiat_p384_addcarryx_u32(x988, x948, x945);
    let x991: u32 = ((x990 as u32) + x946);
    let (x992, x993) = fiat_p384_addcarryx_u32(0x0, x920, x967);
    let (x994, x995) = fiat_p384_addcarryx_u32(x993, x922, x969);
    let (x996, x997) = fiat_p384_addcarryx_u32(x995, x924, x971);
    let (x998, x999) = fiat_p384_addcarryx_u32(x997, x926, x973);
    let (x1000, x1001) = fiat_p384_addcarryx_u32(x999, x928, x975);
    let (x1002, x1003) = fiat_p384_addcarryx_u32(x1001, x930, x977);
    let (x1004, x1005) = fiat_p384_addcarryx_u32(x1003, x932, x979);
    let (x1006, x1007) = fiat_p384_addcarryx_u32(x1005, x934, x981);
    let (x1008, x1009) = fiat_p384_addcarryx_u32(x1007, x936, x983);
    let (x1010, x1011) = fiat_p384_addcarryx_u32(x1009, x938, x985);
    let (x1012, x1013) = fiat_p384_addcarryx_u32(x1011, x940, x987);
    let (x1014, x1015) = fiat_p384_addcarryx_u32(x1013, x942, x989);
    let (x1016, x1017) = fiat_p384_addcarryx_u32(x1015, x944, x991);
    let (x1018, x1019) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1020, x1021) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1022, x1023) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1024, x1025) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1026, x1027) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1028, x1029) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1030, x1031) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1032, x1033) = fiat_p384_mulx_u32(x992, 0xfffffffe);
    let (x1034, x1035) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1036, x1037) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1038, x1039) = fiat_p384_addcarryx_u32(0x0, x1035, x1032);
    let (x1040, x1041) = fiat_p384_addcarryx_u32(x1039, x1033, x1030);
    let (x1042, x1043) = fiat_p384_addcarryx_u32(x1041, x1031, x1028);
    let (x1044, x1045) = fiat_p384_addcarryx_u32(x1043, x1029, x1026);
    let (x1046, x1047) = fiat_p384_addcarryx_u32(x1045, x1027, x1024);
    let (x1048, x1049) = fiat_p384_addcarryx_u32(x1047, x1025, x1022);
    let (x1050, x1051) = fiat_p384_addcarryx_u32(x1049, x1023, x1020);
    let (x1052, x1053) = fiat_p384_addcarryx_u32(x1051, x1021, x1018);
    let x1054: u32 = ((x1053 as u32) + x1019);
    let (x1055, x1056) = fiat_p384_addcarryx_u32(0x0, x992, x1036);
    let (x1057, x1058) = fiat_p384_addcarryx_u32(x1056, x994, x1037);
    let (x1059, x1060) = fiat_p384_addcarryx_u32(x1058, x996, (0x0 as u32));
    let (x1061, x1062) = fiat_p384_addcarryx_u32(x1060, x998, x1034);
    let (x1063, x1064) = fiat_p384_addcarryx_u32(x1062, x1000, x1038);
    let (x1065, x1066) = fiat_p384_addcarryx_u32(x1064, x1002, x1040);
    let (x1067, x1068) = fiat_p384_addcarryx_u32(x1066, x1004, x1042);
    let (x1069, x1070) = fiat_p384_addcarryx_u32(x1068, x1006, x1044);
    let (x1071, x1072) = fiat_p384_addcarryx_u32(x1070, x1008, x1046);
    let (x1073, x1074) = fiat_p384_addcarryx_u32(x1072, x1010, x1048);
    let (x1075, x1076) = fiat_p384_addcarryx_u32(x1074, x1012, x1050);
    let (x1077, x1078) = fiat_p384_addcarryx_u32(x1076, x1014, x1052);
    let (x1079, x1080) = fiat_p384_addcarryx_u32(x1078, x1016, x1054);
    let x1081: u32 = ((x1080 as u32) + (x1017 as u32));
    let (x1082, x1083) = fiat_p384_mulx_u32(x8, (arg2[11]));
    let (x1084, x1085) = fiat_p384_mulx_u32(x8, (arg2[10]));
    let (x1086, x1087) = fiat_p384_mulx_u32(x8, (arg2[9]));
    let (x1088, x1089) = fiat_p384_mulx_u32(x8, (arg2[8]));
    let (x1090, x1091) = fiat_p384_mulx_u32(x8, (arg2[7]));
    let (x1092, x1093) = fiat_p384_mulx_u32(x8, (arg2[6]));
    let (x1094, x1095) = fiat_p384_mulx_u32(x8, (arg2[5]));
    let (x1096, x1097) = fiat_p384_mulx_u32(x8, (arg2[4]));
    let (x1098, x1099) = fiat_p384_mulx_u32(x8, (arg2[3]));
    let (x1100, x1101) = fiat_p384_mulx_u32(x8, (arg2[2]));
    let (x1102, x1103) = fiat_p384_mulx_u32(x8, (arg2[1]));
    let (x1104, x1105) = fiat_p384_mulx_u32(x8, (arg2[0]));
    let (x1106, x1107) = fiat_p384_addcarryx_u32(0x0, x1105, x1102);
    let (x1108, x1109) = fiat_p384_addcarryx_u32(x1107, x1103, x1100);
    let (x1110, x1111) = fiat_p384_addcarryx_u32(x1109, x1101, x1098);
    let (x1112, x1113) = fiat_p384_addcarryx_u32(x1111, x1099, x1096);
    let (x1114, x1115) = fiat_p384_addcarryx_u32(x1113, x1097, x1094);
    let (x1116, x1117) = fiat_p384_addcarryx_u32(x1115, x1095, x1092);
    let (x1118, x1119) = fiat_p384_addcarryx_u32(x1117, x1093, x1090);
    let (x1120, x1121) = fiat_p384_addcarryx_u32(x1119, x1091, x1088);
    let (x1122, x1123) = fiat_p384_addcarryx_u32(x1121, x1089, x1086);
    let (x1124, x1125) = fiat_p384_addcarryx_u32(x1123, x1087, x1084);
    let (x1126, x1127) = fiat_p384_addcarryx_u32(x1125, x1085, x1082);
    let x1128: u32 = ((x1127 as u32) + x1083);
    let (x1129, x1130) = fiat_p384_addcarryx_u32(0x0, x1057, x1104);
    let (x1131, x1132) = fiat_p384_addcarryx_u32(x1130, x1059, x1106);
    let (x1133, x1134) = fiat_p384_addcarryx_u32(x1132, x1061, x1108);
    let (x1135, x1136) = fiat_p384_addcarryx_u32(x1134, x1063, x1110);
    let (x1137, x1138) = fiat_p384_addcarryx_u32(x1136, x1065, x1112);
    let (x1139, x1140) = fiat_p384_addcarryx_u32(x1138, x1067, x1114);
    let (x1141, x1142) = fiat_p384_addcarryx_u32(x1140, x1069, x1116);
    let (x1143, x1144) = fiat_p384_addcarryx_u32(x1142, x1071, x1118);
    let (x1145, x1146) = fiat_p384_addcarryx_u32(x1144, x1073, x1120);
    let (x1147, x1148) = fiat_p384_addcarryx_u32(x1146, x1075, x1122);
    let (x1149, x1150) = fiat_p384_addcarryx_u32(x1148, x1077, x1124);
    let (x1151, x1152) = fiat_p384_addcarryx_u32(x1150, x1079, x1126);
    let (x1153, x1154) = fiat_p384_addcarryx_u32(x1152, x1081, x1128);
    let (x1155, x1156) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1157, x1158) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1159, x1160) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1161, x1162) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1163, x1164) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1165, x1166) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1167, x1168) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1169, x1170) = fiat_p384_mulx_u32(x1129, 0xfffffffe);
    let (x1171, x1172) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1173, x1174) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1175, x1176) = fiat_p384_addcarryx_u32(0x0, x1172, x1169);
    let (x1177, x1178) = fiat_p384_addcarryx_u32(x1176, x1170, x1167);
    let (x1179, x1180) = fiat_p384_addcarryx_u32(x1178, x1168, x1165);
    let (x1181, x1182) = fiat_p384_addcarryx_u32(x1180, x1166, x1163);
    let (x1183, x1184) = fiat_p384_addcarryx_u32(x1182, x1164, x1161);
    let (x1185, x1186) = fiat_p384_addcarryx_u32(x1184, x1162, x1159);
    let (x1187, x1188) = fiat_p384_addcarryx_u32(x1186, x1160, x1157);
    let (x1189, x1190) = fiat_p384_addcarryx_u32(x1188, x1158, x1155);
    let x1191: u32 = ((x1190 as u32) + x1156);
    let (x1192, x1193) = fiat_p384_addcarryx_u32(0x0, x1129, x1173);
    let (x1194, x1195) = fiat_p384_addcarryx_u32(x1193, x1131, x1174);
    let (x1196, x1197) = fiat_p384_addcarryx_u32(x1195, x1133, (0x0 as u32));
    let (x1198, x1199) = fiat_p384_addcarryx_u32(x1197, x1135, x1171);
    let (x1200, x1201) = fiat_p384_addcarryx_u32(x1199, x1137, x1175);
    let (x1202, x1203) = fiat_p384_addcarryx_u32(x1201, x1139, x1177);
    let (x1204, x1205) = fiat_p384_addcarryx_u32(x1203, x1141, x1179);
    let (x1206, x1207) = fiat_p384_addcarryx_u32(x1205, x1143, x1181);
    let (x1208, x1209) = fiat_p384_addcarryx_u32(x1207, x1145, x1183);
    let (x1210, x1211) = fiat_p384_addcarryx_u32(x1209, x1147, x1185);
    let (x1212, x1213) = fiat_p384_addcarryx_u32(x1211, x1149, x1187);
    let (x1214, x1215) = fiat_p384_addcarryx_u32(x1213, x1151, x1189);
    let (x1216, x1217) = fiat_p384_addcarryx_u32(x1215, x1153, x1191);
    let x1218: u32 = ((x1217 as u32) + (x1154 as u32));
    let (x1219, x1220) = fiat_p384_mulx_u32(x9, (arg2[11]));
    let (x1221, x1222) = fiat_p384_mulx_u32(x9, (arg2[10]));
    let (x1223, x1224) = fiat_p384_mulx_u32(x9, (arg2[9]));
    let (x1225, x1226) = fiat_p384_mulx_u32(x9, (arg2[8]));
    let (x1227, x1228) = fiat_p384_mulx_u32(x9, (arg2[7]));
    let (x1229, x1230) = fiat_p384_mulx_u32(x9, (arg2[6]));
    let (x1231, x1232) = fiat_p384_mulx_u32(x9, (arg2[5]));
    let (x1233, x1234) = fiat_p384_mulx_u32(x9, (arg2[4]));
    let (x1235, x1236) = fiat_p384_mulx_u32(x9, (arg2[3]));
    let (x1237, x1238) = fiat_p384_mulx_u32(x9, (arg2[2]));
    let (x1239, x1240) = fiat_p384_mulx_u32(x9, (arg2[1]));
    let (x1241, x1242) = fiat_p384_mulx_u32(x9, (arg2[0]));
    let (x1243, x1244) = fiat_p384_addcarryx_u32(0x0, x1242, x1239);
    let (x1245, x1246) = fiat_p384_addcarryx_u32(x1244, x1240, x1237);
    let (x1247, x1248) = fiat_p384_addcarryx_u32(x1246, x1238, x1235);
    let (x1249, x1250) = fiat_p384_addcarryx_u32(x1248, x1236, x1233);
    let (x1251, x1252) = fiat_p384_addcarryx_u32(x1250, x1234, x1231);
    let (x1253, x1254) = fiat_p384_addcarryx_u32(x1252, x1232, x1229);
    let (x1255, x1256) = fiat_p384_addcarryx_u32(x1254, x1230, x1227);
    let (x1257, x1258) = fiat_p384_addcarryx_u32(x1256, x1228, x1225);
    let (x1259, x1260) = fiat_p384_addcarryx_u32(x1258, x1226, x1223);
    let (x1261, x1262) = fiat_p384_addcarryx_u32(x1260, x1224, x1221);
    let (x1263, x1264) = fiat_p384_addcarryx_u32(x1262, x1222, x1219);
    let x1265: u32 = ((x1264 as u32) + x1220);
    let (x1266, x1267) = fiat_p384_addcarryx_u32(0x0, x1194, x1241);
    let (x1268, x1269) = fiat_p384_addcarryx_u32(x1267, x1196, x1243);
    let (x1270, x1271) = fiat_p384_addcarryx_u32(x1269, x1198, x1245);
    let (x1272, x1273) = fiat_p384_addcarryx_u32(x1271, x1200, x1247);
    let (x1274, x1275) = fiat_p384_addcarryx_u32(x1273, x1202, x1249);
    let (x1276, x1277) = fiat_p384_addcarryx_u32(x1275, x1204, x1251);
    let (x1278, x1279) = fiat_p384_addcarryx_u32(x1277, x1206, x1253);
    let (x1280, x1281) = fiat_p384_addcarryx_u32(x1279, x1208, x1255);
    let (x1282, x1283) = fiat_p384_addcarryx_u32(x1281, x1210, x1257);
    let (x1284, x1285) = fiat_p384_addcarryx_u32(x1283, x1212, x1259);
    let (x1286, x1287) = fiat_p384_addcarryx_u32(x1285, x1214, x1261);
    let (x1288, x1289) = fiat_p384_addcarryx_u32(x1287, x1216, x1263);
    let (x1290, x1291) = fiat_p384_addcarryx_u32(x1289, x1218, x1265);
    let (x1292, x1293) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1294, x1295) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1296, x1297) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1298, x1299) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1300, x1301) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1302, x1303) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1304, x1305) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1306, x1307) = fiat_p384_mulx_u32(x1266, 0xfffffffe);
    let (x1308, x1309) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1310, x1311) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1312, x1313) = fiat_p384_addcarryx_u32(0x0, x1309, x1306);
    let (x1314, x1315) = fiat_p384_addcarryx_u32(x1313, x1307, x1304);
    let (x1316, x1317) = fiat_p384_addcarryx_u32(x1315, x1305, x1302);
    let (x1318, x1319) = fiat_p384_addcarryx_u32(x1317, x1303, x1300);
    let (x1320, x1321) = fiat_p384_addcarryx_u32(x1319, x1301, x1298);
    let (x1322, x1323) = fiat_p384_addcarryx_u32(x1321, x1299, x1296);
    let (x1324, x1325) = fiat_p384_addcarryx_u32(x1323, x1297, x1294);
    let (x1326, x1327) = fiat_p384_addcarryx_u32(x1325, x1295, x1292);
    let x1328: u32 = ((x1327 as u32) + x1293);
    let (x1329, x1330) = fiat_p384_addcarryx_u32(0x0, x1266, x1310);
    let (x1331, x1332) = fiat_p384_addcarryx_u32(x1330, x1268, x1311);
    let (x1333, x1334) = fiat_p384_addcarryx_u32(x1332, x1270, (0x0 as u32));
    let (x1335, x1336) = fiat_p384_addcarryx_u32(x1334, x1272, x1308);
    let (x1337, x1338) = fiat_p384_addcarryx_u32(x1336, x1274, x1312);
    let (x1339, x1340) = fiat_p384_addcarryx_u32(x1338, x1276, x1314);
    let (x1341, x1342) = fiat_p384_addcarryx_u32(x1340, x1278, x1316);
    let (x1343, x1344) = fiat_p384_addcarryx_u32(x1342, x1280, x1318);
    let (x1345, x1346) = fiat_p384_addcarryx_u32(x1344, x1282, x1320);
    let (x1347, x1348) = fiat_p384_addcarryx_u32(x1346, x1284, x1322);
    let (x1349, x1350) = fiat_p384_addcarryx_u32(x1348, x1286, x1324);
    let (x1351, x1352) = fiat_p384_addcarryx_u32(x1350, x1288, x1326);
    let (x1353, x1354) = fiat_p384_addcarryx_u32(x1352, x1290, x1328);
    let x1355: u32 = ((x1354 as u32) + (x1291 as u32));
    let (x1356, x1357) = fiat_p384_mulx_u32(x10, (arg2[11]));
    let (x1358, x1359) = fiat_p384_mulx_u32(x10, (arg2[10]));
    let (x1360, x1361) = fiat_p384_mulx_u32(x10, (arg2[9]));
    let (x1362, x1363) = fiat_p384_mulx_u32(x10, (arg2[8]));
    let (x1364, x1365) = fiat_p384_mulx_u32(x10, (arg2[7]));
    let (x1366, x1367) = fiat_p384_mulx_u32(x10, (arg2[6]));
    let (x1368, x1369) = fiat_p384_mulx_u32(x10, (arg2[5]));
    let (x1370, x1371) = fiat_p384_mulx_u32(x10, (arg2[4]));
    let (x1372, x1373) = fiat_p384_mulx_u32(x10, (arg2[3]));
    let (x1374, x1375) = fiat_p384_mulx_u32(x10, (arg2[2]));
    let (x1376, x1377) = fiat_p384_mulx_u32(x10, (arg2[1]));
    let (x1378, x1379) = fiat_p384_mulx_u32(x10, (arg2[0]));
    let (x1380, x1381) = fiat_p384_addcarryx_u32(0x0, x1379, x1376);
    let (x1382, x1383) = fiat_p384_addcarryx_u32(x1381, x1377, x1374);
    let (x1384, x1385) = fiat_p384_addcarryx_u32(x1383, x1375, x1372);
    let (x1386, x1387) = fiat_p384_addcarryx_u32(x1385, x1373, x1370);
    let (x1388, x1389) = fiat_p384_addcarryx_u32(x1387, x1371, x1368);
    let (x1390, x1391) = fiat_p384_addcarryx_u32(x1389, x1369, x1366);
    let (x1392, x1393) = fiat_p384_addcarryx_u32(x1391, x1367, x1364);
    let (x1394, x1395) = fiat_p384_addcarryx_u32(x1393, x1365, x1362);
    let (x1396, x1397) = fiat_p384_addcarryx_u32(x1395, x1363, x1360);
    let (x1398, x1399) = fiat_p384_addcarryx_u32(x1397, x1361, x1358);
    let (x1400, x1401) = fiat_p384_addcarryx_u32(x1399, x1359, x1356);
    let x1402: u32 = ((x1401 as u32) + x1357);
    let (x1403, x1404) = fiat_p384_addcarryx_u32(0x0, x1331, x1378);
    let (x1405, x1406) = fiat_p384_addcarryx_u32(x1404, x1333, x1380);
    let (x1407, x1408) = fiat_p384_addcarryx_u32(x1406, x1335, x1382);
    let (x1409, x1410) = fiat_p384_addcarryx_u32(x1408, x1337, x1384);
    let (x1411, x1412) = fiat_p384_addcarryx_u32(x1410, x1339, x1386);
    let (x1413, x1414) = fiat_p384_addcarryx_u32(x1412, x1341, x1388);
    let (x1415, x1416) = fiat_p384_addcarryx_u32(x1414, x1343, x1390);
    let (x1417, x1418) = fiat_p384_addcarryx_u32(x1416, x1345, x1392);
    let (x1419, x1420) = fiat_p384_addcarryx_u32(x1418, x1347, x1394);
    let (x1421, x1422) = fiat_p384_addcarryx_u32(x1420, x1349, x1396);
    let (x1423, x1424) = fiat_p384_addcarryx_u32(x1422, x1351, x1398);
    let (x1425, x1426) = fiat_p384_addcarryx_u32(x1424, x1353, x1400);
    let (x1427, x1428) = fiat_p384_addcarryx_u32(x1426, x1355, x1402);
    let (x1429, x1430) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1431, x1432) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1433, x1434) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1435, x1436) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1437, x1438) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1439, x1440) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1441, x1442) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1443, x1444) = fiat_p384_mulx_u32(x1403, 0xfffffffe);
    let (x1445, x1446) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1447, x1448) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1449, x1450) = fiat_p384_addcarryx_u32(0x0, x1446, x1443);
    let (x1451, x1452) = fiat_p384_addcarryx_u32(x1450, x1444, x1441);
    let (x1453, x1454) = fiat_p384_addcarryx_u32(x1452, x1442, x1439);
    let (x1455, x1456) = fiat_p384_addcarryx_u32(x1454, x1440, x1437);
    let (x1457, x1458) = fiat_p384_addcarryx_u32(x1456, x1438, x1435);
    let (x1459, x1460) = fiat_p384_addcarryx_u32(x1458, x1436, x1433);
    let (x1461, x1462) = fiat_p384_addcarryx_u32(x1460, x1434, x1431);
    let (x1463, x1464) = fiat_p384_addcarryx_u32(x1462, x1432, x1429);
    let x1465: u32 = ((x1464 as u32) + x1430);
    let (x1466, x1467) = fiat_p384_addcarryx_u32(0x0, x1403, x1447);
    let (x1468, x1469) = fiat_p384_addcarryx_u32(x1467, x1405, x1448);
    let (x1470, x1471) = fiat_p384_addcarryx_u32(x1469, x1407, (0x0 as u32));
    let (x1472, x1473) = fiat_p384_addcarryx_u32(x1471, x1409, x1445);
    let (x1474, x1475) = fiat_p384_addcarryx_u32(x1473, x1411, x1449);
    let (x1476, x1477) = fiat_p384_addcarryx_u32(x1475, x1413, x1451);
    let (x1478, x1479) = fiat_p384_addcarryx_u32(x1477, x1415, x1453);
    let (x1480, x1481) = fiat_p384_addcarryx_u32(x1479, x1417, x1455);
    let (x1482, x1483) = fiat_p384_addcarryx_u32(x1481, x1419, x1457);
    let (x1484, x1485) = fiat_p384_addcarryx_u32(x1483, x1421, x1459);
    let (x1486, x1487) = fiat_p384_addcarryx_u32(x1485, x1423, x1461);
    let (x1488, x1489) = fiat_p384_addcarryx_u32(x1487, x1425, x1463);
    let (x1490, x1491) = fiat_p384_addcarryx_u32(x1489, x1427, x1465);
    let x1492: u32 = ((x1491 as u32) + (x1428 as u32));
    let (x1493, x1494) = fiat_p384_mulx_u32(x11, (arg2[11]));
    let (x1495, x1496) = fiat_p384_mulx_u32(x11, (arg2[10]));
    let (x1497, x1498) = fiat_p384_mulx_u32(x11, (arg2[9]));
    let (x1499, x1500) = fiat_p384_mulx_u32(x11, (arg2[8]));
    let (x1501, x1502) = fiat_p384_mulx_u32(x11, (arg2[7]));
    let (x1503, x1504) = fiat_p384_mulx_u32(x11, (arg2[6]));
    let (x1505, x1506) = fiat_p384_mulx_u32(x11, (arg2[5]));
    let (x1507, x1508) = fiat_p384_mulx_u32(x11, (arg2[4]));
    let (x1509, x1510) = fiat_p384_mulx_u32(x11, (arg2[3]));
    let (x1511, x1512) = fiat_p384_mulx_u32(x11, (arg2[2]));
    let (x1513, x1514) = fiat_p384_mulx_u32(x11, (arg2[1]));
    let (x1515, x1516) = fiat_p384_mulx_u32(x11, (arg2[0]));
    let (x1517, x1518) = fiat_p384_addcarryx_u32(0x0, x1516, x1513);
    let (x1519, x1520) = fiat_p384_addcarryx_u32(x1518, x1514, x1511);
    let (x1521, x1522) = fiat_p384_addcarryx_u32(x1520, x1512, x1509);
    let (x1523, x1524) = fiat_p384_addcarryx_u32(x1522, x1510, x1507);
    let (x1525, x1526) = fiat_p384_addcarryx_u32(x1524, x1508, x1505);
    let (x1527, x1528) = fiat_p384_addcarryx_u32(x1526, x1506, x1503);
    let (x1529, x1530) = fiat_p384_addcarryx_u32(x1528, x1504, x1501);
    let (x1531, x1532) = fiat_p384_addcarryx_u32(x1530, x1502, x1499);
    let (x1533, x1534) = fiat_p384_addcarryx_u32(x1532, x1500, x1497);
    let (x1535, x1536) = fiat_p384_addcarryx_u32(x1534, x1498, x1495);
    let (x1537, x1538) = fiat_p384_addcarryx_u32(x1536, x1496, x1493);
    let x1539: u32 = ((x1538 as u32) + x1494);
    let (x1540, x1541) = fiat_p384_addcarryx_u32(0x0, x1468, x1515);
    let (x1542, x1543) = fiat_p384_addcarryx_u32(x1541, x1470, x1517);
    let (x1544, x1545) = fiat_p384_addcarryx_u32(x1543, x1472, x1519);
    let (x1546, x1547) = fiat_p384_addcarryx_u32(x1545, x1474, x1521);
    let (x1548, x1549) = fiat_p384_addcarryx_u32(x1547, x1476, x1523);
    let (x1550, x1551) = fiat_p384_addcarryx_u32(x1549, x1478, x1525);
    let (x1552, x1553) = fiat_p384_addcarryx_u32(x1551, x1480, x1527);
    let (x1554, x1555) = fiat_p384_addcarryx_u32(x1553, x1482, x1529);
    let (x1556, x1557) = fiat_p384_addcarryx_u32(x1555, x1484, x1531);
    let (x1558, x1559) = fiat_p384_addcarryx_u32(x1557, x1486, x1533);
    let (x1560, x1561) = fiat_p384_addcarryx_u32(x1559, x1488, x1535);
    let (x1562, x1563) = fiat_p384_addcarryx_u32(x1561, x1490, x1537);
    let (x1564, x1565) = fiat_p384_addcarryx_u32(x1563, x1492, x1539);
    let (x1566, x1567) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1568, x1569) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1570, x1571) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1572, x1573) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1574, x1575) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1576, x1577) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1578, x1579) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1580, x1581) = fiat_p384_mulx_u32(x1540, 0xfffffffe);
    let (x1582, x1583) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1584, x1585) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1586, x1587) = fiat_p384_addcarryx_u32(0x0, x1583, x1580);
    let (x1588, x1589) = fiat_p384_addcarryx_u32(x1587, x1581, x1578);
    let (x1590, x1591) = fiat_p384_addcarryx_u32(x1589, x1579, x1576);
    let (x1592, x1593) = fiat_p384_addcarryx_u32(x1591, x1577, x1574);
    let (x1594, x1595) = fiat_p384_addcarryx_u32(x1593, x1575, x1572);
    let (x1596, x1597) = fiat_p384_addcarryx_u32(x1595, x1573, x1570);
    let (x1598, x1599) = fiat_p384_addcarryx_u32(x1597, x1571, x1568);
    let (x1600, x1601) = fiat_p384_addcarryx_u32(x1599, x1569, x1566);
    let x1602: u32 = ((x1601 as u32) + x1567);
    let (x1603, x1604) = fiat_p384_addcarryx_u32(0x0, x1540, x1584);
    let (x1605, x1606) = fiat_p384_addcarryx_u32(x1604, x1542, x1585);
    let (x1607, x1608) = fiat_p384_addcarryx_u32(x1606, x1544, (0x0 as u32));
    let (x1609, x1610) = fiat_p384_addcarryx_u32(x1608, x1546, x1582);
    let (x1611, x1612) = fiat_p384_addcarryx_u32(x1610, x1548, x1586);
    let (x1613, x1614) = fiat_p384_addcarryx_u32(x1612, x1550, x1588);
    let (x1615, x1616) = fiat_p384_addcarryx_u32(x1614, x1552, x1590);
    let (x1617, x1618) = fiat_p384_addcarryx_u32(x1616, x1554, x1592);
    let (x1619, x1620) = fiat_p384_addcarryx_u32(x1618, x1556, x1594);
    let (x1621, x1622) = fiat_p384_addcarryx_u32(x1620, x1558, x1596);
    let (x1623, x1624) = fiat_p384_addcarryx_u32(x1622, x1560, x1598);
    let (x1625, x1626) = fiat_p384_addcarryx_u32(x1624, x1562, x1600);
    let (x1627, x1628) = fiat_p384_addcarryx_u32(x1626, x1564, x1602);
    let x1629: u32 = ((x1628 as u32) + (x1565 as u32));
    let (x1630, x1631) = fiat_p384_subborrowx_u32(0x0, x1605, 0xffffffff);
    let (x1632, x1633) = fiat_p384_subborrowx_u32(x1631, x1607, (0x0 as u32));
    let (x1634, x1635) = fiat_p384_subborrowx_u32(x1633, x1609, (0x0 as u32));
    let (x1636, x1637) = fiat_p384_subborrowx_u32(x1635, x1611, 0xffffffff);
    let (x1638, x1639) = fiat_p384_subborrowx_u32(x1637, x1613, 0xfffffffe);
    let (x1640, x1641) = fiat_p384_subborrowx_u32(x1639, x1615, 0xffffffff);
    let (x1642, x1643) = fiat_p384_subborrowx_u32(x1641, x1617, 0xffffffff);
    let (x1644, x1645) = fiat_p384_subborrowx_u32(x1643, x1619, 0xffffffff);
    let (x1646, x1647) = fiat_p384_subborrowx_u32(x1645, x1621, 0xffffffff);
    let (x1648, x1649) = fiat_p384_subborrowx_u32(x1647, x1623, 0xffffffff);
    let (x1650, x1651) = fiat_p384_subborrowx_u32(x1649, x1625, 0xffffffff);
    let (x1652, x1653) = fiat_p384_subborrowx_u32(x1651, x1627, 0xffffffff);
    let (x1654, x1655) = fiat_p384_subborrowx_u32(x1653, x1629, (0x0 as u32));
    let (x1656) = fiat_p384_cmovznz_u32(x1655, x1630, x1605);
    let (x1657) = fiat_p384_cmovznz_u32(x1655, x1632, x1607);
    let (x1658) = fiat_p384_cmovznz_u32(x1655, x1634, x1609);
    let (x1659) = fiat_p384_cmovznz_u32(x1655, x1636, x1611);
    let (x1660) = fiat_p384_cmovznz_u32(x1655, x1638, x1613);
    let (x1661) = fiat_p384_cmovznz_u32(x1655, x1640, x1615);
    let (x1662) = fiat_p384_cmovznz_u32(x1655, x1642, x1617);
    let (x1663) = fiat_p384_cmovznz_u32(x1655, x1644, x1619);
    let (x1664) = fiat_p384_cmovznz_u32(x1655, x1646, x1621);
    let (x1665) = fiat_p384_cmovznz_u32(x1655, x1648, x1623);
    let (x1666) = fiat_p384_cmovznz_u32(x1655, x1650, x1625);
    let (x1667) = fiat_p384_cmovznz_u32(x1655, x1652, x1627);
    out1[0] = x1656;
    out1[1] = x1657;
    out1[2] = x1658;
    out1[3] = x1659;
    out1[4] = x1660;
    out1[5] = x1661;
    out1[6] = x1662;
    out1[7] = x1663;
    out1[8] = x1664;
    out1[9] = x1665;
    out1[10] = x1666;
    out1[11] = x1667;
    out1
}
#[doc = " The function fiat_p384_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_square(
    arg1: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let (x13, x14) = fiat_p384_mulx_u32(x12, (arg1[11]));
    let (x15, x16) = fiat_p384_mulx_u32(x12, (arg1[10]));
    let (x17, x18) = fiat_p384_mulx_u32(x12, (arg1[9]));
    let (x19, x20) = fiat_p384_mulx_u32(x12, (arg1[8]));
    let (x21, x22) = fiat_p384_mulx_u32(x12, (arg1[7]));
    let (x23, x24) = fiat_p384_mulx_u32(x12, (arg1[6]));
    let (x25, x26) = fiat_p384_mulx_u32(x12, (arg1[5]));
    let (x27, x28) = fiat_p384_mulx_u32(x12, (arg1[4]));
    let (x29, x30) = fiat_p384_mulx_u32(x12, (arg1[3]));
    let (x31, x32) = fiat_p384_mulx_u32(x12, (arg1[2]));
    let (x33, x34) = fiat_p384_mulx_u32(x12, (arg1[1]));
    let (x35, x36) = fiat_p384_mulx_u32(x12, (arg1[0]));
    let (x37, x38) = fiat_p384_addcarryx_u32(0x0, x36, x33);
    let (x39, x40) = fiat_p384_addcarryx_u32(x38, x34, x31);
    let (x41, x42) = fiat_p384_addcarryx_u32(x40, x32, x29);
    let (x43, x44) = fiat_p384_addcarryx_u32(x42, x30, x27);
    let (x45, x46) = fiat_p384_addcarryx_u32(x44, x28, x25);
    let (x47, x48) = fiat_p384_addcarryx_u32(x46, x26, x23);
    let (x49, x50) = fiat_p384_addcarryx_u32(x48, x24, x21);
    let (x51, x52) = fiat_p384_addcarryx_u32(x50, x22, x19);
    let (x53, x54) = fiat_p384_addcarryx_u32(x52, x20, x17);
    let (x55, x56) = fiat_p384_addcarryx_u32(x54, x18, x15);
    let (x57, x58) = fiat_p384_addcarryx_u32(x56, x16, x13);
    let x59: u32 = ((x58 as u32) + x14);
    let (x60, x61) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x62, x63) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x64, x65) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x66, x67) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x68, x69) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x70, x71) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x72, x73) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x74, x75) = fiat_p384_mulx_u32(x35, 0xfffffffe);
    let (x76, x77) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x78, x79) = fiat_p384_mulx_u32(x35, 0xffffffff);
    let (x80, x81) = fiat_p384_addcarryx_u32(0x0, x77, x74);
    let (x82, x83) = fiat_p384_addcarryx_u32(x81, x75, x72);
    let (x84, x85) = fiat_p384_addcarryx_u32(x83, x73, x70);
    let (x86, x87) = fiat_p384_addcarryx_u32(x85, x71, x68);
    let (x88, x89) = fiat_p384_addcarryx_u32(x87, x69, x66);
    let (x90, x91) = fiat_p384_addcarryx_u32(x89, x67, x64);
    let (x92, x93) = fiat_p384_addcarryx_u32(x91, x65, x62);
    let (x94, x95) = fiat_p384_addcarryx_u32(x93, x63, x60);
    let x96: u32 = ((x95 as u32) + x61);
    let (x97, x98) = fiat_p384_addcarryx_u32(0x0, x35, x78);
    let (x99, x100) = fiat_p384_addcarryx_u32(x98, x37, x79);
    let (x101, x102) = fiat_p384_addcarryx_u32(x100, x39, (0x0 as u32));
    let (x103, x104) = fiat_p384_addcarryx_u32(x102, x41, x76);
    let (x105, x106) = fiat_p384_addcarryx_u32(x104, x43, x80);
    let (x107, x108) = fiat_p384_addcarryx_u32(x106, x45, x82);
    let (x109, x110) = fiat_p384_addcarryx_u32(x108, x47, x84);
    let (x111, x112) = fiat_p384_addcarryx_u32(x110, x49, x86);
    let (x113, x114) = fiat_p384_addcarryx_u32(x112, x51, x88);
    let (x115, x116) = fiat_p384_addcarryx_u32(x114, x53, x90);
    let (x117, x118) = fiat_p384_addcarryx_u32(x116, x55, x92);
    let (x119, x120) = fiat_p384_addcarryx_u32(x118, x57, x94);
    let (x121, x122) = fiat_p384_addcarryx_u32(x120, x59, x96);
    let (x123, x124) = fiat_p384_mulx_u32(x1, (arg1[11]));
    let (x125, x126) = fiat_p384_mulx_u32(x1, (arg1[10]));
    let (x127, x128) = fiat_p384_mulx_u32(x1, (arg1[9]));
    let (x129, x130) = fiat_p384_mulx_u32(x1, (arg1[8]));
    let (x131, x132) = fiat_p384_mulx_u32(x1, (arg1[7]));
    let (x133, x134) = fiat_p384_mulx_u32(x1, (arg1[6]));
    let (x135, x136) = fiat_p384_mulx_u32(x1, (arg1[5]));
    let (x137, x138) = fiat_p384_mulx_u32(x1, (arg1[4]));
    let (x139, x140) = fiat_p384_mulx_u32(x1, (arg1[3]));
    let (x141, x142) = fiat_p384_mulx_u32(x1, (arg1[2]));
    let (x143, x144) = fiat_p384_mulx_u32(x1, (arg1[1]));
    let (x145, x146) = fiat_p384_mulx_u32(x1, (arg1[0]));
    let (x147, x148) = fiat_p384_addcarryx_u32(0x0, x146, x143);
    let (x149, x150) = fiat_p384_addcarryx_u32(x148, x144, x141);
    let (x151, x152) = fiat_p384_addcarryx_u32(x150, x142, x139);
    let (x153, x154) = fiat_p384_addcarryx_u32(x152, x140, x137);
    let (x155, x156) = fiat_p384_addcarryx_u32(x154, x138, x135);
    let (x157, x158) = fiat_p384_addcarryx_u32(x156, x136, x133);
    let (x159, x160) = fiat_p384_addcarryx_u32(x158, x134, x131);
    let (x161, x162) = fiat_p384_addcarryx_u32(x160, x132, x129);
    let (x163, x164) = fiat_p384_addcarryx_u32(x162, x130, x127);
    let (x165, x166) = fiat_p384_addcarryx_u32(x164, x128, x125);
    let (x167, x168) = fiat_p384_addcarryx_u32(x166, x126, x123);
    let x169: u32 = ((x168 as u32) + x124);
    let (x170, x171) = fiat_p384_addcarryx_u32(0x0, x99, x145);
    let (x172, x173) = fiat_p384_addcarryx_u32(x171, x101, x147);
    let (x174, x175) = fiat_p384_addcarryx_u32(x173, x103, x149);
    let (x176, x177) = fiat_p384_addcarryx_u32(x175, x105, x151);
    let (x178, x179) = fiat_p384_addcarryx_u32(x177, x107, x153);
    let (x180, x181) = fiat_p384_addcarryx_u32(x179, x109, x155);
    let (x182, x183) = fiat_p384_addcarryx_u32(x181, x111, x157);
    let (x184, x185) = fiat_p384_addcarryx_u32(x183, x113, x159);
    let (x186, x187) = fiat_p384_addcarryx_u32(x185, x115, x161);
    let (x188, x189) = fiat_p384_addcarryx_u32(x187, x117, x163);
    let (x190, x191) = fiat_p384_addcarryx_u32(x189, x119, x165);
    let (x192, x193) = fiat_p384_addcarryx_u32(x191, x121, x167);
    let (x194, x195) = fiat_p384_addcarryx_u32(x193, (x122 as u32), x169);
    let (x196, x197) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x198, x199) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x200, x201) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x202, x203) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x204, x205) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x206, x207) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x208, x209) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x210, x211) = fiat_p384_mulx_u32(x170, 0xfffffffe);
    let (x212, x213) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x214, x215) = fiat_p384_mulx_u32(x170, 0xffffffff);
    let (x216, x217) = fiat_p384_addcarryx_u32(0x0, x213, x210);
    let (x218, x219) = fiat_p384_addcarryx_u32(x217, x211, x208);
    let (x220, x221) = fiat_p384_addcarryx_u32(x219, x209, x206);
    let (x222, x223) = fiat_p384_addcarryx_u32(x221, x207, x204);
    let (x224, x225) = fiat_p384_addcarryx_u32(x223, x205, x202);
    let (x226, x227) = fiat_p384_addcarryx_u32(x225, x203, x200);
    let (x228, x229) = fiat_p384_addcarryx_u32(x227, x201, x198);
    let (x230, x231) = fiat_p384_addcarryx_u32(x229, x199, x196);
    let x232: u32 = ((x231 as u32) + x197);
    let (x233, x234) = fiat_p384_addcarryx_u32(0x0, x170, x214);
    let (x235, x236) = fiat_p384_addcarryx_u32(x234, x172, x215);
    let (x237, x238) = fiat_p384_addcarryx_u32(x236, x174, (0x0 as u32));
    let (x239, x240) = fiat_p384_addcarryx_u32(x238, x176, x212);
    let (x241, x242) = fiat_p384_addcarryx_u32(x240, x178, x216);
    let (x243, x244) = fiat_p384_addcarryx_u32(x242, x180, x218);
    let (x245, x246) = fiat_p384_addcarryx_u32(x244, x182, x220);
    let (x247, x248) = fiat_p384_addcarryx_u32(x246, x184, x222);
    let (x249, x250) = fiat_p384_addcarryx_u32(x248, x186, x224);
    let (x251, x252) = fiat_p384_addcarryx_u32(x250, x188, x226);
    let (x253, x254) = fiat_p384_addcarryx_u32(x252, x190, x228);
    let (x255, x256) = fiat_p384_addcarryx_u32(x254, x192, x230);
    let (x257, x258) = fiat_p384_addcarryx_u32(x256, x194, x232);
    let x259: u32 = ((x258 as u32) + (x195 as u32));
    let (x260, x261) = fiat_p384_mulx_u32(x2, (arg1[11]));
    let (x262, x263) = fiat_p384_mulx_u32(x2, (arg1[10]));
    let (x264, x265) = fiat_p384_mulx_u32(x2, (arg1[9]));
    let (x266, x267) = fiat_p384_mulx_u32(x2, (arg1[8]));
    let (x268, x269) = fiat_p384_mulx_u32(x2, (arg1[7]));
    let (x270, x271) = fiat_p384_mulx_u32(x2, (arg1[6]));
    let (x272, x273) = fiat_p384_mulx_u32(x2, (arg1[5]));
    let (x274, x275) = fiat_p384_mulx_u32(x2, (arg1[4]));
    let (x276, x277) = fiat_p384_mulx_u32(x2, (arg1[3]));
    let (x278, x279) = fiat_p384_mulx_u32(x2, (arg1[2]));
    let (x280, x281) = fiat_p384_mulx_u32(x2, (arg1[1]));
    let (x282, x283) = fiat_p384_mulx_u32(x2, (arg1[0]));
    let (x284, x285) = fiat_p384_addcarryx_u32(0x0, x283, x280);
    let (x286, x287) = fiat_p384_addcarryx_u32(x285, x281, x278);
    let (x288, x289) = fiat_p384_addcarryx_u32(x287, x279, x276);
    let (x290, x291) = fiat_p384_addcarryx_u32(x289, x277, x274);
    let (x292, x293) = fiat_p384_addcarryx_u32(x291, x275, x272);
    let (x294, x295) = fiat_p384_addcarryx_u32(x293, x273, x270);
    let (x296, x297) = fiat_p384_addcarryx_u32(x295, x271, x268);
    let (x298, x299) = fiat_p384_addcarryx_u32(x297, x269, x266);
    let (x300, x301) = fiat_p384_addcarryx_u32(x299, x267, x264);
    let (x302, x303) = fiat_p384_addcarryx_u32(x301, x265, x262);
    let (x304, x305) = fiat_p384_addcarryx_u32(x303, x263, x260);
    let x306: u32 = ((x305 as u32) + x261);
    let (x307, x308) = fiat_p384_addcarryx_u32(0x0, x235, x282);
    let (x309, x310) = fiat_p384_addcarryx_u32(x308, x237, x284);
    let (x311, x312) = fiat_p384_addcarryx_u32(x310, x239, x286);
    let (x313, x314) = fiat_p384_addcarryx_u32(x312, x241, x288);
    let (x315, x316) = fiat_p384_addcarryx_u32(x314, x243, x290);
    let (x317, x318) = fiat_p384_addcarryx_u32(x316, x245, x292);
    let (x319, x320) = fiat_p384_addcarryx_u32(x318, x247, x294);
    let (x321, x322) = fiat_p384_addcarryx_u32(x320, x249, x296);
    let (x323, x324) = fiat_p384_addcarryx_u32(x322, x251, x298);
    let (x325, x326) = fiat_p384_addcarryx_u32(x324, x253, x300);
    let (x327, x328) = fiat_p384_addcarryx_u32(x326, x255, x302);
    let (x329, x330) = fiat_p384_addcarryx_u32(x328, x257, x304);
    let (x331, x332) = fiat_p384_addcarryx_u32(x330, x259, x306);
    let (x333, x334) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x335, x336) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x337, x338) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x339, x340) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x341, x342) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x343, x344) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x345, x346) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x347, x348) = fiat_p384_mulx_u32(x307, 0xfffffffe);
    let (x349, x350) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x351, x352) = fiat_p384_mulx_u32(x307, 0xffffffff);
    let (x353, x354) = fiat_p384_addcarryx_u32(0x0, x350, x347);
    let (x355, x356) = fiat_p384_addcarryx_u32(x354, x348, x345);
    let (x357, x358) = fiat_p384_addcarryx_u32(x356, x346, x343);
    let (x359, x360) = fiat_p384_addcarryx_u32(x358, x344, x341);
    let (x361, x362) = fiat_p384_addcarryx_u32(x360, x342, x339);
    let (x363, x364) = fiat_p384_addcarryx_u32(x362, x340, x337);
    let (x365, x366) = fiat_p384_addcarryx_u32(x364, x338, x335);
    let (x367, x368) = fiat_p384_addcarryx_u32(x366, x336, x333);
    let x369: u32 = ((x368 as u32) + x334);
    let (x370, x371) = fiat_p384_addcarryx_u32(0x0, x307, x351);
    let (x372, x373) = fiat_p384_addcarryx_u32(x371, x309, x352);
    let (x374, x375) = fiat_p384_addcarryx_u32(x373, x311, (0x0 as u32));
    let (x376, x377) = fiat_p384_addcarryx_u32(x375, x313, x349);
    let (x378, x379) = fiat_p384_addcarryx_u32(x377, x315, x353);
    let (x380, x381) = fiat_p384_addcarryx_u32(x379, x317, x355);
    let (x382, x383) = fiat_p384_addcarryx_u32(x381, x319, x357);
    let (x384, x385) = fiat_p384_addcarryx_u32(x383, x321, x359);
    let (x386, x387) = fiat_p384_addcarryx_u32(x385, x323, x361);
    let (x388, x389) = fiat_p384_addcarryx_u32(x387, x325, x363);
    let (x390, x391) = fiat_p384_addcarryx_u32(x389, x327, x365);
    let (x392, x393) = fiat_p384_addcarryx_u32(x391, x329, x367);
    let (x394, x395) = fiat_p384_addcarryx_u32(x393, x331, x369);
    let x396: u32 = ((x395 as u32) + (x332 as u32));
    let (x397, x398) = fiat_p384_mulx_u32(x3, (arg1[11]));
    let (x399, x400) = fiat_p384_mulx_u32(x3, (arg1[10]));
    let (x401, x402) = fiat_p384_mulx_u32(x3, (arg1[9]));
    let (x403, x404) = fiat_p384_mulx_u32(x3, (arg1[8]));
    let (x405, x406) = fiat_p384_mulx_u32(x3, (arg1[7]));
    let (x407, x408) = fiat_p384_mulx_u32(x3, (arg1[6]));
    let (x409, x410) = fiat_p384_mulx_u32(x3, (arg1[5]));
    let (x411, x412) = fiat_p384_mulx_u32(x3, (arg1[4]));
    let (x413, x414) = fiat_p384_mulx_u32(x3, (arg1[3]));
    let (x415, x416) = fiat_p384_mulx_u32(x3, (arg1[2]));
    let (x417, x418) = fiat_p384_mulx_u32(x3, (arg1[1]));
    let (x419, x420) = fiat_p384_mulx_u32(x3, (arg1[0]));
    let (x421, x422) = fiat_p384_addcarryx_u32(0x0, x420, x417);
    let (x423, x424) = fiat_p384_addcarryx_u32(x422, x418, x415);
    let (x425, x426) = fiat_p384_addcarryx_u32(x424, x416, x413);
    let (x427, x428) = fiat_p384_addcarryx_u32(x426, x414, x411);
    let (x429, x430) = fiat_p384_addcarryx_u32(x428, x412, x409);
    let (x431, x432) = fiat_p384_addcarryx_u32(x430, x410, x407);
    let (x433, x434) = fiat_p384_addcarryx_u32(x432, x408, x405);
    let (x435, x436) = fiat_p384_addcarryx_u32(x434, x406, x403);
    let (x437, x438) = fiat_p384_addcarryx_u32(x436, x404, x401);
    let (x439, x440) = fiat_p384_addcarryx_u32(x438, x402, x399);
    let (x441, x442) = fiat_p384_addcarryx_u32(x440, x400, x397);
    let x443: u32 = ((x442 as u32) + x398);
    let (x444, x445) = fiat_p384_addcarryx_u32(0x0, x372, x419);
    let (x446, x447) = fiat_p384_addcarryx_u32(x445, x374, x421);
    let (x448, x449) = fiat_p384_addcarryx_u32(x447, x376, x423);
    let (x450, x451) = fiat_p384_addcarryx_u32(x449, x378, x425);
    let (x452, x453) = fiat_p384_addcarryx_u32(x451, x380, x427);
    let (x454, x455) = fiat_p384_addcarryx_u32(x453, x382, x429);
    let (x456, x457) = fiat_p384_addcarryx_u32(x455, x384, x431);
    let (x458, x459) = fiat_p384_addcarryx_u32(x457, x386, x433);
    let (x460, x461) = fiat_p384_addcarryx_u32(x459, x388, x435);
    let (x462, x463) = fiat_p384_addcarryx_u32(x461, x390, x437);
    let (x464, x465) = fiat_p384_addcarryx_u32(x463, x392, x439);
    let (x466, x467) = fiat_p384_addcarryx_u32(x465, x394, x441);
    let (x468, x469) = fiat_p384_addcarryx_u32(x467, x396, x443);
    let (x470, x471) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x472, x473) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x474, x475) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x476, x477) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x478, x479) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x480, x481) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x482, x483) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x484, x485) = fiat_p384_mulx_u32(x444, 0xfffffffe);
    let (x486, x487) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x488, x489) = fiat_p384_mulx_u32(x444, 0xffffffff);
    let (x490, x491) = fiat_p384_addcarryx_u32(0x0, x487, x484);
    let (x492, x493) = fiat_p384_addcarryx_u32(x491, x485, x482);
    let (x494, x495) = fiat_p384_addcarryx_u32(x493, x483, x480);
    let (x496, x497) = fiat_p384_addcarryx_u32(x495, x481, x478);
    let (x498, x499) = fiat_p384_addcarryx_u32(x497, x479, x476);
    let (x500, x501) = fiat_p384_addcarryx_u32(x499, x477, x474);
    let (x502, x503) = fiat_p384_addcarryx_u32(x501, x475, x472);
    let (x504, x505) = fiat_p384_addcarryx_u32(x503, x473, x470);
    let x506: u32 = ((x505 as u32) + x471);
    let (x507, x508) = fiat_p384_addcarryx_u32(0x0, x444, x488);
    let (x509, x510) = fiat_p384_addcarryx_u32(x508, x446, x489);
    let (x511, x512) = fiat_p384_addcarryx_u32(x510, x448, (0x0 as u32));
    let (x513, x514) = fiat_p384_addcarryx_u32(x512, x450, x486);
    let (x515, x516) = fiat_p384_addcarryx_u32(x514, x452, x490);
    let (x517, x518) = fiat_p384_addcarryx_u32(x516, x454, x492);
    let (x519, x520) = fiat_p384_addcarryx_u32(x518, x456, x494);
    let (x521, x522) = fiat_p384_addcarryx_u32(x520, x458, x496);
    let (x523, x524) = fiat_p384_addcarryx_u32(x522, x460, x498);
    let (x525, x526) = fiat_p384_addcarryx_u32(x524, x462, x500);
    let (x527, x528) = fiat_p384_addcarryx_u32(x526, x464, x502);
    let (x529, x530) = fiat_p384_addcarryx_u32(x528, x466, x504);
    let (x531, x532) = fiat_p384_addcarryx_u32(x530, x468, x506);
    let x533: u32 = ((x532 as u32) + (x469 as u32));
    let (x534, x535) = fiat_p384_mulx_u32(x4, (arg1[11]));
    let (x536, x537) = fiat_p384_mulx_u32(x4, (arg1[10]));
    let (x538, x539) = fiat_p384_mulx_u32(x4, (arg1[9]));
    let (x540, x541) = fiat_p384_mulx_u32(x4, (arg1[8]));
    let (x542, x543) = fiat_p384_mulx_u32(x4, (arg1[7]));
    let (x544, x545) = fiat_p384_mulx_u32(x4, (arg1[6]));
    let (x546, x547) = fiat_p384_mulx_u32(x4, (arg1[5]));
    let (x548, x549) = fiat_p384_mulx_u32(x4, (arg1[4]));
    let (x550, x551) = fiat_p384_mulx_u32(x4, (arg1[3]));
    let (x552, x553) = fiat_p384_mulx_u32(x4, (arg1[2]));
    let (x554, x555) = fiat_p384_mulx_u32(x4, (arg1[1]));
    let (x556, x557) = fiat_p384_mulx_u32(x4, (arg1[0]));
    let (x558, x559) = fiat_p384_addcarryx_u32(0x0, x557, x554);
    let (x560, x561) = fiat_p384_addcarryx_u32(x559, x555, x552);
    let (x562, x563) = fiat_p384_addcarryx_u32(x561, x553, x550);
    let (x564, x565) = fiat_p384_addcarryx_u32(x563, x551, x548);
    let (x566, x567) = fiat_p384_addcarryx_u32(x565, x549, x546);
    let (x568, x569) = fiat_p384_addcarryx_u32(x567, x547, x544);
    let (x570, x571) = fiat_p384_addcarryx_u32(x569, x545, x542);
    let (x572, x573) = fiat_p384_addcarryx_u32(x571, x543, x540);
    let (x574, x575) = fiat_p384_addcarryx_u32(x573, x541, x538);
    let (x576, x577) = fiat_p384_addcarryx_u32(x575, x539, x536);
    let (x578, x579) = fiat_p384_addcarryx_u32(x577, x537, x534);
    let x580: u32 = ((x579 as u32) + x535);
    let (x581, x582) = fiat_p384_addcarryx_u32(0x0, x509, x556);
    let (x583, x584) = fiat_p384_addcarryx_u32(x582, x511, x558);
    let (x585, x586) = fiat_p384_addcarryx_u32(x584, x513, x560);
    let (x587, x588) = fiat_p384_addcarryx_u32(x586, x515, x562);
    let (x589, x590) = fiat_p384_addcarryx_u32(x588, x517, x564);
    let (x591, x592) = fiat_p384_addcarryx_u32(x590, x519, x566);
    let (x593, x594) = fiat_p384_addcarryx_u32(x592, x521, x568);
    let (x595, x596) = fiat_p384_addcarryx_u32(x594, x523, x570);
    let (x597, x598) = fiat_p384_addcarryx_u32(x596, x525, x572);
    let (x599, x600) = fiat_p384_addcarryx_u32(x598, x527, x574);
    let (x601, x602) = fiat_p384_addcarryx_u32(x600, x529, x576);
    let (x603, x604) = fiat_p384_addcarryx_u32(x602, x531, x578);
    let (x605, x606) = fiat_p384_addcarryx_u32(x604, x533, x580);
    let (x607, x608) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x609, x610) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x611, x612) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x613, x614) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x615, x616) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x617, x618) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x619, x620) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x621, x622) = fiat_p384_mulx_u32(x581, 0xfffffffe);
    let (x623, x624) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x625, x626) = fiat_p384_mulx_u32(x581, 0xffffffff);
    let (x627, x628) = fiat_p384_addcarryx_u32(0x0, x624, x621);
    let (x629, x630) = fiat_p384_addcarryx_u32(x628, x622, x619);
    let (x631, x632) = fiat_p384_addcarryx_u32(x630, x620, x617);
    let (x633, x634) = fiat_p384_addcarryx_u32(x632, x618, x615);
    let (x635, x636) = fiat_p384_addcarryx_u32(x634, x616, x613);
    let (x637, x638) = fiat_p384_addcarryx_u32(x636, x614, x611);
    let (x639, x640) = fiat_p384_addcarryx_u32(x638, x612, x609);
    let (x641, x642) = fiat_p384_addcarryx_u32(x640, x610, x607);
    let x643: u32 = ((x642 as u32) + x608);
    let (x644, x645) = fiat_p384_addcarryx_u32(0x0, x581, x625);
    let (x646, x647) = fiat_p384_addcarryx_u32(x645, x583, x626);
    let (x648, x649) = fiat_p384_addcarryx_u32(x647, x585, (0x0 as u32));
    let (x650, x651) = fiat_p384_addcarryx_u32(x649, x587, x623);
    let (x652, x653) = fiat_p384_addcarryx_u32(x651, x589, x627);
    let (x654, x655) = fiat_p384_addcarryx_u32(x653, x591, x629);
    let (x656, x657) = fiat_p384_addcarryx_u32(x655, x593, x631);
    let (x658, x659) = fiat_p384_addcarryx_u32(x657, x595, x633);
    let (x660, x661) = fiat_p384_addcarryx_u32(x659, x597, x635);
    let (x662, x663) = fiat_p384_addcarryx_u32(x661, x599, x637);
    let (x664, x665) = fiat_p384_addcarryx_u32(x663, x601, x639);
    let (x666, x667) = fiat_p384_addcarryx_u32(x665, x603, x641);
    let (x668, x669) = fiat_p384_addcarryx_u32(x667, x605, x643);
    let x670: u32 = ((x669 as u32) + (x606 as u32));
    let (x671, x672) = fiat_p384_mulx_u32(x5, (arg1[11]));
    let (x673, x674) = fiat_p384_mulx_u32(x5, (arg1[10]));
    let (x675, x676) = fiat_p384_mulx_u32(x5, (arg1[9]));
    let (x677, x678) = fiat_p384_mulx_u32(x5, (arg1[8]));
    let (x679, x680) = fiat_p384_mulx_u32(x5, (arg1[7]));
    let (x681, x682) = fiat_p384_mulx_u32(x5, (arg1[6]));
    let (x683, x684) = fiat_p384_mulx_u32(x5, (arg1[5]));
    let (x685, x686) = fiat_p384_mulx_u32(x5, (arg1[4]));
    let (x687, x688) = fiat_p384_mulx_u32(x5, (arg1[3]));
    let (x689, x690) = fiat_p384_mulx_u32(x5, (arg1[2]));
    let (x691, x692) = fiat_p384_mulx_u32(x5, (arg1[1]));
    let (x693, x694) = fiat_p384_mulx_u32(x5, (arg1[0]));
    let (x695, x696) = fiat_p384_addcarryx_u32(0x0, x694, x691);
    let (x697, x698) = fiat_p384_addcarryx_u32(x696, x692, x689);
    let (x699, x700) = fiat_p384_addcarryx_u32(x698, x690, x687);
    let (x701, x702) = fiat_p384_addcarryx_u32(x700, x688, x685);
    let (x703, x704) = fiat_p384_addcarryx_u32(x702, x686, x683);
    let (x705, x706) = fiat_p384_addcarryx_u32(x704, x684, x681);
    let (x707, x708) = fiat_p384_addcarryx_u32(x706, x682, x679);
    let (x709, x710) = fiat_p384_addcarryx_u32(x708, x680, x677);
    let (x711, x712) = fiat_p384_addcarryx_u32(x710, x678, x675);
    let (x713, x714) = fiat_p384_addcarryx_u32(x712, x676, x673);
    let (x715, x716) = fiat_p384_addcarryx_u32(x714, x674, x671);
    let x717: u32 = ((x716 as u32) + x672);
    let (x718, x719) = fiat_p384_addcarryx_u32(0x0, x646, x693);
    let (x720, x721) = fiat_p384_addcarryx_u32(x719, x648, x695);
    let (x722, x723) = fiat_p384_addcarryx_u32(x721, x650, x697);
    let (x724, x725) = fiat_p384_addcarryx_u32(x723, x652, x699);
    let (x726, x727) = fiat_p384_addcarryx_u32(x725, x654, x701);
    let (x728, x729) = fiat_p384_addcarryx_u32(x727, x656, x703);
    let (x730, x731) = fiat_p384_addcarryx_u32(x729, x658, x705);
    let (x732, x733) = fiat_p384_addcarryx_u32(x731, x660, x707);
    let (x734, x735) = fiat_p384_addcarryx_u32(x733, x662, x709);
    let (x736, x737) = fiat_p384_addcarryx_u32(x735, x664, x711);
    let (x738, x739) = fiat_p384_addcarryx_u32(x737, x666, x713);
    let (x740, x741) = fiat_p384_addcarryx_u32(x739, x668, x715);
    let (x742, x743) = fiat_p384_addcarryx_u32(x741, x670, x717);
    let (x744, x745) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x746, x747) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x748, x749) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x750, x751) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x752, x753) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x754, x755) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x756, x757) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x758, x759) = fiat_p384_mulx_u32(x718, 0xfffffffe);
    let (x760, x761) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x762, x763) = fiat_p384_mulx_u32(x718, 0xffffffff);
    let (x764, x765) = fiat_p384_addcarryx_u32(0x0, x761, x758);
    let (x766, x767) = fiat_p384_addcarryx_u32(x765, x759, x756);
    let (x768, x769) = fiat_p384_addcarryx_u32(x767, x757, x754);
    let (x770, x771) = fiat_p384_addcarryx_u32(x769, x755, x752);
    let (x772, x773) = fiat_p384_addcarryx_u32(x771, x753, x750);
    let (x774, x775) = fiat_p384_addcarryx_u32(x773, x751, x748);
    let (x776, x777) = fiat_p384_addcarryx_u32(x775, x749, x746);
    let (x778, x779) = fiat_p384_addcarryx_u32(x777, x747, x744);
    let x780: u32 = ((x779 as u32) + x745);
    let (x781, x782) = fiat_p384_addcarryx_u32(0x0, x718, x762);
    let (x783, x784) = fiat_p384_addcarryx_u32(x782, x720, x763);
    let (x785, x786) = fiat_p384_addcarryx_u32(x784, x722, (0x0 as u32));
    let (x787, x788) = fiat_p384_addcarryx_u32(x786, x724, x760);
    let (x789, x790) = fiat_p384_addcarryx_u32(x788, x726, x764);
    let (x791, x792) = fiat_p384_addcarryx_u32(x790, x728, x766);
    let (x793, x794) = fiat_p384_addcarryx_u32(x792, x730, x768);
    let (x795, x796) = fiat_p384_addcarryx_u32(x794, x732, x770);
    let (x797, x798) = fiat_p384_addcarryx_u32(x796, x734, x772);
    let (x799, x800) = fiat_p384_addcarryx_u32(x798, x736, x774);
    let (x801, x802) = fiat_p384_addcarryx_u32(x800, x738, x776);
    let (x803, x804) = fiat_p384_addcarryx_u32(x802, x740, x778);
    let (x805, x806) = fiat_p384_addcarryx_u32(x804, x742, x780);
    let x807: u32 = ((x806 as u32) + (x743 as u32));
    let (x808, x809) = fiat_p384_mulx_u32(x6, (arg1[11]));
    let (x810, x811) = fiat_p384_mulx_u32(x6, (arg1[10]));
    let (x812, x813) = fiat_p384_mulx_u32(x6, (arg1[9]));
    let (x814, x815) = fiat_p384_mulx_u32(x6, (arg1[8]));
    let (x816, x817) = fiat_p384_mulx_u32(x6, (arg1[7]));
    let (x818, x819) = fiat_p384_mulx_u32(x6, (arg1[6]));
    let (x820, x821) = fiat_p384_mulx_u32(x6, (arg1[5]));
    let (x822, x823) = fiat_p384_mulx_u32(x6, (arg1[4]));
    let (x824, x825) = fiat_p384_mulx_u32(x6, (arg1[3]));
    let (x826, x827) = fiat_p384_mulx_u32(x6, (arg1[2]));
    let (x828, x829) = fiat_p384_mulx_u32(x6, (arg1[1]));
    let (x830, x831) = fiat_p384_mulx_u32(x6, (arg1[0]));
    let (x832, x833) = fiat_p384_addcarryx_u32(0x0, x831, x828);
    let (x834, x835) = fiat_p384_addcarryx_u32(x833, x829, x826);
    let (x836, x837) = fiat_p384_addcarryx_u32(x835, x827, x824);
    let (x838, x839) = fiat_p384_addcarryx_u32(x837, x825, x822);
    let (x840, x841) = fiat_p384_addcarryx_u32(x839, x823, x820);
    let (x842, x843) = fiat_p384_addcarryx_u32(x841, x821, x818);
    let (x844, x845) = fiat_p384_addcarryx_u32(x843, x819, x816);
    let (x846, x847) = fiat_p384_addcarryx_u32(x845, x817, x814);
    let (x848, x849) = fiat_p384_addcarryx_u32(x847, x815, x812);
    let (x850, x851) = fiat_p384_addcarryx_u32(x849, x813, x810);
    let (x852, x853) = fiat_p384_addcarryx_u32(x851, x811, x808);
    let x854: u32 = ((x853 as u32) + x809);
    let (x855, x856) = fiat_p384_addcarryx_u32(0x0, x783, x830);
    let (x857, x858) = fiat_p384_addcarryx_u32(x856, x785, x832);
    let (x859, x860) = fiat_p384_addcarryx_u32(x858, x787, x834);
    let (x861, x862) = fiat_p384_addcarryx_u32(x860, x789, x836);
    let (x863, x864) = fiat_p384_addcarryx_u32(x862, x791, x838);
    let (x865, x866) = fiat_p384_addcarryx_u32(x864, x793, x840);
    let (x867, x868) = fiat_p384_addcarryx_u32(x866, x795, x842);
    let (x869, x870) = fiat_p384_addcarryx_u32(x868, x797, x844);
    let (x871, x872) = fiat_p384_addcarryx_u32(x870, x799, x846);
    let (x873, x874) = fiat_p384_addcarryx_u32(x872, x801, x848);
    let (x875, x876) = fiat_p384_addcarryx_u32(x874, x803, x850);
    let (x877, x878) = fiat_p384_addcarryx_u32(x876, x805, x852);
    let (x879, x880) = fiat_p384_addcarryx_u32(x878, x807, x854);
    let (x881, x882) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x883, x884) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x885, x886) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x887, x888) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x889, x890) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x891, x892) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x893, x894) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x895, x896) = fiat_p384_mulx_u32(x855, 0xfffffffe);
    let (x897, x898) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x899, x900) = fiat_p384_mulx_u32(x855, 0xffffffff);
    let (x901, x902) = fiat_p384_addcarryx_u32(0x0, x898, x895);
    let (x903, x904) = fiat_p384_addcarryx_u32(x902, x896, x893);
    let (x905, x906) = fiat_p384_addcarryx_u32(x904, x894, x891);
    let (x907, x908) = fiat_p384_addcarryx_u32(x906, x892, x889);
    let (x909, x910) = fiat_p384_addcarryx_u32(x908, x890, x887);
    let (x911, x912) = fiat_p384_addcarryx_u32(x910, x888, x885);
    let (x913, x914) = fiat_p384_addcarryx_u32(x912, x886, x883);
    let (x915, x916) = fiat_p384_addcarryx_u32(x914, x884, x881);
    let x917: u32 = ((x916 as u32) + x882);
    let (x918, x919) = fiat_p384_addcarryx_u32(0x0, x855, x899);
    let (x920, x921) = fiat_p384_addcarryx_u32(x919, x857, x900);
    let (x922, x923) = fiat_p384_addcarryx_u32(x921, x859, (0x0 as u32));
    let (x924, x925) = fiat_p384_addcarryx_u32(x923, x861, x897);
    let (x926, x927) = fiat_p384_addcarryx_u32(x925, x863, x901);
    let (x928, x929) = fiat_p384_addcarryx_u32(x927, x865, x903);
    let (x930, x931) = fiat_p384_addcarryx_u32(x929, x867, x905);
    let (x932, x933) = fiat_p384_addcarryx_u32(x931, x869, x907);
    let (x934, x935) = fiat_p384_addcarryx_u32(x933, x871, x909);
    let (x936, x937) = fiat_p384_addcarryx_u32(x935, x873, x911);
    let (x938, x939) = fiat_p384_addcarryx_u32(x937, x875, x913);
    let (x940, x941) = fiat_p384_addcarryx_u32(x939, x877, x915);
    let (x942, x943) = fiat_p384_addcarryx_u32(x941, x879, x917);
    let x944: u32 = ((x943 as u32) + (x880 as u32));
    let (x945, x946) = fiat_p384_mulx_u32(x7, (arg1[11]));
    let (x947, x948) = fiat_p384_mulx_u32(x7, (arg1[10]));
    let (x949, x950) = fiat_p384_mulx_u32(x7, (arg1[9]));
    let (x951, x952) = fiat_p384_mulx_u32(x7, (arg1[8]));
    let (x953, x954) = fiat_p384_mulx_u32(x7, (arg1[7]));
    let (x955, x956) = fiat_p384_mulx_u32(x7, (arg1[6]));
    let (x957, x958) = fiat_p384_mulx_u32(x7, (arg1[5]));
    let (x959, x960) = fiat_p384_mulx_u32(x7, (arg1[4]));
    let (x961, x962) = fiat_p384_mulx_u32(x7, (arg1[3]));
    let (x963, x964) = fiat_p384_mulx_u32(x7, (arg1[2]));
    let (x965, x966) = fiat_p384_mulx_u32(x7, (arg1[1]));
    let (x967, x968) = fiat_p384_mulx_u32(x7, (arg1[0]));
    let (x969, x970) = fiat_p384_addcarryx_u32(0x0, x968, x965);
    let (x971, x972) = fiat_p384_addcarryx_u32(x970, x966, x963);
    let (x973, x974) = fiat_p384_addcarryx_u32(x972, x964, x961);
    let (x975, x976) = fiat_p384_addcarryx_u32(x974, x962, x959);
    let (x977, x978) = fiat_p384_addcarryx_u32(x976, x960, x957);
    let (x979, x980) = fiat_p384_addcarryx_u32(x978, x958, x955);
    let (x981, x982) = fiat_p384_addcarryx_u32(x980, x956, x953);
    let (x983, x984) = fiat_p384_addcarryx_u32(x982, x954, x951);
    let (x985, x986) = fiat_p384_addcarryx_u32(x984, x952, x949);
    let (x987, x988) = fiat_p384_addcarryx_u32(x986, x950, x947);
    let (x989, x990) = fiat_p384_addcarryx_u32(x988, x948, x945);
    let x991: u32 = ((x990 as u32) + x946);
    let (x992, x993) = fiat_p384_addcarryx_u32(0x0, x920, x967);
    let (x994, x995) = fiat_p384_addcarryx_u32(x993, x922, x969);
    let (x996, x997) = fiat_p384_addcarryx_u32(x995, x924, x971);
    let (x998, x999) = fiat_p384_addcarryx_u32(x997, x926, x973);
    let (x1000, x1001) = fiat_p384_addcarryx_u32(x999, x928, x975);
    let (x1002, x1003) = fiat_p384_addcarryx_u32(x1001, x930, x977);
    let (x1004, x1005) = fiat_p384_addcarryx_u32(x1003, x932, x979);
    let (x1006, x1007) = fiat_p384_addcarryx_u32(x1005, x934, x981);
    let (x1008, x1009) = fiat_p384_addcarryx_u32(x1007, x936, x983);
    let (x1010, x1011) = fiat_p384_addcarryx_u32(x1009, x938, x985);
    let (x1012, x1013) = fiat_p384_addcarryx_u32(x1011, x940, x987);
    let (x1014, x1015) = fiat_p384_addcarryx_u32(x1013, x942, x989);
    let (x1016, x1017) = fiat_p384_addcarryx_u32(x1015, x944, x991);
    let (x1018, x1019) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1020, x1021) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1022, x1023) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1024, x1025) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1026, x1027) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1028, x1029) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1030, x1031) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1032, x1033) = fiat_p384_mulx_u32(x992, 0xfffffffe);
    let (x1034, x1035) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1036, x1037) = fiat_p384_mulx_u32(x992, 0xffffffff);
    let (x1038, x1039) = fiat_p384_addcarryx_u32(0x0, x1035, x1032);
    let (x1040, x1041) = fiat_p384_addcarryx_u32(x1039, x1033, x1030);
    let (x1042, x1043) = fiat_p384_addcarryx_u32(x1041, x1031, x1028);
    let (x1044, x1045) = fiat_p384_addcarryx_u32(x1043, x1029, x1026);
    let (x1046, x1047) = fiat_p384_addcarryx_u32(x1045, x1027, x1024);
    let (x1048, x1049) = fiat_p384_addcarryx_u32(x1047, x1025, x1022);
    let (x1050, x1051) = fiat_p384_addcarryx_u32(x1049, x1023, x1020);
    let (x1052, x1053) = fiat_p384_addcarryx_u32(x1051, x1021, x1018);
    let x1054: u32 = ((x1053 as u32) + x1019);
    let (x1055, x1056) = fiat_p384_addcarryx_u32(0x0, x992, x1036);
    let (x1057, x1058) = fiat_p384_addcarryx_u32(x1056, x994, x1037);
    let (x1059, x1060) = fiat_p384_addcarryx_u32(x1058, x996, (0x0 as u32));
    let (x1061, x1062) = fiat_p384_addcarryx_u32(x1060, x998, x1034);
    let (x1063, x1064) = fiat_p384_addcarryx_u32(x1062, x1000, x1038);
    let (x1065, x1066) = fiat_p384_addcarryx_u32(x1064, x1002, x1040);
    let (x1067, x1068) = fiat_p384_addcarryx_u32(x1066, x1004, x1042);
    let (x1069, x1070) = fiat_p384_addcarryx_u32(x1068, x1006, x1044);
    let (x1071, x1072) = fiat_p384_addcarryx_u32(x1070, x1008, x1046);
    let (x1073, x1074) = fiat_p384_addcarryx_u32(x1072, x1010, x1048);
    let (x1075, x1076) = fiat_p384_addcarryx_u32(x1074, x1012, x1050);
    let (x1077, x1078) = fiat_p384_addcarryx_u32(x1076, x1014, x1052);
    let (x1079, x1080) = fiat_p384_addcarryx_u32(x1078, x1016, x1054);
    let x1081: u32 = ((x1080 as u32) + (x1017 as u32));
    let (x1082, x1083) = fiat_p384_mulx_u32(x8, (arg1[11]));
    let (x1084, x1085) = fiat_p384_mulx_u32(x8, (arg1[10]));
    let (x1086, x1087) = fiat_p384_mulx_u32(x8, (arg1[9]));
    let (x1088, x1089) = fiat_p384_mulx_u32(x8, (arg1[8]));
    let (x1090, x1091) = fiat_p384_mulx_u32(x8, (arg1[7]));
    let (x1092, x1093) = fiat_p384_mulx_u32(x8, (arg1[6]));
    let (x1094, x1095) = fiat_p384_mulx_u32(x8, (arg1[5]));
    let (x1096, x1097) = fiat_p384_mulx_u32(x8, (arg1[4]));
    let (x1098, x1099) = fiat_p384_mulx_u32(x8, (arg1[3]));
    let (x1100, x1101) = fiat_p384_mulx_u32(x8, (arg1[2]));
    let (x1102, x1103) = fiat_p384_mulx_u32(x8, (arg1[1]));
    let (x1104, x1105) = fiat_p384_mulx_u32(x8, (arg1[0]));
    let (x1106, x1107) = fiat_p384_addcarryx_u32(0x0, x1105, x1102);
    let (x1108, x1109) = fiat_p384_addcarryx_u32(x1107, x1103, x1100);
    let (x1110, x1111) = fiat_p384_addcarryx_u32(x1109, x1101, x1098);
    let (x1112, x1113) = fiat_p384_addcarryx_u32(x1111, x1099, x1096);
    let (x1114, x1115) = fiat_p384_addcarryx_u32(x1113, x1097, x1094);
    let (x1116, x1117) = fiat_p384_addcarryx_u32(x1115, x1095, x1092);
    let (x1118, x1119) = fiat_p384_addcarryx_u32(x1117, x1093, x1090);
    let (x1120, x1121) = fiat_p384_addcarryx_u32(x1119, x1091, x1088);
    let (x1122, x1123) = fiat_p384_addcarryx_u32(x1121, x1089, x1086);
    let (x1124, x1125) = fiat_p384_addcarryx_u32(x1123, x1087, x1084);
    let (x1126, x1127) = fiat_p384_addcarryx_u32(x1125, x1085, x1082);
    let x1128: u32 = ((x1127 as u32) + x1083);
    let (x1129, x1130) = fiat_p384_addcarryx_u32(0x0, x1057, x1104);
    let (x1131, x1132) = fiat_p384_addcarryx_u32(x1130, x1059, x1106);
    let (x1133, x1134) = fiat_p384_addcarryx_u32(x1132, x1061, x1108);
    let (x1135, x1136) = fiat_p384_addcarryx_u32(x1134, x1063, x1110);
    let (x1137, x1138) = fiat_p384_addcarryx_u32(x1136, x1065, x1112);
    let (x1139, x1140) = fiat_p384_addcarryx_u32(x1138, x1067, x1114);
    let (x1141, x1142) = fiat_p384_addcarryx_u32(x1140, x1069, x1116);
    let (x1143, x1144) = fiat_p384_addcarryx_u32(x1142, x1071, x1118);
    let (x1145, x1146) = fiat_p384_addcarryx_u32(x1144, x1073, x1120);
    let (x1147, x1148) = fiat_p384_addcarryx_u32(x1146, x1075, x1122);
    let (x1149, x1150) = fiat_p384_addcarryx_u32(x1148, x1077, x1124);
    let (x1151, x1152) = fiat_p384_addcarryx_u32(x1150, x1079, x1126);
    let (x1153, x1154) = fiat_p384_addcarryx_u32(x1152, x1081, x1128);
    let (x1155, x1156) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1157, x1158) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1159, x1160) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1161, x1162) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1163, x1164) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1165, x1166) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1167, x1168) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1169, x1170) = fiat_p384_mulx_u32(x1129, 0xfffffffe);
    let (x1171, x1172) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1173, x1174) = fiat_p384_mulx_u32(x1129, 0xffffffff);
    let (x1175, x1176) = fiat_p384_addcarryx_u32(0x0, x1172, x1169);
    let (x1177, x1178) = fiat_p384_addcarryx_u32(x1176, x1170, x1167);
    let (x1179, x1180) = fiat_p384_addcarryx_u32(x1178, x1168, x1165);
    let (x1181, x1182) = fiat_p384_addcarryx_u32(x1180, x1166, x1163);
    let (x1183, x1184) = fiat_p384_addcarryx_u32(x1182, x1164, x1161);
    let (x1185, x1186) = fiat_p384_addcarryx_u32(x1184, x1162, x1159);
    let (x1187, x1188) = fiat_p384_addcarryx_u32(x1186, x1160, x1157);
    let (x1189, x1190) = fiat_p384_addcarryx_u32(x1188, x1158, x1155);
    let x1191: u32 = ((x1190 as u32) + x1156);
    let (x1192, x1193) = fiat_p384_addcarryx_u32(0x0, x1129, x1173);
    let (x1194, x1195) = fiat_p384_addcarryx_u32(x1193, x1131, x1174);
    let (x1196, x1197) = fiat_p384_addcarryx_u32(x1195, x1133, (0x0 as u32));
    let (x1198, x1199) = fiat_p384_addcarryx_u32(x1197, x1135, x1171);
    let (x1200, x1201) = fiat_p384_addcarryx_u32(x1199, x1137, x1175);
    let (x1202, x1203) = fiat_p384_addcarryx_u32(x1201, x1139, x1177);
    let (x1204, x1205) = fiat_p384_addcarryx_u32(x1203, x1141, x1179);
    let (x1206, x1207) = fiat_p384_addcarryx_u32(x1205, x1143, x1181);
    let (x1208, x1209) = fiat_p384_addcarryx_u32(x1207, x1145, x1183);
    let (x1210, x1211) = fiat_p384_addcarryx_u32(x1209, x1147, x1185);
    let (x1212, x1213) = fiat_p384_addcarryx_u32(x1211, x1149, x1187);
    let (x1214, x1215) = fiat_p384_addcarryx_u32(x1213, x1151, x1189);
    let (x1216, x1217) = fiat_p384_addcarryx_u32(x1215, x1153, x1191);
    let x1218: u32 = ((x1217 as u32) + (x1154 as u32));
    let (x1219, x1220) = fiat_p384_mulx_u32(x9, (arg1[11]));
    let (x1221, x1222) = fiat_p384_mulx_u32(x9, (arg1[10]));
    let (x1223, x1224) = fiat_p384_mulx_u32(x9, (arg1[9]));
    let (x1225, x1226) = fiat_p384_mulx_u32(x9, (arg1[8]));
    let (x1227, x1228) = fiat_p384_mulx_u32(x9, (arg1[7]));
    let (x1229, x1230) = fiat_p384_mulx_u32(x9, (arg1[6]));
    let (x1231, x1232) = fiat_p384_mulx_u32(x9, (arg1[5]));
    let (x1233, x1234) = fiat_p384_mulx_u32(x9, (arg1[4]));
    let (x1235, x1236) = fiat_p384_mulx_u32(x9, (arg1[3]));
    let (x1237, x1238) = fiat_p384_mulx_u32(x9, (arg1[2]));
    let (x1239, x1240) = fiat_p384_mulx_u32(x9, (arg1[1]));
    let (x1241, x1242) = fiat_p384_mulx_u32(x9, (arg1[0]));
    let (x1243, x1244) = fiat_p384_addcarryx_u32(0x0, x1242, x1239);
    let (x1245, x1246) = fiat_p384_addcarryx_u32(x1244, x1240, x1237);
    let (x1247, x1248) = fiat_p384_addcarryx_u32(x1246, x1238, x1235);
    let (x1249, x1250) = fiat_p384_addcarryx_u32(x1248, x1236, x1233);
    let (x1251, x1252) = fiat_p384_addcarryx_u32(x1250, x1234, x1231);
    let (x1253, x1254) = fiat_p384_addcarryx_u32(x1252, x1232, x1229);
    let (x1255, x1256) = fiat_p384_addcarryx_u32(x1254, x1230, x1227);
    let (x1257, x1258) = fiat_p384_addcarryx_u32(x1256, x1228, x1225);
    let (x1259, x1260) = fiat_p384_addcarryx_u32(x1258, x1226, x1223);
    let (x1261, x1262) = fiat_p384_addcarryx_u32(x1260, x1224, x1221);
    let (x1263, x1264) = fiat_p384_addcarryx_u32(x1262, x1222, x1219);
    let x1265: u32 = ((x1264 as u32) + x1220);
    let (x1266, x1267) = fiat_p384_addcarryx_u32(0x0, x1194, x1241);
    let (x1268, x1269) = fiat_p384_addcarryx_u32(x1267, x1196, x1243);
    let (x1270, x1271) = fiat_p384_addcarryx_u32(x1269, x1198, x1245);
    let (x1272, x1273) = fiat_p384_addcarryx_u32(x1271, x1200, x1247);
    let (x1274, x1275) = fiat_p384_addcarryx_u32(x1273, x1202, x1249);
    let (x1276, x1277) = fiat_p384_addcarryx_u32(x1275, x1204, x1251);
    let (x1278, x1279) = fiat_p384_addcarryx_u32(x1277, x1206, x1253);
    let (x1280, x1281) = fiat_p384_addcarryx_u32(x1279, x1208, x1255);
    let (x1282, x1283) = fiat_p384_addcarryx_u32(x1281, x1210, x1257);
    let (x1284, x1285) = fiat_p384_addcarryx_u32(x1283, x1212, x1259);
    let (x1286, x1287) = fiat_p384_addcarryx_u32(x1285, x1214, x1261);
    let (x1288, x1289) = fiat_p384_addcarryx_u32(x1287, x1216, x1263);
    let (x1290, x1291) = fiat_p384_addcarryx_u32(x1289, x1218, x1265);
    let (x1292, x1293) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1294, x1295) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1296, x1297) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1298, x1299) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1300, x1301) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1302, x1303) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1304, x1305) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1306, x1307) = fiat_p384_mulx_u32(x1266, 0xfffffffe);
    let (x1308, x1309) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1310, x1311) = fiat_p384_mulx_u32(x1266, 0xffffffff);
    let (x1312, x1313) = fiat_p384_addcarryx_u32(0x0, x1309, x1306);
    let (x1314, x1315) = fiat_p384_addcarryx_u32(x1313, x1307, x1304);
    let (x1316, x1317) = fiat_p384_addcarryx_u32(x1315, x1305, x1302);
    let (x1318, x1319) = fiat_p384_addcarryx_u32(x1317, x1303, x1300);
    let (x1320, x1321) = fiat_p384_addcarryx_u32(x1319, x1301, x1298);
    let (x1322, x1323) = fiat_p384_addcarryx_u32(x1321, x1299, x1296);
    let (x1324, x1325) = fiat_p384_addcarryx_u32(x1323, x1297, x1294);
    let (x1326, x1327) = fiat_p384_addcarryx_u32(x1325, x1295, x1292);
    let x1328: u32 = ((x1327 as u32) + x1293);
    let (x1329, x1330) = fiat_p384_addcarryx_u32(0x0, x1266, x1310);
    let (x1331, x1332) = fiat_p384_addcarryx_u32(x1330, x1268, x1311);
    let (x1333, x1334) = fiat_p384_addcarryx_u32(x1332, x1270, (0x0 as u32));
    let (x1335, x1336) = fiat_p384_addcarryx_u32(x1334, x1272, x1308);
    let (x1337, x1338) = fiat_p384_addcarryx_u32(x1336, x1274, x1312);
    let (x1339, x1340) = fiat_p384_addcarryx_u32(x1338, x1276, x1314);
    let (x1341, x1342) = fiat_p384_addcarryx_u32(x1340, x1278, x1316);
    let (x1343, x1344) = fiat_p384_addcarryx_u32(x1342, x1280, x1318);
    let (x1345, x1346) = fiat_p384_addcarryx_u32(x1344, x1282, x1320);
    let (x1347, x1348) = fiat_p384_addcarryx_u32(x1346, x1284, x1322);
    let (x1349, x1350) = fiat_p384_addcarryx_u32(x1348, x1286, x1324);
    let (x1351, x1352) = fiat_p384_addcarryx_u32(x1350, x1288, x1326);
    let (x1353, x1354) = fiat_p384_addcarryx_u32(x1352, x1290, x1328);
    let x1355: u32 = ((x1354 as u32) + (x1291 as u32));
    let (x1356, x1357) = fiat_p384_mulx_u32(x10, (arg1[11]));
    let (x1358, x1359) = fiat_p384_mulx_u32(x10, (arg1[10]));
    let (x1360, x1361) = fiat_p384_mulx_u32(x10, (arg1[9]));
    let (x1362, x1363) = fiat_p384_mulx_u32(x10, (arg1[8]));
    let (x1364, x1365) = fiat_p384_mulx_u32(x10, (arg1[7]));
    let (x1366, x1367) = fiat_p384_mulx_u32(x10, (arg1[6]));
    let (x1368, x1369) = fiat_p384_mulx_u32(x10, (arg1[5]));
    let (x1370, x1371) = fiat_p384_mulx_u32(x10, (arg1[4]));
    let (x1372, x1373) = fiat_p384_mulx_u32(x10, (arg1[3]));
    let (x1374, x1375) = fiat_p384_mulx_u32(x10, (arg1[2]));
    let (x1376, x1377) = fiat_p384_mulx_u32(x10, (arg1[1]));
    let (x1378, x1379) = fiat_p384_mulx_u32(x10, (arg1[0]));
    let (x1380, x1381) = fiat_p384_addcarryx_u32(0x0, x1379, x1376);
    let (x1382, x1383) = fiat_p384_addcarryx_u32(x1381, x1377, x1374);
    let (x1384, x1385) = fiat_p384_addcarryx_u32(x1383, x1375, x1372);
    let (x1386, x1387) = fiat_p384_addcarryx_u32(x1385, x1373, x1370);
    let (x1388, x1389) = fiat_p384_addcarryx_u32(x1387, x1371, x1368);
    let (x1390, x1391) = fiat_p384_addcarryx_u32(x1389, x1369, x1366);
    let (x1392, x1393) = fiat_p384_addcarryx_u32(x1391, x1367, x1364);
    let (x1394, x1395) = fiat_p384_addcarryx_u32(x1393, x1365, x1362);
    let (x1396, x1397) = fiat_p384_addcarryx_u32(x1395, x1363, x1360);
    let (x1398, x1399) = fiat_p384_addcarryx_u32(x1397, x1361, x1358);
    let (x1400, x1401) = fiat_p384_addcarryx_u32(x1399, x1359, x1356);
    let x1402: u32 = ((x1401 as u32) + x1357);
    let (x1403, x1404) = fiat_p384_addcarryx_u32(0x0, x1331, x1378);
    let (x1405, x1406) = fiat_p384_addcarryx_u32(x1404, x1333, x1380);
    let (x1407, x1408) = fiat_p384_addcarryx_u32(x1406, x1335, x1382);
    let (x1409, x1410) = fiat_p384_addcarryx_u32(x1408, x1337, x1384);
    let (x1411, x1412) = fiat_p384_addcarryx_u32(x1410, x1339, x1386);
    let (x1413, x1414) = fiat_p384_addcarryx_u32(x1412, x1341, x1388);
    let (x1415, x1416) = fiat_p384_addcarryx_u32(x1414, x1343, x1390);
    let (x1417, x1418) = fiat_p384_addcarryx_u32(x1416, x1345, x1392);
    let (x1419, x1420) = fiat_p384_addcarryx_u32(x1418, x1347, x1394);
    let (x1421, x1422) = fiat_p384_addcarryx_u32(x1420, x1349, x1396);
    let (x1423, x1424) = fiat_p384_addcarryx_u32(x1422, x1351, x1398);
    let (x1425, x1426) = fiat_p384_addcarryx_u32(x1424, x1353, x1400);
    let (x1427, x1428) = fiat_p384_addcarryx_u32(x1426, x1355, x1402);
    let (x1429, x1430) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1431, x1432) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1433, x1434) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1435, x1436) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1437, x1438) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1439, x1440) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1441, x1442) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1443, x1444) = fiat_p384_mulx_u32(x1403, 0xfffffffe);
    let (x1445, x1446) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1447, x1448) = fiat_p384_mulx_u32(x1403, 0xffffffff);
    let (x1449, x1450) = fiat_p384_addcarryx_u32(0x0, x1446, x1443);
    let (x1451, x1452) = fiat_p384_addcarryx_u32(x1450, x1444, x1441);
    let (x1453, x1454) = fiat_p384_addcarryx_u32(x1452, x1442, x1439);
    let (x1455, x1456) = fiat_p384_addcarryx_u32(x1454, x1440, x1437);
    let (x1457, x1458) = fiat_p384_addcarryx_u32(x1456, x1438, x1435);
    let (x1459, x1460) = fiat_p384_addcarryx_u32(x1458, x1436, x1433);
    let (x1461, x1462) = fiat_p384_addcarryx_u32(x1460, x1434, x1431);
    let (x1463, x1464) = fiat_p384_addcarryx_u32(x1462, x1432, x1429);
    let x1465: u32 = ((x1464 as u32) + x1430);
    let (x1466, x1467) = fiat_p384_addcarryx_u32(0x0, x1403, x1447);
    let (x1468, x1469) = fiat_p384_addcarryx_u32(x1467, x1405, x1448);
    let (x1470, x1471) = fiat_p384_addcarryx_u32(x1469, x1407, (0x0 as u32));
    let (x1472, x1473) = fiat_p384_addcarryx_u32(x1471, x1409, x1445);
    let (x1474, x1475) = fiat_p384_addcarryx_u32(x1473, x1411, x1449);
    let (x1476, x1477) = fiat_p384_addcarryx_u32(x1475, x1413, x1451);
    let (x1478, x1479) = fiat_p384_addcarryx_u32(x1477, x1415, x1453);
    let (x1480, x1481) = fiat_p384_addcarryx_u32(x1479, x1417, x1455);
    let (x1482, x1483) = fiat_p384_addcarryx_u32(x1481, x1419, x1457);
    let (x1484, x1485) = fiat_p384_addcarryx_u32(x1483, x1421, x1459);
    let (x1486, x1487) = fiat_p384_addcarryx_u32(x1485, x1423, x1461);
    let (x1488, x1489) = fiat_p384_addcarryx_u32(x1487, x1425, x1463);
    let (x1490, x1491) = fiat_p384_addcarryx_u32(x1489, x1427, x1465);
    let x1492: u32 = ((x1491 as u32) + (x1428 as u32));
    let (x1493, x1494) = fiat_p384_mulx_u32(x11, (arg1[11]));
    let (x1495, x1496) = fiat_p384_mulx_u32(x11, (arg1[10]));
    let (x1497, x1498) = fiat_p384_mulx_u32(x11, (arg1[9]));
    let (x1499, x1500) = fiat_p384_mulx_u32(x11, (arg1[8]));
    let (x1501, x1502) = fiat_p384_mulx_u32(x11, (arg1[7]));
    let (x1503, x1504) = fiat_p384_mulx_u32(x11, (arg1[6]));
    let (x1505, x1506) = fiat_p384_mulx_u32(x11, (arg1[5]));
    let (x1507, x1508) = fiat_p384_mulx_u32(x11, (arg1[4]));
    let (x1509, x1510) = fiat_p384_mulx_u32(x11, (arg1[3]));
    let (x1511, x1512) = fiat_p384_mulx_u32(x11, (arg1[2]));
    let (x1513, x1514) = fiat_p384_mulx_u32(x11, (arg1[1]));
    let (x1515, x1516) = fiat_p384_mulx_u32(x11, (arg1[0]));
    let (x1517, x1518) = fiat_p384_addcarryx_u32(0x0, x1516, x1513);
    let (x1519, x1520) = fiat_p384_addcarryx_u32(x1518, x1514, x1511);
    let (x1521, x1522) = fiat_p384_addcarryx_u32(x1520, x1512, x1509);
    let (x1523, x1524) = fiat_p384_addcarryx_u32(x1522, x1510, x1507);
    let (x1525, x1526) = fiat_p384_addcarryx_u32(x1524, x1508, x1505);
    let (x1527, x1528) = fiat_p384_addcarryx_u32(x1526, x1506, x1503);
    let (x1529, x1530) = fiat_p384_addcarryx_u32(x1528, x1504, x1501);
    let (x1531, x1532) = fiat_p384_addcarryx_u32(x1530, x1502, x1499);
    let (x1533, x1534) = fiat_p384_addcarryx_u32(x1532, x1500, x1497);
    let (x1535, x1536) = fiat_p384_addcarryx_u32(x1534, x1498, x1495);
    let (x1537, x1538) = fiat_p384_addcarryx_u32(x1536, x1496, x1493);
    let x1539: u32 = ((x1538 as u32) + x1494);
    let (x1540, x1541) = fiat_p384_addcarryx_u32(0x0, x1468, x1515);
    let (x1542, x1543) = fiat_p384_addcarryx_u32(x1541, x1470, x1517);
    let (x1544, x1545) = fiat_p384_addcarryx_u32(x1543, x1472, x1519);
    let (x1546, x1547) = fiat_p384_addcarryx_u32(x1545, x1474, x1521);
    let (x1548, x1549) = fiat_p384_addcarryx_u32(x1547, x1476, x1523);
    let (x1550, x1551) = fiat_p384_addcarryx_u32(x1549, x1478, x1525);
    let (x1552, x1553) = fiat_p384_addcarryx_u32(x1551, x1480, x1527);
    let (x1554, x1555) = fiat_p384_addcarryx_u32(x1553, x1482, x1529);
    let (x1556, x1557) = fiat_p384_addcarryx_u32(x1555, x1484, x1531);
    let (x1558, x1559) = fiat_p384_addcarryx_u32(x1557, x1486, x1533);
    let (x1560, x1561) = fiat_p384_addcarryx_u32(x1559, x1488, x1535);
    let (x1562, x1563) = fiat_p384_addcarryx_u32(x1561, x1490, x1537);
    let (x1564, x1565) = fiat_p384_addcarryx_u32(x1563, x1492, x1539);
    let (x1566, x1567) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1568, x1569) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1570, x1571) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1572, x1573) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1574, x1575) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1576, x1577) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1578, x1579) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1580, x1581) = fiat_p384_mulx_u32(x1540, 0xfffffffe);
    let (x1582, x1583) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1584, x1585) = fiat_p384_mulx_u32(x1540, 0xffffffff);
    let (x1586, x1587) = fiat_p384_addcarryx_u32(0x0, x1583, x1580);
    let (x1588, x1589) = fiat_p384_addcarryx_u32(x1587, x1581, x1578);
    let (x1590, x1591) = fiat_p384_addcarryx_u32(x1589, x1579, x1576);
    let (x1592, x1593) = fiat_p384_addcarryx_u32(x1591, x1577, x1574);
    let (x1594, x1595) = fiat_p384_addcarryx_u32(x1593, x1575, x1572);
    let (x1596, x1597) = fiat_p384_addcarryx_u32(x1595, x1573, x1570);
    let (x1598, x1599) = fiat_p384_addcarryx_u32(x1597, x1571, x1568);
    let (x1600, x1601) = fiat_p384_addcarryx_u32(x1599, x1569, x1566);
    let x1602: u32 = ((x1601 as u32) + x1567);
    let (x1603, x1604) = fiat_p384_addcarryx_u32(0x0, x1540, x1584);
    let (x1605, x1606) = fiat_p384_addcarryx_u32(x1604, x1542, x1585);
    let (x1607, x1608) = fiat_p384_addcarryx_u32(x1606, x1544, (0x0 as u32));
    let (x1609, x1610) = fiat_p384_addcarryx_u32(x1608, x1546, x1582);
    let (x1611, x1612) = fiat_p384_addcarryx_u32(x1610, x1548, x1586);
    let (x1613, x1614) = fiat_p384_addcarryx_u32(x1612, x1550, x1588);
    let (x1615, x1616) = fiat_p384_addcarryx_u32(x1614, x1552, x1590);
    let (x1617, x1618) = fiat_p384_addcarryx_u32(x1616, x1554, x1592);
    let (x1619, x1620) = fiat_p384_addcarryx_u32(x1618, x1556, x1594);
    let (x1621, x1622) = fiat_p384_addcarryx_u32(x1620, x1558, x1596);
    let (x1623, x1624) = fiat_p384_addcarryx_u32(x1622, x1560, x1598);
    let (x1625, x1626) = fiat_p384_addcarryx_u32(x1624, x1562, x1600);
    let (x1627, x1628) = fiat_p384_addcarryx_u32(x1626, x1564, x1602);
    let x1629: u32 = ((x1628 as u32) + (x1565 as u32));
    let (x1630, x1631) = fiat_p384_subborrowx_u32(0x0, x1605, 0xffffffff);
    let (x1632, x1633) = fiat_p384_subborrowx_u32(x1631, x1607, (0x0 as u32));
    let (x1634, x1635) = fiat_p384_subborrowx_u32(x1633, x1609, (0x0 as u32));
    let (x1636, x1637) = fiat_p384_subborrowx_u32(x1635, x1611, 0xffffffff);
    let (x1638, x1639) = fiat_p384_subborrowx_u32(x1637, x1613, 0xfffffffe);
    let (x1640, x1641) = fiat_p384_subborrowx_u32(x1639, x1615, 0xffffffff);
    let (x1642, x1643) = fiat_p384_subborrowx_u32(x1641, x1617, 0xffffffff);
    let (x1644, x1645) = fiat_p384_subborrowx_u32(x1643, x1619, 0xffffffff);
    let (x1646, x1647) = fiat_p384_subborrowx_u32(x1645, x1621, 0xffffffff);
    let (x1648, x1649) = fiat_p384_subborrowx_u32(x1647, x1623, 0xffffffff);
    let (x1650, x1651) = fiat_p384_subborrowx_u32(x1649, x1625, 0xffffffff);
    let (x1652, x1653) = fiat_p384_subborrowx_u32(x1651, x1627, 0xffffffff);
    let (x1654, x1655) = fiat_p384_subborrowx_u32(x1653, x1629, (0x0 as u32));
    let (x1656) = fiat_p384_cmovznz_u32(x1655, x1630, x1605);
    let (x1657) = fiat_p384_cmovznz_u32(x1655, x1632, x1607);
    let (x1658) = fiat_p384_cmovznz_u32(x1655, x1634, x1609);
    let (x1659) = fiat_p384_cmovznz_u32(x1655, x1636, x1611);
    let (x1660) = fiat_p384_cmovznz_u32(x1655, x1638, x1613);
    let (x1661) = fiat_p384_cmovznz_u32(x1655, x1640, x1615);
    let (x1662) = fiat_p384_cmovznz_u32(x1655, x1642, x1617);
    let (x1663) = fiat_p384_cmovznz_u32(x1655, x1644, x1619);
    let (x1664) = fiat_p384_cmovznz_u32(x1655, x1646, x1621);
    let (x1665) = fiat_p384_cmovznz_u32(x1655, x1648, x1623);
    let (x1666) = fiat_p384_cmovznz_u32(x1655, x1650, x1625);
    let (x1667) = fiat_p384_cmovznz_u32(x1655, x1652, x1627);
    out1[0] = x1656;
    out1[1] = x1657;
    out1[2] = x1658;
    out1[3] = x1659;
    out1[4] = x1660;
    out1[5] = x1661;
    out1[6] = x1662;
    out1[7] = x1663;
    out1[8] = x1664;
    out1[9] = x1665;
    out1[10] = x1666;
    out1[11] = x1667;
    out1
}
#[doc = " The function fiat_p384_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_add(
    arg1: &fiat_p384_montgomery_domain_field_element,
    arg2: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    let (x1, x2) = fiat_p384_addcarryx_u32(0x0, (arg1[0]), (arg2[0]));
    let (x3, x4) = fiat_p384_addcarryx_u32(x2, (arg1[1]), (arg2[1]));
    let (x5, x6) = fiat_p384_addcarryx_u32(x4, (arg1[2]), (arg2[2]));
    let (x7, x8) = fiat_p384_addcarryx_u32(x6, (arg1[3]), (arg2[3]));
    let (x9, x10) = fiat_p384_addcarryx_u32(x8, (arg1[4]), (arg2[4]));
    let (x11, x12) = fiat_p384_addcarryx_u32(x10, (arg1[5]), (arg2[5]));
    let (x13, x14) = fiat_p384_addcarryx_u32(x12, (arg1[6]), (arg2[6]));
    let (x15, x16) = fiat_p384_addcarryx_u32(x14, (arg1[7]), (arg2[7]));
    let (x17, x18) = fiat_p384_addcarryx_u32(x16, (arg1[8]), (arg2[8]));
    let (x19, x20) = fiat_p384_addcarryx_u32(x18, (arg1[9]), (arg2[9]));
    let (x21, x22) = fiat_p384_addcarryx_u32(x20, (arg1[10]), (arg2[10]));
    let (x23, x24) = fiat_p384_addcarryx_u32(x22, (arg1[11]), (arg2[11]));
    let (x25, x26) = fiat_p384_subborrowx_u32(0x0, x1, 0xffffffff);
    let (x27, x28) = fiat_p384_subborrowx_u32(x26, x3, (0x0 as u32));
    let (x29, x30) = fiat_p384_subborrowx_u32(x28, x5, (0x0 as u32));
    let (x31, x32) = fiat_p384_subborrowx_u32(x30, x7, 0xffffffff);
    let (x33, x34) = fiat_p384_subborrowx_u32(x32, x9, 0xfffffffe);
    let (x35, x36) = fiat_p384_subborrowx_u32(x34, x11, 0xffffffff);
    let (x37, x38) = fiat_p384_subborrowx_u32(x36, x13, 0xffffffff);
    let (x39, x40) = fiat_p384_subborrowx_u32(x38, x15, 0xffffffff);
    let (x41, x42) = fiat_p384_subborrowx_u32(x40, x17, 0xffffffff);
    let (x43, x44) = fiat_p384_subborrowx_u32(x42, x19, 0xffffffff);
    let (x45, x46) = fiat_p384_subborrowx_u32(x44, x21, 0xffffffff);
    let (x47, x48) = fiat_p384_subborrowx_u32(x46, x23, 0xffffffff);
    let (x49, x50) = fiat_p384_subborrowx_u32(x48, (x24 as u32), (0x0 as u32));
    let (x51) = fiat_p384_cmovznz_u32(x50, x25, x1);
    let (x52) = fiat_p384_cmovznz_u32(x50, x27, x3);
    let (x53) = fiat_p384_cmovznz_u32(x50, x29, x5);
    let (x54) = fiat_p384_cmovznz_u32(x50, x31, x7);
    let (x55) = fiat_p384_cmovznz_u32(x50, x33, x9);
    let (x56) = fiat_p384_cmovznz_u32(x50, x35, x11);
    let (x57) = fiat_p384_cmovznz_u32(x50, x37, x13);
    let (x58) = fiat_p384_cmovznz_u32(x50, x39, x15);
    let (x59) = fiat_p384_cmovznz_u32(x50, x41, x17);
    let (x60) = fiat_p384_cmovznz_u32(x50, x43, x19);
    let (x61) = fiat_p384_cmovznz_u32(x50, x45, x21);
    let (x62) = fiat_p384_cmovznz_u32(x50, x47, x23);
    out1[0] = x51;
    out1[1] = x52;
    out1[2] = x53;
    out1[3] = x54;
    out1[4] = x55;
    out1[5] = x56;
    out1[6] = x57;
    out1[7] = x58;
    out1[8] = x59;
    out1[9] = x60;
    out1[10] = x61;
    out1[11] = x62;
    out1
}
#[doc = " The function fiat_p384_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_sub(
    arg1: &fiat_p384_montgomery_domain_field_element,
    arg2: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    let (x1, x2) = fiat_p384_subborrowx_u32(0x0, (arg1[0]), (arg2[0]));
    let (x3, x4) = fiat_p384_subborrowx_u32(x2, (arg1[1]), (arg2[1]));
    let (x5, x6) = fiat_p384_subborrowx_u32(x4, (arg1[2]), (arg2[2]));
    let (x7, x8) = fiat_p384_subborrowx_u32(x6, (arg1[3]), (arg2[3]));
    let (x9, x10) = fiat_p384_subborrowx_u32(x8, (arg1[4]), (arg2[4]));
    let (x11, x12) = fiat_p384_subborrowx_u32(x10, (arg1[5]), (arg2[5]));
    let (x13, x14) = fiat_p384_subborrowx_u32(x12, (arg1[6]), (arg2[6]));
    let (x15, x16) = fiat_p384_subborrowx_u32(x14, (arg1[7]), (arg2[7]));
    let (x17, x18) = fiat_p384_subborrowx_u32(x16, (arg1[8]), (arg2[8]));
    let (x19, x20) = fiat_p384_subborrowx_u32(x18, (arg1[9]), (arg2[9]));
    let (x21, x22) = fiat_p384_subborrowx_u32(x20, (arg1[10]), (arg2[10]));
    let (x23, x24) = fiat_p384_subborrowx_u32(x22, (arg1[11]), (arg2[11]));
    let (x25) = fiat_p384_cmovznz_u32(x24, (0x0 as u32), 0xffffffff);
    let (x26, x27) = fiat_p384_addcarryx_u32(0x0, x1, x25);
    let (x28, x29) = fiat_p384_addcarryx_u32(x27, x3, (0x0 as u32));
    let (x30, x31) = fiat_p384_addcarryx_u32(x29, x5, (0x0 as u32));
    let (x32, x33) = fiat_p384_addcarryx_u32(x31, x7, x25);
    let (x34, x35) = fiat_p384_addcarryx_u32(x33, x9, (x25 & 0xfffffffe));
    let (x36, x37) = fiat_p384_addcarryx_u32(x35, x11, x25);
    let (x38, x39) = fiat_p384_addcarryx_u32(x37, x13, x25);
    let (x40, x41) = fiat_p384_addcarryx_u32(x39, x15, x25);
    let (x42, x43) = fiat_p384_addcarryx_u32(x41, x17, x25);
    let (x44, x45) = fiat_p384_addcarryx_u32(x43, x19, x25);
    let (x46, x47) = fiat_p384_addcarryx_u32(x45, x21, x25);
    let (x48, x49) = fiat_p384_addcarryx_u32(x47, x23, x25);
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
    out1
}
#[doc = " The function fiat_p384_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_opp(
    arg1: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    let (x1, x2) = fiat_p384_subborrowx_u32(0x0, (0x0 as u32), (arg1[0]));
    let (x3, x4) = fiat_p384_subborrowx_u32(x2, (0x0 as u32), (arg1[1]));
    let (x5, x6) = fiat_p384_subborrowx_u32(x4, (0x0 as u32), (arg1[2]));
    let (x7, x8) = fiat_p384_subborrowx_u32(x6, (0x0 as u32), (arg1[3]));
    let (x9, x10) = fiat_p384_subborrowx_u32(x8, (0x0 as u32), (arg1[4]));
    let (x11, x12) = fiat_p384_subborrowx_u32(x10, (0x0 as u32), (arg1[5]));
    let (x13, x14) = fiat_p384_subborrowx_u32(x12, (0x0 as u32), (arg1[6]));
    let (x15, x16) = fiat_p384_subborrowx_u32(x14, (0x0 as u32), (arg1[7]));
    let (x17, x18) = fiat_p384_subborrowx_u32(x16, (0x0 as u32), (arg1[8]));
    let (x19, x20) = fiat_p384_subborrowx_u32(x18, (0x0 as u32), (arg1[9]));
    let (x21, x22) = fiat_p384_subborrowx_u32(x20, (0x0 as u32), (arg1[10]));
    let (x23, x24) = fiat_p384_subborrowx_u32(x22, (0x0 as u32), (arg1[11]));
    let (x25) = fiat_p384_cmovznz_u32(x24, (0x0 as u32), 0xffffffff);
    let (x26, x27) = fiat_p384_addcarryx_u32(0x0, x1, x25);
    let (x28, x29) = fiat_p384_addcarryx_u32(x27, x3, (0x0 as u32));
    let (x30, x31) = fiat_p384_addcarryx_u32(x29, x5, (0x0 as u32));
    let (x32, x33) = fiat_p384_addcarryx_u32(x31, x7, x25);
    let (x34, x35) = fiat_p384_addcarryx_u32(x33, x9, (x25 & 0xfffffffe));
    let (x36, x37) = fiat_p384_addcarryx_u32(x35, x11, x25);
    let (x38, x39) = fiat_p384_addcarryx_u32(x37, x13, x25);
    let (x40, x41) = fiat_p384_addcarryx_u32(x39, x15, x25);
    let (x42, x43) = fiat_p384_addcarryx_u32(x41, x17, x25);
    let (x44, x45) = fiat_p384_addcarryx_u32(x43, x19, x25);
    let (x46, x47) = fiat_p384_addcarryx_u32(x45, x21, x25);
    let (x48, x49) = fiat_p384_addcarryx_u32(x47, x23, x25);
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
    out1
}
#[doc = " The function fiat_p384_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_from_montgomery(
    arg1: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_non_montgomery_domain_field_element {
    let mut out1: fiat_p384_non_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[0]);
    let (x2, x3) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x4, x5) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x6, x7) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x8, x9) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x10, x11) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x12, x13) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x14, x15) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x16, x17) = fiat_p384_mulx_u32(x1, 0xfffffffe);
    let (x18, x19) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x20, x21) = fiat_p384_mulx_u32(x1, 0xffffffff);
    let (x22, x23) = fiat_p384_addcarryx_u32(0x0, x19, x16);
    let (x24, x25) = fiat_p384_addcarryx_u32(x23, x17, x14);
    let (x26, x27) = fiat_p384_addcarryx_u32(x25, x15, x12);
    let (x28, x29) = fiat_p384_addcarryx_u32(x27, x13, x10);
    let (x30, x31) = fiat_p384_addcarryx_u32(x29, x11, x8);
    let (x32, x33) = fiat_p384_addcarryx_u32(x31, x9, x6);
    let (x34, x35) = fiat_p384_addcarryx_u32(x33, x7, x4);
    let (x36, x37) = fiat_p384_addcarryx_u32(x35, x5, x2);
    let (x38, x39) = fiat_p384_addcarryx_u32(0x0, x1, x20);
    let (x40, x41) = fiat_p384_addcarryx_u32(0x0, ((x39 as u32) + x21), (arg1[1]));
    let (x42, x43) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x44, x45) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x46, x47) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x48, x49) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x50, x51) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x52, x53) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x54, x55) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x56, x57) = fiat_p384_mulx_u32(x40, 0xfffffffe);
    let (x58, x59) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x60, x61) = fiat_p384_mulx_u32(x40, 0xffffffff);
    let (x62, x63) = fiat_p384_addcarryx_u32(0x0, x59, x56);
    let (x64, x65) = fiat_p384_addcarryx_u32(x63, x57, x54);
    let (x66, x67) = fiat_p384_addcarryx_u32(x65, x55, x52);
    let (x68, x69) = fiat_p384_addcarryx_u32(x67, x53, x50);
    let (x70, x71) = fiat_p384_addcarryx_u32(x69, x51, x48);
    let (x72, x73) = fiat_p384_addcarryx_u32(x71, x49, x46);
    let (x74, x75) = fiat_p384_addcarryx_u32(x73, x47, x44);
    let (x76, x77) = fiat_p384_addcarryx_u32(x75, x45, x42);
    let (x78, x79) = fiat_p384_addcarryx_u32(0x0, x40, x60);
    let (x80, x81) = fiat_p384_addcarryx_u32(x79, (x41 as u32), x61);
    let (x82, x83) = fiat_p384_addcarryx_u32(x81, x18, (0x0 as u32));
    let (x84, x85) = fiat_p384_addcarryx_u32(x83, x22, x58);
    let (x86, x87) = fiat_p384_addcarryx_u32(x85, x24, x62);
    let (x88, x89) = fiat_p384_addcarryx_u32(x87, x26, x64);
    let (x90, x91) = fiat_p384_addcarryx_u32(x89, x28, x66);
    let (x92, x93) = fiat_p384_addcarryx_u32(x91, x30, x68);
    let (x94, x95) = fiat_p384_addcarryx_u32(x93, x32, x70);
    let (x96, x97) = fiat_p384_addcarryx_u32(x95, x34, x72);
    let (x98, x99) = fiat_p384_addcarryx_u32(x97, x36, x74);
    let (x100, x101) = fiat_p384_addcarryx_u32(x99, ((x37 as u32) + x3), x76);
    let (x102, x103) = fiat_p384_addcarryx_u32(x101, (0x0 as u32), ((x77 as u32) + x43));
    let (x104, x105) = fiat_p384_addcarryx_u32(0x0, x80, (arg1[2]));
    let (x106, x107) = fiat_p384_addcarryx_u32(x105, x82, (0x0 as u32));
    let (x108, x109) = fiat_p384_addcarryx_u32(x107, x84, (0x0 as u32));
    let (x110, x111) = fiat_p384_addcarryx_u32(x109, x86, (0x0 as u32));
    let (x112, x113) = fiat_p384_addcarryx_u32(x111, x88, (0x0 as u32));
    let (x114, x115) = fiat_p384_addcarryx_u32(x113, x90, (0x0 as u32));
    let (x116, x117) = fiat_p384_addcarryx_u32(x115, x92, (0x0 as u32));
    let (x118, x119) = fiat_p384_addcarryx_u32(x117, x94, (0x0 as u32));
    let (x120, x121) = fiat_p384_addcarryx_u32(x119, x96, (0x0 as u32));
    let (x122, x123) = fiat_p384_addcarryx_u32(x121, x98, (0x0 as u32));
    let (x124, x125) = fiat_p384_addcarryx_u32(x123, x100, (0x0 as u32));
    let (x126, x127) = fiat_p384_addcarryx_u32(x125, x102, (0x0 as u32));
    let (x128, x129) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x130, x131) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x132, x133) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x134, x135) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x136, x137) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x138, x139) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x140, x141) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x142, x143) = fiat_p384_mulx_u32(x104, 0xfffffffe);
    let (x144, x145) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x146, x147) = fiat_p384_mulx_u32(x104, 0xffffffff);
    let (x148, x149) = fiat_p384_addcarryx_u32(0x0, x145, x142);
    let (x150, x151) = fiat_p384_addcarryx_u32(x149, x143, x140);
    let (x152, x153) = fiat_p384_addcarryx_u32(x151, x141, x138);
    let (x154, x155) = fiat_p384_addcarryx_u32(x153, x139, x136);
    let (x156, x157) = fiat_p384_addcarryx_u32(x155, x137, x134);
    let (x158, x159) = fiat_p384_addcarryx_u32(x157, x135, x132);
    let (x160, x161) = fiat_p384_addcarryx_u32(x159, x133, x130);
    let (x162, x163) = fiat_p384_addcarryx_u32(x161, x131, x128);
    let (x164, x165) = fiat_p384_addcarryx_u32(0x0, x104, x146);
    let (x166, x167) = fiat_p384_addcarryx_u32(x165, x106, x147);
    let (x168, x169) = fiat_p384_addcarryx_u32(x167, x108, (0x0 as u32));
    let (x170, x171) = fiat_p384_addcarryx_u32(x169, x110, x144);
    let (x172, x173) = fiat_p384_addcarryx_u32(x171, x112, x148);
    let (x174, x175) = fiat_p384_addcarryx_u32(x173, x114, x150);
    let (x176, x177) = fiat_p384_addcarryx_u32(x175, x116, x152);
    let (x178, x179) = fiat_p384_addcarryx_u32(x177, x118, x154);
    let (x180, x181) = fiat_p384_addcarryx_u32(x179, x120, x156);
    let (x182, x183) = fiat_p384_addcarryx_u32(x181, x122, x158);
    let (x184, x185) = fiat_p384_addcarryx_u32(x183, x124, x160);
    let (x186, x187) = fiat_p384_addcarryx_u32(x185, x126, x162);
    let (x188, x189) = fiat_p384_addcarryx_u32(
        x187,
        ((x127 as u32) + (x103 as u32)),
        ((x163 as u32) + x129),
    );
    let (x190, x191) = fiat_p384_addcarryx_u32(0x0, x166, (arg1[3]));
    let (x192, x193) = fiat_p384_addcarryx_u32(x191, x168, (0x0 as u32));
    let (x194, x195) = fiat_p384_addcarryx_u32(x193, x170, (0x0 as u32));
    let (x196, x197) = fiat_p384_addcarryx_u32(x195, x172, (0x0 as u32));
    let (x198, x199) = fiat_p384_addcarryx_u32(x197, x174, (0x0 as u32));
    let (x200, x201) = fiat_p384_addcarryx_u32(x199, x176, (0x0 as u32));
    let (x202, x203) = fiat_p384_addcarryx_u32(x201, x178, (0x0 as u32));
    let (x204, x205) = fiat_p384_addcarryx_u32(x203, x180, (0x0 as u32));
    let (x206, x207) = fiat_p384_addcarryx_u32(x205, x182, (0x0 as u32));
    let (x208, x209) = fiat_p384_addcarryx_u32(x207, x184, (0x0 as u32));
    let (x210, x211) = fiat_p384_addcarryx_u32(x209, x186, (0x0 as u32));
    let (x212, x213) = fiat_p384_addcarryx_u32(x211, x188, (0x0 as u32));
    let (x214, x215) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x216, x217) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x218, x219) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x220, x221) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x222, x223) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x224, x225) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x226, x227) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x228, x229) = fiat_p384_mulx_u32(x190, 0xfffffffe);
    let (x230, x231) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x232, x233) = fiat_p384_mulx_u32(x190, 0xffffffff);
    let (x234, x235) = fiat_p384_addcarryx_u32(0x0, x231, x228);
    let (x236, x237) = fiat_p384_addcarryx_u32(x235, x229, x226);
    let (x238, x239) = fiat_p384_addcarryx_u32(x237, x227, x224);
    let (x240, x241) = fiat_p384_addcarryx_u32(x239, x225, x222);
    let (x242, x243) = fiat_p384_addcarryx_u32(x241, x223, x220);
    let (x244, x245) = fiat_p384_addcarryx_u32(x243, x221, x218);
    let (x246, x247) = fiat_p384_addcarryx_u32(x245, x219, x216);
    let (x248, x249) = fiat_p384_addcarryx_u32(x247, x217, x214);
    let (x250, x251) = fiat_p384_addcarryx_u32(0x0, x190, x232);
    let (x252, x253) = fiat_p384_addcarryx_u32(x251, x192, x233);
    let (x254, x255) = fiat_p384_addcarryx_u32(x253, x194, (0x0 as u32));
    let (x256, x257) = fiat_p384_addcarryx_u32(x255, x196, x230);
    let (x258, x259) = fiat_p384_addcarryx_u32(x257, x198, x234);
    let (x260, x261) = fiat_p384_addcarryx_u32(x259, x200, x236);
    let (x262, x263) = fiat_p384_addcarryx_u32(x261, x202, x238);
    let (x264, x265) = fiat_p384_addcarryx_u32(x263, x204, x240);
    let (x266, x267) = fiat_p384_addcarryx_u32(x265, x206, x242);
    let (x268, x269) = fiat_p384_addcarryx_u32(x267, x208, x244);
    let (x270, x271) = fiat_p384_addcarryx_u32(x269, x210, x246);
    let (x272, x273) = fiat_p384_addcarryx_u32(x271, x212, x248);
    let (x274, x275) = fiat_p384_addcarryx_u32(
        x273,
        ((x213 as u32) + (x189 as u32)),
        ((x249 as u32) + x215),
    );
    let (x276, x277) = fiat_p384_addcarryx_u32(0x0, x252, (arg1[4]));
    let (x278, x279) = fiat_p384_addcarryx_u32(x277, x254, (0x0 as u32));
    let (x280, x281) = fiat_p384_addcarryx_u32(x279, x256, (0x0 as u32));
    let (x282, x283) = fiat_p384_addcarryx_u32(x281, x258, (0x0 as u32));
    let (x284, x285) = fiat_p384_addcarryx_u32(x283, x260, (0x0 as u32));
    let (x286, x287) = fiat_p384_addcarryx_u32(x285, x262, (0x0 as u32));
    let (x288, x289) = fiat_p384_addcarryx_u32(x287, x264, (0x0 as u32));
    let (x290, x291) = fiat_p384_addcarryx_u32(x289, x266, (0x0 as u32));
    let (x292, x293) = fiat_p384_addcarryx_u32(x291, x268, (0x0 as u32));
    let (x294, x295) = fiat_p384_addcarryx_u32(x293, x270, (0x0 as u32));
    let (x296, x297) = fiat_p384_addcarryx_u32(x295, x272, (0x0 as u32));
    let (x298, x299) = fiat_p384_addcarryx_u32(x297, x274, (0x0 as u32));
    let (x300, x301) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x302, x303) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x304, x305) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x306, x307) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x308, x309) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x310, x311) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x312, x313) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x314, x315) = fiat_p384_mulx_u32(x276, 0xfffffffe);
    let (x316, x317) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x318, x319) = fiat_p384_mulx_u32(x276, 0xffffffff);
    let (x320, x321) = fiat_p384_addcarryx_u32(0x0, x317, x314);
    let (x322, x323) = fiat_p384_addcarryx_u32(x321, x315, x312);
    let (x324, x325) = fiat_p384_addcarryx_u32(x323, x313, x310);
    let (x326, x327) = fiat_p384_addcarryx_u32(x325, x311, x308);
    let (x328, x329) = fiat_p384_addcarryx_u32(x327, x309, x306);
    let (x330, x331) = fiat_p384_addcarryx_u32(x329, x307, x304);
    let (x332, x333) = fiat_p384_addcarryx_u32(x331, x305, x302);
    let (x334, x335) = fiat_p384_addcarryx_u32(x333, x303, x300);
    let (x336, x337) = fiat_p384_addcarryx_u32(0x0, x276, x318);
    let (x338, x339) = fiat_p384_addcarryx_u32(x337, x278, x319);
    let (x340, x341) = fiat_p384_addcarryx_u32(x339, x280, (0x0 as u32));
    let (x342, x343) = fiat_p384_addcarryx_u32(x341, x282, x316);
    let (x344, x345) = fiat_p384_addcarryx_u32(x343, x284, x320);
    let (x346, x347) = fiat_p384_addcarryx_u32(x345, x286, x322);
    let (x348, x349) = fiat_p384_addcarryx_u32(x347, x288, x324);
    let (x350, x351) = fiat_p384_addcarryx_u32(x349, x290, x326);
    let (x352, x353) = fiat_p384_addcarryx_u32(x351, x292, x328);
    let (x354, x355) = fiat_p384_addcarryx_u32(x353, x294, x330);
    let (x356, x357) = fiat_p384_addcarryx_u32(x355, x296, x332);
    let (x358, x359) = fiat_p384_addcarryx_u32(x357, x298, x334);
    let (x360, x361) = fiat_p384_addcarryx_u32(
        x359,
        ((x299 as u32) + (x275 as u32)),
        ((x335 as u32) + x301),
    );
    let (x362, x363) = fiat_p384_addcarryx_u32(0x0, x338, (arg1[5]));
    let (x364, x365) = fiat_p384_addcarryx_u32(x363, x340, (0x0 as u32));
    let (x366, x367) = fiat_p384_addcarryx_u32(x365, x342, (0x0 as u32));
    let (x368, x369) = fiat_p384_addcarryx_u32(x367, x344, (0x0 as u32));
    let (x370, x371) = fiat_p384_addcarryx_u32(x369, x346, (0x0 as u32));
    let (x372, x373) = fiat_p384_addcarryx_u32(x371, x348, (0x0 as u32));
    let (x374, x375) = fiat_p384_addcarryx_u32(x373, x350, (0x0 as u32));
    let (x376, x377) = fiat_p384_addcarryx_u32(x375, x352, (0x0 as u32));
    let (x378, x379) = fiat_p384_addcarryx_u32(x377, x354, (0x0 as u32));
    let (x380, x381) = fiat_p384_addcarryx_u32(x379, x356, (0x0 as u32));
    let (x382, x383) = fiat_p384_addcarryx_u32(x381, x358, (0x0 as u32));
    let (x384, x385) = fiat_p384_addcarryx_u32(x383, x360, (0x0 as u32));
    let (x386, x387) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x388, x389) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x390, x391) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x392, x393) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x394, x395) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x396, x397) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x398, x399) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x400, x401) = fiat_p384_mulx_u32(x362, 0xfffffffe);
    let (x402, x403) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x404, x405) = fiat_p384_mulx_u32(x362, 0xffffffff);
    let (x406, x407) = fiat_p384_addcarryx_u32(0x0, x403, x400);
    let (x408, x409) = fiat_p384_addcarryx_u32(x407, x401, x398);
    let (x410, x411) = fiat_p384_addcarryx_u32(x409, x399, x396);
    let (x412, x413) = fiat_p384_addcarryx_u32(x411, x397, x394);
    let (x414, x415) = fiat_p384_addcarryx_u32(x413, x395, x392);
    let (x416, x417) = fiat_p384_addcarryx_u32(x415, x393, x390);
    let (x418, x419) = fiat_p384_addcarryx_u32(x417, x391, x388);
    let (x420, x421) = fiat_p384_addcarryx_u32(x419, x389, x386);
    let (x422, x423) = fiat_p384_addcarryx_u32(0x0, x362, x404);
    let (x424, x425) = fiat_p384_addcarryx_u32(x423, x364, x405);
    let (x426, x427) = fiat_p384_addcarryx_u32(x425, x366, (0x0 as u32));
    let (x428, x429) = fiat_p384_addcarryx_u32(x427, x368, x402);
    let (x430, x431) = fiat_p384_addcarryx_u32(x429, x370, x406);
    let (x432, x433) = fiat_p384_addcarryx_u32(x431, x372, x408);
    let (x434, x435) = fiat_p384_addcarryx_u32(x433, x374, x410);
    let (x436, x437) = fiat_p384_addcarryx_u32(x435, x376, x412);
    let (x438, x439) = fiat_p384_addcarryx_u32(x437, x378, x414);
    let (x440, x441) = fiat_p384_addcarryx_u32(x439, x380, x416);
    let (x442, x443) = fiat_p384_addcarryx_u32(x441, x382, x418);
    let (x444, x445) = fiat_p384_addcarryx_u32(x443, x384, x420);
    let (x446, x447) = fiat_p384_addcarryx_u32(
        x445,
        ((x385 as u32) + (x361 as u32)),
        ((x421 as u32) + x387),
    );
    let (x448, x449) = fiat_p384_addcarryx_u32(0x0, x424, (arg1[6]));
    let (x450, x451) = fiat_p384_addcarryx_u32(x449, x426, (0x0 as u32));
    let (x452, x453) = fiat_p384_addcarryx_u32(x451, x428, (0x0 as u32));
    let (x454, x455) = fiat_p384_addcarryx_u32(x453, x430, (0x0 as u32));
    let (x456, x457) = fiat_p384_addcarryx_u32(x455, x432, (0x0 as u32));
    let (x458, x459) = fiat_p384_addcarryx_u32(x457, x434, (0x0 as u32));
    let (x460, x461) = fiat_p384_addcarryx_u32(x459, x436, (0x0 as u32));
    let (x462, x463) = fiat_p384_addcarryx_u32(x461, x438, (0x0 as u32));
    let (x464, x465) = fiat_p384_addcarryx_u32(x463, x440, (0x0 as u32));
    let (x466, x467) = fiat_p384_addcarryx_u32(x465, x442, (0x0 as u32));
    let (x468, x469) = fiat_p384_addcarryx_u32(x467, x444, (0x0 as u32));
    let (x470, x471) = fiat_p384_addcarryx_u32(x469, x446, (0x0 as u32));
    let (x472, x473) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x474, x475) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x476, x477) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x478, x479) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x480, x481) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x482, x483) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x484, x485) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x486, x487) = fiat_p384_mulx_u32(x448, 0xfffffffe);
    let (x488, x489) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x490, x491) = fiat_p384_mulx_u32(x448, 0xffffffff);
    let (x492, x493) = fiat_p384_addcarryx_u32(0x0, x489, x486);
    let (x494, x495) = fiat_p384_addcarryx_u32(x493, x487, x484);
    let (x496, x497) = fiat_p384_addcarryx_u32(x495, x485, x482);
    let (x498, x499) = fiat_p384_addcarryx_u32(x497, x483, x480);
    let (x500, x501) = fiat_p384_addcarryx_u32(x499, x481, x478);
    let (x502, x503) = fiat_p384_addcarryx_u32(x501, x479, x476);
    let (x504, x505) = fiat_p384_addcarryx_u32(x503, x477, x474);
    let (x506, x507) = fiat_p384_addcarryx_u32(x505, x475, x472);
    let (x508, x509) = fiat_p384_addcarryx_u32(0x0, x448, x490);
    let (x510, x511) = fiat_p384_addcarryx_u32(x509, x450, x491);
    let (x512, x513) = fiat_p384_addcarryx_u32(x511, x452, (0x0 as u32));
    let (x514, x515) = fiat_p384_addcarryx_u32(x513, x454, x488);
    let (x516, x517) = fiat_p384_addcarryx_u32(x515, x456, x492);
    let (x518, x519) = fiat_p384_addcarryx_u32(x517, x458, x494);
    let (x520, x521) = fiat_p384_addcarryx_u32(x519, x460, x496);
    let (x522, x523) = fiat_p384_addcarryx_u32(x521, x462, x498);
    let (x524, x525) = fiat_p384_addcarryx_u32(x523, x464, x500);
    let (x526, x527) = fiat_p384_addcarryx_u32(x525, x466, x502);
    let (x528, x529) = fiat_p384_addcarryx_u32(x527, x468, x504);
    let (x530, x531) = fiat_p384_addcarryx_u32(x529, x470, x506);
    let (x532, x533) = fiat_p384_addcarryx_u32(
        x531,
        ((x471 as u32) + (x447 as u32)),
        ((x507 as u32) + x473),
    );
    let (x534, x535) = fiat_p384_addcarryx_u32(0x0, x510, (arg1[7]));
    let (x536, x537) = fiat_p384_addcarryx_u32(x535, x512, (0x0 as u32));
    let (x538, x539) = fiat_p384_addcarryx_u32(x537, x514, (0x0 as u32));
    let (x540, x541) = fiat_p384_addcarryx_u32(x539, x516, (0x0 as u32));
    let (x542, x543) = fiat_p384_addcarryx_u32(x541, x518, (0x0 as u32));
    let (x544, x545) = fiat_p384_addcarryx_u32(x543, x520, (0x0 as u32));
    let (x546, x547) = fiat_p384_addcarryx_u32(x545, x522, (0x0 as u32));
    let (x548, x549) = fiat_p384_addcarryx_u32(x547, x524, (0x0 as u32));
    let (x550, x551) = fiat_p384_addcarryx_u32(x549, x526, (0x0 as u32));
    let (x552, x553) = fiat_p384_addcarryx_u32(x551, x528, (0x0 as u32));
    let (x554, x555) = fiat_p384_addcarryx_u32(x553, x530, (0x0 as u32));
    let (x556, x557) = fiat_p384_addcarryx_u32(x555, x532, (0x0 as u32));
    let (x558, x559) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x560, x561) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x562, x563) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x564, x565) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x566, x567) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x568, x569) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x570, x571) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x572, x573) = fiat_p384_mulx_u32(x534, 0xfffffffe);
    let (x574, x575) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x576, x577) = fiat_p384_mulx_u32(x534, 0xffffffff);
    let (x578, x579) = fiat_p384_addcarryx_u32(0x0, x575, x572);
    let (x580, x581) = fiat_p384_addcarryx_u32(x579, x573, x570);
    let (x582, x583) = fiat_p384_addcarryx_u32(x581, x571, x568);
    let (x584, x585) = fiat_p384_addcarryx_u32(x583, x569, x566);
    let (x586, x587) = fiat_p384_addcarryx_u32(x585, x567, x564);
    let (x588, x589) = fiat_p384_addcarryx_u32(x587, x565, x562);
    let (x590, x591) = fiat_p384_addcarryx_u32(x589, x563, x560);
    let (x592, x593) = fiat_p384_addcarryx_u32(x591, x561, x558);
    let (x594, x595) = fiat_p384_addcarryx_u32(0x0, x534, x576);
    let (x596, x597) = fiat_p384_addcarryx_u32(x595, x536, x577);
    let (x598, x599) = fiat_p384_addcarryx_u32(x597, x538, (0x0 as u32));
    let (x600, x601) = fiat_p384_addcarryx_u32(x599, x540, x574);
    let (x602, x603) = fiat_p384_addcarryx_u32(x601, x542, x578);
    let (x604, x605) = fiat_p384_addcarryx_u32(x603, x544, x580);
    let (x606, x607) = fiat_p384_addcarryx_u32(x605, x546, x582);
    let (x608, x609) = fiat_p384_addcarryx_u32(x607, x548, x584);
    let (x610, x611) = fiat_p384_addcarryx_u32(x609, x550, x586);
    let (x612, x613) = fiat_p384_addcarryx_u32(x611, x552, x588);
    let (x614, x615) = fiat_p384_addcarryx_u32(x613, x554, x590);
    let (x616, x617) = fiat_p384_addcarryx_u32(x615, x556, x592);
    let (x618, x619) = fiat_p384_addcarryx_u32(
        x617,
        ((x557 as u32) + (x533 as u32)),
        ((x593 as u32) + x559),
    );
    let (x620, x621) = fiat_p384_addcarryx_u32(0x0, x596, (arg1[8]));
    let (x622, x623) = fiat_p384_addcarryx_u32(x621, x598, (0x0 as u32));
    let (x624, x625) = fiat_p384_addcarryx_u32(x623, x600, (0x0 as u32));
    let (x626, x627) = fiat_p384_addcarryx_u32(x625, x602, (0x0 as u32));
    let (x628, x629) = fiat_p384_addcarryx_u32(x627, x604, (0x0 as u32));
    let (x630, x631) = fiat_p384_addcarryx_u32(x629, x606, (0x0 as u32));
    let (x632, x633) = fiat_p384_addcarryx_u32(x631, x608, (0x0 as u32));
    let (x634, x635) = fiat_p384_addcarryx_u32(x633, x610, (0x0 as u32));
    let (x636, x637) = fiat_p384_addcarryx_u32(x635, x612, (0x0 as u32));
    let (x638, x639) = fiat_p384_addcarryx_u32(x637, x614, (0x0 as u32));
    let (x640, x641) = fiat_p384_addcarryx_u32(x639, x616, (0x0 as u32));
    let (x642, x643) = fiat_p384_addcarryx_u32(x641, x618, (0x0 as u32));
    let (x644, x645) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x646, x647) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x648, x649) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x650, x651) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x652, x653) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x654, x655) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x656, x657) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x658, x659) = fiat_p384_mulx_u32(x620, 0xfffffffe);
    let (x660, x661) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x662, x663) = fiat_p384_mulx_u32(x620, 0xffffffff);
    let (x664, x665) = fiat_p384_addcarryx_u32(0x0, x661, x658);
    let (x666, x667) = fiat_p384_addcarryx_u32(x665, x659, x656);
    let (x668, x669) = fiat_p384_addcarryx_u32(x667, x657, x654);
    let (x670, x671) = fiat_p384_addcarryx_u32(x669, x655, x652);
    let (x672, x673) = fiat_p384_addcarryx_u32(x671, x653, x650);
    let (x674, x675) = fiat_p384_addcarryx_u32(x673, x651, x648);
    let (x676, x677) = fiat_p384_addcarryx_u32(x675, x649, x646);
    let (x678, x679) = fiat_p384_addcarryx_u32(x677, x647, x644);
    let (x680, x681) = fiat_p384_addcarryx_u32(0x0, x620, x662);
    let (x682, x683) = fiat_p384_addcarryx_u32(x681, x622, x663);
    let (x684, x685) = fiat_p384_addcarryx_u32(x683, x624, (0x0 as u32));
    let (x686, x687) = fiat_p384_addcarryx_u32(x685, x626, x660);
    let (x688, x689) = fiat_p384_addcarryx_u32(x687, x628, x664);
    let (x690, x691) = fiat_p384_addcarryx_u32(x689, x630, x666);
    let (x692, x693) = fiat_p384_addcarryx_u32(x691, x632, x668);
    let (x694, x695) = fiat_p384_addcarryx_u32(x693, x634, x670);
    let (x696, x697) = fiat_p384_addcarryx_u32(x695, x636, x672);
    let (x698, x699) = fiat_p384_addcarryx_u32(x697, x638, x674);
    let (x700, x701) = fiat_p384_addcarryx_u32(x699, x640, x676);
    let (x702, x703) = fiat_p384_addcarryx_u32(x701, x642, x678);
    let (x704, x705) = fiat_p384_addcarryx_u32(
        x703,
        ((x643 as u32) + (x619 as u32)),
        ((x679 as u32) + x645),
    );
    let (x706, x707) = fiat_p384_addcarryx_u32(0x0, x682, (arg1[9]));
    let (x708, x709) = fiat_p384_addcarryx_u32(x707, x684, (0x0 as u32));
    let (x710, x711) = fiat_p384_addcarryx_u32(x709, x686, (0x0 as u32));
    let (x712, x713) = fiat_p384_addcarryx_u32(x711, x688, (0x0 as u32));
    let (x714, x715) = fiat_p384_addcarryx_u32(x713, x690, (0x0 as u32));
    let (x716, x717) = fiat_p384_addcarryx_u32(x715, x692, (0x0 as u32));
    let (x718, x719) = fiat_p384_addcarryx_u32(x717, x694, (0x0 as u32));
    let (x720, x721) = fiat_p384_addcarryx_u32(x719, x696, (0x0 as u32));
    let (x722, x723) = fiat_p384_addcarryx_u32(x721, x698, (0x0 as u32));
    let (x724, x725) = fiat_p384_addcarryx_u32(x723, x700, (0x0 as u32));
    let (x726, x727) = fiat_p384_addcarryx_u32(x725, x702, (0x0 as u32));
    let (x728, x729) = fiat_p384_addcarryx_u32(x727, x704, (0x0 as u32));
    let (x730, x731) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x732, x733) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x734, x735) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x736, x737) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x738, x739) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x740, x741) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x742, x743) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x744, x745) = fiat_p384_mulx_u32(x706, 0xfffffffe);
    let (x746, x747) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x748, x749) = fiat_p384_mulx_u32(x706, 0xffffffff);
    let (x750, x751) = fiat_p384_addcarryx_u32(0x0, x747, x744);
    let (x752, x753) = fiat_p384_addcarryx_u32(x751, x745, x742);
    let (x754, x755) = fiat_p384_addcarryx_u32(x753, x743, x740);
    let (x756, x757) = fiat_p384_addcarryx_u32(x755, x741, x738);
    let (x758, x759) = fiat_p384_addcarryx_u32(x757, x739, x736);
    let (x760, x761) = fiat_p384_addcarryx_u32(x759, x737, x734);
    let (x762, x763) = fiat_p384_addcarryx_u32(x761, x735, x732);
    let (x764, x765) = fiat_p384_addcarryx_u32(x763, x733, x730);
    let (x766, x767) = fiat_p384_addcarryx_u32(0x0, x706, x748);
    let (x768, x769) = fiat_p384_addcarryx_u32(x767, x708, x749);
    let (x770, x771) = fiat_p384_addcarryx_u32(x769, x710, (0x0 as u32));
    let (x772, x773) = fiat_p384_addcarryx_u32(x771, x712, x746);
    let (x774, x775) = fiat_p384_addcarryx_u32(x773, x714, x750);
    let (x776, x777) = fiat_p384_addcarryx_u32(x775, x716, x752);
    let (x778, x779) = fiat_p384_addcarryx_u32(x777, x718, x754);
    let (x780, x781) = fiat_p384_addcarryx_u32(x779, x720, x756);
    let (x782, x783) = fiat_p384_addcarryx_u32(x781, x722, x758);
    let (x784, x785) = fiat_p384_addcarryx_u32(x783, x724, x760);
    let (x786, x787) = fiat_p384_addcarryx_u32(x785, x726, x762);
    let (x788, x789) = fiat_p384_addcarryx_u32(x787, x728, x764);
    let (x790, x791) = fiat_p384_addcarryx_u32(
        x789,
        ((x729 as u32) + (x705 as u32)),
        ((x765 as u32) + x731),
    );
    let (x792, x793) = fiat_p384_addcarryx_u32(0x0, x768, (arg1[10]));
    let (x794, x795) = fiat_p384_addcarryx_u32(x793, x770, (0x0 as u32));
    let (x796, x797) = fiat_p384_addcarryx_u32(x795, x772, (0x0 as u32));
    let (x798, x799) = fiat_p384_addcarryx_u32(x797, x774, (0x0 as u32));
    let (x800, x801) = fiat_p384_addcarryx_u32(x799, x776, (0x0 as u32));
    let (x802, x803) = fiat_p384_addcarryx_u32(x801, x778, (0x0 as u32));
    let (x804, x805) = fiat_p384_addcarryx_u32(x803, x780, (0x0 as u32));
    let (x806, x807) = fiat_p384_addcarryx_u32(x805, x782, (0x0 as u32));
    let (x808, x809) = fiat_p384_addcarryx_u32(x807, x784, (0x0 as u32));
    let (x810, x811) = fiat_p384_addcarryx_u32(x809, x786, (0x0 as u32));
    let (x812, x813) = fiat_p384_addcarryx_u32(x811, x788, (0x0 as u32));
    let (x814, x815) = fiat_p384_addcarryx_u32(x813, x790, (0x0 as u32));
    let (x816, x817) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x818, x819) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x820, x821) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x822, x823) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x824, x825) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x826, x827) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x828, x829) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x830, x831) = fiat_p384_mulx_u32(x792, 0xfffffffe);
    let (x832, x833) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x834, x835) = fiat_p384_mulx_u32(x792, 0xffffffff);
    let (x836, x837) = fiat_p384_addcarryx_u32(0x0, x833, x830);
    let (x838, x839) = fiat_p384_addcarryx_u32(x837, x831, x828);
    let (x840, x841) = fiat_p384_addcarryx_u32(x839, x829, x826);
    let (x842, x843) = fiat_p384_addcarryx_u32(x841, x827, x824);
    let (x844, x845) = fiat_p384_addcarryx_u32(x843, x825, x822);
    let (x846, x847) = fiat_p384_addcarryx_u32(x845, x823, x820);
    let (x848, x849) = fiat_p384_addcarryx_u32(x847, x821, x818);
    let (x850, x851) = fiat_p384_addcarryx_u32(x849, x819, x816);
    let (x852, x853) = fiat_p384_addcarryx_u32(0x0, x792, x834);
    let (x854, x855) = fiat_p384_addcarryx_u32(x853, x794, x835);
    let (x856, x857) = fiat_p384_addcarryx_u32(x855, x796, (0x0 as u32));
    let (x858, x859) = fiat_p384_addcarryx_u32(x857, x798, x832);
    let (x860, x861) = fiat_p384_addcarryx_u32(x859, x800, x836);
    let (x862, x863) = fiat_p384_addcarryx_u32(x861, x802, x838);
    let (x864, x865) = fiat_p384_addcarryx_u32(x863, x804, x840);
    let (x866, x867) = fiat_p384_addcarryx_u32(x865, x806, x842);
    let (x868, x869) = fiat_p384_addcarryx_u32(x867, x808, x844);
    let (x870, x871) = fiat_p384_addcarryx_u32(x869, x810, x846);
    let (x872, x873) = fiat_p384_addcarryx_u32(x871, x812, x848);
    let (x874, x875) = fiat_p384_addcarryx_u32(x873, x814, x850);
    let (x876, x877) = fiat_p384_addcarryx_u32(
        x875,
        ((x815 as u32) + (x791 as u32)),
        ((x851 as u32) + x817),
    );
    let (x878, x879) = fiat_p384_addcarryx_u32(0x0, x854, (arg1[11]));
    let (x880, x881) = fiat_p384_addcarryx_u32(x879, x856, (0x0 as u32));
    let (x882, x883) = fiat_p384_addcarryx_u32(x881, x858, (0x0 as u32));
    let (x884, x885) = fiat_p384_addcarryx_u32(x883, x860, (0x0 as u32));
    let (x886, x887) = fiat_p384_addcarryx_u32(x885, x862, (0x0 as u32));
    let (x888, x889) = fiat_p384_addcarryx_u32(x887, x864, (0x0 as u32));
    let (x890, x891) = fiat_p384_addcarryx_u32(x889, x866, (0x0 as u32));
    let (x892, x893) = fiat_p384_addcarryx_u32(x891, x868, (0x0 as u32));
    let (x894, x895) = fiat_p384_addcarryx_u32(x893, x870, (0x0 as u32));
    let (x896, x897) = fiat_p384_addcarryx_u32(x895, x872, (0x0 as u32));
    let (x898, x899) = fiat_p384_addcarryx_u32(x897, x874, (0x0 as u32));
    let (x900, x901) = fiat_p384_addcarryx_u32(x899, x876, (0x0 as u32));
    let (x902, x903) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x904, x905) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x906, x907) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x908, x909) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x910, x911) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x912, x913) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x914, x915) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x916, x917) = fiat_p384_mulx_u32(x878, 0xfffffffe);
    let (x918, x919) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x920, x921) = fiat_p384_mulx_u32(x878, 0xffffffff);
    let (x922, x923) = fiat_p384_addcarryx_u32(0x0, x919, x916);
    let (x924, x925) = fiat_p384_addcarryx_u32(x923, x917, x914);
    let (x926, x927) = fiat_p384_addcarryx_u32(x925, x915, x912);
    let (x928, x929) = fiat_p384_addcarryx_u32(x927, x913, x910);
    let (x930, x931) = fiat_p384_addcarryx_u32(x929, x911, x908);
    let (x932, x933) = fiat_p384_addcarryx_u32(x931, x909, x906);
    let (x934, x935) = fiat_p384_addcarryx_u32(x933, x907, x904);
    let (x936, x937) = fiat_p384_addcarryx_u32(x935, x905, x902);
    let (x938, x939) = fiat_p384_addcarryx_u32(0x0, x878, x920);
    let (x940, x941) = fiat_p384_addcarryx_u32(x939, x880, x921);
    let (x942, x943) = fiat_p384_addcarryx_u32(x941, x882, (0x0 as u32));
    let (x944, x945) = fiat_p384_addcarryx_u32(x943, x884, x918);
    let (x946, x947) = fiat_p384_addcarryx_u32(x945, x886, x922);
    let (x948, x949) = fiat_p384_addcarryx_u32(x947, x888, x924);
    let (x950, x951) = fiat_p384_addcarryx_u32(x949, x890, x926);
    let (x952, x953) = fiat_p384_addcarryx_u32(x951, x892, x928);
    let (x954, x955) = fiat_p384_addcarryx_u32(x953, x894, x930);
    let (x956, x957) = fiat_p384_addcarryx_u32(x955, x896, x932);
    let (x958, x959) = fiat_p384_addcarryx_u32(x957, x898, x934);
    let (x960, x961) = fiat_p384_addcarryx_u32(x959, x900, x936);
    let (x962, x963) = fiat_p384_addcarryx_u32(
        x961,
        ((x901 as u32) + (x877 as u32)),
        ((x937 as u32) + x903),
    );
    let (x964, x965) = fiat_p384_subborrowx_u32(0x0, x940, 0xffffffff);
    let (x966, x967) = fiat_p384_subborrowx_u32(x965, x942, (0x0 as u32));
    let (x968, x969) = fiat_p384_subborrowx_u32(x967, x944, (0x0 as u32));
    let (x970, x971) = fiat_p384_subborrowx_u32(x969, x946, 0xffffffff);
    let (x972, x973) = fiat_p384_subborrowx_u32(x971, x948, 0xfffffffe);
    let (x974, x975) = fiat_p384_subborrowx_u32(x973, x950, 0xffffffff);
    let (x976, x977) = fiat_p384_subborrowx_u32(x975, x952, 0xffffffff);
    let (x978, x979) = fiat_p384_subborrowx_u32(x977, x954, 0xffffffff);
    let (x980, x981) = fiat_p384_subborrowx_u32(x979, x956, 0xffffffff);
    let (x982, x983) = fiat_p384_subborrowx_u32(x981, x958, 0xffffffff);
    let (x984, x985) = fiat_p384_subborrowx_u32(x983, x960, 0xffffffff);
    let (x986, x987) = fiat_p384_subborrowx_u32(x985, x962, 0xffffffff);
    let (x988, x989) = fiat_p384_subborrowx_u32(x987, (x963 as u32), (0x0 as u32));
    let (x990) = fiat_p384_cmovznz_u32(x989, x964, x940);
    let (x991) = fiat_p384_cmovznz_u32(x989, x966, x942);
    let (x992) = fiat_p384_cmovznz_u32(x989, x968, x944);
    let (x993) = fiat_p384_cmovznz_u32(x989, x970, x946);
    let (x994) = fiat_p384_cmovznz_u32(x989, x972, x948);
    let (x995) = fiat_p384_cmovznz_u32(x989, x974, x950);
    let (x996) = fiat_p384_cmovznz_u32(x989, x976, x952);
    let (x997) = fiat_p384_cmovznz_u32(x989, x978, x954);
    let (x998) = fiat_p384_cmovznz_u32(x989, x980, x956);
    let (x999) = fiat_p384_cmovznz_u32(x989, x982, x958);
    let (x1000) = fiat_p384_cmovznz_u32(x989, x984, x960);
    let (x1001) = fiat_p384_cmovznz_u32(x989, x986, x962);
    out1[0] = x990;
    out1[1] = x991;
    out1[2] = x992;
    out1[3] = x993;
    out1[4] = x994;
    out1[5] = x995;
    out1[6] = x996;
    out1[7] = x997;
    out1[8] = x998;
    out1[9] = x999;
    out1[10] = x1000;
    out1[11] = x1001;
    out1
}
#[doc = " The function fiat_p384_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_to_montgomery(
    arg1: &fiat_p384_non_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let (x13, x14) = fiat_p384_mulx_u32(x12, 0x2);
    let (x15, x16) = fiat_p384_mulx_u32(x12, 0xfffffffe);
    let (x17, x18) = fiat_p384_mulx_u32(x12, 0x2);
    let (x19, x20) = fiat_p384_mulx_u32(x12, 0xfffffffe);
    let (x21, x22) = fiat_p384_addcarryx_u32(0x0, ((x14 as fiat_p384_u1) as u32), x12);
    let (x23, x24) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x25, x26) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x27, x28) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x29, x30) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x31, x32) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x33, x34) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x35, x36) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x37, x38) = fiat_p384_mulx_u32(x12, 0xfffffffe);
    let (x39, x40) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x41, x42) = fiat_p384_mulx_u32(x12, 0xffffffff);
    let (x43, x44) = fiat_p384_addcarryx_u32(0x0, x40, x37);
    let (x45, x46) = fiat_p384_addcarryx_u32(x44, x38, x35);
    let (x47, x48) = fiat_p384_addcarryx_u32(x46, x36, x33);
    let (x49, x50) = fiat_p384_addcarryx_u32(x48, x34, x31);
    let (x51, x52) = fiat_p384_addcarryx_u32(x50, x32, x29);
    let (x53, x54) = fiat_p384_addcarryx_u32(x52, x30, x27);
    let (x55, x56) = fiat_p384_addcarryx_u32(x54, x28, x25);
    let (x57, x58) = fiat_p384_addcarryx_u32(x56, x26, x23);
    let (x59, x60) = fiat_p384_addcarryx_u32(0x0, x12, x41);
    let (x61, x62) = fiat_p384_addcarryx_u32(x60, x19, x42);
    let (x63, x64) = fiat_p384_addcarryx_u32(0x0, x17, x39);
    let (x65, x66) = fiat_p384_addcarryx_u32(x64, ((x18 as fiat_p384_u1) as u32), x43);
    let (x67, x68) = fiat_p384_addcarryx_u32(x66, x15, x45);
    let (x69, x70) = fiat_p384_addcarryx_u32(x68, x16, x47);
    let (x71, x72) = fiat_p384_addcarryx_u32(x70, x13, x49);
    let (x73, x74) = fiat_p384_addcarryx_u32(x72, x21, x51);
    let (x75, x76) = fiat_p384_addcarryx_u32(x74, (x22 as u32), x53);
    let (x77, x78) = fiat_p384_addcarryx_u32(x76, (0x0 as u32), x55);
    let (x79, x80) = fiat_p384_addcarryx_u32(x78, (0x0 as u32), x57);
    let (x81, x82) = fiat_p384_addcarryx_u32(x80, (0x0 as u32), ((x58 as u32) + x24));
    let (x83, x84) = fiat_p384_mulx_u32(x1, 0x2);
    let (x85, x86) = fiat_p384_mulx_u32(x1, 0xfffffffe);
    let (x87, x88) = fiat_p384_mulx_u32(x1, 0x2);
    let (x89, x90) = fiat_p384_mulx_u32(x1, 0xfffffffe);
    let (x91, x92) = fiat_p384_addcarryx_u32(0x0, ((x84 as fiat_p384_u1) as u32), x1);
    let (x93, x94) = fiat_p384_addcarryx_u32(0x0, x61, x1);
    let (x95, x96) = fiat_p384_addcarryx_u32(x94, ((x62 as u32) + x20), x89);
    let (x97, x98) = fiat_p384_addcarryx_u32(x96, x63, x90);
    let (x99, x100) = fiat_p384_addcarryx_u32(x98, x65, x87);
    let (x101, x102) = fiat_p384_addcarryx_u32(x100, x67, ((x88 as fiat_p384_u1) as u32));
    let (x103, x104) = fiat_p384_addcarryx_u32(x102, x69, x85);
    let (x105, x106) = fiat_p384_addcarryx_u32(x104, x71, x86);
    let (x107, x108) = fiat_p384_addcarryx_u32(x106, x73, x83);
    let (x109, x110) = fiat_p384_addcarryx_u32(x108, x75, x91);
    let (x111, x112) = fiat_p384_addcarryx_u32(x110, x77, (x92 as u32));
    let (x113, x114) = fiat_p384_addcarryx_u32(x112, x79, (0x0 as u32));
    let (x115, x116) = fiat_p384_addcarryx_u32(x114, x81, (0x0 as u32));
    let (x117, x118) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x119, x120) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x121, x122) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x123, x124) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x125, x126) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x127, x128) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x129, x130) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x131, x132) = fiat_p384_mulx_u32(x93, 0xfffffffe);
    let (x133, x134) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x135, x136) = fiat_p384_mulx_u32(x93, 0xffffffff);
    let (x137, x138) = fiat_p384_addcarryx_u32(0x0, x134, x131);
    let (x139, x140) = fiat_p384_addcarryx_u32(x138, x132, x129);
    let (x141, x142) = fiat_p384_addcarryx_u32(x140, x130, x127);
    let (x143, x144) = fiat_p384_addcarryx_u32(x142, x128, x125);
    let (x145, x146) = fiat_p384_addcarryx_u32(x144, x126, x123);
    let (x147, x148) = fiat_p384_addcarryx_u32(x146, x124, x121);
    let (x149, x150) = fiat_p384_addcarryx_u32(x148, x122, x119);
    let (x151, x152) = fiat_p384_addcarryx_u32(x150, x120, x117);
    let (x153, x154) = fiat_p384_addcarryx_u32(0x0, x93, x135);
    let (x155, x156) = fiat_p384_addcarryx_u32(x154, x95, x136);
    let (x157, x158) = fiat_p384_addcarryx_u32(x156, x97, (0x0 as u32));
    let (x159, x160) = fiat_p384_addcarryx_u32(x158, x99, x133);
    let (x161, x162) = fiat_p384_addcarryx_u32(x160, x101, x137);
    let (x163, x164) = fiat_p384_addcarryx_u32(x162, x103, x139);
    let (x165, x166) = fiat_p384_addcarryx_u32(x164, x105, x141);
    let (x167, x168) = fiat_p384_addcarryx_u32(x166, x107, x143);
    let (x169, x170) = fiat_p384_addcarryx_u32(x168, x109, x145);
    let (x171, x172) = fiat_p384_addcarryx_u32(x170, x111, x147);
    let (x173, x174) = fiat_p384_addcarryx_u32(x172, x113, x149);
    let (x175, x176) = fiat_p384_addcarryx_u32(x174, x115, x151);
    let (x177, x178) =
        fiat_p384_addcarryx_u32(x176, ((x116 as u32) + (x82 as u32)), ((x152 as u32) + x118));
    let (x179, x180) = fiat_p384_mulx_u32(x2, 0x2);
    let (x181, x182) = fiat_p384_mulx_u32(x2, 0xfffffffe);
    let (x183, x184) = fiat_p384_mulx_u32(x2, 0x2);
    let (x185, x186) = fiat_p384_mulx_u32(x2, 0xfffffffe);
    let (x187, x188) = fiat_p384_addcarryx_u32(0x0, ((x180 as fiat_p384_u1) as u32), x2);
    let (x189, x190) = fiat_p384_addcarryx_u32(0x0, x155, x2);
    let (x191, x192) = fiat_p384_addcarryx_u32(x190, x157, x185);
    let (x193, x194) = fiat_p384_addcarryx_u32(x192, x159, x186);
    let (x195, x196) = fiat_p384_addcarryx_u32(x194, x161, x183);
    let (x197, x198) = fiat_p384_addcarryx_u32(x196, x163, ((x184 as fiat_p384_u1) as u32));
    let (x199, x200) = fiat_p384_addcarryx_u32(x198, x165, x181);
    let (x201, x202) = fiat_p384_addcarryx_u32(x200, x167, x182);
    let (x203, x204) = fiat_p384_addcarryx_u32(x202, x169, x179);
    let (x205, x206) = fiat_p384_addcarryx_u32(x204, x171, x187);
    let (x207, x208) = fiat_p384_addcarryx_u32(x206, x173, (x188 as u32));
    let (x209, x210) = fiat_p384_addcarryx_u32(x208, x175, (0x0 as u32));
    let (x211, x212) = fiat_p384_addcarryx_u32(x210, x177, (0x0 as u32));
    let (x213, x214) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x215, x216) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x217, x218) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x219, x220) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x221, x222) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x223, x224) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x225, x226) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x227, x228) = fiat_p384_mulx_u32(x189, 0xfffffffe);
    let (x229, x230) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x231, x232) = fiat_p384_mulx_u32(x189, 0xffffffff);
    let (x233, x234) = fiat_p384_addcarryx_u32(0x0, x230, x227);
    let (x235, x236) = fiat_p384_addcarryx_u32(x234, x228, x225);
    let (x237, x238) = fiat_p384_addcarryx_u32(x236, x226, x223);
    let (x239, x240) = fiat_p384_addcarryx_u32(x238, x224, x221);
    let (x241, x242) = fiat_p384_addcarryx_u32(x240, x222, x219);
    let (x243, x244) = fiat_p384_addcarryx_u32(x242, x220, x217);
    let (x245, x246) = fiat_p384_addcarryx_u32(x244, x218, x215);
    let (x247, x248) = fiat_p384_addcarryx_u32(x246, x216, x213);
    let (x249, x250) = fiat_p384_addcarryx_u32(0x0, x189, x231);
    let (x251, x252) = fiat_p384_addcarryx_u32(x250, x191, x232);
    let (x253, x254) = fiat_p384_addcarryx_u32(x252, x193, (0x0 as u32));
    let (x255, x256) = fiat_p384_addcarryx_u32(x254, x195, x229);
    let (x257, x258) = fiat_p384_addcarryx_u32(x256, x197, x233);
    let (x259, x260) = fiat_p384_addcarryx_u32(x258, x199, x235);
    let (x261, x262) = fiat_p384_addcarryx_u32(x260, x201, x237);
    let (x263, x264) = fiat_p384_addcarryx_u32(x262, x203, x239);
    let (x265, x266) = fiat_p384_addcarryx_u32(x264, x205, x241);
    let (x267, x268) = fiat_p384_addcarryx_u32(x266, x207, x243);
    let (x269, x270) = fiat_p384_addcarryx_u32(x268, x209, x245);
    let (x271, x272) = fiat_p384_addcarryx_u32(x270, x211, x247);
    let (x273, x274) = fiat_p384_addcarryx_u32(
        x272,
        ((x212 as u32) + (x178 as u32)),
        ((x248 as u32) + x214),
    );
    let (x275, x276) = fiat_p384_mulx_u32(x3, 0x2);
    let (x277, x278) = fiat_p384_mulx_u32(x3, 0xfffffffe);
    let (x279, x280) = fiat_p384_mulx_u32(x3, 0x2);
    let (x281, x282) = fiat_p384_mulx_u32(x3, 0xfffffffe);
    let (x283, x284) = fiat_p384_addcarryx_u32(0x0, ((x276 as fiat_p384_u1) as u32), x3);
    let (x285, x286) = fiat_p384_addcarryx_u32(0x0, x251, x3);
    let (x287, x288) = fiat_p384_addcarryx_u32(x286, x253, x281);
    let (x289, x290) = fiat_p384_addcarryx_u32(x288, x255, x282);
    let (x291, x292) = fiat_p384_addcarryx_u32(x290, x257, x279);
    let (x293, x294) = fiat_p384_addcarryx_u32(x292, x259, ((x280 as fiat_p384_u1) as u32));
    let (x295, x296) = fiat_p384_addcarryx_u32(x294, x261, x277);
    let (x297, x298) = fiat_p384_addcarryx_u32(x296, x263, x278);
    let (x299, x300) = fiat_p384_addcarryx_u32(x298, x265, x275);
    let (x301, x302) = fiat_p384_addcarryx_u32(x300, x267, x283);
    let (x303, x304) = fiat_p384_addcarryx_u32(x302, x269, (x284 as u32));
    let (x305, x306) = fiat_p384_addcarryx_u32(x304, x271, (0x0 as u32));
    let (x307, x308) = fiat_p384_addcarryx_u32(x306, x273, (0x0 as u32));
    let (x309, x310) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x311, x312) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x313, x314) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x315, x316) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x317, x318) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x319, x320) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x321, x322) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x323, x324) = fiat_p384_mulx_u32(x285, 0xfffffffe);
    let (x325, x326) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x327, x328) = fiat_p384_mulx_u32(x285, 0xffffffff);
    let (x329, x330) = fiat_p384_addcarryx_u32(0x0, x326, x323);
    let (x331, x332) = fiat_p384_addcarryx_u32(x330, x324, x321);
    let (x333, x334) = fiat_p384_addcarryx_u32(x332, x322, x319);
    let (x335, x336) = fiat_p384_addcarryx_u32(x334, x320, x317);
    let (x337, x338) = fiat_p384_addcarryx_u32(x336, x318, x315);
    let (x339, x340) = fiat_p384_addcarryx_u32(x338, x316, x313);
    let (x341, x342) = fiat_p384_addcarryx_u32(x340, x314, x311);
    let (x343, x344) = fiat_p384_addcarryx_u32(x342, x312, x309);
    let (x345, x346) = fiat_p384_addcarryx_u32(0x0, x285, x327);
    let (x347, x348) = fiat_p384_addcarryx_u32(x346, x287, x328);
    let (x349, x350) = fiat_p384_addcarryx_u32(x348, x289, (0x0 as u32));
    let (x351, x352) = fiat_p384_addcarryx_u32(x350, x291, x325);
    let (x353, x354) = fiat_p384_addcarryx_u32(x352, x293, x329);
    let (x355, x356) = fiat_p384_addcarryx_u32(x354, x295, x331);
    let (x357, x358) = fiat_p384_addcarryx_u32(x356, x297, x333);
    let (x359, x360) = fiat_p384_addcarryx_u32(x358, x299, x335);
    let (x361, x362) = fiat_p384_addcarryx_u32(x360, x301, x337);
    let (x363, x364) = fiat_p384_addcarryx_u32(x362, x303, x339);
    let (x365, x366) = fiat_p384_addcarryx_u32(x364, x305, x341);
    let (x367, x368) = fiat_p384_addcarryx_u32(x366, x307, x343);
    let (x369, x370) = fiat_p384_addcarryx_u32(
        x368,
        ((x308 as u32) + (x274 as u32)),
        ((x344 as u32) + x310),
    );
    let (x371, x372) = fiat_p384_mulx_u32(x4, 0x2);
    let (x373, x374) = fiat_p384_mulx_u32(x4, 0xfffffffe);
    let (x375, x376) = fiat_p384_mulx_u32(x4, 0x2);
    let (x377, x378) = fiat_p384_mulx_u32(x4, 0xfffffffe);
    let (x379, x380) = fiat_p384_addcarryx_u32(0x0, ((x372 as fiat_p384_u1) as u32), x4);
    let (x381, x382) = fiat_p384_addcarryx_u32(0x0, x347, x4);
    let (x383, x384) = fiat_p384_addcarryx_u32(x382, x349, x377);
    let (x385, x386) = fiat_p384_addcarryx_u32(x384, x351, x378);
    let (x387, x388) = fiat_p384_addcarryx_u32(x386, x353, x375);
    let (x389, x390) = fiat_p384_addcarryx_u32(x388, x355, ((x376 as fiat_p384_u1) as u32));
    let (x391, x392) = fiat_p384_addcarryx_u32(x390, x357, x373);
    let (x393, x394) = fiat_p384_addcarryx_u32(x392, x359, x374);
    let (x395, x396) = fiat_p384_addcarryx_u32(x394, x361, x371);
    let (x397, x398) = fiat_p384_addcarryx_u32(x396, x363, x379);
    let (x399, x400) = fiat_p384_addcarryx_u32(x398, x365, (x380 as u32));
    let (x401, x402) = fiat_p384_addcarryx_u32(x400, x367, (0x0 as u32));
    let (x403, x404) = fiat_p384_addcarryx_u32(x402, x369, (0x0 as u32));
    let (x405, x406) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x407, x408) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x409, x410) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x411, x412) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x413, x414) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x415, x416) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x417, x418) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x419, x420) = fiat_p384_mulx_u32(x381, 0xfffffffe);
    let (x421, x422) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x423, x424) = fiat_p384_mulx_u32(x381, 0xffffffff);
    let (x425, x426) = fiat_p384_addcarryx_u32(0x0, x422, x419);
    let (x427, x428) = fiat_p384_addcarryx_u32(x426, x420, x417);
    let (x429, x430) = fiat_p384_addcarryx_u32(x428, x418, x415);
    let (x431, x432) = fiat_p384_addcarryx_u32(x430, x416, x413);
    let (x433, x434) = fiat_p384_addcarryx_u32(x432, x414, x411);
    let (x435, x436) = fiat_p384_addcarryx_u32(x434, x412, x409);
    let (x437, x438) = fiat_p384_addcarryx_u32(x436, x410, x407);
    let (x439, x440) = fiat_p384_addcarryx_u32(x438, x408, x405);
    let (x441, x442) = fiat_p384_addcarryx_u32(0x0, x381, x423);
    let (x443, x444) = fiat_p384_addcarryx_u32(x442, x383, x424);
    let (x445, x446) = fiat_p384_addcarryx_u32(x444, x385, (0x0 as u32));
    let (x447, x448) = fiat_p384_addcarryx_u32(x446, x387, x421);
    let (x449, x450) = fiat_p384_addcarryx_u32(x448, x389, x425);
    let (x451, x452) = fiat_p384_addcarryx_u32(x450, x391, x427);
    let (x453, x454) = fiat_p384_addcarryx_u32(x452, x393, x429);
    let (x455, x456) = fiat_p384_addcarryx_u32(x454, x395, x431);
    let (x457, x458) = fiat_p384_addcarryx_u32(x456, x397, x433);
    let (x459, x460) = fiat_p384_addcarryx_u32(x458, x399, x435);
    let (x461, x462) = fiat_p384_addcarryx_u32(x460, x401, x437);
    let (x463, x464) = fiat_p384_addcarryx_u32(x462, x403, x439);
    let (x465, x466) = fiat_p384_addcarryx_u32(
        x464,
        ((x404 as u32) + (x370 as u32)),
        ((x440 as u32) + x406),
    );
    let (x467, x468) = fiat_p384_mulx_u32(x5, 0x2);
    let (x469, x470) = fiat_p384_mulx_u32(x5, 0xfffffffe);
    let (x471, x472) = fiat_p384_mulx_u32(x5, 0x2);
    let (x473, x474) = fiat_p384_mulx_u32(x5, 0xfffffffe);
    let (x475, x476) = fiat_p384_addcarryx_u32(0x0, ((x468 as fiat_p384_u1) as u32), x5);
    let (x477, x478) = fiat_p384_addcarryx_u32(0x0, x443, x5);
    let (x479, x480) = fiat_p384_addcarryx_u32(x478, x445, x473);
    let (x481, x482) = fiat_p384_addcarryx_u32(x480, x447, x474);
    let (x483, x484) = fiat_p384_addcarryx_u32(x482, x449, x471);
    let (x485, x486) = fiat_p384_addcarryx_u32(x484, x451, ((x472 as fiat_p384_u1) as u32));
    let (x487, x488) = fiat_p384_addcarryx_u32(x486, x453, x469);
    let (x489, x490) = fiat_p384_addcarryx_u32(x488, x455, x470);
    let (x491, x492) = fiat_p384_addcarryx_u32(x490, x457, x467);
    let (x493, x494) = fiat_p384_addcarryx_u32(x492, x459, x475);
    let (x495, x496) = fiat_p384_addcarryx_u32(x494, x461, (x476 as u32));
    let (x497, x498) = fiat_p384_addcarryx_u32(x496, x463, (0x0 as u32));
    let (x499, x500) = fiat_p384_addcarryx_u32(x498, x465, (0x0 as u32));
    let (x501, x502) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x503, x504) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x505, x506) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x507, x508) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x509, x510) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x511, x512) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x513, x514) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x515, x516) = fiat_p384_mulx_u32(x477, 0xfffffffe);
    let (x517, x518) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x519, x520) = fiat_p384_mulx_u32(x477, 0xffffffff);
    let (x521, x522) = fiat_p384_addcarryx_u32(0x0, x518, x515);
    let (x523, x524) = fiat_p384_addcarryx_u32(x522, x516, x513);
    let (x525, x526) = fiat_p384_addcarryx_u32(x524, x514, x511);
    let (x527, x528) = fiat_p384_addcarryx_u32(x526, x512, x509);
    let (x529, x530) = fiat_p384_addcarryx_u32(x528, x510, x507);
    let (x531, x532) = fiat_p384_addcarryx_u32(x530, x508, x505);
    let (x533, x534) = fiat_p384_addcarryx_u32(x532, x506, x503);
    let (x535, x536) = fiat_p384_addcarryx_u32(x534, x504, x501);
    let (x537, x538) = fiat_p384_addcarryx_u32(0x0, x477, x519);
    let (x539, x540) = fiat_p384_addcarryx_u32(x538, x479, x520);
    let (x541, x542) = fiat_p384_addcarryx_u32(x540, x481, (0x0 as u32));
    let (x543, x544) = fiat_p384_addcarryx_u32(x542, x483, x517);
    let (x545, x546) = fiat_p384_addcarryx_u32(x544, x485, x521);
    let (x547, x548) = fiat_p384_addcarryx_u32(x546, x487, x523);
    let (x549, x550) = fiat_p384_addcarryx_u32(x548, x489, x525);
    let (x551, x552) = fiat_p384_addcarryx_u32(x550, x491, x527);
    let (x553, x554) = fiat_p384_addcarryx_u32(x552, x493, x529);
    let (x555, x556) = fiat_p384_addcarryx_u32(x554, x495, x531);
    let (x557, x558) = fiat_p384_addcarryx_u32(x556, x497, x533);
    let (x559, x560) = fiat_p384_addcarryx_u32(x558, x499, x535);
    let (x561, x562) = fiat_p384_addcarryx_u32(
        x560,
        ((x500 as u32) + (x466 as u32)),
        ((x536 as u32) + x502),
    );
    let (x563, x564) = fiat_p384_mulx_u32(x6, 0x2);
    let (x565, x566) = fiat_p384_mulx_u32(x6, 0xfffffffe);
    let (x567, x568) = fiat_p384_mulx_u32(x6, 0x2);
    let (x569, x570) = fiat_p384_mulx_u32(x6, 0xfffffffe);
    let (x571, x572) = fiat_p384_addcarryx_u32(0x0, ((x564 as fiat_p384_u1) as u32), x6);
    let (x573, x574) = fiat_p384_addcarryx_u32(0x0, x539, x6);
    let (x575, x576) = fiat_p384_addcarryx_u32(x574, x541, x569);
    let (x577, x578) = fiat_p384_addcarryx_u32(x576, x543, x570);
    let (x579, x580) = fiat_p384_addcarryx_u32(x578, x545, x567);
    let (x581, x582) = fiat_p384_addcarryx_u32(x580, x547, ((x568 as fiat_p384_u1) as u32));
    let (x583, x584) = fiat_p384_addcarryx_u32(x582, x549, x565);
    let (x585, x586) = fiat_p384_addcarryx_u32(x584, x551, x566);
    let (x587, x588) = fiat_p384_addcarryx_u32(x586, x553, x563);
    let (x589, x590) = fiat_p384_addcarryx_u32(x588, x555, x571);
    let (x591, x592) = fiat_p384_addcarryx_u32(x590, x557, (x572 as u32));
    let (x593, x594) = fiat_p384_addcarryx_u32(x592, x559, (0x0 as u32));
    let (x595, x596) = fiat_p384_addcarryx_u32(x594, x561, (0x0 as u32));
    let (x597, x598) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x599, x600) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x601, x602) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x603, x604) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x605, x606) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x607, x608) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x609, x610) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x611, x612) = fiat_p384_mulx_u32(x573, 0xfffffffe);
    let (x613, x614) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x615, x616) = fiat_p384_mulx_u32(x573, 0xffffffff);
    let (x617, x618) = fiat_p384_addcarryx_u32(0x0, x614, x611);
    let (x619, x620) = fiat_p384_addcarryx_u32(x618, x612, x609);
    let (x621, x622) = fiat_p384_addcarryx_u32(x620, x610, x607);
    let (x623, x624) = fiat_p384_addcarryx_u32(x622, x608, x605);
    let (x625, x626) = fiat_p384_addcarryx_u32(x624, x606, x603);
    let (x627, x628) = fiat_p384_addcarryx_u32(x626, x604, x601);
    let (x629, x630) = fiat_p384_addcarryx_u32(x628, x602, x599);
    let (x631, x632) = fiat_p384_addcarryx_u32(x630, x600, x597);
    let (x633, x634) = fiat_p384_addcarryx_u32(0x0, x573, x615);
    let (x635, x636) = fiat_p384_addcarryx_u32(x634, x575, x616);
    let (x637, x638) = fiat_p384_addcarryx_u32(x636, x577, (0x0 as u32));
    let (x639, x640) = fiat_p384_addcarryx_u32(x638, x579, x613);
    let (x641, x642) = fiat_p384_addcarryx_u32(x640, x581, x617);
    let (x643, x644) = fiat_p384_addcarryx_u32(x642, x583, x619);
    let (x645, x646) = fiat_p384_addcarryx_u32(x644, x585, x621);
    let (x647, x648) = fiat_p384_addcarryx_u32(x646, x587, x623);
    let (x649, x650) = fiat_p384_addcarryx_u32(x648, x589, x625);
    let (x651, x652) = fiat_p384_addcarryx_u32(x650, x591, x627);
    let (x653, x654) = fiat_p384_addcarryx_u32(x652, x593, x629);
    let (x655, x656) = fiat_p384_addcarryx_u32(x654, x595, x631);
    let (x657, x658) = fiat_p384_addcarryx_u32(
        x656,
        ((x596 as u32) + (x562 as u32)),
        ((x632 as u32) + x598),
    );
    let (x659, x660) = fiat_p384_mulx_u32(x7, 0x2);
    let (x661, x662) = fiat_p384_mulx_u32(x7, 0xfffffffe);
    let (x663, x664) = fiat_p384_mulx_u32(x7, 0x2);
    let (x665, x666) = fiat_p384_mulx_u32(x7, 0xfffffffe);
    let (x667, x668) = fiat_p384_addcarryx_u32(0x0, ((x660 as fiat_p384_u1) as u32), x7);
    let (x669, x670) = fiat_p384_addcarryx_u32(0x0, x635, x7);
    let (x671, x672) = fiat_p384_addcarryx_u32(x670, x637, x665);
    let (x673, x674) = fiat_p384_addcarryx_u32(x672, x639, x666);
    let (x675, x676) = fiat_p384_addcarryx_u32(x674, x641, x663);
    let (x677, x678) = fiat_p384_addcarryx_u32(x676, x643, ((x664 as fiat_p384_u1) as u32));
    let (x679, x680) = fiat_p384_addcarryx_u32(x678, x645, x661);
    let (x681, x682) = fiat_p384_addcarryx_u32(x680, x647, x662);
    let (x683, x684) = fiat_p384_addcarryx_u32(x682, x649, x659);
    let (x685, x686) = fiat_p384_addcarryx_u32(x684, x651, x667);
    let (x687, x688) = fiat_p384_addcarryx_u32(x686, x653, (x668 as u32));
    let (x689, x690) = fiat_p384_addcarryx_u32(x688, x655, (0x0 as u32));
    let (x691, x692) = fiat_p384_addcarryx_u32(x690, x657, (0x0 as u32));
    let (x693, x694) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x695, x696) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x697, x698) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x699, x700) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x701, x702) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x703, x704) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x705, x706) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x707, x708) = fiat_p384_mulx_u32(x669, 0xfffffffe);
    let (x709, x710) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x711, x712) = fiat_p384_mulx_u32(x669, 0xffffffff);
    let (x713, x714) = fiat_p384_addcarryx_u32(0x0, x710, x707);
    let (x715, x716) = fiat_p384_addcarryx_u32(x714, x708, x705);
    let (x717, x718) = fiat_p384_addcarryx_u32(x716, x706, x703);
    let (x719, x720) = fiat_p384_addcarryx_u32(x718, x704, x701);
    let (x721, x722) = fiat_p384_addcarryx_u32(x720, x702, x699);
    let (x723, x724) = fiat_p384_addcarryx_u32(x722, x700, x697);
    let (x725, x726) = fiat_p384_addcarryx_u32(x724, x698, x695);
    let (x727, x728) = fiat_p384_addcarryx_u32(x726, x696, x693);
    let (x729, x730) = fiat_p384_addcarryx_u32(0x0, x669, x711);
    let (x731, x732) = fiat_p384_addcarryx_u32(x730, x671, x712);
    let (x733, x734) = fiat_p384_addcarryx_u32(x732, x673, (0x0 as u32));
    let (x735, x736) = fiat_p384_addcarryx_u32(x734, x675, x709);
    let (x737, x738) = fiat_p384_addcarryx_u32(x736, x677, x713);
    let (x739, x740) = fiat_p384_addcarryx_u32(x738, x679, x715);
    let (x741, x742) = fiat_p384_addcarryx_u32(x740, x681, x717);
    let (x743, x744) = fiat_p384_addcarryx_u32(x742, x683, x719);
    let (x745, x746) = fiat_p384_addcarryx_u32(x744, x685, x721);
    let (x747, x748) = fiat_p384_addcarryx_u32(x746, x687, x723);
    let (x749, x750) = fiat_p384_addcarryx_u32(x748, x689, x725);
    let (x751, x752) = fiat_p384_addcarryx_u32(x750, x691, x727);
    let (x753, x754) = fiat_p384_addcarryx_u32(
        x752,
        ((x692 as u32) + (x658 as u32)),
        ((x728 as u32) + x694),
    );
    let (x755, x756) = fiat_p384_mulx_u32(x8, 0x2);
    let (x757, x758) = fiat_p384_mulx_u32(x8, 0xfffffffe);
    let (x759, x760) = fiat_p384_mulx_u32(x8, 0x2);
    let (x761, x762) = fiat_p384_mulx_u32(x8, 0xfffffffe);
    let (x763, x764) = fiat_p384_addcarryx_u32(0x0, ((x756 as fiat_p384_u1) as u32), x8);
    let (x765, x766) = fiat_p384_addcarryx_u32(0x0, x731, x8);
    let (x767, x768) = fiat_p384_addcarryx_u32(x766, x733, x761);
    let (x769, x770) = fiat_p384_addcarryx_u32(x768, x735, x762);
    let (x771, x772) = fiat_p384_addcarryx_u32(x770, x737, x759);
    let (x773, x774) = fiat_p384_addcarryx_u32(x772, x739, ((x760 as fiat_p384_u1) as u32));
    let (x775, x776) = fiat_p384_addcarryx_u32(x774, x741, x757);
    let (x777, x778) = fiat_p384_addcarryx_u32(x776, x743, x758);
    let (x779, x780) = fiat_p384_addcarryx_u32(x778, x745, x755);
    let (x781, x782) = fiat_p384_addcarryx_u32(x780, x747, x763);
    let (x783, x784) = fiat_p384_addcarryx_u32(x782, x749, (x764 as u32));
    let (x785, x786) = fiat_p384_addcarryx_u32(x784, x751, (0x0 as u32));
    let (x787, x788) = fiat_p384_addcarryx_u32(x786, x753, (0x0 as u32));
    let (x789, x790) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x791, x792) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x793, x794) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x795, x796) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x797, x798) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x799, x800) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x801, x802) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x803, x804) = fiat_p384_mulx_u32(x765, 0xfffffffe);
    let (x805, x806) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x807, x808) = fiat_p384_mulx_u32(x765, 0xffffffff);
    let (x809, x810) = fiat_p384_addcarryx_u32(0x0, x806, x803);
    let (x811, x812) = fiat_p384_addcarryx_u32(x810, x804, x801);
    let (x813, x814) = fiat_p384_addcarryx_u32(x812, x802, x799);
    let (x815, x816) = fiat_p384_addcarryx_u32(x814, x800, x797);
    let (x817, x818) = fiat_p384_addcarryx_u32(x816, x798, x795);
    let (x819, x820) = fiat_p384_addcarryx_u32(x818, x796, x793);
    let (x821, x822) = fiat_p384_addcarryx_u32(x820, x794, x791);
    let (x823, x824) = fiat_p384_addcarryx_u32(x822, x792, x789);
    let (x825, x826) = fiat_p384_addcarryx_u32(0x0, x765, x807);
    let (x827, x828) = fiat_p384_addcarryx_u32(x826, x767, x808);
    let (x829, x830) = fiat_p384_addcarryx_u32(x828, x769, (0x0 as u32));
    let (x831, x832) = fiat_p384_addcarryx_u32(x830, x771, x805);
    let (x833, x834) = fiat_p384_addcarryx_u32(x832, x773, x809);
    let (x835, x836) = fiat_p384_addcarryx_u32(x834, x775, x811);
    let (x837, x838) = fiat_p384_addcarryx_u32(x836, x777, x813);
    let (x839, x840) = fiat_p384_addcarryx_u32(x838, x779, x815);
    let (x841, x842) = fiat_p384_addcarryx_u32(x840, x781, x817);
    let (x843, x844) = fiat_p384_addcarryx_u32(x842, x783, x819);
    let (x845, x846) = fiat_p384_addcarryx_u32(x844, x785, x821);
    let (x847, x848) = fiat_p384_addcarryx_u32(x846, x787, x823);
    let (x849, x850) = fiat_p384_addcarryx_u32(
        x848,
        ((x788 as u32) + (x754 as u32)),
        ((x824 as u32) + x790),
    );
    let (x851, x852) = fiat_p384_mulx_u32(x9, 0x2);
    let (x853, x854) = fiat_p384_mulx_u32(x9, 0xfffffffe);
    let (x855, x856) = fiat_p384_mulx_u32(x9, 0x2);
    let (x857, x858) = fiat_p384_mulx_u32(x9, 0xfffffffe);
    let (x859, x860) = fiat_p384_addcarryx_u32(0x0, ((x852 as fiat_p384_u1) as u32), x9);
    let (x861, x862) = fiat_p384_addcarryx_u32(0x0, x827, x9);
    let (x863, x864) = fiat_p384_addcarryx_u32(x862, x829, x857);
    let (x865, x866) = fiat_p384_addcarryx_u32(x864, x831, x858);
    let (x867, x868) = fiat_p384_addcarryx_u32(x866, x833, x855);
    let (x869, x870) = fiat_p384_addcarryx_u32(x868, x835, ((x856 as fiat_p384_u1) as u32));
    let (x871, x872) = fiat_p384_addcarryx_u32(x870, x837, x853);
    let (x873, x874) = fiat_p384_addcarryx_u32(x872, x839, x854);
    let (x875, x876) = fiat_p384_addcarryx_u32(x874, x841, x851);
    let (x877, x878) = fiat_p384_addcarryx_u32(x876, x843, x859);
    let (x879, x880) = fiat_p384_addcarryx_u32(x878, x845, (x860 as u32));
    let (x881, x882) = fiat_p384_addcarryx_u32(x880, x847, (0x0 as u32));
    let (x883, x884) = fiat_p384_addcarryx_u32(x882, x849, (0x0 as u32));
    let (x885, x886) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x887, x888) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x889, x890) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x891, x892) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x893, x894) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x895, x896) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x897, x898) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x899, x900) = fiat_p384_mulx_u32(x861, 0xfffffffe);
    let (x901, x902) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x903, x904) = fiat_p384_mulx_u32(x861, 0xffffffff);
    let (x905, x906) = fiat_p384_addcarryx_u32(0x0, x902, x899);
    let (x907, x908) = fiat_p384_addcarryx_u32(x906, x900, x897);
    let (x909, x910) = fiat_p384_addcarryx_u32(x908, x898, x895);
    let (x911, x912) = fiat_p384_addcarryx_u32(x910, x896, x893);
    let (x913, x914) = fiat_p384_addcarryx_u32(x912, x894, x891);
    let (x915, x916) = fiat_p384_addcarryx_u32(x914, x892, x889);
    let (x917, x918) = fiat_p384_addcarryx_u32(x916, x890, x887);
    let (x919, x920) = fiat_p384_addcarryx_u32(x918, x888, x885);
    let (x921, x922) = fiat_p384_addcarryx_u32(0x0, x861, x903);
    let (x923, x924) = fiat_p384_addcarryx_u32(x922, x863, x904);
    let (x925, x926) = fiat_p384_addcarryx_u32(x924, x865, (0x0 as u32));
    let (x927, x928) = fiat_p384_addcarryx_u32(x926, x867, x901);
    let (x929, x930) = fiat_p384_addcarryx_u32(x928, x869, x905);
    let (x931, x932) = fiat_p384_addcarryx_u32(x930, x871, x907);
    let (x933, x934) = fiat_p384_addcarryx_u32(x932, x873, x909);
    let (x935, x936) = fiat_p384_addcarryx_u32(x934, x875, x911);
    let (x937, x938) = fiat_p384_addcarryx_u32(x936, x877, x913);
    let (x939, x940) = fiat_p384_addcarryx_u32(x938, x879, x915);
    let (x941, x942) = fiat_p384_addcarryx_u32(x940, x881, x917);
    let (x943, x944) = fiat_p384_addcarryx_u32(x942, x883, x919);
    let (x945, x946) = fiat_p384_addcarryx_u32(
        x944,
        ((x884 as u32) + (x850 as u32)),
        ((x920 as u32) + x886),
    );
    let (x947, x948) = fiat_p384_mulx_u32(x10, 0x2);
    let (x949, x950) = fiat_p384_mulx_u32(x10, 0xfffffffe);
    let (x951, x952) = fiat_p384_mulx_u32(x10, 0x2);
    let (x953, x954) = fiat_p384_mulx_u32(x10, 0xfffffffe);
    let (x955, x956) = fiat_p384_addcarryx_u32(0x0, ((x948 as fiat_p384_u1) as u32), x10);
    let (x957, x958) = fiat_p384_addcarryx_u32(0x0, x923, x10);
    let (x959, x960) = fiat_p384_addcarryx_u32(x958, x925, x953);
    let (x961, x962) = fiat_p384_addcarryx_u32(x960, x927, x954);
    let (x963, x964) = fiat_p384_addcarryx_u32(x962, x929, x951);
    let (x965, x966) = fiat_p384_addcarryx_u32(x964, x931, ((x952 as fiat_p384_u1) as u32));
    let (x967, x968) = fiat_p384_addcarryx_u32(x966, x933, x949);
    let (x969, x970) = fiat_p384_addcarryx_u32(x968, x935, x950);
    let (x971, x972) = fiat_p384_addcarryx_u32(x970, x937, x947);
    let (x973, x974) = fiat_p384_addcarryx_u32(x972, x939, x955);
    let (x975, x976) = fiat_p384_addcarryx_u32(x974, x941, (x956 as u32));
    let (x977, x978) = fiat_p384_addcarryx_u32(x976, x943, (0x0 as u32));
    let (x979, x980) = fiat_p384_addcarryx_u32(x978, x945, (0x0 as u32));
    let (x981, x982) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x983, x984) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x985, x986) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x987, x988) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x989, x990) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x991, x992) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x993, x994) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x995, x996) = fiat_p384_mulx_u32(x957, 0xfffffffe);
    let (x997, x998) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x999, x1000) = fiat_p384_mulx_u32(x957, 0xffffffff);
    let (x1001, x1002) = fiat_p384_addcarryx_u32(0x0, x998, x995);
    let (x1003, x1004) = fiat_p384_addcarryx_u32(x1002, x996, x993);
    let (x1005, x1006) = fiat_p384_addcarryx_u32(x1004, x994, x991);
    let (x1007, x1008) = fiat_p384_addcarryx_u32(x1006, x992, x989);
    let (x1009, x1010) = fiat_p384_addcarryx_u32(x1008, x990, x987);
    let (x1011, x1012) = fiat_p384_addcarryx_u32(x1010, x988, x985);
    let (x1013, x1014) = fiat_p384_addcarryx_u32(x1012, x986, x983);
    let (x1015, x1016) = fiat_p384_addcarryx_u32(x1014, x984, x981);
    let (x1017, x1018) = fiat_p384_addcarryx_u32(0x0, x957, x999);
    let (x1019, x1020) = fiat_p384_addcarryx_u32(x1018, x959, x1000);
    let (x1021, x1022) = fiat_p384_addcarryx_u32(x1020, x961, (0x0 as u32));
    let (x1023, x1024) = fiat_p384_addcarryx_u32(x1022, x963, x997);
    let (x1025, x1026) = fiat_p384_addcarryx_u32(x1024, x965, x1001);
    let (x1027, x1028) = fiat_p384_addcarryx_u32(x1026, x967, x1003);
    let (x1029, x1030) = fiat_p384_addcarryx_u32(x1028, x969, x1005);
    let (x1031, x1032) = fiat_p384_addcarryx_u32(x1030, x971, x1007);
    let (x1033, x1034) = fiat_p384_addcarryx_u32(x1032, x973, x1009);
    let (x1035, x1036) = fiat_p384_addcarryx_u32(x1034, x975, x1011);
    let (x1037, x1038) = fiat_p384_addcarryx_u32(x1036, x977, x1013);
    let (x1039, x1040) = fiat_p384_addcarryx_u32(x1038, x979, x1015);
    let (x1041, x1042) = fiat_p384_addcarryx_u32(
        x1040,
        ((x980 as u32) + (x946 as u32)),
        ((x1016 as u32) + x982),
    );
    let (x1043, x1044) = fiat_p384_mulx_u32(x11, 0x2);
    let (x1045, x1046) = fiat_p384_mulx_u32(x11, 0xfffffffe);
    let (x1047, x1048) = fiat_p384_mulx_u32(x11, 0x2);
    let (x1049, x1050) = fiat_p384_mulx_u32(x11, 0xfffffffe);
    let (x1051, x1052) = fiat_p384_addcarryx_u32(0x0, ((x1044 as fiat_p384_u1) as u32), x11);
    let (x1053, x1054) = fiat_p384_addcarryx_u32(0x0, x1019, x11);
    let (x1055, x1056) = fiat_p384_addcarryx_u32(x1054, x1021, x1049);
    let (x1057, x1058) = fiat_p384_addcarryx_u32(x1056, x1023, x1050);
    let (x1059, x1060) = fiat_p384_addcarryx_u32(x1058, x1025, x1047);
    let (x1061, x1062) = fiat_p384_addcarryx_u32(x1060, x1027, ((x1048 as fiat_p384_u1) as u32));
    let (x1063, x1064) = fiat_p384_addcarryx_u32(x1062, x1029, x1045);
    let (x1065, x1066) = fiat_p384_addcarryx_u32(x1064, x1031, x1046);
    let (x1067, x1068) = fiat_p384_addcarryx_u32(x1066, x1033, x1043);
    let (x1069, x1070) = fiat_p384_addcarryx_u32(x1068, x1035, x1051);
    let (x1071, x1072) = fiat_p384_addcarryx_u32(x1070, x1037, (x1052 as u32));
    let (x1073, x1074) = fiat_p384_addcarryx_u32(x1072, x1039, (0x0 as u32));
    let (x1075, x1076) = fiat_p384_addcarryx_u32(x1074, x1041, (0x0 as u32));
    let (x1077, x1078) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1079, x1080) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1081, x1082) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1083, x1084) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1085, x1086) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1087, x1088) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1089, x1090) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1091, x1092) = fiat_p384_mulx_u32(x1053, 0xfffffffe);
    let (x1093, x1094) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1095, x1096) = fiat_p384_mulx_u32(x1053, 0xffffffff);
    let (x1097, x1098) = fiat_p384_addcarryx_u32(0x0, x1094, x1091);
    let (x1099, x1100) = fiat_p384_addcarryx_u32(x1098, x1092, x1089);
    let (x1101, x1102) = fiat_p384_addcarryx_u32(x1100, x1090, x1087);
    let (x1103, x1104) = fiat_p384_addcarryx_u32(x1102, x1088, x1085);
    let (x1105, x1106) = fiat_p384_addcarryx_u32(x1104, x1086, x1083);
    let (x1107, x1108) = fiat_p384_addcarryx_u32(x1106, x1084, x1081);
    let (x1109, x1110) = fiat_p384_addcarryx_u32(x1108, x1082, x1079);
    let (x1111, x1112) = fiat_p384_addcarryx_u32(x1110, x1080, x1077);
    let (x1113, x1114) = fiat_p384_addcarryx_u32(0x0, x1053, x1095);
    let (x1115, x1116) = fiat_p384_addcarryx_u32(x1114, x1055, x1096);
    let (x1117, x1118) = fiat_p384_addcarryx_u32(x1116, x1057, (0x0 as u32));
    let (x1119, x1120) = fiat_p384_addcarryx_u32(x1118, x1059, x1093);
    let (x1121, x1122) = fiat_p384_addcarryx_u32(x1120, x1061, x1097);
    let (x1123, x1124) = fiat_p384_addcarryx_u32(x1122, x1063, x1099);
    let (x1125, x1126) = fiat_p384_addcarryx_u32(x1124, x1065, x1101);
    let (x1127, x1128) = fiat_p384_addcarryx_u32(x1126, x1067, x1103);
    let (x1129, x1130) = fiat_p384_addcarryx_u32(x1128, x1069, x1105);
    let (x1131, x1132) = fiat_p384_addcarryx_u32(x1130, x1071, x1107);
    let (x1133, x1134) = fiat_p384_addcarryx_u32(x1132, x1073, x1109);
    let (x1135, x1136) = fiat_p384_addcarryx_u32(x1134, x1075, x1111);
    let (x1137, x1138) = fiat_p384_addcarryx_u32(
        x1136,
        ((x1076 as u32) + (x1042 as u32)),
        ((x1112 as u32) + x1078),
    );
    let (x1139, x1140) = fiat_p384_subborrowx_u32(0x0, x1115, 0xffffffff);
    let (x1141, x1142) = fiat_p384_subborrowx_u32(x1140, x1117, (0x0 as u32));
    let (x1143, x1144) = fiat_p384_subborrowx_u32(x1142, x1119, (0x0 as u32));
    let (x1145, x1146) = fiat_p384_subborrowx_u32(x1144, x1121, 0xffffffff);
    let (x1147, x1148) = fiat_p384_subborrowx_u32(x1146, x1123, 0xfffffffe);
    let (x1149, x1150) = fiat_p384_subborrowx_u32(x1148, x1125, 0xffffffff);
    let (x1151, x1152) = fiat_p384_subborrowx_u32(x1150, x1127, 0xffffffff);
    let (x1153, x1154) = fiat_p384_subborrowx_u32(x1152, x1129, 0xffffffff);
    let (x1155, x1156) = fiat_p384_subborrowx_u32(x1154, x1131, 0xffffffff);
    let (x1157, x1158) = fiat_p384_subborrowx_u32(x1156, x1133, 0xffffffff);
    let (x1159, x1160) = fiat_p384_subborrowx_u32(x1158, x1135, 0xffffffff);
    let (x1161, x1162) = fiat_p384_subborrowx_u32(x1160, x1137, 0xffffffff);
    let (x1163, x1164) = fiat_p384_subborrowx_u32(x1162, (x1138 as u32), (0x0 as u32));
    let (x1165) = fiat_p384_cmovznz_u32(x1164, x1139, x1115);
    let (x1166) = fiat_p384_cmovznz_u32(x1164, x1141, x1117);
    let (x1167) = fiat_p384_cmovznz_u32(x1164, x1143, x1119);
    let (x1168) = fiat_p384_cmovznz_u32(x1164, x1145, x1121);
    let (x1169) = fiat_p384_cmovznz_u32(x1164, x1147, x1123);
    let (x1170) = fiat_p384_cmovznz_u32(x1164, x1149, x1125);
    let (x1171) = fiat_p384_cmovznz_u32(x1164, x1151, x1127);
    let (x1172) = fiat_p384_cmovznz_u32(x1164, x1153, x1129);
    let (x1173) = fiat_p384_cmovznz_u32(x1164, x1155, x1131);
    let (x1174) = fiat_p384_cmovznz_u32(x1164, x1157, x1133);
    let (x1175) = fiat_p384_cmovznz_u32(x1164, x1159, x1135);
    let (x1176) = fiat_p384_cmovznz_u32(x1164, x1161, x1137);
    out1[0] = x1165;
    out1[1] = x1166;
    out1[2] = x1167;
    out1[3] = x1168;
    out1[4] = x1169;
    out1[5] = x1170;
    out1[6] = x1171;
    out1[7] = x1172;
    out1[8] = x1173;
    out1[9] = x1174;
    out1[10] = x1175;
    out1[11] = x1176;
    out1
}
#[doc = " The function fiat_p384_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_nonzero(arg1: &[u32; 12]) -> u32 {
    let mut out1: u32 = 0;
    let x1: u32 = ((arg1[0])
        | ((arg1[1])
            | ((arg1[2])
                | ((arg1[3])
                    | ((arg1[4])
                        | ((arg1[5])
                            | ((arg1[6])
                                | ((arg1[7])
                                    | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | (arg1[11]))))))))))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p384_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_selectznz(
    arg1: fiat_p384_u1,
    arg2: &[u32; 12],
    arg3: &[u32; 12],
) -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    let (x1) = fiat_p384_cmovznz_u32(arg1, (arg2[0]), (arg3[0]));
    let (x2) = fiat_p384_cmovznz_u32(arg1, (arg2[1]), (arg3[1]));
    let (x3) = fiat_p384_cmovznz_u32(arg1, (arg2[2]), (arg3[2]));
    let (x4) = fiat_p384_cmovznz_u32(arg1, (arg2[3]), (arg3[3]));
    let (x5) = fiat_p384_cmovznz_u32(arg1, (arg2[4]), (arg3[4]));
    let (x6) = fiat_p384_cmovznz_u32(arg1, (arg2[5]), (arg3[5]));
    let (x7) = fiat_p384_cmovznz_u32(arg1, (arg2[6]), (arg3[6]));
    let (x8) = fiat_p384_cmovznz_u32(arg1, (arg2[7]), (arg3[7]));
    let (x9) = fiat_p384_cmovznz_u32(arg1, (arg2[8]), (arg3[8]));
    let (x10) = fiat_p384_cmovznz_u32(arg1, (arg2[9]), (arg3[9]));
    let (x11) = fiat_p384_cmovznz_u32(arg1, (arg2[10]), (arg3[10]));
    let (x12) = fiat_p384_cmovznz_u32(arg1, (arg2[11]), (arg3[11]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1
}
#[doc = " The function fiat_p384_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[inline]
pub const fn fiat_p384_to_bytes(arg1: &[u32; 12]) -> [u8; 48] {
    let mut out1: [u8; 48] = [0; 48];
    let x1: u32 = (arg1[11]);
    let x2: u32 = (arg1[10]);
    let x3: u32 = (arg1[9]);
    let x4: u32 = (arg1[8]);
    let x5: u32 = (arg1[7]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[5]);
    let x8: u32 = (arg1[4]);
    let x9: u32 = (arg1[3]);
    let x10: u32 = (arg1[2]);
    let x11: u32 = (arg1[1]);
    let x12: u32 = (arg1[0]);
    let x13: u8 = ((x12 & (0xff as u32)) as u8);
    let x14: u32 = (x12 >> 8);
    let x15: u8 = ((x14 & (0xff as u32)) as u8);
    let x16: u32 = (x14 >> 8);
    let x17: u8 = ((x16 & (0xff as u32)) as u8);
    let x18: u8 = ((x16 >> 8) as u8);
    let x19: u8 = ((x11 & (0xff as u32)) as u8);
    let x20: u32 = (x11 >> 8);
    let x21: u8 = ((x20 & (0xff as u32)) as u8);
    let x22: u32 = (x20 >> 8);
    let x23: u8 = ((x22 & (0xff as u32)) as u8);
    let x24: u8 = ((x22 >> 8) as u8);
    let x25: u8 = ((x10 & (0xff as u32)) as u8);
    let x26: u32 = (x10 >> 8);
    let x27: u8 = ((x26 & (0xff as u32)) as u8);
    let x28: u32 = (x26 >> 8);
    let x29: u8 = ((x28 & (0xff as u32)) as u8);
    let x30: u8 = ((x28 >> 8) as u8);
    let x31: u8 = ((x9 & (0xff as u32)) as u8);
    let x32: u32 = (x9 >> 8);
    let x33: u8 = ((x32 & (0xff as u32)) as u8);
    let x34: u32 = (x32 >> 8);
    let x35: u8 = ((x34 & (0xff as u32)) as u8);
    let x36: u8 = ((x34 >> 8) as u8);
    let x37: u8 = ((x8 & (0xff as u32)) as u8);
    let x38: u32 = (x8 >> 8);
    let x39: u8 = ((x38 & (0xff as u32)) as u8);
    let x40: u32 = (x38 >> 8);
    let x41: u8 = ((x40 & (0xff as u32)) as u8);
    let x42: u8 = ((x40 >> 8) as u8);
    let x43: u8 = ((x7 & (0xff as u32)) as u8);
    let x44: u32 = (x7 >> 8);
    let x45: u8 = ((x44 & (0xff as u32)) as u8);
    let x46: u32 = (x44 >> 8);
    let x47: u8 = ((x46 & (0xff as u32)) as u8);
    let x48: u8 = ((x46 >> 8) as u8);
    let x49: u8 = ((x6 & (0xff as u32)) as u8);
    let x50: u32 = (x6 >> 8);
    let x51: u8 = ((x50 & (0xff as u32)) as u8);
    let x52: u32 = (x50 >> 8);
    let x53: u8 = ((x52 & (0xff as u32)) as u8);
    let x54: u8 = ((x52 >> 8) as u8);
    let x55: u8 = ((x5 & (0xff as u32)) as u8);
    let x56: u32 = (x5 >> 8);
    let x57: u8 = ((x56 & (0xff as u32)) as u8);
    let x58: u32 = (x56 >> 8);
    let x59: u8 = ((x58 & (0xff as u32)) as u8);
    let x60: u8 = ((x58 >> 8) as u8);
    let x61: u8 = ((x4 & (0xff as u32)) as u8);
    let x62: u32 = (x4 >> 8);
    let x63: u8 = ((x62 & (0xff as u32)) as u8);
    let x64: u32 = (x62 >> 8);
    let x65: u8 = ((x64 & (0xff as u32)) as u8);
    let x66: u8 = ((x64 >> 8) as u8);
    let x67: u8 = ((x3 & (0xff as u32)) as u8);
    let x68: u32 = (x3 >> 8);
    let x69: u8 = ((x68 & (0xff as u32)) as u8);
    let x70: u32 = (x68 >> 8);
    let x71: u8 = ((x70 & (0xff as u32)) as u8);
    let x72: u8 = ((x70 >> 8) as u8);
    let x73: u8 = ((x2 & (0xff as u32)) as u8);
    let x74: u32 = (x2 >> 8);
    let x75: u8 = ((x74 & (0xff as u32)) as u8);
    let x76: u32 = (x74 >> 8);
    let x77: u8 = ((x76 & (0xff as u32)) as u8);
    let x78: u8 = ((x76 >> 8) as u8);
    let x79: u8 = ((x1 & (0xff as u32)) as u8);
    let x80: u32 = (x1 >> 8);
    let x81: u8 = ((x80 & (0xff as u32)) as u8);
    let x82: u32 = (x80 >> 8);
    let x83: u8 = ((x82 & (0xff as u32)) as u8);
    let x84: u8 = ((x82 >> 8) as u8);
    out1[0] = x13;
    out1[1] = x15;
    out1[2] = x17;
    out1[3] = x18;
    out1[4] = x19;
    out1[5] = x21;
    out1[6] = x23;
    out1[7] = x24;
    out1[8] = x25;
    out1[9] = x27;
    out1[10] = x29;
    out1[11] = x30;
    out1[12] = x31;
    out1[13] = x33;
    out1[14] = x35;
    out1[15] = x36;
    out1[16] = x37;
    out1[17] = x39;
    out1[18] = x41;
    out1[19] = x42;
    out1[20] = x43;
    out1[21] = x45;
    out1[22] = x47;
    out1[23] = x48;
    out1[24] = x49;
    out1[25] = x51;
    out1[26] = x53;
    out1[27] = x54;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
    out1[32] = x61;
    out1[33] = x63;
    out1[34] = x65;
    out1[35] = x66;
    out1[36] = x67;
    out1[37] = x69;
    out1[38] = x71;
    out1[39] = x72;
    out1[40] = x73;
    out1[41] = x75;
    out1[42] = x77;
    out1[43] = x78;
    out1[44] = x79;
    out1[45] = x81;
    out1[46] = x83;
    out1[47] = x84;
    out1
}
#[doc = " The function fiat_p384_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_from_bytes(arg1: &[u8; 48]) -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    let x1: u32 = (((arg1[47]) as u32) << 24);
    let x2: u32 = (((arg1[46]) as u32) << 16);
    let x3: u32 = (((arg1[45]) as u32) << 8);
    let x4: u8 = (arg1[44]);
    let x5: u32 = (((arg1[43]) as u32) << 24);
    let x6: u32 = (((arg1[42]) as u32) << 16);
    let x7: u32 = (((arg1[41]) as u32) << 8);
    let x8: u8 = (arg1[40]);
    let x9: u32 = (((arg1[39]) as u32) << 24);
    let x10: u32 = (((arg1[38]) as u32) << 16);
    let x11: u32 = (((arg1[37]) as u32) << 8);
    let x12: u8 = (arg1[36]);
    let x13: u32 = (((arg1[35]) as u32) << 24);
    let x14: u32 = (((arg1[34]) as u32) << 16);
    let x15: u32 = (((arg1[33]) as u32) << 8);
    let x16: u8 = (arg1[32]);
    let x17: u32 = (((arg1[31]) as u32) << 24);
    let x18: u32 = (((arg1[30]) as u32) << 16);
    let x19: u32 = (((arg1[29]) as u32) << 8);
    let x20: u8 = (arg1[28]);
    let x21: u32 = (((arg1[27]) as u32) << 24);
    let x22: u32 = (((arg1[26]) as u32) << 16);
    let x23: u32 = (((arg1[25]) as u32) << 8);
    let x24: u8 = (arg1[24]);
    let x25: u32 = (((arg1[23]) as u32) << 24);
    let x26: u32 = (((arg1[22]) as u32) << 16);
    let x27: u32 = (((arg1[21]) as u32) << 8);
    let x28: u8 = (arg1[20]);
    let x29: u32 = (((arg1[19]) as u32) << 24);
    let x30: u32 = (((arg1[18]) as u32) << 16);
    let x31: u32 = (((arg1[17]) as u32) << 8);
    let x32: u8 = (arg1[16]);
    let x33: u32 = (((arg1[15]) as u32) << 24);
    let x34: u32 = (((arg1[14]) as u32) << 16);
    let x35: u32 = (((arg1[13]) as u32) << 8);
    let x36: u8 = (arg1[12]);
    let x37: u32 = (((arg1[11]) as u32) << 24);
    let x38: u32 = (((arg1[10]) as u32) << 16);
    let x39: u32 = (((arg1[9]) as u32) << 8);
    let x40: u8 = (arg1[8]);
    let x41: u32 = (((arg1[7]) as u32) << 24);
    let x42: u32 = (((arg1[6]) as u32) << 16);
    let x43: u32 = (((arg1[5]) as u32) << 8);
    let x44: u8 = (arg1[4]);
    let x45: u32 = (((arg1[3]) as u32) << 24);
    let x46: u32 = (((arg1[2]) as u32) << 16);
    let x47: u32 = (((arg1[1]) as u32) << 8);
    let x48: u8 = (arg1[0]);
    let x49: u32 = (x47 + (x48 as u32));
    let x50: u32 = (x46 + x49);
    let x51: u32 = (x45 + x50);
    let x52: u32 = (x43 + (x44 as u32));
    let x53: u32 = (x42 + x52);
    let x54: u32 = (x41 + x53);
    let x55: u32 = (x39 + (x40 as u32));
    let x56: u32 = (x38 + x55);
    let x57: u32 = (x37 + x56);
    let x58: u32 = (x35 + (x36 as u32));
    let x59: u32 = (x34 + x58);
    let x60: u32 = (x33 + x59);
    let x61: u32 = (x31 + (x32 as u32));
    let x62: u32 = (x30 + x61);
    let x63: u32 = (x29 + x62);
    let x64: u32 = (x27 + (x28 as u32));
    let x65: u32 = (x26 + x64);
    let x66: u32 = (x25 + x65);
    let x67: u32 = (x23 + (x24 as u32));
    let x68: u32 = (x22 + x67);
    let x69: u32 = (x21 + x68);
    let x70: u32 = (x19 + (x20 as u32));
    let x71: u32 = (x18 + x70);
    let x72: u32 = (x17 + x71);
    let x73: u32 = (x15 + (x16 as u32));
    let x74: u32 = (x14 + x73);
    let x75: u32 = (x13 + x74);
    let x76: u32 = (x11 + (x12 as u32));
    let x77: u32 = (x10 + x76);
    let x78: u32 = (x9 + x77);
    let x79: u32 = (x7 + (x8 as u32));
    let x80: u32 = (x6 + x79);
    let x81: u32 = (x5 + x80);
    let x82: u32 = (x3 + (x4 as u32));
    let x83: u32 = (x2 + x82);
    let x84: u32 = (x1 + x83);
    out1[0] = x51;
    out1[1] = x54;
    out1[2] = x57;
    out1[3] = x60;
    out1[4] = x63;
    out1[5] = x66;
    out1[6] = x69;
    out1[7] = x72;
    out1[8] = x75;
    out1[9] = x78;
    out1[10] = x81;
    out1[11] = x84;
    out1
}
#[doc = " The function fiat_p384_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_set_one() -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 12];
    out1[0] = (0x1 as u32);
    out1[1] = 0xffffffff;
    out1[2] = 0xffffffff;
    out1[3] = (0x0 as u32);
    out1[4] = (0x1 as u32);
    out1[5] = (0x0 as u32);
    out1[6] = (0x0 as u32);
    out1[7] = (0x0 as u32);
    out1[8] = (0x0 as u32);
    out1[9] = (0x0 as u32);
    out1[10] = (0x0 as u32);
    out1[11] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p384_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_msat() -> [u32; 13] {
    let mut out1: [u32; 13] = [0; 13];
    out1[0] = 0xffffffff;
    out1[1] = (0x0 as u32);
    out1[2] = (0x0 as u32);
    out1[3] = 0xffffffff;
    out1[4] = 0xfffffffe;
    out1[5] = 0xffffffff;
    out1[6] = 0xffffffff;
    out1[7] = 0xffffffff;
    out1[8] = 0xffffffff;
    out1[9] = 0xffffffff;
    out1[10] = 0xffffffff;
    out1[11] = 0xffffffff;
    out1[12] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p384_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_divstep(
    arg1: u32,
    arg2: &[u32; 13],
    arg3: &[u32; 13],
    arg4: &[u32; 12],
    arg5: &[u32; 12],
) -> (u32, [u32; 13], [u32; 13], [u32; 12], [u32; 12]) {
    let mut out1: u32 = 0;
    let mut out2: [u32; 13] = [0; 13];
    let mut out3: [u32; 13] = [0; 13];
    let mut out4: [u32; 12] = [0; 12];
    let mut out5: [u32; 12] = [0; 12];
    let (x1, x2) = fiat_p384_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let x3: fiat_p384_u1 =
        (((x1 >> 31) as fiat_p384_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p384_u1));
    let (x4, x5) = fiat_p384_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let (x6) = fiat_p384_cmovznz_u32(x3, arg1, x4);
    let (x7) = fiat_p384_cmovznz_u32(x3, (arg2[0]), (arg3[0]));
    let (x8) = fiat_p384_cmovznz_u32(x3, (arg2[1]), (arg3[1]));
    let (x9) = fiat_p384_cmovznz_u32(x3, (arg2[2]), (arg3[2]));
    let (x10) = fiat_p384_cmovznz_u32(x3, (arg2[3]), (arg3[3]));
    let (x11) = fiat_p384_cmovznz_u32(x3, (arg2[4]), (arg3[4]));
    let (x12) = fiat_p384_cmovznz_u32(x3, (arg2[5]), (arg3[5]));
    let (x13) = fiat_p384_cmovznz_u32(x3, (arg2[6]), (arg3[6]));
    let (x14) = fiat_p384_cmovznz_u32(x3, (arg2[7]), (arg3[7]));
    let (x15) = fiat_p384_cmovznz_u32(x3, (arg2[8]), (arg3[8]));
    let (x16) = fiat_p384_cmovznz_u32(x3, (arg2[9]), (arg3[9]));
    let (x17) = fiat_p384_cmovznz_u32(x3, (arg2[10]), (arg3[10]));
    let (x18) = fiat_p384_cmovznz_u32(x3, (arg2[11]), (arg3[11]));
    let (x19) = fiat_p384_cmovznz_u32(x3, (arg2[12]), (arg3[12]));
    let (x20, x21) = fiat_p384_addcarryx_u32(0x0, (0x1 as u32), (!(arg2[0])));
    let (x22, x23) = fiat_p384_addcarryx_u32(x21, (0x0 as u32), (!(arg2[1])));
    let (x24, x25) = fiat_p384_addcarryx_u32(x23, (0x0 as u32), (!(arg2[2])));
    let (x26, x27) = fiat_p384_addcarryx_u32(x25, (0x0 as u32), (!(arg2[3])));
    let (x28, x29) = fiat_p384_addcarryx_u32(x27, (0x0 as u32), (!(arg2[4])));
    let (x30, x31) = fiat_p384_addcarryx_u32(x29, (0x0 as u32), (!(arg2[5])));
    let (x32, x33) = fiat_p384_addcarryx_u32(x31, (0x0 as u32), (!(arg2[6])));
    let (x34, x35) = fiat_p384_addcarryx_u32(x33, (0x0 as u32), (!(arg2[7])));
    let (x36, x37) = fiat_p384_addcarryx_u32(x35, (0x0 as u32), (!(arg2[8])));
    let (x38, x39) = fiat_p384_addcarryx_u32(x37, (0x0 as u32), (!(arg2[9])));
    let (x40, x41) = fiat_p384_addcarryx_u32(x39, (0x0 as u32), (!(arg2[10])));
    let (x42, x43) = fiat_p384_addcarryx_u32(x41, (0x0 as u32), (!(arg2[11])));
    let (x44, x45) = fiat_p384_addcarryx_u32(x43, (0x0 as u32), (!(arg2[12])));
    let (x46) = fiat_p384_cmovznz_u32(x3, (arg3[0]), x20);
    let (x47) = fiat_p384_cmovznz_u32(x3, (arg3[1]), x22);
    let (x48) = fiat_p384_cmovznz_u32(x3, (arg3[2]), x24);
    let (x49) = fiat_p384_cmovznz_u32(x3, (arg3[3]), x26);
    let (x50) = fiat_p384_cmovznz_u32(x3, (arg3[4]), x28);
    let (x51) = fiat_p384_cmovznz_u32(x3, (arg3[5]), x30);
    let (x52) = fiat_p384_cmovznz_u32(x3, (arg3[6]), x32);
    let (x53) = fiat_p384_cmovznz_u32(x3, (arg3[7]), x34);
    let (x54) = fiat_p384_cmovznz_u32(x3, (arg3[8]), x36);
    let (x55) = fiat_p384_cmovznz_u32(x3, (arg3[9]), x38);
    let (x56) = fiat_p384_cmovznz_u32(x3, (arg3[10]), x40);
    let (x57) = fiat_p384_cmovznz_u32(x3, (arg3[11]), x42);
    let (x58) = fiat_p384_cmovznz_u32(x3, (arg3[12]), x44);
    let (x59) = fiat_p384_cmovznz_u32(x3, (arg4[0]), (arg5[0]));
    let (x60) = fiat_p384_cmovznz_u32(x3, (arg4[1]), (arg5[1]));
    let (x61) = fiat_p384_cmovznz_u32(x3, (arg4[2]), (arg5[2]));
    let (x62) = fiat_p384_cmovznz_u32(x3, (arg4[3]), (arg5[3]));
    let (x63) = fiat_p384_cmovznz_u32(x3, (arg4[4]), (arg5[4]));
    let (x64) = fiat_p384_cmovznz_u32(x3, (arg4[5]), (arg5[5]));
    let (x65) = fiat_p384_cmovznz_u32(x3, (arg4[6]), (arg5[6]));
    let (x66) = fiat_p384_cmovznz_u32(x3, (arg4[7]), (arg5[7]));
    let (x67) = fiat_p384_cmovznz_u32(x3, (arg4[8]), (arg5[8]));
    let (x68) = fiat_p384_cmovznz_u32(x3, (arg4[9]), (arg5[9]));
    let (x69) = fiat_p384_cmovznz_u32(x3, (arg4[10]), (arg5[10]));
    let (x70) = fiat_p384_cmovznz_u32(x3, (arg4[11]), (arg5[11]));
    let (x71, x72) = fiat_p384_addcarryx_u32(0x0, x59, x59);
    let (x73, x74) = fiat_p384_addcarryx_u32(x72, x60, x60);
    let (x75, x76) = fiat_p384_addcarryx_u32(x74, x61, x61);
    let (x77, x78) = fiat_p384_addcarryx_u32(x76, x62, x62);
    let (x79, x80) = fiat_p384_addcarryx_u32(x78, x63, x63);
    let (x81, x82) = fiat_p384_addcarryx_u32(x80, x64, x64);
    let (x83, x84) = fiat_p384_addcarryx_u32(x82, x65, x65);
    let (x85, x86) = fiat_p384_addcarryx_u32(x84, x66, x66);
    let (x87, x88) = fiat_p384_addcarryx_u32(x86, x67, x67);
    let (x89, x90) = fiat_p384_addcarryx_u32(x88, x68, x68);
    let (x91, x92) = fiat_p384_addcarryx_u32(x90, x69, x69);
    let (x93, x94) = fiat_p384_addcarryx_u32(x92, x70, x70);
    let (x95, x96) = fiat_p384_subborrowx_u32(0x0, x71, 0xffffffff);
    let (x97, x98) = fiat_p384_subborrowx_u32(x96, x73, (0x0 as u32));
    let (x99, x100) = fiat_p384_subborrowx_u32(x98, x75, (0x0 as u32));
    let (x101, x102) = fiat_p384_subborrowx_u32(x100, x77, 0xffffffff);
    let (x103, x104) = fiat_p384_subborrowx_u32(x102, x79, 0xfffffffe);
    let (x105, x106) = fiat_p384_subborrowx_u32(x104, x81, 0xffffffff);
    let (x107, x108) = fiat_p384_subborrowx_u32(x106, x83, 0xffffffff);
    let (x109, x110) = fiat_p384_subborrowx_u32(x108, x85, 0xffffffff);
    let (x111, x112) = fiat_p384_subborrowx_u32(x110, x87, 0xffffffff);
    let (x113, x114) = fiat_p384_subborrowx_u32(x112, x89, 0xffffffff);
    let (x115, x116) = fiat_p384_subborrowx_u32(x114, x91, 0xffffffff);
    let (x117, x118) = fiat_p384_subborrowx_u32(x116, x93, 0xffffffff);
    let (x119, x120) = fiat_p384_subborrowx_u32(x118, (x94 as u32), (0x0 as u32));
    let x121: u32 = (arg4[11]);
    let x122: u32 = (arg4[10]);
    let x123: u32 = (arg4[9]);
    let x124: u32 = (arg4[8]);
    let x125: u32 = (arg4[7]);
    let x126: u32 = (arg4[6]);
    let x127: u32 = (arg4[5]);
    let x128: u32 = (arg4[4]);
    let x129: u32 = (arg4[3]);
    let x130: u32 = (arg4[2]);
    let x131: u32 = (arg4[1]);
    let x132: u32 = (arg4[0]);
    let (x133, x134) = fiat_p384_subborrowx_u32(0x0, (0x0 as u32), x132);
    let (x135, x136) = fiat_p384_subborrowx_u32(x134, (0x0 as u32), x131);
    let (x137, x138) = fiat_p384_subborrowx_u32(x136, (0x0 as u32), x130);
    let (x139, x140) = fiat_p384_subborrowx_u32(x138, (0x0 as u32), x129);
    let (x141, x142) = fiat_p384_subborrowx_u32(x140, (0x0 as u32), x128);
    let (x143, x144) = fiat_p384_subborrowx_u32(x142, (0x0 as u32), x127);
    let (x145, x146) = fiat_p384_subborrowx_u32(x144, (0x0 as u32), x126);
    let (x147, x148) = fiat_p384_subborrowx_u32(x146, (0x0 as u32), x125);
    let (x149, x150) = fiat_p384_subborrowx_u32(x148, (0x0 as u32), x124);
    let (x151, x152) = fiat_p384_subborrowx_u32(x150, (0x0 as u32), x123);
    let (x153, x154) = fiat_p384_subborrowx_u32(x152, (0x0 as u32), x122);
    let (x155, x156) = fiat_p384_subborrowx_u32(x154, (0x0 as u32), x121);
    let (x157) = fiat_p384_cmovznz_u32(x156, (0x0 as u32), 0xffffffff);
    let (x158, x159) = fiat_p384_addcarryx_u32(0x0, x133, x157);
    let (x160, x161) = fiat_p384_addcarryx_u32(x159, x135, (0x0 as u32));
    let (x162, x163) = fiat_p384_addcarryx_u32(x161, x137, (0x0 as u32));
    let (x164, x165) = fiat_p384_addcarryx_u32(x163, x139, x157);
    let (x166, x167) = fiat_p384_addcarryx_u32(x165, x141, (x157 & 0xfffffffe));
    let (x168, x169) = fiat_p384_addcarryx_u32(x167, x143, x157);
    let (x170, x171) = fiat_p384_addcarryx_u32(x169, x145, x157);
    let (x172, x173) = fiat_p384_addcarryx_u32(x171, x147, x157);
    let (x174, x175) = fiat_p384_addcarryx_u32(x173, x149, x157);
    let (x176, x177) = fiat_p384_addcarryx_u32(x175, x151, x157);
    let (x178, x179) = fiat_p384_addcarryx_u32(x177, x153, x157);
    let (x180, x181) = fiat_p384_addcarryx_u32(x179, x155, x157);
    let (x182) = fiat_p384_cmovznz_u32(x3, (arg5[0]), x158);
    let (x183) = fiat_p384_cmovznz_u32(x3, (arg5[1]), x160);
    let (x184) = fiat_p384_cmovznz_u32(x3, (arg5[2]), x162);
    let (x185) = fiat_p384_cmovznz_u32(x3, (arg5[3]), x164);
    let (x186) = fiat_p384_cmovznz_u32(x3, (arg5[4]), x166);
    let (x187) = fiat_p384_cmovznz_u32(x3, (arg5[5]), x168);
    let (x188) = fiat_p384_cmovznz_u32(x3, (arg5[6]), x170);
    let (x189) = fiat_p384_cmovznz_u32(x3, (arg5[7]), x172);
    let (x190) = fiat_p384_cmovznz_u32(x3, (arg5[8]), x174);
    let (x191) = fiat_p384_cmovznz_u32(x3, (arg5[9]), x176);
    let (x192) = fiat_p384_cmovznz_u32(x3, (arg5[10]), x178);
    let (x193) = fiat_p384_cmovznz_u32(x3, (arg5[11]), x180);
    let x194: fiat_p384_u1 = ((x46 & (0x1 as u32)) as fiat_p384_u1);
    let (x195) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x7);
    let (x196) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x8);
    let (x197) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x9);
    let (x198) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x10);
    let (x199) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x11);
    let (x200) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x12);
    let (x201) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x13);
    let (x202) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x14);
    let (x203) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x15);
    let (x204) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x16);
    let (x205) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x17);
    let (x206) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x18);
    let (x207) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x19);
    let (x208, x209) = fiat_p384_addcarryx_u32(0x0, x46, x195);
    let (x210, x211) = fiat_p384_addcarryx_u32(x209, x47, x196);
    let (x212, x213) = fiat_p384_addcarryx_u32(x211, x48, x197);
    let (x214, x215) = fiat_p384_addcarryx_u32(x213, x49, x198);
    let (x216, x217) = fiat_p384_addcarryx_u32(x215, x50, x199);
    let (x218, x219) = fiat_p384_addcarryx_u32(x217, x51, x200);
    let (x220, x221) = fiat_p384_addcarryx_u32(x219, x52, x201);
    let (x222, x223) = fiat_p384_addcarryx_u32(x221, x53, x202);
    let (x224, x225) = fiat_p384_addcarryx_u32(x223, x54, x203);
    let (x226, x227) = fiat_p384_addcarryx_u32(x225, x55, x204);
    let (x228, x229) = fiat_p384_addcarryx_u32(x227, x56, x205);
    let (x230, x231) = fiat_p384_addcarryx_u32(x229, x57, x206);
    let (x232, x233) = fiat_p384_addcarryx_u32(x231, x58, x207);
    let (x234) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x59);
    let (x235) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x60);
    let (x236) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x61);
    let (x237) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x62);
    let (x238) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x63);
    let (x239) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x64);
    let (x240) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x65);
    let (x241) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x66);
    let (x242) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x67);
    let (x243) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x68);
    let (x244) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x69);
    let (x245) = fiat_p384_cmovznz_u32(x194, (0x0 as u32), x70);
    let (x246, x247) = fiat_p384_addcarryx_u32(0x0, x182, x234);
    let (x248, x249) = fiat_p384_addcarryx_u32(x247, x183, x235);
    let (x250, x251) = fiat_p384_addcarryx_u32(x249, x184, x236);
    let (x252, x253) = fiat_p384_addcarryx_u32(x251, x185, x237);
    let (x254, x255) = fiat_p384_addcarryx_u32(x253, x186, x238);
    let (x256, x257) = fiat_p384_addcarryx_u32(x255, x187, x239);
    let (x258, x259) = fiat_p384_addcarryx_u32(x257, x188, x240);
    let (x260, x261) = fiat_p384_addcarryx_u32(x259, x189, x241);
    let (x262, x263) = fiat_p384_addcarryx_u32(x261, x190, x242);
    let (x264, x265) = fiat_p384_addcarryx_u32(x263, x191, x243);
    let (x266, x267) = fiat_p384_addcarryx_u32(x265, x192, x244);
    let (x268, x269) = fiat_p384_addcarryx_u32(x267, x193, x245);
    let (x270, x271) = fiat_p384_subborrowx_u32(0x0, x246, 0xffffffff);
    let (x272, x273) = fiat_p384_subborrowx_u32(x271, x248, (0x0 as u32));
    let (x274, x275) = fiat_p384_subborrowx_u32(x273, x250, (0x0 as u32));
    let (x276, x277) = fiat_p384_subborrowx_u32(x275, x252, 0xffffffff);
    let (x278, x279) = fiat_p384_subborrowx_u32(x277, x254, 0xfffffffe);
    let (x280, x281) = fiat_p384_subborrowx_u32(x279, x256, 0xffffffff);
    let (x282, x283) = fiat_p384_subborrowx_u32(x281, x258, 0xffffffff);
    let (x284, x285) = fiat_p384_subborrowx_u32(x283, x260, 0xffffffff);
    let (x286, x287) = fiat_p384_subborrowx_u32(x285, x262, 0xffffffff);
    let (x288, x289) = fiat_p384_subborrowx_u32(x287, x264, 0xffffffff);
    let (x290, x291) = fiat_p384_subborrowx_u32(x289, x266, 0xffffffff);
    let (x292, x293) = fiat_p384_subborrowx_u32(x291, x268, 0xffffffff);
    let (x294, x295) = fiat_p384_subborrowx_u32(x293, (x269 as u32), (0x0 as u32));
    let (x296, x297) = fiat_p384_addcarryx_u32(0x0, x6, (0x1 as u32));
    let x298: u32 = ((x208 >> 1) | ((x210 << 31) & 0xffffffff));
    let x299: u32 = ((x210 >> 1) | ((x212 << 31) & 0xffffffff));
    let x300: u32 = ((x212 >> 1) | ((x214 << 31) & 0xffffffff));
    let x301: u32 = ((x214 >> 1) | ((x216 << 31) & 0xffffffff));
    let x302: u32 = ((x216 >> 1) | ((x218 << 31) & 0xffffffff));
    let x303: u32 = ((x218 >> 1) | ((x220 << 31) & 0xffffffff));
    let x304: u32 = ((x220 >> 1) | ((x222 << 31) & 0xffffffff));
    let x305: u32 = ((x222 >> 1) | ((x224 << 31) & 0xffffffff));
    let x306: u32 = ((x224 >> 1) | ((x226 << 31) & 0xffffffff));
    let x307: u32 = ((x226 >> 1) | ((x228 << 31) & 0xffffffff));
    let x308: u32 = ((x228 >> 1) | ((x230 << 31) & 0xffffffff));
    let x309: u32 = ((x230 >> 1) | ((x232 << 31) & 0xffffffff));
    let x310: u32 = ((x232 & 0x80000000) | (x232 >> 1));
    let (x311) = fiat_p384_cmovznz_u32(x120, x95, x71);
    let (x312) = fiat_p384_cmovznz_u32(x120, x97, x73);
    let (x313) = fiat_p384_cmovznz_u32(x120, x99, x75);
    let (x314) = fiat_p384_cmovznz_u32(x120, x101, x77);
    let (x315) = fiat_p384_cmovznz_u32(x120, x103, x79);
    let (x316) = fiat_p384_cmovznz_u32(x120, x105, x81);
    let (x317) = fiat_p384_cmovznz_u32(x120, x107, x83);
    let (x318) = fiat_p384_cmovznz_u32(x120, x109, x85);
    let (x319) = fiat_p384_cmovznz_u32(x120, x111, x87);
    let (x320) = fiat_p384_cmovznz_u32(x120, x113, x89);
    let (x321) = fiat_p384_cmovznz_u32(x120, x115, x91);
    let (x322) = fiat_p384_cmovznz_u32(x120, x117, x93);
    let (x323) = fiat_p384_cmovznz_u32(x295, x270, x246);
    let (x324) = fiat_p384_cmovznz_u32(x295, x272, x248);
    let (x325) = fiat_p384_cmovznz_u32(x295, x274, x250);
    let (x326) = fiat_p384_cmovznz_u32(x295, x276, x252);
    let (x327) = fiat_p384_cmovznz_u32(x295, x278, x254);
    let (x328) = fiat_p384_cmovznz_u32(x295, x280, x256);
    let (x329) = fiat_p384_cmovznz_u32(x295, x282, x258);
    let (x330) = fiat_p384_cmovznz_u32(x295, x284, x260);
    let (x331) = fiat_p384_cmovznz_u32(x295, x286, x262);
    let (x332) = fiat_p384_cmovznz_u32(x295, x288, x264);
    let (x333) = fiat_p384_cmovznz_u32(x295, x290, x266);
    let (x334) = fiat_p384_cmovznz_u32(x295, x292, x268);
    out1 = x296;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out2[5] = x12;
    out2[6] = x13;
    out2[7] = x14;
    out2[8] = x15;
    out2[9] = x16;
    out2[10] = x17;
    out2[11] = x18;
    out2[12] = x19;
    out3[0] = x298;
    out3[1] = x299;
    out3[2] = x300;
    out3[3] = x301;
    out3[4] = x302;
    out3[5] = x303;
    out3[6] = x304;
    out3[7] = x305;
    out3[8] = x306;
    out3[9] = x307;
    out3[10] = x308;
    out3[11] = x309;
    out3[12] = x310;
    out4[0] = x311;
    out4[1] = x312;
    out4[2] = x313;
    out4[3] = x314;
    out4[4] = x315;
    out4[5] = x316;
    out4[6] = x317;
    out4[7] = x318;
    out4[8] = x319;
    out4[9] = x320;
    out4[10] = x321;
    out4[11] = x322;
    out5[0] = x323;
    out5[1] = x324;
    out5[2] = x325;
    out5[3] = x326;
    out5[4] = x327;
    out5[5] = x328;
    out5[6] = x329;
    out5[7] = x330;
    out5[8] = x331;
    out5[9] = x332;
    out5[10] = x333;
    out5[11] = x334;
    (out1, out2, out3, out4, out5)
}
#[doc = " The function fiat_p384_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_divstep_precomp() -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    out1[0] = 0xfff18fff;
    out1[1] = 0xfff69400;
    out1[2] = 0xffffd3ff;
    out1[3] = 0x2b7fe;
    out1[4] = 0xfffe97ff;
    out1[5] = 0xfffedbff;
    out1[6] = 0x2fff;
    out1[7] = 0x28400;
    out1[8] = 0x50400;
    out1[9] = 0x60400;
    out1[10] = 0x38000;
    out1[11] = 0xfffc4800;
    out1
}
