/* 
   -copyright-
#-# 
#-# Copyright (C) 1999-2001  Robin Hogan, 2021-2026 Willem Vermin
#-# 
#-# This program is free software; you can redistribute it and/or modify
#-# it under the terms of the GNU General Public License as published by
#-# the Free Software Foundation; either version 2 of the License, or
#-# (at your option) any later version.
#-# 
#-# This program is distributed in the hope that it will be useful,
#-# but WITHOUT ANY WARRANTY; without even the implied warranty of
#-# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#-# GNU General Public License for more details.
#-# 
#-# You should have received a copy of the GNU General Public License
#-# along with this program; if not, write to the Free Software
#-# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#-# 
*/

#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Intrinsic.h>
#include <X11/extensions/Xinerama.h>
#include <ctype.h>
#include <assert.h>
#include "debug.h"
#include "windows.h"
#include "utils.h"
#include "wmctrl.h"
#include "transwindow.h"
#include "xdo.h"

static int          waitmax(gpointer widget);
static int          waitfull(gpointer widget);

// gets location and size of xinerama screen xscreen, -1: full screen
// returns the number of xinerama screens
int xinerama(Display *display, int xscreen, int *x, int *y, int *w, int *h)
{
   int number;
   XineramaScreenInfo *info = XineramaQueryScreens(display,&number);
   if (info == NULL)
   {
      I("No xinerama...\n");
      return 0;
   }
   else
   {
      int scr = xscreen;
      if(scr > number-1)
	 scr = number-1;

      for (int i=0; i<number; i++)
      {
	 P("number: %d\n",info[i].screen_number);
	 P("   x_org:  %d\n",info[i].x_org);
	 P("   y_org:  %d\n",info[i].y_org);
	 P("   width:  %d\n",info[i].width);
	 P("   height: %d\n",info[i].height);
      }

      if (scr < 0)
      {
	 // set x,y to 0,0
	 // set width and height to maximum values found
	 if(x)
	    *x = 0;
	 if(y)
	    *y = 0;
	 if(w)
	    *w = 0;
	 if(h)
	    *h = 0;
	 for (int i=0; i<number; i++)
	 {
	    if (w && info[i].width > *w)
	       *w = info[i].width;
	    if (h && info[i].height > *h)
	       *h = info[i].height;
	 }
      }
      else
      {
	 if(x)
	    *x = info[scr].x_org;
	 if(y)
	    *y = info[scr].y_org;
	 if(w)
	    *w = info[scr].width;
	 if(h)
	    *h = info[scr].height;
      }
      P("Xinerama window: %d+%d %dx%d\n",*x,*y,*w,*h);

      XFree(info);
   }
   return number;
}

int waitmax(gpointer widget)
{
   static int counter = 0;
   int w,h;
   int m = gtk_window_is_maximized(GTK_WINDOW(widget));
   gtk_window_get_size(GTK_WINDOW(widget),&w,&h);
   P("waitmax, maximized: %d, w: %d, h: %d\n",m,w,h);
   if ( m && h>200 && w>200 )
   {
      P("waitmax quitting\n");
      fflush(stdout);
      gtk_main_quit();
      return FALSE;
   }
   if (counter++ > 100)
   {
      P("waitmax quitting after %d cycles\n",counter);
      return FALSE;
   }
   return TRUE;
}

void wait_for_maximized(GtkWidget * widget)
{
   gtk_window_unfullscreen(GTK_WINDOW(widget));
   gtk_window_maximize(GTK_WINDOW(widget));
   gtk_widget_show(widget);
   g_timeout_add(20,waitmax,widget);
   P("calling gtk_main from wait_for_maximized\n");
   gtk_main();
}


int waitfull(gpointer widget)
{
   static int counter = 0;
   int w,h;

   gtk_window_fullscreen(GTK_WINDOW(widget));
   gtk_window_get_size(GTK_WINDOW(widget),&w,&h);
   P("waitfull, w: %d, h: %d counter: %d\n",w,h,counter);
   if ( h>200 && w>200  && counter > 40)
   {
      P("waitfull quitting\n");
      gtk_main_quit();
      return FALSE;
   }

   if (counter++ > 200)
   {
      P("waitfull quitting after %d cycles\n",counter);
      return FALSE;
   }
   return TRUE;
}

void wait_for_fullscreen(GtkWidget * widget)
{
   //gtk_window_move(GTK_WINDOW(widget),40,40);
   gtk_widget_show_all(widget);

   GdkWindow *gdkwin = gtk_widget_get_window(widget);
   gdk_window_set_fullscreen_mode(gdkwin,GDK_FULLSCREEN_ON_ALL_MONITORS);

   gtk_widget_show_all(widget);
   gtk_window_fullscreen(GTK_WINDOW(widget));
   //gtk_window_move(GTK_WINDOW(widget),0,0);
   g_timeout_add(20,waitfull,widget);
   P("calling gtk_main from wait_for_fullscreen\n");
   gtk_main();
   if(1)
   {
      int w,h;
      gtk_window_get_size(GTK_WINDOW(widget),&w,&h);
      P("wait_for_fullscreen: w: %d, h:%d\n",w,h);
   }
}


void printxwindowattrs(Display *d, Window w)
{
   XFlush(d);
   XWindowAttributes a;
   XGetWindowAttributes(d, w, &a);
   printf(" id: %#lx, x: %d, y: %d, w: %d, h: %d\n",w,a.x,a.y,a.width,a.height);
}

void printgdkwindowattrs(GdkWindow *g)
{
   int x,y,w,h;
   gdk_window_get_position(g,&x,&y);
   w = gdk_window_get_width(g);
   h = gdk_window_get_height(g);
   printf(" x: %d, y: %d, w: %d, h: %d\n",x,y,w,h);
}

void printgtkwindowattrs(GtkWindow *g)
{
   int x,y,w,h;
   gtk_window_get_position(g,&x,&y);
   gtk_window_get_size(g,&w,&h);
   printf(" x: %d, y: %d, w: %d, h: %d\n",x,y,w,h);
}

