/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "GBTextEncoder.h"
#include "TextUtfEncoding.h"

struct indexTbl_t
{
	uint8_t tblBegin;
	uint8_t tblEnd;
	uint16_t tblOffset;
	uint16_t algOffset;
};

static const indexTbl_t ucs_to_gb18030_index[256] = {
  /* 0x00__ */        {0x80, 0xFF, 0x0080, 0x0000},        {0x00, 0xFF, 0x0080, 0x0000},
  /* 0x02__ */        {0x00, 0xFF, 0x0080, 0x0000},        {0x00, 0xFF, 0x0080, 0x0000},
  /* 0x04__ */        {0x00, 0x51, 0x0080, 0x02E2},        {0xFF, 0x00, 0x1C3E, 0x03E2},
  /* 0x06__ */        {0xFF, 0x00, 0x1C3E, 0x04E2},        {0xFF, 0x00, 0x1C3E, 0x05E2},
  /* 0x08__ */        {0xFF, 0x00, 0x1C3E, 0x06E2},        {0xFF, 0x00, 0x1C3E, 0x07E2},
  /* 0x0A__ */        {0xFF, 0x00, 0x1C3E, 0x08E2},        {0xFF, 0x00, 0x1C3E, 0x09E2},
  /* 0x0C__ */        {0xFF, 0x00, 0x1C3E, 0x0AE2},        {0xFF, 0x00, 0x1C3E, 0x0BE2},
  /* 0x0E__ */        {0xFF, 0x00, 0x1C3E, 0x0CE2},        {0xFF, 0x00, 0x1C3E, 0x0DE2},
  /* 0x10__ */        {0xFF, 0x00, 0x1C3E, 0x0EE2},        {0xFF, 0x00, 0x1C3E, 0x0FE2},
  /* 0x12__ */        {0xFF, 0x00, 0x1C3E, 0x10E2},        {0xFF, 0x00, 0x1C3E, 0x11E2},
  /* 0x14__ */        {0xFF, 0x00, 0x1C3E, 0x12E2},        {0xFF, 0x00, 0x1C3E, 0x13E2},
  /* 0x16__ */        {0xFF, 0x00, 0x1C3E, 0x14E2},        {0xFF, 0x00, 0x1C3E, 0x15E2},
  /* 0x18__ */        {0xFF, 0x00, 0x1C3E, 0x16E2},        {0xFF, 0x00, 0x1C3E, 0x17E2},
  /* 0x1A__ */        {0xFF, 0x00, 0x1C3E, 0x18E2},        {0xFF, 0x00, 0x1C3E, 0x19E2},
  /* 0x1C__ */        {0xFF, 0x00, 0x1C3E, 0x1AE2},        {0xFF, 0x00, 0x1C3E, 0x1BE2},
  /* 0x1E__ */        {0xFF, 0x00, 0x1C3E, 0x1CE2},        {0xFF, 0x00, 0x1C3E, 0x1DE2},
  /* 0x20__ */        {0x10, 0xFF, 0x1C3E, 0x1EE2},        {0x00, 0xFF, 0x1C3E, 0x0000},
  /* 0x22__ */        {0x00, 0xFF, 0x1C3E, 0x0000},        {0x00, 0xFF, 0x1C3E, 0x0000},
  /* 0x24__ */        {0x00, 0xFF, 0x1C3E, 0x0000},        {0x00, 0xFF, 0x1C3E, 0x0000},
  /* 0x26__ */        {0x00, 0x42, 0x1C3E, 0x23C0},        {0xFF, 0x00, 0x247C, 0x24C0},
  /* 0x28__ */        {0xFF, 0x00, 0x247C, 0x25C0},        {0xFF, 0x00, 0x247C, 0x26C0},
  /* 0x2A__ */        {0xFF, 0x00, 0x247C, 0x27C0},        {0xFF, 0x00, 0x247C, 0x28C0},
  /* 0x2C__ */        {0xFF, 0x00, 0x247C, 0x29C0},        {0xFF, 0x00, 0x247C, 0x2AC0},
  /* 0x2E__ */        {0x81, 0xFF, 0x247C, 0x2BC0},        {0x00, 0xFF, 0x247C, 0x0000},
  /* 0x30__ */        {0x00, 0xFF, 0x247C, 0x0000},        {0x00, 0xFF, 0x247C, 0x0000},
  /* 0x32__ */        {0x00, 0xFF, 0x247C, 0x0000},        {0x00, 0xFF, 0x247C, 0x0000},
  /* 0x34__ */        {0x00, 0xFF, 0x247C, 0x0000},        {0x00, 0xFF, 0x247C, 0x0000},
  /* 0x36__ */        {0x00, 0x1A, 0x247C, 0x3292},        {0xFF, 0x00, 0x2779, 0x3392},
  /* 0x38__ */        {0xFF, 0x00, 0x2779, 0x3492},        {0x18, 0xFF, 0x2779, 0x3592},
  /* 0x3A__ */        {0x00, 0xFF, 0x2779, 0x0000},        {0x00, 0xFF, 0x2779, 0x0000},
  /* 0x3C__ */        {0x00, 0xE0, 0x2779, 0x3889},        {0xFF, 0x00, 0x2AEE, 0x3989},
  /* 0x3E__ */        {0xFF, 0x00, 0x2AEE, 0x3A89},        {0xFF, 0x00, 0x2AEE, 0x3B89},
  /* 0x40__ */        {0x56, 0xFF, 0x2AEE, 0x3C89},        {0x00, 0x5F, 0x2AEE, 0x3D87},
  /* 0x42__ */        {0xFF, 0x00, 0x2CC5, 0x3E87},        {0x37, 0xFF, 0x2CC5, 0x3F87},
  /* 0x44__ */        {0x00, 0xD6, 0x2CC5, 0x4082},        {0xFF, 0x00, 0x2E3A, 0x4182},
  /* 0x46__ */        {0x4C, 0xFF, 0x2E3A, 0x4282},        {0x00, 0x8D, 0x2E3A, 0x437C},
  /* 0x48__ */        {0xFF, 0x00, 0x2FF3, 0x447C},        {0x47, 0xB7, 0x2FF3, 0x457C},
  /* 0x4A__ */        {0xFF, 0x00, 0x32B2, 0x4671},        {0xFF, 0x00, 0x32B2, 0x4771},
  /* 0x4C__ */        {0x77, 0xFF, 0x32B2, 0x4871},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x4E__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x50__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x52__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x54__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x56__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x58__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x5A__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x5C__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x5E__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x60__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x62__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x64__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x66__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x68__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x6A__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x6C__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x6E__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x70__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x72__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x74__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x76__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x78__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x7A__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x7C__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x7E__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x80__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x82__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x84__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x86__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x88__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x8A__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x8C__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x8E__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x90__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x92__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x94__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x96__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x98__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x9A__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x9C__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xFF, 0x32B2, 0x0000},
  /* 0x9E__ */        {0x00, 0xFF, 0x32B2, 0x0000},        {0x00, 0xA5, 0x32B2, 0x49BD},
  /* 0xA0__ */        {0xFF, 0x00, 0x6B0C, 0x4ABD},        {0xFF, 0x00, 0x6B0C, 0x4BBD},
  /* 0xA2__ */        {0xFF, 0x00, 0x6B0C, 0x4CBD},        {0xFF, 0x00, 0x6B0C, 0x4DBD},
  /* 0xA4__ */        {0xFF, 0x00, 0x6B0C, 0x4EBD},        {0xFF, 0x00, 0x6B0C, 0x4FBD},
  /* 0xA6__ */        {0xFF, 0x00, 0x6B0C, 0x50BD},        {0xFF, 0x00, 0x6B0C, 0x51BD},
  /* 0xA8__ */        {0xFF, 0x00, 0x6B0C, 0x52BD},        {0xFF, 0x00, 0x6B0C, 0x53BD},
  /* 0xAA__ */        {0xFF, 0x00, 0x6B0C, 0x54BD},        {0xFF, 0x00, 0x6B0C, 0x55BD},
  /* 0xAC__ */        {0xFF, 0x00, 0x6B0C, 0x56BD},        {0xFF, 0x00, 0x6B0C, 0x57BD},
  /* 0xAE__ */        {0xFF, 0x00, 0x6B0C, 0x58BD},        {0xFF, 0x00, 0x6B0C, 0x59BD},
  /* 0xB0__ */        {0xFF, 0x00, 0x6B0C, 0x5ABD},        {0xFF, 0x00, 0x6B0C, 0x5BBD},
  /* 0xB2__ */        {0xFF, 0x00, 0x6B0C, 0x5CBD},        {0xFF, 0x00, 0x6B0C, 0x5DBD},
  /* 0xB4__ */        {0xFF, 0x00, 0x6B0C, 0x5EBD},        {0xFF, 0x00, 0x6B0C, 0x5FBD},
  /* 0xB6__ */        {0xFF, 0x00, 0x6B0C, 0x60BD},        {0xFF, 0x00, 0x6B0C, 0x61BD},
  /* 0xB8__ */        {0xFF, 0x00, 0x6B0C, 0x62BD},        {0xFF, 0x00, 0x6B0C, 0x63BD},
  /* 0xBA__ */        {0xFF, 0x00, 0x6B0C, 0x64BD},        {0xFF, 0x00, 0x6B0C, 0x65BD},
  /* 0xBC__ */        {0xFF, 0x00, 0x6B0C, 0x66BD},        {0xFF, 0x00, 0x6B0C, 0x67BD},
  /* 0xBE__ */        {0xFF, 0x00, 0x6B0C, 0x68BD},        {0xFF, 0x00, 0x6B0C, 0x69BD},
  /* 0xC0__ */        {0xFF, 0x00, 0x6B0C, 0x6ABD},        {0xFF, 0x00, 0x6B0C, 0x6BBD},
  /* 0xC2__ */        {0xFF, 0x00, 0x6B0C, 0x6CBD},        {0xFF, 0x00, 0x6B0C, 0x6DBD},
  /* 0xC4__ */        {0xFF, 0x00, 0x6B0C, 0x6EBD},        {0xFF, 0x00, 0x6B0C, 0x6FBD},
  /* 0xC6__ */        {0xFF, 0x00, 0x6B0C, 0x70BD},        {0xFF, 0x00, 0x6B0C, 0x71BD},
  /* 0xC8__ */        {0xFF, 0x00, 0x6B0C, 0x72BD},        {0xFF, 0x00, 0x6B0C, 0x73BD},
  /* 0xCA__ */        {0xFF, 0x00, 0x6B0C, 0x74BD},        {0xFF, 0x00, 0x6B0C, 0x75BD},
  /* 0xCC__ */        {0xFF, 0x00, 0x6B0C, 0x76BD},        {0xFF, 0x00, 0x6B0C, 0x77BD},
  /* 0xCE__ */        {0xFF, 0x00, 0x6B0C, 0x78BD},        {0xFF, 0x00, 0x6B0C, 0x79BD},
  /* 0xD0__ */        {0xFF, 0x00, 0x6B0C, 0x7ABD},        {0xFF, 0x00, 0x6B0C, 0x7BBD},
  /* 0xD2__ */        {0xFF, 0x00, 0x6B0C, 0x7CBD},        {0xFF, 0x00, 0x6B0C, 0x7DBD},
  /* 0xD4__ */        {0xFF, 0x00, 0x6B0C, 0x7EBD},        {0xFF, 0x00, 0x6B0C, 0x7FBD},
  /* 0xD6__ */        {0xFF, 0x00, 0x6B0C, 0x80BD},        {0xFF, 0x00, 0x6B0C, 0x81BD},
  /* 0xD8__ */        {0xFF, 0x00, 0x6B0C, 0x0000},        {0xFF, 0x00, 0x6B0C, 0x0000},
  /* 0xDA__ */        {0xFF, 0x00, 0x6B0C, 0x0000},        {0xFF, 0x00, 0x6B0C, 0x0000},
  /* 0xDC__ */        {0xFF, 0x00, 0x6B0C, 0x0000},        {0xFF, 0x00, 0x6B0C, 0x0000},
  /* 0xDE__ */        {0xFF, 0x00, 0x6B0C, 0x0000},        {0xFF, 0x00, 0x6B0C, 0x0000},
  /* 0xE0__ */        {0xFF, 0x00, 0x7A72, 0x0000},        {0xFF, 0x00, 0x7A72, 0x0000},
  /* 0xE2__ */        {0xFF, 0x00, 0x7A72, 0x0000},        {0xFF, 0x00, 0x7A72, 0x0000},
  /* 0xE4__ */        {0xFF, 0x00, 0x7A72, 0x0000},        {0xFF, 0x00, 0x7A72, 0x0000},
  /* 0xE6__ */        {0xFF, 0x00, 0x7A72, 0x0000},        {0x66, 0xFF, 0x7A72, 0x0000},
  /* 0xE8__ */        {0x00, 0x64, 0x7A72, 0x82A9},        {0xFF, 0x00, 0x8B39, 0x83A9},
  /* 0xEA__ */        {0xFF, 0x00, 0x8B39, 0x84A9},        {0xFF, 0x00, 0x8B39, 0x85A9},
  /* 0xEC__ */        {0xFF, 0x00, 0x8B39, 0x86A9},        {0xFF, 0x00, 0x8B39, 0x87A9},
  /* 0xEE__ */        {0xFF, 0x00, 0x8B39, 0x88A9},        {0xFF, 0x00, 0x8B39, 0x89A9},
  /* 0xF0__ */        {0xFF, 0x00, 0x8B39, 0x8AA9},        {0xFF, 0x00, 0x8B39, 0x8BA9},
  /* 0xF2__ */        {0xFF, 0x00, 0x8B39, 0x8CA9},        {0xFF, 0x00, 0x8B39, 0x8DA9},
  /* 0xF4__ */        {0xFF, 0x00, 0x8B39, 0x8EA9},        {0xFF, 0x00, 0x8B39, 0x8FA9},
  /* 0xF6__ */        {0xFF, 0x00, 0x8B39, 0x90A9},        {0xFF, 0x00, 0x8B39, 0x91A9},
  /* 0xF8__ */        {0xFF, 0x00, 0x8B39, 0x92A9},        {0x2C, 0xFF, 0x8B39, 0x93A9},
  /* 0xFA__ */        {0x00, 0x29, 0x8B39, 0x9494},        {0xFF, 0x00, 0x8F3F, 0x9594},
  /* 0xFC__ */        {0xFF, 0x00, 0x8F3F, 0x9694},        {0xFF, 0x00, 0x8F3F, 0x9794},
  /* 0xFE__ */        {0x30, 0xFF, 0x8F3F, 0x9894},        {0x00, 0xE5, 0x8F3F, 0x98FC},
};

static const uint16_t ucs_to_gb18030[28839] = {
	/* Contiguous area: U+0080 .. U+0451 */
	/* U+0080 */        0x0000,        0x0001,        0x0002,        0x0003,        0x0004,        0x0005,        0x0006,        0x0007,
	/* U+0088 */        0x0008,        0x0009,        0x0010,        0x0011,        0x0012,        0x0013,        0x0014,        0x0015,
	/* U+0090 */        0x0016,        0x0017,        0x0018,        0x0019,        0x0020,        0x0021,        0x0022,        0x0023,
	/* U+0098 */        0x0024,        0x0025,        0x0026,        0x0027,        0x0028,        0x0029,        0x0030,        0x0031,
	/* U+00A0 */        0x0032,        0x0033,        0x0034,        0x0035,        0xA1E8,        0x0036,        0x0037,        0xA1EC,
	/* U+00A8 */        0xA1A7,        0x0038,        0x0039,        0x0040,        0x0041,        0x0042,        0x0043,        0x0044,
	/* U+00B0 */        0xA1E3,        0xA1C0,        0x0045,        0x0046,        0x0047,        0x0048,        0x0049,        0xA1A4,
	/* U+00B8 */        0x0050,        0x0051,        0x0052,        0x0053,        0x0054,        0x0055,        0x0056,        0x0057,
	/* U+00C0 */        0x0058,        0x0059,        0x0060,        0x0061,        0x0062,        0x0063,        0x0064,        0x0065,
	/* U+00C8 */        0x0066,        0x0067,        0x0068,        0x0069,        0x0070,        0x0071,        0x0072,        0x0073,
	/* U+00D0 */        0x0074,        0x0075,        0x0076,        0x0077,        0x0078,        0x0079,        0x0080,        0xA1C1,
	/* U+00D8 */        0x0081,        0x0082,        0x0083,        0x0084,        0x0085,        0x0086,        0x0087,        0x0088,
	/* U+00E0 */        0xA8A4,        0xA8A2,        0x0089,        0x0090,        0x0091,        0x0092,        0x0093,        0x0094,
	/* U+00E8 */        0xA8A8,        0xA8A6,        0xA8BA,        0x0095,        0xA8AC,        0xA8AA,        0x0096,        0x0097,
	/* U+00F0 */        0x0098,        0x0099,        0xA8B0,        0xA8AE,        0x00A0,        0x00A1,        0x00A2,        0xA1C2,
	/* U+00F8 */        0x00A3,        0xA8B4,        0xA8B2,        0x00A4,        0xA8B9,        0x00A5,        0x00A6,        0x00A7,
	/* U+0100 */        0x00A8,        0xA8A1,        0x00A9,        0x00B0,        0x00B1,        0x00B2,        0x00B3,        0x00B4,
	/* U+0108 */        0x00B5,        0x00B6,        0x00B7,        0x00B8,        0x00B9,        0x00C0,        0x00C1,        0x00C2,
	/* U+0110 */        0x00C3,        0x00C4,        0x00C5,        0xA8A5,        0x00C6,        0x00C7,        0x00C8,        0x00C9,
	/* U+0118 */        0x00D0,        0x00D1,        0x00D2,        0xA8A7,        0x00D3,        0x00D4,        0x00D5,        0x00D6,
	/* U+0120 */        0x00D7,        0x00D8,        0x00D9,        0x00E0,        0x00E1,        0x00E2,        0x00E3,        0x00E4,
	/* U+0128 */        0x00E5,        0x00E6,        0x00E7,        0xA8A9,        0x00E8,        0x00E9,        0x00F0,        0x00F1,
	/* U+0130 */        0x00F2,        0x00F3,        0x00F4,        0x00F5,        0x00F6,        0x00F7,        0x00F8,        0x00F9,
	/* U+0138 */        0x0100,        0x0101,        0x0102,        0x0103,        0x0104,        0x0105,        0x0106,        0x0107,
	/* U+0140 */        0x0108,        0x0109,        0x0110,        0x0111,        0xA8BD,        0x0112,        0x0113,        0x0114,
	/* U+0148 */        0xA8BE,        0x0115,        0x0116,        0x0117,        0x0118,        0xA8AD,        0x0119,        0x0120,
	/* U+0150 */        0x0121,        0x0122,        0x0123,        0x0124,        0x0125,        0x0126,        0x0127,        0x0128,
	/* U+0158 */        0x0129,        0x0130,        0x0131,        0x0132,        0x0133,        0x0134,        0x0135,        0x0136,
	/* U+0160 */        0x0137,        0x0138,        0x0139,        0x0140,        0x0141,        0x0142,        0x0143,        0x0144,
	/* U+0168 */        0x0145,        0x0146,        0x0147,        0xA8B1,        0x0148,        0x0149,        0x0150,        0x0151,
	/* U+0170 */        0x0152,        0x0153,        0x0154,        0x0155,        0x0156,        0x0157,        0x0158,        0x0159,
	/* U+0178 */        0x0160,        0x0161,        0x0162,        0x0163,        0x0164,        0x0165,        0x0166,        0x0167,
	/* U+0180 */        0x0168,        0x0169,        0x0170,        0x0171,        0x0172,        0x0173,        0x0174,        0x0175,
	/* U+0188 */        0x0176,        0x0177,        0x0178,        0x0179,        0x0180,        0x0181,        0x0182,        0x0183,
	/* U+0190 */        0x0184,        0x0185,        0x0186,        0x0187,        0x0188,        0x0189,        0x0190,        0x0191,
	/* U+0198 */        0x0192,        0x0193,        0x0194,        0x0195,        0x0196,        0x0197,        0x0198,        0x0199,
	/* U+01A0 */        0x01A0,        0x01A1,        0x01A2,        0x01A3,        0x01A4,        0x01A5,        0x01A6,        0x01A7,
	/* U+01A8 */        0x01A8,        0x01A9,        0x01B0,        0x01B1,        0x01B2,        0x01B3,        0x01B4,        0x01B5,
	/* U+01B0 */        0x01B6,        0x01B7,        0x01B8,        0x01B9,        0x01C0,        0x01C1,        0x01C2,        0x01C3,
	/* U+01B8 */        0x01C4,        0x01C5,        0x01C6,        0x01C7,        0x01C8,        0x01C9,        0x01D0,        0x01D1,
	/* U+01C0 */        0x01D2,        0x01D3,        0x01D4,        0x01D5,        0x01D6,        0x01D7,        0x01D8,        0x01D9,
	/* U+01C8 */        0x01E0,        0x01E1,        0x01E2,        0x01E3,        0x01E4,        0x01E5,        0xA8A3,        0x01E6,
	/* U+01D0 */        0xA8AB,        0x01E7,        0xA8AF,        0x01E8,        0xA8B3,        0x01E9,        0xA8B5,        0x01F0,
	/* U+01D8 */        0xA8B6,        0x01F1,        0xA8B7,        0x01F2,        0xA8B8,        0x01F3,        0x01F4,        0x01F5,
	/* U+01E0 */        0x01F6,        0x01F7,        0x01F8,        0x01F9,        0x0200,        0x0201,        0x0202,        0x0203,
	/* U+01E8 */        0x0204,        0x0205,        0x0206,        0x0207,        0x0208,        0x0209,        0x0210,        0x0211,
	/* U+01F0 */        0x0212,        0x0213,        0x0214,        0x0215,        0x0216,        0x0217,        0x0218,        0x0219,
	/* U+01F8 */        0x0220,        0xA8BF,        0x0221,        0x0222,        0x0223,        0x0224,        0x0225,        0x0226,
	/* U+0200 */        0x0227,        0x0228,        0x0229,        0x0230,        0x0231,        0x0232,        0x0233,        0x0234,
	/* U+0208 */        0x0235,        0x0236,        0x0237,        0x0238,        0x0239,        0x0240,        0x0241,        0x0242,
	/* U+0210 */        0x0243,        0x0244,        0x0245,        0x0246,        0x0247,        0x0248,        0x0249,        0x0250,
	/* U+0218 */        0x0251,        0x0252,        0x0253,        0x0254,        0x0255,        0x0256,        0x0257,        0x0258,
	/* U+0220 */        0x0259,        0x0260,        0x0261,        0x0262,        0x0263,        0x0264,        0x0265,        0x0266,
	/* U+0228 */        0x0267,        0x0268,        0x0269,        0x0270,        0x0271,        0x0272,        0x0273,        0x0274,
	/* U+0230 */        0x0275,        0x0276,        0x0277,        0x0278,        0x0279,        0x0280,        0x0281,        0x0282,
	/* U+0238 */        0x0283,        0x0284,        0x0285,        0x0286,        0x0287,        0x0288,        0x0289,        0x0290,
	/* U+0240 */        0x0291,        0x0292,        0x0293,        0x0294,        0x0295,        0x0296,        0x0297,        0x0298,
	/* U+0248 */        0x0299,        0x02A0,        0x02A1,        0x02A2,        0x02A3,        0x02A4,        0x02A5,        0x02A6,
	/* U+0250 */        0x02A7,        0xA8BB,        0x02A8,        0x02A9,        0x02B0,        0x02B1,        0x02B2,        0x02B3,
	/* U+0258 */        0x02B4,        0x02B5,        0x02B6,        0x02B7,        0x02B8,        0x02B9,        0x02C0,        0x02C1,
	/* U+0260 */        0x02C2,        0xA8C0,        0x02C3,        0x02C4,        0x02C5,        0x02C6,        0x02C7,        0x02C8,
	/* U+0268 */        0x02C9,        0x02D0,        0x02D1,        0x02D2,        0x02D3,        0x02D4,        0x02D5,        0x02D6,
	/* U+0270 */        0x02D7,        0x02D8,        0x02D9,        0x02E0,        0x02E1,        0x02E2,        0x02E3,        0x02E4,
	/* U+0278 */        0x02E5,        0x02E6,        0x02E7,        0x02E8,        0x02E9,        0x02F0,        0x02F1,        0x02F2,
	/* U+0280 */        0x02F3,        0x02F4,        0x02F5,        0x02F6,        0x02F7,        0x02F8,        0x02F9,        0x0300,
	/* U+0288 */        0x0301,        0x0302,        0x0303,        0x0304,        0x0305,        0x0306,        0x0307,        0x0308,
	/* U+0290 */        0x0309,        0x0310,        0x0311,        0x0312,        0x0313,        0x0314,        0x0315,        0x0316,
	/* U+0298 */        0x0317,        0x0318,        0x0319,        0x0320,        0x0321,        0x0322,        0x0323,        0x0324,
	/* U+02A0 */        0x0325,        0x0326,        0x0327,        0x0328,        0x0329,        0x0330,        0x0331,        0x0332,
	/* U+02A8 */        0x0333,        0x0334,        0x0335,        0x0336,        0x0337,        0x0338,        0x0339,        0x0340,
	/* U+02B0 */        0x0341,        0x0342,        0x0343,        0x0344,        0x0345,        0x0346,        0x0347,        0x0348,
	/* U+02B8 */        0x0349,        0x0350,        0x0351,        0x0352,        0x0353,        0x0354,        0x0355,        0x0356,
	/* U+02C0 */        0x0357,        0x0358,        0x0359,        0x0360,        0x0361,        0x0362,        0x0363,        0xA1A6,
	/* U+02C8 */        0x0364,        0xA1A5,        0xA840,        0xA841,        0x0365,        0x0366,        0x0367,        0x0368,
	/* U+02D0 */        0x0369,        0x0370,        0x0371,        0x0372,        0x0373,        0x0374,        0x0375,        0x0376,
	/* U+02D8 */        0x0377,        0xA842,        0x0378,        0x0379,        0x0380,        0x0381,        0x0382,        0x0383,
	/* U+02E0 */        0x0384,        0x0385,        0x0386,        0x0387,        0x0388,        0x0389,        0x0390,        0x0391,
	/* U+02E8 */        0x0392,        0x0393,        0x0394,        0x0395,        0x0396,        0x0397,        0x0398,        0x0399,
	/* U+02F0 */        0x03A0,        0x03A1,        0x03A2,        0x03A3,        0x03A4,        0x03A5,        0x03A6,        0x03A7,
	/* U+02F8 */        0x03A8,        0x03A9,        0x03B0,        0x03B1,        0x03B2,        0x03B3,        0x03B4,        0x03B5,
	/* U+0300 */        0x03B6,        0x03B7,        0x03B8,        0x03B9,        0x03C0,        0x03C1,        0x03C2,        0x03C3,
	/* U+0308 */        0x03C4,        0x03C5,        0x03C6,        0x03C7,        0x03C8,        0x03C9,        0x03D0,        0x03D1,
	/* U+0310 */        0x03D2,        0x03D3,        0x03D4,        0x03D5,        0x03D6,        0x03D7,        0x03D8,        0x03D9,
	/* U+0318 */        0x03E0,        0x03E1,        0x03E2,        0x03E3,        0x03E4,        0x03E5,        0x03E6,        0x03E7,
	/* U+0320 */        0x03E8,        0x03E9,        0x03F0,        0x03F1,        0x03F2,        0x03F3,        0x03F4,        0x03F5,
	/* U+0328 */        0x03F6,        0x03F7,        0x03F8,        0x03F9,        0x0400,        0x0401,        0x0402,        0x0403,
	/* U+0330 */        0x0404,        0x0405,        0x0406,        0x0407,        0x0408,        0x0409,        0x0410,        0x0411,
	/* U+0338 */        0x0412,        0x0413,        0x0414,        0x0415,        0x0416,        0x0417,        0x0418,        0x0419,
	/* U+0340 */        0x0420,        0x0421,        0x0422,        0x0423,        0x0424,        0x0425,        0x0426,        0x0427,
	/* U+0348 */        0x0428,        0x0429,        0x0430,        0x0431,        0x0432,        0x0433,        0x0434,        0x0435,
	/* U+0350 */        0x0436,        0x0437,        0x0438,        0x0439,        0x0440,        0x0441,        0x0442,        0x0443,
	/* U+0358 */        0x0444,        0x0445,        0x0446,        0x0447,        0x0448,        0x0449,        0x0450,        0x0451,
	/* U+0360 */        0x0452,        0x0453,        0x0454,        0x0455,        0x0456,        0x0457,        0x0458,        0x0459,
	/* U+0368 */        0x0460,        0x0461,        0x0462,        0x0463,        0x0464,        0x0465,        0x0466,        0x0467,
	/* U+0370 */        0x0468,        0x0469,        0x0470,        0x0471,        0x0472,        0x0473,        0x0474,        0x0475,
	/* U+0378 */        0x0476,        0x0477,        0x0478,        0x0479,        0x0480,        0x0481,        0x0482,        0x0483,
	/* U+0380 */        0x0484,        0x0485,        0x0486,        0x0487,        0x0488,        0x0489,        0x0490,        0x0491,
	/* U+0388 */        0x0492,        0x0493,        0x0494,        0x0495,        0x0496,        0x0497,        0x0498,        0x0499,
	/* U+0390 */        0x04A0,        0xA6A1,        0xA6A2,        0xA6A3,        0xA6A4,        0xA6A5,        0xA6A6,        0xA6A7,
	/* U+0398 */        0xA6A8,        0xA6A9,        0xA6AA,        0xA6AB,        0xA6AC,        0xA6AD,        0xA6AE,        0xA6AF,
	/* U+03A0 */        0xA6B0,        0xA6B1,        0x04A1,        0xA6B2,        0xA6B3,        0xA6B4,        0xA6B5,        0xA6B6,
	/* U+03A8 */        0xA6B7,        0xA6B8,        0x04A2,        0x04A3,        0x04A4,        0x04A5,        0x04A6,        0x04A7,
	/* U+03B0 */        0x04A8,        0xA6C1,        0xA6C2,        0xA6C3,        0xA6C4,        0xA6C5,        0xA6C6,        0xA6C7,
	/* U+03B8 */        0xA6C8,        0xA6C9,        0xA6CA,        0xA6CB,        0xA6CC,        0xA6CD,        0xA6CE,        0xA6CF,
	/* U+03C0 */        0xA6D0,        0xA6D1,        0x04A9,        0xA6D2,        0xA6D3,        0xA6D4,        0xA6D5,        0xA6D6,
	/* U+03C8 */        0xA6D7,        0xA6D8,        0x04B0,        0x04B1,        0x04B2,        0x04B3,        0x04B4,        0x04B5,
	/* U+03D0 */        0x04B6,        0x04B7,        0x04B8,        0x04B9,        0x04C0,        0x04C1,        0x04C2,        0x04C3,
	/* U+03D8 */        0x04C4,        0x04C5,        0x04C6,        0x04C7,        0x04C8,        0x04C9,        0x04D0,        0x04D1,
	/* U+03E0 */        0x04D2,        0x04D3,        0x04D4,        0x04D5,        0x04D6,        0x04D7,        0x04D8,        0x04D9,
	/* U+03E8 */        0x04E0,        0x04E1,        0x04E2,        0x04E3,        0x04E4,        0x04E5,        0x04E6,        0x04E7,
	/* U+03F0 */        0x04E8,        0x04E9,        0x04F0,        0x04F1,        0x04F2,        0x04F3,        0x04F4,        0x04F5,
	/* U+03F8 */        0x04F6,        0x04F7,        0x04F8,        0x04F9,        0x0500,        0x0501,        0x0502,        0x0503,
	/* U+0400 */        0x0504,        0xA7A7,        0x0505,        0x0506,        0x0507,        0x0508,        0x0509,        0x0510,
	/* U+0408 */        0x0511,        0x0512,        0x0513,        0x0514,        0x0515,        0x0516,        0x0517,        0x0518,
	/* U+0410 */        0xA7A1,        0xA7A2,        0xA7A3,        0xA7A4,        0xA7A5,        0xA7A6,        0xA7A8,        0xA7A9,
	/* U+0418 */        0xA7AA,        0xA7AB,        0xA7AC,        0xA7AD,        0xA7AE,        0xA7AF,        0xA7B0,        0xA7B1,
	/* U+0420 */        0xA7B2,        0xA7B3,        0xA7B4,        0xA7B5,        0xA7B6,        0xA7B7,        0xA7B8,        0xA7B9,
	/* U+0428 */        0xA7BA,        0xA7BB,        0xA7BC,        0xA7BD,        0xA7BE,        0xA7BF,        0xA7C0,        0xA7C1,
	/* U+0430 */        0xA7D1,        0xA7D2,        0xA7D3,        0xA7D4,        0xA7D5,        0xA7D6,        0xA7D8,        0xA7D9,
	/* U+0438 */        0xA7DA,        0xA7DB,        0xA7DC,        0xA7DD,        0xA7DE,        0xA7DF,        0xA7E0,        0xA7E1,
	/* U+0440 */        0xA7E2,        0xA7E3,        0xA7E4,        0xA7E5,        0xA7E6,        0xA7E7,        0xA7E8,        0xA7E9,
	/* U+0448 */        0xA7EA,        0xA7EB,        0xA7EC,        0xA7ED,        0xA7EE,        0xA7EF,        0xA7F0,        0xA7F1,
	/* U+0450 */        0x0519,        0xA7D7,
	/* Contiguous area: U+2010 .. U+2642 */
	/* U+2010 */        0xA95C,        0x0A42,        0x0A43,        0xA843,        0xA1AA,        0xA844,        0xA1AC,        0x0A44,
	/* U+2018 */        0xA1AE,        0xA1AF,        0x0A45,        0x0A46,        0xA1B0,        0xA1B1,        0x0A47,        0x0A48,
	/* U+2020 */        0x0A49,        0x0A50,        0x0A51,        0x0A52,        0x0A53,        0xA845,        0xA1AD,        0x0A54,
	/* U+2028 */        0x0A55,        0x0A56,        0x0A57,        0x0A58,        0x0A59,        0x0A60,        0x0A61,        0x0A62,
	/* U+2030 */        0xA1EB,        0x0A63,        0xA1E4,        0xA1E5,        0x0A64,        0xA846,        0x0A65,        0x0A66,
	/* U+2038 */        0x0A67,        0x0A68,        0x0A69,        0xA1F9,        0x0A70,        0x0A71,        0x0A72,        0x0A73,
	/* U+2040 */        0x0A74,        0x0A75,        0x0A76,        0x0A77,        0x0A78,        0x0A79,        0x0A80,        0x0A81,
	/* U+2048 */        0x0A82,        0x0A83,        0x0A84,        0x0A85,        0x0A86,        0x0A87,        0x0A88,        0x0A89,
	/* U+2050 */        0x0A90,        0x0A91,        0x0A92,        0x0A93,        0x0A94,        0x0A95,        0x0A96,        0x0A97,
	/* U+2058 */        0x0A98,        0x0A99,        0x0AA0,        0x0AA1,        0x0AA2,        0x0AA3,        0x0AA4,        0x0AA5,
	/* U+2060 */        0x0AA6,        0x0AA7,        0x0AA8,        0x0AA9,        0x0AB0,        0x0AB1,        0x0AB2,        0x0AB3,
	/* U+2068 */        0x0AB4,        0x0AB5,        0x0AB6,        0x0AB7,        0x0AB8,        0x0AB9,        0x0AC0,        0x0AC1,
	/* U+2070 */        0x0AC2,        0x0AC3,        0x0AC4,        0x0AC5,        0x0AC6,        0x0AC7,        0x0AC8,        0x0AC9,
	/* U+2078 */        0x0AD0,        0x0AD1,        0x0AD2,        0x0AD3,        0x0AD4,        0x0AD5,        0x0AD6,        0x0AD7,
	/* U+2080 */        0x0AD8,        0x0AD9,        0x0AE0,        0x0AE1,        0x0AE2,        0x0AE3,        0x0AE4,        0x0AE5,
	/* U+2088 */        0x0AE6,        0x0AE7,        0x0AE8,        0x0AE9,        0x0AF0,        0x0AF1,        0x0AF2,        0x0AF3,
	/* U+2090 */        0x0AF4,        0x0AF5,        0x0AF6,        0x0AF7,        0x0AF8,        0x0AF9,        0x0B00,        0x0B01,
	/* U+2098 */        0x0B02,        0x0B03,        0x0B04,        0x0B05,        0x0B06,        0x0B07,        0x0B08,        0x0B09,
	/* U+20A0 */        0x0B10,        0x0B11,        0x0B12,        0x0B13,        0x0B14,        0x0B15,        0x0B16,        0x0B17,
	/* U+20A8 */        0x0B18,        0x0B19,        0x0B20,        0x0B21,        0xA2E3,        0x0B22,        0x0B23,        0x0B24,
	/* U+20B0 */        0x0B25,        0x0B26,        0x0B27,        0x0B28,        0x0B29,        0x0B30,        0x0B31,        0x0B32,
	/* U+20B8 */        0x0B33,        0x0B34,        0x0B35,        0x0B36,        0x0B37,        0x0B38,        0x0B39,        0x0B40,
	/* U+20C0 */        0x0B41,        0x0B42,        0x0B43,        0x0B44,        0x0B45,        0x0B46,        0x0B47,        0x0B48,
	/* U+20C8 */        0x0B49,        0x0B50,        0x0B51,        0x0B52,        0x0B53,        0x0B54,        0x0B55,        0x0B56,
	/* U+20D0 */        0x0B57,        0x0B58,        0x0B59,        0x0B60,        0x0B61,        0x0B62,        0x0B63,        0x0B64,
	/* U+20D8 */        0x0B65,        0x0B66,        0x0B67,        0x0B68,        0x0B69,        0x0B70,        0x0B71,        0x0B72,
	/* U+20E0 */        0x0B73,        0x0B74,        0x0B75,        0x0B76,        0x0B77,        0x0B78,        0x0B79,        0x0B80,
	/* U+20E8 */        0x0B81,        0x0B82,        0x0B83,        0x0B84,        0x0B85,        0x0B86,        0x0B87,        0x0B88,
	/* U+20F0 */        0x0B89,        0x0B90,        0x0B91,        0x0B92,        0x0B93,        0x0B94,        0x0B95,        0x0B96,
	/* U+20F8 */        0x0B97,        0x0B98,        0x0B99,        0x0BA0,        0x0BA1,        0x0BA2,        0x0BA3,        0x0BA4,
	/* U+2100 */        0x0BA5,        0x0BA6,        0x0BA7,        0xA1E6,        0x0BA8,        0xA847,        0x0BA9,        0x0BB0,
	/* U+2108 */        0x0BB1,        0xA848,        0x0BB2,        0x0BB3,        0x0BB4,        0x0BB5,        0x0BB6,        0x0BB7,
	/* U+2110 */        0x0BB8,        0x0BB9,        0x0BC0,        0x0BC1,        0x0BC2,        0x0BC3,        0xA1ED,        0x0BC4,
	/* U+2118 */        0x0BC5,        0x0BC6,        0x0BC7,        0x0BC8,        0x0BC9,        0x0BD0,        0x0BD1,        0x0BD2,
	/* U+2120 */        0x0BD3,        0xA959,        0x0BD4,        0x0BD5,        0x0BD6,        0x0BD7,        0x0BD8,        0x0BD9,
	/* U+2128 */        0x0BE0,        0x0BE1,        0x0BE2,        0x0BE3,        0x0BE4,        0x0BE5,        0x0BE6,        0x0BE7,
	/* U+2130 */        0x0BE8,        0x0BE9,        0x0BF0,        0x0BF1,        0x0BF2,        0x0BF3,        0x0BF4,        0x0BF5,
	/* U+2138 */        0x0BF6,        0x0BF7,        0x0BF8,        0x0BF9,        0x0C00,        0x0C01,        0x0C02,        0x0C03,
	/* U+2140 */        0x0C04,        0x0C05,        0x0C06,        0x0C07,        0x0C08,        0x0C09,        0x0C10,        0x0C11,
	/* U+2148 */        0x0C12,        0x0C13,        0x0C14,        0x0C15,        0x0C16,        0x0C17,        0x0C18,        0x0C19,
	/* U+2150 */        0x0C20,        0x0C21,        0x0C22,        0x0C23,        0x0C24,        0x0C25,        0x0C26,        0x0C27,
	/* U+2158 */        0x0C28,        0x0C29,        0x0C30,        0x0C31,        0x0C32,        0x0C33,        0x0C34,        0x0C35,
	/* U+2160 */        0xA2F1,        0xA2F2,        0xA2F3,        0xA2F4,        0xA2F5,        0xA2F6,        0xA2F7,        0xA2F8,
	/* U+2168 */        0xA2F9,        0xA2FA,        0xA2FB,        0xA2FC,        0x0C36,        0x0C37,        0x0C38,        0x0C39,
	/* U+2170 */        0xA2A1,        0xA2A2,        0xA2A3,        0xA2A4,        0xA2A5,        0xA2A6,        0xA2A7,        0xA2A8,
	/* U+2178 */        0xA2A9,        0xA2AA,        0x0C40,        0x0C41,        0x0C42,        0x0C43,        0x0C44,        0x0C45,
	/* U+2180 */        0x0C46,        0x0C47,        0x0C48,        0x0C49,        0x0C50,        0x0C51,        0x0C52,        0x0C53,
	/* U+2188 */        0x0C54,        0x0C55,        0x0C56,        0x0C57,        0x0C58,        0x0C59,        0x0C60,        0x0C61,
	/* U+2190 */        0xA1FB,        0xA1FC,        0xA1FA,        0xA1FD,        0x0C62,        0x0C63,        0xA849,        0xA84A,
	/* U+2198 */        0xA84B,        0xA84C,        0x0C64,        0x0C65,        0x0C66,        0x0C67,        0x0C68,        0x0C69,
	/* U+21A0 */        0x0C70,        0x0C71,        0x0C72,        0x0C73,        0x0C74,        0x0C75,        0x0C76,        0x0C77,
	/* U+21A8 */        0x0C78,        0x0C79,        0x0C80,        0x0C81,        0x0C82,        0x0C83,        0x0C84,        0x0C85,
	/* U+21B0 */        0x0C86,        0x0C87,        0x0C88,        0x0C89,        0x0C90,        0x0C91,        0x0C92,        0x0C93,
	/* U+21B8 */        0x0C94,        0x0C95,        0x0C96,        0x0C97,        0x0C98,        0x0C99,        0x0CA0,        0x0CA1,
	/* U+21C0 */        0x0CA2,        0x0CA3,        0x0CA4,        0x0CA5,        0x0CA6,        0x0CA7,        0x0CA8,        0x0CA9,
	/* U+21C8 */        0x0CB0,        0x0CB1,        0x0CB2,        0x0CB3,        0x0CB4,        0x0CB5,        0x0CB6,        0x0CB7,
	/* U+21D0 */        0x0CB8,        0x0CB9,        0x0CC0,        0x0CC1,        0x0CC2,        0x0CC3,        0x0CC4,        0x0CC5,
	/* U+21D8 */        0x0CC6,        0x0CC7,        0x0CC8,        0x0CC9,        0x0CD0,        0x0CD1,        0x0CD2,        0x0CD3,
	/* U+21E0 */        0x0CD4,        0x0CD5,        0x0CD6,        0x0CD7,        0x0CD8,        0x0CD9,        0x0CE0,        0x0CE1,
	/* U+21E8 */        0x0CE2,        0x0CE3,        0x0CE4,        0x0CE5,        0x0CE6,        0x0CE7,        0x0CE8,        0x0CE9,
	/* U+21F0 */        0x0CF0,        0x0CF1,        0x0CF2,        0x0CF3,        0x0CF4,        0x0CF5,        0x0CF6,        0x0CF7,
	/* U+21F8 */        0x0CF8,        0x0CF9,        0x0D00,        0x0D01,        0x0D02,        0x0D03,        0x0D04,        0x0D05,
	/* U+2200 */        0x0D06,        0x0D07,        0x0D08,        0x0D09,        0x0D10,        0x0D11,        0x0D12,        0x0D13,
	/* U+2208 */        0xA1CA,        0x0D14,        0x0D15,        0x0D16,        0x0D17,        0x0D18,        0x0D19,        0xA1C7,
	/* U+2210 */        0x0D20,        0xA1C6,        0x0D21,        0x0D22,        0x0D23,        0xA84D,        0x0D24,        0x0D25,
	/* U+2218 */        0x0D26,        0x0D27,        0xA1CC,        0x0D28,        0x0D29,        0xA1D8,        0xA1DE,        0xA84E,
	/* U+2220 */        0xA1CF,        0x0D30,        0x0D31,        0xA84F,        0x0D32,        0xA1CE,        0x0D33,        0xA1C4,
	/* U+2228 */        0xA1C5,        0xA1C9,        0xA1C8,        0xA1D2,        0x0D34,        0x0D35,        0xA1D3,        0x0D36,
	/* U+2230 */        0x0D37,        0x0D38,        0x0D39,        0x0D40,        0xA1E0,        0xA1DF,        0xA1C3,        0xA1CB,
	/* U+2238 */        0x0D41,        0x0D42,        0x0D43,        0x0D44,        0x0D45,        0xA1D7,        0x0D46,        0x0D47,
	/* U+2240 */        0x0D48,        0x0D49,        0x0D50,        0x0D51,        0x0D52,        0x0D53,        0x0D54,        0x0D55,
	/* U+2248 */        0xA1D6,        0x0D56,        0x0D57,        0x0D58,        0xA1D5,        0x0D59,        0x0D60,        0x0D61,
	/* U+2250 */        0x0D62,        0x0D63,        0xA850,        0x0D64,        0x0D65,        0x0D66,        0x0D67,        0x0D68,
	/* U+2258 */        0x0D69,        0x0D70,        0x0D71,        0x0D72,        0x0D73,        0x0D74,        0x0D75,        0x0D76,
	/* U+2260 */        0xA1D9,        0xA1D4,        0x0D77,        0x0D78,        0xA1DC,        0xA1DD,        0xA851,        0xA852,
	/* U+2268 */        0x0D79,        0x0D80,        0x0D81,        0x0D82,        0x0D83,        0x0D84,        0xA1DA,        0xA1DB,
	/* U+2270 */        0x0D85,        0x0D86,        0x0D87,        0x0D88,        0x0D89,        0x0D90,        0x0D91,        0x0D92,
	/* U+2278 */        0x0D93,        0x0D94,        0x0D95,        0x0D96,        0x0D97,        0x0D98,        0x0D99,        0x0DA0,
	/* U+2280 */        0x0DA1,        0x0DA2,        0x0DA3,        0x0DA4,        0x0DA5,        0x0DA6,        0x0DA7,        0x0DA8,
	/* U+2288 */        0x0DA9,        0x0DB0,        0x0DB1,        0x0DB2,        0x0DB3,        0x0DB4,        0x0DB5,        0x0DB6,
	/* U+2290 */        0x0DB7,        0x0DB8,        0x0DB9,        0x0DC0,        0x0DC1,        0xA892,        0x0DC2,        0x0DC3,
	/* U+2298 */        0x0DC4,        0xA1D1,        0x0DC5,        0x0DC6,        0x0DC7,        0x0DC8,        0x0DC9,        0x0DD0,
	/* U+22A0 */        0x0DD1,        0x0DD2,        0x0DD3,        0x0DD4,        0x0DD5,        0xA1CD,        0x0DD6,        0x0DD7,
	/* U+22A8 */        0x0DD8,        0x0DD9,        0x0DE0,        0x0DE1,        0x0DE2,        0x0DE3,        0x0DE4,        0x0DE5,
	/* U+22B0 */        0x0DE6,        0x0DE7,        0x0DE8,        0x0DE9,        0x0DF0,        0x0DF1,        0x0DF2,        0x0DF3,
	/* U+22B8 */        0x0DF4,        0x0DF5,        0x0DF6,        0x0DF7,        0x0DF8,        0x0DF9,        0x0E00,        0xA853,
	/* U+22C0 */        0x0E01,        0x0E02,        0x0E03,        0x0E04,        0x0E05,        0x0E06,        0x0E07,        0x0E08,
	/* U+22C8 */        0x0E09,        0x0E10,        0x0E11,        0x0E12,        0x0E13,        0x0E14,        0x0E15,        0x0E16,
	/* U+22D0 */        0x0E17,        0x0E18,        0x0E19,        0x0E20,        0x0E21,        0x0E22,        0x0E23,        0x0E24,
	/* U+22D8 */        0x0E25,        0x0E26,        0x0E27,        0x0E28,        0x0E29,        0x0E30,        0x0E31,        0x0E32,
	/* U+22E0 */        0x0E33,        0x0E34,        0x0E35,        0x0E36,        0x0E37,        0x0E38,        0x0E39,        0x0E40,
	/* U+22E8 */        0x0E41,        0x0E42,        0x0E43,        0x0E44,        0x0E45,        0x0E46,        0x0E47,        0x0E48,
	/* U+22F0 */        0x0E49,        0x0E50,        0x0E51,        0x0E52,        0x0E53,        0x0E54,        0x0E55,        0x0E56,
	/* U+22F8 */        0x0E57,        0x0E58,        0x0E59,        0x0E60,        0x0E61,        0x0E62,        0x0E63,        0x0E64,
	/* U+2300 */        0x0E65,        0x0E66,        0x0E67,        0x0E68,        0x0E69,        0x0E70,        0x0E71,        0x0E72,
	/* U+2308 */        0x0E73,        0x0E74,        0x0E75,        0x0E76,        0x0E77,        0x0E78,        0x0E79,        0x0E80,
	/* U+2310 */        0x0E81,        0x0E82,        0xA1D0,        0x0E83,        0x0E84,        0x0E85,        0x0E86,        0x0E87,
	/* U+2318 */        0x0E88,        0x0E89,        0x0E90,        0x0E91,        0x0E92,        0x0E93,        0x0E94,        0x0E95,
	/* U+2320 */        0x0E96,        0x0E97,        0x0E98,        0x0E99,        0x0EA0,        0x0EA1,        0x0EA2,        0x0EA3,
	/* U+2328 */        0x0EA4,        0x0EA5,        0x0EA6,        0x0EA7,        0x0EA8,        0x0EA9,        0x0EB0,        0x0EB1,
	/* U+2330 */        0x0EB2,        0x0EB3,        0x0EB4,        0x0EB5,        0x0EB6,        0x0EB7,        0x0EB8,        0x0EB9,
	/* U+2338 */        0x0EC0,        0x0EC1,        0x0EC2,        0x0EC3,        0x0EC4,        0x0EC5,        0x0EC6,        0x0EC7,
	/* U+2340 */        0x0EC8,        0x0EC9,        0x0ED0,        0x0ED1,        0x0ED2,        0x0ED3,        0x0ED4,        0x0ED5,
	/* U+2348 */        0x0ED6,        0x0ED7,        0x0ED8,        0x0ED9,        0x0EE0,        0x0EE1,        0x0EE2,        0x0EE3,
	/* U+2350 */        0x0EE4,        0x0EE5,        0x0EE6,        0x0EE7,        0x0EE8,        0x0EE9,        0x0EF0,        0x0EF1,
	/* U+2358 */        0x0EF2,        0x0EF3,        0x0EF4,        0x0EF5,        0x0EF6,        0x0EF7,        0x0EF8,        0x0EF9,
	/* U+2360 */        0x0F00,        0x0F01,        0x0F02,        0x0F03,        0x0F04,        0x0F05,        0x0F06,        0x0F07,
	/* U+2368 */        0x0F08,        0x0F09,        0x0F10,        0x0F11,        0x0F12,        0x0F13,        0x0F14,        0x0F15,
	/* U+2370 */        0x0F16,        0x0F17,        0x0F18,        0x0F19,        0x0F20,        0x0F21,        0x0F22,        0x0F23,
	/* U+2378 */        0x0F24,        0x0F25,        0x0F26,        0x0F27,        0x0F28,        0x0F29,        0x0F30,        0x0F31,
	/* U+2380 */        0x0F32,        0x0F33,        0x0F34,        0x0F35,        0x0F36,        0x0F37,        0x0F38,        0x0F39,
	/* U+2388 */        0x0F40,        0x0F41,        0x0F42,        0x0F43,        0x0F44,        0x0F45,        0x0F46,        0x0F47,
	/* U+2390 */        0x0F48,        0x0F49,        0x0F50,        0x0F51,        0x0F52,        0x0F53,        0x0F54,        0x0F55,
	/* U+2398 */        0x0F56,        0x0F57,        0x0F58,        0x0F59,        0x0F60,        0x0F61,        0x0F62,        0x0F63,
	/* U+23A0 */        0x0F64,        0x0F65,        0x0F66,        0x0F67,        0x0F68,        0x0F69,        0x0F70,        0x0F71,
	/* U+23A8 */        0x0F72,        0x0F73,        0x0F74,        0x0F75,        0x0F76,        0x0F77,        0x0F78,        0x0F79,
	/* U+23B0 */        0x0F80,        0x0F81,        0x0F82,        0x0F83,        0x0F84,        0x0F85,        0x0F86,        0x0F87,
	/* U+23B8 */        0x0F88,        0x0F89,        0x0F90,        0x0F91,        0x0F92,        0x0F93,        0x0F94,        0x0F95,
	/* U+23C0 */        0x0F96,        0x0F97,        0x0F98,        0x0F99,        0x0FA0,        0x0FA1,        0x0FA2,        0x0FA3,
	/* U+23C8 */        0x0FA4,        0x0FA5,        0x0FA6,        0x0FA7,        0x0FA8,        0x0FA9,        0x0FB0,        0x0FB1,
	/* U+23D0 */        0x0FB2,        0x0FB3,        0x0FB4,        0x0FB5,        0x0FB6,        0x0FB7,        0x0FB8,        0x0FB9,
	/* U+23D8 */        0x0FC0,        0x0FC1,        0x0FC2,        0x0FC3,        0x0FC4,        0x0FC5,        0x0FC6,        0x0FC7,
	/* U+23E0 */        0x0FC8,        0x0FC9,        0x0FD0,        0x0FD1,        0x0FD2,        0x0FD3,        0x0FD4,        0x0FD5,
	/* U+23E8 */        0x0FD6,        0x0FD7,        0x0FD8,        0x0FD9,        0x1000,        0x1001,        0x1002,        0x1003,
	/* U+23F0 */        0x1004,        0x1005,        0x1006,        0x1007,        0x1008,        0x1009,        0x1010,        0x1011,
	/* U+23F8 */        0x1012,        0x1013,        0x1014,        0x1015,        0x1016,        0x1017,        0x1018,        0x1019,
	/* U+2400 */        0x1020,        0x1021,        0x1022,        0x1023,        0x1024,        0x1025,        0x1026,        0x1027,
	/* U+2408 */        0x1028,        0x1029,        0x1030,        0x1031,        0x1032,        0x1033,        0x1034,        0x1035,
	/* U+2410 */        0x1036,        0x1037,        0x1038,        0x1039,        0x1040,        0x1041,        0x1042,        0x1043,
	/* U+2418 */        0x1044,        0x1045,        0x1046,        0x1047,        0x1048,        0x1049,        0x1050,        0x1051,
	/* U+2420 */        0x1052,        0x1053,        0x1054,        0x1055,        0x1056,        0x1057,        0x1058,        0x1059,
	/* U+2428 */        0x1060,        0x1061,        0x1062,        0x1063,        0x1064,        0x1065,        0x1066,        0x1067,
	/* U+2430 */        0x1068,        0x1069,        0x1070,        0x1071,        0x1072,        0x1073,        0x1074,        0x1075,
	/* U+2438 */        0x1076,        0x1077,        0x1078,        0x1079,        0x1080,        0x1081,        0x1082,        0x1083,
	/* U+2440 */        0x1084,        0x1085,        0x1086,        0x1087,        0x1088,        0x1089,        0x1090,        0x1091,
	/* U+2448 */        0x1092,        0x1093,        0x1094,        0x1095,        0x1096,        0x1097,        0x1098,        0x1099,
	/* U+2450 */        0x10A0,        0x10A1,        0x10A2,        0x10A3,        0x10A4,        0x10A5,        0x10A6,        0x10A7,
	/* U+2458 */        0x10A8,        0x10A9,        0x10B0,        0x10B1,        0x10B2,        0x10B3,        0x10B4,        0x10B5,
	/* U+2460 */        0xA2D9,        0xA2DA,        0xA2DB,        0xA2DC,        0xA2DD,        0xA2DE,        0xA2DF,        0xA2E0,
	/* U+2468 */        0xA2E1,        0xA2E2,        0x10B6,        0x10B7,        0x10B8,        0x10B9,        0x10C0,        0x10C1,
	/* U+2470 */        0x10C2,        0x10C3,        0x10C4,        0x10C5,        0xA2C5,        0xA2C6,        0xA2C7,        0xA2C8,
	/* U+2478 */        0xA2C9,        0xA2CA,        0xA2CB,        0xA2CC,        0xA2CD,        0xA2CE,        0xA2CF,        0xA2D0,
	/* U+2480 */        0xA2D1,        0xA2D2,        0xA2D3,        0xA2D4,        0xA2D5,        0xA2D6,        0xA2D7,        0xA2D8,
	/* U+2488 */        0xA2B1,        0xA2B2,        0xA2B3,        0xA2B4,        0xA2B5,        0xA2B6,        0xA2B7,        0xA2B8,
	/* U+2490 */        0xA2B9,        0xA2BA,        0xA2BB,        0xA2BC,        0xA2BD,        0xA2BE,        0xA2BF,        0xA2C0,
	/* U+2498 */        0xA2C1,        0xA2C2,        0xA2C3,        0xA2C4,        0x10C6,        0x10C7,        0x10C8,        0x10C9,
	/* U+24A0 */        0x10D0,        0x10D1,        0x10D2,        0x10D3,        0x10D4,        0x10D5,        0x10D6,        0x10D7,
	/* U+24A8 */        0x10D8,        0x10D9,        0x10E0,        0x10E1,        0x10E2,        0x10E3,        0x10E4,        0x10E5,
	/* U+24B0 */        0x10E6,        0x10E7,        0x10E8,        0x10E9,        0x10F0,        0x10F1,        0x10F2,        0x10F3,
	/* U+24B8 */        0x10F4,        0x10F5,        0x10F6,        0x10F7,        0x10F8,        0x10F9,        0x1100,        0x1101,
	/* U+24C0 */        0x1102,        0x1103,        0x1104,        0x1105,        0x1106,        0x1107,        0x1108,        0x1109,
	/* U+24C8 */        0x1110,        0x1111,        0x1112,        0x1113,        0x1114,        0x1115,        0x1116,        0x1117,
	/* U+24D0 */        0x1118,        0x1119,        0x1120,        0x1121,        0x1122,        0x1123,        0x1124,        0x1125,
	/* U+24D8 */        0x1126,        0x1127,        0x1128,        0x1129,        0x1130,        0x1131,        0x1132,        0x1133,
	/* U+24E0 */        0x1134,        0x1135,        0x1136,        0x1137,        0x1138,        0x1139,        0x1140,        0x1141,
	/* U+24E8 */        0x1142,        0x1143,        0x1144,        0x1145,        0x1146,        0x1147,        0x1148,        0x1149,
	/* U+24F0 */        0x1150,        0x1151,        0x1152,        0x1153,        0x1154,        0x1155,        0x1156,        0x1157,
	/* U+24F8 */        0x1158,        0x1159,        0x1160,        0x1161,        0x1162,        0x1163,        0x1164,        0x1165,
	/* U+2500 */        0xA9A4,        0xA9A5,        0xA9A6,        0xA9A7,        0xA9A8,        0xA9A9,        0xA9AA,        0xA9AB,
	/* U+2508 */        0xA9AC,        0xA9AD,        0xA9AE,        0xA9AF,        0xA9B0,        0xA9B1,        0xA9B2,        0xA9B3,
	/* U+2510 */        0xA9B4,        0xA9B5,        0xA9B6,        0xA9B7,        0xA9B8,        0xA9B9,        0xA9BA,        0xA9BB,
	/* U+2518 */        0xA9BC,        0xA9BD,        0xA9BE,        0xA9BF,        0xA9C0,        0xA9C1,        0xA9C2,        0xA9C3,
	/* U+2520 */        0xA9C4,        0xA9C5,        0xA9C6,        0xA9C7,        0xA9C8,        0xA9C9,        0xA9CA,        0xA9CB,
	/* U+2528 */        0xA9CC,        0xA9CD,        0xA9CE,        0xA9CF,        0xA9D0,        0xA9D1,        0xA9D2,        0xA9D3,
	/* U+2530 */        0xA9D4,        0xA9D5,        0xA9D6,        0xA9D7,        0xA9D8,        0xA9D9,        0xA9DA,        0xA9DB,
	/* U+2538 */        0xA9DC,        0xA9DD,        0xA9DE,        0xA9DF,        0xA9E0,        0xA9E1,        0xA9E2,        0xA9E3,
	/* U+2540 */        0xA9E4,        0xA9E5,        0xA9E6,        0xA9E7,        0xA9E8,        0xA9E9,        0xA9EA,        0xA9EB,
	/* U+2548 */        0xA9EC,        0xA9ED,        0xA9EE,        0xA9EF,        0x1166,        0x1167,        0x1168,        0x1169,
	/* U+2550 */        0xA854,        0xA855,        0xA856,        0xA857,        0xA858,        0xA859,        0xA85A,        0xA85B,
	/* U+2558 */        0xA85C,        0xA85D,        0xA85E,        0xA85F,        0xA860,        0xA861,        0xA862,        0xA863,
	/* U+2560 */        0xA864,        0xA865,        0xA866,        0xA867,        0xA868,        0xA869,        0xA86A,        0xA86B,
	/* U+2568 */        0xA86C,        0xA86D,        0xA86E,        0xA86F,        0xA870,        0xA871,        0xA872,        0xA873,
	/* U+2570 */        0xA874,        0xA875,        0xA876,        0xA877,        0x1170,        0x1171,        0x1172,        0x1173,
	/* U+2578 */        0x1174,        0x1175,        0x1176,        0x1177,        0x1178,        0x1179,        0x1180,        0x1181,
	/* U+2580 */        0x1182,        0xA878,        0xA879,        0xA87A,        0xA87B,        0xA87C,        0xA87D,        0xA87E,
	/* U+2588 */        0xA880,        0xA881,        0xA882,        0xA883,        0xA884,        0xA885,        0xA886,        0xA887,
	/* U+2590 */        0x1183,        0x1184,        0x1185,        0xA888,        0xA889,        0xA88A,        0x1186,        0x1187,
	/* U+2598 */        0x1188,        0x1189,        0x1190,        0x1191,        0x1192,        0x1193,        0x1194,        0x1195,
	/* U+25A0 */        0xA1F6,        0xA1F5,        0x1196,        0x1197,        0x1198,        0x1199,        0x11A0,        0x11A1,
	/* U+25A8 */        0x11A2,        0x11A3,        0x11A4,        0x11A5,        0x11A6,        0x11A7,        0x11A8,        0x11A9,
	/* U+25B0 */        0x11B0,        0x11B1,        0xA1F8,        0xA1F7,        0x11B2,        0x11B3,        0x11B4,        0x11B5,
	/* U+25B8 */        0x11B6,        0x11B7,        0x11B8,        0x11B9,        0xA88B,        0xA88C,        0x11C0,        0x11C1,
	/* U+25C0 */        0x11C2,        0x11C3,        0x11C4,        0x11C5,        0x11C6,        0x11C7,        0xA1F4,        0xA1F3,
	/* U+25C8 */        0x11C8,        0x11C9,        0x11D0,        0xA1F0,        0x11D1,        0x11D2,        0xA1F2,        0xA1F1,
	/* U+25D0 */        0x11D3,        0x11D4,        0x11D5,        0x11D6,        0x11D7,        0x11D8,        0x11D9,        0x11E0,
	/* U+25D8 */        0x11E1,        0x11E2,        0x11E3,        0x11E4,        0x11E5,        0x11E6,        0x11E7,        0x11E8,
	/* U+25E0 */        0x11E9,        0x11F0,        0xA88D,        0xA88E,        0xA88F,        0xA890,        0x11F1,        0x11F2,
	/* U+25E8 */        0x11F3,        0x11F4,        0x11F5,        0x11F6,        0x11F7,        0x11F8,        0x11F9,        0x1200,
	/* U+25F0 */        0x1201,        0x1202,        0x1203,        0x1204,        0x1205,        0x1206,        0x1207,        0x1208,
	/* U+25F8 */        0x1209,        0x1210,        0x1211,        0x1212,        0x1213,        0x1214,        0x1215,        0x1216,
	/* U+2600 */        0x1217,        0x1218,        0x1219,        0x1220,        0x1221,        0xA1EF,        0xA1EE,        0x1222,
	/* U+2608 */        0x1223,        0xA891,        0x1224,        0x1225,        0x1226,        0x1227,        0x1228,        0x1229,
	/* U+2610 */        0x1230,        0x1231,        0x1232,        0x1233,        0x1234,        0x1235,        0x1236,        0x1237,
	/* U+2618 */        0x1238,        0x1239,        0x1240,        0x1241,        0x1242,        0x1243,        0x1244,        0x1245,
	/* U+2620 */        0x1246,        0x1247,        0x1248,        0x1249,        0x1250,        0x1251,        0x1252,        0x1253,
	/* U+2628 */        0x1254,        0x1255,        0x1256,        0x1257,        0x1258,        0x1259,        0x1260,        0x1261,
	/* U+2630 */        0x1262,        0x1263,        0x1264,        0x1265,        0x1266,        0x1267,        0x1268,        0x1269,
	/* U+2638 */        0x1270,        0x1271,        0x1272,        0x1273,        0x1274,        0x1275,        0x1276,        0x1277,
	/* U+2640 */        0xA1E2,        0x1278,        0xA1E1,
	/* Contiguous area: U+2E81 .. U+361A */
	/* U+2E81 */                0xFE50,        0x1FC9,        0x1FD0,        0xFE54,        0x1FD1,        0x1FD2,        0x1FD3,
	/* U+2E88 */        0xFE57,        0x1FD4,        0x1FD5,        0xFE58,        0xFE5D,        0x1FD6,        0x1FD7,        0x1FD8,
	/* U+2E90 */        0x1FD9,        0x2000,        0x2001,        0x2002,        0x2003,        0x2004,        0x2005,        0xFE5E,
	/* U+2E98 */        0x2006,        0x2007,        0x2008,        0x2009,        0x2010,        0x2011,        0x2012,        0x2013,
	/* U+2EA0 */        0x2014,        0x2015,        0x2016,        0x2017,        0x2018,        0x2019,        0x2020,        0xFE6B,
	/* U+2EA8 */        0x2021,        0x2022,        0xFE6E,        0x2023,        0x2024,        0x2025,        0xFE71,        0x2026,
	/* U+2EB0 */        0x2027,        0x2028,        0x2029,        0xFE73,        0x2030,        0x2031,        0xFE74,        0xFE75,
	/* U+2EB8 */        0x2032,        0x2033,        0x2034,        0xFE79,        0x2035,        0x2036,        0x2037,        0x2038,
	/* U+2EC0 */        0x2039,        0x2040,        0x2041,        0x2042,        0x2043,        0x2044,        0x2045,        0x2046,
	/* U+2EC8 */        0x2047,        0x2048,        0xFE84,        0x2049,        0x2050,        0x2051,        0x2052,        0x2053,
	/* U+2ED0 */        0x2054,        0x2055,        0x2056,        0x2057,        0x2058,        0x2059,        0x2060,        0x2061,
	/* U+2ED8 */        0x2062,        0x2063,        0x2064,        0x2065,        0x2066,        0x2067,        0x2068,        0x2069,
	/* U+2EE0 */        0x2070,        0x2071,        0x2072,        0x2073,        0x2074,        0x2075,        0x2076,        0x2077,
	/* U+2EE8 */        0x2078,        0x2079,        0x2080,        0x2081,        0x2082,        0x2083,        0x2084,        0x2085,
	/* U+2EF0 */        0x2086,        0x2087,        0x2088,        0x2089,        0x2090,        0x2091,        0x2092,        0x2093,
	/* U+2EF8 */        0x2094,        0x2095,        0x2096,        0x2097,        0x2098,        0x2099,        0x20A0,        0x20A1,
	/* U+2F00 */        0x20A2,        0x20A3,        0x20A4,        0x20A5,        0x20A6,        0x20A7,        0x20A8,        0x20A9,
	/* U+2F08 */        0x20B0,        0x20B1,        0x20B2,        0x20B3,        0x20B4,        0x20B5,        0x20B6,        0x20B7,
	/* U+2F10 */        0x20B8,        0x20B9,        0x20C0,        0x20C1,        0x20C2,        0x20C3,        0x20C4,        0x20C5,
	/* U+2F18 */        0x20C6,        0x20C7,        0x20C8,        0x20C9,        0x20D0,        0x20D1,        0x20D2,        0x20D3,
	/* U+2F20 */        0x20D4,        0x20D5,        0x20D6,        0x20D7,        0x20D8,        0x20D9,        0x20E0,        0x20E1,
	/* U+2F28 */        0x20E2,        0x20E3,        0x20E4,        0x20E5,        0x20E6,        0x20E7,        0x20E8,        0x20E9,
	/* U+2F30 */        0x20F0,        0x20F1,        0x20F2,        0x20F3,        0x20F4,        0x20F5,        0x20F6,        0x20F7,
	/* U+2F38 */        0x20F8,        0x20F9,        0x2100,        0x2101,        0x2102,        0x2103,        0x2104,        0x2105,
	/* U+2F40 */        0x2106,        0x2107,        0x2108,        0x2109,        0x2110,        0x2111,        0x2112,        0x2113,
	/* U+2F48 */        0x2114,        0x2115,        0x2116,        0x2117,        0x2118,        0x2119,        0x2120,        0x2121,
	/* U+2F50 */        0x2122,        0x2123,        0x2124,        0x2125,        0x2126,        0x2127,        0x2128,        0x2129,
	/* U+2F58 */        0x2130,        0x2131,        0x2132,        0x2133,        0x2134,        0x2135,        0x2136,        0x2137,
	/* U+2F60 */        0x2138,        0x2139,        0x2140,        0x2141,        0x2142,        0x2143,        0x2144,        0x2145,
	/* U+2F68 */        0x2146,        0x2147,        0x2148,        0x2149,        0x2150,        0x2151,        0x2152,        0x2153,
	/* U+2F70 */        0x2154,        0x2155,        0x2156,        0x2157,        0x2158,        0x2159,        0x2160,        0x2161,
	/* U+2F78 */        0x2162,        0x2163,        0x2164,        0x2165,        0x2166,        0x2167,        0x2168,        0x2169,
	/* U+2F80 */        0x2170,        0x2171,        0x2172,        0x2173,        0x2174,        0x2175,        0x2176,        0x2177,
	/* U+2F88 */        0x2178,        0x2179,        0x2180,        0x2181,        0x2182,        0x2183,        0x2184,        0x2185,
	/* U+2F90 */        0x2186,        0x2187,        0x2188,        0x2189,        0x2190,        0x2191,        0x2192,        0x2193,
	/* U+2F98 */        0x2194,        0x2195,        0x2196,        0x2197,        0x2198,        0x2199,        0x21A0,        0x21A1,
	/* U+2FA0 */        0x21A2,        0x21A3,        0x21A4,        0x21A5,        0x21A6,        0x21A7,        0x21A8,        0x21A9,
	/* U+2FA8 */        0x21B0,        0x21B1,        0x21B2,        0x21B3,        0x21B4,        0x21B5,        0x21B6,        0x21B7,
	/* U+2FB0 */        0x21B8,        0x21B9,        0x21C0,        0x21C1,        0x21C2,        0x21C3,        0x21C4,        0x21C5,
	/* U+2FB8 */        0x21C6,        0x21C7,        0x21C8,        0x21C9,        0x21D0,        0x21D1,        0x21D2,        0x21D3,
	/* U+2FC0 */        0x21D4,        0x21D5,        0x21D6,        0x21D7,        0x21D8,        0x21D9,        0x21E0,        0x21E1,
	/* U+2FC8 */        0x21E2,        0x21E3,        0x21E4,        0x21E5,        0x21E6,        0x21E7,        0x21E8,        0x21E9,
	/* U+2FD0 */        0x21F0,        0x21F1,        0x21F2,        0x21F3,        0x21F4,        0x21F5,        0x21F6,        0x21F7,
	/* U+2FD8 */        0x21F8,        0x21F9,        0x2200,        0x2201,        0x2202,        0x2203,        0x2204,        0x2205,
	/* U+2FE0 */        0x2206,        0x2207,        0x2208,        0x2209,        0x2210,        0x2211,        0x2212,        0x2213,
	/* U+2FE8 */        0x2214,        0x2215,        0x2216,        0x2217,        0x2218,        0x2219,        0x2220,        0x2221,
	/* U+2FF0 */        0xA98A,        0xA98B,        0xA98C,        0xA98D,        0xA98E,        0xA98F,        0xA990,        0xA991,
	/* U+2FF8 */        0xA992,        0xA993,        0xA994,        0xA995,        0x2222,        0x2223,        0x2224,        0x2225,
	/* U+3000 */        0xA1A1,        0xA1A2,        0xA1A3,        0xA1A8,        0x2226,        0xA1A9,        0xA965,        0xA996,
	/* U+3008 */        0xA1B4,        0xA1B5,        0xA1B6,        0xA1B7,        0xA1B8,        0xA1B9,        0xA1BA,        0xA1BB,
	/* U+3010 */        0xA1BE,        0xA1BF,        0xA893,        0xA1FE,        0xA1B2,        0xA1B3,        0xA1BC,        0xA1BD,
	/* U+3018 */        0x2227,        0x2228,        0x2229,        0x2230,        0x2231,        0xA894,        0xA895,        0x2232,
	/* U+3020 */        0x2233,        0xA940,        0xA941,        0xA942,        0xA943,        0xA944,        0xA945,        0xA946,
	/* U+3028 */        0xA947,        0xA948,        0x2234,        0x2235,        0x2236,        0x2237,        0x2238,        0x2239,
	/* U+3030 */        0x2240,        0x2241,        0x2242,        0x2243,        0x2244,        0x2245,        0x2246,        0x2247,
	/* U+3038 */        0x2248,        0x2249,        0x2250,        0x2251,        0x2252,        0x2253,        0xA989,        0x2254,
	/* U+3040 */        0x2255,        0xA4A1,        0xA4A2,        0xA4A3,        0xA4A4,        0xA4A5,        0xA4A6,        0xA4A7,
	/* U+3048 */        0xA4A8,        0xA4A9,        0xA4AA,        0xA4AB,        0xA4AC,        0xA4AD,        0xA4AE,        0xA4AF,
	/* U+3050 */        0xA4B0,        0xA4B1,        0xA4B2,        0xA4B3,        0xA4B4,        0xA4B5,        0xA4B6,        0xA4B7,
	/* U+3058 */        0xA4B8,        0xA4B9,        0xA4BA,        0xA4BB,        0xA4BC,        0xA4BD,        0xA4BE,        0xA4BF,
	/* U+3060 */        0xA4C0,        0xA4C1,        0xA4C2,        0xA4C3,        0xA4C4,        0xA4C5,        0xA4C6,        0xA4C7,
	/* U+3068 */        0xA4C8,        0xA4C9,        0xA4CA,        0xA4CB,        0xA4CC,        0xA4CD,        0xA4CE,        0xA4CF,
	/* U+3070 */        0xA4D0,        0xA4D1,        0xA4D2,        0xA4D3,        0xA4D4,        0xA4D5,        0xA4D6,        0xA4D7,
	/* U+3078 */        0xA4D8,        0xA4D9,        0xA4DA,        0xA4DB,        0xA4DC,        0xA4DD,        0xA4DE,        0xA4DF,
	/* U+3080 */        0xA4E0,        0xA4E1,        0xA4E2,        0xA4E3,        0xA4E4,        0xA4E5,        0xA4E6,        0xA4E7,
	/* U+3088 */        0xA4E8,        0xA4E9,        0xA4EA,        0xA4EB,        0xA4EC,        0xA4ED,        0xA4EE,        0xA4EF,
	/* U+3090 */        0xA4F0,        0xA4F1,        0xA4F2,        0xA4F3,        0x2256,        0x2257,        0x2258,        0x2259,
	/* U+3098 */        0x2260,        0x2261,        0x2262,        0xA961,        0xA962,        0xA966,        0xA967,        0x2263,
	/* U+30A0 */        0x2264,        0xA5A1,        0xA5A2,        0xA5A3,        0xA5A4,        0xA5A5,        0xA5A6,        0xA5A7,
	/* U+30A8 */        0xA5A8,        0xA5A9,        0xA5AA,        0xA5AB,        0xA5AC,        0xA5AD,        0xA5AE,        0xA5AF,
	/* U+30B0 */        0xA5B0,        0xA5B1,        0xA5B2,        0xA5B3,        0xA5B4,        0xA5B5,        0xA5B6,        0xA5B7,
	/* U+30B8 */        0xA5B8,        0xA5B9,        0xA5BA,        0xA5BB,        0xA5BC,        0xA5BD,        0xA5BE,        0xA5BF,
	/* U+30C0 */        0xA5C0,        0xA5C1,        0xA5C2,        0xA5C3,        0xA5C4,        0xA5C5,        0xA5C6,        0xA5C7,
	/* U+30C8 */        0xA5C8,        0xA5C9,        0xA5CA,        0xA5CB,        0xA5CC,        0xA5CD,        0xA5CE,        0xA5CF,
	/* U+30D0 */        0xA5D0,        0xA5D1,        0xA5D2,        0xA5D3,        0xA5D4,        0xA5D5,        0xA5D6,        0xA5D7,
	/* U+30D8 */        0xA5D8,        0xA5D9,        0xA5DA,        0xA5DB,        0xA5DC,        0xA5DD,        0xA5DE,        0xA5DF,
	/* U+30E0 */        0xA5E0,        0xA5E1,        0xA5E2,        0xA5E3,        0xA5E4,        0xA5E5,        0xA5E6,        0xA5E7,
	/* U+30E8 */        0xA5E8,        0xA5E9,        0xA5EA,        0xA5EB,        0xA5EC,        0xA5ED,        0xA5EE,        0xA5EF,
	/* U+30F0 */        0xA5F0,        0xA5F1,        0xA5F2,        0xA5F3,        0xA5F4,        0xA5F5,        0xA5F6,        0x2265,
	/* U+30F8 */        0x2266,        0x2267,        0x2268,        0x2269,        0xA960,        0xA963,        0xA964,        0x2270,
	/* U+3100 */        0x2271,        0x2272,        0x2273,        0x2274,        0x2275,        0xA8C5,        0xA8C6,        0xA8C7,
	/* U+3108 */        0xA8C8,        0xA8C9,        0xA8CA,        0xA8CB,        0xA8CC,        0xA8CD,        0xA8CE,        0xA8CF,
	/* U+3110 */        0xA8D0,        0xA8D1,        0xA8D2,        0xA8D3,        0xA8D4,        0xA8D5,        0xA8D6,        0xA8D7,
	/* U+3118 */        0xA8D8,        0xA8D9,        0xA8DA,        0xA8DB,        0xA8DC,        0xA8DD,        0xA8DE,        0xA8DF,
	/* U+3120 */        0xA8E0,        0xA8E1,        0xA8E2,        0xA8E3,        0xA8E4,        0xA8E5,        0xA8E6,        0xA8E7,
	/* U+3128 */        0xA8E8,        0xA8E9,        0x2276,        0x2277,        0x2278,        0x2279,        0x2280,        0x2281,
	/* U+3130 */        0x2282,        0x2283,        0x2284,        0x2285,        0x2286,        0x2287,        0x2288,        0x2289,
	/* U+3138 */        0x2290,        0x2291,        0x2292,        0x2293,        0x2294,        0x2295,        0x2296,        0x2297,
	/* U+3140 */        0x2298,        0x2299,        0x22A0,        0x22A1,        0x22A2,        0x22A3,        0x22A4,        0x22A5,
	/* U+3148 */        0x22A6,        0x22A7,        0x22A8,        0x22A9,        0x22B0,        0x22B1,        0x22B2,        0x22B3,
	/* U+3150 */        0x22B4,        0x22B5,        0x22B6,        0x22B7,        0x22B8,        0x22B9,        0x22C0,        0x22C1,
	/* U+3158 */        0x22C2,        0x22C3,        0x22C4,        0x22C5,        0x22C6,        0x22C7,        0x22C8,        0x22C9,
	/* U+3160 */        0x22D0,        0x22D1,        0x22D2,        0x22D3,        0x22D4,        0x22D5,        0x22D6,        0x22D7,
	/* U+3168 */        0x22D8,        0x22D9,        0x22E0,        0x22E1,        0x22E2,        0x22E3,        0x22E4,        0x22E5,
	/* U+3170 */        0x22E6,        0x22E7,        0x22E8,        0x22E9,        0x22F0,        0x22F1,        0x22F2,        0x22F3,
	/* U+3178 */        0x22F4,        0x22F5,        0x22F6,        0x22F7,        0x22F8,        0x22F9,        0x2300,        0x2301,
	/* U+3180 */        0x2302,        0x2303,        0x2304,        0x2305,        0x2306,        0x2307,        0x2308,        0x2309,
	/* U+3188 */        0x2310,        0x2311,        0x2312,        0x2313,        0x2314,        0x2315,        0x2316,        0x2317,
	/* U+3190 */        0x2318,        0x2319,        0x2320,        0x2321,        0x2322,        0x2323,        0x2324,        0x2325,
	/* U+3198 */        0x2326,        0x2327,        0x2328,        0x2329,        0x2330,        0x2331,        0x2332,        0x2333,
	/* U+31A0 */        0x2334,        0x2335,        0x2336,        0x2337,        0x2338,        0x2339,        0x2340,        0x2341,
	/* U+31A8 */        0x2342,        0x2343,        0x2344,        0x2345,        0x2346,        0x2347,        0x2348,        0x2349,
	/* U+31B0 */        0x2350,        0x2351,        0x2352,        0x2353,        0x2354,        0x2355,        0x2356,        0x2357,
	/* U+31B8 */        0x2358,        0x2359,        0x2360,        0x2361,        0x2362,        0x2363,        0x2364,        0x2365,
	/* U+31C0 */        0x2366,        0x2367,        0x2368,        0x2369,        0x2370,        0x2371,        0x2372,        0x2373,
	/* U+31C8 */        0x2374,        0x2375,        0x2376,        0x2377,        0x2378,        0x2379,        0x2380,        0x2381,
	/* U+31D0 */        0x2382,        0x2383,        0x2384,        0x2385,        0x2386,        0x2387,        0x2388,        0x2389,
	/* U+31D8 */        0x2390,        0x2391,        0x2392,        0x2393,        0x2394,        0x2395,        0x2396,        0x2397,
	/* U+31E0 */        0x2398,        0x2399,        0x23A0,        0x23A1,        0x23A2,        0x23A3,        0x23A4,        0x23A5,
	/* U+31E8 */        0x23A6,        0x23A7,        0x23A8,        0x23A9,        0x23B0,        0x23B1,        0x23B2,        0x23B3,
	/* U+31F0 */        0x23B4,        0x23B5,        0x23B6,        0x23B7,        0x23B8,        0x23B9,        0x23C0,        0x23C1,
	/* U+31F8 */        0x23C2,        0x23C3,        0x23C4,        0x23C5,        0x23C6,        0x23C7,        0x23C8,        0x23C9,
	/* U+3200 */        0x23D0,        0x23D1,        0x23D2,        0x23D3,        0x23D4,        0x23D5,        0x23D6,        0x23D7,
	/* U+3208 */        0x23D8,        0x23D9,        0x23E0,        0x23E1,        0x23E2,        0x23E3,        0x23E4,        0x23E5,
	/* U+3210 */        0x23E6,        0x23E7,        0x23E8,        0x23E9,        0x23F0,        0x23F1,        0x23F2,        0x23F3,
	/* U+3218 */        0x23F4,        0x23F5,        0x23F6,        0x23F7,        0x23F8,        0x23F9,        0x2400,        0x2401,
	/* U+3220 */        0xA2E5,        0xA2E6,        0xA2E7,        0xA2E8,        0xA2E9,        0xA2EA,        0xA2EB,        0xA2EC,
	/* U+3228 */        0xA2ED,        0xA2EE,        0x2402,        0x2403,        0x2404,        0x2405,        0x2406,        0x2407,
	/* U+3230 */        0x2408,        0xA95A,        0x2409,        0x2410,        0x2411,        0x2412,        0x2413,        0x2414,
	/* U+3238 */        0x2415,        0x2416,        0x2417,        0x2418,        0x2419,        0x2420,        0x2421,        0x2422,
	/* U+3240 */        0x2423,        0x2424,        0x2425,        0x2426,        0x2427,        0x2428,        0x2429,        0x2430,
	/* U+3248 */        0x2431,        0x2432,        0x2433,        0x2434,        0x2435,        0x2436,        0x2437,        0x2438,
	/* U+3250 */        0x2439,        0x2440,        0x2441,        0x2442,        0x2443,        0x2444,        0x2445,        0x2446,
	/* U+3258 */        0x2447,        0x2448,        0x2449,        0x2450,        0x2451,        0x2452,        0x2453,        0x2454,
	/* U+3260 */        0x2455,        0x2456,        0x2457,        0x2458,        0x2459,        0x2460,        0x2461,        0x2462,
	/* U+3268 */        0x2463,        0x2464,        0x2465,        0x2466,        0x2467,        0x2468,        0x2469,        0x2470,
	/* U+3270 */        0x2471,        0x2472,        0x2473,        0x2474,        0x2475,        0x2476,        0x2477,        0x2478,
	/* U+3278 */        0x2479,        0x2480,        0x2481,        0x2482,        0x2483,        0x2484,        0x2485,        0x2486,
	/* U+3280 */        0x2487,        0x2488,        0x2489,        0x2490,        0x2491,        0x2492,        0x2493,        0x2494,
	/* U+3288 */        0x2495,        0x2496,        0x2497,        0x2498,        0x2499,        0x24A0,        0x24A1,        0x24A2,
	/* U+3290 */        0x24A3,        0x24A4,        0x24A5,        0x24A6,        0x24A7,        0x24A8,        0x24A9,        0x24B0,
	/* U+3298 */        0x24B1,        0x24B2,        0x24B3,        0x24B4,        0x24B5,        0x24B6,        0x24B7,        0x24B8,
	/* U+32A0 */        0x24B9,        0x24C0,        0x24C1,        0xA949,        0x24C2,        0x24C3,        0x24C4,        0x24C5,
	/* U+32A8 */        0x24C6,        0x24C7,        0x24C8,        0x24C9,        0x24D0,        0x24D1,        0x24D2,        0x24D3,
	/* U+32B0 */        0x24D4,        0x24D5,        0x24D6,        0x24D7,        0x24D8,        0x24D9,        0x24E0,        0x24E1,
	/* U+32B8 */        0x24E2,        0x24E3,        0x24E4,        0x24E5,        0x24E6,        0x24E7,        0x24E8,        0x24E9,
	/* U+32C0 */        0x24F0,        0x24F1,        0x24F2,        0x24F3,        0x24F4,        0x24F5,        0x24F6,        0x24F7,
	/* U+32C8 */        0x24F8,        0x24F9,        0x2500,        0x2501,        0x2502,        0x2503,        0x2504,        0x2505,
	/* U+32D0 */        0x2506,        0x2507,        0x2508,        0x2509,        0x2510,        0x2511,        0x2512,        0x2513,
	/* U+32D8 */        0x2514,        0x2515,        0x2516,        0x2517,        0x2518,        0x2519,        0x2520,        0x2521,
	/* U+32E0 */        0x2522,        0x2523,        0x2524,        0x2525,        0x2526,        0x2527,        0x2528,        0x2529,
	/* U+32E8 */        0x2530,        0x2531,        0x2532,        0x2533,        0x2534,        0x2535,        0x2536,        0x2537,
	/* U+32F0 */        0x2538,        0x2539,        0x2540,        0x2541,        0x2542,        0x2543,        0x2544,        0x2545,
	/* U+32F8 */        0x2546,        0x2547,        0x2548,        0x2549,        0x2550,        0x2551,        0x2552,        0x2553,
	/* U+3300 */        0x2554,        0x2555,        0x2556,        0x2557,        0x2558,        0x2559,        0x2560,        0x2561,
	/* U+3308 */        0x2562,        0x2563,        0x2564,        0x2565,        0x2566,        0x2567,        0x2568,        0x2569,
	/* U+3310 */        0x2570,        0x2571,        0x2572,        0x2573,        0x2574,        0x2575,        0x2576,        0x2577,
	/* U+3318 */        0x2578,        0x2579,        0x2580,        0x2581,        0x2582,        0x2583,        0x2584,        0x2585,
	/* U+3320 */        0x2586,        0x2587,        0x2588,        0x2589,        0x2590,        0x2591,        0x2592,        0x2593,
	/* U+3328 */        0x2594,        0x2595,        0x2596,        0x2597,        0x2598,        0x2599,        0x25A0,        0x25A1,
	/* U+3330 */        0x25A2,        0x25A3,        0x25A4,        0x25A5,        0x25A6,        0x25A7,        0x25A8,        0x25A9,
	/* U+3338 */        0x25B0,        0x25B1,        0x25B2,        0x25B3,        0x25B4,        0x25B5,        0x25B6,        0x25B7,
	/* U+3340 */        0x25B8,        0x25B9,        0x25C0,        0x25C1,        0x25C2,        0x25C3,        0x25C4,        0x25C5,
	/* U+3348 */        0x25C6,        0x25C7,        0x25C8,        0x25C9,        0x25D0,        0x25D1,        0x25D2,        0x25D3,
	/* U+3350 */        0x25D4,        0x25D5,        0x25D6,        0x25D7,        0x25D8,        0x25D9,        0x25E0,        0x25E1,
	/* U+3358 */        0x25E2,        0x25E3,        0x25E4,        0x25E5,        0x25E6,        0x25E7,        0x25E8,        0x25E9,
	/* U+3360 */        0x25F0,        0x25F1,        0x25F2,        0x25F3,        0x25F4,        0x25F5,        0x25F6,        0x25F7,
	/* U+3368 */        0x25F8,        0x25F9,        0x2600,        0x2601,        0x2602,        0x2603,        0x2604,        0x2605,
	/* U+3370 */        0x2606,        0x2607,        0x2608,        0x2609,        0x2610,        0x2611,        0x2612,        0x2613,
	/* U+3378 */        0x2614,        0x2615,        0x2616,        0x2617,        0x2618,        0x2619,        0x2620,        0x2621,
	/* U+3380 */        0x2622,        0x2623,        0x2624,        0x2625,        0x2626,        0x2627,        0x2628,        0x2629,
	/* U+3388 */        0x2630,        0x2631,        0x2632,        0x2633,        0x2634,        0x2635,        0xA94A,        0xA94B,
	/* U+3390 */        0x2636,        0x2637,        0x2638,        0x2639,        0x2640,        0x2641,        0x2642,        0x2643,
	/* U+3398 */        0x2644,        0x2645,        0x2646,        0x2647,        0xA94C,        0xA94D,        0xA94E,        0x2648,
	/* U+33A0 */        0x2649,        0xA94F,        0x2650,        0x2651,        0x2652,        0x2653,        0x2654,        0x2655,
	/* U+33A8 */        0x2656,        0x2657,        0x2658,        0x2659,        0x2660,        0x2661,        0x2662,        0x2663,
	/* U+33B0 */        0x2664,        0x2665,        0x2666,        0x2667,        0x2668,        0x2669,        0x2670,        0x2671,
	/* U+33B8 */        0x2672,        0x2673,        0x2674,        0x2675,        0x2676,        0x2677,        0x2678,        0x2679,
	/* U+33C0 */        0x2680,        0x2681,        0x2682,        0x2683,        0xA950,        0x2684,        0x2685,        0x2686,
	/* U+33C8 */        0x2687,        0x2688,        0x2689,        0x2690,        0x2691,        0x2692,        0xA951,        0x2693,
	/* U+33D0 */        0x2694,        0xA952,        0xA953,        0x2695,        0x2696,        0xA954,        0x2697,        0x2698,
	/* U+33D8 */        0x2699,        0x26A0,        0x26A1,        0x26A2,        0x26A3,        0x26A4,        0x26A5,        0x26A6,
	/* U+33E0 */        0x26A7,        0x26A8,        0x26A9,        0x26B0,        0x26B1,        0x26B2,        0x26B3,        0x26B4,
	/* U+33E8 */        0x26B5,        0x26B6,        0x26B7,        0x26B8,        0x26B9,        0x26C0,        0x26C1,        0x26C2,
	/* U+33F0 */        0x26C3,        0x26C4,        0x26C5,        0x26C6,        0x26C7,        0x26C8,        0x26C9,        0x26D0,
	/* U+33F8 */        0x26D1,        0x26D2,        0x26D3,        0x26D4,        0x26D5,        0x26D6,        0x26D7,        0x26D8,
	/* U+3400 */        0x26D9,        0x26E0,        0x26E1,        0x26E2,        0x26E3,        0x26E4,        0x26E5,        0x26E6,
	/* U+3408 */        0x26E7,        0x26E8,        0x26E9,        0x26F0,        0x26F1,        0x26F2,        0x26F3,        0x26F4,
	/* U+3410 */        0x26F5,        0x26F6,        0x26F7,        0x26F8,        0x26F9,        0x2700,        0x2701,        0x2702,
	/* U+3418 */        0x2703,        0x2704,        0x2705,        0x2706,        0x2707,        0x2708,        0x2709,        0x2710,
	/* U+3420 */        0x2711,        0x2712,        0x2713,        0x2714,        0x2715,        0x2716,        0x2717,        0x2718,
	/* U+3428 */        0x2719,        0x2720,        0x2721,        0x2722,        0x2723,        0x2724,        0x2725,        0x2726,
	/* U+3430 */        0x2727,        0x2728,        0x2729,        0x2730,        0x2731,        0x2732,        0x2733,        0x2734,
	/* U+3438 */        0x2735,        0x2736,        0x2737,        0x2738,        0x2739,        0x2740,        0x2741,        0x2742,
	/* U+3440 */        0x2743,        0x2744,        0x2745,        0x2746,        0x2747,        0x2748,        0x2749,        0xFE56,
	/* U+3448 */        0x2750,        0x2751,        0x2752,        0x2753,        0x2754,        0x2755,        0x2756,        0x2757,
	/* U+3450 */        0x2758,        0x2759,        0x2760,        0x2761,        0x2762,        0x2763,        0x2764,        0x2765,
	/* U+3458 */        0x2766,        0x2767,        0x2768,        0x2769,        0x2770,        0x2771,        0x2772,        0x2773,
	/* U+3460 */        0x2774,        0x2775,        0x2776,        0x2777,        0x2778,        0x2779,        0x2780,        0x2781,
	/* U+3468 */        0x2782,        0x2783,        0x2784,        0x2785,        0x2786,        0x2787,        0x2788,        0x2789,
	/* U+3470 */        0x2790,        0x2791,        0x2792,        0xFE55,        0x2793,        0x2794,        0x2795,        0x2796,
	/* U+3478 */        0x2797,        0x2798,        0x2799,        0x27A0,        0x27A1,        0x27A2,        0x27A3,        0x27A4,
	/* U+3480 */        0x27A5,        0x27A6,        0x27A7,        0x27A8,        0x27A9,        0x27B0,        0x27B1,        0x27B2,
	/* U+3488 */        0x27B3,        0x27B4,        0x27B5,        0x27B6,        0x27B7,        0x27B8,        0x27B9,        0x27C0,
	/* U+3490 */        0x27C1,        0x27C2,        0x27C3,        0x27C4,        0x27C5,        0x27C6,        0x27C7,        0x27C8,
	/* U+3498 */        0x27C9,        0x27D0,        0x27D1,        0x27D2,        0x27D3,        0x27D4,        0x27D5,        0x27D6,
	/* U+34A0 */        0x27D7,        0x27D8,        0x27D9,        0x3000,        0x3001,        0x3002,        0x3003,        0x3004,
	/* U+34A8 */        0x3005,        0x3006,        0x3007,        0x3008,        0x3009,        0x3010,        0x3011,        0x3012,
	/* U+34B0 */        0x3013,        0x3014,        0x3015,        0x3016,        0x3017,        0x3018,        0x3019,        0x3020,
	/* U+34B8 */        0x3021,        0x3022,        0x3023,        0x3024,        0x3025,        0x3026,        0x3027,        0x3028,
	/* U+34C0 */        0x3029,        0x3030,        0x3031,        0x3032,        0x3033,        0x3034,        0x3035,        0x3036,
	/* U+34C8 */        0x3037,        0x3038,        0x3039,        0x3040,        0x3041,        0x3042,        0x3043,        0x3044,
	/* U+34D0 */        0x3045,        0x3046,        0x3047,        0x3048,        0x3049,        0x3050,        0x3051,        0x3052,
	/* U+34D8 */        0x3053,        0x3054,        0x3055,        0x3056,        0x3057,        0x3058,        0x3059,        0x3060,
	/* U+34E0 */        0x3061,        0x3062,        0x3063,        0x3064,        0x3065,        0x3066,        0x3067,        0x3068,
	/* U+34E8 */        0x3069,        0x3070,        0x3071,        0x3072,        0x3073,        0x3074,        0x3075,        0x3076,
	/* U+34F0 */        0x3077,        0x3078,        0x3079,        0x3080,        0x3081,        0x3082,        0x3083,        0x3084,
	/* U+34F8 */        0x3085,        0x3086,        0x3087,        0x3088,        0x3089,        0x3090,        0x3091,        0x3092,
	/* U+3500 */        0x3093,        0x3094,        0x3095,        0x3096,        0x3097,        0x3098,        0x3099,        0x30A0,
	/* U+3508 */        0x30A1,        0x30A2,        0x30A3,        0x30A4,        0x30A5,        0x30A6,        0x30A7,        0x30A8,
	/* U+3510 */        0x30A9,        0x30B0,        0x30B1,        0x30B2,        0x30B3,        0x30B4,        0x30B5,        0x30B6,
	/* U+3518 */        0x30B7,        0x30B8,        0x30B9,        0x30C0,        0x30C1,        0x30C2,        0x30C3,        0x30C4,
	/* U+3520 */        0x30C5,        0x30C6,        0x30C7,        0x30C8,        0x30C9,        0x30D0,        0x30D1,        0x30D2,
	/* U+3528 */        0x30D3,        0x30D4,        0x30D5,        0x30D6,        0x30D7,        0x30D8,        0x30D9,        0x30E0,
	/* U+3530 */        0x30E1,        0x30E2,        0x30E3,        0x30E4,        0x30E5,        0x30E6,        0x30E7,        0x30E8,
	/* U+3538 */        0x30E9,        0x30F0,        0x30F1,        0x30F2,        0x30F3,        0x30F4,        0x30F5,        0x30F6,
	/* U+3540 */        0x30F7,        0x30F8,        0x30F9,        0x3100,        0x3101,        0x3102,        0x3103,        0x3104,
	/* U+3548 */        0x3105,        0x3106,        0x3107,        0x3108,        0x3109,        0x3110,        0x3111,        0x3112,
	/* U+3550 */        0x3113,        0x3114,        0x3115,        0x3116,        0x3117,        0x3118,        0x3119,        0x3120,
	/* U+3558 */        0x3121,        0x3122,        0x3123,        0x3124,        0x3125,        0x3126,        0x3127,        0x3128,
	/* U+3560 */        0x3129,        0x3130,        0x3131,        0x3132,        0x3133,        0x3134,        0x3135,        0x3136,
	/* U+3568 */        0x3137,        0x3138,        0x3139,        0x3140,        0x3141,        0x3142,        0x3143,        0x3144,
	/* U+3570 */        0x3145,        0x3146,        0x3147,        0x3148,        0x3149,        0x3150,        0x3151,        0x3152,
	/* U+3578 */        0x3153,        0x3154,        0x3155,        0x3156,        0x3157,        0x3158,        0x3159,        0x3160,
	/* U+3580 */        0x3161,        0x3162,        0x3163,        0x3164,        0x3165,        0x3166,        0x3167,        0x3168,
	/* U+3588 */        0x3169,        0x3170,        0x3171,        0x3172,        0x3173,        0x3174,        0x3175,        0x3176,
	/* U+3590 */        0x3177,        0x3178,        0x3179,        0x3180,        0x3181,        0x3182,        0x3183,        0x3184,
	/* U+3598 */        0x3185,        0x3186,        0x3187,        0x3188,        0x3189,        0x3190,        0xFE5A,        0x3191,
	/* U+35A0 */        0x3192,        0x3193,        0x3194,        0x3195,        0x3196,        0x3197,        0x3198,        0x3199,
	/* U+35A8 */        0x31A0,        0x31A1,        0x31A2,        0x31A3,        0x31A4,        0x31A5,        0x31A6,        0x31A7,
	/* U+35B0 */        0x31A8,        0x31A9,        0x31B0,        0x31B1,        0x31B2,        0x31B3,        0x31B4,        0x31B5,
	/* U+35B8 */        0x31B6,        0x31B7,        0x31B8,        0x31B9,        0x31C0,        0x31C1,        0x31C2,        0x31C3,
	/* U+35C0 */        0x31C4,        0x31C5,        0x31C6,        0x31C7,        0x31C8,        0x31C9,        0x31D0,        0x31D1,
	/* U+35C8 */        0x31D2,        0x31D3,        0x31D4,        0x31D5,        0x31D6,        0x31D7,        0x31D8,        0x31D9,
	/* U+35D0 */        0x31E0,        0x31E1,        0x31E2,        0x31E3,        0x31E4,        0x31E5,        0x31E6,        0x31E7,
	/* U+35D8 */        0x31E8,        0x31E9,        0x31F0,        0x31F1,        0x31F2,        0x31F3,        0x31F4,        0x31F5,
	/* U+35E0 */        0x31F6,        0x31F7,        0x31F8,        0x31F9,        0x3200,        0x3201,        0x3202,        0x3203,
	/* U+35E8 */        0x3204,        0x3205,        0x3206,        0x3207,        0x3208,        0x3209,        0x3210,        0x3211,
	/* U+35F0 */        0x3212,        0x3213,        0x3214,        0x3215,        0x3216,        0x3217,        0x3218,        0x3219,
	/* U+35F8 */        0x3220,        0x3221,        0x3222,        0x3223,        0x3224,        0x3225,        0x3226,        0x3227,
	/* U+3600 */        0x3228,        0x3229,        0x3230,        0x3231,        0x3232,        0x3233,        0x3234,        0x3235,
	/* U+3608 */        0x3236,        0x3237,        0x3238,        0x3239,        0x3240,        0x3241,        0xFE5C,        0x3242,
	/* U+3610 */        0x3243,        0x3244,        0x3245,        0x3246,        0x3247,        0x3248,        0x3249,        0x3250,
	/* U+3618 */        0x3251,        0x3252,        0xFE5B,
	/* Contiguous area: U+3918 .. U+3CE0 */
	/* U+3918 */        0xFE60,        0x3718,        0x3719,        0x3720,        0x3721,        0x3722,        0x3723,        0x3724,
	/* U+3920 */        0x3725,        0x3726,        0x3727,        0x3728,        0x3729,        0x3730,        0x3731,        0x3732,
	/* U+3928 */        0x3733,        0x3734,        0x3735,        0x3736,        0x3737,        0x3738,        0x3739,        0x3740,
	/* U+3930 */        0x3741,        0x3742,        0x3743,        0x3744,        0x3745,        0x3746,        0x3747,        0x3748,
	/* U+3938 */        0x3749,        0x3750,        0x3751,        0x3752,        0x3753,        0x3754,        0x3755,        0x3756,
	/* U+3940 */        0x3757,        0x3758,        0x3759,        0x3760,        0x3761,        0x3762,        0x3763,        0x3764,
	/* U+3948 */        0x3765,        0x3766,        0x3767,        0x3768,        0x3769,        0x3770,        0x3771,        0x3772,
	/* U+3950 */        0x3773,        0x3774,        0x3775,        0x3776,        0x3777,        0x3778,        0x3779,        0x3780,
	/* U+3958 */        0x3781,        0x3782,        0x3783,        0x3784,        0x3785,        0x3786,        0x3787,        0x3788,
	/* U+3960 */        0x3789,        0x3790,        0x3791,        0x3792,        0x3793,        0x3794,        0x3795,        0x3796,
	/* U+3968 */        0x3797,        0x3798,        0x3799,        0x37A0,        0x37A1,        0x37A2,        0xFE5F,        0x37A3,
	/* U+3970 */        0x37A4,        0x37A5,        0x37A6,        0x37A7,        0x37A8,        0x37A9,        0x37B0,        0x37B1,
	/* U+3978 */        0x37B2,        0x37B3,        0x37B4,        0x37B5,        0x37B6,        0x37B7,        0x37B8,        0x37B9,
	/* U+3980 */        0x37C0,        0x37C1,        0x37C2,        0x37C3,        0x37C4,        0x37C5,        0x37C6,        0x37C7,
	/* U+3988 */        0x37C8,        0x37C9,        0x37D0,        0x37D1,        0x37D2,        0x37D3,        0x37D4,        0x37D5,
	/* U+3990 */        0x37D6,        0x37D7,        0x37D8,        0x37D9,        0x3800,        0x3801,        0x3802,        0x3803,
	/* U+3998 */        0x3804,        0x3805,        0x3806,        0x3807,        0x3808,        0x3809,        0x3810,        0x3811,
	/* U+39A0 */        0x3812,        0x3813,        0x3814,        0x3815,        0x3816,        0x3817,        0x3818,        0x3819,
	/* U+39A8 */        0x3820,        0x3821,        0x3822,        0x3823,        0x3824,        0x3825,        0x3826,        0x3827,
	/* U+39B0 */        0x3828,        0x3829,        0x3830,        0x3831,        0x3832,        0x3833,        0x3834,        0x3835,
	/* U+39B8 */        0x3836,        0x3837,        0x3838,        0x3839,        0x3840,        0x3841,        0x3842,        0x3843,
	/* U+39C0 */        0x3844,        0x3845,        0x3846,        0x3847,        0x3848,        0x3849,        0x3850,        0x3851,
	/* U+39C8 */        0x3852,        0x3853,        0x3854,        0x3855,        0x3856,        0x3857,        0x3858,        0xFE62,
	/* U+39D0 */        0xFE65,        0x3859,        0x3860,        0x3861,        0x3862,        0x3863,        0x3864,        0x3865,
	/* U+39D8 */        0x3866,        0x3867,        0x3868,        0x3869,        0x3870,        0x3871,        0x3872,        0xFE63,
	/* U+39E0 */        0x3873,        0x3874,        0x3875,        0x3876,        0x3877,        0x3878,        0x3879,        0x3880,
	/* U+39E8 */        0x3881,        0x3882,        0x3883,        0x3884,        0x3885,        0x3886,        0x3887,        0x3888,
	/* U+39F0 */        0x3889,        0x3890,        0x3891,        0x3892,        0x3893,        0x3894,        0x3895,        0x3896,
	/* U+39F8 */        0x3897,        0x3898,        0x3899,        0x38A0,        0x38A1,        0x38A2,        0x38A3,        0x38A4,
	/* U+3A00 */        0x38A5,        0x38A6,        0x38A7,        0x38A8,        0x38A9,        0x38B0,        0x38B1,        0x38B2,
	/* U+3A08 */        0x38B3,        0x38B4,        0x38B5,        0x38B6,        0x38B7,        0x38B8,        0x38B9,        0x38C0,
	/* U+3A10 */        0x38C1,        0x38C2,        0x38C3,        0x38C4,        0x38C5,        0x38C6,        0x38C7,        0x38C8,
	/* U+3A18 */        0x38C9,        0x38D0,        0x38D1,        0x38D2,        0x38D3,        0x38D4,        0x38D5,        0x38D6,
	/* U+3A20 */        0x38D7,        0x38D8,        0x38D9,        0x38E0,        0x38E1,        0x38E2,        0x38E3,        0x38E4,
	/* U+3A28 */        0x38E5,        0x38E6,        0x38E7,        0x38E8,        0x38E9,        0x38F0,        0x38F1,        0x38F2,
	/* U+3A30 */        0x38F3,        0x38F4,        0x38F5,        0x38F6,        0x38F7,        0x38F8,        0x38F9,        0x3900,
	/* U+3A38 */        0x3901,        0x3902,        0x3903,        0x3904,        0x3905,        0x3906,        0x3907,        0x3908,
	/* U+3A40 */        0x3909,        0x3910,        0x3911,        0x3912,        0x3913,        0x3914,        0x3915,        0x3916,
	/* U+3A48 */        0x3917,        0x3918,        0x3919,        0x3920,        0x3921,        0x3922,        0x3923,        0x3924,
	/* U+3A50 */        0x3925,        0x3926,        0x3927,        0x3928,        0x3929,        0x3930,        0x3931,        0x3932,
	/* U+3A58 */        0x3933,        0x3934,        0x3935,        0x3936,        0x3937,        0x3938,        0x3939,        0x3940,
	/* U+3A60 */        0x3941,        0x3942,        0x3943,        0x3944,        0x3945,        0x3946,        0x3947,        0x3948,
	/* U+3A68 */        0x3949,        0x3950,        0x3951,        0x3952,        0x3953,        0x3954,        0x3955,        0x3956,
	/* U+3A70 */        0x3957,        0x3958,        0x3959,        0xFE64,        0x3960,        0x3961,        0x3962,        0x3963,
	/* U+3A78 */        0x3964,        0x3965,        0x3966,        0x3967,        0x3968,        0x3969,        0x3970,        0x3971,
	/* U+3A80 */        0x3972,        0x3973,        0x3974,        0x3975,        0x3976,        0x3977,        0x3978,        0x3979,
	/* U+3A88 */        0x3980,        0x3981,        0x3982,        0x3983,        0x3984,        0x3985,        0x3986,        0x3987,
	/* U+3A90 */        0x3988,        0x3989,        0x3990,        0x3991,        0x3992,        0x3993,        0x3994,        0x3995,
	/* U+3A98 */        0x3996,        0x3997,        0x3998,        0x3999,        0x39A0,        0x39A1,        0x39A2,        0x39A3,
	/* U+3AA0 */        0x39A4,        0x39A5,        0x39A6,        0x39A7,        0x39A8,        0x39A9,        0x39B0,        0x39B1,
	/* U+3AA8 */        0x39B2,        0x39B3,        0x39B4,        0x39B5,        0x39B6,        0x39B7,        0x39B8,        0x39B9,
	/* U+3AB0 */        0x39C0,        0x39C1,        0x39C2,        0x39C3,        0x39C4,        0x39C5,        0x39C6,        0x39C7,
	/* U+3AB8 */        0x39C8,        0x39C9,        0x39D0,        0x39D1,        0x39D2,        0x39D3,        0x39D4,        0x39D5,
	/* U+3AC0 */        0x39D6,        0x39D7,        0x39D8,        0x39D9,        0x39E0,        0x39E1,        0x39E2,        0x39E3,
	/* U+3AC8 */        0x39E4,        0x39E5,        0x39E6,        0x39E7,        0x39E8,        0x39E9,        0x39F0,        0x39F1,
	/* U+3AD0 */        0x39F2,        0x39F3,        0x39F4,        0x39F5,        0x39F6,        0x39F7,        0x39F8,        0x39F9,
	/* U+3AD8 */        0x3A00,        0x3A01,        0x3A02,        0x3A03,        0x3A04,        0x3A05,        0x3A06,        0x3A07,
	/* U+3AE0 */        0x3A08,        0x3A09,        0x3A10,        0x3A11,        0x3A12,        0x3A13,        0x3A14,        0x3A15,
	/* U+3AE8 */        0x3A16,        0x3A17,        0x3A18,        0x3A19,        0x3A20,        0x3A21,        0x3A22,        0x3A23,
	/* U+3AF0 */        0x3A24,        0x3A25,        0x3A26,        0x3A27,        0x3A28,        0x3A29,        0x3A30,        0x3A31,
	/* U+3AF8 */        0x3A32,        0x3A33,        0x3A34,        0x3A35,        0x3A36,        0x3A37,        0x3A38,        0x3A39,
	/* U+3B00 */        0x3A40,        0x3A41,        0x3A42,        0x3A43,        0x3A44,        0x3A45,        0x3A46,        0x3A47,
	/* U+3B08 */        0x3A48,        0x3A49,        0x3A50,        0x3A51,        0x3A52,        0x3A53,        0x3A54,        0x3A55,
	/* U+3B10 */        0x3A56,        0x3A57,        0x3A58,        0x3A59,        0x3A60,        0x3A61,        0x3A62,        0x3A63,
	/* U+3B18 */        0x3A64,        0x3A65,        0x3A66,        0x3A67,        0x3A68,        0x3A69,        0x3A70,        0x3A71,
	/* U+3B20 */        0x3A72,        0x3A73,        0x3A74,        0x3A75,        0x3A76,        0x3A77,        0x3A78,        0x3A79,
	/* U+3B28 */        0x3A80,        0x3A81,        0x3A82,        0x3A83,        0x3A84,        0x3A85,        0x3A86,        0x3A87,
	/* U+3B30 */        0x3A88,        0x3A89,        0x3A90,        0x3A91,        0x3A92,        0x3A93,        0x3A94,        0x3A95,
	/* U+3B38 */        0x3A96,        0x3A97,        0x3A98,        0x3A99,        0x3AA0,        0x3AA1,        0x3AA2,        0x3AA3,
	/* U+3B40 */        0x3AA4,        0x3AA5,        0x3AA6,        0x3AA7,        0x3AA8,        0x3AA9,        0x3AB0,        0x3AB1,
	/* U+3B48 */        0x3AB2,        0x3AB3,        0x3AB4,        0x3AB5,        0x3AB6,        0x3AB7,        0xFE68,        0x3AB8,
	/* U+3B50 */        0x3AB9,        0x3AC0,        0x3AC1,        0x3AC2,        0x3AC3,        0x3AC4,        0x3AC5,        0x3AC6,
	/* U+3B58 */        0x3AC7,        0x3AC8,        0x3AC9,        0x3AD0,        0x3AD1,        0x3AD2,        0x3AD3,        0x3AD4,
	/* U+3B60 */        0x3AD5,        0x3AD6,        0x3AD7,        0x3AD8,        0x3AD9,        0x3AE0,        0x3AE1,        0x3AE2,
	/* U+3B68 */        0x3AE3,        0x3AE4,        0x3AE5,        0x3AE6,        0x3AE7,        0x3AE8,        0x3AE9,        0x3AF0,
	/* U+3B70 */        0x3AF1,        0x3AF2,        0x3AF3,        0x3AF4,        0x3AF5,        0x3AF6,        0x3AF7,        0x3AF8,
	/* U+3B78 */        0x3AF9,        0x3B00,        0x3B01,        0x3B02,        0x3B03,        0x3B04,        0x3B05,        0x3B06,
	/* U+3B80 */        0x3B07,        0x3B08,        0x3B09,        0x3B10,        0x3B11,        0x3B12,        0x3B13,        0x3B14,
	/* U+3B88 */        0x3B15,        0x3B16,        0x3B17,        0x3B18,        0x3B19,        0x3B20,        0x3B21,        0x3B22,
	/* U+3B90 */        0x3B23,        0x3B24,        0x3B25,        0x3B26,        0x3B27,        0x3B28,        0x3B29,        0x3B30,
	/* U+3B98 */        0x3B31,        0x3B32,        0x3B33,        0x3B34,        0x3B35,        0x3B36,        0x3B37,        0x3B38,
	/* U+3BA0 */        0x3B39,        0x3B40,        0x3B41,        0x3B42,        0x3B43,        0x3B44,        0x3B45,        0x3B46,
	/* U+3BA8 */        0x3B47,        0x3B48,        0x3B49,        0x3B50,        0x3B51,        0x3B52,        0x3B53,        0x3B54,
	/* U+3BB0 */        0x3B55,        0x3B56,        0x3B57,        0x3B58,        0x3B59,        0x3B60,        0x3B61,        0x3B62,
	/* U+3BB8 */        0x3B63,        0x3B64,        0x3B65,        0x3B66,        0x3B67,        0x3B68,        0x3B69,        0x3B70,
	/* U+3BC0 */        0x3B71,        0x3B72,        0x3B73,        0x3B74,        0x3B75,        0x3B76,        0x3B77,        0x3B78,
	/* U+3BC8 */        0x3B79,        0x3B80,        0x3B81,        0x3B82,        0x3B83,        0x3B84,        0x3B85,        0x3B86,
	/* U+3BD0 */        0x3B87,        0x3B88,        0x3B89,        0x3B90,        0x3B91,        0x3B92,        0x3B93,        0x3B94,
	/* U+3BD8 */        0x3B95,        0x3B96,        0x3B97,        0x3B98,        0x3B99,        0x3BA0,        0x3BA1,        0x3BA2,
	/* U+3BE0 */        0x3BA3,        0x3BA4,        0x3BA5,        0x3BA6,        0x3BA7,        0x3BA8,        0x3BA9,        0x3BB0,
	/* U+3BE8 */        0x3BB1,        0x3BB2,        0x3BB3,        0x3BB4,        0x3BB5,        0x3BB6,        0x3BB7,        0x3BB8,
	/* U+3BF0 */        0x3BB9,        0x3BC0,        0x3BC1,        0x3BC2,        0x3BC3,        0x3BC4,        0x3BC5,        0x3BC6,
	/* U+3BF8 */        0x3BC7,        0x3BC8,        0x3BC9,        0x3BD0,        0x3BD1,        0x3BD2,        0x3BD3,        0x3BD4,
	/* U+3C00 */        0x3BD5,        0x3BD6,        0x3BD7,        0x3BD8,        0x3BD9,        0x3BE0,        0x3BE1,        0x3BE2,
	/* U+3C08 */        0x3BE3,        0x3BE4,        0x3BE5,        0x3BE6,        0x3BE7,        0x3BE8,        0x3BE9,        0x3BF0,
	/* U+3C10 */        0x3BF1,        0x3BF2,        0x3BF3,        0x3BF4,        0x3BF5,        0x3BF6,        0x3BF7,        0x3BF8,
	/* U+3C18 */        0x3BF9,        0x3C00,        0x3C01,        0x3C02,        0x3C03,        0x3C04,        0x3C05,        0x3C06,
	/* U+3C20 */        0x3C07,        0x3C08,        0x3C09,        0x3C10,        0x3C11,        0x3C12,        0x3C13,        0x3C14,
	/* U+3C28 */        0x3C15,        0x3C16,        0x3C17,        0x3C18,        0x3C19,        0x3C20,        0x3C21,        0x3C22,
	/* U+3C30 */        0x3C23,        0x3C24,        0x3C25,        0x3C26,        0x3C27,        0x3C28,        0x3C29,        0x3C30,
	/* U+3C38 */        0x3C31,        0x3C32,        0x3C33,        0x3C34,        0x3C35,        0x3C36,        0x3C37,        0x3C38,
	/* U+3C40 */        0x3C39,        0x3C40,        0x3C41,        0x3C42,        0x3C43,        0x3C44,        0x3C45,        0x3C46,
	/* U+3C48 */        0x3C47,        0x3C48,        0x3C49,        0x3C50,        0x3C51,        0x3C52,        0x3C53,        0x3C54,
	/* U+3C50 */        0x3C55,        0x3C56,        0x3C57,        0x3C58,        0x3C59,        0x3C60,        0x3C61,        0x3C62,
	/* U+3C58 */        0x3C63,        0x3C64,        0x3C65,        0x3C66,        0x3C67,        0x3C68,        0x3C69,        0x3C70,
	/* U+3C60 */        0x3C71,        0x3C72,        0x3C73,        0x3C74,        0x3C75,        0x3C76,        0x3C77,        0x3C78,
	/* U+3C68 */        0x3C79,        0x3C80,        0x3C81,        0x3C82,        0x3C83,        0x3C84,        0xFE69,        0x3C85,
	/* U+3C70 */        0x3C86,        0x3C87,        0x3C88,        0x3C89,        0x3C90,        0x3C91,        0x3C92,        0x3C93,
	/* U+3C78 */        0x3C94,        0x3C95,        0x3C96,        0x3C97,        0x3C98,        0x3C99,        0x3CA0,        0x3CA1,
	/* U+3C80 */        0x3CA2,        0x3CA3,        0x3CA4,        0x3CA5,        0x3CA6,        0x3CA7,        0x3CA8,        0x3CA9,
	/* U+3C88 */        0x3CB0,        0x3CB1,        0x3CB2,        0x3CB3,        0x3CB4,        0x3CB5,        0x3CB6,        0x3CB7,
	/* U+3C90 */        0x3CB8,        0x3CB9,        0x3CC0,        0x3CC1,        0x3CC2,        0x3CC3,        0x3CC4,        0x3CC5,
	/* U+3C98 */        0x3CC6,        0x3CC7,        0x3CC8,        0x3CC9,        0x3CD0,        0x3CD1,        0x3CD2,        0x3CD3,
	/* U+3CA0 */        0x3CD4,        0x3CD5,        0x3CD6,        0x3CD7,        0x3CD8,        0x3CD9,        0x3CE0,        0x3CE1,
	/* U+3CA8 */        0x3CE2,        0x3CE3,        0x3CE4,        0x3CE5,        0x3CE6,        0x3CE7,        0x3CE8,        0x3CE9,
	/* U+3CB0 */        0x3CF0,        0x3CF1,        0x3CF2,        0x3CF3,        0x3CF4,        0x3CF5,        0x3CF6,        0x3CF7,
	/* U+3CB8 */        0x3CF8,        0x3CF9,        0x3D00,        0x3D01,        0x3D02,        0x3D03,        0x3D04,        0x3D05,
	/* U+3CC0 */        0x3D06,        0x3D07,        0x3D08,        0x3D09,        0x3D10,        0x3D11,        0x3D12,        0x3D13,
	/* U+3CC8 */        0x3D14,        0x3D15,        0x3D16,        0x3D17,        0x3D18,        0x3D19,        0x3D20,        0x3D21,
	/* U+3CD0 */        0x3D22,        0x3D23,        0x3D24,        0x3D25,        0x3D26,        0x3D27,        0x3D28,        0x3D29,
	/* U+3CD8 */        0x3D30,        0x3D31,        0x3D32,        0x3D33,        0x3D34,        0x3D35,        0x3D36,        0x3D37,
	/* U+3CE0 */        0xFE6A,
	/* Contiguous area: U+4056 .. U+415F */
	/* U+4056 */                                                        0xFE6F,        0x42E3,
	/* U+4058 */        0x42E4,        0x42E5,        0x42E6,        0x42E7,        0x42E8,        0x42E9,        0x42F0,        0x42F1,
	/* U+4060 */        0x42F2,        0x42F3,        0x42F4,        0x42F5,        0x42F6,        0x42F7,        0x42F8,        0x42F9,
	/* U+4068 */        0x4300,        0x4301,        0x4302,        0x4303,        0x4304,        0x4305,        0x4306,        0x4307,
	/* U+4070 */        0x4308,        0x4309,        0x4310,        0x4311,        0x4312,        0x4313,        0x4314,        0x4315,
	/* U+4078 */        0x4316,        0x4317,        0x4318,        0x4319,        0x4320,        0x4321,        0x4322,        0x4323,
	/* U+4080 */        0x4324,        0x4325,        0x4326,        0x4327,        0x4328,        0x4329,        0x4330,        0x4331,
	/* U+4088 */        0x4332,        0x4333,        0x4334,        0x4335,        0x4336,        0x4337,        0x4338,        0x4339,
	/* U+4090 */        0x4340,        0x4341,        0x4342,        0x4343,        0x4344,        0x4345,        0x4346,        0x4347,
	/* U+4098 */        0x4348,        0x4349,        0x4350,        0x4351,        0x4352,        0x4353,        0x4354,        0x4355,
	/* U+40A0 */        0x4356,        0x4357,        0x4358,        0x4359,        0x4360,        0x4361,        0x4362,        0x4363,
	/* U+40A8 */        0x4364,        0x4365,        0x4366,        0x4367,        0x4368,        0x4369,        0x4370,        0x4371,
	/* U+40B0 */        0x4372,        0x4373,        0x4374,        0x4375,        0x4376,        0x4377,        0x4378,        0x4379,
	/* U+40B8 */        0x4380,        0x4381,        0x4382,        0x4383,        0x4384,        0x4385,        0x4386,        0x4387,
	/* U+40C0 */        0x4388,        0x4389,        0x4390,        0x4391,        0x4392,        0x4393,        0x4394,        0x4395,
	/* U+40C8 */        0x4396,        0x4397,        0x4398,        0x4399,        0x43A0,        0x43A1,        0x43A2,        0x43A3,
	/* U+40D0 */        0x43A4,        0x43A5,        0x43A6,        0x43A7,        0x43A8,        0x43A9,        0x43B0,        0x43B1,
	/* U+40D8 */        0x43B2,        0x43B3,        0x43B4,        0x43B5,        0x43B6,        0x43B7,        0x43B8,        0x43B9,
	/* U+40E0 */        0x43C0,        0x43C1,        0x43C2,        0x43C3,        0x43C4,        0x43C5,        0x43C6,        0x43C7,
	/* U+40E8 */        0x43C8,        0x43C9,        0x43D0,        0x43D1,        0x43D2,        0x43D3,        0x43D4,        0x43D5,
	/* U+40F0 */        0x43D6,        0x43D7,        0x43D8,        0x43D9,        0x43E0,        0x43E1,        0x43E2,        0x43E3,
	/* U+40F8 */        0x43E4,        0x43E5,        0x43E6,        0x43E7,        0x43E8,        0x43E9,        0x43F0,        0x43F1,
	/* U+4100 */        0x43F2,        0x43F3,        0x43F4,        0x43F5,        0x43F6,        0x43F7,        0x43F8,        0x43F9,
	/* U+4108 */        0x4400,        0x4401,        0x4402,        0x4403,        0x4404,        0x4405,        0x4406,        0x4407,
	/* U+4110 */        0x4408,        0x4409,        0x4410,        0x4411,        0x4412,        0x4413,        0x4414,        0x4415,
	/* U+4118 */        0x4416,        0x4417,        0x4418,        0x4419,        0x4420,        0x4421,        0x4422,        0x4423,
	/* U+4120 */        0x4424,        0x4425,        0x4426,        0x4427,        0x4428,        0x4429,        0x4430,        0x4431,
	/* U+4128 */        0x4432,        0x4433,        0x4434,        0x4435,        0x4436,        0x4437,        0x4438,        0x4439,
	/* U+4130 */        0x4440,        0x4441,        0x4442,        0x4443,        0x4444,        0x4445,        0x4446,        0x4447,
	/* U+4138 */        0x4448,        0x4449,        0x4450,        0x4451,        0x4452,        0x4453,        0x4454,        0x4455,
	/* U+4140 */        0x4456,        0x4457,        0x4458,        0x4459,        0x4460,        0x4461,        0x4462,        0x4463,
	/* U+4148 */        0x4464,        0x4465,        0x4466,        0x4467,        0x4468,        0x4469,        0x4470,        0x4471,
	/* U+4150 */        0x4472,        0x4473,        0x4474,        0x4475,        0x4476,        0x4477,        0x4478,        0x4479,
	/* U+4158 */        0x4480,        0x4481,        0x4482,        0x4483,        0x4484,        0x4485,        0x4486,        0xFE70,
	/* Contiguous area: U+4337 .. U+44D6 */
	/* U+4337 */                                                                0xFE72,
	/* U+4338 */        0x4778,        0x4779,        0x4780,        0x4781,        0x4782,        0x4783,        0x4784,        0x4785,
	/* U+4340 */        0x4786,        0x4787,        0x4788,        0x4789,        0x4790,        0x4791,        0x4792,        0x4793,
	/* U+4348 */        0x4794,        0x4795,        0x4796,        0x4797,        0x4798,        0x4799,        0x47A0,        0x47A1,
	/* U+4350 */        0x47A2,        0x47A3,        0x47A4,        0x47A5,        0x47A6,        0x47A7,        0x47A8,        0x47A9,
	/* U+4358 */        0x47B0,        0x47B1,        0x47B2,        0x47B3,        0x47B4,        0x47B5,        0x47B6,        0x47B7,
	/* U+4360 */        0x47B8,        0x47B9,        0x47C0,        0x47C1,        0x47C2,        0x47C3,        0x47C4,        0x47C5,
	/* U+4368 */        0x47C6,        0x47C7,        0x47C8,        0x47C9,        0x47D0,        0x47D1,        0x47D2,        0x47D3,
	/* U+4370 */        0x47D4,        0x47D5,        0x47D6,        0x47D7,        0x47D8,        0x47D9,        0x4800,        0x4801,
	/* U+4378 */        0x4802,        0x4803,        0x4804,        0x4805,        0x4806,        0x4807,        0x4808,        0x4809,
	/* U+4380 */        0x4810,        0x4811,        0x4812,        0x4813,        0x4814,        0x4815,        0x4816,        0x4817,
	/* U+4388 */        0x4818,        0x4819,        0x4820,        0x4821,        0x4822,        0x4823,        0x4824,        0x4825,
	/* U+4390 */        0x4826,        0x4827,        0x4828,        0x4829,        0x4830,        0x4831,        0x4832,        0x4833,
	/* U+4398 */        0x4834,        0x4835,        0x4836,        0x4837,        0x4838,        0x4839,        0x4840,        0x4841,
	/* U+43A0 */        0x4842,        0x4843,        0x4844,        0x4845,        0x4846,        0x4847,        0x4848,        0x4849,
	/* U+43A8 */        0x4850,        0x4851,        0x4852,        0x4853,        0xFE78,        0x4854,        0x4855,        0x4856,
	/* U+43B0 */        0x4857,        0xFE77,        0x4858,        0x4859,        0x4860,        0x4861,        0x4862,        0x4863,
	/* U+43B8 */        0x4864,        0x4865,        0x4866,        0x4867,        0x4868,        0x4869,        0x4870,        0x4871,
	/* U+43C0 */        0x4872,        0x4873,        0x4874,        0x4875,        0x4876,        0x4877,        0x4878,        0x4879,
	/* U+43C8 */        0x4880,        0x4881,        0x4882,        0x4883,        0x4884,        0x4885,        0x4886,        0x4887,
	/* U+43D0 */        0x4888,        0x4889,        0x4890,        0x4891,        0x4892,        0x4893,        0x4894,        0x4895,
	/* U+43D8 */        0x4896,        0x4897,        0x4898,        0x4899,        0x48A0,        0xFE7A,        0x48A1,        0x48A2,
	/* U+43E0 */        0x48A3,        0x48A4,        0x48A5,        0x48A6,        0x48A7,        0x48A8,        0x48A9,        0x48B0,
	/* U+43E8 */        0x48B1,        0x48B2,        0x48B3,        0x48B4,        0x48B5,        0x48B6,        0x48B7,        0x48B8,
	/* U+43F0 */        0x48B9,        0x48C0,        0x48C1,        0x48C2,        0x48C3,        0x48C4,        0x48C5,        0x48C6,
	/* U+43F8 */        0x48C7,        0x48C8,        0x48C9,        0x48D0,        0x48D1,        0x48D2,        0x48D3,        0x48D4,
	/* U+4400 */        0x48D5,        0x48D6,        0x48D7,        0x48D8,        0x48D9,        0x48E0,        0x48E1,        0x48E2,
	/* U+4408 */        0x48E3,        0x48E4,        0x48E5,        0x48E6,        0x48E7,        0x48E8,        0x48E9,        0x48F0,
	/* U+4410 */        0x48F1,        0x48F2,        0x48F3,        0x48F4,        0x48F5,        0x48F6,        0x48F7,        0x48F8,
	/* U+4418 */        0x48F9,        0x4900,        0x4901,        0x4902,        0x4903,        0x4904,        0x4905,        0x4906,
	/* U+4420 */        0x4907,        0x4908,        0x4909,        0x4910,        0x4911,        0x4912,        0x4913,        0x4914,
	/* U+4428 */        0x4915,        0x4916,        0x4917,        0x4918,        0x4919,        0x4920,        0x4921,        0x4922,
	/* U+4430 */        0x4923,        0x4924,        0x4925,        0x4926,        0x4927,        0x4928,        0x4929,        0x4930,
	/* U+4438 */        0x4931,        0x4932,        0x4933,        0x4934,        0x4935,        0x4936,        0x4937,        0x4938,
	/* U+4440 */        0x4939,        0x4940,        0x4941,        0x4942,        0x4943,        0x4944,        0x4945,        0x4946,
	/* U+4448 */        0x4947,        0x4948,        0x4949,        0x4950,        0x4951,        0x4952,        0x4953,        0x4954,
	/* U+4450 */        0x4955,        0x4956,        0x4957,        0x4958,        0x4959,        0x4960,        0x4961,        0x4962,
	/* U+4458 */        0x4963,        0x4964,        0x4965,        0x4966,        0x4967,        0x4968,        0x4969,        0x4970,
	/* U+4460 */        0x4971,        0x4972,        0x4973,        0x4974,        0x4975,        0x4976,        0x4977,        0x4978,
	/* U+4468 */        0x4979,        0x4980,        0x4981,        0x4982,        0x4983,        0x4984,        0x4985,        0x4986,
	/* U+4470 */        0x4987,        0x4988,        0x4989,        0x4990,        0x4991,        0x4992,        0x4993,        0x4994,
	/* U+4478 */        0x4995,        0x4996,        0x4997,        0x4998,        0x4999,        0x49A0,        0x49A1,        0x49A2,
	/* U+4480 */        0x49A3,        0x49A4,        0x49A5,        0x49A6,        0x49A7,        0x49A8,        0x49A9,        0x49B0,
	/* U+4488 */        0x49B1,        0x49B2,        0x49B3,        0x49B4,        0x49B5,        0x49B6,        0x49B7,        0x49B8,
	/* U+4490 */        0x49B9,        0x49C0,        0x49C1,        0x49C2,        0x49C3,        0x49C4,        0x49C5,        0x49C6,
	/* U+4498 */        0x49C7,        0x49C8,        0x49C9,        0x49D0,        0x49D1,        0x49D2,        0x49D3,        0x49D4,
	/* U+44A0 */        0x49D5,        0x49D6,        0x49D7,        0x49D8,        0x49D9,        0x49E0,        0x49E1,        0x49E2,
	/* U+44A8 */        0x49E3,        0x49E4,        0x49E5,        0x49E6,        0x49E7,        0x49E8,        0x49E9,        0x49F0,
	/* U+44B0 */        0x49F1,        0x49F2,        0x49F3,        0x49F4,        0x49F5,        0x49F6,        0x49F7,        0x49F8,
	/* U+44B8 */        0x49F9,        0x4A00,        0x4A01,        0x4A02,        0x4A03,        0x4A04,        0x4A05,        0x4A06,
	/* U+44C0 */        0x4A07,        0x4A08,        0x4A09,        0x4A10,        0x4A11,        0x4A12,        0x4A13,        0x4A14,
	/* U+44C8 */        0x4A15,        0x4A16,        0x4A17,        0x4A18,        0x4A19,        0x4A20,        0x4A21,        0x4A22,
	/* U+44D0 */        0x4A23,        0x4A24,        0x4A25,        0x4A26,        0x4A27,        0x4A28,        0xFE7B,
	/* Contiguous area: U+464C .. U+478D */
	/* U+464C */                                        0xFE7D,        0x4C82,        0x4C83,        0x4C84,
	/* U+4650 */        0x4C85,        0x4C86,        0x4C87,        0x4C88,        0x4C89,        0x4C90,        0x4C91,        0x4C92,
	/* U+4658 */        0x4C93,        0x4C94,        0x4C95,        0x4C96,        0x4C97,        0x4C98,        0x4C99,        0x4CA0,
	/* U+4660 */        0x4CA1,        0xFE7C,        0x4CA2,        0x4CA3,        0x4CA4,        0x4CA5,        0x4CA6,        0x4CA7,
	/* U+4668 */        0x4CA8,        0x4CA9,        0x4CB0,        0x4CB1,        0x4CB2,        0x4CB3,        0x4CB4,        0x4CB5,
	/* U+4670 */        0x4CB6,        0x4CB7,        0x4CB8,        0x4CB9,        0x4CC0,        0x4CC1,        0x4CC2,        0x4CC3,
	/* U+4678 */        0x4CC4,        0x4CC5,        0x4CC6,        0x4CC7,        0x4CC8,        0x4CC9,        0x4CD0,        0x4CD1,
	/* U+4680 */        0x4CD2,        0x4CD3,        0x4CD4,        0x4CD5,        0x4CD6,        0x4CD7,        0x4CD8,        0x4CD9,
	/* U+4688 */        0x4CE0,        0x4CE1,        0x4CE2,        0x4CE3,        0x4CE4,        0x4CE5,        0x4CE6,        0x4CE7,
	/* U+4690 */        0x4CE8,        0x4CE9,        0x4CF0,        0x4CF1,        0x4CF2,        0x4CF3,        0x4CF4,        0x4CF5,
	/* U+4698 */        0x4CF6,        0x4CF7,        0x4CF8,        0x4CF9,        0x4D00,        0x4D01,        0x4D02,        0x4D03,
	/* U+46A0 */        0x4D04,        0x4D05,        0x4D06,        0x4D07,        0x4D08,        0x4D09,        0x4D10,        0x4D11,
	/* U+46A8 */        0x4D12,        0x4D13,        0x4D14,        0x4D15,        0x4D16,        0x4D17,        0x4D18,        0x4D19,
	/* U+46B0 */        0x4D20,        0x4D21,        0x4D22,        0x4D23,        0x4D24,        0x4D25,        0x4D26,        0x4D27,
	/* U+46B8 */        0x4D28,        0x4D29,        0x4D30,        0x4D31,        0x4D32,        0x4D33,        0x4D34,        0x4D35,
	/* U+46C0 */        0x4D36,        0x4D37,        0x4D38,        0x4D39,        0x4D40,        0x4D41,        0x4D42,        0x4D43,
	/* U+46C8 */        0x4D44,        0x4D45,        0x4D46,        0x4D47,        0x4D48,        0x4D49,        0x4D50,        0x4D51,
	/* U+46D0 */        0x4D52,        0x4D53,        0x4D54,        0x4D55,        0x4D56,        0x4D57,        0x4D58,        0x4D59,
	/* U+46D8 */        0x4D60,        0x4D61,        0x4D62,        0x4D63,        0x4D64,        0x4D65,        0x4D66,        0x4D67,
	/* U+46E0 */        0x4D68,        0x4D69,        0x4D70,        0x4D71,        0x4D72,        0x4D73,        0x4D74,        0x4D75,
	/* U+46E8 */        0x4D76,        0x4D77,        0x4D78,        0x4D79,        0x4D80,        0x4D81,        0x4D82,        0x4D83,
	/* U+46F0 */        0x4D84,        0x4D85,        0x4D86,        0x4D87,        0x4D88,        0x4D89,        0x4D90,        0x4D91,
	/* U+46F8 */        0x4D92,        0x4D93,        0x4D94,        0x4D95,        0x4D96,        0x4D97,        0x4D98,        0x4D99,
	/* U+4700 */        0x4DA0,        0x4DA1,        0x4DA2,        0x4DA3,        0x4DA4,        0x4DA5,        0x4DA6,        0x4DA7,
	/* U+4708 */        0x4DA8,        0x4DA9,        0x4DB0,        0x4DB1,        0x4DB2,        0x4DB3,        0x4DB4,        0x4DB5,
	/* U+4710 */        0x4DB6,        0x4DB7,        0x4DB8,        0x4DB9,        0x4DC0,        0x4DC1,        0x4DC2,        0x4DC3,
	/* U+4718 */        0x4DC4,        0x4DC5,        0x4DC6,        0x4DC7,        0x4DC8,        0x4DC9,        0x4DD0,        0x4DD1,
	/* U+4720 */        0x4DD2,        0x4DD3,        0x4DD4,        0xFE80,        0x4DD5,        0x4DD6,        0x4DD7,        0x4DD8,
	/* U+4728 */        0x4DD9,        0xFE81,        0x4DE0,        0x4DE1,        0x4DE2,        0x4DE3,        0x4DE4,        0x4DE5,
	/* U+4730 */        0x4DE6,        0x4DE7,        0x4DE8,        0x4DE9,        0x4DF0,        0x4DF1,        0x4DF2,        0x4DF3,
	/* U+4738 */        0x4DF4,        0x4DF5,        0x4DF6,        0x4DF7,        0x4DF8,        0x4DF9,        0x4E00,        0x4E01,
	/* U+4740 */        0x4E02,        0x4E03,        0x4E04,        0x4E05,        0x4E06,        0x4E07,        0x4E08,        0x4E09,
	/* U+4748 */        0x4E10,        0x4E11,        0x4E12,        0x4E13,        0x4E14,        0x4E15,        0x4E16,        0x4E17,
	/* U+4750 */        0x4E18,        0x4E19,        0x4E20,        0x4E21,        0x4E22,        0x4E23,        0x4E24,        0x4E25,
	/* U+4758 */        0x4E26,        0x4E27,        0x4E28,        0x4E29,        0x4E30,        0x4E31,        0x4E32,        0x4E33,
	/* U+4760 */        0x4E34,        0x4E35,        0x4E36,        0x4E37,        0x4E38,        0x4E39,        0x4E40,        0x4E41,
	/* U+4768 */        0x4E42,        0x4E43,        0x4E44,        0x4E45,        0x4E46,        0x4E47,        0x4E48,        0x4E49,
	/* U+4770 */        0x4E50,        0x4E51,        0x4E52,        0x4E53,        0x4E54,        0x4E55,        0x4E56,        0x4E57,
	/* U+4778 */        0x4E58,        0x4E59,        0x4E60,        0x4E61,        0xFE82,        0x4E62,        0x4E63,        0x4E64,
	/* U+4780 */        0x4E65,        0x4E66,        0x4E67,        0x4E68,        0x4E69,        0x4E70,        0x4E71,        0x4E72,
	/* U+4788 */        0x4E73,        0x4E74,        0x4E75,        0x4E76,        0x4E77,        0xFE83,
	/* Contiguous area: U+4947 .. U+49B7 */
	/* U+4947 */                                                                0xFE85,
	/* U+4948 */        0x5159,        0x5160,        0x5161,        0x5162,        0x5163,        0x5164,        0x5165,        0x5166,
	/* U+4950 */        0x5167,        0x5168,        0x5169,        0x5170,        0x5171,        0x5172,        0x5173,        0x5174,
	/* U+4958 */        0x5175,        0x5176,        0x5177,        0x5178,        0x5179,        0x5180,        0x5181,        0x5182,
	/* U+4960 */        0x5183,        0x5184,        0x5185,        0x5186,        0x5187,        0x5188,        0x5189,        0x5190,
	/* U+4968 */        0x5191,        0x5192,        0x5193,        0x5194,        0x5195,        0x5196,        0x5197,        0x5198,
	/* U+4970 */        0x5199,        0x51A0,        0x51A1,        0x51A2,        0x51A3,        0x51A4,        0x51A5,        0x51A6,
	/* U+4978 */        0x51A7,        0x51A8,        0xFE86,        0x51A9,        0x51B0,        0xFE87,        0x51B1,        0x51B2,
	/* U+4980 */        0x51B3,        0x51B4,        0xFE88,        0xFE89,        0x51B5,        0xFE8A,        0xFE8B,        0x51B6,
	/* U+4988 */        0x51B7,        0x51B8,        0x51B9,        0x51C0,        0x51C1,        0x51C2,        0x51C3,        0x51C4,
	/* U+4990 */        0x51C5,        0x51C6,        0x51C7,        0x51C8,        0x51C9,        0x51D0,        0x51D1,        0x51D2,
	/* U+4998 */        0x51D3,        0x51D4,        0x51D5,        0xFE8D,        0x51D6,        0x51D7,        0x51D8,        0xFE8C,
	/* U+49A0 */        0x51D9,        0x51E0,        0x51E1,        0x51E2,        0x51E3,        0x51E4,        0x51E5,        0x51E6,
	/* U+49A8 */        0x51E7,        0x51E8,        0x51E9,        0x51F0,        0x51F1,        0x51F2,        0x51F3,        0x51F4,
	/* U+49B0 */        0x51F5,        0x51F6,        0x51F7,        0x51F8,        0x51F9,        0x5200,        0xFE8F,        0xFE8E,
	/* Contiguous area: U+4C77 .. U+9FA5 */
	/* U+4C77 */                                                                0xFE96,
	/* U+4C78 */        0x5664,        0x5665,        0x5666,        0x5667,        0x5668,        0x5669,        0x5670,        0x5671,
	/* U+4C80 */        0x5672,        0x5673,        0x5674,        0x5675,        0x5676,        0x5677,        0x5678,        0x5679,
	/* U+4C88 */        0x5680,        0x5681,        0x5682,        0x5683,        0x5684,        0x5685,        0x5686,        0x5687,
	/* U+4C90 */        0x5688,        0x5689,        0x5690,        0x5691,        0x5692,        0x5693,        0x5694,        0x5695,
	/* U+4C98 */        0x5696,        0x5697,        0x5698,        0x5699,        0x56A0,        0x56A1,        0x56A2,        0xFE93,
	/* U+4CA0 */        0xFE94,        0xFE95,        0xFE97,        0xFE92,        0x56A3,        0x56A4,        0x56A5,        0x56A6,
	/* U+4CA8 */        0x56A7,        0x56A8,        0x56A9,        0x56B0,        0x56B1,        0x56B2,        0x56B3,        0x56B4,
	/* U+4CB0 */        0x56B5,        0x56B6,        0x56B7,        0x56B8,        0x56B9,        0x56C0,        0x56C1,        0x56C2,
	/* U+4CB8 */        0x56C3,        0x56C4,        0x56C5,        0x56C6,        0x56C7,        0x56C8,        0x56C9,        0x56D0,
	/* U+4CC0 */        0x56D1,        0x56D2,        0x56D3,        0x56D4,        0x56D5,        0x56D6,        0x56D7,        0x56D8,
	/* U+4CC8 */        0x56D9,        0x56E0,        0x56E1,        0x56E2,        0x56E3,        0x56E4,        0x56E5,        0x56E6,
	/* U+4CD0 */        0x56E7,        0x56E8,        0x56E9,        0x56F0,        0x56F1,        0x56F2,        0x56F3,        0x56F4,
	/* U+4CD8 */        0x56F5,        0x56F6,        0x56F7,        0x56F8,        0x56F9,        0x5700,        0x5701,        0x5702,
	/* U+4CE0 */        0x5703,        0x5704,        0x5705,        0x5706,        0x5707,        0x5708,        0x5709,        0x5710,
	/* U+4CE8 */        0x5711,        0x5712,        0x5713,        0x5714,        0x5715,        0x5716,        0x5717,        0x5718,
	/* U+4CF0 */        0x5719,        0x5720,        0x5721,        0x5722,        0x5723,        0x5724,        0x5725,        0x5726,
	/* U+4CF8 */        0x5727,        0x5728,        0x5729,        0x5730,        0x5731,        0x5732,        0x5733,        0x5734,
	/* U+4D00 */        0x5735,        0x5736,        0x5737,        0x5738,        0x5739,        0x5740,        0x5741,        0x5742,
	/* U+4D08 */        0x5743,        0x5744,        0x5745,        0x5746,        0x5747,        0x5748,        0x5749,        0x5750,
	/* U+4D10 */        0x5751,        0x5752,        0x5753,        0xFE98,        0xFE99,        0xFE9A,        0xFE9B,        0xFE9C,
	/* U+4D18 */        0xFE9D,        0xFE9E,        0x5754,        0x5755,        0x5756,        0x5757,        0x5758,        0x5759,
	/* U+4D20 */        0x5760,        0x5761,        0x5762,        0x5763,        0x5764,        0x5765,        0x5766,        0x5767,
	/* U+4D28 */        0x5768,        0x5769,        0x5770,        0x5771,        0x5772,        0x5773,        0x5774,        0x5775,
	/* U+4D30 */        0x5776,        0x5777,        0x5778,        0x5779,        0x5780,        0x5781,        0x5782,        0x5783,
	/* U+4D38 */        0x5784,        0x5785,        0x5786,        0x5787,        0x5788,        0x5789,        0x5790,        0x5791,
	/* U+4D40 */        0x5792,        0x5793,        0x5794,        0x5795,        0x5796,        0x5797,        0x5798,        0x5799,
	/* U+4D48 */        0x57A0,        0x57A1,        0x57A2,        0x57A3,        0x57A4,        0x57A5,        0x57A6,        0x57A7,
	/* U+4D50 */        0x57A8,        0x57A9,        0x57B0,        0x57B1,        0x57B2,        0x57B3,        0x57B4,        0x57B5,
	/* U+4D58 */        0x57B6,        0x57B7,        0x57B8,        0x57B9,        0x57C0,        0x57C1,        0x57C2,        0x57C3,
	/* U+4D60 */        0x57C4,        0x57C5,        0x57C6,        0x57C7,        0x57C8,        0x57C9,        0x57D0,        0x57D1,
	/* U+4D68 */        0x57D2,        0x57D3,        0x57D4,        0x57D5,        0x57D6,        0x57D7,        0x57D8,        0x57D9,
	/* U+4D70 */        0x5800,        0x5801,        0x5802,        0x5803,        0x5804,        0x5805,        0x5806,        0x5807,
	/* U+4D78 */        0x5808,        0x5809,        0x5810,        0x5811,        0x5812,        0x5813,        0x5814,        0x5815,
	/* U+4D80 */        0x5816,        0x5817,        0x5818,        0x5819,        0x5820,        0x5821,        0x5822,        0x5823,
	/* U+4D88 */        0x5824,        0x5825,        0x5826,        0x5827,        0x5828,        0x5829,        0x5830,        0x5831,
	/* U+4D90 */        0x5832,        0x5833,        0x5834,        0x5835,        0x5836,        0x5837,        0x5838,        0x5839,
	/* U+4D98 */        0x5840,        0x5841,        0x5842,        0x5843,        0x5844,        0x5845,        0x5846,        0x5847,
	/* U+4DA0 */        0x5848,        0x5849,        0x5850,        0x5851,        0x5852,        0x5853,        0x5854,        0x5855,
	/* U+4DA8 */        0x5856,        0x5857,        0x5858,        0x5859,        0x5860,        0x5861,        0xFE9F,        0x5862,
	/* U+4DB0 */        0x5863,        0x5864,        0x5865,        0x5866,        0x5867,        0x5868,        0x5869,        0x5870,
	/* U+4DB8 */        0x5871,        0x5872,        0x5873,        0x5874,        0x5875,        0x5876,        0x5877,        0x5878,
	/* U+4DC0 */        0x5879,        0x5880,        0x5881,        0x5882,        0x5883,        0x5884,        0x5885,        0x5886,
	/* U+4DC8 */        0x5887,        0x5888,        0x5889,        0x5890,        0x5891,        0x5892,        0x5893,        0x5894,
	/* U+4DD0 */        0x5895,        0x5896,        0x5897,        0x5898,        0x5899,        0x58A0,        0x58A1,        0x58A2,
	/* U+4DD8 */        0x58A3,        0x58A4,        0x58A5,        0x58A6,        0x58A7,        0x58A8,        0x58A9,        0x58B0,
	/* U+4DE0 */        0x58B1,        0x58B2,        0x58B3,        0x58B4,        0x58B5,        0x58B6,        0x58B7,        0x58B8,
	/* U+4DE8 */        0x58B9,        0x58C0,        0x58C1,        0x58C2,        0x58C3,        0x58C4,        0x58C5,        0x58C6,
	/* U+4DF0 */        0x58C7,        0x58C8,        0x58C9,        0x58D0,        0x58D1,        0x58D2,        0x58D3,        0x58D4,
	/* U+4DF8 */        0x58D5,        0x58D6,        0x58D7,        0x58D8,        0x58D9,        0x58E0,        0x58E1,        0x58E2,
	/* U+4E00 */        0xD2BB,        0xB6A1,        0x8140,        0xC6DF,        0x8141,        0x8142,        0x8143,        0xCDF2,
	/* U+4E08 */        0xD5C9,        0xC8FD,        0xC9CF,        0xCFC2,        0xD8A2,        0xB2BB,        0xD3EB,        0x8144,
	/* U+4E10 */        0xD8A4,        0xB3F3,        0x8145,        0xD7A8,        0xC7D2,        0xD8A7,        0xCAC0,        0x8146,
	/* U+4E18 */        0xC7F0,        0xB1FB,        0xD2B5,        0xB4D4,        0xB6AB,        0xCBBF,        0xD8A9,        0x8147,
	/* U+4E20 */        0x8148,        0x8149,        0xB6AA,        0x814A,        0xC1BD,        0xD1CF,        0x814B,        0xC9A5,
	/* U+4E28 */        0xD8AD,        0x814C,        0xB8F6,        0xD1BE,        0xE3DC,        0xD6D0,        0x814D,        0x814E,
	/* U+4E30 */        0xB7E1,        0x814F,        0xB4AE,        0x8150,        0xC1D9,        0x8151,        0xD8BC,        0x8152,
	/* U+4E38 */        0xCDE8,        0xB5A4,        0xCEAA,        0xD6F7,        0x8153,        0xC0F6,        0xBED9,        0xD8AF,
	/* U+4E40 */        0x8154,        0x8155,        0x8156,        0xC4CB,        0x8157,        0xBEC3,        0x8158,        0xD8B1,
	/* U+4E48 */        0xC3B4,        0xD2E5,        0x8159,        0xD6AE,        0xCEDA,        0xD5A7,        0xBAF5,        0xB7A6,
	/* U+4E50 */        0xC0D6,        0x815A,        0xC6B9,        0xC5D2,        0xC7C7,        0x815B,        0xB9D4,        0x815C,
	/* U+4E58 */        0xB3CB,        0xD2D2,        0x815D,        0x815E,        0xD8BF,        0xBEC5,        0xC6F2,        0xD2B2,
	/* U+4E60 */        0xCFB0,        0xCFE7,        0x815F,        0x8160,        0x8161,        0x8162,        0xCAE9,        0x8163,
	/* U+4E68 */        0x8164,        0xD8C0,        0x8165,        0x8166,        0x8167,        0x8168,        0x8169,        0x816A,
	/* U+4E70 */        0xC2F2,        0xC2D2,        0x816B,        0xC8E9,        0x816C,        0x816D,        0x816E,        0x816F,
	/* U+4E78 */        0x8170,        0x8171,        0x8172,        0x8173,        0x8174,        0x8175,        0xC7AC,        0x8176,
	/* U+4E80 */        0x8177,        0x8178,        0x8179,        0x817A,        0x817B,        0x817C,        0xC1CB,        0x817D,
	/* U+4E88 */        0xD3E8,        0xD5F9,        0x817E,        0xCAC2,        0xB6FE,        0xD8A1,        0xD3DA,        0xBFF7,
	/* U+4E90 */        0x8180,        0xD4C6,        0xBBA5,        0xD8C1,        0xCEE5,        0xBEAE,        0x8181,        0x8182,
	/* U+4E98 */        0xD8A8,        0x8183,        0xD1C7,        0xD0A9,        0x8184,        0x8185,        0x8186,        0xD8BD,
	/* U+4EA0 */        0xD9EF,        0xCDF6,        0xBFBA,        0x8187,        0xBDBB,        0xBAA5,        0xD2E0,        0xB2FA,
	/* U+4EA8 */        0xBAE0,        0xC4B6,        0x8188,        0xCFED,        0xBEA9,        0xCDA4,        0xC1C1,        0x8189,
	/* U+4EB0 */        0x818A,        0x818B,        0xC7D7,        0xD9F1,        0x818C,        0xD9F4,        0x818D,        0x818E,
	/* U+4EB8 */        0x818F,        0x8190,        0xC8CB,        0xD8E9,        0x8191,        0x8192,        0x8193,        0xD2DA,
	/* U+4EC0 */        0xCAB2,        0xC8CA,        0xD8EC,        0xD8EA,        0xD8C6,        0xBDF6,        0xC6CD,        0xB3F0,
	/* U+4EC8 */        0x8194,        0xD8EB,        0xBDF1,        0xBDE9,        0x8195,        0xC8D4,        0xB4D3,        0x8196,
	/* U+4ED0 */        0x8197,        0xC2D8,        0x8198,        0xB2D6,        0xD7D0,        0xCACB,        0xCBFB,        0xD5CC,
	/* U+4ED8 */        0xB8B6,        0xCFC9,        0x8199,        0x819A,        0x819B,        0xD9DA,        0xD8F0,        0xC7AA,
	/* U+4EE0 */        0x819C,        0xD8EE,        0x819D,        0xB4FA,        0xC1EE,        0xD2D4,        0x819E,        0x819F,
	/* U+4EE8 */        0xD8ED,        0x81A0,        0xD2C7,        0xD8EF,        0xC3C7,        0x81A1,        0x81A2,        0x81A3,
	/* U+4EF0 */        0xD1F6,        0x81A4,        0xD6D9,        0xD8F2,        0x81A5,        0xD8F5,        0xBCFE,        0xBCDB,
	/* U+4EF8 */        0x81A6,        0x81A7,        0x81A8,        0xC8CE,        0x81A9,        0xB7DD,        0x81AA,        0xB7C2,
	/* U+4F00 */        0x81AB,        0xC6F3,        0x81AC,        0x81AD,        0x81AE,        0x81AF,        0x81B0,        0x81B1,
	/* U+4F08 */        0x81B2,        0xD8F8,        0xD2C1,        0x81B3,        0x81B4,        0xCEE9,        0xBCBF,        0xB7FC,
	/* U+4F10 */        0xB7A5,        0xD0DD,        0x81B5,        0x81B6,        0x81B7,        0x81B8,        0x81B9,        0xD6DA,
	/* U+4F18 */        0xD3C5,        0xBBEF,        0xBBE1,        0xD8F1,        0x81BA,        0x81BB,        0xC9A1,        0xCEB0,
	/* U+4F20 */        0xB4AB,        0x81BC,        0xD8F3,        0x81BD,        0xC9CB,        0xD8F6,        0xC2D7,        0xD8F7,
	/* U+4F28 */        0x81BE,        0x81BF,        0xCEB1,        0xD8F9,        0x81C0,        0x81C1,        0x81C2,        0xB2AE,
	/* U+4F30 */        0xB9C0,        0x81C3,        0xD9A3,        0x81C4,        0xB0E9,        0x81C5,        0xC1E6,        0x81C6,
	/* U+4F38 */        0xC9EC,        0x81C7,        0xCBC5,        0x81C8,        0xCBC6,        0xD9A4,        0x81C9,        0x81CA,
	/* U+4F40 */        0x81CB,        0x81CC,        0x81CD,        0xB5E8,        0x81CE,        0x81CF,        0xB5AB,        0x81D0,
	/* U+4F48 */        0x81D1,        0x81D2,        0x81D3,        0x81D4,        0x81D5,        0xCEBB,        0xB5CD,        0xD7A1,
	/* U+4F50 */        0xD7F4,        0xD3D3,        0x81D6,        0xCCE5,        0x81D7,        0xBACE,        0x81D8,        0xD9A2,
	/* U+4F58 */        0xD9DC,        0xD3E0,        0xD8FD,        0xB7F0,        0xD7F7,        0xD8FE,        0xD8FA,        0xD9A1,
	/* U+4F60 */        0xC4E3,        0x81D9,        0x81DA,        0xD3B6,        0xD8F4,        0xD9DD,        0x81DB,        0xD8FB,
	/* U+4F68 */        0x81DC,        0xC5E5,        0x81DD,        0x81DE,        0xC0D0,        0x81DF,        0x81E0,        0xD1F0,
	/* U+4F70 */        0xB0DB,        0x81E1,        0x81E2,        0xBCD1,        0xD9A6,        0x81E3,        0xD9A5,        0x81E4,
	/* U+4F78 */        0x81E5,        0x81E6,        0x81E7,        0xD9AC,        0xD9AE,        0x81E8,        0xD9AB,        0xCAB9,
	/* U+4F80 */        0x81E9,        0x81EA,        0x81EB,        0xD9A9,        0xD6B6,        0x81EC,        0x81ED,        0x81EE,
	/* U+4F88 */        0xB3DE,        0xD9A8,        0x81EF,        0xC0FD,        0x81F0,        0xCACC,        0x81F1,        0xD9AA,
	/* U+4F90 */        0x81F2,        0xD9A7,        0x81F3,        0x81F4,        0xD9B0,        0x81F5,        0x81F6,        0xB6B1,
	/* U+4F98 */        0x81F7,        0x81F8,        0x81F9,        0xB9A9,        0x81FA,        0xD2C0,        0x81FB,        0x81FC,
	/* U+4FA0 */        0xCFC0,        0x81FD,        0x81FE,        0xC2C2,        0x8240,        0xBDC4,        0xD5EC,        0xB2E0,
	/* U+4FA8 */        0xC7C8,        0xBFEB,        0xD9AD,        0x8241,        0xD9AF,        0x8242,        0xCEEA,        0xBAEE,
	/* U+4FB0 */        0x8243,        0x8244,        0x8245,        0x8246,        0x8247,        0xC7D6,        0x8248,        0x8249,
	/* U+4FB8 */        0x824A,        0x824B,        0x824C,        0x824D,        0x824E,        0x824F,        0x8250,        0xB1E3,
	/* U+4FC0 */        0x8251,        0x8252,        0x8253,        0xB4D9,        0xB6ED,        0xD9B4,        0x8254,        0x8255,
	/* U+4FC8 */        0x8256,        0x8257,        0xBFA1,        0x8258,        0x8259,        0x825A,        0xD9DE,        0xC7CE,
	/* U+4FD0 */        0xC0FE,        0xD9B8,        0x825B,        0x825C,        0x825D,        0x825E,        0x825F,        0xCBD7,
	/* U+4FD8 */        0xB7FD,        0x8260,        0xD9B5,        0x8261,        0xD9B7,        0xB1A3,        0xD3E1,        0xD9B9,
	/* U+4FE0 */        0x8262,        0xD0C5,        0x8263,        0xD9B6,        0x8264,        0x8265,        0xD9B1,        0x8266,
	/* U+4FE8 */        0xD9B2,        0xC1A9,        0xD9B3,        0x8267,        0x8268,        0xBCF3,        0xD0DE,        0xB8A9,
	/* U+4FF0 */        0x8269,        0xBEE3,        0x826A,        0xD9BD,        0x826B,        0x826C,        0x826D,        0x826E,
	/* U+4FF8 */        0xD9BA,        0x826F,        0xB0B3,        0x8270,        0x8271,        0x8272,        0xD9C2,        0x8273,
	/* U+5000 */        0x8274,        0x8275,        0x8276,        0x8277,        0x8278,        0x8279,        0x827A,        0x827B,
	/* U+5008 */        0x827C,        0x827D,        0x827E,        0x8280,        0xD9C4,        0xB1B6,        0x8281,        0xD9BF,
	/* U+5010 */        0x8282,        0x8283,        0xB5B9,        0x8284,        0xBEF3,        0x8285,        0x8286,        0x8287,
	/* U+5018 */        0xCCC8,        0xBAF2,        0xD2D0,        0x8288,        0xD9C3,        0x8289,        0x828A,        0xBDE8,
	/* U+5020 */        0x828B,        0xB3AB,        0x828C,        0x828D,        0x828E,        0xD9C5,        0xBEEB,        0x828F,
	/* U+5028 */        0xD9C6,        0xD9BB,        0xC4DF,        0x8290,        0xD9BE,        0xD9C1,        0xD9C0,        0x8291,
	/* U+5030 */        0x8292,        0x8293,        0x8294,        0x8295,        0x8296,        0x8297,        0x8298,        0x8299,
	/* U+5038 */        0x829A,        0x829B,        0xD5AE,        0x829C,        0xD6B5,        0x829D,        0xC7E3,        0x829E,
	/* U+5040 */        0x829F,        0x82A0,        0x82A1,        0xD9C8,        0x82A2,        0x82A3,        0x82A4,        0xBCD9,
	/* U+5048 */        0xD9CA,        0x82A5,        0x82A6,        0x82A7,        0xD9BC,        0x82A8,        0xD9CB,        0xC6AB,
	/* U+5050 */        0x82A9,        0x82AA,        0x82AB,        0x82AC,        0x82AD,        0xD9C9,        0x82AE,        0x82AF,
	/* U+5058 */        0x82B0,        0x82B1,        0xD7F6,        0x82B2,        0xCDA3,        0x82B3,        0x82B4,        0x82B5,
	/* U+5060 */        0x82B6,        0x82B7,        0x82B8,        0x82B9,        0x82BA,        0xBDA1,        0x82BB,        0x82BC,
	/* U+5068 */        0x82BD,        0x82BE,        0x82BF,        0x82C0,        0xD9CC,        0x82C1,        0x82C2,        0x82C3,
	/* U+5070 */        0x82C4,        0x82C5,        0x82C6,        0x82C7,        0x82C8,        0x82C9,        0xC5BC,        0xCDB5,
	/* U+5078 */        0x82CA,        0x82CB,        0x82CC,        0xD9CD,        0x82CD,        0x82CE,        0xD9C7,        0xB3A5,
	/* U+5080 */        0xBFFE,        0x82CF,        0x82D0,        0x82D1,        0x82D2,        0xB8B5,        0x82D3,        0x82D4,
	/* U+5088 */        0xC0FC,        0x82D5,        0x82D6,        0x82D7,        0x82D8,        0xB0F8,        0x82D9,        0x82DA,
	/* U+5090 */        0x82DB,        0x82DC,        0x82DD,        0x82DE,        0x82DF,        0x82E0,        0x82E1,        0x82E2,
	/* U+5098 */        0x82E3,        0x82E4,        0x82E5,        0x82E6,        0x82E7,        0x82E8,        0x82E9,        0x82EA,
	/* U+50A0 */        0x82EB,        0x82EC,        0x82ED,        0xB4F6,        0x82EE,        0xD9CE,        0x82EF,        0xD9CF,
	/* U+50A8 */        0xB4A2,        0xD9D0,        0x82F0,        0x82F1,        0xB4DF,        0x82F2,        0x82F3,        0x82F4,
	/* U+50B0 */        0x82F5,        0x82F6,        0xB0C1,        0x82F7,        0x82F8,        0x82F9,        0x82FA,        0x82FB,
	/* U+50B8 */        0x82FC,        0x82FD,        0xD9D1,        0xC9B5,        0x82FE,        0x8340,        0x8341,        0x8342,
	/* U+50C0 */        0x8343,        0x8344,        0x8345,        0x8346,        0x8347,        0x8348,        0x8349,        0x834A,
	/* U+50C8 */        0x834B,        0x834C,        0x834D,        0x834E,        0x834F,        0x8350,        0x8351,        0xCFF1,
	/* U+50D0 */        0x8352,        0x8353,        0x8354,        0x8355,        0x8356,        0x8357,        0xD9D2,        0x8358,
	/* U+50D8 */        0x8359,        0x835A,        0xC1C5,        0x835B,        0x835C,        0x835D,        0x835E,        0x835F,
	/* U+50E0 */        0x8360,        0x8361,        0x8362,        0x8363,        0x8364,        0x8365,        0xD9D6,        0xC9AE,
	/* U+50E8 */        0x8366,        0x8367,        0x8368,        0x8369,        0xD9D5,        0xD9D4,        0xD9D7,        0x836A,
	/* U+50F0 */        0x836B,        0x836C,        0x836D,        0xCBDB,        0x836E,        0xBDA9,        0x836F,        0x8370,
	/* U+50F8 */        0x8371,        0x8372,        0x8373,        0xC6A7,        0x8374,        0x8375,        0x8376,        0x8377,
	/* U+5100 */        0x8378,        0x8379,        0x837A,        0x837B,        0x837C,        0x837D,        0xD9D3,        0xD9D8,
	/* U+5108 */        0x837E,        0x8380,        0x8381,        0xD9D9,        0x8382,        0x8383,        0x8384,        0x8385,
	/* U+5110 */        0x8386,        0x8387,        0xC8E5,        0x8388,        0x8389,        0x838A,        0x838B,        0x838C,
	/* U+5118 */        0x838D,        0x838E,        0x838F,        0x8390,        0x8391,        0x8392,        0x8393,        0x8394,
	/* U+5120 */        0x8395,        0xC0DC,        0x8396,        0x8397,        0x8398,        0x8399,        0x839A,        0x839B,
	/* U+5128 */        0x839C,        0x839D,        0x839E,        0x839F,        0x83A0,        0x83A1,        0x83A2,        0x83A3,
	/* U+5130 */        0x83A4,        0x83A5,        0x83A6,        0x83A7,        0x83A8,        0x83A9,        0x83AA,        0x83AB,
	/* U+5138 */        0x83AC,        0x83AD,        0x83AE,        0x83AF,        0x83B0,        0x83B1,        0x83B2,        0xB6F9,
	/* U+5140 */        0xD8A3,        0xD4CA,        0x83B3,        0xD4AA,        0xD0D6,        0xB3E4,        0xD5D7,        0x83B4,
	/* U+5148 */        0xCFC8,        0xB9E2,        0x83B5,        0xBFCB,        0x83B6,        0xC3E2,        0x83B7,        0x83B8,
	/* U+5150 */        0x83B9,        0xB6D2,        0x83BA,        0x83BB,        0xCDC3,        0xD9EE,        0xD9F0,        0x83BC,
	/* U+5158 */        0x83BD,        0x83BE,        0xB5B3,        0x83BF,        0xB6B5,        0x83C0,        0x83C1,        0x83C2,
	/* U+5160 */        0x83C3,        0x83C4,        0xBEA4,        0x83C5,        0x83C6,        0xC8EB,        0x83C7,        0x83C8,
	/* U+5168 */        0xC8AB,        0x83C9,        0x83CA,        0xB0CB,        0xB9AB,        0xC1F9,        0xD9E2,        0x83CB,
	/* U+5170 */        0xC0BC,        0xB9B2,        0x83CC,        0xB9D8,        0xD0CB,        0xB1F8,        0xC6E4,        0xBEDF,
	/* U+5178 */        0xB5E4,        0xD7C8,        0x83CD,        0xD1F8,        0xBCE6,        0xCADE,        0x83CE,        0x83CF,
	/* U+5180 */        0xBCBD,        0xD9E6,        0xD8E7,        0x83D0,        0x83D1,        0xC4DA,        0x83D2,        0x83D3,
	/* U+5188 */        0xB8D4,        0xC8BD,        0x83D4,        0x83D5,        0xB2E1,        0xD4D9,        0x83D6,        0x83D7,
	/* U+5190 */        0x83D8,        0x83D9,        0xC3B0,        0x83DA,        0x83DB,        0xC3E1,        0xDAA2,        0xC8DF,
	/* U+5198 */        0x83DC,        0xD0B4,        0x83DD,        0xBEFC,        0xC5A9,        0x83DE,        0x83DF,        0x83E0,
	/* U+51A0 */        0xB9DA,        0x83E1,        0xDAA3,        0x83E2,        0xD4A9,        0xDAA4,        0x83E3,        0x83E4,
	/* U+51A8 */        0x83E5,        0x83E6,        0x83E7,        0xD9FB,        0xB6AC,        0x83E8,        0x83E9,        0xB7EB,
	/* U+51B0 */        0xB1F9,        0xD9FC,        0xB3E5,        0xBEF6,        0x83EA,        0xBFF6,        0xD2B1,        0xC0E4,
	/* U+51B8 */        0x83EB,        0x83EC,        0x83ED,        0xB6B3,        0xD9FE,        0xD9FD,        0x83EE,        0x83EF,
	/* U+51C0 */        0xBEBB,        0x83F0,        0x83F1,        0x83F2,        0xC6E0,        0x83F3,        0xD7BC,        0xDAA1,
	/* U+51C8 */        0x83F4,        0xC1B9,        0x83F5,        0xB5F2,        0xC1E8,        0x83F6,        0x83F7,        0xBCF5,
	/* U+51D0 */        0x83F8,        0xB4D5,        0x83F9,        0x83FA,        0x83FB,        0x83FC,        0x83FD,        0x83FE,
	/* U+51D8 */        0x8440,        0x8441,        0x8442,        0xC1DD,        0x8443,        0xC4FD,        0x8444,        0x8445,
	/* U+51E0 */        0xBCB8,        0xB7B2,        0x8446,        0x8447,        0xB7EF,        0x8448,        0x8449,        0x844A,
	/* U+51E8 */        0x844B,        0x844C,        0x844D,        0xD9EC,        0x844E,        0xC6BE,        0x844F,        0xBFAD,
	/* U+51F0 */        0xBBCB,        0x8450,        0x8451,        0xB5CA,        0x8452,        0xDBC9,        0xD0D7,        0x8453,
	/* U+51F8 */        0xCDB9,        0xB0BC,        0xB3F6,        0xBBF7,        0xDBCA,        0xBAAF,        0x8454,        0xD4E4,
	/* U+5200 */        0xB5B6,        0xB5F3,        0xD8D6,        0xC8D0,        0x8455,        0x8456,        0xB7D6,        0xC7D0,
	/* U+5208 */        0xD8D7,        0x8457,        0xBFAF,        0x8458,        0x8459,        0xDBBB,        0xD8D8,        0x845A,
	/* U+5210 */        0x845B,        0xD0CC,        0xBBAE,        0x845C,        0x845D,        0x845E,        0xEBBE,        0xC1D0,
	/* U+5218 */        0xC1F5,        0xD4F2,        0xB8D5,        0xB4B4,        0x845F,        0xB3F5,        0x8460,        0x8461,
	/* U+5220 */        0xC9BE,        0x8462,        0x8463,        0x8464,        0xC5D0,        0x8465,        0x8466,        0x8467,
	/* U+5228 */        0xC5D9,        0xC0FB,        0x8468,        0xB1F0,        0x8469,        0xD8D9,        0xB9CE,        0x846A,
	/* U+5230 */        0xB5BD,        0x846B,        0x846C,        0xD8DA,        0x846D,        0x846E,        0xD6C6,        0xCBA2,
	/* U+5238 */        0xC8AF,        0xC9B2,        0xB4CC,        0xBFCC,        0x846F,        0xB9F4,        0x8470,        0xD8DB,
	/* U+5240 */        0xD8DC,        0xB6E7,        0xBCC1,        0xCCEA,        0x8471,        0x8472,        0x8473,        0x8474,
	/* U+5248 */        0x8475,        0x8476,        0xCFF7,        0x8477,        0xD8DD,        0xC7B0,        0x8478,        0x8479,
	/* U+5250 */        0xB9D0,        0xBDA3,        0x847A,        0x847B,        0xCCDE,        0x847C,        0xC6CA,        0x847D,
	/* U+5258 */        0x847E,        0x8480,        0x8481,        0x8482,        0xD8E0,        0x8483,        0xD8DE,        0x8484,
	/* U+5260 */        0x8485,        0xD8DF,        0x8486,        0x8487,        0x8488,        0xB0FE,        0x8489,        0xBEE7,
	/* U+5268 */        0x848A,        0xCAA3,        0xBCF4,        0x848B,        0x848C,        0x848D,        0x848E,        0xB8B1,
	/* U+5270 */        0x848F,        0x8490,        0xB8EE,        0x8491,        0x8492,        0x8493,        0x8494,        0x8495,
	/* U+5278 */        0x8496,        0x8497,        0x8498,        0x8499,        0x849A,        0xD8E2,        0x849B,        0xBDCB,
	/* U+5280 */        0x849C,        0xD8E4,        0xD8E3,        0x849D,        0x849E,        0x849F,        0x84A0,        0x84A1,
	/* U+5288 */        0xC5FC,        0x84A2,        0x84A3,        0x84A4,        0x84A5,        0x84A6,        0x84A7,        0x84A8,
	/* U+5290 */        0xD8E5,        0x84A9,        0x84AA,        0xD8E6,        0x84AB,        0x84AC,        0x84AD,        0x84AE,
	/* U+5298 */        0x84AF,        0x84B0,        0x84B1,        0xC1A6,        0x84B2,        0xC8B0,        0xB0EC,        0xB9A6,
	/* U+52A0 */        0xBCD3,        0xCEF1,        0xDBBD,        0xC1D3,        0x84B3,        0x84B4,        0x84B5,        0x84B6,
	/* U+52A8 */        0xB6AF,        0xD6FA,        0xC5AC,        0xBDD9,        0xDBBE,        0xDBBF,        0x84B7,        0x84B8,
	/* U+52B0 */        0x84B9,        0xC0F8,        0xBEA2,        0xC0CD,        0x84BA,        0x84BB,        0x84BC,        0x84BD,
	/* U+52B8 */        0x84BE,        0x84BF,        0x84C0,        0x84C1,        0x84C2,        0x84C3,        0xDBC0,        0xCAC6,
	/* U+52C0 */        0x84C4,        0x84C5,        0x84C6,        0xB2AA,        0x84C7,        0x84C8,        0x84C9,        0xD3C2,
	/* U+52C8 */        0x84CA,        0xC3E3,        0x84CB,        0xD1AB,        0x84CC,        0x84CD,        0x84CE,        0x84CF,
	/* U+52D0 */        0xDBC2,        0x84D0,        0xC0D5,        0x84D1,        0x84D2,        0x84D3,        0xDBC3,        0x84D4,
	/* U+52D8 */        0xBFB1,        0x84D5,        0x84D6,        0x84D7,        0x84D8,        0x84D9,        0x84DA,        0xC4BC,
	/* U+52E0 */        0x84DB,        0x84DC,        0x84DD,        0x84DE,        0xC7DA,        0x84DF,        0x84E0,        0x84E1,
	/* U+52E8 */        0x84E2,        0x84E3,        0x84E4,        0x84E5,        0x84E6,        0x84E7,        0x84E8,        0x84E9,
	/* U+52F0 */        0xDBC4,        0x84EA,        0x84EB,        0x84EC,        0x84ED,        0x84EE,        0x84EF,        0x84F0,
	/* U+52F8 */        0x84F1,        0xD9E8,        0xC9D7,        0x84F2,        0x84F3,        0x84F4,        0xB9B4,        0xCEF0,
	/* U+5300 */        0xD4C8,        0x84F5,        0x84F6,        0x84F7,        0x84F8,        0xB0FC,        0xB4D2,        0x84F9,
	/* U+5308 */        0xD0D9,        0x84FA,        0x84FB,        0x84FC,        0x84FD,        0xD9E9,        0x84FE,        0xDECB,
	/* U+5310 */        0xD9EB,        0x8540,        0x8541,        0x8542,        0x8543,        0xD8B0,        0xBBAF,        0xB1B1,
	/* U+5318 */        0x8544,        0xB3D7,        0xD8CE,        0x8545,        0x8546,        0xD4D1,        0x8547,        0x8548,
	/* U+5320 */        0xBDB3,        0xBFEF,        0x8549,        0xCFBB,        0x854A,        0x854B,        0xD8D0,        0x854C,
	/* U+5328 */        0x854D,        0x854E,        0xB7CB,        0x854F,        0x8550,        0x8551,        0xD8D1,        0x8552,
	/* U+5330 */        0x8553,        0x8554,        0x8555,        0x8556,        0x8557,        0x8558,        0x8559,        0x855A,
	/* U+5338 */        0x855B,        0xC6A5,        0xC7F8,        0xD2BD,        0x855C,        0x855D,        0xD8D2,        0xC4E4,
	/* U+5340 */        0x855E,        0xCAAE,        0x855F,        0xC7A7,        0x8560,        0xD8A6,        0x8561,        0xC9FD,
	/* U+5348 */        0xCEE7,        0xBBDC,        0xB0EB,        0x8562,        0x8563,        0x8564,        0xBBAA,        0xD0AD,
	/* U+5350 */        0x8565,        0xB1B0,        0xD7E4,        0xD7BF,        0x8566,        0xB5A5,        0xC2F4,        0xC4CF,
	/* U+5358 */        0x8567,        0x8568,        0xB2A9,        0x8569,        0xB2B7,        0x856A,        0xB1E5,        0xDFB2,
	/* U+5360 */        0xD5BC,        0xBFA8,        0xC2AC,        0xD8D5,        0xC2B1,        0x856B,        0xD8D4,        0xCED4,
	/* U+5368 */        0x856C,        0xDAE0,        0x856D,        0xCEC0,        0x856E,        0x856F,        0xD8B4,        0xC3AE,
	/* U+5370 */        0xD3A1,        0xCEA3,        0x8570,        0xBCB4,        0xC8B4,        0xC2D1,        0x8571,        0xBEED,
	/* U+5378 */        0xD0B6,        0x8572,        0xDAE1,        0x8573,        0x8574,        0x8575,        0x8576,        0xC7E4,
	/* U+5380 */        0x8577,        0x8578,        0xB3A7,        0x8579,        0xB6F2,        0xCCFC,        0xC0FA,        0x857A,
	/* U+5388 */        0x857B,        0xC0F7,        0x857C,        0xD1B9,        0xD1E1,        0xD8C7,        0x857D,        0x857E,
	/* U+5390 */        0x8580,        0x8581,        0x8582,        0x8583,        0x8584,        0xB2DE,        0x8585,        0x8586,
	/* U+5398 */        0xC0E5,        0x8587,        0xBAF1,        0x8588,        0x8589,        0xD8C8,        0x858A,        0xD4AD,
	/* U+53A0 */        0x858B,        0x858C,        0xCFE1,        0xD8C9,        0x858D,        0xD8CA,        0xCFC3,        0x858E,
	/* U+53A8 */        0xB3F8,        0xBEC7,        0x858F,        0x8590,        0x8591,        0x8592,        0xD8CB,        0x8593,
	/* U+53B0 */        0x8594,        0x8595,        0x8596,        0x8597,        0x8598,        0x8599,        0xDBCC,        0x859A,
	/* U+53B8 */        0x859B,        0x859C,        0x859D,        0xC8A5,        0x859E,        0x859F,        0x85A0,        0xCFD8,
	/* U+53C0 */        0x85A1,        0xC8FE,        0xB2CE,        0x85A2,        0x85A3,        0x85A4,        0x85A5,        0x85A6,
	/* U+53C8 */        0xD3D6,        0xB2E6,        0xBCB0,        0xD3D1,        0xCBAB,        0xB7B4,        0x85A7,        0x85A8,
	/* U+53D0 */        0x85A9,        0xB7A2,        0x85AA,        0x85AB,        0xCAE5,        0x85AC,        0xC8A1,        0xCADC,
	/* U+53D8 */        0xB1E4,        0xD0F0,        0x85AD,        0xC5D1,        0x85AE,        0x85AF,        0x85B0,        0xDBC5,
	/* U+53E0 */        0xB5FE,        0x85B1,        0x85B2,        0xBFDA,        0xB9C5,        0xBEE4,        0xC1ED,        0x85B3,
	/* U+53E8 */        0xDFB6,        0xDFB5,        0xD6BB,        0xBDD0,        0xD5D9,        0xB0C8,        0xB6A3,        0xBFC9,
	/* U+53F0 */        0xCCA8,        0xDFB3,        0xCAB7,        0xD3D2,        0x85B4,        0xD8CF,        0xD2B6,        0xBAC5,
	/* U+53F8 */        0xCBBE,        0xCCBE,        0x85B5,        0xDFB7,        0xB5F0,        0xDFB4,        0x85B6,        0x85B7,
	/* U+5400 */        0x85B8,        0xD3F5,        0x85B9,        0xB3D4,        0xB8F7,        0x85BA,        0xDFBA,        0x85BB,
	/* U+5408 */        0xBACF,        0xBCAA,        0xB5F5,        0x85BC,        0xCDAC,        0xC3FB,        0xBAF3,        0xC0F4,
	/* U+5410 */        0xCDC2,        0xCFF2,        0xDFB8,        0xCFC5,        0x85BD,        0xC2C0,        0xDFB9,        0xC2F0,
	/* U+5418 */        0x85BE,        0x85BF,        0x85C0,        0xBEFD,        0x85C1,        0xC1DF,        0xCDCC,        0xD2F7,
	/* U+5420 */        0xB7CD,        0xDFC1,        0x85C2,        0xDFC4,        0x85C3,        0x85C4,        0xB7F1,        0xB0C9,
	/* U+5428 */        0xB6D6,        0xB7D4,        0x85C5,        0xBAAC,        0xCCFD,        0xBFD4,        0xCBB1,        0xC6F4,
	/* U+5430 */        0x85C6,        0xD6A8,        0xDFC5,        0x85C7,        0xCEE2,        0xB3B3,        0x85C8,        0x85C9,
	/* U+5438 */        0xCEFC,        0xB4B5,        0x85CA,        0xCEC7,        0xBAF0,        0x85CB,        0xCEE1,        0x85CC,
	/* U+5440 */        0xD1BD,        0x85CD,        0x85CE,        0xDFC0,        0x85CF,        0x85D0,        0xB4F4,        0x85D1,
	/* U+5448 */        0xB3CA,        0x85D2,        0xB8E6,        0xDFBB,        0x85D3,        0x85D4,        0x85D5,        0x85D6,
	/* U+5450 */        0xC4C5,        0x85D7,        0xDFBC,        0xDFBD,        0xDFBE,        0xC5BB,        0xDFBF,        0xDFC2,
	/* U+5458 */        0xD4B1,        0xDFC3,        0x85D8,        0xC7BA,        0xCED8,        0x85D9,        0x85DA,        0x85DB,
	/* U+5460 */        0x85DC,        0x85DD,        0xC4D8,        0x85DE,        0xDFCA,        0x85DF,        0xDFCF,        0x85E0,
	/* U+5468 */        0xD6DC,        0x85E1,        0x85E2,        0x85E3,        0x85E4,        0x85E5,        0x85E6,        0x85E7,
	/* U+5470 */        0x85E8,        0xDFC9,        0xDFDA,        0xCEB6,        0x85E9,        0xBAC7,        0xDFCE,        0xDFC8,
	/* U+5478 */        0xC5DE,        0x85EA,        0x85EB,        0xC9EB,        0xBAF4,        0xC3FC,        0x85EC,        0x85ED,
	/* U+5480 */        0xBED7,        0x85EE,        0xDFC6,        0x85EF,        0xDFCD,        0x85F0,        0xC5D8,        0x85F1,
	/* U+5488 */        0x85F2,        0x85F3,        0x85F4,        0xD5A6,        0xBACD,        0x85F5,        0xBECC,        0xD3BD,
	/* U+5490 */        0xB8C0,        0x85F6,        0xD6E4,        0x85F7,        0xDFC7,        0xB9BE,        0xBFA7,        0x85F8,
	/* U+5498 */        0x85F9,        0xC1FC,        0xDFCB,        0xDFCC,        0x85FA,        0xDFD0,        0x85FB,        0x85FC,
	/* U+54A0 */        0x85FD,        0x85FE,        0x8640,        0xDFDB,        0xDFE5,        0x8641,        0xDFD7,        0xDFD6,
	/* U+54A8 */        0xD7C9,        0xDFE3,        0xDFE4,        0xE5EB,        0xD2A7,        0xDFD2,        0x8642,        0xBFA9,
	/* U+54B0 */        0x8643,        0xD4DB,        0x8644,        0xBFC8,        0xDFD4,        0x8645,        0x8646,        0x8647,
	/* U+54B8 */        0xCFCC,        0x8648,        0x8649,        0xDFDD,        0x864A,        0xD1CA,        0x864B,        0xDFDE,
	/* U+54C0 */        0xB0A7,        0xC6B7,        0xDFD3,        0x864C,        0xBAE5,        0x864D,        0xB6DF,        0xCDDB,
	/* U+54C8 */        0xB9FE,        0xD4D5,        0x864E,        0x864F,        0xDFDF,        0xCFEC,        0xB0A5,        0xDFE7,
	/* U+54D0 */        0xDFD1,        0xD1C6,        0xDFD5,        0xDFD8,        0xDFD9,        0xDFDC,        0x8650,        0xBBA9,
	/* U+54D8 */        0x8651,        0xDFE0,        0xDFE1,        0x8652,        0xDFE2,        0xDFE6,        0xDFE8,        0xD3B4,
	/* U+54E0 */        0x8653,        0x8654,        0x8655,        0x8656,        0x8657,        0xB8E7,        0xC5B6,        0xDFEA,
	/* U+54E8 */        0xC9DA,        0xC1A8,        0xC4C4,        0x8658,        0x8659,        0xBFDE,        0xCFF8,        0x865A,
	/* U+54F0 */        0x865B,        0x865C,        0xD5DC,        0xDFEE,        0x865D,        0x865E,        0x865F,        0x8660,
	/* U+54F8 */        0x8661,        0x8662,        0xB2B8,        0x8663,        0xBADF,        0xDFEC,        0x8664,        0xDBC1,
	/* U+5500 */        0x8665,        0xD1E4,        0x8666,        0x8667,        0x8668,        0x8669,        0xCBF4,        0xB4BD,
	/* U+5508 */        0x866A,        0xB0A6,        0x866B,        0x866C,        0x866D,        0x866E,        0x866F,        0xDFF1,
	/* U+5510 */        0xCCC6,        0xDFF2,        0x8670,        0x8671,        0xDFED,        0x8672,        0x8673,        0x8674,
	/* U+5518 */        0x8675,        0x8676,        0x8677,        0xDFE9,        0x8678,        0x8679,        0x867A,        0x867B,
	/* U+5520 */        0xDFEB,        0x867C,        0xDFEF,        0xDFF0,        0xBBBD,        0x867D,        0x867E,        0xDFF3,
	/* U+5528 */        0x8680,        0x8681,        0xDFF4,        0x8682,        0xBBA3,        0x8683,        0xCADB,        0xCEA8,
	/* U+5530 */        0xE0A7,        0xB3AA,        0x8684,        0xE0A6,        0x8685,        0x8686,        0x8687,        0xE0A1,
	/* U+5538 */        0x8688,        0x8689,        0x868A,        0x868B,        0xDFFE,        0x868C,        0xCDD9,        0xDFFC,
	/* U+5540 */        0x868D,        0xDFFA,        0x868E,        0xBFD0,        0xD7C4,        0x868F,        0xC9CC,        0x8690,
	/* U+5548 */        0x8691,        0xDFF8,        0xB0A1,        0x8692,        0x8693,        0x8694,        0x8695,        0x8696,
	/* U+5550 */        0xDFFD,        0x8697,        0x8698,        0x8699,        0x869A,        0xDFFB,        0xE0A2,        0x869B,
	/* U+5558 */        0x869C,        0x869D,        0x869E,        0x869F,        0xE0A8,        0x86A0,        0x86A1,        0x86A2,
	/* U+5560 */        0x86A3,        0xB7C8,        0x86A4,        0x86A5,        0xC6A1,        0xC9B6,        0xC0B2,        0xDFF5,
	/* U+5568 */        0x86A6,        0x86A7,        0xC5BE,        0x86A8,        0xD8C4,        0xDFF9,        0xC4F6,        0x86A9,
	/* U+5570 */        0x86AA,        0x86AB,        0x86AC,        0x86AD,        0x86AE,        0xE0A3,        0xE0A4,        0xE0A5,
	/* U+5578 */        0xD0A5,        0x86AF,        0x86B0,        0xE0B4,        0xCCE4,        0x86B1,        0xE0B1,        0x86B2,
	/* U+5580 */        0xBFA6,        0xE0AF,        0xCEB9,        0xE0AB,        0xC9C6,        0x86B3,        0x86B4,        0xC0AE,
	/* U+5588 */        0xE0AE,        0xBAED,        0xBAB0,        0xE0A9,        0x86B5,        0x86B6,        0x86B7,        0xDFF6,
	/* U+5590 */        0x86B8,        0xE0B3,        0x86B9,        0x86BA,        0xE0B8,        0x86BB,        0x86BC,        0x86BD,
	/* U+5598 */        0xB4AD,        0xE0B9,        0x86BE,        0x86BF,        0xCFB2,        0xBAC8,        0x86C0,        0xE0B0,
	/* U+55A0 */        0x86C1,        0x86C2,        0x86C3,        0x86C4,        0x86C5,        0x86C6,        0x86C7,        0xD0FA,
	/* U+55A8 */        0x86C8,        0x86C9,        0x86CA,        0x86CB,        0x86CC,        0x86CD,        0x86CE,        0x86CF,
	/* U+55B0 */        0x86D0,        0xE0AC,        0x86D1,        0xD4FB,        0x86D2,        0xDFF7,        0x86D3,        0xC5E7,
	/* U+55B8 */        0x86D4,        0xE0AD,        0x86D5,        0xD3F7,        0x86D6,        0xE0B6,        0xE0B7,        0x86D7,
	/* U+55C0 */        0x86D8,        0x86D9,        0x86DA,        0x86DB,        0xE0C4,        0xD0E1,        0x86DC,        0x86DD,
	/* U+55C8 */        0x86DE,        0xE0BC,        0x86DF,        0x86E0,        0xE0C9,        0xE0CA,        0x86E1,        0x86E2,
	/* U+55D0 */        0x86E3,        0xE0BE,        0xE0AA,        0xC9A4,        0xE0C1,        0x86E4,        0xE0B2,        0x86E5,
	/* U+55D8 */        0x86E6,        0x86E7,        0x86E8,        0x86E9,        0xCAC8,        0xE0C3,        0x86EA,        0xE0B5,
	/* U+55E0 */        0x86EB,        0xCECB,        0x86EC,        0xCBC3,        0xE0CD,        0xE0C6,        0xE0C2,        0x86ED,
	/* U+55E8 */        0xE0CB,        0x86EE,        0xE0BA,        0xE0BF,        0xE0C0,        0x86EF,        0x86F0,        0xE0C5,
	/* U+55F0 */        0x86F1,        0x86F2,        0xE0C7,        0xE0C8,        0x86F3,        0xE0CC,        0x86F4,        0xE0BB,
	/* U+55F8 */        0x86F5,        0x86F6,        0x86F7,        0x86F8,        0x86F9,        0xCBD4,        0xE0D5,        0x86FA,
	/* U+5600 */        0xE0D6,        0xE0D2,        0x86FB,        0x86FC,        0x86FD,        0x86FE,        0x8740,        0x8741,
	/* U+5608 */        0xE0D0,        0xBCCE,        0x8742,        0x8743,        0xE0D1,        0x8744,        0xB8C2,        0xD8C5,
	/* U+5610 */        0x8745,        0x8746,        0x8747,        0x8748,        0x8749,        0x874A,        0x874B,        0x874C,
	/* U+5618 */        0xD0EA,        0x874D,        0x874E,        0xC2EF,        0x874F,        0x8750,        0xE0CF,        0xE0BD,
	/* U+5620 */        0x8751,        0x8752,        0x8753,        0xE0D4,        0xE0D3,        0x8754,        0x8755,        0xE0D7,
	/* U+5628 */        0x8756,        0x8757,        0x8758,        0x8759,        0xE0DC,        0xE0D8,        0x875A,        0x875B,
	/* U+5630 */        0x875C,        0xD6F6,        0xB3B0,        0x875D,        0xD7EC,        0x875E,        0xCBBB,        0x875F,
	/* U+5638 */        0x8760,        0xE0DA,        0x8761,        0xCEFB,        0x8762,        0x8763,        0x8764,        0xBAD9,
	/* U+5640 */        0x8765,        0x8766,        0x8767,        0x8768,        0x8769,        0x876A,        0x876B,        0x876C,
	/* U+5648 */        0x876D,        0x876E,        0x876F,        0x8770,        0xE0E1,        0xE0DD,        0xD2AD,        0x8771,
	/* U+5650 */        0x8772,        0x8773,        0x8774,        0x8775,        0xE0E2,        0x8776,        0x8777,        0xE0DB,
	/* U+5658 */        0xE0D9,        0xE0DF,        0x8778,        0x8779,        0xE0E0,        0x877A,        0x877B,        0x877C,
	/* U+5660 */        0x877D,        0x877E,        0xE0DE,        0x8780,        0xE0E4,        0x8781,        0x8782,        0x8783,
	/* U+5668 */        0xC6F7,        0xD8AC,        0xD4EB,        0xE0E6,        0xCAC9,        0x8784,        0x8785,        0x8786,
	/* U+5670 */        0x8787,        0xE0E5,        0x8788,        0x8789,        0x878A,        0x878B,        0xB8C1,        0x878C,
	/* U+5678 */        0x878D,        0x878E,        0x878F,        0xE0E7,        0xE0E8,        0x8790,        0x8791,        0x8792,
	/* U+5680 */        0x8793,        0x8794,        0x8795,        0x8796,        0x8797,        0xE0E9,        0xE0E3,        0x8798,
	/* U+5688 */        0x8799,        0x879A,        0x879B,        0x879C,        0x879D,        0x879E,        0xBABF,        0xCCE7,
	/* U+5690 */        0x879F,        0x87A0,        0x87A1,        0xE0EA,        0x87A2,        0x87A3,        0x87A4,        0x87A5,
	/* U+5698 */        0x87A6,        0x87A7,        0x87A8,        0x87A9,        0x87AA,        0x87AB,        0x87AC,        0x87AD,
	/* U+56A0 */        0x87AE,        0x87AF,        0x87B0,        0xCFF9,        0x87B1,        0x87B2,        0x87B3,        0x87B4,
	/* U+56A8 */        0x87B5,        0x87B6,        0x87B7,        0x87B8,        0x87B9,        0x87BA,        0x87BB,        0xE0EB,
	/* U+56B0 */        0x87BC,        0x87BD,        0x87BE,        0x87BF,        0x87C0,        0x87C1,        0x87C2,        0xC8C2,
	/* U+56B8 */        0x87C3,        0x87C4,        0x87C5,        0x87C6,        0xBDC0,        0x87C7,        0x87C8,        0x87C9,
	/* U+56C0 */        0x87CA,        0x87CB,        0x87CC,        0x87CD,        0x87CE,        0x87CF,        0x87D0,        0x87D1,
	/* U+56C8 */        0x87D2,        0x87D3,        0xC4D2,        0x87D4,        0x87D5,        0x87D6,        0x87D7,        0x87D8,
	/* U+56D0 */        0x87D9,        0x87DA,        0x87DB,        0x87DC,        0xE0EC,        0x87DD,        0x87DE,        0xE0ED,
	/* U+56D8 */        0x87DF,        0x87E0,        0xC7F4,        0xCBC4,        0x87E1,        0xE0EE,        0xBBD8,        0xD8B6,
	/* U+56E0 */        0xD2F2,        0xE0EF,        0xCDC5,        0x87E2,        0xB6DA,        0x87E3,        0x87E4,        0x87E5,
	/* U+56E8 */        0x87E6,        0x87E7,        0x87E8,        0xE0F1,        0x87E9,        0xD4B0,        0x87EA,        0x87EB,
	/* U+56F0 */        0xC0A7,        0xB4D1,        0x87EC,        0x87ED,        0xCEA7,        0xE0F0,        0x87EE,        0x87EF,
	/* U+56F8 */        0x87F0,        0xE0F2,        0xB9CC,        0x87F1,        0x87F2,        0xB9FA,        0xCDBC,        0xE0F3,
	/* U+5700 */        0x87F3,        0x87F4,        0x87F5,        0xC6D4,        0xE0F4,        0x87F6,        0xD4B2,        0x87F7,
	/* U+5708 */        0xC8A6,        0xE0F6,        0xE0F5,        0x87F8,        0x87F9,        0x87FA,        0x87FB,        0x87FC,
	/* U+5710 */        0x87FD,        0x87FE,        0x8840,        0x8841,        0x8842,        0x8843,        0x8844,        0x8845,
	/* U+5718 */        0x8846,        0x8847,        0x8848,        0x8849,        0xE0F7,        0x884A,        0x884B,        0xCDC1,
	/* U+5720 */        0x884C,        0x884D,        0x884E,        0xCAA5,        0x884F,        0x8850,        0x8851,        0x8852,
	/* U+5728 */        0xD4DA,        0xDBD7,        0xDBD9,        0x8853,        0xDBD8,        0xB9E7,        0xDBDC,        0xDBDD,
	/* U+5730 */        0xB5D8,        0x8854,        0x8855,        0xDBDA,        0x8856,        0x8857,        0x8858,        0x8859,
	/* U+5738 */        0x885A,        0xDBDB,        0xB3A1,        0xDBDF,        0x885B,        0x885C,        0xBBF8,        0x885D,
	/* U+5740 */        0xD6B7,        0x885E,        0xDBE0,        0x885F,        0x8860,        0x8861,        0x8862,        0xBEF9,
	/* U+5748 */        0x8863,        0x8864,        0xB7BB,        0x8865,        0xDBD0,        0xCCAE,        0xBFB2,        0xBBB5,
	/* U+5750 */        0xD7F8,        0xBFD3,        0x8866,        0x8867,        0x8868,        0x8869,        0x886A,        0xBFE9,
	/* U+5758 */        0x886B,        0x886C,        0xBCE1,        0xCCB3,        0xDBDE,        0xB0D3,        0xCEEB,        0xB7D8,
	/* U+5760 */        0xD7B9,        0xC6C2,        0x886D,        0x886E,        0xC0A4,        0x886F,        0xCCB9,        0x8870,
	/* U+5768 */        0xDBE7,        0xDBE1,        0xC6BA,        0xDBE3,        0x8871,        0xDBE8,        0x8872,        0xC5F7,
	/* U+5770 */        0x8873,        0x8874,        0x8875,        0xDBEA,        0x8876,        0x8877,        0xDBE9,        0xBFC0,
	/* U+5778 */        0x8878,        0x8879,        0x887A,        0xDBE6,        0xDBE5,        0x887B,        0x887C,        0x887D,
	/* U+5780 */        0x887E,        0x8880,        0xB4B9,        0xC0AC,        0xC2A2,        0xDBE2,        0xDBE4,        0x8881,
	/* U+5788 */        0x8882,        0x8883,        0x8884,        0xD0CD,        0xDBED,        0x8885,        0x8886,        0x8887,
	/* U+5790 */        0x8888,        0x8889,        0xC0DD,        0xDBF2,        0x888A,        0x888B,        0x888C,        0x888D,
	/* U+5798 */        0x888E,        0x888F,        0x8890,        0xB6E2,        0x8891,        0x8892,        0x8893,        0x8894,
	/* U+57A0 */        0xDBF3,        0xDBD2,        0xB9B8,        0xD4AB,        0xDBEC,        0x8895,        0xBFD1,        0xDBF0,
	/* U+57A8 */        0x8896,        0xDBD1,        0x8897,        0xB5E6,        0x8898,        0xDBEB,        0xBFE5,        0x8899,
	/* U+57B0 */        0x889A,        0x889B,        0xDBEE,        0x889C,        0xDBF1,        0x889D,        0x889E,        0x889F,
	/* U+57B8 */        0xDBF9,        0x88A0,        0x88A1,        0x88A2,        0x88A3,        0x88A4,        0x88A5,        0x88A6,
	/* U+57C0 */        0x88A7,        0x88A8,        0xB9A1,        0xB0A3,        0x88A9,        0x88AA,        0x88AB,        0x88AC,
	/* U+57C8 */        0x88AD,        0x88AE,        0x88AF,        0xC2F1,        0x88B0,        0x88B1,        0xB3C7,        0xDBEF,
	/* U+57D0 */        0x88B2,        0x88B3,        0xDBF8,        0x88B4,        0xC6D2,        0xDBF4,        0x88B5,        0x88B6,
	/* U+57D8 */        0xDBF5,        0xDBF7,        0xDBF6,        0x88B7,        0x88B8,        0xDBFE,        0x88B9,        0xD3F2,
	/* U+57E0 */        0xB2BA,        0x88BA,        0x88BB,        0x88BC,        0xDBFD,        0x88BD,        0x88BE,        0x88BF,
	/* U+57E8 */        0x88C0,        0x88C1,        0x88C2,        0x88C3,        0x88C4,        0xDCA4,        0x88C5,        0xDBFB,
	/* U+57F0 */        0x88C6,        0x88C7,        0x88C8,        0x88C9,        0xDBFA,        0x88CA,        0x88CB,        0x88CC,
	/* U+57F8 */        0xDBFC,        0xC5E0,        0xBBF9,        0x88CD,        0x88CE,        0xDCA3,        0x88CF,        0x88D0,
	/* U+5800 */        0xDCA5,        0x88D1,        0xCCC3,        0x88D2,        0x88D3,        0x88D4,        0xB6D1,        0xDDC0,
	/* U+5808 */        0x88D5,        0x88D6,        0x88D7,        0xDCA1,        0x88D8,        0xDCA2,        0x88D9,        0x88DA,
	/* U+5810 */        0x88DB,        0xC7B5,        0x88DC,        0x88DD,        0x88DE,        0xB6E9,        0x88DF,        0x88E0,
	/* U+5818 */        0x88E1,        0xDCA7,        0x88E2,        0x88E3,        0x88E4,        0x88E5,        0xDCA6,        0x88E6,
	/* U+5820 */        0xDCA9,        0xB1A4,        0x88E7,        0x88E8,        0xB5CC,        0x88E9,        0x88EA,        0x88EB,
	/* U+5828 */        0x88EC,        0x88ED,        0xBFB0,        0x88EE,        0x88EF,        0x88F0,        0x88F1,        0x88F2,
	/* U+5830 */        0xD1DF,        0x88F3,        0x88F4,        0x88F5,        0x88F6,        0xB6C2,        0x88F7,        0x88F8,
	/* U+5838 */        0x88F9,        0x88FA,        0x88FB,        0x88FC,        0x88FD,        0x88FE,        0x8940,        0x8941,
	/* U+5840 */        0x8942,        0x8943,        0x8944,        0x8945,        0xDCA8,        0x8946,        0x8947,        0x8948,
	/* U+5848 */        0x8949,        0x894A,        0x894B,        0x894C,        0xCBFA,        0xEBF3,        0x894D,        0x894E,
	/* U+5850 */        0x894F,        0xCBDC,        0x8950,        0x8951,        0xCBFE,        0x8952,        0x8953,        0x8954,
	/* U+5858 */        0xCCC1,        0x8955,        0x8956,        0x8957,        0x8958,        0x8959,        0xC8FB,        0x895A,
	/* U+5860 */        0x895B,        0x895C,        0x895D,        0x895E,        0x895F,        0xDCAA,        0x8960,        0x8961,
	/* U+5868 */        0x8962,        0x8963,        0x8964,        0xCCEE,        0xDCAB,        0x8965,        0x8966,        0x8967,
	/* U+5870 */        0x8968,        0x8969,        0x896A,        0x896B,        0x896C,        0x896D,        0x896E,        0x896F,
	/* U+5878 */        0x8970,        0x8971,        0x8972,        0x8973,        0x8974,        0x8975,        0xDBD3,        0x8976,
	/* U+5880 */        0xDCAF,        0xDCAC,        0x8977,        0xBEB3,        0x8978,        0xCAFB,        0x8979,        0x897A,
	/* U+5888 */        0x897B,        0xDCAD,        0x897C,        0x897D,        0x897E,        0x8980,        0x8981,        0x8982,
	/* U+5890 */        0x8983,        0x8984,        0xC9CA,        0xC4B9,        0x8985,        0x8986,        0x8987,        0x8988,
	/* U+5898 */        0x8989,        0xC7BD,        0xDCAE,        0x898A,        0x898B,        0x898C,        0xD4F6,        0xD0E6,
	/* U+58A0 */        0x898D,        0x898E,        0x898F,        0x8990,        0x8991,        0x8992,        0x8993,        0x8994,
	/* U+58A8 */        0xC4AB,        0xB6D5,        0x8995,        0x8996,        0x8997,        0x8998,        0x8999,        0x899A,
	/* U+58B0 */        0x899B,        0x899C,        0x899D,        0x899E,        0x899F,        0x89A0,        0x89A1,        0x89A2,
	/* U+58B8 */        0x89A3,        0x89A4,        0x89A5,        0x89A6,        0xDBD4,        0x89A7,        0x89A8,        0x89A9,
	/* U+58C0 */        0x89AA,        0xB1DA,        0x89AB,        0x89AC,        0x89AD,        0xDBD5,        0x89AE,        0x89AF,
	/* U+58C8 */        0x89B0,        0x89B1,        0x89B2,        0x89B3,        0x89B4,        0x89B5,        0x89B6,        0x89B7,
	/* U+58D0 */        0x89B8,        0xDBD6,        0x89B9,        0x89BA,        0x89BB,        0xBABE,        0x89BC,        0x89BD,
	/* U+58D8 */        0x89BE,        0x89BF,        0x89C0,        0x89C1,        0x89C2,        0x89C3,        0x89C4,        0x89C5,
	/* U+58E0 */        0x89C6,        0x89C7,        0x89C8,        0x89C9,        0xC8C0,        0x89CA,        0x89CB,        0x89CC,
	/* U+58E8 */        0x89CD,        0x89CE,        0x89CF,        0xCABF,        0xC8C9,        0x89D0,        0xD7B3,        0x89D1,
	/* U+58F0 */        0xC9F9,        0x89D2,        0x89D3,        0xBFC7,        0x89D4,        0x89D5,        0xBAF8,        0x89D6,
	/* U+58F8 */        0x89D7,        0xD2BC,        0x89D8,        0x89D9,        0x89DA,        0x89DB,        0x89DC,        0x89DD,
	/* U+5900 */        0x89DE,        0x89DF,        0xE2BA,        0x89E0,        0xB4A6,        0x89E1,        0x89E2,        0xB1B8,
	/* U+5908 */        0x89E3,        0x89E4,        0x89E5,        0x89E6,        0x89E7,        0xB8B4,        0x89E8,        0xCFC4,
	/* U+5910 */        0x89E9,        0x89EA,        0x89EB,        0x89EC,        0xD9E7,        0xCFA6,        0xCDE2,        0x89ED,
	/* U+5918 */        0x89EE,        0xD9ED,        0xB6E0,        0x89EF,        0xD2B9,        0x89F0,        0x89F1,        0xB9BB,
	/* U+5920 */        0x89F2,        0x89F3,        0x89F4,        0x89F5,        0xE2B9,        0xE2B7,        0x89F6,        0xB4F3,
	/* U+5928 */        0x89F7,        0xCCEC,        0xCCAB,        0xB7F2,        0x89F8,        0xD8B2,        0xD1EB,        0xBABB,
	/* U+5930 */        0x89F9,        0xCAA7,        0x89FA,        0x89FB,        0xCDB7,        0x89FC,        0x89FD,        0xD2C4,
	/* U+5938 */        0xBFE4,        0xBCD0,        0xB6E1,        0x89FE,        0xDEC5,        0x8A40,        0x8A41,        0x8A42,
	/* U+5940 */        0x8A43,        0xDEC6,        0xDBBC,        0x8A44,        0xD1D9,        0x8A45,        0x8A46,        0xC6E6,
	/* U+5948 */        0xC4CE,        0xB7EE,        0x8A47,        0xB7DC,        0x8A48,        0x8A49,        0xBFFC,        0xD7E0,
	/* U+5950 */        0x8A4A,        0xC6F5,        0x8A4B,        0x8A4C,        0xB1BC,        0xDEC8,        0xBDB1,        0xCCD7,
	/* U+5958 */        0xDECA,        0x8A4D,        0xDEC9,        0x8A4E,        0x8A4F,        0x8A50,        0x8A51,        0x8A52,
	/* U+5960 */        0xB5EC,        0x8A53,        0xC9DD,        0x8A54,        0x8A55,        0xB0C2,        0x8A56,        0x8A57,
	/* U+5968 */        0x8A58,        0x8A59,        0x8A5A,        0x8A5B,        0x8A5C,        0x8A5D,        0x8A5E,        0x8A5F,
	/* U+5970 */        0x8A60,        0x8A61,        0x8A62,        0xC5AE,        0xC5AB,        0x8A63,        0xC4CC,        0x8A64,
	/* U+5978 */        0xBCE9,        0xCBFD,        0x8A65,        0x8A66,        0x8A67,        0xBAC3,        0x8A68,        0x8A69,
	/* U+5980 */        0x8A6A,        0xE5F9,        0xC8E7,        0xE5FA,        0xCDFD,        0x8A6B,        0xD7B1,        0xB8BE,
	/* U+5988 */        0xC2E8,        0x8A6C,        0xC8D1,        0x8A6D,        0x8A6E,        0xE5FB,        0x8A6F,        0x8A70,
	/* U+5990 */        0x8A71,        0x8A72,        0xB6CA,        0xBCCB,        0x8A73,        0x8A74,        0xD1FD,        0xE6A1,
	/* U+5998 */        0x8A75,        0xC3EE,        0x8A76,        0x8A77,        0x8A78,        0x8A79,        0xE6A4,        0x8A7A,
	/* U+59A0 */        0x8A7B,        0x8A7C,        0x8A7D,        0xE5FE,        0xE6A5,        0xCDD7,        0x8A7E,        0x8A80,
	/* U+59A8 */        0xB7C1,        0xE5FC,        0xE5FD,        0xE6A3,        0x8A81,        0x8A82,        0xC4DD,        0xE6A8,
	/* U+59B0 */        0x8A83,        0x8A84,        0xE6A7,        0x8A85,        0x8A86,        0x8A87,        0x8A88,        0x8A89,
	/* U+59B8 */        0x8A8A,        0xC3C3,        0x8A8B,        0xC6DE,        0x8A8C,        0x8A8D,        0xE6AA,        0x8A8E,
	/* U+59C0 */        0x8A8F,        0x8A90,        0x8A91,        0x8A92,        0x8A93,        0x8A94,        0xC4B7,        0x8A95,
	/* U+59C8 */        0x8A96,        0x8A97,        0xE6A2,        0xCABC,        0x8A98,        0x8A99,        0x8A9A,        0x8A9B,
	/* U+59D0 */        0xBDE3,        0xB9C3,        0xE6A6,        0xD0D5,        0xCEAF,        0x8A9C,        0x8A9D,        0xE6A9,
	/* U+59D8 */        0xE6B0,        0x8A9E,        0xD2A6,        0x8A9F,        0xBDAA,        0xE6AD,        0x8AA0,        0x8AA1,
	/* U+59E0 */        0x8AA2,        0x8AA3,        0x8AA4,        0xE6AF,        0x8AA5,        0xC0D1,        0x8AA6,        0x8AA7,
	/* U+59E8 */        0xD2CC,        0x8AA8,        0x8AA9,        0x8AAA,        0xBCA7,        0x8AAB,        0x8AAC,        0x8AAD,
	/* U+59F0 */        0x8AAE,        0x8AAF,        0x8AB0,        0x8AB1,        0x8AB2,        0x8AB3,        0x8AB4,        0x8AB5,
	/* U+59F8 */        0x8AB6,        0xE6B1,        0x8AB7,        0xD2F6,        0x8AB8,        0x8AB9,        0x8ABA,        0xD7CB,
	/* U+5A00 */        0x8ABB,        0xCDFE,        0x8ABC,        0xCDDE,        0xC2A6,        0xE6AB,        0xE6AC,        0xBDBF,
	/* U+5A08 */        0xE6AE,        0xE6B3,        0x8ABD,        0x8ABE,        0xE6B2,        0x8ABF,        0x8AC0,        0x8AC1,
	/* U+5A10 */        0x8AC2,        0xE6B6,        0x8AC3,        0xE6B8,        0x8AC4,        0x8AC5,        0x8AC6,        0x8AC7,
	/* U+5A18 */        0xC4EF,        0x8AC8,        0x8AC9,        0x8ACA,        0xC4C8,        0x8ACB,        0x8ACC,        0xBEEA,
	/* U+5A20 */        0xC9EF,        0x8ACD,        0x8ACE,        0xE6B7,        0x8ACF,        0xB6F0,        0x8AD0,        0x8AD1,
	/* U+5A28 */        0x8AD2,        0xC3E4,        0x8AD3,        0x8AD4,        0x8AD5,        0x8AD6,        0x8AD7,        0x8AD8,
	/* U+5A30 */        0x8AD9,        0xD3E9,        0xE6B4,        0x8ADA,        0xE6B5,        0x8ADB,        0xC8A2,        0x8ADC,
	/* U+5A38 */        0x8ADD,        0x8ADE,        0x8ADF,        0x8AE0,        0xE6BD,        0x8AE1,        0x8AE2,        0x8AE3,
	/* U+5A40 */        0xE6B9,        0x8AE4,        0x8AE5,        0x8AE6,        0x8AE7,        0x8AE8,        0xC6C5,        0x8AE9,
	/* U+5A48 */        0x8AEA,        0xCDF1,        0xE6BB,        0x8AEB,        0x8AEC,        0x8AED,        0x8AEE,        0x8AEF,
	/* U+5A50 */        0x8AF0,        0x8AF1,        0x8AF2,        0x8AF3,        0x8AF4,        0xE6BC,        0x8AF5,        0x8AF6,
	/* U+5A58 */        0x8AF7,        0x8AF8,        0xBBE9,        0x8AF9,        0x8AFA,        0x8AFB,        0x8AFC,        0x8AFD,
	/* U+5A60 */        0x8AFE,        0x8B40,        0xE6BE,        0x8B41,        0x8B42,        0x8B43,        0x8B44,        0xE6BA,
	/* U+5A68 */        0x8B45,        0x8B46,        0xC0B7,        0x8B47,        0x8B48,        0x8B49,        0x8B4A,        0x8B4B,
	/* U+5A70 */        0x8B4C,        0x8B4D,        0x8B4E,        0x8B4F,        0xD3A4,        0xE6BF,        0xC9F4,        0xE6C3,
	/* U+5A78 */        0x8B50,        0x8B51,        0xE6C4,        0x8B52,        0x8B53,        0x8B54,        0x8B55,        0xD0F6,
	/* U+5A80 */        0x8B56,        0x8B57,        0x8B58,        0x8B59,        0x8B5A,        0x8B5B,        0x8B5C,        0x8B5D,
	/* U+5A88 */        0x8B5E,        0x8B5F,        0x8B60,        0x8B61,        0x8B62,        0x8B63,        0x8B64,        0x8B65,
	/* U+5A90 */        0x8B66,        0x8B67,        0xC3BD,        0x8B68,        0x8B69,        0x8B6A,        0x8B6B,        0x8B6C,
	/* U+5A98 */        0x8B6D,        0x8B6E,        0xC3C4,        0xE6C2,        0x8B6F,        0x8B70,        0x8B71,        0x8B72,
	/* U+5AA0 */        0x8B73,        0x8B74,        0x8B75,        0x8B76,        0x8B77,        0x8B78,        0x8B79,        0x8B7A,
	/* U+5AA8 */        0x8B7B,        0x8B7C,        0xE6C1,        0x8B7D,        0x8B7E,        0x8B80,        0x8B81,        0x8B82,
	/* U+5AB0 */        0x8B83,        0x8B84,        0xE6C7,        0xCFB1,        0x8B85,        0xEBF4,        0x8B86,        0x8B87,
	/* U+5AB8 */        0xE6CA,        0x8B88,        0x8B89,        0x8B8A,        0x8B8B,        0x8B8C,        0xE6C5,        0x8B8D,
	/* U+5AC0 */        0x8B8E,        0xBCDE,        0xC9A9,        0x8B8F,        0x8B90,        0x8B91,        0x8B92,        0x8B93,
	/* U+5AC8 */        0x8B94,        0xBCB5,        0x8B95,        0x8B96,        0xCFD3,        0x8B97,        0x8B98,        0x8B99,
	/* U+5AD0 */        0x8B9A,        0x8B9B,        0xE6C8,        0x8B9C,        0xE6C9,        0x8B9D,        0xE6CE,        0x8B9E,
	/* U+5AD8 */        0xE6D0,        0x8B9F,        0x8BA0,        0x8BA1,        0xE6D1,        0x8BA2,        0x8BA3,        0x8BA4,
	/* U+5AE0 */        0xE6CB,        0xB5D5,        0x8BA5,        0xE6CC,        0x8BA6,        0x8BA7,        0xE6CF,        0x8BA8,
	/* U+5AE8 */        0x8BA9,        0xC4DB,        0x8BAA,        0xE6C6,        0x8BAB,        0x8BAC,        0x8BAD,        0x8BAE,
	/* U+5AF0 */        0x8BAF,        0xE6CD,        0x8BB0,        0x8BB1,        0x8BB2,        0x8BB3,        0x8BB4,        0x8BB5,
	/* U+5AF8 */        0x8BB6,        0x8BB7,        0x8BB8,        0x8BB9,        0x8BBA,        0x8BBB,        0x8BBC,        0x8BBD,
	/* U+5B00 */        0x8BBE,        0x8BBF,        0x8BC0,        0x8BC1,        0x8BC2,        0x8BC3,        0x8BC4,        0x8BC5,
	/* U+5B08 */        0x8BC6,        0xE6D2,        0x8BC7,        0x8BC8,        0x8BC9,        0x8BCA,        0x8BCB,        0x8BCC,
	/* U+5B10 */        0x8BCD,        0x8BCE,        0x8BCF,        0x8BD0,        0x8BD1,        0x8BD2,        0xE6D4,        0xE6D3,
	/* U+5B18 */        0x8BD3,        0x8BD4,        0x8BD5,        0x8BD6,        0x8BD7,        0x8BD8,        0x8BD9,        0x8BDA,
	/* U+5B20 */        0x8BDB,        0x8BDC,        0x8BDD,        0x8BDE,        0x8BDF,        0x8BE0,        0x8BE1,        0x8BE2,
	/* U+5B28 */        0x8BE3,        0x8BE4,        0x8BE5,        0x8BE6,        0x8BE7,        0x8BE8,        0x8BE9,        0x8BEA,
	/* U+5B30 */        0x8BEB,        0x8BEC,        0xE6D5,        0x8BED,        0xD9F8,        0x8BEE,        0x8BEF,        0xE6D6,
	/* U+5B38 */        0x8BF0,        0x8BF1,        0x8BF2,        0x8BF3,        0x8BF4,        0x8BF5,        0x8BF6,        0x8BF7,
	/* U+5B40 */        0xE6D7,        0x8BF8,        0x8BF9,        0x8BFA,        0x8BFB,        0x8BFC,        0x8BFD,        0x8BFE,
	/* U+5B48 */        0x8C40,        0x8C41,        0x8C42,        0x8C43,        0x8C44,        0x8C45,        0x8C46,        0x8C47,
	/* U+5B50 */        0xD7D3,        0xE6DD,        0x8C48,        0xE6DE,        0xBFD7,        0xD4D0,        0x8C49,        0xD7D6,
	/* U+5B58 */        0xB4E6,        0xCBEF,        0xE6DA,        0xD8C3,        0xD7CE,        0xD0A2,        0x8C4A,        0xC3CF,
	/* U+5B60 */        0x8C4B,        0x8C4C,        0xE6DF,        0xBCBE,        0xB9C2,        0xE6DB,        0xD1A7,        0x8C4D,
	/* U+5B68 */        0x8C4E,        0xBAA2,        0xC2CF,        0x8C4F,        0xD8AB,        0x8C50,        0x8C51,        0x8C52,
	/* U+5B70 */        0xCAEB,        0xE5EE,        0x8C53,        0xE6DC,        0x8C54,        0xB7F5,        0x8C55,        0x8C56,
	/* U+5B78 */        0x8C57,        0x8C58,        0xC8E6,        0x8C59,        0x8C5A,        0xC4F5,        0x8C5B,        0x8C5C,
	/* U+5B80 */        0xE5B2,        0xC4FE,        0x8C5D,        0xCBFC,        0xE5B3,        0xD5AC,        0x8C5E,        0xD3EE,
	/* U+5B88 */        0xCAD8,        0xB0B2,        0x8C5F,        0xCBCE,        0xCDEA,        0x8C60,        0x8C61,        0xBAEA,
	/* U+5B90 */        0x8C62,        0x8C63,        0x8C64,        0xE5B5,        0x8C65,        0xE5B4,        0x8C66,        0xD7DA,
	/* U+5B98 */        0xB9D9,        0xD6E6,        0xB6A8,        0xCDF0,        0xD2CB,        0xB1A6,        0xCAB5,        0x8C67,
	/* U+5BA0 */        0xB3E8,        0xC9F3,        0xBFCD,        0xD0FB,        0xCAD2,        0xE5B6,        0xBBC2,        0x8C68,
	/* U+5BA8 */        0x8C69,        0x8C6A,        0xCFDC,        0xB9AC,        0x8C6B,        0x8C6C,        0x8C6D,        0x8C6E,
	/* U+5BB0 */        0xD4D7,        0x8C6F,        0x8C70,        0xBAA6,        0xD1E7,        0xCFFC,        0xBCD2,        0x8C71,
	/* U+5BB8 */        0xE5B7,        0xC8DD,        0x8C72,        0x8C73,        0x8C74,        0xBFED,        0xB1F6,        0xCBDE,
	/* U+5BC0 */        0x8C75,        0x8C76,        0xBCC5,        0x8C77,        0xBCC4,        0xD2FA,        0xC3DC,        0xBFDC,
	/* U+5BC8 */        0x8C78,        0x8C79,        0x8C7A,        0x8C7B,        0xB8BB,        0x8C7C,        0x8C7D,        0x8C7E,
	/* U+5BD0 */        0xC3C2,        0x8C80,        0xBAAE,        0xD4A2,        0x8C81,        0x8C82,        0x8C83,        0x8C84,
	/* U+5BD8 */        0x8C85,        0x8C86,        0x8C87,        0x8C88,        0x8C89,        0xC7DE,        0xC4AF,        0xB2EC,
	/* U+5BE0 */        0x8C8A,        0xB9D1,        0x8C8B,        0x8C8C,        0xE5BB,        0xC1C8,        0x8C8D,        0x8C8E,
	/* U+5BE8 */        0xD5AF,        0x8C8F,        0x8C90,        0x8C91,        0x8C92,        0x8C93,        0xE5BC,        0x8C94,
	/* U+5BF0 */        0xE5BE,        0x8C95,        0x8C96,        0x8C97,        0x8C98,        0x8C99,        0x8C9A,        0x8C9B,
	/* U+5BF8 */        0xB4E7,        0xB6D4,        0xCBC2,        0xD1B0,        0xB5BC,        0x8C9C,        0x8C9D,        0xCAD9,
	/* U+5C00 */        0x8C9E,        0xB7E2,        0x8C9F,        0x8CA0,        0xC9E4,        0x8CA1,        0xBDAB,        0x8CA2,
	/* U+5C08 */        0x8CA3,        0xCEBE,        0xD7F0,        0x8CA4,        0x8CA5,        0x8CA6,        0x8CA7,        0xD0A1,
	/* U+5C10 */        0x8CA8,        0xC9D9,        0x8CA9,        0x8CAA,        0xB6FB,        0xE6D8,        0xBCE2,        0x8CAB,
	/* U+5C18 */        0xB3BE,        0x8CAC,        0xC9D0,        0x8CAD,        0xE6D9,        0xB3A2,        0x8CAE,        0x8CAF,
	/* U+5C20 */        0x8CB0,        0x8CB1,        0xDECC,        0x8CB2,        0xD3C8,        0xDECD,        0x8CB3,        0xD2A2,
	/* U+5C28 */        0x8CB4,        0x8CB5,        0x8CB6,        0x8CB7,        0xDECE,        0x8CB8,        0x8CB9,        0x8CBA,
	/* U+5C30 */        0x8CBB,        0xBECD,        0x8CBC,        0x8CBD,        0xDECF,        0x8CBE,        0x8CBF,        0x8CC0,
	/* U+5C38 */        0xCAAC,        0xD2FC,        0xB3DF,        0xE5EA,        0xC4E1,        0xBEA1,        0xCEB2,        0xC4F2,
	/* U+5C40 */        0xBED6,        0xC6A8,        0xB2E3,        0x8CC1,        0x8CC2,        0xBED3,        0x8CC3,        0x8CC4,
	/* U+5C48 */        0xC7FC,        0xCCEB,        0xBDEC,        0xCEDD,        0x8CC5,        0x8CC6,        0xCABA,        0xC6C1,
	/* U+5C50 */        0xE5EC,        0xD0BC,        0x8CC7,        0x8CC8,        0x8CC9,        0xD5B9,        0x8CCA,        0x8CCB,
	/* U+5C58 */        0x8CCC,        0xE5ED,        0x8CCD,        0x8CCE,        0x8CCF,        0x8CD0,        0xCAF4,        0x8CD1,
	/* U+5C60 */        0xCDC0,        0xC2C5,        0x8CD2,        0xE5EF,        0x8CD3,        0xC2C4,        0xE5F0,        0x8CD4,
	/* U+5C68 */        0x8CD5,        0x8CD6,        0x8CD7,        0x8CD8,        0x8CD9,        0x8CDA,        0xE5F8,        0xCDCD,
	/* U+5C70 */        0x8CDB,        0xC9BD,        0x8CDC,        0x8CDD,        0x8CDE,        0x8CDF,        0x8CE0,        0x8CE1,
	/* U+5C78 */        0x8CE2,        0xD2D9,        0xE1A8,        0x8CE3,        0x8CE4,        0x8CE5,        0x8CE6,        0xD3EC,
	/* U+5C80 */        0x8CE7,        0xCBEA,        0xC6F1,        0x8CE8,        0x8CE9,        0x8CEA,        0x8CEB,        0x8CEC,
	/* U+5C88 */        0xE1AC,        0x8CED,        0x8CEE,        0x8CEF,        0xE1A7,        0xE1A9,        0x8CF0,        0x8CF1,
	/* U+5C90 */        0xE1AA,        0xE1AF,        0x8CF2,        0x8CF3,        0xB2ED,        0x8CF4,        0xE1AB,        0xB8DA,
	/* U+5C98 */        0xE1AD,        0xE1AE,        0xE1B0,        0xB5BA,        0xE1B1,        0x8CF5,        0x8CF6,        0x8CF7,
	/* U+5CA0 */        0x8CF8,        0x8CF9,        0xE1B3,        0xE1B8,        0x8CFA,        0x8CFB,        0x8CFC,        0x8CFD,
	/* U+5CA8 */        0x8CFE,        0xD1D2,        0x8D40,        0xE1B6,        0xE1B5,        0xC1EB,        0x8D41,        0x8D42,
	/* U+5CB0 */        0x8D43,        0xE1B7,        0x8D44,        0xD4C0,        0x8D45,        0xE1B2,        0x8D46,        0xE1BA,
	/* U+5CB8 */        0xB0B6,        0x8D47,        0x8D48,        0x8D49,        0x8D4A,        0xE1B4,        0x8D4B,        0xBFF9,
	/* U+5CC0 */        0x8D4C,        0xE1B9,        0x8D4D,        0x8D4E,        0xE1BB,        0x8D4F,        0x8D50,        0x8D51,
	/* U+5CC8 */        0x8D52,        0x8D53,        0x8D54,        0xE1BE,        0x8D55,        0x8D56,        0x8D57,        0x8D58,
	/* U+5CD0 */        0x8D59,        0x8D5A,        0xE1BC,        0x8D5B,        0x8D5C,        0x8D5D,        0x8D5E,        0x8D5F,
	/* U+5CD8 */        0x8D60,        0xD6C5,        0x8D61,        0x8D62,        0x8D63,        0x8D64,        0x8D65,        0x8D66,
	/* U+5CE0 */        0x8D67,        0xCFBF,        0x8D68,        0x8D69,        0xE1BD,        0xE1BF,        0xC2CD,        0x8D6A,
	/* U+5CE8 */        0xB6EB,        0x8D6B,        0xD3F8,        0x8D6C,        0x8D6D,        0xC7CD,        0x8D6E,        0x8D6F,
	/* U+5CF0 */        0xB7E5,        0x8D70,        0x8D71,        0x8D72,        0x8D73,        0x8D74,        0x8D75,        0x8D76,
	/* U+5CF8 */        0x8D77,        0x8D78,        0x8D79,        0xBEFE,        0x8D7A,        0x8D7B,        0x8D7C,        0x8D7D,
	/* U+5D00 */        0x8D7E,        0x8D80,        0xE1C0,        0xE1C1,        0x8D81,        0x8D82,        0xE1C7,        0xB3E7,
	/* U+5D08 */        0x8D83,        0x8D84,        0x8D85,        0x8D86,        0x8D87,        0x8D88,        0xC6E9,        0x8D89,
	/* U+5D10 */        0x8D8A,        0x8D8B,        0x8D8C,        0x8D8D,        0xB4DE,        0x8D8E,        0xD1C2,        0x8D8F,
	/* U+5D18 */        0x8D90,        0x8D91,        0x8D92,        0xE1C8,        0x8D93,        0x8D94,        0xE1C6,        0x8D95,
	/* U+5D20 */        0x8D96,        0x8D97,        0x8D98,        0x8D99,        0xE1C5,        0x8D9A,        0xE1C3,        0xE1C2,
	/* U+5D28 */        0x8D9B,        0xB1C0,        0x8D9C,        0x8D9D,        0x8D9E,        0xD5B8,        0xE1C4,        0x8D9F,
	/* U+5D30 */        0x8DA0,        0x8DA1,        0x8DA2,        0x8DA3,        0xE1CB,        0x8DA4,        0x8DA5,        0x8DA6,
	/* U+5D38 */        0x8DA7,        0x8DA8,        0x8DA9,        0x8DAA,        0x8DAB,        0xE1CC,        0xE1CA,        0x8DAC,
	/* U+5D40 */        0x8DAD,        0x8DAE,        0x8DAF,        0x8DB0,        0x8DB1,        0x8DB2,        0x8DB3,        0xEFFA,
	/* U+5D48 */        0x8DB4,        0x8DB5,        0xE1D3,        0xE1D2,        0xC7B6,        0x8DB6,        0x8DB7,        0x8DB8,
	/* U+5D50 */        0x8DB9,        0x8DBA,        0x8DBB,        0x8DBC,        0x8DBD,        0x8DBE,        0x8DBF,        0x8DC0,
	/* U+5D58 */        0xE1C9,        0x8DC1,        0x8DC2,        0xE1CE,        0x8DC3,        0xE1D0,        0x8DC4,        0x8DC5,
	/* U+5D60 */        0x8DC6,        0x8DC7,        0x8DC8,        0x8DC9,        0x8DCA,        0x8DCB,        0x8DCC,        0x8DCD,
	/* U+5D68 */        0x8DCE,        0xE1D4,        0x8DCF,        0xE1D1,        0xE1CD,        0x8DD0,        0x8DD1,        0xE1CF,
	/* U+5D70 */        0x8DD2,        0x8DD3,        0x8DD4,        0x8DD5,        0xE1D5,        0x8DD6,        0x8DD7,        0x8DD8,
	/* U+5D78 */        0x8DD9,        0x8DDA,        0x8DDB,        0x8DDC,        0x8DDD,        0x8DDE,        0x8DDF,        0x8DE0,
	/* U+5D80 */        0x8DE1,        0x8DE2,        0xE1D6,        0x8DE3,        0x8DE4,        0x8DE5,        0x8DE6,        0x8DE7,
	/* U+5D88 */        0x8DE8,        0x8DE9,        0x8DEA,        0x8DEB,        0x8DEC,        0x8DED,        0x8DEE,        0x8DEF,
	/* U+5D90 */        0x8DF0,        0x8DF1,        0x8DF2,        0x8DF3,        0x8DF4,        0x8DF5,        0x8DF6,        0x8DF7,
	/* U+5D98 */        0x8DF8,        0xE1D7,        0x8DF9,        0x8DFA,        0x8DFB,        0xE1D8,        0x8DFC,        0x8DFD,
	/* U+5DA0 */        0x8DFE,        0x8E40,        0x8E41,        0x8E42,        0x8E43,        0x8E44,        0x8E45,        0x8E46,
	/* U+5DA8 */        0x8E47,        0x8E48,        0x8E49,        0x8E4A,        0x8E4B,        0x8E4C,        0x8E4D,        0x8E4E,
	/* U+5DB0 */        0x8E4F,        0x8E50,        0x8E51,        0x8E52,        0x8E53,        0x8E54,        0x8E55,        0xE1DA,
	/* U+5DB8 */        0x8E56,        0x8E57,        0x8E58,        0x8E59,        0x8E5A,        0x8E5B,        0x8E5C,        0x8E5D,
	/* U+5DC0 */        0x8E5E,        0x8E5F,        0x8E60,        0x8E61,        0x8E62,        0xE1DB,        0x8E63,        0x8E64,
	/* U+5DC8 */        0x8E65,        0x8E66,        0x8E67,        0x8E68,        0x8E69,        0xCEA1,        0x8E6A,        0x8E6B,
	/* U+5DD0 */        0x8E6C,        0x8E6D,        0x8E6E,        0x8E6F,        0x8E70,        0x8E71,        0x8E72,        0x8E73,
	/* U+5DD8 */        0x8E74,        0x8E75,        0x8E76,        0xE7DD,        0x8E77,        0xB4A8,        0xD6DD,        0x8E78,
	/* U+5DE0 */        0x8E79,        0xD1B2,        0xB3B2,        0x8E7A,        0x8E7B,        0xB9A4,        0xD7F3,        0xC7C9,
	/* U+5DE8 */        0xBEDE,        0xB9AE,        0x8E7C,        0xCED7,        0x8E7D,        0x8E7E,        0xB2EE,        0xDBCF,
	/* U+5DF0 */        0x8E80,        0xBCBA,        0xD2D1,        0xCBC8,        0xB0CD,        0x8E81,        0x8E82,        0xCFEF,
	/* U+5DF8 */        0x8E83,        0x8E84,        0x8E85,        0x8E86,        0x8E87,        0xD9E3,        0xBDED,        0x8E88,
	/* U+5E00 */        0x8E89,        0xB1D2,        0xCAD0,        0xB2BC,        0x8E8A,        0xCBA7,        0xB7AB,        0x8E8B,
	/* U+5E08 */        0xCAA6,        0x8E8C,        0x8E8D,        0x8E8E,        0xCFA3,        0x8E8F,        0x8E90,        0xE0F8,
	/* U+5E10 */        0xD5CA,        0xE0FB,        0x8E91,        0x8E92,        0xE0FA,        0xC5C1,        0xCCFB,        0x8E93,
	/* U+5E18 */        0xC1B1,        0xE0F9,        0xD6E3,        0xB2AF,        0xD6C4,        0xB5DB,        0x8E94,        0x8E95,
	/* U+5E20 */        0x8E96,        0x8E97,        0x8E98,        0x8E99,        0x8E9A,        0x8E9B,        0xB4F8,        0xD6A1,
	/* U+5E28 */        0x8E9C,        0x8E9D,        0x8E9E,        0x8E9F,        0x8EA0,        0xCFAF,        0xB0EF,        0x8EA1,
	/* U+5E30 */        0x8EA2,        0xE0FC,        0x8EA3,        0x8EA4,        0x8EA5,        0x8EA6,        0x8EA7,        0xE1A1,
	/* U+5E38 */        0xB3A3,        0x8EA8,        0x8EA9,        0xE0FD,        0xE0FE,        0xC3B1,        0x8EAA,        0x8EAB,
	/* U+5E40 */        0x8EAC,        0x8EAD,        0xC3DD,        0x8EAE,        0xE1A2,        0xB7F9,        0x8EAF,        0x8EB0,
	/* U+5E48 */        0x8EB1,        0x8EB2,        0x8EB3,        0x8EB4,        0xBBCF,        0x8EB5,        0x8EB6,        0x8EB7,
	/* U+5E50 */        0x8EB8,        0x8EB9,        0x8EBA,        0x8EBB,        0xE1A3,        0xC4BB,        0x8EBC,        0x8EBD,
	/* U+5E58 */        0x8EBE,        0x8EBF,        0x8EC0,        0xE1A4,        0x8EC1,        0x8EC2,        0xE1A5,        0x8EC3,
	/* U+5E60 */        0x8EC4,        0xE1A6,        0xB4B1,        0x8EC5,        0x8EC6,        0x8EC7,        0x8EC8,        0x8EC9,
	/* U+5E68 */        0x8ECA,        0x8ECB,        0x8ECC,        0x8ECD,        0x8ECE,        0x8ECF,        0x8ED0,        0x8ED1,
	/* U+5E70 */        0x8ED2,        0x8ED3,        0xB8C9,        0xC6BD,        0xC4EA,        0x8ED4,        0xB2A2,        0x8ED5,
	/* U+5E78 */        0xD0D2,        0x8ED6,        0xE7DB,        0xBBC3,        0xD3D7,        0xD3C4,        0x8ED7,        0xB9E3,
	/* U+5E80 */        0xE2CF,        0x8ED8,        0x8ED9,        0x8EDA,        0xD7AF,        0x8EDB,        0xC7EC,        0xB1D3,
	/* U+5E88 */        0x8EDC,        0x8EDD,        0xB4B2,        0xE2D1,        0x8EDE,        0x8EDF,        0x8EE0,        0xD0F2,
	/* U+5E90 */        0xC2AE,        0xE2D0,        0x8EE1,        0xBFE2,        0xD3A6,        0xB5D7,        0xE2D2,        0xB5EA,
	/* U+5E98 */        0x8EE2,        0xC3ED,        0xB8FD,        0x8EE3,        0xB8AE,        0x8EE4,        0xC5D3,        0xB7CF,
	/* U+5EA0 */        0xE2D4,        0x8EE5,        0x8EE6,        0x8EE7,        0x8EE8,        0xE2D3,        0xB6C8,        0xD7F9,
	/* U+5EA8 */        0x8EE9,        0x8EEA,        0x8EEB,        0x8EEC,        0x8EED,        0xCDA5,        0x8EEE,        0x8EEF,
	/* U+5EB0 */        0x8EF0,        0x8EF1,        0x8EF2,        0xE2D8,        0x8EF3,        0xE2D6,        0xCAFC,        0xBFB5,
	/* U+5EB8 */        0xD3B9,        0xE2D5,        0x8EF4,        0x8EF5,        0x8EF6,        0x8EF7,        0xE2D7,        0x8EF8,
	/* U+5EC0 */        0x8EF9,        0x8EFA,        0x8EFB,        0x8EFC,        0x8EFD,        0x8EFE,        0x8F40,        0x8F41,
	/* U+5EC8 */        0x8F42,        0xC1AE,        0xC0C8,        0x8F43,        0x8F44,        0x8F45,        0x8F46,        0x8F47,
	/* U+5ED0 */        0x8F48,        0xE2DB,        0xE2DA,        0xC0AA,        0x8F49,        0x8F4A,        0xC1CE,        0x8F4B,
	/* U+5ED8 */        0x8F4C,        0x8F4D,        0x8F4E,        0xE2DC,        0x8F4F,        0x8F50,        0x8F51,        0x8F52,
	/* U+5EE0 */        0x8F53,        0x8F54,        0x8F55,        0x8F56,        0x8F57,        0x8F58,        0x8F59,        0x8F5A,
	/* U+5EE8 */        0xE2DD,        0x8F5B,        0xE2DE,        0x8F5C,        0x8F5D,        0x8F5E,        0x8F5F,        0x8F60,
	/* U+5EF0 */        0x8F61,        0x8F62,        0x8F63,        0x8F64,        0xDBC8,        0x8F65,        0xD1D3,        0xCDA2,
	/* U+5EF8 */        0x8F66,        0x8F67,        0xBDA8,        0x8F68,        0x8F69,        0x8F6A,        0xDEC3,        0xD8A5,
	/* U+5F00 */        0xBFAA,        0xDBCD,        0xD2EC,        0xC6FA,        0xC5AA,        0x8F6B,        0x8F6C,        0x8F6D,
	/* U+5F08 */        0xDEC4,        0x8F6E,        0xB1D7,        0xDFAE,        0x8F6F,        0x8F70,        0x8F71,        0xCABD,
	/* U+5F10 */        0x8F72,        0xDFB1,        0x8F73,        0xB9AD,        0x8F74,        0xD2FD,        0x8F75,        0xB8A5,
	/* U+5F18 */        0xBAEB,        0x8F76,        0x8F77,        0xB3DA,        0x8F78,        0x8F79,        0x8F7A,        0xB5DC,
	/* U+5F20 */        0xD5C5,        0x8F7B,        0x8F7C,        0x8F7D,        0x8F7E,        0xC3D6,        0xCFD2,        0xBBA1,
	/* U+5F28 */        0x8F80,        0xE5F3,        0xE5F2,        0x8F81,        0x8F82,        0xE5F4,        0x8F83,        0xCDE4,
	/* U+5F30 */        0x8F84,        0xC8F5,        0x8F85,        0x8F86,        0x8F87,        0x8F88,        0x8F89,        0x8F8A,
	/* U+5F38 */        0x8F8B,        0xB5AF,        0xC7BF,        0x8F8C,        0xE5F6,        0x8F8D,        0x8F8E,        0x8F8F,
	/* U+5F40 */        0xECB0,        0x8F90,        0x8F91,        0x8F92,        0x8F93,        0x8F94,        0x8F95,        0x8F96,
	/* U+5F48 */        0x8F97,        0x8F98,        0x8F99,        0x8F9A,        0x8F9B,        0x8F9C,        0x8F9D,        0x8F9E,
	/* U+5F50 */        0xE5E6,        0x8F9F,        0xB9E9,        0xB5B1,        0x8FA0,        0xC2BC,        0xE5E8,        0xE5E7,
	/* U+5F58 */        0xE5E9,        0x8FA1,        0x8FA2,        0x8FA3,        0x8FA4,        0xD2CD,        0x8FA5,        0x8FA6,
	/* U+5F60 */        0x8FA7,        0xE1EA,        0xD0CE,        0x8FA8,        0xCDAE,        0x8FA9,        0xD1E5,        0x8FAA,
	/* U+5F68 */        0x8FAB,        0xB2CA,        0xB1EB,        0x8FAC,        0xB1F2,        0xC5ED,        0x8FAD,        0x8FAE,
	/* U+5F70 */        0xD5C3,        0xD3B0,        0x8FAF,        0xE1DC,        0x8FB0,        0x8FB1,        0x8FB2,        0xE1DD,
	/* U+5F78 */        0x8FB3,        0xD2DB,        0x8FB4,        0xB3B9,        0xB1CB,        0x8FB5,        0x8FB6,        0x8FB7,
	/* U+5F80 */        0xCDF9,        0xD5F7,        0xE1DE,        0x8FB8,        0xBEB6,        0xB4FD,        0x8FB9,        0xE1DF,
	/* U+5F88 */        0xBADC,        0xE1E0,        0xBBB2,        0xC2C9,        0xE1E1,        0x8FBA,        0x8FBB,        0x8FBC,
	/* U+5F90 */        0xD0EC,        0x8FBD,        0xCDBD,        0x8FBE,        0x8FBF,        0xE1E2,        0x8FC0,        0xB5C3,
	/* U+5F98 */        0xC5C7,        0xE1E3,        0x8FC1,        0x8FC2,        0xE1E4,        0x8FC3,        0x8FC4,        0x8FC5,
	/* U+5FA0 */        0x8FC6,        0xD3F9,        0x8FC7,        0x8FC8,        0x8FC9,        0x8FCA,        0x8FCB,        0x8FCC,
	/* U+5FA8 */        0xE1E5,        0x8FCD,        0xD1AD,        0x8FCE,        0x8FCF,        0xE1E6,        0xCEA2,        0x8FD0,
	/* U+5FB0 */        0x8FD1,        0x8FD2,        0x8FD3,        0x8FD4,        0x8FD5,        0xE1E7,        0x8FD6,        0xB5C2,
	/* U+5FB8 */        0x8FD7,        0x8FD8,        0x8FD9,        0x8FDA,        0xE1E8,        0xBBD5,        0x8FDB,        0x8FDC,
	/* U+5FC0 */        0x8FDD,        0x8FDE,        0x8FDF,        0xD0C4,        0xE2E0,        0xB1D8,        0xD2E4,        0x8FE0,
	/* U+5FC8 */        0x8FE1,        0xE2E1,        0x8FE2,        0x8FE3,        0xBCC9,        0xC8CC,        0x8FE4,        0xE2E3,
	/* U+5FD0 */        0xECFE,        0xECFD,        0xDFAF,        0x8FE5,        0x8FE6,        0x8FE7,        0xE2E2,        0xD6BE,
	/* U+5FD8 */        0xCDFC,        0xC3A6,        0x8FE8,        0x8FE9,        0x8FEA,        0xE3C3,        0x8FEB,        0x8FEC,
	/* U+5FE0 */        0xD6D2,        0xE2E7,        0x8FED,        0x8FEE,        0xE2E8,        0x8FEF,        0x8FF0,        0xD3C7,
	/* U+5FE8 */        0x8FF1,        0x8FF2,        0xE2EC,        0xBFEC,        0x8FF3,        0xE2ED,        0xE2E5,        0x8FF4,
	/* U+5FF0 */        0x8FF5,        0xB3C0,        0x8FF6,        0x8FF7,        0x8FF8,        0xC4EE,        0x8FF9,        0x8FFA,
	/* U+5FF8 */        0xE2EE,        0x8FFB,        0x8FFC,        0xD0C3,        0x8FFD,        0xBAF6,        0xE2E9,        0xB7DE,
	/* U+6000 */        0xBBB3,        0xCCAC,        0xCBCB,        0xE2E4,        0xE2E6,        0xE2EA,        0xE2EB,        0x8FFE,
	/* U+6008 */        0x9040,        0x9041,        0xE2F7,        0x9042,        0x9043,        0xE2F4,        0xD4F5,        0xE2F3,
	/* U+6010 */        0x9044,        0x9045,        0xC5AD,        0x9046,        0xD5FA,        0xC5C2,        0xB2C0,        0x9047,
	/* U+6018 */        0x9048,        0xE2EF,        0x9049,        0xE2F2,        0xC1AF,        0xCBBC,        0x904A,        0x904B,
	/* U+6020 */        0xB5A1,        0xE2F9,        0x904C,        0x904D,        0x904E,        0xBCB1,        0xE2F1,        0xD0D4,
	/* U+6028 */        0xD4B9,        0xE2F5,        0xB9D6,        0xE2F6,        0x904F,        0x9050,        0x9051,        0xC7D3,
	/* U+6030 */        0x9052,        0x9053,        0x9054,        0x9055,        0x9056,        0xE2F0,        0x9057,        0x9058,
	/* U+6038 */        0x9059,        0x905A,        0x905B,        0xD7DC,        0xEDA1,        0x905C,        0x905D,        0xE2F8,
	/* U+6040 */        0x905E,        0xEDA5,        0xE2FE,        0xCAD1,        0x905F,        0x9060,        0x9061,        0x9062,
	/* U+6048 */        0x9063,        0x9064,        0x9065,        0xC1B5,        0x9066,        0xBBD0,        0x9067,        0x9068,
	/* U+6050 */        0xBFD6,        0x9069,        0xBAE3,        0x906A,        0x906B,        0xCBA1,        0x906C,        0x906D,
	/* U+6058 */        0x906E,        0xEDA6,        0xEDA3,        0x906F,        0x9070,        0xEDA2,        0x9071,        0x9072,
	/* U+6060 */        0x9073,        0x9074,        0xBBD6,        0xEDA7,        0xD0F4,        0x9075,        0x9076,        0xEDA4,
	/* U+6068 */        0xBADE,        0xB6F7,        0xE3A1,        0xB6B2,        0xCCF1,        0xB9A7,        0x9077,        0xCFA2,
	/* U+6070 */        0xC7A1,        0x9078,        0x9079,        0xBFD2,        0x907A,        0x907B,        0xB6F1,        0x907C,
	/* U+6078 */        0xE2FA,        0xE2FB,        0xE2FD,        0xE2FC,        0xC4D5,        0xE3A2,        0x907D,        0xD3C1,
	/* U+6080 */        0x907E,        0x9080,        0x9081,        0xE3A7,        0xC7C4,        0x9082,        0x9083,        0x9084,
	/* U+6088 */        0x9085,        0xCFA4,        0x9086,        0x9087,        0xE3A9,        0xBAB7,        0x9088,        0x9089,
	/* U+6090 */        0x908A,        0x908B,        0xE3A8,        0x908C,        0xBBDA,        0x908D,        0xE3A3,        0x908E,
	/* U+6098 */        0x908F,        0x9090,        0xE3A4,        0xE3AA,        0x9091,        0xE3A6,        0x9092,        0xCEF2,
	/* U+60A0 */        0xD3C6,        0x9093,        0x9094,        0xBBBC,        0x9095,        0x9096,        0xD4C3,        0x9097,
	/* U+60A8 */        0xC4FA,        0x9098,        0x9099,        0xEDA8,        0xD0FC,        0xE3A5,        0x909A,        0xC3F5,
	/* U+60B0 */        0x909B,        0xE3AD,        0xB1AF,        0x909C,        0xE3B2,        0x909D,        0x909E,        0x909F,
	/* U+60B8 */        0xBCC2,        0x90A0,        0x90A1,        0xE3AC,        0xB5BF,        0x90A2,        0x90A3,        0x90A4,
	/* U+60C0 */        0x90A5,        0x90A6,        0x90A7,        0x90A8,        0x90A9,        0xC7E9,        0xE3B0,        0x90AA,
	/* U+60C8 */        0x90AB,        0x90AC,        0xBEAA,        0xCDEF,        0x90AD,        0x90AE,        0x90AF,        0x90B0,
	/* U+60D0 */        0x90B1,        0xBBF3,        0x90B2,        0x90B3,        0x90B4,        0xCCE8,        0x90B5,        0x90B6,
	/* U+60D8 */        0xE3AF,        0x90B7,        0xE3B1,        0x90B8,        0xCFA7,        0xE3AE,        0x90B9,        0xCEA9,
	/* U+60E0 */        0xBBDD,        0x90BA,        0x90BB,        0x90BC,        0x90BD,        0x90BE,        0xB5EB,        0xBEE5,
	/* U+60E8 */        0xB2D2,        0xB3CD,        0x90BF,        0xB1B9,        0xE3AB,        0xB2D1,        0xB5AC,        0xB9DF,
	/* U+60F0 */        0xB6E8,        0x90C0,        0x90C1,        0xCFEB,        0xE3B7,        0x90C2,        0xBBCC,        0x90C3,
	/* U+60F8 */        0x90C4,        0xC8C7,        0xD0CA,        0x90C5,        0x90C6,        0x90C7,        0x90C8,        0x90C9,
	/* U+6100 */        0xE3B8,        0xB3EE,        0x90CA,        0x90CB,        0x90CC,        0x90CD,        0xEDA9,        0x90CE,
	/* U+6108 */        0xD3FA,        0xD3E4,        0x90CF,        0x90D0,        0x90D1,        0xEDAA,        0xE3B9,        0xD2E2,
	/* U+6110 */        0x90D2,        0x90D3,        0x90D4,        0x90D5,        0x90D6,        0xE3B5,        0x90D7,        0x90D8,
	/* U+6118 */        0x90D9,        0x90DA,        0xD3DE,        0x90DB,        0x90DC,        0x90DD,        0x90DE,        0xB8D0,
	/* U+6120 */        0xE3B3,        0x90DF,        0x90E0,        0xE3B6,        0xB7DF,        0x90E1,        0xE3B4,        0xC0A2,
	/* U+6128 */        0x90E2,        0x90E3,        0x90E4,        0xE3BA,        0x90E5,        0x90E6,        0x90E7,        0x90E8,
	/* U+6130 */        0x90E9,        0x90EA,        0x90EB,        0x90EC,        0x90ED,        0x90EE,        0x90EF,        0x90F0,
	/* U+6138 */        0x90F1,        0x90F2,        0x90F3,        0x90F4,        0x90F5,        0x90F6,        0x90F7,        0xD4B8,
	/* U+6140 */        0x90F8,        0x90F9,        0x90FA,        0x90FB,        0x90FC,        0x90FD,        0x90FE,        0x9140,
	/* U+6148 */        0xB4C8,        0x9141,        0xE3BB,        0x9142,        0xBBC5,        0x9143,        0xC9F7,        0x9144,
	/* U+6150 */        0x9145,        0xC9E5,        0x9146,        0x9147,        0x9148,        0xC4BD,        0x9149,        0x914A,
	/* U+6158 */        0x914B,        0x914C,        0x914D,        0x914E,        0x914F,        0xEDAB,        0x9150,        0x9151,
	/* U+6160 */        0x9152,        0x9153,        0xC2FD,        0x9154,        0x9155,        0x9156,        0x9157,        0xBBDB,
	/* U+6168 */        0xBFAE,        0x9158,        0x9159,        0x915A,        0x915B,        0x915C,        0x915D,        0x915E,
	/* U+6170 */        0xCEBF,        0x915F,        0x9160,        0x9161,        0x9162,        0xE3BC,        0x9163,        0xBFB6,
	/* U+6178 */        0x9164,        0x9165,        0x9166,        0x9167,        0x9168,        0x9169,        0x916A,        0x916B,
	/* U+6180 */        0x916C,        0x916D,        0x916E,        0x916F,        0x9170,        0x9171,        0x9172,        0x9173,
	/* U+6188 */        0x9174,        0x9175,        0x9176,        0xB1EF,        0x9177,        0x9178,        0xD4F7,        0x9179,
	/* U+6190 */        0x917A,        0x917B,        0x917C,        0x917D,        0xE3BE,        0x917E,        0x9180,        0x9181,
	/* U+6198 */        0x9182,        0x9183,        0x9184,        0x9185,        0x9186,        0xEDAD,        0x9187,        0x9188,
	/* U+61A0 */        0x9189,        0x918A,        0x918B,        0x918C,        0x918D,        0x918E,        0x918F,        0xE3BF,
	/* U+61A8 */        0xBAA9,        0xEDAC,        0x9190,        0x9191,        0xE3BD,        0x9192,        0x9193,        0x9194,
	/* U+61B0 */        0x9195,        0x9196,        0x9197,        0x9198,        0x9199,        0x919A,        0x919B,        0xE3C0,
	/* U+61B8 */        0x919C,        0x919D,        0x919E,        0x919F,        0x91A0,        0x91A1,        0xBAB6,        0x91A2,
	/* U+61C0 */        0x91A3,        0x91A4,        0xB6AE,        0x91A5,        0x91A6,        0x91A7,        0x91A8,        0x91A9,
	/* U+61C8 */        0xD0B8,        0x91AA,        0xB0C3,        0xEDAE,        0x91AB,        0x91AC,        0x91AD,        0x91AE,
	/* U+61D0 */        0x91AF,        0xEDAF,        0xC0C1,        0x91B0,        0xE3C1,        0x91B1,        0x91B2,        0x91B3,
	/* U+61D8 */        0x91B4,        0x91B5,        0x91B6,        0x91B7,        0x91B8,        0x91B9,        0x91BA,        0x91BB,
	/* U+61E0 */        0x91BC,        0x91BD,        0x91BE,        0x91BF,        0x91C0,        0x91C1,        0xC5B3,        0x91C2,
	/* U+61E8 */        0x91C3,        0x91C4,        0x91C5,        0x91C6,        0x91C7,        0x91C8,        0x91C9,        0x91CA,
	/* U+61F0 */        0x91CB,        0x91CC,        0x91CD,        0x91CE,        0x91CF,        0xE3C2,        0x91D0,        0x91D1,
	/* U+61F8 */        0x91D2,        0x91D3,        0x91D4,        0x91D5,        0x91D6,        0x91D7,        0x91D8,        0xDCB2,
	/* U+6200 */        0x91D9,        0x91DA,        0x91DB,        0x91DC,        0x91DD,        0x91DE,        0xEDB0,        0x91DF,
	/* U+6208 */        0xB8EA,        0x91E0,        0xCEEC,        0xEAA7,        0xD0E7,        0xCAF9,        0xC8D6,        0xCFB7,
	/* U+6210 */        0xB3C9,        0xCED2,        0xBDE4,        0x91E1,        0x91E2,        0xE3DE,        0xBBF2,        0xEAA8,
	/* U+6218 */        0xD5BD,        0x91E3,        0xC6DD,        0xEAA9,        0x91E4,        0x91E5,        0x91E6,        0xEAAA,
	/* U+6220 */        0x91E7,        0xEAAC,        0xEAAB,        0x91E8,        0xEAAE,        0xEAAD,        0x91E9,        0x91EA,
	/* U+6228 */        0x91EB,        0x91EC,        0xBDD8,        0x91ED,        0xEAAF,        0x91EE,        0xC2BE,        0x91EF,
	/* U+6230 */        0x91F0,        0x91F1,        0x91F2,        0xB4C1,        0xB4F7,        0x91F3,        0x91F4,        0xBBA7,
	/* U+6238 */        0x91F5,        0x91F6,        0x91F7,        0x91F8,        0x91F9,        0xECE6,        0xECE5,        0xB7BF,
	/* U+6240 */        0xCBF9,        0xB1E2,        0x91FA,        0xECE7,        0x91FB,        0x91FC,        0x91FD,        0xC9C8,
	/* U+6248 */        0xECE8,        0xECE9,        0x91FE,        0xCAD6,        0xDED0,        0xB2C5,        0xD4FA,        0x9240,
	/* U+6250 */        0x9241,        0xC6CB,        0xB0C7,        0xB4F2,        0xC8D3,        0x9242,        0x9243,        0x9244,
	/* U+6258 */        0xCDD0,        0x9245,        0x9246,        0xBFB8,        0x9247,        0x9248,        0x9249,        0x924A,
	/* U+6260 */        0x924B,        0x924C,        0x924D,        0xBFDB,        0x924E,        0x924F,        0xC7A4,        0xD6B4,
	/* U+6268 */        0x9250,        0xC0A9,        0xDED1,        0xC9A8,        0xD1EF,        0xC5A4,        0xB0E7,        0xB3B6,
	/* U+6270 */        0xC8C5,        0x9251,        0x9252,        0xB0E2,        0x9253,        0x9254,        0xB7F6,        0x9255,
	/* U+6278 */        0x9256,        0xC5FA,        0x9257,        0x9258,        0xB6F3,        0x9259,        0xD5D2,        0xB3D0,
	/* U+6280 */        0xBCBC,        0x925A,        0x925B,        0x925C,        0xB3AD,        0x925D,        0x925E,        0x925F,
	/* U+6288 */        0x9260,        0xBEF1,        0xB0D1,        0x9261,        0x9262,        0x9263,        0x9264,        0x9265,
	/* U+6290 */        0x9266,        0xD2D6,        0xCAE3,        0xD7A5,        0x9267,        0xCDB6,        0xB6B6,        0xBFB9,
	/* U+6298 */        0xD5DB,        0x9268,        0xB8A7,        0xC5D7,        0x9269,        0x926A,        0x926B,        0xDED2,
	/* U+62A0 */        0xBFD9,        0xC2D5,        0xC7C0,        0x926C,        0xBBA4,        0xB1A8,        0x926D,        0x926E,
	/* U+62A8 */        0xC5EA,        0x926F,        0x9270,        0xC5FB,        0xCCA7,        0x9271,        0x9272,        0x9273,
	/* U+62B0 */        0x9274,        0xB1A7,        0x9275,        0x9276,        0x9277,        0xB5D6,        0x9278,        0x9279,
	/* U+62B8 */        0x927A,        0xC4A8,        0x927B,        0xDED3,        0xD1BA,        0xB3E9,        0x927C,        0xC3F2,
	/* U+62C0 */        0x927D,        0x927E,        0xB7F7,        0x9280,        0xD6F4,        0xB5A3,        0xB2F0,        0xC4B4,
	/* U+62C8 */        0xC4E9,        0xC0AD,        0xDED4,        0x9281,        0xB0E8,        0xC5C4,        0xC1E0,        0x9282,
	/* U+62D0 */        0xB9D5,        0x9283,        0xBEDC,        0xCDD8,        0xB0CE,        0x9284,        0xCDCF,        0xDED6,
	/* U+62D8 */        0xBED0,        0xD7BE,        0xDED5,        0xD5D0,        0xB0DD,        0x9285,        0x9286,        0xC4E2,
	/* U+62E0 */        0x9287,        0x9288,        0xC2A3,        0xBCF0,        0x9289,        0xD3B5,        0xC0B9,        0xC5A1,
	/* U+62E8 */        0xB2A6,        0xD4F1,        0x928A,        0x928B,        0xC0A8,        0xCAC3,        0xDED7,        0xD5FC,
	/* U+62F0 */        0x928C,        0xB9B0,        0x928D,        0xC8AD,        0xCBA9,        0x928E,        0xDED9,        0xBFBD,
	/* U+62F8 */        0x928F,        0x9290,        0x9291,        0x9292,        0xC6B4,        0xD7A7,        0xCAB0,        0xC4C3,
	/* U+6300 */        0x9293,        0xB3D6,        0xB9D2,        0x9294,        0x9295,        0x9296,        0x9297,        0xD6B8,
	/* U+6308 */        0xEAFC,        0xB0B4,        0x9298,        0x9299,        0x929A,        0x929B,        0xBFE6,        0x929C,
	/* U+6310 */        0x929D,        0xCCF4,        0x929E,        0x929F,        0x92A0,        0x92A1,        0xCDDA,        0x92A2,
	/* U+6318 */        0x92A3,        0x92A4,        0xD6BF,        0xC2CE,        0x92A5,        0xCECE,        0xCCA2,        0xD0AE,
	/* U+6320 */        0xC4D3,        0xB5B2,        0xDED8,        0xD5F5,        0xBCB7,        0xBBD3,        0x92A6,        0x92A7,
	/* U+6328 */        0xB0A4,        0x92A8,        0xC5B2,        0xB4EC,        0x92A9,        0x92AA,        0x92AB,        0xD5F1,
	/* U+6330 */        0x92AC,        0x92AD,        0xEAFD,        0x92AE,        0x92AF,        0x92B0,        0x92B1,        0x92B2,
	/* U+6338 */        0x92B3,        0xDEDA,        0xCDA6,        0x92B4,        0x92B5,        0xCDEC,        0x92B6,        0x92B7,
	/* U+6340 */        0x92B8,        0x92B9,        0xCEE6,        0xDEDC,        0x92BA,        0xCDB1,        0xC0A6,        0x92BB,
	/* U+6348 */        0x92BC,        0xD7BD,        0x92BD,        0xDEDB,        0xB0C6,        0xBAB4,        0xC9D3,        0xC4F3,
	/* U+6350 */        0xBEE8,        0x92BE,        0x92BF,        0x92C0,        0x92C1,        0xB2B6,        0x92C2,        0x92C3,
	/* U+6358 */        0x92C4,        0x92C5,        0x92C6,        0x92C7,        0x92C8,        0x92C9,        0xC0CC,        0xCBF0,
	/* U+6360 */        0x92CA,        0xBCF1,        0xBBBB,        0xB5B7,        0x92CB,        0x92CC,        0x92CD,        0xC5F5,
	/* U+6368 */        0x92CE,        0xDEE6,        0x92CF,        0x92D0,        0x92D1,        0xDEE3,        0xBEDD,        0x92D2,
	/* U+6370 */        0x92D3,        0xDEDF,        0x92D4,        0x92D5,        0x92D6,        0x92D7,        0xB4B7,        0xBDDD,
	/* U+6378 */        0x92D8,        0x92D9,        0xDEE0,        0xC4ED,        0x92DA,        0x92DB,        0x92DC,        0x92DD,
	/* U+6380 */        0xCFC6,        0x92DE,        0xB5E0,        0x92DF,        0x92E0,        0x92E1,        0x92E2,        0xB6DE,
	/* U+6388 */        0xCADA,        0xB5F4,        0xDEE5,        0x92E3,        0xD5C6,        0x92E4,        0xDEE1,        0xCCCD,
	/* U+6390 */        0xC6FE,        0x92E5,        0xC5C5,        0x92E6,        0x92E7,        0x92E8,        0xD2B4,        0x92E9,
	/* U+6398 */        0xBEF2,        0x92EA,        0x92EB,        0x92EC,        0x92ED,        0x92EE,        0x92EF,        0x92F0,
	/* U+63A0 */        0xC2D3,        0x92F1,        0xCCBD,        0xB3B8,        0x92F2,        0xBDD3,        0x92F3,        0xBFD8,
	/* U+63A8 */        0xCDC6,        0xD1DA,        0xB4EB,        0x92F4,        0xDEE4,        0xDEDD,        0xDEE7,        0x92F5,
	/* U+63B0 */        0xEAFE,        0x92F6,        0x92F7,        0xC2B0,        0xDEE2,        0x92F8,        0x92F9,        0xD6C0,
	/* U+63B8 */        0xB5A7,        0x92FA,        0xB2F4,        0x92FB,        0xDEE8,        0x92FC,        0xDEF2,        0x92FD,
	/* U+63C0 */        0x92FE,        0x9340,        0x9341,        0x9342,        0xDEED,        0x9343,        0xDEF1,        0x9344,
	/* U+63C8 */        0x9345,        0xC8E0,        0x9346,        0x9347,        0x9348,        0xD7E1,        0xDEEF,        0xC3E8,
	/* U+63D0 */        0xCCE1,        0x9349,        0xB2E5,        0x934A,        0x934B,        0x934C,        0xD2BE,        0x934D,
	/* U+63D8 */        0x934E,        0x934F,        0x9350,        0x9351,        0x9352,        0x9353,        0xDEEE,        0x9354,
	/* U+63E0 */        0xDEEB,        0xCED5,        0x9355,        0xB4A7,        0x9356,        0x9357,        0x9358,        0x9359,
	/* U+63E8 */        0x935A,        0xBFAB,        0xBEBE,        0x935B,        0x935C,        0xBDD2,        0x935D,        0x935E,
	/* U+63F0 */        0x935F,        0x9360,        0xDEE9,        0x9361,        0xD4AE,        0x9362,        0xDEDE,        0x9363,
	/* U+63F8 */        0xDEEA,        0x9364,        0x9365,        0x9366,        0x9367,        0xC0BF,        0x9368,        0xDEEC,
	/* U+6400 */        0xB2F3,        0xB8E9,        0xC2A7,        0x9369,        0x936A,        0xBDC1,        0x936B,        0x936C,
	/* U+6408 */        0x936D,        0x936E,        0x936F,        0xDEF5,        0xDEF8,        0x9370,        0x9371,        0xB2AB,
	/* U+6410 */        0xB4A4,        0x9372,        0x9373,        0xB4EA,        0xC9A6,        0x9374,        0x9375,        0x9376,
	/* U+6418 */        0x9377,        0x9378,        0x9379,        0xDEF6,        0xCBD1,        0x937A,        0xB8E3,        0x937B,
	/* U+6420 */        0xDEF7,        0xDEFA,        0x937C,        0x937D,        0x937E,        0x9380,        0xDEF9,        0x9381,
	/* U+6428 */        0x9382,        0x9383,        0xCCC2,        0x9384,        0xB0E1,        0xB4EE,        0x9385,        0x9386,
	/* U+6430 */        0x9387,        0x9388,        0x9389,        0x938A,        0xE5BA,        0x938B,        0x938C,        0x938D,
	/* U+6438 */        0x938E,        0x938F,        0xD0AF,        0x9390,        0x9391,        0xB2EB,        0x9392,        0xEBA1,
	/* U+6440 */        0x9393,        0xDEF4,        0x9394,        0x9395,        0xC9E3,        0xDEF3,        0xB0DA,        0xD2A1,
	/* U+6448 */        0xB1F7,        0x9396,        0xCCAF,        0x9397,        0x9398,        0x9399,        0x939A,        0x939B,
	/* U+6450 */        0x939C,        0x939D,        0xDEF0,        0x939E,        0xCBA4,        0x939F,        0x93A0,        0x93A1,
	/* U+6458 */        0xD5AA,        0x93A2,        0x93A3,        0x93A4,        0x93A5,        0x93A6,        0xDEFB,        0x93A7,
	/* U+6460 */        0x93A8,        0x93A9,        0x93AA,        0x93AB,        0x93AC,        0x93AD,        0x93AE,        0xB4DD,
	/* U+6468 */        0x93AF,        0xC4A6,        0x93B0,        0x93B1,        0x93B2,        0xDEFD,        0x93B3,        0x93B4,
	/* U+6470 */        0x93B5,        0x93B6,        0x93B7,        0x93B8,        0x93B9,        0x93BA,        0x93BB,        0x93BC,
	/* U+6478 */        0xC3FE,        0xC4A1,        0xDFA1,        0x93BD,        0x93BE,        0x93BF,        0x93C0,        0x93C1,
	/* U+6480 */        0x93C2,        0x93C3,        0xC1CC,        0x93C4,        0xDEFC,        0xBEEF,        0x93C5,        0xC6B2,
	/* U+6488 */        0x93C6,        0x93C7,        0x93C8,        0x93C9,        0x93CA,        0x93CB,        0x93CC,        0x93CD,
	/* U+6490 */        0x93CE,        0xB3C5,        0xC8F6,        0x93CF,        0x93D0,        0xCBBA,        0xDEFE,        0x93D1,
	/* U+6498 */        0x93D2,        0xDFA4,        0x93D3,        0x93D4,        0x93D5,        0x93D6,        0xD7B2,        0x93D7,
	/* U+64A0 */        0x93D8,        0x93D9,        0x93DA,        0x93DB,        0xB3B7,        0x93DC,        0x93DD,        0x93DE,
	/* U+64A8 */        0x93DF,        0xC1C3,        0x93E0,        0x93E1,        0xC7CB,        0xB2A5,        0xB4E9,        0x93E2,
	/* U+64B0 */        0xD7AB,        0x93E3,        0x93E4,        0x93E5,        0x93E6,        0xC4EC,        0x93E7,        0xDFA2,
	/* U+64B8 */        0xDFA3,        0x93E8,        0xDFA5,        0x93E9,        0xBAB3,        0x93EA,        0x93EB,        0x93EC,
	/* U+64C0 */        0xDFA6,        0x93ED,        0xC0DE,        0x93EE,        0x93EF,        0xC9C3,        0x93F0,        0x93F1,
	/* U+64C8 */        0x93F2,        0x93F3,        0x93F4,        0x93F5,        0x93F6,        0xB2D9,        0xC7E6,        0x93F7,
	/* U+64D0 */        0xDFA7,        0x93F8,        0xC7DC,        0x93F9,        0x93FA,        0x93FB,        0x93FC,        0xDFA8,
	/* U+64D8 */        0xEBA2,        0x93FD,        0x93FE,        0x9440,        0x9441,        0x9442,        0xCBD3,        0x9443,
	/* U+64E0 */        0x9444,        0x9445,        0xDFAA,        0x9446,        0xDFA9,        0x9447,        0xB2C1,        0x9448,
	/* U+64E8 */        0x9449,        0x944A,        0x944B,        0x944C,        0x944D,        0x944E,        0x944F,        0x9450,
	/* U+64F0 */        0x9451,        0x9452,        0x9453,        0x9454,        0x9455,        0x9456,        0x9457,        0x9458,
	/* U+64F8 */        0x9459,        0x945A,        0x945B,        0x945C,        0x945D,        0x945E,        0x945F,        0x9460,
	/* U+6500 */        0xC5CA,        0x9461,        0x9462,        0x9463,        0x9464,        0x9465,        0x9466,        0x9467,
	/* U+6508 */        0x9468,        0xDFAB,        0x9469,        0x946A,        0x946B,        0x946C,        0x946D,        0x946E,
	/* U+6510 */        0x946F,        0x9470,        0xD4DC,        0x9471,        0x9472,        0x9473,        0x9474,        0x9475,
	/* U+6518 */        0xC8C1,        0x9476,        0x9477,        0x9478,        0x9479,        0x947A,        0x947B,        0x947C,
	/* U+6520 */        0x947D,        0x947E,        0x9480,        0x9481,        0x9482,        0xDFAC,        0x9483,        0x9484,
	/* U+6528 */        0x9485,        0x9486,        0x9487,        0xBEF0,        0x9488,        0x9489,        0xDFAD,        0xD6A7,
	/* U+6530 */        0x948A,        0x948B,        0x948C,        0x948D,        0xEAB7,        0xEBB6,        0xCAD5,        0x948E,
	/* U+6538 */        0xD8FC,        0xB8C4,        0x948F,        0xB9A5,        0x9490,        0x9491,        0xB7C5,        0xD5FE,
	/* U+6540 */        0x9492,        0x9493,        0x9494,        0x9495,        0x9496,        0xB9CA,        0x9497,        0x9498,
	/* U+6548 */        0xD0A7,        0xF4CD,        0x9499,        0x949A,        0xB5D0,        0x949B,        0x949C,        0xC3F4,
	/* U+6550 */        0x949D,        0xBEC8,        0x949E,        0x949F,        0x94A0,        0xEBB7,        0xB0BD,        0x94A1,
	/* U+6558 */        0x94A2,        0xBDCC,        0x94A3,        0xC1B2,        0x94A4,        0xB1D6,        0xB3A8,        0x94A5,
	/* U+6560 */        0x94A6,        0x94A7,        0xB8D2,        0xC9A2,        0x94A8,        0x94A9,        0xB6D8,        0x94AA,
	/* U+6568 */        0x94AB,        0x94AC,        0x94AD,        0xEBB8,        0xBEB4,        0x94AE,        0x94AF,        0x94B0,
	/* U+6570 */        0xCAFD,        0x94B1,        0xC7C3,        0x94B2,        0xD5FB,        0x94B3,        0x94B4,        0xB7F3,
	/* U+6578 */        0x94B5,        0x94B6,        0x94B7,        0x94B8,        0x94B9,        0x94BA,        0x94BB,        0x94BC,
	/* U+6580 */        0x94BD,        0x94BE,        0x94BF,        0x94C0,        0x94C1,        0x94C2,        0x94C3,        0xCEC4,
	/* U+6588 */        0x94C4,        0x94C5,        0x94C6,        0xD5AB,        0xB1F3,        0x94C7,        0x94C8,        0x94C9,
	/* U+6590 */        0xECB3,        0xB0DF,        0x94CA,        0xECB5,        0x94CB,        0x94CC,        0x94CD,        0xB6B7,
	/* U+6598 */        0x94CE,        0xC1CF,        0x94CF,        0xF5FA,        0xD0B1,        0x94D0,        0x94D1,        0xD5E5,
	/* U+65A0 */        0x94D2,        0xCED3,        0x94D3,        0x94D4,        0xBDEF,        0xB3E2,        0x94D5,        0xB8AB,
	/* U+65A8 */        0x94D6,        0xD5B6,        0x94D7,        0xEDBD,        0x94D8,        0xB6CF,        0x94D9,        0xCBB9,
	/* U+65B0 */        0xD0C2,        0x94DA,        0x94DB,        0x94DC,        0x94DD,        0x94DE,        0x94DF,        0x94E0,
	/* U+65B8 */        0x94E1,        0xB7BD,        0x94E2,        0x94E3,        0xECB6,        0xCAA9,        0x94E4,        0x94E5,
	/* U+65C0 */        0x94E6,        0xC5D4,        0x94E7,        0xECB9,        0xECB8,        0xC2C3,        0xECB7,        0x94E8,
	/* U+65C8 */        0x94E9,        0x94EA,        0x94EB,        0xD0FD,        0xECBA,        0x94EC,        0xECBB,        0xD7E5,
	/* U+65D0 */        0x94ED,        0x94EE,        0xECBC,        0x94EF,        0x94F0,        0x94F1,        0xECBD,        0xC6EC,
	/* U+65D8 */        0x94F2,        0x94F3,        0x94F4,        0x94F5,        0x94F6,        0x94F7,        0x94F8,        0x94F9,
	/* U+65E0 */        0xCEDE,        0x94FA,        0xBCC8,        0x94FB,        0x94FC,        0xC8D5,        0xB5A9,        0xBEC9,
	/* U+65E8 */        0xD6BC,        0xD4E7,        0x94FD,        0x94FE,        0xD1AE,        0xD0F1,        0xEAB8,        0xEAB9,
	/* U+65F0 */        0xEABA,        0xBAB5,        0x9540,        0x9541,        0x9542,        0x9543,        0xCAB1,        0xBFF5,
	/* U+65F8 */        0x9544,        0x9545,        0xCDFA,        0x9546,        0x9547,        0x9548,        0x9549,        0x954A,
	/* U+6600 */        0xEAC0,        0x954B,        0xB0BA,        0xEABE,        0x954C,        0x954D,        0xC0A5,        0x954E,
	/* U+6608 */        0x954F,        0x9550,        0xEABB,        0x9551,        0xB2FD,        0x9552,        0xC3F7,        0xBBE8,
	/* U+6610 */        0x9553,        0x9554,        0x9555,        0xD2D7,        0xCEF4,        0xEABF,        0x9556,        0x9557,
	/* U+6618 */        0x9558,        0xEABC,        0x9559,        0x955A,        0x955B,        0xEAC3,        0x955C,        0xD0C7,
	/* U+6620 */        0xD3B3,        0x955D,        0x955E,        0x955F,        0x9560,        0xB4BA,        0x9561,        0xC3C1,
	/* U+6628 */        0xD7F2,        0x9562,        0x9563,        0x9564,        0x9565,        0xD5D1,        0x9566,        0xCAC7,
	/* U+6630 */        0x9567,        0xEAC5,        0x9568,        0x9569,        0xEAC4,        0xEAC7,        0xEAC6,        0x956A,
	/* U+6638 */        0x956B,        0x956C,        0x956D,        0x956E,        0xD6E7,        0x956F,        0xCFD4,        0x9570,
	/* U+6640 */        0x9571,        0xEACB,        0x9572,        0xBBCE,        0x9573,        0x9574,        0x9575,        0x9576,
	/* U+6648 */        0x9577,        0x9578,        0x9579,        0xBDFA,        0xC9CE,        0x957A,        0x957B,        0xEACC,
	/* U+6650 */        0x957C,        0x957D,        0xC9B9,        0xCFFE,        0xEACA,        0xD4CE,        0xEACD,        0xEACF,
	/* U+6658 */        0x957E,        0x9580,        0xCDED,        0x9581,        0x9582,        0x9583,        0x9584,        0xEAC9,
	/* U+6660 */        0x9585,        0xEACE,        0x9586,        0x9587,        0xCEEE,        0x9588,        0xBBDE,        0x9589,
	/* U+6668 */        0xB3BF,        0x958A,        0x958B,        0x958C,        0x958D,        0x958E,        0xC6D5,        0xBEB0,
	/* U+6670 */        0xCEFA,        0x958F,        0x9590,        0x9591,        0xC7E7,        0x9592,        0xBEA7,        0xEAD0,
	/* U+6678 */        0x9593,        0x9594,        0xD6C7,        0x9595,        0x9596,        0x9597,        0xC1C0,        0x9598,
	/* U+6680 */        0x9599,        0x959A,        0xD4DD,        0x959B,        0xEAD1,        0x959C,        0x959D,        0xCFBE,
	/* U+6688 */        0x959E,        0x959F,        0x95A0,        0x95A1,        0xEAD2,        0x95A2,        0x95A3,        0x95A4,
	/* U+6690 */        0x95A5,        0xCAEE,        0x95A6,        0x95A7,        0x95A8,        0x95A9,        0xC5AF,        0xB0B5,
	/* U+6698 */        0x95AA,        0x95AB,        0x95AC,        0x95AD,        0x95AE,        0xEAD4,        0x95AF,        0x95B0,
	/* U+66A0 */        0x95B1,        0x95B2,        0x95B3,        0x95B4,        0x95B5,        0x95B6,        0x95B7,        0xEAD3,
	/* U+66A8 */        0xF4DF,        0x95B8,        0x95B9,        0x95BA,        0x95BB,        0x95BC,        0xC4BA,        0x95BD,
	/* U+66B0 */        0x95BE,        0x95BF,        0x95C0,        0x95C1,        0xB1A9,        0x95C2,        0x95C3,        0x95C4,
	/* U+66B8 */        0x95C5,        0xE5DF,        0x95C6,        0x95C7,        0x95C8,        0x95C9,        0xEAD5,        0x95CA,
	/* U+66C0 */        0x95CB,        0x95CC,        0x95CD,        0x95CE,        0x95CF,        0x95D0,        0x95D1,        0x95D2,
	/* U+66C8 */        0x95D3,        0x95D4,        0x95D5,        0x95D6,        0x95D7,        0x95D8,        0x95D9,        0x95DA,
	/* U+66D0 */        0x95DB,        0x95DC,        0x95DD,        0x95DE,        0x95DF,        0x95E0,        0x95E1,        0x95E2,
	/* U+66D8 */        0x95E3,        0xCAEF,        0x95E4,        0xEAD6,        0xEAD7,        0xC6D8,        0x95E5,        0x95E6,
	/* U+66E0 */        0x95E7,        0x95E8,        0x95E9,        0x95EA,        0x95EB,        0x95EC,        0xEAD8,        0x95ED,
	/* U+66E8 */        0x95EE,        0xEAD9,        0x95EF,        0x95F0,        0x95F1,        0x95F2,        0x95F3,        0x95F4,
	/* U+66F0 */        0xD4BB,        0x95F5,        0xC7FA,        0xD2B7,        0xB8FC,        0x95F6,        0x95F7,        0xEAC2,
	/* U+66F8 */        0x95F8,        0xB2DC,        0x95F9,        0x95FA,        0xC2FC,        0x95FB,        0xD4F8,        0xCCE6,
	/* U+6700 */        0xD7EE,        0x95FC,        0x95FD,        0x95FE,        0x9640,        0x9641,        0x9642,        0x9643,
	/* U+6708 */        0xD4C2,        0xD3D0,        0xEBC3,        0xC5F3,        0x9644,        0xB7FE,        0x9645,        0x9646,
	/* U+6710 */        0xEBD4,        0x9647,        0x9648,        0x9649,        0xCBB7,        0xEBDE,        0x964A,        0xC0CA,
	/* U+6718 */        0x964B,        0x964C,        0x964D,        0xCDFB,        0x964E,        0xB3AF,        0x964F,        0xC6DA,
	/* U+6720 */        0x9650,        0x9651,        0x9652,        0x9653,        0x9654,        0x9655,        0xEBFC,        0x9656,
	/* U+6728 */        0xC4BE,        0x9657,        0xCEB4,        0xC4A9,        0xB1BE,        0xD4FD,        0x9658,        0xCAF5,
	/* U+6730 */        0x9659,        0xD6EC,        0x965A,        0x965B,        0xC6D3,        0xB6E4,        0x965C,        0x965D,
	/* U+6738 */        0x965E,        0x965F,        0xBBFA,        0x9660,        0x9661,        0xD0E0,        0x9662,        0x9663,
	/* U+6740 */        0xC9B1,        0x9664,        0xD4D3,        0xC8A8,        0x9665,        0x9666,        0xB8CB,        0x9667,
	/* U+6748 */        0xE8BE,        0xC9BC,        0x9668,        0x9669,        0xE8BB,        0x966A,        0xC0EE,        0xD0D3,
	/* U+6750 */        0xB2C4,        0xB4E5,        0x966B,        0xE8BC,        0x966C,        0x966D,        0xD5C8,        0x966E,
	/* U+6758 */        0x966F,        0x9670,        0x9671,        0x9672,        0xB6C5,        0x9673,        0xE8BD,        0xCAF8,
	/* U+6760 */        0xB8DC,        0xCCF5,        0x9674,        0x9675,        0x9676,        0xC0B4,        0x9677,        0x9678,
	/* U+6768 */        0xD1EE,        0xE8BF,        0xE8C2,        0x9679,        0x967A,        0xBABC,        0x967B,        0xB1AD,
	/* U+6770 */        0xBDDC,        0x967C,        0xEABD,        0xE8C3,        0x967D,        0xE8C6,        0x967E,        0xE8CB,
	/* U+6778 */        0x9680,        0x9681,        0x9682,        0x9683,        0xE8CC,        0x9684,        0xCBC9,        0xB0E5,
	/* U+6780 */        0x9685,        0xBCAB,        0x9686,        0x9687,        0xB9B9,        0x9688,        0x9689,        0xE8C1,
	/* U+6788 */        0x968A,        0xCDF7,        0x968B,        0xE8CA,        0x968C,        0x968D,        0x968E,        0x968F,
	/* U+6790 */        0xCEF6,        0x9690,        0x9691,        0x9692,        0x9693,        0xD5ED,        0x9694,        0xC1D6,
	/* U+6798 */        0xE8C4,        0x9695,        0xC3B6,        0x9696,        0xB9FB,        0xD6A6,        0xE8C8,        0x9697,
	/* U+67A0 */        0x9698,        0x9699,        0xCAE0,        0xD4E6,        0x969A,        0xE8C0,        0x969B,        0xE8C5,
	/* U+67A8 */        0xE8C7,        0x969C,        0xC7B9,        0xB7E3,        0x969D,        0xE8C9,        0x969E,        0xBFDD,
	/* U+67B0 */        0xE8D2,        0x969F,        0x96A0,        0xE8D7,        0x96A1,        0xE8D5,        0xBCDC,        0xBCCF,
	/* U+67B8 */        0xE8DB,        0x96A2,        0x96A3,        0x96A4,        0x96A5,        0x96A6,        0x96A7,        0x96A8,
	/* U+67C0 */        0x96A9,        0xE8DE,        0x96AA,        0xE8DA,        0xB1FA,        0x96AB,        0x96AC,        0x96AD,
	/* U+67C8 */        0x96AE,        0x96AF,        0x96B0,        0x96B1,        0x96B2,        0x96B3,        0x96B4,        0xB0D8,
	/* U+67D0 */        0xC4B3,        0xB8CC,        0xC6E2,        0xC8BE,        0xC8E1,        0x96B5,        0x96B6,        0x96B7,
	/* U+67D8 */        0xE8CF,        0xE8D4,        0xE8D6,        0x96B8,        0xB9F1,        0xE8D8,        0xD7F5,        0x96B9,
	/* U+67E0 */        0xC4FB,        0x96BA,        0xE8DC,        0x96BB,        0x96BC,        0xB2E9,        0x96BD,        0x96BE,
	/* U+67E8 */        0x96BF,        0xE8D1,        0x96C0,        0x96C1,        0xBCED,        0x96C2,        0x96C3,        0xBFC2,
	/* U+67F0 */        0xE8CD,        0xD6F9,        0x96C4,        0xC1F8,        0xB2F1,        0x96C5,        0x96C6,        0x96C7,
	/* U+67F8 */        0x96C8,        0x96C9,        0x96CA,        0x96CB,        0x96CC,        0xE8DF,        0x96CD,        0xCAC1,
	/* U+6800 */        0xE8D9,        0x96CE,        0x96CF,        0x96D0,        0x96D1,        0xD5A4,        0x96D2,        0xB1EA,
	/* U+6808 */        0xD5BB,        0xE8CE,        0xE8D0,        0xB6B0,        0xE8D3,        0x96D3,        0xE8DD,        0xC0B8,
	/* U+6810 */        0x96D4,        0xCAF7,        0x96D5,        0xCBA8,        0x96D6,        0x96D7,        0xC6DC,        0xC0F5,
	/* U+6818 */        0x96D8,        0x96D9,        0x96DA,        0x96DB,        0x96DC,        0xE8E9,        0x96DD,        0x96DE,
	/* U+6820 */        0x96DF,        0xD0A3,        0x96E0,        0x96E1,        0x96E2,        0x96E3,        0x96E4,        0x96E5,
	/* U+6828 */        0x96E6,        0xE8F2,        0xD6EA,        0x96E7,        0x96E8,        0x96E9,        0x96EA,        0x96EB,
	/* U+6830 */        0x96EC,        0x96ED,        0xE8E0,        0xE8E1,        0x96EE,        0x96EF,        0x96F0,        0xD1F9,
	/* U+6838 */        0xBACB,        0xB8F9,        0x96F1,        0x96F2,        0xB8F1,        0xD4D4,        0xE8EF,        0x96F3,
	/* U+6840 */        0xE8EE,        0xE8EC,        0xB9F0,        0xCCD2,        0xE8E6,        0xCEA6,        0xBFF2,        0x96F4,
	/* U+6848 */        0xB0B8,        0xE8F1,        0xE8F0,        0x96F5,        0xD7C0,        0x96F6,        0xE8E4,        0x96F7,
	/* U+6850 */        0xCDA9,        0xC9A3,        0x96F8,        0xBBB8,        0xBDDB,        0xE8EA,        0x96F9,        0x96FA,
	/* U+6858 */        0x96FB,        0x96FC,        0x96FD,        0x96FE,        0x9740,        0x9741,        0x9742,        0x9743,
	/* U+6860 */        0xE8E2,        0xE8E3,        0xE8E5,        0xB5B5,        0xE8E7,        0xC7C5,        0xE8EB,        0xE8ED,
	/* U+6868 */        0xBDB0,        0xD7AE,        0x9744,        0xE8F8,        0x9745,        0x9746,        0x9747,        0x9748,
	/* U+6870 */        0x9749,        0x974A,        0x974B,        0x974C,        0xE8F5,        0x974D,        0xCDB0,        0xE8F6,
	/* U+6878 */        0x974E,        0x974F,        0x9750,        0x9751,        0x9752,        0x9753,        0x9754,        0x9755,
	/* U+6880 */        0x9756,        0xC1BA,        0x9757,        0xE8E8,        0x9758,        0xC3B7,        0xB0F0,        0x9759,
	/* U+6888 */        0x975A,        0x975B,        0x975C,        0x975D,        0x975E,        0x975F,        0x9760,        0xE8F4,
	/* U+6890 */        0x9761,        0x9762,        0x9763,        0xE8F7,        0x9764,        0x9765,        0x9766,        0xB9A3,
	/* U+6898 */        0x9767,        0x9768,        0x9769,        0x976A,        0x976B,        0x976C,        0x976D,        0x976E,
	/* U+68A0 */        0x976F,        0x9770,        0xC9D2,        0x9771,        0x9772,        0x9773,        0xC3CE,        0xCEE0,
	/* U+68A8 */        0xC0E6,        0x9774,        0x9775,        0x9776,        0x9777,        0xCBF3,        0x9778,        0xCCDD,
	/* U+68B0 */        0xD0B5,        0x9779,        0x977A,        0xCAE1,        0x977B,        0xE8F3,        0x977C,        0x977D,
	/* U+68B8 */        0x977E,        0x9780,        0x9781,        0x9782,        0x9783,        0x9784,        0x9785,        0x9786,
	/* U+68C0 */        0xBCEC,        0x9787,        0xE8F9,        0x9788,        0x9789,        0x978A,        0x978B,        0x978C,
	/* U+68C8 */        0x978D,        0xC3DE,        0x978E,        0xC6E5,        0x978F,        0xB9F7,        0x9790,        0x9791,
	/* U+68D0 */        0x9792,        0x9793,        0xB0F4,        0x9794,        0x9795,        0xD7D8,        0x9796,        0x9797,
	/* U+68D8 */        0xBCAC,        0x9798,        0xC5EF,        0x9799,        0x979A,        0x979B,        0x979C,        0x979D,
	/* U+68E0 */        0xCCC4,        0x979E,        0x979F,        0xE9A6,        0x97A0,        0x97A1,        0x97A2,        0x97A3,
	/* U+68E8 */        0x97A4,        0x97A5,        0x97A6,        0x97A7,        0x97A8,        0x97A9,        0xC9AD,        0x97AA,
	/* U+68F0 */        0xE9A2,        0xC0E2,        0x97AB,        0x97AC,        0x97AD,        0xBFC3,        0x97AE,        0x97AF,
	/* U+68F8 */        0x97B0,        0xE8FE,        0xB9D7,        0x97B1,        0xE8FB,        0x97B2,        0x97B3,        0x97B4,
	/* U+6900 */        0x97B5,        0xE9A4,        0x97B6,        0x97B7,        0x97B8,        0xD2CE,        0x97B9,        0x97BA,
	/* U+6908 */        0x97BB,        0x97BC,        0x97BD,        0xE9A3,        0x97BE,        0xD6B2,        0xD7B5,        0x97BF,
	/* U+6910 */        0xE9A7,        0x97C0,        0xBDB7,        0x97C1,        0x97C2,        0x97C3,        0x97C4,        0x97C5,
	/* U+6918 */        0x97C6,        0x97C7,        0x97C8,        0x97C9,        0x97CA,        0x97CB,        0x97CC,        0xE8FC,
	/* U+6920 */        0xE8FD,        0x97CD,        0x97CE,        0x97CF,        0xE9A1,        0x97D0,        0x97D1,        0x97D2,
	/* U+6928 */        0x97D3,        0x97D4,        0x97D5,        0x97D6,        0x97D7,        0xCDD6,        0x97D8,        0x97D9,
	/* U+6930 */        0xD2AC,        0x97DA,        0x97DB,        0x97DC,        0xE9B2,        0x97DD,        0x97DE,        0x97DF,
	/* U+6938 */        0x97E0,        0xE9A9,        0x97E1,        0x97E2,        0x97E3,        0xB4AA,        0x97E4,        0xB4BB,
	/* U+6940 */        0x97E5,        0x97E6,        0xE9AB,        0x97E7,        0x97E8,        0x97E9,        0x97EA,        0x97EB,
	/* U+6948 */        0x97EC,        0x97ED,        0x97EE,        0x97EF,        0x97F0,        0x97F1,        0x97F2,        0x97F3,
	/* U+6950 */        0x97F4,        0x97F5,        0x97F6,        0x97F7,        0xD0A8,        0x97F8,        0x97F9,        0xE9A5,
	/* U+6958 */        0x97FA,        0x97FB,        0xB3FE,        0x97FC,        0x97FD,        0xE9AC,        0xC0E3,        0x97FE,
	/* U+6960 */        0xE9AA,        0x9840,        0x9841,        0xE9B9,        0x9842,        0x9843,        0xE9B8,        0x9844,
	/* U+6968 */        0x9845,        0x9846,        0x9847,        0xE9AE,        0x9848,        0x9849,        0xE8FA,        0x984A,
	/* U+6970 */        0x984B,        0xE9A8,        0x984C,        0x984D,        0x984E,        0x984F,        0x9850,        0xBFAC,
	/* U+6978 */        0xE9B1,        0xE9BA,        0x9851,        0x9852,        0xC2A5,        0x9853,        0x9854,        0x9855,
	/* U+6980 */        0xE9AF,        0x9856,        0xB8C5,        0x9857,        0xE9AD,        0x9858,        0xD3DC,        0xE9B4,
	/* U+6988 */        0xE9B5,        0xE9B7,        0x9859,        0x985A,        0x985B,        0xE9C7,        0x985C,        0x985D,
	/* U+6990 */        0x985E,        0x985F,        0x9860,        0x9861,        0xC0C6,        0xE9C5,        0x9862,        0x9863,
	/* U+6998 */        0xE9B0,        0x9864,        0x9865,        0xE9BB,        0xB0F1,        0x9866,        0x9867,        0x9868,
	/* U+69A0 */        0x9869,        0x986A,        0x986B,        0x986C,        0x986D,        0x986E,        0x986F,        0xE9BC,
	/* U+69A8 */        0xD5A5,        0x9870,        0x9871,        0xE9BE,        0x9872,        0xE9BF,        0x9873,        0x9874,
	/* U+69B0 */        0x9875,        0xE9C1,        0x9876,        0x9877,        0xC1F1,        0x9878,        0x9879,        0xC8B6,
	/* U+69B8 */        0x987A,        0x987B,        0x987C,        0xE9BD,        0x987D,        0x987E,        0x9880,        0x9881,
	/* U+69C0 */        0x9882,        0xE9C2,        0x9883,        0x9884,        0x9885,        0x9886,        0x9887,        0x9888,
	/* U+69C8 */        0x9889,        0x988A,        0xE9C3,        0x988B,        0xE9B3,        0x988C,        0xE9B6,        0x988D,
	/* U+69D0 */        0xBBB1,        0x988E,        0x988F,        0x9890,        0xE9C0,        0x9891,        0x9892,        0x9893,
	/* U+69D8 */        0x9894,        0x9895,        0x9896,        0xBCF7,        0x9897,        0x9898,        0x9899,        0xE9C4,
	/* U+69E0 */        0xE9C6,        0x989A,        0x989B,        0x989C,        0x989D,        0x989E,        0x989F,        0x98A0,
	/* U+69E8 */        0x98A1,        0x98A2,        0x98A3,        0x98A4,        0x98A5,        0xE9CA,        0x98A6,        0x98A7,
	/* U+69F0 */        0x98A8,        0x98A9,        0xE9CE,        0x98AA,        0x98AB,        0x98AC,        0x98AD,        0x98AE,
	/* U+69F8 */        0x98AF,        0x98B0,        0x98B1,        0x98B2,        0x98B3,        0xB2DB,        0x98B4,        0xE9C8,
	/* U+6A00 */        0x98B5,        0x98B6,        0x98B7,        0x98B8,        0x98B9,        0x98BA,        0x98BB,        0x98BC,
	/* U+6A08 */        0x98BD,        0x98BE,        0xB7AE,        0x98BF,        0x98C0,        0x98C1,        0x98C2,        0x98C3,
	/* U+6A10 */        0x98C4,        0x98C5,        0x98C6,        0x98C7,        0x98C8,        0x98C9,        0x98CA,        0xE9CB,
	/* U+6A18 */        0xE9CC,        0x98CB,        0x98CC,        0x98CD,        0x98CE,        0x98CF,        0x98D0,        0xD5C1,
	/* U+6A20 */        0x98D1,        0xC4A3,        0x98D2,        0x98D3,        0x98D4,        0x98D5,        0x98D6,        0x98D7,
	/* U+6A28 */        0xE9D8,        0x98D8,        0xBAE1,        0x98D9,        0x98DA,        0x98DB,        0x98DC,        0xE9C9,
	/* U+6A30 */        0x98DD,        0xD3A3,        0x98DE,        0x98DF,        0x98E0,        0xE9D4,        0x98E1,        0x98E2,
	/* U+6A38 */        0x98E3,        0x98E4,        0x98E5,        0x98E6,        0x98E7,        0xE9D7,        0xE9D0,        0x98E8,
	/* U+6A40 */        0x98E9,        0x98EA,        0x98EB,        0x98EC,        0xE9CF,        0x98ED,        0x98EE,        0xC7C1,
	/* U+6A48 */        0x98EF,        0x98F0,        0x98F1,        0x98F2,        0x98F3,        0x98F4,        0x98F5,        0x98F6,
	/* U+6A50 */        0xE9D2,        0x98F7,        0x98F8,        0x98F9,        0x98FA,        0x98FB,        0x98FC,        0x98FD,
	/* U+6A58 */        0xE9D9,        0xB3C8,        0x98FE,        0xE9D3,        0x9940,        0x9941,        0x9942,        0x9943,
	/* U+6A60 */        0x9944,        0xCFF0,        0x9945,        0x9946,        0x9947,        0xE9CD,        0x9948,        0x9949,
	/* U+6A68 */        0x994A,        0x994B,        0x994C,        0x994D,        0x994E,        0x994F,        0x9950,        0x9951,
	/* U+6A70 */        0x9952,        0xB3F7,        0x9953,        0x9954,        0x9955,        0x9956,        0x9957,        0x9958,
	/* U+6A78 */        0x9959,        0xE9D6,        0x995A,        0x995B,        0xE9DA,        0x995C,        0x995D,        0x995E,
	/* U+6A80 */        0xCCB4,        0x995F,        0x9960,        0x9961,        0xCFAD,        0x9962,        0x9963,        0x9964,
	/* U+6A88 */        0x9965,        0x9966,        0x9967,        0x9968,        0x9969,        0x996A,        0xE9D5,        0x996B,
	/* U+6A90 */        0xE9DC,        0xE9DB,        0x996C,        0x996D,        0x996E,        0x996F,        0x9970,        0xE9DE,
	/* U+6A98 */        0x9971,        0x9972,        0x9973,        0x9974,        0x9975,        0x9976,        0x9977,        0x9978,
	/* U+6AA0 */        0xE9D1,        0x9979,        0x997A,        0x997B,        0x997C,        0x997D,        0x997E,        0x9980,
	/* U+6AA8 */        0x9981,        0xE9DD,        0x9982,        0xE9DF,        0xC3CA,        0x9983,        0x9984,        0x9985,
	/* U+6AB0 */        0x9986,        0x9987,        0x9988,        0x9989,        0x998A,        0x998B,        0x998C,        0x998D,
	/* U+6AB8 */        0x998E,        0x998F,        0x9990,        0x9991,        0x9992,        0x9993,        0x9994,        0x9995,
	/* U+6AC0 */        0x9996,        0x9997,        0x9998,        0x9999,        0x999A,        0x999B,        0x999C,        0x999D,
	/* U+6AC8 */        0x999E,        0x999F,        0x99A0,        0x99A1,        0x99A2,        0x99A3,        0x99A4,        0x99A5,
	/* U+6AD0 */        0x99A6,        0x99A7,        0x99A8,        0x99A9,        0x99AA,        0x99AB,        0x99AC,        0x99AD,
	/* U+6AD8 */        0x99AE,        0x99AF,        0x99B0,        0x99B1,        0x99B2,        0x99B3,        0x99B4,        0x99B5,
	/* U+6AE0 */        0x99B6,        0x99B7,        0x99B8,        0x99B9,        0x99BA,        0x99BB,        0x99BC,        0x99BD,
	/* U+6AE8 */        0x99BE,        0x99BF,        0x99C0,        0x99C1,        0x99C2,        0x99C3,        0x99C4,        0x99C5,
	/* U+6AF0 */        0x99C6,        0x99C7,        0x99C8,        0x99C9,        0x99CA,        0x99CB,        0x99CC,        0x99CD,
	/* U+6AF8 */        0x99CE,        0x99CF,        0x99D0,        0x99D1,        0x99D2,        0x99D3,        0x99D4,        0x99D5,
	/* U+6B00 */        0x99D6,        0x99D7,        0x99D8,        0x99D9,        0x99DA,        0x99DB,        0x99DC,        0x99DD,
	/* U+6B08 */        0x99DE,        0x99DF,        0x99E0,        0x99E1,        0x99E2,        0x99E3,        0x99E4,        0x99E5,
	/* U+6B10 */        0x99E6,        0x99E7,        0x99E8,        0x99E9,        0x99EA,        0x99EB,        0x99EC,        0x99ED,
	/* U+6B18 */        0x99EE,        0x99EF,        0x99F0,        0x99F1,        0x99F2,        0x99F3,        0x99F4,        0x99F5,
	/* U+6B20 */        0xC7B7,        0xB4CE,        0xBBB6,        0xD0C0,        0xECA3,        0x99F6,        0x99F7,        0xC5B7,
	/* U+6B28 */        0x99F8,        0x99F9,        0x99FA,        0x99FB,        0x99FC,        0x99FD,        0x99FE,        0x9A40,
	/* U+6B30 */        0x9A41,        0x9A42,        0xD3FB,        0x9A43,        0x9A44,        0x9A45,        0x9A46,        0xECA4,
	/* U+6B38 */        0x9A47,        0xECA5,        0xC6DB,        0x9A48,        0x9A49,        0x9A4A,        0xBFEE,        0x9A4B,
	/* U+6B40 */        0x9A4C,        0x9A4D,        0x9A4E,        0xECA6,        0x9A4F,        0x9A50,        0xECA7,        0xD0AA,
	/* U+6B48 */        0x9A51,        0xC7B8,        0x9A52,        0x9A53,        0xB8E8,        0x9A54,        0x9A55,        0x9A56,
	/* U+6B50 */        0x9A57,        0x9A58,        0x9A59,        0x9A5A,        0x9A5B,        0x9A5C,        0x9A5D,        0x9A5E,
	/* U+6B58 */        0x9A5F,        0xECA8,        0x9A60,        0x9A61,        0x9A62,        0x9A63,        0x9A64,        0x9A65,
	/* U+6B60 */        0x9A66,        0x9A67,        0xD6B9,        0xD5FD,        0xB4CB,        0xB2BD,        0xCEE4,        0xC6E7,
	/* U+6B68 */        0x9A68,        0x9A69,        0xCDE1,        0x9A6A,        0x9A6B,        0x9A6C,        0x9A6D,        0x9A6E,
	/* U+6B70 */        0x9A6F,        0x9A70,        0x9A71,        0x9A72,        0x9A73,        0x9A74,        0x9A75,        0x9A76,
	/* U+6B78 */        0x9A77,        0xB4F5,        0x9A78,        0xCBC0,        0xBCDF,        0x9A79,        0x9A7A,        0x9A7B,
	/* U+6B80 */        0x9A7C,        0xE9E2,        0xE9E3,        0xD1EA,        0xE9E5,        0x9A7D,        0xB4F9,        0xE9E4,
	/* U+6B88 */        0x9A7E,        0xD1B3,        0xCAE2,        0xB2D0,        0x9A80,        0xE9E8,        0x9A81,        0x9A82,
	/* U+6B90 */        0x9A83,        0x9A84,        0xE9E6,        0xE9E7,        0x9A85,        0x9A86,        0xD6B3,        0x9A87,
	/* U+6B98 */        0x9A88,        0x9A89,        0xE9E9,        0xE9EA,        0x9A8A,        0x9A8B,        0x9A8C,        0x9A8D,
	/* U+6BA0 */        0x9A8E,        0xE9EB,        0x9A8F,        0x9A90,        0x9A91,        0x9A92,        0x9A93,        0x9A94,
	/* U+6BA8 */        0x9A95,        0x9A96,        0xE9EC,        0x9A97,        0x9A98,        0x9A99,        0x9A9A,        0x9A9B,
	/* U+6BB0 */        0x9A9C,        0x9A9D,        0x9A9E,        0xECAF,        0xC5B9,        0xB6CE,        0x9A9F,        0xD2F3,
	/* U+6BB8 */        0x9AA0,        0x9AA1,        0x9AA2,        0x9AA3,        0x9AA4,        0x9AA5,        0x9AA6,        0xB5EE,
	/* U+6BC0 */        0x9AA7,        0xBBD9,        0xECB1,        0x9AA8,        0x9AA9,        0xD2E3,        0x9AAA,        0x9AAB,
	/* U+6BC8 */        0x9AAC,        0x9AAD,        0x9AAE,        0xCEE3,        0x9AAF,        0xC4B8,        0x9AB0,        0xC3BF,
	/* U+6BD0 */        0x9AB1,        0x9AB2,        0xB6BE,        0xD8B9,        0xB1C8,        0xB1CF,        0xB1D1,        0xC5FE,
	/* U+6BD8 */        0x9AB3,        0xB1D0,        0x9AB4,        0xC3AB,        0x9AB5,        0x9AB6,        0x9AB7,        0x9AB8,
	/* U+6BE0 */        0x9AB9,        0xD5B1,        0x9ABA,        0x9ABB,        0x9ABC,        0x9ABD,        0x9ABE,        0x9ABF,
	/* U+6BE8 */        0x9AC0,        0x9AC1,        0xEBA4,        0xBAC1,        0x9AC2,        0x9AC3,        0x9AC4,        0xCCBA,
	/* U+6BF0 */        0x9AC5,        0x9AC6,        0x9AC7,        0xEBA5,        0x9AC8,        0xEBA7,        0x9AC9,        0x9ACA,
	/* U+6BF8 */        0x9ACB,        0xEBA8,        0x9ACC,        0x9ACD,        0x9ACE,        0xEBA6,        0x9ACF,        0x9AD0,
	/* U+6C00 */        0x9AD1,        0x9AD2,        0x9AD3,        0x9AD4,        0x9AD5,        0xEBA9,        0xEBAB,        0xEBAA,
	/* U+6C08 */        0x9AD6,        0x9AD7,        0x9AD8,        0x9AD9,        0x9ADA,        0xEBAC,        0x9ADB,        0xCACF,
	/* U+6C10 */        0xD8B5,        0xC3F1,        0x9ADC,        0xC3A5,        0xC6F8,        0xEBAD,        0xC4CA,        0x9ADD,
	/* U+6C18 */        0xEBAE,        0xEBAF,        0xEBB0,        0xB7D5,        0x9ADE,        0x9ADF,        0x9AE0,        0xB7FA,
	/* U+6C20 */        0x9AE1,        0xEBB1,        0xC7E2,        0x9AE2,        0xEBB3,        0x9AE3,        0xBAA4,        0xD1F5,
	/* U+6C28 */        0xB0B1,        0xEBB2,        0xEBB4,        0x9AE4,        0x9AE5,        0x9AE6,        0xB5AA,        0xC2C8,
	/* U+6C30 */        0xC7E8,        0x9AE7,        0xEBB5,        0x9AE8,        0xCBAE,        0xE3DF,        0x9AE9,        0x9AEA,
	/* U+6C38 */        0xD3C0,        0x9AEB,        0x9AEC,        0x9AED,        0x9AEE,        0xD9DB,        0x9AEF,        0x9AF0,
	/* U+6C40 */        0xCDA1,        0xD6AD,        0xC7F3,        0x9AF1,        0x9AF2,        0x9AF3,        0xD9E0,        0xBBE3,
	/* U+6C48 */        0x9AF4,        0xBABA,        0xE3E2,        0x9AF5,        0x9AF6,        0x9AF7,        0x9AF8,        0x9AF9,
	/* U+6C50 */        0xCFAB,        0x9AFA,        0x9AFB,        0x9AFC,        0xE3E0,        0xC9C7,        0x9AFD,        0xBAB9,
	/* U+6C58 */        0x9AFE,        0x9B40,        0x9B41,        0xD1B4,        0xE3E1,        0xC8EA,        0xB9AF,        0xBDAD,
	/* U+6C60 */        0xB3D8,        0xCEDB,        0x9B42,        0x9B43,        0xCCC0,        0x9B44,        0x9B45,        0x9B46,
	/* U+6C68 */        0xE3E8,        0xE3E9,        0xCDF4,        0x9B47,        0x9B48,        0x9B49,        0x9B4A,        0x9B4B,
	/* U+6C70 */        0xCCAD,        0x9B4C,        0xBCB3,        0x9B4D,        0xE3EA,        0x9B4E,        0xE3EB,        0x9B4F,
	/* U+6C78 */        0x9B50,        0xD0DA,        0x9B51,        0x9B52,        0x9B53,        0xC6FB,        0xB7DA,        0x9B54,
	/* U+6C80 */        0x9B55,        0xC7DF,        0xD2CA,        0xCED6,        0x9B56,        0xE3E4,        0xE3EC,        0x9B57,
	/* U+6C88 */        0xC9F2,        0xB3C1,        0x9B58,        0x9B59,        0xE3E7,        0x9B5A,        0x9B5B,        0xC6E3,
	/* U+6C90 */        0xE3E5,        0x9B5C,        0x9B5D,        0xEDB3,        0xE3E6,        0x9B5E,        0x9B5F,        0x9B60,
	/* U+6C98 */        0x9B61,        0xC9B3,        0x9B62,        0xC5E6,        0x9B63,        0x9B64,        0x9B65,        0xB9B5,
	/* U+6CA0 */        0x9B66,        0xC3BB,        0x9B67,        0xE3E3,        0xC5BD,        0xC1A4,        0xC2D9,        0xB2D7,
	/* U+6CA8 */        0x9B68,        0xE3ED,        0xBBA6,        0xC4AD,        0x9B69,        0xE3F0,        0xBEDA,        0x9B6A,
	/* U+6CB0 */        0x9B6B,        0xE3FB,        0xE3F5,        0xBAD3,        0x9B6C,        0x9B6D,        0x9B6E,        0x9B6F,
	/* U+6CB8 */        0xB7D0,        0xD3CD,        0x9B70,        0xD6CE,        0xD5D3,        0xB9C1,        0xD5B4,        0xD1D8,
	/* U+6CC0 */        0x9B71,        0x9B72,        0x9B73,        0x9B74,        0xD0B9,        0xC7F6,        0x9B75,        0x9B76,
	/* U+6CC8 */        0x9B77,        0xC8AA,        0xB2B4,        0x9B78,        0xC3DA,        0x9B79,        0x9B7A,        0x9B7B,
	/* U+6CD0 */        0xE3EE,        0x9B7C,        0x9B7D,        0xE3FC,        0xE3EF,        0xB7A8,        0xE3F7,        0xE3F4,
	/* U+6CD8 */        0x9B7E,        0x9B80,        0x9B81,        0xB7BA,        0x9B82,        0x9B83,        0xC5A2,        0x9B84,
	/* U+6CE0 */        0xE3F6,        0xC5DD,        0xB2A8,        0xC6FC,        0x9B85,        0xC4E0,        0x9B86,        0x9B87,
	/* U+6CE8 */        0xD7A2,        0x9B88,        0xC0E1,        0xE3F9,        0x9B89,        0x9B8A,        0xE3FA,        0xE3FD,
	/* U+6CF0 */        0xCCA9,        0xE3F3,        0x9B8B,        0xD3BE,        0x9B8C,        0xB1C3,        0xEDB4,        0xE3F1,
	/* U+6CF8 */        0xE3F2,        0x9B8D,        0xE3F8,        0xD0BA,        0xC6C3,        0xD4F3,        0xE3FE,        0x9B8E,
	/* U+6D00 */        0x9B8F,        0xBDE0,        0x9B90,        0x9B91,        0xE4A7,        0x9B92,        0x9B93,        0xE4A6,
	/* U+6D08 */        0x9B94,        0x9B95,        0x9B96,        0xD1F3,        0xE4A3,        0x9B97,        0xE4A9,        0x9B98,
	/* U+6D10 */        0x9B99,        0x9B9A,        0xC8F7,        0x9B9B,        0x9B9C,        0x9B9D,        0x9B9E,        0xCFB4,
	/* U+6D18 */        0x9B9F,        0xE4A8,        0xE4AE,        0xC2E5,        0x9BA0,        0x9BA1,        0xB6B4,        0x9BA2,
	/* U+6D20 */        0x9BA3,        0x9BA4,        0x9BA5,        0x9BA6,        0x9BA7,        0xBDF2,        0x9BA8,        0xE4A2,
	/* U+6D28 */        0x9BA9,        0x9BAA,        0xBAE9,        0xE4AA,        0x9BAB,        0x9BAC,        0xE4AC,        0x9BAD,
	/* U+6D30 */        0x9BAE,        0xB6FD,        0xD6DE,        0xE4B2,        0x9BAF,        0xE4AD,        0x9BB0,        0x9BB1,
	/* U+6D38 */        0x9BB2,        0xE4A1,        0x9BB3,        0xBBEE,        0xCDDD,        0xC7A2,        0xC5C9,        0x9BB4,
	/* U+6D40 */        0x9BB5,        0xC1F7,        0x9BB6,        0xE4A4,        0x9BB7,        0xC7B3,        0xBDAC,        0xBDBD,
	/* U+6D48 */        0xE4A5,        0x9BB8,        0xD7C7,        0xB2E2,        0x9BB9,        0xE4AB,        0xBCC3,        0xE4AF,
	/* U+6D50 */        0x9BBA,        0xBBEB,        0xE4B0,        0xC5A8,        0xE4B1,        0x9BBB,        0x9BBC,        0x9BBD,
	/* U+6D58 */        0x9BBE,        0xD5E3,        0xBFA3,        0x9BBF,        0xE4BA,        0x9BC0,        0xE4B7,        0x9BC1,
	/* U+6D60 */        0xE4BB,        0x9BC2,        0x9BC3,        0xE4BD,        0x9BC4,        0x9BC5,        0xC6D6,        0x9BC6,
	/* U+6D68 */        0x9BC7,        0xBAC6,        0xC0CB,        0x9BC8,        0x9BC9,        0x9BCA,        0xB8A1,        0xE4B4,
	/* U+6D70 */        0x9BCB,        0x9BCC,        0x9BCD,        0x9BCE,        0xD4A1,        0x9BCF,        0x9BD0,        0xBAA3,
	/* U+6D78 */        0xBDFE,        0x9BD1,        0x9BD2,        0x9BD3,        0xE4BC,        0x9BD4,        0x9BD5,        0x9BD6,
	/* U+6D80 */        0x9BD7,        0x9BD8,        0xCDBF,        0x9BD9,        0x9BDA,        0xC4F9,        0x9BDB,        0x9BDC,
	/* U+6D88 */        0xCFFB,        0xC9E6,        0x9BDD,        0x9BDE,        0xD3BF,        0x9BDF,        0xCFD1,        0x9BE0,
	/* U+6D90 */        0x9BE1,        0xE4B3,        0x9BE2,        0xE4B8,        0xE4B9,        0xCCE9,        0x9BE3,        0x9BE4,
	/* U+6D98 */        0x9BE5,        0x9BE6,        0x9BE7,        0xCCCE,        0x9BE8,        0xC0D4,        0xE4B5,        0xC1B0,
	/* U+6DA0 */        0xE4B6,        0xCED0,        0x9BE9,        0xBBC1,        0xB5D3,        0x9BEA,        0xC8F3,        0xBDA7,
	/* U+6DA8 */        0xD5C7,        0xC9AC,        0xB8A2,        0xE4CA,        0x9BEB,        0x9BEC,        0xE4CC,        0xD1C4,
	/* U+6DB0 */        0x9BED,        0x9BEE,        0xD2BA,        0x9BEF,        0x9BF0,        0xBAAD,        0x9BF1,        0x9BF2,
	/* U+6DB8 */        0xBAD4,        0x9BF3,        0x9BF4,        0x9BF5,        0x9BF6,        0x9BF7,        0x9BF8,        0xE4C3,
	/* U+6DC0 */        0xB5ED,        0x9BF9,        0x9BFA,        0x9BFB,        0xD7CD,        0xE4C0,        0xCFFD,        0xE4BF,
	/* U+6DC8 */        0x9BFC,        0x9BFD,        0x9BFE,        0xC1DC,        0xCCCA,        0x9C40,        0x9C41,        0x9C42,
	/* U+6DD0 */        0x9C43,        0xCAE7,        0x9C44,        0x9C45,        0x9C46,        0x9C47,        0xC4D7,        0x9C48,
	/* U+6DD8 */        0xCCD4,        0xE4C8,        0x9C49,        0x9C4A,        0x9C4B,        0xE4C7,        0xE4C1,        0x9C4C,
	/* U+6DE0 */        0xE4C4,        0xB5AD,        0x9C4D,        0x9C4E,        0xD3D9,        0x9C4F,        0xE4C6,        0x9C50,
	/* U+6DE8 */        0x9C51,        0x9C52,        0x9C53,        0xD2F9,        0xB4E3,        0x9C54,        0xBBB4,        0x9C55,
	/* U+6DF0 */        0x9C56,        0xC9EE,        0x9C57,        0xB4BE,        0x9C58,        0x9C59,        0x9C5A,        0xBBEC,
	/* U+6DF8 */        0x9C5B,        0xD1CD,        0x9C5C,        0xCCED,        0xEDB5,        0x9C5D,        0x9C5E,        0x9C5F,
	/* U+6E00 */        0x9C60,        0x9C61,        0x9C62,        0x9C63,        0x9C64,        0xC7E5,        0x9C65,        0x9C66,
	/* U+6E08 */        0x9C67,        0x9C68,        0xD4A8,        0x9C69,        0xE4CB,        0xD7D5,        0xE4C2,        0x9C6A,
	/* U+6E10 */        0xBDA5,        0xE4C5,        0x9C6B,        0x9C6C,        0xD3E6,        0x9C6D,        0xE4C9,        0xC9F8,
	/* U+6E18 */        0x9C6E,        0x9C6F,        0xE4BE,        0x9C70,        0x9C71,        0xD3E5,        0x9C72,        0x9C73,
	/* U+6E20 */        0xC7FE,        0xB6C9,        0x9C74,        0xD4FC,        0xB2B3,        0xE4D7,        0x9C75,        0x9C76,
	/* U+6E28 */        0x9C77,        0xCEC2,        0x9C78,        0xE4CD,        0x9C79,        0xCEBC,        0x9C7A,        0xB8DB,
	/* U+6E30 */        0x9C7B,        0x9C7C,        0xE4D6,        0x9C7D,        0xBFCA,        0x9C7E,        0x9C80,        0x9C81,
	/* U+6E38 */        0xD3CE,        0x9C82,        0xC3EC,        0x9C83,        0x9C84,        0x9C85,        0x9C86,        0x9C87,
	/* U+6E40 */        0x9C88,        0x9C89,        0x9C8A,        0xC5C8,        0xE4D8,        0x9C8B,        0x9C8C,        0x9C8D,
	/* U+6E48 */        0x9C8E,        0x9C8F,        0x9C90,        0x9C91,        0x9C92,        0xCDC4,        0xE4CF,        0x9C93,
	/* U+6E50 */        0x9C94,        0x9C95,        0x9C96,        0xE4D4,        0xE4D5,        0x9C97,        0xBAFE,        0x9C98,
	/* U+6E58 */        0xCFE6,        0x9C99,        0x9C9A,        0xD5BF,        0x9C9B,        0x9C9C,        0x9C9D,        0xE4D2,
	/* U+6E60 */        0x9C9E,        0x9C9F,        0x9CA0,        0x9CA1,        0x9CA2,        0x9CA3,        0x9CA4,        0x9CA5,
	/* U+6E68 */        0x9CA6,        0x9CA7,        0x9CA8,        0xE4D0,        0x9CA9,        0x9CAA,        0xE4CE,        0x9CAB,
	/* U+6E70 */        0x9CAC,        0x9CAD,        0x9CAE,        0x9CAF,        0x9CB0,        0x9CB1,        0x9CB2,        0x9CB3,
	/* U+6E78 */        0x9CB4,        0x9CB5,        0x9CB6,        0x9CB7,        0x9CB8,        0x9CB9,        0xCDE5,        0xCAAA,
	/* U+6E80 */        0x9CBA,        0x9CBB,        0x9CBC,        0xC0A3,        0x9CBD,        0xBDA6,        0xE4D3,        0x9CBE,
	/* U+6E88 */        0x9CBF,        0xB8C8,        0x9CC0,        0x9CC1,        0x9CC2,        0x9CC3,        0x9CC4,        0xE4E7,
	/* U+6E90 */        0xD4B4,        0x9CC5,        0x9CC6,        0x9CC7,        0x9CC8,        0x9CC9,        0x9CCA,        0x9CCB,
	/* U+6E98 */        0xE4DB,        0x9CCC,        0x9CCD,        0x9CCE,        0xC1EF,        0x9CCF,        0x9CD0,        0xE4E9,
	/* U+6EA0 */        0x9CD1,        0x9CD2,        0xD2E7,        0x9CD3,        0x9CD4,        0xE4DF,        0x9CD5,        0xE4E0,
	/* U+6EA8 */        0x9CD6,        0x9CD7,        0xCFAA,        0x9CD8,        0x9CD9,        0x9CDA,        0x9CDB,        0xCBDD,
	/* U+6EB0 */        0x9CDC,        0xE4DA,        0xE4D1,        0x9CDD,        0xE4E5,        0x9CDE,        0xC8DC,        0xE4E3,
	/* U+6EB8 */        0x9CDF,        0x9CE0,        0xC4E7,        0xE4E2,        0x9CE1,        0xE4E1,        0x9CE2,        0x9CE3,
	/* U+6EC0 */        0x9CE4,        0xB3FC,        0xE4E8,        0x9CE5,        0x9CE6,        0x9CE7,        0x9CE8,        0xB5E1,
	/* U+6EC8 */        0x9CE9,        0x9CEA,        0x9CEB,        0xD7CC,        0x9CEC,        0x9CED,        0x9CEE,        0xE4E6,
	/* U+6ED0 */        0x9CEF,        0xBBAC,        0x9CF0,        0xD7D2,        0xCCCF,        0xEBF8,        0x9CF1,        0xE4E4,
	/* U+6ED8 */        0x9CF2,        0x9CF3,        0xB9F6,        0x9CF4,        0x9CF5,        0x9CF6,        0xD6CD,        0xE4D9,
	/* U+6EE0 */        0xE4DC,        0xC2FA,        0xE4DE,        0x9CF7,        0xC2CB,        0xC0C4,        0xC2D0,        0x9CF8,
	/* U+6EE8 */        0xB1F5,        0xCCB2,        0x9CF9,        0x9CFA,        0x9CFB,        0x9CFC,        0x9CFD,        0x9CFE,
	/* U+6EF0 */        0x9D40,        0x9D41,        0x9D42,        0x9D43,        0xB5CE,        0x9D44,        0x9D45,        0x9D46,
	/* U+6EF8 */        0x9D47,        0xE4EF,        0x9D48,        0x9D49,        0x9D4A,        0x9D4B,        0x9D4C,        0x9D4D,
	/* U+6F00 */        0x9D4E,        0x9D4F,        0xC6AF,        0x9D50,        0x9D51,        0x9D52,        0xC6E1,        0x9D53,
	/* U+6F08 */        0x9D54,        0xE4F5,        0x9D55,        0x9D56,        0x9D57,        0x9D58,        0x9D59,        0xC2A9,
	/* U+6F10 */        0x9D5A,        0x9D5B,        0x9D5C,        0xC0EC,        0xD1DD,        0xE4EE,        0x9D5D,        0x9D5E,
	/* U+6F18 */        0x9D5F,        0x9D60,        0x9D61,        0x9D62,        0x9D63,        0x9D64,        0x9D65,        0x9D66,
	/* U+6F20 */        0xC4AE,        0x9D67,        0x9D68,        0x9D69,        0xE4ED,        0x9D6A,        0x9D6B,        0x9D6C,
	/* U+6F28 */        0x9D6D,        0xE4F6,        0xE4F4,        0xC2FE,        0x9D6E,        0xE4DD,        0x9D6F,        0xE4F0,
	/* U+6F30 */        0x9D70,        0xCAFE,        0x9D71,        0xD5C4,        0x9D72,        0x9D73,        0xE4F1,        0x9D74,
	/* U+6F38 */        0x9D75,        0x9D76,        0x9D77,        0x9D78,        0x9D79,        0x9D7A,        0xD1FA,        0x9D7B,
	/* U+6F40 */        0x9D7C,        0x9D7D,        0x9D7E,        0x9D80,        0x9D81,        0x9D82,        0xE4EB,        0xE4EC,
	/* U+6F48 */        0x9D83,        0x9D84,        0x9D85,        0xE4F2,        0x9D86,        0xCEAB,        0x9D87,        0x9D88,
	/* U+6F50 */        0x9D89,        0x9D8A,        0x9D8B,        0x9D8C,        0x9D8D,        0x9D8E,        0x9D8F,        0x9D90,
	/* U+6F58 */        0xC5CB,        0x9D91,        0x9D92,        0x9D93,        0xC7B1,        0x9D94,        0xC2BA,        0x9D95,
	/* U+6F60 */        0x9D96,        0x9D97,        0xE4EA,        0x9D98,        0x9D99,        0x9D9A,        0xC1CA,        0x9D9B,
	/* U+6F68 */        0x9D9C,        0x9D9D,        0x9D9E,        0x9D9F,        0x9DA0,        0xCCB6,        0xB3B1,        0x9DA1,
	/* U+6F70 */        0x9DA2,        0x9DA3,        0xE4FB,        0x9DA4,        0xE4F3,        0x9DA5,        0x9DA6,        0x9DA7,
	/* U+6F78 */        0xE4FA,        0x9DA8,        0xE4FD,        0x9DA9,        0xE4FC,        0x9DAA,        0x9DAB,        0x9DAC,
	/* U+6F80 */        0x9DAD,        0x9DAE,        0x9DAF,        0x9DB0,        0xB3CE,        0x9DB1,        0x9DB2,        0x9DB3,
	/* U+6F88 */        0xB3BA,        0xE4F7,        0x9DB4,        0x9DB5,        0xE4F9,        0xE4F8,        0xC5EC,        0x9DB6,
	/* U+6F90 */        0x9DB7,        0x9DB8,        0x9DB9,        0x9DBA,        0x9DBB,        0x9DBC,        0x9DBD,        0x9DBE,
	/* U+6F98 */        0x9DBF,        0x9DC0,        0x9DC1,        0x9DC2,        0xC0BD,        0x9DC3,        0x9DC4,        0x9DC5,
	/* U+6FA0 */        0x9DC6,        0xD4E8,        0x9DC7,        0x9DC8,        0x9DC9,        0x9DCA,        0x9DCB,        0xE5A2,
	/* U+6FA8 */        0x9DCC,        0x9DCD,        0x9DCE,        0x9DCF,        0x9DD0,        0x9DD1,        0x9DD2,        0x9DD3,
	/* U+6FB0 */        0x9DD4,        0x9DD5,        0x9DD6,        0xB0C4,        0x9DD7,        0x9DD8,        0xE5A4,        0x9DD9,
	/* U+6FB8 */        0x9DDA,        0xE5A3,        0x9DDB,        0x9DDC,        0x9DDD,        0x9DDE,        0x9DDF,        0x9DE0,
	/* U+6FC0 */        0xBCA4,        0x9DE1,        0xE5A5,        0x9DE2,        0x9DE3,        0x9DE4,        0x9DE5,        0x9DE6,
	/* U+6FC8 */        0x9DE7,        0xE5A1,        0x9DE8,        0x9DE9,        0x9DEA,        0x9DEB,        0x9DEC,        0x9DED,
	/* U+6FD0 */        0x9DEE,        0xE4FE,        0xB1F4,        0x9DEF,        0x9DF0,        0x9DF1,        0x9DF2,        0x9DF3,
	/* U+6FD8 */        0x9DF4,        0x9DF5,        0x9DF6,        0x9DF7,        0x9DF8,        0x9DF9,        0xE5A8,        0x9DFA,
	/* U+6FE0 */        0xE5A9,        0xE5A6,        0x9DFB,        0x9DFC,        0x9DFD,        0x9DFE,        0x9E40,        0x9E41,
	/* U+6FE8 */        0x9E42,        0x9E43,        0x9E44,        0x9E45,        0x9E46,        0x9E47,        0xE5A7,        0xE5AA,
	/* U+6FF0 */        0x9E48,        0x9E49,        0x9E4A,        0x9E4B,        0x9E4C,        0x9E4D,        0x9E4E,        0x9E4F,
	/* U+6FF8 */        0x9E50,        0x9E51,        0x9E52,        0x9E53,        0x9E54,        0x9E55,        0x9E56,        0x9E57,
	/* U+7000 */        0x9E58,        0x9E59,        0x9E5A,        0x9E5B,        0x9E5C,        0x9E5D,        0x9E5E,        0x9E5F,
	/* U+7008 */        0x9E60,        0x9E61,        0x9E62,        0x9E63,        0x9E64,        0x9E65,        0x9E66,        0x9E67,
	/* U+7010 */        0x9E68,        0xC6D9,        0x9E69,        0x9E6A,        0x9E6B,        0x9E6C,        0x9E6D,        0x9E6E,
	/* U+7018 */        0x9E6F,        0x9E70,        0xE5AB,        0xE5AD,        0x9E71,        0x9E72,        0x9E73,        0x9E74,
	/* U+7020 */        0x9E75,        0x9E76,        0x9E77,        0xE5AC,        0x9E78,        0x9E79,        0x9E7A,        0x9E7B,
	/* U+7028 */        0x9E7C,        0x9E7D,        0x9E7E,        0x9E80,        0x9E81,        0x9E82,        0x9E83,        0x9E84,
	/* U+7030 */        0x9E85,        0x9E86,        0x9E87,        0x9E88,        0x9E89,        0xE5AF,        0x9E8A,        0x9E8B,
	/* U+7038 */        0x9E8C,        0xE5AE,        0x9E8D,        0x9E8E,        0x9E8F,        0x9E90,        0x9E91,        0x9E92,
	/* U+7040 */        0x9E93,        0x9E94,        0x9E95,        0x9E96,        0x9E97,        0x9E98,        0x9E99,        0x9E9A,
	/* U+7048 */        0x9E9B,        0x9E9C,        0x9E9D,        0x9E9E,        0xB9E0,        0x9E9F,        0x9EA0,        0xE5B0,
	/* U+7050 */        0x9EA1,        0x9EA2,        0x9EA3,        0x9EA4,        0x9EA5,        0x9EA6,        0x9EA7,        0x9EA8,
	/* U+7058 */        0x9EA9,        0x9EAA,        0x9EAB,        0x9EAC,        0x9EAD,        0x9EAE,        0xE5B1,        0x9EAF,
	/* U+7060 */        0x9EB0,        0x9EB1,        0x9EB2,        0x9EB3,        0x9EB4,        0x9EB5,        0x9EB6,        0x9EB7,
	/* U+7068 */        0x9EB8,        0x9EB9,        0x9EBA,        0xBBF0,        0xECE1,        0xC3F0,        0x9EBB,        0xB5C6,
	/* U+7070 */        0xBBD2,        0x9EBC,        0x9EBD,        0x9EBE,        0x9EBF,        0xC1E9,        0xD4EE,        0x9EC0,
	/* U+7078 */        0xBEC4,        0x9EC1,        0x9EC2,        0x9EC3,        0xD7C6,        0x9EC4,        0xD4D6,        0xB2D3,
	/* U+7080 */        0xECBE,        0x9EC5,        0x9EC6,        0x9EC7,        0x9EC8,        0xEAC1,        0x9EC9,        0x9ECA,
	/* U+7088 */        0x9ECB,        0xC2AF,        0xB4B6,        0x9ECC,        0x9ECD,        0x9ECE,        0xD1D7,        0x9ECF,
	/* U+7090 */        0x9ED0,        0x9ED1,        0xB3B4,        0x9ED2,        0xC8B2,        0xBFBB,        0xECC0,        0x9ED3,
	/* U+7098 */        0x9ED4,        0xD6CB,        0x9ED5,        0x9ED6,        0xECBF,        0xECC1,        0x9ED7,        0x9ED8,
	/* U+70A0 */        0x9ED9,        0x9EDA,        0x9EDB,        0x9EDC,        0x9EDD,        0x9EDE,        0x9EDF,        0x9EE0,
	/* U+70A8 */        0x9EE1,        0x9EE2,        0x9EE3,        0xECC5,        0xBEE6,        0xCCBF,        0xC5DA,        0xBEBC,
	/* U+70B0 */        0x9EE4,        0xECC6,        0x9EE5,        0xB1FE,        0x9EE6,        0x9EE7,        0x9EE8,        0xECC4,
	/* U+70B8 */        0xD5A8,        0xB5E3,        0x9EE9,        0xECC2,        0xC1B6,        0xB3E3,        0x9EEA,        0x9EEB,
	/* U+70C0 */        0xECC3,        0xCBB8,        0xC0C3,        0xCCFE,        0x9EEC,        0x9EED,        0x9EEE,        0x9EEF,
	/* U+70C8 */        0xC1D2,        0x9EF0,        0xECC8,        0x9EF1,        0x9EF2,        0x9EF3,        0x9EF4,        0x9EF5,
	/* U+70D0 */        0x9EF6,        0x9EF7,        0x9EF8,        0x9EF9,        0x9EFA,        0x9EFB,        0x9EFC,        0x9EFD,
	/* U+70D8 */        0xBAE6,        0xC0D3,        0x9EFE,        0xD6F2,        0x9F40,        0x9F41,        0x9F42,        0xD1CC,
	/* U+70E0 */        0x9F43,        0x9F44,        0x9F45,        0x9F46,        0xBFBE,        0x9F47,        0xB7B3,        0xC9D5,
	/* U+70E8 */        0xECC7,        0xBBE2,        0x9F48,        0xCCCC,        0xBDFD,        0xC8C8,        0x9F49,        0xCFA9,
	/* U+70F0 */        0x9F4A,        0x9F4B,        0x9F4C,        0x9F4D,        0x9F4E,        0x9F4F,        0x9F50,        0xCDE9,
	/* U+70F8 */        0x9F51,        0xC5EB,        0x9F52,        0x9F53,        0x9F54,        0xB7E9,        0x9F55,        0x9F56,
	/* U+7100 */        0x9F57,        0x9F58,        0x9F59,        0x9F5A,        0x9F5B,        0x9F5C,        0x9F5D,        0x9F5E,
	/* U+7108 */        0x9F5F,        0xD1C9,        0xBAB8,        0x9F60,        0x9F61,        0x9F62,        0x9F63,        0x9F64,
	/* U+7110 */        0xECC9,        0x9F65,        0x9F66,        0xECCA,        0x9F67,        0xBBC0,        0xECCB,        0x9F68,
	/* U+7118 */        0xECE2,        0xB1BA,        0xB7D9,        0x9F69,        0x9F6A,        0x9F6B,        0x9F6C,        0x9F6D,
	/* U+7120 */        0x9F6E,        0x9F6F,        0x9F70,        0x9F71,        0x9F72,        0x9F73,        0xBDB9,        0x9F74,
	/* U+7128 */        0x9F75,        0x9F76,        0x9F77,        0x9F78,        0x9F79,        0x9F7A,        0x9F7B,        0xECCC,
	/* U+7130 */        0xD1E6,        0xECCD,        0x9F7C,        0x9F7D,        0x9F7E,        0x9F80,        0xC8BB,        0x9F81,
	/* U+7138 */        0x9F82,        0x9F83,        0x9F84,        0x9F85,        0x9F86,        0x9F87,        0x9F88,        0x9F89,
	/* U+7140 */        0x9F8A,        0x9F8B,        0x9F8C,        0x9F8D,        0x9F8E,        0xECD1,        0x9F8F,        0x9F90,
	/* U+7148 */        0x9F91,        0x9F92,        0xECD3,        0x9F93,        0xBBCD,        0x9F94,        0xBCE5,        0x9F95,
	/* U+7150 */        0x9F96,        0x9F97,        0x9F98,        0x9F99,        0x9F9A,        0x9F9B,        0x9F9C,        0x9F9D,
	/* U+7158 */        0x9F9E,        0x9F9F,        0x9FA0,        0x9FA1,        0xECCF,        0x9FA2,        0xC9B7,        0x9FA3,
	/* U+7160 */        0x9FA4,        0x9FA5,        0x9FA6,        0x9FA7,        0xC3BA,        0x9FA8,        0xECE3,        0xD5D5,
	/* U+7168 */        0xECD0,        0x9FA9,        0x9FAA,        0x9FAB,        0x9FAC,        0x9FAD,        0xD6F3,        0x9FAE,
	/* U+7170 */        0x9FAF,        0x9FB0,        0xECD2,        0xECCE,        0x9FB1,        0x9FB2,        0x9FB3,        0x9FB4,
	/* U+7178 */        0xECD4,        0x9FB5,        0xECD5,        0x9FB6,        0x9FB7,        0xC9BF,        0x9FB8,        0x9FB9,
	/* U+7180 */        0x9FBA,        0x9FBB,        0x9FBC,        0x9FBD,        0xCFA8,        0x9FBE,        0x9FBF,        0x9FC0,
	/* U+7188 */        0x9FC1,        0x9FC2,        0xD0DC,        0x9FC3,        0x9FC4,        0x9FC5,        0x9FC6,        0xD1AC,
	/* U+7190 */        0x9FC7,        0x9FC8,        0x9FC9,        0x9FCA,        0xC8DB,        0x9FCB,        0x9FCC,        0x9FCD,
	/* U+7198 */        0xECD6,        0xCEF5,        0x9FCE,        0x9FCF,        0x9FD0,        0x9FD1,        0x9FD2,        0xCAEC,
	/* U+71A0 */        0xECDA,        0x9FD3,        0x9FD4,        0x9FD5,        0x9FD6,        0x9FD7,        0x9FD8,        0x9FD9,
	/* U+71A8 */        0xECD9,        0x9FDA,        0x9FDB,        0x9FDC,        0xB0BE,        0x9FDD,        0x9FDE,        0x9FDF,
	/* U+71B0 */        0x9FE0,        0x9FE1,        0x9FE2,        0xECD7,        0x9FE3,        0xECD8,        0x9FE4,        0x9FE5,
	/* U+71B8 */        0x9FE6,        0xECE4,        0x9FE7,        0x9FE8,        0x9FE9,        0x9FEA,        0x9FEB,        0x9FEC,
	/* U+71C0 */        0x9FED,        0x9FEE,        0x9FEF,        0xC8BC,        0x9FF0,        0x9FF1,        0x9FF2,        0x9FF3,
	/* U+71C8 */        0x9FF4,        0x9FF5,        0x9FF6,        0x9FF7,        0x9FF8,        0x9FF9,        0xC1C7,        0x9FFA,
	/* U+71D0 */        0x9FFB,        0x9FFC,        0x9FFD,        0x9FFE,        0xECDC,        0xD1E0,        0xA040,        0xA041,
	/* U+71D8 */        0xA042,        0xA043,        0xA044,        0xA045,        0xA046,        0xA047,        0xA048,        0xA049,
	/* U+71E0 */        0xECDB,        0xA04A,        0xA04B,        0xA04C,        0xA04D,        0xD4EF,        0xA04E,        0xECDD,
	/* U+71E8 */        0xA04F,        0xA050,        0xA051,        0xA052,        0xA053,        0xA054,        0xDBC6,        0xA055,
	/* U+71F0 */        0xA056,        0xA057,        0xA058,        0xA059,        0xA05A,        0xA05B,        0xA05C,        0xA05D,
	/* U+71F8 */        0xA05E,        0xECDE,        0xA05F,        0xA060,        0xA061,        0xA062,        0xA063,        0xA064,
	/* U+7200 */        0xA065,        0xA066,        0xA067,        0xA068,        0xA069,        0xA06A,        0xB1AC,        0xA06B,
	/* U+7208 */        0xA06C,        0xA06D,        0xA06E,        0xA06F,        0xA070,        0xA071,        0xA072,        0xA073,
	/* U+7210 */        0xA074,        0xA075,        0xA076,        0xA077,        0xA078,        0xA079,        0xA07A,        0xA07B,
	/* U+7218 */        0xA07C,        0xA07D,        0xA07E,        0xA080,        0xA081,        0xECDF,        0xA082,        0xA083,
	/* U+7220 */        0xA084,        0xA085,        0xA086,        0xA087,        0xA088,        0xA089,        0xA08A,        0xA08B,
	/* U+7228 */        0xECE0,        0xA08C,        0xD7A6,        0xA08D,        0xC5C0,        0xA08E,        0xA08F,        0xA090,
	/* U+7230 */        0xEBBC,        0xB0AE,        0xA091,        0xA092,        0xA093,        0xBEF4,        0xB8B8,        0xD2AF,
	/* U+7238 */        0xB0D6,        0xB5F9,        0xA094,        0xD8B3,        0xA095,        0xCBAC,        0xA096,        0xE3DD,
	/* U+7240 */        0xA097,        0xA098,        0xA099,        0xA09A,        0xA09B,        0xA09C,        0xA09D,        0xC6AC,
	/* U+7248 */        0xB0E6,        0xA09E,        0xA09F,        0xA0A0,        0xC5C6,        0xEBB9,        0xA0A1,        0xA0A2,
	/* U+7250 */        0xA0A3,        0xA0A4,        0xEBBA,        0xA0A5,        0xA0A6,        0xA0A7,        0xEBBB,        0xA0A8,
	/* U+7258 */        0xA0A9,        0xD1C0,        0xA0AA,        0xC5A3,        0xA0AB,        0xEAF2,        0xA0AC,        0xC4B2,
	/* U+7260 */        0xA0AD,        0xC4B5,        0xC0CE,        0xA0AE,        0xA0AF,        0xA0B0,        0xEAF3,        0xC4C1,
	/* U+7268 */        0xA0B1,        0xCEEF,        0xA0B2,        0xA0B3,        0xA0B4,        0xA0B5,        0xEAF0,        0xEAF4,
	/* U+7270 */        0xA0B6,        0xA0B7,        0xC9FC,        0xA0B8,        0xA0B9,        0xC7A3,        0xA0BA,        0xA0BB,
	/* U+7278 */        0xA0BC,        0xCCD8,        0xCEFE,        0xA0BD,        0xA0BE,        0xA0BF,        0xEAF5,        0xEAF6,
	/* U+7280 */        0xCFAC,        0xC0E7,        0xA0C0,        0xA0C1,        0xEAF7,        0xA0C2,        0xA0C3,        0xA0C4,
	/* U+7288 */        0xA0C5,        0xA0C6,        0xB6BF,        0xEAF8,        0xA0C7,        0xEAF9,        0xA0C8,        0xEAFA,
	/* U+7290 */        0xA0C9,        0xA0CA,        0xEAFB,        0xA0CB,        0xA0CC,        0xA0CD,        0xA0CE,        0xA0CF,
	/* U+7298 */        0xA0D0,        0xA0D1,        0xA0D2,        0xA0D3,        0xA0D4,        0xA0D5,        0xA0D6,        0xEAF1,
	/* U+72A0 */        0xA0D7,        0xA0D8,        0xA0D9,        0xA0DA,        0xA0DB,        0xA0DC,        0xA0DD,        0xA0DE,
	/* U+72A8 */        0xA0DF,        0xA0E0,        0xA0E1,        0xA0E2,        0xC8AE,        0xE1EB,        0xA0E3,        0xB7B8,
	/* U+72B0 */        0xE1EC,        0xA0E4,        0xA0E5,        0xA0E6,        0xE1ED,        0xA0E7,        0xD7B4,        0xE1EE,
	/* U+72B8 */        0xE1EF,        0xD3CC,        0xA0E8,        0xA0E9,        0xA0EA,        0xA0EB,        0xA0EC,        0xA0ED,
	/* U+72C0 */        0xA0EE,        0xE1F1,        0xBFF1,        0xE1F0,        0xB5D2,        0xA0EF,        0xA0F0,        0xA0F1,
	/* U+72C8 */        0xB1B7,        0xA0F2,        0xA0F3,        0xA0F4,        0xA0F5,        0xE1F3,        0xE1F2,        0xA0F6,
	/* U+72D0 */        0xBAFC,        0xA0F7,        0xE1F4,        0xA0F8,        0xA0F9,        0xA0FA,        0xA0FB,        0xB9B7,
	/* U+72D8 */        0xA0FC,        0xBED1,        0xA0FD,        0xA0FE,        0xAA40,        0xAA41,        0xC4FC,        0xAA42,
	/* U+72E0 */        0xBADD,        0xBDC6,        0xAA43,        0xAA44,        0xAA45,        0xAA46,        0xAA47,        0xAA48,
	/* U+72E8 */        0xE1F5,        0xE1F7,        0xAA49,        0xAA4A,        0xB6C0,        0xCFC1,        0xCAA8,        0xE1F6,
	/* U+72F0 */        0xD5F8,        0xD3FC,        0xE1F8,        0xE1FC,        0xE1F9,        0xAA4B,        0xAA4C,        0xE1FA,
	/* U+72F8 */        0xC0EA,        0xAA4D,        0xE1FE,        0xE2A1,        0xC0C7,        0xAA4E,        0xAA4F,        0xAA50,
	/* U+7300 */        0xAA51,        0xE1FB,        0xAA52,        0xE1FD,        0xAA53,        0xAA54,        0xAA55,        0xAA56,
	/* U+7308 */        0xAA57,        0xAA58,        0xE2A5,        0xAA59,        0xAA5A,        0xAA5B,        0xC1D4,        0xAA5C,
	/* U+7310 */        0xAA5D,        0xAA5E,        0xAA5F,        0xE2A3,        0xAA60,        0xE2A8,        0xB2FE,        0xE2A2,
	/* U+7318 */        0xAA61,        0xAA62,        0xAA63,        0xC3CD,        0xB2C2,        0xE2A7,        0xE2A6,        0xAA64,
	/* U+7320 */        0xAA65,        0xE2A4,        0xE2A9,        0xAA66,        0xAA67,        0xE2AB,        0xAA68,        0xAA69,
	/* U+7328 */        0xAA6A,        0xD0C9,        0xD6ED,        0xC3A8,        0xE2AC,        0xAA6B,        0xCFD7,        0xAA6C,
	/* U+7330 */        0xAA6D,        0xE2AE,        0xAA6E,        0xAA6F,        0xBAEF,        0xAA70,        0xAA71,        0xE9E0,
	/* U+7338 */        0xE2AD,        0xE2AA,        0xAA72,        0xAA73,        0xAA74,        0xAA75,        0xBBAB,        0xD4B3,
	/* U+7340 */        0xAA76,        0xAA77,        0xAA78,        0xAA79,        0xAA7A,        0xAA7B,        0xAA7C,        0xAA7D,
	/* U+7348 */        0xAA7E,        0xAA80,        0xAA81,        0xAA82,        0xAA83,        0xE2B0,        0xAA84,        0xAA85,
	/* U+7350 */        0xE2AF,        0xAA86,        0xE9E1,        0xAA87,        0xAA88,        0xAA89,        0xAA8A,        0xE2B1,
	/* U+7358 */        0xAA8B,        0xAA8C,        0xAA8D,        0xAA8E,        0xAA8F,        0xAA90,        0xAA91,        0xAA92,
	/* U+7360 */        0xE2B2,        0xAA93,        0xAA94,        0xAA95,        0xAA96,        0xAA97,        0xAA98,        0xAA99,
	/* U+7368 */        0xAA9A,        0xAA9B,        0xAA9C,        0xAA9D,        0xE2B3,        0xCCA1,        0xAA9E,        0xE2B4,
	/* U+7370 */        0xAA9F,        0xAAA0,        0xAB40,        0xAB41,        0xAB42,        0xAB43,        0xAB44,        0xAB45,
	/* U+7378 */        0xAB46,        0xAB47,        0xAB48,        0xAB49,        0xAB4A,        0xAB4B,        0xE2B5,        0xAB4C,
	/* U+7380 */        0xAB4D,        0xAB4E,        0xAB4F,        0xAB50,        0xD0FE,        0xAB51,        0xAB52,        0xC2CA,
	/* U+7388 */        0xAB53,        0xD3F1,        0xAB54,        0xCDF5,        0xAB55,        0xAB56,        0xE7E0,        0xAB57,
	/* U+7390 */        0xAB58,        0xE7E1,        0xAB59,        0xAB5A,        0xAB5B,        0xAB5C,        0xBEC1,        0xAB5D,
	/* U+7398 */        0xAB5E,        0xAB5F,        0xAB60,        0xC2EA,        0xAB61,        0xAB62,        0xAB63,        0xE7E4,
	/* U+73A0 */        0xAB64,        0xAB65,        0xE7E3,        0xAB66,        0xAB67,        0xAB68,        0xAB69,        0xAB6A,
	/* U+73A8 */        0xAB6B,        0xCDE6,        0xAB6C,        0xC3B5,        0xAB6D,        0xAB6E,        0xE7E2,        0xBBB7,
	/* U+73B0 */        0xCFD6,        0xAB6F,        0xC1E1,        0xE7E9,        0xAB70,        0xAB71,        0xAB72,        0xE7E8,
	/* U+73B8 */        0xAB73,        0xAB74,        0xE7F4,        0xB2A3,        0xAB75,        0xAB76,        0xAB77,        0xAB78,
	/* U+73C0 */        0xE7EA,        0xAB79,        0xE7E6,        0xAB7A,        0xAB7B,        0xAB7C,        0xAB7D,        0xAB7E,
	/* U+73C8 */        0xE7EC,        0xE7EB,        0xC9BA,        0xAB80,        0xAB81,        0xD5E4,        0xAB82,        0xE7E5,
	/* U+73D0 */        0xB7A9,        0xE7E7,        0xAB83,        0xAB84,        0xAB85,        0xAB86,        0xAB87,        0xAB88,
	/* U+73D8 */        0xAB89,        0xE7EE,        0xAB8A,        0xAB8B,        0xAB8C,        0xAB8D,        0xE7F3,        0xAB8E,
	/* U+73E0 */        0xD6E9,        0xAB8F,        0xAB90,        0xAB91,        0xAB92,        0xE7ED,        0xAB93,        0xE7F2,
	/* U+73E8 */        0xAB94,        0xE7F1,        0xAB95,        0xAB96,        0xAB97,        0xB0E0,        0xAB98,        0xAB99,
	/* U+73F0 */        0xAB9A,        0xAB9B,        0xE7F5,        0xAB9C,        0xAB9D,        0xAB9E,        0xAB9F,        0xABA0,
	/* U+73F8 */        0xAC40,        0xAC41,        0xAC42,        0xAC43,        0xAC44,        0xAC45,        0xAC46,        0xAC47,
	/* U+7400 */        0xAC48,        0xAC49,        0xAC4A,        0xC7F2,        0xAC4B,        0xC0C5,        0xC0ED,        0xAC4C,
	/* U+7408 */        0xAC4D,        0xC1F0,        0xE7F0,        0xAC4E,        0xAC4F,        0xAC50,        0xAC51,        0xE7F6,
	/* U+7410 */        0xCBF6,        0xAC52,        0xAC53,        0xAC54,        0xAC55,        0xAC56,        0xAC57,        0xAC58,
	/* U+7418 */        0xAC59,        0xAC5A,        0xE8A2,        0xE8A1,        0xAC5B,        0xAC5C,        0xAC5D,        0xAC5E,
	/* U+7420 */        0xAC5F,        0xAC60,        0xD7C1,        0xAC61,        0xAC62,        0xE7FA,        0xE7F9,        0xAC63,
	/* U+7428 */        0xE7FB,        0xAC64,        0xE7F7,        0xAC65,        0xE7FE,        0xAC66,        0xE7FD,        0xAC67,
	/* U+7430 */        0xE7FC,        0xAC68,        0xAC69,        0xC1D5,        0xC7D9,        0xC5FD,        0xC5C3,        0xAC6A,
	/* U+7438 */        0xAC6B,        0xAC6C,        0xAC6D,        0xAC6E,        0xC7ED,        0xAC6F,        0xAC70,        0xAC71,
	/* U+7440 */        0xAC72,        0xE8A3,        0xAC73,        0xAC74,        0xAC75,        0xAC76,        0xAC77,        0xAC78,
	/* U+7448 */        0xAC79,        0xAC7A,        0xAC7B,        0xAC7C,        0xAC7D,        0xAC7E,        0xAC80,        0xAC81,
	/* U+7450 */        0xAC82,        0xAC83,        0xAC84,        0xAC85,        0xAC86,        0xE8A6,        0xAC87,        0xE8A5,
	/* U+7458 */        0xAC88,        0xE8A7,        0xBAF7,        0xE7F8,        0xE8A4,        0xAC89,        0xC8F0,        0xC9AA,
	/* U+7460 */        0xAC8A,        0xAC8B,        0xAC8C,        0xAC8D,        0xAC8E,        0xAC8F,        0xAC90,        0xAC91,
	/* U+7468 */        0xAC92,        0xAC93,        0xAC94,        0xAC95,        0xAC96,        0xE8A9,        0xAC97,        0xAC98,
	/* U+7470 */        0xB9E5,        0xAC99,        0xAC9A,        0xAC9B,        0xAC9C,        0xAC9D,        0xD1FE,        0xE8A8,
	/* U+7478 */        0xAC9E,        0xAC9F,        0xACA0,        0xAD40,        0xAD41,        0xAD42,        0xE8AA,        0xAD43,
	/* U+7480 */        0xE8AD,        0xE8AE,        0xAD44,        0xC1A7,        0xAD45,        0xAD46,        0xAD47,        0xE8AF,
	/* U+7488 */        0xAD48,        0xAD49,        0xAD4A,        0xE8B0,        0xAD4B,        0xAD4C,        0xE8AC,        0xAD4D,
	/* U+7490 */        0xE8B4,        0xAD4E,        0xAD4F,        0xAD50,        0xAD51,        0xAD52,        0xAD53,        0xAD54,
	/* U+7498 */        0xAD55,        0xAD56,        0xAD57,        0xAD58,        0xE8AB,        0xAD59,        0xE8B1,        0xAD5A,
	/* U+74A0 */        0xAD5B,        0xAD5C,        0xAD5D,        0xAD5E,        0xAD5F,        0xAD60,        0xAD61,        0xE8B5,
	/* U+74A8 */        0xE8B2,        0xE8B3,        0xAD62,        0xAD63,        0xAD64,        0xAD65,        0xAD66,        0xAD67,
	/* U+74B0 */        0xAD68,        0xAD69,        0xAD6A,        0xAD6B,        0xAD6C,        0xAD6D,        0xAD6E,        0xAD6F,
	/* U+74B8 */        0xAD70,        0xAD71,        0xE8B7,        0xAD72,        0xAD73,        0xAD74,        0xAD75,        0xAD76,
	/* U+74C0 */        0xAD77,        0xAD78,        0xAD79,        0xAD7A,        0xAD7B,        0xAD7C,        0xAD7D,        0xAD7E,
	/* U+74C8 */        0xAD80,        0xAD81,        0xAD82,        0xAD83,        0xAD84,        0xAD85,        0xAD86,        0xAD87,
	/* U+74D0 */        0xAD88,        0xAD89,        0xE8B6,        0xAD8A,        0xAD8B,        0xAD8C,        0xAD8D,        0xAD8E,
	/* U+74D8 */        0xAD8F,        0xAD90,        0xAD91,        0xAD92,        0xB9CF,        0xAD93,        0xF0AC,        0xAD94,
	/* U+74E0 */        0xF0AD,        0xAD95,        0xC6B0,        0xB0EA,        0xC8BF,        0xAD96,        0xCDDF,        0xAD97,
	/* U+74E8 */        0xAD98,        0xAD99,        0xAD9A,        0xAD9B,        0xAD9C,        0xAD9D,        0xCECD,        0xEAB1,
	/* U+74F0 */        0xAD9E,        0xAD9F,        0xADA0,        0xAE40,        0xEAB2,        0xAE41,        0xC6BF,        0xB4C9,
	/* U+74F8 */        0xAE42,        0xAE43,        0xAE44,        0xAE45,        0xAE46,        0xAE47,        0xAE48,        0xEAB3,
	/* U+7500 */        0xAE49,        0xAE4A,        0xAE4B,        0xAE4C,        0xD5E7,        0xAE4D,        0xAE4E,        0xAE4F,
	/* U+7508 */        0xAE50,        0xAE51,        0xAE52,        0xAE53,        0xAE54,        0xDDF9,        0xAE55,        0xEAB4,
	/* U+7510 */        0xAE56,        0xEAB5,        0xAE57,        0xEAB6,        0xAE58,        0xAE59,        0xAE5A,        0xAE5B,
	/* U+7518 */        0xB8CA,        0xDFB0,        0xC9F5,        0xAE5C,        0xCCF0,        0xAE5D,        0xAE5E,        0xC9FA,
	/* U+7520 */        0xAE5F,        0xAE60,        0xAE61,        0xAE62,        0xAE63,        0xC9FB,        0xAE64,        0xAE65,
	/* U+7528 */        0xD3C3,        0xCBA6,        0xAE66,        0xB8A6,        0xF0AE,        0xB1C2,        0xAE67,        0xE5B8,
	/* U+7530 */        0xCCEF,        0xD3C9,        0xBCD7,        0xC9EA,        0xAE68,        0xB5E7,        0xAE69,        0xC4D0,
	/* U+7538 */        0xB5E9,        0xAE6A,        0xEEAE,        0xBBAD,        0xAE6B,        0xAE6C,        0xE7DE,        0xAE6D,
	/* U+7540 */        0xEEAF,        0xAE6E,        0xAE6F,        0xAE70,        0xAE71,        0xB3A9,        0xAE72,        0xAE73,
	/* U+7548 */        0xEEB2,        0xAE74,        0xAE75,        0xEEB1,        0xBDE7,        0xAE76,        0xEEB0,        0xCEB7,
	/* U+7550 */        0xAE77,        0xAE78,        0xAE79,        0xAE7A,        0xC5CF,        0xAE7B,        0xAE7C,        0xAE7D,
	/* U+7558 */        0xAE7E,        0xC1F4,        0xDBCE,        0xEEB3,        0xD0F3,        0xAE80,        0xAE81,        0xAE82,
	/* U+7560 */        0xAE83,        0xAE84,        0xAE85,        0xAE86,        0xAE87,        0xC2D4,        0xC6E8,        0xAE88,
	/* U+7568 */        0xAE89,        0xAE8A,        0xB7AC,        0xAE8B,        0xAE8C,        0xAE8D,        0xAE8E,        0xAE8F,
	/* U+7570 */        0xAE90,        0xAE91,        0xEEB4,        0xAE92,        0xB3EB,        0xAE93,        0xAE94,        0xAE95,
	/* U+7578 */        0xBBFB,        0xEEB5,        0xAE96,        0xAE97,        0xAE98,        0xAE99,        0xAE9A,        0xE7DC,
	/* U+7580 */        0xAE9B,        0xAE9C,        0xAE9D,        0xEEB6,        0xAE9E,        0xAE9F,        0xBDAE,        0xAEA0,
	/* U+7588 */        0xAF40,        0xAF41,        0xAF42,        0xF1E2,        0xAF43,        0xAF44,        0xAF45,        0xCAE8,
	/* U+7590 */        0xAF46,        0xD2C9,        0xF0DA,        0xAF47,        0xF0DB,        0xAF48,        0xF0DC,        0xC1C6,
	/* U+7598 */        0xAF49,        0xB8ED,        0xBECE,        0xAF4A,        0xAF4B,        0xF0DE,        0xAF4C,        0xC5B1,
	/* U+75A0 */        0xF0DD,        0xD1F1,        0xAF4D,        0xF0E0,        0xB0CC,        0xBDEA,        0xAF4E,        0xAF4F,
	/* U+75A8 */        0xAF50,        0xAF51,        0xAF52,        0xD2DF,        0xF0DF,        0xAF53,        0xB4AF,        0xB7E8,
	/* U+75B0 */        0xF0E6,        0xF0E5,        0xC6A3,        0xF0E1,        0xF0E2,        0xB4C3,        0xAF54,        0xAF55,
	/* U+75B8 */        0xF0E3,        0xD5EE,        0xAF56,        0xAF57,        0xCCDB,        0xBED2,        0xBCB2,        0xAF58,
	/* U+75C0 */        0xAF59,        0xAF5A,        0xF0E8,        0xF0E7,        0xF0E4,        0xB2A1,        0xAF5B,        0xD6A2,
	/* U+75C8 */        0xD3B8,        0xBEB7,        0xC8AC,        0xAF5C,        0xAF5D,        0xF0EA,        0xAF5E,        0xAF5F,
	/* U+75D0 */        0xAF60,        0xAF61,        0xD1F7,        0xAF62,        0xD6CC,        0xBADB,        0xF0E9,        0xAF63,
	/* U+75D8 */        0xB6BB,        0xAF64,        0xAF65,        0xCDB4,        0xAF66,        0xAF67,        0xC6A6,        0xAF68,
	/* U+75E0 */        0xAF69,        0xAF6A,        0xC1A1,        0xF0EB,        0xF0EE,        0xAF6B,        0xF0ED,        0xF0F0,
	/* U+75E8 */        0xF0EC,        0xAF6C,        0xBBBE,        0xF0EF,        0xAF6D,        0xAF6E,        0xAF6F,        0xAF70,
	/* U+75F0 */        0xCCB5,        0xF0F2,        0xAF71,        0xAF72,        0xB3D5,        0xAF73,        0xAF74,        0xAF75,
	/* U+75F8 */        0xAF76,        0xB1D4,        0xAF77,        0xAF78,        0xF0F3,        0xAF79,        0xAF7A,        0xF0F4,
	/* U+7600 */        0xF0F6,        0xB4E1,        0xAF7B,        0xF0F1,        0xAF7C,        0xF0F7,        0xAF7D,        0xAF7E,
	/* U+7608 */        0xAF80,        0xAF81,        0xF0FA,        0xAF82,        0xF0F8,        0xAF83,        0xAF84,        0xAF85,
	/* U+7610 */        0xF0F5,        0xAF86,        0xAF87,        0xAF88,        0xAF89,        0xF0FD,        0xAF8A,        0xF0F9,
	/* U+7618 */        0xF0FC,        0xF0FE,        0xAF8B,        0xF1A1,        0xAF8C,        0xAF8D,        0xAF8E,        0xCEC1,
	/* U+7620 */        0xF1A4,        0xAF8F,        0xF1A3,        0xAF90,        0xC1F6,        0xF0FB,        0xCADD,        0xAF91,
	/* U+7628 */        0xAF92,        0xB4F1,        0xB1F1,        0xCCB1,        0xAF93,        0xF1A6,        0xAF94,        0xAF95,
	/* U+7630 */        0xF1A7,        0xAF96,        0xAF97,        0xF1AC,        0xD5CE,        0xF1A9,        0xAF98,        0xAF99,
	/* U+7638 */        0xC8B3,        0xAF9A,        0xAF9B,        0xAF9C,        0xF1A2,        0xAF9D,        0xF1AB,        0xF1A8,
	/* U+7640 */        0xF1A5,        0xAF9E,        0xAF9F,        0xF1AA,        0xAFA0,        0xB040,        0xB041,        0xB042,
	/* U+7648 */        0xB043,        0xB044,        0xB045,        0xB046,        0xB0A9,        0xF1AD,        0xB047,        0xB048,
	/* U+7650 */        0xB049,        0xB04A,        0xB04B,        0xB04C,        0xF1AF,        0xB04D,        0xF1B1,        0xB04E,
	/* U+7658 */        0xB04F,        0xB050,        0xB051,        0xB052,        0xF1B0,        0xB053,        0xF1AE,        0xB054,
	/* U+7660 */        0xB055,        0xB056,        0xB057,        0xD1A2,        0xB058,        0xB059,        0xB05A,        0xB05B,
	/* U+7668 */        0xB05C,        0xB05D,        0xB05E,        0xF1B2,        0xB05F,        0xB060,        0xB061,        0xF1B3,
	/* U+7670 */        0xB062,        0xB063,        0xB064,        0xB065,        0xB066,        0xB067,        0xB068,        0xB069,
	/* U+7678 */        0xB9EF,        0xB06A,        0xB06B,        0xB5C7,        0xB06C,        0xB0D7,        0xB0D9,        0xB06D,
	/* U+7680 */        0xB06E,        0xB06F,        0xD4ED,        0xB070,        0xB5C4,        0xB071,        0xBDD4,        0xBBCA,
	/* U+7688 */        0xF0A7,        0xB072,        0xB073,        0xB8DE,        0xB074,        0xB075,        0xF0A8,        0xB076,
	/* U+7690 */        0xB077,        0xB0A8,        0xB078,        0xF0A9,        0xB079,        0xB07A,        0xCDEE,        0xB07B,
	/* U+7698 */        0xB07C,        0xF0AA,        0xB07D,        0xB07E,        0xB080,        0xB081,        0xB082,        0xB083,
	/* U+76A0 */        0xB084,        0xB085,        0xB086,        0xB087,        0xF0AB,        0xB088,        0xB089,        0xB08A,
	/* U+76A8 */        0xB08B,        0xB08C,        0xB08D,        0xB08E,        0xB08F,        0xB090,        0xC6A4,        0xB091,
	/* U+76B0 */        0xB092,        0xD6E5,        0xF1E4,        0xB093,        0xF1E5,        0xB094,        0xB095,        0xB096,
	/* U+76B8 */        0xB097,        0xB098,        0xB099,        0xB09A,        0xB09B,        0xB09C,        0xB09D,        0xC3F3,
	/* U+76C0 */        0xB09E,        0xB09F,        0xD3DB,        0xB0A0,        0xB140,        0xD6D1,        0xC5E8,        0xB141,
	/* U+76C8 */        0xD3AF,        0xB142,        0xD2E6,        0xB143,        0xB144,        0xEEC1,        0xB0BB,        0xD5B5,
	/* U+76D0 */        0xD1CE,        0xBCE0,        0xBAD0,        0xB145,        0xBFF8,        0xB146,        0xB8C7,        0xB5C1,
	/* U+76D8 */        0xC5CC,        0xB147,        0xB148,        0xCAA2,        0xB149,        0xB14A,        0xB14B,        0xC3CB,
	/* U+76E0 */        0xB14C,        0xB14D,        0xB14E,        0xB14F,        0xB150,        0xEEC2,        0xB151,        0xB152,
	/* U+76E8 */        0xB153,        0xB154,        0xB155,        0xB156,        0xB157,        0xB158,        0xC4BF,        0xB6A2,
	/* U+76F0 */        0xB159,        0xEDEC,        0xC3A4,        0xB15A,        0xD6B1,        0xB15B,        0xB15C,        0xB15D,
	/* U+76F8 */        0xCFE0,        0xEDEF,        0xB15E,        0xB15F,        0xC5CE,        0xB160,        0xB6DC,        0xB161,
	/* U+7700 */        0xB162,        0xCAA1,        0xB163,        0xB164,        0xEDED,        0xB165,        0xB166,        0xEDF0,
	/* U+7708 */        0xEDF1,        0xC3BC,        0xB167,        0xBFB4,        0xB168,        0xEDEE,        0xB169,        0xB16A,
	/* U+7710 */        0xB16B,        0xB16C,        0xB16D,        0xB16E,        0xB16F,        0xB170,        0xB171,        0xB172,
	/* U+7718 */        0xB173,        0xEDF4,        0xEDF2,        0xB174,        0xB175,        0xB176,        0xB177,        0xD5E6,
	/* U+7720 */        0xC3DF,        0xB178,        0xEDF3,        0xB179,        0xB17A,        0xB17B,        0xEDF6,        0xB17C,
	/* U+7728 */        0xD5A3,        0xD1A3,        0xB17D,        0xB17E,        0xB180,        0xEDF5,        0xB181,        0xC3D0,
	/* U+7730 */        0xB182,        0xB183,        0xB184,        0xB185,        0xB186,        0xEDF7,        0xBFF4,        0xBEEC,
	/* U+7738 */        0xEDF8,        0xB187,        0xCCF7,        0xB188,        0xD1DB,        0xB189,        0xB18A,        0xB18B,
	/* U+7740 */        0xD7C5,        0xD5F6,        0xB18C,        0xEDFC,        0xB18D,        0xB18E,        0xB18F,        0xEDFB,
	/* U+7748 */        0xB190,        0xB191,        0xB192,        0xB193,        0xB194,        0xB195,        0xB196,        0xB197,
	/* U+7750 */        0xEDF9,        0xEDFA,        0xB198,        0xB199,        0xB19A,        0xB19B,        0xB19C,        0xB19D,
	/* U+7758 */        0xB19E,        0xB19F,        0xEDFD,        0xBEA6,        0xB1A0,        0xB240,        0xB241,        0xB242,
	/* U+7760 */        0xB243,        0xCBAF,        0xEEA1,        0xB6BD,        0xB244,        0xEEA2,        0xC4C0,        0xB245,
	/* U+7768 */        0xEDFE,        0xB246,        0xB247,        0xBDDE,        0xB2C7,        0xB248,        0xB249,        0xB24A,
	/* U+7770 */        0xB24B,        0xB24C,        0xB24D,        0xB24E,        0xB24F,        0xB250,        0xB251,        0xB252,
	/* U+7778 */        0xB253,        0xB6C3,        0xB254,        0xB255,        0xB256,        0xEEA5,        0xD8BA,        0xEEA3,
	/* U+7780 */        0xEEA6,        0xB257,        0xB258,        0xB259,        0xC3E9,        0xB3F2,        0xB25A,        0xB25B,
	/* U+7788 */        0xB25C,        0xB25D,        0xB25E,        0xB25F,        0xEEA7,        0xEEA4,        0xCFB9,        0xB260,
	/* U+7790 */        0xB261,        0xEEA8,        0xC2F7,        0xB262,        0xB263,        0xB264,        0xB265,        0xB266,
	/* U+7798 */        0xB267,        0xB268,        0xB269,        0xB26A,        0xB26B,        0xB26C,        0xB26D,        0xEEA9,
	/* U+77A0 */        0xEEAA,        0xB26E,        0xDEAB,        0xB26F,        0xB270,        0xC6B3,        0xB271,        0xC7C6,
	/* U+77A8 */        0xB272,        0xD6F5,        0xB5C9,        0xB273,        0xCBB2,        0xB274,        0xB275,        0xB276,
	/* U+77B0 */        0xEEAB,        0xB277,        0xB278,        0xCDAB,        0xB279,        0xEEAC,        0xB27A,        0xB27B,
	/* U+77B8 */        0xB27C,        0xB27D,        0xB27E,        0xD5B0,        0xB280,        0xEEAD,        0xB281,        0xF6C4,
	/* U+77C0 */        0xB282,        0xB283,        0xB284,        0xB285,        0xB286,        0xB287,        0xB288,        0xB289,
	/* U+77C8 */        0xB28A,        0xB28B,        0xB28C,        0xB28D,        0xB28E,        0xDBC7,        0xB28F,        0xB290,
	/* U+77D0 */        0xB291,        0xB292,        0xB293,        0xB294,        0xB295,        0xB296,        0xB297,        0xB4A3,
	/* U+77D8 */        0xB298,        0xB299,        0xB29A,        0xC3AC,        0xF1E6,        0xB29B,        0xB29C,        0xB29D,
	/* U+77E0 */        0xB29E,        0xB29F,        0xCAB8,        0xD2D3,        0xB2A0,        0xD6AA,        0xB340,        0xEFF2,
	/* U+77E8 */        0xB341,        0xBED8,        0xB342,        0xBDC3,        0xEFF3,        0xB6CC,        0xB0AB,        0xB343,
	/* U+77F0 */        0xB344,        0xB345,        0xB346,        0xCAAF,        0xB347,        0xB348,        0xEDB6,        0xB349,
	/* U+77F8 */        0xEDB7,        0xB34A,        0xB34B,        0xB34C,        0xB34D,        0xCEF9,        0xB7AF,        0xBFF3,
	/* U+7800 */        0xEDB8,        0xC2EB,        0xC9B0,        0xB34E,        0xB34F,        0xB350,        0xB351,        0xB352,
	/* U+7808 */        0xB353,        0xEDB9,        0xB354,        0xB355,        0xC6F6,        0xBFB3,        0xB356,        0xB357,
	/* U+7810 */        0xB358,        0xEDBC,        0xC5F8,        0xB359,        0xD1D0,        0xB35A,        0xD7A9,        0xEDBA,
	/* U+7818 */        0xEDBB,        0xB35B,        0xD1E2,        0xB35C,        0xEDBF,        0xEDC0,        0xB35D,        0xEDC4,
	/* U+7820 */        0xB35E,        0xB35F,        0xB360,        0xEDC8,        0xB361,        0xEDC6,        0xEDCE,        0xD5E8,
	/* U+7828 */        0xB362,        0xEDC9,        0xB363,        0xB364,        0xEDC7,        0xEDBE,        0xB365,        0xB366,
	/* U+7830 */        0xC5E9,        0xB367,        0xB368,        0xB369,        0xC6C6,        0xB36A,        0xB36B,        0xC9E9,
	/* U+7838 */        0xD4D2,        0xEDC1,        0xEDC2,        0xEDC3,        0xEDC5,        0xB36C,        0xC0F9,        0xB36D,
	/* U+7840 */        0xB4A1,        0xB36E,        0xB36F,        0xB370,        0xB371,        0xB9E8,        0xB372,        0xEDD0,
	/* U+7848 */        0xB373,        0xB374,        0xB375,        0xB376,        0xEDD1,        0xB377,        0xEDCA,        0xB378,
	/* U+7850 */        0xEDCF,        0xB379,        0xCEF8,        0xB37A,        0xB37B,        0xCBB6,        0xEDCC,        0xEDCD,
	/* U+7858 */        0xB37C,        0xB37D,        0xB37E,        0xB380,        0xB381,        0xCFF5,        0xB382,        0xB383,
	/* U+7860 */        0xB384,        0xB385,        0xB386,        0xB387,        0xB388,        0xB389,        0xB38A,        0xB38B,
	/* U+7868 */        0xB38C,        0xB38D,        0xEDD2,        0xC1F2,        0xD3B2,        0xEDCB,        0xC8B7,        0xB38E,
	/* U+7870 */        0xB38F,        0xB390,        0xB391,        0xB392,        0xB393,        0xB394,        0xB395,        0xBCEF,
	/* U+7878 */        0xB396,        0xB397,        0xB398,        0xB399,        0xC5F0,        0xB39A,        0xB39B,        0xB39C,
	/* U+7880 */        0xB39D,        0xB39E,        0xB39F,        0xB3A0,        0xB440,        0xB441,        0xB442,        0xEDD6,
	/* U+7888 */        0xB443,        0xB5EF,        0xB444,        0xB445,        0xC2B5,        0xB0AD,        0xCBE9,        0xB446,
	/* U+7890 */        0xB447,        0xB1AE,        0xB448,        0xEDD4,        0xB449,        0xB44A,        0xB44B,        0xCDEB,
	/* U+7898 */        0xB5E2,        0xB44C,        0xEDD5,        0xEDD3,        0xEDD7,        0xB44D,        0xB44E,        0xB5FA,
	/* U+78A0 */        0xB44F,        0xEDD8,        0xB450,        0xEDD9,        0xB451,        0xEDDC,        0xB452,        0xB1CC,
	/* U+78A8 */        0xB453,        0xB454,        0xB455,        0xB456,        0xB457,        0xB458,        0xB459,        0xB45A,
	/* U+78B0 */        0xC5F6,        0xBCEE,        0xEDDA,        0xCCBC,        0xB2EA,        0xB45B,        0xB45C,        0xB45D,
	/* U+78B8 */        0xB45E,        0xEDDB,        0xB45F,        0xB460,        0xB461,        0xB462,        0xC4EB,        0xB463,
	/* U+78C0 */        0xB464,        0xB4C5,        0xB465,        0xB466,        0xB467,        0xB0F5,        0xB468,        0xB469,
	/* U+78C8 */        0xB46A,        0xEDDF,        0xC0DA,        0xB4E8,        0xB46B,        0xB46C,        0xB46D,        0xB46E,
	/* U+78D0 */        0xC5CD,        0xB46F,        0xB470,        0xB471,        0xEDDD,        0xBFC4,        0xB472,        0xB473,
	/* U+78D8 */        0xB474,        0xEDDE,        0xB475,        0xB476,        0xB477,        0xB478,        0xB479,        0xB47A,
	/* U+78E0 */        0xB47B,        0xB47C,        0xB47D,        0xB47E,        0xB480,        0xB481,        0xB482,        0xB483,
	/* U+78E8 */        0xC4A5,        0xB484,        0xB485,        0xB486,        0xEDE0,        0xB487,        0xB488,        0xB489,
	/* U+78F0 */        0xB48A,        0xB48B,        0xEDE1,        0xB48C,        0xEDE3,        0xB48D,        0xB48E,        0xC1D7,
	/* U+78F8 */        0xB48F,        0xB490,        0xBBC7,        0xB491,        0xB492,        0xB493,        0xB494,        0xB495,
	/* U+7900 */        0xB496,        0xBDB8,        0xB497,        0xB498,        0xB499,        0xEDE2,        0xB49A,        0xB49B,
	/* U+7908 */        0xB49C,        0xB49D,        0xB49E,        0xB49F,        0xB4A0,        0xB540,        0xB541,        0xB542,
	/* U+7910 */        0xB543,        0xB544,        0xB545,        0xEDE4,        0xB546,        0xB547,        0xB548,        0xB549,
	/* U+7918 */        0xB54A,        0xB54B,        0xB54C,        0xB54D,        0xB54E,        0xB54F,        0xEDE6,        0xB550,
	/* U+7920 */        0xB551,        0xB552,        0xB553,        0xB554,        0xEDE5,        0xB555,        0xB556,        0xB557,
	/* U+7928 */        0xB558,        0xB559,        0xB55A,        0xB55B,        0xB55C,        0xB55D,        0xB55E,        0xB55F,
	/* U+7930 */        0xB560,        0xB561,        0xB562,        0xB563,        0xEDE7,        0xB564,        0xB565,        0xB566,
	/* U+7938 */        0xB567,        0xB568,        0xCABE,        0xECEA,        0xC0F1,        0xB569,        0xC9E7,        0xB56A,
	/* U+7940 */        0xECEB,        0xC6EE,        0xB56B,        0xB56C,        0xB56D,        0xB56E,        0xECEC,        0xB56F,
	/* U+7948 */        0xC6ED,        0xECED,        0xB570,        0xB571,        0xB572,        0xB573,        0xB574,        0xB575,
	/* U+7950 */        0xB576,        0xB577,        0xB578,        0xECF0,        0xB579,        0xB57A,        0xD7E6,        0xECF3,
	/* U+7958 */        0xB57B,        0xB57C,        0xECF1,        0xECEE,        0xECEF,        0xD7A3,        0xC9F1,        0xCBEE,
	/* U+7960 */        0xECF4,        0xB57D,        0xECF2,        0xB57E,        0xB580,        0xCFE9,        0xB581,        0xECF6,
	/* U+7968 */        0xC6B1,        0xB582,        0xB583,        0xB584,        0xB585,        0xBCC0,        0xB586,        0xECF5,
	/* U+7970 */        0xB587,        0xB588,        0xB589,        0xB58A,        0xB58B,        0xB58C,        0xB58D,        0xB5BB,
	/* U+7978 */        0xBBF6,        0xB58E,        0xECF7,        0xB58F,        0xB590,        0xB591,        0xB592,        0xB593,
	/* U+7980 */        0xD9F7,        0xBDFB,        0xB594,        0xB595,        0xC2BB,        0xECF8,        0xB596,        0xB597,
	/* U+7988 */        0xB598,        0xB599,        0xECF9,        0xB59A,        0xB59B,        0xB59C,        0xB59D,        0xB8A3,
	/* U+7990 */        0xB59E,        0xB59F,        0xB5A0,        0xB640,        0xB641,        0xB642,        0xB643,        0xB644,
	/* U+7998 */        0xB645,        0xB646,        0xECFA,        0xB647,        0xB648,        0xB649,        0xB64A,        0xB64B,
	/* U+79A0 */        0xB64C,        0xB64D,        0xB64E,        0xB64F,        0xB650,        0xB651,        0xB652,        0xECFB,
	/* U+79A8 */        0xB653,        0xB654,        0xB655,        0xB656,        0xB657,        0xB658,        0xB659,        0xB65A,
	/* U+79B0 */        0xB65B,        0xB65C,        0xB65D,        0xECFC,        0xB65E,        0xB65F,        0xB660,        0xB661,
	/* U+79B8 */        0xB662,        0xD3ED,        0xD8AE,        0xC0EB,        0xB663,        0xC7DD,        0xBACC,        0xB664,
	/* U+79C0 */        0xD0E3,        0xCBBD,        0xB665,        0xCDBA,        0xB666,        0xB667,        0xB8D1,        0xB668,
	/* U+79C8 */        0xB669,        0xB1FC,        0xB66A,        0xC7EF,        0xB66B,        0xD6D6,        0xB66C,        0xB66D,
	/* U+79D0 */        0xB66E,        0xBFC6,        0xC3EB,        0xB66F,        0xB670,        0xEFF5,        0xB671,        0xB672,
	/* U+79D8 */        0xC3D8,        0xB673,        0xB674,        0xB675,        0xB676,        0xB677,        0xB678,        0xD7E2,
	/* U+79E0 */        0xB679,        0xB67A,        0xB67B,        0xEFF7,        0xB3D3,        0xB67C,        0xC7D8,        0xD1ED,
	/* U+79E8 */        0xB67D,        0xD6C8,        0xB67E,        0xEFF8,        0xB680,        0xEFF6,        0xB681,        0xBBFD,
	/* U+79F0 */        0xB3C6,        0xB682,        0xB683,        0xB684,        0xB685,        0xB686,        0xB687,        0xB688,
	/* U+79F8 */        0xBDD5,        0xB689,        0xB68A,        0xD2C6,        0xB68B,        0xBBE0,        0xB68C,        0xB68D,
	/* U+7A00 */        0xCFA1,        0xB68E,        0xEFFC,        0xEFFB,        0xB68F,        0xB690,        0xEFF9,        0xB691,
	/* U+7A08 */        0xB692,        0xB693,        0xB694,        0xB3CC,        0xB695,        0xC9D4,        0xCBB0,        0xB696,
	/* U+7A10 */        0xB697,        0xB698,        0xB699,        0xB69A,        0xEFFE,        0xB69B,        0xB69C,        0xB0DE,
	/* U+7A18 */        0xB69D,        0xB69E,        0xD6C9,        0xB69F,        0xB6A0,        0xB740,        0xEFFD,        0xB741,
	/* U+7A20 */        0xB3ED,        0xB742,        0xB743,        0xF6D5,        0xB744,        0xB745,        0xB746,        0xB747,
	/* U+7A28 */        0xB748,        0xB749,        0xB74A,        0xB74B,        0xB74C,        0xB74D,        0xB74E,        0xB74F,
	/* U+7A30 */        0xB750,        0xB751,        0xB752,        0xCEC8,        0xB753,        0xB754,        0xB755,        0xF0A2,
	/* U+7A38 */        0xB756,        0xF0A1,        0xB757,        0xB5BE,        0xBCDA,        0xBBFC,        0xB758,        0xB8E5,
	/* U+7A40 */        0xB759,        0xB75A,        0xB75B,        0xB75C,        0xB75D,        0xB75E,        0xC4C2,        0xB75F,
	/* U+7A48 */        0xB760,        0xB761,        0xB762,        0xB763,        0xB764,        0xB765,        0xB766,        0xB767,
	/* U+7A50 */        0xB768,        0xF0A3,        0xB769,        0xB76A,        0xB76B,        0xB76C,        0xB76D,        0xCBEB,
	/* U+7A58 */        0xB76E,        0xB76F,        0xB770,        0xB771,        0xB772,        0xB773,        0xB774,        0xB775,
	/* U+7A60 */        0xB776,        0xB777,        0xB778,        0xB779,        0xB77A,        0xB77B,        0xB77C,        0xB77D,
	/* U+7A68 */        0xB77E,        0xB780,        0xB781,        0xB782,        0xB783,        0xB784,        0xB785,        0xB786,
	/* U+7A70 */        0xF0A6,        0xB787,        0xB788,        0xB789,        0xD1A8,        0xB78A,        0xBEBF,        0xC7EE,
	/* U+7A78 */        0xF1B6,        0xF1B7,        0xBFD5,        0xB78B,        0xB78C,        0xB78D,        0xB78E,        0xB4A9,
	/* U+7A80 */        0xF1B8,        0xCDBB,        0xB78F,        0xC7D4,        0xD5AD,        0xB790,        0xF1B9,        0xB791,
	/* U+7A88 */        0xF1BA,        0xB792,        0xB793,        0xB794,        0xB795,        0xC7CF,        0xB796,        0xB797,
	/* U+7A90 */        0xB798,        0xD2A4,        0xD6CF,        0xB799,        0xB79A,        0xF1BB,        0xBDD1,        0xB4B0,
	/* U+7A98 */        0xBEBD,        0xB79B,        0xB79C,        0xB79D,        0xB4DC,        0xCED1,        0xB79E,        0xBFDF,
	/* U+7AA0 */        0xF1BD,        0xB79F,        0xB7A0,        0xB840,        0xB841,        0xBFFA,        0xF1BC,        0xB842,
	/* U+7AA8 */        0xF1BF,        0xB843,        0xB844,        0xB845,        0xF1BE,        0xF1C0,        0xB846,        0xB847,
	/* U+7AB0 */        0xB848,        0xB849,        0xB84A,        0xF1C1,        0xB84B,        0xB84C,        0xB84D,        0xB84E,
	/* U+7AB8 */        0xB84F,        0xB850,        0xB851,        0xB852,        0xB853,        0xB854,        0xB855,        0xC1FE,
	/* U+7AC0 */        0xB856,        0xB857,        0xB858,        0xB859,        0xB85A,        0xB85B,        0xB85C,        0xB85D,
	/* U+7AC8 */        0xB85E,        0xB85F,        0xB860,        0xC1A2,        0xB861,        0xB862,        0xB863,        0xB864,
	/* U+7AD0 */        0xB865,        0xB866,        0xB867,        0xB868,        0xB869,        0xB86A,        0xCAFA,        0xB86B,
	/* U+7AD8 */        0xB86C,        0xD5BE,        0xB86D,        0xB86E,        0xB86F,        0xB870,        0xBEBA,        0xBEB9,
	/* U+7AE0 */        0xD5C2,        0xB871,        0xB872,        0xBFA2,        0xB873,        0xCDAF,        0xF1B5,        0xB874,
	/* U+7AE8 */        0xB875,        0xB876,        0xB877,        0xB878,        0xB879,        0xBDDF,        0xB87A,        0xB6CB,
	/* U+7AF0 */        0xB87B,        0xB87C,        0xB87D,        0xB87E,        0xB880,        0xB881,        0xB882,        0xB883,
	/* U+7AF8 */        0xB884,        0xD6F1,        0xF3C3,        0xB885,        0xB886,        0xF3C4,        0xB887,        0xB8CD,
	/* U+7B00 */        0xB888,        0xB889,        0xB88A,        0xF3C6,        0xF3C7,        0xB88B,        0xB0CA,        0xB88C,
	/* U+7B08 */        0xF3C5,        0xB88D,        0xF3C9,        0xCBF1,        0xB88E,        0xB88F,        0xB890,        0xF3CB,
	/* U+7B10 */        0xB891,        0xD0A6,        0xB892,        0xB893,        0xB1CA,        0xF3C8,        0xB894,        0xB895,
	/* U+7B18 */        0xB896,        0xF3CF,        0xB897,        0xB5D1,        0xB898,        0xB899,        0xF3D7,        0xB89A,
	/* U+7B20 */        0xF3D2,        0xB89B,        0xB89C,        0xB89D,        0xF3D4,        0xF3D3,        0xB7FB,        0xB89E,
	/* U+7B28 */        0xB1BF,        0xB89F,        0xF3CE,        0xF3CA,        0xB5DA,        0xB8A0,        0xF3D0,        0xB940,
	/* U+7B30 */        0xB941,        0xF3D1,        0xB942,        0xF3D5,        0xB943,        0xB944,        0xB945,        0xB946,
	/* U+7B38 */        0xF3CD,        0xB947,        0xBCE3,        0xB948,        0xC1FD,        0xB949,        0xF3D6,        0xB94A,
	/* U+7B40 */        0xB94B,        0xB94C,        0xB94D,        0xB94E,        0xB94F,        0xF3DA,        0xB950,        0xF3CC,
	/* U+7B48 */        0xB951,        0xB5C8,        0xB952,        0xBDEE,        0xF3DC,        0xB953,        0xB954,        0xB7A4,
	/* U+7B50 */        0xBFF0,        0xD6FE,        0xCDB2,        0xB955,        0xB4F0,        0xB956,        0xB2DF,        0xB957,
	/* U+7B58 */        0xF3D8,        0xB958,        0xF3D9,        0xC9B8,        0xB959,        0xF3DD,        0xB95A,        0xB95B,
	/* U+7B60 */        0xF3DE,        0xB95C,        0xF3E1,        0xB95D,        0xB95E,        0xB95F,        0xB960,        0xB961,
	/* U+7B68 */        0xB962,        0xB963,        0xB964,        0xB965,        0xB966,        0xB967,        0xF3DF,        0xB968,
	/* U+7B70 */        0xB969,        0xF3E3,        0xF3E2,        0xB96A,        0xB96B,        0xF3DB,        0xB96C,        0xBFEA,
	/* U+7B78 */        0xB96D,        0xB3EF,        0xB96E,        0xF3E0,        0xB96F,        0xB970,        0xC7A9,        0xB971,
	/* U+7B80 */        0xBCF2,        0xB972,        0xB973,        0xB974,        0xB975,        0xF3EB,        0xB976,        0xB977,
	/* U+7B88 */        0xB978,        0xB979,        0xB97A,        0xB97B,        0xB97C,        0xB9BF,        0xB97D,        0xB97E,
	/* U+7B90 */        0xF3E4,        0xB980,        0xB981,        0xB982,        0xB2AD,        0xBBFE,        0xB983,        0xCBE3,
	/* U+7B98 */        0xB984,        0xB985,        0xB986,        0xB987,        0xF3ED,        0xF3E9,        0xB988,        0xB989,
	/* U+7BA0 */        0xB98A,        0xB9DC,        0xF3EE,        0xB98B,        0xB98C,        0xB98D,        0xF3E5,        0xF3E6,
	/* U+7BA8 */        0xF3EA,        0xC2E1,        0xF3EC,        0xF3EF,        0xF3E8,        0xBCFD,        0xB98E,        0xB98F,
	/* U+7BB0 */        0xB990,        0xCFE4,        0xB991,        0xB992,        0xF3F0,        0xB993,        0xB994,        0xB995,
	/* U+7BB8 */        0xF3E7,        0xB996,        0xB997,        0xB998,        0xB999,        0xB99A,        0xB99B,        0xB99C,
	/* U+7BC0 */        0xB99D,        0xF3F2,        0xB99E,        0xB99F,        0xB9A0,        0xBA40,        0xD7AD,        0xC6AA,
	/* U+7BC8 */        0xBA41,        0xBA42,        0xBA43,        0xBA44,        0xF3F3,        0xBA45,        0xBA46,        0xBA47,
	/* U+7BD0 */        0xBA48,        0xF3F1,        0xBA49,        0xC2A8,        0xBA4A,        0xBA4B,        0xBA4C,        0xBA4D,
	/* U+7BD8 */        0xBA4E,        0xB8DD,        0xF3F5,        0xBA4F,        0xBA50,        0xF3F4,        0xBA51,        0xBA52,
	/* U+7BE0 */        0xBA53,        0xB4DB,        0xBA54,        0xBA55,        0xBA56,        0xF3F6,        0xF3F7,        0xBA57,
	/* U+7BE8 */        0xBA58,        0xBA59,        0xF3F8,        0xBA5A,        0xBA5B,        0xBA5C,        0xC0BA,        0xBA5D,
	/* U+7BF0 */        0xBA5E,        0xC0E9,        0xBA5F,        0xBA60,        0xBA61,        0xBA62,        0xBA63,        0xC5F1,
	/* U+7BF8 */        0xBA64,        0xBA65,        0xBA66,        0xBA67,        0xF3FB,        0xBA68,        0xF3FA,        0xBA69,
	/* U+7C00 */        0xBA6A,        0xBA6B,        0xBA6C,        0xBA6D,        0xBA6E,        0xBA6F,        0xBA70,        0xB4D8,
	/* U+7C08 */        0xBA71,        0xBA72,        0xBA73,        0xF3FE,        0xF3F9,        0xBA74,        0xBA75,        0xF3FC,
	/* U+7C10 */        0xBA76,        0xBA77,        0xBA78,        0xBA79,        0xBA7A,        0xBA7B,        0xF3FD,        0xBA7C,
	/* U+7C18 */        0xBA7D,        0xBA7E,        0xBA80,        0xBA81,        0xBA82,        0xBA83,        0xBA84,        0xF4A1,
	/* U+7C20 */        0xBA85,        0xBA86,        0xBA87,        0xBA88,        0xBA89,        0xBA8A,        0xF4A3,        0xBBC9,
	/* U+7C28 */        0xBA8B,        0xBA8C,        0xF4A2,        0xBA8D,        0xBA8E,        0xBA8F,        0xBA90,        0xBA91,
	/* U+7C30 */        0xBA92,        0xBA93,        0xBA94,        0xBA95,        0xBA96,        0xBA97,        0xBA98,        0xBA99,
	/* U+7C38 */        0xF4A4,        0xBA9A,        0xBA9B,        0xBA9C,        0xBA9D,        0xBA9E,        0xBA9F,        0xB2BE,
	/* U+7C40 */        0xF4A6,        0xF4A5,        0xBAA0,        0xBB40,        0xBB41,        0xBB42,        0xBB43,        0xBB44,
	/* U+7C48 */        0xBB45,        0xBB46,        0xBB47,        0xBB48,        0xBB49,        0xBCAE,        0xBB4A,        0xBB4B,
	/* U+7C50 */        0xBB4C,        0xBB4D,        0xBB4E,        0xBB4F,        0xBB50,        0xBB51,        0xBB52,        0xBB53,
	/* U+7C58 */        0xBB54,        0xBB55,        0xBB56,        0xBB57,        0xBB58,        0xBB59,        0xBB5A,        0xBB5B,
	/* U+7C60 */        0xBB5C,        0xBB5D,        0xBB5E,        0xBB5F,        0xBB60,        0xBB61,        0xBB62,        0xBB63,
	/* U+7C68 */        0xBB64,        0xBB65,        0xBB66,        0xBB67,        0xBB68,        0xBB69,        0xBB6A,        0xBB6B,
	/* U+7C70 */        0xBB6C,        0xBB6D,        0xBB6E,        0xC3D7,        0xD9E1,        0xBB6F,        0xBB70,        0xBB71,
	/* U+7C78 */        0xBB72,        0xBB73,        0xBB74,        0xC0E0,        0xF4CC,        0xD7D1,        0xBB75,        0xBB76,
	/* U+7C80 */        0xBB77,        0xBB78,        0xBB79,        0xBB7A,        0xBB7B,        0xBB7C,        0xBB7D,        0xBB7E,
	/* U+7C88 */        0xBB80,        0xB7DB,        0xBB81,        0xBB82,        0xBB83,        0xBB84,        0xBB85,        0xBB86,
	/* U+7C90 */        0xBB87,        0xF4CE,        0xC1A3,        0xBB88,        0xBB89,        0xC6C9,        0xBB8A,        0xB4D6,
	/* U+7C98 */        0xD5B3,        0xBB8B,        0xBB8C,        0xBB8D,        0xF4D0,        0xF4CF,        0xF4D1,        0xCBDA,
	/* U+7CA0 */        0xBB8E,        0xBB8F,        0xF4D2,        0xBB90,        0xD4C1,        0xD6E0,        0xBB91,        0xBB92,
	/* U+7CA8 */        0xBB93,        0xBB94,        0xB7E0,        0xBB95,        0xBB96,        0xBB97,        0xC1B8,        0xBB98,
	/* U+7CB0 */        0xBB99,        0xC1BB,        0xF4D3,        0xBEAC,        0xBB9A,        0xBB9B,        0xBB9C,        0xBB9D,
	/* U+7CB8 */        0xBB9E,        0xB4E2,        0xBB9F,        0xBBA0,        0xF4D4,        0xF4D5,        0xBEAB,        0xBC40,
	/* U+7CC0 */        0xBC41,        0xF4D6,        0xBC42,        0xBC43,        0xBC44,        0xF4DB,        0xBC45,        0xF4D7,
	/* U+7CC8 */        0xF4DA,        0xBC46,        0xBAFD,        0xBC47,        0xF4D8,        0xF4D9,        0xBC48,        0xBC49,
	/* U+7CD0 */        0xBC4A,        0xBC4B,        0xBC4C,        0xBC4D,        0xBC4E,        0xB8E2,        0xCCC7,        0xF4DC,
	/* U+7CD8 */        0xBC4F,        0xB2DA,        0xBC50,        0xBC51,        0xC3D3,        0xBC52,        0xBC53,        0xD4E3,
	/* U+7CE0 */        0xBFB7,        0xBC54,        0xBC55,        0xBC56,        0xBC57,        0xBC58,        0xBC59,        0xBC5A,
	/* U+7CE8 */        0xF4DD,        0xBC5B,        0xBC5C,        0xBC5D,        0xBC5E,        0xBC5F,        0xBC60,        0xC5B4,
	/* U+7CF0 */        0xBC61,        0xBC62,        0xBC63,        0xBC64,        0xBC65,        0xBC66,        0xBC67,        0xBC68,
	/* U+7CF8 */        0xF4E9,        0xBC69,        0xBC6A,        0xCFB5,        0xBC6B,        0xBC6C,        0xBC6D,        0xBC6E,
	/* U+7D00 */        0xBC6F,        0xBC70,        0xBC71,        0xBC72,        0xBC73,        0xBC74,        0xBC75,        0xBC76,
	/* U+7D08 */        0xBC77,        0xBC78,        0xCEC9,        0xBC79,        0xBC7A,        0xBC7B,        0xBC7C,        0xBC7D,
	/* U+7D10 */        0xBC7E,        0xBC80,        0xBC81,        0xBC82,        0xBC83,        0xBC84,        0xBC85,        0xBC86,
	/* U+7D18 */        0xBC87,        0xBC88,        0xBC89,        0xBC8A,        0xBC8B,        0xBC8C,        0xBC8D,        0xBC8E,
	/* U+7D20 */        0xCBD8,        0xBC8F,        0xCBF7,        0xBC90,        0xBC91,        0xBC92,        0xBC93,        0xBDF4,
	/* U+7D28 */        0xBC94,        0xBC95,        0xBC96,        0xD7CF,        0xBC97,        0xBC98,        0xBC99,        0xC0DB,
	/* U+7D30 */        0xBC9A,        0xBC9B,        0xBC9C,        0xBC9D,        0xBC9E,        0xBC9F,        0xBCA0,        0xBD40,
	/* U+7D38 */        0xBD41,        0xBD42,        0xBD43,        0xBD44,        0xBD45,        0xBD46,        0xBD47,        0xBD48,
	/* U+7D40 */        0xBD49,        0xBD4A,        0xBD4B,        0xBD4C,        0xBD4D,        0xBD4E,        0xBD4F,        0xBD50,
	/* U+7D48 */        0xBD51,        0xBD52,        0xBD53,        0xBD54,        0xBD55,        0xBD56,        0xBD57,        0xBD58,
	/* U+7D50 */        0xBD59,        0xBD5A,        0xBD5B,        0xBD5C,        0xBD5D,        0xBD5E,        0xBD5F,        0xBD60,
	/* U+7D58 */        0xBD61,        0xBD62,        0xBD63,        0xBD64,        0xBD65,        0xBD66,        0xBD67,        0xBD68,
	/* U+7D60 */        0xBD69,        0xBD6A,        0xBD6B,        0xBD6C,        0xBD6D,        0xBD6E,        0xBD6F,        0xBD70,
	/* U+7D68 */        0xBD71,        0xBD72,        0xBD73,        0xBD74,        0xBD75,        0xBD76,        0xD0F5,        0xBD77,
	/* U+7D70 */        0xBD78,        0xBD79,        0xBD7A,        0xBD7B,        0xBD7C,        0xBD7D,        0xBD7E,        0xF4EA,
	/* U+7D78 */        0xBD80,        0xBD81,        0xBD82,        0xBD83,        0xBD84,        0xBD85,        0xBD86,        0xBD87,
	/* U+7D80 */        0xBD88,        0xBD89,        0xBD8A,        0xBD8B,        0xBD8C,        0xBD8D,        0xBD8E,        0xBD8F,
	/* U+7D88 */        0xBD90,        0xBD91,        0xBD92,        0xBD93,        0xBD94,        0xBD95,        0xBD96,        0xBD97,
	/* U+7D90 */        0xBD98,        0xBD99,        0xBD9A,        0xBD9B,        0xBD9C,        0xBD9D,        0xBD9E,        0xBD9F,
	/* U+7D98 */        0xBDA0,        0xBE40,        0xBE41,        0xBE42,        0xBE43,        0xBE44,        0xBE45,        0xBE46,
	/* U+7DA0 */        0xBE47,        0xBE48,        0xBE49,        0xBE4A,        0xBE4B,        0xBE4C,        0xF4EB,        0xBE4D,
	/* U+7DA8 */        0xBE4E,        0xBE4F,        0xBE50,        0xBE51,        0xBE52,        0xBE53,        0xF4EC,        0xBE54,
	/* U+7DB0 */        0xBE55,        0xBE56,        0xBE57,        0xBE58,        0xBE59,        0xBE5A,        0xBE5B,        0xBE5C,
	/* U+7DB8 */        0xBE5D,        0xBE5E,        0xBE5F,        0xBE60,        0xBE61,        0xBE62,        0xBE63,        0xBE64,
	/* U+7DC0 */        0xBE65,        0xBE66,        0xBE67,        0xBE68,        0xBE69,        0xBE6A,        0xBE6B,        0xBE6C,
	/* U+7DC8 */        0xBE6D,        0xBE6E,        0xBE6F,        0xBE70,        0xBE71,        0xBE72,        0xBE73,        0xBE74,
	/* U+7DD0 */        0xBE75,        0xBE76,        0xBE77,        0xBE78,        0xBE79,        0xBE7A,        0xBE7B,        0xBE7C,
	/* U+7DD8 */        0xBE7D,        0xBE7E,        0xBE80,        0xBE81,        0xBE82,        0xBE83,        0xBE84,        0xBE85,
	/* U+7DE0 */        0xBE86,        0xBE87,        0xBE88,        0xBE89,        0xBE8A,        0xBE8B,        0xBE8C,        0xBE8D,
	/* U+7DE8 */        0xBE8E,        0xBE8F,        0xBE90,        0xBE91,        0xBE92,        0xBE93,        0xBE94,        0xBE95,
	/* U+7DF0 */        0xBE96,        0xBE97,        0xBE98,        0xBE99,        0xBE9A,        0xBE9B,        0xBE9C,        0xBE9D,
	/* U+7DF8 */        0xBE9E,        0xBE9F,        0xBEA0,        0xBF40,        0xBF41,        0xBF42,        0xBF43,        0xBF44,
	/* U+7E00 */        0xBF45,        0xBF46,        0xBF47,        0xBF48,        0xBF49,        0xBF4A,        0xBF4B,        0xBF4C,
	/* U+7E08 */        0xBF4D,        0xBF4E,        0xBF4F,        0xBF50,        0xBF51,        0xBF52,        0xBF53,        0xBF54,
	/* U+7E10 */        0xBF55,        0xBF56,        0xBF57,        0xBF58,        0xBF59,        0xBF5A,        0xBF5B,        0xBF5C,
	/* U+7E18 */        0xBF5D,        0xBF5E,        0xBF5F,        0xBF60,        0xBF61,        0xBF62,        0xBF63,        0xBF64,
	/* U+7E20 */        0xBF65,        0xBF66,        0xBF67,        0xBF68,        0xBF69,        0xBF6A,        0xBF6B,        0xBF6C,
	/* U+7E28 */        0xBF6D,        0xBF6E,        0xBF6F,        0xBF70,        0xBF71,        0xBF72,        0xBF73,        0xBF74,
	/* U+7E30 */        0xBF75,        0xBF76,        0xBF77,        0xBF78,        0xBF79,        0xBF7A,        0xBF7B,        0xBF7C,
	/* U+7E38 */        0xBF7D,        0xBF7E,        0xBF80,        0xF7E3,        0xBF81,        0xBF82,        0xBF83,        0xBF84,
	/* U+7E40 */        0xBF85,        0xB7B1,        0xBF86,        0xBF87,        0xBF88,        0xBF89,        0xBF8A,        0xF4ED,
	/* U+7E48 */        0xBF8B,        0xBF8C,        0xBF8D,        0xBF8E,        0xBF8F,        0xBF90,        0xBF91,        0xBF92,
	/* U+7E50 */        0xBF93,        0xBF94,        0xBF95,        0xBF96,        0xBF97,        0xBF98,        0xBF99,        0xBF9A,
	/* U+7E58 */        0xBF9B,        0xBF9C,        0xBF9D,        0xBF9E,        0xBF9F,        0xBFA0,        0xC040,        0xC041,
	/* U+7E60 */        0xC042,        0xC043,        0xC044,        0xC045,        0xC046,        0xC047,        0xC048,        0xC049,
	/* U+7E68 */        0xC04A,        0xC04B,        0xC04C,        0xC04D,        0xC04E,        0xC04F,        0xC050,        0xC051,
	/* U+7E70 */        0xC052,        0xC053,        0xC054,        0xC055,        0xC056,        0xC057,        0xC058,        0xC059,
	/* U+7E78 */        0xC05A,        0xC05B,        0xC05C,        0xC05D,        0xC05E,        0xC05F,        0xC060,        0xC061,
	/* U+7E80 */        0xC062,        0xC063,        0xD7EB,        0xC064,        0xC065,        0xC066,        0xC067,        0xC068,
	/* U+7E88 */        0xC069,        0xC06A,        0xC06B,        0xC06C,        0xC06D,        0xC06E,        0xC06F,        0xC070,
	/* U+7E90 */        0xC071,        0xC072,        0xC073,        0xC074,        0xC075,        0xC076,        0xC077,        0xC078,
	/* U+7E98 */        0xC079,        0xC07A,        0xC07B,        0xF4EE,        0xC07C,        0xC07D,        0xC07E,        0xE6F9,
	/* U+7EA0 */        0xBEC0,        0xE6FA,        0xBAEC,        0xE6FB,        0xCFCB,        0xE6FC,        0xD4BC,        0xBCB6,
	/* U+7EA8 */        0xE6FD,        0xE6FE,        0xBCCD,        0xC8D2,        0xCEB3,        0xE7A1,        0xC080,        0xB4BF,
	/* U+7EB0 */        0xE7A2,        0xC9B4,        0xB8D9,        0xC4C9,        0xC081,        0xD7DD,        0xC2DA,        0xB7D7,
	/* U+7EB8 */        0xD6BD,        0xCEC6,        0xB7C4,        0xC082,        0xC083,        0xC5A6,        0xE7A3,        0xCFDF,
	/* U+7EC0 */        0xE7A4,        0xE7A5,        0xE7A6,        0xC1B7,        0xD7E9,        0xC9F0,        0xCFB8,        0xD6AF,
	/* U+7EC8 */        0xD6D5,        0xE7A7,        0xB0ED,        0xE7A8,        0xE7A9,        0xC9DC,        0xD2EF,        0xBEAD,
	/* U+7ED0 */        0xE7AA,        0xB0F3,        0xC8DE,        0xBDE1,        0xE7AB,        0xC8C6,        0xC084,        0xE7AC,
	/* U+7ED8 */        0xBBE6,        0xB8F8,        0xD1A4,        0xE7AD,        0xC2E7,        0xBEF8,        0xBDCA,        0xCDB3,
	/* U+7EE0 */        0xE7AE,        0xE7AF,        0xBEEE,        0xD0E5,        0xC085,        0xCBE7,        0xCCD0,        0xBCCC,
	/* U+7EE8 */        0xE7B0,        0xBCA8,        0xD0F7,        0xE7B1,        0xC086,        0xD0F8,        0xE7B2,        0xE7B3,
	/* U+7EF0 */        0xB4C2,        0xE7B4,        0xE7B5,        0xC9FE,        0xCEAC,        0xC3E0,        0xE7B7,        0xB1C1,
	/* U+7EF8 */        0xB3F1,        0xC087,        0xE7B8,        0xE7B9,        0xD7DB,        0xD5C0,        0xE7BA,        0xC2CC,
	/* U+7F00 */        0xD7BA,        0xE7BB,        0xE7BC,        0xE7BD,        0xBCEA,        0xC3E5,        0xC0C2,        0xE7BE,
	/* U+7F08 */        0xE7BF,        0xBCA9,        0xC088,        0xE7C0,        0xE7C1,        0xE7B6,        0xB6D0,        0xE7C2,
	/* U+7F10 */        0xC089,        0xE7C3,        0xE7C4,        0xBBBA,        0xB5DE,        0xC2C6,        0xB1E0,        0xE7C5,
	/* U+7F18 */        0xD4B5,        0xE7C6,        0xB8BF,        0xE7C8,        0xE7C7,        0xB7EC,        0xC08A,        0xE7C9,
	/* U+7F20 */        0xB2F8,        0xE7CA,        0xE7CB,        0xE7CC,        0xE7CD,        0xE7CE,        0xE7CF,        0xE7D0,
	/* U+7F28 */        0xD3A7,        0xCBF5,        0xE7D1,        0xE7D2,        0xE7D3,        0xE7D4,        0xC9C9,        0xE7D5,
	/* U+7F30 */        0xE7D6,        0xE7D7,        0xE7D8,        0xE7D9,        0xBDC9,        0xE7DA,        0xF3BE,        0xC08B,
	/* U+7F38 */        0xB8D7,        0xC08C,        0xC8B1,        0xC08D,        0xC08E,        0xC08F,        0xC090,        0xC091,
	/* U+7F40 */        0xC092,        0xC093,        0xF3BF,        0xC094,        0xF3C0,        0xF3C1,        0xC095,        0xC096,
	/* U+7F48 */        0xC097,        0xC098,        0xC099,        0xC09A,        0xC09B,        0xC09C,        0xC09D,        0xC09E,
	/* U+7F50 */        0xB9DE,        0xCDF8,        0xC09F,        0xC0A0,        0xD8E8,        0xBAB1,        0xC140,        0xC2DE,
	/* U+7F58 */        0xEEB7,        0xC141,        0xB7A3,        0xC142,        0xC143,        0xC144,        0xC145,        0xEEB9,
	/* U+7F60 */        0xC146,        0xEEB8,        0xB0D5,        0xC147,        0xC148,        0xC149,        0xC14A,        0xC14B,
	/* U+7F68 */        0xEEBB,        0xD5D6,        0xD7EF,        0xC14C,        0xC14D,        0xC14E,        0xD6C3,        0xC14F,
	/* U+7F70 */        0xC150,        0xEEBD,        0xCAF0,        0xC151,        0xEEBC,        0xC152,        0xC153,        0xC154,
	/* U+7F78 */        0xC155,        0xEEBE,        0xC156,        0xC157,        0xC158,        0xC159,        0xEEC0,        0xC15A,
	/* U+7F80 */        0xC15B,        0xEEBF,        0xC15C,        0xC15D,        0xC15E,        0xC15F,        0xC160,        0xC161,
	/* U+7F88 */        0xC162,        0xC163,        0xD1F2,        0xC164,        0xC7BC,        0xC165,        0xC3C0,        0xC166,
	/* U+7F90 */        0xC167,        0xC168,        0xC169,        0xC16A,        0xB8E1,        0xC16B,        0xC16C,        0xC16D,
	/* U+7F98 */        0xC16E,        0xC16F,        0xC1E7,        0xC170,        0xC171,        0xF4C6,        0xD0DF,        0xF4C7,
	/* U+7FA0 */        0xC172,        0xCFDB,        0xC173,        0xC174,        0xC8BA,        0xC175,        0xC176,        0xF4C8,
	/* U+7FA8 */        0xC177,        0xC178,        0xC179,        0xC17A,        0xC17B,        0xC17C,        0xC17D,        0xF4C9,
	/* U+7FB0 */        0xF4CA,        0xC17E,        0xF4CB,        0xC180,        0xC181,        0xC182,        0xC183,        0xC184,
	/* U+7FB8 */        0xD9FA,        0xB8FE,        0xC185,        0xC186,        0xE5F1,        0xD3F0,        0xC187,        0xF4E0,
	/* U+7FC0 */        0xC188,        0xCECC,        0xC189,        0xC18A,        0xC18B,        0xB3E1,        0xC18C,        0xC18D,
	/* U+7FC8 */        0xC18E,        0xC18F,        0xF1B4,        0xC190,        0xD2EE,        0xC191,        0xF4E1,        0xC192,
	/* U+7FD0 */        0xC193,        0xC194,        0xC195,        0xC196,        0xCFE8,        0xF4E2,        0xC197,        0xC198,
	/* U+7FD8 */        0xC7CC,        0xC199,        0xC19A,        0xC19B,        0xC19C,        0xC19D,        0xC19E,        0xB5D4,
	/* U+7FE0 */        0xB4E4,        0xF4E4,        0xC19F,        0xC1A0,        0xC240,        0xF4E3,        0xF4E5,        0xC241,
	/* U+7FE8 */        0xC242,        0xF4E6,        0xC243,        0xC244,        0xC245,        0xC246,        0xF4E7,        0xC247,
	/* U+7FF0 */        0xBAB2,        0xB0BF,        0xC248,        0xF4E8,        0xC249,        0xC24A,        0xC24B,        0xC24C,
	/* U+7FF8 */        0xC24D,        0xC24E,        0xC24F,        0xB7AD,        0xD2ED,        0xC250,        0xC251,        0xC252,
	/* U+8000 */        0xD2AB,        0xC0CF,        0xC253,        0xBFBC,        0xEBA3,        0xD5DF,        0xEAC8,        0xC254,
	/* U+8008 */        0xC255,        0xC256,        0xC257,        0xF1F3,        0xB6F8,        0xCBA3,        0xC258,        0xC259,
	/* U+8010 */        0xC4CD,        0xC25A,        0xF1E7,        0xC25B,        0xF1E8,        0xB8FB,        0xF1E9,        0xBAC4,
	/* U+8018 */        0xD4C5,        0xB0D2,        0xC25C,        0xC25D,        0xF1EA,        0xC25E,        0xC25F,        0xC260,
	/* U+8020 */        0xF1EB,        0xC261,        0xF1EC,        0xC262,        0xC263,        0xF1ED,        0xF1EE,        0xF1EF,
	/* U+8028 */        0xF1F1,        0xF1F0,        0xC5D5,        0xC264,        0xC265,        0xC266,        0xC267,        0xC268,
	/* U+8030 */        0xC269,        0xF1F2,        0xC26A,        0xB6FA,        0xC26B,        0xF1F4,        0xD2AE,        0xDEC7,
	/* U+8038 */        0xCBCA,        0xC26C,        0xC26D,        0xB3DC,        0xC26E,        0xB5A2,        0xC26F,        0xB9A2,
	/* U+8040 */        0xC270,        0xC271,        0xC4F4,        0xF1F5,        0xC272,        0xC273,        0xF1F6,        0xC274,
	/* U+8048 */        0xC275,        0xC276,        0xC1C4,        0xC1FB,        0xD6B0,        0xF1F7,        0xC277,        0xC278,
	/* U+8050 */        0xC279,        0xC27A,        0xF1F8,        0xC27B,        0xC1AA,        0xC27C,        0xC27D,        0xC27E,
	/* U+8058 */        0xC6B8,        0xC280,        0xBEDB,        0xC281,        0xC282,        0xC283,        0xC284,        0xC285,
	/* U+8060 */        0xC286,        0xC287,        0xC288,        0xC289,        0xC28A,        0xC28B,        0xC28C,        0xC28D,
	/* U+8068 */        0xC28E,        0xF1F9,        0xB4CF,        0xC28F,        0xC290,        0xC291,        0xC292,        0xC293,
	/* U+8070 */        0xC294,        0xF1FA,        0xC295,        0xC296,        0xC297,        0xC298,        0xC299,        0xC29A,
	/* U+8078 */        0xC29B,        0xC29C,        0xC29D,        0xC29E,        0xC29F,        0xC2A0,        0xC340,        0xEDB2,
	/* U+8080 */        0xEDB1,        0xC341,        0xC342,        0xCBE0,        0xD2DE,        0xC343,        0xCBC1,        0xD5D8,
	/* U+8088 */        0xC344,        0xC8E2,        0xC345,        0xC0DF,        0xBCA1,        0xC346,        0xC347,        0xC348,
	/* U+8090 */        0xC349,        0xC34A,        0xC34B,        0xEBC1,        0xC34C,        0xC34D,        0xD0A4,        0xC34E,
	/* U+8098 */        0xD6E2,        0xC34F,        0xB6C7,        0xB8D8,        0xEBC0,        0xB8CE,        0xC350,        0xEBBF,
	/* U+80A0 */        0xB3A6,        0xB9C9,        0xD6AB,        0xC351,        0xB7F4,        0xB7CA,        0xC352,        0xC353,
	/* U+80A8 */        0xC354,        0xBCE7,        0xB7BE,        0xEBC6,        0xC355,        0xEBC7,        0xB0B9,        0xBFCF,
	/* U+80B0 */        0xC356,        0xEBC5,        0xD3FD,        0xC357,        0xEBC8,        0xC358,        0xC359,        0xEBC9,
	/* U+80B8 */        0xC35A,        0xC35B,        0xB7CE,        0xC35C,        0xEBC2,        0xEBC4,        0xC9F6,        0xD6D7,
	/* U+80C0 */        0xD5CD,        0xD0B2,        0xEBCF,        0xCEB8,        0xEBD0,        0xC35D,        0xB5A8,        0xC35E,
	/* U+80C8 */        0xC35F,        0xC360,        0xC361,        0xC362,        0xB1B3,        0xEBD2,        0xCCA5,        0xC363,
	/* U+80D0 */        0xC364,        0xC365,        0xC366,        0xC367,        0xC368,        0xC369,        0xC5D6,        0xEBD3,
	/* U+80D8 */        0xC36A,        0xEBD1,        0xC5DF,        0xEBCE,        0xCAA4,        0xEBD5,        0xB0FB,        0xC36B,
	/* U+80E0 */        0xC36C,        0xBAFA,        0xC36D,        0xC36E,        0xD8B7,        0xF1E3,        0xC36F,        0xEBCA,
	/* U+80E8 */        0xEBCB,        0xEBCC,        0xEBCD,        0xEBD6,        0xE6C0,        0xEBD9,        0xC370,        0xBFE8,
	/* U+80F0 */        0xD2C8,        0xEBD7,        0xEBDC,        0xB8EC,        0xEBD8,        0xC371,        0xBDBA,        0xC372,
	/* U+80F8 */        0xD0D8,        0xC373,        0xB0B7,        0xC374,        0xEBDD,        0xC4DC,        0xC375,        0xC376,
	/* U+8100 */        0xC377,        0xC378,        0xD6AC,        0xC379,        0xC37A,        0xC37B,        0xB4E0,        0xC37C,
	/* U+8108 */        0xC37D,        0xC2F6,        0xBCB9,        0xC37E,        0xC380,        0xEBDA,        0xEBDB,        0xD4E0,
	/* U+8110 */        0xC6EA,        0xC4D4,        0xEBDF,        0xC5A7,        0xD9F5,        0xC381,        0xB2B1,        0xC382,
	/* U+8118 */        0xEBE4,        0xC383,        0xBDC5,        0xC384,        0xC385,        0xC386,        0xEBE2,        0xC387,
	/* U+8120 */        0xC388,        0xC389,        0xC38A,        0xC38B,        0xC38C,        0xC38D,        0xC38E,        0xC38F,
	/* U+8128 */        0xC390,        0xC391,        0xC392,        0xC393,        0xEBE3,        0xC394,        0xC395,        0xB8AC,
	/* U+8130 */        0xC396,        0xCDD1,        0xEBE5,        0xC397,        0xC398,        0xC399,        0xEBE1,        0xC39A,
	/* U+8138 */        0xC1B3,        0xC39B,        0xC39C,        0xC39D,        0xC39E,        0xC39F,        0xC6A2,        0xC3A0,
	/* U+8140 */        0xC440,        0xC441,        0xC442,        0xC443,        0xC444,        0xC445,        0xCCF3,        0xC446,
	/* U+8148 */        0xEBE6,        0xC447,        0xC0B0,        0xD2B8,        0xEBE7,        0xC448,        0xC449,        0xC44A,
	/* U+8150 */        0xB8AF,        0xB8AD,        0xC44B,        0xEBE8,        0xC7BB,        0xCDF3,        0xC44C,        0xC44D,
	/* U+8158 */        0xC44E,        0xEBEA,        0xEBEB,        0xC44F,        0xC450,        0xC451,        0xC452,        0xC453,
	/* U+8160 */        0xEBED,        0xC454,        0xC455,        0xC456,        0xC457,        0xD0C8,        0xC458,        0xEBF2,
	/* U+8168 */        0xC459,        0xEBEE,        0xC45A,        0xC45B,        0xC45C,        0xEBF1,        0xC8F9,        0xC45D,
	/* U+8170 */        0xD1FC,        0xEBEC,        0xC45E,        0xC45F,        0xEBE9,        0xC460,        0xC461,        0xC462,
	/* U+8178 */        0xC463,        0xB8B9,        0xCFD9,        0xC4E5,        0xEBEF,        0xEBF0,        0xCCDA,        0xCDC8,
	/* U+8180 */        0xB0F2,        0xC464,        0xEBF6,        0xC465,        0xC466,        0xC467,        0xC468,        0xC469,
	/* U+8188 */        0xEBF5,        0xC46A,        0xB2B2,        0xC46B,        0xC46C,        0xC46D,        0xC46E,        0xB8E0,
	/* U+8190 */        0xC46F,        0xEBF7,        0xC470,        0xC471,        0xC472,        0xC473,        0xC474,        0xC475,
	/* U+8198 */        0xB1EC,        0xC476,        0xC477,        0xCCC5,        0xC4A4,        0xCFA5,        0xC478,        0xC479,
	/* U+81A0 */        0xC47A,        0xC47B,        0xC47C,        0xEBF9,        0xC47D,        0xC47E,        0xECA2,        0xC480,
	/* U+81A8 */        0xC5F2,        0xC481,        0xEBFA,        0xC482,        0xC483,        0xC484,        0xC485,        0xC486,
	/* U+81B0 */        0xC487,        0xC488,        0xC489,        0xC9C5,        0xC48A,        0xC48B,        0xC48C,        0xC48D,
	/* U+81B8 */        0xC48E,        0xC48F,        0xE2DF,        0xEBFE,        0xC490,        0xC491,        0xC492,        0xC493,
	/* U+81C0 */        0xCDCE,        0xECA1,        0xB1DB,        0xD3B7,        0xC494,        0xC495,        0xD2DC,        0xC496,
	/* U+81C8 */        0xC497,        0xC498,        0xEBFD,        0xC499,        0xEBFB,        0xC49A,        0xC49B,        0xC49C,
	/* U+81D0 */        0xC49D,        0xC49E,        0xC49F,        0xC4A0,        0xC540,        0xC541,        0xC542,        0xC543,
	/* U+81D8 */        0xC544,        0xC545,        0xC546,        0xC547,        0xC548,        0xC549,        0xC54A,        0xC54B,
	/* U+81E0 */        0xC54C,        0xC54D,        0xC54E,        0xB3BC,        0xC54F,        0xC550,        0xC551,        0xEAB0,
	/* U+81E8 */        0xC552,        0xC553,        0xD7D4,        0xC554,        0xF4AB,        0xB3F4,        0xC555,        0xC556,
	/* U+81F0 */        0xC557,        0xC558,        0xC559,        0xD6C1,        0xD6C2,        0xC55A,        0xC55B,        0xC55C,
	/* U+81F8 */        0xC55D,        0xC55E,        0xC55F,        0xD5E9,        0xBECA,        0xC560,        0xF4A7,        0xC561,
	/* U+8200 */        0xD2A8,        0xF4A8,        0xF4A9,        0xC562,        0xF4AA,        0xBECB,        0xD3DF,        0xC563,
	/* U+8208 */        0xC564,        0xC565,        0xC566,        0xC567,        0xC9E0,        0xC9E1,        0xC568,        0xC569,
	/* U+8210 */        0xF3C2,        0xC56A,        0xCAE6,        0xC56B,        0xCCF2,        0xC56C,        0xC56D,        0xC56E,
	/* U+8218 */        0xC56F,        0xC570,        0xC571,        0xE2B6,        0xCBB4,        0xC572,        0xCEE8,        0xD6DB,
	/* U+8220 */        0xC573,        0xF4AD,        0xF4AE,        0xF4AF,        0xC574,        0xC575,        0xC576,        0xC577,
	/* U+8228 */        0xF4B2,        0xC578,        0xBABD,        0xF4B3,        0xB0E3,        0xF4B0,        0xC579,        0xF4B1,
	/* U+8230 */        0xBDA2,        0xB2D5,        0xC57A,        0xF4B6,        0xF4B7,        0xB6E6,        0xB2B0,        0xCFCF,
	/* U+8238 */        0xF4B4,        0xB4AC,        0xC57B,        0xF4B5,        0xC57C,        0xC57D,        0xF4B8,        0xC57E,
	/* U+8240 */        0xC580,        0xC581,        0xC582,        0xC583,        0xF4B9,        0xC584,        0xC585,        0xCDA7,
	/* U+8248 */        0xC586,        0xF4BA,        0xC587,        0xF4BB,        0xC588,        0xC589,        0xC58A,        0xF4BC,
	/* U+8250 */        0xC58B,        0xC58C,        0xC58D,        0xC58E,        0xC58F,        0xC590,        0xC591,        0xC592,
	/* U+8258 */        0xCBD2,        0xC593,        0xF4BD,        0xC594,        0xC595,        0xC596,        0xC597,        0xF4BE,
	/* U+8260 */        0xC598,        0xC599,        0xC59A,        0xC59B,        0xC59C,        0xC59D,        0xC59E,        0xC59F,
	/* U+8268 */        0xF4BF,        0xC5A0,        0xC640,        0xC641,        0xC642,        0xC643,        0xF4DE,        0xC1BC,
	/* U+8270 */        0xBCE8,        0xC644,        0xC9AB,        0xD1DE,        0xE5F5,        0xC645,        0xC646,        0xC647,
	/* U+8278 */        0xC648,        0xDCB3,        0xD2D5,        0xC649,        0xC64A,        0xDCB4,        0xB0AC,        0xDCB5,
	/* U+8280 */        0xC64B,        0xC64C,        0xBDDA,        0xC64D,        0xDCB9,        0xC64E,        0xC64F,        0xC650,
	/* U+8288 */        0xD8C2,        0xC651,        0xDCB7,        0xD3F3,        0xC652,        0xC9D6,        0xDCBA,        0xDCB6,
	/* U+8290 */        0xC653,        0xDCBB,        0xC3A2,        0xC654,        0xC655,        0xC656,        0xC657,        0xDCBC,
	/* U+8298 */        0xDCC5,        0xDCBD,        0xC658,        0xC659,        0xCEDF,        0xD6A5,        0xC65A,        0xDCCF,
	/* U+82A0 */        0xC65B,        0xDCCD,        0xC65C,        0xC65D,        0xDCD2,        0xBDE6,        0xC2AB,        0xC65E,
	/* U+82A8 */        0xDCB8,        0xDCCB,        0xDCCE,        0xDCBE,        0xB7D2,        0xB0C5,        0xDCC7,        0xD0BE,
	/* U+82B0 */        0xDCC1,        0xBBA8,        0xC65F,        0xB7BC,        0xDCCC,        0xC660,        0xC661,        0xDCC6,
	/* U+82B8 */        0xDCBF,        0xC7DB,        0xC662,        0xC663,        0xC664,        0xD1BF,        0xDCC0,        0xC665,
	/* U+82C0 */        0xC666,        0xDCCA,        0xC667,        0xC668,        0xDCD0,        0xC669,        0xC66A,        0xCEAD,
	/* U+82C8 */        0xDCC2,        0xC66B,        0xDCC3,        0xDCC8,        0xDCC9,        0xB2D4,        0xDCD1,        0xCBD5,
	/* U+82D0 */        0xC66C,        0xD4B7,        0xDCDB,        0xDCDF,        0xCCA6,        0xDCE6,        0xC66D,        0xC3E7,
	/* U+82D8 */        0xDCDC,        0xC66E,        0xC66F,        0xBFC1,        0xDCD9,        0xC670,        0xB0FA,        0xB9B6,
	/* U+82E0 */        0xDCE5,        0xDCD3,        0xC671,        0xDCC4,        0xDCD6,        0xC8F4,        0xBFE0,        0xC672,
	/* U+82E8 */        0xC673,        0xC674,        0xC675,        0xC9BB,        0xC676,        0xC677,        0xC678,        0xB1BD,
	/* U+82F0 */        0xC679,        0xD3A2,        0xC67A,        0xC67B,        0xDCDA,        0xC67C,        0xC67D,        0xDCD5,
	/* U+82F8 */        0xC67E,        0xC6BB,        0xC680,        0xDCDE,        0xC681,        0xC682,        0xC683,        0xC684,
	/* U+8300 */        0xC685,        0xD7C2,        0xC3AF,        0xB7B6,        0xC7D1,        0xC3A9,        0xDCE2,        0xDCD8,
	/* U+8308 */        0xDCEB,        0xDCD4,        0xC686,        0xC687,        0xDCDD,        0xC688,        0xBEA5,        0xDCD7,
	/* U+8310 */        0xC689,        0xDCE0,        0xC68A,        0xC68B,        0xDCE3,        0xDCE4,        0xC68C,        0xDCF8,
	/* U+8318 */        0xC68D,        0xC68E,        0xDCE1,        0xDDA2,        0xDCE7,        0xC68F,        0xC690,        0xC691,
	/* U+8320 */        0xC692,        0xC693,        0xC694,        0xC695,        0xC696,        0xC697,        0xC698,        0xBCEB,
	/* U+8328 */        0xB4C4,        0xC699,        0xC69A,        0xC3A3,        0xB2E7,        0xDCFA,        0xC69B,        0xDCF2,
	/* U+8330 */        0xC69C,        0xDCEF,        0xC69D,        0xDCFC,        0xDCEE,        0xD2F0,        0xB2E8,        0xC69E,
	/* U+8338 */        0xC8D7,        0xC8E3,        0xDCFB,        0xC69F,        0xDCED,        0xC6A0,        0xC740,        0xC741,
	/* U+8340 */        0xDCF7,        0xC742,        0xC743,        0xDCF5,        0xC744,        0xC745,        0xBEA3,        0xDCF4,
	/* U+8348 */        0xC746,        0xB2DD,        0xC747,        0xC748,        0xC749,        0xC74A,        0xC74B,        0xDCF3,
	/* U+8350 */        0xBCF6,        0xDCE8,        0xBBC4,        0xC74C,        0xC0F3,        0xC74D,        0xC74E,        0xC74F,
	/* U+8358 */        0xC750,        0xC751,        0xBCD4,        0xDCE9,        0xDCEA,        0xC752,        0xDCF1,        0xDCF6,
	/* U+8360 */        0xDCF9,        0xB5B4,        0xC753,        0xC8D9,        0xBBE7,        0xDCFE,        0xDCFD,        0xD3AB,
	/* U+8368 */        0xDDA1,        0xDDA3,        0xDDA5,        0xD2F1,        0xDDA4,        0xDDA6,        0xDDA7,        0xD2A9,
	/* U+8370 */        0xC754,        0xC755,        0xC756,        0xC757,        0xC758,        0xC759,        0xC75A,        0xBAC9,
	/* U+8378 */        0xDDA9,        0xC75B,        0xC75C,        0xDDB6,        0xDDB1,        0xDDB4,        0xC75D,        0xC75E,
	/* U+8380 */        0xC75F,        0xC760,        0xC761,        0xC762,        0xC763,        0xDDB0,        0xC6CE,        0xC764,
	/* U+8388 */        0xC765,        0xC0F2,        0xC766,        0xC767,        0xC768,        0xC769,        0xC9AF,        0xC76A,
	/* U+8390 */        0xC76B,        0xC76C,        0xDCEC,        0xDDAE,        0xC76D,        0xC76E,        0xC76F,        0xC770,
	/* U+8398 */        0xDDB7,        0xC771,        0xC772,        0xDCF0,        0xDDAF,        0xC773,        0xDDB8,        0xC774,
	/* U+83A0 */        0xDDAC,        0xC775,        0xC776,        0xC777,        0xC778,        0xC779,        0xC77A,        0xC77B,
	/* U+83A8 */        0xDDB9,        0xDDB3,        0xDDAD,        0xC4AA,        0xC77C,        0xC77D,        0xC77E,        0xC780,
	/* U+83B0 */        0xDDA8,        0xC0B3,        0xC1AB,        0xDDAA,        0xDDAB,        0xC781,        0xDDB2,        0xBBF1,
	/* U+83B8 */        0xDDB5,        0xD3A8,        0xDDBA,        0xC782,        0xDDBB,        0xC3A7,        0xC783,        0xC784,
	/* U+83C0 */        0xDDD2,        0xDDBC,        0xC785,        0xC786,        0xC787,        0xDDD1,        0xC788,        0xB9BD,
	/* U+83C8 */        0xC789,        0xC78A,        0xBED5,        0xC78B,        0xBEFA,        0xC78C,        0xC78D,        0xBACA,
	/* U+83D0 */        0xC78E,        0xC78F,        0xC790,        0xC791,        0xDDCA,        0xC792,        0xDDC5,        0xC793,
	/* U+83D8 */        0xDDBF,        0xC794,        0xC795,        0xC796,        0xB2CB,        0xDDC3,        0xC797,        0xDDCB,
	/* U+83E0 */        0xB2A4,        0xDDD5,        0xC798,        0xC799,        0xC79A,        0xDDBE,        0xC79B,        0xC79C,
	/* U+83E8 */        0xC79D,        0xC6D0,        0xDDD0,        0xC79E,        0xC79F,        0xC7A0,        0xC840,        0xC841,
	/* U+83F0 */        0xDDD4,        0xC1E2,        0xB7C6,        0xC842,        0xC843,        0xC844,        0xC845,        0xC846,
	/* U+83F8 */        0xDDCE,        0xDDCF,        0xC847,        0xC848,        0xC849,        0xDDC4,        0xC84A,        0xC84B,
	/* U+8400 */        0xC84C,        0xDDBD,        0xC84D,        0xDDCD,        0xCCD1,        0xC84E,        0xDDC9,        0xC84F,
	/* U+8408 */        0xC850,        0xC851,        0xC852,        0xDDC2,        0xC3C8,        0xC6BC,        0xCEAE,        0xDDCC,
	/* U+8410 */        0xC853,        0xDDC8,        0xC854,        0xC855,        0xC856,        0xC857,        0xC858,        0xC859,
	/* U+8418 */        0xDDC1,        0xC85A,        0xC85B,        0xC85C,        0xDDC6,        0xC2DC,        0xC85D,        0xC85E,
	/* U+8420 */        0xC85F,        0xC860,        0xC861,        0xC862,        0xD3A9,        0xD3AA,        0xDDD3,        0xCFF4,
	/* U+8428 */        0xC8F8,        0xC863,        0xC864,        0xC865,        0xC866,        0xC867,        0xC868,        0xC869,
	/* U+8430 */        0xC86A,        0xDDE6,        0xC86B,        0xC86C,        0xC86D,        0xC86E,        0xC86F,        0xC870,
	/* U+8438 */        0xDDC7,        0xC871,        0xC872,        0xC873,        0xDDE0,        0xC2E4,        0xC874,        0xC875,
	/* U+8440 */        0xC876,        0xC877,        0xC878,        0xC879,        0xC87A,        0xC87B,        0xDDE1,        0xC87C,
	/* U+8448 */        0xC87D,        0xC87E,        0xC880,        0xC881,        0xC882,        0xC883,        0xC884,        0xC885,
	/* U+8450 */        0xC886,        0xDDD7,        0xC887,        0xC888,        0xC889,        0xC88A,        0xC88B,        0xD6F8,
	/* U+8458 */        0xC88C,        0xDDD9,        0xDDD8,        0xB8F0,        0xDDD6,        0xC88D,        0xC88E,        0xC88F,
	/* U+8460 */        0xC890,        0xC6CF,        0xC891,        0xB6AD,        0xC892,        0xC893,        0xC894,        0xC895,
	/* U+8468 */        0xC896,        0xDDE2,        0xC897,        0xBAF9,        0xD4E1,        0xDDE7,        0xC898,        0xC899,
	/* U+8470 */        0xC89A,        0xB4D0,        0xC89B,        0xDDDA,        0xC89C,        0xBFFB,        0xDDE3,        0xC89D,
	/* U+8478 */        0xDDDF,        0xC89E,        0xDDDD,        0xC89F,        0xC8A0,        0xC940,        0xC941,        0xC942,
	/* U+8480 */        0xC943,        0xC944,        0xB5D9,        0xC945,        0xC946,        0xC947,        0xC948,        0xDDDB,
	/* U+8488 */        0xDDDC,        0xDDDE,        0xC949,        0xBDAF,        0xDDE4,        0xC94A,        0xDDE5,        0xC94B,
	/* U+8490 */        0xC94C,        0xC94D,        0xC94E,        0xC94F,        0xC950,        0xC951,        0xC952,        0xDDF5,
	/* U+8498 */        0xC953,        0xC3C9,        0xC954,        0xC955,        0xCBE2,        0xC956,        0xC957,        0xC958,
	/* U+84A0 */        0xC959,        0xDDF2,        0xC95A,        0xC95B,        0xC95C,        0xC95D,        0xC95E,        0xC95F,
	/* U+84A8 */        0xC960,        0xC961,        0xC962,        0xC963,        0xC964,        0xC965,        0xC966,        0xD8E1,
	/* U+84B0 */        0xC967,        0xC968,        0xC6D1,        0xC969,        0xDDF4,        0xC96A,        0xC96B,        0xC96C,
	/* U+84B8 */        0xD5F4,        0xDDF3,        0xDDF0,        0xC96D,        0xC96E,        0xDDEC,        0xC96F,        0xDDEF,
	/* U+84C0 */        0xC970,        0xDDE8,        0xC971,        0xC972,        0xD0EE,        0xC973,        0xC974,        0xC975,
	/* U+84C8 */        0xC976,        0xC8D8,        0xDDEE,        0xC977,        0xC978,        0xDDE9,        0xC979,        0xC97A,
	/* U+84D0 */        0xDDEA,        0xCBF2,        0xC97B,        0xDDED,        0xC97C,        0xC97D,        0xB1CD,        0xC97E,
	/* U+84D8 */        0xC980,        0xC981,        0xC982,        0xC983,        0xC984,        0xC0B6,        0xC985,        0xBCBB,
	/* U+84E0 */        0xDDF1,        0xC986,        0xC987,        0xDDF7,        0xC988,        0xDDF6,        0xDDEB,        0xC989,
	/* U+84E8 */        0xC98A,        0xC98B,        0xC98C,        0xC98D,        0xC5EE,        0xC98E,        0xC98F,        0xC990,
	/* U+84F0 */        0xDDFB,        0xC991,        0xC992,        0xC993,        0xC994,        0xC995,        0xC996,        0xC997,
	/* U+84F8 */        0xC998,        0xC999,        0xC99A,        0xC99B,        0xDEA4,        0xC99C,        0xC99D,        0xDEA3,
	/* U+8500 */        0xC99E,        0xC99F,        0xC9A0,        0xCA40,        0xCA41,        0xCA42,        0xCA43,        0xCA44,
	/* U+8508 */        0xCA45,        0xCA46,        0xCA47,        0xCA48,        0xDDF8,        0xCA49,        0xCA4A,        0xCA4B,
	/* U+8510 */        0xCA4C,        0xC3EF,        0xCA4D,        0xC2FB,        0xCA4E,        0xCA4F,        0xCA50,        0xD5E1,
	/* U+8518 */        0xCA51,        0xCA52,        0xCEB5,        0xCA53,        0xCA54,        0xCA55,        0xCA56,        0xDDFD,
	/* U+8520 */        0xCA57,        0xB2CC,        0xCA58,        0xCA59,        0xCA5A,        0xCA5B,        0xCA5C,        0xCA5D,
	/* U+8528 */        0xCA5E,        0xCA5F,        0xCA60,        0xC4E8,        0xCADF,        0xCA61,        0xCA62,        0xCA63,
	/* U+8530 */        0xCA64,        0xCA65,        0xCA66,        0xCA67,        0xCA68,        0xCA69,        0xCA6A,        0xC7BE,
	/* U+8538 */        0xDDFA,        0xDDFC,        0xDDFE,        0xDEA2,        0xB0AA,        0xB1CE,        0xCA6B,        0xCA6C,
	/* U+8540 */        0xCA6D,        0xCA6E,        0xCA6F,        0xDEAC,        0xCA70,        0xCA71,        0xCA72,        0xCA73,
	/* U+8548 */        0xDEA6,        0xBDB6,        0xC8EF,        0xCA74,        0xCA75,        0xCA76,        0xCA77,        0xCA78,
	/* U+8550 */        0xCA79,        0xCA7A,        0xCA7B,        0xCA7C,        0xCA7D,        0xCA7E,        0xDEA1,        0xCA80,
	/* U+8558 */        0xCA81,        0xDEA5,        0xCA82,        0xCA83,        0xCA84,        0xCA85,        0xDEA9,        0xCA86,
	/* U+8560 */        0xCA87,        0xCA88,        0xCA89,        0xCA8A,        0xDEA8,        0xCA8B,        0xCA8C,        0xCA8D,
	/* U+8568 */        0xDEA7,        0xCA8E,        0xCA8F,        0xCA90,        0xCA91,        0xCA92,        0xCA93,        0xCA94,
	/* U+8570 */        0xCA95,        0xCA96,        0xDEAD,        0xCA97,        0xD4CC,        0xCA98,        0xCA99,        0xCA9A,
	/* U+8578 */        0xCA9B,        0xDEB3,        0xDEAA,        0xDEAE,        0xCA9C,        0xCA9D,        0xC0D9,        0xCA9E,
	/* U+8580 */        0xCA9F,        0xCAA0,        0xCB40,        0xCB41,        0xB1A1,        0xDEB6,        0xCB42,        0xDEB1,
	/* U+8588 */        0xCB43,        0xCB44,        0xCB45,        0xCB46,        0xCB47,        0xCB48,        0xCB49,        0xDEB2,
	/* U+8590 */        0xCB4A,        0xCB4B,        0xCB4C,        0xCB4D,        0xCB4E,        0xCB4F,        0xCB50,        0xCB51,
	/* U+8598 */        0xCB52,        0xCB53,        0xCB54,        0xD1A6,        0xDEB5,        0xCB55,        0xCB56,        0xCB57,
	/* U+85A0 */        0xCB58,        0xCB59,        0xCB5A,        0xCB5B,        0xDEAF,        0xCB5C,        0xCB5D,        0xCB5E,
	/* U+85A8 */        0xDEB0,        0xCB5F,        0xD0BD,        0xCB60,        0xCB61,        0xCB62,        0xDEB4,        0xCAED,
	/* U+85B0 */        0xDEB9,        0xCB63,        0xCB64,        0xCB65,        0xCB66,        0xCB67,        0xCB68,        0xDEB8,
	/* U+85B8 */        0xCB69,        0xDEB7,        0xCB6A,        0xCB6B,        0xCB6C,        0xCB6D,        0xCB6E,        0xCB6F,
	/* U+85C0 */        0xCB70,        0xDEBB,        0xCB71,        0xCB72,        0xCB73,        0xCB74,        0xCB75,        0xCB76,
	/* U+85C8 */        0xCB77,        0xBDE5,        0xCB78,        0xCB79,        0xCB7A,        0xCB7B,        0xCB7C,        0xB2D8,
	/* U+85D0 */        0xC3EA,        0xCB7D,        0xCB7E,        0xDEBA,        0xCB80,        0xC5BA,        0xCB81,        0xCB82,
	/* U+85D8 */        0xCB83,        0xCB84,        0xCB85,        0xCB86,        0xDEBC,        0xCB87,        0xCB88,        0xCB89,
	/* U+85E0 */        0xCB8A,        0xCB8B,        0xCB8C,        0xCB8D,        0xCCD9,        0xCB8E,        0xCB8F,        0xCB90,
	/* U+85E8 */        0xCB91,        0xB7AA,        0xCB92,        0xCB93,        0xCB94,        0xCB95,        0xCB96,        0xCB97,
	/* U+85F0 */        0xCB98,        0xCB99,        0xCB9A,        0xCB9B,        0xCB9C,        0xCB9D,        0xCB9E,        0xCB9F,
	/* U+85F8 */        0xCBA0,        0xCC40,        0xCC41,        0xD4E5,        0xCC42,        0xCC43,        0xCC44,        0xDEBD,
	/* U+8600 */        0xCC45,        0xCC46,        0xCC47,        0xCC48,        0xCC49,        0xDEBF,        0xCC4A,        0xCC4B,
	/* U+8608 */        0xCC4C,        0xCC4D,        0xCC4E,        0xCC4F,        0xCC50,        0xCC51,        0xCC52,        0xCC53,
	/* U+8610 */        0xCC54,        0xC4A2,        0xCC55,        0xCC56,        0xCC57,        0xCC58,        0xDEC1,        0xCC59,
	/* U+8618 */        0xCC5A,        0xCC5B,        0xCC5C,        0xCC5D,        0xCC5E,        0xCC5F,        0xCC60,        0xCC61,
	/* U+8620 */        0xCC62,        0xCC63,        0xCC64,        0xCC65,        0xCC66,        0xCC67,        0xCC68,        0xDEBE,
	/* U+8628 */        0xCC69,        0xDEC0,        0xCC6A,        0xCC6B,        0xCC6C,        0xCC6D,        0xCC6E,        0xCC6F,
	/* U+8630 */        0xCC70,        0xCC71,        0xCC72,        0xCC73,        0xCC74,        0xCC75,        0xCC76,        0xCC77,
	/* U+8638 */        0xD5BA,        0xCC78,        0xCC79,        0xCC7A,        0xDEC2,        0xCC7B,        0xCC7C,        0xCC7D,
	/* U+8640 */        0xCC7E,        0xCC80,        0xCC81,        0xCC82,        0xCC83,        0xCC84,        0xCC85,        0xCC86,
	/* U+8648 */        0xCC87,        0xCC88,        0xCC89,        0xCC8A,        0xCC8B,        0xF2AE,        0xBBA2,        0xC2B2,
	/* U+8650 */        0xC5B0,        0xC2C7,        0xCC8C,        0xCC8D,        0xF2AF,        0xCC8E,        0xCC8F,        0xCC90,
	/* U+8658 */        0xCC91,        0xCC92,        0xD0E9,        0xCC93,        0xCC94,        0xCC95,        0xD3DD,        0xCC96,
	/* U+8660 */        0xCC97,        0xCC98,        0xEBBD,        0xCC99,        0xCC9A,        0xCC9B,        0xCC9C,        0xCC9D,
	/* U+8668 */        0xCC9E,        0xCC9F,        0xCCA0,        0xB3E6,        0xF2B0,        0xCD40,        0xF2B1,        0xCD41,
	/* U+8670 */        0xCD42,        0xCAAD,        0xCD43,        0xCD44,        0xCD45,        0xCD46,        0xCD47,        0xCD48,
	/* U+8678 */        0xCD49,        0xBAE7,        0xF2B3,        0xF2B5,        0xF2B4,        0xCBE4,        0xCFBA,        0xF2B2,
	/* U+8680 */        0xCAB4,        0xD2CF,        0xC2EC,        0xCD4A,        0xCD4B,        0xCD4C,        0xCD4D,        0xCD4E,
	/* U+8688 */        0xCD4F,        0xCD50,        0xCEC3,        0xF2B8,        0xB0F6,        0xF2B7,        0xCD51,        0xCD52,
	/* U+8690 */        0xCD53,        0xCD54,        0xCD55,        0xF2BE,        0xCD56,        0xB2CF,        0xCD57,        0xCD58,
	/* U+8698 */        0xCD59,        0xCD5A,        0xCD5B,        0xCD5C,        0xD1C1,        0xF2BA,        0xCD5D,        0xCD5E,
	/* U+86A0 */        0xCD5F,        0xCD60,        0xCD61,        0xF2BC,        0xD4E9,        0xCD62,        0xCD63,        0xF2BB,
	/* U+86A8 */        0xF2B6,        0xF2BF,        0xF2BD,        0xCD64,        0xF2B9,        0xCD65,        0xCD66,        0xF2C7,
	/* U+86B0 */        0xF2C4,        0xF2C6,        0xCD67,        0xCD68,        0xF2CA,        0xF2C2,        0xF2C0,        0xCD69,
	/* U+86B8 */        0xCD6A,        0xCD6B,        0xF2C5,        0xCD6C,        0xCD6D,        0xCD6E,        0xCD6F,        0xCD70,
	/* U+86C0 */        0xD6FB,        0xCD71,        0xCD72,        0xCD73,        0xF2C1,        0xCD74,        0xC7F9,        0xC9DF,
	/* U+86C8 */        0xCD75,        0xF2C8,        0xB9C6,        0xB5B0,        0xCD76,        0xCD77,        0xF2C3,        0xF2C9,
	/* U+86D0 */        0xF2D0,        0xF2D6,        0xCD78,        0xCD79,        0xBBD7,        0xCD7A,        0xCD7B,        0xCD7C,
	/* U+86D8 */        0xF2D5,        0xCDDC,        0xCD7D,        0xD6EB,        0xCD7E,        0xCD80,        0xF2D2,        0xF2D4,
	/* U+86E0 */        0xCD81,        0xCD82,        0xCD83,        0xCD84,        0xB8F2,        0xCD85,        0xCD86,        0xCD87,
	/* U+86E8 */        0xCD88,        0xF2CB,        0xCD89,        0xCD8A,        0xCD8B,        0xF2CE,        0xC2F9,        0xCD8C,
	/* U+86F0 */        0xD5DD,        0xF2CC,        0xF2CD,        0xF2CF,        0xF2D3,        0xCD8D,        0xCD8E,        0xCD8F,
	/* U+86F8 */        0xF2D9,        0xD3BC,        0xCD90,        0xCD91,        0xCD92,        0xCD93,        0xB6EA,        0xCD94,
	/* U+8700 */        0xCAF1,        0xCD95,        0xB7E4,        0xF2D7,        0xCD96,        0xCD97,        0xCD98,        0xF2D8,
	/* U+8708 */        0xF2DA,        0xF2DD,        0xF2DB,        0xCD99,        0xCD9A,        0xF2DC,        0xCD9B,        0xCD9C,
	/* U+8710 */        0xCD9D,        0xCD9E,        0xD1D1,        0xF2D1,        0xCD9F,        0xCDC9,        0xCDA0,        0xCECF,
	/* U+8718 */        0xD6A9,        0xCE40,        0xF2E3,        0xCE41,        0xC3DB,        0xCE42,        0xF2E0,        0xCE43,
	/* U+8720 */        0xCE44,        0xC0AF,        0xF2EC,        0xF2DE,        0xCE45,        0xF2E1,        0xCE46,        0xCE47,
	/* U+8728 */        0xCE48,        0xF2E8,        0xCE49,        0xCE4A,        0xCE4B,        0xCE4C,        0xF2E2,        0xCE4D,
	/* U+8730 */        0xCE4E,        0xF2E7,        0xCE4F,        0xCE50,        0xF2E6,        0xCE51,        0xCE52,        0xF2E9,
	/* U+8738 */        0xCE53,        0xCE54,        0xCE55,        0xF2DF,        0xCE56,        0xCE57,        0xF2E4,        0xF2EA,
	/* U+8740 */        0xCE58,        0xCE59,        0xCE5A,        0xCE5B,        0xCE5C,        0xCE5D,        0xCE5E,        0xD3AC,
	/* U+8748 */        0xF2E5,        0xB2F5,        0xCE5F,        0xCE60,        0xF2F2,        0xCE61,        0xD0AB,        0xCE62,
	/* U+8750 */        0xCE63,        0xCE64,        0xCE65,        0xF2F5,        0xCE66,        0xCE67,        0xCE68,        0xBBC8,
	/* U+8758 */        0xCE69,        0xF2F9,        0xCE6A,        0xCE6B,        0xCE6C,        0xCE6D,        0xCE6E,        0xCE6F,
	/* U+8760 */        0xF2F0,        0xCE70,        0xCE71,        0xF2F6,        0xF2F8,        0xF2FA,        0xCE72,        0xCE73,
	/* U+8768 */        0xCE74,        0xCE75,        0xCE76,        0xCE77,        0xCE78,        0xCE79,        0xF2F3,        0xCE7A,
	/* U+8770 */        0xF2F1,        0xCE7B,        0xCE7C,        0xCE7D,        0xBAFB,        0xCE7E,        0xB5FB,        0xCE80,
	/* U+8778 */        0xCE81,        0xCE82,        0xCE83,        0xF2EF,        0xF2F7,        0xF2ED,        0xF2EE,        0xCE84,
	/* U+8780 */        0xCE85,        0xCE86,        0xF2EB,        0xF3A6,        0xCE87,        0xF3A3,        0xCE88,        0xCE89,
	/* U+8788 */        0xF3A2,        0xCE8A,        0xCE8B,        0xF2F4,        0xCE8C,        0xC8DA,        0xCE8D,        0xCE8E,
	/* U+8790 */        0xCE8F,        0xCE90,        0xCE91,        0xF2FB,        0xCE92,        0xCE93,        0xCE94,        0xF3A5,
	/* U+8798 */        0xCE95,        0xCE96,        0xCE97,        0xCE98,        0xCE99,        0xCE9A,        0xCE9B,        0xC3F8,
	/* U+87A0 */        0xCE9C,        0xCE9D,        0xCE9E,        0xCE9F,        0xCEA0,        0xCF40,        0xCF41,        0xCF42,
	/* U+87A8 */        0xF2FD,        0xCF43,        0xCF44,        0xF3A7,        0xF3A9,        0xF3A4,        0xCF45,        0xF2FC,
	/* U+87B0 */        0xCF46,        0xCF47,        0xCF48,        0xF3AB,        0xCF49,        0xF3AA,        0xCF4A,        0xCF4B,
	/* U+87B8 */        0xCF4C,        0xCF4D,        0xC2DD,        0xCF4E,        0xCF4F,        0xF3AE,        0xCF50,        0xCF51,
	/* U+87C0 */        0xF3B0,        0xCF52,        0xCF53,        0xCF54,        0xCF55,        0xCF56,        0xF3A1,        0xCF57,
	/* U+87C8 */        0xCF58,        0xCF59,        0xF3B1,        0xF3AC,        0xCF5A,        0xCF5B,        0xCF5C,        0xCF5D,
	/* U+87D0 */        0xCF5E,        0xF3AF,        0xF2FE,        0xF3AD,        0xCF5F,        0xCF60,        0xCF61,        0xCF62,
	/* U+87D8 */        0xCF63,        0xCF64,        0xCF65,        0xF3B2,        0xCF66,        0xCF67,        0xCF68,        0xCF69,
	/* U+87E0 */        0xF3B4,        0xCF6A,        0xCF6B,        0xCF6C,        0xCF6D,        0xF3A8,        0xCF6E,        0xCF6F,
	/* U+87E8 */        0xCF70,        0xCF71,        0xF3B3,        0xCF72,        0xCF73,        0xCF74,        0xF3B5,        0xCF75,
	/* U+87F0 */        0xCF76,        0xCF77,        0xCF78,        0xCF79,        0xCF7A,        0xCF7B,        0xCF7C,        0xCF7D,
	/* U+87F8 */        0xCF7E,        0xD0B7,        0xCF80,        0xCF81,        0xCF82,        0xCF83,        0xF3B8,        0xCF84,
	/* U+8800 */        0xCF85,        0xCF86,        0xCF87,        0xD9F9,        0xCF88,        0xCF89,        0xCF8A,        0xCF8B,
	/* U+8808 */        0xCF8C,        0xCF8D,        0xF3B9,        0xCF8E,        0xCF8F,        0xCF90,        0xCF91,        0xCF92,
	/* U+8810 */        0xCF93,        0xCF94,        0xCF95,        0xF3B7,        0xCF96,        0xC8E4,        0xF3B6,        0xCF97,
	/* U+8818 */        0xCF98,        0xCF99,        0xCF9A,        0xF3BA,        0xCF9B,        0xCF9C,        0xCF9D,        0xCF9E,
	/* U+8820 */        0xCF9F,        0xF3BB,        0xB4C0,        0xCFA0,        0xD040,        0xD041,        0xD042,        0xD043,
	/* U+8828 */        0xD044,        0xD045,        0xD046,        0xD047,        0xD048,        0xD049,        0xD04A,        0xD04B,
	/* U+8830 */        0xD04C,        0xD04D,        0xEEC3,        0xD04E,        0xD04F,        0xD050,        0xD051,        0xD052,
	/* U+8838 */        0xD053,        0xF3BC,        0xD054,        0xD055,        0xF3BD,        0xD056,        0xD057,        0xD058,
	/* U+8840 */        0xD1AA,        0xD059,        0xD05A,        0xD05B,        0xF4AC,        0xD0C6,        0xD05C,        0xD05D,
	/* U+8848 */        0xD05E,        0xD05F,        0xD060,        0xD061,        0xD0D0,        0xD1DC,        0xD062,        0xD063,
	/* U+8850 */        0xD064,        0xD065,        0xD066,        0xD067,        0xCFCE,        0xD068,        0xD069,        0xBDD6,
	/* U+8858 */        0xD06A,        0xD1C3,        0xD06B,        0xD06C,        0xD06D,        0xD06E,        0xD06F,        0xD070,
	/* U+8860 */        0xD071,        0xBAE2,        0xE1E9,        0xD2C2,        0xF1C2,        0xB2B9,        0xD072,        0xD073,
	/* U+8868 */        0xB1ED,        0xF1C3,        0xD074,        0xC9C0,        0xB3C4,        0xD075,        0xD9F2,        0xD076,
	/* U+8870 */        0xCBA5,        0xD077,        0xF1C4,        0xD078,        0xD079,        0xD07A,        0xD07B,        0xD6D4,
	/* U+8878 */        0xD07C,        0xD07D,        0xD07E,        0xD080,        0xD081,        0xF1C5,        0xF4C0,        0xF1C6,
	/* U+8880 */        0xD082,        0xD4AC,        0xF1C7,        0xD083,        0xB0C0,        0xF4C1,        0xD084,        0xD085,
	/* U+8888 */        0xF4C2,        0xD086,        0xD087,        0xB4FC,        0xD088,        0xC5DB,        0xD089,        0xD08A,
	/* U+8890 */        0xD08B,        0xD08C,        0xCCBB,        0xD08D,        0xD08E,        0xD08F,        0xD0E4,        0xD090,
	/* U+8898 */        0xD091,        0xD092,        0xD093,        0xD094,        0xCDE0,        0xD095,        0xD096,        0xD097,
	/* U+88A0 */        0xD098,        0xD099,        0xF1C8,        0xD09A,        0xD9F3,        0xD09B,        0xD09C,        0xD09D,
	/* U+88A8 */        0xD09E,        0xD09F,        0xD0A0,        0xB1BB,        0xD140,        0xCFAE,        0xD141,        0xD142,
	/* U+88B0 */        0xD143,        0xB8A4,        0xD144,        0xD145,        0xD146,        0xD147,        0xD148,        0xF1CA,
	/* U+88B8 */        0xD149,        0xD14A,        0xD14B,        0xD14C,        0xF1CB,        0xD14D,        0xD14E,        0xD14F,
	/* U+88C0 */        0xD150,        0xB2C3,        0xC1D1,        0xD151,        0xD152,        0xD7B0,        0xF1C9,        0xD153,
	/* U+88C8 */        0xD154,        0xF1CC,        0xD155,        0xD156,        0xD157,        0xD158,        0xF1CE,        0xD159,
	/* U+88D0 */        0xD15A,        0xD15B,        0xD9F6,        0xD15C,        0xD2E1,        0xD4A3,        0xD15D,        0xD15E,
	/* U+88D8 */        0xF4C3,        0xC8B9,        0xD15F,        0xD160,        0xD161,        0xD162,        0xD163,        0xF4C4,
	/* U+88E0 */        0xD164,        0xD165,        0xF1CD,        0xF1CF,        0xBFE3,        0xF1D0,        0xD166,        0xD167,
	/* U+88E8 */        0xF1D4,        0xD168,        0xD169,        0xD16A,        0xD16B,        0xD16C,        0xD16D,        0xD16E,
	/* U+88F0 */        0xF1D6,        0xF1D1,        0xD16F,        0xC9D1,        0xC5E1,        0xD170,        0xD171,        0xD172,
	/* U+88F8 */        0xC2E3,        0xB9FC,        0xD173,        0xD174,        0xF1D3,        0xD175,        0xF1D5,        0xD176,
	/* U+8900 */        0xD177,        0xD178,        0xB9D3,        0xD179,        0xD17A,        0xD17B,        0xD17C,        0xD17D,
	/* U+8908 */        0xD17E,        0xD180,        0xF1DB,        0xD181,        0xD182,        0xD183,        0xD184,        0xD185,
	/* U+8910 */        0xBAD6,        0xD186,        0xB0FD,        0xF1D9,        0xD187,        0xD188,        0xD189,        0xD18A,
	/* U+8918 */        0xD18B,        0xF1D8,        0xF1D2,        0xF1DA,        0xD18C,        0xD18D,        0xD18E,        0xD18F,
	/* U+8920 */        0xD190,        0xF1D7,        0xD191,        0xD192,        0xD193,        0xC8EC,        0xD194,        0xD195,
	/* U+8928 */        0xD196,        0xD197,        0xCDCA,        0xF1DD,        0xD198,        0xD199,        0xD19A,        0xD19B,
	/* U+8930 */        0xE5BD,        0xD19C,        0xD19D,        0xD19E,        0xF1DC,        0xD19F,        0xF1DE,        0xD1A0,
	/* U+8938 */        0xD240,        0xD241,        0xD242,        0xD243,        0xD244,        0xD245,        0xD246,        0xD247,
	/* U+8940 */        0xD248,        0xF1DF,        0xD249,        0xD24A,        0xCFE5,        0xD24B,        0xD24C,        0xD24D,
	/* U+8948 */        0xD24E,        0xD24F,        0xD250,        0xD251,        0xD252,        0xD253,        0xD254,        0xD255,
	/* U+8950 */        0xD256,        0xD257,        0xD258,        0xD259,        0xD25A,        0xD25B,        0xD25C,        0xD25D,
	/* U+8958 */        0xD25E,        0xD25F,        0xD260,        0xD261,        0xD262,        0xD263,        0xF4C5,        0xBDF3,
	/* U+8960 */        0xD264,        0xD265,        0xD266,        0xD267,        0xD268,        0xD269,        0xF1E0,        0xD26A,
	/* U+8968 */        0xD26B,        0xD26C,        0xD26D,        0xD26E,        0xD26F,        0xD270,        0xD271,        0xD272,
	/* U+8970 */        0xD273,        0xD274,        0xD275,        0xD276,        0xD277,        0xD278,        0xD279,        0xD27A,
	/* U+8978 */        0xD27B,        0xD27C,        0xD27D,        0xF1E1,        0xD27E,        0xD280,        0xD281,        0xCEF7,
	/* U+8980 */        0xD282,        0xD2AA,        0xD283,        0xF1FB,        0xD284,        0xD285,        0xB8B2,        0xD286,
	/* U+8988 */        0xD287,        0xD288,        0xD289,        0xD28A,        0xD28B,        0xD28C,        0xD28D,        0xD28E,
	/* U+8990 */        0xD28F,        0xD290,        0xD291,        0xD292,        0xD293,        0xD294,        0xD295,        0xD296,
	/* U+8998 */        0xD297,        0xD298,        0xD299,        0xD29A,        0xD29B,        0xD29C,        0xD29D,        0xD29E,
	/* U+89A0 */        0xD29F,        0xD2A0,        0xD340,        0xD341,        0xD342,        0xD343,        0xD344,        0xD345,
	/* U+89A8 */        0xD346,        0xD347,        0xD348,        0xD349,        0xD34A,        0xD34B,        0xD34C,        0xD34D,
	/* U+89B0 */        0xD34E,        0xD34F,        0xD350,        0xD351,        0xD352,        0xD353,        0xD354,        0xD355,
	/* U+89B8 */        0xD356,        0xD357,        0xD358,        0xD359,        0xD35A,        0xD35B,        0xD35C,        0xD35D,
	/* U+89C0 */        0xD35E,        0xBCFB,        0xB9DB,        0xD35F,        0xB9E6,        0xC3D9,        0xCAD3,        0xEAE8,
	/* U+89C8 */        0xC0C0,        0xBEF5,        0xEAE9,        0xEAEA,        0xEAEB,        0xD360,        0xEAEC,        0xEAED,
	/* U+89D0 */        0xEAEE,        0xEAEF,        0xBDC7,        0xD361,        0xD362,        0xD363,        0xF5FB,        0xD364,
	/* U+89D8 */        0xD365,        0xD366,        0xF5FD,        0xD367,        0xF5FE,        0xD368,        0xF5FC,        0xD369,
	/* U+89E0 */        0xD36A,        0xD36B,        0xD36C,        0xBDE2,        0xD36D,        0xF6A1,        0xB4A5,        0xD36E,
	/* U+89E8 */        0xD36F,        0xD370,        0xD371,        0xF6A2,        0xD372,        0xD373,        0xD374,        0xF6A3,
	/* U+89F0 */        0xD375,        0xD376,        0xD377,        0xECB2,        0xD378,        0xD379,        0xD37A,        0xD37B,
	/* U+89F8 */        0xD37C,        0xD37D,        0xD37E,        0xD380,        0xD381,        0xD382,        0xD383,        0xD384,
	/* U+8A00 */        0xD1D4,        0xD385,        0xD386,        0xD387,        0xD388,        0xD389,        0xD38A,        0xD9EA,
	/* U+8A08 */        0xD38B,        0xD38C,        0xD38D,        0xD38E,        0xD38F,        0xD390,        0xD391,        0xD392,
	/* U+8A10 */        0xD393,        0xD394,        0xD395,        0xD396,        0xD397,        0xD398,        0xD399,        0xD39A,
	/* U+8A18 */        0xD39B,        0xD39C,        0xD39D,        0xD39E,        0xD39F,        0xD3A0,        0xD440,        0xD441,
	/* U+8A20 */        0xD442,        0xD443,        0xD444,        0xD445,        0xD446,        0xD447,        0xD448,        0xD449,
	/* U+8A28 */        0xD44A,        0xD44B,        0xD44C,        0xD44D,        0xD44E,        0xD44F,        0xD450,        0xD451,
	/* U+8A30 */        0xD452,        0xD453,        0xD454,        0xD455,        0xD456,        0xD457,        0xD458,        0xD459,
	/* U+8A38 */        0xD45A,        0xD45B,        0xD45C,        0xD45D,        0xD45E,        0xD45F,        0xF6A4,        0xD460,
	/* U+8A40 */        0xD461,        0xD462,        0xD463,        0xD464,        0xD465,        0xD466,        0xD467,        0xD468,
	/* U+8A48 */        0xEEBA,        0xD469,        0xD46A,        0xD46B,        0xD46C,        0xD46D,        0xD46E,        0xD46F,
	/* U+8A50 */        0xD470,        0xD471,        0xD472,        0xD473,        0xD474,        0xD475,        0xD476,        0xD477,
	/* U+8A58 */        0xD478,        0xD479,        0xD47A,        0xD47B,        0xD47C,        0xD47D,        0xD47E,        0xD480,
	/* U+8A60 */        0xD481,        0xD482,        0xD483,        0xD484,        0xD485,        0xD486,        0xD487,        0xD488,
	/* U+8A68 */        0xD489,        0xD48A,        0xD48B,        0xD48C,        0xD48D,        0xD48E,        0xD48F,        0xD490,
	/* U+8A70 */        0xD491,        0xD492,        0xD493,        0xD494,        0xD495,        0xD496,        0xD497,        0xD498,
	/* U+8A78 */        0xD499,        0xD5B2,        0xD49A,        0xD49B,        0xD49C,        0xD49D,        0xD49E,        0xD49F,
	/* U+8A80 */        0xD4A0,        0xD540,        0xD541,        0xD542,        0xD543,        0xD544,        0xD545,        0xD546,
	/* U+8A88 */        0xD547,        0xD3FE,        0xCCDC,        0xD548,        0xD549,        0xD54A,        0xD54B,        0xD54C,
	/* U+8A90 */        0xD54D,        0xD54E,        0xD54F,        0xCAC4,        0xD550,        0xD551,        0xD552,        0xD553,
	/* U+8A98 */        0xD554,        0xD555,        0xD556,        0xD557,        0xD558,        0xD559,        0xD55A,        0xD55B,
	/* U+8AA0 */        0xD55C,        0xD55D,        0xD55E,        0xD55F,        0xD560,        0xD561,        0xD562,        0xD563,
	/* U+8AA8 */        0xD564,        0xD565,        0xD566,        0xD567,        0xD568,        0xD569,        0xD56A,        0xD56B,
	/* U+8AB0 */        0xD56C,        0xD56D,        0xD56E,        0xD56F,        0xD570,        0xD571,        0xD572,        0xD573,
	/* U+8AB8 */        0xD574,        0xD575,        0xD576,        0xD577,        0xD578,        0xD579,        0xD57A,        0xD57B,
	/* U+8AC0 */        0xD57C,        0xD57D,        0xD57E,        0xD580,        0xD581,        0xD582,        0xD583,        0xD584,
	/* U+8AC8 */        0xD585,        0xD586,        0xD587,        0xD588,        0xD589,        0xD58A,        0xD58B,        0xD58C,
	/* U+8AD0 */        0xD58D,        0xD58E,        0xD58F,        0xD590,        0xD591,        0xD592,        0xD593,        0xD594,
	/* U+8AD8 */        0xD595,        0xD596,        0xD597,        0xD598,        0xD599,        0xD59A,        0xD59B,        0xD59C,
	/* U+8AE0 */        0xD59D,        0xD59E,        0xD59F,        0xD5A0,        0xD640,        0xD641,        0xD642,        0xD643,
	/* U+8AE8 */        0xD644,        0xD645,        0xD646,        0xD647,        0xD648,        0xD649,        0xD64A,        0xD64B,
	/* U+8AF0 */        0xD64C,        0xD64D,        0xD64E,        0xD64F,        0xD650,        0xD651,        0xD652,        0xD653,
	/* U+8AF8 */        0xD654,        0xD655,        0xD656,        0xD657,        0xD658,        0xD659,        0xD65A,        0xD65B,
	/* U+8B00 */        0xD65C,        0xD65D,        0xD65E,        0xD65F,        0xD660,        0xD661,        0xD662,        0xE5C0,
	/* U+8B08 */        0xD663,        0xD664,        0xD665,        0xD666,        0xD667,        0xD668,        0xD669,        0xD66A,
	/* U+8B10 */        0xD66B,        0xD66C,        0xD66D,        0xD66E,        0xD66F,        0xD670,        0xD671,        0xD672,
	/* U+8B18 */        0xD673,        0xD674,        0xD675,        0xD676,        0xD677,        0xD678,        0xD679,        0xD67A,
	/* U+8B20 */        0xD67B,        0xD67C,        0xD67D,        0xD67E,        0xD680,        0xD681,        0xF6A5,        0xD682,
	/* U+8B28 */        0xD683,        0xD684,        0xD685,        0xD686,        0xD687,        0xD688,        0xD689,        0xD68A,
	/* U+8B30 */        0xD68B,        0xD68C,        0xD68D,        0xD68E,        0xD68F,        0xD690,        0xD691,        0xD692,
	/* U+8B38 */        0xD693,        0xD694,        0xD695,        0xD696,        0xD697,        0xD698,        0xD699,        0xD69A,
	/* U+8B40 */        0xD69B,        0xD69C,        0xD69D,        0xD69E,        0xD69F,        0xD6A0,        0xD740,        0xD741,
	/* U+8B48 */        0xD742,        0xD743,        0xD744,        0xD745,        0xD746,        0xD747,        0xD748,        0xD749,
	/* U+8B50 */        0xD74A,        0xD74B,        0xD74C,        0xD74D,        0xD74E,        0xD74F,        0xD750,        0xD751,
	/* U+8B58 */        0xD752,        0xD753,        0xD754,        0xD755,        0xD756,        0xD757,        0xD758,        0xD759,
	/* U+8B60 */        0xD75A,        0xD75B,        0xD75C,        0xD75D,        0xD75E,        0xD75F,        0xBEAF,        0xD760,
	/* U+8B68 */        0xD761,        0xD762,        0xD763,        0xD764,        0xC6A9,        0xD765,        0xD766,        0xD767,
	/* U+8B70 */        0xD768,        0xD769,        0xD76A,        0xD76B,        0xD76C,        0xD76D,        0xD76E,        0xD76F,
	/* U+8B78 */        0xD770,        0xD771,        0xD772,        0xD773,        0xD774,        0xD775,        0xD776,        0xD777,
	/* U+8B80 */        0xD778,        0xD779,        0xD77A,        0xD77B,        0xD77C,        0xD77D,        0xD77E,        0xD780,
	/* U+8B88 */        0xD781,        0xD782,        0xD783,        0xD784,        0xD785,        0xD786,        0xD787,        0xD788,
	/* U+8B90 */        0xD789,        0xD78A,        0xD78B,        0xD78C,        0xD78D,        0xD78E,        0xD78F,        0xD790,
	/* U+8B98 */        0xD791,        0xD792,        0xD793,        0xD794,        0xD795,        0xD796,        0xD797,        0xD798,
	/* U+8BA0 */        0xDAA5,        0xBCC6,        0xB6A9,        0xB8BC,        0xC8CF,        0xBCA5,        0xDAA6,        0xDAA7,
	/* U+8BA8 */        0xCCD6,        0xC8C3,        0xDAA8,        0xC6FD,        0xD799,        0xD1B5,        0xD2E9,        0xD1B6,
	/* U+8BB0 */        0xBCC7,        0xD79A,        0xBDB2,        0xBBE4,        0xDAA9,        0xDAAA,        0xD1C8,        0xDAAB,
	/* U+8BB8 */        0xD0ED,        0xB6EF,        0xC2DB,        0xD79B,        0xCBCF,        0xB7ED,        0xC9E8,        0xB7C3,
	/* U+8BC0 */        0xBEF7,        0xD6A4,        0xDAAC,        0xDAAD,        0xC6C0,        0xD7E7,        0xCAB6,        0xD79C,
	/* U+8BC8 */        0xD5A9,        0xCBDF,        0xD5EF,        0xDAAE,        0xD6DF,        0xB4CA,        0xDAB0,        0xDAAF,
	/* U+8BD0 */        0xD79D,        0xD2EB,        0xDAB1,        0xDAB2,        0xDAB3,        0xCAD4,        0xDAB4,        0xCAAB,
	/* U+8BD8 */        0xDAB5,        0xDAB6,        0xB3CF,        0xD6EF,        0xDAB7,        0xBBB0,        0xB5AE,        0xDAB8,
	/* U+8BE0 */        0xDAB9,        0xB9EE,        0xD1AF,        0xD2E8,        0xDABA,        0xB8C3,        0xCFEA,        0xB2EF,
	/* U+8BE8 */        0xDABB,        0xDABC,        0xD79E,        0xBDEB,        0xCEDC,        0xD3EF,        0xDABD,        0xCEF3,
	/* U+8BF0 */        0xDABE,        0xD3D5,        0xBBE5,        0xDABF,        0xCBB5,        0xCBD0,        0xDAC0,        0xC7EB,
	/* U+8BF8 */        0xD6EE,        0xDAC1,        0xC5B5,        0xB6C1,        0xDAC2,        0xB7CC,        0xBFCE,        0xDAC3,
	/* U+8C00 */        0xDAC4,        0xCBAD,        0xDAC5,        0xB5F7,        0xDAC6,        0xC1C2,        0xD7BB,        0xDAC7,
	/* U+8C08 */        0xCCB8,        0xD79F,        0xD2EA,        0xC4B1,        0xDAC8,        0xB5FD,        0xBBD1,        0xDAC9,
	/* U+8C10 */        0xD0B3,        0xDACA,        0xDACB,        0xCEBD,        0xDACC,        0xDACD,        0xDACE,        0xB2F7,
	/* U+8C18 */        0xDAD1,        0xDACF,        0xD1E8,        0xDAD0,        0xC3D5,        0xDAD2,        0xD7A0,        0xDAD3,
	/* U+8C20 */        0xDAD4,        0xDAD5,        0xD0BB,        0xD2A5,        0xB0F9,        0xDAD6,        0xC7AB,        0xDAD7,
	/* U+8C28 */        0xBDF7,        0xC3A1,        0xDAD8,        0xDAD9,        0xC3FD,        0xCCB7,        0xDADA,        0xDADB,
	/* U+8C30 */        0xC0BE,        0xC6D7,        0xDADC,        0xDADD,        0xC7B4,        0xDADE,        0xDADF,        0xB9C8,
	/* U+8C38 */        0xD840,        0xD841,        0xD842,        0xD843,        0xD844,        0xD845,        0xD846,        0xD847,
	/* U+8C40 */        0xD848,        0xBBED,        0xD849,        0xD84A,        0xD84B,        0xD84C,        0xB6B9,        0xF4F8,
	/* U+8C48 */        0xD84D,        0xF4F9,        0xD84E,        0xD84F,        0xCDE3,        0xD850,        0xD851,        0xD852,
	/* U+8C50 */        0xD853,        0xD854,        0xD855,        0xD856,        0xD857,        0xF5B9,        0xD858,        0xD859,
	/* U+8C58 */        0xD85A,        0xD85B,        0xEBE0,        0xD85C,        0xD85D,        0xD85E,        0xD85F,        0xD860,
	/* U+8C60 */        0xD861,        0xCFF3,        0xBBBF,        0xD862,        0xD863,        0xD864,        0xD865,        0xD866,
	/* U+8C68 */        0xD867,        0xD868,        0xBAC0,        0xD4A5,        0xD869,        0xD86A,        0xD86B,        0xD86C,
	/* U+8C70 */        0xD86D,        0xD86E,        0xD86F,        0xE1D9,        0xD870,        0xD871,        0xD872,        0xD873,
	/* U+8C78 */        0xF5F4,        0xB1AA,        0xB2F2,        0xD874,        0xD875,        0xD876,        0xD877,        0xD878,
	/* U+8C80 */        0xD879,        0xD87A,        0xF5F5,        0xD87B,        0xD87C,        0xF5F7,        0xD87D,        0xD87E,
	/* U+8C88 */        0xD880,        0xBAD1,        0xF5F6,        0xD881,        0xC3B2,        0xD882,        0xD883,        0xD884,
	/* U+8C90 */        0xD885,        0xD886,        0xD887,        0xD888,        0xF5F9,        0xD889,        0xD88A,        0xD88B,
	/* U+8C98 */        0xF5F8,        0xD88C,        0xD88D,        0xD88E,        0xD88F,        0xD890,        0xD891,        0xD892,
	/* U+8CA0 */        0xD893,        0xD894,        0xD895,        0xD896,        0xD897,        0xD898,        0xD899,        0xD89A,
	/* U+8CA8 */        0xD89B,        0xD89C,        0xD89D,        0xD89E,        0xD89F,        0xD8A0,        0xD940,        0xD941,
	/* U+8CB0 */        0xD942,        0xD943,        0xD944,        0xD945,        0xD946,        0xD947,        0xD948,        0xD949,
	/* U+8CB8 */        0xD94A,        0xD94B,        0xD94C,        0xD94D,        0xD94E,        0xD94F,        0xD950,        0xD951,
	/* U+8CC0 */        0xD952,        0xD953,        0xD954,        0xD955,        0xD956,        0xD957,        0xD958,        0xD959,
	/* U+8CC8 */        0xD95A,        0xD95B,        0xD95C,        0xD95D,        0xD95E,        0xD95F,        0xD960,        0xD961,
	/* U+8CD0 */        0xD962,        0xD963,        0xD964,        0xD965,        0xD966,        0xD967,        0xD968,        0xD969,
	/* U+8CD8 */        0xD96A,        0xD96B,        0xD96C,        0xD96D,        0xD96E,        0xD96F,        0xD970,        0xD971,
	/* U+8CE0 */        0xD972,        0xD973,        0xD974,        0xD975,        0xD976,        0xD977,        0xD978,        0xD979,
	/* U+8CE8 */        0xD97A,        0xD97B,        0xD97C,        0xD97D,        0xD97E,        0xD980,        0xD981,        0xD982,
	/* U+8CF0 */        0xD983,        0xD984,        0xD985,        0xD986,        0xD987,        0xD988,        0xD989,        0xD98A,
	/* U+8CF8 */        0xD98B,        0xD98C,        0xD98D,        0xD98E,        0xD98F,        0xD990,        0xD991,        0xD992,
	/* U+8D00 */        0xD993,        0xD994,        0xD995,        0xD996,        0xD997,        0xD998,        0xD999,        0xD99A,
	/* U+8D08 */        0xD99B,        0xD99C,        0xD99D,        0xD99E,        0xD99F,        0xD9A0,        0xDA40,        0xDA41,
	/* U+8D10 */        0xDA42,        0xDA43,        0xDA44,        0xDA45,        0xDA46,        0xDA47,        0xDA48,        0xDA49,
	/* U+8D18 */        0xDA4A,        0xDA4B,        0xDA4C,        0xDA4D,        0xDA4E,        0xB1B4,        0xD5EA,        0xB8BA,
	/* U+8D20 */        0xDA4F,        0xB9B1,        0xB2C6,        0xD4F0,        0xCFCD,        0xB0DC,        0xD5CB,        0xBBF5,
	/* U+8D28 */        0xD6CA,        0xB7B7,        0xCCB0,        0xC6B6,        0xB1E1,        0xB9BA,        0xD6FC,        0xB9E1,
	/* U+8D30 */        0xB7A1,        0xBCFA,        0xEADA,        0xEADB,        0xCCF9,        0xB9F3,        0xEADC,        0xB4FB,
	/* U+8D38 */        0xC3B3,        0xB7D1,        0xBAD8,        0xEADD,        0xD4F4,        0xEADE,        0xBCD6,        0xBBDF,
	/* U+8D40 */        0xEADF,        0xC1DE,        0xC2B8,        0xD4DF,        0xD7CA,        0xEAE0,        0xEAE1,        0xEAE4,
	/* U+8D48 */        0xEAE2,        0xEAE3,        0xC9DE,        0xB8B3,        0xB6C4,        0xEAE5,        0xCAEA,        0xC9CD,
	/* U+8D50 */        0xB4CD,        0xDA50,        0xDA51,        0xE2D9,        0xC5E2,        0xEAE6,        0xC0B5,        0xDA52,
	/* U+8D58 */        0xD7B8,        0xEAE7,        0xD7AC,        0xC8FC,        0xD8D3,        0xD8CD,        0xD4DE,        0xDA53,
	/* U+8D60 */        0xD4F9,        0xC9C4,        0xD3AE,        0xB8D3,        0xB3E0,        0xDA54,        0xC9E2,        0xF4F6,
	/* U+8D68 */        0xDA55,        0xDA56,        0xDA57,        0xBAD5,        0xDA58,        0xF4F7,        0xDA59,        0xDA5A,
	/* U+8D70 */        0xD7DF,        0xDA5B,        0xDA5C,        0xF4F1,        0xB8B0,        0xD5D4,        0xB8CF,        0xC6F0,
	/* U+8D78 */        0xDA5D,        0xDA5E,        0xDA5F,        0xDA60,        0xDA61,        0xDA62,        0xDA63,        0xDA64,
	/* U+8D80 */        0xDA65,        0xB3C3,        0xDA66,        0xDA67,        0xF4F2,        0xB3AC,        0xDA68,        0xDA69,
	/* U+8D88 */        0xDA6A,        0xDA6B,        0xD4BD,        0xC7F7,        0xDA6C,        0xDA6D,        0xDA6E,        0xDA6F,
	/* U+8D90 */        0xDA70,        0xF4F4,        0xDA71,        0xDA72,        0xF4F3,        0xDA73,        0xDA74,        0xDA75,
	/* U+8D98 */        0xDA76,        0xDA77,        0xDA78,        0xDA79,        0xDA7A,        0xDA7B,        0xDA7C,        0xCCCB,
	/* U+8DA0 */        0xDA7D,        0xDA7E,        0xDA80,        0xC8A4,        0xDA81,        0xDA82,        0xDA83,        0xDA84,
	/* U+8DA8 */        0xDA85,        0xDA86,        0xDA87,        0xDA88,        0xDA89,        0xDA8A,        0xDA8B,        0xDA8C,
	/* U+8DB0 */        0xDA8D,        0xF4F5,        0xDA8E,        0xD7E3,        0xC5BF,        0xF5C0,        0xDA8F,        0xDA90,
	/* U+8DB8 */        0xF5BB,        0xDA91,        0xF5C3,        0xDA92,        0xF5C2,        0xDA93,        0xD6BA,        0xF5C1,
	/* U+8DC0 */        0xDA94,        0xDA95,        0xDA96,        0xD4BE,        0xF5C4,        0xDA97,        0xF5CC,        0xDA98,
	/* U+8DC8 */        0xDA99,        0xDA9A,        0xDA9B,        0xB0CF,        0xB5F8,        0xDA9C,        0xF5C9,        0xF5CA,
	/* U+8DD0 */        0xDA9D,        0xC5DC,        0xDA9E,        0xDA9F,        0xDAA0,        0xDB40,        0xF5C5,        0xF5C6,
	/* U+8DD8 */        0xDB41,        0xDB42,        0xF5C7,        0xF5CB,        0xDB43,        0xBEE0,        0xF5C8,        0xB8FA,
	/* U+8DE0 */        0xDB44,        0xDB45,        0xDB46,        0xF5D0,        0xF5D3,        0xDB47,        0xDB48,        0xDB49,
	/* U+8DE8 */        0xBFE7,        0xDB4A,        0xB9F2,        0xF5BC,        0xF5CD,        0xDB4B,        0xDB4C,        0xC2B7,
	/* U+8DF0 */        0xDB4D,        0xDB4E,        0xDB4F,        0xCCF8,        0xDB50,        0xBCF9,        0xDB51,        0xF5CE,
	/* U+8DF8 */        0xF5CF,        0xF5D1,        0xB6E5,        0xF5D2,        0xDB52,        0xF5D5,        0xDB53,        0xDB54,
	/* U+8E00 */        0xDB55,        0xDB56,        0xDB57,        0xDB58,        0xDB59,        0xF5BD,        0xDB5A,        0xDB5B,
	/* U+8E08 */        0xDB5C,        0xF5D4,        0xD3BB,        0xDB5D,        0xB3EC,        0xDB5E,        0xDB5F,        0xCCA4,
	/* U+8E10 */        0xDB60,        0xDB61,        0xDB62,        0xDB63,        0xF5D6,        0xDB64,        0xDB65,        0xDB66,
	/* U+8E18 */        0xDB67,        0xDB68,        0xDB69,        0xDB6A,        0xDB6B,        0xF5D7,        0xBEE1,        0xF5D8,
	/* U+8E20 */        0xDB6C,        0xDB6D,        0xCCDF,        0xF5DB,        0xDB6E,        0xDB6F,        0xDB70,        0xDB71,
	/* U+8E28 */        0xDB72,        0xB2C8,        0xD7D9,        0xDB73,        0xF5D9,        0xDB74,        0xF5DA,        0xF5DC,
	/* U+8E30 */        0xDB75,        0xF5E2,        0xDB76,        0xDB77,        0xDB78,        0xF5E0,        0xDB79,        0xDB7A,
	/* U+8E38 */        0xDB7B,        0xF5DF,        0xF5DD,        0xDB7C,        0xDB7D,        0xF5E1,        0xDB7E,        0xDB80,
	/* U+8E40 */        0xF5DE,        0xF5E4,        0xF5E5,        0xDB81,        0xCCE3,        0xDB82,        0xDB83,        0xE5BF,
	/* U+8E48 */        0xB5B8,        0xF5E3,        0xF5E8,        0xCCA3,        0xDB84,        0xDB85,        0xDB86,        0xDB87,
	/* U+8E50 */        0xDB88,        0xF5E6,        0xF5E7,        0xDB89,        0xDB8A,        0xDB8B,        0xDB8C,        0xDB8D,
	/* U+8E58 */        0xDB8E,        0xF5BE,        0xDB8F,        0xDB90,        0xDB91,        0xDB92,        0xDB93,        0xDB94,
	/* U+8E60 */        0xDB95,        0xDB96,        0xDB97,        0xDB98,        0xDB99,        0xDB9A,        0xB1C4,        0xDB9B,
	/* U+8E68 */        0xDB9C,        0xF5BF,        0xDB9D,        0xDB9E,        0xB5C5,        0xB2E4,        0xDB9F,        0xF5EC,
	/* U+8E70 */        0xF5E9,        0xDBA0,        0xB6D7,        0xDC40,        0xF5ED,        0xDC41,        0xF5EA,        0xDC42,
	/* U+8E78 */        0xDC43,        0xDC44,        0xDC45,        0xDC46,        0xF5EB,        0xDC47,        0xDC48,        0xB4DA,
	/* U+8E80 */        0xDC49,        0xD4EA,        0xDC4A,        0xDC4B,        0xDC4C,        0xF5EE,        0xDC4D,        0xB3F9,
	/* U+8E88 */        0xDC4E,        0xDC4F,        0xDC50,        0xDC51,        0xDC52,        0xDC53,        0xDC54,        0xF5EF,
	/* U+8E90 */        0xF5F1,        0xDC55,        0xDC56,        0xDC57,        0xF5F0,        0xDC58,        0xDC59,        0xDC5A,
	/* U+8E98 */        0xDC5B,        0xDC5C,        0xDC5D,        0xDC5E,        0xF5F2,        0xDC5F,        0xF5F3,        0xDC60,
	/* U+8EA0 */        0xDC61,        0xDC62,        0xDC63,        0xDC64,        0xDC65,        0xDC66,        0xDC67,        0xDC68,
	/* U+8EA8 */        0xDC69,        0xDC6A,        0xDC6B,        0xC9ED,        0xB9AA,        0xDC6C,        0xDC6D,        0xC7FB,
	/* U+8EB0 */        0xDC6E,        0xDC6F,        0xB6E3,        0xDC70,        0xDC71,        0xDC72,        0xDC73,        0xDC74,
	/* U+8EB8 */        0xDC75,        0xDC76,        0xCCC9,        0xDC77,        0xDC78,        0xDC79,        0xDC7A,        0xDC7B,
	/* U+8EC0 */        0xDC7C,        0xDC7D,        0xDC7E,        0xDC80,        0xDC81,        0xDC82,        0xDC83,        0xDC84,
	/* U+8EC8 */        0xDC85,        0xDC86,        0xDC87,        0xDC88,        0xDC89,        0xDC8A,        0xEAA6,        0xDC8B,
	/* U+8ED0 */        0xDC8C,        0xDC8D,        0xDC8E,        0xDC8F,        0xDC90,        0xDC91,        0xDC92,        0xDC93,
	/* U+8ED8 */        0xDC94,        0xDC95,        0xDC96,        0xDC97,        0xDC98,        0xDC99,        0xDC9A,        0xDC9B,
	/* U+8EE0 */        0xDC9C,        0xDC9D,        0xDC9E,        0xDC9F,        0xDCA0,        0xDD40,        0xDD41,        0xDD42,
	/* U+8EE8 */        0xDD43,        0xDD44,        0xDD45,        0xDD46,        0xDD47,        0xDD48,        0xDD49,        0xDD4A,
	/* U+8EF0 */        0xDD4B,        0xDD4C,        0xDD4D,        0xDD4E,        0xDD4F,        0xDD50,        0xDD51,        0xDD52,
	/* U+8EF8 */        0xDD53,        0xDD54,        0xDD55,        0xDD56,        0xDD57,        0xDD58,        0xDD59,        0xDD5A,
	/* U+8F00 */        0xDD5B,        0xDD5C,        0xDD5D,        0xDD5E,        0xDD5F,        0xDD60,        0xDD61,        0xDD62,
	/* U+8F08 */        0xDD63,        0xDD64,        0xDD65,        0xDD66,        0xDD67,        0xDD68,        0xDD69,        0xDD6A,
	/* U+8F10 */        0xDD6B,        0xDD6C,        0xDD6D,        0xDD6E,        0xDD6F,        0xDD70,        0xDD71,        0xDD72,
	/* U+8F18 */        0xDD73,        0xDD74,        0xDD75,        0xDD76,        0xDD77,        0xDD78,        0xDD79,        0xDD7A,
	/* U+8F20 */        0xDD7B,        0xDD7C,        0xDD7D,        0xDD7E,        0xDD80,        0xDD81,        0xDD82,        0xDD83,
	/* U+8F28 */        0xDD84,        0xDD85,        0xDD86,        0xDD87,        0xDD88,        0xDD89,        0xDD8A,        0xDD8B,
	/* U+8F30 */        0xDD8C,        0xDD8D,        0xDD8E,        0xDD8F,        0xDD90,        0xDD91,        0xDD92,        0xDD93,
	/* U+8F38 */        0xDD94,        0xDD95,        0xDD96,        0xDD97,        0xDD98,        0xDD99,        0xDD9A,        0xDD9B,
	/* U+8F40 */        0xDD9C,        0xDD9D,        0xDD9E,        0xDD9F,        0xDDA0,        0xDE40,        0xDE41,        0xDE42,
	/* U+8F48 */        0xDE43,        0xDE44,        0xDE45,        0xDE46,        0xDE47,        0xDE48,        0xDE49,        0xDE4A,
	/* U+8F50 */        0xDE4B,        0xDE4C,        0xDE4D,        0xDE4E,        0xDE4F,        0xDE50,        0xDE51,        0xDE52,
	/* U+8F58 */        0xDE53,        0xDE54,        0xDE55,        0xDE56,        0xDE57,        0xDE58,        0xDE59,        0xDE5A,
	/* U+8F60 */        0xDE5B,        0xDE5C,        0xDE5D,        0xDE5E,        0xDE5F,        0xDE60,        0xB3B5,        0xD4FE,
	/* U+8F68 */        0xB9EC,        0xD0F9,        0xDE61,        0xE9ED,        0xD7AA,        0xE9EE,        0xC2D6,        0xC8ED,
	/* U+8F70 */        0xBAE4,        0xE9EF,        0xE9F0,        0xE9F1,        0xD6E1,        0xE9F2,        0xE9F3,        0xE9F5,
	/* U+8F78 */        0xE9F4,        0xE9F6,        0xE9F7,        0xC7E1,        0xE9F8,        0xD4D8,        0xE9F9,        0xBDCE,
	/* U+8F80 */        0xDE62,        0xE9FA,        0xE9FB,        0xBDCF,        0xE9FC,        0xB8A8,        0xC1BE,        0xE9FD,
	/* U+8F88 */        0xB1B2,        0xBBD4,        0xB9F5,        0xE9FE,        0xDE63,        0xEAA1,        0xEAA2,        0xEAA3,
	/* U+8F90 */        0xB7F8,        0xBCAD,        0xDE64,        0xCAE4,        0xE0CE,        0xD4AF,        0xCFBD,        0xD5B7,
	/* U+8F98 */        0xEAA4,        0xD5DE,        0xEAA5,        0xD0C1,        0xB9BC,        0xDE65,        0xB4C7,        0xB1D9,
	/* U+8FA0 */        0xDE66,        0xDE67,        0xDE68,        0xC0B1,        0xDE69,        0xDE6A,        0xDE6B,        0xDE6C,
	/* U+8FA8 */        0xB1E6,        0xB1E7,        0xDE6D,        0xB1E8,        0xDE6E,        0xDE6F,        0xDE70,        0xDE71,
	/* U+8FB0 */        0xB3BD,        0xC8E8,        0xDE72,        0xDE73,        0xDE74,        0xDE75,        0xE5C1,        0xDE76,
	/* U+8FB8 */        0xDE77,        0xB1DF,        0xDE78,        0xDE79,        0xDE7A,        0xC1C9,        0xB4EF,        0xDE7B,
	/* U+8FC0 */        0xDE7C,        0xC7A8,        0xD3D8,        0xDE7D,        0xC6F9,        0xD1B8,        0xDE7E,        0xB9FD,
	/* U+8FC8 */        0xC2F5,        0xDE80,        0xDE81,        0xDE82,        0xDE83,        0xDE84,        0xD3AD,        0xDE85,
	/* U+8FD0 */        0xD4CB,        0xBDFC,        0xDE86,        0xE5C2,        0xB7B5,        0xE5C3,        0xDE87,        0xDE88,
	/* U+8FD8 */        0xBBB9,        0xD5E2,        0xDE89,        0xBDF8,        0xD4B6,        0xCEA5,        0xC1AC,        0xB3D9,
	/* U+8FE0 */        0xDE8A,        0xDE8B,        0xCCF6,        0xDE8C,        0xE5C6,        0xE5C4,        0xE5C8,        0xDE8D,
	/* U+8FE8 */        0xE5CA,        0xE5C7,        0xB5CF,        0xC6C8,        0xDE8E,        0xB5FC,        0xE5C5,        0xDE8F,
	/* U+8FF0 */        0xCAF6,        0xDE90,        0xDE91,        0xE5C9,        0xDE92,        0xDE93,        0xDE94,        0xC3D4,
	/* U+8FF8 */        0xB1C5,        0xBCA3,        0xDE95,        0xDE96,        0xDE97,        0xD7B7,        0xDE98,        0xDE99,
	/* U+9000 */        0xCDCB,        0xCBCD,        0xCACA,        0xCCD3,        0xE5CC,        0xE5CB,        0xC4E6,        0xDE9A,
	/* U+9008 */        0xDE9B,        0xD1A1,        0xD1B7,        0xE5CD,        0xDE9C,        0xE5D0,        0xDE9D,        0xCDB8,
	/* U+9010 */        0xD6F0,        0xE5CF,        0xB5DD,        0xDE9E,        0xCDBE,        0xDE9F,        0xE5D1,        0xB6BA,
	/* U+9018 */        0xDEA0,        0xDF40,        0xCDA8,        0xB9E4,        0xDF41,        0xCAC5,        0xB3D1,        0xCBD9,
	/* U+9020 */        0xD4EC,        0xE5D2,        0xB7EA,        0xDF42,        0xDF43,        0xDF44,        0xE5CE,        0xDF45,
	/* U+9028 */        0xDF46,        0xDF47,        0xDF48,        0xDF49,        0xDF4A,        0xE5D5,        0xB4FE,        0xE5D6,
	/* U+9030 */        0xDF4B,        0xDF4C,        0xDF4D,        0xDF4E,        0xDF4F,        0xE5D3,        0xE5D4,        0xDF50,
	/* U+9038 */        0xD2DD,        0xDF51,        0xDF52,        0xC2DF,        0xB1C6,        0xDF53,        0xD3E2,        0xDF54,
	/* U+9040 */        0xDF55,        0xB6DD,        0xCBEC,        0xDF56,        0xE5D7,        0xDF57,        0xDF58,        0xD3F6,
	/* U+9048 */        0xDF59,        0xDF5A,        0xDF5B,        0xDF5C,        0xDF5D,        0xB1E9,        0xDF5E,        0xB6F4,
	/* U+9050 */        0xE5DA,        0xE5D8,        0xE5D9,        0xB5C0,        0xDF5F,        0xDF60,        0xDF61,        0xD2C5,
	/* U+9058 */        0xE5DC,        0xDF62,        0xDF63,        0xE5DE,        0xDF64,        0xDF65,        0xDF66,        0xDF67,
	/* U+9060 */        0xDF68,        0xDF69,        0xE5DD,        0xC7B2,        0xDF6A,        0xD2A3,        0xDF6B,        0xDF6C,
	/* U+9068 */        0xE5DB,        0xDF6D,        0xDF6E,        0xDF6F,        0xDF70,        0xD4E2,        0xD5DA,        0xDF71,
	/* U+9070 */        0xDF72,        0xDF73,        0xDF74,        0xDF75,        0xE5E0,        0xD7F1,        0xDF76,        0xDF77,
	/* U+9078 */        0xDF78,        0xDF79,        0xDF7A,        0xDF7B,        0xDF7C,        0xE5E1,        0xDF7D,        0xB1DC,
	/* U+9080 */        0xD1FB,        0xDF7E,        0xE5E2,        0xE5E4,        0xDF80,        0xDF81,        0xDF82,        0xDF83,
	/* U+9088 */        0xE5E3,        0xDF84,        0xDF85,        0xE5E5,        0xDF86,        0xDF87,        0xDF88,        0xDF89,
	/* U+9090 */        0xDF8A,        0xD2D8,        0xDF8B,        0xB5CB,        0xDF8C,        0xE7DF,        0xDF8D,        0xDAF5,
	/* U+9098 */        0xDF8E,        0xDAF8,        0xDF8F,        0xDAF6,        0xDF90,        0xDAF7,        0xDF91,        0xDF92,
	/* U+90A0 */        0xDF93,        0xDAFA,        0xD0CF,        0xC4C7,        0xDF94,        0xDF95,        0xB0EE,        0xDF96,
	/* U+90A8 */        0xDF97,        0xDF98,        0xD0B0,        0xDF99,        0xDAF9,        0xDF9A,        0xD3CA,        0xBAAA,
	/* U+90B0 */        0xDBA2,        0xC7F1,        0xDF9B,        0xDAFC,        0xDAFB,        0xC9DB,        0xDAFD,        0xDF9C,
	/* U+90B8 */        0xDBA1,        0xD7DE,        0xDAFE,        0xC1DA,        0xDF9D,        0xDF9E,        0xDBA5,        0xDF9F,
	/* U+90C0 */        0xDFA0,        0xD3F4,        0xE040,        0xE041,        0xDBA7,        0xDBA4,        0xE042,        0xDBA8,
	/* U+90C8 */        0xE043,        0xE044,        0xBDBC,        0xE045,        0xE046,        0xE047,        0xC0C9,        0xDBA3,
	/* U+90D0 */        0xDBA6,        0xD6A3,        0xE048,        0xDBA9,        0xE049,        0xE04A,        0xE04B,        0xDBAD,
	/* U+90D8 */        0xE04C,        0xE04D,        0xE04E,        0xDBAE,        0xDBAC,        0xBAC2,        0xE04F,        0xE050,
	/* U+90E0 */        0xE051,        0xBFA4,        0xDBAB,        0xE052,        0xE053,        0xE054,        0xDBAA,        0xD4C7,
	/* U+90E8 */        0xB2BF,        0xE055,        0xE056,        0xDBAF,        0xE057,        0xB9F9,        0xE058,        0xDBB0,
	/* U+90F0 */        0xE059,        0xE05A,        0xE05B,        0xE05C,        0xB3BB,        0xE05D,        0xE05E,        0xE05F,
	/* U+90F8 */        0xB5A6,        0xE060,        0xE061,        0xE062,        0xE063,        0xB6BC,        0xDBB1,        0xE064,
	/* U+9100 */        0xE065,        0xE066,        0xB6F5,        0xE067,        0xDBB2,        0xE068,        0xE069,        0xE06A,
	/* U+9108 */        0xE06B,        0xE06C,        0xE06D,        0xE06E,        0xE06F,        0xE070,        0xE071,        0xE072,
	/* U+9110 */        0xE073,        0xE074,        0xE075,        0xE076,        0xE077,        0xE078,        0xE079,        0xE07A,
	/* U+9118 */        0xE07B,        0xB1C9,        0xE07C,        0xE07D,        0xE07E,        0xE080,        0xDBB4,        0xE081,
	/* U+9120 */        0xE082,        0xE083,        0xDBB3,        0xDBB5,        0xE084,        0xE085,        0xE086,        0xE087,
	/* U+9128 */        0xE088,        0xE089,        0xE08A,        0xE08B,        0xE08C,        0xE08D,        0xE08E,        0xDBB7,
	/* U+9130 */        0xE08F,        0xDBB6,        0xE090,        0xE091,        0xE092,        0xE093,        0xE094,        0xE095,
	/* U+9138 */        0xE096,        0xDBB8,        0xE097,        0xE098,        0xE099,        0xE09A,        0xE09B,        0xE09C,
	/* U+9140 */        0xE09D,        0xE09E,        0xE09F,        0xDBB9,        0xE0A0,        0xE140,        0xDBBA,        0xE141,
	/* U+9148 */        0xE142,        0xD3CF,        0xF4FA,        0xC7F5,        0xD7C3,        0xC5E4,        0xF4FC,        0xF4FD,
	/* U+9150 */        0xF4FB,        0xE143,        0xBEC6,        0xE144,        0xE145,        0xE146,        0xE147,        0xD0EF,
	/* U+9158 */        0xE148,        0xE149,        0xB7D3,        0xE14A,        0xE14B,        0xD4CD,        0xCCAA,        0xE14C,
	/* U+9160 */        0xE14D,        0xF5A2,        0xF5A1,        0xBAA8,        0xF4FE,        0xCBD6,        0xE14E,        0xE14F,
	/* U+9168 */        0xE150,        0xF5A4,        0xC0D2,        0xE151,        0xB3EA,        0xE152,        0xCDAA,        0xF5A5,
	/* U+9170 */        0xF5A3,        0xBDB4,        0xF5A8,        0xE153,        0xF5A9,        0xBDCD,        0xC3B8,        0xBFE1,
	/* U+9178 */        0xCBE1,        0xF5AA,        0xE154,        0xE155,        0xE156,        0xF5A6,        0xF5A7,        0xC4F0,
	/* U+9180 */        0xE157,        0xE158,        0xE159,        0xE15A,        0xE15B,        0xF5AC,        0xE15C,        0xB4BC,
	/* U+9188 */        0xE15D,        0xD7ED,        0xE15E,        0xB4D7,        0xF5AB,        0xF5AE,        0xE15F,        0xE160,
	/* U+9190 */        0xF5AD,        0xF5AF,        0xD0D1,        0xE161,        0xE162,        0xE163,        0xE164,        0xE165,
	/* U+9198 */        0xE166,        0xE167,        0xC3D1,        0xC8A9,        0xE168,        0xE169,        0xE16A,        0xE16B,
	/* U+91A0 */        0xE16C,        0xE16D,        0xF5B0,        0xF5B1,        0xE16E,        0xE16F,        0xE170,        0xE171,
	/* U+91A8 */        0xE172,        0xE173,        0xF5B2,        0xE174,        0xE175,        0xF5B3,        0xF5B4,        0xF5B5,
	/* U+91B0 */        0xE176,        0xE177,        0xE178,        0xE179,        0xF5B7,        0xF5B6,        0xE17A,        0xE17B,
	/* U+91B8 */        0xE17C,        0xE17D,        0xF5B8,        0xE17E,        0xE180,        0xE181,        0xE182,        0xE183,
	/* U+91C0 */        0xE184,        0xE185,        0xE186,        0xE187,        0xE188,        0xE189,        0xE18A,        0xB2C9,
	/* U+91C8 */        0xE18B,        0xD3D4,        0xCACD,        0xE18C,        0xC0EF,        0xD6D8,        0xD2B0,        0xC1BF,
	/* U+91D0 */        0xE18D,        0xBDF0,        0xE18E,        0xE18F,        0xE190,        0xE191,        0xE192,        0xE193,
	/* U+91D8 */        0xE194,        0xE195,        0xE196,        0xE197,        0xB8AA,        0xE198,        0xE199,        0xE19A,
	/* U+91E0 */        0xE19B,        0xE19C,        0xE19D,        0xE19E,        0xE19F,        0xE1A0,        0xE240,        0xE241,
	/* U+91E8 */        0xE242,        0xE243,        0xE244,        0xE245,        0xE246,        0xE247,        0xE248,        0xE249,
	/* U+91F0 */        0xE24A,        0xE24B,        0xE24C,        0xE24D,        0xE24E,        0xE24F,        0xE250,        0xE251,
	/* U+91F8 */        0xE252,        0xE253,        0xE254,        0xE255,        0xE256,        0xE257,        0xE258,        0xE259,
	/* U+9200 */        0xE25A,        0xE25B,        0xE25C,        0xE25D,        0xE25E,        0xE25F,        0xE260,        0xE261,
	/* U+9208 */        0xE262,        0xE263,        0xE264,        0xE265,        0xE266,        0xE267,        0xE268,        0xE269,
	/* U+9210 */        0xE26A,        0xE26B,        0xE26C,        0xE26D,        0xE26E,        0xE26F,        0xE270,        0xE271,
	/* U+9218 */        0xE272,        0xE273,        0xE274,        0xE275,        0xE276,        0xE277,        0xE278,        0xE279,
	/* U+9220 */        0xE27A,        0xE27B,        0xE27C,        0xE27D,        0xE27E,        0xE280,        0xE281,        0xE282,
	/* U+9228 */        0xE283,        0xE284,        0xE285,        0xE286,        0xE287,        0xE288,        0xE289,        0xE28A,
	/* U+9230 */        0xE28B,        0xE28C,        0xE28D,        0xE28E,        0xE28F,        0xE290,        0xE291,        0xE292,
	/* U+9238 */        0xE293,        0xE294,        0xE295,        0xE296,        0xE297,        0xE298,        0xE299,        0xE29A,
	/* U+9240 */        0xE29B,        0xE29C,        0xE29D,        0xE29E,        0xE29F,        0xE2A0,        0xE340,        0xE341,
	/* U+9248 */        0xE342,        0xE343,        0xE344,        0xE345,        0xE346,        0xE347,        0xE348,        0xE349,
	/* U+9250 */        0xE34A,        0xE34B,        0xE34C,        0xE34D,        0xE34E,        0xE34F,        0xE350,        0xE351,
	/* U+9258 */        0xE352,        0xE353,        0xE354,        0xE355,        0xE356,        0xE357,        0xE358,        0xE359,
	/* U+9260 */        0xE35A,        0xE35B,        0xE35C,        0xE35D,        0xE35E,        0xE35F,        0xE360,        0xE361,
	/* U+9268 */        0xE362,        0xE363,        0xE364,        0xE365,        0xE366,        0xE367,        0xE368,        0xE369,
	/* U+9270 */        0xE36A,        0xE36B,        0xE36C,        0xE36D,        0xBCF8,        0xE36E,        0xE36F,        0xE370,
	/* U+9278 */        0xE371,        0xE372,        0xE373,        0xE374,        0xE375,        0xE376,        0xE377,        0xE378,
	/* U+9280 */        0xE379,        0xE37A,        0xE37B,        0xE37C,        0xE37D,        0xE37E,        0xE380,        0xE381,
	/* U+9288 */        0xE382,        0xE383,        0xE384,        0xE385,        0xE386,        0xE387,        0xF6C6,        0xE388,
	/* U+9290 */        0xE389,        0xE38A,        0xE38B,        0xE38C,        0xE38D,        0xE38E,        0xE38F,        0xE390,
	/* U+9298 */        0xE391,        0xE392,        0xE393,        0xE394,        0xE395,        0xE396,        0xE397,        0xE398,
	/* U+92A0 */        0xE399,        0xE39A,        0xE39B,        0xE39C,        0xE39D,        0xE39E,        0xE39F,        0xE3A0,
	/* U+92A8 */        0xE440,        0xE441,        0xE442,        0xE443,        0xE444,        0xE445,        0xF6C7,        0xE446,
	/* U+92B0 */        0xE447,        0xE448,        0xE449,        0xE44A,        0xE44B,        0xE44C,        0xE44D,        0xE44E,
	/* U+92B8 */        0xE44F,        0xE450,        0xE451,        0xE452,        0xE453,        0xE454,        0xE455,        0xE456,
	/* U+92C0 */        0xE457,        0xE458,        0xE459,        0xE45A,        0xE45B,        0xE45C,        0xE45D,        0xE45E,
	/* U+92C8 */        0xF6C8,        0xE45F,        0xE460,        0xE461,        0xE462,        0xE463,        0xE464,        0xE465,
	/* U+92D0 */        0xE466,        0xE467,        0xE468,        0xE469,        0xE46A,        0xE46B,        0xE46C,        0xE46D,
	/* U+92D8 */        0xE46E,        0xE46F,        0xE470,        0xE471,        0xE472,        0xE473,        0xE474,        0xE475,
	/* U+92E0 */        0xE476,        0xE477,        0xE478,        0xE479,        0xE47A,        0xE47B,        0xE47C,        0xE47D,
	/* U+92E8 */        0xE47E,        0xE480,        0xE481,        0xE482,        0xE483,        0xE484,        0xE485,        0xE486,
	/* U+92F0 */        0xE487,        0xE488,        0xE489,        0xE48A,        0xE48B,        0xE48C,        0xE48D,        0xE48E,
	/* U+92F8 */        0xE48F,        0xE490,        0xE491,        0xE492,        0xE493,        0xE494,        0xE495,        0xE496,
	/* U+9300 */        0xE497,        0xE498,        0xE499,        0xE49A,        0xE49B,        0xE49C,        0xE49D,        0xE49E,
	/* U+9308 */        0xE49F,        0xE4A0,        0xE540,        0xE541,        0xE542,        0xE543,        0xE544,        0xE545,
	/* U+9310 */        0xE546,        0xE547,        0xE548,        0xE549,        0xE54A,        0xE54B,        0xE54C,        0xE54D,
	/* U+9318 */        0xE54E,        0xE54F,        0xE550,        0xE551,        0xE552,        0xE553,        0xE554,        0xE555,
	/* U+9320 */        0xE556,        0xE557,        0xE558,        0xE559,        0xE55A,        0xE55B,        0xE55C,        0xE55D,
	/* U+9328 */        0xE55E,        0xE55F,        0xE560,        0xE561,        0xE562,        0xE563,        0xE564,        0xE565,
	/* U+9330 */        0xE566,        0xE567,        0xE568,        0xE569,        0xE56A,        0xE56B,        0xE56C,        0xE56D,
	/* U+9338 */        0xE56E,        0xE56F,        0xE570,        0xE571,        0xE572,        0xE573,        0xF6C9,        0xE574,
	/* U+9340 */        0xE575,        0xE576,        0xE577,        0xE578,        0xE579,        0xE57A,        0xE57B,        0xE57C,
	/* U+9348 */        0xE57D,        0xE57E,        0xE580,        0xE581,        0xE582,        0xE583,        0xE584,        0xE585,
	/* U+9350 */        0xE586,        0xE587,        0xE588,        0xE589,        0xE58A,        0xE58B,        0xE58C,        0xE58D,
	/* U+9358 */        0xE58E,        0xE58F,        0xE590,        0xE591,        0xE592,        0xE593,        0xE594,        0xE595,
	/* U+9360 */        0xE596,        0xE597,        0xE598,        0xE599,        0xE59A,        0xE59B,        0xE59C,        0xE59D,
	/* U+9368 */        0xE59E,        0xE59F,        0xF6CA,        0xE5A0,        0xE640,        0xE641,        0xE642,        0xE643,
	/* U+9370 */        0xE644,        0xE645,        0xE646,        0xE647,        0xE648,        0xE649,        0xE64A,        0xE64B,
	/* U+9378 */        0xE64C,        0xE64D,        0xE64E,        0xE64F,        0xE650,        0xE651,        0xE652,        0xE653,
	/* U+9380 */        0xE654,        0xE655,        0xE656,        0xE657,        0xE658,        0xE659,        0xE65A,        0xE65B,
	/* U+9388 */        0xE65C,        0xE65D,        0xE65E,        0xE65F,        0xE660,        0xE661,        0xE662,        0xF6CC,
	/* U+9390 */        0xE663,        0xE664,        0xE665,        0xE666,        0xE667,        0xE668,        0xE669,        0xE66A,
	/* U+9398 */        0xE66B,        0xE66C,        0xE66D,        0xE66E,        0xE66F,        0xE670,        0xE671,        0xE672,
	/* U+93A0 */        0xE673,        0xE674,        0xE675,        0xE676,        0xE677,        0xE678,        0xE679,        0xE67A,
	/* U+93A8 */        0xE67B,        0xE67C,        0xE67D,        0xE67E,        0xE680,        0xE681,        0xE682,        0xE683,
	/* U+93B0 */        0xE684,        0xE685,        0xE686,        0xE687,        0xE688,        0xE689,        0xE68A,        0xE68B,
	/* U+93B8 */        0xE68C,        0xE68D,        0xE68E,        0xE68F,        0xE690,        0xE691,        0xE692,        0xE693,
	/* U+93C0 */        0xE694,        0xE695,        0xE696,        0xE697,        0xE698,        0xE699,        0xE69A,        0xE69B,
	/* U+93C8 */        0xE69C,        0xE69D,        0xF6CB,        0xE69E,        0xE69F,        0xE6A0,        0xE740,        0xE741,
	/* U+93D0 */        0xE742,        0xE743,        0xE744,        0xE745,        0xE746,        0xE747,        0xF7E9,        0xE748,
	/* U+93D8 */        0xE749,        0xE74A,        0xE74B,        0xE74C,        0xE74D,        0xE74E,        0xE74F,        0xE750,
	/* U+93E0 */        0xE751,        0xE752,        0xE753,        0xE754,        0xE755,        0xE756,        0xE757,        0xE758,
	/* U+93E8 */        0xE759,        0xE75A,        0xE75B,        0xE75C,        0xE75D,        0xE75E,        0xE75F,        0xE760,
	/* U+93F0 */        0xE761,        0xE762,        0xE763,        0xE764,        0xE765,        0xE766,        0xE767,        0xE768,
	/* U+93F8 */        0xE769,        0xE76A,        0xE76B,        0xE76C,        0xE76D,        0xE76E,        0xE76F,        0xE770,
	/* U+9400 */        0xE771,        0xE772,        0xE773,        0xE774,        0xE775,        0xE776,        0xE777,        0xE778,
	/* U+9408 */        0xE779,        0xE77A,        0xE77B,        0xE77C,        0xE77D,        0xE77E,        0xE780,        0xE781,
	/* U+9410 */        0xE782,        0xE783,        0xE784,        0xE785,        0xE786,        0xE787,        0xE788,        0xE789,
	/* U+9418 */        0xE78A,        0xE78B,        0xE78C,        0xE78D,        0xE78E,        0xE78F,        0xE790,        0xE791,
	/* U+9420 */        0xE792,        0xE793,        0xE794,        0xE795,        0xE796,        0xE797,        0xE798,        0xE799,
	/* U+9428 */        0xE79A,        0xE79B,        0xE79C,        0xE79D,        0xE79E,        0xE79F,        0xE7A0,        0xE840,
	/* U+9430 */        0xE841,        0xE842,        0xE843,        0xE844,        0xE845,        0xE846,        0xE847,        0xE848,
	/* U+9438 */        0xE849,        0xE84A,        0xE84B,        0xE84C,        0xE84D,        0xE84E,        0xF6CD,        0xE84F,
	/* U+9440 */        0xE850,        0xE851,        0xE852,        0xE853,        0xE854,        0xE855,        0xE856,        0xE857,
	/* U+9448 */        0xE858,        0xE859,        0xE85A,        0xE85B,        0xE85C,        0xE85D,        0xE85E,        0xE85F,
	/* U+9450 */        0xE860,        0xE861,        0xE862,        0xE863,        0xE864,        0xE865,        0xE866,        0xE867,
	/* U+9458 */        0xE868,        0xE869,        0xE86A,        0xE86B,        0xE86C,        0xE86D,        0xE86E,        0xE86F,
	/* U+9460 */        0xE870,        0xE871,        0xE872,        0xE873,        0xE874,        0xE875,        0xE876,        0xE877,
	/* U+9468 */        0xE878,        0xE879,        0xE87A,        0xF6CE,        0xE87B,        0xE87C,        0xE87D,        0xE87E,
	/* U+9470 */        0xE880,        0xE881,        0xE882,        0xE883,        0xE884,        0xE885,        0xE886,        0xE887,
	/* U+9478 */        0xE888,        0xE889,        0xE88A,        0xE88B,        0xE88C,        0xE88D,        0xE88E,        0xE88F,
	/* U+9480 */        0xE890,        0xE891,        0xE892,        0xE893,        0xE894,        0xEEC4,        0xEEC5,        0xEEC6,
	/* U+9488 */        0xD5EB,        0xB6A4,        0xEEC8,        0xEEC7,        0xEEC9,        0xEECA,        0xC7A5,        0xEECB,
	/* U+9490 */        0xEECC,        0xE895,        0xB7B0,        0xB5F6,        0xEECD,        0xEECF,        0xE896,        0xEECE,
	/* U+9498 */        0xE897,        0xB8C6,        0xEED0,        0xEED1,        0xEED2,        0xB6DB,        0xB3AE,        0xD6D3,
	/* U+94A0 */        0xC4C6,        0xB1B5,        0xB8D6,        0xEED3,        0xEED4,        0xD4BF,        0xC7D5,        0xBEFB,
	/* U+94A8 */        0xCED9,        0xB9B3,        0xEED6,        0xEED5,        0xEED8,        0xEED7,        0xC5A5,        0xEED9,
	/* U+94B0 */        0xEEDA,        0xC7AE,        0xEEDB,        0xC7AF,        0xEEDC,        0xB2A7,        0xEEDD,        0xEEDE,
	/* U+94B8 */        0xEEDF,        0xEEE0,        0xEEE1,        0xD7EA,        0xEEE2,        0xEEE3,        0xBCD8,        0xEEE4,
	/* U+94C0 */        0xD3CB,        0xCCFA,        0xB2AC,        0xC1E5,        0xEEE5,        0xC7A6,        0xC3AD,        0xE898,
	/* U+94C8 */        0xEEE6,        0xEEE7,        0xEEE8,        0xEEE9,        0xEEEA,        0xEEEB,        0xEEEC,        0xE899,
	/* U+94D0 */        0xEEED,        0xEEEE,        0xEEEF,        0xE89A,        0xE89B,        0xEEF0,        0xEEF1,        0xEEF2,
	/* U+94D8 */        0xEEF4,        0xEEF3,        0xE89C,        0xEEF5,        0xCDAD,        0xC2C1,        0xEEF6,        0xEEF7,
	/* U+94E0 */        0xEEF8,        0xD5A1,        0xEEF9,        0xCFB3,        0xEEFA,        0xEEFB,        0xE89D,        0xEEFC,
	/* U+94E8 */        0xEEFD,        0xEFA1,        0xEEFE,        0xEFA2,        0xB8F5,        0xC3FA,        0xEFA3,        0xEFA4,
	/* U+94F0 */        0xBDC2,        0xD2BF,        0xB2F9,        0xEFA5,        0xEFA6,        0xEFA7,        0xD2F8,        0xEFA8,
	/* U+94F8 */        0xD6FD,        0xEFA9,        0xC6CC,        0xE89E,        0xEFAA,        0xEFAB,        0xC1B4,        0xEFAC,
	/* U+9500 */        0xCFFA,        0xCBF8,        0xEFAE,        0xEFAD,        0xB3FA,        0xB9F8,        0xEFAF,        0xEFB0,
	/* U+9508 */        0xD0E2,        0xEFB1,        0xEFB2,        0xB7E6,        0xD0BF,        0xEFB3,        0xEFB4,        0xEFB5,
	/* U+9510 */        0xC8F1,        0xCCE0,        0xEFB6,        0xEFB7,        0xEFB8,        0xEFB9,        0xEFBA,        0xD5E0,
	/* U+9518 */        0xEFBB,        0xB4ED,        0xC3AA,        0xEFBC,        0xE89F,        0xEFBD,        0xEFBE,        0xEFBF,
	/* U+9520 */        0xE8A0,        0xCEFD,        0xEFC0,        0xC2E0,        0xB4B8,        0xD7B6,        0xBDF5,        0xE940,
	/* U+9528 */        0xCFC7,        0xEFC3,        0xEFC1,        0xEFC2,        0xEFC4,        0xB6A7,        0xBCFC,        0xBEE2,
	/* U+9530 */        0xC3CC,        0xEFC5,        0xEFC6,        0xE941,        0xEFC7,        0xEFCF,        0xEFC8,        0xEFC9,
	/* U+9538 */        0xEFCA,        0xC7C2,        0xEFF1,        0xB6CD,        0xEFCB,        0xE942,        0xEFCC,        0xEFCD,
	/* U+9540 */        0xB6C6,        0xC3BE,        0xEFCE,        0xE943,        0xEFD0,        0xEFD1,        0xEFD2,        0xD5F2,
	/* U+9548 */        0xE944,        0xEFD3,        0xC4F7,        0xE945,        0xEFD4,        0xC4F8,        0xEFD5,        0xEFD6,
	/* U+9550 */        0xB8E4,        0xB0F7,        0xEFD7,        0xEFD8,        0xEFD9,        0xE946,        0xEFDA,        0xEFDB,
	/* U+9558 */        0xEFDC,        0xEFDD,        0xE947,        0xEFDE,        0xBEB5,        0xEFE1,        0xEFDF,        0xEFE0,
	/* U+9560 */        0xE948,        0xEFE2,        0xEFE3,        0xC1CD,        0xEFE4,        0xEFE5,        0xEFE6,        0xEFE7,
	/* U+9568 */        0xEFE8,        0xEFE9,        0xEFEA,        0xEFEB,        0xEFEC,        0xC0D8,        0xE949,        0xEFED,
	/* U+9570 */        0xC1AD,        0xEFEE,        0xEFEF,        0xEFF0,        0xE94A,        0xE94B,        0xCFE2,        0xE94C,
	/* U+9578 */        0xE94D,        0xE94E,        0xE94F,        0xE950,        0xE951,        0xE952,        0xE953,        0xB3A4,
	/* U+9580 */        0xE954,        0xE955,        0xE956,        0xE957,        0xE958,        0xE959,        0xE95A,        0xE95B,
	/* U+9588 */        0xE95C,        0xE95D,        0xE95E,        0xE95F,        0xE960,        0xE961,        0xE962,        0xE963,
	/* U+9590 */        0xE964,        0xE965,        0xE966,        0xE967,        0xE968,        0xE969,        0xE96A,        0xE96B,
	/* U+9598 */        0xE96C,        0xE96D,        0xE96E,        0xE96F,        0xE970,        0xE971,        0xE972,        0xE973,
	/* U+95A0 */        0xE974,        0xE975,        0xE976,        0xE977,        0xE978,        0xE979,        0xE97A,        0xE97B,
	/* U+95A8 */        0xE97C,        0xE97D,        0xE97E,        0xE980,        0xE981,        0xE982,        0xE983,        0xE984,
	/* U+95B0 */        0xE985,        0xE986,        0xE987,        0xE988,        0xE989,        0xE98A,        0xE98B,        0xE98C,
	/* U+95B8 */        0xE98D,        0xE98E,        0xE98F,        0xE990,        0xE991,        0xE992,        0xE993,        0xE994,
	/* U+95C0 */        0xE995,        0xE996,        0xE997,        0xE998,        0xE999,        0xE99A,        0xE99B,        0xE99C,
	/* U+95C8 */        0xE99D,        0xE99E,        0xE99F,        0xE9A0,        0xEA40,        0xEA41,        0xEA42,        0xEA43,
	/* U+95D0 */        0xEA44,        0xEA45,        0xEA46,        0xEA47,        0xEA48,        0xEA49,        0xEA4A,        0xEA4B,
	/* U+95D8 */        0xEA4C,        0xEA4D,        0xEA4E,        0xEA4F,        0xEA50,        0xEA51,        0xEA52,        0xEA53,
	/* U+95E0 */        0xEA54,        0xEA55,        0xEA56,        0xEA57,        0xEA58,        0xEA59,        0xEA5A,        0xEA5B,
	/* U+95E8 */        0xC3C5,        0xE3C5,        0xC9C1,        0xE3C6,        0xEA5C,        0xB1D5,        0xCECA,        0xB4B3,
	/* U+95F0 */        0xC8F2,        0xE3C7,        0xCFD0,        0xE3C8,        0xBCE4,        0xE3C9,        0xE3CA,        0xC3C6,
	/* U+95F8 */        0xD5A2,        0xC4D6,        0xB9EB,        0xCEC5,        0xE3CB,        0xC3F6,        0xE3CC,        0xEA5D,
	/* U+9600 */        0xB7A7,        0xB8F3,        0xBAD2,        0xE3CD,        0xE3CE,        0xD4C4,        0xE3CF,        0xEA5E,
	/* U+9608 */        0xE3D0,        0xD1CB,        0xE3D1,        0xE3D2,        0xE3D3,        0xE3D4,        0xD1D6,        0xE3D5,
	/* U+9610 */        0xB2FB,        0xC0BB,        0xE3D6,        0xEA5F,        0xC0AB,        0xE3D7,        0xE3D8,        0xE3D9,
	/* U+9618 */        0xEA60,        0xE3DA,        0xE3DB,        0xEA61,        0xB8B7,        0xDAE2,        0xEA62,        0xB6D3,
	/* U+9620 */        0xEA63,        0xDAE4,        0xDAE3,        0xEA64,        0xEA65,        0xEA66,        0xEA67,        0xEA68,
	/* U+9628 */        0xEA69,        0xEA6A,        0xDAE6,        0xEA6B,        0xEA6C,        0xEA6D,        0xC8EE,        0xEA6E,
	/* U+9630 */        0xEA6F,        0xDAE5,        0xB7C0,        0xD1F4,        0xD2F5,        0xD5F3,        0xBDD7,        0xEA70,
	/* U+9638 */        0xEA71,        0xEA72,        0xEA73,        0xD7E8,        0xDAE8,        0xDAE7,        0xEA74,        0xB0A2,
	/* U+9640 */        0xCDD3,        0xEA75,        0xDAE9,        0xEA76,        0xB8BD,        0xBCCA,        0xC2BD,        0xC2A4,
	/* U+9648 */        0xB3C2,        0xDAEA,        0xEA77,        0xC2AA,        0xC4B0,        0xBDB5,        0xEA78,        0xEA79,
	/* U+9650 */        0xCFDE,        0xEA7A,        0xEA7B,        0xEA7C,        0xDAEB,        0xC9C2,        0xEA7D,        0xEA7E,
	/* U+9658 */        0xEA80,        0xEA81,        0xEA82,        0xB1DD,        0xEA83,        0xEA84,        0xEA85,        0xDAEC,
	/* U+9660 */        0xEA86,        0xB6B8,        0xD4BA,        0xEA87,        0xB3FD,        0xEA88,        0xEA89,        0xDAED,
	/* U+9668 */        0xD4C9,        0xCFD5,        0xC5E3,        0xEA8A,        0xDAEE,        0xEA8B,        0xEA8C,        0xEA8D,
	/* U+9670 */        0xEA8E,        0xEA8F,        0xDAEF,        0xEA90,        0xDAF0,        0xC1EA,        0xCCD5,        0xCFDD,
	/* U+9678 */        0xEA91,        0xEA92,        0xEA93,        0xEA94,        0xEA95,        0xEA96,        0xEA97,        0xEA98,
	/* U+9680 */        0xEA99,        0xEA9A,        0xEA9B,        0xEA9C,        0xEA9D,        0xD3E7,        0xC2A1,        0xEA9E,
	/* U+9688 */        0xDAF1,        0xEA9F,        0xEAA0,        0xCBE5,        0xEB40,        0xDAF2,        0xEB41,        0xCBE6,
	/* U+9690 */        0xD2FE,        0xEB42,        0xEB43,        0xEB44,        0xB8F4,        0xEB45,        0xEB46,        0xDAF3,
	/* U+9698 */        0xB0AF,        0xCFB6,        0xEB47,        0xEB48,        0xD5CF,        0xEB49,        0xEB4A,        0xEB4B,
	/* U+96A0 */        0xEB4C,        0xEB4D,        0xEB4E,        0xEB4F,        0xEB50,        0xEB51,        0xEB52,        0xCBED,
	/* U+96A8 */        0xEB53,        0xEB54,        0xEB55,        0xEB56,        0xEB57,        0xEB58,        0xEB59,        0xEB5A,
	/* U+96B0 */        0xDAF4,        0xEB5B,        0xEB5C,        0xE3C4,        0xEB5D,        0xEB5E,        0xC1A5,        0xEB5F,
	/* U+96B8 */        0xEB60,        0xF6BF,        0xEB61,        0xEB62,        0xF6C0,        0xF6C1,        0xC4D1,        0xEB63,
	/* U+96C0 */        0xC8B8,        0xD1E3,        0xEB64,        0xEB65,        0xD0DB,        0xD1C5,        0xBCAF,        0xB9CD,
	/* U+96C8 */        0xEB66,        0xEFF4,        0xEB67,        0xEB68,        0xB4C6,        0xD3BA,        0xF6C2,        0xB3FB,
	/* U+96D0 */        0xEB69,        0xEB6A,        0xF6C3,        0xEB6B,        0xEB6C,        0xB5F1,        0xEB6D,        0xEB6E,
	/* U+96D8 */        0xEB6F,        0xEB70,        0xEB71,        0xEB72,        0xEB73,        0xEB74,        0xEB75,        0xEB76,
	/* U+96E0 */        0xF6C5,        0xEB77,        0xEB78,        0xEB79,        0xEB7A,        0xEB7B,        0xEB7C,        0xEB7D,
	/* U+96E8 */        0xD3EA,        0xF6A7,        0xD1A9,        0xEB7E,        0xEB80,        0xEB81,        0xEB82,        0xF6A9,
	/* U+96F0 */        0xEB83,        0xEB84,        0xEB85,        0xF6A8,        0xEB86,        0xEB87,        0xC1E3,        0xC0D7,
	/* U+96F8 */        0xEB88,        0xB1A2,        0xEB89,        0xEB8A,        0xEB8B,        0xEB8C,        0xCEED,        0xEB8D,
	/* U+9700 */        0xD0E8,        0xF6AB,        0xEB8E,        0xEB8F,        0xCFF6,        0xEB90,        0xF6AA,        0xD5F0,
	/* U+9708 */        0xF6AC,        0xC3B9,        0xEB91,        0xEB92,        0xEB93,        0xBBF4,        0xF6AE,        0xF6AD,
	/* U+9710 */        0xEB94,        0xEB95,        0xEB96,        0xC4DE,        0xEB97,        0xEB98,        0xC1D8,        0xEB99,
	/* U+9718 */        0xEB9A,        0xEB9B,        0xEB9C,        0xEB9D,        0xCBAA,        0xEB9E,        0xCFBC,        0xEB9F,
	/* U+9720 */        0xEBA0,        0xEC40,        0xEC41,        0xEC42,        0xEC43,        0xEC44,        0xEC45,        0xEC46,
	/* U+9728 */        0xEC47,        0xEC48,        0xF6AF,        0xEC49,        0xEC4A,        0xF6B0,        0xEC4B,        0xEC4C,
	/* U+9730 */        0xF6B1,        0xEC4D,        0xC2B6,        0xEC4E,        0xEC4F,        0xEC50,        0xEC51,        0xEC52,
	/* U+9738 */        0xB0D4,        0xC5F9,        0xEC53,        0xEC54,        0xEC55,        0xEC56,        0xF6B2,        0xEC57,
	/* U+9740 */        0xEC58,        0xEC59,        0xEC5A,        0xEC5B,        0xEC5C,        0xEC5D,        0xEC5E,        0xEC5F,
	/* U+9748 */        0xEC60,        0xEC61,        0xEC62,        0xEC63,        0xEC64,        0xEC65,        0xEC66,        0xEC67,
	/* U+9750 */        0xEC68,        0xEC69,        0xC7E0,        0xF6A6,        0xEC6A,        0xEC6B,        0xBEB8,        0xEC6C,
	/* U+9758 */        0xEC6D,        0xBEB2,        0xEC6E,        0xB5E5,        0xEC6F,        0xEC70,        0xB7C7,        0xEC71,
	/* U+9760 */        0xBFBF,        0xC3D2,        0xC3E6,        0xEC72,        0xEC73,        0xD8CC,        0xEC74,        0xEC75,
	/* U+9768 */        0xEC76,        0xB8EF,        0xEC77,        0xEC78,        0xEC79,        0xEC7A,        0xEC7B,        0xEC7C,
	/* U+9770 */        0xEC7D,        0xEC7E,        0xEC80,        0xBDF9,        0xD1A5,        0xEC81,        0xB0D0,        0xEC82,
	/* U+9778 */        0xEC83,        0xEC84,        0xEC85,        0xEC86,        0xF7B0,        0xEC87,        0xEC88,        0xEC89,
	/* U+9780 */        0xEC8A,        0xEC8B,        0xEC8C,        0xEC8D,        0xEC8E,        0xF7B1,        0xEC8F,        0xEC90,
	/* U+9788 */        0xEC91,        0xEC92,        0xEC93,        0xD0AC,        0xEC94,        0xB0B0,        0xEC95,        0xEC96,
	/* U+9790 */        0xEC97,        0xF7B2,        0xF7B3,        0xEC98,        0xF7B4,        0xEC99,        0xEC9A,        0xEC9B,
	/* U+9798 */        0xC7CA,        0xEC9C,        0xEC9D,        0xEC9E,        0xEC9F,        0xECA0,        0xED40,        0xED41,
	/* U+97A0 */        0xBECF,        0xED42,        0xED43,        0xF7B7,        0xED44,        0xED45,        0xED46,        0xED47,
	/* U+97A8 */        0xED48,        0xED49,        0xED4A,        0xF7B6,        0xED4B,        0xB1DE,        0xED4C,        0xF7B5,
	/* U+97B0 */        0xED4D,        0xED4E,        0xF7B8,        0xED4F,        0xF7B9,        0xED50,        0xED51,        0xED52,
	/* U+97B8 */        0xED53,        0xED54,        0xED55,        0xED56,        0xED57,        0xED58,        0xED59,        0xED5A,
	/* U+97C0 */        0xED5B,        0xED5C,        0xED5D,        0xED5E,        0xED5F,        0xED60,        0xED61,        0xED62,
	/* U+97C8 */        0xED63,        0xED64,        0xED65,        0xED66,        0xED67,        0xED68,        0xED69,        0xED6A,
	/* U+97D0 */        0xED6B,        0xED6C,        0xED6D,        0xED6E,        0xED6F,        0xED70,        0xED71,        0xED72,
	/* U+97D8 */        0xED73,        0xED74,        0xED75,        0xED76,        0xED77,        0xED78,        0xED79,        0xED7A,
	/* U+97E0 */        0xED7B,        0xED7C,        0xED7D,        0xED7E,        0xED80,        0xED81,        0xCEA4,        0xC8CD,
	/* U+97E8 */        0xED82,        0xBAAB,        0xE8B8,        0xE8B9,        0xE8BA,        0xBEC2,        0xED83,        0xED84,
	/* U+97F0 */        0xED85,        0xED86,        0xED87,        0xD2F4,        0xED88,        0xD4CF,        0xC9D8,        0xED89,
	/* U+97F8 */        0xED8A,        0xED8B,        0xED8C,        0xED8D,        0xED8E,        0xED8F,        0xED90,        0xED91,
	/* U+9800 */        0xED92,        0xED93,        0xED94,        0xED95,        0xED96,        0xED97,        0xED98,        0xED99,
	/* U+9808 */        0xED9A,        0xED9B,        0xED9C,        0xED9D,        0xED9E,        0xED9F,        0xEDA0,        0xEE40,
	/* U+9810 */        0xEE41,        0xEE42,        0xEE43,        0xEE44,        0xEE45,        0xEE46,        0xEE47,        0xEE48,
	/* U+9818 */        0xEE49,        0xEE4A,        0xEE4B,        0xEE4C,        0xEE4D,        0xEE4E,        0xEE4F,        0xEE50,
	/* U+9820 */        0xEE51,        0xEE52,        0xEE53,        0xEE54,        0xEE55,        0xEE56,        0xEE57,        0xEE58,
	/* U+9828 */        0xEE59,        0xEE5A,        0xEE5B,        0xEE5C,        0xEE5D,        0xEE5E,        0xEE5F,        0xEE60,
	/* U+9830 */        0xEE61,        0xEE62,        0xEE63,        0xEE64,        0xEE65,        0xEE66,        0xEE67,        0xEE68,
	/* U+9838 */        0xEE69,        0xEE6A,        0xEE6B,        0xEE6C,        0xEE6D,        0xEE6E,        0xEE6F,        0xEE70,
	/* U+9840 */        0xEE71,        0xEE72,        0xEE73,        0xEE74,        0xEE75,        0xEE76,        0xEE77,        0xEE78,
	/* U+9848 */        0xEE79,        0xEE7A,        0xEE7B,        0xEE7C,        0xEE7D,        0xEE7E,        0xEE80,        0xEE81,
	/* U+9850 */        0xEE82,        0xEE83,        0xEE84,        0xEE85,        0xEE86,        0xEE87,        0xEE88,        0xEE89,
	/* U+9858 */        0xEE8A,        0xEE8B,        0xEE8C,        0xEE8D,        0xEE8E,        0xEE8F,        0xEE90,        0xEE91,
	/* U+9860 */        0xEE92,        0xEE93,        0xEE94,        0xEE95,        0xEE96,        0xEE97,        0xEE98,        0xEE99,
	/* U+9868 */        0xEE9A,        0xEE9B,        0xEE9C,        0xEE9D,        0xEE9E,        0xEE9F,        0xEEA0,        0xEF40,
	/* U+9870 */        0xEF41,        0xEF42,        0xEF43,        0xEF44,        0xEF45,        0xD2B3,        0xB6A5,        0xC7EA,
	/* U+9878 */        0xF1FC,        0xCFEE,        0xCBB3,        0xD0EB,        0xE7EF,        0xCDE7,        0xB9CB,        0xB6D9,
	/* U+9880 */        0xF1FD,        0xB0E4,        0xCBCC,        0xF1FE,        0xD4A4,        0xC2AD,        0xC1EC,        0xC6C4,
	/* U+9888 */        0xBEB1,        0xF2A1,        0xBCD5,        0xEF46,        0xF2A2,        0xF2A3,        0xEF47,        0xF2A4,
	/* U+9890 */        0xD2C3,        0xC6B5,        0xEF48,        0xCDC7,        0xF2A5,        0xEF49,        0xD3B1,        0xBFC5,
	/* U+9898 */        0xCCE2,        0xEF4A,        0xF2A6,        0xF2A7,        0xD1D5,        0xB6EE,        0xF2A8,        0xF2A9,
	/* U+98A0 */        0xB5DF,        0xF2AA,        0xF2AB,        0xEF4B,        0xB2FC,        0xF2AC,        0xF2AD,        0xC8A7,
	/* U+98A8 */        0xEF4C,        0xEF4D,        0xEF4E,        0xEF4F,        0xEF50,        0xEF51,        0xEF52,        0xEF53,
	/* U+98B0 */        0xEF54,        0xEF55,        0xEF56,        0xEF57,        0xEF58,        0xEF59,        0xEF5A,        0xEF5B,
	/* U+98B8 */        0xEF5C,        0xEF5D,        0xEF5E,        0xEF5F,        0xEF60,        0xEF61,        0xEF62,        0xEF63,
	/* U+98C0 */        0xEF64,        0xEF65,        0xEF66,        0xEF67,        0xEF68,        0xEF69,        0xEF6A,        0xEF6B,
	/* U+98C8 */        0xEF6C,        0xEF6D,        0xEF6E,        0xEF6F,        0xEF70,        0xEF71,        0xB7E7,        0xEF72,
	/* U+98D0 */        0xEF73,        0xECA9,        0xECAA,        0xECAB,        0xEF74,        0xECAC,        0xEF75,        0xEF76,
	/* U+98D8 */        0xC6AE,        0xECAD,        0xECAE,        0xEF77,        0xEF78,        0xEF79,        0xB7C9,        0xCAB3,
	/* U+98E0 */        0xEF7A,        0xEF7B,        0xEF7C,        0xEF7D,        0xEF7E,        0xEF80,        0xEF81,        0xE2B8,
	/* U+98E8 */        0xF7CF,        0xEF82,        0xEF83,        0xEF84,        0xEF85,        0xEF86,        0xEF87,        0xEF88,
	/* U+98F0 */        0xEF89,        0xEF8A,        0xEF8B,        0xEF8C,        0xEF8D,        0xEF8E,        0xEF8F,        0xEF90,
	/* U+98F8 */        0xEF91,        0xEF92,        0xEF93,        0xEF94,        0xEF95,        0xEF96,        0xEF97,        0xEF98,
	/* U+9900 */        0xEF99,        0xEF9A,        0xEF9B,        0xEF9C,        0xEF9D,        0xEF9E,        0xEF9F,        0xEFA0,
	/* U+9908 */        0xF040,        0xF041,        0xF042,        0xF043,        0xF044,        0xF7D0,        0xF045,        0xF046,
	/* U+9910 */        0xB2CD,        0xF047,        0xF048,        0xF049,        0xF04A,        0xF04B,        0xF04C,        0xF04D,
	/* U+9918 */        0xF04E,        0xF04F,        0xF050,        0xF051,        0xF052,        0xF053,        0xF054,        0xF055,
	/* U+9920 */        0xF056,        0xF057,        0xF058,        0xF059,        0xF05A,        0xF05B,        0xF05C,        0xF05D,
	/* U+9928 */        0xF05E,        0xF05F,        0xF060,        0xF061,        0xF062,        0xF063,        0xF7D1,        0xF064,
	/* U+9930 */        0xF065,        0xF066,        0xF067,        0xF068,        0xF069,        0xF06A,        0xF06B,        0xF06C,
	/* U+9938 */        0xF06D,        0xF06E,        0xF06F,        0xF070,        0xF071,        0xF072,        0xF073,        0xF074,
	/* U+9940 */        0xF075,        0xF076,        0xF077,        0xF078,        0xF079,        0xF07A,        0xF07B,        0xF07C,
	/* U+9948 */        0xF07D,        0xF07E,        0xF080,        0xF081,        0xF082,        0xF083,        0xF084,        0xF085,
	/* U+9950 */        0xF086,        0xF087,        0xF088,        0xF089,        0xF7D3,        0xF7D2,        0xF08A,        0xF08B,
	/* U+9958 */        0xF08C,        0xF08D,        0xF08E,        0xF08F,        0xF090,        0xF091,        0xF092,        0xF093,
	/* U+9960 */        0xF094,        0xF095,        0xF096,        0xE2BB,        0xF097,        0xBCA2,        0xF098,        0xE2BC,
	/* U+9968 */        0xE2BD,        0xE2BE,        0xE2BF,        0xE2C0,        0xE2C1,        0xB7B9,        0xD2FB,        0xBDA4,
	/* U+9970 */        0xCACE,        0xB1A5,        0xCBC7,        0xF099,        0xE2C2,        0xB6FC,        0xC8C4,        0xE2C3,
	/* U+9978 */        0xF09A,        0xF09B,        0xBDC8,        0xF09C,        0xB1FD,        0xE2C4,        0xF09D,        0xB6F6,
	/* U+9980 */        0xE2C5,        0xC4D9,        0xF09E,        0xF09F,        0xE2C6,        0xCFDA,        0xB9DD,        0xE2C7,
	/* U+9988 */        0xC0A1,        0xF0A0,        0xE2C8,        0xB2F6,        0xF140,        0xE2C9,        0xF141,        0xC1F3,
	/* U+9990 */        0xE2CA,        0xE2CB,        0xC2F8,        0xE2CC,        0xE2CD,        0xE2CE,        0xCAD7,        0xD8B8,
	/* U+9998 */        0xD9E5,        0xCFE3,        0xF142,        0xF143,        0xF144,        0xF145,        0xF146,        0xF147,
	/* U+99A0 */        0xF148,        0xF149,        0xF14A,        0xF14B,        0xF14C,        0xF0A5,        0xF14D,        0xF14E,
	/* U+99A8 */        0xDCB0,        0xF14F,        0xF150,        0xF151,        0xF152,        0xF153,        0xF154,        0xF155,
	/* U+99B0 */        0xF156,        0xF157,        0xF158,        0xF159,        0xF15A,        0xF15B,        0xF15C,        0xF15D,
	/* U+99B8 */        0xF15E,        0xF15F,        0xF160,        0xF161,        0xF162,        0xF163,        0xF164,        0xF165,
	/* U+99C0 */        0xF166,        0xF167,        0xF168,        0xF169,        0xF16A,        0xF16B,        0xF16C,        0xF16D,
	/* U+99C8 */        0xF16E,        0xF16F,        0xF170,        0xF171,        0xF172,        0xF173,        0xF174,        0xF175,
	/* U+99D0 */        0xF176,        0xF177,        0xF178,        0xF179,        0xF17A,        0xF17B,        0xF17C,        0xF17D,
	/* U+99D8 */        0xF17E,        0xF180,        0xF181,        0xF182,        0xF183,        0xF184,        0xF185,        0xF186,
	/* U+99E0 */        0xF187,        0xF188,        0xF189,        0xF18A,        0xF18B,        0xF18C,        0xF18D,        0xF18E,
	/* U+99E8 */        0xF18F,        0xF190,        0xF191,        0xF192,        0xF193,        0xF194,        0xF195,        0xF196,
	/* U+99F0 */        0xF197,        0xF198,        0xF199,        0xF19A,        0xF19B,        0xF19C,        0xF19D,        0xF19E,
	/* U+99F8 */        0xF19F,        0xF1A0,        0xF240,        0xF241,        0xF242,        0xF243,        0xF244,        0xF245,
	/* U+9A00 */        0xF246,        0xF247,        0xF248,        0xF249,        0xF24A,        0xF24B,        0xF24C,        0xF24D,
	/* U+9A08 */        0xF24E,        0xF24F,        0xF250,        0xF251,        0xF252,        0xF253,        0xF254,        0xF255,
	/* U+9A10 */        0xF256,        0xF257,        0xF258,        0xF259,        0xF25A,        0xF25B,        0xF25C,        0xF25D,
	/* U+9A18 */        0xF25E,        0xF25F,        0xF260,        0xF261,        0xF262,        0xF263,        0xF264,        0xF265,
	/* U+9A20 */        0xF266,        0xF267,        0xF268,        0xF269,        0xF26A,        0xF26B,        0xF26C,        0xF26D,
	/* U+9A28 */        0xF26E,        0xF26F,        0xF270,        0xF271,        0xF272,        0xF273,        0xF274,        0xF275,
	/* U+9A30 */        0xF276,        0xF277,        0xF278,        0xF279,        0xF27A,        0xF27B,        0xF27C,        0xF27D,
	/* U+9A38 */        0xF27E,        0xF280,        0xF281,        0xF282,        0xF283,        0xF284,        0xF285,        0xF286,
	/* U+9A40 */        0xF287,        0xF288,        0xF289,        0xF28A,        0xF28B,        0xF28C,        0xF28D,        0xF28E,
	/* U+9A48 */        0xF28F,        0xF290,        0xF291,        0xF292,        0xF293,        0xF294,        0xF295,        0xF296,
	/* U+9A50 */        0xF297,        0xF298,        0xF299,        0xF29A,        0xF29B,        0xF29C,        0xF29D,        0xF29E,
	/* U+9A58 */        0xF29F,        0xF2A0,        0xF340,        0xF341,        0xF342,        0xF343,        0xF344,        0xF345,
	/* U+9A60 */        0xF346,        0xF347,        0xF348,        0xF349,        0xF34A,        0xF34B,        0xF34C,        0xF34D,
	/* U+9A68 */        0xF34E,        0xF34F,        0xF350,        0xF351,        0xC2ED,        0xD4A6,        0xCDD4,        0xD1B1,
	/* U+9A70 */        0xB3DB,        0xC7FD,        0xF352,        0xB2B5,        0xC2BF,        0xE6E0,        0xCABB,        0xE6E1,
	/* U+9A78 */        0xE6E2,        0xBED4,        0xE6E3,        0xD7A4,        0xCDD5,        0xE6E5,        0xBCDD,        0xE6E4,
	/* U+9A80 */        0xE6E6,        0xE6E7,        0xC2EE,        0xF353,        0xBDBE,        0xE6E8,        0xC2E6,        0xBAA7,
	/* U+9A88 */        0xE6E9,        0xF354,        0xE6EA,        0xB3D2,        0xD1E9,        0xF355,        0xF356,        0xBFA5,
	/* U+9A90 */        0xE6EB,        0xC6EF,        0xE6EC,        0xE6ED,        0xF357,        0xF358,        0xE6EE,        0xC6AD,
	/* U+9A98 */        0xE6EF,        0xF359,        0xC9A7,        0xE6F0,        0xE6F1,        0xE6F2,        0xE5B9,        0xE6F3,
	/* U+9AA0 */        0xE6F4,        0xC2E2,        0xE6F5,        0xE6F6,        0xD6E8,        0xE6F7,        0xF35A,        0xE6F8,
	/* U+9AA8 */        0xB9C7,        0xF35B,        0xF35C,        0xF35D,        0xF35E,        0xF35F,        0xF360,        0xF361,
	/* U+9AB0 */        0xF7BB,        0xF7BA,        0xF362,        0xF363,        0xF364,        0xF365,        0xF7BE,        0xF7BC,
	/* U+9AB8 */        0xBAA1,        0xF366,        0xF7BF,        0xF367,        0xF7C0,        0xF368,        0xF369,        0xF36A,
	/* U+9AC0 */        0xF7C2,        0xF7C1,        0xF7C4,        0xF36B,        0xF36C,        0xF7C3,        0xF36D,        0xF36E,
	/* U+9AC8 */        0xF36F,        0xF370,        0xF371,        0xF7C5,        0xF7C6,        0xF372,        0xF373,        0xF374,
	/* U+9AD0 */        0xF375,        0xF7C7,        0xF376,        0xCBE8,        0xF377,        0xF378,        0xF379,        0xF37A,
	/* U+9AD8 */        0xB8DF,        0xF37B,        0xF37C,        0xF37D,        0xF37E,        0xF380,        0xF381,        0xF7D4,
	/* U+9AE0 */        0xF382,        0xF7D5,        0xF383,        0xF384,        0xF385,        0xF386,        0xF7D6,        0xF387,
	/* U+9AE8 */        0xF388,        0xF389,        0xF38A,        0xF7D8,        0xF38B,        0xF7DA,        0xF38C,        0xF7D7,
	/* U+9AF0 */        0xF38D,        0xF38E,        0xF38F,        0xF390,        0xF391,        0xF392,        0xF393,        0xF394,
	/* U+9AF8 */        0xF395,        0xF7DB,        0xF396,        0xF7D9,        0xF397,        0xF398,        0xF399,        0xF39A,
	/* U+9B00 */        0xF39B,        0xF39C,        0xF39D,        0xD7D7,        0xF39E,        0xF39F,        0xF3A0,        0xF440,
	/* U+9B08 */        0xF7DC,        0xF441,        0xF442,        0xF443,        0xF444,        0xF445,        0xF446,        0xF7DD,
	/* U+9B10 */        0xF447,        0xF448,        0xF449,        0xF7DE,        0xF44A,        0xF44B,        0xF44C,        0xF44D,
	/* U+9B18 */        0xF44E,        0xF44F,        0xF450,        0xF451,        0xF452,        0xF453,        0xF454,        0xF7DF,
	/* U+9B20 */        0xF455,        0xF456,        0xF457,        0xF7E0,        0xF458,        0xF459,        0xF45A,        0xF45B,
	/* U+9B28 */        0xF45C,        0xF45D,        0xF45E,        0xF45F,        0xF460,        0xF461,        0xF462,        0xDBCB,
	/* U+9B30 */        0xF463,        0xF464,        0xD8AA,        0xF465,        0xF466,        0xF467,        0xF468,        0xF469,
	/* U+9B38 */        0xF46A,        0xF46B,        0xF46C,        0xE5F7,        0xB9ED,        0xF46D,        0xF46E,        0xF46F,
	/* U+9B40 */        0xF470,        0xBFFD,        0xBBEA,        0xF7C9,        0xC6C7,        0xF7C8,        0xF471,        0xF7CA,
	/* U+9B48 */        0xF7CC,        0xF7CB,        0xF472,        0xF473,        0xF474,        0xF7CD,        0xF475,        0xCEBA,
	/* U+9B50 */        0xF476,        0xF7CE,        0xF477,        0xF478,        0xC4A7,        0xF479,        0xF47A,        0xF47B,
	/* U+9B58 */        0xF47C,        0xF47D,        0xF47E,        0xF480,        0xF481,        0xF482,        0xF483,        0xF484,
	/* U+9B60 */        0xF485,        0xF486,        0xF487,        0xF488,        0xF489,        0xF48A,        0xF48B,        0xF48C,
	/* U+9B68 */        0xF48D,        0xF48E,        0xF48F,        0xF490,        0xF491,        0xF492,        0xF493,        0xF494,
	/* U+9B70 */        0xF495,        0xF496,        0xF497,        0xF498,        0xF499,        0xF49A,        0xF49B,        0xF49C,
	/* U+9B78 */        0xF49D,        0xF49E,        0xF49F,        0xF4A0,        0xF540,        0xF541,        0xF542,        0xF543,
	/* U+9B80 */        0xF544,        0xF545,        0xF546,        0xF547,        0xF548,        0xF549,        0xF54A,        0xF54B,
	/* U+9B88 */        0xF54C,        0xF54D,        0xF54E,        0xF54F,        0xF550,        0xF551,        0xF552,        0xF553,
	/* U+9B90 */        0xF554,        0xF555,        0xF556,        0xF557,        0xF558,        0xF559,        0xF55A,        0xF55B,
	/* U+9B98 */        0xF55C,        0xF55D,        0xF55E,        0xF55F,        0xF560,        0xF561,        0xF562,        0xF563,
	/* U+9BA0 */        0xF564,        0xF565,        0xF566,        0xF567,        0xF568,        0xF569,        0xF56A,        0xF56B,
	/* U+9BA8 */        0xF56C,        0xF56D,        0xF56E,        0xF56F,        0xF570,        0xF571,        0xF572,        0xF573,
	/* U+9BB0 */        0xF574,        0xF575,        0xF576,        0xF577,        0xF578,        0xF579,        0xF57A,        0xF57B,
	/* U+9BB8 */        0xF57C,        0xF57D,        0xF57E,        0xF580,        0xF581,        0xF582,        0xF583,        0xF584,
	/* U+9BC0 */        0xF585,        0xF586,        0xF587,        0xF588,        0xF589,        0xF58A,        0xF58B,        0xF58C,
	/* U+9BC8 */        0xF58D,        0xF58E,        0xF58F,        0xF590,        0xF591,        0xF592,        0xF593,        0xF594,
	/* U+9BD0 */        0xF595,        0xF596,        0xF597,        0xF598,        0xF599,        0xF59A,        0xF59B,        0xF59C,
	/* U+9BD8 */        0xF59D,        0xF59E,        0xF59F,        0xF5A0,        0xF640,        0xF641,        0xF642,        0xF643,
	/* U+9BE0 */        0xF644,        0xF645,        0xF646,        0xF647,        0xF648,        0xF649,        0xF64A,        0xF64B,
	/* U+9BE8 */        0xF64C,        0xF64D,        0xF64E,        0xF64F,        0xF650,        0xF651,        0xF652,        0xF653,
	/* U+9BF0 */        0xF654,        0xF655,        0xF656,        0xF657,        0xF658,        0xF659,        0xF65A,        0xF65B,
	/* U+9BF8 */        0xF65C,        0xF65D,        0xF65E,        0xF65F,        0xF660,        0xF661,        0xF662,        0xF663,
	/* U+9C00 */        0xF664,        0xF665,        0xF666,        0xF667,        0xF668,        0xF669,        0xF66A,        0xF66B,
	/* U+9C08 */        0xF66C,        0xF66D,        0xF66E,        0xF66F,        0xF670,        0xF671,        0xF672,        0xF673,
	/* U+9C10 */        0xF674,        0xF675,        0xF676,        0xF677,        0xF678,        0xF679,        0xF67A,        0xF67B,
	/* U+9C18 */        0xF67C,        0xF67D,        0xF67E,        0xF680,        0xF681,        0xF682,        0xF683,        0xF684,
	/* U+9C20 */        0xF685,        0xF686,        0xF687,        0xF688,        0xF689,        0xF68A,        0xF68B,        0xF68C,
	/* U+9C28 */        0xF68D,        0xF68E,        0xF68F,        0xF690,        0xF691,        0xF692,        0xF693,        0xF694,
	/* U+9C30 */        0xF695,        0xF696,        0xF697,        0xF698,        0xF699,        0xF69A,        0xF69B,        0xF69C,
	/* U+9C38 */        0xF69D,        0xF69E,        0xF69F,        0xF6A0,        0xF740,        0xF741,        0xF742,        0xF743,
	/* U+9C40 */        0xF744,        0xF745,        0xF746,        0xF747,        0xF748,        0xF749,        0xF74A,        0xF74B,
	/* U+9C48 */        0xF74C,        0xF74D,        0xF74E,        0xF74F,        0xF750,        0xF751,        0xF752,        0xF753,
	/* U+9C50 */        0xF754,        0xF755,        0xF756,        0xF757,        0xF758,        0xF759,        0xF75A,        0xF75B,
	/* U+9C58 */        0xF75C,        0xF75D,        0xF75E,        0xF75F,        0xF760,        0xF761,        0xF762,        0xF763,
	/* U+9C60 */        0xF764,        0xF765,        0xF766,        0xF767,        0xF768,        0xF769,        0xF76A,        0xF76B,
	/* U+9C68 */        0xF76C,        0xF76D,        0xF76E,        0xF76F,        0xF770,        0xF771,        0xF772,        0xF773,
	/* U+9C70 */        0xF774,        0xF775,        0xF776,        0xF777,        0xF778,        0xF779,        0xF77A,        0xF77B,
	/* U+9C78 */        0xF77C,        0xF77D,        0xF77E,        0xF780,        0xD3E3,        0xF781,        0xF782,        0xF6CF,
	/* U+9C80 */        0xF783,        0xC2B3,        0xF6D0,        0xF784,        0xF785,        0xF6D1,        0xF6D2,        0xF6D3,
	/* U+9C88 */        0xF6D4,        0xF786,        0xF787,        0xF6D6,        0xF788,        0xB1AB,        0xF6D7,        0xF789,
	/* U+9C90 */        0xF6D8,        0xF6D9,        0xF6DA,        0xF78A,        0xF6DB,        0xF6DC,        0xF78B,        0xF78C,
	/* U+9C98 */        0xF78D,        0xF78E,        0xF6DD,        0xF6DE,        0xCFCA,        0xF78F,        0xF6DF,        0xF6E0,
	/* U+9CA0 */        0xF6E1,        0xF6E2,        0xF6E3,        0xF6E4,        0xC0F0,        0xF6E5,        0xF6E6,        0xF6E7,
	/* U+9CA8 */        0xF6E8,        0xF6E9,        0xF790,        0xF6EA,        0xF791,        0xF6EB,        0xF6EC,        0xF792,
	/* U+9CB0 */        0xF6ED,        0xF6EE,        0xF6EF,        0xF6F0,        0xF6F1,        0xF6F2,        0xF6F3,        0xF6F4,
	/* U+9CB8 */        0xBEA8,        0xF793,        0xF6F5,        0xF6F6,        0xF6F7,        0xF6F8,        0xF794,        0xF795,
	/* U+9CC0 */        0xF796,        0xF797,        0xF798,        0xC8FA,        0xF6F9,        0xF6FA,        0xF6FB,        0xF6FC,
	/* U+9CC8 */        0xF799,        0xF79A,        0xF6FD,        0xF6FE,        0xF7A1,        0xF7A2,        0xF7A3,        0xF7A4,
	/* U+9CD0 */        0xF7A5,        0xF79B,        0xF79C,        0xF7A6,        0xF7A7,        0xF7A8,        0xB1EE,        0xF7A9,
	/* U+9CD8 */        0xF7AA,        0xF7AB,        0xF79D,        0xF79E,        0xF7AC,        0xF7AD,        0xC1DB,        0xF7AE,
	/* U+9CE0 */        0xF79F,        0xF7A0,        0xF7AF,        0xF840,        0xF841,        0xF842,        0xF843,        0xF844,
	/* U+9CE8 */        0xF845,        0xF846,        0xF847,        0xF848,        0xF849,        0xF84A,        0xF84B,        0xF84C,
	/* U+9CF0 */        0xF84D,        0xF84E,        0xF84F,        0xF850,        0xF851,        0xF852,        0xF853,        0xF854,
	/* U+9CF8 */        0xF855,        0xF856,        0xF857,        0xF858,        0xF859,        0xF85A,        0xF85B,        0xF85C,
	/* U+9D00 */        0xF85D,        0xF85E,        0xF85F,        0xF860,        0xF861,        0xF862,        0xF863,        0xF864,
	/* U+9D08 */        0xF865,        0xF866,        0xF867,        0xF868,        0xF869,        0xF86A,        0xF86B,        0xF86C,
	/* U+9D10 */        0xF86D,        0xF86E,        0xF86F,        0xF870,        0xF871,        0xF872,        0xF873,        0xF874,
	/* U+9D18 */        0xF875,        0xF876,        0xF877,        0xF878,        0xF879,        0xF87A,        0xF87B,        0xF87C,
	/* U+9D20 */        0xF87D,        0xF87E,        0xF880,        0xF881,        0xF882,        0xF883,        0xF884,        0xF885,
	/* U+9D28 */        0xF886,        0xF887,        0xF888,        0xF889,        0xF88A,        0xF88B,        0xF88C,        0xF88D,
	/* U+9D30 */        0xF88E,        0xF88F,        0xF890,        0xF891,        0xF892,        0xF893,        0xF894,        0xF895,
	/* U+9D38 */        0xF896,        0xF897,        0xF898,        0xF899,        0xF89A,        0xF89B,        0xF89C,        0xF89D,
	/* U+9D40 */        0xF89E,        0xF89F,        0xF8A0,        0xF940,        0xF941,        0xF942,        0xF943,        0xF944,
	/* U+9D48 */        0xF945,        0xF946,        0xF947,        0xF948,        0xF949,        0xF94A,        0xF94B,        0xF94C,
	/* U+9D50 */        0xF94D,        0xF94E,        0xF94F,        0xF950,        0xF951,        0xF952,        0xF953,        0xF954,
	/* U+9D58 */        0xF955,        0xF956,        0xF957,        0xF958,        0xF959,        0xF95A,        0xF95B,        0xF95C,
	/* U+9D60 */        0xF95D,        0xF95E,        0xF95F,        0xF960,        0xF961,        0xF962,        0xF963,        0xF964,
	/* U+9D68 */        0xF965,        0xF966,        0xF967,        0xF968,        0xF969,        0xF96A,        0xF96B,        0xF96C,
	/* U+9D70 */        0xF96D,        0xF96E,        0xF96F,        0xF970,        0xF971,        0xF972,        0xF973,        0xF974,
	/* U+9D78 */        0xF975,        0xF976,        0xF977,        0xF978,        0xF979,        0xF97A,        0xF97B,        0xF97C,
	/* U+9D80 */        0xF97D,        0xF97E,        0xF980,        0xF981,        0xF982,        0xF983,        0xF984,        0xF985,
	/* U+9D88 */        0xF986,        0xF987,        0xF988,        0xF989,        0xF98A,        0xF98B,        0xF98C,        0xF98D,
	/* U+9D90 */        0xF98E,        0xF98F,        0xF990,        0xF991,        0xF992,        0xF993,        0xF994,        0xF995,
	/* U+9D98 */        0xF996,        0xF997,        0xF998,        0xF999,        0xF99A,        0xF99B,        0xF99C,        0xF99D,
	/* U+9DA0 */        0xF99E,        0xF99F,        0xF9A0,        0xFA40,        0xFA41,        0xFA42,        0xFA43,        0xFA44,
	/* U+9DA8 */        0xFA45,        0xFA46,        0xFA47,        0xFA48,        0xFA49,        0xFA4A,        0xFA4B,        0xFA4C,
	/* U+9DB0 */        0xFA4D,        0xFA4E,        0xFA4F,        0xFA50,        0xFA51,        0xFA52,        0xFA53,        0xFA54,
	/* U+9DB8 */        0xFA55,        0xFA56,        0xFA57,        0xFA58,        0xFA59,        0xFA5A,        0xFA5B,        0xFA5C,
	/* U+9DC0 */        0xFA5D,        0xFA5E,        0xFA5F,        0xFA60,        0xFA61,        0xFA62,        0xFA63,        0xFA64,
	/* U+9DC8 */        0xFA65,        0xFA66,        0xFA67,        0xFA68,        0xFA69,        0xFA6A,        0xFA6B,        0xFA6C,
	/* U+9DD0 */        0xFA6D,        0xFA6E,        0xFA6F,        0xFA70,        0xFA71,        0xFA72,        0xFA73,        0xFA74,
	/* U+9DD8 */        0xFA75,        0xFA76,        0xFA77,        0xFA78,        0xFA79,        0xFA7A,        0xFA7B,        0xFA7C,
	/* U+9DE0 */        0xFA7D,        0xFA7E,        0xFA80,        0xFA81,        0xFA82,        0xFA83,        0xFA84,        0xFA85,
	/* U+9DE8 */        0xFA86,        0xFA87,        0xFA88,        0xFA89,        0xFA8A,        0xFA8B,        0xFA8C,        0xFA8D,
	/* U+9DF0 */        0xFA8E,        0xFA8F,        0xFA90,        0xFA91,        0xFA92,        0xFA93,        0xFA94,        0xFA95,
	/* U+9DF8 */        0xFA96,        0xFA97,        0xFA98,        0xFA99,        0xFA9A,        0xFA9B,        0xFA9C,        0xFA9D,
	/* U+9E00 */        0xFA9E,        0xFA9F,        0xFAA0,        0xFB40,        0xFB41,        0xFB42,        0xFB43,        0xFB44,
	/* U+9E08 */        0xFB45,        0xFB46,        0xFB47,        0xFB48,        0xFB49,        0xFB4A,        0xFB4B,        0xFB4C,
	/* U+9E10 */        0xFB4D,        0xFB4E,        0xFB4F,        0xFB50,        0xFB51,        0xFB52,        0xFB53,        0xFB54,
	/* U+9E18 */        0xFB55,        0xFB56,        0xFB57,        0xFB58,        0xFB59,        0xFB5A,        0xFB5B,        0xC4F1,
	/* U+9E20 */        0xF0AF,        0xBCA6,        0xF0B0,        0xC3F9,        0xFB5C,        0xC5B8,        0xD1BB,        0xFB5D,
	/* U+9E28 */        0xF0B1,        0xF0B2,        0xF0B3,        0xF0B4,        0xF0B5,        0xD1BC,        0xFB5E,        0xD1EC,
	/* U+9E30 */        0xFB5F,        0xF0B7,        0xF0B6,        0xD4A7,        0xFB60,        0xCDD2,        0xF0B8,        0xF0BA,
	/* U+9E38 */        0xF0B9,        0xF0BB,        0xF0BC,        0xFB61,        0xFB62,        0xB8EB,        0xF0BD,        0xBAE8,
	/* U+9E40 */        0xFB63,        0xF0BE,        0xF0BF,        0xBEE9,        0xF0C0,        0xB6EC,        0xF0C1,        0xF0C2,
	/* U+9E48 */        0xF0C3,        0xF0C4,        0xC8B5,        0xF0C5,        0xF0C6,        0xFB64,        0xF0C7,        0xC5F4,
	/* U+9E50 */        0xFB65,        0xF0C8,        0xFB66,        0xFB67,        0xFB68,        0xF0C9,        0xFB69,        0xF0CA,
	/* U+9E58 */        0xF7BD,        0xFB6A,        0xF0CB,        0xF0CC,        0xF0CD,        0xFB6B,        0xF0CE,        0xFB6C,
	/* U+9E60 */        0xFB6D,        0xFB6E,        0xFB6F,        0xF0CF,        0xBAD7,        0xFB70,        0xF0D0,        0xF0D1,
	/* U+9E68 */        0xF0D2,        0xF0D3,        0xF0D4,        0xF0D5,        0xF0D6,        0xF0D8,        0xFB71,        0xFB72,
	/* U+9E70 */        0xD3A5,        0xF0D7,        0xFB73,        0xF0D9,        0xFB74,        0xFB75,        0xFB76,        0xFB77,
	/* U+9E78 */        0xFB78,        0xFB79,        0xFB7A,        0xFB7B,        0xFB7C,        0xFB7D,        0xF5BA,        0xC2B9,
	/* U+9E80 */        0xFB7E,        0xFB80,        0xF7E4,        0xFB81,        0xFB82,        0xFB83,        0xFB84,        0xF7E5,
	/* U+9E88 */        0xF7E6,        0xFB85,        0xFB86,        0xF7E7,        0xFB87,        0xFB88,        0xFB89,        0xFB8A,
	/* U+9E90 */        0xFB8B,        0xFB8C,        0xF7E8,        0xC2B4,        0xFB8D,        0xFB8E,        0xFB8F,        0xFB90,
	/* U+9E98 */        0xFB91,        0xFB92,        0xFB93,        0xFB94,        0xFB95,        0xF7EA,        0xFB96,        0xF7EB,
	/* U+9EA0 */        0xFB97,        0xFB98,        0xFB99,        0xFB9A,        0xFB9B,        0xFB9C,        0xC2F3,        0xFB9D,
	/* U+9EA8 */        0xFB9E,        0xFB9F,        0xFBA0,        0xFC40,        0xFC41,        0xFC42,        0xFC43,        0xFC44,
	/* U+9EB0 */        0xFC45,        0xFC46,        0xFC47,        0xFC48,        0xF4F0,        0xFC49,        0xFC4A,        0xFC4B,
	/* U+9EB8 */        0xF4EF,        0xFC4C,        0xFC4D,        0xC2E9,        0xFC4E,        0xF7E1,        0xF7E2,        0xFC4F,
	/* U+9EC0 */        0xFC50,        0xFC51,        0xFC52,        0xFC53,        0xBBC6,        0xFC54,        0xFC55,        0xFC56,
	/* U+9EC8 */        0xFC57,        0xD9E4,        0xFC58,        0xFC59,        0xFC5A,        0xCAF2,        0xC0E8,        0xF0A4,
	/* U+9ED0 */        0xFC5B,        0xBADA,        0xFC5C,        0xFC5D,        0xC7AD,        0xFC5E,        0xFC5F,        0xFC60,
	/* U+9ED8 */        0xC4AC,        0xFC61,        0xFC62,        0xF7EC,        0xF7ED,        0xF7EE,        0xFC63,        0xF7F0,
	/* U+9EE0 */        0xF7EF,        0xFC64,        0xF7F1,        0xFC65,        0xFC66,        0xF7F4,        0xFC67,        0xF7F3,
	/* U+9EE8 */        0xFC68,        0xF7F2,        0xF7F5,        0xFC69,        0xFC6A,        0xFC6B,        0xFC6C,        0xF7F6,
	/* U+9EF0 */        0xFC6D,        0xFC6E,        0xFC6F,        0xFC70,        0xFC71,        0xFC72,        0xFC73,        0xFC74,
	/* U+9EF8 */        0xFC75,        0xEDE9,        0xFC76,        0xEDEA,        0xEDEB,        0xFC77,        0xF6BC,        0xFC78,
	/* U+9F00 */        0xFC79,        0xFC7A,        0xFC7B,        0xFC7C,        0xFC7D,        0xFC7E,        0xFC80,        0xFC81,
	/* U+9F08 */        0xFC82,        0xFC83,        0xFC84,        0xF6BD,        0xFC85,        0xF6BE,        0xB6A6,        0xFC86,
	/* U+9F10 */        0xD8BE,        0xFC87,        0xFC88,        0xB9C4,        0xFC89,        0xFC8A,        0xFC8B,        0xD8BB,
	/* U+9F18 */        0xFC8C,        0xDCB1,        0xFC8D,        0xFC8E,        0xFC8F,        0xFC90,        0xFC91,        0xFC92,
	/* U+9F20 */        0xCAF3,        0xFC93,        0xF7F7,        0xFC94,        0xFC95,        0xFC96,        0xFC97,        0xFC98,
	/* U+9F28 */        0xFC99,        0xFC9A,        0xFC9B,        0xFC9C,        0xF7F8,        0xFC9D,        0xFC9E,        0xF7F9,
	/* U+9F30 */        0xFC9F,        0xFCA0,        0xFD40,        0xFD41,        0xFD42,        0xFD43,        0xFD44,        0xF7FB,
	/* U+9F38 */        0xFD45,        0xF7FA,        0xFD46,        0xB1C7,        0xFD47,        0xF7FC,        0xF7FD,        0xFD48,
	/* U+9F40 */        0xFD49,        0xFD4A,        0xFD4B,        0xFD4C,        0xF7FE,        0xFD4D,        0xFD4E,        0xFD4F,
	/* U+9F48 */        0xFD50,        0xFD51,        0xFD52,        0xFD53,        0xFD54,        0xFD55,        0xFD56,        0xFD57,
	/* U+9F50 */        0xC6EB,        0xECB4,        0xFD58,        0xFD59,        0xFD5A,        0xFD5B,        0xFD5C,        0xFD5D,
	/* U+9F58 */        0xFD5E,        0xFD5F,        0xFD60,        0xFD61,        0xFD62,        0xFD63,        0xFD64,        0xFD65,
	/* U+9F60 */        0xFD66,        0xFD67,        0xFD68,        0xFD69,        0xFD6A,        0xFD6B,        0xFD6C,        0xFD6D,
	/* U+9F68 */        0xFD6E,        0xFD6F,        0xFD70,        0xFD71,        0xFD72,        0xFD73,        0xFD74,        0xFD75,
	/* U+9F70 */        0xFD76,        0xFD77,        0xFD78,        0xFD79,        0xFD7A,        0xFD7B,        0xFD7C,        0xFD7D,
	/* U+9F78 */        0xFD7E,        0xFD80,        0xFD81,        0xFD82,        0xFD83,        0xFD84,        0xFD85,        0xB3DD,
	/* U+9F80 */        0xF6B3,        0xFD86,        0xFD87,        0xF6B4,        0xC1E4,        0xF6B5,        0xF6B6,        0xF6B7,
	/* U+9F88 */        0xF6B8,        0xF6B9,        0xF6BA,        0xC8A3,        0xF6BB,        0xFD88,        0xFD89,        0xFD8A,
	/* U+9F90 */        0xFD8B,        0xFD8C,        0xFD8D,        0xFD8E,        0xFD8F,        0xFD90,        0xFD91,        0xFD92,
	/* U+9F98 */        0xFD93,        0xC1FA,        0xB9A8,        0xEDE8,        0xFD94,        0xFD95,        0xFD96,        0xB9EA,
	/* U+9FA0 */        0xD9DF,        0xFD97,        0xFD98,        0xFD99,        0xFD9A,        0xFD9B,
	/* Contiguous area: U+E766 .. U+E864 */
	/* U+E766 */                                                        0xA2AB,        0xA2AC,
	/* U+E768 */        0xA2AD,        0xA2AE,        0xA2AF,        0xA2B0,        0x6469,        0xA2E4,        0xA2EF,        0xA2F0,
	/* U+E770 */        0xA2FD,        0xA2FE,        0xA4F4,        0xA4F5,        0xA4F6,        0xA4F7,        0xA4F8,        0xA4F9,
	/* U+E778 */        0xA4FA,        0xA4FB,        0xA4FC,        0xA4FD,        0xA4FE,        0xA5F7,        0xA5F8,        0xA5F9,
	/* U+E780 */        0xA5FA,        0xA5FB,        0xA5FC,        0xA5FD,        0xA5FE,        0xA6B9,        0xA6BA,        0xA6BB,
	/* U+E788 */        0xA6BC,        0xA6BD,        0xA6BE,        0xA6BF,        0xA6C0,        0xA6D9,        0xA6DA,        0xA6DB,
	/* U+E790 */        0xA6DC,        0xA6DD,        0xA6DE,        0xA6DF,        0xA6EC,        0xA6ED,        0xA6F3,        0xA6F6,
	/* U+E798 */        0xA6F7,        0xA6F8,        0xA6F9,        0xA6FA,        0xA6FB,        0xA6FC,        0xA6FD,        0xA6FE,
	/* U+E7A0 */        0xA7C2,        0xA7C3,        0xA7C4,        0xA7C5,        0xA7C6,        0xA7C7,        0xA7C8,        0xA7C9,
	/* U+E7A8 */        0xA7CA,        0xA7CB,        0xA7CC,        0xA7CD,        0xA7CE,        0xA7CF,        0xA7D0,        0xA7F2,
	/* U+E7B0 */        0xA7F3,        0xA7F4,        0xA7F5,        0xA7F6,        0xA7F7,        0xA7F8,        0xA7F9,        0xA7FA,
	/* U+E7B8 */        0xA7FB,        0xA7FC,        0xA7FD,        0xA7FE,        0xA896,        0xA897,        0xA898,        0xA899,
	/* U+E7C0 */        0xA89A,        0xA89B,        0xA89C,        0xA89D,        0xA89E,        0xA89F,        0xA8A0,        0xA8BC,
	/* U+E7C8 */        0x6470,        0xA8C1,        0xA8C2,        0xA8C3,        0xA8C4,        0xA8EA,        0xA8EB,        0xA8EC,
	/* U+E7D0 */        0xA8ED,        0xA8EE,        0xA8EF,        0xA8F0,        0xA8F1,        0xA8F2,        0xA8F3,        0xA8F4,
	/* U+E7D8 */        0xA8F5,        0xA8F6,        0xA8F7,        0xA8F8,        0xA8F9,        0xA8FA,        0xA8FB,        0xA8FC,
	/* U+E7E0 */        0xA8FD,        0xA8FE,        0xA958,        0xA95B,        0xA95D,        0xA95E,        0xA95F,        0x6471,
	/* U+E7E8 */        0x6472,        0x6473,        0x6474,        0x6475,        0x6476,        0x6477,        0x6478,        0x6479,
	/* U+E7F0 */        0x6480,        0x6481,        0x6482,        0x6483,        0xA997,        0xA998,        0xA999,        0xA99A,
	/* U+E7F8 */        0xA99B,        0xA99C,        0xA99D,        0xA99E,        0xA99F,        0xA9A0,        0xA9A1,        0xA9A2,
	/* U+E800 */        0xA9A3,        0xA9F0,        0xA9F1,        0xA9F2,        0xA9F3,        0xA9F4,        0xA9F5,        0xA9F6,
	/* U+E808 */        0xA9F7,        0xA9F8,        0xA9F9,        0xA9FA,        0xA9FB,        0xA9FC,        0xA9FD,        0xA9FE,
	/* U+E810 */        0xD7FA,        0xD7FB,        0xD7FC,        0xD7FD,        0xD7FE,        0x6484,        0xFE51,        0xFE52,
	/* U+E818 */        0xFE53,        0x6485,        0x6486,        0x6487,        0x6488,        0x6489,        0xFE59,        0x6490,
	/* U+E820 */        0x6491,        0x6492,        0x6493,        0x6494,        0x6495,        0x6496,        0xFE61,        0x6497,
	/* U+E828 */        0x6498,        0x6499,        0x64A0,        0xFE66,        0xFE67,        0x64A1,        0x64A2,        0x64A3,
	/* U+E830 */        0x64A4,        0xFE6C,        0xFE6D,        0x64A5,        0x64A6,        0x64A7,        0x64A8,        0x64A9,
	/* U+E838 */        0x64B0,        0x64B1,        0x64B2,        0xFE76,        0x64B3,        0x64B4,        0x64B5,        0x64B6,
	/* U+E840 */        0x64B7,        0x64B8,        0x64B9,        0xFE7E,        0x64C0,        0x64C1,        0x64C2,        0x64C3,
	/* U+E848 */        0x64C4,        0x64C5,        0x64C6,        0x64C7,        0x64C8,        0x64C9,        0x64D0,        0x64D1,
	/* U+E850 */        0x64D2,        0x64D3,        0x64D4,        0x64D5,        0xFE90,        0xFE91,        0x64D6,        0x64D7,
	/* U+E858 */        0x64D8,        0x64D9,        0x64E0,        0x64E1,        0x64E2,        0x64E3,        0x64E4,        0x64E5,
	/* U+E860 */        0x64E6,        0x64E7,        0x64E8,        0x64E9,        0xFEA0,
	/* Contiguous area: U+F92C .. U+FA29 */
	/* U+F92C */                                        0xFD9C,        0x7045,        0x7046,        0x7047,
	/* U+F930 */        0x7048,        0x7049,        0x7050,        0x7051,        0x7052,        0x7053,        0x7054,        0x7055,
	/* U+F938 */        0x7056,        0x7057,        0x7058,        0x7059,        0x7060,        0x7061,        0x7062,        0x7063,
	/* U+F940 */        0x7064,        0x7065,        0x7066,        0x7067,        0x7068,        0x7069,        0x7070,        0x7071,
	/* U+F948 */        0x7072,        0x7073,        0x7074,        0x7075,        0x7076,        0x7077,        0x7078,        0x7079,
	/* U+F950 */        0x7080,        0x7081,        0x7082,        0x7083,        0x7084,        0x7085,        0x7086,        0x7087,
	/* U+F958 */        0x7088,        0x7089,        0x7090,        0x7091,        0x7092,        0x7093,        0x7094,        0x7095,
	/* U+F960 */        0x7096,        0x7097,        0x7098,        0x7099,        0x70A0,        0x70A1,        0x70A2,        0x70A3,
	/* U+F968 */        0x70A4,        0x70A5,        0x70A6,        0x70A7,        0x70A8,        0x70A9,        0x70B0,        0x70B1,
	/* U+F970 */        0x70B2,        0x70B3,        0x70B4,        0x70B5,        0x70B6,        0x70B7,        0x70B8,        0x70B9,
	/* U+F978 */        0x70C0,        0xFD9D,        0x70C1,        0x70C2,        0x70C3,        0x70C4,        0x70C5,        0x70C6,
	/* U+F980 */        0x70C7,        0x70C8,        0x70C9,        0x70D0,        0x70D1,        0x70D2,        0x70D3,        0x70D4,
	/* U+F988 */        0x70D5,        0x70D6,        0x70D7,        0x70D8,        0x70D9,        0x70E0,        0x70E1,        0x70E2,
	/* U+F990 */        0x70E3,        0x70E4,        0x70E5,        0x70E6,        0x70E7,        0xFD9E,        0x70E8,        0x70E9,
	/* U+F998 */        0x70F0,        0x70F1,        0x70F2,        0x70F3,        0x70F4,        0x70F5,        0x70F6,        0x70F7,
	/* U+F9A0 */        0x70F8,        0x70F9,        0x7100,        0x7101,        0x7102,        0x7103,        0x7104,        0x7105,
	/* U+F9A8 */        0x7106,        0x7107,        0x7108,        0x7109,        0x7110,        0x7111,        0x7112,        0x7113,
	/* U+F9B0 */        0x7114,        0x7115,        0x7116,        0x7117,        0x7118,        0x7119,        0x7120,        0x7121,
	/* U+F9B8 */        0x7122,        0x7123,        0x7124,        0x7125,        0x7126,        0x7127,        0x7128,        0x7129,
	/* U+F9C0 */        0x7130,        0x7131,        0x7132,        0x7133,        0x7134,        0x7135,        0x7136,        0x7137,
	/* U+F9C8 */        0x7138,        0x7139,        0x7140,        0x7141,        0x7142,        0x7143,        0x7144,        0x7145,
	/* U+F9D0 */        0x7146,        0x7147,        0x7148,        0x7149,        0x7150,        0x7151,        0x7152,        0x7153,
	/* U+F9D8 */        0x7154,        0x7155,        0x7156,        0x7157,        0x7158,        0x7159,        0x7160,        0x7161,
	/* U+F9E0 */        0x7162,        0x7163,        0x7164,        0x7165,        0x7166,        0x7167,        0x7168,        0xFD9F,
	/* U+F9E8 */        0x7169,        0x7170,        0x7171,        0x7172,        0x7173,        0x7174,        0x7175,        0x7176,
	/* U+F9F0 */        0x7177,        0xFDA0,        0x7178,        0x7179,        0x7180,        0x7181,        0x7182,        0x7183,
	/* U+F9F8 */        0x7184,        0x7185,        0x7186,        0x7187,        0x7188,        0x7189,        0x7190,        0x7191,
	/* U+FA00 */        0x7192,        0x7193,        0x7194,        0x7195,        0x7196,        0x7197,        0x7198,        0x7199,
	/* U+FA08 */        0x71A0,        0x71A1,        0x71A2,        0x71A3,        0xFE40,        0xFE41,        0xFE42,        0xFE43,
	/* U+FA10 */        0x71A4,        0xFE44,        0x71A5,        0xFE45,        0xFE46,        0x71A6,        0x71A7,        0x71A8,
	/* U+FA18 */        0xFE47,        0x71A9,        0x71B0,        0x71B1,        0x71B2,        0x71B3,        0x71B4,        0xFE48,
	/* U+FA20 */        0xFE49,        0xFE4A,        0x71B5,        0xFE4B,        0xFE4C,        0x71B6,        0x71B7,        0xFE4D,
	/* U+FA28 */        0xFE4E,        0xFE4F,
	/* Contiguous area: U+FE30 .. U+FFE5 */
	/* U+FE30 */        0xA955,        0xA6F2,        0x7848,        0xA6F4,        0xA6F5,        0xA6E0,        0xA6E1,        0xA6F0,
	/* U+FE38 */        0xA6F1,        0xA6E2,        0xA6E3,        0xA6EE,        0xA6EF,        0xA6E6,        0xA6E7,        0xA6E4,
	/* U+FE40 */        0xA6E5,        0xA6E8,        0xA6E9,        0xA6EA,        0xA6EB,        0x7849,        0x7850,        0x7851,
	/* U+FE48 */        0x7852,        0xA968,        0xA969,        0xA96A,        0xA96B,        0xA96C,        0xA96D,        0xA96E,
	/* U+FE50 */        0xA96F,        0xA970,        0xA971,        0x7853,        0xA972,        0xA973,        0xA974,        0xA975,
	/* U+FE58 */        0x7854,        0xA976,        0xA977,        0xA978,        0xA979,        0xA97A,        0xA97B,        0xA97C,
	/* U+FE60 */        0xA97D,        0xA97E,        0xA980,        0xA981,        0xA982,        0xA983,        0xA984,        0x7855,
	/* U+FE68 */        0xA985,        0xA986,        0xA987,        0xA988,        0x7856,        0x7857,        0x7858,        0x7859,
	/* U+FE70 */        0x7860,        0x7861,        0x7862,        0x7863,        0x7864,        0x7865,        0x7866,        0x7867,
	/* U+FE78 */        0x7868,        0x7869,        0x7870,        0x7871,        0x7872,        0x7873,        0x7874,        0x7875,
	/* U+FE80 */        0x7876,        0x7877,        0x7878,        0x7879,        0x7880,        0x7881,        0x7882,        0x7883,
	/* U+FE88 */        0x7884,        0x7885,        0x7886,        0x7887,        0x7888,        0x7889,        0x7890,        0x7891,
	/* U+FE90 */        0x7892,        0x7893,        0x7894,        0x7895,        0x7896,        0x7897,        0x7898,        0x7899,
	/* U+FE98 */        0x78A0,        0x78A1,        0x78A2,        0x78A3,        0x78A4,        0x78A5,        0x78A6,        0x78A7,
	/* U+FEA0 */        0x78A8,        0x78A9,        0x78B0,        0x78B1,        0x78B2,        0x78B3,        0x78B4,        0x78B5,
	/* U+FEA8 */        0x78B6,        0x78B7,        0x78B8,        0x78B9,        0x78C0,        0x78C1,        0x78C2,        0x78C3,
	/* U+FEB0 */        0x78C4,        0x78C5,        0x78C6,        0x78C7,        0x78C8,        0x78C9,        0x78D0,        0x78D1,
	/* U+FEB8 */        0x78D2,        0x78D3,        0x78D4,        0x78D5,        0x78D6,        0x78D7,        0x78D8,        0x78D9,
	/* U+FEC0 */        0x78E0,        0x78E1,        0x78E2,        0x78E3,        0x78E4,        0x78E5,        0x78E6,        0x78E7,
	/* U+FEC8 */        0x78E8,        0x78E9,        0x78F0,        0x78F1,        0x78F2,        0x78F3,        0x78F4,        0x78F5,
	/* U+FED0 */        0x78F6,        0x78F7,        0x78F8,        0x78F9,        0x7900,        0x7901,        0x7902,        0x7903,
	/* U+FED8 */        0x7904,        0x7905,        0x7906,        0x7907,        0x7908,        0x7909,        0x7910,        0x7911,
	/* U+FEE0 */        0x7912,        0x7913,        0x7914,        0x7915,        0x7916,        0x7917,        0x7918,        0x7919,
	/* U+FEE8 */        0x7920,        0x7921,        0x7922,        0x7923,        0x7924,        0x7925,        0x7926,        0x7927,
	/* U+FEF0 */        0x7928,        0x7929,        0x7930,        0x7931,        0x7932,        0x7933,        0x7934,        0x7935,
	/* U+FEF8 */        0x7936,        0x7937,        0x7938,        0x7939,        0x7940,        0x7941,        0x7942,        0x7943,
	/* U+FF00 */        0x7944,        0xA3A1,        0xA3A2,        0xA3A3,        0xA1E7,        0xA3A5,        0xA3A6,        0xA3A7,
	/* U+FF08 */        0xA3A8,        0xA3A9,        0xA3AA,        0xA3AB,        0xA3AC,        0xA3AD,        0xA3AE,        0xA3AF,
	/* U+FF10 */        0xA3B0,        0xA3B1,        0xA3B2,        0xA3B3,        0xA3B4,        0xA3B5,        0xA3B6,        0xA3B7,
	/* U+FF18 */        0xA3B8,        0xA3B9,        0xA3BA,        0xA3BB,        0xA3BC,        0xA3BD,        0xA3BE,        0xA3BF,
	/* U+FF20 */        0xA3C0,        0xA3C1,        0xA3C2,        0xA3C3,        0xA3C4,        0xA3C5,        0xA3C6,        0xA3C7,
	/* U+FF28 */        0xA3C8,        0xA3C9,        0xA3CA,        0xA3CB,        0xA3CC,        0xA3CD,        0xA3CE,        0xA3CF,
	/* U+FF30 */        0xA3D0,        0xA3D1,        0xA3D2,        0xA3D3,        0xA3D4,        0xA3D5,        0xA3D6,        0xA3D7,
	/* U+FF38 */        0xA3D8,        0xA3D9,        0xA3DA,        0xA3DB,        0xA3DC,        0xA3DD,        0xA3DE,        0xA3DF,
	/* U+FF40 */        0xA3E0,        0xA3E1,        0xA3E2,        0xA3E3,        0xA3E4,        0xA3E5,        0xA3E6,        0xA3E7,
	/* U+FF48 */        0xA3E8,        0xA3E9,        0xA3EA,        0xA3EB,        0xA3EC,        0xA3ED,        0xA3EE,        0xA3EF,
	/* U+FF50 */        0xA3F0,        0xA3F1,        0xA3F2,        0xA3F3,        0xA3F4,        0xA3F5,        0xA3F6,        0xA3F7,
	/* U+FF58 */        0xA3F8,        0xA3F9,        0xA3FA,        0xA3FB,        0xA3FC,        0xA3FD,        0xA1AB,        0x7945,
	/* U+FF60 */        0x7946,        0x7947,        0x7948,        0x7949,        0x7950,        0x7951,        0x7952,        0x7953,
	/* U+FF68 */        0x7954,        0x7955,        0x7956,        0x7957,        0x7958,        0x7959,        0x7960,        0x7961,
	/* U+FF70 */        0x7962,        0x7963,        0x7964,        0x7965,        0x7966,        0x7967,        0x7968,        0x7969,
	/* U+FF78 */        0x7970,        0x7971,        0x7972,        0x7973,        0x7974,        0x7975,        0x7976,        0x7977,
	/* U+FF80 */        0x7978,        0x7979,        0x7980,        0x7981,        0x7982,        0x7983,        0x7984,        0x7985,
	/* U+FF88 */        0x7986,        0x7987,        0x7988,        0x7989,        0x7990,        0x7991,        0x7992,        0x7993,
	/* U+FF90 */        0x7994,        0x7995,        0x7996,        0x7997,        0x7998,        0x7999,        0x79A0,        0x79A1,
	/* U+FF98 */        0x79A2,        0x79A3,        0x79A4,        0x79A5,        0x79A6,        0x79A7,        0x79A8,        0x79A9,
	/* U+FFA0 */        0x79B0,        0x79B1,        0x79B2,        0x79B3,        0x79B4,        0x79B5,        0x79B6,        0x79B7,
	/* U+FFA8 */        0x79B8,        0x79B9,        0x79C0,        0x79C1,        0x79C2,        0x79C3,        0x79C4,        0x79C5,
	/* U+FFB0 */        0x79C6,        0x79C7,        0x79C8,        0x79C9,        0x79D0,        0x79D1,        0x79D2,        0x79D3,
	/* U+FFB8 */        0x79D4,        0x79D5,        0x79D6,        0x79D7,        0x79D8,        0x79D9,        0x79E0,        0x79E1,
	/* U+FFC0 */        0x79E2,        0x79E3,        0x79E4,        0x79E5,        0x79E6,        0x79E7,        0x79E8,        0x79E9,
	/* U+FFC8 */        0x79F0,        0x79F1,        0x79F2,        0x79F3,        0x79F4,        0x79F5,        0x79F6,        0x79F7,
	/* U+FFD0 */        0x79F8,        0x79F9,        0x7A00,        0x7A01,        0x7A02,        0x7A03,        0x7A04,        0x7A05,
	/* U+FFD8 */        0x7A06,        0x7A07,        0x7A08,        0x7A09,        0x7A10,        0x7A11,        0x7A12,        0x7A13,
	/* U+FFE0 */        0xA1E9,        0xA1EA,        0xA956,        0xA3FE,        0xA957,        0xA3A4,
};

static inline bool InRange(unsigned c, unsigned lower, unsigned upper)
{
	return c >= lower && c <= upper;
}

static inline unsigned gb4lin_to_gb(unsigned gb4lin)
{
	unsigned   a, b, c, d;
	a = 0x81 + gb4lin / 12600;
	b = 0x30 + (gb4lin / 1260) % 10;
	c = 0x81 + (gb4lin / 10) % 126;
	d = 0x30 + gb4lin % 10;
	return ((a << 24) | (b << 16) | (c << 8) | d);
}

static int qt_UnicodeToGb18030(unsigned uni, uint8_t *gbchar) {
	/* Returns the bytesize of the GB18030 character. */
	unsigned        gb, gb4lin;
	indexTbl_t        u2g;

	if (uni < 0x80) {
		*gbchar = (uint8_t)uni;
		return 1;
	}
	else if (uni <= 0xD7FF || InRange(uni, 0xE766, 0xFFFF)) {
		u2g = ucs_to_gb18030_index[uni >> 8];

		if ((uint8_t)(uni & 0xFF) >= u2g.tblBegin && (uint8_t)(uni & 0xFF) <= u2g.tblEnd) {
			// Use mapping table (2-byte or 4-byte GB18030)
			unsigned tblEntry;

			tblEntry = ucs_to_gb18030[uni - u2g.tblOffset];

			if (tblEntry > 0x8000) {
				// 2-byte GB18030
				gb = tblEntry;
			}
			else {
				// 4-byte GB18030 stored in a special compact format
				uint8_t        a, b;
				a = 0x81;
				b = 0x30 + (tblEntry >> 11);
				if (tblEntry >= 0x7000) {
					a += 3;
					b -= 14;
				}
				else if (tblEntry >= 0x6000) {
					a += 2;
					b -= 6;
				}
				else if (tblEntry >= 0x3000) {
					a += 1;
					b -= 6;
				}
				else if (b >= 0x31) {
					b += 5;
				}
				gbchar[0] = a;
				gbchar[1] = b;
				gbchar[2] = 0x81 + ((tblEntry >> 4) & 0x7F);
				gbchar[3] = 0x30 + (tblEntry & 0xF);
				return 4;
			}
		}
		else {
			// 4-byte GB18030 calculated algorithmically
			gb4lin = u2g.algOffset + (uni & 0xFF);
			// Yikes, my index table could not cover all the bases...
			if (InRange(uni, 0x49B8, 0x49FF))
				gb4lin -= 11;
			gb = gb4lin_to_gb(gb4lin);
		}
	}
	else if (InRange(uni, 0xE000, 0xE765)) {
		// User-defined areas in GB18030 (2-byte)
		if (uni <= 0xE233)
			gb = 0xAAA1 + (((uni - 0xE000) / 94) << 8) + (uni - 0xE000) % 94;
		else if (uni <= 0xE4C5)
			gb = 0xF8A1 + (((uni - 0xE234) / 94) << 8) + (uni - 0xE234) % 94;
		else {
			gb = 0xA140 + (((uni - 0xE4C6) / 96) << 8) + (uni - 0xE4C6) % 96;
			// Skip the gap at 0x7F
			if ((gb & 0xFF) >= 0x7F)
				gb++;
		}
	}
	else if (InRange(uni, 0x10000, 0x10FFFF)) {
		// Qt 3.x does not support beyond BMP yet, but what the heck...
		// (U+10000 = GB+90308130) to (U+10FFFF = GB+E3329A35)
		gb = gb4lin_to_gb(0x1E248 + uni);
	}
	else {
		// Surrogate area and other undefined/reserved areas (discard)
		*gbchar = 0;
		return 0;
	}

	if (gb <= 0xFFFF) {
		gbchar[0] = (uint8_t)((gb >> 8) & 0xFF);
		gbchar[1] = (uint8_t)(gb & 0xFF);
		return 2;
	}
	else {
		gbchar[0] = (uint8_t)((gb >> 24) & 0xFF);
		gbchar[1] = (uint8_t)((gb >> 16) & 0xFF);
		gbchar[2] = (uint8_t)((gb >> 8) & 0xFF);
		gbchar[3] = (uint8_t)(gb & 0xFF);
		return 4;
	}
}

static int qt_UnicodeToGbk(unsigned uni, uint8_t *gbchar) {
	/* Returns the bytesize of the GBK character. */
	/* Intended for improving performance of GB2312 and GBK functions. */
	unsigned        gb;
	indexTbl_t        u2g;

	if (uni < 0x80) {
		*gbchar = (uint8_t)uni;
		return 1;
	}
	else if (uni <= 0xD7FF || InRange(uni, 0xE766, 0xFFFF)) {
		u2g = ucs_to_gb18030_index[uni >> 8];

		if ((uint8_t)(uni & 0xFF) >= u2g.tblBegin && (uint8_t)(uni & 0xFF) <= u2g.tblEnd) {
			// Use mapping table (2-byte GBK or 4-byte GB18030)
			unsigned tblEntry;

			tblEntry = ucs_to_gb18030[uni - u2g.tblOffset];

			if (tblEntry > 0x8000) {
				// GBK
				gb = tblEntry;
			}
			else {
				// 4-byte GB18030 stored in a special compact format (discard)
				*gbchar = 0;
				return 0;
			}
		}
		else {
			// 4-byte GB18030 calculated algorithmically (discard)
			*gbchar = 0;
			return 0;
		}
	}
	else if (InRange(uni, 0xE000, 0xE765)) {
		// User-defined areas in GB18030 (2-byte)
		if (uni <= 0xE233)
			gb = 0xAAA1 + (((uni - 0xE000) / 94) << 8) + (uni - 0xE000) % 94;
		else if (uni <= 0xE4C5)
			gb = 0xF8A1 + (((uni - 0xE234) / 94) << 8) + (uni - 0xE234) % 94;
		else {
			gb = 0xA140 + (((uni - 0xE4C6) / 96) << 8) + (uni - 0xE4C6) % 96;
			// Skip the gap at 0x7F
			if ((gb & 0xFF) >= 0x7F)
				gb++;
		}
	}
	else {
		// Surrogate area and other undefined/reserved areas (discard)
		*gbchar = 0;
		return 0;
	}

	gbchar[0] = (uint8_t)((gb >> 8) & 0xFF);
	gbchar[1] = (uint8_t)(gb & 0xFF);
	return 2;
}

void GBTextEncoder::EncodeGB18030(const std::wstring& str, std::string& bytes)
{
	static const char replacement = '?';
	unsigned high = 0;
//	int invalid = 0;

	bytes.resize(4 * str.length() + 1);
	int index = 0;

	uint8_t buf[4];
	for (size_t i = 0; i < str.length(); ++i) {
		unsigned ch = str[i];
		int len;
		if (high > 0) {
			if (ZXing::TextUtfEncoding::IsUtf16LowSurrogate(ch)) {
				// valid surrogate pair
				++i;
				unsigned u = ZXing::TextUtfEncoding::CodePointFromUtf16Surrogates(high, ch);
				len = qt_UnicodeToGb18030(u, buf);
				if (len >= 2) {
					for (int j = 0; j<len; j++)
						bytes[index++] = buf[j];
				}
				else {
					bytes[index++] = replacement;
//					++invalid;
				}
				high = 0;
				continue;
			}
			else {
				bytes[index++] = replacement;
//				++invalid;
				high = 0;
			}
		}

		if (ch < 0x80) {
			// ASCII
			bytes[index++] = static_cast<char>(ch);
		}
		else if (ZXing::TextUtfEncoding::IsUtf16HighSurrogate(ch)) {
			// surrogates area. check for correct encoding
			// we need at least one more character, first the high surrogate, then the low one
			high = ch;
		}
		else if ((len = qt_UnicodeToGb18030(ch, buf)) >= 2) {
			for (int j = 0; j<len; j++)
				bytes[index++] = buf[j];
		}
		else {
			// Error
			bytes[index++] = replacement;
//			++invalid;
		}
	}
	bytes.resize(index);
}

void GBTextEncoder::EncodeGB2312(const std::wstring& str, std::string& bytes)
{
	static const char replacement = '?';
	//int invalid = 0;

	bytes.resize(2 * str.length() + 1);
	int index = 0;

	uint8_t buf[2];
	for (wchar_t ch : str) {
		if (ch < 0x80) {
			// ASCII
			bytes[index++] = static_cast<char>(ch);
		}
		else if ((qt_UnicodeToGbk(ch, buf) == 2) &&
			(buf[0] >= 0xA1) && (buf[1] >= 0xA1)) {
			bytes[index++] = buf[0];
			bytes[index++] = buf[1];
		}
		else {
			// Error
			bytes[index++] = replacement;
			//++invalid;
		}
	}
	bytes.resize(index);
}
