#!/usr/bin/env python

"""
General support for calendar data storage.

Copyright (C) 2016, 2017 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from imiptools.stores.manifest import stores

# Access functions.

def get_store(store_type, store_dir):
    return stores[store_type].Store(store_dir)

def get_publisher(publishing_dir):
    return stores["file"].Publisher(publishing_dir)

def get_journal(store_type, journal_dir):
    return stores[store_type].Journal(journal_dir)

# vim: tabstop=4 expandtab shiftwidth=4
