/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

#include "test.h"
#include <agent.h>

int main(void)
{
	char name[] = PACKAGE_NAME " help";
	state_t state = {
		.verb = VERB_HELP,
	};
	int rc;

	test_name(name);

	rc = agent_run(&state);
	test_assert(rc == 0, "agent_run() returned %i", rc);

	/* Testing the exact output of `lcagent help` is probably a waste of
	 * time, so lets just assume it printed something helpful. The whole
	 * thing needs localizing and keeping in sync with the available
	 * commandline options. */

	return test_status;
}
