#########################################################################################
# Package        HiPi::Graphics::BitmapFont::Mono26
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::Mono26;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 26;
my $line_spacing = 2;
my $name = 'Mono 26';
my $space_width = 14;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 6, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 7, 
        'xoffset'  => 4, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x18, ##        00   00 
            0x02, 0x30, ##        0   00  
            0x06, 0x30, ##       00   00  
            0x06, 0x30, ##       00   00  
            0x06, 0x30, ##       00   00  
            0x7F, 0xFC, ##   0000000000000
            0x7F, 0xFC, ##   0000000000000
            0x0C, 0x60, ##      00   00   
            0x0C, 0x60, ##      00   00   
            0x0C, 0xC0, ##      00  00    
            0x18, 0xC0, ##     00   00    
            0xFF, 0xF8, ##  0000000000000 
            0xFF, 0xF8, ##  0000000000000 
            0x19, 0x80, ##     00  00     
            0x31, 0x80, ##    00   00     
            0x31, 0x80, ##    00   00     
            0x31, 0x80, ##    00   00     
            0x33, 0x00, ##    00  00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x1F, 0x80, ##     000000  
            0x7F, 0xC0, ##   000000000 
            0xE4, 0x40, ##  000  0   0 
            0xC4, 0x00, ##  00   0     
            0xC4, 0x00, ##  00   0     
            0xC4, 0x00, ##  00   0     
            0x74, 0x00, ##   000 0     
            0x3F, 0x00, ##    000000   
            0x0F, 0xC0, ##      000000 
            0x04, 0xC0, ##       0  00 
            0x04, 0x60, ##       0   00
            0x04, 0x60, ##       0   00
            0x04, 0x60, ##       0   00
            0xC4, 0xE0, ##  00   0  000
            0xFF, 0xC0, ##  0000000000 
            0x3F, 0x00, ##    000000   
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3C, 0x00, ##    0000        
            0x7E, 0x00, ##   000000       
            0xE7, 0x00, ##  000  000      
            0xC3, 0x00, ##  00    00      
            0xC3, 0x00, ##  00    00      
            0xC3, 0x00, ##  00    00      
            0xE7, 0x08, ##  000  000    0 
            0x7E, 0x38, ##   000000   000 
            0x3D, 0xE0, ##    0000 0000   
            0x07, 0x80, ##       0000     
            0x3C, 0xF0, ##    0000  0000  
            0x61, 0xF8, ##   00    000000 
            0x03, 0x9C, ##        000  000
            0x03, 0x0C, ##        00    00
            0x03, 0x0C, ##        00    00
            0x03, 0x9C, ##        000  000
            0x01, 0xF8, ##         000000 
            0x00, 0xF0, ##          0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x1F, 0x80, ##     000000    
            0x38, 0x80, ##    000   0    
            0x30, 0x00, ##    00         
            0x30, 0x00, ##    00         
            0x30, 0x00, ##    00         
            0x18, 0x00, ##     00        
            0x1C, 0x00, ##     000       
            0x2C, 0x00, ##    0 00       
            0x66, 0x18, ##   00  00    00
            0xC3, 0x18, ##  00    00   00
            0xC1, 0x98, ##  00     00  00
            0xC1, 0x98, ##  00     00  00
            0xC0, 0xF0, ##  00      0000 
            0xE0, 0x60, ##  000      00  
            0x70, 0xF0, ##   000    0000 
            0x3F, 0xF0, ##    0000000000 
            0x1F, 0x38, ##     00000  000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 6, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 5, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x18, ##     00
            0x30, ##    00 
            0x30, ##    00 
            0x20, ##    0  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x30, ##    00 
            0x30, ##    00 
            0x18, ##     00
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 5, 
        'xoffset'  => 4, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00   
            0x60, ##   00  
            0x60, ##   00  
            0x20, ##    0  
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x60, ##   00  
            0x60, ##   00  
            0xC0, ##  00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x46, 0x20, ##   0   00   0 
            0x66, 0x60, ##   00  00  00 
            0x1F, 0x80, ##     000000   
            0x06, 0x00, ##       00     
            0x1F, 0x80, ##     000000   
            0x66, 0x60, ##   00  00  00 
            0x46, 0x20, ##   0   00   0 
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x60, ##   00 
            0xE0, ##  000 
            0xC0, ##  00  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 6, 
        'xoffset'  => 4, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 3, 
        'xoffset'  => 6, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x60, ##           00 
            0x00, 0x60, ##           00 
            0x00, 0xE0, ##          000 
            0x00, 0xC0, ##          00  
            0x01, 0xC0, ##         000  
            0x01, 0x80, ##         00   
            0x03, 0x80, ##        000   
            0x03, 0x00, ##        00    
            0x03, 0x00, ##        00    
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x0C, 0x00, ##      00      
            0x0C, 0x00, ##      00      
            0x1C, 0x00, ##     000      
            0x18, 0x00, ##     00       
            0x38, 0x00, ##    000       
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x71, 0xC0, ##   000   000 
            0x60, 0xC0, ##   00     00 
            0xE0, 0xC0, ##  000     00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xCE, 0x60, ##  00  000  00
            0xCE, 0x60, ##  00  000  00
            0xCE, 0x60, ##  00  000  00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xE0, 0xE0, ##  000     000
            0x60, 0xC0, ##   00     00 
            0x71, 0xC0, ##   000   000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7C, 0x00, ##   00000    
            0xFC, 0x00, ##  000000    
            0xEC, 0x00, ##  000 00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0xFF, 0x80, ##  000000000 
            0xC1, 0x80, ##  00     00 
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x01, 0x80, ##         00 
            0x01, 0x80, ##         00 
            0x03, 0x00, ##        00  
            0x06, 0x00, ##       00   
            0x0C, 0x00, ##      00    
            0x1C, 0x00, ##     000    
            0x38, 0x00, ##    000     
            0x70, 0x00, ##   000      
            0xE0, 0x00, ##  000       
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7E, 0x00, ##   000000    
            0xFF, 0x80, ##  000000000  
            0x81, 0x80, ##  0      00  
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x01, 0xC0, ##         000 
            0x1F, 0x80, ##     000000  
            0x1E, 0x00, ##     0000    
            0x01, 0x80, ##         00  
            0x00, 0xC0, ##          00 
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0xE0, ##          000
            0x81, 0xC0, ##  0      000 
            0xFF, 0x80, ##  000000000  
            0x7F, 0x00, ##   0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000   
            0x03, 0x80, ##        000   
            0x07, 0x80, ##       0000   
            0x0D, 0x80, ##      00 00   
            0x0D, 0x80, ##      00 00   
            0x19, 0x80, ##     00  00   
            0x19, 0x80, ##     00  00   
            0x31, 0x80, ##    00   00   
            0x61, 0x80, ##   00    00   
            0x61, 0x80, ##   00    00   
            0xC1, 0x80, ##  00     00   
            0xC1, 0x80, ##  00     00   
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000 
            0xFF, 0x80, ##  000000000 
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xFE, 0x00, ##  0000000   
            0xFF, 0x00, ##  00000000  
            0x83, 0x80, ##  0     000 
            0x01, 0xC0, ##         000
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x01, 0xC0, ##         000
            0x83, 0x80, ##  0     000 
            0xFF, 0x00, ##  00000000  
            0xFE, 0x00, ##  0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000  
            0x3F, 0xC0, ##    00000000 
            0x30, 0x40, ##    00     0 
            0x60, 0x00, ##   00        
            0x60, 0x00, ##   00        
            0xC0, 0x00, ##  00         
            0xCF, 0x00, ##  00  0000   
            0xDF, 0xC0, ##  00 0000000 
            0xF0, 0xC0, ##  0000    00 
            0xE0, 0xE0, ##  000     000
            0xE0, 0x60, ##  000      00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xE0, 0x60, ##  000      00
            0x60, 0xE0, ##   00     000
            0x70, 0xC0, ##   000    00 
            0x3F, 0xC0, ##    00000000 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x01, 0xC0, ##         000 
            0x01, 0x80, ##         00  
            0x01, 0x80, ##         00  
            0x03, 0x80, ##        000  
            0x03, 0x00, ##        00   
            0x07, 0x00, ##       000   
            0x07, 0x00, ##       000   
            0x06, 0x00, ##       00    
            0x0E, 0x00, ##      000    
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x1C, 0x00, ##     000     
            0x18, 0x00, ##     00      
            0x38, 0x00, ##    000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000  
            0x3F, 0xC0, ##    00000000 
            0x70, 0xE0, ##   000    000
            0x60, 0x60, ##   00      00
            0x60, 0x60, ##   00      00
            0x60, 0x60, ##   00      00
            0x70, 0xC0, ##   000    00 
            0x3F, 0x80, ##    0000000  
            0x0F, 0x80, ##      00000  
            0x31, 0xC0, ##    00   000 
            0x40, 0x60, ##   0       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x60, 0xC0, ##   00     00 
            0x7F, 0xC0, ##   000000000 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x7F, 0x80, ##   00000000  
            0x61, 0xC0, ##   00    000 
            0xE0, 0xC0, ##  000     00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xE0, 0xE0, ##  000     000
            0x61, 0xE0, ##   00    0000
            0x7F, 0xE0, ##   0000000000
            0x1E, 0x60, ##     0000  00
            0x00, 0x60, ##           00
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x41, 0x80, ##   0     00  
            0x7F, 0x80, ##   00000000  
            0x3E, 0x00, ##    00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 3, 
        'xoffset'  => 6, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x60, ##   00 
            0xE0, ##  000 
            0xC0, ##  00  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x18, ##             00
            0x00, 0x78, ##           0000
            0x03, 0xF0, ##        000000 
            0x0F, 0x80, ##      00000    
            0x3E, 0x00, ##    00000      
            0xF0, 0x00, ##  0000         
            0xE0, 0x00, ##  000          
            0x7C, 0x00, ##   00000       
            0x1F, 0x00, ##     00000     
            0x03, 0xE0, ##        00000  
            0x00, 0xF8, ##          00000
            0x00, 0x18, ##             00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x80, 0x00, ##  0            
            0xF0, 0x00, ##  0000         
            0x7C, 0x00, ##   00000       
            0x1F, 0x00, ##     00000     
            0x03, 0xE0, ##        00000  
            0x00, 0xF8, ##          00000
            0x00, 0x78, ##           0000
            0x01, 0xF0, ##         00000 
            0x0F, 0x80, ##      00000    
            0x7E, 0x00, ##   000000      
            0xF0, 0x00, ##  0000         
            0xC0, 0x00, ##  00           
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0xFF, 0x00, ##  00000000 
            0xC3, 0x80, ##  00    000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xE0, ##        00000   
            0x0F, 0xF0, ##      00000000  
            0x1C, 0x38, ##     000    000 
            0x30, 0x1C, ##    00       000
            0x70, 0x0C, ##   000        00
            0x61, 0xEC, ##   00    0000 00
            0xE7, 0xFC, ##  000  000000000
            0xC6, 0x1C, ##  00   00    000
            0xCC, 0x0C, ##  00  00      00
            0xCC, 0x0C, ##  00  00      00
            0xCC, 0x0C, ##  00  00      00
            0xCC, 0x0C, ##  00  00      00
            0xCC, 0x0C, ##  00  00      00
            0xC6, 0x1C, ##  00   00    000
            0x67, 0xFC, ##   00  000000000
            0x61, 0xEC, ##   00    0000 00
            0x70, 0x00, ##   000          
            0x38, 0x00, ##    000         
            0x1C, 0x00, ##     000        
            0x0F, 0xF0, ##      00000000  
            0x03, 0xF0, ##        000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x06, 0xC0, ##       00 00    
            0x0C, 0xC0, ##      00  00    
            0x0C, 0xC0, ##      00  00    
            0x0C, 0x60, ##      00   00   
            0x0C, 0x60, ##      00   00   
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x18, 0x30, ##     00     00  
            0x3F, 0xF0, ##    0000000000  
            0x3F, 0xF0, ##    0000000000  
            0x30, 0x38, ##    00      000 
            0x70, 0x18, ##   000       00 
            0x70, 0x18, ##   000       00 
            0x60, 0x1C, ##   00        000
            0x60, 0x1C, ##   00        000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000   
            0xFF, 0xC0, ##  0000000000 
            0xC0, 0xE0, ##  00      000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0x80, ##  000000000  
            0xC1, 0xC0, ##  00     000 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xC0, ##  00      00 
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0x00, ##  00000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000 
            0x1F, 0xE0, ##     00000000
            0x38, 0x60, ##    000    00
            0x60, 0x00, ##   00        
            0x60, 0x00, ##   00        
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0x60, 0x00, ##   00        
            0x60, 0x00, ##   00        
            0x38, 0x60, ##    000    00
            0x1F, 0xE0, ##     00000000
            0x0F, 0xC0, ##      000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000    
            0xFF, 0x00, ##  00000000   
            0xC3, 0x80, ##  00    000  
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC3, 0x80, ##  00    000  
            0xFF, 0x00, ##  00000000   
            0xFE, 0x00, ##  0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0xC0, ##  0000000000 
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0xC0, ##  0000000000 
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000  
            0x1F, 0xE0, ##     00000000 
            0x38, 0x20, ##    000     0 
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC1, 0xF0, ##  00     00000
            0xC1, 0xF0, ##  00     00000
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x30, ##   00       00
            0x60, 0x30, ##   00       00
            0x38, 0x70, ##    000    000
            0x1F, 0xF0, ##     000000000
            0x0F, 0xC0, ##      000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0xC3, 0x00, ##  00    00 
            0xFF, 0x00, ##  00000000 
            0x7E, 0x00, ##   000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x70, ##  00       000
            0xC0, 0xE0, ##  00      000 
            0xC1, 0xC0, ##  00     000  
            0xC3, 0x80, ##  00    000   
            0xC7, 0x00, ##  00   000    
            0xCE, 0x00, ##  00  000     
            0xDC, 0x00, ##  00 000      
            0xF8, 0x00, ##  00000       
            0xFC, 0x00, ##  000000      
            0xEE, 0x00, ##  000 000     
            0xC6, 0x00, ##  00   00     
            0xC7, 0x00, ##  00   000    
            0xC3, 0x80, ##  00    000   
            0xC1, 0x80, ##  00     00   
            0xC1, 0xC0, ##  00     000  
            0xC0, 0xE0, ##  00      000 
            0xC0, 0x60, ##  00       00 
            0xC0, 0x70, ##  00       000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x70, ##  000      000
            0xE0, 0x70, ##  000      000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xD0, 0xB0, ##  00 0    0 00
            0xD9, 0xB0, ##  00 00  00 00
            0xD9, 0xB0, ##  00 00  00 00
            0xC9, 0x30, ##  00  0  0  00
            0xCF, 0x30, ##  00  0000  00
            0xCF, 0x30, ##  00  0000  00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x60, ##  000      00
            0xE0, 0x60, ##  000      00
            0xF0, 0x60, ##  0000     00
            0xF0, 0x60, ##  0000     00
            0xD8, 0x60, ##  00 00    00
            0xD8, 0x60, ##  00 00    00
            0xDC, 0x60, ##  00 000   00
            0xCC, 0x60, ##  00  00   00
            0xCC, 0x60, ##  00  00   00
            0xC6, 0x60, ##  00   00  00
            0xC6, 0x60, ##  00   00  00
            0xC7, 0x60, ##  00   000 00
            0xC3, 0x60, ##  00    00 00
            0xC3, 0x60, ##  00    00 00
            0xC1, 0xE0, ##  00     0000
            0xC1, 0xE0, ##  00     0000
            0xC0, 0xE0, ##  00      000
            0xC0, 0xE0, ##  00      000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x71, 0xC0, ##   000   000 
            0x60, 0xC0, ##   00     00 
            0xC0, 0xE0, ##  00      000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0x60, 0xC0, ##   00     00 
            0x71, 0xC0, ##   000   000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000   
            0xFF, 0xC0, ##  0000000000 
            0xC1, 0xC0, ##  00     000 
            0xC0, 0xE0, ##  00      000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0xC1, 0xC0, ##  00     000 
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0x00, ##  00000000   
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x71, 0xC0, ##   000   000 
            0x60, 0xC0, ##   00     00 
            0xC0, 0xE0, ##  00      000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0x60, 0xC0, ##   00     00 
            0x71, 0xC0, ##   000   000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x03, 0x80, ##        000  
            0x01, 0xC0, ##         000 
            0x00, 0x80, ##          0  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000     
            0xFF, 0xC0, ##  0000000000   
            0xC1, 0xC0, ##  00     000   
            0xC0, 0x60, ##  00       00  
            0xC0, 0x60, ##  00       00  
            0xC0, 0x60, ##  00       00  
            0xC0, 0x60, ##  00       00  
            0xC0, 0xC0, ##  00      00   
            0xFF, 0xC0, ##  0000000000   
            0xFE, 0x00, ##  0000000      
            0xC3, 0x80, ##  00    000    
            0xC1, 0xC0, ##  00     000   
            0xC0, 0xC0, ##  00      00   
            0xC0, 0xE0, ##  00      000  
            0xC0, 0x60, ##  00       00  
            0xC0, 0x70, ##  00       000 
            0xC0, 0x30, ##  00        00 
            0xC0, 0x38, ##  00        000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000  
            0x7F, 0xC0, ##   000000000 
            0x60, 0xC0, ##   00     00 
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xE0, 0x00, ##  000        
            0x78, 0x00, ##   0000      
            0x3F, 0x00, ##    000000   
            0x0F, 0xC0, ##      000000 
            0x01, 0xC0, ##         000 
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0xC1, 0xC0, ##  00     000 
            0xFF, 0xC0, ##  0000000000 
            0x3F, 0x00, ##    000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x60, 0xC0, ##   00     00 
            0x7F, 0xC0, ##   000000000 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x38, ##  00        000
            0xE0, 0x30, ##  000       00 
            0xE0, 0x30, ##  000       00 
            0x60, 0x70, ##   00      000 
            0x60, 0x70, ##   00      000 
            0x70, 0x60, ##   000     00  
            0x30, 0x60, ##    00     00  
            0x30, 0xE0, ##    00    000  
            0x30, 0xC0, ##    00    00   
            0x38, 0xC0, ##    000   00   
            0x18, 0xC0, ##     00   00   
            0x19, 0xC0, ##     00  000   
            0x19, 0x80, ##     00  00    
            0x0D, 0x80, ##      00 00    
            0x0D, 0x80, ##      00 00    
            0x0F, 0x00, ##      0000     
            0x0F, 0x00, ##      0000     
            0x07, 0x00, ##       000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xE0, 0x0C, ##  000         00
            0x60, 0x0C, ##   00         00
            0x63, 0x8C, ##   00   000   00
            0x63, 0x9C, ##   00   000  000
            0x67, 0x9C, ##   00  0000  000
            0x67, 0x98, ##   00  0000  00 
            0x66, 0x98, ##   00  00 0  00 
            0x66, 0xD8, ##   00  00 00 00 
            0x34, 0xD8, ##    00 0  00 00 
            0x34, 0xD8, ##    00 0  00 00 
            0x3C, 0xD8, ##    0000  00 00 
            0x3C, 0x58, ##    0000   0 00 
            0x3C, 0x70, ##    0000   000  
            0x38, 0x70, ##    000    000  
            0x38, 0x70, ##    000    000  
            0x18, 0x70, ##     00    000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x1C, ##   000       000
            0x30, 0x38, ##    00      000 
            0x18, 0x30, ##     00     00  
            0x1C, 0x70, ##     000   000  
            0x0C, 0x60, ##      00   00   
            0x0E, 0xC0, ##      000 00    
            0x06, 0xC0, ##       00 00    
            0x07, 0x80, ##       0000     
            0x03, 0x80, ##        000     
            0x07, 0x80, ##       0000     
            0x06, 0xC0, ##       00 00    
            0x0E, 0xC0, ##      000 00    
            0x0C, 0x60, ##      00   00   
            0x18, 0x70, ##     00    000  
            0x38, 0x30, ##    000     00  
            0x30, 0x38, ##    00      000 
            0x70, 0x18, ##   000       00 
            0x60, 0x1C, ##   00        000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x60, 0x18, ##   00        00 
            0x70, 0x38, ##   000      000 
            0x30, 0x30, ##    00      00  
            0x38, 0x70, ##    000    000  
            0x18, 0x60, ##     00    00   
            0x0C, 0xE0, ##      00  000   
            0x0C, 0xC0, ##      00  00    
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000 
            0xFF, 0xE0, ##  00000000000 
            0x00, 0xE0, ##          000 
            0x01, 0xC0, ##         000  
            0x01, 0x80, ##         00   
            0x03, 0x80, ##        000   
            0x03, 0x00, ##        00    
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x0C, 0x00, ##      00      
            0x1C, 0x00, ##     000      
            0x18, 0x00, ##     00       
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x60, 0x00, ##   00         
            0xC0, 0x00, ##  00          
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 5, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000         
            0x60, 0x00, ##   00         
            0x70, 0x00, ##   000        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x18, 0x00, ##     00       
            0x18, 0x00, ##     00       
            0x0C, 0x00, ##      00      
            0x0C, 0x00, ##      00      
            0x0E, 0x00, ##      000     
            0x06, 0x00, ##       00     
            0x07, 0x00, ##       000    
            0x03, 0x00, ##        00    
            0x03, 0x00, ##        00    
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x00, 0xC0, ##          00  
            0x00, 0xC0, ##          00  
            0x00, 0x60, ##           00 
            0x00, 0x60, ##           00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 5, 
        'xoffset'  => 4, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x00, ##       000     
            0x0F, 0x00, ##      0000     
            0x1D, 0x80, ##     000 00    
            0x39, 0xC0, ##    000  000   
            0x30, 0xE0, ##    00    000  
            0x60, 0x60, ##   00      00  
            0xC0, 0x30, ##  00        00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 6, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0xE0, ##  000   
            0x60, ##   00   
            0x30, ##    00  
            0x18, ##     00 
            0x0C, ##      00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000   
            0x7F, 0xC0, ##   000000000 
            0x60, 0xC0, ##   00     00 
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x1F, 0xE0, ##     00000000
            0x7F, 0xE0, ##   0000000000
            0xE0, 0x60, ##  000      00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0xE1, 0xE0, ##  000    0000
            0x7F, 0x60, ##   0000000 00
            0x3E, 0x60, ##    00000  00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xCF, 0x00, ##  00  0000   
            0xFF, 0x80, ##  000000000  
            0xF1, 0xC0, ##  0000   000 
            0xE0, 0xC0, ##  000     00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xE0, 0xC0, ##  000     00 
            0xF1, 0xC0, ##  0000   000 
            0xFF, 0x80, ##  000000000  
            0xCF, 0x00, ##  00  0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000 
            0x3F, 0xC0, ##    00000000
            0x70, 0x40, ##   000     0
            0x60, 0x00, ##   00       
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x70, 0x40, ##   000     0
            0x3F, 0xC0, ##    00000000
            0x0F, 0x80, ##      00000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x1E, 0x60, ##     0000  00
            0x3F, 0xE0, ##    000000000
            0x71, 0xE0, ##   000   0000
            0x60, 0xE0, ##   00     000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x60, 0xE0, ##   00     000
            0x71, 0xE0, ##   000   0000
            0x3F, 0xE0, ##    000000000
            0x1E, 0x60, ##     0000  00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000   
            0x3F, 0xC0, ##    00000000  
            0x70, 0x60, ##   000     00 
            0x60, 0x30, ##   00       00
            0xC0, 0x30, ##  00        00
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0x60, 0x00, ##   00         
            0x70, 0x70, ##   000     000
            0x3F, 0xF0, ##    0000000000
            0x0F, 0xC0, ##      000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x03, 0xC0, ##        0000
            0x07, 0xC0, ##       00000
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x60, ##     0000  00
            0x3F, 0xE0, ##    000000000
            0x71, 0xE0, ##   000   0000
            0x60, 0xE0, ##   00     000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x60, 0xE0, ##   00     000
            0x71, 0xE0, ##   000   0000
            0x3F, 0x60, ##    000000 00
            0x1E, 0x60, ##     0000  00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x60, 0xC0, ##   00     00 
            0x7F, 0x80, ##   00000000  
            0x3F, 0x00, ##    000000   
            0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xCF, 0x00, ##  00  0000  
            0xDF, 0x80, ##  00 000000 
            0xF1, 0xC0, ##  0000   000
            0xE0, 0xC0, ##  000     00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x7C, 0x00, ##   00000     
            0x7C, 0x00, ##   00000     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x00, ##         
            0x00, ##         
            0x7E, ##   000000
            0x7E, ##   000000
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x0E, ##      000
            0xFC, ##  000000 
            0xF8, ##  00000  
            0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC1, 0xC0, ##  00     000 
            0xC3, 0x80, ##  00    000  
            0xC7, 0x00, ##  00   000   
            0xCE, 0x00, ##  00  000    
            0xDC, 0x00, ##  00 000     
            0xF8, 0x00, ##  00000      
            0xFC, 0x00, ##  000000     
            0xEE, 0x00, ##  000 000    
            0xC6, 0x00, ##  00   00    
            0xC7, 0x00, ##  00   000   
            0xC3, 0x80, ##  00    000  
            0xC1, 0x80, ##  00     00  
            0xC1, 0xC0, ##  00     000 
            0xC0, 0xE0, ##  00      000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000     
            0xF8, 0x00, ##  00000     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0x1C, 0x00, ##     000    
            0x0F, 0xC0, ##      000000
            0x07, 0xC0, ##       00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xDC, 0xE0, ##  00 000  000 
            0xFF, 0xE0, ##  00000000000 
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0xC6, 0x30, ##  00   00   00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xCF, 0x00, ##  00  0000  
            0xDF, 0x80, ##  00 000000 
            0xF1, 0xC0, ##  0000   000
            0xE0, 0xC0, ##  000     00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x71, 0xC0, ##   000   000 
            0xE0, 0xC0, ##  000     00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xE0, 0xC0, ##  000     00 
            0x71, 0xC0, ##   000   000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xCF, 0x00, ##  00  0000   
            0xFF, 0x80, ##  000000000  
            0xF1, 0xC0, ##  0000   000 
            0xE0, 0xC0, ##  000     00 
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xE0, 0xC0, ##  000     00 
            0xF1, 0xC0, ##  0000   000 
            0xFF, 0x80, ##  000000000  
            0xCF, 0x00, ##  00  0000   
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x60, ##     0000  00
            0x3F, 0xE0, ##    000000000
            0x71, 0xE0, ##   000   0000
            0x60, 0xE0, ##   00     000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x60, 0xE0, ##   00     000
            0x71, 0xE0, ##   000   0000
            0x3F, 0xE0, ##    000000000
            0x1E, 0x60, ##     0000  00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 10, 
        'xoffset'  => 4, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xCF, 0x80, ##  00  00000 
            0xDF, 0xC0, ##  00 0000000
            0xF0, 0x40, ##  0000     0
            0xE0, 0x00, ##  000       
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0x7F, 0x00, ##   0000000 
            0xE1, 0x00, ##  000    0 
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xE0, 0x00, ##  000      
            0x7E, 0x00, ##   000000  
            0x1F, 0x00, ##     00000 
            0x03, 0x80, ##        000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0xC3, 0x80, ##  00    000
            0xFF, 0x00, ##  00000000 
            0x7E, 0x00, ##   000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0E, 0x00, ##      000    
            0x07, 0xE0, ##       000000
            0x03, 0xE0, ##        00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC1, 0xC0, ##  00     000
            0xE3, 0xC0, ##  000   0000
            0x7E, 0xC0, ##   000000 00
            0x3C, 0xC0, ##    0000  00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x30, ##  000       00
            0x60, 0x30, ##   00       00
            0x60, 0x60, ##   00      00 
            0x70, 0x60, ##   000     00 
            0x30, 0x60, ##    00     00 
            0x30, 0xC0, ##    00    00  
            0x38, 0xC0, ##    000   00  
            0x18, 0xC0, ##     00   00  
            0x19, 0x80, ##     00  00   
            0x19, 0x80, ##     00  00   
            0x0D, 0x80, ##      00 00   
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x07, 0x00, ##       000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0x60, 0x0C, ##   00         00
            0x60, 0x0C, ##   00         00
            0x63, 0x18, ##   00   00   00 
            0x63, 0x98, ##   00   000  00 
            0x63, 0x98, ##   00   000  00 
            0x36, 0x98, ##    00 00 0  00 
            0x36, 0x98, ##    00 00 0  00 
            0x34, 0xF0, ##    00 0  0000  
            0x34, 0xF0, ##    00 0  0000  
            0x1C, 0x70, ##     000   000  
            0x1C, 0x70, ##     000   000  
            0x18, 0x70, ##     00    000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x60, 0x70, ##   00      000 
            0x70, 0x60, ##   000     00  
            0x30, 0xC0, ##    00    00   
            0x19, 0xC0, ##     00  000   
            0x0D, 0x80, ##      00 00    
            0x0F, 0x00, ##      0000     
            0x07, 0x00, ##       000     
            0x0F, 0x00, ##      0000     
            0x0F, 0x80, ##      00000    
            0x19, 0x80, ##     00  00    
            0x38, 0xC0, ##    000   00   
            0x30, 0xE0, ##    00    000  
            0x60, 0x70, ##   00      000 
            0xE0, 0x30, ##  000       00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x30, ##  000       00
            0x60, 0x30, ##   00       00
            0x60, 0x60, ##   00      00 
            0x70, 0x60, ##   000     00 
            0x30, 0xE0, ##    00    000 
            0x30, 0xC0, ##    00    00  
            0x18, 0xC0, ##     00   00  
            0x19, 0xC0, ##     00  000  
            0x19, 0x80, ##     00  00   
            0x0D, 0x80, ##      00 00   
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x07, 0x00, ##       000    
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x0E, 0x00, ##      000     
            0x0C, 0x00, ##      00      
            0x7C, 0x00, ##   00000      
            0x78, 0x00, ##   0000       
            0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x01, 0xC0, ##         000
            0x03, 0x80, ##        000 
            0x03, 0x00, ##        00  
            0x06, 0x00, ##       00   
            0x0E, 0x00, ##      000   
            0x1C, 0x00, ##     000    
            0x18, 0x00, ##     00     
            0x30, 0x00, ##    00      
            0x60, 0x00, ##   00       
            0xE0, 0x00, ##  000       
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000
            0x0F, 0x80, ##      00000
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x38, 0x00, ##    000    
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0x38, 0x00, ##    000    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x1F, 0x80, ##     000000
            0x07, 0x80, ##       0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 6, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000      
            0xF0, 0x00, ##  0000     
            0x38, 0x00, ##    000    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x1C, 0x00, ##     000   
            0x0F, 0x80, ##      00000
            0x0F, 0x80, ##      00000
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x38, 0x00, ##    000    
            0xF8, 0x00, ##  00000    
            0xE0, 0x00, ##  000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x38, 0x00, ##    000       
            0xFE, 0x30, ##  0000000   00
            0xC7, 0xF0, ##  00   0000000
            0x01, 0xC0, ##         000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 8, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xE7, ##  000  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE7, ##  000  000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { },  # K
    '76' => { },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { },  # P
    '81' => { },  # Q
    '82' => { },  # R
    '83' => { },  # S
    '84' => { },  # T
    '85' => { },  # U
    '86' => { },  # V
    '87' => { },  # W
    '88' => { },  # X
    '89' => { },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { },  # v
    '119' => { },  # w
    '120' => { },  # x
    '121' => { },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
