
//./tests/peptidoms/catch2-only-peptidoms [javafit] -s

#include "../common.h"
#include "tests/tests-config.h"
#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_vector.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>
#include <pappsomspp/core/massspectrum/massspectrum.h>
#include <pappsomspp/core/amino_acid/aacode.h>
#include <pappsomspp/core/processing/specpeptidoms/spomsprotein.h>
#include <pappsomspp/core/processing/specpeptidoms/spomsspectrum.h>
#include <pappsomspp/core/processing/specpeptidoms/scorevalues.h>
#include <pappsomspp/core/processing/specpeptidoms/semiglobalalignment.h>
#include <pappsomspp/core/processing/filters/filterresample.h>
#include <pappsomspp/core/processing/filters/filterpass.h>
#include <pappsomspp/core/processing/filters/filterchargedeconvolution.h>

TEST_CASE("test for peptidoms alignment.", "[javafit]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION(
    "..:: BASIC sequence alignment scan_8838 spectrum easy met on fasta file KGIGSGKVLKSGPQ "
    "::..",
    "[peptidoms]")
  {
    pappso::AaCode aa_code;
    aa_code.addAaModification('C', pappso::AaModification::getInstance("MOD:00397"));

    pappso::specpeptidoms::SpOMSProtein protein(
      "protein_id", "TVEQIYQKGIGSGKVLKSGPQVNHFVPEA", aa_code);

    pappso::PrecisionPtr precision_ptr = pappso::PrecisionFactory::getDaltonInstance(0.02);

    pappso::QualifiedMassSpectrum spectrum_simple =
      readQualifiedMassSpectrumMgf(QString(CMAKE_SOURCE_DIR).append("/tests/data/scans/8838.mgf"));
    pappso::FilterChargeDeconvolution(precision_ptr)
      .filter(*(spectrum_simple.getMassSpectrumSPtr().get()));
    pappso::FilterResampleKeepGreater(150).filter(*(spectrum_simple.getMassSpectrumSPtr().get()));
    pappso::FilterGreatestY(60).filter(*(spectrum_simple.getMassSpectrumSPtr().get()));

    pappso::specpeptidoms::SpOMSSpectrum experimental_spectrum(
      spectrum_simple, precision_ptr, aa_code);


    pappso::specpeptidoms::ScoreValues score_values;

    pappso::specpeptidoms::SemiGlobalAlignment semi_global_alignment(
      score_values, precision_ptr, aa_code);

    semi_global_alignment.fastAlign(experimental_spectrum, &protein);
    std::vector<pappso::specpeptidoms::Location> locations =
      semi_global_alignment.getLocationSaver().getLocations();
    REQUIRE(locations.size() == 2);
    REQUIRE(locations.at(0).score == 17);
    // REQUIRE(locations.at(0).beginning == 4);
    // REQUIRE(locations.at(0).length == 30);

    for(auto loc : locations)
      {
        semi_global_alignment.preciseAlign(
          experimental_spectrum, &protein, loc.beginning, loc.length);
        pappso::specpeptidoms::Alignment best_alignment = semi_global_alignment.getBestAlignment();

        REQUIRE(best_alignment.m_peptideModel.toInterpretation().toStdString() == "KGIGSGKVLKSGPQ");
        REQUIRE(best_alignment.SPC == 24);
        /*
        REQUIRE_THAT(best_alignment.peaks,
                     Catch::Matchers::Approx(std::vector<std::size_t>(
                       {0, 4, 12, 21, 27, 37, 47, 55, 66, 69, 76, 82, 94, 103, 106})));
        REQUIRE_THAT(best_alignment.shifts,
                     Catch::Matchers::Approx(std::vector<double>({})).margin(0.001));
        REQUIRE(best_alignment.score == 131);
        REQUIRE(best_alignment.beginning == 7);
        REQUIRE(best_alignment.end == 20);
        REQUIRE(best_alignment.begin_shift == 0.0);
        REQUIRE(best_alignment.end_shift == 0);
        REQUIRE((best_alignment.begin_shift > 0 || best_alignment.end_shift > 0 ||
                 best_alignment.shifts.size() > 0) == false);

        REQUIRE(best_alignment.getNonAlignedMass() == Catch::Approx(0));
        REQUIRE_THAT(best_alignment.m_peptideModel.getNonAlignedMass(),
                     Catch::Matchers::WithinAbs(0, 0.02));
                     */
      }
  }
}
