# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AdoptionPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action if the Namespace with the same name already exists."""

    NEVER = "Never"
    """If the Namespace already exists, do not take over the existing Namespace to be managed by ARM."""
    IF_IDENTICAL = "IfIdentical"
    """If there is an identical Namespace, take over the existing Namespace to be managed by ARM."""
    ALWAYS = "Always"
    """Always take over the existing Namespace to be managed by ARM, even if it is not identical."""


class AutoUpgradeLastTriggerStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AutoUpgradeLastTriggerStatus is the status of the last AutoUpgrade trigger (attempt to
    automatically create and start UpdateRun when there are new released versions) of an auto
    upgrade profile.
    """

    SUCCEEDED = "Succeeded"
    """The last AutoUpgrade trigger was succeeded."""
    FAILED = "Failed"
    """The last AutoUpgrade trigger failed."""


class AutoUpgradeNodeImageSelectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The node image upgrade type."""

    LATEST = "Latest"
    """Use the latest image version when upgrading nodes. Clusters may use different image versions
    (e.g., 'AKSUbuntu-1804gen2containerd-2021.10.12' and 'AKSUbuntu-1804gen2containerd-2021.10.19')
    because, for example, the latest available version is different in different regions."""
    CONSISTENT = "Consistent"
    """The image versions to upgrade nodes to are selected as described below: for each node pool in
    managed clusters affected by the update run, the system selects the latest image version such
    that it is available across all other node pools (in all other clusters) of the same image
    type. As a result, all node pools of the same image type will be upgraded to the same image
    version. For example, if the latest image version for image type 'AKSUbuntu-1804gen2containerd'
    is 'AKSUbuntu-1804gen2containerd-2021.10.12' for a node pool in cluster A in region X, and is
    'AKSUbuntu-1804gen2containerd-2021.10.17' for a node pool in cluster B in region Y, the system
    will upgrade both node pools to image version 'AKSUbuntu-1804gen2containerd-2021.10.12'."""


class AutoUpgradeProfileProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the AutoUpgradeProfile resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DeletePolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Delete options for the ARM managed namespace."""

    KEEP = "Keep"
    """Delete the ARM resource but keep the Namespace."""
    DELETE = "Delete"
    """Delete both ARM resource and Namespace."""


class FleetManagedNamespaceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the fleet managed namespace resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    """The provisioning state of a fleet managed namespace being created."""
    UPDATING = "Updating"
    """The provisioning state of a fleet managed namespace being updated."""
    DELETING = "Deleting"
    """The provisioning state of a fleet managed namespace being deleted."""


class FleetMemberProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the last accepted operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    JOINING = "Joining"
    """The provisioning state of a member joining a fleet."""
    LEAVING = "Leaving"
    """The provisioning state of a member leaving a fleet."""
    UPDATING = "Updating"
    """The provisioning state of a member being updated."""


class FleetProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the last accepted operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    """The provisioning state of a fleet being created."""
    UPDATING = "Updating"
    """The provisioning state of a fleet being updated."""
    DELETING = "Deleting"
    """The provisioning state of a fleet being deleted."""


class FleetUpdateStrategyProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the UpdateStrategy resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class GateProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the Gate resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class GateState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the Gate."""

    PENDING = "Pending"
    """A Pending Gate will continue to block the staged rollout process it is controlling."""
    SKIPPED = "Skipped"
    """A Skipped Gate means that the staged rollout process it is controlling was skipped."""
    COMPLETED = "Completed"
    """An Completed Gate allows the staged rollout process to continue."""


class GateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the Gate determines how it is completed."""

    APPROVAL = "Approval"
    """An approval gate is completed by setting its state to be Completed."""


class LabelSelectorOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A label selector operator is the set of operators that can be used in a selector requirement."""

    IN = "In"
    """Label Selector Operator In"""
    NOT_IN = "NotIn"
    """Label Selector Operator NotIn"""
    EXISTS = "Exists"
    """Label Selector Operator Exists"""
    DOES_NOT_EXIST = "DoesNotExist"
    """Label Selector Operator DoesNotExist"""


class ManagedClusterUpgradeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of upgrade to perform when targeting ManagedClusters."""

    FULL = "Full"
    """Full upgrades the control plane and all agent pools of the target ManagedClusters. Requires the
    ManagedClusterUpgradeSpec.KubernetesVersion property to be set."""
    NODE_IMAGE_ONLY = "NodeImageOnly"
    """NodeImageOnly upgrades only the node images of the target ManagedClusters. Requires the
    ManagedClusterUpgradeSpec.KubernetesVersion property to NOT be set."""
    CONTROL_PLANE_ONLY = "ControlPlaneOnly"
    """ControlPlaneOnly upgrades only targets the KubernetesVersion of the ManagedClusters and will
    not be applied to the AgentPool. Requires the ManagedClusterUpgradeSpec.KubernetesVersion
    property to be set."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    """System and user assigned managed identity."""


class NodeImageSelectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The node image upgrade type."""

    LATEST = "Latest"
    """Use the latest image version when upgrading nodes. Clusters may use different image versions
    (e.g., 'AKSUbuntu-1804gen2containerd-2021.10.12' and 'AKSUbuntu-1804gen2containerd-2021.10.19')
    because, for example, the latest available version is different in different regions."""
    CONSISTENT = "Consistent"
    """The image versions to upgrade nodes to are selected as described below: for each node pool in
    managed clusters affected by the update run, the system selects the latest image version such
    that it is available across all other node pools (in all other clusters) of the same image
    type. As a result, all node pools of the same image type will be upgraded to the same image
    version. For example, if the latest image version for image type 'AKSUbuntu-1804gen2containerd'
    is 'AKSUbuntu-1804gen2containerd-2021.10.12' for a node pool in cluster A in region X, and is
    'AKSUbuntu-1804gen2containerd-2021.10.17' for a node pool in cluster B in region Y, the system
    will upgrade both node pools to image version 'AKSUbuntu-1804gen2containerd-2021.10.12'."""
    CUSTOM = "Custom"
    """Upgrade the nodes to the custom image versions. When set, update run will use node image
    versions provided in customNodeImageVersions to upgrade the nodes. If set,
    customNodeImageVersions must not be empty."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PlacementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PlacementType identifies the type of placement."""

    PICK_ALL = "PickAll"
    """PickAll picks all clusters that satisfy the rules."""
    PICK_FIXED = "PickFixed"
    """PickFixed picks a fixed set of clusters."""


class PolicyRule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The possible values representing different network policy rules."""

    ALLOW_ALL = "AllowAll"
    """Allow all network traffic."""
    DENY_ALL = "DenyAll"
    """Deny all network traffic."""
    ALLOW_SAME_NAMESPACE = "AllowSameNamespace"
    """Allow traffic within the same namespace."""


class PropagationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """How the namespace will be provisioned among the fleet members."""

    PLACEMENT = "Placement"
    """Using ClusterResourcePlacement."""


class PropertySelectorOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PropertySelectorOperator is the operator that can be used with PropertySelectorRequirements."""

    GT = "Gt"
    """Gt dictates Fleet to select cluster if its observed value of a given property is greater than
    the value specified in the requirement."""
    GE = "Ge"
    """Ge dictates Fleet to select cluster if its observed value of a given property is greater than
    or equal to the value specified in the requirement."""
    EQ = "Eq"
    """Eq dictates Fleet to select cluster if its observed value of a given property is equal to the
    values specified in the requirement."""
    NE = "Ne"
    """Ne dictates Fleet to select cluster if its observed value of a given property is not equal to
    the values specified in the requirement."""
    LT = "Lt"
    """Lt dictates Fleet to select cluster if its observed value of a given property is less than the
    value specified in the requirement."""
    LE = "Le"
    """Le dictates Fleet to select cluster if its observed value of a given property is less than or
    equal to the value specified in the requirement."""


class TaintEffect(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TaintEffect."""

    NO_SCHEDULE = "NoSchedule"
    """Do not allow new pods to schedule onto the node unless they tolerate the taint, but allow all
    pods submitted to Kubelet without going through the scheduler to start, and allow all
    already-running pods to continue running. Enforced by the scheduler."""


class TargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The target type of a skip request."""

    MEMBER = "Member"
    """Skip the update of a member."""
    GROUP = "Group"
    """Skip the update of a group."""
    STAGE = "Stage"
    """Skip the update of an entire stage including the after stage wait."""
    AFTER_STAGE_WAIT = "AfterStageWait"
    """Skip the update of the after stage wait of a certain stage."""


class Timing(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the Gate is placed before or after the target."""

    BEFORE = "Before"
    """The Gate is before the target."""
    AFTER = "After"
    """The Gate is after the target."""


class TolerationOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A toleration operator is the set of operators that can be used in a toleration."""

    EXISTS = "Exists"
    """Toleration Operator Exists"""
    EQUAL = "Equal"
    """Toleration Operator Equal"""


class UpdateRunProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the UpdateRun resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class UpdateState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the UpdateRun, UpdateStage, UpdateGroup, or MemberUpdate."""

    NOT_STARTED = "NotStarted"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has not been started."""
    RUNNING = "Running"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that is running."""
    STOPPING = "Stopping"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that is being stopped."""
    STOPPED = "Stopped"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has stopped."""
    SKIPPED = "Skipped"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has been skipped."""
    FAILED = "Failed"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has failed."""
    PENDING = "Pending"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that is pending."""
    COMPLETED = "Completed"
    """The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has completed."""


class UpgradeChannel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configuration of how auto upgrade will be run."""

    STABLE = "Stable"
    """ Upgrades the clusters kubernetes version to the latest supported patch release on minor
    version N-1, where N is the latest supported minor version.
     For example, if a cluster runs version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1
    are available, the cluster upgrades to 1.18.6."""
    RAPID = "Rapid"
    """Upgrades the clusters kubernetes version to the latest supported patch release on the latest
    supported minor version."""
    NODE_IMAGE = "NodeImage"
    """Upgrade node image version of the clusters."""
    TARGET_KUBERNETES_VERSION = "TargetKubernetesVersion"
    """  Upgrades the clusters Kubernetes version to the latest supported patch version of the
    specified target Kubernetes version.
      For information on the behavior of update run for Kubernetes version upgrade,
      see
    `https://learn.microsoft.com/en-us/azure/kubernetes-fleet/update-orchestration?tabs=azure-portal
    <https://learn.microsoft.com/en-us/azure/kubernetes-fleet/update-orchestration?tabs=azure-portal>`_"""
