% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-and-date-time-boundary}
\alias{date-and-date-time-boundary}
\alias{date_start}
\alias{date_end}
\title{Boundaries: date and date-time}
\usage{
date_start(x, precision, ...)

date_end(x, precision, ...)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time vector.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the input used.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} but with some components altered to be at the boundary value.
}
\description{
\itemize{
\item \code{date_start()} computes the date at the start of a particular
\code{precision}, such as the "start of the year".
\item \code{date_end()} computes the date at the end of a particular
\code{precision}, such as the "end of the month".
}

There are separate help pages for computing boundaries for dates and
date-times:
\itemize{
\item \link[=date-boundary]{dates (Date)}
\item \link[=posixt-boundary]{date-times (POSIXct/POSIXlt)}
}
}
\examples{
# See type specific documentation for more examples

x <- date_build(2019, 2:4)

date_end(x, "month")

x <- date_time_build(2019, 2:4, 3:5, 4, 5, zone = "America/New_York")

# Note that the hour, minute, and second components are also adjusted
date_end(x, "month")
}
