/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct StepInstruction {
    #[serde(rename = "relativeDirection")]
    pub relative_direction: models::Direction,
    /// The distance in meters that this step takes.
    #[serde(rename = "distance")]
    pub distance: f64,
    /// level where this segment starts, based on OpenStreetMap data
    #[serde(rename = "fromLevel")]
    pub from_level: f64,
    /// level where this segment starts, based on OpenStreetMap data
    #[serde(rename = "toLevel")]
    pub to_level: f64,
    /// OpenStreetMap way index
    #[serde(rename = "osmWay", skip_serializing_if = "Option::is_none")]
    pub osm_way: Option<i32>,
    #[serde(rename = "polyline")]
    pub polyline: Box<models::EncodedPolyline>,
    /// The name of the street.
    #[serde(rename = "streetName")]
    pub street_name: String,
    /// Not implemented! When exiting a highway or traffic circle, the exit name/number. 
    #[serde(rename = "exit")]
    pub exit: String,
    /// Not implemented! Indicates whether or not a street changes direction at an intersection. 
    #[serde(rename = "stayOn")]
    pub stay_on: bool,
    /// Not implemented! This step is on an open area, such as a plaza or train platform, and thus the directions should say something like \"cross\" 
    #[serde(rename = "area")]
    pub area: bool,
    /// Indicates that a fee must be paid by general traffic to use a road, road bridge or road tunnel.
    #[serde(rename = "toll", skip_serializing_if = "Option::is_none")]
    pub toll: Option<bool>,
    /// Experimental. Indicates whether access to this part of the route is restricted. See: https://wiki.openstreetmap.org/wiki/Conditional_restrictions 
    #[serde(rename = "accessRestriction", skip_serializing_if = "Option::is_none")]
    pub access_restriction: Option<String>,
    /// incline in meters across this path segment
    #[serde(rename = "elevationUp", skip_serializing_if = "Option::is_none")]
    pub elevation_up: Option<i32>,
    /// decline in meters across this path segment
    #[serde(rename = "elevationDown", skip_serializing_if = "Option::is_none")]
    pub elevation_down: Option<i32>,
}

impl StepInstruction {
    pub fn new(relative_direction: models::Direction, distance: f64, from_level: f64, to_level: f64, polyline: models::EncodedPolyline, street_name: String, exit: String, stay_on: bool, area: bool) -> StepInstruction {
        StepInstruction {
            relative_direction,
            distance,
            from_level,
            to_level,
            osm_way: None,
            polyline: Box::new(polyline),
            street_name,
            exit,
            stay_on,
            area,
            toll: None,
            access_restriction: None,
            elevation_up: None,
            elevation_down: None,
        }
    }
}

