/*
 * Copyright 2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.spockframework.groovy

import spock.lang.Specification

/**
 *
 * @author Peter Niederwieser
 */
class DGMMatcherIterator extends Specification {
  def "can cope with multiple hasNext calls"() {
    def matcher = "a1a2a3" =~ /a./
    def iter = matcher.iterator()

    when:
    iter.hasNext()
    iter.hasNext()
    iter.hasNext()
    iter.hasNext()
    iter.hasNext()
    iter.next()
    
    then:
    notThrown(Exception)
  }
}