/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.io.Serializable;
import uk.me.nxg.unity.Dimensions;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitRepresentation;

public class UnitDefinition
implements Serializable,
Comparable<UnitDefinition> {
    private final String uri;
    private final String name;
    private final String label;
    private final String type;
    private final Dimensions dimensions;
    private final String description;
    private final String latexForm;
    private static final long serialVersionUID = 42L;

    UnitDefinition(String string, String string2, String string3, String string4, Dimensions dimensions, String string5, String string6) {
        if (string == null || string2 == null || string4 == null) {
            throw new IllegalArgumentException("UnitDefinition must have a non-null uri, name and type");
        }
        this.uri = string;
        this.name = string2;
        this.label = string3;
        this.type = string4;
        this.dimensions = dimensions;
        this.description = string5 == null || string5.length() == 0 ? null : string5;
        String string7 = this.latexForm = string6 == null || string6.length() == 0 ? null : string6;
        assert (!(this.uri == null || this.name == null || this.type == null || this.description != null && this.description.length() <= 0 || this.latexForm != null && this.latexForm.length() <= 0));
    }

    UnitDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws UnitParserException {
        this(string, string2, string3, string4, Dimensions.parse(string5), string6, string7);
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String latexForm() {
        return this.latexForm;
    }

    public Dimensions dimensions() {
        return this.dimensions;
    }

    public String getURI() {
        return this.uri;
    }

    public UnitRepresentation getRepresentation(Syntax syntax) {
        if (syntax == null) {
            throw new IllegalArgumentException("Must specify a syntax for getRepresentation");
        }
        UnitDefinitionMap.Resolver resolver = UnitDefinitionMap.getInstance().getResolver(syntax);
        if (resolver == null) {
            return null;
        }
        return resolver.lookupUnit(this);
    }

    public UnitRepresentation getRepresentation() {
        for (Syntax syntax : Syntax.values()) {
            UnitRepresentation unitRepresentation = this.getRepresentation(syntax);
            if (unitRepresentation == null) continue;
            return unitRepresentation;
        }
        assert (false);
        return null;
    }

    @Override
    public int compareTo(UnitDefinition unitDefinition) {
        assert (this.uri != null);
        assert (unitDefinition.uri != null);
        return this.uri.compareTo(unitDefinition.uri);
    }

    public boolean equals(Object object) {
        if (object instanceof UnitDefinition) {
            return this.compareTo((UnitDefinition)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name + "(" + this.type + ")";
    }
}

