/*
 *    globals.c - tcl-syslog extension's global data
 *
 *    A Tcl interface to the POSIX syslog service.
 *
 *    Copyright (C) 2026 Massimo Manghi <mxmanghi@apache.org>
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "syslog.h"
#include "params.h"

SyslogGlobalStatus *g_status = NULL;
char* g_default_format = "%s";

/*
 * parse_open_options
 *
 */

const char* options[num_syslog_options+1] = {
#define SYSLOG_OPTION_CLI(option,optcode,option_idx,opt_class) [option_idx] = option,
    SYSLOG_OPTIONS(SYSLOG_OPTION_CLI) 
    /* Sentinel */
    (char *) NULL
};

int opt_code[num_syslog_options+1] = {
#define SYSLOG_OPTION_CODE(option,optcode,option_idx,opt_class) [option_idx] = optcode,
    SYSLOG_OPTIONS(SYSLOG_OPTION_CODE)
    /* Sentinel */
    [num_syslog_options] = -1  
};

int opt_class[num_syslog_options+1] = {
#define SYSLOG_OPTION_CLASS(option,optcode,option_idx,opt_class) [option_idx] = opt_class,
    SYSLOG_OPTIONS(SYSLOG_OPTION_CLASS)
    /* Sentinel */
    [num_syslog_options] = 0
};
