/* CSL - Common Sound Layer
 * Copyright (C) 2001 Jeff Tranter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* 
 * This illustrates using some of the debug and utility functions.
 * The lines of code commented out will cause the program to exit.
 */

#include <stdio.h>
#include <csl/csl.h>

int main()
{
	if (CSL_BYTE_ORDER == CSL_BIG_ENDIAN)
		printf("Machine is big endian\n");
	else if (CSL_BYTE_ORDER == CSL_LITTLE_ENDIAN)
		printf("Machine is little endian\n");
	else
		printf("Machine has unknown endian convention\n");

	csl_message("This is a message.");
	csl_warning("This is a warning.");
	/*csl_error("This is an error.");*/

	csl_assert(TRUE);
	/*csl_assert(FALSE);*/
	/*csl_return_if_fail(TRUE);*/
	csl_return_val_if_fail(TRUE, 1);

	csl_set_debug_mask(CSL_DEBUG_PCM|CSL_DEBUG_MISC);

	printf("MAX(1,2) is %d\n", MAX(1,2));
	printf("MIN(1,2) is %d\n", MIN(1,2));
	printf("CLAMP(1,2,3) is %d\n", CLAMP(1,2,3));

	/*CSL_BREAKPOINT();*/

	return 0;
}
