/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_check_report.h
 * @brief implementation of the check_report function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_CHECK_REPORT_H
#define PG_CHECK_REPORT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Check that a particular report is scheduled under the
 * given @a report_id and @a report_token. Does not
 * validate that the report is actually due.
 *
 * @param cls closure
 * @param report_id serial number of the report to lookup
 * @param report_token report token to check
 * @param mime_type mime type to request from the @a data_source
 * @param[out] instance_id instance to lookup reports for
 * @param[out] data_source relative URL (to instance base URL)
 *   to request report data from
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_check_report (void *cls,
                     uint64_t report_id,
                     const struct TALER_MERCHANT_ReportToken *report_token,
                     const char *mime_type,
                     char **instance_id,
                     char **data_source);

#endif
