/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.synchro.CalendarDetailReader;
import net.sf.mpxj.synchro.DayTypeAssignmentReader;
import net.sf.mpxj.synchro.DayTypeReader;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.TableReader;

class CalendarReader
extends TableReader {
    private UUID m_defaultCalendarUUID;

    public CalendarReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("NAME", stream.readString());
        map.put("UNKNOWN1", stream.readTable(CalendarDetailReader.class));
        map.put("UNKNOWN2", stream.readBytes(4));
        map.put("SUNDAY_DAY_TYPE", stream.readUUID());
        map.put("MONDAY_DAY_TYPE", stream.readUUID());
        map.put("TUESDAY_DAY_TYPE", stream.readUUID());
        map.put("WEDNESDAY_DAY_TYPE", stream.readUUID());
        map.put("THURSDAY_DAY_TYPE", stream.readUUID());
        map.put("FRIDAY_DAY_TYPE", stream.readUUID());
        map.put("SATURDAY_DAY_TYPE", stream.readUUID());
        map.put("UNKNOWN3", stream.readBytes(4));
        map.put("DAY_TYPE_ASSIGNMENTS", stream.readTable(DayTypeAssignmentReader.class));
        map.put("DAY_TYPES", stream.readTable(DayTypeReader.class));
        map.put("UNKNOWN4", stream.readBytes(8));
    }

    @Override
    protected void postTrailer(StreamReader stream) throws IOException {
        this.m_defaultCalendarUUID = stream.readUUID();
    }

    @Override
    protected int rowMagicNumber() {
        return 2146182685;
    }

    public UUID getDefaultCalendarUUID() {
        return this.m_defaultCalendarUUID;
    }
}

