#ifndef __diamon_h__
#define __diamon_h__
#include <qstring.h>
#include <qtooltip.h>
#include <qwidget.h>
#include <qlistbox.h>
#include <kpanelapplet.h>
#include <kconfig.h>
#include <kprocess.h>
#include "prefdialog.h"

#define LOAD_ARRAY_SIZE 480
#define H_STRING "horizontal"
#define V_STRING "vertical"
#define VERSION "0.1 ISDN"

/* change MAX_SIZE if you want a larger DiaMon */
#define MAX_SIZE 400
#define MIN_SIZE 12
#define ISDN_MAX 16

typedef struct
{
	unsigned long in[LOAD_ARRAY_SIZE];
	unsigned long out[LOAD_ARRAY_SIZE];
	QColor inColor;
	QColor outColor;
	char name[24];
	char provider[MAX_LEN+5];
	unsigned long totalIn;
	unsigned long totalOut;
	bool ok;
}deviceLoad;

class DiaMon : public KPanelApplet
{
	Q_OBJECT

	public:
		DiaMon(const QString& configFile, Type t = Normal, int actions = 0, QWidget *parent = 0, const char *name = 0);
		~DiaMon();
		int widthForHeight(int h) const;
		int heightForWidth(int w) const;

	protected:
		void orientationChange(Orientation);
		void paintEvent( QPaintEvent* );
		void resizeEvent( QResizeEvent* );
		void mousePressEvent(QMouseEvent*);
		void mouseMoveEvent(QMouseEvent*);
		void mouseReleaseEvent(QMouseEvent*);

	protected slots:


	private slots:
		void about();
		void help();
		void preferences();
		void slotPrefOk(bool);
		void toggleConnection(int);
		void procExited(KProcess*);
		void lookupIfOnline(void);
		void lookupLoad(void);

	private:
		/* reads from /dev/isdninfo and fills the usage, flags (and phone) arrays
		*  -> ISDN only ! <-  */
		int IsdnInfo(void);

		/* get load from /proc/net/dev, if init is true, only totalIn and
		*  totalOut are filled for initialisiation  */
		int getLoad(bool init=0);

		/* load config  */
		void getDMConfig(void);

		/* load config, loadList will not be cleared & renewed */
		bool updateDMConfig(void);

		/* number of items in the popup-menu that are NO providers */
		int numMenuItems;

		/* number of items in the popup-menu that are providers */
		int numProviders;

		/* calls the lookupLoad() slot */
		QTimer *lookupTimer;

		/* 0 for offline, 1 for dialing, 2 for online */
		int onlineStatus;

		/* 100% isdn load in bytes */
		unsigned long loadScale;

		/* stores isdn load as deviceLoad */
		QList<deviceLoad> loadList;

		/* index of current load in the arrays of deviceLoad */
		int currentLoad;

		/* converts a huge amount of bytes to a human-readable string */
		QString bytesToStr(unsigned long bytes,int len=0);

		/* /dev/isdninfo */
		int fp;

		bool resizeMode,vertical;
		int dsize,height,width,size;

        QPopupMenu *menu;

		prefDialog *pref;

		KProcess *proc;

#ifdef ERROR_BOX
		QListBox *ErrBox;
#endif

		/* timeout for lookupTimer in msec */
		int timersTimeoutTime;

		/* store data from /dev/isdninfo */
		int usage[ISDN_MAX];
		int flags[ISDN_MAX];
#ifdef USE_PHONE
		char phone[ISDN_MAX][20];
#endif

		QColor offC,onC,dialC;

		/* for the online-counter */
		QDateTime startTime;
		QDateTime endTime;
};

#endif
