//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include "frame.h"

//#include <kmsgbox.h>
#include <kmessagebox.h>
#include <qmlined.h>
#include <qprogdlg.h>
#include <kapp.h>
#include <qprogdlg.h>
#include <qstring.h>

#include "kinputline.h"
#include "ktextbox.h"
#include "ktable.h"
#include "widgets.h"

#include <stream.h>
#include <qfile.h>
#include <qtstream.h>

#include "klocale.h"

#include <stdlib.h>
#include <stdio.h>

KDialogFrame::KDialogFrame(QDataStream *ret) 
  : KMainWindow() 
{
  retStream = ret;

  persistantWidget = 0;
  xxx = false;

  backtitle = new QLabel(this);
  backtitle->setGeometry(0,0,width(),height());
  backtitle->setAlignment(AlignHCenter | AlignTop | WordBreak);
  backtitle->setFrameStyle(QFrame::Box | QFrame::Plain);
}


void KDialogFrame::resizeEvent(QResizeEvent *) {
  backtitle->setGeometry(0,0,width(),height());
}


void KDialogFrame::sendReturn(int type, int code, QString message) 
{
  *retStream << type;

  switch (type) {
    case 0: *retStream << code;
            break;
    case 1: *retStream << message;
            break;
    case 2: break;
  }

  retStream->device()->flush();
}


void KDialogFrame::processArgs(QStrList args) {

  int index, count=args.count();
  char *arg;

  separateOutput = FALSE;

  for (index=0; index < count; index++) {

    arg = args.at(index);

    // --title text
    if ((strcmp(arg,"--title") == 0) && (index+1<=count)) {
      title = args.at(index+1);
      index++;
      continue;
    }

    // --caption text
    if ((strcmp(arg,"--caption") == 0) && (index+1<count)) {
      setCaption(args.at(index+1));
      index++;
      continue;
    }

    // --backtitle text
    if ((strcmp(arg,"--backtitle") == 0) && (index+1<count)) {
      backtitle->setText(args.at(index+1));
      index++;
      continue;
    }

    // --separate-output
    if ((strcmp(arg,"--separate-output") == 0)) {
      separateOutput = TRUE;
      continue;
    }

    // --clear
    if ((strcmp(arg,"--clear") == 0)) {
      if (persistantWidget) {
        delete persistantWidget;      
        persistantWidget = 0;
      }
      continue;
    }

    // --create-rc
    if ((strcmp(arg,"--create-rc") == 0)) {
      continue;
    }

    // --yesno text width height
    if ((strcmp(arg,"--yesno") == 0) && (index+3<count)) {
      yesno(args.at(index+1),args.at(index+2),args.at(index+3));
      return;
    }

    // --msgbox text width height
    if ((strcmp(arg,"--msgbox") == 0) && (index+3<count)) {
      msgbox(args.at(index+1),args.at(index+2),args.at(index+3));
      return;
    }

    // --infobox text width height
    if ((strcmp(arg,"--infobox") == 0) && (index+3<count)) {
      infobox(args.at(index+1),args.at(index+2),args.at(index+3));
      return;
    }

    // --infobox text width height init
    if ((strcmp(arg,"--inputbox") == 0) && (index+4<count)) {
      inputbox(args.at(index+1),args.at(index+2),args.at(index+3),args.at(index+4));
      return;
    }

    // --inputbox text width height
    if ((strcmp(arg,"--inputbox") == 0) && (index+3<count)) {
      inputbox(args.at(index+1),args.at(index+2),args.at(index+3),"");
      return;
    }

    // --textbox file width height
    if ((strcmp(arg,"--textbox") == 0) && (index+3<count)) {
      textbox(args.at(index+1),args.at(index+2),args.at(index+3));
      return;
    }

    // --menu text width height menuheight [tag item]
    if ((strcmp(arg,"--menu") == 0) && (index+6<count)) {
      menu(args.at(index+1),args.at(index+2),args.at(index+3),
           args.at(index+4),args,index+5);
      return;
    }

    // --checklist text width height menuheight [tag item status]
    if ((strcmp(arg,"--checklist") == 0) && (index+7<count)) {
      checklist(args.at(index+1),args.at(index+2),args.at(index+3),
           args.at(index+4),args,index+5);
      return;
    }

    // --radiolist text width height menuheight [tag item status]
    if ((strcmp(arg,"--radiolist") == 0) && (index+7<count)) {
      radiobox(args.at(index+1),args.at(index+2),args.at(index+3),
           args.at(index+4),args,index+5);
      return;
    }

    // --gauge text width height percent
    if ((strcmp(arg,"--gauge") == 0) && (index+4<count)) {
      gauge(args.at(index+1),args.at(index+2),args.at(index+3),args.at(index+4));
      return;
    }

    // --kexit
    if (strcmp(arg,"--kexit") == 0) {
      sendReturn(0,0,0);
      exit(0);
      return;
    }

  }

  // pipe result
  sendReturn(0,0,0);
}


void KDialogFrame::yesno(QString text, QString /*width*/, QString /*height*/) 
{
  if (KMessageBox::questionYesNo(0, text, title) == KMessageBox::Yes)
    sendReturn(0,0,0);
  else
    sendReturn(0,-1,0);
}


void KDialogFrame::msgbox(QString text, QString /*width*/, QString /*height*/) 
{
  KMessageBox::information(0, text, title); //, 0, kapp->i18n("Ok"));
  sendReturn(0,0,0);
}


void KDialogFrame::infobox(QString text, QString /*width*/, QString /*height*/) 
{
  if (persistantWidget)
    delete persistantWidget;

  persistantWidget = infoBox(title, text);

  sendReturn(0,0,0);
}


void KDialogFrame::inputbox(QString text, QString width, QString /*height*/, QString init) 
{
  QString result;
  int w = convert(width, 40);

  if (inputBox(this, w, title, text, init, result) == QDialog::Accepted) 
  {
    sendReturn(1,0,result);
    sendReturn(0,0,0);
  }
  else
  {
    sendReturn(1,0,result);
    sendReturn(0,-1,0);
  }
}


void KDialogFrame::textbox(QString file, QString width, QString height) 
{
  int w = convert(width, 40);
  int h = convert(height, 15);

  textBox(this, w, h, title, file);
  sendReturn(0,0,0);
}


void KDialogFrame::menu(QString text, QString width, QString /*height*/, QString menuheight, QStrList args, int index)
{
  QString result;
  int w = convert(width, 40);
  int mh = convert(menuheight, 10);

  if (menuBox(this, w, mh, title, text, args, index, result) == QDialog::Accepted)
  {
    sendReturn(1,0,result);
    sendReturn(0,0,0);
  }
  else
  {
    sendReturn(1,0,result);
    sendReturn(0,-1,0);
  }
}


void KDialogFrame::checklist(QString text, QString width, QString /* height */, QString menuheight, QStrList args, int index)
{
  QStrList result;
  unsigned int i;
  int w = convert(width, 40);
  int mh = convert(menuheight, 10);

  if (checkList(this, w, mh, title, text, args, index, separateOutput, result) == QDialog::Accepted)
  {
    for (i=0; i<result.count(); i++)
      sendReturn(1,0,result.at(i));	    
    sendReturn(0,0,0);
  }
  else
  {
    for (i=0; i<result.count(); i++)
      sendReturn(1,0,result.at(i));	    
    sendReturn(0,-1,0);
  }
}


void KDialogFrame::radiobox(QString text, QString width, QString /* height */, QString menuheight, QStrList args, int index)
{
  QString result;
  int w = convert(width, 40);
  int mh = convert(menuheight, 10);

  if (radioBox(this, w, mh, title, text, args, index, result) == QDialog::Accepted)
  {
    sendReturn(1,0,result);	    
    sendReturn(0,0,0);
  }
  else
  {
    sendReturn(1,0,result);	    
    sendReturn(0,-1,0);
  }
}


void KDialogFrame::gauge(QString text, QString /*width*/, QString /*height*/, QString percent)
{
  QProgressDialog *pd;

  if (persistantWidget)
    delete persistantWidget;

  pd = new QProgressDialog(text, 0, 100, this, 0, true);
  pd->setProgress(0);
  pd->setProgress(atoi(percent));
  pd->setCaption(title);
  gaugeText=text;

  pd->show();  
  persistantWidget = pd;

  sendReturn(2,0,0);
}


void KDialogFrame::processGauge(QStrList args)
{
  QProgressDialog *dlg;
  int progress;
 
  if (!(persistantWidget && persistantWidget->isA("QProgressDialog"))) {
    cerr << i18n("No gauge present!") << endl;
    return;
  }

  dlg = (QProgressDialog *)persistantWidget;

  if (strcmp(args.at(1), "XXX") == 0) {
    if (xxx) {
      xxx = false;
      dlg->setLabelText(gaugeText);
      gaugeText = "";
    } else {
      xxx = true;
      gaugeText = "";
    }
  } else {
    if (xxx) {
      gaugeText += args.at(1);
    } else {
      progress=atoi(args.at(1));
      dlg->setProgress(progress);
    }
  }
}
